DROP TABLE nc_machine CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_machine 
--

CREATE TABLE nc_machine(
    uniqueID        NUMBER(38, 0)    NOT NULL,
    tableID         NUMBER(38, 0)    NOT NULL,
    owner           NUMBER(38, 0)    NOT NULL,
    modTime         DATE             NOT NULL,
    modUser         NUMBER(38, 0)    NOT NULL,
    architecture    VARCHAR2(128)    NOT NULL,
    OS              VARCHAR2(128)    NOT NULL,
    OSversion       VARCHAR2(64)     NOT NULL,
    description     CLOB,
    address         VARCHAR2(64)     NOT NULL,
    CONSTRAINT nc_machine_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_machine_pidx on nc_machine(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_machine_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_machine_sidx on nc_machine(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_machine.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_machine.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_machine.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_machine.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_machine.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_machine.architecture IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_machine.OS IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_machine.OSversion IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_machine.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_machine.address IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
