DROP TABLE nc_researchGroup CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_researchGroup 
--

CREATE TABLE nc_researchGroup(
    uniqueID                         NUMBER(38, 0)    NOT NULL,
    tableID                          NUMBER(38, 0)    NOT NULL,
    owner                            NUMBER(38, 0)    NOT NULL,
    modTime                          DATE             NOT NULL,
    modUser                          NUMBER(38, 0)    NOT NULL,
    name                             VARCHAR2(128),
    description                      CLOB,
    nc_researchGroupType_uniqueID    NUMBER(38, 0)    NOT NULL,
    nc_experiment_uniqueID           NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_researchGroup_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_researchGroup_pidx on nc_researchGroup(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_researchGroup_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_researchGroup_sidx on nc_researchGroup(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_researchGroup.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_researchGroup.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_researchGroup.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_researchGroup.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_researchGroup.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_researchGroup.name IS 'The name of the research group.'
;
COMMENT ON COLUMN nc_researchGroup.description IS 'Description of research group.'
;
COMMENT ON COLUMN nc_researchGroup.nc_researchGroupType_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_researchGroup.nc_experiment_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
