DROP TABLE nc_scoreValidation CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_scoreValidation 
--

CREATE TABLE nc_scoreValidation(
    dataTable       NUMBER(38, 0)    NOT NULL,
    dataID          NUMBER(38, 0)    NOT NULL,
    uniqueID        NUMBER(38, 0)    NOT NULL,
    tableID         NUMBER(38, 0)    NOT NULL,
    owner           NUMBER(38, 0)    NOT NULL,
    modTime         DATE             NOT NULL,
    modUser         NUMBER(38, 0)    NOT NULL,
    timestamp       TIMESTAMP(6)     NOT NULL,
    comments        CLOB,
    validatorID     NUMBER(38, 0)    NOT NULL,
    assessmentID    NUMBER(38, 0)    NOT NULL,
    method          VARCHAR2(128)    NOT NULL,
    CONSTRAINT nc_scoreValidation_pk PRIMARY KEY (dataTable, dataID)
 		USING INDEX
 		(CREATE INDEX nc_scoreValidation_pidx on nc_scoreValidation(dataTable, dataID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_scoreValidation_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_scoreValidation_sidx on nc_scoreValidation(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_scoreValidation.dataTable IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_scoreValidation.dataID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidation.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidation.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_scoreValidation.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_scoreValidation.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_scoreValidation.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_scoreValidation.timestamp IS 'The timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expComponent).  The timestamp refers to the beginning (start) time for the object.'
;
COMMENT ON COLUMN nc_scoreValidation.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_scoreValidation.validatorID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidation.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidation.method IS 'The name column is used to store the name of the object being described by the tuple. '
;
