DROP TABLE nc_storedAssessment CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_storedAssessment 
--

CREATE TABLE nc_storedAssessment(
    uniqueID                  NUMBER(38, 0)       NOT NULL,
    assessmentID              NUMBER(38, 0)       NOT NULL,
    tableID                   NUMBER(38, 0)       NOT NULL,
    owner                     NUMBER(38, 0)       NOT NULL,
    modTime                   DATE                NOT NULL,
    modUser                   NUMBER(38, 0)       NOT NULL,
    componentID               NUMBER(38, 0)       NOT NULL,
    nc_experiment_uniqueID    NUMBER(38, 0)       NOT NULL,
    segmentID                 NUMBER(38, 0)       NOT NULL,
    subjectID                 VARCHAR2(64),
    time_stamp                TIMESTAMP(6)        NOT NULL,
    informantID               VARCHAR2(64),
    informantRelation         VARCHAR2(128)       NOT NULL,
    isValidated               NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    status                    VARCHAR2(64)        NOT NULL,
    ratorQuality              VARCHAR2(128),
    isTimeInterval            NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    timeInterval              DOUBLE PRECISION,
    CONSTRAINT nc_storedAssessment_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_storedAssessment_pidx on nc_storedAssessment(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_storedAssessment_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_storedAssessment_sidx on nc_storedAssessment(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_storedAssessment.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedAssessment.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedAssessment.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_storedAssessment.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_storedAssessment.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_storedAssessment.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_storedAssessment.componentID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_storedAssessment.nc_experiment_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedAssessment.segmentID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_storedAssessment.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_storedAssessment.time_stamp IS 'The timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expComponent).  The timestamp refers to the beginning (start) time for the object.'
;
COMMENT ON COLUMN nc_storedAssessment.informantID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_storedAssessment.informantRelation IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_storedAssessment.isValidated IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_storedAssessment.status IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_storedAssessment.isTimeInterval IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
