DROP TABLE nc_storedTuple CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_storedTuple 
--

CREATE TABLE nc_storedTuple(
    baseTableID        NUMBER(38, 0)    NOT NULL,
    baseTupleID        NUMBER(38, 0),
    extendedTupleID    NUMBER(38, 0)    NOT NULL,
    uniqueID           NUMBER(38, 0)    NOT NULL,
    tableID            NUMBER(38, 0),
    owner              NUMBER(38, 0)    NOT NULL,
    modTime            DATE             NOT NULL,
    modUser            NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_storedTuple_pk PRIMARY KEY (baseTableID, extendedTupleID)
 		USING INDEX
 		(CREATE INDEX nc_storedTuple_pidx on nc_storedTuple(baseTableID, extendedTupleID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_storedTuple_sk  UNIQUE (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_storedTuple_sidx on nc_storedTuple(uniqueID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_storedTuple.baseTableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_storedTuple.baseTupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedTuple.extendedTupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedTuple.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedTuple.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_storedTuple.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_storedTuple.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_storedTuple.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
