DROP TABLE nc_tupleTimestamp CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_tupleTimestamp 
--

CREATE TABLE nc_tupleTimestamp(
    tableID            NUMBER(38, 0)    NOT NULL,
    uniqueID           NUMBER(38, 0)    NOT NULL,
    owner              NUMBER(38, 0)    NOT NULL,
    modTime            DATE             NOT NULL,
    modUser            NUMBER(38, 0)    NOT NULL,
    extendedTupleID    NUMBER(38, 0)    NOT NULL,
    columnName         VARCHAR2(128)    NOT NULL,
    columnType         VARCHAR2(64)     NOT NULL,
    baseTableID        NUMBER(38, 0)    NOT NULL,
    baseTupleID        NUMBER(38, 0)    NOT NULL,
    textValue          VARCHAR2(255),
    comments           CLOB,
    dataValue          TIMESTAMP(6),
    CONSTRAINT nc_tupleTimestamp_pk PRIMARY KEY (tableID, uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_tupleTimestamp_pidx on nc_tupleTimestamp(tableID, uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tupleTimestamp_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_tupleTimestamp_sidx on nc_tupleTimestamp(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_tupleTimestamp.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_tupleTimestamp.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleTimestamp.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_tupleTimestamp.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_tupleTimestamp.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleTimestamp.extendedTupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleTimestamp.columnName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleTimestamp.columnType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_tupleTimestamp.baseTableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_tupleTimestamp.baseTupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleTimestamp.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_tupleTimestamp.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
