DROP TABLE nc_visitType CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_visitType 
--

CREATE TABLE nc_visitType(
    visitType      VARCHAR2(64)     NOT NULL,
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        TIMESTAMP(6)     NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    description    CLOB,
    CONSTRAINT nc_visitType_pk PRIMARY KEY (visitType)
 		USING INDEX
 		(CREATE INDEX nc_visitType_pidx on nc_visitType(visitType)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_visitType_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_visitType_sidx on nc_visitType(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_visitType.visitType IS 'The name of the visit type (e.g. ''clinical'' or ''scan'')'
;
COMMENT ON COLUMN nc_visitType.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_visitType.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_visitType.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_visitType.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_visitType.description IS 'Description of the visit type'
;
