-----------------------------------------------------------------
--   Run as the schema owner of hid
--   Assumptions:
--   (1)Tablespaces HIDPRD_DATA and HIDPRD_INDEX have been created
--   (2)The schema owner, by defaul "BIRNWEB", has been created 
--      with previlidges creating database objects.
-----------------------------------------------------------------

SET ECHO OFF

PROMPT 
PROMPT specify the name of HID schema owner:
DEFINE hid_name = "BIRNWEB"
PROMPT 

PROMPT 
PROMPT specify the first name of HID schema owner:
DEFINE OFirstName = &1

PROMPT
PROMPT specify the last name of HID schema owner:
DEFINE OLastName = &2

PROMPT
PROMPT specify the email address of HID schema owner:
DEFINE OEmailAddress = &3

PROMPT 
PROMPT specify the first name of the rater:
DEFINE RFirstName = &4

PROMPT
PROMPT specify the last name of the rater:
DEFINE RLastName = &5

PROMPT
PROMPT specify the email address of the rater:
DEFINE REmailAddress = &6

PROMPT
PROMPT specify the user name of the rater:
DEFINE RDBuserName = &7


SPOOL hid_schema.log

-- create datebase
DEFINE tablespace_data = 'HIDPRD_DATA'
DEFINE tablespace_index = 'HIDPRD_INDX'
@@create_tables.sql
@@create_triggers.sql
 
--create sequency number
drop sequence uid_seq;

create sequence uid_seq increment by 1
start with 1 nomaxvalue nocycle;

--populate with static data 
@@SP/sp_user.sql
@@SP/sp_static_data.sql
@@SP/sp_create_rater.sql
commit;

declare
   owner_id number;
begin
   owner_id := create_static_data('&hid_name', '&OFirstName', '&OLastName', '&OEmailAddress');
--   owner_id := create_static_data('&hid_name', 'Steve', 'Potkin', 'spotkin@uci.edu');
   CREATE_RATER('&RDBuserName','&RFirstName','&RLastName','&REmailAddress',owner_id);
--   CREATE_RATER('dywei','Dingying','Wei','dywei@uci.edu',owner_id);
   commit;
end;
/

@@FK/CreateForeignKeys.sql
-- populate fBIRN PhaseI project related data
@@static_data_project.sql
spool off
exit
