 -- *** Begin Autogenerated Header ***
 --
 -- Name: data upload and download
 -- Description: table changes for downloading data and importing assessments from excel files
 -- Version: 0
 --
 -- *** Calling Version Checker ***
whenever SQLerror exit 1
DECLARE
  CRU_proper_version NUMBER;
  CRU_temp NUMBER;
BEGIN
  SELECT check_for_schema_version(1, 0) INTO CRU_proper_version FROM DUAL;
  IF CRU_proper_version = 0 THEN
    RAISE_APPLICATION_ERROR(-20737,'Invalid starting schema version.');
  END IF;
  SELECT set_schema_version(2, 0, 0, '05-Oct-2007', 0) INTO CRU_temp FROM DUAL;
END;
/
 -- *** Autogenerated Header Completed ***

DEFINE tablespace_data = 'HIDPRD_DATA'
DEFINE tablespace_index = 'HIDPRD_INDX'
PROMPT specify your siteID, e.g., 0009 for UCI, as mySiteID:
DEFINE PrimarySiteID = &mySiteID
-- 
-- TABLE: nc_site
--
DROP TABLE nc_site CASCADE CONSTRAINTS
;
CREATE table nc_site(
    uniqueID                    NUMBER(38, 0)    NOT NULL,
    tableID                     NUMBER(38, 0)    NOT NULL,
    owner                       NUMBER(38, 0)    NOT NULL,
    modTime                     DATE             NOT NULL,
    modUser                     NUMBER(38, 0)    NOT NULL,
    siteID                      VARCHAR2(64)    NOT NULL,
    siteName                    VARCHAR2(64)    NOT NULL,
    isPrimary                   NUMBER(38, 0)    NOT NULL,
    databaseAddress             VARCHAR2(2048)    NOT NULL,
    databaseName                VARCHAR2(64)    NOT NULL,
    databaseVendor              VARCHAR2(64)    NOT NULL,
    databaseVersion             VARCHAR2(64)    NOT NULL,
    databasePort                NUMBER(38, 0)     NOT NULL,
    contactFirstName            VARCHAR2(64)    NOT NULL,
    contactLastName             VARCHAR2(64)    NOT NULL,
    contactEmail                VARCHAR2(128)    NOT NULL,
    contactPhone                VARCHAR2(128)    NOT NULL,
    CONSTRAINT nc_site_pk PRIMARY KEY (uniqueID),
    CONSTRAINT nc_site_ck CHECK (isPrimary in (0, 1))
)
TABLESPACE &&tablespace_data
;

ALTER TABLE nc_site ADD CONSTRAINT Refnc_tableID2872
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_site ADD CONSTRAINT Refnc_databaseUser3052
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_site ADD CONSTRAINT Refnc_databaseUser3062
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

-- 
-- TABLE: nc_dataArchive 
--
DROP TABLE nc_dataArchive CASCADE CONSTRAINTS
;

CREATE TABLE nc_dataArchive(
    uniqueID            NUMBER(38, 0)     NOT NULL,
    tableID             NUMBER(38, 0)     NOT NULL,
    owner               NUMBER(38, 0)     NOT NULL,
    modTime             DATE              NOT NULL,
    modUser             NUMBER(38, 0)     NOT NULL,
    archiveName		VARCHAR2(64)     NOT NULL,
    description         VARCHAR2(2048),
    dataURI 		VARCHAR2(2048),
    dataSize		NUMBER(38, 0), 
    dataDescription 	VARCHAR2(128),
    CONSTRAINT nc_dataArchive_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_dataArchive_pidx on nc_dataArchive(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_dataArchive_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_dataArchive_sidx on nc_dataArchive(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;

COMMENT ON COLUMN nc_dataArchive.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_dataArchive.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_dataArchive.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_dataArchive.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_dataArchive.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_dataArchive.archiveName IS 'Textual name of the dataArchive, one archive can contain multiple dataURIs.'
;
COMMENT ON COLUMN nc_dataArchive.description IS 'Description of the dataArchive.'
;
COMMENT ON COLUMN nc_dataArchive.dataURI IS 'The URI for the data from this dataArchive file.'
;
COMMENT ON COLUMN nc_dataArchive.dataDescription IS 'A brief description about the archive file that shows in the web page.'
;
COMMENT ON COLUMN nc_dataArchive.dataSize IS 'The size of the archive file in bytes.'
;

ALTER TABLE nc_dataArchive ADD CONSTRAINT Refnc_tableID2875
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dataArchive ADD CONSTRAINT Refnc_databaseUser3055
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataArchive ADD CONSTRAINT Refnc_databaseUser3065
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_dataObject 
--
DROP TABLE nc_dataObject CASCADE CONSTRAINTS
;

CREATE TABLE nc_dataObject(
    uniqueID         NUMBER(38, 0)    NOT NULL,
    tableID          NUMBER(38, 0)    NOT NULL,
    owner            NUMBER(38, 0)    NOT NULL,
    modTime          DATE             NOT NULL,
    modUser          NUMBER(38, 0)    NOT NULL,
    extensionName    VARCHAR2(18)     NOT NULL,
    dataID           NUMBER(38, 0)    NOT NULL,
    objectType       VARCHAR2(18)     NOT NULL,
    objectName       VARCHAR2(256)    NOT NULL,
    objectSize       NUMBER(38, 0)    NOT NULL,
    description      VARCHAR2(256),
    CONSTRAINT nc_dataObject_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_dataObject_sidx on nc_dataObject(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;


COMMENT ON COLUMN nc_dataObject.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_dataObject.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_dataObject.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_dataObject.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_dataObject.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_dataObject.dataID IS 'the nc_researchdata.uniqueid that the dataobject is associated to'
;
COMMENT ON COLUMN nc_dataObject.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_researchData2001
    FOREIGN KEY (dataID)
    REFERENCES nc_researchData(uniqueID)
;
ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_tableID2871
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_databaseUser3051
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_databaseUser3061
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_dataObjectType3062
    FOREIGN KEY (objectType)
    REFERENCES nc_dataObjectType(objectType)
;


DROP TABLE nc_dataObjectType CASCADE CONSTRAINTS
;
--
-- TABLE: nc_dataObjectType
--

CREATE TABLE nc_dataObjectType(
    uniqueID         NUMBER(38, 0),
    tableID          NUMBER(38, 0)    NOT NULL,
    owner            NUMBER(38, 0)    NOT NULL,
    modTime          DATE             NOT NULL,
    modUser          NUMBER(38, 0)    NOT NULL,
    objectType       VARCHAR2(18)     NOT NULL,
    applicableActions VARCHAR2(256) default 'DOWNLOAD',
    description      VARCHAR2(256),
    CONSTRAINT nc_dataObjectType_sk  UNIQUE (objectType)
                USING INDEX
                (CREATE INDEX nc_dataObjectType_sidx on nc_dataObjectType(objectType)
                TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;

COMMENT ON COLUMN nc_dataObjectType.objectType IS 'The classification of dataobject type in nc_researchData in the format of xx_xxxxx where prefix is 1 for structural, 2 for symantic and 3 for mix objects respectively.'
;

COMMENT ON COLUMN nc_dataObjectType.applicableActions IS 'The actions can be applied to the dataobjects with this objectType. The actions are in comma delimited format.'

ALTER TABLE nc_dataObjectType ADD CONSTRAINT Refnc_tableID2873
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dataObjectType ADD CONSTRAINT Refnc_databaseUser3053
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataObjectType ADD CONSTRAINT Refnc_databaseUser3063
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_humanSubject 
--
alter table nc_humanSubject
add (
    siteID                      NUMBER(38, 0),
    isRemote                    NUMBER(1, 0)
);

ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_site_humanSubject
    FOREIGN KEY (siteID)
    REFERENCES nc_site(uniqueID)
;

DROP TABLE nc_jobs CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_jobs 
--

CREATE TABLE nc_jobs (
	uniqueID         NUMBER(38, 0) NOT NULL,
	tableID          NUMBER(38, 0)    NOT NULL,
	owner            NUMBER(38, 0)    NOT NULL,
	modTime          DATE             NOT NULL,
	modUser          NUMBER(38, 0)    NOT NULL,
        jobID		 VARCHAR2(30)	  NOT NULL,
	jobType		 VARCHAR2(64)	  NOT NULL,
	jobUser		 VARCHAR2(64)	  NOT NULL,
	jobStatus	 VARCHAR2(64)	  NOT NULL,
	jobStartDate	 DATE		  NOT NULL,
        jobEndDate       DATE,
        jobSize		 NUMBER(38, 0), 
        downloadCount    NUMBER(38, 0),
        lastDownloadTime DATE, 
	savedResultFile	 VARCHAR2(2048),
	errorMsg	 VARCHAR2(2048),
	description	 VARCHAR2(255),
       CONSTRAINT nc_jobs_pk PRIMARY KEY (uniqueID)
          USING INDEX
          (CREATE INDEX nc_jobs_pidx on nc_jobs(uniqueID)
                  TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;

COMMENT ON COLUMN nc_jobs.jobID IS 'Unique Job ID assigned to a submitted job.';
COMMENT ON COLUMN nc_jobs.jobType IS 'The type of the job submitted, as assigned by job scheduler, including download, batch query etc.';
COMMENT ON COLUMN nc_jobs.jobUser IS 'The web app user who have submitted the job.';
COMMENT ON COLUMN nc_jobs.jobStatus IS 'This column indicates the last saved status of the submitted job.';
COMMENT ON COLUMN nc_jobs.jobStartDate IS 'This column indicates the start date and time of the submitted job.';
COMMENT ON COLUMN nc_jobs.jobEndDate IS 'This column indicates the finish date and time of the submitted job.';
COMMENT ON COLUMN nc_jobs.jobSize IS 'This column indicates (if applicable) the size of the created result file in bytes.';
COMMENT ON COLUMN nc_jobs.downloadCount IS 'This column indicates (if applicable) the number of times the result file is downloaded.';

COMMENT ON COLUMN nc_jobs.lastDownloadTime IS 'This column indicates (if applicable) the date and time of the last download of the job result file. This value is mainly used for cache cleanup decision making.';
COMMENT ON COLUMN nc_jobs.savedResultFile IS 'This column indicates (if applicable) the full path of the job result file on the web server.';

COMMENT ON COLUMN nc_jobs.errorMsg IS 'If submitted job has ended with error, this column contains the error message.';

ALTER TABLE nc_jobs ADD CONSTRAINT Refnc_tableID2874
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_jobs ADD CONSTRAINT Refnc_databaseUser3054
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_jobs ADD CONSTRAINT Refnc_databaseUser3064
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;



declare
        v_id number;
        v_ownerid number;
	v_siteID varchar2(4);
	v_majorversion number :=2;
	v_minorversion number :=0;
begin
	v_siteID := &&PrimarySiteID;
        select max(OWNER) into v_ownerid from nc_tableID; 

        insert into nc_tableid
select 'NC_SITE', max(tableid) + 1, max(tableid) + 1, max(owner), sysdate, max(owner),
v_majorversion, v_minorversion, '' from nc_tableID;

insert into nc_tableid
select 'NC_JOBS', max(tableid) + 1, max(tableid) + 1, max(owner), sysdate, max(owner),
v_majorversion, v_minorversion, '' from nc_tableID;

insert into nc_tableid
select 'NC_DATAOBJECTTYPE', max(tableid) + 1, max(tableid) + 1, max(owner), sysdate, max(owner),
v_majorversion, v_minorversion, '' from nc_tableID;

insert into nc_tableid
select 'NC_DATAARCHIVE', max(tableid) + 1, max(tableid) + 1, max(owner), sysdate, max(owner),
v_majorversion, v_minorversion, '' from nc_tableID;

	select max(tableID) into v_id from nc_tableid where tablename = 'NC_DATAOBJECTTYPE';

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '1_SRB COL', 'DOWNLOAD', 'SRB collection specified by nc_researchdata.dataURI');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '1_SRB CHILD COL', 'DOWNLOAD', 'SRB child collection under the collection specified by nc_researchdata.dataURI');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '1_SRB FILE', 'DOWNLOAD', 'SRB File specified by nc_researchdata.dataURI');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '1_SRB CHILD F', 'DOWNLOAD', 'SRB child file under the collection specified by nc_researchdata.dataURI');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '2_HTML', 'DOWNLOAD', 'HTML file specified by both nc_researchdata.dataURI and objectname');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '2_DICOM', 'DOWNLOAD', 'DICOM image file specified by both nc_researchdata.dataURI and objectname');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '2_NIFTI', 'DOWNLOAD', 'NIFTI image file specified by both nc_researchdata.dataURI and objectname');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '3_SRB COL A_7.5', 'DOWNLOAD', 'A directory contains ANALYZE_7.5 image data.');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '3_SRB FILE Eprime', 'DOWNLOAD', 'Eprime file contains fMRI task data.');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '3_LOC COL A_7.5', 'DOWNLOAD', 'A local directory contains ANALYZE_7.5 image data.');

        insert into nc_dataObjectType(uniqueID, tableID, owner, modTime, modUser, objectType, applicableActions, description) values(uid_seq.nextval, v_id, v_ownerid, sysdate, v_ownerid, '3_LOC FILE Eprime', 'DOWNLOAD', 'A local Eprime file contains fMRI task data.');


insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0003', 'Duke', 0, 'duke-biac-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0005', 'BWH', 0, 'bwh-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0006', 'MGH', 0, 'mgh-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0007', 'UCLA', 0, 'loni-gpop.nbirn.net', 'fbirn_test',
'Postgres', '?', 5432, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0008', 'UCSD', 0, 'fmri-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0009', 'UCI', 0, 'uci-bic-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0010', 'UNM', 0, 'unm-hsc-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0011', 'Stanford', 0, 'stanford-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0012', 'Iowa', 0, 'uiowa-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0013', 'UMN', 0, 'umn-cmrr-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 10025, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

insert into nc_site
select uid_seq.nextval, tableid, owner, sysdate, moduser, '0018', 'Yale', 0, 'yale-gpop.nbirn.net', 'hidprd',
'Oracle', '10.2.0.2.0', 1521, 'contactFirstName', 'contactLastName',  'contactEmail', 'contactPhone'
from nc_tableID where tablename = 'NC_SITE';

update nc_site set isPrimary = 1 where siteid = v_siteID;

commit;

end;
/


 -- *** Begin Autogenerated Footer ***
DECLARE
  CRU_temp NUMBER;
BEGIN
  SELECT set_schema_version(2, 0, 0, '05-Oct-2007', 1) INTO CRU_temp FROM DUAL;
END;
/
 -- *** Autogenerated Footer Completed ***

