-- 
-- table: bk_tupleaccess 
--

alter table bk_tupleaccess add constraint refnc_databaseuser2531 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table bk_tupleaccess add constraint refnc_databaseuser2541 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table bk_tupleaccess add constraint refnc_tupleaccess2581 
    foreign key (tableid, tupleid, grantor, grantee)
    references nc_tupleaccess(tableid, tupleid, grantor, grantee)
;


-- 
-- table: nc_animalspecies 
--

alter table nc_animalspecies add constraint refnc_databaseuser2321 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_animalspecies add constraint refnc_databaseuser2331 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_animalspecies add constraint refnc_tableid2701 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_assessment 
--

alter table nc_assessment add constraint refnc_assessment1801 
    foreign key (previousassessmentid)
    references nc_assessment(assessmentid)
;

alter table nc_assessment add constraint refnc_tableid3641 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessment add constraint refnc_databaseuser3951 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessment add constraint refnc_databaseuser3961 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentboolean 
--

alter table nc_assessmentboolean add constraint refnc_assessmentdata821 
    foreign key (tableid, nc_assessmentdata_uniqueid)
    references nc_assessmentdata(tableid, uniqueid)
;


alter table nc_assessmentboolean add constraint refnc_assessmentscore1391 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentboolean add constraint refnc_databaseuser2041 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentboolean add constraint refnc_databaseuser2051 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentboolean add constraint refnc_dataclassification2121 
    foreign key (nc_dataclassification_uniqueid)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmentboolean add constraint refnc_humansubject3741 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmentboolean add constraint refnc_databaseuser4231 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentboolean add constraint refnc_databaseuser4241 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentboolean add constraint refnc_storedassessment4591 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;


-- 
-- table: nc_assessmentdata 
--

alter table nc_assessmentdata add constraint refnc_assessmentscore801 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentdata add constraint refnc_storedassessment811 
    foreign key (nc_storedassessment_uniqueid)
    references nc_storedassessment(uniqueid)
;

alter table nc_assessmentdata add constraint refnc_databaseuser1871 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentdata add constraint refnc_databaseuser1881 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentdata add constraint refnc_dataclassification1921 
    foreign key (classification)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmentdata add constraint refnc_tableid3601 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentdata add constraint refnc_humansubject3781 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmentdata add constraint refnc_databaseuser4131 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentdata add constraint refnc_databaseuser4141 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentfloat 
--

alter table nc_assessmentfloat add constraint refnc_assessmentdata851 
    foreign key (tableid, nc_assessmentdata_uniqueid)
    references nc_assessmentdata(tableid, uniqueid)
;


alter table nc_assessmentfloat add constraint refnc_assessmentscore1371 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentfloat add constraint refnc_databaseuser2061 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentfloat add constraint refnc_databaseuser2071 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentfloat add constraint refnc_dataclassification2131 
    foreign key (classification)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmentfloat add constraint refnc_humansubject3751 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmentfloat add constraint refnc_databaseuser4171 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentfloat add constraint refnc_databaseuser4181 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentfloat add constraint refnc_storedassessment4601 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;


-- 
-- table: nc_assessmentinformant 
--

alter table nc_assessmentinformant add constraint refnc_ontologyconcept1761 
    foreign key (ontologysource, conceptid, informantrelation)
    references nc_ontologyconcept(ontologysource, conceptid, concept)
;

alter table nc_assessmentinformant add constraint refnc_tableid3581 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentinformant add constraint refnc_databaseuser3791 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentinformant add constraint refnc_databaseuser3801 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentinteger 
--

alter table nc_assessmentinteger add constraint refnc_assessmentdata841 
    foreign key (tableid, nc_assessmentdata_uniqueid)
    references nc_assessmentdata(tableid, uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_storedassessment1331 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_assessmentscore1381 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentinteger add constraint refnc_databaseuser2081 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_databaseuser2091 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_dataclassification2141 
    foreign key (classification)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_humansubject3761 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmentinteger add constraint refnc_databaseuser4191 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentinteger add constraint refnc_databaseuser4201 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentitem 
--

alter table nc_assessmentitem add constraint refnc_assessmentscore1501 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentitem add constraint refnc_tableid3671 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentitem add constraint refnc_databaseuser3911 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentitem add constraint refnc_databaseuser3921 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentscore 
--

alter table nc_assessmentscore add constraint refnc_assessment791 
    foreign key (assessmentid)
    references nc_assessment(assessmentid)
;

alter table nc_assessmentscore add constraint refnc_ontologyconcept901 
    foreign key (assessmentontology, assessmentconcept)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_assessmentscore add constraint refnc_securityclassificati1211 
    foreign key (securityclassification)
    references nc_securityclassification(securityclassification)
;

alter table nc_assessmentscore add constraint refnc_assessmentscore1491 
    foreign key (parentasid, parentscore)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentscore add constraint refnc_tableid3611 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentscore add constraint refnc_databaseuser3971 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentscore add constraint refnc_databaseuser3981 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentscorecode 
--

alter table nc_assessmentscorecode add constraint refnc_assessmentscore1551 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentscorecode add constraint refnc_ontologyconcept1861 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_assessmentscorecode add constraint refnc_tableid3631 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentscorecode add constraint refnc_databaseuser3891 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentscorecode add constraint refnc_databaseuser3901 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmentstatus 
--

alter table nc_assessmentstatus add constraint refnc_tableid3551 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_assessmentstatus add constraint refnc_databaseuser3991 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentstatus add constraint refnc_databaseuser4001 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_assessmenttimestamp 
--

alter table nc_assessmenttimestamp add constraint refnc_databaseuser2161 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_databaseuser2171 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_dataclassification2181 
    foreign key (classification)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_assessmentdata3701 
    foreign key (tableid, nc_assessmentdata_uniqueid)
    references nc_assessmentdata(tableid, uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_assessmentscore3711 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmenttimestamp add constraint refnc_storedassessment3721 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_humansubject3731 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmenttimestamp add constraint refnc_databaseuser4211 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmenttimestamp add constraint refnc_databaseuser4221 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

/* dyw, dup
alter table nc_assessmenttimestamp add constraint refnc_storedassessment4621 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;
*/


-- 
-- table: nc_assessmentvarchar 
--

alter table nc_assessmentvarchar add constraint refnc_assessmentdata831 
    foreign key (tableid, nc_assessmentdata_uniqueid)
    references nc_assessmentdata(tableid, uniqueid)
;


alter table nc_assessmentvarchar add constraint refnc_assessmentscore1361 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_assessmentvarchar add constraint refnc_databaseuser2101 
    foreign key (raterid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentvarchar add constraint refnc_databaseuser2111 
    foreign key (keyerid)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentvarchar add constraint refnc_dataclassification2151 
    foreign key (classification)
    references nc_dataclassification(uniqueid)
;

alter table nc_assessmentvarchar add constraint refnc_humansubject3771 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_assessmentvarchar add constraint refnc_databaseuser4151 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentvarchar add constraint refnc_databaseuser4161 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_assessmentvarchar add constraint refnc_storedassessment4631 
    foreign key (storedassessmentid)
    references nc_storedassessment(uniqueid)
;


-- 
-- table: nc_brainsegmentdata 
--

alter table nc_brainsegmentdata add constraint refnc_deriveddata1731 
    foreign key (dataid)
    references nc_deriveddata(uniqueid)
;

alter table nc_brainsegmentdata add constraint refnc_ontologyconcept1741 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_brainsegmentdata add constraint refnc_expsegment1971 
    foreign key (segmentid, componentid, nc_experimentid, subjectid)
    references nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid)
;

alter table nc_brainsegmentdata add constraint refnc_tableid3521 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_brainsegmentdata add constraint refnc_databaseuser4111 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_brainsegmentdata add constraint refnc_databaseuser4121 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_brainsegmentdata add constraint refnc_humansubject4501 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;


-- 
-- table: nc_collectionequipment 
--

alter table nc_collectionequipment add constraint refnc_tableid3431 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_compiler 
--

alter table nc_compiler add constraint refnc_databaseuser4451 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_compiler add constraint refnc_databaseuser4461 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_compiler add constraint refnc_tableid4491 
    foreign key (tableid)
    references nc_tableid(tableid)
;

-- 
-- table: nc_dataarchive (10/5/2007)
--

alter table nc_dataarchive add constraint refnc_tableid2875
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_dataarchive add constraint refnc_databaseuser3055
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_dataarchive add constraint refnc_databaseuser3065
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

-- 
-- table: nc_databasecolumn 
--

alter table nc_databasecolumn add constraint refnc_tableid1591 
    foreign key (tablename)
    references nc_tableid(tablename)
;

alter table nc_databasecolumn add constraint refnc_databasecolumn1601 
    foreign key (parentcolumn)
    references nc_databasecolumn(columnname)
;

alter table nc_databasecolumn add constraint refnc_tableid2671 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_databaseuser 
--

alter table nc_databaseuser add constraint refnc_userstatus541 
    foreign key (userstatus)
    references nc_userstatus(uniqueid)
;

alter table nc_databaseuser add constraint refnc_userclass551 
    foreign key (userclass)
    references nc_userclass(uniqueid)
;

alter table nc_databaseuser add constraint refnc_person1121 
    foreign key (personid)
    references nc_person(uniqueid)
;

alter table nc_databaseuser add constraint refnc_tableid4511 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_dataclassification 
--

alter table nc_dataclassification add constraint refnc_tableid3591 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_dataclassification add constraint refnc_databaseuser3811 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_dataclassification add constraint refnc_databaseuser3821 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_dataobject 
--

alter table nc_dataobject add constraint refnc_researchdata2001 
    foreign key (dataid)
    references nc_researchdata(uniqueid)
;

alter table nc_dataobject add constraint refnc_tableid2871 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_dataobject add constraint refnc_databaseuser3051 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_dataobject add constraint refnc_databaseuser3061 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

-- (10/5/2007) (corrected as noticed by Deepthi Dhandi
alter table nc_dataobject add constraint refnc_dataobjecttype3062
    foreign key (objecttypeid)
    references nc_dataobjecttype(uniqueid)
;

-- 
-- table: nc_dataobjecttype (10/5/2007)
--

alter table nc_dataobjecttype add constraint refnc_tableid2873
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_dataobjecttype add constraint refnc_databaseuser3053
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_dataobjecttype add constraint refnc_databaseuser3063
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_dbcolumnunit 
--

alter table nc_dbcolumnunit add constraint refnc_databasecolumn1661 
    foreign key (columnname)
    references nc_databasecolumn(columnname)
;

alter table nc_dbcolumnunit add constraint refnc_measurementunit1681 
    foreign key (measurementsystem, unit)
    references nc_measurementunit(measurementsystem, unit)
;

alter table nc_dbcolumnunit add constraint refnc_tableid2631 
    foreign key (columntable)
    references nc_tableid(tableid)
;

alter table nc_dbcolumnunit add constraint refnc_tableid4581 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_dbcolumnunit add constraint refnc_databaseuser4681 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_dbcolumnunit add constraint refnc_databaseuser4691 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_deriveddata 
--

alter table nc_deriveddata add constraint refnc_researchdata1081 
    foreign key (uniqueid)
    references nc_researchdata(uniqueid)
;

alter table nc_deriveddata add constraint refnc_ontologyconcept1181 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

--
-- 3/12/08 IBO not all derived data is local!
--

-- alter table nc_deriveddata add constraint refnc_expsegment1961 
--    foreign key (segmentid, componentid, nc_experiment_uniqueid, subjectid)
--    references nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid)
-- ;

alter table nc_deriveddata add constraint refnc_tableid2851 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_deriveddata add constraint refnc_databaseuser2951 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;



 alter table nc_deriveddata add constraint refnc_databaseuser2961 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

--
-- 3/12/08 IBO not all derived data is local!
--

-- alter table nc_deriveddata add constraint refnc_humansubject4521 
--    foreign key (subjectid)
--    references nc_humansubject(subjectid)
--;


-- 
-- table: nc_executedtransform 
--

alter table nc_executedtransform add constraint refnc_transformation1021 
    foreign key (logicaltransformid)
    references nc_transformation(uniqueid)
;

alter table nc_executedtransform add constraint refnc_databaseuser1131 
    foreign key (nc_databaseuser_uniqueid)
    references nc_databaseuser(uniqueid)
;

alter table nc_executedtransform add constraint refnc_machine1141 
    foreign key (machineid)
    references nc_machine(uniqueid)
;

alter table nc_executedtransform add constraint refnc_tableid2811 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_executedtransform add constraint refnc_databaseuser2991 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_executedtransform add constraint refnc_databaseuser3001 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_executedtransform add constraint refnc_compiler4401 
    foreign key (compilerid)
    references nc_compiler(uniqueid)
;


-- 
-- table: nc_expcomponent 
--

alter table nc_expcomponent add constraint refnc_experiment141 
    foreign key (nc_experiment_uniqueid)
    references nc_experiment(uniqueid)
;

alter table nc_expcomponent add constraint refnc_humansubject151 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_expcomponent add constraint refnc_visittype171 
    foreign key (visittype)
    references nc_visittype(visittype)
;

alter table nc_expcomponent add constraint refnc_tableid3511 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_expcomponent add constraint refnc_databaseuser3851 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_expcomponent add constraint refnc_databaseuser3861 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_expcondition 
--

alter table nc_expcondition add constraint refnc_expmanipulation301 
    foreign key (expmanipulationid)
    references nc_expmanipulation(uniqueid)
;

alter table nc_expcondition add constraint refnc_ontologyconcept1251 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_expcondition add constraint refnc_tableid3441 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_expcondition add constraint refnc_databaseuser4741 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_expcondition add constraint refnc_databaseuser4751 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_experiment 
--

alter table nc_experiment add constraint refnc_person131 
    foreign key (contactperson)
    references nc_person(uniqueid)
;

alter table nc_experiment add constraint refnc_databaseuser2291 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_experiment add constraint refnc_databaseuser2301 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_experiment add constraint refnc_tableid2721 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_expevent 
--

alter table nc_expevent add constraint refnc_expmanipulation321 
    foreign key (expmanipulationid)
    references nc_expmanipulation(uniqueid)
;

alter table nc_expevent add constraint refnc_ontologyconcept1261 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_expevent add constraint refnc_tableid3411 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_expevent add constraint refnc_databaseuser4761 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_expevent add constraint refnc_databaseuser4771 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_expmanipulation 
--

alter table nc_expmanipulation add constraint refnc_ontologyconcept1231 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_expmanipulation add constraint refnc_tableid3451 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_expsegment 
--

alter table nc_expsegment add constraint refnc_expcomponent161 
    foreign key (componentid, nc_experiment_uniqueid, subjectid)
    references nc_expcomponent(componentid, nc_experiment_uniqueid, subjectid)
;

alter table nc_expsegment add constraint refnc_protocol201 
    foreign key (protocolversion, protocolid)
    references nc_protocol(protocolversion, protocolid)
;

alter table nc_expsegment add constraint refnc_expstudy2021 
    foreign key (studyid, componentid, nc_experiment_uniqueid, subjectid)
    references nc_expstudy(studyid, componentid, experimentid, subjectid)
;

alter table nc_expsegment add constraint refnc_tableid3481 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_expsegment add constraint refnc_databaseuser3871 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_expsegment add constraint refnc_databaseuser3881 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_expstudy 
--

alter table nc_expstudy add constraint refnc_expcomponent2031 
    foreign key (componentid, experimentid, subjectid)
    references nc_expcomponent(componentid, nc_experiment_uniqueid, subjectid)
;

alter table nc_expstudy add constraint refnc_tableid3491 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_extendedtuple 
--

alter table nc_extendedtuple add constraint refnc_tuplesubclass631 
    foreign key (tuplesubclass, tupleclass)
    references nc_tuplesubclass(tuplesubclass, tupleclass)
;

alter table nc_extendedtuple add constraint refnc_tableid3171 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_extendedtuple add constraint refnc_databaseuser3351 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_extendedtuple add constraint refnc_databaseuser3361 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_humansubject 
--

alter table nc_humansubject add constraint refnc_animalspecies21 
    foreign key (nc_animalspecies_uniqueid)
    references nc_animalspecies(uniqueid)
;

/* dyw, no trigger to populate the parent table
alter table nc_humansubject add constraint refnc_researchsubject2191 
    foreign key (subjectid)
    references nc_researchsubject(subjectid)
;
*/

alter table nc_humansubject add constraint refnc_databaseuser2411 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_humansubject add constraint refnc_databaseuser2421 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_humansubject add constraint refnc_tableid2741 
    foreign key (tableid)
    references nc_tableid(tableid)
;

-- 10/5/2007

alter table nc_humansubject add constraint refnc_site_humansubject
    foreign key (siteid)
    references nc_site(uniqueid)
;

-- 
-- table: nc_jobs
--
alter table nc_jobs add constraint refnc_tableid2874
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_jobs add constraint refnc_databaseuser3054
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_jobs add constraint refnc_databaseuser3064
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

-- 
-- table: nc_machine 
--

alter table nc_machine add constraint refnc_tableid2791 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_machine add constraint refnc_databaseuser3091 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_machine add constraint refnc_databaseuser3101 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_maskvalidator 
--

alter table nc_maskvalidator add constraint refnc_tableid3621 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_maskvalidator add constraint refnc_databaseuser4051 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_maskvalidator add constraint refnc_databaseuser4061 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_measurementsystem 
--

alter table nc_measurementsystem add constraint refnc_tableid2641 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_measurementsystem add constraint refnc_databaseuser4841 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_measurementsystem add constraint refnc_databaseuser4851 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_measurementtype 
--

alter table nc_measurementtype add constraint refnc_tableid2661 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_measurementtype add constraint refnc_databaseuser4861 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_measurementtype add constraint refnc_databaseuser4871 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_measurementunit 
--

alter table nc_measurementunit add constraint refnc_measurementsystem1691 
    foreign key (measurementsystem)
    references nc_measurementsystem(name)
;

alter table nc_measurementunit add constraint refnc_measurementtype1701 
    foreign key (measurementtype)
    references nc_measurementtype(name)
;

alter table nc_measurementunit add constraint refnc_measurementunit1711 
    foreign key (measurementsystem, conversionunit)
    references nc_measurementunit(measurementsystem, unit)
;

alter table nc_measurementunit add constraint refnc_tableid2651 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_measurementunit add constraint refnc_databaseuser4881 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_measurementunit add constraint refnc_databaseuser4891 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_ontologyconcept 
--

alter table nc_ontologyconcept add constraint refnc_ontologysource771 
    foreign key (ontologysource)
    references nc_ontologysource(ontologysource)
;

alter table nc_ontologyconcept add constraint refnc_tableid2781 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_ontologyconcept add constraint refnc_databaseuser2931 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_ontologyconcept add constraint refnc_databaseuser2941 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_ontologysource 
--

alter table nc_ontologysource add constraint refnc_tableid2771 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_ontologysource add constraint refnc_databaseuser3131 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_ontologysource add constraint refnc_databaseuser3141 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_person 
--

alter table nc_person add constraint refnc_databaseuser2251 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_person add constraint refnc_databaseuser2261 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_person add constraint refnc_tableid2691 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_protocol 
--

alter table nc_protocol add constraint refnc_tableid3471 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_protocolmanip 
--

alter table nc_protocolmanip add constraint refnc_protocol211 
    foreign key (protocolversion, protocolid)
    references nc_protocol(protocolversion, protocolid)
;

alter table nc_protocolmanip add constraint refnc_expmanipulation281 
    foreign key (nc_expmanipulation_uniqueid)
    references nc_expmanipulation(uniqueid)
;

alter table nc_protocolmanip add constraint refnc_tableid3461 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_rangevalidator 
--

alter table nc_rangevalidator add constraint refnc_tableid3661 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_rangevalidator add constraint refnc_databaseuser4031 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_rangevalidator add constraint refnc_databaseuser4041 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_rawdata 
--

alter table nc_rawdata add constraint refnc_expsegment181 
    foreign key (segmentid, componentid, nc_experiment_uniqueid, subjectid)
    references nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid)
;

alter table nc_rawdata add constraint refnc_protocol191 
    foreign key (protocolversion, protocolid)
    references nc_protocol(protocolversion, protocolid)
;

alter table nc_rawdata add constraint refnc_collectionequipment951 
    foreign key (nc_colequipment_uniqueid)
    references nc_collectionequipment(uniqueid)
;

alter table nc_rawdata add constraint refnc_researchdata971 
    foreign key (uniqueid)
    references nc_researchdata(uniqueid)
;

alter table nc_rawdata add constraint refnc_ontologyconcept1171 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_rawdata add constraint refnc_tableid2861 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_rawdata add constraint refnc_databaseuser3071 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_rawdata add constraint refnc_databaseuser3081 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_researchdata 
--

alter table nc_researchdata add constraint refnc_ontologyconcept1151 
    foreign key (dataontology, dataclass)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_researchdata add constraint refnc_tableid2831 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_researchdata add constraint refnc_databaseuser3031 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchdata add constraint refnc_databaseuser3041 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_researchgroup 
--

alter table nc_researchgroup add constraint refnc_researchgrouptype91 
    foreign key (nc_researchgrouptype_uniqueid)
    references nc_researchgrouptype(uniqueid)
;

alter table nc_researchgroup add constraint refnc_experiment101 
    foreign key (nc_experiment_uniqueid)
    references nc_experiment(uniqueid)
;

alter table nc_researchgroup add constraint refnc_databaseuser2381 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchgroup add constraint refnc_databaseuser2391 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchgroup add constraint refnc_tableid2751 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_researchgrouptype 
--

alter table nc_researchgrouptype add constraint refnc_databaseuser2221 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchgrouptype add constraint refnc_databaseuser2231 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchgrouptype add constraint refnc_tableid2731 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_researchsubject 
--

alter table nc_researchsubject add constraint refnc_animalspecies2201 
    foreign key (speciesid)
    references nc_animalspecies(uniqueid)
;

alter table nc_researchsubject add constraint refnc_databaseuser2351 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchsubject add constraint refnc_databaseuser2361 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_researchsubject add constraint refnc_tableid2711 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_schemaversion 
--

alter table nc_schemaversion add constraint refnc_tableid2621 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_scorevalidation 
--

alter table nc_scorevalidation add constraint refnc_databaseuser1891 
    foreign key (validatorid)
    references nc_databaseuser(uniqueid)
;

alter table nc_scorevalidation add constraint refnc_assessmentdata1901 
    foreign key (tableid, dataid, assessmentid)
    references nc_assessmentdata(tableid, uniqueid, assessmentid)
;

alter table nc_scorevalidation add constraint refnc_validationmethod1951 
    foreign key (method)
    references nc_validationmethod(method)
;

alter table nc_scorevalidation add constraint refnc_tableid3561 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_scorevalidation add constraint refnc_databaseuser4091 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_scorevalidation add constraint refnc_databaseuser4101 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_scorevalidator 
--

alter table nc_scorevalidator add constraint refnc_assessmentscore1821 
    foreign key (assessmentid, scorename)
    references nc_assessmentscore(assessmentid, scorename)
;

alter table nc_scorevalidator add constraint refnc_rangevalidator1841 
    foreign key (validatorid)
    references nc_rangevalidator(uniqueid)
;

alter table nc_scorevalidator add constraint refnc_maskvalidator1851 
    foreign key (validatorid)
    references nc_maskvalidator(uniqueid)
;

alter table nc_scorevalidator add constraint refnc_tableid3651 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_scorevalidator add constraint refnc_databaseuser4071 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_scorevalidator add constraint refnc_databaseuser4081 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_securityclassification 
--

alter table nc_securityclassification add constraint refnc_tableid3681 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_securityclassification add constraint refnc_databaseuser3931 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_securityclassification add constraint refnc_databaseuser3941 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_site  (10/5/2007) 
--
alter table nc_site add constraint refnc_tableid2872
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_site add constraint refnc_databaseuser3052
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_site add constraint refnc_databaseuser3062
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

-- 
-- table: nc_storedassessment 
--

alter table nc_storedassessment add constraint refnc_assessment751 
    foreign key (assessmentid)
    references nc_assessment(assessmentid)
;

alter table nc_storedassessment add constraint refnc_expsegment1481 
    foreign key (segmentid, componentid, nc_experiment_uniqueid, subjectid)
    references nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid)
;

alter table nc_storedassessment add constraint refnc_assessmentinformant1771 
    foreign key (informantrelation)
    references nc_assessmentinformant(informantrelation)
;

alter table nc_storedassessment add constraint refnc_humansubject1791 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_storedassessment add constraint refnc_assessmentstatus1941 
    foreign key (status)
    references nc_assessmentstatus(status)
;

alter table nc_storedassessment add constraint refnc_tableid3571 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_storedassessment add constraint refnc_databaseuser3831 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_storedassessment add constraint refnc_databaseuser3841 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_storedassessment add constraint refnc_humansubject4321 
    foreign key (informantid)
    references nc_humansubject(subjectid)
;


-- 
-- table: nc_storedquery 
--

alter table nc_storedquery add constraint refnc_tableid4571 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_storedquery add constraint refnc_databaseuser4921 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_storedquery add constraint refnc_databaseuser4931 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_storedtuple 
--

alter table nc_storedtuple add constraint refnc_extendedtuple601 
    foreign key (extendedtupleid)
    references nc_extendedtuple(uniqueid)
;



-- alter table nc_storedtuple add constraint refnc_collectionequipment961 
--     foreign key (basetupleid)
--     references nc_collectionequipment(uniqueid)
-- ;

alter table nc_storedtuple add constraint refnc_databaseuser3271 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_storedtuple add constraint refnc_databaseuser3281 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_subjexperiment 
--

alter table nc_subjexperiment add constraint refnc_experiment71 
    foreign key (nc_experiment_uniqueid)
    references nc_experiment(uniqueid)
;

alter table nc_subjexperiment add constraint refnc_humansubject81 
    foreign key (subjectid)
    references nc_humansubject(subjectid)
;

alter table nc_subjexperiment add constraint refnc_researchgroup121 
    foreign key (nc_researchgroup_uniqueid)
    references nc_researchgroup(uniqueid)
;

alter table nc_subjexperiment add constraint refnc_databaseuser2441 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_subjexperiment add constraint refnc_databaseuser2451 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_subjexperiment add constraint refnc_tableid2761 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_tableid 
--

alter table nc_tableid add constraint refnc_schemaversion1581 
    foreign key (majorversion, minorversion)
    references nc_schemaversion(majorversion, minorversion)
;

alter table nc_tableid add constraint refnc_databaseuser3111 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tableid add constraint refnc_databaseuser3121 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_transformation 
--

alter table nc_transformation add constraint refnc_ontologyconcept1051 
    foreign key (ontologysource, conceptid)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_transformation add constraint refnc_tableid2801 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_transformation add constraint refnc_databaseuser2911 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_transformation add constraint refnc_databaseuser2921 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_transformationargument 
--

alter table nc_transformationargument add constraint refnc_transformation1011 
    foreign key (transformid)
    references nc_transformation(uniqueid)
;

alter table nc_transformationargument add constraint refnc_tableid2821 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_transformationargument add constraint refnc_databaseuser2891 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_transformationargument add constraint refnc_databaseuser2901 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_transformationlibrary 
--

alter table nc_transformationlibrary add constraint refnc_databaseuser4431 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_transformationlibrary add constraint refnc_databaseuser4441 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_transformationlibrary add constraint refnc_tableid4471 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_transformeddata 
--

alter table nc_transformeddata add constraint refnc_deriveddata1191 
    foreign key (nc_researchdata_uniqueid)
    references nc_deriveddata(uniqueid)
;

alter table nc_transformeddata add constraint refnc_executedtransform1201 
    foreign key (nc_executedtransform_uniqueid)
    references nc_executedtransform(uniqueid)
;

alter table nc_transformeddata add constraint refnc_tableid2881 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_transformeddata add constraint refnc_databaseuser2971 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_transformeddata add constraint refnc_databaseuser2981 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupleaccess 
--

alter table nc_tupleaccess add constraint refnc_databaseuser571 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleaccess add constraint refnc_databaseuser581 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleaccess add constraint refnc_databaseuser2471 
    foreign key (grantor)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleaccess add constraint refnc_databaseuser2481 
    foreign key (grantee)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupleboolean 
--

alter table nc_tupleboolean add constraint refnc_tupledata711 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;

alter table nc_tupleboolean add constraint refnc_tuplecolumns1401 
   foreign key (extendedtupleid, columnname, columntype)
   references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;

--alter table nc_tupleboolean add constraint refnc_storedtuple1441 
--    foreign key (basetableid, extendedtupleid)
--    references nc_storedtuple(basetableid, extendedtupleid)
--;

alter table nc_tupleboolean add constraint refnc_databaseuser3211 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleboolean add constraint refnc_databaseuser3221 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupleclass 
--

alter table nc_tupleclass add constraint refnc_tableid3191 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_tupleclass add constraint refnc_databaseuser3371 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleclass add constraint refnc_databaseuser3381 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tuplecolumns 
--

alter table nc_tuplecolumns add constraint refnc_extendedtuple641 
    foreign key (extendedtupleid)
    references nc_extendedtuple(uniqueid)
;

alter table nc_tuplecolumns add constraint refnc_ontologyconcept1221 
    foreign key (columnontology, columnconcept)
    references nc_ontologyconcept(ontologysource, conceptid)
;

alter table nc_tuplecolumns add constraint refnc_measurementunit1751 
    foreign key (measurementsystem, measurementunit)
    references nc_measurementunit(measurementsystem, unit)
;

alter table nc_tuplecolumns add constraint refnc_tableid3151 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_tuplecolumns add constraint refnc_databaseuser3331 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tuplecolumns add constraint refnc_databaseuser3341 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupledata 
--

alter table nc_tupledata add constraint refnc_tuplecolumns651 
    foreign key (extendedtupleid, columnname, columntype)
    references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;

-- alter table nc_tupledata add constraint refnc_storedtuple661 
--     foreign key (basetableid, extendedtupleid)
--     references nc_storedtuple(basetableid, extendedtupleid)
-- ;

alter table nc_tupledata add constraint refnc_tableid3161 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_tupledata add constraint refnc_databaseuser3291 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupledata add constraint refnc_databaseuser3301 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tuplefloat 
--

alter table nc_tuplefloat add constraint refnc_tupledata741 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;

alter table nc_tuplefloat add constraint refnc_tuplecolumns1421 
    foreign key (extendedtupleid, columnname, columntype)
    references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;

-- alter table nc_tuplefloat add constraint refnc_storedtuple1461 
--     foreign key (basetableid, extendedtupleid)
--     references nc_storedtuple(basetableid, extendedtupleid)
-- ;

alter table nc_tuplefloat add constraint refnc_databaseuser3231 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tuplefloat add constraint refnc_databaseuser3241 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupleinteger 
--

alter table nc_tupleinteger add constraint refnc_tupledata731 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;

alter table nc_tupleinteger add constraint refnc_tuplecolumns1411 
    foreign key (extendedtupleid, columnname, columntype)
    references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;

-- alter table nc_tupleinteger add constraint refnc_storedtuple1451 
--     foreign key (basetableid, extendedtupleid)
--     references nc_storedtuple(basetableid, extendedtupleid)
-- ;

alter table nc_tupleinteger add constraint refnc_databaseuser3251 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupleinteger add constraint refnc_databaseuser3261 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tuplesubclass 
--

alter table nc_tuplesubclass add constraint refnc_tupleclass621 
    foreign key (tupleclass)
    references nc_tupleclass(tupleclass)
;

alter table nc_tuplesubclass add constraint refnc_tableid3181 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_tuplesubclass add constraint refnc_databaseuser3391 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tuplesubclass add constraint refnc_databaseuser3401 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_tupletimestamp 
--

alter table nc_tupletimestamp add constraint refnc_tupledata4251 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;

alter table nc_tupletimestamp add constraint refnc_tableid4261 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_tupletimestamp add constraint refnc_databaseuser4271 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tupletimestamp add constraint refnc_databaseuser4291 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

-- alter table nc_tupletimestamp add constraint refnc_storedtuple4301 
--     foreign key (basetableid, extendedtupleid)
--     references nc_storedtuple(basetableid, extendedtupleid)
-- ;

alter table nc_tupletimestamp add constraint refnc_tuplecolumns4311 
    foreign key (extendedtupleid, columnname, columntype)
    references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;


-- 
-- table: nc_tuplevarchar 
--

alter table nc_tuplevarchar add constraint refnc_tupledata721 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;

alter table nc_tuplevarchar add constraint refnc_tuplecolumns1431 
    foreign key (extendedtupleid, columnname, columntype)
    references nc_tuplecolumns(extendedtupleid, columnname, columntype)
;

-- alter table nc_tuplevarchar add constraint refnc_storedtuple1471 
--     foreign key (basetableid, extendedtupleid)
--     references nc_storedtuple(basetableid, extendedtupleid)
-- ;

alter table nc_tuplevarchar add constraint refnc_databaseuser3311 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_tuplevarchar add constraint refnc_databaseuser3321 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_updatelog 
--

alter table nc_updatelog add constraint refnc_databaseuser2681 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_usedargument 
--

alter table nc_usedargument add constraint refnc_executedtransform1061 
    foreign key (nc_executedtransform_uniqueid)
    references nc_executedtransform(uniqueid)
;

alter table nc_usedargument add constraint refnc_transformationargume1071 
    foreign key (transformationargid)
    references nc_transformationargument(uniqueid)
;

alter table nc_usedargument add constraint refnc_researchdata1161 
    foreign key (uniqueid)
    references nc_researchdata(uniqueid)
;

alter table nc_usedargument add constraint refnc_tableid2841 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_usedargument add constraint refnc_databaseuser3011 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_usedargument add constraint refnc_databaseuser3021 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_usedlibrary 
--

alter table nc_usedlibrary add constraint refnc_executedtransform4341 
    foreign key (executedtransformid)
    references nc_executedtransform(uniqueid)
;

alter table nc_usedlibrary add constraint refnc_transformationlibrar4361 
    foreign key (libraryid)
    references nc_transformationlibrary(uniqueid)
;

alter table nc_usedlibrary add constraint refnc_databaseuser4411 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_usedlibrary add constraint refnc_databaseuser4421 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;

alter table nc_usedlibrary add constraint refnc_tableid4481 
    foreign key (tableid)
    references nc_tableid(tableid)
;


-- 
-- table: nc_userclass 
--

alter table nc_userclass add constraint refnc_tableid4541 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_userclass add constraint refnc_databaseuser5001 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_userclass add constraint refnc_databaseuser5011 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_usergroup 
--

alter table nc_usergroup add constraint refnc_databaseuser461 
    foreign key (userid)
    references nc_databaseuser(uniqueid)
;

alter table nc_usergroup add constraint refnc_databaseuser471 
    foreign key (groupid)
    references nc_databaseuser(uniqueid)
;

alter table nc_usergroup add constraint refnc_tableid4551 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_usergroup add constraint refnc_databaseuser5021 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_usergroup add constraint refnc_databaseuser5031 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_userstatus 
--

alter table nc_userstatus add constraint refnc_tableid4561 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_userstatus add constraint refnc_databaseuser5041 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_userstatus add constraint refnc_databaseuser5051 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_validationmethod 
--

alter table nc_validationmethod add constraint refnc_tableid3541 
    foreign key (tableid)
    references nc_tableid(tableid)
;

alter table nc_validationmethod add constraint refnc_databaseuser4011 
    foreign key (owner)
    references nc_databaseuser(uniqueid)
;

alter table nc_validationmethod add constraint refnc_databaseuser4021 
    foreign key (moduser)
    references nc_databaseuser(uniqueid)
;


-- 
-- table: nc_visittype 
--

alter table nc_visittype add constraint refnc_tableid3501 
    foreign key (tableid)
    references nc_tableid(tableid)
;


