package Iterator;
use strict;

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self = {};
    $self->{LIST} = shift;
    $self->{IDX} = 0;
    bless($self, $class);
    return $self;
}

sub has_next() {
    my $self = shift;
    my $ref = $self->{LIST};
    my @list = @{$ref};
    my $cur_idx = $self->{IDX};
    return ( $cur_idx < @list);
}


sub next() {
    my $self = shift;
    my @list = @{$self->{LIST}};
    my $cur_idx = $self->{IDX};
    $self->{IDX} = $cur_idx + 1;
    return $list[$cur_idx];
}

sub has_previous() {
    my $self = shift;
    my $cur_idx = $self->{IDX};
    return ( $cur_idx > 0);
}

sub previous() {
    my $self = shift;
    my @list = @{$self->{LIST}};
    my $cur_idx = $self->{IDX};
    $self->{IDX} = --$cur_idx;
    return $list[$cur_idx];
}


1;
