-- select create_static_data('fbirn_test','Burak','Ozyurt','iozyurt@ucsd.edu');


create or replace function get_num_rows(varchar) returns integer as '
declare
  table_name_in alias for $1;
  v_row_count integer;
  v_arow numeric;
  cur refcursor;
begin
   v_row_count := -1;
   open cur for execute  ''select count(*) from '' || table_name_in;
   fetch cur into v_row_count;
   close cur;	
   return v_row_count;
END;
' LANGUAGE plpgsql;

create or replace function create_static_data(varchar, varchar, varchar, varchar) returns integer as '
DECLARE
   database_user_name_in ALIAS for $1;
   first_name_in ALIAS for $2;
   last_name_in alias for $3;
   email_in alias for $4;

  v_owner_id integer := -1;
  v_mod_user_id integer := -1;
  v_table_id integer;
  v_majorversion integer := 1;
  v_minorversion integer := 0;
  v_count integer;
BEGIN

  if get_num_rows(''nc_tableid'') = 0 then 
  insert into nc_tableid (tablename,tableid,owner,modtime,moduser,
        majorversion,minorversion,description,uniqueid)
   select upper(tablename), nextval(''uid_seq''), -1, now(), -1, 
         v_majorversion, v_minorversion, null, -1 from pg_tables 
      where tablename like ''nc__%'' or tablename like ''bk__%'';
  end if;
 


  -- nc_userClass
  if get_num_rows(''nc_userclass'') = 0 then
  insert into nc_userclass(uniqueid, tableid, owner, modtime, moduser, userclass,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''researcher'',''researcher'',''researcher'');

insert into nc_userclass(uniqueid, tableid, owner, modtime, moduser, userclass,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data processing'',''data processing'',''data processing'');

insert into nc_userclass(uniqueid, tableid, owner, modtime, moduser, userclass,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''admin'',''admin'',''admin'');

insert into nc_userclass(uniqueid, tableid, owner, modtime, moduser, userclass,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data manager'',''data manager'',''data manager'');
  end if;

-- nc_userStatus
 if get_num_rows(''nc_userstatus'') = 0 then
insert into nc_userstatus (uniqueid, tableid, owner, modtime, moduser, userstatus,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''active'', ''active'', ''active'');

insert into nc_userstatus (uniqueid, tableid, owner, modtime, moduser, userstatus,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''inactive'', ''inactive'', ''inactive'');

insert into nc_userstatus (uniqueid, tableid, owner, modtime, moduser, userstatus,name,description)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''revoked'', ''revoked'', ''revoked'');
 end if;

    v_owner_id := get_database_user_id(database_user_name_in);
    if v_owner_id < 0 then
      v_owner_id := create_birn_user(database_user_name_in, database_user_name_in, 
         first_name_in, last_name_in, email_in, database_user_name_in, ''admin'', -1);
    end if;

    if v_owner_id < 0 then
         raise exception ''error in create_birn_user!'';
    end if;

-- add missing nc_tableid records
insert into nc_tableid (tablename,tableid,owner,modtime,moduser,
        majorversion,minorversion,description,uniqueid)
 select upper(tablename), nextval(''uid_seq''), v_owner_id, now(), v_owner_id, 
         1, 0, null, -1 from pg_tables 
    where (tablename like ''nc__%'' or tablename like ''bk__%'') and 
    upper(tablename) not in (select tablename from nc_tableid);

  v_mod_user_id := v_owner_id;
  update nc_tableid set owner = v_owner_id, moduser = v_owner_id, uniqueid = tableid
     where owner = -1;

  update nc_userclass  set owner = v_owner_id, moduser = v_owner_id
     where owner = -1;

  update nc_userstatus  set owner = v_owner_id, moduser = v_owner_id where owner = -1;


--nc_schemaversion
 if get_num_rows(''nc_schemaversion'') = 0 then 
insert into nc_schemaversion (majorversion,minorversion,uniqueid,tableid,owner,modtime,moduser,releasedate,description)
values(v_majorversion, v_minorversion, nextval(''uid_seq''), get_table_id(''nc_schemaversion''), 
  v_owner_id, now(), v_mod_user_id, now(), null);
 end if; 
     
-- NC_ANIMALSPECIES
 if get_num_rows(''nc_animalspecies'') = 0 then 
insert into nc_animalspecies (uniqueid,tableid,owner,modtime,moduser,name,strain,latinname,description) 
values(nextval(''uid_seq''),get_table_id(''nc_animalspecies''), v_owner_id, now(), 
  v_owner_id, ''researchSubject'',''human'',NULL,NULL);
 end if;

-- nc_tupleClass
if get_num_rows(''nc_tupleclass'') = 0 then 
 insert into nc_tupleclass (tupleclass,uniqueid,tableid,owner,modtime,moduser)
 values(''nc_researchdata'',nextval(''uid_seq''), get_table_id(''nc_tupleclass''), v_owner_id, 
    now(), v_mod_user_id );
end if;

if get_num_rows(''nc_tuplesubclass'') = 0 then 
 insert into nc_tuplesubclass (tuplesubclass, tupleclass,uniqueid,tableid,owner,modtime,moduser)
 values(''nc_analysisresult'', ''nc_researchdata'',nextval(''uid_seq''), get_table_id(''nc_tupleclass''), v_owner_id, 
    now(), v_mod_user_id );
end if;


-- nc_researchGroupType
if get_num_rows(''nc_researchgrouptype'') = 0 then 
v_table_id := get_table_id(''nc_researchgrouptype'');
insert into nc_researchgrouptype (uniqueid,tableid,owner,modtime,moduser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, now(), v_mod_user_id, 
   ''control'', NULL); 

insert into nc_researchgrouptype (uniqueid,tableid,owner,modtime,moduser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, now(), v_mod_user_id, 
   ''healthy'', NULL); 

insert into nc_researchgrouptype (uniqueid,tableid,owner,modtime,moduser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, now(), v_mod_user_id, 
   ''experimental'', NULL);

insert into nc_researchgrouptype (uniqueid,tableid,owner,modtime,moduser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, now(), v_mod_user_id, ''patient'', null);
end if;

--nc_visitType
if get_num_rows(''nc_visittype'') = 0 then 
v_table_id := get_table_id(''nc_visittype'');
 insert into nc_visittype(visittype,uniqueid,tableid,owner,modtime,moduser,description) 
  values(''screening'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
  ''screening potential subjects for a experiment'');
  insert into nc_visittype (visittype,uniqueid,tableid,owner,modtime,moduser,description) 
   values(''baseline'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
   ''baseline for a experiment'');
   insert into nc_visittype (visittype,uniqueid,tableid,owner,modtime,moduser,description) 
    values(''MRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
     ''non-functional MRI scanning'');

   insert into nc_visittype (visittype,uniqueid,tableid,owner,modtime,moduser,description) 
     values(''fMRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
     ''functional MRI scanning'');
   insert into nc_visittype (visittype,uniqueid,tableid,owner,modtime,moduser,description) 
   values(''clinical visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), 
     v_mod_user_id, ''clinical visit'');
    insert into nc_visittype (visittype,uniqueid,tableid,owner,modtime,moduser,description) 
    values(''follow up visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), 
      v_mod_user_id, ''follow up visit'');
end if;

if get_num_rows(''nc_assessmentstatus'') = 0 then 
--nc_assessmentStatus
v_table_id := get_table_id(''nc_assessmentStatus'');
insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''000'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''data not usable'', ''data quality has not verified, data is not usable'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''110'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry incomplete data'', ''one entry incomplete data'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''119'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry complete data'', ''one entry complete data'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''120'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries with different score values incomplete data'', ''two entries with different score values incomplete data'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''122'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries the same score values, incomplete data'', ''two entries the same score values, incomplete data'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''124'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries with the same score values, complete data'', ''two entries with the same score values, complete data'');

insert into nc_assessmentstatus(status, tableid, uniqueid, owner, modtime, moduser, name, description)
values(''129'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry incomplete data'', ''one entry incomplete data'');

end if;

if get_num_rows(''nc_ontologysource'') = 0 then 
insert into nc_ontologysource(ontologysource, tableid, uniqueid, owner, modtime, moduser, sourceuri, description)
values(''UNKNOWN'', get_table_id(''nc_ontologySource''), nextval(''uid_seq''), v_owner_id, now(), v_owner_id, null, '' '');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, 
         owner, modtime, moduser, ontologypath)
      values(''UNKNOWN'', ''9999'', ''to be determined'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);
end if;

if get_num_rows(''nc_assessmentinformant'') = 0 then 
v_table_id := get_table_id(''nc_assessmentinformant'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9900'', ''unknown relationship'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);
           
insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''unknown relationship'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9900'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9901'', ''self'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''self'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9901'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9902'', ''husband'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''husband'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9902'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9903'', ''wife'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''wife'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9903'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9904'', ''mother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''mother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9904'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9905'', ''father'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''father'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9905'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9906'', ''mother-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''mother-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9906'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9907'', ''father-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''father-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9907'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9908'', ''sister'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''sister'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9908'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9909'', ''brother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''brother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9909'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9910'', ''sister-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''sister-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9910'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9911'', ''brother-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''brother-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9911'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9912'', ''grandmother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''grandmother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9912'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9913'', ''grandfather'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''grandfather'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9913'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9914'', ''granddaughter'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''granddaughter'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9914'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9915'', ''grandson'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''grandson'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9915'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9916'', ''daughter'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''daughter'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9916'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9917'', ''son'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''son'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9917'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9918'', ''daughter-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''daughter-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9918'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9919'', ''son-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''son-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9919'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9920'', ''aunt'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''aunt'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9920'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9921'', ''uncle'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''uncle'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9921'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9922'', ''niece'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''niece'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9922'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9923'', ''nephew'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''nephew'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9923'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9924'', ''colleague'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''colleague'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9924'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9925'', ''roommate'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''roommate'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9925'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9926'', ''friend'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''friend'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9926'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9927'', ''health professional'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''health professional'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9927'');

-----
insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9928'', ''associate'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''associate'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9928'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9929'', ''cousin'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''cousin'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9929'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9930'', ''partner'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''partner'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9930'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9931'', ''guardian'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''guardian'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9931'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9932'', ''other relative'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''other relative'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9932'');

insert into nc_ontologyconcept(ontologysource,conceptid,concept,tableid, uniqueid, owner, modtime, moduser, ontologypath)
values(''UNKNOWN'', ''9933'', ''medical record'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(informantrelation, 
tableid, uniqueid, owner, modtime, moduser, ontologysource, conceptid)
values(''medical record'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9933'');
end if;


--nc_dataClassification
delete from nc_dataClassification;
v_table_id := get_table_id(''nc_dataclassification'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''No data entered'', ''No data entered'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Subject declined to answer the question'', ''Subject declined to answer the question'');


insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Interviewer forgot to ask the question'', ''Interviewer forgot to ask the question'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Interviewer deferred the question'', ''Interviewer deferred the question'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Question is excluded from the protocol'', ''Question is excluded from the protocol'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Question is not applicable to the subject'', ''Question is not applicable to the subject'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Answer is not intelligible'', ''Answer is not intelligible'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Answer is unknown to the informant'', ''Answer is unknown to the informant'');

insert into nc_dataclassification(tableid, uniqueid, owner, modtime, moduser, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Missing Value'', ''Missing Value'');

if get_num_rows(''nc_protocol'') = 0 then
insert into nc_protocol(protocolversion, protocolid, uniqueid, tableid, owner, 
        modtime, moduser, name, description)
      values(1, ''Subjects screening protocol'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, 
        now(), v_owner_id, ''Subject screening protocol'', NULL); 

end if;

   return v_owner_id;
END;
' LANGUAGE plpgsql;
