
-- select create_static_data('fbirn_test', 'Burak', 'Ozyurt', 'iozyurt@ucsd.edu');


create or replace function create_tableids() returns integer as '
DECLARE
   v_MAJORVERSION integer := 1;
   v_MINORVERSION integer := 0;
BEGIN
 insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,
        MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select upper(tablename), nextval(''uid_seq''), -1, now(), -1, 
         v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables 
      where tablename like ''nc__%'' or tablename like ''bk__%'';

 return 0;
END;
' LANGUAGE plpgsql;


create or replace function get_num_rows(varchar) returns integer as '
declare
  table_name_in alias for $1;
  v_row_count integer;
  v_arow numeric;
  cur refcursor;
begin
   v_row_count := -1;
   open cur for execute  ''select count(*) from '' || table_name_in;
   fetch cur into v_row_count;
   close cur;	
   return v_row_count;
END;
' LANGUAGE plpgsql;


create or replace function create_static_data(varchar, varchar, varchar, varchar) returns integer as '
DECLARE
   database_user_name_in ALIAS for $1;
   first_name_in ALIAS for $2;
   last_name_in alias for $3;
   email_in alias for $4;

  v_owner_id integer := -1;
  v_mod_user_id integer := -1;
  v_table_id integer;
  v_MAJORVERSION integer := 1;
  v_MINORVERSION integer := 0;
  v_count integer;
BEGIN

  if get_num_rows(''nc_tableid'') = 0 then 
  insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,
        MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select upper(tablename), nextval(''uid_seq''), -1, now(), -1, 
         v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables 
      where tablename like ''nc__%'' or tablename like ''bk__%'';
  end if;
 

  -- nc_userClass
  if get_num_rows(''nc_userclass'') = 0 then
  insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''researcher'',''researcher'',''researcher'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data processing'',''data processing'',''data processing'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''admin'',''admin'',''admin'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data manager'',''data manager'',''data manager'');
  end if;

-- nc_userStatus
 if get_num_rows(''nc_userstatus'') = 0 then
insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''active'', ''active'', ''active'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''inactive'', ''inactive'', ''inactive'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''revoked'', ''revoked'', ''revoked'');
 end if;

    v_owner_id := get_database_user_id(database_user_name_in);
    if v_owner_id < 0 then
      v_owner_id := create_birn_user(database_user_name_in, database_user_name_in, 
         first_name_in, last_name_in, email_in, database_user_name_in, ''admin'', -1);
    end if;

    if v_owner_id < 0 then
         raise exception "error in create_birn_user!";
    end if;



--nc_schemaversion
 if get_num_rows(''nc_schemaversion'') = 0 then 
insert into nc_schemaVersion (MAJORVERSION,MINORVERSION,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,RELEASEDATE,DESCRIPTION)
values(v_MAJORVERSION, v_MINORVERSION, nextval(''uid_seq''), get_table_id(''nc_schemaVersion''), 
  v_owner_id, NOW(), v_mod_user_id, now(), NULL);
 end if; 
     
-- NC_ANIMALSPECIES
 if get_num_rows(''nc_animalspecies'') = 0 then 
insert into NC_ANIMALSPECIES (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,NAME,STRAIN,LATINNAME,DESCRIPTION) 
values(nextval(''uid_seq''),get_table_id(''NC_ANIMALSPECIES''), v_owner_id, now(), 
  v_owner_id, ''researchSubject'',''human'',NULL,NULL);
 end if;

-- nc_tupleClass
if get_num_rows(''nc_tupleclass'') = 0 then 
 insert into nc_tupleClass (TUPLECLASS,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER)
 values(''researchData'',nextval(''uid_seq''), get_table_id(''nc_tupleClass''), v_owner_id, 
    NOW(), v_mod_user_id );
end if;


-- nc_researchGroupType
if get_num_rows(''nc_researchgrouptype'') = 0 then 
v_table_id := get_table_id(''nc_researchgrouptype'');
insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
   ''control'', NULL); 

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
   ''healthy'', NULL); 

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
   ''experimental'', NULL);

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, ''patient'', NULL);
end if;

--nc_visitType
if get_num_rows(''nc_visittype'') = 0 then 
v_table_id := get_table_id(''NC_VISITTYPE'');
 insert into NC_VISITTYPE(VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
  values(''screening'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
  ''screening potential subjects for a experiment'');
  insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
   values(''baseline'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
   ''baseline for a experiment'');
   insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
    values(''MRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
     ''non-functional MRI scanning'');

   insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
     values(''fMRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
     ''functional MRI scanning'');
   insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
   values(''clinical visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), 
     v_mod_user_id, ''clinical visit'');
    insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
    values(''follow up visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), 
      v_mod_user_id, ''follow up visit'');
end if;

   return 0;
END;
' LANGUAGE plpgsql;


-- NC_TABLEID
insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select tablename, nextval(''uid_seq''), -1, now(), -1, v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables where tablename like ''nc__%'' or tablename like ''bk__%'';


create or replace function create_static_data(varchar, varchar, varchar, varchar) returns integer as '
DECLARE
   database_user_name_in ALIAS for $1;
   first_name_in ALIAS for $2;
   last_name_in alias for $3;
   email_in alias for $4;

  v_owner_id integer := -1;
  v_mod_user_id integer := -1;
  v_table_id integer;
  v_MAJORVERSION integer := 1;
  v_MINORVERSION integer := 0;
  v_count integer;
BEGIN

-- NC_TABLEID
insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select tablename, nextval(''uid_seq''), -1, now(), -1, v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables where tablename like ''nc__%'' or tablename like ''bk__%'';

-- nc_userClass
insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''researcher'',''researcher'',''researcher'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data processing'',''data processing'',''data processing'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''admin'',''admin'',''admin'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data manager'',''data manager'',''data manager'');

-- nc_userStatus
insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''active'', ''active'', ''active'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''inactive'', ''inactive'', ''inactive'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''revoked'', ''revoked'', ''revoked'');



   v_owner_id := create_birn_user(database_user_name_in, database_user_name_in, 
   first_name_in, last_name_in, email_in, database_user_name_in, ''admin'', -1);

if v_owner_id < 0 then
   raise exception "error in create_birn_user!";
end if;

v_mod_user_id := v_owner_id;
update nc_tableID set owner = v_owner_id, moduser = v_owner_id, uniqueid = tableid
where owner = -1;

update nc_userClass
set owner = v_owner_id, moduser = v_owner_id
where owner = -1;

update nc_userStatus
set owner = v_owner_id, moduser = v_owner_id
where owner = -1;

--nc_schemaversion
insert into nc_schemaVersion (MAJORVERSION,MINORVERSION,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,RELEASEDATE,DESCRIPTION)
values(v_MAJORVERSION, v_MINORVERSION, nextval(''uid_seq''), get_table_id(''nc_schemaVersion''), v_owner_id, NOW(), v_mod_user_id, now(), NULL);
     
-- NC_ANIMALSPECIES
insert into NC_ANIMALSPECIES (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,NAME,STRAIN,LATINNAME,DESCRIPTION) 
values(nextval(''uid_seq''),get_table_id(''NC_ANIMALSPECIES''), v_owner_id, now(), v_owner_id, ''researchSubject'',''human'',NULL,NULL);

-- nc_tupleClass
insert into nc_tupleClass (TUPLECLASS,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER)
values(''researchData'',nextval(''uid_seq''), get_table_id(''nc_tupleClass''), v_owner_id, NOW(), v_mod_user_id );

-- nc_researchGroupType
v_table_id := get_table_id(''nc_researchGroupType'');
insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, ''control'', NULL); 

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, ''healthy'', NULL); 

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, ''experimental'', NULL);

insert into nc_researchGroupType (uniqueID,tableID,owner,modTime,modUser,name, description)
  values( nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, ''patient'', NULL);

--nc_visitType
v_table_id := get_table_id(''NC_VISITTYPE'');
insert into NC_VISITTYPE(VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''screening'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''screening potential subjects for a experiment'');
insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''baseline'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''baseline for a experiment'');
insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''MRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''non-functional MRI scanning'');
insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''fMRI scan'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''functional MRI scanning'');
insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''clinical visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''clinical visit'');
insert into NC_VISITTYPE (VISITTYPE,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,DESCRIPTION) 
values(''follow up visit'', nextval(''uid_seq''), v_table_id, v_owner_id, NOW(), v_mod_user_id, 
''follow up visit'');

--nc_assessmentStatus
v_table_id := get_table_id(''nc_assessmentStatus'');
insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''000'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''data not usable'', ''data quality has not verified, data is not usable'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''110'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry incomplete data'', ''one entry incomplete data'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''119'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry complete data'', ''one entry complete data'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''120'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries with different score values incomplete data'', ''two entries with different score values incomplete data'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''122'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries the same score values, incomplete data'', ''two entries the same score values, incomplete data'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''124'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''two entries with the same score values, complete data'', ''two entries with the same score values, complete data'');

insert into nc_assessmentStatus(STATUS, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, NAME, DESCRIPTION)
values(''129'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''one entry incomplete data'', ''one entry incomplete data'');

--nc_ontologySource
insert into nc_ontologySource(ONTOLOGYSOURCE, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, SOURCEURI, DESCRIPTION)
values(''UNKNOWN'', get_table_id(''nc_ontologySource''), nextval(''uid_seq''), v_owner_id, now(), v_owner_id, null, '' '');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, 
         OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
      values(''UNKNOWN'', ''9999'', ''to be determined'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

--nc_assessmentinformant
v_table_id := get_table_id(''nc_assessmentinformant'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9900'', ''unknown relationship'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);
           
insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''unknown relationship'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9900'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9901'', ''self'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''self'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9901'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9902'', ''husband'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''husband'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9902'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9903'', ''wife'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''wife'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9903'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9904'', ''mother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''mother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9904'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9905'', ''father'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''father'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9905'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9906'', ''mother-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''mother-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9906'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9907'', ''father-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''father-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9907'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9908'', ''sister'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''sister'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9908'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9909'', ''brother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''brother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9909'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9910'', ''sister-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''sister-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9910'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9911'', ''brother-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''brother-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9911'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9912'', ''grandmother'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''grandmother'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9912'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9913'', ''grandfather'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''grandfather'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9913'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9914'', ''granddaughter'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''granddaughter'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9914'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9915'', ''grandson'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''grandson'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9915'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9916'', ''daughter'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''daughter'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9916'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9917'', ''son'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''son'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9917'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9918'', ''daughter-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''daughter-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9918'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9919'', ''son-in-law'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''son-in-law'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9919'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9920'', ''aunt'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''aunt'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9920'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9921'', ''uncle'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''uncle'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9921'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9922'', ''niece'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''niece'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9922'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9923'', ''nephew'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''nephew'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9923'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9924'', ''colleague'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''colleague'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9924'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9925'', ''roommate'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''roommate'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9925'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9926'', ''friend'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''friend'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9926'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9927'', ''health professional'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''health professional'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9927'');

-----
insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9928'', ''associate'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''associate'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9928'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9929'', ''cousin'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''cousin'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9929'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9930'', ''partner'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''partner'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9930'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9931'', ''guardian'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''guardian'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9931'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9932'', ''other relative'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''other relative'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9932'');

insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UNKNOWN'', ''9933'', ''medical record'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);

insert into nc_assessmentinformant(INFORMANTRELATION, 
TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYSOURCE, CONCEPTID)
values(''medical record'', v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''UNKNOWN'', ''9933'');



--nc_dataClassification
v_table_id := get_table_id(''nc_dataClassification'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''No data entered'', ''No data entered'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Subject declined to answer the question'', ''Subject declined to answer the question'');


insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Interviewer forgot to ask the question'', ''Interviewer forgot to ask the question'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Interviewer deferred the question'', ''Interviewer deferred the question'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Question is excluded from the protocol'', ''Question is excluded from the protocol'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Question is not applicable to the subject'', ''Question is not applicable to the subject'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Answer is not intelligible'', ''Answer is not intelligible'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Answer is unknown to the informant'', ''Answer is unknown to the informant'');

insert into nc_dataclassification(TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, name, description)
values(v_table_id, nextval(''uid_seq''), v_owner_id, now(), v_owner_id, ''Missing Value'', ''Missing Value'');

--nc_protocol
insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, 
        MODTIME, MODUSER, name, DESCRIPTION)
      values(1, ''Subjects screening protocol'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, 
        now(), v_owner_id, ''Subject screening protocol'', NULL); 

return v_owner_id;
END;
' LANGUAGE plpgsql;
