create or replace FUNCTION get_table_id(varchar) returns numeric AS '
declare
 uname_in alias for $1;
 v_id numeric;
 v_return numeric;
 user_cur CURSOR FOR SELECT tableID FROM  nc_tableID
    WHERE tablename = UPPER(uname_in);
BEGIN
 OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF v_id IS NULL THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
' LANGUAGE plpgsql;


create or replace FUNCTION get_database_user_id(varchar) returns numeric AS '
declare
 uname_in alias for $1;
 v_id numeric;
 v_return numeric;
 user_cur CURSOR FOR SELECT min(UNIQUEID) FROM  nc_databaseUser
    WHERE UPPER(NAME) = UPPER(uname_in) and isgroup = false;
BEGIN
OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF v_id IS NULL THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
' LANGUAGE plpgsql;


create or replace function get_person_id(varchar, varchar, varchar) returns numeric AS '
declare
 first_name_in alias for $1;
 last_name_in alias for $2;
 email_in alias for $3;
 v_id numeric;
 v_return numeric;
 user_cur CURSOR FOR SELECT min(uniqueid) FROM  nc_person
    WHERE upper(first_name) = upper( first_name_in )
    and upper(last_name) = upper(last_name_in)
    and upper(email) = upper(email_in);
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF v_id is NULL THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
' LANGUAGE plpgsql;




create or replace function get_userstatus_id(varchar) returns numeric AS '
declare
  userstatus_in alias for $1;
  v_id numeric := -1;
  v_return numeric;
  user_cur CURSOR FOR SELECT max(uniqueid) FROM  nc_userstatus
     WHERE upper(userstatus) = upper( userstatus_in );
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF v_id is NULL THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  -- raise notice '' v_return %'', v_return;
  return v_return;
END;
' LANGUAGE plpgsql;

create or replace function get_userclass_id(varchar) returns numeric AS '
declare
  uclass_in alias for $1;
  v_id numeric := -1;
  v_return numeric;
  user_cur CURSOR FOR SELECT max(uniqueid) FROM  nc_userclass
    WHERE upper(userclass) = upper( uclass_in );
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF v_id is NULL THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  -- raise notice '' v_return %'', v_return;
  return v_return;
END;
' LANGUAGE plpgsql;

-- select create_birn_user('fbirn_test', 'fbirn_test', 
--        'Burak', 'Ozyurt', 'iozyurt@ucsd.edu', 'fbirn_test', 'admin', -1);

create or replace FUNCTION  create_birn_user(varchar, varchar, varchar,
  varchar, varchar, varchar, varchar, numeric) returns numeric AS '
declare
  owner_name_in alias for $1;
  mod_user_in alias for $2;
  first_name_in alias for $3;
  last_name_in alias for $4;
  email_in alias for $5;
  db_user_name_in alias for $6;
  user_class_in alias for $7;
  group_id_in alias for $8;

 owner_id numeric;
 mod_user_id numeric;
 person_id numeric;
 db_user_id numeric;
 group_id numeric;
 v_table_id numeric;
BEGIN
  db_user_id := nextval(''uid_seq'');
  raise notice ''db_user_id:%'', db_user_id;
  if owner_name_in != db_user_name_in then
      owner_id := get_database_user_id(owner_name_in);
      mod_user_id :=  get_database_user_id(mod_user_in);
      IF owner_id < 0 OR mod_user_id < 0 THEN
         RETURN -1;
      END IF;
   else
      owner_id := db_user_id;
      mod_user_id := db_user_id;
   end if;

   person_id := get_person_id(first_name_in, last_name_in, email_in) ;
   raise notice ''person_id:%'', person_id;	
   
   v_table_id := get_table_id(''nc_person'');
   if person_id < 0 then
     person_id := nextval(''uid_seq'');
      raise notice ''new person_id:%'', person_id;
     insert into nc_person (UNIQUEID,TABLEID,OWNER,
        MODTIME,MODUSER,FIRST_NAME, LAST_NAME, EMAIL)
     values(person_id, v_table_id, owner_id, now(), 
        mod_user_id, first_name_in,
        last_name_in, email_in);
   end if;

   IF group_id_in < 0 THEN
     -- create a new group with the db_user_name_in ,
     -- create the user and assign to the newly created group
     group_id := nextval(''uid_seq'');
     raise notice ''new group_id :%'', group_id;
     insert into nc_databaseUser ( UNIQUEID,NAME,TABLEID,OWNER,MODTIME,
            MODUSER,USERCLASS,USERSTATUS, ISGROUP,PERSONID)
      values(group_id, lower(db_user_name_in), 
            get_table_id(''nc_databaseuser''), owner_id, now(), mod_user_id, 
            get_userclass_id(user_class_in),
            get_userstatus_id(''active''), true, person_id);
   else
     group_id := group_id_in ;
   end if;

   insert into nc_databaseUser ( UNIQUEID,NAME,TABLEID,OWNER,MODTIME,
            MODUSER,USERCLASS,USERSTATUS,
            ISGROUP,PERSONID)
   values(db_user_id, UPPER(db_user_name_in), 
         get_table_id(''nc_databaseuser''), owner_id, now(), 
           mod_user_id, 
           get_userclass_id(user_class_in),
           get_userstatus_id(''active''), false, person_id);

   INSERT INTO nc_usergroup (USERID,GROUPID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER)
   VALUES(db_user_id, group_id, nextval(''uid_seq''), 
         get_table_id(''nc_usergroup''), owner_id, 
         now(), mod_user_id);

   return db_user_id;
END;
' LANGUAGE plpgsql;

create or replace function create_static_data() returns integer as '
DECLARE

  v_owner_id integer := -1;
  v_mod_user_id integer := -1;
  v_table_id integer;
  v_MAJORVERSION integer := 1;
  v_MINORVERSION integer := 0;
  v_count integer;
BEGIN
-- NC_TABLEID
insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select tablename, nextval(''uid_seq''), -1, now(), -1, v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables where tablename like ''nc__%'' or tablename like ''bk__%'';
 return 1;
END;
' LANGUAGE plpgsql;
