drop table nc_assessmentinformant ;

create table nc_assessmentinformant(
    informantrelation    varchar(128)    not null,
    tableid              bigint    not null,
    uniqueid             bigint    not null,
    owner                bigint    not null,
    modtime timestamp not null,
    moduser              bigint    not null,
    ontologysource       varchar(128)    not null,
    conceptid            varchar(64)     not null,
    constraint nc_assessmentinformant_pk primary key (informantrelation) ,
    constraint nc_assessmentinformant_sk  unique (uniqueid, tableid) );

-- comment on column nc_assessmentinformant.informantrelation is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentinformant.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_assessmentinformant.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentinformant.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_assessmentinformant.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_assessmentinformant.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_assessmentinformant.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentinformant.conceptid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

