drop table nc_assessmenttimestamp ;

create table nc_assessmenttimestamp(
    tableid                       bigint    not null,
    nc_assessmentdata_uniqueid    bigint    not null,
    scoreorder                    bigint    not null,
    owner                         bigint    not null,
    modtime timestamp not null,
    moduser                       bigint    not null,
    textvalue                     varchar(255),
    textnormvalue                 varchar(255),
    comments                      text,
    datavalue                     timestamp(6),
    datanormvalue                 timestamp(6),
    storedassessmentid            bigint    not null,
    assessmentid                  bigint    not null,
    scorename                     varchar(128)    not null,
    scoretype                     varchar(64)     not null,
    isvalidated                   boolean      default false not null,
    isranked                      boolean      default false not null,
    subjectid                     varchar(64)     not null,
    entryid                       bigint,
    keyerid                       bigint,
    raterid                       bigint,
    classification                bigint,
    uniqueid                      bigint    not null,
    constraint nc_assessmenttimestamp_pk primary key (tableid, nc_assessmentdata_uniqueid) ,
    constraint nc_assessmenttimestamp_sk  unique (nc_assessmentdata_uniqueid, tableid) );

-- comment on column nc_assessmenttimestamp.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_assessmenttimestamp.nc_assessmentdata_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.scoreorder is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmenttimestamp.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_assessmenttimestamp.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.textvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmenttimestamp.textnormvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmenttimestamp.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_assessmenttimestamp.datavalue is 'the timestampdata domain is used to hold native timestamps.' ;

-- comment on column nc_assessmenttimestamp.datanormvalue is 'the timestampdata domain is used to hold native timestamps.' ;

-- comment on column nc_assessmenttimestamp.storedassessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.scorename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmenttimestamp.scoretype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_assessmenttimestamp.isvalidated is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmenttimestamp.isranked is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmenttimestamp.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_assessmenttimestamp.entryid is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmenttimestamp.keyerid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.raterid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.classification is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmenttimestamp.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

