drop table nc_compiler ;

create table nc_compiler(
    uniqueid           bigint    not null,
    tableid            bigint    not null,
    owner              bigint    not null,
    modtime timestamp not null,
    moduser            bigint    not null,
    compiler           varchar(128),
    compilerversion    varchar(64),
    description        text,
    constraint nc_compiler_pk primary key (uniqueid) ,
    constraint nc_compiler_sk  unique (uniqueid, tableid) );

-- comment on column nc_compiler.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_compiler.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_compiler.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_compiler.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_compiler.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_compiler.compiler is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_compiler.compilerversion is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_compiler.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

