drop table nc_databaseuser ;

create table nc_databaseuser(
    uniqueid      bigint    not null,
    name          varchar(128)    not null,
    tableid       bigint    not null,
    owner         bigint    not null,
    modtime timestamp not null,
    moduser       bigint    not null,
    userclass     bigint     default 0 not null,
    userstatus    bigint     default 0 not null,
    isgroup       boolean     not null,
    personid      bigint    not null,
    constraint nc_databaseuser_pk primary key (uniqueid) ,
    constraint nc_databaseuser_sk  unique (uniqueid, tableid) );

-- comment on column nc_databaseuser.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_databaseuser.name is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_databaseuser.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_databaseuser.owner is 'the owner column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (moduser) in the tuple (e.g. the pi''s graduate student researcher).' ;

-- comment on column nc_databaseuser.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_databaseuser.moduser is 'the moduser column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the owner column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (moduser) in the tuple (e.g. the pi''s graduate student researcher).' ;

-- comment on column nc_databaseuser.userclass is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_databaseuser.userstatus is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_databaseuser.isgroup is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_databaseuser.personid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

