drop table nc_dbcolumnunit ;

create table nc_dbcolumnunit(
    columntable          bigint    not null,
    columnname           varchar(200)    not null,
    measurementsystem    varchar(128)    not null,
    unit                 varchar(64)     not null,
    uniqueid             bigint    not null,
    tableid              bigint    not null,
    owner                bigint    not null,
    moduser              bigint    not null,
    modtime timestamp not null,
    constraint nc_dbcolumnunits_pk primary key (columntable, columnname, measurementsystem, unit) ,
    constraint nc_dbcolumnunits_sk  unique (uniqueid, tableid) );

-- comment on table nc_dbcolumnunit is 'the nc__dbcolumnunits table is the backing table that links all columns within the database to their default measurement units.' ;

-- comment on column nc_dbcolumnunit.columntable is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_dbcolumnunit.columnname is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_dbcolumnunit.measurementsystem is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_dbcolumnunit.unit is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_dbcolumnunit.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_dbcolumnunit.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_dbcolumnunit.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_dbcolumnunit.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_dbcolumnunit.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

