drop table nc_executedtransform ;

create table nc_executedtransform(
    uniqueid                    bigint    not null,
    tableid                     bigint    not null,
    owner                       bigint    not null,
    modtime timestamp not null,
    moduser                     bigint    not null,
    logicaltransformid          bigint    not null,
    nc_databaseuser_uniqueid    bigint    not null,
    machineid                   bigint    not null,
    time_stamp                  timestamp(6)     not null,
    compilerid                  bigint,
    constraint nc_executedtransform_pk primary key (uniqueid) ,
    constraint nc_executedtransform_sk  unique (uniqueid, tableid) );

-- comment on column nc_executedtransform.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_executedtransform.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_executedtransform.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_executedtransform.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_executedtransform.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_executedtransform.logicaltransformid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_executedtransform.sequencestep is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_executedtransform.nc_databaseuser_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_executedtransform.machineid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_executedtransform.time_stamp is 'the timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expcomponent).  the timestamp refers to the beginning (start) time for the object.' ;

-- comment on column nc_executedtransform.compilerid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

