drop table nc_expcondition ;

create table nc_expcondition(
    expmanipulationid    bigint    not null,
    tableid              bigint    not null,
    owner                bigint    not null,
    modtime timestamp not null,
    moduser              bigint    not null,
    extensionname        varchar(128)     default 'expcondition' not null,
    condition            varchar(128),
    description          text,
    ontologysource       varchar(128)    not null,
    conceptid            varchar(64)     not null,
    uniqueid             bigint,
    constraint nc_expcondition_pk primary key (expmanipulationid) ,
    constraint nc_expcondition_sk  unique (uniqueid, tableid) );

-- comment on column nc_expcondition.expmanipulationid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expcondition.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_expcondition.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expcondition.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_expcondition.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expcondition.extensionname is 'the extensionname column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  this should default to the name of the table.' ;

-- comment on column nc_expcondition.condition is 'the condition column holds the name of the manipulation (i.e. children of nc_expmanipulation - nc_expevent or nc_expcondition). this name should be descriptive if possible.  the condition name will be used in the generation of any stimulus files and analysis files.' ;

-- comment on column nc_expcondition.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_expcondition.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_expcondition.conceptid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_expcondition.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

