drop table nc_experiment ;

create table nc_experiment(
    uniqueid            bigint     not null,
    tableid             bigint     not null,
    owner               bigint     not null,
    modtime timestamp not null,
    moduser             bigint     not null,
    name                varchar(128)     not null,
    description         text,
    contactperson       bigint     not null,
    baseuri             varchar(2048),
    isregressiondata    boolean       default false,
    storagetype varchar(20) default 'local',
    -- 
    data_sharing_agreed bool default false,
    approved            bool default false,
    irb_flag            bool default false,
    irb_doc_loc         varchar(2048),
    contact_info_id     bigint,
    
    constraint nc_experiment_pk primary key (uniqueid) ,
    constraint nc_experiment_sk  unique (uniqueid, tableid) );

-- comment on column nc_experiment.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_experiment.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_experiment.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_experiment.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_experiment.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_experiment.name is 'textual name of the experiment.' ;

-- comment on column nc_experiment.description is 'dewscription of the experiment.' ;

-- comment on column nc_experiment.contactperson is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_experiment.baseuri is 'the root uri for the data from this experiment' ;

-- comment on column nc_experiment.isregressiondata is 'if flag is set to true, data is not real experimental data, rather it is a regression (or testing) data set' ;

