drop table nc_ontologyconcept ;

create table nc_ontologyconcept(
    ontologysource    varchar(128)     not null,
    conceptid         varchar(64)      not null,
    concept           varchar(128)     not null,
    uniqueid          bigint     not null,
    tableid           bigint     not null,
    owner             bigint     not null,
    modtime timestamp not null,
    moduser           bigint     not null,
    ontologypath      varchar(2048),
    constraint nc_ontologyconcept_pk primary key (ontologysource, conceptid) ,
    constraint nc_ontologyconcept_sk  unique (uniqueid, tableid) ,
    constraint nc_ontologyterm_uk_full  unique (ontologysource, conceptid, concept) );

-- comment on column nc_ontologyconcept.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_ontologyconcept.conceptid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_ontologyconcept.concept is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_ontologyconcept.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_ontologyconcept.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_ontologyconcept.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_ontologyconcept.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_ontologyconcept.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_ontologyconcept.ontologypath is 'the ontology path is the complete description of the hierarchy (from the root object in a terminological tree) to a specific ontological concept. this can be viewed as similar to a directory path.  following the unix path analogy, the separator for the ontology path shall be a: ''/''. an example of such a path is as follows for the cerebellar purkinje cell: /brain/cerebellum/cerebellar cortex/purkinje cell. it is important to note that hierarchies are dependent on the source ontology.  ' ;

