drop table nc_researchdata ;

create table nc_researchdata(
    uniqueid         bigint     not null,
    tableid          bigint     not null,
    owner            bigint     not null,
    modtime timestamp not null,
    moduser          bigint     not null,
    extensionname    varchar(128)      default 'researchdata' not null,
    datauri          varchar(2048),
    israw            boolean      not null,
    dataontology     varchar(128)     not null,
    dataclass        varchar(64)      not null,
    isbad            boolean       default false not null,
    constraint nc_researchdata_pk primary key (uniqueid) ,
    constraint nc_researchdata_sk  unique (uniqueid, tableid) );

-- comment on column nc_researchdata.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_researchdata.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_researchdata.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_researchdata.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_researchdata.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_researchdata.extensionname is 'the extensionname column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  this should default to the name of the table.' ;

-- comment on column nc_researchdata.datauri is 'the uri for the selected data (can be multiple files or just a single file)' ;

-- comment on column nc_researchdata.israw is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_researchdata.dataontology is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_researchdata.dataclass is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_researchdata.isbad is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

