drop table nc_storedassessment ;

create table nc_storedassessment(
    uniqueid                  bigint       not null,
    assessmentid              bigint       not null,
    tableid                   bigint       not null,
    owner                     bigint       not null,
    modtime timestamp not null,
    moduser                   bigint       not null,
    componentid               bigint       not null,
    nc_experiment_uniqueid    bigint       not null,
    segmentid                 bigint       not null,
    subjectid                 varchar(64),
    time_stamp                timestamp(6)        not null,
    informantid               varchar(64),
    informantrelation         varchar(128)       not null,
    isvalidated               boolean         default false not null,
    status                    varchar(64)        not null,
    ratorquality              varchar(128),
    istimeinterval            boolean         default false not null,
    timeinterval              double precision,
    constraint nc_storedassessment_pk primary key (uniqueid) ,
    constraint nc_storedassessment_sk  unique (uniqueid, tableid) );

-- comment on column nc_storedassessment.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedassessment.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedassessment.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_storedassessment.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_storedassessment.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_storedassessment.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_storedassessment.componentid is 'the sequenceid domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  the sequence begins with 1.' ;

-- comment on column nc_storedassessment.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedassessment.segmentid is 'the sequenceid domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  the sequence begins with 1.' ;

-- comment on column nc_storedassessment.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_storedassessment.time_stamp is 'the timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expcomponent).  the timestamp refers to the beginning (start) time for the object.' ;

-- comment on column nc_storedassessment.informantid is 'the investigator id for the research subject.' ;

-- comment on column nc_storedassessment.informantrelation is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_storedassessment.isvalidated is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_storedassessment.status is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_storedassessment.istimeinterval is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

