drop table nc_tableid ;

create table nc_tableid(
    tablename       varchar(200)    not null,
    uniqueid        bigint    not null,
    tableid         bigint    not null,
    owner           bigint    not null,
    modtime timestamp not null,
    moduser         bigint    not null,
    majorversion    bigint    not null,
    minorversion    bigint    not null,
    description     text,
    constraint nc_tableid_pk primary key (tablename) ,
    constraint nc_tableid_sk  unique (uniqueid, tableid) ,
    constraint nc_tableid_uk_tableid  unique (tableid) );

-- comment on column nc_tableid.tablename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_tableid.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tableid.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_tableid.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tableid.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_tableid.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_tableid.majorversion is 'the versionid domain is used to denote version identifiers. these identifiers can have major and minor revisions.' ;

-- comment on column nc_tableid.minorversion is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_tableid.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

