drop table nc_updatelog ;

create table nc_updatelog(
    uniqueid    bigint    not null,
    tableid     bigint    not null,
    modtime timestamp not null,
    moduser     bigint    not null,
    owner       bigint,
    comments    text,
    constraint nc_updatelog_pk primary key (uniqueid, tableid, modtime) );

-- comment on column nc_updatelog.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_updatelog.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_updatelog.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_updatelog.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_updatelog.owner is 'the owner column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (moduser) in the tuple (e.g. the pi''s graduate student researcher).' ;

-- comment on column nc_updatelog.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

