CREATE OR REPLACE FUNCTION nc_assessmenttimestamp_ins_upd() RETURNS trigger AS '
BEGIN
     new.uniqueid := new.nc_assessmentdata_uniqueid; 
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_assessmenttimestamp_ins_upd   before insert or update on nc_assessmenttimestamp  for each row   EXECUTE PROCEDURE nc_assessmenttimestamp_ins_upd();

CREATE OR REPLACE FUNCTION nc_assessmenttimestamp_insert() RETURNS trigger AS '
BEGIN
  -- RAISE NOTICE ''*** in nc_assessmenttimestamp_insert ***'';
  insert into nc_assessmentdata
    (tableid,uniqueid,scoreorder, owner,modtime,moduser,assessmentid,
     scorename, scoretype, textvalue, textnormvalue,
     encrypted, comments,nc_storedassessment_uniqueid,subjectid,
     isvalidated, isranked, entryid, keyerid, raterid, classification)
  values(new.tableid,
        new.nc_assessmentdata_uniqueid,
        new.scoreorder,
        new.owner,
        new.modtime,
        new.moduser,
        new.assessmentid,
        new.scorename,
        new.scoretype,
        new.textvalue,
        new.textnormvalue,
        false,
        new.comments,
        new.storedassessmentid,
        new.subjectid,
        new.isvalidated,
        new.isranked,
        new.entryid,
        new.keyerid, 
        new.raterid, 
        new.classification);
     -- RAISE NOTICE ''*** exiting nc_assessmenttimestamp_insert ***'';
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_assessmenttimestamp_insert  before insert on nc_assessmenttimestamp  for each row  EXECUTE PROCEDURE nc_assessmenttimestamp_insert();

CREATE OR REPLACE FUNCTION nc_assessmenttimestamp_update() RETURNS trigger AS '
BEGIN
    update nc_assessmentdata
    set owner = new.owner,
        modtime = new.modtime,
        moduser = new.moduser,
        assessmentid = new.assessmentid,
        scorename = new.scorename,
        scoretype = new.scoretype,
        textvalue = new.textvalue,
        textnormvalue = new.textnormvalue,
        comments = new.comments,
        nc_storedassessment_uniqueid = new.storedassessmentid,
        subjectid = new.subjectid,
        isvalidated = new.isvalidated,
        isranked = new.isranked,
        entryid = new.entryid,
        keyerid = new.keyerid, 
        raterid = new.raterid, 
        classification = new.classification
  where
     tableid = new.tableid and uniqueid = new.nc_assessmentdata_uniqueid
     and scoreorder = new.scoreorder;
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_assessmenttimestamp_update  after update on nc_assessmenttimestamp  for each row  EXECUTE PROCEDURE nc_assessmenttimestamp_update();

CREATE OR REPLACE FUNCTION nc_assessmenttimestamp_delete() RETURNS trigger AS '
BEGIN
 delete from nc_assessmentdata
 where
   tableid = old.tableid and uniqueid = old.nc_assessmentdata_uniqueid
     and scoreorder = old.scoreorder;
     return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_assessmenttimestamp_delete  after delete on nc_assessmenttimestamp   for each row  EXECUTE PROCEDURE nc_assessmenttimestamp_delete();

