create or replace function nc_tupleinteger_insert() returns trigger as '
begin
  insert into nc_tupledata
    ( tableid, uniqueid, owner,modtime, moduser,                             
 extendedtupleid, columnname, columntype, storedtupleid, textvalue, comments)  
  values(new.tableid,
    new.uniqueid,
    new.owner,
    new.modtime,
    new.moduser,                             
    new.extendedtupleid,                     
    new.columnname,                          
    new.columntype,                          
    new.storedtupleid,
    new.textvalue,                           
    new.comments);
    return new;
end;
' language plpgsql;

create trigger nc_tupleinteger_insert  before insert on nc_tupleinteger  for each row  execute procedure nc_tupleinteger_insert();

create or replace function nc_tupleinteger_update() returns trigger as '
begin
  update nc_tupledata
    set owner = new.owner,
        modtime = new.modtime,
        moduser = new.moduser,
        extendedtupleid = new.extendedtupleid,                     
        columnname = new.columnname,                          
        columntype = new.columntype,                          
        storedtupleid = new.storedtupleid,
        textvalue = new.textvalue,                           
        comments = new.comments
    where
      tableid = new.tableid and uniqueid = new.uniqueid;   
    return new; 
end;
' language plpgsql;

create trigger nc_tupleinteger_update  after update on nc_tupleinteger  for each row  execute procedure nc_tupleinteger_update();

create or replace function nc_tupleinteger_delete() returns trigger as '
begin
  delete from nc_tupledata
  where
    tableid = old.tableid and uniqueid = old.uniqueid;
  return new;
end;
' language plpgsql;

create trigger nc_tupleinteger_delete   after delete on nc_tupleinteger  for each row  execute procedure nc_tupleinteger_delete();

