create or replace function drop_triggers()  returns integer as '
declare
  tg_rec RECORD;
  sql_st varchar;
  cr CURSOR FOR select tgname, relname from pg_trigger a, pg_class b where tgname like ''nc__%'' and a.tgrelid = b.oid;
begin
  open cr;
  loop
    fetch cr into tg_rec;
    if NOT FOUND then
      exit;
    end if;
    sql_st := ''DROP TRIGGER '' || tg_rec.tgname || '' ON '' 
      || tg_rec.relname || '' CASCADE;'';

    raise notice ''query: %'', sql_st;  
    EXECUTE sql_st;
  end loop;
  close cr;
  return 0;
end;
' language plpgsql;


create or replace function drop_triggers_prefixed(varchar)  returns integer as '
declare
  prefix_in alias for $1; 
  tg_rec RECORD;
  sql_st varchar;
  cr_st varchar;
  cr refcursor;
begin
  
  cr_st := ''select tgname, relname from pg_trigger a, pg_class b where tgname like '''''' 
          || prefix_in || ''%'''' and a.tgrelid = b.oid'';
  raise notice ''cursor: %'', cr_st;
  open cr FOR EXECUTE cr_st;
  loop
    fetch cr into tg_rec;
    if NOT FOUND then
      close cr;
      exit;
    end if;
    sql_st := ''DROP TRIGGER '' || tg_rec.tgname || '' ON '' 
      || tg_rec.relname || '' CASCADE;'';

    raise notice ''query: %'', sql_st;  
    EXECUTE sql_st;
  end loop;
  return 0;
end;
' language plpgsql;


create or replace function drop_ext_tuple_triggers()  returns integer as '
begin
  return drop_triggers_prefixed(''nc_tuple'');
end;
' language plpgsql;


create or replace function drop_deriveddata_triggers()  returns integer as '
declare
begin
  return drop_triggers_prefixed(''nc_deriveddata'');
end;
' language plpgsql;


create or replace function drop_rawdata_triggers()  returns integer as '
declare
begin
  return drop_triggers_prefixed(''nc_rawdata'');
end;
' language plpgsql;
