#!/bin/bash
LWDP_DIR=`dirname $0`
source $LWDP_DIR//lwdp.sh

# Is set to 1 if any data is created or updated
export LWDP_CHANGED_FLAG=0

LWDP_changed_data_hook() {
   if [ $LWDP_CHANGED_FLAG == 0 ]; then 
       LWDP_CHANGED_FLAG=1
   fi 
}

LWDP_error_hook() {
    echo "error_hook: passed" 
    rm -f ${OUTPUT}*
}


cmd()
{
 if LWDP_needs_update_and_lock ${OUTPUT}; then
     touch $OUTPUT
     LWDP_lockfile_delete ${OUTPUT}
 fi
}

OUTPUT=`mktemp 2>/dev/null`
if [ "$OUTPUT" == "" ]; then 
    echo "ERROR:Could not create tmp file!"
    exit 1
fi 

rm -f ${OUTPUT}
cmd
echo -n "changed_data_hook: " 
if [ $LWDP_CHANGED_FLAG -eq 1 ]; then 
   echo "passed"    
else
   echo "failed"    
fi 

touch ${OUTPUT}.lock
cmd
echo "error_hook: failed" 
rm -f ${OUTPUT}*
