/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * $Id: ParseArgs.cxx,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $
 * 
 */
#include "svvController.h"
#include "vtkProperty.h"


// ----------------------------------------------------------------------------
static char*
args_cat_dup (int aArgc, char** aArgv)
{
  char*       cat  = NULL;
  std::size_t size = 0;

  if (aArgc>1)
    { // concatenate

    if (svv.GetDebug())
      std::cerr << "concatenating " << aArgc << " args" << std::endl;

    size = (aArgc + 1); // spaces btwn args + terminating nul.
    for (int n=0; n<aArgc; n++)
      {
      size += strlen(aArgv[n]);
      }

    cat    = new char[size];
    cat[0] = '\0';

    for (int n=0; n<aArgc; n++)
      {
      strcat(cat,aArgv[n]);
      if (n<(aArgc-1))
        {
        strcat(cat," ");
        }
      }
    }
  else
    {
    size = strlen(aArgv[0]) + 1;
    cat  = new char[size];
    strcpy(cat, aArgv[0]);
    }

  if (svv.GetDebug())
    std::cerr << "alloc=" << size << " vs " << " strlen=" << strlen(cat)
              << std::endl;

  return cat;
}

// ----------------------------------------------------------------------------
int
parse_args(int aArgc, char** aArgv, int& aIndex)
{
  static vtkProperty* property = vtkProperty::New();

  // pointer to the current flag
  const char*  flag = aArgv[aIndex];
  char**       args;

  bool valid = false;

  // determines how many arguments follow the current flag
  int nargs = 0;
  {
    while((aIndex+nargs+1) < aArgc && aArgv[aIndex+nargs+1][0]!='-') nargs++;
    
    if (svv.GetDebug())
      {
      std::cerr << " '" << &flag[0] << "' + ( ";
      }
    if (nargs)
      {
      args = aArgv + std::ptrdiff_t(aIndex+1);
      if (svv.GetDebug())
        {
        for (int n=0; n<nargs; n++)
          {
          std::cerr << "'" << args[n] << "' ";
          }
        }
      }
    else
      {
      args = 0;
      if (svv.GetDebug())
        {
        std::cerr << "none ";
        }
      }
    if (svv.GetDebug())
      {
      std::cerr << ")" << std::endl;
      }
  }

  // first check for flags that do not take arguments
  if (args==0)
    {
    ;
    }
  else
    {
    // some flags require that multiple arguments be concatenated
    if ( flag[1]=='c' || flag[1]=='m' ||
         flag[1]=='K' || flag[1]=='S' )
      {
      const char* ptr = args_cat_dup(nargs, args);
      
      int         n;
      const char* first;
      char*       last;
      float       rgba[4] = { 1.f, 1.f, 1.f, 1.f };
      
      first = ptr;
      last  = 0/*NULL*/;

      // specify an RGB(A) color by name, by triplet, or by quadruplet
      if (flag[1]=='c'  && !flag[2])
        {
      	// first attempt to parse an RGB triplet or RGBA quadruplet
        for (n=0; n<4; n++)
          {
          if ((rgba[n] = float(strtod(first, &last)))==0 && last==first) break;
          while(isspace(*last)) last++; /* chomp whitespace */
          first = last; /* point to char after last conversion */
          last  = 0; /* rezero to allow check for conversion failure */
          }
	
        if (property) property->Delete();

        if (n>2) property = svv.MakeProperty(rgba);
        else    property = svv.MakeProperty(ptr);

        if (svv.GetDebug() && property) property->Print(std::cerr);
        valid = true;
        } // '-c'

      // specify a material by name
      else if (flag[1]=='m' && !flag[2])
        { 
        if (property) property->Delete();
        property = svv.MakeProperty(ptr);

        if (svv.GetDebug() && property) property->Print(std::cerr);
        valid = true;
        } // '-m'
      
      // specify material reflectance
      else if (flag[1]=='K' && !flag[3])
        {
        // first attempt to parse an RGB triplet
        for (n=0; n<3; n++)
          {
          if ((rgba[n] = float(strtod(first, &last)))==0 && last==first) break;
          while(isspace(*last)) last++; /* chomp whitespace */
          first = last; /* point to char after last conversion */
          last  = 0; /* rezero to allow check for conversion failure */
          }
        if (n)
          {
          if (flag[2]=='a')
            {
            if (n<3) property->SetAmbient(rgba[0]);
            else property->SetAmbientColor(rgba);
            valid = true;
            }
          else if (flag[2]=='d')
            {
            if (n<3) property->SetDiffuse(rgba[0]);
            else property->SetDiffuseColor(rgba);
            valid = true;
            }
          else if (flag[2]=='s')
            {
            if (n<3) property->SetSpecular(rgba[0]);
            else property->SetSpecularColor(rgba);
            valid = true;
            }
          }
        } // '-Ka' || '-Kd' || '-Ks'

      // specify material reflectance
      else if (flag[1]=='S' && flag[2]=='e' && !flag[3])
        {
        property->SetSpecularPower(atof(args[0]));
        valid = true;
        } // '-Se'
      }
    else
      {
      // specify input pathnames
      if (flag[1]=='i')
        {
        if (nargs > 1)
          {
          std::cerr << "'-i' flag require one (and only one) anatomical data"
                    << " input path/prefix" << std::endl;
          }
        else
          {
          gAnatomicalData = GetImageData(args[0]);
          valid = true;
          }
        } // '-i'

      // specify input pathnames
      if (flag[1]=='f')
        {
        if (nargs > 1)
          {
          std::cerr << "'-f' flag require one (and only one) functional data"
                    << " input path" << std::endl;
          }
        else
          {
          gFunctionalData = GetFunctionalData(args[0]);
          valid = true;
          }
        } // '-f'

      // specify input surface pathnames
      if (flag[1]=='s')
        {
        vtkPolyDataFileSource* pSource;
        vtkActor*              pActor;
        
        for (int n=0; n<nargs; n++)
          {
          // make the "standard" surface
          pSource = svv.MakeSurfaceDataSource(args[n]);
          
          vtkPolyDataNormals* pNormals = vtkPolyDataNormals::New();
            {
            vtkTransformPolyDataFilter* pTransformFilter =
              vtkTransformPolyDataFilter::New();
              {
              pTransformFilter->SetInput(pSource->GetOutput());
              vtkTransform* pTransform = vtkTransform::New();
                {
                pTransform->Scale(1.0, -1.0, 1.0);
                pTransform->RotateX(90.0);
                }
              pTransformFilter->SetTransform(pTransform);
              pTransform->Delete();
              }
            pNormals->SetInput(pTransformFilter->GetOutput());
            pTransformFilter->Delete();
            }
          pActor = svv.MakeSurfaceActor(pNormals, property);
          pNormals->Delete();
          }
        // references are retained in the list so decrement ref count here
        pActor->Delete();
        pSource->Delete();
        pActor = 0;
        pSource = 0;
        valid = true;
        } // '-s'

      if (flag[1]=='r')
        {
        double res[3], m[16], inv[16], trp[16], scale;
        
        int ret = ReadRegistration(args[0], res, scale, m);

        std::cerr << "res: (" << res[0] << "," << res[1] << "," << res[2]
                  << ")\n scale: " << scale << "\n"
                  << "m:\t( " << m[0] << ", " << m[1] << ", " << m[2]
                  << ", " << m[3] << ",\n\t  " << m[4] << ", " << m[5] << ", "
                  << m[6] << ", " << m[7] << ",\n\t  " << m[8] << ", " << m[9]
                  << ", " << m[10] << ", " << m[11] << ",\n\t  " << m[12]
                  << ", " << m[13] << ", " << m[14] << ", " << m[15] << " )\n"
                  << std::endl;

        vtkMatrix4x4::Transpose(m,trp);

        std::cerr << "trp:\t( " << trp[0] << ", " << trp[1] << ", "
                  << trp[2] << ", " << trp[3] << ",\n\t  "
                  << trp[4] << ", " << trp[5] << ", " << trp[6]
                  << ", " << trp[7] << ",\n\t  " << trp[8] << ", "
                  << trp[9] << ", " << trp[10] << ", " << trp[11]
                  << ",\n\t  " << trp[12] << ", " << trp[13] << ", "
                  << trp[14] << ", " << trp[15] << " )\n" << std::endl;

        vtkMatrix4x4::Invert(trp,inv);

        std::cerr << "inv:\t( " << inv[0] << ", " << inv[1] << ", "
                  << inv[2] << ", " << inv[3] << ",\n\t  "
                  << inv[4] << ", " << inv[5] << ", " << inv[6]
                  << ", " << inv[7] << ",\n\t  " << inv[8] << ", "
                  << inv[9] << ", " << inv[10] << ", " << inv[11]
                  << ",\n\t  " << inv[12] << ", " << inv[13] << ", "
                  << inv[14] << ", " << inv[15] << " )\n" << std::endl;

        if (gTransform) gTransform->Delete();
        gTransform = vtkTransform::New();
        gTransform->SetMatrix(m);
        } // '-r'

      valid = true;
      }

    }

  if (valid)
    {
    aIndex += (nargs+1);
    return (nargs+1);
    }
  else
    {
    return 0;
    }
}

/* 
 * End of: $Id: ParseArgs.cxx,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $.
 * 
 */
