/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvMain.h,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MAIN_H_
#  define SVV_MAIN_H_
#  include "svvConfiguration.h"
// VTK Parallel
#  include "vtkCommunicator.h"
#  include "vtkMultiProcessController.h"

static const int sgMainPortId   = 0;
static const int sgMainPortTag  = 10000;
static const int sgPortId1      = 1;
static const int sgPortTag1     = 10002;
static const int sgPortId2      = 2;
static const int sgPortTag2     = 10004;
static const int sgPortId3      = 3;
static const int sgPortTag3     = 10006;

static const int sgScalingFractionTag = 10100;
static const int sgScalingFactorTag   = 10102;
static const int sgOriginalBoundsTag  = 10202;


void SvvProcess0 (vtkMultiProcessController*, void*);
void SvvProcess1 (vtkMultiProcessController*, void*);
void SvvProcess2 (vtkMultiProcessController*, void*);
void SvvProcess3 (vtkMultiProcessController*, void*);

  
static const int WINDOW_WIDTH  = 512; 
static const int WINDOW_HEIGHT = 512; 

#endif /* SVV_MAIN_H_ */
/* 
 * End of: $Id: svvMain.h,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $.
 * 
 */
