/* 
 * $Id: svDepthSort.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkDepthSortPolyData.h"

#include "svDepthSort.H"


//----------------------------------------------------------------------------
svDepthSort::svDepthSort(void)
{
  this->ResetParameters();
}


//----------------------------------------------------------------------------
svDepthSort*
svDepthSort::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svDepthSort");

  if(ret) {
    return reinterpret_cast<svDepthSort*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svDepthSort;
}

//----------------------------------------------------------------------------
void
svDepthSort::InstallFilter(void)
{
  if( !(vtkDepthSortPolyData::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkDepthSortPolyData::New());
}

//----------------------------------------------------------------------------
void
svDepthSort::ResetParameters(void)
{
  // this->Active        = int(0);
  this->Direction     = int(VTK_DIRECTION_BACK_TO_FRONT);
  this->DepthSortMode = int(VTK_SORT_FIRST_POINT);
  this->Camera        = (vtkCamera*)(0);
  this->Prop3D        = (vtkProp3D*)(0);
  this->Vector[0] = this->Vector[1] = this->Vector[2] = double(0.0);
  this->Origin[0] = this->Origin[1] = this->Origin[2] = double(0.0);
  this->SortScalars   = int(0);
}

//----------------------------------------------------------------------------
void
svDepthSort::ApplyParameters(void)
{
  if(this->Active) {
    vtkDepthSortPolyData* filter =
      vtkDepthSortPolyData::SafeDownCast(this->GetFilter());

    filter->SetDirection(this->Direction);
    filter->SetDepthSortMode(this->DepthSortMode);
    filter->SetCamera(this->Camera);
    filter->SetProp3D(this->Prop3D);
    filter->SetVector(this->Vector);
    filter->SetOrigin(this->Origin);
    filter->SetSortScalars(this->SortScalars);
  }
}

/* 
 * End of: $Id: svDepthSort.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
