/* 
 * $Id: svHull.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkHull.h"

#include "svHull.H"


//----------------------------------------------------------------------------
svHull::svHull(void)
{
  this->ResetParameters();
}


//----------------------------------------------------------------------------
svHull*
svHull::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svHull");

  if(ret) {
    return reinterpret_cast<svHull*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svHull;
}

//----------------------------------------------------------------------------
void
svHull::InstallFilter(void)
{
  if( !(vtkHull::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkHull::New());
}

//----------------------------------------------------------------------------
void
svHull::ResetParameters(void)
{
  // this->Active           = int(0);
}

//----------------------------------------------------------------------------
void
svHull::ApplyParameters(void)
{
  if(this->Active) {
    vtkHull* filter =
      vtkHull::SafeDownCast(this->GetFilter());
    // ...
  }
}

/* 
 * End of: $Id: svHull.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
