/* 
 * $Id: svNormals.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkPolyDataNormals.h"

#include "svNormals.H"


//----------------------------------------------------------------------------
svNormals::svNormals(void)
{
  this->ResetParameters();
}


//----------------------------------------------------------------------------
svNormals*
svNormals::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svNormals");

  if(ret) {
    return reinterpret_cast<svNormals*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svNormals;
}

//----------------------------------------------------------------------------
void
svNormals::InstallFilter(void)
{
  if( !(vtkPolyDataNormals::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkPolyDataNormals::New());
}

//----------------------------------------------------------------------------
void
svNormals::ResetParameters(void)
{
  // this->Active                 = 0;
  this->FeatureAngle           = 30.f;
  this->Splitting              = 1;
  this->Consistency            = 1;
  this->FlipNormals            = 0;
  this->NonManifoldTraversal   = 1;
  this->ComputePointNormals    = 1;
  this->ComputeCellNormals     = 0;
}

//----------------------------------------------------------------------------
void
svNormals::ApplyParameters(void)
{
  if(this->Active) {
    vtkPolyDataNormals* filter =
      vtkPolyDataNormals::SafeDownCast(this->GetFilter());

    filter->SetFeatureAngle(this->FeatureAngle);
    filter->SetSplitting(this->Splitting);
    filter->SetConsistency(this->Consistency);
    filter->SetComputePointNormals(this->ComputePointNormals);
    filter->SetComputeCellNormals(this->ComputeCellNormals);
    filter->SetFlipNormals(this->FlipNormals);
    filter->SetNonManifoldTraversal(this->NonManifoldTraversal);
  }
}

/* 
 * End of: $Id: svNormals.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
