/* 
 * $Id: svSelect.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkSelectPolyData.h"

#include "svSelect.H"


//----------------------------------------------------------------------------
svSelect*
svSelect::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svSelect");

  if(ret) {
    return reinterpret_cast<svSelect*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svSelect;
}

//----------------------------------------------------------------------------
void
svSelect::InstallFilter(void)
{
  if( !(vtkSelectPolyData::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkSelectPolyData::New());
}

//----------------------------------------------------------------------------
void
svSelect::ResetParameters(void)
{
  // this->Active                    = 0;
  this->GenerateSelectionScalars  = int(0);
  this->InsideOut                 = int(0);
  this->Loop                      = (vtkPoints*)(0);
  this->SelectionMode             = int(VTK_INSIDE_SMALLEST_REGION);
  this->GenerateUnselectedOutput  = int(0);
}

//----------------------------------------------------------------------------
void
svSelect::ApplyParameters(void)
{
  if(this->Active) {
    vtkSelectPolyData* filter =
      vtkSelectPolyData::SafeDownCast(this->GetFilter());

    filter->SetGenerateSelectionScalars(this->GenerateSelectionScalars);
    filter->SetInsideOut(this->InsideOut);
    filter->SetLoop(this->Loop);
    filter->SetSelectionMode(this->SelectionMode);
    filter->SetGenerateUnselectedOutput(this->GenerateUnselectedOutput);
  }
}

//----------------------------------------------------------------------------
vtkPolyData*
svSelect::GetUnselectedOutput(void)
{
  if(!this->GetActive()) return 0;

  vtkSelectPolyData* filter = vtkSelectPolyData::SafeDownCast(this->GetFilter());
  return filter->GetUnselectedOutput();
}

//----------------------------------------------------------------------------
vtkPolyData*
svSelect::GetSelectionEdges(void)
{
  if(!this->GetActive()) return 0;

  vtkSelectPolyData* filter = vtkSelectPolyData::SafeDownCast(this->GetFilter());
  return filter->GetSelectionEdges();
}

/* 
 * End of: $Id: svSelect.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
