/* 
 * $Id: svTriangleFilter.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkTriangleFilter.h"

#include "svTriangleFilter.H"


//----------------------------------------------------------------------------
svTriangleFilter*
svTriangleFilter::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svTriangleFilter");

  if(ret) {
    return reinterpret_cast<svTriangleFilter*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svTriangleFilter;
}

//----------------------------------------------------------------------------
void
svTriangleFilter::InstallFilter(void)
{
  if( !(vtkTriangleFilter::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkTriangleFilter::New());
}

//----------------------------------------------------------------------------
void
svTriangleFilter::ResetParameters(void)
{
  // this->Active                 = 0;
  this->PassVerts              = int(1); // VTK default
  this->PassLines              = int(1); // VTK default
}

//----------------------------------------------------------------------------
void
svTriangleFilter::ApplyParameters(void)
{
  if(this->Active) {
    vtkTriangleFilter* filter =
      vtkTriangleFilter::SafeDownCast(this->GetFilter());

    filter->SetPassVerts(this->PassVerts);
    filter->SetPassLines(this->PassLines);
  }
}

/* 
 * End of: $Id: svTriangleFilter.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
