/* 
 * $Id: svWindowedSinc.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkWindowedSincPolyDataFilter.h"

#include "svWindowedSinc.H"


//----------------------------------------------------------------------------
svWindowedSinc*
svWindowedSinc::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svWindowedSinc");

  if(ret) {
    return reinterpret_cast<svWindowedSinc*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svWindowedSinc;
}

//----------------------------------------------------------------------------
void
svWindowedSinc::InstallFilter(void)
{
  if( !(vtkWindowedSincPolyDataFilter::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkWindowedSincPolyDataFilter::New());
}

//----------------------------------------------------------------------------
void
svWindowedSinc::ResetParameters(void)
{
  // this->Active                 = 0;
  this->NumberOfIterations     = 20;
  this->PassBand               = 0.1f;
  this->FeatureEdgeSmoothing   = 0;
  this->FeatureAngle           = 45.f;
  this->EdgeAngle              = 15.f;
  this->BoundarySmoothing      = 1;
  this->GenerateErrorScalars   = 0;
  this->GenerateErrorVectors   = 0;
}

//----------------------------------------------------------------------------
void
svWindowedSinc::ApplyParameters(void)
{
  if(this->Active) {
    vtkWindowedSincPolyDataFilter* filter =
      vtkWindowedSincPolyDataFilter::SafeDownCast(this->GetFilter());

    filter->SetNumberOfIterations(this->NumberOfIterations);
    filter->SetPassBand(this->PassBand);
    filter->SetFeatureEdgeSmoothing(this->FeatureEdgeSmoothing);
    filter->SetFeatureAngle(this->FeatureAngle);
    filter->SetEdgeAngle(this->EdgeAngle);
    filter->SetBoundarySmoothing(this->BoundarySmoothing);
    filter->SetGenerateErrorScalars(this->GenerateErrorScalars);
    filter->SetGenerateErrorVectors(this->GenerateErrorVectors);
  }
}

/* 
 * End of: $Id: svWindowedSinc.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
