/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: cow.h,v 1.1.1.1 2006/12/19 22:58:40 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_COW_H_
#  define SVV_COW_H_
#  include "svvModel.h"

static GLsizei cow_nvertices = 1945;
static GLsizei cow_nindices  = 3888;
static GLsizei cow_nedges    = 15552;

static GLfloat cow_vertices[][6] =
{
  { 7.026557e-01, -3.201535e-01, -6.354343e-01,  4.175179e-01, -1.192795e-01, -2.429679e-01},
  { 7.302461e-01, -4.498619e-01, -5.141643e-01,  4.015620e-01, -1.531597e-01, -2.359133e-01},
  { 6.033090e-01, -1.645535e-01, -7.803464e-01,  4.800353e-01, -1.689447e-01, -1.905712e-01},
  { 3.875717e-01, -3.763229e-01, -8.415279e-01,  4.402592e-01, -1.816134e-01, -2.099114e-01},
  { 6.322194e-01, -4.715785e-01, -6.147457e-01,  3.887607e-01, -1.866826e-01, -2.258953e-01},
  { 3.010598e-01, -5.221684e-01, -7.979368e-01,  4.225990e-01, -2.375951e-01, -1.839326e-01},
  { 2.852827e-01, -6.528668e-01, -7.016971e-01,  4.113531e-01, -2.716713e-01, -1.616021e-01},
  { 4.087080e-01, -3.653060e-01, -8.363667e-01,  4.919938e-01, -2.511079e-01, -1.443114e-01},
  { 6.926820e-01, -2.058608e-01, -6.912402e-01,  5.190160e-01, -1.787896e-01, -1.514860e-01},
  { 5.118393e-01, -3.730628e-01, -7.738505e-01,  4.764328e-01, -1.985490e-01, -1.820704e-01},
  { 6.114763e-01, -6.920851e-02, -7.882302e-01,  5.454344e-01, -1.854111e-01, -1.281821e-01},
  { 7.111265e-01, -1.805527e-01, -6.794850e-01,  5.566157e-01, -2.205554e-01, -1.143365e-01},
  { 7.705954e-01, -9.219646e-02, -6.306208e-01,  5.677295e-01, -1.824483e-01, -1.096362e-01},
  { 5.575384e-01, -2.842643e-01, -7.799646e-01,  5.331798e-01, -2.469402e-01, -1.265800e-01},
  { 4.793253e-01, -6.047753e-01, -6.359984e-01,  5.164764e-01, -2.762694e-01, -1.219070e-01},
  { 2.203411e-01, -7.031201e-01, -6.760709e-01,  4.770971e-01, -2.892224e-01, -1.291726e-01},
  { 1.403576e-01, -7.456354e-01, -6.514044e-01,  4.429700e-01, -2.931598e-01, -1.340803e-01},
  { 7.367197e-01, -5.649188e-01, -3.716326e-01,  3.589101e-01, -2.849088e-01, -1.803527e-01},
  { 8.442976e-01, -2.005912e-01, -4.969153e-01,  6.004716e-01, -1.321989e-01, -7.294813e-02},
  { 9.349462e-01, -2.213960e-01, -2.772354e-01,  5.869335e-01, -1.844724e-01, -7.257969e-02},
  { 8.991260e-01, -3.675094e-01, -2.377169e-01,  5.757543e-01, -2.363232e-01, -7.297364e-02},
  { 7.464097e-01, -5.317262e-01, -4.001747e-01,  5.546849e-01, -2.620595e-01, -9.295100e-02},
  { 5.608268e-01, -8.077122e-01, -1.818635e-01,  5.290144e-01, -2.936401e-01, -7.430957e-02},
  { 2.938328e-01, -8.948870e-01, -3.359159e-01,  4.900671e-01, -3.077506e-01, -9.609399e-02},
  { 9.081046e-02, -9.574152e-01, -2.740615e-01,  4.516998e-01, -3.129005e-01, -9.181336e-02},
  { 1.320899e-01, -9.273247e-01, -3.501730e-01,  4.074344e-01, -3.122371e-01, -1.021950e-01},
  { 3.373326e-01, -8.504989e-01, -4.035571e-01,  3.502641e-01, -3.148133e-01, -1.530478e-01},
  { 9.505363e-01, -3.106135e-01,  4.616778e-05,  5.925546e-01, -1.880500e-01,  2.241583e-05},
  { 9.480531e-01, -3.181120e-01,  8.717800e-05,  5.826188e-01, -2.286048e-01,  3.242307e-05},
  { 7.819076e-01, -6.233943e-01,  9.350241e-05,  5.594233e-01, -2.691663e-01,  3.690902e-05},
  { 5.445711e-01, -8.387147e-01,  1.248857e-04,  5.293211e-01, -2.975051e-01,  4.142814e-05},
  { 2.454226e-01, -9.694161e-01,  9.907888e-05,  4.861584e-01, -3.155736e-01,  3.865251e-05},
  { 1.874051e-02, -9.997373e-01,  1.319741e-02,  4.311233e-01, -3.205714e-01,  3.244313e-05},
  { 5.224220e-01, -1.782273e-01, -8.338526e-01,  5.722179e-01, -9.167187e-03, -1.491766e-01},
  { 7.869707e-01, -1.738443e-01, -5.919927e-01,  5.433632e-01,  2.920130e-02, -1.853846e-01},
  { 6.561567e-01, -1.847740e-01, -7.316536e-01,  5.718532e-01,  4.772081e-02, -1.583707e-01},
  { 6.953421e-01, -3.926449e-01, -6.019381e-01,  6.097964e-01, -8.186890e-02, -9.107116e-02},
  { 8.382453e-01, -4.933031e-01, -2.323728e-01,  6.237425e-01, -9.453926e-02, -5.441407e-02},
  { 7.143952e-01, -5.507004e-01, -4.317041e-01,  6.419504e-01, -6.948734e-02, -7.285789e-02},
  { 1.627107e-01, -6.044375e-01, -7.798593e-01, -7.736018e-01, -1.297918e-01, -2.654970e-01},
  { 2.217038e-01, -2.547438e-01, -9.412508e-01, -8.399428e-01, -1.853738e-01, -2.652945e-01},
  { 8.858731e-02, -1.169645e-01, -9.891773e-01, -7.610931e-01, -1.867266e-01, -2.625351e-01},
  {-2.881192e-01, -5.925907e-01, -7.522125e-01, -7.044595e-01, -1.602319e-01, -2.597590e-01},
  { 3.483202e-01, -4.570621e-01, -8.183931e-01, -8.918447e-01, -2.386841e-01, -2.660959e-01},
  { 6.909562e-02, -2.861787e-01, -9.556817e-01, -8.530008e-01, -2.507719e-01, -2.595922e-01},
  { 7.710685e-02, -2.286928e-01, -9.704401e-01, -8.139895e-01, -2.387774e-01, -2.601807e-01},
  { 1.106735e-01, -3.205010e-01, -9.407606e-01, -7.722278e-01, -2.446969e-01, -2.533394e-01},
  {-3.169177e-01, -5.497934e-01, -7.728456e-01, -6.147941e-01, -2.359380e-01, -2.462281e-01},
  { 4.773173e-01, -5.984156e-01, -6.434804e-01, -9.272331e-01, -2.952256e-01, -2.438132e-01},
  { 5.845406e-02, -5.375473e-01, -8.412052e-01, -8.763452e-01, -3.028023e-01, -2.373426e-01},
  { 9.170051e-02, -5.279303e-01, -8.443226e-01, -8.198058e-01, -2.982330e-01, -2.354253e-01},
  { 7.910294e-02, -5.365210e-01, -8.401715e-01, -7.664056e-01, -3.030716e-01, -2.255387e-01},
  { 1.284694e-01, -3.404297e-01, -9.314522e-01, -6.815137e-01, -2.656892e-01, -2.373409e-01},
  {-4.717258e-02, -6.960848e-01, -7.164082e-01, -6.411102e-01, -3.074048e-01, -2.025764e-01},
  { 1.853940e-01, -6.976689e-01, -6.920167e-01, -6.707183e-01, -3.044542e-01, -2.170248e-01},
  {-5.851575e-02, -8.132322e-01, -5.789900e-01, -5.891128e-01, -3.274960e-01, -1.944604e-01},
  {-2.602679e-01, -6.821737e-01, -6.833006e-01, -5.889560e-01, -2.662245e-01, -2.425093e-01},
  {-2.918443e-01, -6.255978e-01, -7.235014e-01, -4.691879e-01, -3.133800e-01, -2.477733e-01},
  {-5.902071e-01, -3.751573e-01, -7.147815e-01, -5.129685e-01, -3.430864e-01, -2.066723e-01},
  {-2.866403e-01, -8.174027e-01, -4.996901e-01, -5.591543e-01, -3.470191e-01, -1.605507e-01},
  {-3.055736e-01, -9.261775e-01, -2.209526e-01, -5.137374e-01, -3.630581e-01, -1.886564e-01},
  {-3.134695e-01, -7.216280e-01, -6.172439e-01, -4.813693e-01, -3.678246e-01, -2.116250e-01},
  {-1.068441e-01, -8.539820e-01, -5.092140e-01, -4.375216e-01, -3.708306e-01, -2.116087e-01},
  { 2.897259e-03, -6.195143e-01, -7.849801e-01, -3.568363e-01, -3.287795e-01, -2.499933e-01},
  {-1.213964e-01, -8.086005e-01, -5.756979e-01, -4.009556e-01, -3.661224e-01, -2.255328e-01},
  { 3.841702e-02, -8.725500e-01, -4.870120e-01, -3.690228e-01, -3.719257e-01, -2.211578e-01},
  { 2.027907e-01, -8.618186e-01, -4.649135e-01, -3.301444e-01, -3.614071e-01, -2.267287e-01},
  { 2.744147e-01, -7.838845e-01, -5.569754e-01, -2.268041e-01, -3.387284e-01, -2.088774e-01},
  { 2.622869e-02, -9.965819e-01, -7.833598e-02, -3.754667e-01, -3.738551e-01, -1.649619e-01},
  { 2.087861e-01, -9.559535e-01, -2.063036e-01, -2.404183e-01, -3.585665e-01, -1.538192e-01},
  {-1.870621e-01, -9.348749e-01, -3.016898e-01, -5.964473e-01, -3.429648e-01, -1.547255e-01},
  {-2.234901e-01, -9.005352e-01, -3.729457e-01, -6.222323e-01, -3.314170e-01, -1.693442e-01},
  { 1.169065e-01, -8.961323e-01, -4.281118e-01, -6.604410e-01, -3.248939e-01, -1.643266e-01},
  { 1.099872e-01, -9.784480e-01, -1.747637e-01, -6.474898e-01, -3.481489e-01, -8.439802e-02},
  {-1.303736e-01, -9.888340e-01, -7.218182e-02, -4.804649e-01, -3.746960e-01, -9.331555e-02},
  { 5.864348e-02, -9.941360e-01, -9.085490e-02, -3.407352e-01, -3.813957e-01, -9.442781e-02},
  { 1.994896e-01, -9.751948e-01, -9.591277e-02, -2.251435e-01, -3.672466e-01, -8.673014e-02},
  { 2.594356e-01, -8.686836e-01, -4.219974e-01, -9.606798e-02, -3.059853e-01, -1.776922e-01},
  { 2.699825e-01, -9.514729e-01, -1.476778e-01, -9.197483e-02, -3.296373e-01, -9.979315e-02},
  { 2.608148e-01, -9.653774e-01,  4.681379e-03, -1.203707e-01, -3.445161e-01,  2.930242e-05},
  { 1.385290e-01, -9.903584e-01,  7.070410e-05, -2.658390e-01, -3.776739e-01,  3.152827e-05},
  {-1.939531e-02, -9.998119e-01,  4.951227e-05, -3.816569e-01, -3.854535e-01,  2.244735e-05},
  {-1.117616e-01, -9.937351e-01,  2.400296e-05, -4.793147e-01, -3.779318e-01,  1.609321e-05},
  {-2.251483e-02, -9.997465e-01, -1.845323e-05, -6.520871e-01, -3.523285e-01,  2.181080e-05},
  { 3.170006e-01, -9.484253e-01, -3.879182e-05, -7.068483e-01, -3.658687e-01,  1.195706e-05},
  { 5.298110e-01, -7.262037e-01, -4.380965e-01, -9.665604e-01, -3.522512e-01, -2.063964e-01},
  { 1.034360e-01, -7.524434e-01, -6.504844e-01, -8.424074e-01, -3.585790e-01, -1.824607e-01},
  { 1.534861e-01, -7.312692e-01, -6.645955e-01, -7.721973e-01, -3.513448e-01, -1.808324e-01},
  { 5.778800e-01, -5.490372e-01, -6.038318e-01, -7.467901e-01, -3.829991e-01, -1.346225e-01},
  { 7.321241e-01, -6.697497e-01, -1.242158e-01, -7.322318e-01, -3.830269e-01, -1.105711e-01},
  { 1.440648e-01, -4.346431e-01, -8.890054e-01, -7.719046e-01, -3.784270e-01, -1.528826e-01},
  {-3.143458e-01, -5.900351e-01, -7.436702e-01, -7.992008e-01, -3.931540e-01, -1.384716e-01},
  { 7.069251e-02, -9.654244e-01, -2.509151e-01, -8.508346e-01, -3.939710e-01, -1.239816e-01},
  {-5.797670e-01, -7.568203e-01, -3.018165e-01, -8.130167e-01, -3.951693e-01, -1.227456e-01},
  { 4.248070e-01, -5.764913e-01, -6.979949e-01, -8.929306e-01, -3.907260e-01, -1.570758e-01},
  { 7.467776e-01, -6.383180e-01, -1.867440e-01, -8.873124e-01, -4.005234e-01, -1.360527e-01},
  { 8.769737e-02, -5.863286e-01, -8.053123e-01, -9.154930e-01, -3.864616e-01, -1.688540e-01},
  {-8.375182e-02, -6.211764e-01, -7.791826e-01, -9.426149e-01, -3.869622e-01, -1.636528e-01},
  { 3.218280e-01, -9.436939e-01, -7.660702e-02, -9.878715e-01, -3.743513e-01, -1.962514e-01},
  {-4.754688e-01, -5.119827e-01, -7.154042e-01, -9.571384e-01, -3.887209e-01, -1.569682e-01},
  {-4.107549e-01, -9.109403e-01,  3.831774e-02, -1.019432e+00, -3.715775e-01, -1.057042e-01},
  {-5.797286e-01, -7.529033e-01,  3.115306e-01, -9.528667e-01, -3.999579e-01, -1.231878e-01},
  {-5.390352e-01, -8.333212e-01, -1.225429e-01, -9.597369e-01, -3.968574e-01, -1.400907e-01},
  {-1.984633e-01, -9.801083e-01, -2.729551e-06, -9.369606e-01, -3.943322e-01,  2.423972e-07},
  {-1.778636e-01, -6.059383e-01,  7.753730e-01, -9.334909e-01, -4.037571e-01, -1.114957e-01},
  { 3.001791e-01, -8.424893e-01,  4.473303e-01, -9.031293e-01, -4.050791e-01, -1.188010e-01},
  {-5.311334e-01, -7.549081e-01,  3.847220e-01, -8.049110e-01, -4.032596e-01, -9.980354e-02},
  { 8.954036e-02, -9.959832e-01, -4.392991e-06, -7.843990e-01, -3.903147e-01,  7.476506e-07},
  { 1.090983e-01, -7.421573e-01,  6.612867e-01, -7.816748e-01, -3.980412e-01, -8.462465e-02},
  { 4.954057e-01, -7.929599e-01,  3.546656e-01, -7.496189e-01, -3.948716e-01, -9.478916e-02},
  {-6.144285e-01, -7.889442e-01,  6.680796e-03, -1.123480e+00, -3.161381e-01, -1.138729e-01},
  {-5.730545e-01, -4.613204e-01,  6.773419e-01, -1.123680e+00, -3.148709e-01, -1.771719e-01},
  {-7.538065e-01, -6.568031e-01, -1.963613e-02, -1.163024e+00, -2.797176e-01, -1.011886e-01},
  {-9.595900e-01, -2.797587e-01, -3.036736e-02, -1.146383e+00, -2.883920e-01, -1.852716e-01},
  {-8.374305e-01, -3.521396e-01, -4.179807e-01, -1.186764e+00, -2.455554e-01, -1.564659e-01},
  {-8.945243e-01, -4.458334e-01, -3.254221e-02, -1.194288e+00, -2.348945e-01, -9.198807e-02},
  {-9.128104e-01, -2.039621e-01, -3.538031e-01, -1.203688e+00, -1.959184e-01, -1.399524e-01},
  {-9.614094e-01, -2.581526e-01, -9.512741e-02, -1.213988e+00, -1.870930e-01, -9.060756e-02},
  {-9.438633e-01, -6.215776e-02, -3.244358e-01, -1.215491e+00, -1.407539e-01, -1.293540e-01},
  {-9.944694e-01, -7.644551e-02, -7.201876e-02, -1.223875e+00, -1.376914e-01, -7.779946e-02},
  {-9.677695e-01,  8.818813e-02, -2.358921e-01, -1.217437e+00, -7.224596e-02, -1.159193e-01},
  {-9.955720e-01,  7.925800e-02, -5.054475e-02, -1.222798e+00, -7.145157e-02, -6.708230e-02},
  {-9.823369e-01,  1.603482e-01, -9.644965e-02, -1.209579e+00,  1.892120e-02, -7.930135e-02},
  {-9.172451e-01,  1.652476e-01, -3.624289e-01, -1.200860e+00,  2.010221e-02, -1.210717e-01},
  {-9.726289e-01,  1.085976e-01, -2.054255e-01, -1.195828e+00,  9.923755e-02, -9.122843e-02},
  {-9.935126e-01, -1.137179e-01, -9.209242e-04, -1.191338e+00,  2.576385e-01,  1.003069e-05},
  {-9.909456e-01,  1.326163e-01,  2.096877e-02, -1.215351e+00,  3.008676e-03,  3.857876e-05},
  {-9.997441e-01, -2.262316e-02,  3.734127e-05, -1.224864e+00, -1.242382e-01,  3.490880e-05},
  {-9.540337e-01, -2.996991e-01,  4.336841e-05, -1.213870e+00, -1.916891e-01,  1.913835e-05},
  {-7.764934e-01, -6.301254e-01,  2.373262e-05, -1.181624e+00, -2.551099e-01,  2.287163e-05},
  {-5.176313e-01, -8.556038e-01,  3.599920e-07, -1.107470e+00, -3.258571e-01,  2.014306e-05},
  {-9.159745e-01, -2.270959e-02, -4.005933e-01, -1.169381e+00,  9.924679e-02, -1.504501e-01},
  {-7.455113e-01,  1.634444e-01, -6.461414e-01, -1.180919e+00,  2.380236e-02, -1.558819e-01},
  {-8.210697e-01,  9.987381e-02, -5.620230e-01, -1.196026e+00, -7.194264e-02, -1.630050e-01},
  {-7.188959e-01, -3.769618e-02, -6.940948e-01, -1.186446e+00, -1.441013e-01, -1.781213e-01},
  {-6.256613e-01, -1.260493e-01, -7.698438e-01, -1.168101e+00, -2.003204e-01, -1.866870e-01},
  {-8.642208e-01,  8.700003e-02, -4.955333e-01, -1.132244e+00, -2.486516e-01, -1.998293e-01},
  {-8.505140e-01, -2.899215e-02, -5.251527e-01, -1.149558e+00,  2.357867e-02, -1.833438e-01},
  {-8.310615e-01, -8.133545e-02, -5.502012e-01, -1.124557e+00, -6.716493e-02, -2.110496e-01},
  {-5.678686e-01,  1.044722e-01, -8.164623e-01, -1.162102e+00, -7.007929e-02, -1.921562e-01},
  {-8.824233e-01,  9.500289e-02, -4.607643e-01, -1.118868e+00, -1.972704e-01, -2.142291e-01},
  {-7.569519e-01,  1.125535e-02, -6.533737e-01, -1.108923e+00, -1.403032e-01, -2.257498e-01},
  {-9.841493e-01, -1.676974e-01,  5.768671e-02, -1.195973e+00,  3.063660e-01, -5.966780e-02},
  {-9.726059e-01, -2.080141e-01,  1.037688e-01, -1.203643e+00,  3.459610e-01, -6.602155e-02},
  {-7.777572e-01, -6.973795e-03, -6.285262e-01,  2.639059e-01, -6.958669e-01, -2.716031e-01},
  {-7.134270e-01,  3.243614e-02, -6.999784e-01,  2.594307e-01, -6.434383e-01, -2.538156e-01},
  {-1.783056e-01,  2.413348e-02, -9.836791e-01,  2.818689e-01, -6.906345e-01, -2.691367e-01},
  {-1.419710e-01,  1.558283e-01, -9.775283e-01,  2.740520e-01, -6.416638e-01, -2.605077e-01},
  { 5.530005e-01,  2.978044e-01, -7.781407e-01,  3.435937e-01, -6.713162e-01, -2.570753e-01},
  { 5.754048e-01,  2.316481e-01, -7.843777e-01,  3.261555e-01, -6.261992e-01, -2.480591e-01},
  {-5.082550e-02,  1.698320e-01, -9.841616e-01,  3.036398e-01, -6.213306e-01, -2.501834e-01},
  { 9.640100e-01,  2.657874e-01, -6.458568e-03,  3.370688e-01, -6.196322e-01, -2.288716e-01},
  {-4.300917e-01, -8.257817e-02, -8.990005e-01,  2.640461e-01, -7.115221e-01, -2.678460e-01},
  { 1.931437e-02, -3.549404e-01, -9.346893e-01,  2.793191e-01, -7.299383e-01, -2.657448e-01},
  {-5.044479e-01, -5.425387e-01, -6.717024e-01,  2.603751e-01, -7.374476e-01, -2.695972e-01},
  {-6.711499e-01, -4.042898e-01, -6.213756e-01,  2.851709e-01, -7.426115e-01, -2.569270e-01},
  {-1.080263e-01,  4.482608e-01, -8.873514e-01,  3.292798e-01, -7.484147e-01, -2.897008e-01},
  { 2.017648e-01,  5.785851e-01, -7.902722e-01,  3.638202e-01, -7.503979e-01, -2.885441e-01},
  {-5.118872e-02,  4.331945e-01, -8.998457e-01,  3.521924e-01, -7.807713e-01, -3.056988e-01},
  { 1.156456e-02,  4.143666e-01, -9.100366e-01,  3.769088e-01, -8.215887e-01, -3.280810e-01},
  { 4.061343e-01,  6.037337e-01, -6.859742e-01,  4.014200e-01, -8.008760e-01, -3.076679e-01},
  { 4.126322e-01,  3.346999e-01, -8.471781e-01,  4.315205e-01, -8.450978e-01, -3.291141e-01},
  { 3.372571e-01, -7.694915e-01, -5.423471e-01,  4.070303e-01, -8.569611e-01, -3.400885e-01},
  {-3.821602e-01, -5.931920e-01, -7.085738e-01,  3.440050e-01, -8.585888e-01, -3.317517e-01},
  {-3.827313e-01,  2.748884e-01, -8.820165e-01,  3.365546e-01, -8.210561e-01, -3.193762e-01},
  {-5.053976e-01,  2.213914e-01, -8.340018e-01,  3.178257e-01, -7.870803e-01, -2.983882e-01},
  { 7.094324e-01,  5.195553e-01, -4.762016e-01,  3.838124e-01, -7.422984e-01, -2.695297e-01},
  { 9.570005e-01,  2.825669e-01,  6.562030e-02,  3.919762e-01, -7.499654e-01, -2.446820e-01},
  { 8.930275e-01,  4.232612e-01,  1.528130e-01,  3.682684e-01, -7.085261e-01, -2.345004e-01},
  { 5.266707e-01,  4.495596e-01, -7.214666e-01,  3.621975e-01, -7.141944e-01, -2.607635e-01},
  {-8.290829e-01, -3.768404e-01, -4.130531e-01,  3.147967e-01, -8.393793e-01, -3.058766e-01},
  { 2.009704e-01,  3.949785e-01, -8.964390e-01,  3.316563e-01, -7.173494e-01, -2.655016e-01},
  { 3.529714e-02,  2.120357e-01, -9.766243e-01,  2.952142e-01, -6.852340e-01, -2.745136e-01},
  { 1.177725e-01,  2.417289e-01, -9.631702e-01,  2.903672e-01, -6.326041e-01, -2.487263e-01},
  {-8.537217e-01, -5.096086e-01,  1.070429e-01,  2.569134e-01, -7.419242e-01, -2.224655e-01},
  {-9.953646e-01,  6.370573e-02,  7.204727e-02,  2.598518e-01, -7.086640e-01, -2.330396e-01},
  {-4.906774e-01, -8.576381e-01,  1.539244e-01,  2.836867e-01, -7.529927e-01, -2.297663e-01},
  {-9.273462e-01, -2.774839e-01,  2.510616e-01,  2.909513e-01, -7.869061e-01, -2.381983e-01},
  {-2.569689e-01, -9.658887e-01,  3.203006e-02,  3.523371e-01, -8.587353e-01, -2.534414e-01},
  {-6.914968e-01, -7.165846e-01,  9.131665e-02,  3.223595e-01, -8.458971e-01, -2.435677e-01},
  {-9.247334e-01, -3.694778e-01,  9.140108e-02,  3.017287e-01, -8.128687e-01, -2.459282e-01},
  {-2.892332e-01, -2.121124e-01,  9.334626e-01,  3.095899e-01, -7.415902e-01, -2.006250e-01},
  {-5.988795e-01, -3.313958e-01,  7.290544e-01,  2.659121e-01, -7.367025e-01, -1.929384e-01},
  {-5.682018e-01, -8.607543e-02,  8.183751e-01,  3.176436e-01, -7.874320e-01, -1.898636e-01},
  {-6.978390e-01, -2.958299e-01,  6.523076e-01,  3.208362e-01, -8.249854e-01, -1.931061e-01},
  {-3.959253e-01, -6.756027e-01,  6.219360e-01,  3.377481e-01, -8.493860e-01, -1.894685e-01},
  { 4.987546e-02, -8.297789e-01,  5.558593e-01,  3.718386e-01, -8.566164e-01, -1.930210e-01},
  { 1.374440e-01, -9.898672e-01,  3.566612e-02,  3.946851e-01, -8.590401e-01, -2.591067e-01},
  { 4.455104e-01, -4.678316e-01,  7.633178e-01,  4.042180e-01, -8.554814e-01, -2.017999e-01},
  {-7.839350e-01,  6.703155e-02,  6.172137e-01,  2.716542e-01, -6.907935e-01, -2.028356e-01},
  {-9.831724e-01, -9.498296e-02,  1.560459e-01,  2.578196e-01, -6.535914e-01, -2.298985e-01},
  {-6.723220e-01, -4.860650e-02,  7.386613e-01,  2.662253e-01, -6.272655e-01, -2.058373e-01},
  {-7.881711e-02,  1.941141e-01, -9.778076e-01,  3.090645e-01, -7.240621e-01, -2.737899e-01},
  {-3.295196e-01, -4.273780e-02, -9.431810e-01,  2.971036e-01, -7.281796e-01, -2.715296e-01},
  { 7.184897e-01,  3.830873e-01,  5.805313e-01,  3.769571e-01, -7.425447e-01, -2.188322e-01},
  { 8.972575e-01,  2.490806e-01, -3.645378e-01,  4.435048e-01, -8.325353e-01, -3.129286e-01},
  { 9.144477e-01, -3.960816e-01, -8.309527e-02,  4.582109e-01, -8.455708e-01, -2.806954e-01},
  { 7.825283e-01,  6.205018e-01, -5.125595e-02,  4.261419e-01, -8.054448e-01, -2.635895e-01},
  { 8.867785e-01, -2.102058e-01,  4.116277e-01,  4.410231e-01, -8.385618e-01, -2.203706e-01},
  { 6.734086e-01,  4.496652e-01,  5.867897e-01,  4.221737e-01, -8.003871e-01, -2.206944e-01},
  { 8.233818e-01,  4.030217e-01,  3.995199e-01,  3.935837e-01, -7.725158e-01, -2.216948e-01},
  {-1.102317e-01, -1.082383e-03,  9.939054e-01,  2.962386e-01, -6.896318e-01, -1.917666e-01},
  { 3.517630e-01,  1.557653e-01,  9.230384e-01,  3.364689e-01, -7.162644e-01, -1.979360e-01},
  { 4.785755e-01,  1.164640e-01,  8.702883e-01,  3.220222e-01, -6.713151e-01, -1.936028e-01},
  { 9.012032e-02,  2.490428e-02,  9.956195e-01,  3.051394e-01, -6.293778e-01, -1.932947e-01},
  { 8.029198e-01,  1.506825e-01,  5.767274e-01,  3.294607e-01, -6.306015e-01, -2.127060e-01},
  { 2.643569e-01,  2.264550e-01,  9.374613e-01,  3.523596e-01, -7.643098e-01, -1.893387e-01},
  { 2.142038e-01,  8.628598e-02,  9.729705e-01,  3.667259e-01, -8.053718e-01, -1.864132e-01},
  { 3.840068e-01, -3.851502e-01, -8.391652e-01, -9.716366e-01, -3.085614e-01, -2.988026e-01},
  { 7.059772e-01, -4.152105e-01, -5.737565e-01, -1.017255e+00, -4.035311e-01, -2.766318e-01},
  { 4.488021e-01, -2.041522e-01, -8.699991e-01, -1.037965e+00, -3.909939e-01, -2.951167e-01},
  {-3.281910e-02, -8.501031e-02, -9.958394e-01, -1.068895e+00, -3.913342e-01, -3.004955e-01},
  {-1.268475e-01, -8.066986e-02, -9.886366e-01, -1.029161e+00, -2.986144e-01, -3.082303e-01},
  {-4.248468e-01,  9.137569e-02, -9.006418e-01, -1.100924e+00, -3.780335e-01, -2.911180e-01},
  {-8.663520e-01,  3.452419e-01, -3.608908e-01, -1.146665e+00, -2.993045e-01, -2.459548e-01},
  {-8.767985e-01,  5.884886e-02,  4.772434e-01, -1.177020e+00, -3.644024e-01, -2.099459e-01},
  {-8.841360e-01,  8.787786e-02, -4.588913e-01, -1.174817e+00, -3.639450e-01, -2.486688e-01},
  {-8.129638e-01,  2.343968e-01, -5.330553e-01, -1.129172e+00, -2.519216e-01, -2.465731e-01},
  { 4.142191e-01, -4.391951e-02, -9.091169e-01, -1.060366e+00, -5.089483e-01, -2.843335e-01},
  { 3.059290e-01,  3.293455e-02, -9.514845e-01, -1.061422e+00, -5.824523e-01, -2.882447e-01},
  {-1.402757e-01, -7.131786e-03, -9.900869e-01, -1.085867e+00, -5.131633e-01, -2.881434e-01},
  { 3.990519e-01, -1.531105e-01, -9.040546e-01, -1.053664e+00, -4.553606e-01, -2.894011e-01},
  {-1.909107e-01, -6.904319e-02, -9.791762e-01, -1.097284e+00, -4.549107e-01, -2.916404e-01},
  {-2.020535e-01,  1.449084e-01, -9.685948e-01, -1.109014e+00, -5.852245e-01, -2.818547e-01},
  {-7.419453e-01, -6.366005e-03, -6.704302e-01, -1.133934e+00, -5.829586e-01, -2.652161e-01},
  {-7.561778e-01, -8.479203e-02, -6.488493e-01, -1.162374e+00, -4.444685e-01, -2.558203e-01},
  { 9.158397e-01, -1.383839e-01, -3.769450e-01, -1.041813e+00, -5.044541e-01, -2.710202e-01},
  { 8.392431e-01, -2.787481e-01, -4.668730e-01, -1.032176e+00, -4.474650e-01, -2.697042e-01},
  { 8.578396e-01, -5.132991e-01,  2.520387e-02, -1.009226e+00, -4.104415e-01, -2.390257e-01},
  { 7.862031e-01, -3.538046e-01,  5.066626e-01, -1.035123e+00, -4.659913e-01, -2.403034e-01},
  { 7.606044e-01, -1.541460e-01,  6.306505e-01, -1.048180e+00, -5.156086e-01, -2.434994e-01},
  { 4.946275e-01, -5.297537e-01,  6.889882e-01, -1.029899e+00, -4.240564e-01, -2.138283e-01},
  { 2.040174e-01, -2.309576e-01,  9.513335e-01, -1.073158e+00, -5.226764e-01, -2.301055e-01},
  { 2.945924e-01, -2.925246e-01,  9.097497e-01, -1.076775e+00, -4.779963e-01, -2.148130e-01},
  { 1.535951e-01, -3.337310e-01,  9.300711e-01, -1.063230e+00, -4.257044e-01, -2.023352e-01},
  {-3.350366e-02, -2.479375e-01,  9.681965e-01, -1.106742e+00, -4.660505e-01, -2.111374e-01},
  { 2.798339e-01, -5.090247e-02,  9.586980e-01, -1.078067e+00, -5.829693e-01, -2.351253e-01},
  {-3.677880e-01, -1.991668e-01,  9.083306e-01, -1.144733e+00, -3.826059e-01, -1.919276e-01},
  {-4.119338e-01, -2.348771e-01,  8.804221e-01, -1.156142e+00, -4.494075e-01, -2.130920e-01},
  {-2.877793e-01, -3.083006e-01,  9.067159e-01, -1.133230e+00, -5.202683e-01, -2.278711e-01},
  {-9.456179e-01, -1.968109e-01,  2.589831e-01, -1.166302e+00, -4.479359e-01, -2.281124e-01},
  {-6.400181e-01, -1.392988e-01,  7.556273e-01, -1.142920e+00, -5.907172e-01, -2.510272e-01},
  { 9.873956e-01, -1.527344e-01, -4.149830e-02,  3.437466e-01, -4.836989e-01, -2.233862e-01},
  { 9.889011e-01,  1.880296e-02, -1.473808e-01,  3.243018e-01, -5.571893e-01, -2.287032e-01},
  { 6.533312e-01, -5.706613e-02, -7.549184e-01,  3.183314e-01, -5.530506e-01, -2.479368e-01},
  { 8.327756e-01, -8.382583e-02, -5.472276e-01,  3.366288e-01, -4.384637e-01, -2.498402e-01},
  { 9.913498e-01, -8.084101e-02, -1.033938e-01,  3.516156e-01, -3.578509e-01, -2.271224e-01},
  { 8.091436e-01, -2.578686e-01, -5.280060e-01,  3.427830e-01, -3.119718e-01, -2.663845e-01},
  { 9.730546e-01, -2.304459e-01,  7.700558e-03,  3.512961e-01, -3.089071e-01, -2.326532e-01},
  { 5.554196e-03, -5.181916e-02, -9.986411e-01,  2.647471e-01, -5.634629e-01, -2.528623e-01},
  {-5.753750e-01, -4.718270e-02, -8.165277e-01,  2.530577e-01, -5.797298e-01, -2.484872e-01},
  {-4.045829e-01, -1.730336e-01, -8.979822e-01,  2.445785e-01, -5.140678e-01, -2.539774e-01},
  {-3.699468e-01, -1.726291e-01, -9.128738e-01,  2.346615e-01, -4.525689e-01, -2.617398e-01},
  {-4.777632e-01, -1.904582e-01, -8.575943e-01,  2.233123e-01, -3.868236e-01, -2.694115e-01},
  {-1.461276e-01, -2.948836e-01, -9.442936e-01,  2.454360e-01, -3.398942e-01, -2.867649e-01},
  {-9.731305e-01, -2.000175e-01, -1.140611e-01,  2.422580e-01, -5.733506e-01, -2.324686e-01},
  {-9.283193e-01, -2.446015e-01, -2.799885e-01,  2.073870e-01, -4.552689e-01, -2.443317e-01},
  {-9.059340e-01, -1.976677e-01, -3.744476e-01,  1.957578e-01, -3.282876e-01, -2.557697e-01},
  {-6.228822e-01, -1.981502e-01,  7.568053e-01,  2.451703e-01, -5.578659e-01, -2.178593e-01},
  {-9.135164e-01, -2.008009e-01,  3.537892e-01,  1.921274e-01, -3.800611e-01, -2.201624e-01},
  {-7.736773e-01, -6.276185e-01,  8.670941e-02,  1.860529e-01, -3.134016e-01, -1.935037e-01},
  {-5.778962e-01, -2.593605e-01,  7.738011e-01,  2.521553e-01, -4.920284e-01, -1.918934e-01},
  {-2.167936e-01, -8.610622e-01,  4.599699e-01,  2.268222e-01, -3.185424e-01, -1.715933e-01},
  { 5.713282e-01, -2.452276e-01, -7.832289e-01,  3.185480e-01, -3.316295e-01, -2.796005e-01},
  { 3.694280e-01, -1.165708e-01, -9.219187e-01,  3.206115e-01, -3.787457e-01, -2.709217e-01},
  { 3.870969e-01, -7.985511e-02, -9.185745e-01,  3.145902e-01, -4.529479e-01, -2.757000e-01},
  { 4.693869e-01, -1.918310e-01, -8.619030e-01,  3.112114e-01, -5.076405e-01, -2.656806e-01},
  { 1.290055e-01, -2.649044e-01, -9.556062e-01,  2.826280e-01, -3.138892e-01, -2.957431e-01},
  {-1.358680e-01, -9.863439e-02, -9.858048e-01,  2.871381e-01, -4.585660e-01, -2.724651e-01},
  {-1.895048e-01, -2.914003e-01,  9.376427e-01,  2.706574e-01, -3.484046e-01, -1.787044e-01},
  {-3.407157e-03, -8.245333e-01,  5.658032e-01,  2.693967e-01, -3.173755e-01, -1.681876e-01},
  {-9.000723e-02, -1.143437e-01,  9.893554e-01,  2.675138e-01, -4.485049e-01, -1.759042e-01},
  { 7.621698e-01, -8.383682e-02,  6.419256e-01,  3.224715e-01, -5.519574e-01, -2.017171e-01},
  { 4.923760e-01, -1.030597e-01,  8.642595e-01,  3.347598e-01, -3.606361e-01, -1.797395e-01},
  { 5.984919e-01, -7.011366e-01,  3.875757e-01,  3.268466e-01, -3.167012e-01, -1.687506e-01},
  { 6.598151e-01, -1.191768e-01,  7.419171e-01,  3.219049e-01, -4.342559e-01, -1.852339e-01},
  { 6.037501e-01, -2.889198e-01, -7.429745e-01,  3.566525e-01, -2.251732e-01, -2.912658e-01},
  { 8.782846e-01, -2.919133e-01, -3.786856e-01,  3.554151e-01, -2.675325e-01, -2.698440e-01},
  { 2.838566e-01, -2.366764e-01, -9.291984e-01,  3.201902e-01, -2.225471e-01, -3.135591e-01},
  { 4.748998e-01, -2.871549e-01, -8.318727e-01,  3.265413e-01, -2.805272e-01, -2.922347e-01},
  { 5.859790e-02, -2.533282e-01, -9.656040e-01,  2.809142e-01, -2.699663e-01, -3.085696e-01},
  {-2.746354e-02, -1.696681e-01, -9.851185e-01,  2.781168e-01, -2.220873e-01, -3.191391e-01},
  {-2.442928e-01, -2.459361e-01, -9.379959e-01,  2.337989e-01, -2.873071e-01, -2.992658e-01},
  {-2.239887e-01, -2.011491e-01, -9.536080e-01,  2.345022e-01, -2.297169e-01, -3.123428e-01},
  {-5.943438e-01, -2.688839e-01, -7.579294e-01,  2.009325e-01, -2.372229e-01, -2.964370e-01},
  {-6.159007e-01, -2.336014e-01, -7.523940e-01,  2.045412e-01, -2.858689e-01, -2.862844e-01},
  {-8.420286e-01, -3.019378e-01, -4.470138e-01,  1.839229e-01, -2.707361e-01, -2.596746e-01},
  {-5.171503e-01, -4.944145e-01, -6.986486e-01,  1.567176e-01, -2.329819e-01, -2.406511e-01},
  {-5.622855e-01, -5.955746e-01, -5.736950e-01,  1.477604e-01, -2.561980e-01, -2.108628e-01},
  { 8.015674e-01, -3.548852e-01, -4.811924e-01,  3.756694e-01, -1.821943e-01, -2.896687e-01},
  { 3.701831e-01, -2.171036e-01, -9.032333e-01,  3.424911e-01, -1.747590e-01, -3.167157e-01},
  { 3.477748e-02, -1.242053e-01, -9.916469e-01,  2.913046e-01, -1.792902e-01, -3.260367e-01},
  {-3.369819e-01, -1.838803e-01, -9.233803e-01,  2.077263e-01, -1.890560e-01, -3.128884e-01},
  { 8.529354e-01, -1.496912e-02, -5.218018e-01,  3.981424e-01, -1.428191e-01, -2.792416e-01},
  { 9.136073e-02, -2.146350e-02, -9.955865e-01,  3.084309e-01, -1.369786e-01, -3.274691e-01},
  {-2.102176e-02, -7.692776e-02, -9.968151e-01,  2.560080e-01, -1.415913e-01, -3.263689e-01},
  { 4.063768e-01,  1.962759e-01, -8.923753e-01,  3.530146e-01, -1.356314e-01, -3.203735e-01},
  { 6.555821e-01,  9.339890e-03, -7.550660e-01,  3.806586e-01, -1.423970e-01, -3.066415e-01},
  {-2.545802e-01, -3.974290e-01, -8.816116e-01,  1.533016e-01, -1.437141e-01, -2.827261e-01},
  {-4.114977e-01, -1.380225e-01, -9.008992e-01,  1.899679e-01, -1.389707e-01, -3.129696e-01},
  {-1.962234e-01, -1.160638e-01, -9.736660e-01,  2.177961e-01, -1.526511e-01, -3.235525e-01},
  {-3.894582e-01,  9.210441e-01,  2.672133e-05,  6.804643e-01,  6.916741e-01,  0.000000e+00},
  {-2.307383e-01,  7.136372e-01, -6.614240e-01,  6.227203e-01,  6.481206e-01, -4.290663e-02},
  {-3.785499e-01,  6.869406e-01, -6.203327e-01,  6.930189e-01,  6.767642e-01, -4.661837e-02},
  {-1.291203e-01,  4.511543e-01, -8.830559e-01,  6.236497e-01,  6.100185e-01, -7.687767e-02},
  {-2.280740e-01,  3.822972e-01, -8.954502e-01,  7.061726e-01,  6.055025e-01, -9.455766e-02},
  {-1.736769e-01,  1.542798e-01, -9.726428e-01,  7.359822e-01,  4.910288e-01, -1.249073e-01},
  { 6.349067e-02,  8.637874e-02, -9.942372e-01,  6.694232e-01,  3.691356e-01, -1.355873e-01},
  { 1.822565e-01, -6.076378e-02, -9.813717e-01,  7.638743e-01,  3.227565e-01, -1.247371e-01},
  { 2.418413e-01, -4.805285e-02, -9.691252e-01,  6.901053e-01,  2.747297e-01, -1.353140e-01},
  { 4.254027e-01, -2.664329e-01, -8.648965e-01,  7.149256e-01,  1.746706e-01, -1.142273e-01},
  { 3.608078e-01, -2.907360e-01, -8.861660e-01,  7.765846e-01,  2.272807e-01, -1.028142e-01},
  { 6.805887e-01, -4.955733e-01, -5.396352e-01,  7.570808e-01,  8.907030e-02, -5.293112e-02},
  { 7.421252e-01, -6.026319e-01, -2.934026e-01,  8.148643e-01,  1.663758e-01, -5.087217e-02},
  { 8.102341e-01, -5.861030e-01,  1.958411e-03,  7.417871e-01,  7.138003e-02, -1.741886e-06},
  {-4.632099e-01,  8.235639e-01, -3.273820e-01,  7.358064e-01,  7.126586e-01, -2.511183e-02},
  {-5.040897e-01,  8.636514e-01, -8.539912e-05,  7.908733e-01,  7.502608e-01, -1.717433e-05},
  { 3.950152e-01, -9.186744e-01,  5.179336e-04,  9.251564e-01,  2.869944e-01,  4.413351e-07},
  { 4.312281e-01, -6.995526e-01, -5.697969e-01,  9.209640e-01,  2.934667e-01, -5.106650e-02},
  { 1.659998e-01, -3.575537e-01, -9.190210e-01,  8.423480e-01,  3.070962e-01, -1.072639e-01},
  {-4.741217e-01, -6.599644e-02, -8.779824e-01,  8.216651e-01,  6.590428e-01, -1.158731e-01},
  {-3.567704e-01,  3.313783e-01, -8.734434e-01,  7.463018e-01,  6.637534e-01, -8.491410e-02},
  {-5.919820e-01,  6.387288e-01, -4.915108e-01,  8.097711e-01,  7.402588e-01, -6.299911e-02},
  { 7.819796e-01, -5.004464e-01, -3.715662e-01,  7.024115e-01,  1.194178e-02, -5.937492e-02},
  { 3.021777e-02,  9.239452e-01, -3.813293e-01,  4.474556e-01,  6.004301e-01, -5.828004e-02},
  { 1.874127e-03,  6.367358e-01, -7.710798e-01,  5.363103e-01,  5.819930e-01, -8.218201e-02},
  { 1.769438e-01,  5.966806e-01, -7.827280e-01,  4.579732e-01,  5.729947e-01, -9.033568e-02},
  { 3.183588e-01,  3.093472e-02, -9.474655e-01,  5.984520e-01,  3.297721e-01, -1.480916e-01},
  { 4.516809e-01,  2.750365e-01, -8.487280e-01,  5.414667e-01,  3.273996e-01, -1.706471e-01},
  { 4.065157e-01, -8.298919e-02, -9.098669e-01,  6.482775e-01,  1.742897e-01, -1.474217e-01},
  { 4.385462e-01, -1.632750e-01, -8.837526e-01,  6.040331e-01,  8.451901e-02, -1.450888e-01},
  { 7.129129e-01,  3.449731e-01, -6.105315e-01,  5.271223e-01,  3.002496e-01, -1.963494e-01},
  { 6.486985e-01,  2.186860e-01, -7.289491e-01,  5.486873e-01,  2.327140e-01, -1.969451e-01},
  { 7.817399e-01,  7.465366e-02, -6.191200e-01,  5.548175e-01,  1.796076e-01, -2.037353e-01},
  { 7.156389e-01, -1.416694e-01, -6.839523e-01,  5.564202e-01,  1.341351e-01, -2.000289e-01},
  { 7.911395e-01, -1.913092e-01, -5.809466e-01,  5.525253e-01,  8.828968e-02, -1.925557e-01},
  { 5.459213e-01,  4.695932e-01, -6.938676e-01,  4.615588e-01,  3.882836e-01, -2.029281e-01},
  { 4.633518e-01,  4.812341e-01, -7.441230e-01,  4.503422e-01,  4.460923e-01, -1.722960e-01},
  { 6.293465e-01, -3.911537e-01, -6.715071e-01,  4.806302e-01, -3.919307e-02, -2.505940e-01},
  { 8.326744e-01, -2.106679e-01, -5.121254e-01,  5.221022e-01,  1.961996e-02, -2.251459e-01},
  { 6.803820e-01, -2.731822e-01, -6.800380e-01,  4.892591e-01,  6.141773e-03, -2.692713e-01},
  { 7.679592e-01, -1.698316e-01, -6.175727e-01,  5.037242e-01,  6.937543e-02, -2.671017e-01},
  { 8.549787e-01, -9.529915e-02, -5.098329e-01,  5.355496e-01,  1.297078e-01, -2.365544e-01},
  { 7.123236e-01, -4.138102e-02, -7.006302e-01,  5.069556e-01,  1.322954e-01, -2.812656e-01},
  { 7.413487e-01,  1.284653e-01, -6.587099e-01,  5.173019e-01,  1.812060e-01, -2.689825e-01},
  { 8.621637e-01,  8.401848e-02, -4.996144e-01,  5.366465e-01,  1.806683e-01, -2.401867e-01},
  { 6.150895e-01,  3.369036e-01, -7.128540e-01,  4.991264e-01,  2.476964e-01, -2.603090e-01},
  { 7.979674e-01,  2.628652e-01, -5.423558e-01,  5.291387e-01,  2.321547e-01, -2.298590e-01},
  { 6.994197e-01,  4.060755e-01, -5.881453e-01,  5.029762e-01,  3.173091e-01, -2.134927e-01},
  { 5.274137e-01,  4.408579e-01, -7.262776e-01,  4.823727e-01,  3.241173e-01, -2.313371e-01},
  {-4.995240e-02,  9.546099e-01, -2.936404e-01,  3.803166e-01,  6.009607e-01, -4.575997e-02},
  {-7.539534e-02,  9.971536e-01,  3.834401e-05,  3.788424e-01,  6.100587e-01,  6.324217e-06},
  { 6.324155e-01, -4.006059e-01, -6.629974e-01,  4.196469e-01, -8.577594e-02, -2.757878e-01},
  { 6.785154e-01, -2.136745e-01, -7.028228e-01,  3.990341e-01, -1.101319e-01, -2.777747e-01},
  { 2.851941e-02,  8.070286e-01, -5.898234e-01,  3.526675e-01,  5.786316e-01, -8.881193e-02},
  { 6.403972e-03,  9.423153e-01, -3.346653e-01,  3.397954e-01,  5.968170e-01, -5.414411e-02},
  { 2.233204e-01,  5.854447e-01, -7.793475e-01,  3.947244e-01,  4.730043e-01, -1.803826e-01},
  { 3.103119e-01,  4.967121e-01, -8.105454e-01,  4.145948e-01,  4.099815e-01, -2.137809e-01},
  { 3.120719e-01,  4.542251e-01, -8.344404e-01,  4.292680e-01,  3.357294e-01, -2.518805e-01},
  { 3.311513e-01,  3.835596e-01, -8.621026e-01,  4.442526e-01,  2.626263e-01, -2.844607e-01},
  { 4.287553e-01,  1.971389e-01, -8.816491e-01,  4.632632e-01,  1.825674e-01, -3.056239e-01},
  { 5.201347e-01, -6.022017e-02, -8.519585e-01,  4.681219e-01,  1.103890e-01, -3.120105e-01},
  { 5.031183e-01, -1.259748e-01, -8.549867e-01,  4.521823e-01,  5.809744e-02, -3.114755e-01},
  { 4.274556e-01, -2.613426e-01, -8.654373e-01,  4.398297e-01,  1.671704e-02, -3.113482e-01},
  { 5.372213e-01, -3.882409e-01, -7.487738e-01,  4.348989e-01, -3.833539e-02, -2.872664e-01},
  { 2.953229e-01, -1.077062e-01, -9.493070e-01,  3.361055e-01, -7.532128e-02, -3.206463e-01},
  { 2.297950e-01, -1.780485e-01, -9.568140e-01,  3.568299e-01,  1.410186e-02, -3.368256e-01},
  { 7.200082e-03,  9.719973e-01, -2.348816e-01,  2.766550e-01,  6.034320e-01, -3.873599e-02},
  {-2.651390e-02,  9.991252e-01,  3.233840e-02,  3.398423e-01,  6.065373e-01,  1.368739e-05},
  { 7.550307e-03,  9.999714e-01,  2.090508e-04,  2.768242e-01,  6.093187e-01,  1.724467e-05},
  { 2.239046e-01, -9.210585e-02, -9.702491e-01,  3.756797e-01,  6.023000e-02, -3.410860e-01},
  { 2.153733e-01,  4.352858e-02, -9.755611e-01,  3.739269e-01,  1.108798e-01, -3.422209e-01},
  { 1.178394e-01,  2.460072e-01, -9.620782e-01,  3.529959e-01,  1.941172e-01, -3.328093e-01},
  { 1.243166e-01,  3.816412e-01, -9.159123e-01,  3.300404e-01,  2.692782e-01, -3.065778e-01},
  { 1.358341e-01,  4.553067e-01, -8.799118e-01,  3.252497e-01,  3.547273e-01, -2.693216e-01},
  { 1.131052e-01,  5.393758e-01, -8.344345e-01,  3.150015e-01,  4.345560e-01, -2.261209e-01},
  { 5.963014e-02,  6.935416e-01, -7.179445e-01,  2.960803e-01,  5.100988e-01, -1.716689e-01},
  {-5.242459e-03,  8.554569e-01, -5.178474e-01,  2.701042e-01,  5.886257e-01, -7.434417e-02},
  {-6.353259e-02,  8.180156e-01, -5.716764e-01,  1.590526e-02,  5.634499e-01, -8.093983e-02},
  {-7.612689e-03,  9.203882e-01, -3.909318e-01, -1.428939e-01,  5.831480e-01, -3.848130e-02},
  {-6.649873e-02,  9.977865e-01,  8.092999e-05,  2.174402e-02,  5.929875e-01,  2.665455e-06},
  {-5.125443e-02,  8.346923e-01, -5.483263e-01, -1.546945e-01,  5.587762e-01, -8.299797e-02},
  { 2.146880e-02,  7.666420e-01, -6.417158e-01, -1.351706e-01,  5.228844e-01, -1.307192e-01},
  {-4.375247e-03,  5.729123e-01, -8.196051e-01,  6.924402e-03,  4.048061e-01, -2.335852e-01},
  { 7.894009e-02,  6.470889e-01, -7.583168e-01, -1.381045e-01,  4.161622e-01, -2.347094e-01},
  { 1.104540e-01,  4.930864e-01, -8.629402e-01, -1.202847e-01,  3.234269e-01, -2.997182e-01},
  { 9.607410e-02,  2.743355e-01, -9.568228e-01,  4.068547e-02,  1.822741e-01, -3.412835e-01},
  { 2.539959e-01,  2.098085e-01, -9.441750e-01, -8.175389e-02,  1.155122e-01, -3.782669e-01},
  { 1.123802e-01, -9.298431e-02, -9.893051e-01,  5.071780e-02,  3.596223e-02, -3.422954e-01},
  { 2.282007e-01, -2.934514e-01, -9.283376e-01,  3.729863e-02, -2.328175e-02, -3.284595e-01},
  { 3.540590e-01, -1.876965e-01, -9.161944e-01, -7.106672e-02, -5.246473e-02, -3.658021e-01},
  { 2.151740e-01, -3.292306e-01, -9.194060e-01,  4.093235e-02, -7.052394e-02, -3.114314e-01},
  { 2.249177e-01, -4.404268e-01, -8.691583e-01,  2.897193e-02, -1.310924e-01, -2.900407e-01},
  { 3.738939e-01, -3.801951e-01, -8.459639e-01, -7.524378e-02, -1.189099e-01, -3.437483e-01},
  { 3.303717e-01, -6.045154e-01, -7.248557e-01, -6.768442e-02, -1.894112e-01, -3.006858e-01},
  { 8.373430e-02, -5.506340e-01, -8.305365e-01,  5.564490e-02, -1.751866e-01, -2.585651e-01},
  { 1.433093e-01, -9.486721e-01, -2.819285e-01,  2.921999e-02, -2.967173e-01, -1.180085e-01},
  { 1.944780e-01,  9.270881e-01, -3.204466e-01, -3.655388e-01,  5.866469e-01, -4.424493e-02},
  { 9.414953e-02,  9.955581e-01,  3.752932e-05, -3.449890e-01,  5.945020e-01,  7.133567e-06},
  { 2.368925e-01,  7.871613e-01, -5.694375e-01, -3.730649e-01,  5.289326e-01, -1.689437e-01},
  { 1.076605e-01,  7.739860e-01, -6.239830e-01, -2.492852e-01,  5.182024e-01, -1.534634e-01},
  { 1.512939e-01,  5.810218e-01, -7.997024e-01, -4.584144e-01,  4.461136e-01, -2.451939e-01},
  { 1.673946e-01,  5.259104e-01, -8.339049e-01, -2.576844e-01,  2.698571e-01, -3.518506e-01},
  { 8.612491e-02,  4.742360e-01, -8.761750e-01, -4.061216e-01,  2.496109e-01, -3.878713e-01},
  { 2.081506e-01,  4.187529e-01, -8.839226e-01, -2.121927e-01,  1.764064e-01, -3.935553e-01},
  { 6.327879e-02,  3.381054e-01, -9.389785e-01, -3.800187e-01,  1.688895e-01, -4.245774e-01},
  { 2.015457e-01,  2.348489e-01, -9.509076e-01, -2.281202e-01,  1.200316e-01, -4.171135e-01},
  { 9.407270e-02,  1.302727e-01, -9.870052e-01, -3.489918e-01,  7.382682e-02, -4.469351e-01},
  { 2.797858e-01,  4.627605e-02, -9.589465e-01, -1.824326e-01,  6.111249e-02, -4.136988e-01},
  { 9.323598e-02, -9.170874e-02, -9.914114e-01, -3.574528e-01, -4.136622e-02, -4.523091e-01},
  { 2.668973e-01, -5.135814e-02, -9.623556e-01, -2.091438e-01, -1.212466e-02, -4.230216e-01},
  { 2.937263e-01, -2.608124e-01, -9.196205e-01, -2.113211e-01, -9.863316e-02, -4.090692e-01},
  { 9.637999e-02, -3.442138e-01, -9.339313e-01, -3.550765e-01, -1.349367e-01, -4.338202e-01},
  { 2.965110e-01, -4.732740e-01, -8.295138e-01, -2.195977e-01, -1.788741e-01, -3.782185e-01},
  { 7.567242e-02, -5.796411e-01, -8.113507e-01, -3.547391e-01, -2.079464e-01, -3.966375e-01},
  { 1.191494e-02, -7.661728e-01, -6.425241e-01, -3.709296e-01, -2.568877e-01, -3.541397e-01},
  { 2.367597e-01, -7.012398e-01, -6.724638e-01, -2.381384e-01, -2.427145e-01, -3.349009e-01},
  { 2.226338e-01, -7.713118e-01, -5.962485e-01, -2.439783e-01, -2.812328e-01, -2.888092e-01},
  { 2.341895e-02, -8.174581e-01, -5.755118e-01, -3.581154e-01, -2.863533e-01, -3.100050e-01},
  { 5.065902e-02,  9.987161e-01,  5.831713e-05, -4.353635e-01,  5.985246e-01,  6.752760e-06},
  { 1.383114e-01,  9.261045e-01, -3.509992e-01, -4.912614e-01,  5.625665e-01, -1.448630e-01},
  { 2.395442e-01,  6.902332e-01, -6.827859e-01, -4.856457e-01,  5.321574e-01, -1.989812e-01},
  { 2.001728e-01,  8.776621e-01, -4.354768e-01, -5.688077e-01,  5.582967e-01, -1.922915e-01},
  { 2.928767e-01,  6.741602e-01, -6.780348e-01, -5.979568e-01,  5.316783e-01, -2.436575e-01},
  { 2.958549e-01,  4.711989e-01, -8.309281e-01, -5.585979e-01,  4.518806e-01, -2.691646e-01},
  { 2.989553e-01,  4.680761e-01, -8.315831e-01, -6.340964e-01,  4.982247e-01, -2.834419e-01},
  { 2.248069e-01,  3.471067e-01, -9.104826e-01, -6.320120e-01,  4.333215e-01, -3.099555e-01},
  { 6.547366e-02,  5.110760e-01, -8.570382e-01, -5.290303e-01,  3.266008e-01, -3.499118e-01},
  { 2.503686e-02,  3.578986e-01, -9.334248e-01, -6.174398e-01,  3.602865e-01, -3.364364e-01},
  {-1.613081e-01,  3.420909e-01, -9.257178e-01, -6.094109e-01,  2.794250e-01, -3.655039e-01},
  {-7.225902e-02,  3.737113e-01, -9.247262e-01, -5.156422e-01,  2.336680e-01, -3.968270e-01},
  {-2.237180e-01,  2.994571e-01, -9.275105e-01, -6.224007e-01,  1.969771e-01, -3.901421e-01},
  {-1.127899e-01,  2.337431e-01, -9.657342e-01, -5.042860e-01,  1.489337e-01, -4.257343e-01},
  {-1.398451e-01,  4.139724e-02, -9.893077e-01, -4.961892e-01,  2.422031e-02, -4.495054e-01},
  {-2.150960e-01,  6.918380e-02, -9.741393e-01, -6.138114e-01,  9.792201e-02, -4.129752e-01},
  {-3.412175e-01, -1.712391e-01, -9.242552e-01, -6.019390e-01, -4.099448e-02, -4.176434e-01},
  {-1.745254e-01, -2.403176e-01, -9.548761e-01, -4.961370e-01, -1.008127e-01, -4.390562e-01},
  {-2.054782e-01, -5.047023e-01, -8.384833e-01, -4.925194e-01, -1.789980e-01, -4.062150e-01},
  {-4.272453e-01, -4.038784e-01, -8.089151e-01, -5.978609e-01, -1.238247e-01, -3.924483e-01},
  {-4.703695e-01, -6.185164e-01, -6.294363e-01, -5.975150e-01, -1.787101e-01, -3.545937e-01},
  {-2.381578e-01, -7.160165e-01, -6.562021e-01, -4.847385e-01, -2.329836e-01, -3.643546e-01},
  {-4.880461e-01, -7.206765e-01, -4.923784e-01, -5.940138e-01, -2.206428e-01, -2.989169e-01},
  {-2.367740e-01, -8.090936e-01, -5.378714e-01, -4.727289e-01, -2.703763e-01, -3.135819e-01},
  {-7.391737e-02, -5.975535e-02, -9.954726e-01,  2.421626e-01, -1.152595e-01, -3.284864e-01},
  {-1.094443e-01, -1.745723e-01, -9.785430e-01,  2.355179e-01, -6.952778e-02, -3.338655e-01},
  {-6.185887e-02,  9.463011e-01, -3.173131e-01,  1.874184e-01,  5.990784e-01, -4.841500e-02},
  {-4.686406e-02,  9.989013e-01,  1.633448e-04,  1.965114e-01,  6.069885e-01,  2.195244e-05},
  {-8.835290e-02,  8.852521e-01, -4.566427e-01,  1.616535e-01,  5.854689e-01, -7.023083e-02},
  {-5.145142e-02,  8.171504e-01, -5.741236e-01,  1.914470e-01,  5.666215e-01, -1.040952e-01},
  {-4.850155e-02,  7.466817e-01, -6.634109e-01,  1.795323e-01,  5.327777e-01, -1.463997e-01},
  {-6.072388e-02,  6.273052e-01, -7.764025e-01,  1.839671e-01,  4.806633e-01, -1.963572e-01},
  {-1.193105e-02,  4.988489e-01, -8.666068e-01,  1.856337e-01,  3.895045e-01, -2.561743e-01},
  {-4.570530e-03,  4.009877e-01, -9.160721e-01,  2.084117e-01,  3.168461e-01, -2.940970e-01},
  { 1.520958e-02,  2.219949e-01, -9.749292e-01,  2.197258e-01,  2.460474e-01, -3.185958e-01},
  { 1.625716e-02,  8.055565e-02, -9.966175e-01,  2.437564e-01,  6.651025e-02, -3.477544e-01},
  {-9.231264e-04, -1.542144e-01, -9.880369e-01,  2.485012e-01,  7.874154e-03, -3.555243e-01},
  {-2.461129e-01, -9.414428e-01, -2.304648e-01,  1.118497e-01, -2.813279e-01, -1.619318e-01},
  {-6.848025e-02, -7.532250e-01, -6.541885e-01,  9.596667e-02, -2.467997e-01, -1.936712e-01},
  {-1.586880e-01, -2.838575e-01, -9.456443e-01,  1.483888e-01, -5.190093e-02, -3.116491e-01},
  {-3.791110e-01, -3.923742e-01, -8.380438e-01,  1.215972e-01, -1.742574e-01, -2.538958e-01},
  { 1.034705e-01,  9.946301e-01,  2.193624e-03, -5.816153e-01,  6.128531e-01, -1.603875e-06},
  { 1.349836e-01,  9.540281e-01, -2.676001e-01, -6.098112e-01,  5.813531e-01, -1.462117e-01},
  { 1.244791e-01,  9.106032e-01, -3.940898e-01, -6.327805e-01,  5.697871e-01, -1.986332e-01},
  { 8.998670e-02,  7.320759e-01, -6.752535e-01, -6.633890e-01,  5.397817e-01, -2.623797e-01},
  { 3.848654e-02,  4.140256e-01, -9.094512e-01, -6.892121e-01,  4.866324e-01, -3.016003e-01},
  {-3.345951e-02,  2.245000e-01, -9.738995e-01, -6.937449e-01,  4.070084e-01, -3.227009e-01},
  {-1.792774e-01,  2.304807e-01, -9.564195e-01, -7.057279e-01,  2.418592e-01, -3.498147e-01},
  {-2.063365e-01,  3.363360e-01, -9.188598e-01, -7.018129e-01,  1.947724e-01, -3.634371e-01},
  {-3.026725e-01, -3.776098e-01, -8.751001e-01, -7.093128e-01, -3.627155e-02, -3.630656e-01},
  {-3.873838e-01, -5.680221e-01, -7.261436e-01, -6.980227e-01, -1.050997e-01, -3.301477e-01},
  { 6.365775e-02,  9.979718e-01,  1.084002e-06, -6.620293e-01,  6.182915e-01, -9.003842e-07},
  { 5.885751e-02,  9.643715e-01, -2.579212e-01, -6.969657e-01,  5.943703e-01, -1.244677e-01},
  {-1.089301e-02,  8.871203e-01, -4.614097e-01, -7.366512e-01,  5.650949e-01, -2.117204e-01},
  {-6.970320e-02,  6.283997e-01, -7.747614e-01, -7.559550e-01,  5.101213e-01, -2.795580e-01},
  {-4.774486e-02,  2.874409e-01, -9.566076e-01, -7.618898e-01,  4.392396e-01, -3.109155e-01},
  {-2.632004e-02,  1.509522e-01, -9.881906e-01, -7.696407e-01,  3.540096e-01, -3.228289e-01},
  {-1.562319e-02,  1.926047e-01, -9.811521e-01, -7.759742e-01,  2.767826e-01, -3.336648e-01},
  {-6.099989e-03,  2.444843e-01, -9.696341e-01, -7.678574e-01,  2.275412e-01, -3.460161e-01},
  {-1.574120e-01, -1.529319e-01, -9.756194e-01, -7.539558e-01,  4.345543e-02, -3.762315e-01},
  { 1.100142e-02, -5.037975e-01, -8.637518e-01, -7.753836e-01, -8.230793e-02, -3.206741e-01},
  {-1.081184e-02, -8.044729e-01, -5.938909e-01, -7.739086e-01, -1.225438e-01, -2.932873e-01},
  { 9.649712e-02,  9.953333e-01,  4.571188e-06, -7.663562e-01,  6.250840e-01,  1.534783e-06},
  { 6.840573e-02,  9.479607e-01, -3.109521e-01, -8.271487e-01,  6.007951e-01, -1.302562e-01},
  { 2.593819e-03,  8.106158e-01, -5.855726e-01, -8.289559e-01,  5.590932e-01, -2.217967e-01},
  {-2.983256e-02,  5.211866e-01, -8.529212e-01, -8.361326e-01,  4.910384e-01, -2.883152e-01},
  { 1.913958e-02,  2.532528e-01, -9.672108e-01, -8.460968e-01,  4.092378e-01, -3.189985e-01},
  {-9.840265e-02,  1.452732e-01, -9.844859e-01, -7.969071e-01,  1.116266e-01, -3.818198e-01},
  { 1.510903e-02, -2.271308e-01, -9.737470e-01, -8.170927e-01,  2.278914e-02, -3.776337e-01},
  { 1.832690e-01, -4.029954e-01, -8.966645e-01, -8.332874e-01, -6.001810e-02, -3.477051e-01},
  { 4.425946e-01, -5.662701e-01, -6.953045e-01, -8.466393e-01, -1.606618e-01, -2.915104e-01},
  { 1.098397e-01,  9.930056e-01,  4.330399e-02, -9.067749e-01,  6.432243e-01,  3.074925e-06},
  { 4.974981e-02,  9.403330e-01, -3.365991e-01, -9.647123e-01,  6.180441e-01, -1.164330e-01},
  { 2.537864e-02,  8.705665e-01, -4.913960e-01, -9.535400e-01,  5.926783e-01, -1.729620e-01},
  {-4.128228e-02,  6.847246e-01, -7.276317e-01, -9.513938e-01,  5.430525e-01, -2.421584e-01},
  {-9.567918e-02,  4.144912e-01, -9.050097e-01, -9.438477e-01,  4.622096e-01, -2.983790e-01},
  {-1.108508e-01,  2.244186e-01, -9.681675e-01, -9.250773e-01,  3.644206e-01, -3.321001e-01},
  {-2.085746e-02,  1.524951e-01, -9.880841e-01, -9.130838e-01,  3.012614e-01, -3.427982e-01},
  {-5.875036e-02,  1.341672e-01, -9.892156e-01, -8.971922e-01,  2.618480e-01, -3.483877e-01},
  {-6.273724e-02,  1.923899e-01, -9.793111e-01, -8.967822e-01,  2.011718e-01, -3.576224e-01},
  {-1.363762e-01,  1.672128e-01, -9.764432e-01, -8.709162e-01,  1.436141e-01, -3.732098e-01},
  {-1.205803e-01, -4.394629e-03, -9.926938e-01, -8.764665e-01,  8.480200e-02, -3.780529e-01},
  {-4.525398e-02, -1.886638e-01, -9.809985e-01, -8.768193e-01,  4.729454e-05, -3.705570e-01},
  { 1.938273e-01, -3.029365e-01, -9.330918e-01, -8.841770e-01, -1.033768e-01, -3.405266e-01},
  { 4.117319e-01, -4.043935e-01, -8.166656e-01, -9.204565e-01, -2.127495e-01, -3.213601e-01},
  { 1.172310e-01,  9.849421e-01,  1.270666e-01, -1.050095e+00,  6.719022e-01,  0.000000e+00},
  {-1.427328e-02,  9.213720e-01, -3.884197e-01, -1.048218e+00,  6.261802e-01, -9.945184e-02},
  {-1.144426e-01,  8.496811e-01, -5.147280e-01, -1.066384e+00,  6.047508e-01, -1.511860e-01},
  {-1.829681e-01,  7.101838e-01, -6.798248e-01, -1.052858e+00,  5.656949e-01, -2.108621e-01},
  {-2.526305e-01,  4.493312e-01, -8.569010e-01, -1.039327e+00,  5.073697e-01, -2.577430e-01},
  {-3.314371e-01,  2.372562e-01, -9.131588e-01, -1.018872e+00,  4.161417e-01, -2.994486e-01},
  {-3.305299e-01,  1.147273e-01, -9.367965e-01, -9.956926e-01,  3.239349e-01, -3.234521e-01},
  {-2.699597e-01,  1.236881e-01, -9.548942e-01, -9.761710e-01,  2.472368e-01, -3.357559e-01},
  {-2.167522e-01,  2.435229e-02, -9.759229e-01, -9.441084e-01,  5.661230e-02, -3.642640e-01},
  {-1.125665e-01, -1.310106e-01, -9.849696e-01, -9.396326e-01, -2.696124e-02, -3.614277e-01},
  {-3.885547e-02, -1.842004e-01, -9.821204e-01, -9.481331e-01, -1.255662e-01, -3.425599e-01},
  {-6.158938e-02, -1.875744e-01, -9.803175e-01, -9.781210e-01, -2.242138e-01, -3.219694e-01},
  {-5.097485e-01,  8.134535e-01, -2.800890e-01, -1.138468e+00,  6.192353e-01, -1.046588e-01},
  {-3.450843e-01,  9.385718e-01,  2.459890e-05, -1.147911e+00,  6.079769e-01,  0.000000e+00},
  { 8.371120e-01, -5.470314e-01, -4.091792e-04, -1.176202e+00,  5.878224e-01,  3.818942e-06},
  {-5.672122e-01,  5.557593e-01, -6.077844e-01, -1.185944e+00,  5.560811e-01, -1.347256e-01},
  {-4.102553e-01,  6.898813e-01, -5.964516e-01, -1.144617e+00,  5.900315e-01, -1.414321e-01},
  {-4.648374e-01,  5.538768e-01, -6.907581e-01, -1.131995e+00,  5.539586e-01, -1.828354e-01},
  {-5.893984e-01,  3.655621e-01, -7.203984e-01, -1.188037e+00,  5.138727e-01, -1.614387e-01},
  {-4.544032e-01,  4.061946e-01, -7.927948e-01, -1.107513e+00,  5.143974e-01, -2.270585e-01},
  {-5.986858e-01,  2.510057e-01, -7.606388e-01, -1.160833e+00,  4.798302e-01, -1.970704e-01},
  {-5.104451e-01,  1.936904e-01, -8.378126e-01, -1.102485e+00,  4.484660e-01, -2.476595e-01},
  {-6.597137e-01,  8.570363e-02, -7.466141e-01, -1.161795e+00,  4.080347e-01, -2.097161e-01},
  {-5.161933e-01,  1.298598e-01, -8.465701e-01, -1.090683e+00,  3.428883e-01, -2.714291e-01},
  {-6.644424e-01,  1.063820e-01, -7.397291e-01, -1.146992e+00,  3.195399e-01, -2.380562e-01},
  {-5.534231e-01,  9.934108e-02, -8.269548e-01, -1.123120e+00,  2.376913e-01, -2.670898e-01},
  {-4.356473e-01,  1.186069e-01, -8.922689e-01, -1.045464e+00,  1.831004e-01, -3.190539e-01},
  {-5.731910e-01,  5.337033e-02, -8.176819e-01, -1.101174e+00,  1.800062e-01, -2.892349e-01},
  {-5.689697e-01,  8.163800e-03, -8.223180e-01, -1.086215e+00,  1.208911e-01, -3.006182e-01},
  {-3.674947e-01,  7.726696e-02, -9.268103e-01, -1.020636e+00,  1.163170e-01, -3.357322e-01},
  {-3.434429e-01,  3.491390e-03, -9.391671e-01, -1.004553e+00,  2.574977e-02, -3.493161e-01},
  {-5.754929e-01, -2.212651e-02, -8.175074e-01, -1.065373e+00,  2.866138e-02, -3.152578e-01},
  {-6.166881e-01, -7.514194e-02, -7.836130e-01, -1.065420e+00, -6.548925e-02, -3.093639e-01},
  {-3.514868e-01, -9.131078e-02, -9.317293e-01, -1.009519e+00, -5.091091e-02, -3.442757e-01},
  {-7.075914e-01, -5.038896e-02, -7.048230e-01, -1.074495e+00, -1.548660e-01, -2.904998e-01},
  {-3.636190e-01, -1.343752e-01, -9.218050e-01, -1.019665e+00, -1.468851e-01, -3.279877e-01},
  {-4.470677e-01, -9.859218e-02, -8.890501e-01, -1.037719e+00, -2.245261e-01, -3.082941e-01},
  {-8.536289e-01,  4.442726e-01, -2.719184e-01, -1.242131e+00,  5.584328e-01, -8.128356e-02},
  {-8.490632e-01,  5.282914e-01, -2.133199e-06, -1.229932e+00,  5.619152e-01,  0.000000e+00},
  {-8.804849e-01,  1.649534e-01, -4.444511e-01, -1.231939e+00,  5.246375e-01, -1.193451e-01},
  {-8.623315e-01,  2.451695e-02, -5.057502e-01, -1.220147e+00,  4.487076e-01, -1.579655e-01},
  {-9.327300e-01, -1.203091e-01, -3.399125e-01, -1.209718e+00,  3.896575e-01, -1.556850e-01},
  {-8.873964e-01, -1.653887e-02, -4.607104e-01, -1.190738e+00,  3.207166e-01, -1.873678e-01},
  {-8.514912e-01, -2.907722e-02, -5.235620e-01, -1.171009e+00,  2.358882e-01, -2.214795e-01},
  {-7.881520e-01, -4.765579e-02, -6.136329e-01, -1.146201e+00,  1.599963e-01, -2.494121e-01},
  {-7.893805e-01, -9.077418e-02, -6.071561e-01, -1.129817e+00,  7.879806e-02, -2.606258e-01},
  {-8.115340e-01, -1.134278e-01, -5.731898e-01, -1.112240e+00, -5.118697e-03, -2.679543e-01},
  {-8.477021e-01, -1.226052e-01, -5.161095e-01, -1.099856e+00, -7.822305e-02, -2.739480e-01},
  {-8.121998e-01,  1.013759e-01, -5.745036e-01, -1.116165e+00, -2.033970e-01, -2.520269e-01},
  {-9.880068e-01, -1.436276e-01,  5.668821e-02, -1.235179e+00,  4.928339e-01, -5.830377e-02},
  {-9.830734e-01, -1.832124e-01, -2.555499e-06, -1.235203e+00,  5.111636e-01,  0.000000e+00},
  {-9.881174e-01, -1.534818e-01, -8.203335e-03, -1.225838e+00,  4.423400e-01, -8.218209e-02},
  {-9.881554e-01, -1.503338e-01, -3.080271e-02, -1.221512e+00,  4.104554e-01, -9.977178e-02},
  {-9.809076e-01, -1.870558e-01,  5.320196e-02, -1.216795e+00,  3.750428e-01, -8.704942e-02},
  {-9.851406e-01, -1.715291e-01, -8.705302e-03, -1.206590e+00,  3.155930e-01, -1.159021e-01},
  {-9.859373e-01, -1.353450e-01, -9.802797e-02, -1.192180e+00,  2.333363e-01, -1.484873e-01},
  {-9.735641e-01, -9.290851e-02, -2.086647e-01, -1.177119e+00,  1.611172e-01, -1.772252e-01},
  {-9.434275e-01, -1.536820e-01, -2.938135e-01, -1.160006e+00,  8.985449e-02, -2.038116e-01},
  {-9.226756e-01, -1.826317e-01, -3.395813e-01, -1.143596e+00,  2.561581e-02, -2.169716e-01},
  {-6.684827e-01,  6.643543e-02, -7.407545e-01, -1.123023e+00, -7.101974e-01, -3.107352e-01},
  { 9.972258e-02,  2.945737e-01, -9.504114e-01, -1.111842e+00, -6.559944e-01, -2.996397e-01},
  { 5.905228e-01,  3.340860e-01, -7.346219e-01, -1.035201e+00, -6.856467e-01, -2.962074e-01},
  { 4.431430e-01,  2.857794e-01, -8.496790e-01, -1.054420e+00, -6.405297e-01, -2.871912e-01},
  { 9.820874e-01,  1.751447e-01,  6.948848e-02, -1.044273e+00, -6.405809e-01, -2.661719e-01},
  {-4.637424e-01, -1.052031e-01, -8.797018e-01, -1.122869e+00, -7.258524e-01, -3.069780e-01},
  { 1.786592e-02, -3.551301e-01, -9.346461e-01, -1.106036e+00, -7.442688e-01, -3.048768e-01},
  {-2.716562e-01, -6.355519e-01, -7.226871e-01, -1.126914e+00, -7.517781e-01, -3.087293e-01},
  {-5.548536e-01, -5.185416e-01, -6.505781e-01, -1.099587e+00, -7.569420e-01, -2.960591e-01},
  {-9.162294e-02,  4.336443e-01, -8.964139e-01, -1.051534e+00, -7.625369e-01, -3.288845e-01},
  { 1.423761e-01,  5.069443e-01, -8.501391e-01, -1.017282e+00, -7.629749e-01, -3.287027e-01},
  { 3.641429e-01,  5.274975e-01, -7.675586e-01, -9.973480e-01, -7.860713e-01, -3.356595e-01},
  { 4.071160e-01,  6.559764e-01, -6.355717e-01, -9.665926e-01, -8.212131e-01, -3.493426e-01},
  {-2.569805e-02,  4.286356e-01, -9.031119e-01, -1.003953e+00, -8.291972e-01, -3.643431e-01},
  { 3.496299e-01, -5.736697e-01, -7.407172e-01, -9.652891e-01, -8.712917e-01, -3.792205e-01},
  { 4.814932e-01,  2.198375e-01, -8.484313e-01, -9.382994e-01, -8.594283e-01, -3.682462e-01},
  {-3.571857e-01, -5.982741e-01, -7.172772e-01, -1.034748e+00, -8.729193e-01, -3.708838e-01},
  {-3.918632e-01,  2.492394e-01, -8.856201e-01, -1.043721e+00, -8.347725e-01, -3.582930e-01},
  {-3.525577e-01,  2.906177e-01, -8.895193e-01, -1.064090e+00, -8.012584e-01, -3.377433e-01},
  { 6.244923e-01,  5.781710e-01, -5.250977e-01, -9.908772e-01, -7.566289e-01, -3.086618e-01},
  { 8.516160e-01,  4.951882e-01,  1.718686e-01, -9.814701e-01, -7.645891e-01, -2.838684e-01},
  { 8.377448e-01,  4.791374e-01,  2.619370e-01, -1.008008e+00, -7.228566e-01, -2.736324e-01},
  { 5.016064e-01,  4.651511e-01, -7.294008e-01, -1.014699e+00, -7.285249e-01, -2.998955e-01},
  {-8.818150e-01, -9.832856e-04, -4.715944e-01, -1.083402e+00, -8.170193e-01, -3.296200e-01},
  {-8.911648e-01, -4.550975e-02, -4.513913e-01, -1.086797e+00, -7.919379e-01, -3.129340e-01},
  {-7.789364e-01, -4.311075e-01, -4.554166e-01, -1.066938e+00, -8.537099e-01, -3.450087e-01},
  { 1.784176e-01,  4.008633e-01, -8.985965e-01, -1.048357e+00, -7.316799e-01, -3.046337e-01},
  { 7.416137e-02,  1.390719e-01, -9.875014e-01, -1.088519e+00, -6.995645e-01, -3.136456e-01},
  { 1.297446e-01,  2.357342e-01, -9.631177e-01, -1.093861e+00, -6.469346e-01, -2.878584e-01},
  {-9.533100e-01, -2.837664e-01,  1.033283e-01, -1.130729e+00, -7.562547e-01, -2.615975e-01},
  {-4.695440e-01, -8.687782e-01,  1.573310e-01, -1.101223e+00, -7.673233e-01, -2.688984e-01},
  {-9.334483e-01, -2.977906e-01,  1.999873e-01, -1.093217e+00, -8.012366e-01, -2.773304e-01},
  {-2.361228e-01, -9.711900e-01,  3.218696e-02, -1.025566e+00, -8.730657e-01, -2.925738e-01},
  {-6.606037e-01, -7.443974e-01,  9.734014e-02, -1.058612e+00, -8.602260e-01, -2.827117e-01},
  {-9.162757e-01, -3.842503e-01,  1.130954e-01, -1.081531e+00, -8.271651e-01, -2.853089e-01},
  {-2.741138e-01, -2.136488e-01,  9.376652e-01, -1.072676e+00, -7.559207e-01, -2.397571e-01},
  {-4.174758e-01, -4.384135e-01,  7.959319e-01, -1.120812e+00, -7.510328e-01, -2.320704e-01},
  {-5.471191e-01, -9.306970e-02,  8.318645e-01, -1.063800e+00, -8.017625e-01, -2.289956e-01},
  {-6.755779e-01, -3.154738e-01,  6.663864e-01, -1.060282e+00, -8.393157e-01, -2.322381e-01},
  {-3.723795e-01, -6.867452e-01,  6.242712e-01, -1.041643e+00, -8.637163e-01, -2.286005e-01},
  { 4.541752e-02, -8.294764e-01,  5.566922e-01, -1.004073e+00, -8.709469e-01, -2.321531e-01},
  { 1.256306e-01, -9.914330e-01,  3.574334e-02, -9.788949e-01, -8.733706e-01, -2.982387e-01},
  { 4.129095e-01, -4.731903e-01,  7.782009e-01, -9.683887e-01, -8.698117e-01, -2.409320e-01},
  {-7.057624e-01,  7.974713e-02,  7.039459e-01, -1.114571e+00, -7.052156e-01, -2.415805e-01},
  {-9.851316e-01, -5.906795e-02,  1.613280e-01, -1.133271e+00, -6.630896e-01, -2.660884e-01},
  {-5.146410e-01, -3.769039e-02,  8.565770e-01, -1.118206e+00, -6.480203e-01, -2.422130e-01},
  {-5.677935e-03,  2.622596e-01, -9.649807e-01, -1.073255e+00, -7.383926e-01, -3.129220e-01},
  {-3.742972e-01, -4.971258e-02, -9.259753e-01, -1.086437e+00, -7.425101e-01, -3.106616e-01},
  { 7.032999e-01,  4.164071e-01,  5.761722e-01, -9.946339e-01, -7.595776e-01, -2.599469e-01},
  { 7.976050e-01,  5.958925e-01, -9.347887e-02, -9.677122e-01, -7.876877e-01, -2.846400e-01},
  { 8.703973e-01,  2.812229e-01, -4.041313e-01, -9.250917e-01, -8.468658e-01, -3.520606e-01},
  { 9.108177e-01, -4.021120e-01, -9.336577e-02, -9.088846e-01, -8.599014e-01, -3.198275e-01},
  { 7.458492e-01,  6.612659e-01, -8.022752e-02, -9.440483e-01, -8.199197e-01, -3.026679e-01},
  { 8.768880e-01, -2.007994e-01,  4.367459e-01, -9.278268e-01, -8.528923e-01, -2.595026e-01},
  { 6.711248e-01,  4.912534e-01,  5.552130e-01, -9.486002e-01, -8.147177e-01, -2.598265e-01},
  { 6.662958e-01,  4.639752e-01,  5.837610e-01, -9.798574e-01, -7.870175e-01, -2.609446e-01},
  {-9.138776e-02, -5.805455e-03,  9.957984e-01, -1.087265e+00, -7.041478e-01, -2.308016e-01},
  { 2.850899e-01,  9.329693e-02,  9.539494e-01, -1.043053e+00, -7.305950e-01, -2.370680e-01},
  { 4.791872e-01,  1.464123e-01,  8.654149e-01, -1.058975e+00, -6.856456e-01, -2.327349e-01},
  { 1.326917e-01,  9.274487e-02,  9.868087e-01, -1.077581e+00, -6.437083e-01, -2.324267e-01},
  { 3.004316e-01,  2.708054e-01,  9.145520e-01, -1.025541e+00, -7.786403e-01, -2.284708e-01},
  { 1.983441e-01,  8.868918e-02,  9.761116e-01, -1.009708e+00, -8.197023e-01, -2.255452e-01},
  {-9.622850e-01, -2.720433e-01, -7.072084e-06, -1.218866e+00,  4.793854e-01,  4.463160e-06},
  {-9.855239e-01, -1.695366e-01, -4.433738e-05, -1.216541e+00,  4.468966e-01,  9.680325e-06},
  {-8.961551e-01,  7.084537e-03, -4.436843e-01, -1.278040e+00,  3.925255e-01, -1.455830e-02},
  {-9.975369e-01, -1.184700e-02,  6.913563e-02, -1.281334e+00,  3.682880e-01, -1.849446e-05},
  {-8.552043e-01,  2.205782e-01, -4.690106e-01, -1.267266e+00,  5.153283e-01, -1.569703e-02},
  {-9.862733e-01,  1.651205e-01,  5.248726e-04, -1.275331e+00,  4.953624e-01,  1.210181e-06},
  {-7.123190e-01,  5.373955e-01, -4.514506e-01, -1.226861e+00,  6.017608e-01, -1.685461e-02},
  {-8.633429e-01,  5.046173e-01,  5.735895e-04, -1.239668e+00,  5.899910e-01,  2.947365e-06},
  {-4.298633e-01,  7.777269e-01, -4.586483e-01, -1.168084e+00,  6.508456e-01, -1.811199e-02},
  {-5.807560e-01,  8.140775e-01,  4.557324e-04, -1.181687e+00,  6.475185e-01,  2.911775e-06},
  {-1.329381e-01,  8.204927e-01, -5.559849e-01, -1.112668e+00,  6.653879e-01, -2.102790e-02},
  {-1.977013e-01,  9.802623e-01,  1.408071e-04, -1.106428e+00,  6.773709e-01,  0.000000e+00},
  {-5.465528e-01,  9.568943e-03, -8.373700e-01, -1.268561e+00,  3.960185e-01, -2.545397e-02},
  {-5.343897e-01,  1.507494e-01, -8.316865e-01, -1.256615e+00,  5.166761e-01, -2.743708e-02},
  {-4.485011e-01,  3.571338e-01, -8.193303e-01, -1.216312e+00,  5.986812e-01, -2.945672e-02},
  {-3.246845e-01,  5.611631e-01, -7.613645e-01, -1.161178e+00,  6.424861e-01, -3.175795e-02},
  { 2.720489e-01, -1.429568e-03, -9.622824e-01, -1.255902e+00,  3.971313e-01, -2.956517e-02},
  {-7.519062e-02,  9.856483e-03, -9.971204e-01, -1.243197e+00,  5.155662e-01, -3.186426e-02},
  {-5.215346e-02,  2.897950e-02, -9.982185e-01, -1.203822e+00,  5.927465e-01, -3.433028e-02},
  {-1.652714e-01,  5.065182e-01, -8.462414e-01, -1.153574e+00,  6.361282e-01, -3.918463e-02},
  { 7.256230e-01,  4.605002e-02, -6.865499e-01, -1.239510e+00,  2.704532e-01, -2.393167e-02},
  { 4.940802e-01, -1.723466e-01, -8.521628e-01, -1.229861e+00,  5.142816e-01, -2.776248e-02},
  { 4.248324e-01, -3.905235e-01, -8.167060e-01, -1.191507e+00,  5.864263e-01, -3.001692e-02},
  { 8.616607e-01,  1.442267e-01, -4.865588e-01, -1.144615e+00,  6.218340e-01, -3.394309e-02},
  { 8.516753e-01, -4.793695e-02, -5.218728e-01, -1.233906e+00,  4.014194e-01, -1.502133e-02},
  { 8.698739e-01, -2.919997e-01, -3.975620e-01, -1.219777e+00,  5.154015e-01, -1.618865e-02},
  { 6.858998e-01, -6.442410e-01, -3.383712e-01, -1.182147e+00,  5.825285e-01, -1.750977e-02},
  { 7.422599e-01, -6.124815e-01, -2.718765e-01, -1.138055e+00,  6.113665e-01, -1.960925e-02},
  { 9.959605e-01, -8.979202e-02, -1.490931e-04, -1.229465e+00,  4.243963e-01, -1.025528e-05},
  { 9.146048e-01, -4.043489e-01, -1.533549e-04, -1.211468e+00,  5.312304e-01, -8.972633e-06},
  { 9.144138e-01,  4.047807e-01, -1.396092e-04, -1.135649e+00,  6.075289e-01, -2.340466e-05},
  { 9.643725e-01, -2.333487e-01, -1.246358e-01, -7.461108e-01, -4.279945e-01, -1.208512e-01},
  {-9.298455e-01, -9.079792e-02, -3.565713e-01, -8.033988e-01, -4.366052e-01, -1.294848e-01},
  {-7.765166e-01, -6.386574e-02,  6.268519e-01, -7.966179e-01, -4.440688e-01, -1.126539e-01},
  {-1.123880e-01, -1.965536e-01,  9.740306e-01, -7.811729e-01, -4.386419e-01, -1.024516e-01},
  { 5.154467e-01, -2.193169e-01,  8.283808e-01, -7.599609e-01, -4.324433e-01, -1.071560e-01},
  { 6.895231e-01, -2.108134e-01, -6.929038e-01, -9.058250e-01, -4.334543e-01, -1.538300e-01},
  {-8.754591e-01, -6.924614e-02,  4.783058e-01, -9.474856e-01, -4.374834e-01, -1.286207e-01},
  {-1.304396e-01, -2.755677e-02,  9.910732e-01, -9.339497e-01, -4.454955e-01, -1.225433e-01},
  { 3.476563e-01, -1.702438e-01,  9.220369e-01, -9.144177e-01, -4.403666e-01, -1.260181e-01},
  { 4.811099e-01, -5.297395e-01,  6.985052e-01, -7.603072e-01, -4.620364e-01, -1.085580e-01},
  {-1.587906e-01, -5.310195e-01,  8.323484e-01, -7.824816e-01, -4.642287e-01, -1.015267e-01},
  {-5.787141e-01, -7.084758e-01,  4.039209e-01, -7.985551e-01, -4.678386e-01, -1.120265e-01},
  {-8.366428e-01, -5.323237e-01, -1.290755e-01, -8.041620e-01, -4.622421e-01, -1.278966e-01},
  {-3.950705e-01, -5.506941e-01, -7.352927e-01, -7.946049e-01, -4.608480e-01, -1.387751e-01},
  { 1.858855e-01, -3.156377e-01, -9.304942e-01, -7.757232e-01, -4.506609e-01, -1.487438e-01},
  { 6.281221e-01, -4.395706e-01, -6.420595e-01, -7.598971e-01, -4.495054e-01, -1.328553e-01},
  { 8.565038e-01, -5.160848e-01, -7.600892e-03, -7.482796e-01, -4.538428e-01, -1.194750e-01},
  { 8.005337e-01, -5.743690e-01,  1.710154e-01, -9.057090e-01, -4.659458e-01, -1.371018e-01},
  { 3.660718e-01, -5.650756e-01,  7.393788e-01, -9.166503e-01, -4.690972e-01, -1.251679e-01},
  {-1.818550e-01, -6.716557e-01,  7.181973e-01, -9.376528e-01, -4.681827e-01, -1.201147e-01},
  {-6.421111e-01, -4.650345e-01,  6.094557e-01, -9.510557e-01, -4.655548e-01, -1.282025e-01},
  {-8.548980e-01, -5.162995e-01, -5.083458e-02, -9.558083e-01, -4.634101e-01, -1.398949e-01},
  {-6.861260e-01, -3.853566e-01, -6.170343e-01, -9.540108e-01, -4.577814e-01, -1.515700e-01},
  {-3.792044e-02, -3.459795e-01, -9.374754e-01, -9.422388e-01, -4.517321e-01, -1.540575e-01},
  { 2.578432e-03, -2.815831e-01, -9.595334e-01, -9.251621e-01, -4.492770e-01, -1.559113e-01},
  { 3.505379e-01, -5.227020e-01, -7.771138e-01, -9.095954e-01, -4.591686e-01, -1.516443e-01},
  { 2.027696e-01, -9.416050e-01, -2.688207e-01, -7.778738e-01, -4.664181e-01, -1.239965e-01},
  {-4.894757e-02, -9.031923e-01, -4.264361e-01, -9.319757e-01, -4.692125e-01, -1.406177e-01},
  { 3.987393e-01,  6.961264e-02, -9.144185e-01,  1.140864e+00,  6.605596e-01, -1.685238e-01},
  { 2.062466e-01, -7.509131e-02, -9.756145e-01,  1.142525e+00,  6.488522e-01, -1.689026e-01},
  { 7.562524e-01,  5.765073e-02, -6.517352e-01,  1.155294e+00,  6.505772e-01, -1.613617e-01},
  { 3.963134e-01, -2.429919e-01, -8.853760e-01,  1.150209e+00,  6.461331e-01, -1.667538e-01},
  { 2.448657e-01, -2.516807e-01, -9.363213e-01,  1.142717e+00,  6.328816e-01, -1.602908e-01},
  { 3.491341e-01,  3.254708e-03, -9.370671e-01,  1.122447e+00,  6.411168e-01, -1.665947e-01},
  { 2.561336e-01, -8.924491e-02, -9.625129e-01,  1.114784e+00,  6.568431e-01, -1.724670e-01},
  { 8.847073e-02, -8.666108e-02, -9.923018e-01,  1.097209e+00,  6.388137e-01, -1.688220e-01},
  { 4.037844e-01, -5.651731e-02, -9.131068e-01,  1.124936e+00,  6.312995e-01, -1.701918e-01},
  { 5.409462e-01,  6.018369e-01, -5.875113e-01,  1.145384e+00,  6.857079e-01, -1.577345e-01},
  { 1.382325e-02,  2.523154e-01, -9.675463e-01,  1.119777e+00,  6.773560e-01, -1.756795e-01},
  { 8.134306e-01,  2.825358e-01, -5.084330e-01,  1.158673e+00,  6.749605e-01, -1.446282e-01},
  { 5.930768e-01, -1.986369e-01, -7.802585e-01,  1.146771e+00,  6.269740e-01, -1.569118e-01},
  { 4.230182e-01, -1.656101e-01, -8.908585e-01,  1.137250e+00,  6.154799e-01, -1.606944e-01},
  { 7.454861e-01,  1.121984e-01, -6.570100e-01,  1.166099e+00,  6.409330e-01, -1.314707e-01},
  { 5.137576e-01,  5.336147e-01, -6.717949e-01,  1.140589e+00,  6.948109e-01, -1.466820e-01},
  { 7.294165e-01,  4.335686e-01, -5.291217e-01,  1.153387e+00,  6.862338e-01, -1.376478e-01},
  { 7.412369e-01,  1.461314e-01, -6.551438e-01,  1.168568e+00,  6.654711e-01, -1.324368e-01},
  { 2.432777e-01,  5.513650e-01, -7.980053e-01,  1.115127e+00,  6.960365e-01, -1.586239e-01},
  { 3.828291e-01,  4.492384e-01, -8.072340e-01,  1.130431e+00,  6.975220e-01, -1.486744e-01},
  { 1.756935e-01,  2.354267e-01, -9.558798e-01,  1.104796e+00,  6.792047e-01, -1.675826e-01},
  {-1.306199e-02,  1.902687e-01, -9.816452e-01,  1.094620e+00,  6.824018e-01, -1.746081e-01},
  { 5.474611e-01,  3.552539e-01, -7.576813e-01,  1.140615e+00,  7.109197e-01, -1.421304e-01},
  { 8.839780e-01,  3.361412e-01, -3.249491e-01,  1.174954e+00,  6.744595e-01, -1.238703e-01},
  { 8.240813e-01,  6.913216e-02, -5.622373e-01,  1.179544e+00,  6.476638e-01, -1.221332e-01},
  { 9.222103e-01,  1.398513e-01, -3.605132e-01,  1.185738e+00,  6.599681e-01, -1.113981e-01},
  { 9.050734e-01,  6.816570e-02, -4.197565e-01,  1.182199e+00,  6.108599e-01, -1.136307e-01},
  { 8.429449e-01,  4.493988e-01, -2.957781e-01,  1.168967e+00,  6.970387e-01, -1.160857e-01},
  { 6.264125e-01,  6.893313e-01, -3.639092e-01,  1.144865e+00,  7.182620e-01, -1.288689e-01},
  { 3.162991e-01,  6.347035e-01, -7.050576e-01,  1.125643e+00,  7.212466e-01, -1.447769e-01},
  { 1.922954e-01,  4.493790e-01, -8.723996e-01,  1.110116e+00,  7.110366e-01, -1.570571e-01},
  {-5.157150e-01,  3.613306e-01, -7.768386e-01,  1.091819e+00,  6.853220e-01, -1.661961e-01},
  {-1.295769e-01,  5.573649e-02, -9.900017e-01,  1.092098e+00,  6.390547e-01, -1.711707e-01},
  {-1.009495e-01,  6.004996e-01, -7.932273e-01,  1.090599e+00,  7.160022e-01, -1.506248e-01},
  {-2.377141e-01,  2.260284e-01, -9.446709e-01,  1.071295e+00,  6.759422e-01, -1.630244e-01},
  { 2.548205e-01,  8.661868e-01, -4.298685e-01,  1.112977e+00,  7.335745e-01, -1.293279e-01},
  { 5.199876e-01,  8.510956e-01, -7.245135e-02,  1.131864e+00,  7.302266e-01, -1.056177e-01},
  { 7.990699e-01,  5.944320e-01,  9.021045e-02,  1.158773e+00,  7.107178e-01, -9.829871e-02},
  { 5.283756e-01,  8.489120e-01, -1.295216e-02,  1.114212e+00,  7.419122e-01, -6.361546e-02},
  { 3.627180e-01,  8.960105e-01, -2.561264e-01,  1.089990e+00,  7.521949e-01, -9.653313e-02},
  { 7.336526e-01,  6.789365e-01,  2.826891e-02,  1.155024e+00,  7.095177e-01, -6.077081e-02},
  { 8.802938e-01,  3.905301e-01, -2.693863e-01,  1.199429e+00,  6.513050e-01, -6.065252e-02},
  { 7.314292e-01,  2.659276e-01, -6.279282e-01,  1.203399e+00,  5.929157e-01, -9.141932e-02},
  { 7.592898e-01,  1.038051e-01, -6.424201e-01,  1.188861e+00,  5.656362e-01, -1.189824e-01},
  { 4.016733e-01, -7.302250e-02, -9.128670e-01,  1.146074e+00,  5.276819e-01, -1.435144e-01},
  { 9.242651e-02,  3.876705e-02, -9.949646e-01,  1.045700e+00,  6.100843e-01, -1.586502e-01},
  {-1.505267e-02,  1.472336e-01, -9.889872e-01,  1.040996e+00,  6.348039e-01, -1.598488e-01},
  { 1.342099e-01,  7.493151e-01, -6.484709e-01,  1.064937e+00,  7.432057e-01, -1.251439e-01},
  {-1.523925e-01,  3.611358e-01, -9.199769e-01,  1.041315e+00,  7.096113e-01, -1.470138e-01},
  { 7.507180e-01,  6.580946e-01, -5.774038e-02,  1.202657e+00,  6.556091e-01, -3.365663e-02},
  { 6.985685e-01,  5.791481e-01, -4.202257e-01,  1.222125e+00,  6.165602e-01, -5.395339e-02},
  { 5.026086e-01,  1.509310e-01, -8.512370e-01,  1.228620e+00,  5.289899e-01, -9.641817e-02},
  { 1.982161e-01,  5.754791e-02, -9.784675e-01,  1.050099e+00,  5.391656e-01, -1.657170e-01},
  { 5.906157e-01,  8.068858e-01,  1.041292e-02,  1.090866e+00,  7.562523e-01, -3.525466e-05},
  { 5.460188e-01,  7.908070e-01, -2.765643e-01,  1.040295e+00,  7.802281e-01, -7.875360e-02},
  { 6.060423e-01,  2.732669e-01, -7.470194e-01,  1.017751e+00,  7.610070e-01, -1.221900e-01},
  { 2.447717e-01,  1.716185e-01, -9.542714e-01,  9.978631e-01,  7.286421e-01, -1.311266e-01},
  { 3.638535e-01,  3.824209e-03, -9.314483e-01,  1.141799e+00,  4.749709e-01, -1.426008e-01},
  { 5.947697e-01,  7.426648e-01, -3.077302e-01,  1.250945e+00,  6.091107e-01, -3.015825e-02},
  { 6.775671e-01,  7.354609e-01,  2.371266e-04,  1.218975e+00,  6.414025e-01,  3.869827e-05},
  { 6.489054e-01,  7.597420e-01, -4.140078e-02,  1.263886e+00,  6.054266e-01,  7.802276e-05},
  { 5.976186e-01,  6.274822e-01, -4.991173e-01,  1.284952e+00,  5.788702e-01, -2.853245e-02},
  { 6.496090e-01,  5.793321e-01,  4.923236e-01,  1.284134e+00,  5.874874e-01,  1.074018e-04},
  { 3.113327e-01,  3.049769e-01, -9.000340e-01,  1.263441e+00,  5.055057e-01, -8.846772e-02},
  { 3.451570e-01, -1.894512e-01, -9.192252e-01,  1.157294e+00,  4.418027e-01, -1.363110e-01},
  { 3.025507e-01, -4.829257e-02, -9.519091e-01,  1.095546e+00,  4.575698e-01, -1.588947e-01},
  { 2.144008e-01,  1.780144e-02, -9.765835e-01,  1.060929e+00,  4.784173e-01, -1.694312e-01},
  {-1.394595e-01,  1.830836e-01, -9.731554e-01,  9.874812e-01,  6.428183e-01, -1.600835e-01},
  { 4.054879e-01,  8.328158e-01, -3.768253e-01,  1.328534e+00,  5.455012e-01, -2.884366e-02},
  { 1.735516e-01,  4.110519e-01, -8.949392e-01,  1.296510e+00,  4.894568e-01, -8.582529e-02},
  { 9.358327e-02,  5.498223e-01, -8.300227e-01,  1.357244e+00,  4.925827e-01, -7.879992e-02},
  {-2.623695e-03,  1.689362e-01, -9.856235e-01,  1.314296e+00,  4.445453e-01, -9.626253e-02},
  { 3.549544e-01,  7.682661e-01, -5.327049e-01,  1.385844e+00,  5.066062e-01, -5.392329e-02},
  { 4.728130e-01,  8.585040e-01, -1.985418e-01,  1.395748e+00,  5.108051e-01, -3.185143e-02},
  { 5.320315e-01,  7.061699e-01, -4.671900e-01,  1.404704e+00,  4.996671e-01, -4.812666e-02},
  { 6.480512e-01,  7.279509e-01, -2.238686e-01,  1.413804e+00,  4.990358e-01, -3.452228e-02},
  { 9.453796e-01,  3.259688e-01, -1.272466e-03,  1.428826e+00,  4.779446e-01,  1.901601e-04},
  { 8.348554e-01,  5.379828e-01, -1.165802e-01,  1.427302e+00,  4.854773e-01, -2.794743e-02},
  { 6.255888e-01,  7.801530e-01, -4.539891e-05,  1.412672e+00,  5.008470e-01,  1.771473e-04},
  { 7.409012e-01,  4.572435e-01, -4.919288e-01,  1.419469e+00,  4.840518e-01, -4.738534e-02},
  { 4.142629e-01,  2.671113e-01, -8.700792e-01,  1.378839e+00,  4.901567e-01, -7.836156e-02},
  { 3.578379e-01,  4.549137e-02, -9.326749e-01,  1.396532e+00,  4.819232e-01, -7.199715e-02},
  { 3.716876e-01, -3.880740e-01, -8.433546e-01,  1.419520e+00,  4.604223e-01, -5.936882e-02},
  { 9.744341e-01,  3.916043e-02, -2.212346e-01,  1.437862e+00,  4.599793e-01, -2.955431e-02},
  { 9.818382e-01, -1.897052e-01, -2.388192e-03,  1.428345e+00,  4.601260e-01,  3.086662e-04},
  { 8.949741e-01, -4.440566e-01,  4.283814e-02,  1.418796e+00,  4.139771e-01, -2.197893e-02},
  { 7.547841e-01, -6.063418e-01, -2.503009e-01,  1.412937e+00,  4.046484e-01, -4.285312e-02},
  { 6.684198e-01, -7.257301e-01, -1.628828e-01,  1.400666e+00,  3.925119e-01, -3.965295e-02},
  { 8.480434e-01, -4.571893e-01, -2.679556e-01,  1.421113e+00,  4.204245e-01, -4.729237e-02},
  { 5.994553e-01, -4.968456e-01, -6.275330e-01,  1.405115e+00,  4.155452e-01, -6.717512e-02},
  { 5.486525e-01, -6.257294e-01, -5.544754e-01,  1.394632e+00,  3.991290e-01, -6.381764e-02},
  { 4.733317e-01, -2.597544e-01, -8.417153e-01,  1.379743e+00,  4.204310e-01, -8.611411e-02},
  { 2.858836e-01, -6.538367e-01, -7.005484e-01,  1.368283e+00,  3.992527e-01, -8.152397e-02},
  { 3.750790e-01, -3.803496e-01, -8.453696e-01,  1.368009e+00,  4.128748e-01, -9.239360e-02},
  { 8.513159e-01,  1.404924e-01, -5.054931e-01,  1.427226e+00,  4.394253e-01, -5.151697e-02},
  { 6.764053e-01,  2.271864e-01, -7.006155e-01,  1.414198e+00,  4.285997e-01, -6.999288e-02},
  { 1.857323e-01, -6.599185e-01, -7.280186e-01,  1.347479e+00,  3.832550e-01, -6.266959e-02},
  { 6.839347e-01,  1.380261e-01, -7.163673e-01,  1.393747e+00,  4.350929e-01, -8.403210e-02},
  { 5.960837e-01,  2.796832e-01, -7.526364e-01,  1.375997e+00,  4.583236e-01, -8.894460e-02},
  { 3.889413e-01,  2.453909e-01, -8.879797e-01,  1.373619e+00,  4.731823e-01, -8.496223e-02},
  { 3.697018e-01,  2.667645e-01, -8.900322e-01,  1.409724e+00,  4.464475e-01, -4.535135e-02},
  { 5.017429e-01,  2.511071e-01, -8.277677e-01,  1.397029e+00,  4.494075e-01, -4.985111e-02},
  { 6.670965e-01, -1.920910e-01, -7.197800e-01,  1.384261e+00,  4.679404e-01, -5.782384e-02},
  { 4.873290e-01, -5.773998e-02, -8.713074e-01,  1.394515e+00,  4.572445e-01, -5.152550e-02},
  { 3.226731e-01, -5.810393e-01, -7.471783e-01,  1.321035e+00,  3.830754e-01, -6.715376e-02},
  { 1.935400e-01, -7.302120e-01, -6.552348e-01,  1.323987e+00,  3.951532e-01, -9.138665e-02},
  { 6.171247e-02, -5.265566e-01, -8.478972e-01,  1.309139e+00,  3.900653e-01, -8.924908e-02},
  { 1.999514e-01, -1.251004e-01, -9.717867e-01,  1.354260e+00,  4.215750e-01, -9.840518e-02},
  {-1.911087e-01, -1.584570e-02, -9.814410e-01,  1.326917e+00,  4.220466e-01, -1.019274e-01},
  { 9.641797e-03, -3.805556e-01, -9.247078e-01,  1.324177e+00,  4.057759e-01, -9.875958e-02},
  { 3.710124e-02, -7.949069e-01, -6.055960e-01,  1.294973e+00,  3.777048e-01, -7.881036e-02},
  { 1.984418e-01, -6.671464e-01, -7.180088e-01,  1.338814e+00,  3.698102e-01, -6.127836e-02},
  { 2.714406e-01, -6.647112e-01, -6.960453e-01,  1.313475e+00,  3.730158e-01, -6.795117e-02},
  { 3.896683e-01, -7.482783e-01, -5.368783e-01,  1.366467e+00,  3.735366e-01, -4.978767e-02},
  { 7.474170e-03, -9.069536e-01, -4.211644e-01,  1.297104e+00,  3.618294e-01, -5.162592e-02},
  { 2.469415e-01, -9.262081e-01, -2.848833e-01,  1.351560e+00,  3.586382e-01, -3.387127e-02},
  { 1.849752e-01, -3.725823e-01, -9.093770e-01,  1.223756e+00,  4.047985e-01, -1.052805e-01},
  { 5.477200e-01, -8.248450e-01, -1.401194e-01,  1.377192e+00,  3.660328e-01, -1.958757e-02},
  { 2.324506e-01, -9.726082e-01,  2.898935e-04,  1.350543e+00,  3.553624e-01,  1.663535e-04},
  { 3.271239e-02, -9.859033e-01, -1.640873e-01,  1.320963e+00,  3.527659e-01, -1.854403e-02},
  { 1.606647e-01, -9.280103e-01, -3.361303e-01,  1.233749e+00,  3.585083e-01, -5.283218e-02},
  { 2.959180e-02, -9.974265e-01,  6.530469e-02,  1.295607e+00,  3.528112e-01,  1.429328e-04},
  { 3.041783e-01, -8.477026e-01, -4.345985e-01,  1.205370e+00,  3.497573e-01, -6.012190e-02},
  { 2.084515e-01, -9.303608e-01, -3.016236e-01,  1.152433e+00,  3.425241e-01, -7.656500e-02},
  { 1.509568e-01, -8.348500e-01, -5.293747e-01,  1.083757e+00,  3.329437e-01, -9.179942e-02},
  { 2.621616e-01, -5.637275e-01, -7.832513e-01,  1.176155e+00,  3.862520e-01, -1.087461e-01},
  { 2.419085e-01, -3.693069e-01, -8.972695e-01,  1.096050e+00,  4.183395e-01, -1.506629e-01},
  { 2.209425e-01, -5.115474e-01, -8.303636e-01,  1.106833e+00,  3.875592e-01, -1.295419e-01},
  { 1.177010e-01, -2.449089e-01, -9.623752e-01,  1.045579e+00,  4.408285e-01, -1.698165e-01},
  { 7.473125e-02, -5.832650e-01, -8.088369e-01,  1.034840e+00,  4.017578e-01, -1.505429e-01},
  { 1.035654e-01, -8.385218e-01, -5.349348e-01,  9.831626e-01,  3.240812e-01, -7.803930e-02},
  {-1.036616e-01, -2.684898e-01, -9.576886e-01,  9.892396e-01,  4.396281e-01, -1.671073e-01},
  { 2.663475e-02, -5.832056e-02, -9.979425e-01,  1.011370e+00,  4.756802e-01, -1.758692e-01},
  {-1.738788e-01, -4.941895e-02, -9.835263e-01,  9.614071e-01,  5.062029e-01, -1.738101e-01},
  {-4.835618e-02,  5.007131e-02, -9.975744e-01,  9.845400e-01,  5.279734e-01, -1.774468e-01},
  {-2.329981e-02,  1.379177e-01, -9.901696e-01,  9.777234e-01,  5.817272e-01, -1.720409e-01},
  {-8.372560e-02,  2.502115e-01, -9.645643e-01,  9.744874e-01,  6.164444e-01, -1.656388e-01},
  {-2.437863e-01,  1.721980e-01, -9.544193e-01,  9.286850e-01,  6.053756e-01, -1.579856e-01},
  {-6.469688e-01,  2.294932e-01, -7.271618e-01,  9.088513e-01,  6.017088e-01, -1.452290e-01},
  { 3.013627e-01,  9.535096e-01,  4.078500e-05,  9.696122e-01,  8.315948e-01, -1.312176e-04},
  { 5.544797e-01,  8.309045e-01, -4.636729e-02,  1.014751e+00,  8.102738e-01, -3.812021e-02},
  { 6.273310e-01,  7.752278e-01, -7.401080e-02,  1.006569e+00,  8.121613e-01, -6.920016e-02},
  { 3.627042e-01,  9.318787e-01, -6.892701e-03,  9.792489e-01,  8.288016e-01, -5.615065e-02},
  { 3.072668e-01,  9.511634e-01,  2.958460e-02,  9.825352e-01,  8.278844e-01, -7.376389e-02},
  {-6.453708e-02,  9.979153e-01, -7.040199e-05,  9.410921e-01,  8.349489e-01, -1.557363e-04},
  {-9.067061e-02,  9.948772e-01, -4.470163e-02,  9.494363e-01,  8.329126e-01, -7.467459e-02},
  {-1.175228e-01,  9.855085e-01,  1.223168e-01,  9.475099e-01,  8.337336e-01, -9.910176e-02},
  {-1.304433e-01,  9.730696e-01,  1.900527e-01,  9.480909e-01,  8.395973e-01, -1.347619e-01},
  { 3.997211e-01,  9.111740e-01,  9.992490e-02,  9.784745e-01,  8.320495e-01, -1.288016e-01},
  { 9.103912e-01,  4.128891e-01,  2.665683e-02,  9.993895e-01,  8.179644e-01, -1.404476e-01},
  { 7.518495e-01,  5.184803e-01,  4.073087e-01,  1.006038e+00,  8.251315e-01, -1.695070e-01},
  { 1.832273e-01,  8.479096e-01,  4.974708e-01,  9.852138e-01,  8.577049e-01, -1.970194e-01},
  { 1.327154e-01,  8.438158e-01,  5.199630e-01,  1.018502e+00,  8.595228e-01, -2.089592e-01},
  { 4.777873e-01,  2.861772e-01,  8.305553e-01,  1.031038e+00,  8.474746e-01, -2.052842e-01},
  { 3.254981e-02,  8.203809e-01,  5.708902e-01,  1.040531e+00,  8.647780e-01, -2.206565e-01},
  { 2.590275e-01,  2.184756e-01,  9.408364e-01,  1.050560e+00,  8.535697e-01, -2.169251e-01},
  { 5.825340e-01,  8.128063e-01, -4.061798e-05,  1.038286e+00,  7.949522e-01, -9.106436e-05},
  { 8.188882e-01,  4.804841e-01, -3.139383e-01,  1.016557e+00,  7.887517e-01, -1.022053e-01},
  { 8.088617e-02,  3.526820e-01,  9.322407e-01,  1.068475e+00,  8.588685e-01, -2.201922e-01},
  { 7.191458e-02,  6.749796e-01,  7.343235e-01,  1.065595e+00,  8.693203e-01, -2.266151e-01},
  {-1.139650e-01,  9.628277e-01,  2.448975e-01,  1.061637e+00,  8.750958e-01, -2.370026e-01},
  { 7.910083e-02,  8.846634e-01,  4.594711e-01,  1.084428e+00,  8.761339e-01, -2.378589e-01},
  {-7.749275e-03,  4.163125e-01,  9.091886e-01,  1.121898e+00,  8.634636e-01, -2.185892e-01},
  { 9.498563e-01, -2.591270e-01,  1.750036e-01,  1.189513e+00,  8.806701e-01, -2.133208e-01},
  { 8.834211e-01, -3.887651e-01, -2.615895e-01,  1.009646e+00,  7.659991e-01, -1.468216e-01},
  { 7.621570e-01, -5.964257e-01, -2.517801e-01,  1.011785e+00,  7.820774e-01, -1.752710e-01},
  { 7.511746e-01, -6.482661e-01,  1.244501e-01,  1.018378e+00,  7.995782e-01, -2.070321e-01},
  { 6.166021e-01, -2.326289e-02, -7.869311e-01,  9.694054e-01,  7.431889e-01, -1.456034e-01},
  { 4.326523e-02, -8.722373e-01, -4.871656e-01,  9.933883e-01,  7.949197e-01, -2.155193e-01},
  { 5.163576e-01, -6.815106e-01,  5.185732e-01,  1.035877e+00,  8.128332e-01, -2.138267e-01},
  { 1.813504e-01, -8.809551e-01, -4.370700e-01,  1.014015e+00,  8.065968e-01, -2.323111e-01},
  { 1.994330e-01, -9.551787e-01, -2.187696e-01,  1.043222e+00,  8.153779e-01, -2.359084e-01},
  { 2.900088e-01, -8.216281e-01,  4.907364e-01,  1.074436e+00,  8.233449e-01, -2.246964e-01},
  { 2.981821e-01, -8.164369e-01,  4.944876e-01,  1.116110e+00,  8.314038e-01, -2.262892e-01},
  { 3.424362e-01, -9.328026e-01, -1.123254e-01,  1.124896e+00,  8.394417e-01, -2.373276e-01},
  {-7.312605e-02, -6.421184e-01, -7.631098e-01,  1.027368e+00,  8.235536e-01, -2.534685e-01},
  { 1.423658e-01, -7.415056e-01, -6.556687e-01,  1.070032e+00,  8.246713e-01, -2.589982e-01},
  { 3.318877e-01, -7.553499e-01, -5.650638e-01,  1.097874e+00,  8.341675e-01, -2.558675e-01},
  { 4.911599e-01, -7.415724e-01, -4.569818e-01,  1.130829e+00,  8.404521e-01, -2.459315e-01},
  {-3.594749e-01, -4.267876e-01, -8.298374e-01,  9.884143e-01,  8.171043e-01, -2.403467e-01},
  {-5.094660e-01, -4.231441e-01, -7.492619e-01,  9.600514e-01,  8.065885e-01, -2.253225e-01},
  {-5.617057e-01, -6.606197e-01, -4.980646e-01,  9.407746e-01,  7.849166e-01, -1.839375e-01},
  {-6.860586e-01, -5.410658e-01, -4.863859e-01,  9.444312e-01,  7.750801e-01, -1.671298e-01},
  {-3.262442e-01,  7.181382e-01, -6.146887e-01,  9.190621e-01,  7.634846e-01, -1.449632e-01},
  {-9.526581e-02, -2.319325e-01, -9.680556e-01,  1.050727e+00,  8.451731e-01, -2.651106e-01},
  {-2.464022e-01, -2.204142e-01, -9.437709e-01,  1.010746e+00,  8.410013e-01, -2.577387e-01},
  {-7.690464e-01, -7.365704e-02, -6.349348e-01,  9.546090e-01,  8.201235e-01, -2.164955e-01},
  {-8.678939e-01, -2.569458e-01, -4.251340e-01,  9.305741e-01,  8.029509e-01, -1.765307e-01},
  {-8.281221e-01, -1.982104e-01, -5.243343e-01,  9.215073e-01,  7.950826e-01, -1.527441e-01},
  {-7.850175e-01,  3.457341e-01, -5.140188e-01,  9.525334e-01,  8.466510e-01, -2.212740e-01},
  {-4.274620e-01,  4.161534e-01, -8.025538e-01,  9.821344e-01,  8.543271e-01, -2.490110e-01},
  {-1.096993e-01,  4.409482e-01, -8.908035e-01,  1.059728e+00,  8.665315e-01, -2.724426e-01},
  {-8.952110e-01,  1.639041e-01, -4.144062e-01,  9.326559e-01,  8.261068e-01, -1.839781e-01},
  {-8.832234e-01,  4.074143e-01, -2.322284e-01,  9.164069e-01,  8.196131e-01, -1.496348e-01},
  {-8.614537e-01,  3.008835e-01, -4.091046e-01,  9.035783e-01,  7.806610e-01, -1.160043e-01},
  {-6.867251e-01,  7.017032e-01, -1.897922e-01,  9.029067e-01,  8.106114e-01, -8.185630e-02},
  {-6.870092e-01,  5.586222e-01, -4.647146e-01,  8.975348e-01,  7.814944e-01, -9.470820e-02},
  { 1.856975e-01, -2.044397e-02, -9.823943e-01,  1.095032e+00,  8.641423e-01, -2.679914e-01},
  { 3.819868e-01,  1.440943e-01, -9.128653e-01,  1.125512e+00,  8.703255e-01, -2.579084e-01},
  {-4.319938e-01,  9.018765e-01, -4.074986e-05,  9.177700e-01,  8.290812e-01, -1.575245e-04},
  {-4.493498e-01,  8.838209e-01, -1.301741e-01,  9.151469e-01,  8.267292e-01, -4.766142e-02},
  {-4.708581e-01,  8.787032e-01,  7.856996e-02,  9.237414e-01,  8.266920e-01, -1.095180e-01},
  {-2.099967e-01,  9.639021e-01, -1.636893e-01,  1.050785e+00,  8.736849e-01, -2.537237e-01},
  {-1.240002e-01,  9.917306e-01, -3.308205e-02,  1.013211e+00,  8.682367e-01, -2.410409e-01},
  {-2.283646e-01,  9.713812e-01, -6.533097e-02,  9.852178e-01,  8.674853e-01, -2.275883e-01},
  {-3.797532e-01,  9.231268e-01,  6.020253e-02,  9.629746e-01,  8.605297e-01, -2.075233e-01},
  {-6.997133e-01,  7.133715e-01, -3.875868e-02,  9.402047e-01,  8.425636e-01, -1.706672e-01},
  {-6.887923e-01,  7.156162e-01, -1.160117e-01,  8.976747e-01,  8.127245e-01, -5.742892e-02},
  {-5.832861e-01,  7.052939e-01, -4.029118e-01,  8.835738e-01,  7.850146e-01, -8.132593e-02},
  {-6.142344e-01,  7.891235e-01, -2.341303e-04,  8.772961e-01,  7.977481e-01, -1.508813e-04},
  { 2.646920e-02,  9.652830e-01, -2.598619e-01,  1.090194e+00,  8.777968e-01, -2.589186e-01},
  {-5.249859e-01,  8.511108e-01, -3.713715e-04,  8.288819e-01,  7.723812e-01, -1.659867e-04},
  {-5.291530e-01,  7.989995e-01, -2.856518e-01,  8.403997e-01,  7.647538e-01, -5.841550e-02},
  {-5.530497e-01,  6.983731e-01, -4.543247e-01,  8.946742e-01,  7.704148e-01, -1.108547e-01},
  {-5.188621e-01,  7.595016e-01, -3.923512e-01,  9.049430e-01,  7.579288e-01, -1.412115e-01},
  {-6.095598e-01,  6.645131e-01, -4.322721e-01,  8.611169e-01,  7.369934e-01, -1.351835e-01},
  {-7.908440e-01,  1.564718e-01, -5.916776e-01,  8.390496e-01,  7.105080e-01, -1.179474e-01},
  {-4.126787e-01,  8.625933e-01, -2.926245e-01,  8.950850e-01,  7.446096e-01, -1.721312e-01},
  {-6.546444e-01,  6.296070e-01, -4.183728e-01,  8.700941e-01,  7.297169e-01, -1.664560e-01},
  {-8.642133e-01,  1.391518e-01, -4.834998e-01,  8.580567e-01,  7.126279e-01, -1.661976e-01},
  {-5.450659e-01,  7.945240e-01, -2.676465e-01,  9.040875e-01,  7.407179e-01, -2.048932e-01},
  {-7.490399e-01,  4.899557e-01, -4.459627e-01,  8.861240e-01,  7.265314e-01, -1.951502e-01},
  {-8.676629e-01, -1.411700e-01, -4.766888e-01,  8.763720e-01,  7.050357e-01, -1.882106e-01},
  { 3.545327e-01,  8.651743e-01, -3.546546e-01,  9.463325e-01,  7.549634e-01, -1.616610e-01},
  { 4.115034e-01,  8.773850e-01, -2.466992e-01,  9.441847e-01,  7.486683e-01, -1.708281e-01},
  { 2.262701e-01,  9.739830e-01,  1.260508e-02,  9.508366e-01,  7.470713e-01, -1.852407e-01},
  {-6.893629e-01,  7.243353e-01,  1.082412e-02,  9.102029e-01,  7.416866e-01, -2.303188e-01},
  {-6.314720e-01,  7.577909e-01,  1.643051e-01,  9.195689e-01,  7.520031e-01, -2.530298e-01},
  {-8.657579e-01,  4.225888e-01,  2.681079e-01,  9.163408e-01,  7.708074e-01, -3.421562e-01},
  {-9.394792e-01,  3.366885e-01,  6.340015e-02,  9.072435e-01,  7.383293e-01, -3.177105e-01},
  {-5.290344e-01,  8.107376e-01,  2.506540e-01,  9.390303e-01,  7.771708e-01, -2.789051e-01},
  { 3.721244e-01,  8.602227e-01,  3.486263e-01,  9.722478e-01,  7.726678e-01, -2.415367e-01},
  { 4.645664e-01,  8.846231e-01,  4.025101e-02,  9.610055e-01,  7.875831e-01, -2.904378e-01},
  {-3.859567e-01,  9.150599e-01,  1.170589e-01,  9.506138e-01,  7.912667e-01, -3.024915e-01},
  { 4.920552e-01,  8.340222e-01, -2.495768e-01,  9.346291e-01,  7.977132e-01, -3.419410e-01},
  {-9.977780e-01,  4.714745e-02,  4.707688e-02,  9.066796e-01,  7.441476e-01, -3.658512e-01},
  {-3.262265e-01,  8.428950e-01, -4.279069e-01,  9.136051e-01,  7.888280e-01, -3.802657e-01},
  {-6.230904e-01,  2.687105e-01, -7.345427e-01,  9.005416e-01,  7.654721e-01, -3.999527e-01},
  {-8.779954e-01,  4.785117e-01, -1.227589e-02,  9.036340e-01,  7.296761e-01, -2.750592e-01},
  {-9.099897e-01,  1.938764e-01, -3.665114e-01,  8.870652e-01,  7.055225e-01, -2.113691e-01},
  {-9.897672e-01,  9.329892e-02, -1.079635e-01,  8.954692e-01,  7.045868e-01, -2.453859e-01},
  {-9.967142e-01,  3.914775e-02, -7.091013e-02,  8.973652e-01,  7.049863e-01, -2.826659e-01},
  {-9.445076e-01, -2.852975e-01, -1.628211e-01,  9.042551e-01,  6.674772e-01, -2.985544e-01},
  {-9.778655e-01, -1.288629e-01, -1.648436e-01,  9.027056e-01,  6.981319e-01, -3.307189e-01},
  { 2.007782e-01, -2.824176e-01, -9.380450e-01,  9.105409e-01,  7.198897e-01, -3.995121e-01},
  {-6.723687e-01, -3.968455e-01, -6.248471e-01,  9.183046e-01,  6.796266e-01, -3.715858e-01},
  {-5.185423e-01, -6.739615e-01, -5.262032e-01,  9.295890e-01,  6.353493e-01, -3.373030e-01},
  { 6.790225e-01, -7.013805e-01, -2.167807e-01,  9.229082e-01,  6.242208e-01, -3.002714e-01},
  {-9.467826e-01, -3.187841e-01, -4.449082e-02,  9.018747e-01,  6.647043e-01, -2.588615e-01},
  {-6.183642e-01, -4.571295e-01, -6.392639e-01,  8.663334e-01,  6.638991e-01, -1.331486e-01},
  {-5.104088e-01, -6.732134e-01, -5.350388e-01,  9.136039e-01,  6.409956e-01, -1.592715e-01},
  {-5.395837e-01, -2.457978e-01, -8.052533e-01,  9.041796e-01,  6.330598e-01, -1.294380e-01},
  {-9.152943e-01, -3.788390e-01, -1.368111e-01,  8.951757e-01,  6.721470e-01, -2.077616e-01},
  { 4.938194e-02, -9.891120e-01, -1.386321e-01,  9.290745e-01,  6.220775e-01, -2.525077e-01},
  { 8.351118e-01,  4.472643e-02, -5.482589e-01,  9.743690e-01,  7.136533e-01, -1.515201e-01},
  { 4.501137e-01,  2.704759e-02, -8.925615e-01,  9.717848e-01,  6.877950e-01, -1.485252e-01},
  { 8.551921e-01,  1.584358e-01, -4.935024e-01,  9.275467e-01,  7.762268e-01, -3.736844e-01},
  { 7.415015e-01,  1.134849e-01, -6.612841e-01,  9.157004e-01,  7.574784e-01, -3.959967e-01},
  { 8.944815e-01, -1.479937e-01, -4.219012e-01,  9.421114e-01,  7.801465e-01, -3.438134e-01},
  { 9.684110e-01,  2.356035e-01,  8.167749e-02,  9.633799e-01,  7.320670e-01, -1.869826e-01},
  { 9.473652e-01, -1.948590e-01, -2.540255e-01,  9.925955e-01,  7.286722e-01, -2.310222e-01},
  { 8.726352e-01, -2.385209e-01, -4.261639e-01,  9.852770e-01,  6.998388e-01, -2.209896e-01},
  { 9.286208e-01, -5.825827e-02, -3.664277e-01,  9.895008e-01,  7.535921e-01, -2.538426e-01},
  { 8.534518e-01, -1.442264e-01, -5.008181e-01,  9.562203e-01,  7.738265e-01, -3.147237e-01},
  { 7.108214e-01, -5.995518e-01, -3.677915e-01,  9.478422e-01,  7.697358e-01, -3.145708e-01},
  { 7.240750e-01, -5.842963e-01, -3.664877e-01,  9.460133e-01,  7.492653e-01, -2.861253e-01},
  { 8.221035e-01, -2.470373e-01, -5.129508e-01,  9.642497e-01,  6.650553e-01, -1.479591e-01},
  { 6.850994e-02, -5.494391e-01, -8.327202e-01,  9.622874e-01,  7.030286e-01, -2.235597e-01},
  { 4.644589e-01, -7.017666e-01, -5.401866e-01,  9.490367e-01,  7.343106e-01, -2.623393e-01},
  { 5.995354e-01, -6.778049e-01, -4.256028e-01,  9.421017e-01,  7.166566e-01, -2.360933e-01},
  { 6.366869e-01, -1.996056e-01, -7.448406e-01,  9.298669e-01,  6.948379e-01, -2.201878e-01},
  { 9.073050e-01, -3.802710e-01, -1.794201e-01,  9.323295e-01,  7.135596e-01, -2.701667e-01},
  { 9.823544e-01, -1.614180e-01, -9.446701e-02,  9.268368e-01,  6.885330e-01, -2.550085e-01},
  { 9.937777e-01, -6.719109e-02, -8.883242e-02,  9.246403e-01,  6.885374e-01, -2.899601e-01},
  { 9.749138e-01, -1.557176e-01, -1.590440e-01,  9.243886e-01,  7.059997e-01, -3.254937e-01},
  { 9.517626e-01,  2.855566e-02, -3.055038e-01,  9.315338e-01,  6.576875e-01, -2.542013e-01},
  { 1.086052e-01, -1.032855e-01, -9.887047e-01,  9.516651e-01,  6.447949e-01, -1.471360e-01},
  { 2.666543e-01, -3.303072e-01, -9.054241e-01,  9.651424e-01,  6.868330e-01, -2.166996e-01},
  { 5.960822e-01, -5.641723e-01, -5.713103e-01,  9.854229e-01,  6.891487e-01, -2.144558e-01},
  { 6.680853e-01, -6.602924e-01, -3.430392e-01,  9.552127e-01,  6.738313e-01, -2.127459e-01},
  {-2.042247e-01, -8.026335e-01,  5.604211e-01, -1.042044e+00, -3.636294e-01, -1.805386e-01},
  { 7.113203e-01, -3.025481e-01,  6.344194e-01,  4.175179e-01, -1.192795e-01,  2.429679e-01},
  { 4.490034e-01, -2.927881e-01,  8.441984e-01,  4.470927e-01, -1.448001e-01,  2.206093e-01},
  { 6.798448e-01, -4.432699e-01,  5.842284e-01,  4.015620e-01, -1.531597e-01,  2.359133e-01},
  { 6.160373e-01, -9.329966e-02,  7.821721e-01,  4.820448e-01, -1.293833e-01,  2.005975e-01},
  { 6.243153e-01, -4.816695e-01,  6.150000e-01,  3.887607e-01, -1.866826e-01,  2.258953e-01},
  { 3.503378e-01, -4.383185e-01,  8.277320e-01,  4.319541e-01, -2.082371e-01,  2.002151e-01},
  { 2.930990e-01, -5.432432e-01,  7.867527e-01,  4.225990e-01, -2.375951e-01,  1.839326e-01},
  { 2.852866e-01, -6.528778e-01,  7.016852e-01,  4.113530e-01, -2.716712e-01,  1.616022e-01},
  { 4.087110e-01, -3.653033e-01,  8.363665e-01,  4.919938e-01, -2.511077e-01,  1.443114e-01},
  { 6.709768e-01, -1.825916e-01,  7.186449e-01,  5.190164e-01, -1.787896e-01,  1.514856e-01},
  { 5.149789e-01, -3.695275e-01,  7.734637e-01,  4.764328e-01, -1.985490e-01,  1.820704e-01},
  { 7.018178e-01, -2.048261e-01,  6.822742e-01,  5.420135e-01, -9.918778e-02,  1.449537e-01},
  { 6.114673e-01, -6.921855e-02,  7.882363e-01,  5.454392e-01, -1.854097e-01,  1.281764e-01},
  { 7.111388e-01, -1.805591e-01,  6.794704e-01,  5.566155e-01, -2.205531e-01,  1.143369e-01},
  { 7.705843e-01, -9.221487e-02,  6.306316e-01,  5.677298e-01, -1.824470e-01,  1.096359e-01},
  { 5.575520e-01, -2.842741e-01,  7.799513e-01,  5.331795e-01, -2.469396e-01,  1.265802e-01},
  { 4.793451e-01, -6.048118e-01,  6.359488e-01,  5.164761e-01, -2.762674e-01,  1.219081e-01},
  { 2.203432e-01, -7.031784e-01,  6.760096e-01,  4.770973e-01, -2.892206e-01,  1.291733e-01},
  { 1.403700e-01, -7.456844e-01,  6.513455e-01,  4.429696e-01, -2.931584e-01,  1.340810e-01},
  { 7.367198e-01, -5.649188e-01,  3.716325e-01,  3.589101e-01, -2.849088e-01,  1.803527e-01},
  { 8.198196e-01, -1.986396e-01,  5.370644e-01,  6.004730e-01, -1.321943e-01,  7.295091e-02},
  { 9.349219e-01, -2.214382e-01,  2.772835e-01,  5.869324e-01, -1.844588e-01,  7.258638e-02},
  { 8.991267e-01, -3.674631e-01,  2.377857e-01,  5.757483e-01, -2.363023e-01,  7.298441e-02},
  { 7.464300e-01, -5.317021e-01,  4.001689e-01,  5.546805e-01, -2.620533e-01,  9.295659e-02},
  { 5.608153e-01, -8.077006e-01,  1.819501e-01,  5.290102e-01, -2.936244e-01,  7.432432e-02},
  { 2.938473e-01, -8.948857e-01,  3.359067e-01,  4.900689e-01, -3.077385e-01,  9.610087e-02},
  { 9.082926e-02, -9.574106e-01,  2.740713e-01,  4.517001e-01, -3.128856e-01,  9.182262e-02},
  { 1.322100e-01, -9.273006e-01,  3.501915e-01,  4.074298e-01, -3.122291e-01,  1.022015e-01},
  { 3.374057e-01, -8.504542e-01,  4.035904e-01,  3.502641e-01, -3.148133e-01,  1.530478e-01},
  { 6.561616e-01, -1.846652e-01,  7.316767e-01,  5.718591e-01,  4.770891e-02,  1.583605e-01},
  { 7.810335e-01, -1.782124e-01,  5.985207e-01,  5.433750e-01,  2.918677e-02,  1.853785e-01},
  { 5.104875e-01, -1.901208e-01,  8.386040e-01,  5.722267e-01, -9.173824e-03,  1.491783e-01},
  { 6.625752e-01, -4.053573e-01,  6.298251e-01,  6.097967e-01, -8.186802e-02,  9.107150e-02},
  { 8.312535e-01, -5.365356e-01,  1.454206e-01,  6.237473e-01, -9.452763e-02,  5.442097e-02},
  { 6.642241e-01, -5.211454e-01,  5.359233e-01,  6.419504e-01, -6.948734e-02,  7.285789e-02},
  { 2.217034e-01, -2.547436e-01,  9.412509e-01, -8.399428e-01, -1.853738e-01,  2.652945e-01},
  { 1.627108e-01, -6.044372e-01,  7.798597e-01, -7.736018e-01, -1.297918e-01,  2.654970e-01},
  { 8.858773e-02, -1.169637e-01,  9.891773e-01, -7.610923e-01, -1.867265e-01,  2.625352e-01},
  {-2.881189e-01, -5.925905e-01,  7.522127e-01, -7.044595e-01, -1.602319e-01,  2.597590e-01},
  { 6.909505e-02, -2.861788e-01,  9.556817e-01, -8.530008e-01, -2.507719e-01,  2.595922e-01},
  { 3.483202e-01, -4.570621e-01,  8.183931e-01, -8.918447e-01, -2.386841e-01,  2.660959e-01},
  { 7.710581e-02, -2.286928e-01,  9.704403e-01, -8.139886e-01, -2.387773e-01,  2.601807e-01},
  { 1.106736e-01, -3.205014e-01,  9.407604e-01, -7.722270e-01, -2.446968e-01,  2.533395e-01},
  {-3.169176e-01, -5.497934e-01,  7.728456e-01, -6.147941e-01, -2.359380e-01,  2.462281e-01},
  { 4.773173e-01, -5.984156e-01,  6.434804e-01, -9.272331e-01, -2.952256e-01,  2.438132e-01},
  { 5.845386e-02, -5.375471e-01,  8.412053e-01, -8.763452e-01, -3.028023e-01,  2.373426e-01},
  { 9.170005e-02, -5.279305e-01,  8.443225e-01, -8.198057e-01, -2.982329e-01,  2.354253e-01},
  { 7.910296e-02, -5.365214e-01,  8.401711e-01, -7.664056e-01, -3.030716e-01,  2.255387e-01},
  { 1.284700e-01, -3.404297e-01,  9.314522e-01, -6.815137e-01, -2.656892e-01,  2.373409e-01},
  {-4.717086e-02, -6.960834e-01,  7.164097e-01, -6.411102e-01, -3.074048e-01,  2.025764e-01},
  { 1.853936e-01, -6.976658e-01,  6.920200e-01, -6.707183e-01, -3.044542e-01,  2.170248e-01},
  {-5.851544e-02, -8.132318e-01,  5.789905e-01, -5.891128e-01, -3.274960e-01,  1.944604e-01},
  {-2.602678e-01, -6.821737e-01,  6.833006e-01, -5.889560e-01, -2.662245e-01,  2.425093e-01},
  {-2.918442e-01, -6.255979e-01,  7.235013e-01, -4.691879e-01, -3.133800e-01,  2.477733e-01},
  {-5.902067e-01, -3.751578e-01,  7.147816e-01, -5.129685e-01, -3.430864e-01,  2.066723e-01},
  {-2.866322e-01, -8.173978e-01,  4.997028e-01, -5.591543e-01, -3.470191e-01,  1.605507e-01},
  {-3.055723e-01, -9.261805e-01,  2.209418e-01, -5.137374e-01, -3.630581e-01,  1.886564e-01},
  {-3.134695e-01, -7.216280e-01,  6.172439e-01, -4.813693e-01, -3.678246e-01,  2.116250e-01},
  {-1.068430e-01, -8.539838e-01,  5.092114e-01, -4.375216e-01, -3.708306e-01,  2.116087e-01},
  { 2.897383e-03, -6.195142e-01,  7.849801e-01, -3.568363e-01, -3.287795e-01,  2.499933e-01},
  {-1.213957e-01, -8.086028e-01,  5.756948e-01, -4.009556e-01, -3.661224e-01,  2.255328e-01},
  { 3.841776e-02, -8.725531e-01,  4.870064e-01, -3.690228e-01, -3.719257e-01,  2.211578e-01},
  { 2.027919e-01, -8.618241e-01,  4.649029e-01, -3.301444e-01, -3.614071e-01,  2.267287e-01},
  { 2.650798e-01, -7.939967e-01,  5.470850e-01, -2.268048e-01, -3.387284e-01,  2.088775e-01},
  { 2.623219e-02, -9.965854e-01,  7.829031e-02, -3.754687e-01, -3.738545e-01,  1.649624e-01},
  { 2.087698e-01, -9.559728e-01,  2.062308e-01, -2.404249e-01, -3.585663e-01,  1.538201e-01},
  {-1.870583e-01, -9.348652e-01,  3.017220e-01, -5.964472e-01, -3.429649e-01,  1.547255e-01},
  {-2.234841e-01, -9.005287e-01,  3.729651e-01, -6.222321e-01, -3.314171e-01,  1.693442e-01},
  { 1.168906e-01, -8.961156e-01,  4.281512e-01, -6.604398e-01, -3.248943e-01,  1.643268e-01},
  { 1.099429e-01, -9.784499e-01,  1.747811e-01, -6.474721e-01, -3.481565e-01,  8.440371e-02},
  {-1.303526e-01, -9.888363e-01,  7.218742e-02, -4.804713e-01, -3.746917e-01,  9.332051e-02},
  { 5.863175e-02, -9.941362e-01,  9.086029e-02, -3.407659e-01, -3.813852e-01,  9.443518e-02},
  { 1.994422e-01, -9.752012e-01,  9.594413e-02, -2.251900e-01, -3.672454e-01,  8.673979e-02},
  { 2.835184e-01, -8.647419e-01,  4.145345e-01, -9.607106e-02, -3.059859e-01,  1.776925e-01},
  { 2.534808e-01, -9.499930e-01,  1.823755e-01, -9.201483e-02, -3.296436e-01,  9.979817e-02},
  { 5.298110e-01, -7.262037e-01,  4.380965e-01, -9.665604e-01, -3.522512e-01,  2.063964e-01},
  { 1.034354e-01, -7.524391e-01,  6.504894e-01, -8.424072e-01, -3.585790e-01,  1.824607e-01},
  { 1.534847e-01, -7.312688e-01,  6.645963e-01, -7.721973e-01, -3.513448e-01,  1.808324e-01},
  { 5.778441e-01, -5.490578e-01,  6.038474e-01, -7.467901e-01, -3.829991e-01,  1.346225e-01},
  { 7.320613e-01, -6.698147e-01,  1.242355e-01, -7.322318e-01, -3.830269e-01,  1.105711e-01},
  { 1.440648e-01, -4.346432e-01,  8.890054e-01, -7.719046e-01, -3.784270e-01,  1.528826e-01},
  {-3.143371e-01, -5.900387e-01,  7.436711e-01, -7.992008e-01, -3.931540e-01,  1.384716e-01},
  { 7.068903e-02, -9.654240e-01,  2.509175e-01, -8.508329e-01, -3.939725e-01,  1.239820e-01},
  {-5.797495e-01, -7.568344e-01,  3.018149e-01, -8.130167e-01, -3.951693e-01,  1.227456e-01},
  { 4.247932e-01, -5.764946e-01,  6.980006e-01, -8.929306e-01, -3.907260e-01,  1.570758e-01},
  { 7.467631e-01, -6.383320e-01,  1.867545e-01, -8.873124e-01, -4.005234e-01,  1.360527e-01},
  { 8.769711e-02, -5.863287e-01,  8.053123e-01, -9.154930e-01, -3.864616e-01,  1.688540e-01},
  {-8.375178e-02, -6.211764e-01,  7.791826e-01, -9.426149e-01, -3.869622e-01,  1.636528e-01},
  { 3.218279e-01, -9.436939e-01,  7.660697e-02, -9.878715e-01, -3.743513e-01,  1.962514e-01},
  {-4.754688e-01, -5.119827e-01,  7.154043e-01, -9.571384e-01, -3.887209e-01,  1.569682e-01},
  {-5.797232e-01, -7.529079e-01, -3.115295e-01, -9.528667e-01, -3.999579e-01,  1.231878e-01},
  {-4.107547e-01, -9.109403e-01, -3.831652e-02, -1.019422e+00, -3.715833e-01,  1.057080e-01},
  {-5.390308e-01, -8.333232e-01,  1.225483e-01, -9.597369e-01, -3.968574e-01,  1.400907e-01},
  {-1.778636e-01, -6.059382e-01, -7.753730e-01, -9.334909e-01, -4.037571e-01,  1.114957e-01},
  { 3.001671e-01, -8.424935e-01, -4.473303e-01, -9.031293e-01, -4.050791e-01,  1.188010e-01},
  {-5.311257e-01, -7.549134e-01, -3.847221e-01, -8.049110e-01, -4.032596e-01,  9.980354e-02},
  { 1.090981e-01, -7.421570e-01, -6.612871e-01, -7.816748e-01, -3.980412e-01,  8.462465e-02},
  { 4.953781e-01, -7.929785e-01, -3.546627e-01, -7.496189e-01, -3.948716e-01,  9.478916e-02},
  {-6.144348e-01, -7.889392e-01, -6.693297e-03, -1.123471e+00, -3.161419e-01,  1.138786e-01},
  {-5.730484e-01, -4.613106e-01, -6.773537e-01, -1.123680e+00, -3.148709e-01,  1.771719e-01},
  {-7.538140e-01, -6.567951e-01,  1.961231e-02, -1.163016e+00, -2.797197e-01,  1.011943e-01},
  {-9.595902e-01, -2.797613e-01,  3.033571e-02, -1.146383e+00, -2.883920e-01,  1.852716e-01},
  {-8.374471e-01, -3.521537e-01,  4.179355e-01, -1.186764e+00, -2.455554e-01,  1.564659e-01},
  {-8.945279e-01, -4.458276e-01,  3.252170e-02, -1.194281e+00, -2.348918e-01,  9.199354e-02},
  {-9.128319e-01, -2.039747e-01,  3.537404e-01, -1.203687e+00, -1.959181e-01,  1.399529e-01},
  {-9.614140e-01, -2.581505e-01,  9.508584e-02, -1.213982e+00, -1.870895e-01,  9.061095e-02},
  {-9.438826e-01, -6.217150e-02,  3.243769e-01, -1.215491e+00, -1.407530e-01,  1.293545e-01},
  {-9.944682e-01, -7.645827e-02,  7.202221e-02, -1.223868e+00, -1.376803e-01,  7.780676e-02},
  {-9.664583e-01,  8.126618e-02,  2.436274e-01, -1.217437e+00, -7.224706e-02,  1.159206e-01},
  {-9.935765e-01,  9.583870e-02,  6.017312e-02, -1.222795e+00, -7.145510e-02,  6.709673e-02},
  {-9.395016e-01,  1.650518e-01,  3.001573e-01, -1.200860e+00,  2.010051e-02,  1.210723e-01},
  {-9.904673e-01,  1.028476e-01,  9.163450e-02, -1.195828e+00,  9.923165e-02,  9.123260e-02},
  {-9.970791e-01, -6.353991e-02, -4.237852e-02, -1.190699e+00,  2.368523e-01,  8.162487e-02},
  {-9.239342e-01, -1.065675e-02,  3.824028e-01, -1.169381e+00,  9.924679e-02,  1.504501e-01},
  {-7.455583e-01,  1.634534e-01,  6.460850e-01, -1.180920e+00,  2.380521e-02,  1.558810e-01},
  {-8.210993e-01,  9.986528e-02,  5.619813e-01, -1.196026e+00, -7.194246e-02,  1.630054e-01},
  {-7.189123e-01, -3.771644e-02,  6.940768e-01, -1.186446e+00, -1.441010e-01,  1.781218e-01},
  {-6.256617e-01, -1.260510e-01,  7.698432e-01, -1.168101e+00, -2.003202e-01,  1.866871e-01},
  {-8.642207e-01,  8.699957e-02,  4.955337e-01, -1.132244e+00, -2.486516e-01,  1.998293e-01},
  {-5.679466e-01,  1.044501e-01,  8.164110e-01, -1.162103e+00, -7.007477e-02,  1.921630e-01},
  {-8.642520e-01, -8.076441e-02,  4.965336e-01, -1.124572e+00, -6.712591e-02,  2.110500e-01},
  {-8.505237e-01, -2.892779e-02,  5.251405e-01, -1.149577e+00,  2.362049e-02,  1.833241e-01},
  {-8.824229e-01,  9.500268e-02,  4.607649e-01, -1.118868e+00, -1.972704e-01,  2.142291e-01},
  {-7.908217e-01,  1.450135e-02,  6.118748e-01, -1.108923e+00, -1.403032e-01,  2.257498e-01},
  {-9.876706e-01, -1.440789e-01, -6.122157e-02, -1.195971e+00,  3.063626e-01,  5.967500e-02},
  {-9.725969e-01, -2.080456e-01, -1.037900e-01, -1.203642e+00,  3.459567e-01,  6.602918e-02},
  {-7.618834e-01, -3.907426e-03,  6.477025e-01,  2.639059e-01, -6.958669e-01,  2.716031e-01},
  {-1.783056e-01,  2.413349e-02,  9.836791e-01,  2.818689e-01, -6.906345e-01,  2.691367e-01},
  {-7.134270e-01,  3.243614e-02,  6.999784e-01,  2.594307e-01, -6.434383e-01,  2.538156e-01},
  {-1.419710e-01,  1.558284e-01,  9.775283e-01,  2.740520e-01, -6.416638e-01,  2.605077e-01},
  { 5.530006e-01,  2.978044e-01,  7.781407e-01,  3.435937e-01, -6.713162e-01,  2.570753e-01},
  { 5.754048e-01,  2.316481e-01,  7.843778e-01,  3.261555e-01, -6.261992e-01,  2.480591e-01},
  {-5.082554e-02,  1.698320e-01,  9.841616e-01,  3.036398e-01, -6.213306e-01,  2.501834e-01},
  { 9.640100e-01,  2.657874e-01,  6.458568e-03,  3.370688e-01, -6.196322e-01,  2.288716e-01},
  {-4.288140e-01, -8.725083e-02,  8.991696e-01,  2.640461e-01, -7.115221e-01,  2.678460e-01},
  {-2.704388e-01, -6.380781e-01,  7.209156e-01,  2.603751e-01, -7.374476e-01,  2.695972e-01},
  { 1.931437e-02, -3.549404e-01,  9.346893e-01,  2.793191e-01, -7.299383e-01,  2.657448e-01},
  {-5.775858e-01, -5.118472e-01,  6.359301e-01,  2.851709e-01, -7.426115e-01,  2.569270e-01},
  {-1.798801e-01,  4.342689e-01,  8.826401e-01,  3.521954e-01, -7.807679e-01,  3.057034e-01},
  { 1.976726e-01,  5.865515e-01,  7.854189e-01,  3.638262e-01, -7.504017e-01,  2.885439e-01},
  { 1.158074e-02,  4.143348e-01,  9.100509e-01,  3.769091e-01, -8.215886e-01,  3.280812e-01},
  { 4.061706e-01,  6.037313e-01,  6.859548e-01,  4.014202e-01, -8.008758e-01,  3.076681e-01},
  { 4.126371e-01,  3.346941e-01,  8.471780e-01,  4.315205e-01, -8.450978e-01,  3.291141e-01},
  { 3.372570e-01, -7.694921e-01,  5.423463e-01,  4.070303e-01, -8.569611e-01,  3.400885e-01},
  {-3.821585e-01, -5.931945e-01,  7.085725e-01,  3.440050e-01, -8.585888e-01,  3.317517e-01},
  {-4.489237e-01,  3.280499e-01,  8.311744e-01,  3.365550e-01, -8.210558e-01,  3.193766e-01},
  { 7.094319e-01,  5.195531e-01,  4.762047e-01,  3.838124e-01, -7.422984e-01,  2.695297e-01},
  { 9.570006e-01,  2.825668e-01, -6.562012e-02,  3.919762e-01, -7.499654e-01,  2.446820e-01},
  { 8.930275e-01,  4.232612e-01, -1.528130e-01,  3.682684e-01, -7.085261e-01,  2.345004e-01},
  { 5.266707e-01,  4.495596e-01,  7.214666e-01,  3.621975e-01, -7.141944e-01,  2.607635e-01},
  {-8.628063e-01, -2.806028e-01,  4.205085e-01,  3.147967e-01, -8.393793e-01,  3.058766e-01},
  { 2.217250e-01,  3.591692e-01,  9.065515e-01,  3.316563e-01, -7.173494e-01,  2.655016e-01},
  { 3.529711e-02,  2.120356e-01,  9.766243e-01,  2.952142e-01, -6.852340e-01,  2.745136e-01},
  { 1.177725e-01,  2.417289e-01,  9.631702e-01,  2.903672e-01, -6.326041e-01,  2.487263e-01},
  {-9.601977e-01, -2.642432e-01, -9.053113e-02,  2.569134e-01, -7.419242e-01,  2.224655e-01},
  {-4.906774e-01, -8.576381e-01, -1.539244e-01,  2.836867e-01, -7.529927e-01,  2.297663e-01},
  {-9.321039e-01, -2.811811e-01, -2.282972e-01,  2.909513e-01, -7.869061e-01,  2.381983e-01},
  {-2.569689e-01, -9.658887e-01, -3.203006e-02,  3.523371e-01, -8.587353e-01,  2.534414e-01},
  {-6.914968e-01, -7.165846e-01, -9.131665e-02,  3.223595e-01, -8.458971e-01,  2.435677e-01},
  {-8.932547e-01, -4.056675e-01, -1.937262e-01,  3.017287e-01, -8.128687e-01,  2.459282e-01},
  {-2.892332e-01, -2.121124e-01, -9.334626e-01,  3.095899e-01, -7.415902e-01,  2.006250e-01},
  {-4.377995e-01, -4.389287e-01, -7.846484e-01,  2.659121e-01, -7.367025e-01,  1.929384e-01},
  {-5.682018e-01, -8.607547e-02, -8.183749e-01,  3.176436e-01, -7.874320e-01,  1.898636e-01},
  {-6.978391e-01, -2.958299e-01, -6.523076e-01,  3.208362e-01, -8.249854e-01,  1.931061e-01},
  {-3.959253e-01, -6.756027e-01, -6.219360e-01,  3.377481e-01, -8.493860e-01,  1.894685e-01},
  { 4.987545e-02, -8.297789e-01, -5.558593e-01,  3.718386e-01, -8.566164e-01,  1.930210e-01},
  { 1.374440e-01, -9.898672e-01, -3.566612e-02,  3.946851e-01, -8.590401e-01,  2.591067e-01},
  { 4.455104e-01, -4.678316e-01, -7.633178e-01,  4.042180e-01, -8.554814e-01,  2.017999e-01},
  {-7.659534e-01,  8.957537e-02, -6.366251e-01,  2.716542e-01, -6.907935e-01,  2.028356e-01},
  {-9.822149e-01, -7.206418e-02, -1.733805e-01,  2.578196e-01, -6.535914e-01,  2.298985e-01},
  {-6.723220e-01, -4.860649e-02, -7.386613e-01,  2.662253e-01, -6.272655e-01,  2.058373e-01},
  {-6.558794e-02,  2.456916e-01,  9.671266e-01,  3.090645e-01, -7.240621e-01,  2.737899e-01},
  {-3.345165e-01, -5.315158e-02,  9.408898e-01,  2.971036e-01, -7.281796e-01,  2.715296e-01},
  { 7.184898e-01,  3.830874e-01, -5.805313e-01,  3.769571e-01, -7.425447e-01,  2.188322e-01},
  { 8.972588e-01,  2.490779e-01,  3.645365e-01,  4.435048e-01, -8.325353e-01,  3.129286e-01},
  { 9.144476e-01, -3.960817e-01,  8.309528e-02,  4.582109e-01, -8.455708e-01,  2.806954e-01},
  { 7.825287e-01,  6.205013e-01,  5.125451e-02,  4.261420e-01, -8.054448e-01,  2.635895e-01},
  { 8.867784e-01, -2.102060e-01, -4.116279e-01,  4.410231e-01, -8.385618e-01,  2.203706e-01},
  { 6.734085e-01,  4.496651e-01, -5.867898e-01,  4.221737e-01, -8.003871e-01,  2.206944e-01},
  { 8.233817e-01,  4.030217e-01, -3.995199e-01,  3.935837e-01, -7.725158e-01,  2.216948e-01},
  {-1.102317e-01, -1.082383e-03, -9.939054e-01,  2.962386e-01, -6.896318e-01,  1.917666e-01},
  { 3.517630e-01,  1.557653e-01, -9.230384e-01,  3.364689e-01, -7.162644e-01,  1.979360e-01},
  { 4.785755e-01,  1.164640e-01, -8.702883e-01,  3.220222e-01, -6.713151e-01,  1.936028e-01},
  { 9.012032e-02,  2.490429e-02, -9.956195e-01,  3.051394e-01, -6.293778e-01,  1.932947e-01},
  { 8.029198e-01,  1.506825e-01, -5.767274e-01,  3.294607e-01, -6.306015e-01,  2.127060e-01},
  { 2.643569e-01,  2.264550e-01, -9.374613e-01,  3.523596e-01, -7.643098e-01,  1.893387e-01},
  { 2.142038e-01,  8.628597e-02, -9.729705e-01,  3.667259e-01, -8.053718e-01,  1.864132e-01},
  { 3.840068e-01, -3.851502e-01,  8.391652e-01, -9.716366e-01, -3.085614e-01,  2.988026e-01},
  { 7.059772e-01, -4.152105e-01,  5.737565e-01, -1.017255e+00, -4.035311e-01,  2.766318e-01},
  { 4.488021e-01, -2.041522e-01,  8.699991e-01, -1.037965e+00, -3.909939e-01,  2.951167e-01},
  {-3.281910e-02, -8.501031e-02,  9.958394e-01, -1.068895e+00, -3.913342e-01,  3.004955e-01},
  {-1.268475e-01, -8.066987e-02,  9.886366e-01, -1.029161e+00, -2.986144e-01,  3.082303e-01},
  {-4.248468e-01,  9.137569e-02,  9.006418e-01, -1.100924e+00, -3.780335e-01,  2.911180e-01},
  {-8.767985e-01,  5.884886e-02, -4.772434e-01, -1.177020e+00, -3.644024e-01,  2.099459e-01},
  {-8.663520e-01,  3.452420e-01,  3.608908e-01, -1.146665e+00, -2.993045e-01,  2.459548e-01},
  {-8.841360e-01,  8.787787e-02,  4.588913e-01, -1.174817e+00, -3.639450e-01,  2.486688e-01},
  {-8.129639e-01,  2.343968e-01,  5.330553e-01, -1.129172e+00, -2.519216e-01,  2.465731e-01},
  { 4.142191e-01, -4.391951e-02,  9.091169e-01, -1.060366e+00, -5.089483e-01,  2.843335e-01},
  {-1.402757e-01, -7.131786e-03,  9.900869e-01, -1.085867e+00, -5.131633e-01,  2.881434e-01},
  { 3.059290e-01,  3.293455e-02,  9.514845e-01, -1.061422e+00, -5.824523e-01,  2.882447e-01},
  { 3.990519e-01, -1.531105e-01,  9.040546e-01, -1.053664e+00, -4.553606e-01,  2.894011e-01},
  {-1.909107e-01, -6.904320e-02,  9.791762e-01, -1.097284e+00, -4.549107e-01,  2.916404e-01},
  {-2.020535e-01,  1.449084e-01,  9.685948e-01, -1.109014e+00, -5.852245e-01,  2.818547e-01},
  {-7.419452e-01, -6.366007e-03,  6.704302e-01, -1.133934e+00, -5.829586e-01,  2.652161e-01},
  {-7.561778e-01, -8.479203e-02,  6.488494e-01, -1.162374e+00, -4.444685e-01,  2.558203e-01},
  { 9.158397e-01, -1.383839e-01,  3.769450e-01, -1.041813e+00, -5.044541e-01,  2.710202e-01},
  { 8.392431e-01, -2.787481e-01,  4.668729e-01, -1.032176e+00, -4.474650e-01,  2.697042e-01},
  { 8.578396e-01, -5.132991e-01, -2.520389e-02, -1.009226e+00, -4.104415e-01,  2.390257e-01},
  { 7.862031e-01, -3.538046e-01, -5.066626e-01, -1.035123e+00, -4.659913e-01,  2.403034e-01},
  { 7.606044e-01, -1.541460e-01, -6.306505e-01, -1.048180e+00, -5.156086e-01,  2.434994e-01},
  { 4.946274e-01, -5.297537e-01, -6.889881e-01, -1.029899e+00, -4.240564e-01,  2.138283e-01},
  { 2.040174e-01, -2.309576e-01, -9.513335e-01, -1.073158e+00, -5.226764e-01,  2.301055e-01},
  { 2.945924e-01, -2.925246e-01, -9.097497e-01, -1.076775e+00, -4.779963e-01,  2.148130e-01},
  { 1.535952e-01, -3.337310e-01, -9.300711e-01, -1.063230e+00, -4.257044e-01,  2.023352e-01},
  {-3.350366e-02, -2.479376e-01, -9.681965e-01, -1.106742e+00, -4.660505e-01,  2.111374e-01},
  { 2.798339e-01, -5.090247e-02, -9.586980e-01, -1.078067e+00, -5.829693e-01,  2.351253e-01},
  {-3.677881e-01, -1.991668e-01, -9.083306e-01, -1.144733e+00, -3.826059e-01,  1.919276e-01},
  {-4.119338e-01, -2.348771e-01, -8.804221e-01, -1.156142e+00, -4.494075e-01,  2.130920e-01},
  {-2.877793e-01, -3.083007e-01, -9.067159e-01, -1.133230e+00, -5.202683e-01,  2.278711e-01},
  {-9.456179e-01, -1.968109e-01, -2.589831e-01, -1.166302e+00, -4.479359e-01,  2.281124e-01},
  {-6.400180e-01, -1.392988e-01, -7.556273e-01, -1.142920e+00, -5.907172e-01,  2.510272e-01},
  { 9.873956e-01, -1.527344e-01,  4.149828e-02,  3.437466e-01, -4.836989e-01,  2.233862e-01},
  { 9.889011e-01,  1.880295e-02,  1.473808e-01,  3.243018e-01, -5.571893e-01,  2.287032e-01},
  { 6.533312e-01, -5.706612e-02,  7.549184e-01,  3.183314e-01, -5.530506e-01,  2.479368e-01},
  { 8.327756e-01, -8.382584e-02,  5.472276e-01,  3.366288e-01, -4.384637e-01,  2.498402e-01},
  { 9.913498e-01, -8.084101e-02,  1.033938e-01,  3.516156e-01, -3.578509e-01,  2.271224e-01},
  { 8.091436e-01, -2.578686e-01,  5.280060e-01,  3.427830e-01, -3.119718e-01,  2.663845e-01},
  { 9.730546e-01, -2.304460e-01, -7.700552e-03,  3.512961e-01, -3.089071e-01,  2.326532e-01},
  { 5.554186e-03, -5.181915e-02,  9.986411e-01,  2.647471e-01, -5.634629e-01,  2.528623e-01},
  {-5.753750e-01, -4.718270e-02,  8.165277e-01,  2.530577e-01, -5.797298e-01,  2.484872e-01},
  {-4.045829e-01, -1.730336e-01,  8.979822e-01,  2.445785e-01, -5.140678e-01,  2.539774e-01},
  {-3.699468e-01, -1.726291e-01,  9.128738e-01,  2.346615e-01, -4.525689e-01,  2.617398e-01},
  {-4.777632e-01, -1.904582e-01,  8.575943e-01,  2.233123e-01, -3.868236e-01,  2.694115e-01},
  {-1.461276e-01, -2.948837e-01,  9.442936e-01,  2.454360e-01, -3.398942e-01,  2.867649e-01},
  {-9.731305e-01, -2.000175e-01,  1.140611e-01,  2.422580e-01, -5.733506e-01,  2.324686e-01},
  {-9.283192e-01, -2.446015e-01,  2.799885e-01,  2.073870e-01, -4.552689e-01,  2.443317e-01},
  {-9.059340e-01, -1.976677e-01,  3.744476e-01,  1.957578e-01, -3.282876e-01,  2.557697e-01},
  {-6.228823e-01, -1.981502e-01, -7.568052e-01,  2.451703e-01, -5.578659e-01,  2.178593e-01},
  {-9.135164e-01, -2.008009e-01, -3.537892e-01,  1.921274e-01, -3.800611e-01,  2.201624e-01},
  {-7.736765e-01, -6.276197e-01, -8.670691e-02,  1.860529e-01, -3.134016e-01,  1.935037e-01},
  {-5.778962e-01, -2.593605e-01, -7.738011e-01,  2.521553e-01, -4.920284e-01,  1.918934e-01},
  {-2.167880e-01, -8.610560e-01, -4.599844e-01,  2.268222e-01, -3.185424e-01,  1.715933e-01},
  { 5.713282e-01, -2.452276e-01,  7.832289e-01,  3.185480e-01, -3.316295e-01,  2.796005e-01},
  { 3.694280e-01, -1.165708e-01,  9.219187e-01,  3.206115e-01, -3.787457e-01,  2.709217e-01},
  { 3.870969e-01, -7.985510e-02,  9.185745e-01,  3.145902e-01, -4.529479e-01,  2.757000e-01},
  { 4.693868e-01, -1.918310e-01,  8.619030e-01,  3.112114e-01, -5.076405e-01,  2.656806e-01},
  { 1.290055e-01, -2.649044e-01,  9.556062e-01,  2.826280e-01, -3.138892e-01,  2.957431e-01},
  {-1.358680e-01, -9.863439e-02,  9.858048e-01,  2.871381e-01, -4.585660e-01,  2.724651e-01},
  {-1.895048e-01, -2.914003e-01, -9.376427e-01,  2.706574e-01, -3.484046e-01,  1.787044e-01},
  {-3.406714e-03, -8.245378e-01, -5.657966e-01,  2.693967e-01, -3.173755e-01,  1.681876e-01},
  {-9.000722e-02, -1.143437e-01, -9.893554e-01,  2.675138e-01, -4.485049e-01,  1.759042e-01},
  { 7.621698e-01, -8.383683e-02, -6.419256e-01,  3.224715e-01, -5.519574e-01,  2.017171e-01},
  { 4.923760e-01, -1.030597e-01, -8.642595e-01,  3.347598e-01, -3.606361e-01,  1.797395e-01},
  { 5.985032e-01, -7.011353e-01, -3.875603e-01,  3.268466e-01, -3.167012e-01,  1.687506e-01},
  { 6.598151e-01, -1.191768e-01, -7.419171e-01,  3.219049e-01, -4.342559e-01,  1.852339e-01},
  { 6.037501e-01, -2.889199e-01,  7.429745e-01,  3.566525e-01, -2.251732e-01,  2.912658e-01},
  { 8.782846e-01, -2.919133e-01,  3.786856e-01,  3.554151e-01, -2.675325e-01,  2.698440e-01},
  { 2.838563e-01, -2.366760e-01,  9.291986e-01,  3.201902e-01, -2.225471e-01,  3.135591e-01},
  { 4.748998e-01, -2.871549e-01,  8.318727e-01,  3.265413e-01, -2.805272e-01,  2.922347e-01},
  { 5.859776e-02, -2.533281e-01,  9.656041e-01,  2.809142e-01, -2.699663e-01,  3.085696e-01},
  {-2.746399e-02, -1.696670e-01,  9.851187e-01,  2.781168e-01, -2.220873e-01,  3.191391e-01},
  {-2.442927e-01, -2.459360e-01,  9.379960e-01,  2.337989e-01, -2.873071e-01,  2.992658e-01},
  {-2.239889e-01, -2.011482e-01,  9.536081e-01,  2.345022e-01, -2.297169e-01,  3.123428e-01},
  {-6.077158e-01, -2.601091e-01,  7.503497e-01,  2.009325e-01, -2.372229e-01,  2.964370e-01},
  {-6.159006e-01, -2.336014e-01,  7.523941e-01,  2.045412e-01, -2.858689e-01,  2.862844e-01},
  {-8.420285e-01, -3.019377e-01,  4.470141e-01,  1.839229e-01, -2.707362e-01,  2.596746e-01},
  {-6.495150e-01, -4.224137e-01,  6.322160e-01,  1.567176e-01, -2.329819e-01,  2.406511e-01},
  {-5.449591e-01, -5.878606e-01,  5.978624e-01,  1.477603e-01, -2.561980e-01,  2.108628e-01},
  { 8.015674e-01, -3.548852e-01,  4.811924e-01,  3.756694e-01, -1.821943e-01,  2.896687e-01},
  { 3.701825e-01, -2.171036e-01,  9.032336e-01,  3.424911e-01, -1.747590e-01,  3.167157e-01},
  { 3.477463e-02, -1.242024e-01,  9.916474e-01,  2.913046e-01, -1.792902e-01,  3.260366e-01},
  {-2.819039e-01, -1.837262e-01,  9.416872e-01,  2.077263e-01, -1.890560e-01,  3.128883e-01},
  {-6.276681e-01, -2.236946e-01,  7.456497e-01,  1.805537e-01, -1.921796e-01,  2.955394e-01},
  {-5.829770e-01, -3.719861e-01,  7.223325e-01,  1.498628e-01, -1.956822e-01,  2.577863e-01},
  { 8.529352e-01, -1.496788e-02,  5.218022e-01,  3.981424e-01, -1.428191e-01,  2.792416e-01},
  { 9.135525e-02, -2.146006e-02,  9.955871e-01,  3.084308e-01, -1.369787e-01,  3.274690e-01},
  {-2.107729e-02, -7.683510e-02,  9.968209e-01,  2.560078e-01, -1.415917e-01,  3.263683e-01},
  { 4.063763e-01,  1.962784e-01,  8.923751e-01,  3.530146e-01, -1.356314e-01,  3.203735e-01},
  { 6.555822e-01,  9.339948e-03,  7.550661e-01,  3.806586e-01, -1.423970e-01,  3.066415e-01},
  {-3.015782e-01, -4.025279e-01,  8.643043e-01,  1.533016e-01, -1.437155e-01,  2.827264e-01},
  {-4.287839e-01, -1.342889e-01,  8.933705e-01,  1.899684e-01, -1.389713e-01,  3.129691e-01},
  {-1.962276e-01, -1.159472e-01,  9.736791e-01,  2.177959e-01, -1.526515e-01,  3.235514e-01},
  {-2.307271e-01,  7.136313e-01,  6.614344e-01,  6.227202e-01,  6.481205e-01,  4.290661e-02},
  {-3.785191e-01,  6.869690e-01,  6.203200e-01,  6.930175e-01,  6.767633e-01,  4.661803e-02},
  {-1.291211e-01,  4.511545e-01,  8.830557e-01,  6.236497e-01,  6.100185e-01,  7.687767e-02},
  {-2.280719e-01,  3.822988e-01,  8.954501e-01,  7.061726e-01,  6.055025e-01,  9.455765e-02},
  {-1.736764e-01,  1.542802e-01,  9.726428e-01,  7.359822e-01,  4.910288e-01,  1.249073e-01},
  { 6.349067e-02,  8.637857e-02,  9.942372e-01,  6.694232e-01,  3.691356e-01,  1.355873e-01},
  { 1.822565e-01, -6.076377e-02,  9.813716e-01,  7.638743e-01,  3.227565e-01,  1.247371e-01},
  { 2.418413e-01, -4.805285e-02,  9.691252e-01,  6.901053e-01,  2.747297e-01,  1.353140e-01},
  { 4.254027e-01, -2.664329e-01,  8.648965e-01,  7.149256e-01,  1.746706e-01,  1.142273e-01},
  { 3.608078e-01, -2.907360e-01,  8.861660e-01,  7.765846e-01,  2.272807e-01,  1.028142e-01},
  { 7.170953e-01, -5.302733e-01,  4.523102e-01,  7.570808e-01,  8.907030e-02,  5.293112e-02},
  { 6.648487e-01, -5.226209e-01,  5.337074e-01,  8.148643e-01,  1.663758e-01,  5.087217e-02},
  {-4.631620e-01,  8.235791e-01,  3.274119e-01,  7.357910e-01,  7.126454e-01,  2.510768e-02},
  { 4.863694e-01, -7.195710e-01,  4.956434e-01,  9.209640e-01,  2.934667e-01,  5.106650e-02},
  { 1.659998e-01, -3.575538e-01,  9.190210e-01,  8.423480e-01,  3.070962e-01,  1.072639e-01},
  {-4.741388e-01, -6.597273e-02,  8.779749e-01,  8.216650e-01,  6.590427e-01,  1.158729e-01},
  {-3.567508e-01,  3.314210e-01,  8.734352e-01,  7.463018e-01,  6.637533e-01,  8.491380e-02},
  {-5.917805e-01,  6.390686e-01,  4.913116e-01,  8.097693e-01,  7.402563e-01,  6.298738e-02},
  { 7.815855e-01, -4.998982e-01,  3.731299e-01,  7.024115e-01,  1.194178e-02,  5.937492e-02},
  { 3.020466e-02,  9.239476e-01,  3.813247e-01,  4.474665e-01,  6.004274e-01,  5.827994e-02},
  { 1.878727e-03,  6.367385e-01,  7.710775e-01,  5.363110e-01,  5.819929e-01,  8.218201e-02},
  { 1.769455e-01,  5.966905e-01,  7.827200e-01,  4.579743e-01,  5.729945e-01,  9.033568e-02},
  { 3.183590e-01,  3.093438e-02,  9.474654e-01,  5.984520e-01,  3.297721e-01,  1.480916e-01},
  { 4.516797e-01,  2.750323e-01,  8.487300e-01,  5.414667e-01,  3.273995e-01,  1.706472e-01},
  { 4.065241e-01, -8.299032e-02,  9.098630e-01,  6.482775e-01,  1.742897e-01,  1.474217e-01},
  { 4.384995e-01, -1.632455e-01,  8.837811e-01,  6.040336e-01,  8.451811e-02,  1.450881e-01},
  { 7.129120e-01,  3.449717e-01,  6.105334e-01,  5.271223e-01,  3.002495e-01,  1.963495e-01},
  { 6.486987e-01,  2.186858e-01,  7.289489e-01,  5.486873e-01,  2.327140e-01,  1.969451e-01},
  { 7.817397e-01,  7.465407e-02,  6.191202e-01,  5.548175e-01,  1.796076e-01,  2.037353e-01},
  { 7.156394e-01, -1.416653e-01,  6.839526e-01,  5.564203e-01,  1.341349e-01,  2.000288e-01},
  { 7.911363e-01, -1.912669e-01,  5.809650e-01,  5.525263e-01,  8.828810e-02,  1.925547e-01},
  { 4.633577e-01,  4.812244e-01,  7.441255e-01,  4.503488e-01,  4.461036e-01,  1.722845e-01},
  { 5.459237e-01,  4.695893e-01,  6.938683e-01,  4.615632e-01,  3.882750e-01,  2.029295e-01},
  { 6.567129e-01, -4.130513e-01,  6.309650e-01,  4.806302e-01, -3.919308e-02,  2.505940e-01},
  { 8.356782e-01, -2.110211e-01,  5.070620e-01,  5.221029e-01,  1.961884e-02,  2.251455e-01},
  { 6.803791e-01, -2.731825e-01,  6.800408e-01,  4.892592e-01,  6.141723e-03,  2.692713e-01},
  { 7.679571e-01, -1.698295e-01,  6.175758e-01,  5.037242e-01,  6.937532e-02,  2.671016e-01},
  { 8.549780e-01, -9.529605e-02,  5.098346e-01,  5.355497e-01,  1.297077e-01,  2.365543e-01},
  { 7.123234e-01, -4.138086e-02,  7.006305e-01,  5.069556e-01,  1.322954e-01,  2.812656e-01},
  { 7.413489e-01,  1.284651e-01,  6.587098e-01,  5.173019e-01,  1.812060e-01,  2.689825e-01},
  { 8.621638e-01,  8.401881e-02,  4.996141e-01,  5.366465e-01,  1.806683e-01,  2.401867e-01},
  { 6.150903e-01,  3.369028e-01,  7.128537e-01,  4.991264e-01,  2.476963e-01,  2.603091e-01},
  { 7.979677e-01,  2.628650e-01,  5.423555e-01,  5.291387e-01,  2.321546e-01,  2.298590e-01},
  { 6.994189e-01,  4.060746e-01,  5.881467e-01,  5.029760e-01,  3.173075e-01,  2.134939e-01},
  { 5.274137e-01,  4.408607e-01,  7.262760e-01,  4.823729e-01,  3.241150e-01,  2.313385e-01},
  {-1.075258e-01,  9.519283e-01,  2.868289e-01,  3.803151e-01,  6.009552e-01,  4.576200e-02},
  { 6.324145e-01, -4.006059e-01,  6.629983e-01,  4.196469e-01, -8.577595e-02,  2.757878e-01},
  { 6.785142e-01, -2.136741e-01,  7.028242e-01,  3.990341e-01, -1.101319e-01,  2.777747e-01},
  { 1.210078e-02,  8.461514e-01,  5.328053e-01,  3.526670e-01,  5.786309e-01,  8.881211e-02},
  { 2.233249e-01,  5.854436e-01,  7.793469e-01,  3.947248e-01,  4.730049e-01,  1.803818e-01},
  { 3.103212e-01,  4.967113e-01,  8.105422e-01,  4.145957e-01,  4.099817e-01,  2.137802e-01},
  { 3.120748e-01,  4.542283e-01,  8.344375e-01,  4.292684e-01,  3.357287e-01,  2.518807e-01},
  { 3.311508e-01,  3.835593e-01,  8.621029e-01,  4.442526e-01,  2.626262e-01,  2.844608e-01},
  { 4.287553e-01,  1.971385e-01,  8.816491e-01,  4.632632e-01,  1.825674e-01,  3.056239e-01},
  { 5.201346e-01, -6.022000e-02,  8.519587e-01,  4.681219e-01,  1.103890e-01,  3.120105e-01},
  { 5.031180e-01, -1.259746e-01,  8.549870e-01,  4.521823e-01,  5.809744e-02,  3.114755e-01},
  { 4.274552e-01, -2.613425e-01,  8.654376e-01,  4.398297e-01,  1.671704e-02,  3.113482e-01},
  { 5.372207e-01, -3.882414e-01,  7.487741e-01,  4.348989e-01, -3.833540e-02,  2.872664e-01},
  { 2.953089e-01, -1.077051e-01,  9.493115e-01,  3.361053e-01, -7.532150e-02,  3.206460e-01},
  { 2.661954e-01, -2.498532e-01,  9.309744e-01,  3.568299e-01,  1.410185e-02,  3.368256e-01},
  { 2.492908e-02,  9.669516e-01,  2.537383e-01,  2.766520e-01,  6.034197e-01,  3.874282e-02},
  { 2.635266e-01, -1.015421e-01,  9.592929e-01,  3.756797e-01,  6.023000e-02,  3.410860e-01},
  { 2.015655e-01,  5.272588e-02,  9.780548e-01,  3.739269e-01,  1.108798e-01,  3.422209e-01},
  { 1.224638e-01,  2.632796e-01,  9.569151e-01,  3.529959e-01,  1.941172e-01,  3.328093e-01},
  { 1.434485e-01,  3.913746e-01,  9.089822e-01,  3.300404e-01,  2.692781e-01,  3.065778e-01},
  { 1.358349e-01,  4.553070e-01,  8.799116e-01,  3.252497e-01,  3.547273e-01,  2.693216e-01},
  { 1.131064e-01,  5.393760e-01,  8.344342e-01,  3.150015e-01,  4.345560e-01,  2.261208e-01},
  { 5.962944e-02,  6.935440e-01,  7.179422e-01,  2.960804e-01,  5.100987e-01,  1.716688e-01},
  {-4.214412e-03,  8.497012e-01,  5.272477e-01,  2.701043e-01,  5.886244e-01,  7.434469e-02},
  {-6.355452e-02,  8.180225e-01,  5.716642e-01,  1.593445e-02,  5.634436e-01,  8.094017e-02},
  {-7.583509e-03,  9.203876e-01,  3.909336e-01, -1.428265e-01,  5.831318e-01,  3.848361e-02},
  {-5.118292e-02,  8.347757e-01,  5.482060e-01, -1.546874e-01,  5.587747e-01,  8.299814e-02},
  { 1.030871e-02,  7.527351e-01,  6.582429e-01, -1.351702e-01,  5.228844e-01,  1.307192e-01},
  {-2.352632e-02,  5.634817e-01,  8.257935e-01,  6.924406e-03,  4.048061e-01,  2.335852e-01},
  { 1.117387e-01,  5.405204e-01,  8.338778e-01, -1.202847e-01,  3.234269e-01,  2.997182e-01},
  { 1.007200e-01,  3.211960e-01,  9.416414e-01,  4.068547e-02,  1.822741e-01,  3.412835e-01},
  { 2.339743e-01,  2.284055e-01,  9.450328e-01, -8.175389e-02,  1.155122e-01,  3.782669e-01},
  { 1.164904e-01,  3.027189e-02,  9.927304e-01,  6.199035e-02,  9.221059e-02,  3.536881e-01},
  { 1.251339e-01, -2.912246e-01,  9.484354e-01,  5.071780e-02,  3.596223e-02,  3.422954e-01},
  { 2.281982e-01, -2.934443e-01,  9.283405e-01,  3.729961e-02, -2.328230e-02,  3.284593e-01},
  { 3.470247e-01, -1.960037e-01,  9.171458e-01, -7.106667e-02, -5.246484e-02,  3.658021e-01},
  { 2.151726e-01, -3.292269e-01,  9.194077e-01,  4.093230e-02, -7.052543e-02,  3.114318e-01},
  { 2.249156e-01, -4.404288e-01,  8.691579e-01,  2.897081e-02, -1.310938e-01,  2.900412e-01},
  { 3.738912e-01, -3.801960e-01,  8.459647e-01, -7.524383e-02, -1.189101e-01,  3.437483e-01},
  { 3.445278e-01, -5.574124e-01,  7.553754e-01, -6.768450e-02, -1.894113e-01,  3.006859e-01},
  { 1.210214e-01, -5.989281e-01,  7.916054e-01,  5.564392e-02, -1.751878e-01,  2.585655e-01},
  { 3.085064e-01, -7.265700e-01,  6.139379e-01, -1.026871e-01, -2.473422e-01,  2.628702e-01},
  { 1.441781e-01, -7.411719e-01,  6.556500e-01,  3.333531e-02, -2.448437e-01,  1.999419e-01},
  { 1.569350e-01, -9.708867e-01,  1.809707e-01,  2.920692e-02, -2.967200e-01,  1.180098e-01},
  { 1.946189e-01,  9.270289e-01,  3.205323e-01, -3.655028e-01,  5.866358e-01,  4.424684e-02},
  { 2.013844e-01,  7.573654e-01,  6.211618e-01, -3.730648e-01,  5.289326e-01,  1.689437e-01},
  { 1.144223e-01,  8.011415e-01,  5.874349e-01, -2.492852e-01,  5.182024e-01,  1.534634e-01},
  { 1.656988e-01,  5.278256e-01,  8.330330e-01, -2.576844e-01,  2.698571e-01,  3.518506e-01},
  { 8.612493e-02,  4.742361e-01,  8.761750e-01, -4.061216e-01,  2.496109e-01,  3.878713e-01},
  { 2.081506e-01,  4.187529e-01,  8.839228e-01, -2.121927e-01,  1.764064e-01,  3.935553e-01},
  { 6.327879e-02,  3.381054e-01,  9.389785e-01, -3.800187e-01,  1.688895e-01,  4.245774e-01},
  { 2.015457e-01,  2.348489e-01,  9.509076e-01, -2.281202e-01,  1.200316e-01,  4.171135e-01},
  { 9.407270e-02,  1.302727e-01,  9.870052e-01, -3.489918e-01,  7.382681e-02,  4.469351e-01},
  { 2.797857e-01,  4.627606e-02,  9.589465e-01, -1.824326e-01,  6.111249e-02,  4.136988e-01},
  { 9.323598e-02, -9.170874e-02,  9.914114e-01, -3.574528e-01, -4.136622e-02,  4.523091e-01},
  { 2.668972e-01, -5.135811e-02,  9.623556e-01, -2.091438e-01, -1.212466e-02,  4.230216e-01},
  { 2.937262e-01, -2.608123e-01,  9.196205e-01, -2.113211e-01, -9.863317e-02,  4.090692e-01},
  { 9.637995e-02, -3.442138e-01,  9.339313e-01, -3.550765e-01, -1.349367e-01,  4.338202e-01},
  { 2.965107e-01, -4.732739e-01,  8.295138e-01, -2.195977e-01, -1.788741e-01,  3.782185e-01},
  { 7.567235e-02, -5.796411e-01,  8.113506e-01, -3.547391e-01, -2.079464e-01,  3.966375e-01},
  { 1.191495e-02, -7.661728e-01,  6.425241e-01, -3.709296e-01, -2.568877e-01,  3.541397e-01},
  { 2.432512e-01, -6.954880e-01,  6.761104e-01, -2.381384e-01, -2.427145e-01,  3.349009e-01},
  { 2.004575e-01, -7.754638e-01,  5.987259e-01, -2.439783e-01, -2.812328e-01,  2.888092e-01},
  { 2.341895e-02, -8.174581e-01,  5.755118e-01, -3.581154e-01, -2.863533e-01,  3.100050e-01},
  { 1.418821e-01,  9.137684e-01,  3.806532e-01, -4.912612e-01,  5.625665e-01,  1.448630e-01},
  { 2.190484e-01,  6.767656e-01,  7.028558e-01, -4.856457e-01,  5.321574e-01,  1.989812e-01},
  { 2.953561e-01,  6.869215e-01,  6.640056e-01, -5.979568e-01,  5.316783e-01,  2.436575e-01},
  { 2.974106e-01,  4.632877e-01,  8.348122e-01, -5.585979e-01,  4.518806e-01,  2.691646e-01},
  { 2.989553e-01,  4.680761e-01,  8.315831e-01, -6.340964e-01,  4.982247e-01,  2.834419e-01},
  { 2.248069e-01,  3.471067e-01,  9.104826e-01, -6.320120e-01,  4.333215e-01,  3.099555e-01},
  { 7.873043e-02,  5.145950e-01,  8.538111e-01, -5.290303e-01,  3.266008e-01,  3.499118e-01},
  { 2.503686e-02,  3.578986e-01,  9.334248e-01, -6.174398e-01,  3.602865e-01,  3.364364e-01},
  {-1.613081e-01,  3.420909e-01,  9.257178e-01, -6.094109e-01,  2.794250e-01,  3.655039e-01},
  {-7.225901e-02,  3.737113e-01,  9.247262e-01, -5.156422e-01,  2.336680e-01,  3.968270e-01},
  {-2.237180e-01,  2.994571e-01,  9.275105e-01, -6.224007e-01,  1.969771e-01,  3.901421e-01},
  {-1.127899e-01,  2.337431e-01,  9.657342e-01, -5.042860e-01,  1.489337e-01,  4.257343e-01},
  {-1.398451e-01,  4.139723e-02,  9.893077e-01, -4.961892e-01,  2.422031e-02,  4.495054e-01},
  {-2.150960e-01,  6.918379e-02,  9.741393e-01, -6.138114e-01,  9.792201e-02,  4.129752e-01},
  {-3.412175e-01, -1.712391e-01,  9.242552e-01, -6.019390e-01, -4.099448e-02,  4.176434e-01},
  {-1.745254e-01, -2.403176e-01,  9.548761e-01, -4.961370e-01, -1.008127e-01,  4.390562e-01},
  {-2.054782e-01, -5.047023e-01,  8.384833e-01, -4.925194e-01, -1.789980e-01,  4.062150e-01},
  {-4.272452e-01, -4.038784e-01,  8.089151e-01, -5.978609e-01, -1.238247e-01,  3.924483e-01},
  {-4.703695e-01, -6.185164e-01,  6.294363e-01, -5.975150e-01, -1.787101e-01,  3.545937e-01},
  {-2.381578e-01, -7.160165e-01,  6.562022e-01, -4.847385e-01, -2.329836e-01,  3.643546e-01},
  {-4.880460e-01, -7.206765e-01,  4.923784e-01, -5.940138e-01, -2.206428e-01,  2.989169e-01},
  {-2.367740e-01, -8.090936e-01,  5.378714e-01, -4.727289e-01, -2.703763e-01,  3.135819e-01},
  {-1.094201e-01, -1.746523e-01,  9.785315e-01,  2.355151e-01, -6.952879e-02,  3.338694e-01},
  {-7.390577e-02, -5.972581e-02,  9.954752e-01,  2.421598e-01, -1.152646e-01,  3.284768e-01},
  {-6.182588e-02,  9.462968e-01,  3.173326e-01,  1.874280e-01,  5.990712e-01,  4.841902e-02},
  {-8.835191e-02,  8.852635e-01,  4.566207e-01,  1.616566e-01,  5.854679e-01,  7.023136e-02},
  {-5.146950e-02,  8.171476e-01,  5.741261e-01,  1.914495e-01,  5.666209e-01,  1.040953e-01},
  {-4.851758e-02,  7.466840e-01,  6.634071e-01,  1.795344e-01,  5.327771e-01,  1.463997e-01},
  {-6.073456e-02,  6.273113e-01,  7.763967e-01,  1.839674e-01,  4.806632e-01,  1.963572e-01},
  {-1.193094e-02,  4.988491e-01,  8.666067e-01,  1.856337e-01,  3.895045e-01,  2.561743e-01},
  { 8.482002e-03,  3.471711e-01,  9.377635e-01,  2.084118e-01,  3.168461e-01,  2.940970e-01},
  { 8.362164e-03,  1.657799e-01,  9.861273e-01,  2.295220e-01,  1.290560e-01,  3.439985e-01},
  { 1.693080e-02, -1.506844e-01,  9.884369e-01,  2.485012e-01,  7.874154e-03,  3.555243e-01},
  {-2.339611e-01, -9.015757e-01,  3.639002e-01,  1.118485e-01, -2.813281e-01,  1.619320e-01},
  {-1.497019e-01, -6.996805e-01,  6.985961e-01,  9.596658e-02, -2.467997e-01,  1.936712e-01},
  {-2.302421e-01, -5.904297e-01,  7.735511e-01,  1.153424e-01, -2.141823e-01,  2.302726e-01},
  {-1.587166e-01, -2.838337e-01,  9.456466e-01,  1.484017e-01, -5.190635e-02,  3.116470e-01},
  {-1.810340e-01, -5.257804e-01,  8.311328e-01,  1.215961e-01, -1.742588e-01,  2.538963e-01},
  { 1.243201e-01,  9.166343e-01,  3.799026e-01, -6.327805e-01,  5.697871e-01,  1.986332e-01},
  { 8.998667e-02,  7.320759e-01,  6.752535e-01, -6.633890e-01,  5.397817e-01,  2.623797e-01},
  { 3.848654e-02,  4.140257e-01,  9.094512e-01, -6.892121e-01,  4.866324e-01,  3.016003e-01},
  {-3.345952e-02,  2.245000e-01,  9.738995e-01, -6.937449e-01,  4.070084e-01,  3.227009e-01},
  {-1.792774e-01,  2.304807e-01,  9.564195e-01, -7.057279e-01,  2.418592e-01,  3.498147e-01},
  {-2.063365e-01,  3.363360e-01,  9.188598e-01, -7.018129e-01,  1.947724e-01,  3.634371e-01},
  {-3.026725e-01, -3.776098e-01,  8.751001e-01, -7.093128e-01, -3.627155e-02,  3.630656e-01},
  {-3.873838e-01, -5.680222e-01,  7.261436e-01, -6.980227e-01, -1.050997e-01,  3.301477e-01},
  { 5.625715e-02,  9.635555e-01,  2.615262e-01, -6.969653e-01,  5.943702e-01,  1.244677e-01},
  {-1.089309e-02,  8.871206e-01,  4.614092e-01, -7.366512e-01,  5.650949e-01,  2.117204e-01},
  {-6.970320e-02,  6.283997e-01,  7.747614e-01, -7.559550e-01,  5.101213e-01,  2.795580e-01},
  {-4.774486e-02,  2.874409e-01,  9.566076e-01, -7.618898e-01,  4.392396e-01,  3.109155e-01},
  {-2.632004e-02,  1.509523e-01,  9.881906e-01, -7.696407e-01,  3.540096e-01,  3.228289e-01},
  {-1.562319e-02,  1.926047e-01,  9.811521e-01, -7.759742e-01,  2.767826e-01,  3.336648e-01},
  {-6.099986e-03,  2.444843e-01,  9.696341e-01, -7.678574e-01,  2.275412e-01,  3.460161e-01},
  {-1.574120e-01, -1.529319e-01,  9.756194e-01, -7.539558e-01,  4.345543e-02,  3.762315e-01},
  { 1.100142e-02, -5.037975e-01,  8.637518e-01, -7.753836e-01, -8.230793e-02,  3.206741e-01},
  {-1.081182e-02, -8.044729e-01,  5.938909e-01, -7.739086e-01, -1.225438e-01,  2.932873e-01},
  { 6.840751e-02,  9.479595e-01,  3.109552e-01, -8.271484e-01,  6.007950e-01,  1.302562e-01},
  { 2.593881e-03,  8.106160e-01,  5.855724e-01, -8.289559e-01,  5.590932e-01,  2.217967e-01},
  {-2.983255e-02,  5.211866e-01,  8.529212e-01, -8.361326e-01,  4.910384e-01,  2.883152e-01},
  { 1.913958e-02,  2.532528e-01,  9.672108e-01, -8.460968e-01,  4.092378e-01,  3.189985e-01},
  {-9.840265e-02,  1.452733e-01,  9.844859e-01, -7.969071e-01,  1.116266e-01,  3.818198e-01},
  { 1.510902e-02, -2.271308e-01,  9.737470e-01, -8.170927e-01,  2.278914e-02,  3.776337e-01},
  { 1.832690e-01, -4.029954e-01,  8.966645e-01, -8.332874e-01, -6.001810e-02,  3.477051e-01},
  { 4.425946e-01, -5.662701e-01,  6.953044e-01, -8.466393e-01, -1.606618e-01,  2.915104e-01},
  { 4.974923e-02,  9.403314e-01,  3.366035e-01, -9.647123e-01,  6.180441e-01,  1.164330e-01},
  { 2.537883e-02,  8.705665e-01,  4.913958e-01, -9.535400e-01,  5.926783e-01,  1.729620e-01},
  {-4.128229e-02,  6.847246e-01,  7.276317e-01, -9.513938e-01,  5.430525e-01,  2.421584e-01},
  {-9.567918e-02,  4.144912e-01,  9.050097e-01, -9.438477e-01,  4.622096e-01,  2.983790e-01},
  {-1.108508e-01,  2.244186e-01,  9.681675e-01, -9.250773e-01,  3.644206e-01,  3.321001e-01},
  {-2.085746e-02,  1.524950e-01,  9.880841e-01, -9.130838e-01,  3.012614e-01,  3.427982e-01},
  {-5.875036e-02,  1.341672e-01,  9.892156e-01, -8.971922e-01,  2.618480e-01,  3.483877e-01},
  {-6.273724e-02,  1.923899e-01,  9.793111e-01, -8.967822e-01,  2.011718e-01,  3.576224e-01},
  {-8.664324e-02,  1.916808e-01,  9.776254e-01, -8.709162e-01,  1.436141e-01,  3.732098e-01},
  {-1.414032e-01,  1.382474e-02,  9.898556e-01, -8.764665e-01,  8.480200e-02,  3.780529e-01},
  {-4.525398e-02, -1.886638e-01,  9.809985e-01, -8.768193e-01,  4.729454e-05,  3.705570e-01},
  { 1.938273e-01, -3.029365e-01,  9.330918e-01, -8.841770e-01, -1.033768e-01,  3.405266e-01},
  { 4.117319e-01, -4.043935e-01,  8.166656e-01, -9.204565e-01, -2.127495e-01,  3.213601e-01},
  {-9.119338e-03,  8.959764e-01,  4.440081e-01, -1.069468e+00,  6.377042e-01,  6.012885e-02},
  { 2.569356e-03,  9.506955e-01,  3.101152e-01, -1.048218e+00,  6.261802e-01,  9.945184e-02},
  {-1.144430e-01,  8.496810e-01,  5.147281e-01, -1.066384e+00,  6.047508e-01,  1.511860e-01},
  {-1.829683e-01,  7.101838e-01,  6.798247e-01, -1.052858e+00,  5.656949e-01,  2.108621e-01},
  {-2.526305e-01,  4.493312e-01,  8.569009e-01, -1.039327e+00,  5.073697e-01,  2.577430e-01},
  {-3.314371e-01,  2.372562e-01,  9.131588e-01, -1.018872e+00,  4.161417e-01,  2.994486e-01},
  {-3.305299e-01,  1.147273e-01,  9.367965e-01, -9.956926e-01,  3.239349e-01,  3.234521e-01},
  {-2.667041e-01,  1.204096e-01,  9.562272e-01, -9.761710e-01,  2.472368e-01,  3.357559e-01},
  {-2.201235e-01,  2.023424e-02,  9.752622e-01, -9.441084e-01,  5.661230e-02,  3.642640e-01},
  {-1.125665e-01, -1.310106e-01,  9.849696e-01, -9.396326e-01, -2.696124e-02,  3.614277e-01},
  {-3.885547e-02, -1.842004e-01,  9.821204e-01, -9.481331e-01, -1.255662e-01,  3.425599e-01},
  {-6.158937e-02, -1.875744e-01,  9.803175e-01, -9.781210e-01, -2.242138e-01,  3.219694e-01},
  {-4.648944e-01,  8.375860e-01,  2.869197e-01, -1.138468e+00,  6.192353e-01,  1.046588e-01},
  {-5.672107e-01,  5.557601e-01,  6.077852e-01, -1.185944e+00,  5.560811e-01,  1.347256e-01},
  {-4.102543e-01,  6.898810e-01,  5.964525e-01, -1.144617e+00,  5.900315e-01,  1.414321e-01},
  {-4.648374e-01,  5.538778e-01,  6.907573e-01, -1.131995e+00,  5.539586e-01,  1.828354e-01},
  {-5.893981e-01,  3.655631e-01,  7.203981e-01, -1.188037e+00,  5.138727e-01,  1.614387e-01},
  {-4.544034e-01,  4.061949e-01,  7.927946e-01, -1.107513e+00,  5.143974e-01,  2.270585e-01},
  {-5.986857e-01,  2.510061e-01,  7.606388e-01, -1.160833e+00,  4.798302e-01,  1.970704e-01},
  {-5.104450e-01,  1.936904e-01,  8.378125e-01, -1.102485e+00,  4.484660e-01,  2.476595e-01},
  {-6.597115e-01,  8.570467e-02,  7.466160e-01, -1.161795e+00,  4.080347e-01,  2.097161e-01},
  {-5.161932e-01,  1.298598e-01,  8.465701e-01, -1.090683e+00,  3.428883e-01,  2.714291e-01},
  {-6.644422e-01,  1.063820e-01,  7.397293e-01, -1.146992e+00,  3.195399e-01,  2.380562e-01},
  {-5.534232e-01,  9.934101e-02,  8.269547e-01, -1.123120e+00,  2.376913e-01,  2.670898e-01},
  {-4.356473e-01,  1.186070e-01,  8.922689e-01, -1.045464e+00,  1.831004e-01,  3.190539e-01},
  {-5.731912e-01,  5.337021e-02,  8.176817e-01, -1.101174e+00,  1.800062e-01,  2.892349e-01},
  {-5.689698e-01,  8.163864e-03,  8.223180e-01, -1.086215e+00,  1.208911e-01,  3.006182e-01},
  {-3.886375e-01,  7.105643e-02,  9.186468e-01, -1.020636e+00,  1.163171e-01,  3.357322e-01},
  {-3.434429e-01,  3.491379e-03,  9.391671e-01, -1.004553e+00,  2.574978e-02,  3.493161e-01},
  {-5.754911e-01, -2.212545e-02,  8.175087e-01, -1.065373e+00,  2.866150e-02,  3.152578e-01},
  {-6.289968e-01, -9.633341e-02,  7.714161e-01, -1.065420e+00, -6.548899e-02,  3.093639e-01},
  {-3.514870e-01, -9.131074e-02,  9.317292e-01, -1.009519e+00, -5.091090e-02,  3.442757e-01},
  {-3.967938e-01, -1.413761e-01,  9.069551e-01, -1.019665e+00, -1.468851e-01,  3.279877e-01},
  {-4.615456e-01, -6.262361e-02,  8.849034e-01, -1.037719e+00, -2.245261e-01,  3.082941e-01},
  {-8.536287e-01,  4.442727e-01,  2.719189e-01, -1.242131e+00,  5.584328e-01,  8.128356e-02},
  {-8.804737e-01,  1.650046e-01,  4.444543e-01, -1.231939e+00,  5.246375e-01,  1.193451e-01},
  {-8.622990e-01,  2.451503e-02,  5.058057e-01, -1.220147e+00,  4.487076e-01,  1.579655e-01},
  {-9.327139e-01, -1.203248e-01,  3.399513e-01, -1.209719e+00,  3.896581e-01,  1.556855e-01},
  {-8.873944e-01, -1.654080e-02,  4.607141e-01, -1.190738e+00,  3.207168e-01,  1.873679e-01},
  {-8.558300e-01, -4.579345e-02,  5.152260e-01, -1.171009e+00,  2.358883e-01,  2.214795e-01},
  {-8.116675e-01, -3.060813e-02,  5.833172e-01, -1.146201e+00,  1.599965e-01,  2.494121e-01},
  {-7.893776e-01, -9.076666e-02,  6.071610e-01, -1.129817e+00,  7.879864e-02,  2.606257e-01},
  {-8.115154e-01, -1.134098e-01,  5.732200e-01, -1.112241e+00, -5.115630e-03,  2.679543e-01},
  {-8.334329e-01, -8.917747e-02,  5.453778e-01, -1.099858e+00, -7.821963e-02,  2.739480e-01},
  {-8.276786e-01, -5.851359e-02,  5.581436e-01, -1.104902e+00, -1.378469e-01,  2.576946e-01},
  {-8.508443e-01,  1.028410e-01,  5.152550e-01, -1.116165e+00, -2.033970e-01,  2.520269e-01},
  {-9.880094e-01, -1.435942e-01, -5.672959e-02, -1.235179e+00,  4.928339e-01,  5.830377e-02},
  {-9.881181e-01, -1.534782e-01,  8.187980e-03, -1.225852e+00,  4.423514e-01,  8.218540e-02},
  {-9.881393e-01, -1.504359e-01,  3.081904e-02, -1.221519e+00,  4.104628e-01,  9.977450e-02},
  {-9.808971e-01, -1.871041e-01, -5.322499e-02, -1.216798e+00,  3.750446e-01,  8.705518e-02},
  {-9.872856e-01, -1.589565e-01,  5.973088e-05, -1.206590e+00,  3.155936e-01,  1.159030e-01},
  {-9.752846e-01, -1.092392e-01,  1.920595e-01, -1.192181e+00,  2.333373e-01,  1.484876e-01},
  {-9.515689e-01, -1.183296e-01,  2.837514e-01, -1.160007e+00,  8.985759e-02,  2.038101e-01},
  {-9.226612e-01, -1.825951e-01,  3.396400e-01, -1.143600e+00,  2.562261e-02,  2.169699e-01},
  { 9.972259e-02,  2.945737e-01,  9.504114e-01, -1.111842e+00, -6.559944e-01,  2.996397e-01},
  {-6.808659e-01,  6.309997e-02,  7.296848e-01, -1.123023e+00, -7.101974e-01,  3.107352e-01},
  { 5.905228e-01,  3.340860e-01,  7.346219e-01, -1.035201e+00, -6.856467e-01,  2.962074e-01},
  { 4.431430e-01,  2.857794e-01,  8.496791e-01, -1.054420e+00, -6.405297e-01,  2.871912e-01},
  { 9.820874e-01,  1.751447e-01, -6.948850e-02, -1.044273e+00, -6.405809e-01,  2.661719e-01},
  {-4.641453e-01, -1.003065e-01,  8.800612e-01, -1.122869e+00, -7.258524e-01,  3.069780e-01},
  {-5.019902e-01, -5.386906e-01,  6.766228e-01, -1.126914e+00, -7.517781e-01,  3.087293e-01},
  { 1.786592e-02, -3.551301e-01,  9.346461e-01, -1.106036e+00, -7.442688e-01,  3.048768e-01},
  {-5.548528e-01, -5.185420e-01,  6.505786e-01, -1.099587e+00, -7.569420e-01,  2.960591e-01},
  {-1.195875e-01,  4.502438e-01,  8.848612e-01, -1.051534e+00, -7.625369e-01,  3.288848e-01},
  {-7.682224e-02,  4.133876e-01,  9.073086e-01, -1.030931e+00, -7.931954e-01,  3.444845e-01},
  { 1.769954e-01,  5.728043e-01,  8.003548e-01, -1.017279e+00, -7.629777e-01,  3.287021e-01},
  { 4.220242e-01,  5.313770e-01,  7.345299e-01, -9.973472e-01, -7.860714e-01,  3.356596e-01},
  { 4.071209e-01,  6.559752e-01,  6.355700e-01, -9.665925e-01, -8.212131e-01,  3.493427e-01},
  { 1.053460e-02,  4.139841e-01,  9.102232e-01, -1.003953e+00, -8.291969e-01,  3.643435e-01},
  { 3.496319e-01, -5.736711e-01,  7.407151e-01, -9.652891e-01, -8.712917e-01,  3.792205e-01},
  { 4.814943e-01,  2.198357e-01,  8.484311e-01, -9.382994e-01, -8.594283e-01,  3.682462e-01},
  {-3.571838e-01, -5.982769e-01,  7.172757e-01, -1.034748e+00, -8.729193e-01,  3.708838e-01},
  {-3.667997e-01,  2.629338e-01,  8.923697e-01, -1.043720e+00, -8.347722e-01,  3.582935e-01},
  {-4.733088e-01,  2.471541e-01,  8.455138e-01, -1.064089e+00, -8.012583e-01,  3.377438e-01},
  { 6.244849e-01,  5.781724e-01,  5.251051e-01, -9.908772e-01, -7.566289e-01,  3.086618e-01},
  { 8.516160e-01,  4.951882e-01, -1.718690e-01, -9.814701e-01, -7.645892e-01,  2.838684e-01},
  { 8.377450e-01,  4.791372e-01, -2.619370e-01, -1.008008e+00, -7.228566e-01,  2.736324e-01},
  { 5.016064e-01,  4.651511e-01,  7.294008e-01, -1.014699e+00, -7.285249e-01,  2.998955e-01},
  {-8.818163e-01, -9.828283e-04,  4.715920e-01, -1.083402e+00, -8.170193e-01,  3.296200e-01},
  {-8.911647e-01, -4.550954e-02,  4.513915e-01, -1.086797e+00, -7.919379e-01,  3.129340e-01},
  {-7.789367e-01, -4.311081e-01,  4.554157e-01, -1.066938e+00, -8.537099e-01,  3.450087e-01},
  { 1.784238e-01,  4.008569e-01,  8.985982e-01, -1.048357e+00, -7.316799e-01,  3.046337e-01},
  { 7.416137e-02,  1.390719e-01,  9.875014e-01, -1.088519e+00, -6.995645e-01,  3.136456e-01},
  { 1.297446e-01,  2.357342e-01,  9.631177e-01, -1.093861e+00, -6.469346e-01,  2.878584e-01},
  {-8.453791e-01, -5.216975e-01, -1.147437e-01, -1.130729e+00, -7.562547e-01,  2.615975e-01},
  {-9.955256e-01,  5.133833e-02, -7.933012e-02, -1.127667e+00, -7.227467e-01,  2.720256e-01},
  {-4.695440e-01, -8.687782e-01, -1.573310e-01, -1.101223e+00, -7.673233e-01,  2.688984e-01},
  {-9.334486e-01, -2.977909e-01, -1.999863e-01, -1.093217e+00, -8.012366e-01,  2.773304e-01},
  {-2.361228e-01, -9.711900e-01, -3.218695e-02, -1.025566e+00, -8.730657e-01,  2.925738e-01},
  {-6.606037e-01, -7.443974e-01, -9.734013e-02, -1.058612e+00, -8.602260e-01,  2.827117e-01},
  {-9.162760e-01, -3.842497e-01, -1.130952e-01, -1.081531e+00, -8.271651e-01,  2.853090e-01},
  {-2.741138e-01, -2.136488e-01, -9.376652e-01, -1.072676e+00, -7.559207e-01,  2.397571e-01},
  {-5.789472e-01, -3.292421e-01, -7.459354e-01, -1.120812e+00, -7.510328e-01,  2.320704e-01},
  {-5.471192e-01, -9.306978e-02, -8.318645e-01, -1.063800e+00, -8.017625e-01,  2.289956e-01},
  {-6.755779e-01, -3.154737e-01, -6.663864e-01, -1.060282e+00, -8.393157e-01,  2.322381e-01},
  {-3.723795e-01, -6.867452e-01, -6.242712e-01, -1.041643e+00, -8.637163e-01,  2.286005e-01},
  { 4.541752e-02, -8.294764e-01, -5.566922e-01, -1.004073e+00, -8.709469e-01,  2.321531e-01},
  { 1.256306e-01, -9.914330e-01, -3.574334e-02, -9.788949e-01, -8.733706e-01,  2.982387e-01},
  { 4.129095e-01, -4.731903e-01, -7.782009e-01, -9.683887e-01, -8.698117e-01,  2.409320e-01},
  {-7.326765e-01,  5.148423e-02, -6.786269e-01, -1.114571e+00, -7.052156e-01,  2.415805e-01},
  {-9.864302e-01, -9.147070e-02, -1.363398e-01, -1.133271e+00, -6.630896e-01,  2.660884e-01},
  {-5.146409e-01, -3.769039e-02, -8.565770e-01, -1.118206e+00, -6.480203e-01,  2.422130e-01},
  {-5.679052e-03,  2.622625e-01,  9.649799e-01, -1.073255e+00, -7.383926e-01,  3.129220e-01},
  {-3.742974e-01, -4.971205e-02,  9.259752e-01, -1.086437e+00, -7.425101e-01,  3.106616e-01},
  { 7.033004e-01,  4.164068e-01, -5.761719e-01, -9.946339e-01, -7.595776e-01,  2.599469e-01},
  { 7.976052e-01,  5.958927e-01,  9.347539e-02, -9.677122e-01, -7.876877e-01,  2.846400e-01},
  { 8.703979e-01,  2.812221e-01,  4.041308e-01, -9.250917e-01, -8.468658e-01,  3.520606e-01},
  { 9.108177e-01, -4.021119e-01,  9.336575e-02, -9.088846e-01, -8.599014e-01,  3.198275e-01},
  { 7.458495e-01,  6.612656e-01,  8.022707e-02, -9.440483e-01, -8.199197e-01,  3.026679e-01},
  { 8.768880e-01, -2.007994e-01, -4.367459e-01, -9.278268e-01, -8.528923e-01,  2.595026e-01},
  { 6.711245e-01,  4.912536e-01, -5.552132e-01, -9.486002e-01, -8.147177e-01,  2.598265e-01},
  { 6.662956e-01,  4.639753e-01, -5.837611e-01, -9.798574e-01, -7.870175e-01,  2.609446e-01},
  {-9.138776e-02, -5.805456e-03, -9.957984e-01, -1.087265e+00, -7.041478e-01,  2.308016e-01},
  { 2.850900e-01,  9.329694e-02, -9.539494e-01, -1.043053e+00, -7.305950e-01,  2.370680e-01},
  { 4.791872e-01,  1.464123e-01, -8.654149e-01, -1.058975e+00, -6.856456e-01,  2.327349e-01},
  { 1.326917e-01,  9.274489e-02, -9.868087e-01, -1.077581e+00, -6.437083e-01,  2.324267e-01},
  { 3.004317e-01,  2.708054e-01, -9.145519e-01, -1.025541e+00, -7.786403e-01,  2.284708e-01},
  { 1.983441e-01,  8.868930e-02, -9.761116e-01, -1.009708e+00, -8.197023e-01,  2.255452e-01},
  { 3.467714e-01,  4.588152e-02,  9.368268e-01, -1.227343e+00, -4.890883e-02,  1.833908e-02},
  { 2.398971e-01,  8.164392e-02,  9.673591e-01, -1.233014e+00, -9.215728e-02,  2.410639e-02},
  { 5.558577e-01, -1.401951e-02,  8.311593e-01, -1.226336e+00, -1.715609e-01,  1.910549e-02},
  { 4.745654e-01, -1.504509e-01,  8.672671e-01, -1.250251e+00, -2.434987e-01,  2.698077e-02},
  { 7.316719e-01, -1.463224e-01,  6.657673e-01, -1.222178e+00, -2.197341e-01,  9.702941e-03},
  { 5.677597e-01, -2.987712e-01,  7.670624e-01, -1.260984e+00, -2.993475e-01,  1.457299e-02},
  { 9.647427e-01, -2.019572e-01, -1.687741e-01, -1.199995e+00, -2.685448e-01, -2.873845e-02},
  { 6.437505e-01, -7.012376e-01,  3.063512e-01, -1.284920e+00, -3.611048e-01,  4.849446e-03},
  { 1.978459e-01, -7.154362e-01, -6.700807e-01, -1.267875e+00, -3.711432e-01, -3.141594e-02},
  { 2.207221e-01,  4.235915e-03,  9.753276e-01, -1.282604e+00, -2.252785e-01,  3.796052e-02},
  { 1.919804e-01, -1.142025e-01,  9.747314e-01, -1.295040e+00, -2.879381e-01,  3.716860e-02},
  { 4.028757e-01, -3.314342e-01,  8.531368e-01, -1.318393e+00, -3.423037e-01,  3.226037e-02},
  { 9.141038e-02,  9.579035e-02,  9.911954e-01, -1.295782e+00, -1.448056e-01,  3.580876e-02},
  {-2.025377e-02,  1.399652e-02,  9.996969e-01, -1.308320e+00, -1.986561e-01,  4.066470e-02},
  { 3.456620e-01, -5.955572e-01,  7.251409e-01, -1.372254e+00, -4.086636e-01,  4.270773e-02},
  {-3.940836e-01,  2.284471e-01,  8.902304e-01, -1.286521e+00, -5.246086e-02,  2.144500e-02},
  {-4.720746e-02,  1.119663e-01,  9.925900e-01, -1.309075e+00, -1.059493e-01,  2.733665e-02},
  {-2.293668e-01,  1.543724e-01,  9.610204e-01, -1.323287e+00, -1.664705e-01,  3.753144e-02},
  {-2.438735e-01,  9.304877e-02,  9.653329e-01, -1.350703e+00, -2.175609e-01,  3.324701e-02},
  { 8.391384e-03,  7.937175e-02,  9.968098e-01, -1.365808e+00, -3.192457e-01,  4.163029e-02},
  { 1.078418e-01, -7.772336e-01,  6.199017e-01, -1.397092e+00, -3.995988e-01,  4.893144e-02},
  {-5.549367e-01,  2.517470e-01,  7.928863e-01, -1.339465e+00, -1.520107e-01,  2.649332e-02},
  {-6.053477e-01,  2.054231e-01,  7.689965e-01, -1.377783e+00, -2.173156e-01,  1.924524e-02},
  {-6.221426e-01,  2.822608e-01,  7.302517e-01, -1.378202e+00, -2.848306e-01,  3.071793e-02},
  {-6.119737e-01,  3.579893e-01,  7.052177e-01, -1.400389e+00, -3.593827e-01,  4.139293e-02},
  {-3.706063e-02, -2.067152e-01,  9.776990e-01, -1.426718e+00, -4.082833e-01,  5.313629e-02},
  {-9.262757e-01,  3.081535e-01,  2.169211e-01, -1.308311e+00, -3.202392e-02, -3.966953e-03},
  {-8.828210e-01,  3.911066e-01,  2.601203e-01, -1.346064e+00, -1.203570e-01,  4.495347e-03},
  {-9.451698e-01,  3.050200e-01,  1.166904e-01, -1.374976e+00, -2.061586e-01,  2.594142e-03},
  {-9.676859e-01,  2.353750e-01,  9.045681e-02, -1.407021e+00, -3.055264e-01,  1.567782e-02},
  {-9.263567e-01,  2.889821e-01,  2.415628e-01, -1.426670e+00, -3.759754e-01,  3.488332e-02},
  {-9.217681e-01,  2.770126e-01,  2.713072e-01, -1.437862e+00, -4.340791e-01,  5.223425e-02},
  {-6.878535e-01,  2.585065e-01, -6.782565e-01, -1.293485e+00, -2.477366e-02, -3.461141e-02},
  {-7.483909e-01,  3.150763e-01, -5.836421e-01, -1.328354e+00, -1.241793e-01, -3.856704e-02},
  {-7.998018e-01,  2.702330e-01, -5.359957e-01, -1.374658e+00, -1.988559e-01, -2.864566e-02},
  {-8.466136e-01,  1.050733e-01, -5.217327e-01, -1.384678e+00, -2.751276e-01, -4.009632e-02},
  {-1.174437e-01, -9.041388e-01, -4.107797e-01, -1.421702e+00, -4.210515e-01,  1.255646e-02},
  {-4.923530e-01,  2.243277e-01, -8.409908e-01, -1.311030e+00, -1.454974e-01, -5.988436e-02},
  {-5.296651e-01,  1.109301e-01, -8.409218e-01, -1.342065e+00, -2.368567e-01, -6.309010e-02},
  {-4.518346e-01, -7.771317e-02, -8.887104e-01, -1.367529e+00, -3.158136e-01, -5.060315e-02},
  {-6.199258e-01, -1.905645e-01, -7.611683e-01, -1.389860e+00, -3.664912e-01, -2.378396e-02},
  {-1.306405e-01, -8.980075e-01, -4.201375e-01, -1.411898e+00, -4.155063e-01,  6.889231e-03},
  { 2.162923e-01,  1.360689e-01, -9.668004e-01, -1.270411e+00, -5.012987e-02, -4.792162e-02},
  {-3.355973e-02,  1.298982e-01, -9.909592e-01, -1.292490e+00, -1.773724e-01, -7.962294e-02},
  {-1.882592e-01,  1.653903e-02, -9.819801e-01, -1.315513e+00, -2.580144e-01, -7.865096e-02},
  {-2.096860e-01, -2.712888e-01, -9.393798e-01, -1.335365e+00, -3.197434e-01, -6.227449e-02},
  {-1.740155e-01, -4.506449e-01, -8.755786e-01, -1.360187e+00, -3.708228e-01, -3.535305e-02},
  {-2.108962e-01, -8.486953e-01, -4.850146e-01, -1.403563e+00, -4.198604e-01,  6.903550e-03},
  { 4.192049e-01,  1.315412e-01, -8.983118e-01, -1.258963e+00, -1.862046e-01, -6.287479e-02},
  { 2.821530e-01, -1.543883e-01, -9.468653e-01, -1.265641e+00, -2.204105e-01, -7.429108e-02},
  { 2.097059e-01, -3.262999e-01, -9.217113e-01, -1.310633e+00, -2.986584e-01, -7.051641e-02},
  { 4.032089e-01, -5.032780e-01, -7.642865e-01, -1.312781e+00, -3.447472e-01, -4.618057e-02},
  { 4.221620e-01, -8.686748e-01, -2.591975e-01, -1.335760e+00, -4.035914e-01, -1.137852e-02},
  { 8.411325e-02, -9.944100e-01,  6.382664e-02, -1.368102e+00, -4.172071e-01,  4.767117e-03},
  {-8.567203e-01, -1.616837e-02,  5.155279e-01, -1.266604e+00,  1.620668e-01,  1.092071e-02},
  {-9.766633e-01,  6.080549e-02, -2.059889e-01, -1.270025e+00,  1.508660e-01, -6.326839e-04},
  {-8.787977e-01,  1.184341e-01,  4.622642e-01, -1.274860e+00,  7.738800e-02,  3.825404e-03},
  {-9.633954e-01,  2.065718e-01, -1.708727e-01, -1.279008e+00,  6.738733e-02, -9.514926e-03},
  {-8.760306e-01,  6.429551e-03,  4.822127e-01, -1.278026e+00,  3.924953e-01,  1.452878e-02},
  {-8.552697e-01,  2.204444e-01,  4.689541e-01, -1.267264e+00,  5.152721e-01,  1.569580e-02},
  {-7.124155e-01,  5.372995e-01,  4.514125e-01, -1.226873e+00,  6.017181e-01,  1.685524e-02},
  {-4.300095e-01,  7.777125e-01,  4.585358e-01, -1.168094e+00,  6.508273e-01,  1.811237e-02},
  {-1.013305e-01,  8.235425e-01,  5.581308e-01, -1.112669e+00,  6.653864e-01,  2.102792e-02},
  {-4.786724e-01,  3.153728e-02,  8.774270e-01, -1.261598e+00,  6.843854e-02,  1.417276e-02},
  {-5.441995e-01, -4.118318e-02,  8.379443e-01, -1.258133e+00,  1.641879e-01,  2.023626e-02},
  {-5.493924e-01,  3.393142e-03,  8.355575e-01, -1.268564e+00,  3.960546e-01,  2.542727e-02},
  {-5.348069e-01,  1.507673e-01,  8.314150e-01, -1.256617e+00,  5.166740e-01,  2.743561e-02},
  {-4.487059e-01,  3.572832e-01,  8.191530e-01, -1.216313e+00,  5.986776e-01,  2.945670e-02},
  {-3.103667e-01,  5.881541e-01,  7.468248e-01, -1.161180e+00,  6.424849e-01,  3.175796e-02},
  {-8.618528e-02,  7.546205e-01,  6.504768e-01, -1.105919e+00,  6.547127e-01,  3.512900e-02},
  { 1.122039e-01, -4.572836e-02,  9.926324e-01, -1.250338e+00,  6.823269e-02,  1.816582e-02},
  {-9.909774e-02, -4.093263e-02,  9.942355e-01, -1.246706e+00,  1.658521e-01,  2.393639e-02},
  {-2.816417e-02, -1.362842e-02,  9.995104e-01, -1.255915e+00,  3.971987e-01,  2.954789e-02},
  {-1.177193e-02, -6.110354e-04,  9.999305e-01, -1.243198e+00,  5.155703e-01,  3.186326e-02},
  {-5.214165e-02,  2.896167e-02,  9.982197e-01, -1.203822e+00,  5.927469e-01,  3.433019e-02},
  {-1.592850e-01,  4.747277e-01,  8.655992e-01, -1.153574e+00,  6.361282e-01,  3.918463e-02},
  { 4.259188e-01, -3.876384e-02,  9.039306e-01, -1.236602e+00,  1.772123e-01,  2.217405e-02},
  { 5.356568e-01, -3.131160e-02,  8.438551e-01, -1.243250e+00,  3.981874e-01,  2.574917e-02},
  { 5.340356e-01, -1.716903e-01,  8.278457e-01, -1.229861e+00,  5.142891e-01,  2.776131e-02},
  { 4.248052e-01, -3.905511e-01,  8.167070e-01, -1.191506e+00,  5.864292e-01,  3.001637e-02},
  { 8.615099e-01,  1.443070e-01,  4.868020e-01, -1.144615e+00,  6.218340e-01,  3.394309e-02},
  { 7.866982e-01,  3.490427e-02,  6.163501e-01, -1.220653e+00,  6.114554e-02,  5.045820e-03},
  { 7.682791e-01, -1.179154e-02,  6.400065e-01, -1.227840e+00,  1.677765e-01,  1.354906e-02},
  { 8.879125e-01, -4.527172e-02,  4.577793e-01, -1.233910e+00,  4.014836e-01,  1.501252e-02},
  { 8.698339e-01, -2.920983e-01,  3.975771e-01, -1.219763e+00,  5.154300e-01,  1.618307e-02},
  { 6.858588e-01, -6.442854e-01,  3.383695e-01, -1.182137e+00,  5.825353e-01,  1.750748e-02},
  { 7.423364e-01, -6.124706e-01,  2.716918e-01, -1.138055e+00,  6.113665e-01,  1.960925e-02},
  { 9.960358e-01,  3.884970e-02,  8.002101e-02, -1.223717e+00,  1.761928e-01, -1.575688e-04},
  { 9.547086e-01,  3.018853e-02, -2.960068e-01, -1.216102e+00,  6.698662e-02, -6.858668e-03},
  { 8.349397e-01,  5.470539e-02, -5.476158e-01, -1.226470e+00,  1.677440e-01, -1.421029e-02},
  { 5.971847e-01,  1.070271e-02, -8.020324e-01, -1.226025e+00,  7.254288e-02, -2.099446e-02},
  { 2.812563e-03,  8.495976e-02, -9.963804e-01, -1.251553e+00,  7.314219e-02, -3.150277e-02},
  { 1.327779e-01,  1.524212e-02, -9.910285e-01, -1.246950e+00,  1.649848e-01, -2.671084e-02},
  {-5.230014e-01,  1.693910e-01, -8.353300e-01, -1.267328e+00,  5.554761e-02, -3.003710e-02},
  {-5.958415e-01,  2.249864e-02, -8.027868e-01, -1.258599e+00,  1.631550e-01, -2.320716e-02},
  {-7.865154e-01,  2.143522e-01, -5.791776e-01, -1.274410e+00,  6.665936e-02, -2.066647e-02},
  { 9.857503e-01,  3.571509e-02,  1.643801e-01, -1.202890e+00, -9.547381e-02, -1.425334e-02},
  { 9.643725e-01, -2.333487e-01,  1.246357e-01, -7.461108e-01, -4.279945e-01,  1.208512e-01},
  {-9.298456e-01, -9.079793e-02,  3.565713e-01, -8.033988e-01, -4.366052e-01,  1.294848e-01},
  {-7.765166e-01, -6.386574e-02, -6.268519e-01, -7.966179e-01, -4.440688e-01,  1.126539e-01},
  {-1.123880e-01, -1.965536e-01, -9.740306e-01, -7.811729e-01, -4.386419e-01,  1.024516e-01},
  { 5.154467e-01, -2.193169e-01, -8.283809e-01, -7.599609e-01, -4.324433e-01,  1.071560e-01},
  { 6.895231e-01, -2.108134e-01,  6.929038e-01, -9.058250e-01, -4.334543e-01,  1.538300e-01},
  {-8.754591e-01, -6.924613e-02, -4.783058e-01, -9.474856e-01, -4.374834e-01,  1.286207e-01},
  {-1.304396e-01, -2.755674e-02, -9.910732e-01, -9.339497e-01, -4.454955e-01,  1.225433e-01},
  { 3.476563e-01, -1.702438e-01, -9.220369e-01, -9.144177e-01, -4.403666e-01,  1.260181e-01},
  { 4.811099e-01, -5.297394e-01, -6.985051e-01, -7.603072e-01, -4.620364e-01,  1.085580e-01},
  {-1.587906e-01, -5.310194e-01, -8.323484e-01, -7.824816e-01, -4.642287e-01,  1.015267e-01},
  {-5.787141e-01, -7.084758e-01, -4.039209e-01, -7.985551e-01, -4.678386e-01,  1.120265e-01},
  {-8.366427e-01, -5.323237e-01,  1.290755e-01, -8.041620e-01, -4.622421e-01,  1.278966e-01},
  {-3.950705e-01, -5.506941e-01,  7.352927e-01, -7.946049e-01, -4.608480e-01,  1.387751e-01},
  { 1.858855e-01, -3.156377e-01,  9.304942e-01, -7.757232e-01, -4.506609e-01,  1.487438e-01},
  { 6.281222e-01, -4.395705e-01,  6.420594e-01, -7.598971e-01, -4.495054e-01,  1.328553e-01},
  { 8.565038e-01, -5.160847e-01,  7.600874e-03, -7.482796e-01, -4.538428e-01,  1.194750e-01},
  { 8.005337e-01, -5.743690e-01, -1.710154e-01, -9.057090e-01, -4.659458e-01,  1.371018e-01},
  { 3.660718e-01, -5.650756e-01, -7.393788e-01, -9.166503e-01, -4.690972e-01,  1.251679e-01},
  {-1.818550e-01, -6.716557e-01, -7.181973e-01, -9.376528e-01, -4.681827e-01,  1.201147e-01},
  {-6.421111e-01, -4.650345e-01, -6.094558e-01, -9.510557e-01, -4.655548e-01,  1.282025e-01},
  {-8.548980e-01, -5.162995e-01,  5.083458e-02, -9.558083e-01, -4.634101e-01,  1.398949e-01},
  {-6.861261e-01, -3.853566e-01,  6.170343e-01, -9.540108e-01, -4.577814e-01,  1.515700e-01},
  {-3.792045e-02, -3.459795e-01,  9.374754e-01, -9.422388e-01, -4.517321e-01,  1.540575e-01},
  { 2.578434e-03, -2.815831e-01,  9.595334e-01, -9.251621e-01, -4.492770e-01,  1.559113e-01},
  { 3.505379e-01, -5.227020e-01,  7.771138e-01, -9.095954e-01, -4.591686e-01,  1.516443e-01},
  { 2.027696e-01, -9.416050e-01,  2.688207e-01, -7.778738e-01, -4.664181e-01,  1.239965e-01},
  {-4.894757e-02, -9.031923e-01,  4.264361e-01, -9.319757e-01, -4.692125e-01,  1.406177e-01},
  { 2.062466e-01, -7.509131e-02,  9.756145e-01,  1.142525e+00,  6.488522e-01,  1.689026e-01},
  { 3.987393e-01,  6.961264e-02,  9.144185e-01,  1.140864e+00,  6.605596e-01,  1.685238e-01},
  { 7.562524e-01,  5.765070e-02,  6.517352e-01,  1.155294e+00,  6.505772e-01,  1.613617e-01},
  { 3.963134e-01, -2.429919e-01,  8.853760e-01,  1.150209e+00,  6.461331e-01,  1.667538e-01},
  { 2.448657e-01, -2.516807e-01,  9.363213e-01,  1.142717e+00,  6.328816e-01,  1.602908e-01},
  { 3.491341e-01,  3.254708e-03,  9.370671e-01,  1.122447e+00,  6.411168e-01,  1.665947e-01},
  { 2.561336e-01, -8.924488e-02,  9.625129e-01,  1.114784e+00,  6.568431e-01,  1.724670e-01},
  { 7.516446e-02, -1.747261e-01,  9.817439e-01,  1.097209e+00,  6.388137e-01,  1.688220e-01},
  { 4.005516e-01, -1.310924e-02,  9.161804e-01,  1.124936e+00,  6.312995e-01,  1.701918e-01},
  { 5.409462e-01,  6.018369e-01,  5.875114e-01,  1.145384e+00,  6.857079e-01,  1.577345e-01},
  { 1.382325e-02,  2.523154e-01,  9.675463e-01,  1.119777e+00,  6.773560e-01,  1.756795e-01},
  { 8.134306e-01,  2.825357e-01,  5.084331e-01,  1.158673e+00,  6.749605e-01,  1.446282e-01},
  { 5.887586e-01, -2.066856e-01,  7.814373e-01,  1.146771e+00,  6.269740e-01,  1.569118e-01},
  { 7.454866e-01,  1.121974e-01,  6.570094e-01,  1.166099e+00,  6.409330e-01,  1.314706e-01},
  { 5.137576e-01,  5.336147e-01,  6.717950e-01,  1.140589e+00,  6.948109e-01,  1.466820e-01},
  { 7.294171e-01,  4.335687e-01,  5.291209e-01,  1.153387e+00,  6.862338e-01,  1.376478e-01},
  { 7.412380e-01,  1.461332e-01,  6.551422e-01,  1.168568e+00,  6.654711e-01,  1.324368e-01},
  { 2.432777e-01,  5.513650e-01,  7.980053e-01,  1.115127e+00,  6.960365e-01,  1.586239e-01},
  { 3.828291e-01,  4.492384e-01,  8.072340e-01,  1.130431e+00,  6.975220e-01,  1.486744e-01},
  { 1.756935e-01,  2.354267e-01,  9.558798e-01,  1.104796e+00,  6.792047e-01,  1.675826e-01},
  {-1.306199e-02,  1.902687e-01,  9.816452e-01,  1.094620e+00,  6.824018e-01,  1.746081e-01},
  { 5.474611e-01,  3.552541e-01,  7.576812e-01,  1.140615e+00,  7.109197e-01,  1.421304e-01},
  { 7.639995e-01,  2.525744e-01,  5.937263e-01,  1.174954e+00,  6.744595e-01,  1.238702e-01},
  { 8.238992e-01,  6.845274e-02,  5.625871e-01,  1.179545e+00,  6.476638e-01,  1.221330e-01},
  { 3.319941e-01, -1.885290e-01,  9.242493e-01,  1.129164e+00,  6.008583e-01,  1.603703e-01},
  { 9.238734e-01,  9.704249e-02,  3.701902e-01,  1.185736e+00,  6.599669e-01,  1.113964e-01},
  { 9.050685e-01,  6.816290e-02,  4.197675e-01,  1.182199e+00,  6.108599e-01,  1.136306e-01},
  { 4.337283e-02, -1.710610e-01,  9.843053e-01,  1.080745e+00,  6.112950e-01,  1.617623e-01},
  { 7.771440e-01,  4.983152e-01,  3.843556e-01,  1.168967e+00,  6.970387e-01,  1.160857e-01},
  { 8.599665e-01,  4.928572e-01,  1.324745e-01,  1.180785e+00,  6.771511e-01,  1.105239e-01},
  { 6.264105e-01,  6.893319e-01,  3.639111e-01,  1.144865e+00,  7.182620e-01,  1.288689e-01},
  { 3.162986e-01,  6.347045e-01,  7.050571e-01,  1.125643e+00,  7.212466e-01,  1.447769e-01},
  { 1.922954e-01,  4.493790e-01,  8.723996e-01,  1.110116e+00,  7.110366e-01,  1.570571e-01},
  {-5.157150e-01,  3.613306e-01,  7.768386e-01,  1.091819e+00,  6.853220e-01,  1.661961e-01},
  {-1.452082e-01, -1.129736e-01,  9.829301e-01,  1.092098e+00,  6.390547e-01,  1.711707e-01},
  {-1.381489e-01,  6.147566e-01,  7.765238e-01,  1.090599e+00,  7.160022e-01,  1.506248e-01},
  {-2.251154e-01,  2.656257e-01,  9.374251e-01,  1.071295e+00,  6.759422e-01,  1.630244e-01},
  { 2.548183e-01,  8.661914e-01,  4.298604e-01,  1.112977e+00,  7.335745e-01,  1.293278e-01},
  { 5.199804e-01,  8.510973e-01,  7.248282e-02,  1.131863e+00,  7.302271e-01,  1.056167e-01},
  { 7.267411e-01,  6.868448e-01, -9.573585e-03,  1.158773e+00,  7.107183e-01,  9.829868e-02},
  { 5.283583e-01,  8.489223e-01,  1.297901e-02,  1.114208e+00,  7.419174e-01,  6.360244e-02},
  { 3.627092e-01,  8.960127e-01,  2.561314e-01,  1.089990e+00,  7.521950e-01,  9.653003e-02},
  { 6.861855e-01,  7.248881e-01, -6.071851e-02,  1.155024e+00,  7.095219e-01,  6.077126e-02},
  { 7.394012e-01,  2.879632e-01,  6.085746e-01,  1.203399e+00,  5.929152e-01,  9.141982e-02},
  { 7.448541e-01,  1.088843e-01,  6.582831e-01,  1.188861e+00,  5.656362e-01,  1.189824e-01},
  { 3.967257e-01, -6.708231e-02,  9.154828e-01,  1.146074e+00,  5.276819e-01,  1.435144e-01},
  { 1.049020e-01, -4.869557e-02,  9.932896e-01,  1.045700e+00,  6.100843e-01,  1.586502e-01},
  { 4.248015e-02,  8.369000e-02,  9.955860e-01,  1.040996e+00,  6.348039e-01,  1.598488e-01},
  { 5.148586e-02,  6.451163e-01,  7.623478e-01,  1.064937e+00,  7.432057e-01,  1.251436e-01},
  { 8.656334e-01,  4.428011e-01,  2.336792e-01,  1.202666e+00,  6.555962e-01,  3.367123e-02},
  { 6.890076e-01,  4.660058e-01,  5.550740e-01,  1.222130e+00,  6.165512e-01,  5.396238e-02},
  { 5.269808e-01,  1.690490e-01,  8.328947e-01,  1.228620e+00,  5.289897e-01,  9.641825e-02},
  { 2.035774e-01,  7.071453e-02,  9.765018e-01,  1.050099e+00,  5.391656e-01,  1.657170e-01},
  { 5.460330e-01,  7.908307e-01,  2.764684e-01,  1.040296e+00,  7.802277e-01,  7.874987e-02},
  { 6.962590e-01,  1.986773e-01,  6.897469e-01,  1.017751e+00,  7.610070e-01,  1.221900e-01},
  { 3.664821e-01,  1.535464e-01,  9.176679e-01,  9.978631e-01,  7.286421e-01,  1.311266e-01},
  { 3.638533e-01,  3.824173e-03,  9.314485e-01,  1.141799e+00,  4.749709e-01,  1.426008e-01},
  { 6.708435e-01,  6.097763e-01,  4.220687e-01,  1.250949e+00,  6.090952e-01,  3.019457e-02},
  { 3.399180e-01,  3.633109e-01,  8.674451e-01,  1.263441e+00,  5.055057e-01,  8.846774e-02},
  { 3.451568e-01, -1.894512e-01,  9.192253e-01,  1.157294e+00,  4.418027e-01,  1.363110e-01},
  { 3.025507e-01, -4.829256e-02,  9.519091e-01,  1.095546e+00,  4.575698e-01,  1.588947e-01},
  { 2.144008e-01,  1.780145e-02,  9.765835e-01,  1.060929e+00,  4.784173e-01,  1.694312e-01},
  {-1.394595e-01,  1.830836e-01,  9.731554e-01,  9.874812e-01,  6.428183e-01,  1.600835e-01},
  { 4.486060e-01,  8.457077e-01,  2.890174e-01,  1.328529e+00,  5.455032e-01,  2.891226e-02},
  { 1.375355e-01,  4.534049e-01,  8.806294e-01,  1.296510e+00,  4.894573e-01,  8.582520e-02},
  { 1.060133e-01,  6.259301e-01,  7.726400e-01,  1.357241e+00,  4.925893e-01,  7.879459e-02},
  { 5.464285e-02,  3.131335e-01,  9.481359e-01,  1.350693e+00,  4.714120e-01,  8.936144e-02},
  {-3.962951e-02,  1.886011e-01,  9.812539e-01,  1.314296e+00,  4.445453e-01,  9.626253e-02},
  { 4.434139e-01,  7.530945e-01,  4.860379e-01,  1.404703e+00,  4.996697e-01,  4.814276e-02},
  { 4.234352e-01,  8.614659e-01,  2.803195e-01,  1.395741e+00,  5.108007e-01,  3.193795e-02},
  { 6.478925e-01,  7.278636e-01,  2.246106e-01,  1.413802e+00,  4.990332e-01,  3.458557e-02},
  { 8.349079e-01,  5.378231e-01,  1.169402e-01,  1.427301e+00,  4.854745e-01,  2.805121e-02},
  { 7.407129e-01,  4.567778e-01,  4.926445e-01,  1.419469e+00,  4.840516e-01,  4.739629e-02},
  { 4.281987e-01,  2.936732e-01,  8.546356e-01,  1.378839e+00,  4.901567e-01,  7.836156e-02},
  { 3.141744e-01, -1.042321e-01,  9.436261e-01,  1.396532e+00,  4.819232e-01,  7.199715e-02},
  { 3.716527e-01, -3.881348e-01,  8.433419e-01,  1.419520e+00,  4.604223e-01,  5.936882e-02},
  { 9.747871e-01,  3.848065e-02,  2.197941e-01,  1.437862e+00,  4.599793e-01,  2.955431e-02},
  { 8.580509e-01, -5.125831e-01, -3.173527e-02,  1.418795e+00,  4.139745e-01,  2.209530e-02},
  { 7.547051e-01, -6.063862e-01,  2.504315e-01,  1.412937e+00,  4.046484e-01,  4.286846e-02},
  { 6.466069e-01, -7.378569e-01,  1.935632e-01,  1.400666e+00,  3.925120e-01,  3.966656e-02},
  { 8.480151e-01, -4.571428e-01,  2.681248e-01,  1.421113e+00,  4.204243e-01,  4.730672e-02},
  { 5.993679e-01, -4.968483e-01,  6.276144e-01,  1.405115e+00,  4.155452e-01,  6.717637e-02},
  { 4.732997e-01, -2.597859e-01,  8.417236e-01,  1.379746e+00,  4.204285e-01,  8.611497e-02},
  { 5.485795e-01, -6.257126e-01,  5.545667e-01,  1.394629e+00,  3.991313e-01,  6.381723e-02},
  { 2.858421e-01, -6.538159e-01,  7.005848e-01,  1.368282e+00,  3.992527e-01,  8.152415e-02},
  { 3.749495e-01, -3.803677e-01,  8.454190e-01,  1.368009e+00,  4.128746e-01,  9.239388e-02},
  { 8.512669e-01,  1.406007e-01,  5.055451e-01,  1.427226e+00,  4.394253e-01,  5.151697e-02},
  { 6.763446e-01,  2.272508e-01,  7.006534e-01,  1.414198e+00,  4.285997e-01,  6.999288e-02},
  { 1.855984e-01, -6.598499e-01,  7.281150e-01,  1.347479e+00,  3.832550e-01,  6.266959e-02},
  { 6.839493e-01,  1.380639e-01,  7.163461e-01,  1.393747e+00,  4.350929e-01,  8.403210e-02},
  { 5.493653e-01,  2.697913e-01,  7.908289e-01,  1.375997e+00,  4.583236e-01,  8.894460e-02},
  { 5.135865e-01,  2.651155e-01,  8.160532e-01,  1.373619e+00,  4.731823e-01,  8.496223e-02},
  { 3.697018e-01,  2.667645e-01,  8.900322e-01,  1.409724e+00,  4.464475e-01,  4.535135e-02},
  { 5.017430e-01,  2.511070e-01,  8.277677e-01,  1.397029e+00,  4.494075e-01,  4.985111e-02},
  { 6.670966e-01, -1.920910e-01,  7.197800e-01,  1.384261e+00,  4.679404e-01,  5.782384e-02},
  { 4.873290e-01, -5.774000e-02,  8.713074e-01,  1.394515e+00,  4.572445e-01,  5.152550e-02},
  { 3.226731e-01, -5.810395e-01,  7.471781e-01,  1.321035e+00,  3.830754e-01,  6.715376e-02},
  { 1.935491e-01, -7.302082e-01,  6.552364e-01,  1.323987e+00,  3.951532e-01,  9.138668e-02},
  { 6.171068e-02, -5.265557e-01,  8.478979e-01,  1.309139e+00,  3.900653e-01,  8.924910e-02},
  { 2.106613e-01, -1.379255e-01,  9.677802e-01,  1.354258e+00,  4.215741e-01,  9.840362e-02},
  {-1.910845e-01, -1.583093e-02,  9.814460e-01,  1.326917e+00,  4.220466e-01,  1.019275e-01},
  { 9.664059e-03, -3.805577e-01,  9.247067e-01,  1.324177e+00,  4.057759e-01,  9.875980e-02},
  { 3.712665e-02, -7.948824e-01,  6.056266e-01,  1.294973e+00,  3.777047e-01,  7.881060e-02},
  { 1.983861e-01, -6.668508e-01,  7.182986e-01,  1.338814e+00,  3.698102e-01,  6.127836e-02},
  { 2.714579e-01, -6.646799e-01,  6.960683e-01,  1.313475e+00,  3.730158e-01,  6.795117e-02},
  { 3.895144e-01, -7.479726e-01,  5.374156e-01,  1.366467e+00,  3.735369e-01,  4.980194e-02},
  { 7.551203e-03, -9.067737e-01,  4.215498e-01,  1.297104e+00,  3.618293e-01,  5.163042e-02},
  { 2.468996e-01, -9.259682e-01,  2.856982e-01,  1.351560e+00,  3.586416e-01,  3.392483e-02},
  { 1.849666e-01, -3.725716e-01,  9.093832e-01,  1.223756e+00,  4.047985e-01,  1.052805e-01},
  { 5.487382e-01, -8.243918e-01,  1.387969e-01,  1.377191e+00,  3.660362e-01,  1.971701e-02},
  { 3.281304e-02, -9.858023e-01,  1.646727e-01,  1.320966e+00,  3.527676e-01,  1.865731e-02},
  { 2.210559e-01, -8.228971e-01,  5.234259e-01,  1.233749e+00,  3.585079e-01,  5.283714e-02},
  { 2.453562e-01, -9.223756e-01,  2.983684e-01,  1.205370e+00,  3.497573e-01,  6.012190e-02},
  { 2.486178e-01, -8.248057e-01,  5.078235e-01,  1.152433e+00,  3.425241e-01,  7.656500e-02},
  { 1.526115e-01, -8.950472e-01,  4.190469e-01,  1.083757e+00,  3.329437e-01,  9.179942e-02},
  { 2.621615e-01, -5.637275e-01,  7.832513e-01,  1.176155e+00,  3.862520e-01,  1.087461e-01},
  { 2.419085e-01, -3.693069e-01,  8.972695e-01,  1.096050e+00,  4.183395e-01,  1.506629e-01},
  { 2.209424e-01, -5.115474e-01,  8.303636e-01,  1.106833e+00,  3.875592e-01,  1.295419e-01},
  { 1.177010e-01, -2.449089e-01,  9.623752e-01,  1.045579e+00,  4.408285e-01,  1.698165e-01},
  { 7.472843e-02, -5.832621e-01,  8.088393e-01,  1.034840e+00,  4.017578e-01,  1.505429e-01},
  { 1.035615e-01, -8.385192e-01,  5.349398e-01,  9.831617e-01,  3.240809e-01,  7.804041e-02},
  {-1.036616e-01, -2.684898e-01,  9.576886e-01,  9.892396e-01,  4.396281e-01,  1.671073e-01},
  { 2.663475e-02, -5.832057e-02,  9.979425e-01,  1.011370e+00,  4.756802e-01,  1.758692e-01},
  {-1.738788e-01, -4.941894e-02,  9.835263e-01,  9.614071e-01,  5.062029e-01,  1.738101e-01},
  {-4.835615e-02,  5.007131e-02,  9.975744e-01,  9.845400e-01,  5.279734e-01,  1.774468e-01},
  {-2.329979e-02,  1.379177e-01,  9.901696e-01,  9.777234e-01,  5.817272e-01,  1.720409e-01},
  {-8.372560e-02,  2.502115e-01,  9.645643e-01,  9.744874e-01,  6.164444e-01,  1.656388e-01},
  {-2.437863e-01,  1.721980e-01,  9.544193e-01,  9.286850e-01,  6.053756e-01,  1.579856e-01},
  {-6.469688e-01,  2.294932e-01,  7.271619e-01,  9.088513e-01,  6.017088e-01,  1.452290e-01},
  { 5.545468e-01,  8.308612e-01,  4.634239e-02,  1.014756e+00,  8.102693e-01,  3.807698e-02},
  { 5.852137e-01,  7.920209e-01,  1.738614e-01,  1.006569e+00,  8.121611e-01,  6.919639e-02},
  { 3.627175e-01,  9.318738e-01,  6.869516e-03,  9.792493e-01,  8.288010e-01,  5.614338e-02},
  { 3.619890e-01,  9.284621e-01,  8.319972e-02,  9.825352e-01,  8.278844e-01,  7.376327e-02},
  {-5.140226e-02,  9.970789e-01,  5.649347e-02,  9.494364e-01,  8.329126e-01,  7.467330e-02},
  { 4.380438e-01,  8.968912e-01,  6.085886e-02,  9.775625e-01,  8.258377e-01,  9.393732e-02},
  {-8.243695e-02,  9.865081e-01, -1.414422e-01,  9.475099e-01,  8.337336e-01,  9.910172e-02},
  {-1.304433e-01,  9.730696e-01, -1.900526e-01,  9.480909e-01,  8.395973e-01,  1.347619e-01},
  { 4.592267e-01,  8.688775e-01, -1.848314e-01,  9.784745e-01,  8.320495e-01,  1.288016e-01},
  { 9.194937e-01,  3.833522e-01, -8.701930e-02,  9.993895e-01,  8.179644e-01,  1.404476e-01},
  { 7.518495e-01,  5.184803e-01, -4.073087e-01,  1.006038e+00,  8.251315e-01,  1.695070e-01},
  { 1.832273e-01,  8.479095e-01, -4.974709e-01,  9.852138e-01,  8.577049e-01,  1.970194e-01},
  { 1.327154e-01,  8.438158e-01, -5.199630e-01,  1.018502e+00,  8.595228e-01,  2.089592e-01},
  { 4.777873e-01,  2.861772e-01, -8.305553e-01,  1.031038e+00,  8.474746e-01,  2.052842e-01},
  { 3.254981e-02,  8.203809e-01, -5.708902e-01,  1.040531e+00,  8.647780e-01,  2.206565e-01},
  { 2.590275e-01,  2.184755e-01, -9.408364e-01,  1.050560e+00,  8.535697e-01,  2.169251e-01},
  { 7.511159e-01,  6.321800e-01,  1.901931e-01,  1.016557e+00,  7.887516e-01,  1.022051e-01},
  { 8.088619e-02,  3.526820e-01, -9.322407e-01,  1.068475e+00,  8.588685e-01,  2.201922e-01},
  { 7.191459e-02,  6.749796e-01, -7.343235e-01,  1.065595e+00,  8.693203e-01,  2.266151e-01},
  {-1.139650e-01,  9.628277e-01, -2.448975e-01,  1.061637e+00,  8.750958e-01,  2.370026e-01},
  { 2.058464e-02,  8.962062e-01, -4.431598e-01,  1.084428e+00,  8.761339e-01,  2.378589e-01},
  {-4.348990e-02,  3.832974e-01, -9.226006e-01,  1.121898e+00,  8.634636e-01,  2.185892e-01},
  { 9.519304e-01, -2.788635e-01, -1.267428e-01,  1.189513e+00,  8.806701e-01,  2.133208e-01},
  { 8.834211e-01, -3.887651e-01,  2.615895e-01,  1.009646e+00,  7.659991e-01,  1.468216e-01},
  { 7.621570e-01, -5.964257e-01,  2.517801e-01,  1.011785e+00,  7.820774e-01,  1.752710e-01},
  { 7.511746e-01, -6.482661e-01, -1.244501e-01,  1.018378e+00,  7.995782e-01,  2.070321e-01},
  { 6.166008e-01, -2.325569e-02,  7.869324e-01,  9.694054e-01,  7.431889e-01,  1.456034e-01},
  { 4.326523e-02, -8.722373e-01,  4.871657e-01,  9.933883e-01,  7.949197e-01,  2.155193e-01},
  { 5.163576e-01, -6.815106e-01, -5.185732e-01,  1.035877e+00,  8.128332e-01,  2.138267e-01},
  { 1.813504e-01, -8.809551e-01,  4.370700e-01,  1.014015e+00,  8.065968e-01,  2.323111e-01},
  { 1.994330e-01, -9.551787e-01,  2.187696e-01,  1.043222e+00,  8.153779e-01,  2.359084e-01},
  { 2.900088e-01, -8.216282e-01, -4.907363e-01,  1.074436e+00,  8.233449e-01,  2.246964e-01},
  { 2.981821e-01, -8.164369e-01, -4.944876e-01,  1.116110e+00,  8.314038e-01,  2.262892e-01},
  { 3.424362e-01, -9.328026e-01,  1.123254e-01,  1.124896e+00,  8.394417e-01,  2.373276e-01},
  {-7.312605e-02, -6.421184e-01,  7.631098e-01,  1.027368e+00,  8.235536e-01,  2.534685e-01},
  { 1.423658e-01, -7.415056e-01,  6.556687e-01,  1.070032e+00,  8.246713e-01,  2.589982e-01},
  { 3.318877e-01, -7.553499e-01,  5.650639e-01,  1.097874e+00,  8.341675e-01,  2.558675e-01},
  { 4.911599e-01, -7.415724e-01,  4.569818e-01,  1.130829e+00,  8.404521e-01,  2.459315e-01},
  {-3.594750e-01, -4.267876e-01,  8.298374e-01,  9.884143e-01,  8.171043e-01,  2.403467e-01},
  {-5.094660e-01, -4.231441e-01,  7.492619e-01,  9.600514e-01,  8.065885e-01,  2.253225e-01},
  {-5.617057e-01, -6.606196e-01,  4.980646e-01,  9.407746e-01,  7.849166e-01,  1.839375e-01},
  {-6.860586e-01, -5.410658e-01,  4.863859e-01,  9.444312e-01,  7.750801e-01,  1.671298e-01},
  {-3.262442e-01,  7.181382e-01,  6.146887e-01,  9.190621e-01,  7.634846e-01,  1.449632e-01},
  {-9.526582e-02, -2.319325e-01,  9.680557e-01,  1.050727e+00,  8.451731e-01,  2.651106e-01},
  {-2.464022e-01, -2.204142e-01,  9.437709e-01,  1.010746e+00,  8.410013e-01,  2.577387e-01},
  {-7.690464e-01, -7.365706e-02,  6.349349e-01,  9.546090e-01,  8.201235e-01,  2.164955e-01},
  {-8.678939e-01, -2.569458e-01,  4.251340e-01,  9.305741e-01,  8.029509e-01,  1.765307e-01},
  {-8.281221e-01, -1.982104e-01,  5.243341e-01,  9.215073e-01,  7.950826e-01,  1.527441e-01},
  {-7.850175e-01,  3.457341e-01,  5.140189e-01,  9.525334e-01,  8.466510e-01,  2.212740e-01},
  {-4.274620e-01,  4.161534e-01,  8.025538e-01,  9.821344e-01,  8.543271e-01,  2.490110e-01},
  {-1.096993e-01,  4.409482e-01,  8.908035e-01,  1.059728e+00,  8.665315e-01,  2.724426e-01},
  {-8.952110e-01,  1.639041e-01,  4.144062e-01,  9.326559e-01,  8.261068e-01,  1.839781e-01},
  {-8.832234e-01,  4.074143e-01,  2.322284e-01,  9.164069e-01,  8.196131e-01,  1.496348e-01},
  {-8.614537e-01,  3.008836e-01,  4.091046e-01,  9.035783e-01,  7.806610e-01,  1.160043e-01},
  {-6.869051e-01,  7.016293e-01,  1.894138e-01,  9.029067e-01,  8.106114e-01,  8.185630e-02},
  {-6.874623e-01,  5.584019e-01,  4.643090e-01,  8.975348e-01,  7.814944e-01,  9.470820e-02},
  { 1.948978e-01,  1.057352e-01,  9.751077e-01,  1.095032e+00,  8.641423e-01,  2.679914e-01},
  { 3.814321e-01,  1.709038e-01,  9.084610e-01,  1.125512e+00,  8.703255e-01,  2.579084e-01},
  {-4.494995e-01,  8.838047e-01,  1.297666e-01,  9.151513e-01,  8.267293e-01,  4.757727e-02},
  {-4.708582e-01,  8.787032e-01, -7.856992e-02,  9.237414e-01,  8.266920e-01,  1.095179e-01},
  {-2.099966e-01,  9.639021e-01,  1.636893e-01,  1.050785e+00,  8.736849e-01,  2.537237e-01},
  {-1.240001e-01,  9.917306e-01,  3.308206e-02,  1.013211e+00,  8.682367e-01,  2.410409e-01},
  {-2.283646e-01,  9.713812e-01,  6.533098e-02,  9.852178e-01,  8.674853e-01,  2.275883e-01},
  {-3.797533e-01,  9.231268e-01, -6.020251e-02,  9.629746e-01,  8.605297e-01,  2.075233e-01},
  {-6.997133e-01,  7.133715e-01,  3.875868e-02,  9.402047e-01,  8.425636e-01,  1.706672e-01},
  {-6.889362e-01,  7.155414e-01,  1.156172e-01,  8.976725e-01,  8.127171e-01,  5.734943e-02},
  {-5.837384e-01,  7.052453e-01,  4.023413e-01,  8.835688e-01,  7.850084e-01,  8.129119e-02},
  { 4.455482e-03,  9.382871e-01,  3.458287e-01,  1.090194e+00,  8.777968e-01,  2.589186e-01},
  { 6.463208e-02,  9.780017e-01,  1.983315e-01,  1.115606e+00,  8.792025e-01,  2.492043e-01},
  {-5.291294e-01,  7.992249e-01,  2.850647e-01,  8.403984e-01,  7.647521e-01,  5.834426e-02},
  {-5.347861e-01,  7.341862e-01,  4.182994e-01,  8.946742e-01,  7.704148e-01,  1.108547e-01},
  {-4.475199e-01,  7.846997e-01,  4.289200e-01,  9.049430e-01,  7.579288e-01,  1.412115e-01},
  {-4.596657e-01,  8.163311e-01,  3.497299e-01,  8.813246e-01,  7.499399e-01,  1.432888e-01},
  {-6.471279e-01,  6.465555e-01,  4.039696e-01,  8.611169e-01,  7.369934e-01,  1.351831e-01},
  {-7.908610e-01,  1.564909e-01,  5.916497e-01,  8.390496e-01,  7.105080e-01,  1.179474e-01},
  {-3.941110e-01,  8.595855e-01,  3.252527e-01,  8.950850e-01,  7.446096e-01,  1.721312e-01},
  {-6.719267e-01,  5.873501e-01,  4.511479e-01,  8.700941e-01,  7.297169e-01,  1.664560e-01},
  {-8.710303e-01,  4.601198e-02,  4.890696e-01,  8.580567e-01,  7.126279e-01,  1.661976e-01},
  {-5.516272e-01,  8.153903e-01,  1.756302e-01,  9.040875e-01,  7.407179e-01,  2.048932e-01},
  {-7.490399e-01,  4.899556e-01,  4.459626e-01,  8.861240e-01,  7.265314e-01,  1.951502e-01},
  {-8.696236e-01, -1.216454e-02,  4.935654e-01,  8.763720e-01,  7.050357e-01,  1.882106e-01},
  { 3.545327e-01,  8.651743e-01,  3.546546e-01,  9.463325e-01,  7.549634e-01,  1.616610e-01},
  { 4.115034e-01,  8.773850e-01,  2.466992e-01,  9.441847e-01,  7.486683e-01,  1.708281e-01},
  {-3.702783e-01,  9.122752e-01, -1.750655e-01,  9.329093e-01,  7.528266e-01,  2.161134e-01},
  { 2.300468e-01,  9.707001e-01, -6.942558e-02,  9.508366e-01,  7.470713e-01,  1.852407e-01},
  {-7.711034e-01,  6.342244e-01,  5.620361e-02,  9.102029e-01,  7.416866e-01,  2.303188e-01},
  {-6.061062e-01,  7.828469e-01, -1.406632e-01,  9.195689e-01,  7.520031e-01,  2.530298e-01},
  {-8.657628e-01,  4.225748e-01, -2.681141e-01,  9.163405e-01,  7.708067e-01,  3.421570e-01},
  {-9.394861e-01,  3.366697e-01, -6.339885e-02,  9.072422e-01,  7.383260e-01,  3.177156e-01},
  {-5.290383e-01,  8.107349e-01, -2.506541e-01,  9.390301e-01,  7.771705e-01,  2.789055e-01},
  { 3.902203e-01,  8.572176e-01, -3.360151e-01,  9.722478e-01,  7.726678e-01,  2.415367e-01},
  { 4.645608e-01,  8.846259e-01, -4.025480e-02,  9.610055e-01,  7.875831e-01,  2.904378e-01},
  {-3.859700e-01,  9.150540e-01, -1.170610e-01,  9.506138e-01,  7.912667e-01,  3.024915e-01},
  { 4.920588e-01,  8.340189e-01,  2.495808e-01,  9.346291e-01,  7.977132e-01,  3.419410e-01},
  {-9.977784e-01,  4.714416e-02, -4.707281e-02,  9.066795e-01,  7.441475e-01,  3.658516e-01},
  {-3.262233e-01,  8.428954e-01,  4.279084e-01,  9.136051e-01,  7.888280e-01,  3.802657e-01},
  {-6.230898e-01,  2.687098e-01,  7.345434e-01,  9.005416e-01,  7.654721e-01,  3.999527e-01},
  {-8.779966e-01,  4.785094e-01,  1.227853e-02,  9.036339e-01,  7.296759e-01,  2.750596e-01},
  {-9.099897e-01,  1.938764e-01,  3.665114e-01,  8.870652e-01,  7.055225e-01,  2.113691e-01},
  {-9.897674e-01,  9.329797e-02,  1.079626e-01,  8.954692e-01,  7.045867e-01,  2.453859e-01},
  {-9.967148e-01,  3.913917e-02,  7.090688e-02,  8.973652e-01,  7.049861e-01,  2.826663e-01},
  {-9.445071e-01, -2.852996e-01,  1.628201e-01,  9.042551e-01,  6.674772e-01,  2.985544e-01},
  {-9.778638e-01, -1.288733e-01,  1.648457e-01,  9.027056e-01,  6.981317e-01,  3.307194e-01},
  { 2.007774e-01, -2.824176e-01,  9.380451e-01,  9.105409e-01,  7.198897e-01,  3.995121e-01},
  {-6.723624e-01, -3.968491e-01,  6.248516e-01,  9.183046e-01,  6.796266e-01,  3.715858e-01},
  {-5.185394e-01, -6.739649e-01,  5.262016e-01,  9.295890e-01,  6.353493e-01,  3.373030e-01},
  { 6.491859e-01, -7.201843e-01,  2.447289e-01,  9.229082e-01,  6.242208e-01,  3.002714e-01},
  {-9.467824e-01, -3.187847e-01,  4.449042e-02,  9.018747e-01,  6.647043e-01,  2.588616e-01},
  {-6.283329e-01, -4.796477e-01,  6.124834e-01,  8.663334e-01,  6.638991e-01,  1.331486e-01},
  {-7.608002e-01, -5.279322e-01,  3.774530e-01,  8.834699e-01,  6.743057e-01,  1.750677e-01},
  {-4.630774e-01, -7.092032e-01,  5.315921e-01,  9.136039e-01,  6.409956e-01,  1.592715e-01},
  {-5.395844e-01, -2.457978e-01,  8.052529e-01,  9.041796e-01,  6.330598e-01,  1.294380e-01},
  {-8.932711e-01, -4.064288e-01,  1.920477e-01,  8.951757e-01,  6.721470e-01,  2.077616e-01},
  { 4.938194e-02, -9.891120e-01,  1.386321e-01,  9.290745e-01,  6.220775e-01,  2.525077e-01},
  { 8.351043e-01,  4.474041e-02,  5.482690e-01,  9.743701e-01,  7.136555e-01,  1.515189e-01},
  { 2.891692e-01,  1.077278e-01,  9.511971e-01,  9.717848e-01,  6.877950e-01,  1.485252e-01},
  { 8.551940e-01,  1.584305e-01,  4.935008e-01,  9.275466e-01,  7.762264e-01,  3.736842e-01},
  { 7.415047e-01,  1.134842e-01,  6.612808e-01,  9.157004e-01,  7.574784e-01,  3.959967e-01},
  { 8.944803e-01, -1.479940e-01,  4.219038e-01,  9.421114e-01,  7.801465e-01,  3.438134e-01},
  { 9.684100e-01,  2.356084e-01, -8.167461e-02,  9.633799e-01,  7.320670e-01,  1.869826e-01},
  { 9.473652e-01, -1.948591e-01,  2.540256e-01,  9.925955e-01,  7.286722e-01,  2.310222e-01},
  { 8.726352e-01, -2.385209e-01,  4.261639e-01,  9.852770e-01,  6.998388e-01,  2.209896e-01},
  { 9.286208e-01, -5.825830e-02,  3.664277e-01,  9.895008e-01,  7.535921e-01,  2.538426e-01},
  { 8.534518e-01, -1.442264e-01,  5.008180e-01,  9.562203e-01,  7.738265e-01,  3.147237e-01},
  { 7.108214e-01, -5.995517e-01,  3.677915e-01,  9.478422e-01,  7.697358e-01,  3.145708e-01},
  { 7.240751e-01, -5.842963e-01,  3.664877e-01,  9.460133e-01,  7.492653e-01,  2.861253e-01},
  { 8.221035e-01, -2.470372e-01,  5.129508e-01,  9.642497e-01,  6.650553e-01,  1.479591e-01},
  { 6.850993e-02, -5.494391e-01,  8.327202e-01,  9.622874e-01,  7.030286e-01,  2.235597e-01},
  { 4.644589e-01, -7.017667e-01,  5.401866e-01,  9.490367e-01,  7.343106e-01,  2.623393e-01},
  { 5.995353e-01, -6.778049e-01,  4.256028e-01,  9.421017e-01,  7.166566e-01,  2.360933e-01},
  { 6.366869e-01, -1.996056e-01,  7.448406e-01,  9.298669e-01,  6.948379e-01,  2.201878e-01},
  { 9.578774e-01, -2.702812e-01,  9.705132e-02,  9.323295e-01,  7.135596e-01,  2.701667e-01},
  { 9.876237e-01, -1.466342e-01, -5.565817e-02,  9.268368e-01,  6.885330e-01,  2.550085e-01},
  { 9.724486e-01, -1.533810e-01,  1.755504e-01,  9.243886e-01,  7.059997e-01,  3.254937e-01},
  { 9.772166e-01,  1.855591e-02,  2.114319e-01,  9.315338e-01,  6.576875e-01,  2.542013e-01},
  { 1.086052e-01, -1.032854e-01,  9.887047e-01,  9.516651e-01,  6.447949e-01,  1.471360e-01},
  { 2.666543e-01, -3.303072e-01,  9.054241e-01,  9.651424e-01,  6.868330e-01,  2.166996e-01},
  { 5.960822e-01, -5.641723e-01,  5.713103e-01,  9.854229e-01,  6.891487e-01,  2.144558e-01},
  { 6.680854e-01, -6.602924e-01,  3.430392e-01,  9.552127e-01,  6.738313e-01,  2.127459e-01},
  {-2.042247e-01, -8.026332e-01, -5.604216e-01, -1.042044e+00, -3.636294e-01,  1.805386e-01},
};

static GLushort cow_indices[][3] =
{
  {   3,    1,    0},
  {   8,    2,    0},
  {   0,    2,    3},
  {   4,    1,    3},
  {   5,    4,    3},
  {   4,    5,    6},
  {   6,    5,    7},
  {   9,    7,    5},
  {   8,    7,    9},
  {   5,    3,    9},
  {   2,    9,    3},
  {   9,    2,    8},
  {   8,   18,   10},
  {  10,    7,    8},
  {   7,   10,   11},
  {  12,   11,   10},
  {  12,   10,   18},
  {   7,   11,   13},
  {  14,    7,   13},
  {  14,   15,    7},
  {   7,   15,   16},
  {   7,   16,    6},
  {   4,    6,   17},
  {  12,   18,   19},
  {  20,   11,   19},
  {  12,   19,   11},
  {  20,   21,   11},
  {  21,   13,   11},
  {  21,   22,   14},
  {  22,   23,   14},
  {  15,   14,   23},
  {  23,   24,   15},
  {  15,   24,   16},
  {   6,   16,   25},
  {  25,   16,   24},
  {  17,    6,   26},
  {  25,   26,    6},
  {  18,   27,   19},
  {  20,   19,   28},
  {  28,   19,   27},
  {  28,   29,   20},
  {  20,   29,   21},
  {  21,   29,   22},
  {  29,   30,   22},
  {  23,   22,   31},
  {  30,   31,   22},
  {  32,   24,   31},
  {  23,   31,   24},
  {  24,   32,   25},
  {  32,   26,   25},
  {  33,   34,   35},
  {  36,    8,   33},
  {   8,   36,   18},
  {  37,   18,   36},
  {  18,   37,   27},
  {  37,  998,   27},
  {  38,  998,   37},
  {  33,   38,   36},
  {  36,   38,   37},
  {  39,   41,   40},
  {  41,   39,   42},
  {  43,   40,   44},
  {  41,   45,   40},
  {  40,   45,   44},
  {  45,   41,   46},
  {  42,   52,   41},
  {  46,   41,   52},
  {  52,   42,   47},
  {  48,   43,   49},
  {  44,   49,   43},
  {  49,   44,   50},
  {  45,   50,   44},
  {  51,   50,   46},
  {  50,   45,   46},
  {  46,   52,   51},
  {  54,   51,   52},
  {  52,   47,   53},
  {  53,   54,   52},
  {  55,   53,   56},
  {  53,   47,   56},
  {  55,   56,   59},
  {  59,   56,   57},
  {  57,   58,   59},
  {  58,   60,   59},
  {  58,   57,   61},
  {  61,   57,   62},
  {  57,   63,   62},
  {  62,   63,   64},
  {  64,   63,   65},
  {  65,   63,   66},
  {  63,   67,   66},
  {  68,   66,   69},
  {  67,   69,   66},
  {  68,   65,   66},
  {  65,   68,   64},
  {  60,   62,   68},
  {  68,   62,   64},
  {  60,   58,   61},
  {  55,   59,   70},
  {  70,   71,   55},
  {  55,   71,   53},
  {  53,   71,   72},
  {  72,   71,   73},
  {  70,   73,   71},
  {  73,   59,   74},
  {  75,   74,   68},
  {  60,   68,   74},
  {  68,   69,   75},
  {  75,   69,   76},
  {  77,   78,   69},
  {  76,   69,   78},
  {  78,   79,   76},
  {  80,   76,   79},
  {  76,   80,   75},
  {  81,   75,   80},
  {  75,   81,   74},
  {  74,   81,   82},
  {  82,   83,   74},
  {  73,   74,   83},
  {  83,   84,   73},
  {  72,   54,   53},
  {  85,   48,   96},
  {  49,   96,   48},
  {  96,   49,   86},
  {  50,   86,   49},
  {  86,   50,   87},
  {  87,   50,   51},
  {  51,   54,   87},
  {  72,   87,   54},
  {  72,   73,   88},
  {  89,   88,   73},
  {  72,   88,   87},
  {  88,   90,   87},
  {  86,   87,   91},
  {  90,   91,   87},
  {  86,   91,   92},
  {  93,   92,   91},
  {  86,   92,   94},
  {  95,   94,   92},
  {  86,   94,   96},
  {  85,   96,   97},
  {  85,   97,   98},
  {  98,   97,   99},
  { 103,  100,  101},
  { 102,  101,  100},
  { 104,  103,  101},
  { 107,  103,  105},
  { 104,  105,  103},
  { 107,  105,   92},
  {  95,   92,  105},
  { 107,   92,  106},
  {  93,  106,   92},
  { 108,  107,  106},
  {  84,  107,  109},
  { 108,  109,  107},
  {  84,  109,   73},
  {  89,   73,  109},
  {  62,   60,   61},
  { 111,  964,  110},
  { 112,  113,  110},
  { 111,  110,  113},
  { 113,  112,  114},
  { 115,  114,  112},
  { 114,  115,  116},
  { 117,  116,  115},
  { 116,  117,  118},
  { 119,  118,  117},
  { 118,  119,  120},
  { 120,  119,  121},
  { 121,  122,  120},
  { 122,  123,  120},
  { 131,  123,  124},
  { 122,  124,  123},
  { 131,  124,  560},
  { 560,  125,  559},
  { 125,  560, 1076},
  {1076,  560,  124},
  { 122,  121,  126},
  { 127,  126,  121},
  { 119,  127,  121},
  { 127,  119,  128},
  { 117,  128,  119},
  { 129,  128,  115},
  { 117,  115,  128},
  { 115,  112,  129},
  { 130,  129,  110},
  { 112,  110,  129},
  { 103,  130,  100},
  { 100,  130,  110},
  { 126, 1076,  122},
  {1076,  124,  122},
  { 123,  131,  132},
  { 120,  123,  133},
  { 123,  132,  133},
  { 134,  118,  133},
  { 120,  133,  118},
  { 135,  116,  134},
  { 118,  134,  116},
  { 116,  135,  114},
  { 135,  136,  114},
  { 114,  136,  113},
  { 137,  138,  139},
  { 131,  137,  132},
  { 137,  139,  132},
  { 133,  132,  139},
  { 141,  134,  139},
  { 133,  139,  134},
  { 140,  135,  141},
  { 134,  141,  135},
  { 135,  140,  136},
  { 559,  125,  142},
  { 142,  125,  143},
  { 139,  138,  141},
  { 144,  145,  146},
  { 146,  145,  147},
  { 148,  172,  149},
  { 150,  149,  172},
  { 148,  149,  168},
  { 168,  149,  151},
  { 144,  146,  152},
  { 152,  153,  154},
  { 154,  153,  155},
  { 156,  157,  158},
  { 159,  158,  160},
  { 157,  160,  158},
  { 160,  161,  159},
  { 161,  162,  159},
  { 162,  163,  159},
  { 159,  163,  164},
  { 159,  164,  158},
  { 165,  158,  164},
  { 158,  165,  156},
  { 165,  193,  156},
  { 157,  166,  160},
  { 167,  166,  168},
  { 169,  168,  166},
  { 193,  165,  155},
  { 164,  170,  165},
  { 165,  170,  155},
  { 164,  163,  170},
  { 171,  166,  157},
  { 148,  168,  169},
  { 150,  172,  173},
  { 173,  172,  147},
  { 146,  147,  172},
  { 174,  175,  154},
  { 152,  154,  175},
  { 174,  154,  176},
  { 176,  154,  155},
  { 176,  155,  177},
  { 163,  178,  170},
  { 179,  170,  178},
  { 177,  155,  180},
  { 179,  180,  170},
  { 155,  170,  180},
  { 181,  182,  176},
  { 174,  176,  182},
  { 183,  181,  177},
  { 176,  177,  181},
  { 184,  183,  180},
  { 180,  183,  177},
  { 180,  179,  184},
  { 179,  185,  184},
  { 179,  178,  185},
  { 186,  185,  178},
  { 178,  187,  186},
  { 188,  186,  187},
  { 189,  175,  182},
  { 182,  175,  174},
  { 175,  189,  190},
  { 191,  190,  189},
  { 169,  171,  148},
  { 148,  171,  172},
  { 192,  171,  156},
  { 156,  171,  157},
  { 171,  192,  172},
  { 172,  192,  146},
  { 193,  146,  192},
  { 156,  193,  192},
  { 153,  193,  155},
  { 146,  193,  152},
  { 152,  193,  153},
  { 152,  175,  144},
  { 167,  168,  194},
  { 200,  166,  167},
  { 160,  195,  161},
  { 196,  195,  197},
  { 160,  197,  195},
  { 200,  197,  166},
  { 197,  160,  166},
  { 196,  197,  198},
  { 199,  198,  197},
  { 197,  200,  199},
  { 194,  200,  167},
  { 182,  181,  201},
  { 182,  201,  189},
  { 181,  202,  201},
  { 203,  201,  202},
  { 202,  168,  203},
  { 201,  203,  204},
  { 204,  203,  205},
  { 205,  203,  168},
  { 183,  206,  181},
  { 202,  181,  206},
  { 206,  194,  202},
  { 168,  202,  194},
  { 184,  207,  183},
  { 206,  183,  207},
  { 207,  200,  206},
  { 194,  206,  200},
  { 204,  191,  201},
  { 189,  201,  191},
  { 207,  184,  185},
  { 186,  207,  185},
  { 200,  207,  199},
  { 186,  188,  207},
  { 207,  188,  199},
  { 199,  188,  198},
  { 196,  198,  187},
  { 187,  198,  188},
  { 162,  187,  163},
  { 178,  163,  187},
  { 209,   48,   85},
  {  48,  209,  208},
  { 210,  212,  209},
  { 208,  209,  212},
  { 211,  212,  210},
  { 213,  212,  211},
  { 113,  214,  215},
  { 216,  215,  214},
  { 113,  136,  214},
  { 136,  217,  214},
  { 218,  219,  220},
  { 221,  218,  222},
  { 220,  222,  218},
  { 222,  211,  221},
  { 210,  221,  211},
  { 213,  211,  222},
  { 223,  220,  219},
  { 223,  224,  220},
  { 225,  222,  224},
  { 220,  224,  222},
  { 222,  225,  213},
  { 216,  213,  225},
  { 219,  218,  567},
  { 226,  567,  218},
  { 227,  226,  221},
  { 218,  221,  226},
  { 209,  227,  210},
  { 210,  227,  221},
  { 209,  228,  227},
  { 227,  228,  229},
  { 227,  229,  226},
  { 229,  230,  226},
  { 226,  230,  567},
  { 236,  567,  230},
  { 228,  231,  229},
  { 230,  229,  232},
  { 232,  229,  233},
  { 231,  234,  229},
  { 234,  233,  229},
  { 233,  234,  235},
  { 235,  232,  233},
  { 241,  236,  232},
  { 237,  111,  215},
  { 113,  215,  111},
  { 111,  237,  964},
  { 234,  964,  237},
  { 235,  234,  238},
  { 238,  234,  237},
  { 238,  239,  235},
  { 235,  239,  232},
  { 239,  241,  232},
  { 215,  240,  237},
  { 238,  237,  240},
  { 241,  239,  240},
  { 238,  240,  239},
  { 241,  240,  224},
  { 224,  240,  225},
  { 215,  216,  240},
  { 216,  225,  240},
  { 213,  216,  214},
  { 242,  243,  266},
  { 266,  243,  244},
  { 245,  242,  266},
  { 245,  246,  242},
  { 247,  248,  246},
  { 249,  147,  250},
  { 145,  250,  147},
  { 250,  251,  249},
  { 285,  254,  253},
  { 256,  251,  255},
  { 250,  255,  251},
  { 251,  256,  252},
  { 252,  256,  253},
  { 257,  285,  253},
  { 261,  256,  258},
  { 255,  258,  256},
  { 253,  256,  259},
  { 261,  259,  256},
  { 260,  257,  259},
  { 257,  253,  259},
  { 269,  259,  271},
  { 271,  259,  261},
  { 259,  269,  260},
  { 262,  260,  269},
  { 151,  149,  243},
  { 243,  149,  244},
  { 150,  249,  149},
  { 149,  249,  244},
  { 247,  246,  263},
  { 264,  263,  246},
  { 265,  264,  245},
  { 245,  264,  246},
  { 244,  249,  266},
  { 245,  266,  265},
  { 147,  249,  173},
  { 173,  249,  150},
  { 267,  264,  254},
  { 254,  264,  253},
  { 252,  253,  268},
  { 264,  268,  253},
  { 266,  251,  268},
  { 252,  268,  251},
  { 251,  266,  249},
  { 267,  263,  264},
  { 268,  264,  265},
  { 265,  266,  268},
  { 171,  169,  166},
  { 187,  162,  196},
  { 196,  162,  195},
  { 161,  195,  162},
  { 191,  204,  258},
  { 270,  262,  269},
  { 190,  191,  255},
  { 255,  191,  258},
  { 205,  168,  151},
  { 271,  204,  272},
  { 205,  272,  204},
  { 275,  271,  272},
  { 258,  204,  271},
  { 261,  258,  271},
  { 272,  205,  243},
  { 151,  243,  205},
  { 273,  274,  269},
  { 270,  269,  274},
  { 269,  271,  273},
  { 273,  271,  275},
  { 248,  274,  246},
  { 274,  273,  246},
  { 242,  246,  275},
  { 273,  275,  246},
  { 275,  272,  242},
  { 242,  272,  243},
  { 289,    4,  277},
  { 276,  289,  277},
  { 278,  276,  279},
  { 279,  276,  277},
  { 279,  280,  278},
  { 281,  278,  280},
  { 282,  283,  280},
  { 280,  283,  281},
  { 283,  282,  284},
  { 285,  284,  282},
  { 285,  286,  284},
  { 284,  286,  287},
  { 286,  288,  287},
  { 278,  290,  276},
  { 289,  276,  290},
  { 281,  291,  278},
  { 278,  291,  290},
  { 283,  292,  281},
  { 291,  281,  292},
  { 283,  284,  292},
  { 292,  284,  459},
  { 459,  284,  287},
  { 248,   17,  274},
  {  17,   26,  274},
  { 254,  282,  267},
  { 280,  267,  282},
  { 263,  267,  279},
  { 280,  279,  267},
  { 263,  279,  247},
  { 277,  247,  279},
  { 248,  247,  277},
  { 248,  277,   17},
  {   4,   17,  277},
  { 293,    1,  289},
  {   4,  289,    1},
  { 294,  291,  295},
  { 292,  295,  291},
  { 291,  294,  290},
  { 296,  290,  294},
  { 289,  290,  297},
  { 296,  297,  290},
  { 297,  293,  289},
  { 288,  286,  260},
  { 260,  286,  257},
  { 459,  298,  292},
  { 298,  299,  292},
  { 254,  285,  282},
  { 286,  285,  257},
  { 295,  292,  300},
  { 300,  292,  299},
  { 351,  301,  302},
  { 303,  302,  301},
  { 303,  305,  302},
  { 304,  302,  305},
  { 304,  305,  307},
  { 305,  306,  307},
  { 306,  308,  307},
  { 307,  308,  309},
  { 308,  311,  309},
  { 311,  310,  309},
  { 312,  310,  313},
  { 313,  310,  311},
  { 314,  312,  313},
  { 322,  315,  316},
  {1259,  316,  315},
  { 313,  318,  317},
  { 319,  306,  815},
  { 815,  306,  817},
  { 935,  306,  321},
  { 935,  321,  320},
  { 322,  320,  321},
  { 321,  315,  322},
  {  38,  323,  998},
  { 324,  351,  325},
  { 326,  324,  325},
  { 337,  326,  328},
  { 325,  328,  326},
  { 329,  332,  327},
  { 327,  332,  328},
  { 333,  332,  329},
  { 334,  333,  329},
  { 330,  334,  329},
  {  33,  330,  329},
  {  38,   33,  323},
  { 323,   33,  329},
  {1259,  315,  301},
  { 314,  323,  312},
  { 325,  351,  302},
  { 302,  304,  325},
  { 328,  325,  307},
  { 304,  307,  325},
  { 328,  307,  327},
  { 307,  309,  327},
  { 327,  309,  329},
  { 309,  310,  329},
  { 323,  329,  312},
  { 310,  312,  329},
  { 319,  318,  311},
  { 313,  311,  318},
  { 311,  308,  319},
  { 308,  306,  319},
  { 321,  306,  305},
  { 305,  303,  321},
  { 303,  315,  321},
  { 301,  315,  303},
  {  33,   35,  330},
  { 328,  332,  331},
  {  35,   34,  335},
  { 334,  330,  335},
  { 335,  330,   35},
  {   0,  338,    8},
  { 339,  338,  340},
  { 340,  341,  339},
  { 335,  339,  341},
  { 335,  341,  342},
  { 342,  341,  343},
  { 343,  344,  342},
  { 342,  344,  345},
  { 346,  347,  344},
  { 347,  345,  344},
  { 347,  346,  348},
  { 346,  349,  348},
  { 348,  349,  336},
  {  34,    8,  339},
  { 338,  339,    8},
  { 331,  348,  336},
  { 332,  347,  331},
  { 348,  331,  347},
  { 345,  347,  333},
  { 347,  332,  333},
  { 345,  333,  342},
  { 334,  342,  333},
  { 334,  335,  342},
  { 339,  335,   34},
  { 331,  336,  328},
  { 324,  350,  351},
  { 350,  324,  354},
  { 326,  354,  324},
  { 356,  354,  326},
  { 326,  337,  356},
  { 328,  336,  337},
  {   0,  353,  352},
  { 355,  350,  354},
  { 356,  337,  357},
  { 336,  357,  337},
  { 349,  358,  336},
  { 357,  336,  358},
  { 346,  359,  349},
  { 358,  349,  359},
  { 344,  360,  346},
  { 359,  346,  360},
  { 361,  360,  343},
  { 344,  343,  360},
  { 343,  341,  361},
  { 362,  361,  341},
  { 341,  340,  362},
  { 363,  362,  340},
  { 363,  340,  364},
  { 338,  364,  340},
  { 338,    0,  364},
  { 352,  364,    0},
  {   1,  293,    0},
  {   0,  293,  353},
  { 352,  353,  365},
  { 366,  364,  365},
  { 352,  365,  364},
  { 355,  367,  368},
  { 369,  368,  367},
  { 364,  366,  363},
  { 370,  363,  366},
  { 362,  363,  370},
  { 361,  362,  371},
  { 362,  370,  371},
  { 372,  360,  371},
  { 361,  371,  360},
  { 360,  372,  359},
  { 359,  372,  373},
  { 374,  358,  373},
  { 359,  373,  358},
  { 358,  374,  357},
  { 375,  357,  374},
  { 376,  356,  375},
  { 357,  375,  356},
  { 377,  354,  376},
  { 376,  354,  356},
  { 354,  377,  355},
  { 355,  377,  367},
  { 378,  379,  380},
  { 379,  398,  380},
  { 379,  378,  381},
  { 383,  382,  378},
  { 378,  382,  381},
  { 382,  383,  384},
  { 386,  385,  383},
  { 384,  383,  385},
  { 385,  386,  387},
  { 388,  387,  386},
  { 387,  388,  390},
  { 389,  390,  388},
  { 390,  389,  391},
  { 392,  393,  391},
  { 390,  391,  393},
  { 393,  392,  394},
  { 395,  394,  392},
  { 395,  457,  394},
  { 394,  457,   77},
  {  78,   77,  396},
  { 457,  396,   77},
  {  79,   78, 1335},
  {  78,  396, 1335},
  { 397,  398,  399},
  { 400,  399,  398},
  { 400,  401,  399},
  { 402,  427,  401},
  { 427,  402,  403},
  { 403,  402,  404},
  { 403,  404,  405},
  { 406,  405,  404},
  { 405,  406,  407},
  { 408,  407,  406},
  { 409,  407,  410},
  { 407,  408,  410},
  { 410,  411,  409},
  { 412,  409,  411},
  { 411,  413,  412},
  { 414,  412,  413},
  { 415,  414,  416},
  { 413,  416,  414},
  { 417,  418,  416},
  { 418,  415,  416},
  { 418,  417,   63},
  {  67,   63,  417},
  { 419,  420,  460},
  { 461,  460,  420},
  { 421,  422,  420},
  { 461,  420,  422},
  { 423,  422,  421},
  { 421,  424,  423},
  { 425,  423,  424},
  { 425,  424,  426},
  { 428,  426,  424},
  { 428,  427,  429},
  { 430,  429,  427},
  { 429,  430,  431},
  { 431,  430,  432},
  { 433,  434,  432},
  { 431,  432,  434},
  { 434,  433,  435},
  { 433,  436,  435},
  { 437,  438,  436},
  { 436,  438,  435},
  { 438,  437,  439},
  { 439,  437,  440},
  { 439,  440,  441},
  { 442,  441,  440},
  { 443,  444,  365},
  { 445,  446,  367},
  { 369,  367,  446},
  { 367,  377,  445},
  { 447,  445,  377},
  { 447,  377,  448},
  { 376,  449,  377},
  { 448,  377,  449},
  { 375,  450,  376},
  { 449,  376,  450},
  { 450,  375,  451},
  { 375,  374,  451},
  { 452,  451,  374},
  { 453,  452,  373},
  { 374,  373,  452},
  { 372,  453,  373},
  { 371,  454,  372},
  { 372,  454,  453},
  { 454,  371,  370},
  { 455,  454,  366},
  { 454,  370,  366},
  { 366,  365,  455},
  { 444,  455,  365},
  { 365,  293,  296},
  { 293,  297,  296},
  { 353,  293,  365},
  { 295,  443,  365},
  { 294,  295,  365},
  { 296,  294,  365},
  { 274,   32,  270},
  { 260,  456,  288},
  { 457,  288,  456},
  { 260,  262,  456},
  { 274,   26,   32},
  { 262,   32,  456},
  {  32,  262,  270},
  { 457,  287,  288},
  { 443,  295,  300},
  { 444,  443,  299},
  { 443,  300,  299},
  { 458,  455,  444},
  { 458,  444,  299},
  { 446,  445,  380},
  {  32, 1335,  456},
  { 396,  456, 1335},
  { 457,  456,  396},
  { 457,  395,  287},
  { 459,  287,  395},
  { 392,  298,  395},
  { 298,  459,  395},
  { 458,  298,  391},
  { 298,  392,  391},
  { 458,  391,  389},
  { 389,  388,  458},
  { 458,  388,  455},
  { 455,  388,  454},
  { 454,  388,  453},
  { 453,  388,  386},
  { 383,  452,  386},
  { 453,  386,  452},
  { 452,  383,  451},
  { 451,  383,  450},
  { 378,  450,  383},
  { 450,  378,  449},
  { 448,  449,  378},
  { 380,  447,  378},
  { 448,  378,  447},
  { 445,  447,  380},
  { 379,  381,  398},
  { 382,  398,  381},
  { 398,  382,  400},
  { 384,  400,  382},
  { 400,  384,  401},
  { 385,  401,  384},
  { 401,  385,  402},
  { 385,  387,  402},
  { 402,  387,  404},
  { 406,  404,  387},
  { 406,  387,  408},
  { 390,  408,  387},
  { 410,  408,  390},
  { 411,  410,  390},
  { 413,  411,  393},
  { 390,  393,  411},
  { 393,  394,  413},
  { 413,  394,  416},
  { 417,  416,  394},
  { 417,  394,   67},
  {  67,  394,   77},
  {  77,   69,   67},
  { 398,  397,  419},
  { 420,  419,  397},
  { 421,  420,  399},
  { 397,  399,  420},
  { 424,  421,  401},
  { 421,  399,  401},
  { 401,  427,  424},
  { 428,  424,  427},
  { 427,  403,  430},
  { 405,  430,  403},
  { 430,  405,  432},
  { 432,  405,  407},
  { 432,  407,  433},
  { 409,  433,  407},
  { 433,  409,  436},
  { 412,  436,  409},
  { 414,  437,  412},
  { 437,  436,  412},
  { 415,  440,  414},
  { 414,  440,  437},
  { 440,  415,  442},
  { 418,  442,  415},
  { 442,  418,   57},
  {  63,   57,  418},
  {   8,   34,   33},
  {  14,   13,   21},
  { 458,  299,  298},
  { 462,  461,  422},
  { 463,  462,  423},
  { 422,  423,  462},
  { 423,  425,  463},
  { 425,  464,  463},
  { 465,  464,  426},
  { 425,  426,  464},
  { 466,  465,  428},
  { 428,  465,  426},
  { 428,  429,  466},
  { 429,  431,  466},
  { 467,  466,  431},
  { 434,  486,  431},
  { 467,  431,  486},
  { 486,  434,  478},
  { 434,  435,  478},
  { 478,  435,  468},
  { 438,  468,  435},
  { 439,  469,  438},
  { 468,  438,  469},
  { 441,   42,  439},
  { 439,   42,  469},
  { 461,  471,  460},
  { 460,  471,  470},
  { 472,  471,  462},
  { 461,  462,  471},
  { 473,  472,  463},
  { 462,  463,  472},
  { 474,  473,  464},
  { 463,  464,  473},
  { 464,  465,  474},
  { 475,  474,  465},
  { 476,  475,  466},
  { 465,  466,  475},
  { 466,  477,  476},
  { 477,  466,  467},
  { 487,  478,  468},
  { 469,  479,  468},
  { 487,  468,  479},
  {  42,  480,  469},
  { 480,  479,  469},
  { 480,   42,   39},
  { 441,  442,   56},
  {  56,  442,   57},
  {  47,   42,  441},
  {  56,   47,  441},
  { 482,  481,  470},
  { 470,  471,  482},
  { 471,  472,  482},
  { 483,  482,  472},
  { 472,  473,  483},
  { 484,  483,  473},
  { 485,  484,  474},
  { 473,  474,  484},
  { 474,  475,  485},
  { 496,  485,  475},
  { 475,  476,  496},
  { 496,  476,  477},
  { 486,  477,  467},
  { 487,  486,  478},
  { 487,  479,  488},
  { 488,  479,  489},
  { 479,  480,  489},
  {  40,  489,   39},
  { 480,   39,  489},
  { 481,  482,  490},
  { 490,  482,  491},
  { 483,  492,  482},
  { 491,  482,  492},
  { 484,  493,  483},
  { 483,  493,  492},
  { 493,  484,  494},
  { 485,  494,  484},
  { 494,  485,  495},
  { 485,  496,  495},
  { 496,  477,  497},
  { 497,  477,  498},
  { 498,  477,  499},
  { 477,  486,  499},
  { 487,  500,  486},
  { 486,  500,  499},
  { 500,  487,  501},
  { 501,  487,  488},
  { 489,  502,  488},
  { 488,  502,  501},
  { 503,  502,  489},
  { 505,  504,  490},
  { 491,  505,  490},
  { 492,  506,  491},
  { 505,  491,  506},
  { 493,  507,  492},
  { 507,  506,  492},
  { 494,  508,  493},
  { 507,  493,  508},
  { 508,  494,  509},
  { 495,  509,  494},
  { 496,  510,  495},
  { 495,  510,  509},
  { 510,  496,  511},
  { 511,  496,  497},
  { 497,  498,  511},
  { 511,  498,  499},
  { 512,  499,  500},
  { 500,  501,  512},
  { 501,  513,  512},
  { 501,  502,  513},
  { 513,  502,  514},
  { 515,  514,  503},
  { 502,  503,  514},
  { 503,  208,  515},
  { 212,  515,  208},
  { 516,  518,  517},
  { 519,  516,  520},
  { 520,  521,  519},
  { 522,  519,  521},
  { 523,  524,  521},
  { 522,  521,  524},
  { 523,  525,  524},
  { 526,  524,  525},
  { 525,  527,  526},
  { 526,  527,  528},
  { 528,  527,  529},
  { 530,  531,  529},
  { 531,  530,  532},
  { 532,  530,  533},
  { 534,  535,  533},
  { 533,  535,  532},
  { 536,  535,  537},
  { 534,  537,  535},
  { 538,  536,  539},
  { 537,  539,  536},
  { 539,  540,  538},
  { 552,  538,  540},
  { 540,  212,  552},
  { 217,  552,  212},
  { 541,  542,  516},
  { 518,  516,  542},
  { 516,  519,  541},
  { 543,  541,  519},
  { 519,  522,  543},
  { 524,  544,  522},
  { 543,  522,  544},
  { 524,  526,  544},
  { 545,  544,  526},
  { 528,  546,  526},
  { 545,  526,  546},
  { 546,  528,  547},
  { 529,  547,  528},
  { 547,  529,  548},
  { 531,  548,  529},
  { 549,  548,  532},
  { 531,  532,  548},
  { 532,  535,  549},
  { 550,  549,  535},
  { 535,  536,  550},
  { 551,  550,  536},
  { 536,  538,  551},
  { 538,  141,  551},
  { 141,  538,  552},
  { 541,  553,  542},
  { 554,  542,  553},
  { 541,  543,  553},
  { 555,  553,  543},
  { 543,  544,  555},
  { 555,  544,  556},
  { 544,  545,  556},
  { 557,  556,  545},
  { 546,  558,  545},
  { 545,  558,  557},
  { 547,  559,  546},
  { 558,  546,  559},
  { 548,  560,  547},
  { 559,  547,  560},
  { 560,  548,  561},
  { 549,  561,  548},
  { 550,  562,  549},
  { 561,  549,  562},
  { 562,  550,  138},
  { 551,  138,  550},
  { 540,  539,  515},
  { 514,  515,  539},
  { 539,  537,  514},
  { 513,  514,  537},
  { 537,  534,  513},
  { 512,  513,  534},
  { 534,  533,  512},
  { 499,  512,  533},
  { 499,  533,  511},
  { 530,  511,  533},
  { 529,  511,  530},
  { 527,  510,  529},
  { 511,  529,  510},
  { 525,  509,  527},
  { 510,  527,  509},
  { 509,  525,  508},
  { 523,  508,  525},
  { 508,  523,  507},
  { 507,  523,  521},
  { 507,  521,  506},
  { 521,  520,  506},
  { 505,  506,  516},
  { 520,  516,  506},
  { 208,  503,   48},
  { 503,  489,   43},
  {  40,   43,  489},
  { 503,   43,   48},
  { 351,  350,  368},
  { 368,  350,  355},
  { 212,  213,  217},
  { 515,  212,  540},
  { 213,  214,  217},
  { 231,  228,   98},
  {  98,  228,   85},
  { 228,  209,   85},
  { 230,  232,  236},
  { 590,  563,  564},
  { 565,  590,  566},
  { 591,  566,  590},
  { 584,  565,  567},
  { 566,  567,  565},
  { 563,  590,  568},
  { 568,  569,  570},
  { 570,  569,  571},
  { 572,  573,  581},
  { 574,  581,  573},
  { 575,  576,  574},
  { 576,  581,  574},
  { 576,  575,  577},
  { 578,  577,  575},
  { 577,  579,  576},
  { 580,  576,  579},
  { 576,  580,  581},
  { 572,  581,  610},
  { 574,  612,  575},
  { 612,  574,  582},
  { 573,  582,  574},
  { 583,  582,  584},
  { 584,  582,  585},
  { 586,  587,  581},
  { 581,  587,  610},
  { 580,  588,  581},
  { 588,  586,  581},
  { 580,  579,  588},
  { 589,  582,  573},
  { 565,  584,  585},
  { 591,  590,  564},
  { 568,  570,  592},
  { 592,  570,  593},
  { 571,  593,  570},
  { 587,  594,  571},
  { 571,  594,  593},
  { 579,  595,  588},
  { 588,  595,  596},
  { 586,  597,  587},
  { 594,  587,  597},
  { 596,  597,  588},
  { 586,  588,  597},
  { 598,  599,  593},
  { 592,  593,  599},
  { 600,  598,  594},
  { 598,  593,  594},
  { 601,  600,  597},
  { 594,  597,  600},
  { 597,  596,  601},
  { 602,  601,  596},
  { 596,  595,  602},
  { 603,  602,  595},
  { 595,  604,  603},
  { 605,  603,  604},
  { 606,  592,  599},
  { 592,  606,  607},
  { 607,  606,  608},
  { 585,  589,  565},
  { 565,  589,  590},
  { 609,  589,  572},
  { 573,  572,  589},
  { 589,  609,  590},
  { 590,  609,  610},
  { 572,  610,  609},
  { 587,  571,  610},
  { 569,  610,  571},
  { 590,  610,  568},
  { 568,  610,  569},
  { 568,  592,  563},
  { 592,  607,  563},
  { 583,  584,  611},
  { 582,  583,  612},
  { 613,  578,  575},
  { 614,  613,  615},
  { 575,  615,  613},
  { 575,  612,  615},
  { 614,  615,  616},
  { 616,  615,  617},
  { 615,  612,  617},
  { 612,  618,  617},
  { 611,  618,  583},
  { 618,  612,  583},
  { 599,  598,  619},
  { 599,  619,  606},
  { 598,  620,  619},
  { 620,  621,  619},
  { 584,  621,  620},
  { 619,  621,  622},
  { 622,  621,  567},
  { 600,  623,  598},
  { 620,  598,  623},
  { 611,  584,  623},
  { 620,  623,  584},
  { 601,  624,  600},
  { 623,  600,  624},
  { 624,  618,  623},
  { 611,  623,  618},
  { 622,  608,  619},
  { 606,  619,  608},
  { 624,  601,  602},
  { 603,  624,  602},
  { 618,  624,  617},
  { 603,  605,  624},
  { 624,  605,  617},
  { 616,  617,  605},
  { 614,  616,  604},
  { 605,  604,  616},
  { 577,  604,  579},
  { 595,  579,  604},
  { 589,  585,  582},
  { 604,  577,  614},
  { 614,  577,  613},
  { 577,  578,  613},
  { 584,  567,  621},
  { 591,  219,  566},
  { 563,  607,  224},
  { 607,  241,  224},
  { 224,  223,  563},
  { 564,  563,  223},
  { 219,  591,  223},
  { 564,  223,  591},
  { 567,  566,  219},
  { 607,  608,  241},
  { 608,  622,  241},
  { 241,  622,  236},
  { 622,  567,  236},
  { 136,  140,  217},
  { 552,  217,  140},
  { 551,  141,  138},
  { 140,  141,  552},
  { 137,  562,  138},
  { 142,  143,  558},
  { 557,  558,  143},
  { 142,  558,  559},
  { 560,  561,  131},
  { 131,  561,  137},
  { 562,  137,  561},
  { 125,  626,  143},
  { 143,  626,  557},
  { 625,  554,  553},
  { 625,  553,  626},
  { 555,  626,  553},
  { 556,  626,  555},
  { 556,  557,  626},
  { 627, 1606,  628},
  { 629,  627,  630},
  { 628,  630,  627},
  { 631,  629,  632},
  { 632,  629,  630},
  { 633,  631,  634},
  { 634,  631,  632},
  { 635,  633,  636},
  { 634,  636,  633},
  { 637, 1645,  627},
  {1606,  627, 1645},
  { 638,  637,  629},
  { 627,  629,  637},
  { 639,  638,  631},
  { 638,  629,  631},
  { 640,  639,  633},
  { 631,  633,  639},
  { 633,  635,  640},
  { 641, 1643,  637},
  {1645,  637, 1643},
  { 642,  641,  638},
  { 637,  638,  641},
  { 643,  642,  639},
  { 638,  639,  642},
  { 644,  643,  640},
  { 639,  640,  643},
  { 635,  644,  640},
  {1643,  641,  645},
  { 646,  641,  642},
  { 647,  646,  643},
  { 643,  646,  642},
  { 648,  647,  644},
  { 647,  643,  644},
  { 649, 1640,  641},
  { 645,  641, 1640},
  { 650,  649,  646},
  { 641,  646,  649},
  { 651,  650,  647},
  { 646,  647,  650},
  { 652,  651,  648},
  { 647,  648,  651},
  { 653, 1638,  649},
  {1640,  649, 1638},
  { 654,  653,  650},
  { 649,  650,  653},
  { 518,  654,  651},
  { 651,  654,  650},
  { 655,  518,  652},
  { 651,  652,  518},
  { 635,  505,  644},
  { 635,  636,  504},
  { 635,  504,  505},
  { 505,  516,  644},
  {  89,  656,   88},
  {  90,   88,  670},
  { 656,  670,   88},
  {  90,  670,   91},
  {  91,  670,  657},
  {  93,   91,  657},
  {  93,  657,  106},
  { 106,  657,  658},
  { 108,  106,  659},
  { 658,  659,  106},
  { 109,  108,  660},
  { 659,  660,  108},
  {  89,  109,  656},
  { 660,  656,  109},
  {  94,   95,  661},
  { 673,  661,   95},
  {  96,   94,  680},
  { 661,  680,   94},
  {  96,  680,   97},
  {  99,   97,  680},
  { 662,  102,   99},
  { 102,  662,  101},
  { 101,  662,  104},
  { 663,  104,  662},
  { 105,  104,  664},
  { 663,  664,  104},
  {  95,  105,  673},
  { 664,  673,  105},
  { 660,  659,  665},
  { 666,  665,  659},
  { 659,  658,  666},
  { 667,  666,  658},
  { 657,  668,  658},
  { 658,  668,  667},
  { 669,  668,  657},
  { 669,  657,  670},
  { 671,  670,  656},
  { 672,  671,  656},
  { 656,  660,  672},
  { 665,  672,  660},
  { 674,  673,  664},
  { 664,  663,  674},
  { 675,  674,  663},
  { 662,  676,  663},
  { 675,  663,  676},
  { 676,  662,  677},
  {  99,  678,  662},
  { 662,  678,  677},
  { 678,   99,  679},
  { 679,   99,  680},
  { 680,  661,  681},
  { 661,  673,  681},
  { 671,  672,  682},
  { 670,  671,  682},
  { 669,  670,  682},
  { 668,  669,  682},
  { 667,  668,  682},
  { 666,  667,  682},
  { 665,  666,  682},
  { 672,  665,  682},
  { 681,  673,  683},
  { 680,  681,  683},
  { 679,  680,  683},
  { 678,  679,  683},
  { 677,  678,  683},
  { 676,  677,  683},
  { 675,  676,  683},
  { 674,  675,  683},
  { 673,  674,  683},
  { 684,  686,  685},
  { 685,  686,  687},
  { 698,  686,  695},
  { 684,  695,  686},
  { 698,  696,  686},
  { 687,  686,  696},
  { 687,  696,  688},
  { 689,  685,  688},
  { 687,  688,  685},
  { 690,  684,  689},
  { 684,  685,  689},
  { 684,  690,  694},
  { 691,  690,  692},
  { 689,  692,  690},
  { 684,  694,  693},
  { 689,  688,  692},
  { 696,  692,  688},
  { 696,  697,  692},
  { 696,  708,  697},
  { 696,  698,  708},
  { 699,  700,  693},
  { 693,  700,  695},
  { 700,  701,  695},
  { 695,  701,  698},
  { 694,  702,  693},
  { 702,  703,  693},
  { 702,  694,  704},
  { 691,  704,  694},
  { 705,  714,  704},
  { 702,  704,  714},
  { 713,  703,  714},
  { 702,  714,  703},
  { 713,  706,  703},
  { 699,  703,  706},
  { 706,  700,  699},
  { 701,  700,  707},
  { 698,  701,  708},
  { 707,  708,  701},
  { 691,  692,  697},
  { 691,  697,  716},
  { 700,  711,  707},
  { 706,  712,  700},
  { 711,  700,  712},
  { 706,  713,  712},
  { 705,  715,  714},
  { 715,  705,  716},
  { 716,  705,  691},
  { 714,  715,  717},
  { 717,  715,  718},
  { 719,  713,  717},
  { 713,  714,  717},
  { 720,  712,  719},
  { 719,  712,  713},
  { 711,  712,  721},
  { 720,  721,  712},
  { 721,  707,  711},
  { 709,  707,  725},
  { 709,  725,  708},
  { 722,  720,  723},
  { 720,  719,  723},
  { 722,  724,  720},
  { 720,  724,  721},
  { 721,  724,  707},
  { 725,  707,  724},
  { 710,  708,  726},
  { 708,  725,  726},
  { 726,  727,  710},
  { 708,  710,  727},
  { 728,  697,  727},
  { 708,  727,  697},
  { 697,  728,  736},
  { 716,  697,  736},
  { 736,  729,  716},
  { 718,  716,  730},
  { 729,  730,  716},
  { 731,  717,  732},
  { 718,  732,  717},
  { 732,  718,  730},
  { 737,  733,  724},
  { 725,  724,  733},
  { 725,  733,  734},
  { 734,  726,  725},
  { 726,  735,  727},
  { 736,  730,  729},
  { 736,  751,  730},
  { 737,  722,  738},
  { 722,  723,  738},
  { 731,  738,  723},
  { 739,  738,  731},
  { 740,  739,  732},
  { 739,  731,  732},
  { 740,  732,  730},
  { 728,  727,  735},
  { 735,  741,  728},
  { 736,  728,  741},
  { 742,  734,  743},
  { 733,  743,  734},
  { 743,  744,  742},
  { 742,  744,  745},
  { 746,  745,  744},
  { 734,  742,  745},
  { 734,  745,  726},
  { 726,  745,  735},
  { 747,  735,  745},
  { 800,  735,  747},
  { 800,  748,  735},
  { 748,  741,  735},
  { 736,  741,  749},
  { 741,  748,  749},
  { 749,  750,  736},
  { 746, 1739,  745},
  { 752,  745, 1739},
  { 753,  745,  752},
  { 745,  753,  747},
  { 747,  753,  800},
  { 754,  783,  755},
  { 783,  791,  755},
  {1739,  762,  752},
  { 757,  752,  762},
  { 757,  756,  752},
  { 756,  754,  752},
  { 754,  753,  752},
  { 754,  755,  753},
  { 800,  753,  755},
  { 756,  757,  758},
  { 759,  758,  757},
  { 760,  761,  762},
  { 759,  762,  761},
  { 761,  763,  759},
  { 759,  763,  758},
  { 754,  756,  764},
  { 758,  765,  756},
  { 756,  765,  764},
  { 766,  765,  763},
  { 758,  763,  765},
  { 761,  767,  763},
  { 761,  760,  767},
  { 767,  760,  768},
  { 763,  767,  766},
  { 767,  768,  769},
  { 768, 1753,  769},
  { 771,  770,  769},
  { 770,  772,  769},
  { 773,  774,  775},
  { 774,  776,  775},
  { 777,  775,  776},
  { 778,  772,  779},
  { 779,  772,  773},
  { 774,  773,  770},
  { 772,  770,  773},
  { 797,  774,  771},
  { 770,  771,  774},
  { 774,  797,  776},
  { 780,  776,  797},
  { 775,  781,  773},
  { 779,  773,  781},
  { 791,  782,  775},
  { 781,  775,  782},
  { 791,  783,  782},
  { 764,  783,  754},
  { 784,  778,  779},
  { 781,  785,  779},
  { 784,  779,  785},
  { 783,  786,  782},
  { 786,  787,  782},
  { 786,  783,  764},
  { 786,  764,  765},
  { 766,  787,  765},
  { 786,  765,  787},
  { 787,  766,  785},
  { 767,  784,  766},
  { 785,  766,  784},
  { 776,  780,  789},
  { 789,  780,  788},
  { 789,  788,  790},
  { 775,  777,  791},
  { 755,  791,  792},
  { 755,  792,  790},
  { 793,  792,  791},
  { 791,  789,  793},
  { 793,  790,  792},
  { 789,  790,  793},
  { 800,  755,  790},
  { 800,  790,  794},
  { 780,  795,  788},
  { 796,  788,  795},
  { 797,  795,  780},
  { 796,  798,  794},
  { 798,  796,  795},
  { 797,  799,  795},
  { 794,  798,  800},
  {1753,  771,  769},
  { 771, 1753,  801},
  {1785,  801, 1753},
  { 799,  797,  801},
  { 801,  797,  771},
  { 801, 1785,  802},
  { 803,  799,  802},
  { 802,  799,  801},
  { 802, 1786,  803},
  { 799,  803,  795},
  { 803,  798,  795},
  { 806,  804, 1788},
  { 805, 1788,  804},
  { 798,  803,  805},
  { 803, 1786,  805},
  { 804,  798,  805},
  { 806,  800,  804},
  { 798,  804,  800},
  {1790,  807, 1788},
  {1788,  807,  806},
  { 807, 1790,  808},
  { 800,  806,  809},
  { 807,  809,  806},
  { 808,  809,  807},
  { 748,  800,  809},
  { 749,  748,  810},
  { 810,  748,  811},
  { 811,  748,  809},
  { 808,  811,  809},
  { 810,  812,  749},
  { 750,  749,  812},
  { 812,  810,  813},
  { 811,  813,  810},
  { 811,  808,  813},
  { 808, 1790,  317},
  { 317,  814,  808},
  { 813,  808,  814},
  { 813,  815,  812},
  { 816,  812,  815},
  { 815,  817,  816},
  { 816,  817,  818},
  { 816,  818,  736},
  { 819,  736,  818},
  { 820,  736,  819},
  { 736,  820,  751},
  { 821,  820,  819},
  { 819,  818,  821},
  { 817,  821,  818},
  { 724,  722,  737},
  { 757,  762,  759},
  { 824,  826,  823},
  { 825,  826,  824},
  { 826,  825,  827},
  { 826,  829,  823},
  { 823,  829,  828},
  { 827,  829,  826},
  { 830,  829,  827},
  { 831,  830,  832},
  { 827,  832,  830},
  { 827,  825,  832},
  { 833,  832,  825},
  { 831,  832,  834},
  { 832,  833,  834},
  { 831,  834,  835},
  { 835,  834,  837},
  { 835,  837,  836},
  { 836,  837,  838},
  { 839,  838,  837},
  { 840,  737,  738},
  { 738,  824,  840},
  { 824,  823,  840},
  { 825,  824,  738},
  { 841,  833,  825},
  { 837,  834,  850},
  { 837,  850,  853},
  { 837,  853,  839},
  { 853,  856,  839},
  { 842,  839,  856},
  { 838,  839,  843},
  { 842,  843,  839},
  { 843,  844,  838},
  { 843,  842,  845},
  { 844,  843,  845},
  { 856,  846,  842},
  { 845,  842,  846},
  { 846,  894,  845},
  { 847,  894,  846},
  { 841,  825,  738},
  { 841,  738,  739},
  { 841,  739,  833},
  { 848,  833,  739},
  { 848,  849,  833},
  { 834,  833,  849},
  { 849,  850,  834},
  { 865,  849,  851},
  { 851,  849,  848},
  { 851,  848,  739},
  { 865,  852,  849},
  { 850,  849,  852},
  { 852,  854,  850},
  { 853,  850,  854},
  { 854,  855,  853},
  { 855,  856,  853},
  { 858,  857,  856},
  { 846,  856,  857},
  { 859,  860,  855},
  { 855,  860,  856},
  { 860,  861,  856},
  { 856,  861,  858},
  { 861,  862,  858},
  { 855,  854,  859},
  { 863,  859,  854},
  { 864,  863,  852},
  { 854,  852,  863},
  { 864,  852,  865},
  { 851,  866,  865},
  { 867,  866,  851},
  { 862,  847,  858},
  { 881,  882,  861},
  { 862,  861,  882},
  { 868,  881,  860},
  { 861,  860,  881},
  { 860,  859,  868},
  { 869,  868,  859},
  { 859,  863,  869},
  { 864,  870,  863},
  { 871,  870,  865},
  { 864,  865,  870},
  { 862,  882,  847},
  { 872,  871,  866},
  { 865,  866,  871},
  { 866,  867,  872},
  { 878,  872,  867},
  { 870,  873,  863},
  { 874,  863,  873},
  { 863,  874,  869},
  { 875,  868,  874},
  { 869,  874,  868},
  { 873,  870,  876},
  { 871,  876,  870},
  { 876,  871,  877},
  { 877,  871,  872},
  { 878,  877,  872},
  { 879,  877,  878},
  { 878,  880,  879},
  { 868,  875,  881},
  { 828,  829,  883},
  { 884,  883,  829},
  { 879,  884,  829},
  { 885,  879,  830},
  { 829,  830,  879},
  { 830,  831,  885},
  { 877,  885,  831},
  { 844,  886,  838},
  { 887,  838,  886},
  { 838,  887,  836},
  { 888,  836,  887},
  { 889,  835,  888},
  { 836,  888,  835},
  { 877,  831,  890},
  { 891,  879,  892},
  { 880,  892,  879},
  { 892,  893,  891},
  { 883,  891,  893},
  { 891,  883,  884},
  { 891,  884,  879},
  { 877,  879,  885},
  { 890,  831,  889},
  { 831,  835,  889},
  { 876,  877,  890},
  { 876,  890,  873},
  { 889,  873,  890},
  { 874,  873,  888},
  { 889,  888,  873},
  { 888,  887,  874},
  { 886,  844,  894},
  { 894,  844,  845},
  { 887,  886,  874},
  { 875,  874,  886},
  { 886,  894,  875},
  { 881,  875,  894},
  { 882,  881,  894},
  { 882,  894,  847},
  { 895,  893,  896},
  { 892,  896,  893},
  { 896,  892,  899},
  { 897,  899,  892},
  { 878,  897,  880},
  { 897,  892,  880},
  { 898,  899,  897},
  { 903,  900,  899},
  { 867,  898,  878},
  { 897,  878,  898},
  { 901,  898,  867},
  { 901,  902,  898},
  { 899,  898,  902},
  { 899,  902,  903},
  { 904,  901,  909},
  { 909,  901,  867},
  { 902,  901,  905},
  { 904,  905,  901},
  { 905,  906,  902},
  { 902,  906,  903},
  { 867,  851,  907},
  { 909,  867,  908},
  { 907,  908,  867},
  { 909,  910,  904},
  { 910,  923,  904},
  { 905,  904,  923},
  { 915,  910,  909},
  { 915,  911,  910},
  { 912,  913,  917},
  { 922,  917,  913},
  { 915,  914,  911},
  { 911,  914,  922},
  { 922,  914,  917},
  { 915,  916,  914},
  { 914,  916,  917},
  { 912,  917,  918},
  { 919,  912,  920},
  { 918,  920,  912},
  { 919,  920,  921},
  { 910,  911,  922},
  { 906,  905,  923},
  { 910,  924,  923},
  { 910,  922,  924},
  { 925,  924,  922},
  { 925,  922,  913},
  { 913,  912,  919},
  { 926,  925,  927},
  { 913,  927,  925},
  { 927,  913,  919},
  { 919,  921,  928},
  { 927,  919,  929},
  { 919,  928,  929},
  { 929,  930,  927},
  { 926,  927,  930},
  { 930,  931,  926},
  { 932,  926,  931},
  { 926,  932,  925},
  { 924,  925,  932},
  { 900,  903,  933},
  { 906,  933,  903},
  { 934,  935,  933},
  { 933,  906,  934},
  { 932,  936,  924},
  { 923,  924,  936},
  { 936,  906,  923},
  { 906,  936,  934},
  { 936,  937,  934},
  { 931,  937,  932},
  { 937,  936,  932},
  { 851,  739,  740},
  { 938,  740,  939},
  { 938,  851,  740},
  { 939,  740,  730},
  { 940,  941,  920},
  { 920,  941,  921},
  { 942,  940,  918},
  { 918,  940,  920},
  { 948,  958,  942},
  { 940,  942,  958},
  { 851,  938,  943},
  { 944,  943,  945},
  { 907,  851,  908},
  { 908,  851,  909},
  { 909,  851,  943},
  { 909,  943,  915},
  { 943,  938,  939},
  { 943,  944,  915},
  { 946,  915,  944},
  { 946,  947,  915},
  { 916,  915,  947},
  { 916,  947,  917},
  { 917,  947,  918},
  { 918,  947,  942},
  { 947,  948,  942},
  { 952,  947,  946},
  { 951,  952,  944},
  { 946,  944,  952},
  { 947,  949,  948},
  { 945,  943,  950},
  { 939,  950,  943},
  { 944,  945,  951},
  { 949,  947,  952},
  { 953,  952,  951},
  { 954,  953,  951},
  { 956,  953,  954},
  { 952,  953,  955},
  { 956,  955,  953},
  { 958,  949,  955},
  { 952,  955,  949},
  { 949,  958,  948},
  { 957,  955,  956},
  { 955,  957,  958},
  { 931,  957,  959},
  { 956,  959,  957},
  { 931,  958,  957},
  { 950,  751,  960},
  { 960,  751,  820},
  { 939,  751,  950},
  { 939,  730,  751},
  { 934,  960,  821},
  { 821,  960,  820},
  { 951,  945,  961},
  { 945,  962,  961},
  { 961,  962,  963},
  { 954,  951,  961},
  { 961,  959,  954},
  { 956,  954,  959},
  { 962,  945,  950},
  { 962,  950,  963},
  { 960,  963,  950},
  { 959,  961,  963},
  { 767,  778,  784},
  { 767,  769,  778},
  { 772,  778,  769},
  { 777,  776,  791},
  { 776,  789,  791},
  { 782,  787,  781},
  { 781,  787,  785},
  { 794,  790,  796},
  { 788,  796,  790},
  { 736,  750,  816},
  { 812,  816,  750},
  { 715,  716,  718},
  { 694,  690,  691},
  { 684,  693,  695},
  { 705,  704,  691},
  { 703,  699,  693},
  { 723,  719,  731},
  { 717,  731,  719},
  { 708,  707,  709},
  { 928,  921,  941},
  { 941,  958,  928},
  { 934,  937,  963},
  { 959,  963,  937},
  { 931,  959,  937},
  { 958,  931,  930},
  { 930,  929,  958},
  { 928,  958,  929},
  { 935,  934,  822},
  { 821,  822,  934},
  { 935,  822,  306},
  { 822,  821,  306},
  { 306,  821,  817},
  { 813,  319,  815},
  { 814,  318,  813},
  { 813,  318,  319},
  { 317,  318,  814},
  { 899,  322,  896},
  { 896,  322,  895},
  { 316,  895,  322},
  { 933,  935,  320},
  { 900,  933,  320},
  { 900,  320,  322},
  { 899,  900,  322},
  { 846,  857,  847},
  { 857,  858,  847},
  { 963,  960,  934},
  { 190,  255,  145},
  { 250,  145,  255},
  { 175,  190,  144},
  { 190,  145,  144},
  {  59,   60,   74},
  {  73,   70,   59},
  { 100,  110,  964},
  { 964,  102,  100},
  { 964,   98,  102},
  {  99,  102,   98},
  { 517,  644,  516},
  { 655,  648,  517},
  { 644,  517,  648},
  { 941,  940,  958},
  {  98,  964,  231},
  { 234,  231,  964},
  { 966,  965,  967},
  { 976,  965,  968},
  { 968,  965,  966},
  { 976,  968,  974},
  { 975,  974,  968},
  { 970,  975,  966},
  { 966,  975,  968},
  { 969,  970,  967},
  { 966,  967,  970},
  { 969,  971,  970},
  { 972,  971,  969},
  { 972,  973,  971},
  { 975,  971,  973},
  { 974,  975,  973},
  { 971,  975,  970},
  { 977,  985,  974},
  { 974,  973,  977},
  { 973,  978,  977},
  { 979,  977,  978},
  { 985,  977,  979},
  { 980,  978,  973},
  { 981,  980,  973},
  { 981,  973,  982},
  { 983,  982,  973},
  { 973,  972,  983},
  { 969,  984,  972},
  { 979,  986,  985},
  { 987,  986,  978},
  { 979,  978,  986},
  { 987,  978,  988},
  { 988,  978,  980},
  { 981,  989,  988},
  { 989,  981,  990},
  { 982,  990,  981},
  { 990,  982,  991},
  { 991,  982,  983},
  { 972,  992,  983},
  { 983,  992,  991},
  { 984,  993,  972},
  { 992,  972,  993},
  { 985,  986,   27},
  { 987,   28,  986},
  {  28,   27,  986},
  {  28,  987,   29},
  {  29,  987,  988},
  { 988,  989,   29},
  {  29,  989,   30},
  { 990,   31,  989},
  {  30,  989,   31},
  {  32,   31,  991},
  { 990,  991,   31},
  { 991,  992,   32},
  {  32,  992,  993},
  { 994,  995,  996},
  { 997,  996,  976},
  { 985,  997,  976},
  { 998,  997,  985},
  { 985,   27,  998},
  { 974,  985,  976},
  { 996,  997,  999},
  { 997,  998,  999},
  {1000, 1002, 1001},
  {1003, 1001, 1002},
  {1004, 1000, 1005},
  {1002, 1000, 1006},
  {1006, 1000, 1004},
  {1006, 1007, 1002},
  {1003, 1002, 1013},
  {1007, 1013, 1002},
  {1008, 1003, 1013},
  {1009, 1010, 1005},
  {1004, 1005, 1010},
  {1010, 1011, 1004},
  {1006, 1004, 1011},
  {1012, 1007, 1011},
  {1011, 1007, 1006},
  {1007, 1012, 1013},
  {1015, 1013, 1012},
  {1014, 1008, 1013},
  {1013, 1015, 1014},
  {1016, 1017, 1014},
  {1014, 1017, 1008},
  {1016, 1020, 1017},
  {1018, 1017, 1020},
  {1018, 1020, 1019},
  {1019, 1020, 1021},
  {1022, 1018, 1019},
  {1023, 1018, 1022},
  {1018, 1023, 1024},
  {1023, 1025, 1024},
  {1026, 1024, 1025},
  {1027, 1024, 1026},
  {1024, 1027, 1028},
  {1029, 1030, 1027},
  {1028, 1027, 1030},
  {1027, 1026, 1029},
  {1025, 1029, 1026},
  {1021, 1029, 1023},
  {1029, 1025, 1023},
  {1022, 1019, 1021},
  {1031, 1020, 1016},
  {1016, 1032, 1031},
  {1014, 1032, 1016},
  {1033, 1032, 1014},
  {1034, 1032, 1033},
  {1034, 1031, 1032},
  {1035, 1020, 1034},
  {1036, 1029, 1035},
  {1021, 1035, 1029},
  {1029, 1036, 1030},
  {1030, 1036, 1037},
  {1038, 1030, 1039},
  {1037, 1039, 1030},
  {1039, 1037,   79},
  {  80,   79, 1037},
  {1037, 1036,   80},
  {  81,   80, 1036},
  {1036, 1035,   81},
  {1035,   82,   81},
  {  82, 1035,   83},
  {1034,   83, 1035},
  {  83, 1034,   84},
  {1014, 1015, 1033},
  {1040, 1051, 1009},
  {1010, 1009, 1051},
  {1051, 1041, 1010},
  {1011, 1010, 1041},
  {1041, 1042, 1011},
  {1042, 1012, 1011},
  {1012, 1042, 1015},
  {1033, 1015, 1042},
  {1033, 1043, 1034},
  {1044, 1034, 1043},
  {1033, 1042, 1043},
  {1043, 1042, 1045},
  {1041, 1046, 1042},
  {1045, 1042, 1046},
  {1041, 1047, 1046},
  {1048, 1046, 1047},
  {1041, 1049, 1047},
  {1050, 1047, 1049},
  {1041, 1051, 1049},
  {1040, 1052, 1051},
  {1040, 1053, 1052},
  {1053, 1054, 1052},
  { 103, 1055, 1056},
  {1057, 1056, 1055},
  {1058, 1055,  103},
  { 107, 1059,  103},
  {1058,  103, 1059},
  { 107, 1047, 1059},
  {1050, 1059, 1047},
  { 107, 1060, 1047},
  {1048, 1047, 1060},
  {1061, 1060,  107},
  {  84, 1062,  107},
  {1061,  107, 1062},
  {  84, 1034, 1062},
  {1062, 1034, 1044},
  {1022, 1021, 1023},
  {1064, 1063, 1944},
  {1065, 1063, 1066},
  {1064, 1066, 1063},
  {1066, 1067, 1065},
  {1068, 1065, 1067},
  {1067, 1069, 1068},
  {1070, 1068, 1069},
  {1069, 1071, 1070},
  {1072, 1070, 1071},
  {1071, 1073, 1072},
  {1073, 1074, 1072},
  {1074, 1073, 1075},
  {1078, 1076, 1075},
  {1076, 1077,  125},
  {1075,  126, 1074},
  { 127, 1074,  126},
  {1072, 1074,  127},
  { 127,  128, 1072},
  {1070, 1072,  128},
  { 129, 1068,  128},
  {1070,  128, 1068},
  {1068,  129, 1065},
  { 130, 1063,  129},
  {1065,  129, 1063},
  { 103, 1056,  130},
  { 130, 1056, 1063},
  { 126, 1075, 1076},
  {1075, 1079, 1078},
  {1073, 1080, 1075},
  {1075, 1080, 1079},
  {1081, 1080, 1071},
  {1073, 1071, 1080},
  {1082, 1081, 1069},
  {1071, 1069, 1081},
  {1069, 1067, 1082},
  {1082, 1067, 1083},
  {1066, 1083, 1067},
  {1084, 1085, 1086},
  {1079, 1086, 1078},
  {1086, 1079, 1084},
  {1080, 1084, 1079},
  {1088, 1084, 1081},
  {1080, 1081, 1084},
  {1087, 1088, 1082},
  {1081, 1082, 1088},
  {1083, 1087, 1082},
  {1077, 1089,  125},
  {1089, 1090,  125},
  {1084, 1088, 1085},
  {1091, 1092, 1093},
  {1092, 1094, 1093},
  {1095, 1096, 1117},
  {1097, 1117, 1096},
  {1095, 1113, 1096},
  {1113, 1098, 1096},
  {1099, 1092, 1091},
  {1100, 1101, 1099},
  {1102, 1101, 1100},
  {1136, 1103, 1104},
  {1105, 1106, 1103},
  {1104, 1103, 1106},
  {1106, 1105, 1107},
  {1107, 1105, 1108},
  {1108, 1105, 1109},
  {1109, 1105, 1110},
  {1105, 1103, 1110},
  {1103, 1136, 1137},
  {1104, 1106, 1111},
  {1112, 1113, 1111},
  {1114, 1111, 1113},
  {1137, 1115, 1103},
  {1110, 1103, 1115},
  {1115, 1109, 1110},
  {1104, 1111, 1116},
  {1095, 1114, 1113},
  {1097, 1118, 1117},
  {1118, 1094, 1117},
  {1117, 1094, 1092},
  {1099, 1119, 1100},
  {1119, 1120, 1100},
  {1100, 1120, 1102},
  {1115, 1102, 1121},
  {1120, 1121, 1102},
  {1109, 1115, 1122},
  {1123, 1122, 1115},
  {1121, 1124, 1115},
  {1123, 1115, 1124},
  {1125, 1120, 1126},
  {1119, 1126, 1120},
  {1127, 1121, 1125},
  {1120, 1125, 1121},
  {1128, 1124, 1127},
  {1124, 1121, 1127},
  {1124, 1128, 1123},
  {1123, 1128, 1129},
  {1123, 1129, 1122},
  {1130, 1122, 1129},
  {1122, 1130, 1131},
  {1132, 1131, 1130},
  {1133, 1126, 1119},
  {1119, 1134, 1133},
  {1135, 1133, 1134},
  {1114, 1095, 1116},
  {1095, 1117, 1116},
  {1136, 1104, 1116},
  {1116, 1117, 1136},
  {1117, 1092, 1136},
  {1137, 1136, 1092},
  {1102, 1115, 1137},
  {1102, 1137, 1101},
  {1092, 1099, 1137},
  {1099, 1101, 1137},
  {1091, 1119, 1099},
  {1112, 1138, 1113},
  {1144, 1112, 1111},
  {1106, 1107, 1139},
  {1140, 1141, 1139},
  {1106, 1139, 1141},
  {1144, 1111, 1141},
  {1106, 1141, 1111},
  {1140, 1142, 1141},
  {1143, 1141, 1142},
  {1141, 1143, 1144},
  {1138, 1112, 1144},
  {1145, 1125, 1126},
  {1133, 1145, 1126},
  {1125, 1145, 1146},
  {1147, 1146, 1145},
  {1146, 1147, 1113},
  {1145, 1148, 1147},
  {1148, 1149, 1147},
  {1149, 1113, 1147},
  {1127, 1125, 1150},
  {1146, 1150, 1125},
  {1150, 1146, 1138},
  {1113, 1138, 1146},
  {1128, 1127, 1151},
  {1150, 1151, 1127},
  {1151, 1150, 1144},
  {1138, 1144, 1150},
  {1148, 1145, 1135},
  {1133, 1135, 1145},
  {1129, 1128, 1151},
  {1129, 1151, 1130},
  {1143, 1151, 1144},
  {1151, 1132, 1130},
  {1151, 1143, 1132},
  {1143, 1142, 1132},
  {1140, 1131, 1142},
  {1131, 1132, 1142},
  {1108, 1109, 1131},
  {1122, 1131, 1109},
  {1153, 1040, 1009},
  {1009, 1152, 1153},
  {1154, 1153, 1156},
  {1152, 1156, 1153},
  {1155, 1154, 1156},
  {1157, 1155, 1156},
  {1066, 1158, 1159},
  {1160, 1159, 1158},
  {1066, 1159, 1083},
  {1083, 1159, 1161},
  {1162, 1163, 1164},
  {1165, 1166, 1162},
  {1163, 1162, 1166},
  {1166, 1165, 1155},
  {1154, 1155, 1165},
  {1157, 1166, 1155},
  {1167, 1164, 1163},
  {1167, 1163, 1168},
  {1169, 1168, 1166},
  {1163, 1166, 1168},
  {1166, 1157, 1169},
  {1160, 1169, 1157},
  {1164, 1491, 1162},
  {1170, 1162, 1491},
  {1171, 1165, 1170},
  {1162, 1170, 1165},
  {1153, 1154, 1171},
  {1171, 1154, 1165},
  {1153, 1171, 1172},
  {1172, 1171, 1173},
  {1171, 1170, 1173},
  {1173, 1170, 1174},
  {1170, 1491, 1174},
  {1180, 1174, 1491},
  {1172, 1173, 1175},
  {1174, 1176, 1173},
  {1173, 1176, 1177},
  {1175, 1173, 1178},
  {1178, 1173, 1177},
  {1177, 1179, 1178},
  {1179, 1177, 1176},
  {1185, 1176, 1180},
  {1181, 1158, 1064},
  {1066, 1064, 1158},
  {1064, 1944, 1181},
  {1178, 1181, 1944},
  {1179, 1182, 1178},
  {1178, 1182, 1181},
  {1182, 1179, 1183},
  {1179, 1176, 1183},
  {1183, 1176, 1185},
  {1158, 1181, 1184},
  {1182, 1184, 1181},
  {1185, 1184, 1183},
  {1182, 1183, 1184},
  {1185, 1168, 1184},
  {1168, 1169, 1184},
  {1158, 1184, 1160},
  {1160, 1184, 1169},
  {1157, 1159, 1160},
  {1186, 1210, 1187},
  {1210, 1188, 1187},
  {1189, 1210, 1186},
  {1189, 1186, 1190},
  {1191, 1190, 1192},
  {1193, 1194, 1094},
  {1093, 1094, 1194},
  {1194, 1193, 1195},
  {1229, 1197, 1198},
  {1200, 1199, 1195},
  {1194, 1195, 1199},
  {1195, 1196, 1200},
  {1196, 1197, 1200},
  {1201, 1197, 1229},
  {1205, 1202, 1200},
  {1199, 1200, 1202},
  {1197, 1203, 1200},
  {1205, 1200, 1203},
  {1204, 1203, 1201},
  {1201, 1203, 1197},
  {1213, 1215, 1203},
  {1215, 1205, 1203},
  {1203, 1204, 1213},
  {1206, 1213, 1204},
  {1098, 1187, 1096},
  {1096, 1187, 1188},
  {1097, 1096, 1193},
  {1096, 1188, 1193},
  {1191, 1207, 1190},
  {1208, 1190, 1207},
  {1209, 1189, 1208},
  {1189, 1190, 1208},
  {1188, 1210, 1193},
  {1189, 1209, 1210},
  {1094, 1118, 1193},
  {1118, 1097, 1193},
  {1211, 1198, 1208},
  {1198, 1197, 1208},
  {1196, 1212, 1197},
  {1208, 1197, 1212},
  {1210, 1212, 1195},
  {1196, 1195, 1212},
  {1195, 1193, 1210},
  {1211, 1208, 1207},
  {1212, 1209, 1208},
  {1209, 1212, 1210},
  {1111, 1114, 1116},
  {1131, 1140, 1108},
  {1140, 1139, 1108},
  {1107, 1108, 1139},
  {1135, 1202, 1148},
  {1214, 1213, 1206},
  {1134, 1199, 1135},
  {1135, 1199, 1202},
  {1113, 1149, 1098},
  {1215, 1216, 1148},
  {1148, 1216, 1149},
  {1219, 1216, 1215},
  {1202, 1215, 1148},
  {1205, 1215, 1202},
  {1216, 1187, 1149},
  {1098, 1149, 1187},
  {1217, 1213, 1218},
  {1214, 1218, 1213},
  {1213, 1217, 1215},
  {1215, 1217, 1219},
  {1192, 1190, 1218},
  {1218, 1190, 1217},
  {1186, 1219, 1190},
  {1217, 1190, 1219},
  {1219, 1186, 1216},
  {1186, 1187, 1216},
  {1233, 1221,  969},
  {1220, 1221, 1233},
  {1222, 1223, 1220},
  {1223, 1221, 1220},
  {1223, 1222, 1224},
  {1225, 1224, 1222},
  {1226, 1224, 1227},
  {1224, 1225, 1227},
  {1227, 1228, 1226},
  {1229, 1226, 1228},
  {1229, 1228, 1230},
  {1228, 1231, 1230},
  {1232, 1230, 1231},
  {1222, 1220, 1234},
  {1233, 1234, 1220},
  {1225, 1222, 1235},
  {1222, 1234, 1235},
  {1227, 1225, 1236},
  {1235, 1236, 1225},
  {1227, 1236, 1228},
  {1236, 1237, 1228},
  {1237, 1238, 1228},
  {1231, 1228, 1238},
  {1192, 1218,  984},
  { 984, 1218,  993},
  {1198, 1211, 1226},
  {1224, 1226, 1211},
  {1207, 1223, 1211},
  {1224, 1211, 1223},
  {1207, 1191, 1223},
  {1221, 1223, 1191},
  {1192, 1221, 1191},
  {1192,  984, 1221},
  { 969, 1221,  984},
  {1239, 1233,  967},
  { 969,  967, 1233},
  {1240, 1241, 1235},
  {1236, 1235, 1241},
  {1235, 1234, 1240},
  {1242, 1240, 1234},
  {1233, 1243, 1234},
  {1242, 1234, 1243},
  {1243, 1233, 1239},
  {1232, 1204, 1230},
  {1230, 1204, 1201},
  {1238, 1237, 1244},
  {1244, 1237, 1245},
  {1198, 1226, 1229},
  {1230, 1201, 1229},
  {1241, 1246, 1236},
  {1246, 1245, 1236},
  {1237, 1236, 1245},
  { 351, 1247,  301},
  {1248,  301, 1247},
  {1248, 1247, 1250},
  {1249, 1250, 1247},
  {1250, 1249, 1252},
  {1250, 1252, 1251},
  {1251, 1252, 1253},
  {1253, 1252, 1254},
  {1253, 1254, 1256},
  {1256, 1254, 1255},
  {1257, 1258, 1255},
  {1258, 1256, 1255},
  { 314,  313, 1257},
  {1258, 1257,  313},
  {1264,  316, 1259},
  { 313,  317, 1260},
  {1261, 1797, 1251},
  {1251, 1797, 1799},
  {1916, 1263, 1251},
  {1916, 1262, 1263},
  {1264, 1263, 1262},
  {1263, 1264, 1259},
  { 999,  998, 1265},
  {1265,  998,  323},
  {1266, 1267,  351},
  {1268, 1267, 1266},
  {1278, 1270, 1268},
  {1267, 1268, 1270},
  {1271, 1269, 1274},
  {1269, 1270, 1274},
  {1271, 1274, 1275},
  {1276, 1271, 1275},
  {1272, 1271, 1276},
  { 996, 1271, 1272},
  { 999, 1265,  996},
  { 996, 1265, 1271},
  { 323,  314, 1265},
  { 314, 1257, 1265},
  {1267, 1247,  351},
  {1247, 1267, 1249},
  {1270, 1252, 1267},
  {1249, 1267, 1252},
  {1270, 1269, 1252},
  {1252, 1269, 1254},
  {1269, 1271, 1254},
  {1254, 1271, 1255},
  {1265, 1257, 1271},
  {1255, 1271, 1257},
  {1260, 1258,  313},
  {1261, 1256, 1260},
  {1258, 1260, 1256},
  {1256, 1261, 1253},
  {1253, 1261, 1251},
  {1263, 1250, 1251},
  {1250, 1263, 1248},
  {1248, 1263, 1259},
  { 301, 1248, 1259},
  {1272,  994,  996},
  {1270, 1273, 1274},
  {1277,  995,  994},
  {1276, 1277, 1272},
  {1272, 1277,  994},
  { 965,  976, 1280},
  {1281, 1282, 1280},
  {1282, 1281, 1283},
  {1277, 1283, 1281},
  {1277, 1284, 1283},
  {1285, 1283, 1284},
  {1285, 1284, 1286},
  {1284, 1287, 1286},
  {1288, 1286, 1289},
  {1289, 1286, 1287},
  {1289, 1290, 1288},
  {1288, 1290, 1291},
  {1290, 1279, 1291},
  { 995, 1281,  976},
  {1280,  976, 1281},
  {1273, 1279, 1290},
  {1274, 1273, 1289},
  {1273, 1290, 1289},
  {1287, 1275, 1289},
  {1289, 1275, 1274},
  {1287, 1284, 1275},
  {1276, 1275, 1284},
  {1276, 1284, 1277},
  {1281,  995, 1277},
  {1273, 1270, 1279},
  {1266,  351, 1292},
  {1292, 1295, 1266},
  {1266, 1295, 1268},
  {1296, 1268, 1295},
  {1268, 1296, 1278},
  {1270, 1278, 1279},
  {1294,  965, 1293},
  {1296, 1297, 1278},
  {1279, 1278, 1297},
  {1291, 1279, 1298},
  {1297, 1298, 1279},
  {1288, 1291, 1299},
  {1298, 1299, 1291},
  {1286, 1288, 1300},
  {1300, 1288, 1299},
  {1301, 1285, 1300},
  {1286, 1300, 1285},
  {1285, 1301, 1283},
  {1302, 1283, 1301},
  {1283, 1302, 1282},
  {1303, 1282, 1302},
  {1303, 1304, 1282},
  {1280, 1282, 1304},
  {1280, 1304,  965},
  {1293,  965, 1304},
  { 967,  965, 1239},
  { 965, 1294, 1239},
  {1305, 1294, 1293},
  {1306, 1305, 1304},
  {1293, 1304, 1305},
  {1295,  368, 1307},
  { 369, 1307,  368},
  {1304, 1303, 1306},
  {1308, 1306, 1303},
  {1308, 1303, 1302},
  {1301, 1309, 1302},
  {1302, 1309, 1308},
  {1310, 1309, 1300},
  {1301, 1300, 1309},
  {1300, 1299, 1310},
  {1299, 1311, 1310},
  {1312, 1311, 1298},
  {1299, 1298, 1311},
  {1298, 1297, 1312},
  {1313, 1312, 1297},
  {1314, 1313, 1296},
  {1297, 1296, 1313},
  {1315, 1314, 1295},
  {1295, 1314, 1296},
  {1295, 1307, 1315},
  {1316,  380, 1317},
  {1317,  380,  398},
  {1317, 1318, 1316},
  {1320, 1316, 1319},
  {1318, 1319, 1316},
  {1319, 1321, 1320},
  {1322, 1320, 1321},
  {1321, 1323, 1322},
  {1324, 1322, 1323},
  {1325, 1324, 1327},
  {1323, 1327, 1324},
  {1326, 1325, 1327},
  {1328, 1326, 1327},
  {1329, 1328, 1330},
  {1327, 1330, 1328},
  {1330, 1331, 1329},
  {1332, 1329, 1331},
  {1333, 1334, 1331},
  {1332, 1331, 1334},
  {1333, 1038, 1334},
  {1039, 1335, 1038},
  {1038, 1335, 1334},
  {  79, 1335, 1039},
  {1336, 1337,  398},
  {1338,  398, 1337},
  {1357, 1362, 1337},
  {1339, 1337, 1362},
  {1362, 1340, 1339},
  {1339, 1340, 1341},
  {1340, 1342, 1341},
  {1343, 1341, 1342},
  {1342, 1344, 1343},
  {1345, 1343, 1344},
  {1346, 1347, 1344},
  {1344, 1347, 1345},
  {1347, 1346, 1348},
  {1349, 1348, 1346},
  {1348, 1349, 1350},
  {1351, 1350, 1349},
  {1352, 1353, 1351},
  {1350, 1351, 1353},
  {1354, 1353, 1355},
  {1355, 1353, 1352},
  {1355, 1024, 1354},
  {1028, 1354, 1024},
  { 419,  460, 1356},
  {1394, 1356,  460},
  {1357, 1356, 1358},
  {1394, 1358, 1356},
  {1357, 1358, 1359},
  {1360, 1359, 1358},
  {1360, 1361, 1359},
  {1363, 1359, 1361},
  {1363, 1364, 1362},
  {1362, 1364, 1365},
  {1364, 1366, 1365},
  {1365, 1366, 1367},
  {1368, 1367, 1369},
  {1366, 1369, 1367},
  {1369, 1370, 1368},
  {1368, 1370, 1371},
  {1372, 1371, 1373},
  {1373, 1371, 1370},
  {1373, 1374, 1372},
  {1374, 1375, 1372},
  {1374, 1376, 1375},
  {1377, 1375, 1376},
  {1305, 1378, 1379},
  {1380, 1307,  446},
  { 369,  446, 1307},
  {1307, 1380, 1315},
  {1381, 1315, 1380},
  {1381, 1382, 1315},
  {1314, 1315, 1383},
  {1382, 1383, 1315},
  {1313, 1314, 1384},
  {1383, 1384, 1314},
  {1384, 1385, 1313},
  {1313, 1385, 1312},
  {1312, 1385, 1386},
  {1311, 1312, 1386},
  {1310, 1311, 1386},
  {1309, 1310, 1387},
  {1310, 1386, 1387},
  {1387, 1388, 1309},
  {1309, 1388, 1308},
  {1388, 1306, 1308},
  {1306, 1388, 1305},
  {1378, 1305, 1388},
  {1305, 1242, 1239},
  {1239, 1242, 1243},
  {1305, 1239, 1294},
  {1305, 1379, 1241},
  {1305, 1241, 1240},
  {1305, 1240, 1242},
  {1218, 1214,   32},
  {1204, 1232, 1389},
  {1390, 1389, 1232},
  {1204, 1389, 1206},
  {  32,  993, 1218},
  {1206, 1389,   32},
  {1214, 1206,   32},
  {1390, 1232, 1391},
  {1232, 1231, 1391},
  {1238, 1244, 1393},
  {1231, 1238, 1391},
  {1393, 1391, 1238},
  {1246, 1241, 1379},
  {1378, 1245, 1379},
  {1246, 1379, 1245},
  {1378, 1388, 1392},
  {1245, 1378, 1392},
  { 380, 1380,  446},
  {  32, 1389, 1335},
  {1334, 1335, 1389},
  {1389, 1390, 1334},
  {1391, 1334, 1390},
  {1334, 1391, 1332},
  {1393, 1332, 1391},
  {1329, 1332, 1244},
  {1244, 1332, 1393},
  {1392, 1328, 1244},
  {1244, 1328, 1329},
  {1326, 1328, 1392},
  {1326, 1392, 1325},
  {1392, 1388, 1325},
  {1324, 1325, 1388},
  {1388, 1387, 1324},
  {1387, 1386, 1324},
  {1386, 1322, 1324},
  {1320, 1322, 1386},
  {1386, 1385, 1320},
  {1385, 1384, 1320},
  {1316, 1320, 1384},
  {1384, 1383, 1316},
  {1316, 1383, 1382},
  { 380, 1316, 1381},
  {1382, 1381, 1316},
  { 380, 1381, 1380},
  {1317,  398, 1318},
  {1319, 1318,  398},
  { 398, 1338, 1319},
  {1321, 1319, 1338},
  {1338, 1337, 1321},
  {1337, 1339, 1321},
  {1323, 1321, 1339},
  {1339, 1341, 1323},
  {1343, 1323, 1341},
  {1343, 1345, 1323},
  {1327, 1323, 1345},
  {1347, 1327, 1345},
  {1348, 1327, 1347},
  {1350, 1330, 1348},
  {1327, 1348, 1330},
  {1330, 1350, 1331},
  {1331, 1350, 1353},
  {1331, 1353, 1333},
  {1333, 1353, 1354},
  {1354, 1028, 1333},
  {1333, 1028, 1038},
  {1028, 1030, 1038},
  { 398,  419, 1336},
  {1356, 1336,  419},
  {1357, 1337, 1356},
  {1336, 1356, 1337},
  {1357, 1359, 1362},
  {1363, 1362, 1359},
  {1362, 1365, 1340},
  {1342, 1340, 1365},
  {1365, 1367, 1342},
  {1342, 1367, 1344},
  {1367, 1368, 1344},
  {1346, 1344, 1368},
  {1368, 1371, 1346},
  {1349, 1346, 1371},
  {1351, 1349, 1372},
  {1372, 1349, 1371},
  {1352, 1351, 1375},
  {1351, 1372, 1375},
  {1375, 1377, 1352},
  {1355, 1352, 1377},
  {1377, 1018, 1355},
  {1024, 1355, 1018},
  { 996,  995,  976},
  { 988,  980,  981},
  {1244, 1245, 1392},
  {1395, 1358, 1394},
  {1358, 1395, 1360},
  {1360, 1395, 1396},
  {1397, 1361, 1396},
  {1360, 1396, 1361},
  {1398, 1363, 1397},
  {1363, 1361, 1397},
  {1363, 1398, 1364},
  {1364, 1398, 1366},
  {1399, 1366, 1398},
  {1369, 1366, 1416},
  {1399, 1416, 1366},
  {1416, 1409, 1369},
  {1369, 1409, 1370},
  {1409, 1400, 1370},
  {1373, 1370, 1400},
  {1374, 1373, 1401},
  {1400, 1401, 1373},
  {1376, 1374, 1003},
  {1003, 1374, 1401},
  {1394,  460, 1402},
  { 460,  470, 1402},
  {1403, 1394, 1402},
  {1404, 1395, 1403},
  {1394, 1403, 1395},
  {1405, 1396, 1404},
  {1395, 1404, 1396},
  {1396, 1405, 1397},
  {1406, 1397, 1405},
  {1407, 1398, 1406},
  {1397, 1406, 1398},
  {1398, 1407, 1408},
  {1408, 1399, 1398},
  {1417, 1400, 1409},
  {1401, 1400, 1410},
  {1417, 1410, 1400},
  {1003, 1401, 1411},
  {1411, 1401, 1410},
  {1411, 1001, 1003},
  {1376, 1017, 1377},
  {1377, 1017, 1018},
  {1008, 1376, 1003},
  {1376, 1008, 1017},
  {1412,  470,  481},
  { 470, 1412, 1402},
  {1402, 1412, 1403},
  {1413, 1403, 1412},
  {1403, 1413, 1404},
  {1414, 1404, 1413},
  {1415, 1405, 1414},
  {1404, 1414, 1405},
  {1405, 1415, 1406},
  {1425, 1406, 1415},
  {1406, 1425, 1407},
  {1407, 1425, 1408},
  {1416, 1399, 1408},
  {1417, 1409, 1416},
  {1417, 1418, 1410},
  {1418, 1419, 1410},
  {1410, 1419, 1411},
  {1000, 1001, 1419},
  {1411, 1419, 1001},
  { 481,  490, 1412},
  {1412,  490, 1420},
  {1413, 1412, 1421},
  {1420, 1421, 1412},
  {1414, 1413, 1422},
  {1413, 1421, 1422},
  {1422, 1423, 1414},
  {1415, 1414, 1423},
  {1423, 1424, 1415},
  {1415, 1424, 1425},
  {1425, 1426, 1408},
  {1426, 1427, 1408},
  {1427, 1428, 1408},
  {1408, 1428, 1416},
  {1417, 1416, 1429},
  {1429, 1416, 1428},
  {1429, 1430, 1417},
  {1430, 1418, 1417},
  {1419, 1418, 1431},
  {1431, 1418, 1430},
  {1432, 1419, 1431},
  {1433,  490,  504},
  {1420,  490, 1434},
  {1433, 1434,  490},
  {1421, 1420, 1435},
  {1434, 1435, 1420},
  {1422, 1421, 1436},
  {1435, 1436, 1421},
  {1423, 1422, 1437},
  {1436, 1437, 1422},
  {1437, 1438, 1423},
  {1424, 1423, 1438},
  {1425, 1424, 1439},
  {1439, 1424, 1438},
  {1439, 1440, 1425},
  {1440, 1426, 1425},
  {1426, 1440, 1427},
  {1428, 1427, 1440},
  {1441, 1429, 1440},
  {1428, 1440, 1429},
  {1429, 1441, 1430},
  {1430, 1441, 1442},
  {1430, 1442, 1431},
  {1431, 1442, 1443},
  {1444, 1432, 1443},
  {1431, 1443, 1432},
  {1432, 1444, 1152},
  {1156, 1152, 1444},
  {1445,  517,  518},
  {1446, 1447, 1445},
  {1447, 1446, 1448},
  {1449, 1448, 1446},
  {1450, 1448, 1451},
  {1449, 1451, 1448},
  {1450, 1451, 1452},
  {1453, 1452, 1451},
  {1452, 1453, 1454},
  {1454, 1453, 1455},
  {1455, 1456, 1454},
  {1457, 1456, 1458},
  {1458, 1459, 1457},
  {1459, 1460, 1457},
  {1461, 1460, 1462},
  {1459, 1462, 1460},
  {1463, 1464, 1462},
  {1461, 1462, 1464},
  {1477, 1465, 1463},
  {1464, 1463, 1465},
  {1465, 1477, 1466},
  {1478, 1466, 1477},
  {1466, 1478, 1156},
  {1161, 1156, 1478},
  {1467, 1445,  542},
  { 518,  542, 1445},
  {1445, 1467, 1446},
  {1468, 1446, 1467},
  {1446, 1468, 1449},
  {1451, 1449, 1469},
  {1468, 1469, 1449},
  {1451, 1469, 1453},
  {1470, 1453, 1469},
  {1455, 1453, 1471},
  {1470, 1471, 1453},
  {1471, 1472, 1455},
  {1456, 1455, 1472},
  {1472, 1473, 1456},
  {1458, 1456, 1473},
  {1474, 1459, 1473},
  {1458, 1473, 1459},
  {1459, 1474, 1462},
  {1475, 1462, 1474},
  {1462, 1475, 1463},
  {1476, 1463, 1475},
  {1463, 1476, 1477},
  {1467,  542, 1479},
  { 554, 1479,  542},
  {1467, 1479, 1468},
  {1480, 1468, 1479},
  {1468, 1480, 1469},
  {1480, 1481, 1469},
  {1469, 1481, 1470},
  {1482, 1470, 1481},
  {1471, 1470, 1483},
  {1470, 1482, 1483},
  {1472, 1471, 1484},
  {1483, 1484, 1471},
  {1473, 1472, 1078},
  {1484, 1078, 1472},
  {1078, 1485, 1473},
  {1474, 1473, 1485},
  {1475, 1474, 1486},
  {1486, 1474, 1485},
  {1486, 1085, 1475},
  {1476, 1475, 1085},
  {1466, 1444, 1465},
  {1443, 1465, 1444},
  {1465, 1443, 1464},
  {1442, 1464, 1443},
  {1464, 1442, 1461},
  {1441, 1461, 1442},
  {1461, 1441, 1460},
  {1440, 1460, 1441},
  {1457, 1460, 1440},
  {1456, 1457, 1440},
  {1454, 1456, 1439},
  {1440, 1439, 1456},
  {1452, 1454, 1438},
  {1439, 1438, 1454},
  {1438, 1437, 1452},
  {1450, 1452, 1437},
  {1437, 1436, 1450},
  {1436, 1448, 1450},
  {1436, 1435, 1448},
  {1447, 1448, 1435},
  {1434, 1445, 1435},
  {1447, 1435, 1445},
  {1009, 1432, 1152},
  {1432, 1005, 1419},
  {1000, 1419, 1005},
  {1432, 1009, 1005},
  { 351,  368, 1292},
  { 368, 1295, 1292},
  {1156, 1161, 1157},
  {1444, 1466, 1156},
  {1161, 1159, 1157},
  {1175, 1053, 1172},
  {1053, 1040, 1172},
  {1040, 1153, 1172},
  {1174, 1180, 1176},
  {1515, 1487, 1488},
  {1489, 1490, 1515},
  {1516, 1515, 1490},
  {1509, 1491, 1489},
  {1490, 1489, 1491},
  {1492, 1515, 1488},
  {1493, 1494, 1492},
  {1495, 1494, 1493},
  {1496, 1497, 1498},
  {1499, 1498, 1497},
  {1500, 1499, 1501},
  {1501, 1499, 1497},
  {1501, 1502, 1500},
  {1503, 1500, 1502},
  {1502, 1501, 1504},
  {1505, 1504, 1501},
  {1501, 1497, 1505},
  {1506, 1505, 1497},
  {1497, 1496, 1506},
  {1506, 1496, 1536},
  {1499, 1500, 1538},
  {1538, 1507, 1499},
  {1498, 1499, 1507},
  {1508, 1509, 1507},
  {1510, 1507, 1509},
  {1511, 1506, 1512},
  {1506, 1536, 1512},
  {1505, 1506, 1513},
  {1513, 1506, 1511},
  {1513, 1504, 1505},
  {1498, 1507, 1514},
  {1489, 1510, 1509},
  {1516, 1487, 1515},
  {1517, 1493, 1518},
  {1492, 1518, 1493},
  {1517, 1519, 1493},
  {1495, 1493, 1519},
  {1512, 1495, 1520},
  {1495, 1519, 1520},
  {1504, 1513, 1521},
  {1513, 1522, 1521},
  {1511, 1512, 1523},
  {1520, 1523, 1512},
  {1522, 1513, 1523},
  {1511, 1523, 1513},
  {1524, 1519, 1525},
  {1517, 1525, 1519},
  {1526, 1520, 1524},
  {1524, 1520, 1519},
  {1527, 1523, 1526},
  {1520, 1526, 1523},
  {1523, 1527, 1522},
  {1528, 1522, 1527},
  {1522, 1528, 1521},
  {1529, 1521, 1528},
  {1521, 1529, 1530},
  {1531, 1530, 1529},
  {1532, 1525, 1518},
  {1525, 1517, 1518},
  {1518, 1533, 1532},
  {1532, 1533, 1534},
  {1510, 1489, 1514},
  {1514, 1489, 1515},
  {1535, 1496, 1514},
  {1498, 1514, 1496},
  {1514, 1515, 1535},
  {1535, 1515, 1536},
  {1496, 1535, 1536},
  {1512, 1536, 1495},
  {1495, 1536, 1494},
  {1515, 1492, 1536},
  {1494, 1536, 1492},
  {1488, 1518, 1492},
  {1518, 1488, 1533},
  {1508, 1537, 1509},
  {1507, 1538, 1508},
  {1503, 1539, 1500},
  {1540, 1541, 1539},
  {1539, 1541, 1500},
  {1500, 1541, 1538},
  {1540, 1542, 1541},
  {1543, 1541, 1542},
  {1541, 1543, 1538},
  {1538, 1543, 1544},
  {1537, 1508, 1544},
  {1544, 1508, 1538},
  {1545, 1524, 1525},
  {1532, 1545, 1525},
  {1524, 1545, 1546},
  {1546, 1545, 1547},
  {1509, 1546, 1547},
  {1545, 1548, 1547},
  {1548, 1491, 1547},
  {1526, 1524, 1549},
  {1546, 1549, 1524},
  {1537, 1549, 1509},
  {1546, 1509, 1549},
  {1527, 1526, 1550},
  {1549, 1550, 1526},
  {1550, 1549, 1544},
  {1537, 1544, 1549},
  {1548, 1545, 1534},
  {1532, 1534, 1545},
  {1528, 1527, 1550},
  {1528, 1550, 1529},
  {1543, 1550, 1544},
  {1550, 1531, 1529},
  {1550, 1543, 1531},
  {1542, 1531, 1543},
  {1540, 1530, 1542},
  {1531, 1542, 1530},
  {1502, 1504, 1530},
  {1521, 1530, 1504},
  {1507, 1510, 1514},
  {1530, 1540, 1502},
  {1540, 1539, 1502},
  {1503, 1502, 1539},
  {1509, 1547, 1491},
  {1516, 1490, 1164},
  {1488, 1168, 1533},
  {1533, 1168, 1185},
  {1168, 1488, 1167},
  {1487, 1167, 1488},
  {1164, 1167, 1516},
  {1487, 1516, 1167},
  {1491, 1164, 1490},
  {1533, 1185, 1534},
  {1534, 1185, 1548},
  {1185, 1180, 1548},
  {1548, 1180, 1491},
  {1083, 1161, 1087},
  {1478, 1087, 1161},
  {1476, 1085, 1477},
  {1088, 1477, 1085},
  {1477, 1088, 1478},
  {1087, 1478, 1088},
  {1085, 1486, 1086},
  {1089, 1483, 1090},
  {1482, 1090, 1483},
  {1484, 1483, 1077},
  {1089, 1077, 1483},
  {1078, 1484, 1076},
  {1077, 1076, 1484},
  {1078, 1086, 1485},
  {1486, 1485, 1086},
  { 125, 1090,  626},
  {1090, 1482,  626},
  {1479,  554,  625},
  { 625,  626, 1479},
  {1480, 1479,  626},
  {1481, 1480,  626},
  {1481,  626, 1482},
  {1553, 1554, 1555},
  {1555, 1554, 1556},
  {1555, 1556, 1557},
  {1557, 1556, 1558},
  {1557, 1558, 1559},
  {1552, 1563, 1553},
  {1563, 1560, 1553},
  {1553, 1560, 1554},
  {1560, 1561, 1554},
  {1554, 1561, 1556},
  {1561, 1562, 1556},
  {1556, 1562, 1558},
  {1562, 1603, 1558},
  {1551, 1567, 1552},
  {1552, 1567, 1563},
  {1563, 1564, 1560},
  {1560, 1564, 1561},
  {1561, 1570, 1562},
  {1562, 1570, 1565},
  {1562, 1565, 1603},
  {1551, 1566, 1567},
  {1567, 1568, 1563},
  {1563, 1568, 1564},
  {1564, 1568, 1569},
  {1564, 1569, 1561},
  {1561, 1569, 1570},
  {1570, 1571, 1565},
  {1566, 1572, 1567},
  {1567, 1572, 1573},
  {1567, 1573, 1568},
  {1568, 1573, 1574},
  {1568, 1574, 1569},
  {1569, 1574, 1575},
  {1569, 1575, 1570},
  {1570, 1575, 1576},
  {1570, 1576, 1571},
  {1566, 1577, 1578},
  {1566, 1578, 1572},
  {1572, 1578, 1579},
  {1572, 1579, 1573},
  {1573, 1579, 1580},
  {1573, 1580, 1574},
  {1574, 1580, 1581},
  {1574, 1581, 1575},
  {1575, 1581, 1582},
  {1575, 1582, 1576},
  {1577, 1583, 1584},
  {1577, 1584, 1578},
  {1578, 1584, 1585},
  {1578, 1585, 1579},
  {1579, 1585, 1586},
  {1579, 1586, 1580},
  {1580, 1586, 1591},
  {1580, 1591, 1581},
  {1581, 1591, 1587},
  {1581, 1587, 1582},
  {1583, 1593, 1588},
  {1583, 1588, 1584},
  {1584, 1588, 1589},
  {1584, 1589, 1585},
  {1585, 1589, 1590},
  {1585, 1590, 1586},
  {1586, 1590, 1591},
  {1591, 1592, 1587},
  {1593, 1594, 1588},
  {1588, 1594, 1595},
  {1588, 1595, 1589},
  {1589, 1595, 1596},
  {1589, 1596, 1590},
  {1590, 1596, 1597},
  {1590, 1597, 1591},
  {1591, 1597, 1598},
  {1591, 1598, 1592},
  {1593, 1599, 1594},
  {1594, 1599, 1595},
  {1599, 1600, 1595},
  {1600, 1601, 1595},
  {1595, 1601, 1596},
  {1601, 1602, 1596},
  {1596, 1602, 1597},
  {1602, 1603, 1597},
  {1597, 1603, 1598},
  {1603, 1604, 1598},
  {1605, 1606, 1607},
  {1608, 1607, 1606},
  {1609,  628, 1605},
  {1605,  628, 1606},
  {1610,  630, 1609},
  { 628, 1609,  630},
  {1611,  632, 1610},
  { 632,  630, 1610},
  {1612,  634, 1611},
  { 632, 1611,  634},
  {1613,  636, 1612},
  { 634, 1612,  636},
  {1607, 1614, 1605},
  {1614, 1615, 1605},
  {1616, 1609, 1615},
  {1605, 1615, 1609},
  {1617, 1610, 1616},
  {1609, 1616, 1610},
  {1618, 1611, 1617},
  {1610, 1617, 1611},
  {1619, 1612, 1618},
  {1618, 1612, 1611},
  {1620, 1613, 1619},
  {1612, 1619, 1613},
  {1614, 1621, 1615},
  {1622, 1615, 1621},
  {1623, 1616, 1622},
  {1615, 1622, 1616},
  {1624, 1617, 1623},
  {1616, 1623, 1617},
  {1625, 1618, 1624},
  {1617, 1624, 1618},
  {1626, 1619, 1625},
  {1618, 1625, 1619},
  {1619, 1626, 1620},
  {1621, 1627, 1622},
  {1628, 1623, 1627},
  {1622, 1627, 1623},
  {1629, 1624, 1628},
  {1623, 1628, 1624},
  {1630, 1625, 1629},
  {1625, 1624, 1629},
  {1631, 1626, 1630},
  {1630, 1626, 1625},
  {1632, 1633, 1621},
  {1621, 1633, 1627},
  {1634, 1628, 1633},
  {1627, 1633, 1628},
  {1635, 1629, 1634},
  {1628, 1634, 1629},
  {1636, 1630, 1635},
  {1629, 1635, 1630},
  {1637, 1631, 1636},
  {1630, 1636, 1631},
  {1633, 1632, 1638},
  {1639, 1638, 1632},
  { 653, 1634, 1638},
  {1633, 1638, 1634},
  { 654, 1635,  653},
  {1634,  653, 1635},
  { 518, 1636,  654},
  {1635,  654, 1636},
  { 655, 1637,  518},
  {1636,  518, 1637},
  {1638, 1639, 1640},
  {1641, 1640, 1639},
  {1642, 1643, 1641},
  {1641, 1643, 1640},
  {1643,  645, 1640},
  {1644, 1645, 1642},
  {1642, 1645, 1643},
  {1646, 1606, 1644},
  {1606, 1645, 1644},
  {1646, 1608, 1606},
  {1632, 1621, 1551},
  {1614, 1577, 1566},
  {1614, 1566, 1551},
  {1621, 1614, 1551},
  {1607, 1608, 1577},
  {1644, 1642, 1593},
  {1644, 1593, 1583},
  {1646, 1644, 1583},
  {1608, 1583, 1577},
  {1593, 1641, 1639},
  {1593, 1642, 1641},
  {1632, 1551, 1647},
  {1647, 1593, 1639},
  {1551, 1552, 1553},
  {1600, 1599, 1557},
  {1647, 1551, 1553},
  {1647, 1553, 1555},
  {1647, 1555, 1557},
  {1593, 1647, 1557},
  {1599, 1593, 1557},
  {1602, 1558, 1603},
  {1602, 1601, 1600},
  {1600, 1557, 1559},
  {1600, 1559, 1558},
  {1602, 1600, 1558},
  {1576, 1587, 1571},
  {1604, 1603, 1565},
  {1604, 1565, 1571},
  {1598, 1604, 1571},
  {1592, 1598, 1571},
  {1587, 1592, 1571},
  {1576, 1582, 1587},
  {1614, 1607, 1577},
  {1608, 1646, 1583},
  {1647, 1639, 1632},
  {1626, 1433, 1620},
  {1613,  504,  636},
  { 504, 1613, 1620},
  {1433,  504, 1620},
  {1626, 1445, 1433},
  {1445, 1434, 1433},
  {1044, 1043, 1648},
  {1045, 1662, 1043},
  {1648, 1043, 1662},
  {1045, 1046, 1662},
  {1046, 1649, 1662},
  {1048, 1649, 1046},
  {1048, 1060, 1649},
  {1649, 1060, 1650},
  {1061, 1651, 1060},
  {1650, 1060, 1651},
  {1062, 1652, 1061},
  {1651, 1061, 1652},
  {1044, 1648, 1062},
  {1652, 1062, 1648},
  {1049, 1653, 1050},
  {1665, 1050, 1653},
  {1051, 1672, 1049},
  {1653, 1049, 1672},
  {1051, 1052, 1672},
  {1054, 1672, 1052},
  {1654, 1054, 1057},
  {1057, 1055, 1654},
  {1055, 1058, 1654},
  {1655, 1654, 1058},
  {1059, 1656, 1058},
  {1655, 1058, 1656},
  {1050, 1665, 1059},
  {1656, 1059, 1665},
  {1652, 1657, 1651},
  {1658, 1651, 1657},
  {1651, 1658, 1650},
  {1659, 1650, 1658},
  {1649, 1650, 1660},
  {1660, 1650, 1659},
  {1661, 1649, 1660},
  {1662, 1649, 1661},
  {1662, 1663, 1648},
  {1664, 1648, 1663},
  {1648, 1664, 1652},
  {1657, 1652, 1664},
  {1666, 1656, 1665},
  {1656, 1666, 1655},
  {1667, 1655, 1666},
  {1654, 1655, 1668},
  {1667, 1668, 1655},
  {1668, 1669, 1654},
  {1054, 1654, 1670},
  {1670, 1654, 1669},
  {1670, 1671, 1054},
  {1671, 1672, 1054},
  {1653, 1672, 1673},
  {1653, 1673, 1665},
  {1674, 1664, 1663},
  {1674, 1663, 1662},
  {1674, 1662, 1661},
  {1674, 1661, 1660},
  {1674, 1660, 1659},
  {1674, 1659, 1658},
  {1674, 1658, 1657},
  {1674, 1657, 1664},
  {1675, 1665, 1673},
  {1675, 1673, 1672},
  {1675, 1672, 1671},
  {1675, 1671, 1670},
  {1675, 1670, 1669},
  {1675, 1669, 1668},
  {1675, 1668, 1667},
  {1675, 1667, 1666},
  {1675, 1666, 1665},
  {1677, 1676, 1678},
  {1679, 1678, 1676},
  {1689, 1687, 1678},
  {1677, 1678, 1687},
  {1689, 1678, 1688},
  {1679, 1688, 1678},
  {1680, 1688, 1679},
  {1681, 1680, 1676},
  {1679, 1676, 1680},
  {1682, 1681, 1677},
  {1677, 1681, 1676},
  {1686, 1682, 1677},
  {1683, 1684, 1682},
  {1681, 1682, 1684},
  {1677, 1685, 1686},
  {1681, 1684, 1680},
  {1688, 1680, 1684},
  {1700, 1699, 1688},
  {1699, 1689, 1688},
  {1690, 1685, 1691},
  {1685, 1687, 1691},
  {1687, 1692, 1691},
  {1689, 1692, 1687},
  {1686, 1685, 1693},
  {1693, 1685, 1694},
  {1693, 1695, 1686},
  {1686, 1695, 1683},
  {1696, 1695, 1708},
  {1693, 1708, 1695},
  {1707, 1708, 1694},
  {1693, 1694, 1708},
  {1707, 1694, 1697},
  {1690, 1697, 1694},
  {1697, 1690, 1691},
  {1692, 1698, 1691},
  {1689, 1699, 1692},
  {1698, 1692, 1699},
  {1688, 1684, 1700},
  {1700, 1684, 1683},
  {1683, 1703, 1700},
  {1691, 1698, 1704},
  {1705, 1704, 1698},
  {1697, 1691, 1706},
  {1704, 1706, 1691},
  {1697, 1706, 1707},
  {1696, 1708, 1709},
  {1709, 1710, 1696},
  {1696, 1710, 1683},
  {1703, 1683, 1710},
  {1708, 1711, 1709},
  {1711, 1712, 1709},
  {1713, 1711, 1707},
  {1707, 1711, 1708},
  {1714, 1713, 1706},
  {1713, 1707, 1706},
  {1704, 1715, 1706},
  {1714, 1706, 1715},
  {1715, 1704, 1705},
  {1716, 1717, 1714},
  {1714, 1717, 1713},
  {1716, 1714, 1718},
  {1714, 1715, 1718},
  {1715, 1705, 1718},
  {1725, 1705, 1701},
  {1725, 1701, 1699},
  {1702, 1719, 1699},
  {1699, 1719, 1725},
  {1719, 1702, 1720},
  {1720, 1702, 1699},
  {1721, 1720, 1700},
  {1699, 1700, 1720},
  {1728, 1721, 1700},
  {1703, 1728, 1700},
  {1728, 1703, 1722},
  {1722, 1703, 1710},
  {1712, 1723, 1710},
  {1722, 1710, 1723},
  {1723, 1712, 1920},
  {1712, 1711, 1724},
  {1920, 1712, 1724},
  { 737, 1718,  733},
  {1705,  733, 1718},
  { 733, 1705, 1725},
  {1726, 1725, 1719},
  {1720, 1727, 1719},
  {1728, 1722, 1723},
  {1920, 1738, 1723},
  {1728, 1723, 1738},
  { 737, 1729, 1716},
  {1717, 1716, 1729},
  {1724, 1717, 1729},
  {1724, 1729, 1730},
  {1731, 1724, 1730},
  {1920, 1724, 1731},
  {1721, 1727, 1720},
  {1727, 1721, 1732},
  {1728, 1732, 1721},
  {1733,  743, 1726},
  {1726,  743, 1725},
  {1733,  744,  743},
  {1733,  746,  744},
  {1726,  746, 1733},
  {1726, 1719,  746},
  {1719, 1727,  746},
  {1734,  746, 1727},
  {1784, 1734, 1727},
  {1784, 1727, 1735},
  {1735, 1727, 1732},
  {1728, 1736, 1732},
  {1732, 1736, 1735},
  {1736, 1728, 1737},
  {1740, 1739,  746},
  { 746, 1734, 1740},
  {1734, 1784, 1740},
  {1741, 1743, 1742},
  {1742, 1743, 1775},
  { 762, 1739, 1745},
  {1745, 1739, 1741},
  {1740, 1741, 1739},
  {1741, 1740, 1743},
  {1784, 1743, 1740},
  {1746, 1745, 1744},
  { 760,  762, 1747},
  {1747,  762, 1746},
  {1747, 1746, 1748},
  {1746, 1744, 1748},
  {1741, 1744, 1745},
  {1744, 1741, 1749},
  {1750, 1744, 1749},
  {1751, 1748, 1750},
  {1744, 1750, 1748},
  {1748, 1752, 1747},
  {1747, 1752,  760},
  { 768,  760, 1752},
  {1751, 1752, 1748},
  {1752, 1753,  768},
  {1755, 1753, 1754},
  {1754, 1753, 1756},
  {1757, 1758, 1759},
  {1759, 1758, 1760},
  {1761, 1760, 1758},
  {1762, 1763, 1756},
  {1763, 1757, 1756},
  {1759, 1754, 1757},
  {1756, 1757, 1754},
  {1781, 1755, 1759},
  {1754, 1759, 1755},
  {1759, 1760, 1781},
  {1764, 1781, 1760},
  {1758, 1757, 1765},
  {1763, 1765, 1757},
  {1775, 1758, 1766},
  {1765, 1766, 1758},
  {1775, 1766, 1742},
  {1742, 1766, 1767},
  {1742, 1767, 1741},
  {1741, 1767, 1749},
  {1763, 1762, 1768},
  {1765, 1763, 1769},
  {1768, 1769, 1763},
  {1767, 1766, 1770},
  {1770, 1766, 1771},
  {1749, 1767, 1770},
  {1750, 1749, 1770},
  {1751, 1750, 1771},
  {1770, 1771, 1750},
  {1769, 1751, 1771},
  {1752, 1751, 1768},
  {1769, 1768, 1751},
  {1760, 1773, 1764},
  {1773, 1772, 1764},
  {1774, 1772, 1773},
  {1758, 1775, 1761},
  {1743, 1776, 1775},
  {1774, 1776, 1743},
  {1777, 1775, 1776},
  {1775, 1777, 1773},
  {1776, 1774, 1777},
  {1773, 1777, 1774},
  {1784, 1774, 1743},
  {1784, 1778, 1774},
  {1764, 1772, 1779},
  {1780, 1779, 1772},
  {1781, 1764, 1779},
  {1780, 1778, 1782},
  {1782, 1779, 1780},
  {1781, 1779, 1783},
  {1778, 1784, 1782},
  {1755, 1785, 1753},
  {1783, 1785, 1781},
  {1781, 1785, 1755},
  {1786,  802, 1783},
  {1785, 1783,  802},
  {1783, 1779, 1786},
  {1786, 1779, 1782},
  {1788,  805, 1787},
  {1782,  805, 1786},
  {1787,  805, 1782},
  {1788, 1787, 1784},
  {1782, 1784, 1787},
  {1790, 1788, 1789},
  {1784, 1791, 1788},
  {1789, 1788, 1791},
  {1790, 1789, 1791},
  {1735, 1791, 1784},
  {1736, 1792, 1735},
  {1792, 1793, 1735},
  {1793, 1791, 1735},
  {1790, 1791, 1793},
  {1792, 1736, 1794},
  {1737, 1794, 1736},
  {1794, 1795, 1792},
  {1793, 1792, 1795},
  {1793, 1795, 1790},
  { 317, 1790, 1796},
  {1796, 1790, 1795},
  {1795, 1794, 1797},
  {1798, 1797, 1794},
  {1797, 1798, 1799},
  {1798, 1800, 1799},
  {1798, 1728, 1800},
  {1801, 1800, 1728},
  {1802, 1801, 1728},
  {1728, 1738, 1802},
  {1803, 1801, 1802},
  {1801, 1803, 1800},
  {1799, 1800, 1803},
  {1718,  737, 1716},
  {1725,  743,  733},
  {1746,  762, 1745},
  { 823, 1807, 1805},
  {1806, 1805, 1807},
  {1807, 1808, 1806},
  {1807,  823, 1809},
  { 823,  828, 1809},
  {1808, 1807, 1809},
  {1808, 1809, 1810},
  {1811, 1810, 1809},
  {1808, 1810, 1806},
  {1806, 1810, 1821},
  {1812, 1813, 1811},
  {1810, 1811, 1813},
  {1810, 1813, 1821},
  {1814, 1821, 1813},
  {1812, 1815, 1813},
  {1813, 1815, 1814},
  {1812, 1816, 1815},
  {1816, 1818, 1815},
  {1816, 1817, 1818},
  {1817, 1819, 1818},
  {1820, 1818, 1819},
  {1729,  737,  840},
  {1729,  840, 1805},
  {1805,  840,  823},
  {1729, 1805, 1806},
  {1818, 1830, 1815},
  {1818, 1833, 1830},
  {1833, 1818, 1820},
  {1833, 1820, 1836},
  {1822, 1836, 1820},
  {1819, 1823, 1820},
  {1822, 1820, 1823},
  {1823, 1819, 1824},
  {1823, 1825, 1822},
  {1824, 1825, 1823},
  {1836, 1822, 1826},
  {1825, 1826, 1822},
  {1826, 1825, 1873},
  {1826, 1873, 1827},
  {1729, 1806, 1821},
  {1730, 1729, 1821},
  {1821, 1814, 1730},
  {1828, 1730, 1814},
  {1828, 1814, 1829},
  {1815, 1829, 1814},
  {1829, 1815, 1830},
  {1845, 1831, 1829},
  {1831, 1828, 1829},
  {1831, 1730, 1828},
  {1845, 1829, 1832},
  {1830, 1832, 1829},
  {1832, 1830, 1834},
  {1833, 1834, 1830},
  {1834, 1833, 1835},
  {1835, 1833, 1836},
  {1838, 1836, 1837},
  {1826, 1837, 1836},
  {1839, 1835, 1840},
  {1840, 1835, 1836},
  {1840, 1836, 1841},
  {1836, 1838, 1841},
  {1841, 1838, 1842},
  {1835, 1839, 1834},
  {1843, 1834, 1839},
  {1844, 1832, 1843},
  {1834, 1843, 1832},
  {1844, 1845, 1832},
  {1831, 1845, 1846},
  {1847, 1831, 1846},
  {1838, 1827, 1842},
  {1861, 1841, 1862},
  {1842, 1862, 1841},
  {1848, 1840, 1861},
  {1841, 1861, 1840},
  {1840, 1848, 1839},
  {1849, 1839, 1848},
  {1839, 1849, 1843},
  {1844, 1843, 1850},
  {1851, 1845, 1850},
  {1844, 1850, 1845},
  {1827, 1862, 1842},
  {1852, 1846, 1851},
  {1845, 1851, 1846},
  {1846, 1852, 1847},
  {1858, 1847, 1852},
  {1850, 1843, 1853},
  {1854, 1853, 1843},
  {1843, 1849, 1854},
  {1855, 1854, 1848},
  {1849, 1848, 1854},
  {1853, 1856, 1850},
  {1851, 1850, 1856},
  {1856, 1857, 1851},
  {1857, 1852, 1851},
  {1858, 1852, 1857},
  {1859, 1858, 1857},
  {1858, 1859, 1860},
  {1848, 1861, 1855},
  { 828,  883, 1809},
  {1863, 1809,  883},
  {1859, 1809, 1863},
  {1864, 1811, 1859},
  {1809, 1859, 1811},
  {1811, 1864, 1812},
  {1857, 1812, 1864},
  {1824, 1819, 1865},
  {1866, 1865, 1819},
  {1819, 1817, 1866},
  {1867, 1866, 1817},
  {1868, 1867, 1816},
  {1817, 1816, 1867},
  {1857, 1869, 1812},
  {1870, 1871, 1859},
  {1860, 1859, 1871},
  {1871, 1870,  893},
  { 893, 1870,  883},
  {1870, 1863,  883},
  {1870, 1859, 1863},
  {1857, 1864, 1859},
  {1869, 1868, 1812},
  {1816, 1812, 1868},
  {1856, 1869, 1857},
  {1856, 1853, 1869},
  {1868, 1869, 1853},
  {1854, 1867, 1853},
  {1868, 1853, 1867},
  {1867, 1854, 1866},
  {1865, 1872, 1824},
  {1872, 1825, 1824},
  {1825, 1872, 1873},
  {1866, 1854, 1865},
  {1855, 1865, 1854},
  {1865, 1855, 1872},
  {1861, 1872, 1855},
  {1872, 1861, 1873},
  {1862, 1873, 1861},
  {1827, 1873, 1862},
  { 895, 1874,  893},
  {1871,  893, 1874},
  {1874, 1878, 1871},
  {1875, 1871, 1878},
  {1858, 1860, 1875},
  {1875, 1860, 1871},
  {1876, 1875, 1877},
  {1877, 1875, 1878},
  {1882, 1878, 1879},
  {1847, 1858, 1876},
  {1875, 1876, 1858},
  {1877, 1880, 1876},
  {1876, 1880, 1847},
  {1880, 1877, 1881},
  {1878, 1881, 1877},
  {1878, 1882, 1881},
  {1883, 1889, 1880},
  {1889, 1847, 1880},
  {1881, 1884, 1880},
  {1883, 1880, 1884},
  {1884, 1881, 1885},
  {1885, 1881, 1882},
  {1886, 1831, 1847},
  {1889, 1887, 1847},
  {1886, 1847, 1887},
  {1890, 1888, 1883},
  {1889, 1883, 1888},
  {1890, 1883, 1903},
  {1884, 1903, 1883},
  {1895, 1889, 1888},
  {1895, 1888, 1891},
  {1891, 1888, 1890},
  {1892, 1897, 1893},
  {1902, 1893, 1897},
  {1895, 1891, 1894},
  {1894, 1891, 1902},
  {1897, 1894, 1902},
  {1896, 1895, 1894},
  {1894, 1897, 1896},
  {1892, 1898, 1897},
  {1899, 1900, 1892},
  {1898, 1892, 1900},
  {1901, 1900, 1899},
  {1890, 1902, 1891},
  {1885, 1903, 1884},
  {1890, 1903, 1904},
  {1890, 1904, 1902},
  {1902, 1904, 1905},
  {1893, 1902, 1905},
  {1899, 1892, 1893},
  {1906, 1907, 1905},
  {1893, 1905, 1907},
  {1899, 1893, 1907},
  {1908, 1901, 1899},
  {1907, 1909, 1899},
  {1899, 1909, 1908},
  {1909, 1907, 1910},
  {1906, 1910, 1907},
  {1910, 1906, 1911},
  {1912, 1911, 1906},
  {1906, 1905, 1912},
  {1904, 1912, 1905},
  {1879, 1913, 1882},
  {1914, 1882, 1913},
  {1915, 1913, 1916},
  {1915, 1914, 1913},
  {1912, 1904, 1917},
  {1903, 1917, 1904},
  {1903, 1885, 1917},
  {1917, 1885, 1914},
  {1882, 1914, 1885},
  {1915, 1917, 1914},
  {1915, 1918, 1917},
  {1911, 1912, 1918},
  {1918, 1912, 1917},
  {1731, 1730, 1831},
  {1920, 1731, 1919},
  {1731, 1831, 1919},
  {1921, 1900, 1922},
  {1901, 1922, 1900},
  {1938, 1921, 1922},
  {1923, 1898, 1921},
  {1898, 1900, 1921},
  {1929, 1923, 1938},
  {1921, 1938, 1923},
  {1831, 1924, 1919},
  {1925, 1926, 1924},
  {1887, 1831, 1886},
  {1889, 1831, 1887},
  {1924, 1831, 1889},
  {1895, 1924, 1889},
  {1920, 1919, 1924},
  {1924, 1895, 1925},
  {1927, 1925, 1895},
  {1927, 1895, 1928},
  {1928, 1895, 1896},
  {1928, 1896, 1897},
  {1897, 1898, 1928},
  {1898, 1923, 1928},
  {1928, 1923, 1929},
  {1933, 1927, 1928},
  {1932, 1925, 1933},
  {1927, 1933, 1925},
  {1928, 1929, 1930},
  {1926, 1931, 1924},
  {1920, 1924, 1931},
  {1925, 1932, 1926},
  {1933, 1928, 1930},
  {1934, 1932, 1933},
  {1935, 1932, 1934},
  {1935, 1934, 1937},
  {1933, 1936, 1934},
  {1937, 1934, 1936},
  {1938, 1936, 1930},
  {1933, 1930, 1936},
  {1930, 1929, 1938},
  {1911, 1939, 1936},
  {1937, 1936, 1939},
  {1911, 1936, 1938},
  {1940, 1738, 1931},
  {1940, 1802, 1738},
  {1920, 1931, 1738},
  {1915, 1803, 1940},
  {1940, 1803, 1802},
  {1941, 1926, 1932},
  {1941, 1942, 1926},
  {1943, 1942, 1941},
  {1941, 1932, 1935},
  {1941, 1935, 1939},
  {1937, 1939, 1935},
  {1931, 1926, 1942},
  {1942, 1943, 1931},
  {1940, 1931, 1943},
  {1943, 1941, 1939},
  {1768, 1762, 1752},
  {1752, 1762, 1753},
  {1756, 1753, 1762},
  {1761, 1775, 1760},
  {1773, 1760, 1775},
  {1766, 1765, 1771},
  {1765, 1769, 1771},
  {1778, 1780, 1774},
  {1772, 1774, 1780},
  {1728, 1798, 1737},
  {1794, 1737, 1798},
  {1709, 1712, 1710},
  {1686, 1683, 1682},
  {1677, 1687, 1685},
  {1683, 1695, 1696},
  {1685, 1690, 1694},
  {1717, 1724, 1713},
  {1711, 1713, 1724},
  {1699, 1701, 1698},
  {1701, 1705, 1698},
  {1922, 1901, 1908},
  {1915, 1943, 1918},
  {1939, 1918, 1943},
  {1911, 1918, 1939},
  {1938, 1910, 1911},
  {1910, 1938, 1909},
  {1908, 1909, 1938},
  {1908, 1938, 1922},
  {1916, 1804, 1915},
  {1803, 1915, 1804},
  {1916, 1251, 1804},
  {1804, 1251, 1803},
  {1251, 1799, 1803},
  {1795, 1797, 1261},
  {1796, 1795, 1260},
  {1260, 1795, 1261},
  { 317, 1796, 1260},
  {1878, 1874, 1264},
  {1874,  895, 1264},
  { 316, 1264,  895},
  {1262, 1916, 1913},
  {1262, 1913, 1879},
  {1264, 1262, 1879},
  {1264, 1879, 1878},
  {1827, 1837, 1826},
  {1827, 1838, 1837},
  {1915, 1940, 1943},
  {1134, 1093, 1199},
  {1194, 1199, 1093},
  {1119, 1091, 1134},
  {1134, 1091, 1093},
  {1020, 1035, 1021},
  {1034, 1020, 1031},
  {1056, 1944, 1063},
  {1056, 1057, 1944},
  {1944, 1057, 1053},
  {1054, 1053, 1057},
  {1445, 1626,  517},
  { 655,  517, 1631},
  {1626, 1631,  517},
  {1053, 1175, 1944},
  {1178, 1944, 1175},
  {1631, 1637,  655},
  { 652,  648,  655},
};

SVV_NAMESPACE_BEGIN

svvModel cow( "cow",
              cow_vertices, cow_nvertices,
              cow_indices, cow_nindices );

SVV_NAMESPACE_END

#endif /* SVV_COW_H_ */
/*
 * End of: $Id: cow.h,v 1.1.1.1 2006/12/19 22:58:40 christianh Exp $.
 * 
 */
