/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: mechanical.h,v 1.1.1.1 2006/12/19 22:58:56 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MECHANICAL_H_
#  define SVV_MECHANICAL_H_
#  include "svvModel.h"

static GLsizei mechanical_nvertices = 1995;
static GLsizei mechanical_nindices  = 4018;
static GLsizei mechanical_nedges    = 16072;

static GLfloat mechanical_vertices[][6] =
{
  {-3.500756e-01, -9.362952e-01,  2.825284e-02,  9.051759e-01, -7.446398e-01, -4.145211e-02},
  {-8.322567e-01, -5.535013e-01, -3.138402e-02,  9.030197e-01, -7.363110e-01, -4.145211e-02},
  {-8.094307e-01, -5.742303e-01,  1.228070e-01,  8.932196e-01, -7.308039e-01, -4.713417e-02},
  {-1.881025e-01, -9.808823e-01,  4.987336e-02,  8.673483e-01, -6.278704e-01, -4.713417e-02},
  { 7.901121e-01, -6.084011e-01, -7.463960e-02,  9.337895e-01, -7.437187e-01, -5.281922e-02},
  { 8.080112e-01, -4.759021e-01, -3.473256e-01,  9.269292e-01, -7.454442e-01, -7.476991e-02},
  {-7.017453e-01, -5.488349e-01,  4.542396e-01,  8.983155e-01, -7.374864e-01, -6.163837e-02},
  {-3.178387e-01, -8.245415e-01,  4.680916e-01,  8.573539e-01, -6.303780e-01, -6.732342e-02},
  { 9.240333e-01, -3.517667e-01, -1.497420e-01,  7.964003e-01, -6.456852e-01, -4.145211e-02},
  {-4.095656e-01, -8.517685e-01,  3.267206e-01,  8.969429e-01, -7.467182e-01, -6.751781e-02},
  { 8.559086e-01, -4.196432e-01,  3.021921e-01,  7.981647e-01, -6.452351e-01, -5.281922e-02},
  { 6.199697e-01, -6.463553e-01, -4.448173e-01,  9.137976e-01, -7.487368e-01, -9.338912e-02},
  {-4.139551e-01, -4.195704e-01,  8.078378e-01,  8.873402e-01, -7.491091e-01, -7.731786e-02},
  {-4.700280e-01, -5.707849e-01,  6.732594e-01,  8.902799e-01, -7.394855e-01, -7.281110e-02},
  {-5.346526e-01, -6.308963e-01,  5.622423e-01,  8.832251e-01, -7.333115e-01, -6.732342e-02},
  {-2.313125e-01, -5.254567e-01,  8.187733e-01,  8.742086e-01, -7.355858e-01, -7.418077e-02},
  { 3.988438e-01, -8.446210e-01, -3.571261e-01,  8.957676e-01, -7.532840e-01, -1.069124e-01},
  {-2.558062e-01, -3.894266e-01,  8.848220e-01,  8.732277e-01, -7.437979e-01, -8.378644e-02},
  { 1.382065e-02, -5.848318e-01,  8.110368e-01,  8.377537e-01, -6.353170e-01, -7.770962e-02},
  { 1.034827e-01, -2.612047e-01,  9.597205e-01,  8.599018e-01, -7.471488e-01, -8.594263e-02},
  { 1.771813e-01, -7.398483e-01,  6.490232e-01,  8.618606e-01, -7.554790e-01, -8.594263e-02},
  { 2.366282e-01, -3.329616e-01,  9.127670e-01,  8.524553e-01, -7.410541e-01, -7.770962e-02},
  { 1.288185e-01, -8.519027e-01, -5.076096e-01,  8.522579e-01, -7.642189e-01, -1.139671e-01},
  { 2.232422e-01, -2.743913e-01, -9.353461e-01,  8.746004e-01, -7.586146e-01, -1.139671e-01},
  { 4.946121e-01, -2.218995e-01,  8.403092e-01,  8.160004e-01, -6.407852e-01, -7.418077e-02},
  { 6.253905e-01, -2.558704e-01,  7.371683e-01,  8.344222e-01, -7.535381e-01, -7.731786e-02},
  { 5.017887e-01, -6.233847e-01,  5.996663e-01,  8.365784e-01, -7.618684e-01, -7.731786e-02},
  { 7.005928e-01, -2.204050e-01,  6.786688e-01,  8.369702e-01, -7.449149e-01, -7.104667e-02},
  {-6.468552e-01, -6.505331e-01, -3.979762e-01,  7.611237e-01, -6.267535e-01, -7.281110e-02},
  {-2.816209e-01, -8.775064e-01, -3.881651e-01,  8.058086e-01, -7.759001e-01, -8.456996e-02},
  { 7.992829e-01, -4.676348e-01,  3.774447e-01,  8.234469e-01, -7.651415e-01, -6.163837e-02},
  { 9.246348e-01, -2.475732e-01,  2.894098e-01,  8.187428e-01, -7.574782e-01, -5.516980e-02},
  { 9.339331e-01, -1.643321e-01,  3.174330e-01,  8.240361e-01, -7.481686e-01, -5.281922e-02},
  {-2.621352e-01, -9.522715e-01, -1.564105e-01,  7.956168e-01, -7.784480e-01, -6.418633e-02},
  { 9.116932e-01, -4.097662e-01,  3.011962e-02,  8.187428e-01, -7.663363e-01, -4.145211e-02},
  { 8.899987e-01, -3.520705e-01, -2.897390e-01,  8.208990e-01, -7.658069e-01, -2.773144e-02},
  { 9.767126e-01, -1.234711e-01, -1.754634e-01,  8.171757e-01, -7.578700e-01, -3.439739e-02},
  { 9.764869e-01, -1.870044e-01, -1.072502e-01,  8.228608e-01, -7.485006e-01, -3.557268e-02},
  { 8.081530e-01, -1.571203e-01, -5.676284e-01,  8.291320e-01, -7.468946e-01, -1.969581e-02},
  { 6.723508e-01, -5.761885e-01, -4.647056e-01,  8.032606e-01, -6.439611e-01, -1.969581e-02},
  { 7.362500e-01, -4.846047e-01, -4.723284e-01,  8.269758e-01, -7.642593e-01, -1.518904e-02},
  {-7.350038e-01, -5.275648e-01, -4.259635e-01,  8.608827e-01, -6.294764e-01, -1.969581e-02},
  {-3.984079e-01, -7.243379e-01,  5.626773e-01,  8.130607e-01, -7.740773e-01,  1.048489e-02},
  { 7.857797e-01, -2.113104e-01, -5.812901e-01,  8.293263e-01, -7.548316e-01, -9.898744e-03},
  { 3.944450e-01, -6.938326e-01, -6.025027e-01,  8.424579e-01, -7.604179e-01, -1.665740e-03},
  { 3.023306e-01, -5.136120e-01, -8.029937e-01,  8.210963e-01, -6.394917e-01, -6.369886e-03},
  { 4.316431e-01, -1.869113e-01, -8.824672e-01,  8.469676e-01, -7.424253e-01, -6.369886e-03},
  { 1.844917e-01, -9.609590e-01, -2.062054e-01,  8.469676e-01, -7.655527e-01,  1.107403e-02},
  {-1.973060e-01, -8.134601e-01,  5.471316e-01,  8.310907e-01, -7.695511e-01,  2.400819e-02},
  { 3.398851e-01, -9.103587e-01, -2.360615e-01,  8.634307e-01, -7.614168e-01,  1.362199e-02},
  { 1.179810e-01, -8.306267e-01,  5.441873e-01,  8.522579e-01, -7.642189e-01,  3.126029e-02},
  { 2.840537e-01, -4.066783e-01, -8.682892e-01,  8.530415e-01, -7.488534e-01,  2.646643e-03},
  {-1.858632e-01, -6.365092e-01, -7.485391e-01,  8.430470e-01, -6.339458e-01, -6.369886e-03},
  { 1.343800e-01, -6.581953e-01, -7.407570e-01,  8.687209e-01, -7.537923e-01,  2.646643e-03},
  {-1.010026e-01, -4.378030e-01, -8.933796e-01,  8.689183e-01, -7.368792e-01, -6.369886e-03},
  {-2.983329e-01, -4.920653e-01, -8.178442e-01,  8.795019e-01, -7.422293e-01, -1.665740e-03},
  {-2.886351e-01, -8.014199e-01, -5.238470e-01,  8.924361e-01, -7.478157e-01, -9.898744e-03},
  {-6.309928e-01, -7.021314e-01, -3.299387e-01,  9.004717e-01, -7.458165e-01, -2.126585e-02},
  {-6.628330e-01, -5.331229e-01, -5.257685e-01,  8.947867e-01, -7.383880e-01, -1.518904e-02},
  {-5.625522e-01, -6.296675e-01, -5.357741e-01,  8.867510e-01, -7.324098e-01, -1.969581e-02},
  { 8.793230e-01, -3.851745e-01,  2.800567e-01,  8.934170e-01, -5.938259e-01, -1.871790e-02},
  { 6.823668e-01, -6.164277e-01,  3.929280e-01,  8.832251e-01, -5.960614e-01,  1.863117e-03},
  { 8.057367e-01, -2.959696e-01,  5.130211e-01,  9.210497e-01, -7.469141e-01,  1.863117e-03},
  { 6.700420e-01, -7.367936e-01,  9.043686e-02,  9.312415e-01, -7.443661e-01, -1.871790e-02},
  { 2.123465e-01, -4.171006e-01, -8.837059e-01,  7.697455e-01, -5.473766e-01, -4.741947e-01},
  { 4.051311e-01, -4.875061e-01, -7.734382e-01,  7.697455e-01, -5.854973e-01, -4.532249e-01},
  { 6.294310e-01, -6.163529e-01, -4.732079e-01,  7.648469e-01, -6.031954e-01, -4.414660e-01},
  { 3.072174e-01, -7.462013e-01, -5.905938e-01,  7.464251e-01, -6.337888e-01, -4.165756e-01},
  { 4.082699e-01, -9.107413e-01, -6.217631e-02,  7.176141e-01, -6.554853e-01, -3.920770e-01},
  {-1.433014e-01, -8.670570e-01, -4.771550e-01,  6.813565e-01, -6.661855e-01, -3.707125e-01},
  {-1.371060e-01, -9.696711e-01,  2.023361e-01,  6.409811e-01, -6.648143e-01, -3.540550e-01},
  {-4.374022e-01, -8.992636e-01,  2.078697e-03,  6.008029e-01, -6.515257e-01, -3.440576e-01},
  {-6.377950e-01, -7.488269e-01, -1.802109e-01,  5.645454e-01, -6.276147e-01, -3.417070e-01},
  {-8.252427e-01, -5.645874e-01, -1.468273e-02,  5.357374e-01, -5.954334e-01, -3.471947e-01},
  {-6.284849e-01, -4.080979e-01, -6.621653e-01,  5.124140e-01, -5.386562e-01, -3.685563e-01},
  {-9.486539e-01, -2.667591e-01,  1.699866e-01,  5.171182e-01, -5.581172e-01, -3.597371e-01},
  {-9.895325e-01,  3.345729e-02, -1.403783e-01,  5.124140e-01, -5.005550e-01, -3.895290e-01},
  {-9.316881e-01,  3.236030e-01, -1.650409e-01,  5.171182e-01, -4.828374e-01, -4.012879e-01},
  {-6.157451e-01, -1.902821e-01, -7.646245e-01,  5.357374e-01, -4.522440e-01, -4.261783e-01},
  {-7.055489e-01,  2.091532e-01, -6.770935e-01,  5.488659e-01, -4.401323e-01, -4.387207e-01},
  {-5.604495e-01,  6.522390e-01, -5.103732e-01,  5.819893e-01, -4.237275e-01, -4.618497e-01},
  {-4.405119e-01,  3.061884e-01, -8.439182e-01,  6.008029e-01, -4.198667e-01, -4.720385e-01},
  {-1.227544e-01,  6.854944e-01, -7.176551e-01,  6.409811e-01, -4.212185e-01, -4.886989e-01},
  {-1.113450e-01,  9.860229e-02, -9.888781e-01,  6.813565e-01, -4.345070e-01, -4.986933e-01},
  {-8.010487e-03, -1.226916e-01, -9.924124e-01,  7.176141e-01, -4.584180e-01, -5.010469e-01},
  { 2.758934e-01, -5.837249e-02, -9.594141e-01,  7.464251e-01, -4.906188e-01, -4.955592e-01},
  { 7.222030e-01, -2.127207e-02, -6.913540e-01,  7.648469e-01, -5.279350e-01, -4.830168e-01},
  { 7.945179e-01, -2.158486e-01, -5.675831e-01,  8.357949e-01, -4.623177e-01, -3.203455e-01},
  { 6.070333e-01, -3.829188e-02, -7.937533e-01,  8.203128e-01, -4.276272e-01, -3.432741e-01},
  { 4.258621e-01,  3.777461e-02, -9.039992e-01,  7.918935e-01, -3.972492e-01, -3.618933e-01},
  { 2.422407e-01,  2.253927e-01, -9.436724e-01,  7.556360e-01, -3.739662e-01, -3.718907e-01},
  { 6.229502e-02,  5.135197e-01, -8.558136e-01,  7.133017e-01, -3.596593e-01, -3.736522e-01},
  {-2.149453e-01,  4.340983e-01, -8.748469e-01,  6.635209e-01, -3.577185e-01, -3.675784e-01},
  {-4.324868e-01,  5.322281e-01, -7.277970e-01,  6.274577e-01, -3.652053e-01, -3.560139e-01},
  {-6.217048e-01,  4.550278e-01, -6.375210e-01,  6.058989e-01, -3.757889e-01, -3.470003e-01},
  {-8.435439e-01,  3.706572e-01, -3.886475e-01,  5.786579e-01, -3.970922e-01, -3.264193e-01},
  {-9.490288e-01,  7.587705e-02, -3.059201e-01,  5.608222e-01, -4.268243e-01, -2.999618e-01},
  {-8.479102e-01, -3.095890e-01, -4.303521e-01,  5.565098e-01, -4.473829e-01, -2.838906e-01},
  {-9.748592e-01, -2.177266e-01,  4.737781e-02,  5.598413e-01, -4.777430e-01, -2.582166e-01},
  {-7.927586e-01, -6.038509e-01, -8.305272e-02,  5.755208e-01, -5.122555e-01, -2.350877e-01},
  {-4.846686e-01, -6.230168e-01, -6.139596e-01,  1.823672e-01, -2.005348e-01, -2.429289e-01},
  {-6.319049e-01, -7.750137e-01, -7.068825e-03,  6.031565e-01, -5.427712e-01, -2.174494e-01},
  {-4.488237e-01, -8.765079e-01,  1.740439e-01,  6.398058e-01, -5.662904e-01, -2.070632e-01},
  {-2.718565e-01, -8.673368e-01, -4.169183e-01,  6.492141e-01, -5.805195e-01, -1.894249e-01},
  {-1.976761e-01, -9.777197e-01,  7.062811e-02,  6.823345e-01, -5.802638e-01, -2.047096e-01},
  { 5.954823e-03, -9.918277e-01,  1.274452e-01,  7.046799e-01, -5.831257e-01, -2.062797e-01},
  { 1.531810e-01, -9.874573e-01, -3.825667e-02,  7.477948e-01, -5.806959e-01, -2.158823e-01},
  { 3.091145e-01, -9.385009e-01, -1.538321e-01,  7.679840e-01, -5.750124e-01, -2.229371e-01},
  { 5.274308e-01, -8.367935e-01, -1.469468e-01,  8.026745e-01, -5.565696e-01, -2.425372e-01},
  { 6.083592e-01, -6.940857e-01, -3.848950e-01,  8.267784e-01, -5.297577e-01, -2.668384e-01},
  { 6.346660e-01, -5.606812e-01, -5.318230e-01,  8.383428e-01, -4.972818e-01, -2.936907e-01},
  { 3.686344e-02,  7.022468e-01,  7.109784e-01, -5.349523e-01,  5.238410e-01,  6.072715e-01},
  {-3.723390e-02,  7.022273e-01,  7.109784e-01, -5.349523e-01,  5.238410e-01,  6.386304e-01},
  { 2.424249e-01,  8.596404e-01,  4.497205e-01, -5.923770e-01,  5.329143e-01,  6.072715e-01},
  { 2.606672e-01,  8.603926e-01,  4.379237e-01, -5.923770e-01,  5.329143e-01,  6.386304e-01},
  { 3.958479e-01,  7.297547e-01,  5.574607e-01, -6.192278e-01,  5.440466e-01,  6.072715e-01},
  { 4.700616e-01,  6.842954e-01,  5.574782e-01, -6.441181e-01,  5.592566e-01,  6.386304e-01},
  { 2.664506e-01,  2.809480e-01,  9.219936e-01, -6.662662e-01,  5.781689e-01,  6.072715e-01},
  { 4.545435e-01,  3.879951e-01,  8.017792e-01, -6.662662e-01,  5.781689e-01,  6.386304e-01},
  { 8.082116e-01,  4.956699e-01,  3.179706e-01, -7.003675e-01,  6.251281e-01,  6.072715e-01},
  { 7.397878e-01,  3.773755e-01,  5.570474e-01, -7.003675e-01,  6.251281e-01,  6.386304e-01},
  { 7.896585e-01,  2.570228e-01,  5.571164e-01, -7.115388e-01,  6.520177e-01,  6.072715e-01},
  { 5.811465e-01,  1.391950e-01,  8.018064e-01, -7.115388e-01,  6.520177e-01,  6.386304e-01},
  { 7.022973e-01,  3.682124e-02,  7.109309e-01, -7.205553e-01,  7.093437e-01,  6.072715e-01},
  { 5.950164e-01, -3.119406e-02,  8.031080e-01, -7.205553e-01,  7.093437e-01,  6.386304e-01},
  { 8.596234e-01, -2.424285e-01,  4.497510e-01, -7.115388e-01,  7.666712e-01,  6.072715e-01},
  { 6.781465e-01, -1.912489e-01,  7.096063e-01, -7.115388e-01,  7.666712e-01,  6.386304e-01},
  { 7.397878e-01, -3.773755e-01,  5.570474e-01, -7.003675e-01,  7.935608e-01,  6.386304e-01},
  { 8.082116e-01, -4.956699e-01,  3.179706e-01, -7.003675e-01,  7.935608e-01,  6.072715e-01},
  { 5.360650e-01, -4.577370e-01,  7.093033e-01, -6.662662e-01,  8.405200e-01,  6.386304e-01},
  { 2.769441e-01, -2.772183e-01,  9.200283e-01, -6.662662e-01,  8.405200e-01,  6.072715e-01},
  { 4.879620e-01, -6.719934e-01,  5.570619e-01, -6.441181e-01,  8.594128e-01,  6.386304e-01},
  { 4.950582e-01, -8.085822e-01,  3.179814e-01, -6.441181e-01,  8.594128e-01,  6.072715e-01},
  { 2.973488e-01, -7.740658e-01,  5.589328e-01, -5.923770e-01,  8.857731e-01,  6.386304e-01},
  { 1.538312e-01, -5.755649e-01,  8.031569e-01, -5.923770e-01,  8.857731e-01,  6.072715e-01},
  { 3.123674e-02, -5.949607e-01,  8.031476e-01, -5.349523e-01,  8.948479e-01,  6.386304e-01},
  {-5.018359e-02, -9.463016e-01,  3.193661e-01, -5.349523e-01,  8.948479e-01,  6.072715e-01},
  {-2.171970e-01, -6.683120e-01,  7.114666e-01, -4.777235e-01,  8.857731e-01,  6.386304e-01},
  {-2.171970e-01, -6.683120e-01,  7.114666e-01, -4.777235e-01,  8.857731e-01,  6.072715e-01},
  {-3.454339e-01, -5.173287e-01,  7.829728e-01, -4.259824e-01,  8.594128e-01,  6.072715e-01},
  {-3.065543e-01, -4.591019e-01,  8.338164e-01, -4.259824e-01,  8.594128e-01,  6.386304e-01},
  {-5.858780e-01, -5.417688e-01,  6.026886e-01, -4.038359e-01,  8.405200e-01,  6.386304e-01},
  {-6.557682e-01, -6.063972e-01,  4.497228e-01, -4.038359e-01,  8.405200e-01,  6.072715e-01},
  {-7.079463e-01, -4.341776e-01,  5.570474e-01, -3.697345e-01,  7.935608e-01,  6.072715e-01},
  {-7.397882e-01, -3.773746e-01,  5.570474e-01, -3.697345e-01,  7.935608e-01,  6.386304e-01},
  {-3.725902e-01, -1.212718e-01,  9.200379e-01, -3.585633e-01,  7.666712e-01,  6.072715e-01},
  {-5.811470e-01, -1.391930e-01,  8.018064e-01, -3.585633e-01,  7.666712e-01,  6.386304e-01},
  {-9.694374e-01,  2.010708e-06,  2.453388e-01, -3.495468e-01,  7.093437e-01,  6.072715e-01},
  {-7.027739e-01,  1.457622e-06,  7.114133e-01, -3.495468e-01,  7.093437e-01,  6.386304e-01},
  {-6.854908e-01,  1.641869e-01,  7.093272e-01, -3.585633e-01,  6.520177e-01,  6.386304e-01},
  {-7.896589e-01,  2.570218e-01,  5.571164e-01, -3.585633e-01,  6.520177e-01,  6.072715e-01},
  {-5.323863e-01,  2.715765e-01,  8.017550e-01, -3.697345e-01,  6.251281e-01,  6.386304e-01},
  {-5.094714e-01,  3.124546e-01,  8.017550e-01, -3.697345e-01,  6.251281e-01,  6.072715e-01},
  {-6.559261e-01,  6.062344e-01,  4.497120e-01, -4.038359e-01,  5.781689e-01,  6.072715e-01},
  {-5.860219e-01,  5.416260e-01,  6.026770e-01, -4.038359e-01,  5.781689e-01,  6.386304e-01},
  {-4.881375e-01,  6.718522e-01,  5.570784e-01, -4.259824e-01,  5.592566e-01,  6.072715e-01},
  {-3.680752e-01,  6.011863e-01,  7.092924e-01, -4.259824e-01,  5.592566e-01,  6.386304e-01},
  {-2.170987e-01,  6.683513e-01,  7.114596e-01, -4.777235e-01,  5.329143e-01,  6.072715e-01},
  {-1.367994e-01,  4.211451e-01,  8.966174e-01, -4.777235e-01,  5.329143e-01,  6.386304e-01},
  { 1.395408e-01,  8.812129e-01,  4.516547e-01,  1.845234e-01, -9.216583e-01,  6.072715e-01},
  { 1.245607e-01,  7.866123e-01,  6.047525e-01,  1.845234e-01, -9.216583e-01,  6.386304e-01},
  { 1.802460e-01,  4.049603e-01,  8.963919e-01,  1.292549e-01, -9.037045e-01,  6.072715e-01},
  { 4.153268e-01,  7.176877e-01,  5.589526e-01,  1.292549e-01, -9.037045e-01,  6.386304e-01},
  { 6.155010e-01,  7.211614e-01,  3.179382e-01,  8.241377e-02, -8.696032e-01,  6.072715e-01},
  { 4.979050e-01,  4.990912e-01,  7.092239e-01,  8.241377e-02, -8.696032e-01,  6.386304e-01},
  { 6.631706e-01,  4.437230e-01,  6.027557e-01,  6.340280e-02, -8.474566e-01,  6.072715e-01},
  { 4.587309e-01,  3.069338e-01,  8.338810e-01,  6.340280e-02, -8.474566e-01,  6.386304e-01},
  { 6.513020e-01,  2.698263e-01,  7.092245e-01,  3.713973e-02, -7.957544e-01,  6.386304e-01},
  { 6.702825e-01,  2.184535e-01,  7.092246e-01,  3.713973e-02, -7.957544e-01,  6.072715e-01},
  { 8.199963e-01,  1.312470e-01,  5.571178e-01,  3.027939e-02, -7.674532e-01,  6.386304e-01},
  { 9.451182e-01,  7.492052e-02,  3.180230e-01,  3.027939e-02, -7.674532e-01,  6.072715e-01},
  { 8.062238e-01, -1.505652e-01,  5.721306e-01,  3.027939e-02, -7.094020e-01,  6.072715e-01},
  { 7.026737e-01, -5.570180e-02,  7.093285e-01,  3.027939e-02, -7.094020e-01,  6.386304e-01},
  { 6.640884e-01, -2.356973e-01,  7.095304e-01,  3.713973e-02, -6.811009e-01,  6.386304e-01},
  { 4.651363e-01, -2.729321e-01,  8.421142e-01,  4.830946e-02, -6.542113e-01,  6.072715e-01},
  { 5.723565e-01, -3.825287e-01,  7.253136e-01,  6.340280e-02, -6.293986e-01,  6.386304e-01},
  { 5.417584e-01, -5.639238e-01,  6.232879e-01,  8.241377e-02, -6.072521e-01,  6.386304e-01},
  { 6.312542e-01, -6.305117e-01,  4.516339e-01,  8.241377e-02, -6.072521e-01,  6.072715e-01},
  { 3.617545e-01, -7.094747e-01,  6.047970e-01,  1.292549e-01, -5.731493e-01,  6.072715e-01},
  { 3.191889e-01, -6.259947e-01,  7.115119e-01,  1.292549e-01, -5.731493e-01,  6.386304e-01},
  { 1.298492e-01, -8.202592e-01,  5.570585e-01,  1.845234e-01, -5.552164e-01,  6.072715e-01},
  { 1.645614e-01, -6.854559e-01,  7.092741e-01,  1.845234e-01, -5.552164e-01,  6.386304e-01},
  { 3.003715e-04, -5.976279e-01,  8.017735e-01,  2.135288e-01, -5.529241e-01,  6.386304e-01},
  {-6.499746e-02, -8.279165e-01,  5.570723e-01,  2.135288e-01, -5.529241e-01,  6.072715e-01},
  {-1.644844e-01, -6.854354e-01,  7.093117e-01,  2.709534e-01, -5.619975e-01,  6.386304e-01},
  {-2.935709e-01, -9.014910e-01,  3.180094e-01,  2.709534e-01, -5.619975e-01,  6.072715e-01},
  {-2.717351e-01, -5.322751e-01,  8.017751e-01,  2.978057e-01, -5.731493e-01,  6.386304e-01},
  {-1.369416e-01, -2.229023e-01,  9.651744e-01,  2.978057e-01, -5.731493e-01,  6.072715e-01},
  {-4.576733e-01, -5.362249e-01,  7.092235e-01,  3.446468e-01, -6.072521e-01,  6.386304e-01},
  {-6.696227e-01, -6.712086e-01,  3.179379e-01,  3.446468e-01, -6.072521e-01,  6.072715e-01},
  {-5.696439e-01, -4.151119e-01,  7.093574e-01,  3.636577e-01, -6.293986e-01,  6.386304e-01},
  {-7.081129e-01, -4.337750e-01,  5.571493e-01,  3.636577e-01, -6.293986e-01,  6.072715e-01},
  {-7.741135e-01, -2.974148e-01,  5.588316e-01,  3.899208e-01, -6.811009e-01,  6.386304e-01},
  {-6.792020e-01, -1.825044e-01,  7.108986e-01,  3.899208e-01, -6.811009e-01,  6.072715e-01},
  {-8.279499e-01, -4.434510e-02,  5.590461e-01,  3.991317e-01, -7.384269e-01,  6.386304e-01},
  {-9.462437e-01,  5.067689e-02,  3.194600e-01,  3.991317e-01, -7.384269e-01,  6.072715e-01},
  {-7.573861e-01,  2.465058e-01,  6.046498e-01,  3.899208e-01, -7.957544e-01,  6.386304e-01},
  {-5.230442e-01,  1.702347e-01,  8.351317e-01,  3.899208e-01, -7.957544e-01,  6.072715e-01},
  {-4.587309e-01,  3.069338e-01,  8.338810e-01,  3.636577e-01, -8.474566e-01,  6.386304e-01},
  {-7.423022e-01,  4.966693e-01,  4.497856e-01,  3.636577e-01, -8.474566e-01,  6.072715e-01},
  {-4.979051e-01,  4.990912e-01,  7.092239e-01,  3.446468e-01, -8.696032e-01,  6.386304e-01},
  {-3.880165e-01,  4.546255e-01,  8.017225e-01,  3.446468e-01, -8.696032e-01,  6.072715e-01},
  {-3.853368e-01,  8.657397e-01,  3.193902e-01,  2.978057e-01, -9.037045e-01,  6.072715e-01},
  {-3.522078e-01,  6.086175e-01,  7.110093e-01,  2.978057e-01, -9.037045e-01,  6.386304e-01},
  {-7.322040e-02,  6.993877e-01,  7.109822e-01,  2.425372e-01, -9.216583e-01,  6.072715e-01},
  {-1.464408e-01,  6.877932e-01,  7.109822e-01,  2.425372e-01, -9.216583e-01,  6.386304e-01},
  { 1.148681e-01,  6.786279e-01, -7.254443e-01,  4.332330e-01, -6.106628e-01,  5.651345e-01},
  { 5.238479e-01,  2.817092e-01, -8.038802e-01,  3.740439e-01, -4.382901e-01,  5.651345e-01},
  { 4.761582e-01,  1.904798e-01,  8.584817e-01,  3.801208e-01, -4.523218e-01,  6.386304e-01},
  {-6.752750e-01,  1.220076e-01, -7.274048e-01,  3.299482e-01, -4.948520e-01,  5.651345e-01},
  { 5.385275e-01,  4.432667e-01,  7.165911e-01,  3.658139e-01, -4.254920e-01,  6.386304e-01},
  { 5.202681e-01,  6.408079e-01, -5.645232e-01,  3.554247e-01, -4.142804e-01,  5.651345e-01},
  { 3.625045e-01,  7.420001e-01,  5.639383e-01,  3.297508e-01, -3.978772e-01,  6.386304e-01},
  {-2.397709e-01, -5.344160e-01, -8.104995e-01,  3.134851e-01, -4.481081e-01,  5.651345e-01},
  { 1.765404e-01,  6.746067e-01, -7.167562e-01,  3.150522e-01, -3.931730e-01,  5.651345e-01},
  {-9.142312e-02,  8.221896e-01, -5.618240e-01,  2.846741e-01, -3.913697e-01,  5.651345e-01},
  { 4.121497e-02,  7.004178e-01,  7.125421e-01,  2.999618e-01, -3.909779e-01,  6.386304e-01},
  { 2.262236e-02, -4.320403e-01, -9.015706e-01,  2.927097e-01, -4.431901e-01,  5.651345e-01},
  {-2.324031e-01,  4.330971e-01, -8.708706e-01,  2.554713e-01, -3.997971e-01,  5.651345e-01},
  {-2.291226e-01,  7.948452e-01,  5.618933e-01,  2.697782e-01, -3.943289e-01,  6.386304e-01},
  { 5.655387e-01, -6.769528e-01, -4.710636e-01,  2.725235e-01, -4.502642e-01,  5.651345e-01},
  { 4.189922e-01, -6.793804e-02, -9.054446e-01,  2.570384e-01, -4.775665e-01,  5.651345e-01},
  {-4.635583e-02,  8.856450e-01, -4.620434e-01, -1.849166e-01, -8.624498e-01,  5.651345e-01},
  {-2.522052e-01,  3.514404e-01, -9.015998e-01, -1.647289e-01, -8.553741e-01,  5.651345e-01},
  {-3.016864e-01,  3.282202e-01, -8.951296e-01, -2.392057e-01, -7.513042e-01,  5.651345e-01},
  {-1.276127e-01, -4.044630e-01, -9.056073e-01, -1.780563e-01, -7.878757e-01,  5.651345e-01},
  { 1.963195e-01, -7.986427e-01, -5.688835e-01, -1.994193e-01, -7.889927e-01,  5.651345e-01},
  {-7.183189e-01,  4.122688e-01, -5.604039e-01, -2.621358e-01, -7.751958e-01,  5.651345e-01},
  { 4.256642e-01, -4.028684e-01, -8.102512e-01, -2.166659e-01, -8.014573e-01,  5.651345e-01},
  {-5.883723e-01,  5.135748e-02, -8.069575e-01, -2.750714e-01, -8.057892e-01,  5.651345e-01},
  { 8.831313e-01, -8.078375e-02, -4.621179e-01, -2.245056e-01, -8.212728e-01,  5.651345e-01},
  {-7.685414e-01, -3.025082e-01, -5.637667e-01, -2.717400e-01, -8.550795e-01,  5.651345e-01},
  { 4.198821e-01,  2.729260e-01, -8.655694e-01, -2.203906e-01, -8.421842e-01,  5.651345e-01},
  {-5.296612e-01, -4.589730e-01, -7.133042e-01, -2.550811e-01, -8.837141e-01,  5.651345e-01},
  {-2.292400e-01, -4.329292e-01, -8.717920e-01, -2.290139e-01, -9.043519e-01,  5.651345e-01},
  { 3.437531e-01,  6.007808e-01, -7.217314e-01, -2.056905e-01, -8.575303e-01,  5.651345e-01},
  {-5.178145e-02, -3.091985e-01, -9.495867e-01,  4.526358e-01, -1.118412e+00,  5.651345e-01},
  { 6.452895e-02, -7.716144e-01, -6.328089e-01,  2.135288e-01, -9.030585e-01,  5.651345e-01},
  {-7.699700e-01, -2.124257e-01, -6.016823e-01,  3.462138e-01, -8.416549e-01,  5.651345e-01},
  { 1.234708e-02, -3.068735e-01, -9.516702e-01,  3.464112e-01, -8.418702e-01,  5.651345e-01},
  { 5.718147e-01, -3.926072e-01, -7.203385e-01,  3.468029e-01, -8.351879e-01,  5.651345e-01},
  {-6.987043e-01,  5.449906e-02, -7.133317e-01,  3.799234e-01, -7.647677e-01,  5.651345e-01},
  { 5.179033e-01, -1.912468e-01, -8.337870e-01,  3.701263e-01, -7.893067e-01,  5.651345e-01},
  { 8.167045e-01, -1.117679e-01, -5.661287e-01,  3.762001e-01, -7.641801e-01,  5.651345e-01},
  {-6.705248e-01,  7.448889e-02, -7.381381e-01,  3.738495e-01, -6.869803e-01,  5.651345e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  3.799234e-01, -7.120860e-01,  5.651345e-01},
  { 6.774986e-01,  1.243023e-01, -7.249445e-01,  3.762001e-01, -7.126752e-01,  5.651345e-01},
  { 6.445438e-01,  2.384320e-01, -7.264389e-01,  3.701263e-01, -6.875485e-01,  5.651345e-01},
  { 4.250177e-01,  3.072983e-01, -8.514269e-01,  3.468029e-01, -6.416674e-01,  5.651345e-01},
  {-4.576382e-01,  5.218407e-01, -7.198955e-01,  3.168166e-01, -5.116678e-01,  5.651345e-01},
  { 4.616536e-01,  5.104352e-01, -7.254873e-01,  3.103481e-01, -6.052334e-01,  5.651345e-01},
  {-1.034551e-01,  6.863772e-01, -7.198497e-01,  2.966304e-01, -5.187435e-01,  5.651345e-01},
  { 2.839499e-01,  6.331505e-01, -7.200645e-01,  2.758550e-01, -5.138240e-01,  5.651345e-01},
  { 2.485618e-01,  6.652718e-01, -7.040103e-01,  2.644879e-01, -5.818518e-01,  5.651345e-01},
  { 7.869933e-01,  4.088623e-01, -4.620314e-01,  2.611564e-01, -4.984780e-01,  5.651345e-01},
  {-1.090072e-04,  4.526794e-01, -8.916734e-01,  2.135288e-01, -5.737967e-01,  5.651345e-01},
  {-2.052260e-01,  8.170744e-01, -5.387687e-01,  1.625727e-01, -5.818518e-01,  5.651345e-01},
  {-4.258073e-01,  6.365449e-01, -6.430387e-01,  1.167125e-01, -6.052334e-01,  5.651345e-01},
  {-5.729674e-01,  4.960107e-01, -6.524429e-01,  9.711236e-02, -6.220105e-01,  5.651345e-01},
  {-6.633266e-01,  2.995699e-01, -6.857521e-01,  6.692867e-02, -6.636973e-01,  5.651345e-01},
  {-5.526129e-01,  8.833536e-02, -8.287435e-01,  5.085741e-02, -7.126752e-01,  5.651345e-01},
  {-5.467712e-01, -4.000786e-01, -7.355124e-01, -1.533618e-01, -8.071797e-01,  5.651345e-01},
  {-5.223302e-01, -6.157269e-02, -8.505175e-01,  5.085741e-02, -7.641801e-01,  5.651345e-01},
  {-5.280509e-01, -1.909252e-01, -8.274719e-01,  5.693423e-02, -7.893067e-01,  5.651345e-01},
  {-6.521619e-01,  2.041743e-01, -7.300669e-01, -1.515973e-01, -8.385582e-01,  5.651345e-01},
  {-5.490295e-01, -3.003096e-01, -7.799877e-01,  8.025758e-02, -8.351879e-01,  5.651345e-01},
  {-5.036640e-01, -6.223031e-01, -5.992174e-01,  1.167125e-01, -8.716218e-01,  5.651345e-01},
  {-2.180008e-01, -6.685030e-01, -7.110409e-01,  1.625727e-01, -8.950034e-01,  5.651345e-01},
  { 2.540156e-02,  6.861888e-01, -7.269798e-01,  4.708632e-01, -1.069139e+00,  5.651345e-01},
  { 1.587320e-01, -7.762050e-01, -6.101720e-01,  5.016330e-01, -1.119763e+00,  5.651345e-01},
  { 5.176942e-01, -6.464673e-01, -5.604219e-01,  5.314250e-01, -1.106063e+00,  5.651345e-01},
  {-2.224871e-01,  3.612961e-01, -9.055189e-01,  5.016330e-01, -1.063044e+00,  5.651345e-01},
  { 5.272579e-01, -2.671010e-01, -8.066326e-01,  5.543536e-01, -1.082623e+00,  5.651345e-01},
  {-7.431239e-01,  3.387280e-01, -5.770878e-01,  5.147646e-01, -1.046209e+00,  5.651345e-01},
  { 5.418966e-01,  1.005410e-01, -8.344097e-01,  5.688578e-01, -1.019711e+00,  5.651345e-01},
  { 8.259585e-01, -6.096120e-02, -5.604251e-01,  5.696413e-01, -1.036174e+00,  5.651345e-01},
  {-5.967377e-01, -3.119768e-01, -7.393069e-01,  5.130002e-01, -1.014831e+00,  5.651345e-01},
  {-1.239830e-01, -6.751212e-01, -7.272136e-01,  4.883071e-01, -9.955266e-01,  5.651345e-01},
  { 1.791614e-01, -5.080528e-01, -8.424866e-01,  4.669426e-01, -9.966435e-01,  5.651345e-01},
  { 3.028490e-01, -4.172363e-01, -8.568527e-01,  3.103481e-01, -8.716218e-01,  5.651345e-01},
  { 5.041896e-01, -4.771768e-01, -7.197883e-01,  4.496961e-01, -1.009108e+00,  5.651345e-01},
  { 1.637333e-01, -5.011353e-01, -8.497380e-01,  2.644879e-01, -8.950034e-01,  5.651345e-01},
  { 6.817428e-01, -1.302188e-01, -7.199095e-01,  4.418578e-01, -1.028922e+00,  5.651345e-01},
  { 3.923737e-01,  1.693825e-01, -9.040755e-01,  4.459728e-01, -1.049835e+00,  5.651345e-01},
  { 6.279592e-01,  6.076615e-01, -4.862249e-01,  4.522440e-01, -1.058576e+00,  5.651345e-01},
  { 8.807006e-01, -3.676488e-01, -2.986650e-01,  4.612605e-01, -6.943102e-01,  5.651345e-01},
  {-6.557282e-01,  2.792141e-01, -7.014699e-01,  3.636577e-01, -8.149029e-01,  5.651345e-01},
  {-1.396126e-01,  2.354813e-01,  9.617987e-01,  2.423398e-01, -4.075980e-01,  6.386304e-01},
  { 6.751553e-01, -1.094739e-01,  7.295072e-01,  2.570384e-01, -4.775665e-01,  6.386304e-01},
  { 4.381911e-01, -5.245171e-01,  7.299796e-01,  2.725235e-01, -4.502642e-01,  6.386304e-01},
  { 3.620723e-02, -6.914832e-01,  7.214845e-01,  2.927097e-01, -4.431901e-01,  6.386304e-01},
  {-3.395149e-01, -4.773051e-01,  8.104995e-01,  3.134851e-01, -4.481081e-01,  6.386304e-01},
  {-6.587694e-01, -1.946505e-01,  7.267283e-01,  3.281837e-01, -4.634736e-01,  6.386304e-01},
  {-5.254629e-01,  2.397589e-01,  8.163360e-01,  3.299482e-01, -4.948520e-01,  6.386304e-01},
  {-3.619283e-02,  6.914772e-01,  7.214911e-01, -1.849166e-01, -8.624498e-01,  6.386304e-01},
  {-1.265754e-01, -2.390428e-01,  9.627239e-01, -2.290139e-01, -9.043519e-01,  6.386304e-01},
  { 3.912079e-01,  6.837180e-01,  6.160243e-01, -2.056905e-01, -8.575303e-01,  6.386304e-01},
  {-6.007257e-01, -5.205533e-01,  6.067560e-01, -2.550811e-01, -8.837141e-01,  6.386304e-01},
  {-8.061332e-01, -1.797674e-01,  5.637667e-01, -2.717400e-01, -8.550795e-01,  6.386304e-01},
  { 5.438144e-01,  2.183563e-01,  8.103002e-01, -2.203906e-01, -8.421842e-01,  6.386304e-01},
  {-5.729043e-01,  1.435279e-01,  8.069575e-01, -2.750714e-01, -8.057892e-01,  6.386304e-01},
  { 6.894712e-01, -6.306884e-02,  7.215620e-01, -2.245056e-01, -8.212728e-01,  6.386304e-01},
  {-6.623974e-01,  4.971691e-01,  5.604038e-01, -2.621358e-01, -7.751958e-01,  6.386304e-01},
  { 4.953674e-01, -3.132159e-01,  8.102512e-01, -2.166659e-01, -8.014573e-01,  6.386304e-01},
  {-2.477347e-01,  3.056453e-01,  9.193522e-01, -2.392057e-01, -7.513042e-01,  6.386304e-01},
  { 3.480827e-01, -7.451241e-01,  5.688835e-01, -1.994193e-01, -7.889927e-01,  6.386304e-01},
  {-2.056915e-01, -6.519304e-01,  7.298478e-01, -1.780563e-01, -7.878757e-01,  6.386304e-01},
  {-4.036765e-01,  5.625111e-01,  7.215446e-01, -1.647289e-01, -8.553741e-01,  6.386304e-01},
  {-9.101095e-02, -5.434465e-01,  8.344956e-01,  4.526358e-01, -1.118412e+00,  6.386304e-01},
  {-5.052260e-01,  1.581727e-01,  8.483678e-01, -1.515973e-01, -8.385582e-01,  6.386304e-01},
  {-5.374035e-01, -1.851458e-01,  8.227505e-01, -1.533618e-01, -8.071797e-01,  6.386304e-01},
  { 6.144601e-01,  3.192270e-01,  7.214797e-01,  2.611564e-01, -4.984780e-01,  6.386304e-01},
  { 4.019817e-01,  5.656127e-01,  7.200645e-01,  2.758550e-01, -5.138240e-01,  6.386304e-01},
  { 3.120673e-02,  6.934282e-01,  7.198497e-01,  2.966304e-01, -5.187435e-01,  6.386304e-01},
  {-4.122593e-01,  7.117434e-01,  5.687386e-01,  3.168166e-01, -5.116678e-01,  6.386304e-01},
  { 1.090966e-01, -5.334862e-01,  8.387433e-01,  5.016330e-01, -1.119763e+00,  6.386304e-01},
  { 1.920571e-01,  6.592529e-01,  7.269798e-01,  4.708632e-01, -1.069139e+00,  6.386304e-01},
  { 5.245731e-01,  4.381151e-01,  7.299851e-01,  4.522440e-01, -1.058576e+00,  6.386304e-01},
  { 6.798796e-01,  1.363833e-01,  7.205299e-01,  4.418578e-01, -1.028922e+00,  6.386304e-01},
  { 5.867543e-01, -3.709775e-01,  7.197883e-01,  4.496961e-01, -1.009108e+00,  6.386304e-01},
  { 2.619861e-01, -7.429210e-01,  6.159803e-01,  4.669426e-01, -9.966435e-01,  6.386304e-01},
  {-2.406877e-01, -5.252744e-01,  8.161839e-01,  4.883071e-01, -9.955266e-01,  6.386304e-01},
  {-5.967377e-01, -3.119768e-01,  7.393069e-01,  5.130002e-01, -1.014831e+00,  6.386304e-01},
  { 5.136462e-01,  1.105217e-01,  8.508540e-01,  5.688578e-01, -1.019711e+00,  6.386304e-01},
  { 8.122297e-01, -1.618845e-01,  5.604251e-01,  5.696413e-01, -1.036174e+00,  6.386304e-01},
  { 5.673669e-01, -4.079911e-01,  7.152888e-01,  5.543536e-01, -1.082623e+00,  6.386304e-01},
  {-5.684275e-01,  1.025998e-01,  8.163109e-01,  5.147646e-01, -1.046209e+00,  6.386304e-01},
  { 4.344518e-01, -7.051092e-01,  5.604219e-01,  5.314250e-01, -1.106063e+00,  6.386304e-01},
  {-3.585581e-01,  5.822613e-01,  7.296629e-01,  5.016330e-01, -1.063044e+00,  6.386304e-01},
  {-7.042155e-01, -4.145911e-01, -5.763634e-01,  3.281837e-01, -4.634736e-01,  5.651345e-01},
  {-2.735056e-02,  5.552102e-01,  8.312603e-01, -1.988317e-01,  9.493718e-01,  6.386304e-01},
  { 4.165599e-02,  5.097693e-01, -8.593020e-01, -2.427330e-01,  9.488634e-01,  5.651345e-01},
  {-7.447498e-01,  2.331618e-01, -6.252866e-01, -5.104537e-01,  1.018419e+00,  5.651345e-01},
  { 2.398479e-01,  3.758312e-01, -8.951111e-01, -4.902675e-01,  1.103439e+00,  5.651345e-01},
  {-6.274487e-01, -2.727177e-01, -7.293375e-01, -5.122181e-01,  1.049798e+00,  5.651345e-01},
  { 4.298730e-01,  6.714465e-01,  6.036296e-01, -4.902675e-01,  1.103439e+00,  6.386304e-01},
  { 2.105517e-01,  5.560005e-01, -8.040717e-01, -5.188811e-01,  1.118355e+00,  5.651345e-01},
  {-2.957799e-01, -4.391214e-01, -8.483435e-01, -5.269167e-01,  1.065144e+00,  5.651345e-01},
  {-2.011202e-01, -8.504360e-01, -4.861166e-01, -5.369127e-01,  1.069102e+00,  5.651345e-01},
  { 3.287107e-03,  8.283228e-01, -5.602416e-01, -5.508277e-01,  1.122313e+00,  5.651345e-01},
  {-2.620281e-01,  6.482258e-01, -7.149437e-01, -5.819908e-01,  1.114806e+00,  5.651345e-01},
  { 1.438102e-01, -4.078078e-01, -9.016715e-01, -5.582757e-01,  1.067985e+00,  5.651345e-01},
  {-7.008429e-01,  5.482777e-01, -4.563011e-01, -6.192278e-01,  1.084506e+00,  5.651345e-01},
  { 4.256619e-01, -4.028726e-01, -8.102503e-01, -5.755222e-01,  1.055520e+00,  5.651345e-01},
  {-5.854537e-01,  1.212803e-01, -8.015829e-01, -6.329469e-01,  1.055363e+00,  5.651345e-01},
  { 8.831295e-01, -8.080065e-02, -4.621185e-01, -5.833620e-01,  1.035706e+00,  5.651345e-01},
  { 6.894695e-01, -6.308200e-02,  7.215626e-01, -5.833620e-01,  1.035706e+00,  6.386304e-01},
  {-5.677757e-01,  1.887673e-01, -8.012475e-01, -6.411784e-01,  9.792998e-01,  5.651345e-01},
  {-6.911229e-01,  1.220913e-01,  7.123501e-01, -6.370634e-01,  9.936066e-01,  6.386304e-01},
  { 5.819904e-01,  3.782932e-01, -7.198482e-01, -5.792470e-01,  1.014793e+00,  5.651345e-01},
  { 2.839483e-01,  6.331546e-01, -7.200616e-01, -5.645469e-01,  9.994472e-01,  5.651345e-01},
  { 1.470281e-01,  8.034261e-01, -5.769655e-01, -5.419188e-02,  8.408535e-01,  5.651345e-01},
  { 2.276809e-01, -5.519956e-01, -8.021610e-01, -4.713716e-02,  7.851723e-01,  5.651345e-01},
  {-1.659240e-01,  6.738976e-01,  7.199522e-01, -3.282734e-02,  8.419899e-01,  6.386304e-01},
  { 3.732658e-01, -5.930306e-01, -7.134334e-01, -1.273977e-03,  7.990290e-01,  5.651345e-01},
  {-2.936065e-01,  6.288592e-01, -7.199522e-01, -3.282734e-02,  8.419899e-01,  5.651345e-01},
  { 6.686136e-01, -4.887223e-01, -5.604520e-01,  2.400819e-02,  8.200975e-01,  5.651345e-01},
  {-4.953302e-01,  3.131691e-01, -8.102921e-01, -1.558080e-02,  8.544351e-01,  5.651345e-01},
  {-5.039678e-01,  4.773368e-01,  7.198375e-01, -1.558080e-02,  8.544351e-01,  6.386304e-01},
  { 5.113144e-01, -4.807006e-01,  7.123793e-01,  2.400819e-02,  8.200975e-01,  6.386304e-01},
  { 5.233629e-01, -1.498223e-01, -8.388352e-01,  4.007944e-02,  8.488502e-01,  5.651345e-01},
  {-5.748159e-01, -5.998259e-02, -8.160813e-01, -7.742553e-03,  8.742699e-01,  5.651345e-01},
  { 8.648117e-01,  1.990922e-01, -4.609371e-01,  4.243002e-02,  8.978475e-01,  5.651345e-01},
  { 4.823624e-01,  5.054442e-01, -7.154387e-01,  1.891228e-02,  9.408472e-01,  5.651345e-01},
  {-3.737649e-01, -3.593467e-01, -8.550846e-01, -1.812876e-02,  9.039034e-01,  5.651345e-01},
  { 2.502370e-01,  6.556523e-01, -7.123914e-01, -8.134316e-03,  9.597400e-01,  5.651345e-01},
  { 2.780527e-03,  7.020413e-01, -7.121309e-01, -4.007944e-02,  9.676576e-01,  5.651345e-01},
  {-6.735978e-02, -6.738673e-01, -7.357755e-01, -4.733155e-02,  9.154469e-01,  5.651345e-01},
  {-2.340338e-02,  3.702263e-01, -9.286467e-01, -1.988317e-01,  9.493718e-01,  5.651345e-01},
  { 4.487299e-01, -5.194220e-01, -7.272154e-01, -7.535905e-02,  9.009038e-01,  5.651345e-01},
  { 8.080839e-01, -1.517263e-01, -5.691919e-01, -8.319730e-02,  8.810704e-01,  5.651345e-01},
  { 3.993114e-01, -4.450062e-01, -8.015735e-01, -8.574525e-02,  7.627311e-01,  5.651345e-01},
  { 6.551696e-01,  3.920848e-01, -6.457726e-01, -7.888491e-02,  8.601575e-01,  5.651345e-01},
  { 6.675704e-01,  2.061623e-01, -7.154348e-01, -3.685578e-01,  7.354887e-01,  5.651345e-01},
  { 3.701271e-02,  8.217229e-01, -5.686841e-01, -8.465759e-01,  6.066270e-01,  5.651345e-01},
  {-4.381357e-01,  5.245814e-01, -7.299668e-01, -8.263881e-01,  6.137012e-01,  5.651345e-01},
  {-3.049031e-01,  3.243457e-01, -8.954518e-01, -8.079663e-01,  7.593413e-01,  5.651345e-01},
  {-3.199521e-01,  7.323363e-01, -6.010942e-01, -8.326608e-01,  7.423684e-01,  5.651345e-01},
  {-4.002517e-01,  5.819991e-01,  7.078670e-01, -8.197252e-01,  7.499136e-01,  6.386304e-01},
  {-4.601416e-01, -3.842897e-01, -8.003694e-01, -8.212937e-01,  6.706369e-01,  5.651345e-01},
  {-1.237501e-01, -5.245809e-01, -8.423187e-01, -8.399114e-01,  6.812010e-01,  5.651345e-01},
  { 1.771146e-01, -6.533536e-01, -7.360432e-01, -8.610786e-01,  6.800826e-01,  5.651345e-01},
  {-3.156673e-01,  5.030857e-01, -8.045241e-01, -8.920458e-01,  7.234367e-01,  5.651345e-01},
  { 3.399876e-01, -5.850291e-01, -7.363079e-01, -8.706828e-01,  6.751048e-01,  5.651345e-01},
  {-5.816474e-01,  3.881733e-01, -7.148481e-01, -9.169362e-01,  7.030919e-01,  5.651345e-01},
  { 6.522633e-01, -2.040025e-01, -7.300244e-01, -8.838128e-01,  6.582695e-01,  5.651345e-01},
  {-8.182412e-01,  1.135829e-01, -5.635426e-01, -9.375142e-01,  6.595629e-01,  5.651345e-01},
  {-6.653227e-01, -2.147435e-01, -7.150041e-01, -9.371225e-01,  6.273037e-01,  5.651345e-01},
  { 5.917473e-01,  3.487668e-01, -7.267715e-01, -8.820499e-01,  6.268910e-01,  5.651345e-01},
  {-5.059822e-01, -4.823727e-01, -7.150515e-01, -9.157594e-01,  5.842442e-01,  5.651345e-01},
  { 2.675103e-01,  4.675576e-01, -8.425130e-01, -8.673498e-01,  6.115465e-01,  5.651345e-01},
  {-1.806788e-01, -4.025557e-01, -8.973874e-01, -8.902814e-01,  5.644497e-01,  5.651345e-01},
  {-9.106814e-02, -4.357728e-01, -8.954377e-01, -5.851264e-01,  4.695324e-01,  5.651345e-01},
  {-9.924161e-02, -6.997184e-01,  7.074922e-01, -5.621948e-01,  4.658675e-01,  6.386304e-01},
  { 4.617412e-02, -4.367499e-01,  8.983972e-01, -2.958454e-01,  4.374677e-01,  6.386304e-01},
  { 2.656542e-02, -8.254696e-01, -5.638211e-01, -5.088866e-01,  5.429491e-01,  5.651345e-01},
  { 1.603955e-01, -6.838287e-01, -7.117947e-01, -4.832112e-01,  5.491037e-01,  5.651345e-01},
  { 4.638744e-01, -2.110796e-01,  8.603871e-01, -2.035358e-01,  6.109768e-01,  6.386304e-01},
  { 3.795770e-01, -2.292124e-01, -8.963163e-01, -2.035358e-01,  6.109768e-01,  5.651345e-01},
  { 7.280412e-01, -3.006602e-02, -6.848738e-01, -3.665974e-01,  7.091478e-01,  5.651345e-01},
  { 2.258128e-01,  6.705595e-01, -7.066531e-01, -2.856550e-01,  9.581132e-01,  5.651345e-01},
  { 9.915420e-02,  5.047194e-01,  8.575703e-01, -2.644879e-01,  9.522727e-01,  6.386304e-01},
  { 5.805057e-01,  3.742519e-01, -7.231520e-01, -3.848249e-01,  7.856238e-01,  5.651345e-01},
  { 3.016992e-01,  4.647227e-01, -8.324725e-01, -3.254399e-01,  9.766935e-01,  5.651345e-01},
  { 2.995676e-01,  6.410694e-01,  7.066041e-01, -3.060372e-01,  9.662864e-01,  6.386304e-01},
  { 4.038834e-01,  3.719380e-01, -8.357872e-01, -4.157921e-01,  8.282901e-01,  5.651345e-01},
  { 3.925237e-01,  5.851153e-01, -7.096233e-01, -4.357825e-01,  8.454784e-01,  5.651345e-01},
  { 2.036135e-01,  6.689981e-01, -7.148308e-01, -4.828195e-01,  8.694671e-01,  5.651345e-01},
  {-3.478751e-01,  6.006096e-01, -7.198966e-01, -5.235853e-01,  1.001603e+00,  5.651345e-01},
  {-2.261331e-02,  4.320342e-01, -9.015737e-01, -5.437730e-01,  9.945277e-01,  5.651345e-01},
  { 2.834935e-02,  6.998212e-01, -7.137554e-01, -5.347565e-01,  8.777779e-01,  5.651345e-01},
  {-1.313426e-01,  4.921085e-01, -8.605686e-01, -5.612154e-01,  8.757188e-01,  5.651345e-01},
  {-4.220414e-01,  2.943769e-01, -8.574517e-01, -6.554868e-01,  9.533313e-01,  5.651345e-01},
  {-3.897901e-01,  2.149152e-01,  8.954748e-01, -6.472552e-01,  9.657571e-01,  6.386304e-01},
  {-2.924854e-01,  6.364613e-01, -7.137011e-01, -6.113880e-01,  8.594921e-01,  5.651345e-01},
  {-4.358588e-01,  5.536471e-01, -7.095788e-01, -6.339278e-01,  8.457131e-01,  5.651345e-01},
  {-6.406498e-01,  4.640532e-01, -6.117374e-01, -6.711648e-01,  8.084956e-01,  5.651345e-01},
  {-3.895918e-01,  3.365316e-01,  8.573008e-01, -7.979704e-01,  7.704542e-01,  6.386304e-01},
  {-6.309906e-01,  2.921953e-01, -7.186604e-01, -6.850798e-01,  7.859767e-01,  5.651345e-01},
  {-7.044581e-01, -4.704862e-03, -7.097300e-01, -7.035031e-01,  7.095411e-01,  5.651345e-01},
  {-6.898654e-01,  1.382849e-01, -7.106075e-01, -7.013469e-01,  7.358819e-01,  5.651345e-01},
  {-5.167646e-01,  4.642723e-02, -8.548677e-01, -8.109060e-01,  6.409841e-01,  5.651345e-01},
  {-7.594505e-01, -2.368383e-01, -6.059229e-01, -6.952716e-01,  6.574860e-01,  5.651345e-01},
  {-5.925139e-01, -3.797788e-01, -7.104192e-01, -6.852772e-01,  6.330456e-01,  5.651345e-01},
  {-4.880944e-01, -5.046591e-01, -7.120977e-01, -6.543100e-01,  5.903794e-01,  5.651345e-01},
  {-1.376039e-01, -4.953016e-01,  8.577537e-01, -6.074689e-01,  4.753326e-01,  6.386304e-01},
  {-3.062275e-01, -4.581923e-01, -8.344366e-01, -6.341237e-01,  5.731911e-01,  5.651345e-01},
  {-2.931599e-01, -7.771348e-01, -5.568832e-01, -5.872826e-01,  5.492218e-01,  5.651345e-01},
  {-8.356348e-02, -6.972390e-01, -7.119514e-01, -5.616072e-01,  5.430089e-01,  5.651345e-01},
  { 5.673637e-02, -5.420227e-01, -8.384464e-01, -2.958454e-01,  4.374677e-01,  5.651345e-01},
  { 7.558870e-02,  8.075444e-01, -5.849431e-01, -2.993742e-01,  4.896992e-01,  5.651345e-01},
  { 5.807156e-01, -3.953249e-01,  7.116795e-01, -2.297974e-01,  4.725305e-01,  6.386304e-01},
  {-3.141975e-01,  4.377991e-01,  8.423846e-01, -2.791865e-01,  4.967749e-01,  6.386304e-01},
  { 3.539277e-01, -6.026486e-01, -7.152271e-01, -2.523372e-01,  4.517356e-01,  5.651345e-01},
  {-4.036904e-01,  5.624975e-01, -7.215474e-01, -2.791865e-01,  4.967749e-01,  5.651345e-01},
  { 5.316469e-01, -4.591992e-01, -7.116795e-01, -2.297974e-01,  4.725305e-01,  5.651345e-01},
  {-5.720332e-01,  1.790850e-01,  8.004415e-01, -2.660564e-01,  5.135908e-01,  6.386304e-01},
  {-4.045388e-01,  1.266480e-01, -9.057089e-01, -2.660564e-01,  5.135908e-01,  5.651345e-01},
  { 7.724447e-01, -3.000063e-01, -5.597547e-01, -2.154906e-01,  4.997146e-01,  5.651345e-01},
  { 8.018765e-01, -2.089706e-01,  5.597547e-01, -2.154906e-01,  4.997146e-01,  6.386304e-01},
  { 7.978787e-01, -3.388873e-02, -6.018646e-01, -2.111782e-01,  5.301121e-01,  5.651345e-01},
  {-6.841191e-01, -3.576371e-01, -6.356703e-01, -2.678193e-01,  5.449677e-01,  5.651345e-01},
  { 6.888472e-01, -1.335662e-01, -7.124953e-01, -2.139220e-01,  5.790316e-01,  5.651345e-01},
  {-2.052828e-01, -4.480008e-01,  8.701462e-01, -2.925139e-01,  5.642732e-01,  6.386304e-01},
  {-1.043646e-01, -5.682880e-01, -8.161843e-01, -2.925139e-01,  5.642732e-01,  5.651345e-01},
  { 5.629157e-01, -2.175558e-01, -7.973677e-01, -3.748305e-01,  6.571136e-01,  5.651345e-01},
  { 4.815262e-01, -2.706158e-01, -8.336064e-01, -3.850208e-01,  6.326928e-01,  5.651345e-01},
  { 2.937076e-01, -6.287273e-01, -7.200263e-01, -3.138769e-01,  5.631563e-01,  5.651345e-01},
  { 5.226543e-01, -4.710215e-01, -7.106133e-01, -4.159880e-01,  5.901042e-01,  5.651345e-01},
  { 5.867458e-01, -3.709942e-01, -7.197865e-01, -3.311234e-01,  5.506917e-01,  5.651345e-01},
  { 5.366201e-01, -4.908707e-02, -8.423950e-01, -3.389632e-01,  5.308762e-01,  5.651345e-01},
  { 3.495861e-01, -6.106888e-01, -7.105271e-01, -4.587126e-01,  5.591773e-01,  5.651345e-01},
  { 5.330512e-01,  2.447475e-01, -8.099106e-01, -3.348482e-01,  5.099648e-01,  5.651345e-01},
  { 3.401271e-01,  5.941089e-01, -7.289363e-01, -3.201481e-01,  4.946187e-01,  5.651345e-01},
  { 3.896273e-01, -3.345304e-01,  8.580676e-01, -9.574119e-02,  7.516391e-01,  6.386304e-01},
  { 3.393288e-01,  4.774845e-01,  8.104718e-01, -5.645469e-01,  9.994472e-01,  6.386304e-01},
  { 6.441476e-01,  2.586357e-01,  7.198482e-01, -5.792470e-01,  1.014793e+00,  6.386304e-01},
  {-5.645831e-01,  1.846901e-01,  8.044473e-01, -6.329469e-01,  1.055363e+00,  6.386304e-01},
  {-5.498487e-01,  4.301532e-01,  7.159851e-01, -6.192278e-01,  1.084506e+00,  6.386304e-01},
  { 4.953631e-01, -3.132248e-01,  8.102503e-01, -5.755222e-01,  1.055520e+00,  6.386304e-01},
  {-3.566360e-01,  6.013868e-01,  7.149437e-01, -5.819908e-01,  1.114806e+00,  6.386304e-01},
  { 2.302094e-01, -6.528130e-01,  7.216916e-01, -5.582757e-01,  1.067985e+00,  6.386304e-01},
  {-9.675132e-02,  8.226594e-01,  5.602416e-01, -5.508277e-01,  1.122313e+00,  6.386304e-01},
  { 1.423497e-01,  5.772393e-01,  8.040717e-01, -5.188811e-01,  1.118355e+00,  6.386304e-01},
  {-2.056932e-01, -6.519303e-01,  7.298474e-01, -5.369127e-01,  1.069102e+00,  6.386304e-01},
  {-6.954178e-01, -4.726318e-01,  5.413070e-01, -5.122181e-01,  1.049798e+00,  6.386304e-01},
  { 2.110265e-01,  3.049938e-01,  9.286800e-01, -3.434715e-01,  9.891970e-01,  6.386304e-01},
  {-5.052258e-01,  1.581730e-01,  8.483679e-01, -5.104537e-01,  1.018419e+00,  6.386304e-01},
  { 3.051155e-01, -6.368328e-01,  7.080597e-01, -1.273977e-03,  7.990290e-01,  6.386304e-01},
  { 3.007929e-01,  7.531142e-01,  5.851007e-01, -5.419188e-02,  8.408535e-01,  6.386304e-01},
  { 3.097595e-01, -5.103972e-01,  8.022118e-01, -7.398638e-02,  7.721589e-01,  6.386304e-01},
  { 3.085537e-01,  2.980865e-01,  9.032935e-01, -7.261372e-02,  8.514176e-01,  6.386304e-01},
  { 6.691172e-01,  1.856753e-01,  7.195880e-01, -8.260965e-02,  8.703104e-01,  6.386304e-01},
  { 8.177546e-01, -3.125428e-02,  5.747179e-01, -8.319730e-02,  8.810704e-01,  6.386304e-01},
  { 8.704850e-02,  6.966291e-01,  7.121308e-01, -4.007944e-02,  9.676576e-01,  6.386304e-01},
  { 5.625225e-01, -3.933525e-01,  7.272154e-01, -7.535905e-02,  9.009038e-01,  6.386304e-01},
  { 1.357601e-01, -6.634784e-01,  7.357755e-01, -4.733155e-02,  9.154469e-01,  6.386304e-01},
  { 3.290949e-01,  6.198348e-01,  7.123914e-01, -8.134316e-03,  9.597400e-01,  6.386304e-01},
  { 5.550269e-01,  4.243729e-01,  7.154387e-01,  1.891228e-02,  9.408472e-01,  6.386304e-01},
  {-5.561739e-01, -5.347192e-01,  6.361964e-01, -1.812876e-02,  9.039034e-01,  6.386304e-01},
  { 6.758426e-01,  1.555888e-01,  7.204366e-01,  4.243002e-02,  8.978475e-01,  6.386304e-01},
  {-4.878889e-01,  7.034984e-02,  8.700663e-01, -7.742553e-03,  8.742699e-01,  6.386304e-01},
  { 8.551748e-01, -2.448096e-01,  4.568855e-01,  4.007944e-02,  8.488502e-01,  6.386304e-01},
  {-1.225429e-01,  8.133767e-01,  5.686841e-01, -8.465759e-01,  6.066270e-01,  6.386304e-01},
  {-2.629455e-01, -4.360323e-01,  8.606599e-01, -8.902814e-01,  5.644497e-01,  6.386304e-01},
  { 3.911919e-01,  6.837297e-01,  6.160216e-01, -8.673498e-01,  6.115465e-01,  6.386304e-01},
  {-5.732664e-01, -4.000838e-01,  7.150515e-01, -9.157594e-01,  5.842442e-01,  6.386304e-01},
  { 6.586873e-01,  1.947673e-01,  7.267715e-01, -8.820499e-01,  6.268910e-01,  6.386304e-01},
  {-6.901370e-01, -1.117132e-01,  7.150041e-01, -9.371225e-01,  6.273037e-01,  6.386304e-01},
  {-7.912308e-01,  2.374312e-01,  5.635426e-01, -9.375142e-01,  6.595629e-01,  6.386304e-01},
  { 4.046094e-01, -1.265460e-01,  9.056916e-01, -8.838128e-01,  6.582695e-01,  6.386304e-01},
  {-5.170242e-01,  4.708271e-01,  7.148481e-01, -9.169362e-01,  7.030919e-01,  6.386304e-01},
  {-2.895187e-01,  6.364394e-01,  7.149293e-01, -8.920458e-01,  7.234367e-01,  6.386304e-01},
  { 4.293022e-01, -5.358142e-01,  7.270508e-01, -8.706828e-01,  6.751048e-01,  6.386304e-01},
  {-1.994652e-01,  5.161792e-01,  8.329301e-01, -8.467718e-01,  7.369002e-01,  6.386304e-01},
  {-5.205730e-02, -8.463173e-01,  5.301294e-01, -8.399114e-01,  6.812010e-01,  6.386304e-01},
  {-2.691957e-01, -2.248203e-01,  9.364772e-01, -8.212937e-01,  6.706369e-01,  6.386304e-01},
  {-2.248337e-01,  2.691942e-01,  9.364744e-01, -8.263881e-01,  6.137012e-01,  6.386304e-01},
  {-8.729916e-01,  7.843142e-02,  4.813876e-01, -8.109060e-01,  6.409841e-01,  6.386304e-01},
  {-4.118529e-02,  7.868577e-01,  6.157587e-01, -5.437730e-01,  9.945277e-01,  6.386304e-01},
  {-4.576336e-01,  5.218434e-01,  7.198966e-01, -5.235853e-01,  1.001603e+00,  6.386304e-01},
  { 4.199217e-01,  5.426848e-01,  7.274331e-01, -3.285770e-01,  5.012233e-01,  6.386304e-01},
  {-7.136215e-02,  6.828573e-01,  7.270581e-01, -2.993742e-01,  4.896992e-01,  6.386304e-01},
  { 7.869877e-01, -4.417899e-02,  6.153851e-01, -3.389632e-01,  5.308762e-01,  6.386304e-01},
  { 5.041848e-01, -4.771844e-01,  7.197865e-01, -3.311234e-01,  5.506917e-01,  6.386304e-01},
  { 1.963180e-01, -7.986430e-01,  5.688837e-01, -3.138769e-01,  5.631563e-01,  6.386304e-01},
  { 5.927966e-01, -3.965421e-02,  8.043754e-01, -2.139220e-01,  5.790316e-01,  6.386304e-01},
  {-5.967432e-01, -3.119596e-01,  7.393097e-01, -2.678193e-01,  5.449677e-01,  6.386304e-01},
  { 7.047521e-01, -2.993332e-02,  7.088218e-01, -2.111782e-01,  5.301121e-01,  6.386304e-01},
  { 4.017248e-01, -6.840348e-01,  6.088626e-01, -2.523372e-01,  4.517356e-01,  6.386304e-01},
  {-9.726905e-01, -2.321060e-01, -2.626352e-09, -1.181129e+00,  1.333908e-01,  2.284247e-01},
  {-6.912597e-01,  1.999337e-01, -6.943964e-01, -1.181129e+00,  1.333908e-01,  1.380740e-01},
  {-4.641823e-01, -5.965946e-01, -6.546829e-01, -1.057851e+00,  3.747467e-02,  4.792069e-02},
  { 3.214234e-01, -7.763517e-01, -5.421853e-01, -9.345745e-01, -5.844296e-02,  1.380740e-01},
  { 2.254981e-01, -9.385389e-01,  2.613340e-01, -9.345745e-01, -5.844296e-02,  3.185810e-01},
  {-8.987641e-01,  6.684540e-02,  4.333067e-01, -1.181129e+00,  1.333908e-01,  3.185810e-01},
  {-2.206867e-01, -2.834238e-01,  9.332568e-01, -1.057851e+00,  3.747467e-02,  4.087344e-01},
  { 8.426622e-01,  4.003024e-01,  3.601090e-01, -9.045882e-01, -1.977506e-02,  3.185810e-01},
  { 8.849972e-01,  2.121899e-01,  4.144338e-01, -9.281074e-01, -1.448925e-03,  3.201481e-01},
  { 5.741361e-01,  7.411405e-01,  3.479633e-01, -1.027865e+00,  7.614257e-02,  4.087344e-01},
  { 5.230356e-01,  4.927667e-01,  6.954241e-01, -1.008462e+00,  6.114941e-02,  3.826687e-01},
  { 2.745140e-01,  4.937414e-01,  8.251433e-01, -1.047072e+00,  9.115517e-02,  3.826687e-01},
  { 1.725108e-02,  9.437518e-01,  3.302042e-01, -1.150947e+00,  1.720602e-01,  3.185810e-01},
  {-1.129711e-02,  9.104525e-01,  4.134593e-01, -1.127428e+00,  1.537550e-01,  3.201481e-01},
  {-5.501671e-01,  8.325541e-01, -6.457348e-02, -1.150947e+00,  1.720602e-01,  2.284247e-01},
  {-3.354995e-01,  8.396884e-01,  4.270402e-01, -1.145066e+00,  1.673755e-01,  2.766385e-01},
  { 7.623031e-01,  1.740843e-01,  6.233689e-01, -9.553499e-01,  1.977655e-02,  3.546412e-01},
  { 7.258720e-01,  5.676892e-01,  3.883795e-01, -9.661294e-01,  2.818451e-02,  3.636577e-01},
  { 9.323422e-01, -2.474817e-01,  2.636109e-01, -9.104676e-01, -1.507091e-02,  2.766385e-01},
  { 9.615919e-01, -2.744831e-01,  9.804847e-05, -9.045882e-01, -1.977506e-02,  2.284247e-01},
  { 7.300386e-01,  3.371742e-01,  5.944386e-01, -9.635814e-01,  2.618532e-02,  3.611098e-01},
  { 6.484309e-01,  3.875874e-01,  6.552202e-01, -9.718129e-01,  3.261352e-02,  3.675784e-01},
  { 6.450173e-02,  8.359627e-01,  5.449825e-01, -1.100186e+00,  1.325280e-01,  3.546412e-01},
  { 3.464786e-01,  8.394030e-01,  4.187542e-01, -1.089406e+00,  1.241006e-01,  3.636577e-01},
  { 1.206433e-01,  7.771665e-01,  6.176224e-01, -1.091954e+00,  1.261193e-01,  3.611098e-01},
  { 1.150726e-01,  6.582046e-01,  7.439925e-01, -1.083723e+00,  1.196911e-01,  3.675784e-01},
  { 1.013071e-01,  9.776871e-01, -1.840242e-01, -1.150947e+00,  1.720602e-01,  1.380740e-01},
  {-3.518445e-01,  7.452692e-01, -5.663739e-01, -1.127428e+00,  1.537550e-01,  1.365070e-01},
  { 4.592641e-01,  5.954609e-01, -6.591682e-01, -1.027865e+00,  7.614257e-02,  4.792069e-02},
  { 2.783620e-01,  4.931951e-01, -8.241804e-01, -1.047072e+00,  9.115517e-02,  7.398638e-02},
  { 5.812428e-01,  6.022673e-01, -5.472029e-01, -1.008462e+00,  6.114941e-02,  7.398638e-02},
  { 8.959932e-01,  1.780021e-02, -4.437108e-01, -9.281074e-01, -1.448925e-03,  1.365070e-01},
  { 8.374574e-01,  5.064183e-01, -2.054399e-01, -9.045882e-01, -1.977506e-02,  1.380740e-01},
  {-2.184569e-02,  7.733996e-01, -6.335422e-01, -1.100186e+00,  1.325280e-01,  1.020109e-01},
  { 1.351810e-01,  6.488687e-01, -7.487960e-01, -1.083723e+00,  1.196911e-01,  8.927411e-02},
  { 2.780725e-01,  8.228580e-01, -4.955606e-01, -1.089406e+00,  1.241006e-01,  9.299736e-02},
  {-8.500981e-02,  9.726419e-01, -2.161964e-01, -1.145066e+00,  1.673755e-01,  1.800166e-01},
  { 9.646373e-01,  1.507379e-01, -2.162241e-01, -9.104676e-01, -1.507091e-02,  1.800166e-01},
  { 3.437189e-01, -2.040954e-01, -9.166256e-01, -9.718129e-01,  3.261352e-02,  8.927411e-02},
  { 5.916522e-01, -1.985303e-01, -7.813664e-01, -9.553499e-01,  1.977655e-02,  1.020109e-01},
  { 6.979936e-01,  2.667815e-01, -6.645544e-01, -9.816115e-01,  4.017814e-02,  8.182463e-02},
  {-6.305215e-01,  7.341133e-01, -2.520323e-01, -6.574455e-01,  8.045361e-01,  2.135288e-01},
  {-7.024199e-01,  5.512292e-01, -4.502806e-01, -8.912608e-01,  4.782140e-01,  1.574768e-01},
  {-7.433967e-02,  9.564435e-01, -2.822931e-01, -6.449032e-01,  7.947959e-01,  1.574768e-01},
  {-7.019795e-01,  5.993861e-01, -3.846571e-01, -9.226198e-01,  4.092847e-01,  1.308219e-01},
  {-4.528986e-01,  7.031103e-01, -5.481958e-01, -6.347113e-01,  7.869367e-01,  1.365070e-01},
  {-4.229664e-01,  5.961976e-01, -6.823841e-01, -6.255004e-01,  7.798027e-01,  1.229837e-01},
  {-6.882802e-01,  1.768466e-01, -7.035593e-01, -6.302031e-01,  7.768241e-01,  1.249425e-01},
  {-9.317062e-01,  0.000000e+00, -3.632127e-01, -6.302031e-01,  7.766671e-01,  1.249425e-01},
  {-9.122162e-01,  1.746442e-01, -3.706224e-01, -6.302031e-01,  7.765684e-01,  1.249425e-01},
  {-7.293974e-01,  3.710471e-01, -5.747204e-01, -6.302031e-01,  7.669254e-01,  1.178878e-01},
  {-5.229735e-01,  4.072326e-01, -7.487726e-01, -7.603402e-01,  5.995514e-01,  1.178878e-01},
  {-5.928885e-01,  7.504063e-01, -2.921875e-01, -9.079197e-01,  4.217493e-01,  1.263151e-01},
  {-7.931206e-01,  4.054611e-01, -4.544898e-01, -9.524102e-01,  3.605027e-01,  1.233754e-01},
  {-7.324368e-01,  6.393985e-01, -2.338928e-01, -9.451581e-01,  3.782606e-01,  1.294492e-01},
  {-7.651092e-01,  6.262408e-01,  1.497672e-01, -9.226198e-01,  4.092847e-01, -2.646822e-01},
  {-9.097970e-01,  2.162270e-01, -3.542814e-01, -9.584855e-01,  3.226572e-01,  1.061289e-01},
  {-4.011888e-01,  8.446095e-01, -3.545173e-01, -8.738183e-01,  4.391543e-01,  1.102439e-01},
  {-6.203842e-01,  2.913903e-01, -7.281587e-01, -6.366717e-01,  7.211429e-01,  9.926856e-02},
  {-8.094998e-01, -1.168015e-01, -5.753846e-01, -9.524102e-01,  2.848117e-01,  8.829321e-02},
  {-4.216662e-01,  8.571562e-01,  2.957717e-01, -8.600992e-01,  4.424664e-01, -2.174494e-01},
  {-2.693797e-01,  8.598970e-01,  4.336032e-01, -8.359923e-01,  4.451504e-01, -2.051014e-01},
  {-2.429076e-01,  1.997279e-01, -9.492654e-01, -7.315307e-01,  5.723283e-01,  8.927411e-02},
  {-1.512526e-02,  8.792334e-01,  4.761511e-01, -8.167855e-01,  4.436417e-01, -1.968714e-01},
  {-1.714818e-01,  8.913457e-01, -4.196390e-01, -8.359923e-01,  4.451504e-01,  9.182207e-02},
  {-8.029618e-01, -3.182586e-01, -5.039482e-01, -9.451581e-01,  2.670552e-01,  8.143287e-02},
  {-9.083791e-03,  8.030968e-01, -5.957792e-01, -8.052225e-01,  4.408395e-01,  7.986582e-02},
  {-6.536531e-01,  1.618182e-01, -7.392919e-01, -6.302031e-01,  6.804758e-01,  8.358906e-02},
  {-5.015737e-01, -3.014303e-01, -8.109030e-01, -9.226198e-01,  2.360507e-01,  7.339724e-02},
  {-9.347806e-01,  2.080680e-01, -2.879113e-01, -6.221675e-01,  6.509007e-01,  7.614257e-02},
  {-8.973690e-01,  1.239423e-01, -4.235176e-01, -6.407866e-01,  5.734065e-01,  7.222196e-02},
  { 3.152105e-01,  8.017063e-01,  5.078478e-01, -7.803305e-01,  4.318036e-01, -1.860904e-01},
  { 4.639914e-01,  7.122131e-01, -5.267490e-01, -7.638676e-01,  4.217493e-01,  7.241933e-02},
  {-2.325879e-01, -6.867455e-01, -6.886824e-01, -8.916525e-01,  2.135108e-01,  7.398638e-02},
  {-7.619367e-01, -1.094545e-01, -6.383353e-01, -6.413743e-01,  5.327782e-01,  7.398638e-02},
  { 4.550775e-01,  3.060364e-01, -8.362095e-01, -7.430936e-01,  4.020729e-01,  7.398638e-02},
  {-9.727560e-01, -5.545703e-02,  2.251004e-01, -6.552909e-01,  5.344440e-01,  2.753705e-02},
  {-4.515814e-01, -2.631858e-01, -8.525301e-01, -6.370634e-01,  4.996563e-01,  7.986582e-02},
  { 6.055320e-01,  2.066950e-02, -7.955524e-01, -7.287868e-01,  3.816504e-01,  7.986582e-02},
  { 1.321002e-01, -8.036687e-01, -5.802295e-01, -8.551992e-01,  2.016742e-01,  8.437259e-02},
  { 8.342329e-01,  5.090820e-03, -5.513889e-01, -7.187909e-01,  3.577588e-01,  8.927411e-02},
  {-7.319211e-01, -5.071439e-01, -4.550785e-01, -6.286361e-01,  4.735308e-01,  8.927411e-02},
  {-6.147794e-01, -4.019810e-01, -6.785703e-01, -6.364758e-01,  4.966956e-01,  8.084672e-02},
  { 2.793666e-01, -9.041170e-01, -3.233062e-01, -8.167855e-01,  2.016742e-01,  1.004438e-01},
  {-1.679615e-01, -6.676676e-01, -7.252647e-01, -6.174648e-01,  4.539112e-01,  1.020109e-01},
  { 4.544818e-01, -8.598480e-01, -2.326108e-01, -7.981662e-01,  2.061615e-01,  1.102439e-01},
  { 1.814469e-01, -7.687889e-01, -6.132215e-01, -6.045291e-01,  4.402907e-01,  1.178878e-01},
  { 8.206339e-01, -2.574427e-01, -5.101797e-01, -7.134991e-01,  3.226572e-01,  1.061289e-01},
  {-3.884620e-01, -8.090558e-01, -4.410510e-01, -6.160921e-01,  4.519913e-01,  1.039727e-01},
  { 7.256117e-01, -5.839893e-01, -3.639289e-01, -7.368209e-01,  2.506520e-01,  1.319972e-01},
  { 6.422614e-01, -6.842989e-01, -3.453047e-01, -7.638676e-01,  2.235651e-01,  1.263151e-01},
  {-2.569306e-01, -9.397477e-01, -2.255235e-01, -5.984538e-01,  4.362146e-01,  1.263151e-01},
  { 1.471970e-01, -9.551501e-01, -2.569461e-01, -5.906141e-01,  4.320981e-01,  1.365070e-01},
  { 8.841279e-01, -3.958496e-01, -2.482362e-01, -7.193785e-01,  2.848117e-01,  1.233754e-01},
  {-1.012016e-01, -9.948659e-01,  1.136725e-04, -5.874785e-01,  4.313535e-01,  1.414055e-01},
  {-3.265177e-01, -8.978724e-01,  2.953154e-01, -5.749346e-01,  4.314507e-01,  1.574768e-01},
  {-2.555543e-01, -8.723946e-01,  4.166769e-01, -5.700346e-01,  4.330192e-01,  1.645315e-01},
  { 5.325573e-02, -9.543957e-01,  2.937562e-01, -5.586675e-01,  4.370759e-01,  1.800166e-01},
  { 1.060477e-01, -9.055369e-01,  4.108001e-01, -5.557277e-01,  4.390751e-01,  1.847207e-01},
  { 7.553680e-01, -5.999564e-01, -2.635746e-01, -7.229059e-01,  2.166868e-01,  2.039261e-01},
  { 1.695492e-01, -8.261656e-01,  5.373114e-01, -5.398524e-01,  4.519719e-01,  2.039261e-01},
  {-4.132527e-02, -6.433673e-01,  7.644414e-01, -5.188811e-01,  4.758425e-01,  2.284247e-01},
  { 2.322390e-01, -5.827379e-01,  7.787693e-01, -4.912468e-01,  5.143937e-01,  2.527290e-01},
  { 3.423826e-02, -5.104743e-01,  8.592111e-01, -4.838004e-01,  5.261332e-01,  2.580193e-01},
  { 5.379598e-01, -7.372900e-01,  4.086595e-01, -4.800756e-01,  5.437730e-01,  2.848715e-01},
  { 5.054084e-01, -7.681074e-01,  3.931583e-01, -5.033990e-01,  5.442634e-01,  3.201481e-01},
  { 3.407376e-01, -9.136381e-01,  2.217282e-01, -4.832112e-01,  5.491037e-01,  3.097619e-01},
  { 2.557367e-01, -9.325100e-01,  2.549976e-01, -4.824277e-01,  5.476338e-01,  2.952577e-01},
  { 2.697385e-01, -8.876136e-01,  3.733406e-01, -5.488674e-01,  5.420086e-01,  3.546412e-01},
  { 1.216008e-01, -8.152919e-01,  5.661380e-01, -5.725825e-01,  5.456735e-01,  3.675784e-01},
  {-2.827204e-01, -6.669214e-01,  6.894092e-01, -6.178566e-01,  5.631563e-01,  3.826687e-01},
  {-6.130131e-01, -3.929999e-01,  6.853948e-01, -6.564662e-01,  5.930245e-01,  3.826687e-01},
  {-8.260303e-01, -2.769481e-01,  4.908906e-01, -6.721457e-01,  6.117229e-01,  3.767893e-01},
  {-7.310399e-01,  1.445953e-01,  6.668380e-01, -6.940963e-01,  6.544864e-01,  3.546412e-01},
  {-8.864166e-01,  2.693286e-01,  3.764673e-01, -7.027196e-01,  6.996229e-01,  3.201481e-01},
  {-9.202943e-01,  3.512934e-01,  1.721957e-01, -7.005634e-01,  7.351956e-01,  2.817344e-01},
  {-2.062652e-01,  8.796456e-01, -4.285770e-01, -6.268716e-01,  7.807432e-01,  1.251399e-01},
  {-1.480160e-02,  9.638082e-01, -2.661853e-01, -6.413743e-01,  7.920715e-01,  1.584577e-01},
  { 9.982085e-01, -2.300314e-02, -5.523285e-02,  3.769836e-01, -7.375461e-01,  5.043784e-01},
  { 9.486480e-01, -3.064524e-01, -7.844651e-02,  3.689480e-01, -7.883662e-01,  5.022222e-01},
  { 9.728797e-01, -1.580956e-01, -1.688520e-01,  3.711042e-01, -7.602998e-01,  4.657673e-01},
  { 9.310602e-01, -3.634878e-01, -3.167852e-02,  3.701263e-01, -7.893067e-01,  5.373044e-01},
  { 8.148127e-01, -5.756775e-01, -6.837881e-02,  3.454303e-01, -8.342458e-01,  5.012413e-01},
  { 8.558212e-01, -4.756004e-01, -2.034067e-01,  3.550330e-01, -8.091401e-01,  4.628276e-01},
  { 7.246291e-01, -6.885868e-01, -2.758676e-02,  3.299482e-01, -8.548447e-01,  5.371071e-01},
  { 5.849799e-01, -8.067451e-01, -8.343223e-02,  3.091728e-01, -8.706813e-01,  5.018305e-01},
  { 4.225523e-01, -9.055108e-01, -3.872787e-02,  2.882030e-01, -8.851256e-01,  5.374988e-01},
  { 2.724533e-01, -9.607261e-01, -5.267328e-02,  2.633096e-01, -8.941018e-01,  5.037892e-01},
  {-1.063040e-01, -9.937406e-01, -3.433664e-02,  1.866795e-01, -9.002354e-01,  5.086908e-01},
  {-3.939956e-01, -9.171843e-01, -5.950160e-02,  1.351343e-01, -8.821859e-01,  4.851700e-01},
  {-1.660192e-01, -9.797794e-01, -1.116689e-01,  1.835424e-01, -8.976890e-01,  4.767427e-01},
  {-7.702684e-01, -6.376123e-01, -1.171061e-02,  9.397527e-02, -8.523566e-01,  4.939892e-01},
  {-8.706454e-01, -4.863604e-01, -7.368987e-02,  7.966844e-02, -8.345987e-01,  5.194687e-01},
  {-9.913468e-01, -9.949306e-02,  8.563071e-02,  4.909598e-02, -7.112442e-01,  5.151563e-01},
  {-8.054135e-01,  5.024255e-01,  3.144484e-01,  7.418077e-02, -6.369244e-01,  4.971263e-01},
  { 5.907181e-01,  8.067608e-01, -1.375633e-02,  3.093672e-01, -6.045860e-01,  5.159399e-01},
  { 8.007294e-01,  5.979074e-01, -3.659697e-02,  3.458220e-01, -6.409227e-01,  5.116305e-01},
  { 9.483327e-01,  3.142670e-01, -4.360580e-02,  3.691454e-01, -6.867261e-01,  5.075125e-01},
  { 8.694425e-01,  4.721846e-01, -1.452978e-01,  3.560139e-01, -6.604436e-01,  4.785071e-01},
  { 8.793921e-01,  4.740221e-01, -4.441267e-02,  3.601289e-01, -6.636973e-01,  5.392632e-01},
  { 9.754530e-01,  1.656216e-01, -1.451238e-01,  3.714960e-01, -7.090491e-01,  4.710606e-01},
  { 6.922510e-01, -6.956738e-01, -1.919027e-01,  3.246549e-01, -8.507881e-01,  4.624358e-01},
  { 4.429392e-01, -8.830291e-01, -1.551272e-01,  2.833014e-01, -8.811856e-01,  4.649838e-01},
  { 2.862501e-01, -9.346756e-01, -2.108135e-01,  2.533152e-01, -8.863398e-01,  4.308825e-01},
  { 1.353425e-01, -9.853240e-01, -1.040150e-01,  2.345015e-01, -8.973556e-01,  4.698853e-01},
  {-5.157764e-02, -9.854850e-01, -1.617373e-01,  2.033370e-01, -8.951007e-01,  4.398990e-01},
  { 1.146616e-01, -9.557675e-01, -2.708528e-01,  2.201947e-01, -8.862038e-01,  4.010905e-01},
  {-1.565561e-01, -9.695746e-01, -1.881893e-01,  1.706083e-01, -8.876542e-01,  4.148112e-01},
  { 8.039126e-01,  5.905457e-01, -7.057206e-02,  3.379838e-01, -6.347891e-01,  4.540084e-01},
  { 9.764031e-01,  1.104149e-01, -1.855954e-01,  3.671866e-01, -7.299023e-01,  4.326469e-01},
  { 8.933025e-01, -3.857968e-01, -2.305896e-01,  3.483700e-01, -8.040053e-01,  4.244139e-01},
  { 7.309652e-01, -5.937970e-01, -3.362960e-01,  3.256358e-01, -8.188026e-01,  3.861976e-01},
  { 6.221828e-01, -7.392274e-01, -2.577429e-01,  2.985892e-01, -8.625275e-01,  4.253948e-01},
  { 4.342978e-01, -8.463702e-01, -3.082902e-01,  2.680137e-01, -8.692697e-01,  3.912935e-01},
  { 1.743329e-01, -9.262157e-01, -3.342642e-01,  2.337180e-01, -8.710536e-01,  3.613071e-01},
  {-7.615432e-01, -6.274133e-01,  1.624948e-01,  6.242190e-02, -8.213117e-01,  4.373510e-01},
  { 4.920806e-01,  8.695488e-01,  4.173294e-02,  2.760493e-01, -5.822824e-01,  4.520496e-01},
  { 9.227000e-01,  3.527172e-01, -1.556131e-01,  3.434715e-01, -6.506435e-01,  4.179453e-01},
  { 9.578658e-01, -1.127427e-01, -2.641633e-01,  3.560139e-01, -7.485215e-01,  3.930549e-01},
  { 9.561711e-01,  1.798694e-01, -2.310496e-01,  3.573865e-01, -6.981321e-01,  4.036385e-01},
  { 8.945183e-01, -2.827861e-01, -3.462213e-01,  3.495453e-01, -7.732549e-01,  3.893317e-01},
  { 5.594792e-01, -7.229271e-01, -4.054129e-01,  2.780112e-01, -8.464562e-01,  3.522906e-01},
  {-4.845825e-01, -8.722661e-01, -6.581616e-02,  1.237672e-01, -8.734446e-01,  4.310769e-01},
  {-5.001497e-01, -8.641664e-01, -5.537847e-02,  1.155342e-01, -8.669775e-01,  4.052085e-01},
  { 2.143002e-01,  9.638527e-01,  1.583140e-01,  2.294056e-01, -5.680743e-01,  4.685126e-01},
  { 9.354667e-01,  2.329696e-02, -3.526461e-01,  3.477809e-01, -7.148299e-01,  3.640495e-01},
  { 8.242936e-01, -3.849154e-01, -4.151871e-01,  3.275946e-01, -7.878174e-01,  3.507236e-01},
  { 7.033522e-01, -5.194395e-01, -4.852612e-01,  2.997645e-01, -7.986552e-01,  3.144630e-01},
  { 3.605132e-01, -8.191194e-01, -4.461767e-01,  2.429289e-01, -8.498087e-01,  3.221069e-01},
  {-1.250487e-03, -9.476376e-01, -3.193456e-01,  1.729589e-01, -8.715635e-01,  3.458220e-01},
  {-1.864246e-01, -9.653872e-01, -1.824100e-01,  1.610056e-01, -8.802256e-01,  3.850193e-01},
  {-3.643003e-01, -9.164959e-01, -1.652894e-01,  1.267069e-01, -8.670747e-01,  3.681645e-01},
  {-8.263879e-01, -4.759494e-01,  3.009237e-01,  4.380269e-02, -7.952445e-01,  4.302933e-01},
  {-8.063121e-01, -2.442436e-01,  5.387076e-01,  2.577262e-02, -7.445620e-01,  4.381346e-01},
  {-4.742983e-01,  7.654316e-01,  4.349201e-01,  1.027944e-01, -5.943164e-01,  4.738029e-01},
  { 6.021082e-01,  7.981238e-01,  2.154277e-02,  2.807535e-01, -5.821852e-01,  3.983482e-01},
  { 8.271683e-01,  5.390359e-01, -1.588487e-01,  3.228905e-01, -6.346710e-01,  3.613071e-01},
  { 8.933239e-01, -1.251091e-01, -4.316481e-01,  3.313178e-01, -7.292548e-01,  3.246549e-01},
  { 6.715679e-01, -4.801033e-01, -5.643557e-01,  2.833014e-01, -7.858377e-01,  2.811453e-01},
  { 4.719734e-01, -7.030818e-01, -5.318996e-01,  2.478275e-01, -8.229385e-01,  2.846741e-01},
  {-6.689889e-01, -7.398577e-01,  7.116478e-02,  5.928480e-02, -8.253295e-01,  3.858058e-01},
  {-6.287975e-01, -7.774721e-01, -1.228324e-02,  3.576706e-02, -8.070242e-01,  3.495453e-01},
  {-7.966671e-01, -5.431868e-01,  2.650840e-01,  1.656171e-02, -7.739801e-01,  3.842357e-01},
  {-8.293708e-01,  2.308728e-01,  5.087651e-01,  4.262740e-02, -6.763579e-01,  4.720385e-01},
  {-1.250408e-01,  8.844218e-01,  4.496253e-01,  1.698248e-01, -5.618808e-01,  4.549893e-01},
  { 4.890045e-01,  8.614568e-01,  1.369920e-01,  2.411645e-01, -5.550399e-01,  3.738495e-01},
  { 7.085899e-01,  7.023996e-01, -6.734498e-02,  2.864386e-01, -5.881230e-01,  3.626768e-01},
  { 9.156749e-01,  2.320274e-01, -3.281809e-01,  3.344549e-01, -6.802576e-01,  3.401400e-01},
  { 8.975818e-01,  1.137545e-01, -4.259188e-01,  3.195590e-01, -6.927820e-01,  3.007454e-01},
  { 8.240364e-01, -2.248163e-01, -5.200208e-01,  3.079975e-01, -7.409748e-01,  2.866329e-01},
  { 8.310082e-01, -3.311297e-02, -5.552738e-01,  2.976083e-01, -7.031099e-01,  2.625261e-01},
  { 5.288028e-01, -5.691660e-01, -6.296170e-01,  2.480249e-01, -7.910891e-01,  2.503754e-01},
  { 1.890118e-01, -8.733436e-01, -4.489382e-01,  2.049070e-01, -8.486708e-01,  2.970221e-01},
  {-1.498193e-01, -9.334954e-01, -3.257921e-01,  1.588494e-01, -8.605089e-01,  3.170110e-01},
  {-4.586429e-01, -8.823724e-01, -1.051928e-01,  9.378088e-02, -8.500823e-01,  3.566030e-01},
  { 6.847953e-01,  7.221757e-01, -9.755842e-02,  2.735014e-01, -5.781674e-01,  3.411179e-01},
  { 7.155900e-01, -3.165222e-01, -6.226916e-01,  2.785973e-01, -7.496579e-01,  2.513563e-01},
  { 2.904253e-01, -7.648578e-01, -5.750180e-01,  2.088246e-01, -8.233497e-01,  2.593920e-01},
  { 1.341589e-03, -8.921334e-01, -4.517700e-01,  1.651206e-01, -8.433012e-01,  2.778138e-01},
  { 1.219400e-01, -8.072592e-01, -5.774627e-01,  1.678630e-01, -8.198612e-01,  2.399892e-01},
  {-1.153230e-01, -8.985153e-01, -4.235219e-01,  1.249425e-01, -8.340499e-01,  2.646822e-01},
  {-2.983996e-02, -8.193137e-01, -5.725685e-01,  1.259234e-01, -8.127661e-01,  2.268577e-01},
  {-3.364006e-01, -9.171017e-01, -2.139141e-01,  9.985470e-02, -8.461826e-01,  3.185810e-01},
  { 8.350375e-01,  4.540890e-01, -3.106697e-01,  2.950603e-01, -6.129550e-01,  3.097619e-01},
  { 7.634420e-01,  5.872625e-01, -2.688476e-01,  2.605672e-01, -5.861432e-01,  2.650740e-01},
  { 8.652009e-01,  2.506270e-01, -4.342966e-01,  3.032933e-01, -6.559951e-01,  2.827153e-01},
  { 8.219480e-01,  1.728068e-01, -5.427148e-01,  2.831071e-01, -6.644031e-01,  2.444960e-01},
  { 7.404747e-01, -1.442014e-01, -6.564322e-01,  2.693864e-01, -7.109302e-01,  2.270521e-01},
  { 7.483857e-01,  3.023212e-02, -6.625745e-01,  2.562549e-01, -6.708313e-01,  2.086302e-01},
  { 5.845864e-01, -4.128977e-01, -6.984083e-01,  2.439068e-01, -7.551455e-01,  2.201947e-01},
  { 6.221338e-01, -2.446057e-01, -7.437188e-01,  2.354795e-01, -7.160844e-01,  1.954987e-01},
  { 3.715453e-01, -6.420626e-01, -6.706039e-01,  2.088246e-01, -7.926770e-01,  2.247015e-01},
  { 4.155869e-01, -4.970746e-01, -7.617115e-01,  2.047096e-01, -7.573990e-01,  1.941260e-01},
  {-3.536219e-01, -8.668861e-01, -3.513687e-01,  8.554788e-02, -8.214283e-01,  2.576275e-01},
  {-5.859658e-01, -7.929683e-01, -1.668693e-01,  6.575338e-02, -8.283275e-01,  3.134851e-01},
  {-5.276904e-01,  4.416519e-01,  7.255938e-01,  6.124661e-02, -5.941011e-01,  4.418578e-01},
  { 4.514188e-01,  8.757836e-01,  1.709509e-01,  1.864822e-01, -5.212526e-01,  3.477838e-01},
  { 8.135508e-01,  3.032801e-01, -4.961414e-01,  2.648796e-01, -6.260477e-01,  2.327371e-01},
  { 4.673415e-01, -3.541628e-01, -8.100374e-01,  1.968714e-01, -7.184948e-01,  1.688439e-01},
  { 2.034267e-01, -6.969937e-01, -6.876172e-01,  1.668850e-01, -7.907168e-01,  2.049070e-01},
  {-7.651384e-01, -6.367252e-01,  9.562524e-02,  7.545175e-03, -7.851708e-01,  3.189728e-01},
  {-5.798557e-01,  1.013533e-01,  8.083904e-01, -1.734523e-02, -6.596003e-01,  4.050111e-01},
  { 6.111458e-01,  7.912110e-01, -2.204524e-02,  2.311701e-01, -5.437117e-01,  3.221069e-01},
  { 6.785960e-01,  7.225330e-01, -1.321113e-01,  2.270521e-01, -5.419877e-01,  2.858494e-01},
  { 7.664014e-01,  4.726094e-01, -4.350508e-01,  2.437125e-01, -5.892205e-01,  2.274438e-01},
  { 7.416545e-01,  2.028255e-01, -6.393828e-01,  2.395975e-01, -6.305351e-01,  1.968714e-01},
  { 6.432164e-01, -6.910901e-02, -7.625593e-01,  2.233288e-01, -6.750839e-01,  1.766851e-01},
  { 2.021777e-01, -6.390975e-01, -7.420772e-01,  1.433643e-01, -7.723532e-01,  1.813893e-01},
  {-7.973438e-02, -8.043848e-01, -5.887337e-01,  1.037753e-01, -7.956168e-01,  2.049070e-01},
  {-9.256136e-03, -7.049582e-01, -7.091884e-01,  9.926856e-02, -7.665127e-01,  1.713918e-01},
  {-4.995733e-01, -8.606825e-01, -9.824596e-02,  3.243558e-02, -8.023590e-01,  2.770303e-01},
  {-4.617750e-01, -8.332503e-01, -3.040686e-01,  2.832058e-02, -7.904820e-01,  2.403810e-01},
  {-6.712516e-01, -7.383271e-01, -6.553084e-02,  1.860127e-03, -7.821922e-01,  2.838906e-01},
  { 2.097703e-01,  8.680749e-01,  4.499360e-01,  1.092630e-01, -5.147063e-01,  3.836496e-01},
  { 7.107601e-01,  5.709130e-01, -4.109483e-01,  2.205865e-01, -5.550399e-01,  2.284247e-01},
  { 6.513568e-01,  1.060481e-01, -7.513242e-01,  2.080411e-01, -6.333581e-01,  1.647289e-01},
  { 7.050973e-01,  3.764759e-01, -6.009191e-01,  2.201947e-01, -5.912989e-01,  1.917755e-01},
  { 5.156658e-01, -1.591786e-01, -8.418735e-01,  1.855043e-01, -6.771219e-01,  1.496385e-01},
  { 5.393284e-01,  1.355220e-02, -8.419865e-01,  1.729589e-01, -6.359061e-01,  1.384658e-01},
  { 3.569984e-01, -4.146195e-01, -8.370442e-01,  1.545370e-01, -7.182795e-01,  1.480685e-01},
  { 3.025938e-01, -3.065338e-01, -9.024822e-01,  1.455205e-01, -6.785335e-01,  1.296466e-01},
  { 1.848944e-01, -5.172117e-01, -8.356472e-01,  1.368987e-01, -7.366251e-01,  1.525782e-01},
  { 7.148817e-02, -5.583286e-01, -8.265341e-01,  9.358350e-02, -7.336450e-01,  1.435617e-01},
  {-1.480874e-01, -7.266902e-01, -6.708140e-01,  5.713160e-02, -7.592606e-01,  1.692356e-01},
  {-2.300400e-01, -8.216241e-01, -5.215510e-01,  6.203014e-02, -7.850736e-01,  2.015755e-01},
  {-3.949620e-01, -8.081298e-01, -4.369569e-01,  2.322467e-02, -7.729020e-01,  2.054931e-01},
  { 6.628445e-01,  7.442169e-01, -8.233120e-02,  2.092194e-01, -5.281309e-01,  2.709534e-01},
  { 4.913051e-01,  8.534377e-01,  1.739639e-01,  1.823672e-01, -5.056120e-01,  2.813426e-01},
  { 6.354679e-01,  2.827042e-01, -7.185116e-01,  1.917755e-01, -5.933953e-01,  1.606138e-01},
  {-1.813418e-01,  5.916442e-01,  7.855395e-01,  7.280810e-02, -5.403219e-01,  4.093235e-01},
  {-4.547285e-02,  7.208660e-01,  6.915811e-01,  9.103555e-02, -5.261511e-01,  3.979564e-01},
  { 9.340467e-02, -5.615090e-01, -8.221820e-01, -6.782210e-01, -1.329976e-01, -3.228934e-01},
  {-2.099803e-01, -7.380493e-01, -6.412421e-01, -7.144785e-01, -1.588285e-01, -2.968248e-01},
  {-4.185705e-01, -8.355144e-01, -3.559697e-01, -7.477978e-01, -1.729006e-01, -2.603728e-01},
  {-5.810387e-01, -8.121823e-01, -5.247807e-02, -7.856224e-01, -1.693149e-01, -1.935399e-01},
  {-6.109129e-01, -6.833977e-01,  3.996912e-01, -7.991456e-01, -1.507929e-01, -1.472849e-01},
  {-5.454749e-01, -1.142218e-01,  8.303074e-01, -7.922868e-01, -8.376551e-02, -7.104667e-02},
  {-4.889342e-01, -1.359329e-01,  8.616645e-01, -7.940512e-01, -2.459584e-02, -6.144398e-02},
  {-3.001578e-01,  2.366722e-01,  9.240626e-01, -7.283936e-01,  2.036420e-02, -4.047121e-02},
  { 6.008880e-01,  7.742180e-01,  1.987966e-01, -5.853223e-01,  9.172338e-02, -1.825645e-01},
  { 7.420060e-01,  6.194769e-01, -2.562722e-01, -5.692511e-01,  5.967956e-02, -2.505728e-01},
  { 6.824037e-01,  3.185308e-01, -6.579235e-01, -5.727784e-01,  2.575318e-02, -2.891809e-01},
  { 7.525072e-01,  1.514746e-01, -6.409276e-01, -6.080565e-01,  3.190775e-02, -3.234796e-01},
  { 7.564563e-01,  1.298253e-01, -6.410299e-01, -6.311840e-01,  6.026720e-02, -3.405317e-01},
  { 4.534432e-01, -2.115306e-01, -8.658199e-01, -6.454908e-01, -6.240246e-02, -3.483700e-01},
  { 1.442115e-01, -4.665115e-01, -8.726799e-01, -6.811607e-01, -9.948387e-02, -3.438632e-01},
  {-1.043402e-01, -6.549875e-01, -7.484013e-01, -7.189867e-01, -1.290769e-01, -3.250466e-01},
  { 2.396436e-02, -4.943213e-01, -8.689489e-01, -7.215347e-01, -9.479917e-02, -3.503318e-01},
  {-2.541918e-01, -6.841966e-01, -6.835654e-01, -7.611237e-01, -1.175139e-01, -3.266167e-01},
  {-3.726264e-01, -7.738010e-01, -5.122319e-01, -7.720990e-01, -1.533602e-01, -2.750714e-01},
  {-5.570772e-01, -8.066248e-01, -1.975387e-01, -7.999306e-01, -1.538507e-01, -2.317562e-01},
  {-5.285199e-01, -7.582664e-01, -3.817053e-01, -8.126689e-01, -1.306455e-01, -2.709564e-01},
  {-6.899078e-01, -7.184585e-01,  8.857070e-02, -8.185499e-01, -1.415236e-01, -1.853069e-01},
  {-6.095809e-01, -5.590046e-01,  5.620721e-01, -8.259963e-01, -1.176126e-01, -1.404276e-01},
  {-7.677063e-01, -6.093681e-01,  1.982360e-01, -8.495156e-01, -1.061468e-01, -1.794274e-01},
  {-6.645080e-01, -4.395271e-01,  6.043550e-01, -8.501033e-01, -7.827783e-02, -1.361152e-01},
  {-6.405790e-01, -2.963116e-01,  7.084193e-01, -8.381485e-01, -4.329280e-02, -1.002495e-01},
  {-7.690318e-01, -2.843688e-01,  5.724723e-01, -8.677430e-01, -3.653115e-02, -1.325863e-01},
  {-3.246145e-01,  2.479273e-01,  9.127746e-01, -7.828785e-01,  3.394581e-02, -6.359719e-02},
  { 6.916809e-01,  7.130002e-01,  1.149274e-01, -6.094292e-01,  1.128128e-01, -1.978523e-01},
  { 6.379686e-01, -1.017948e-01, -7.633046e-01, -6.311840e-01, -6.760154e-03, -3.483700e-01},
  { 5.376774e-02, -4.602007e-01, -8.861852e-01, -7.413292e-01, -7.243727e-02, -3.642469e-01},
  {-4.892761e-01, -7.176675e-01, -4.955425e-01, -8.203128e-01, -1.031294e-01, -3.079975e-01},
  {-6.680411e-01, -6.981199e-01, -2.575844e-01, -8.499073e-01, -1.018943e-01, -2.658605e-01},
  {-6.894169e-01, -7.193370e-01, -8.519729e-02, -8.367758e-01, -1.241978e-01, -2.258768e-01},
  {-7.823156e-01, -6.223448e-01,  2.587007e-02, -8.687224e-01, -8.940869e-02, -2.194112e-01},
  {-8.191407e-01, -4.856772e-01,  3.051656e-01, -8.747978e-01, -6.688979e-02, -1.735480e-01},
  {-6.153394e-01, -1.676600e-02,  7.880840e-01, -8.342279e-01,  1.705216e-02, -8.868497e-02},
  {-1.937822e-01,  3.391539e-01,  9.205559e-01, -7.942471e-01,  8.884347e-02, -8.535349e-02},
  { 8.505404e-01,  5.189791e-01,  8.509885e-02, -6.149169e-01,  1.171042e-01, -2.576275e-01},
  { 5.835711e-01, -3.909164e-02, -8.111206e-01, -6.582306e-01,  2.634232e-02, -3.683619e-01},
  { 3.648136e-01, -2.413002e-01, -8.992693e-01, -6.797895e-01, -2.677147e-02, -3.716933e-01},
  {-1.003195e-01, -5.526729e-01, -8.273383e-01, -7.813115e-01, -5.867772e-02, -3.691454e-01},
  {-4.062319e-01, -6.475615e-01, -6.447013e-01, -8.228608e-01, -7.216214e-02, -3.419044e-01},
  {-7.750463e-01, -6.141961e-01, -1.485475e-01, -8.826375e-01, -6.785125e-02, -2.595863e-01},
  {-8.414766e-01, -3.526326e-01,  4.093502e-01, -8.936129e-01, -2.489041e-02, -1.680603e-01},
  {-5.027962e-01,  1.450432e-01,  8.521493e-01, -8.342279e-01,  5.718992e-02, -9.299736e-02},
  {-2.633035e-01,  2.778323e-01,  9.238400e-01, -8.181566e-01,  1.304705e-01, -1.065207e-01},
  { 3.622080e-01, -4.073918e-01, -8.383539e-01, -7.080114e-01,  1.425000e-02, -3.942332e-01},
  { 8.285910e-02, -6.698107e-01, -7.378943e-01, -7.752361e-01, -2.293010e-02, -3.914878e-01},
  { 2.147455e-01, -5.961341e-01, -7.736332e-01, -7.523046e-01, -1.207138e-02, -3.961920e-01},
  {-3.130799e-01, -5.667723e-01, -7.620696e-01, -8.203128e-01, -3.866790e-02, -3.718907e-01},
  {-5.560964e-01, -6.071882e-01, -5.675203e-01, -8.600992e-01, -4.527255e-02, -3.399426e-01},
  {-4.618042e-01, -5.292887e-01, -7.117517e-01, -8.569636e-01, -1.266052e-02, -3.720851e-01},
  {-6.235017e-01, -6.600281e-01, -4.190568e-01, -8.577471e-01, -7.531718e-02, -3.040769e-01},
  {-7.440174e-01, -5.880057e-01, -3.173127e-01, -8.910649e-01, -4.207863e-02, -2.987866e-01},
  {-8.501116e-01, -5.084637e-01,  1.370219e-01, -8.949855e-01, -5.046565e-02, -2.127452e-01},
  {-8.894000e-01, -3.832751e-01,  2.491340e-01, -9.149759e-01, -8.485706e-03, -2.056905e-01},
  {-7.278391e-01, -1.279048e-01,  6.737140e-01, -8.787184e-01,  6.369886e-03, -1.300384e-01},
  {-6.049266e-01,  3.932356e-02,  7.953097e-01, -8.671539e-01,  6.499079e-02, -1.151424e-01},
  { 8.550190e-02,  5.577348e-01,  8.256035e-01, -7.285894e-01,  1.253163e-01, -1.012274e-01},
  { 5.180679e-01,  5.743685e-01,  6.338032e-01, -7.033073e-01,  1.673949e-01, -1.429755e-01},
  { 8.589569e-01,  5.084193e-01,  6.085233e-02, -6.268716e-01,  1.389383e-01, -2.405754e-01},
  { 8.886768e-01,  3.557987e-01, -2.892419e-01, -6.349072e-01,  1.456207e-01, -3.003536e-01},
  { 2.326612e-01, -3.039229e-01, -9.238504e-01, -7.421128e-01,  2.426388e-02, -4.087344e-01},
  {-1.334814e-01, -4.588455e-01, -8.784324e-01, -8.128648e-01, -3.643994e-03, -3.971729e-01},
  {-8.588598e-01, -5.109231e-01, -3.629506e-02, -9.098800e-01, -2.939718e-02, -2.525316e-01},
  {-8.433867e-01, -4.949196e-01, -2.091732e-01, -9.190909e-01, -4.233134e-03, -2.919262e-01},
  {-9.160300e-01, -3.933226e-01,  7.865430e-02, -9.310471e-01,  1.238689e-02, -2.446934e-01},
  {-8.240430e-01, -2.039914e-01,  5.285269e-01, -9.055676e-01,  1.861921e-02, -1.629644e-01},
  {-5.208170e-01,  1.249849e-01,  8.444692e-01, -8.616662e-01,  1.049536e-01, -1.172986e-01},
  { 6.105602e-02,  3.799968e-01,  9.229705e-01, -8.034580e-01,  1.621226e-01, -1.159289e-01},
  { 4.737493e-01,  3.398826e-01,  8.124293e-01, -7.191826e-01,  2.149807e-01, -1.629644e-01},
  { 8.142869e-01,  5.413352e-01,  2.095065e-01, -6.456867e-01,  1.516183e-01, -1.943234e-01},
  { 5.694447e-01, -8.249041e-02, -8.178803e-01, -6.795921e-01,  6.373625e-02, -3.873729e-01},
  { 1.110755e-01, -3.969836e-01, -9.110797e-01, -7.768032e-01,  3.982525e-02, -4.204963e-01},
  {-2.741067e-01, -4.609578e-01, -8.440281e-01, -8.252128e-01,  2.585187e-02, -4.104988e-01},
  {-6.882720e-01, -5.471785e-01, -4.763165e-01, -8.936129e-01, -1.285641e-02, -3.358276e-01},
  {-8.012437e-01, -4.662758e-01, -3.749606e-01, -9.222280e-01,  2.430426e-02, -3.299482e-01},
  {-8.984995e-01, -2.530927e-01,  3.586679e-01, -9.281074e-01,  3.535736e-02, -1.986358e-01},
  {-8.757468e-01, -1.270795e-01,  4.657449e-01, -9.343786e-01,  7.982694e-02, -1.917755e-01},
  {-7.706824e-01, -7.397298e-02,  6.329113e-01, -9.108594e-01,  6.244283e-02, -1.584577e-01},
  {-6.896465e-01,  5.464812e-02,  7.220812e-01, -9.092923e-01,  1.053842e-01, -1.547344e-01},
  { 8.383715e-01,  2.874446e-01,  4.631510e-01, -6.586223e-01,  2.286610e-01, -2.501810e-01},
  { 8.142480e-01,  2.340851e-02, -5.800450e-01, -6.627374e-01,  1.272377e-01, -3.718907e-01},
  { 4.888522e-01, -2.108456e-01, -8.465032e-01, -7.152635e-01,  9.384069e-02, -4.171618e-01},
  {-1.025018e-01, -3.924853e-01, -9.140288e-01, -8.109060e-01,  6.109110e-02, -4.295098e-01},
  {-5.880325e-01, -4.996112e-01, -6.360868e-01, -8.902814e-01,  1.891378e-02, -3.701263e-01},
  {-9.171292e-01, -3.873415e-01, -9.402522e-02, -9.412390e-01,  3.718010e-02, -2.838906e-01},
  {-8.920200e-01, -3.659187e-01, -2.653374e-01, -9.453540e-01,  6.522555e-02, -3.223043e-01},
  {-9.625024e-01, -2.701025e-01,  2.517452e-02, -9.569170e-01,  8.102316e-02, -2.744823e-01},
  {-9.424969e-01, -2.706736e-01,  1.960498e-01, -9.453540e-01,  5.630920e-02, -2.362660e-01},
  {-3.877128e-01,  2.596551e-01,  8.844535e-01, -8.508868e-01,  1.421711e-01, -1.208275e-01},
  {-4.608774e-01,  1.593952e-01,  8.730323e-01, -8.812664e-01,  1.570670e-01, -1.398385e-01},
  {-4.757809e-01, -5.758795e-01,  6.648273e-01, -8.551992e-01,  2.016742e-01, -1.406220e-01},
  { 8.178488e-01, -3.864314e-02, -5.741342e-01, -6.672456e-01,  1.455818e-01, -3.791398e-01},
  { 7.237606e-01, -2.149732e-01, -6.557111e-01, -6.876278e-01,  1.765087e-01, -4.114797e-01},
  { 2.273819e-01, -3.206890e-01, -9.194868e-01, -7.613196e-01,  7.498673e-02, -4.308825e-01},
  {-4.456976e-01, -4.514038e-01, -7.730384e-01, -8.814622e-01,  5.231082e-02, -4.005044e-01},
  {-7.295334e-01, -4.123694e-01, -5.456487e-01, -9.192883e-01,  5.532830e-02, -3.656165e-01},
  {-8.275556e-01, -3.180505e-01, -4.625966e-01, -9.430019e-01,  9.572175e-02, -3.587592e-01},
  {-9.379697e-01, -1.479080e-01,  3.135859e-01, -9.529979e-01,  1.011511e-01, -2.272494e-01},
  {-8.034551e-01,  1.454708e-02,  5.951877e-01, -9.337910e-01,  1.236700e-01, -1.851125e-01},
  {-6.547946e-01,  1.260780e-01,  7.452170e-01, -9.087047e-01,  1.754111e-01, -1.631618e-01},
  { 2.829525e-01, -7.218475e-01,  6.315647e-01, -7.981662e-01,  2.061615e-01, -1.337616e-01},
  { 5.476543e-01, -4.935670e-01,  6.756229e-01, -7.803305e-01,  2.135108e-01, -1.384658e-01},
  { 4.652110e-01, -4.820078e-01,  7.424602e-01, -7.869950e-01,  2.107670e-01, -1.363096e-01},
  { 6.762228e-02, -3.174152e-01, -9.458725e-01, -7.977745e-01,  1.246898e-01, -4.534223e-01},
  {-2.474834e-01, -3.976932e-01, -8.835112e-01, -8.432444e-01,  8.796126e-02, -4.355866e-01},
  {-3.278654e-01, -3.342082e-01, -8.836341e-01, -8.487321e-01,  1.202204e-01, -4.469537e-01},
  {-5.660810e-01, -3.546368e-01, -7.441673e-01, -8.898896e-01,  8.639271e-02, -4.136359e-01},
  {-9.524698e-01, -2.331797e-01, -1.960322e-01, -9.620129e-01,  1.088338e-01, -3.127016e-01},
  {-9.822299e-01, -1.372835e-01,  1.279753e-01, -9.657376e-01,  1.260415e-01, -2.642905e-01},
  {-9.712823e-01, -2.830384e-02,  2.362403e-01, -9.675006e-01,  1.710016e-01, -2.533152e-01},
  {-8.933536e-01, -1.874453e-02,  4.489633e-01, -9.535855e-01,  1.456596e-01, -2.182329e-01},
  {-8.457651e-01,  7.730649e-02,  5.279255e-01, -9.473143e-01,  1.886802e-01, -2.092194e-01},
  {-1.132581e-01, -8.166515e-01,  5.659090e-01, -8.359923e-01,  2.001640e-01, -1.347425e-01},
  {-1.000163e-01, -2.345221e-01,  9.669520e-01, -8.152169e-01,  2.020465e-01, -1.321946e-01},
  { 4.106361e-01, -4.847051e-01,  7.722947e-01, -7.905224e-01,  2.092777e-01, -1.349399e-01},
  { 9.782940e-01,  1.507578e-01, -1.421719e-01, -6.476470e-01,  1.656903e-01, -3.358276e-01},
  { 2.560345e-01, -2.808613e-01, -9.249666e-01, -7.750403e-01,  1.565960e-01, -4.598879e-01},
  {-1.232780e-01, -2.721150e-01, -9.543353e-01, -8.263881e-01,  1.530298e-01, -4.622414e-01},
  {-7.673193e-01, -3.003009e-01, -5.666044e-01, -9.343786e-01,  1.277461e-01, -3.924688e-01},
  {-9.789764e-01, -1.736818e-01, -1.069568e-01, -9.682856e-01,  1.460513e-01, -3.260275e-01},
  {-9.212261e-01, -1.759900e-01, -3.469436e-01, -9.641691e-01,  1.769393e-01, -3.620907e-01},
  {-9.704879e-01,  8.185178e-03,  2.410108e-01, -9.708320e-01,  2.069660e-01, -2.650740e-01},
  {-8.460535e-01, -3.992158e-01,  3.532989e-01, -9.226198e-01,  2.360507e-01, -1.900110e-01},
  { 7.208634e-01, -5.007541e-01,  4.791674e-01, -7.638676e-01,  2.235651e-01, -1.459153e-01},
  { 8.842470e-01, -1.757602e-01,  4.326841e-01, -7.368209e-01,  2.506520e-01, -1.678659e-01},
  { 8.727589e-01,  3.590742e-03,  4.881384e-01, -6.694018e-01,  2.650755e-01, -2.364604e-01},
  {-4.953028e-01, -3.097269e-01, -8.116307e-01, -8.991005e-01,  1.567919e-01, -4.377428e-01},
  {-7.669123e-01, -2.327055e-01, -5.980748e-01, -9.377101e-01,  1.650234e-01, -4.046194e-01},
  {-9.951352e-01, -8.977693e-02, -4.057011e-02, -9.755362e-01,  1.914031e-01, -3.138769e-01},
  {-9.914822e-01,  5.090372e-02,  1.198830e-01, -9.757320e-01,  2.364424e-01, -3.003536e-01},
  {-6.604099e-01, -4.898390e-01,  5.691367e-01, -8.916525e-01,  2.135108e-01, -1.600247e-01},
  { 4.743126e-01, -3.304219e-01, -8.159957e-01, -7.276100e-01,  1.890526e-01, -4.496961e-01},
  { 1.965383e-01, -2.791534e-01, -9.399181e-01, -7.754320e-01,  1.846430e-01, -4.683153e-01},
  {-2.017803e-01, -2.619643e-01, -9.437476e-01, -8.524553e-01,  1.862893e-01, -4.677291e-01},
  {-6.189392e-01, -2.062225e-01, -7.578830e-01, -9.204636e-01,  1.973229e-01, -4.336248e-01},
  {-7.020979e-01, -1.085669e-01, -7.037555e-01, -9.183074e-01,  2.345015e-01, -4.438166e-01},
  {-8.517707e-01, -1.120843e-01, -5.117849e-01, -9.533896e-01,  2.087887e-01, -3.958002e-01},
  {-9.754516e-01, -4.169187e-02, -2.162311e-01, -9.724005e-01,  2.222717e-01, -3.497427e-01},
  {-9.150704e-01, -2.010632e-02, -4.027927e-01, -9.626005e-01,  2.540030e-01, -3.840414e-01},
  {-9.938912e-01,  6.842477e-02, -8.659394e-02, -9.739691e-01,  2.675263e-01, -3.356302e-01},
  {-9.906791e-01, -5.674918e-02,  1.238324e-01, -9.694608e-01,  2.799520e-01, -2.858494e-01},
  {-9.351619e-01, -2.152782e-01,  2.812960e-01, -9.451581e-01,  2.670552e-01, -2.256824e-01},
  { 1.959355e-02, -2.573670e-01, -9.661151e-01, -7.993415e-01,  2.141388e-01, -4.800741e-01},
  { 9.222499e-02, -2.336426e-01, -9.679388e-01, -7.956183e-01,  2.442029e-01, -4.875236e-01},
  {-3.800454e-01, -2.167032e-01, -8.992248e-01, -8.749936e-01,  2.238791e-01, -4.692962e-01},
  {-2.227273e-01, -1.920928e-01, -9.557682e-01, -8.461841e-01,  2.531596e-01, -4.849757e-01},
  {-8.182458e-01,  2.158588e-03, -5.748646e-01, -9.463334e-01,  2.856745e-01, -4.155947e-01},
  {-9.621786e-01,  1.000336e-01, -2.533886e-01, -9.653444e-01,  2.993937e-01, -3.697345e-01},
  { 7.586607e-01,  5.700438e-02,  6.489872e-01, -6.823360e-01,  2.872026e-01, -2.201947e-01},
  { 9.277660e-01, -1.006683e-01,  3.593274e-01, -6.531347e-01,  2.879682e-01, -2.654688e-01},
  {-5.310307e-01, -8.546349e-02, -8.430316e-01, -8.930252e-01,  2.650172e-01, -4.671400e-01},
  {-6.495638e-01, -1.025953e-02, -7.602379e-01, -9.061567e-01,  3.086644e-01, -4.608688e-01},
  {-5.281329e-01, -1.119218e-02, -8.490880e-01, -8.759745e-01,  3.365334e-01, -4.816442e-01},
  {-9.843218e-01,  1.751233e-01,  2.103147e-02, -9.688732e-01,  3.115054e-01, -3.197564e-01},
  { 9.012412e-01, -5.852547e-02,  4.293472e-01, -7.148703e-01,  3.034907e-01, -1.929507e-01},
  { 8.368517e-01, -1.502337e-01,  5.264117e-01, -7.193785e-01,  2.848117e-01, -1.872687e-01},
  { 6.758207e-01, -3.618455e-01, -6.421325e-01, -6.741045e-01,  2.809913e-01, -4.371537e-01},
  { 4.432502e-01, -2.276460e-01, -8.670102e-01, -7.182032e-01,  2.624498e-01, -4.675317e-01},
  { 3.920538e-02, -1.594539e-01, -9.864266e-01, -7.711197e-01,  3.327712e-01, -5.041810e-01},
  {-3.211655e-01, -1.236483e-02, -9.469423e-01, -8.420676e-01,  3.615808e-01, -4.973237e-01},
  {-8.909948e-01,  1.243565e-01, -4.366505e-01, -9.498622e-01,  3.311055e-01, -4.018770e-01},
  {-7.806702e-01,  1.291570e-01, -6.114511e-01, -9.281074e-01,  3.617378e-01, -4.310769e-01},
  {-9.663861e-01,  2.190653e-01, -1.345669e-01, -9.614252e-01,  3.437272e-01, -3.532715e-01},
  {-9.315584e-01,  2.517988e-01, -2.622905e-01, -9.471184e-01,  3.757127e-01, -3.852167e-01},
  { 8.971286e-01, -3.099892e-01,  3.147492e-01, -6.413743e-01,  2.960233e-01, -2.919262e-01},
  { 8.781130e-01, -4.478998e-01, -1.682356e-01, -6.352990e-01,  2.990602e-01, -3.703207e-01},
  { 3.560457e-01, -3.202973e-01, -8.778617e-01, -7.244744e-01,  3.167389e-01, -4.890907e-01},
  { 2.659344e-01, -2.466711e-01, -9.318971e-01, -7.570087e-01,  2.969832e-01, -4.941866e-01},
  {-2.287892e-01, -1.274421e-01, -9.650979e-01, -8.305046e-01,  3.193063e-01, -4.983016e-01},
  {-9.048329e-01,  3.085631e-01, -2.933705e-01, -9.339868e-01,  4.130288e-01, -3.912935e-01},
  {-9.328897e-01,  3.595145e-01,  2.159188e-02, -9.382992e-01,  4.220828e-01, -3.407261e-01},
  {-9.229493e-01,  3.815964e-01,  5.048647e-02, -9.473143e-01,  3.890191e-01, -3.095645e-01},
  {-7.952573e-01,  5.722618e-01,  2.002055e-01, -9.373183e-01,  3.910781e-01, -2.793838e-01},
  { 8.594481e-01,  8.766586e-02,  5.036502e-01, -7.148703e-01,  3.418252e-01, -1.945208e-01},
  { 6.947476e-01, -1.072013e-01,  7.112198e-01, -6.695977e-01,  3.330838e-01, -2.288165e-01},
  { 8.170903e-01, -4.810919e-01, -3.176696e-01, -6.425511e-01,  2.982572e-01, -3.952111e-01},
  { 1.996539e-01, -1.793979e-01, -9.633040e-01, -7.358415e-01,  3.509972e-01, -5.020278e-01},
  {-1.401933e-01, -4.726202e-02, -9.889955e-01, -8.054183e-01,  3.832773e-01, -5.077099e-01},
  {-6.112728e-01,  1.070181e-01, -7.841510e-01, -8.834211e-01,  3.812198e-01, -4.736086e-01},
  {-8.046139e-01,  2.259675e-01, -5.491221e-01, -9.149759e-01,  3.989373e-01, -4.369593e-01},
  {-6.728984e-01,  2.391890e-01, -6.999975e-01, -8.851855e-01,  4.263159e-01, -4.612605e-01},
  {-8.885250e-01,  4.358102e-01,  1.435018e-01, -9.198759e-01,  4.590670e-01, -3.197564e-01},
  { 8.424528e-01, -5.241064e-01, -1.248431e-01, -6.204045e-01,  3.305956e-01, -3.738495e-01},
  { 5.424190e-01, -3.723892e-01, -7.530656e-01, -6.815525e-01,  3.559765e-01, -4.812524e-01},
  {-4.523535e-01,  1.138644e-01, -8.845401e-01, -8.489280e-01,  4.056990e-01, -4.916386e-01},
  {-2.790344e-01,  9.034517e-02, -9.560217e-01, -8.112978e-01,  4.266299e-01, -5.047702e-01},
  {-5.384341e-01,  2.393835e-01, -8.079506e-01, -8.504950e-01,  4.505214e-01, -4.814468e-01},
  {-8.246273e-01,  3.588033e-01, -4.373214e-01, -9.104676e-01,  4.430929e-01, -4.197097e-01},
  {-8.990634e-01,  4.113565e-01, -1.499025e-01, -9.224239e-01,  4.543628e-01, -3.709098e-01},
  {-7.175837e-01,  4.433644e-01,  5.371235e-01, -8.869499e-01,  4.879946e-01, -2.740905e-01},
  {-6.163363e-01,  7.156844e-01,  3.285202e-01, -8.916525e-01,  4.318036e-01, -2.388139e-01},
  { 8.218895e-01, -2.360463e-01,  5.184397e-01, -6.139359e-01,  3.704986e-01, -2.748741e-01},
  { 8.792879e-02, -1.441460e-01, -9.856421e-01, -7.444648e-01,  3.888233e-01, -5.106496e-01},
  { 1.237849e-02, -3.416586e-02, -9.993396e-01, -7.501484e-01,  4.294724e-01, -5.145702e-01},
  {-7.171521e-01,  3.724870e-01, -5.890213e-01, -8.810689e-01,  4.706105e-01, -4.451893e-01},
  {-8.138299e-01,  4.898633e-01, -3.125938e-01, -8.793060e-01,  5.190979e-01, -4.016797e-01},
  {-8.630866e-01,  4.573925e-01, -2.141810e-01, -9.043923e-01,  4.894450e-01, -3.744387e-01},
  {-8.595684e-01,  4.864862e-01,  1.564391e-01, -9.026279e-01,  4.926973e-01, -3.230878e-01},
  {-8.371552e-01,  5.469472e-01, -4.454154e-03, -8.851855e-01,  5.253302e-01, -3.509180e-01},
  {-3.465422e-01,  4.227661e-01,  8.373632e-01, -8.085539e-01,  5.176475e-01, -2.182329e-01},
  {-2.176487e-01,  3.142313e-01,  9.240605e-01, -7.869950e-01,  4.687683e-01, -1.937343e-01},
  { 4.097140e-01, -2.220988e-01,  8.847635e-01, -7.117347e-01,  3.966436e-01, -1.921672e-01},
  { 8.120008e-01,  4.257822e-01,  3.992044e-01, -7.368209e-01,  3.946638e-01, -1.858960e-01},
  { 3.964706e-01,  4.731288e-01,  7.867402e-01, -7.493649e-01,  4.092847e-01, -1.845234e-01},
  { 7.444513e-01, -5.771815e-01, -3.356393e-01, -5.894373e-01,  3.744776e-01, -3.752222e-01},
  { 2.262693e-01, -1.707239e-01, -9.589868e-01, -7.072279e-01,  4.019548e-01, -5.061428e-01},
  { 4.114453e-02,  8.293420e-03, -9.991187e-01, -7.095785e-01,  4.831724e-01, -5.149620e-01},
  {-9.296421e-02,  6.760780e-02, -9.933714e-01, -7.517169e-01,  4.720011e-01, -5.133949e-01},
  {-5.297130e-01,  2.949953e-01, -7.952245e-01, -8.307005e-01,  4.834669e-01, -4.836030e-01},
  {-7.245435e-01,  4.051998e-01, -5.575392e-01, -8.604909e-01,  5.046729e-01, -4.473455e-01},
  {-5.642557e-01,  4.191605e-01, -7.112806e-01, -8.242334e-01,  5.270349e-01, -4.679235e-01},
  {-7.887449e-01,  5.928568e-01, -1.624876e-01, -8.610786e-01,  5.557277e-01, -3.775728e-01},
  {-7.834138e-01,  5.267659e-01,  3.298190e-01, -8.775416e-01,  5.227434e-01, -2.999618e-01},
  {-7.755696e-01,  6.096145e-01,  1.638960e-01, -8.610786e-01,  5.562376e-01, -3.260275e-01},
  {-6.924099e-01,  5.132694e-01,  5.070729e-01, -8.485362e-01,  5.471239e-01, -2.770303e-01},
  {-6.434743e-01,  3.337049e-01,  6.888991e-01, -8.426552e-01,  5.031448e-01, -2.343042e-01},
  { 7.011135e-01, -5.399610e-01, -4.657057e-01, -6.011977e-01,  3.599345e-01, -3.754166e-01},
  { 5.184093e-01, -3.852203e-01, -7.634508e-01, -6.223633e-01,  4.064436e-01, -4.661591e-01},
  { 2.868050e-01, -2.371584e-01, -9.281695e-01, -6.711648e-01,  4.499129e-01, -5.067289e-01},
  {-3.658041e-01,  2.562436e-01, -8.947215e-01, -7.909141e-01,  5.016540e-01, -4.979098e-01},
  {-2.087564e-01,  2.198503e-01, -9.529358e-01, -7.483854e-01,  5.160789e-01, -5.073181e-01},
  {-4.252442e-01,  3.994950e-01, -8.121398e-01, -7.838594e-01,  5.454388e-01, -4.841921e-01},
  {-7.112351e-01,  5.318974e-01, -4.595974e-01, -8.483388e-01,  5.456735e-01, -4.263757e-01},
  {-5.997636e-01,  5.383142e-01, -5.920316e-01, -8.124731e-01,  5.683494e-01, -4.479346e-01},
  {-7.152690e-01,  6.239938e-01, -3.146778e-01, -8.314840e-01,  5.825785e-01, -4.022688e-01},
  {-5.559501e-01,  4.591380e-01,  6.929011e-01, -8.052225e-01,  5.529062e-01, -2.348933e-01},
  {-4.132014e-01,  2.974961e-01,  8.606746e-01, -7.742552e-01,  5.251732e-01, -2.043179e-01},
  { 7.192758e-01, -6.722638e-01,  1.752252e-01, -5.790511e-01,  3.862948e-01, -3.226961e-01},
  { 6.445887e-01, -5.800055e-01, -4.980954e-01, -6.004127e-01,  3.858641e-01, -4.242195e-01},
  { 5.048097e-01, -3.708690e-01, -7.795020e-01, -6.176607e-01,  4.407408e-01, -4.814468e-01},
  {-7.613243e-01,  6.480387e-01,  2.076807e-02, -8.389320e-01,  5.867338e-01, -3.515071e-01},
  {-7.028398e-01,  5.943756e-01,  3.908118e-01, -8.271731e-01,  5.734842e-01, -2.766385e-01},
  {-6.003304e-01,  5.495005e-01,  5.810788e-01, -7.965977e-01,  5.873604e-01, -2.527290e-01},
  {-8.010918e-01, -5.985079e-01, -6.336114e-03, -6.033524e-01,  4.522649e-01, -2.103947e-01},
  { 2.705137e-01, -1.171026e-01, -9.555675e-01, -6.266757e-01,  4.961469e-01, -5.016330e-01},
  { 8.643543e-02,  8.705752e-02, -9.924464e-01, -6.605812e-01,  5.342092e-01, -5.094743e-01},
  {-4.032901e-02,  1.310135e-01, -9.905599e-01, -7.042882e-01,  5.272905e-01, -5.110413e-01},
  {-1.432054e-01,  3.250113e-01, -9.348047e-01, -6.958593e-01,  5.708585e-01, -5.012413e-01},
  { 5.232770e-02,  2.169368e-01, -9.747822e-01, -6.507826e-01,  5.768366e-01, -5.020278e-01},
  {-2.723926e-01,  3.829707e-01, -8.826867e-01, -7.405457e-01,  5.603541e-01, -4.953619e-01},
  {-2.001090e-01,  4.505005e-01, -8.700608e-01, -6.839045e-01,  6.128594e-01, -4.857592e-01},
  {-4.682644e-01,  5.300838e-01, -7.069227e-01, -7.722964e-01,  5.875562e-01, -4.653755e-01},
  {-6.002765e-01,  6.505719e-01, -4.652143e-01, -7.965977e-01,  6.062338e-01, -4.238277e-01},
  {-7.034570e-01,  6.929255e-01, -1.581212e-01, -8.109060e-01,  6.145445e-01, -3.750248e-01},
  {-6.114268e-01,  7.204177e-01, -3.273465e-01, -7.769991e-01,  6.393168e-01, -3.959976e-01},
  {-7.237781e-01,  6.625575e-01,  1.927766e-01, -8.138458e-01,  6.116826e-01, -3.236770e-01},
  {-6.793615e-01,  7.337909e-01,  4.360598e-03, -7.869950e-01,  6.408271e-01, -3.454303e-01},
  {-5.775520e-01,  4.799889e-01,  6.603366e-01, -7.644567e-01,  5.953377e-01, -2.301892e-01},
  { 5.347610e-01, -4.305001e-01, -7.271178e-01, -5.857140e-01,  4.445433e-01, -4.618497e-01},
  { 4.870262e-01, -3.844298e-01, -7.842317e-01, -5.765032e-01,  4.787628e-01, -4.743921e-01},
  { 1.483269e-01,  1.223621e-01, -9.813392e-01, -6.066853e-01,  5.783454e-01, -4.975181e-01},
  {-3.180778e-02,  3.844794e-01, -9.225854e-01, -6.378469e-01,  6.183081e-01, -4.885045e-01},
  {-4.179435e-01,  5.794712e-01, -6.996688e-01, -7.438772e-01,  6.155045e-01, -4.612605e-01},
  {-6.651211e-01,  6.534013e-01,  3.614976e-01, -7.860156e-01,  6.304976e-01, -2.950603e-01},
  {-1.743767e-01, -2.815528e-02,  9.842765e-01, -6.903716e-01,  5.392064e-01, -1.813893e-01},
  {-3.337857e-01, -9.343177e-01,  1.250505e-01, -5.882620e-01,  4.393891e-01, -2.270521e-01},
  {-3.225535e-01, -9.077877e-01, -2.681057e-01, -5.482798e-01,  4.293737e-01, -2.705617e-01},
  { 3.592194e-01, -1.735348e-01, -9.169771e-01, -5.778743e-01,  5.360708e-01, -4.908551e-01},
  { 2.834468e-01,  5.712437e-02, -9.572851e-01, -5.645469e-01,  5.756015e-01, -4.883071e-01},
  { 1.071238e-01,  2.949909e-01, -9.494761e-01, -5.925729e-01,  6.188958e-01, -4.865427e-01},
  {-3.642967e-01,  6.262141e-01, -6.893068e-01, -7.140867e-01,  6.415523e-01, -4.553811e-01},
  {-2.184686e-01,  5.900074e-01, -7.772790e-01, -6.686168e-01,  6.520760e-01, -4.645920e-01},
  {-3.834403e-01,  7.373030e-01, -5.561995e-01, -6.958593e-01,  6.763205e-01, -4.281371e-01},
  {-2.435688e-01,  7.130041e-01, -6.574947e-01, -6.503909e-01,  6.873736e-01, -4.385263e-01},
  {-5.186693e-01,  7.262315e-01, -4.511873e-01, -7.383895e-01,  6.601311e-01, -4.140277e-01},
  {-6.085882e-01,  7.808472e-01, -1.410603e-01, -7.544608e-01,  6.667567e-01, -3.654222e-01},
  {-6.464423e-01,  7.383280e-01,  1.923127e-01, -7.607319e-01,  6.607980e-01, -3.146604e-01},
  {-5.982797e-01,  5.828488e-01,  5.498626e-01, -7.505416e-01,  6.298517e-01, -2.448878e-01},
  {-4.282232e-01,  3.512936e-01,  8.325970e-01, -7.319224e-01,  5.974939e-01, -2.094138e-01},
  { 5.546452e-01, -7.900375e-01, -2.611696e-01, -5.326003e-01,  4.271203e-01, -3.656165e-01},
  { 6.368921e-01, -6.260912e-01, -4.498649e-01, -5.520045e-01,  4.334304e-01, -4.173592e-01},
  { 4.895352e-01, -4.519390e-01, -7.457253e-01, -5.455359e-01,  4.773916e-01, -4.530305e-01},
  { 5.718814e-01, -5.439100e-01, -6.140957e-01, -5.190770e-01,  4.742949e-01, -4.287263e-01},
  { 5.005767e-01, -3.679613e-01, -7.835990e-01, -5.318167e-01,  5.109830e-01, -4.624358e-01},
  { 2.432939e-01,  1.647854e-01, -9.558524e-01, -5.488674e-01,  6.147793e-01, -4.796824e-01},
  {-6.630056e-02,  5.472165e-01, -8.343610e-01, -6.221675e-01,  6.574067e-01, -4.692962e-01},
  {-5.115516e-01,  8.127906e-01, -2.787228e-01, -7.168306e-01,  6.886670e-01, -3.828661e-01},
  {-5.885288e-01,  8.081076e-01,  2.440846e-02, -7.293745e-01,  6.879224e-01, -3.328879e-01},
  {-5.049822e-01,  8.556023e-01, -1.137451e-01, -6.929196e-01,  7.110692e-01, -3.491535e-01},
  {-6.136572e-01,  6.850909e-01,  3.925243e-01, -7.327060e-01,  6.741643e-01, -2.833014e-01},
  {-5.654154e-01,  4.244480e-01,  7.072123e-01, -6.954675e-01,  6.484904e-01, -2.133344e-01},
  {-5.753300e-01,  6.509158e-01,  4.952818e-01, -7.036990e-01,  6.809065e-01, -2.525316e-01},
  {-4.816253e-01,  4.813172e-01,  7.323734e-01, -7.191826e-01,  6.323593e-01, -2.201947e-01},
  {-3.476952e-01,  1.094086e-01,  9.312023e-01, -6.552909e-01,  5.645679e-01, -1.719810e-01},
  {-9.325349e-01, -1.863681e-01,  3.092663e-01, -6.331428e-01,  5.173529e-01, -1.755098e-01},
  {-5.976512e-01, -4.167371e-01,  6.849403e-01, -6.260881e-01,  4.920708e-01, -1.845234e-01},
  {-7.960627e-01, -3.948969e-01, -4.586292e-01, -5.962976e-01,  3.992499e-01, -1.853069e-01},
  { 4.365651e-01, -1.848794e-01, -8.804718e-01, -5.163332e-01,  5.463987e-01, -4.665508e-01},
  { 3.205028e-01,  1.443252e-01, -9.361881e-01, -5.081016e-01,  6.063713e-01, -4.687070e-01},
  { 5.363617e-02,  4.666779e-01, -8.827995e-01, -5.757181e-01,  6.575054e-01, -4.692962e-01},
  { 2.181438e-01,  3.546964e-01, -9.091775e-01, -5.308374e-01,  6.524678e-01, -4.649838e-01},
  { 1.749397e-02,  5.925048e-01, -8.053770e-01, -5.567071e-01,  6.930183e-01, -4.465620e-01},
  {-3.749631e-01,  8.298025e-01, -4.133165e-01, -6.748895e-01,  7.058746e-01, -3.971729e-01},
  {-5.494571e-01,  8.104275e-01,  2.032345e-01, -7.029155e-01,  7.024654e-01, -2.993727e-01},
  {-5.083553e-01,  8.571158e-01,  8.323155e-02, -6.678333e-01,  7.268265e-01, -3.138769e-01},
  {-4.729951e-01,  2.231397e-01,  8.523403e-01, -6.650894e-01,  6.426498e-01, -1.902084e-01},
  {-8.288369e-01,  4.444143e-02,  5.577226e-01, -6.370634e-01,  5.704667e-01, -1.664933e-01},
  {-9.244431e-01, -1.647637e-01, -3.438865e-01, -6.378469e-01,  4.948729e-01, -1.598303e-01},
  { 4.400584e-02, -7.067192e-01, -7.061241e-01, -4.663565e-01,  4.626138e-01, -3.407261e-01},
  { 5.192881e-01, -6.728964e-01, -5.268305e-01, -4.783127e-01,  4.798214e-01, -3.946249e-01},
  { 4.935155e-01, -3.707068e-01, -7.867775e-01, -4.845839e-01,  5.366779e-01, -4.459728e-01},
  { 1.976034e-01,  4.720061e-01, -8.591642e-01, -5.108455e-01,  6.875111e-01, -4.442084e-01},
  {-1.847115e-01,  7.477085e-01, -6.378194e-01, -6.172689e-01,  7.068945e-01, -4.275510e-01},
  {-3.869055e-01,  8.824653e-01, -2.675053e-01, -6.521538e-01,  7.294522e-01, -3.628742e-01},
  {-4.568727e-01,  5.158334e-01,  7.246953e-01, -6.456867e-01,  6.755160e-01, -1.960878e-01},
  {-9.594520e-01,  8.823659e-02, -2.677055e-01, -6.486264e-01,  5.701138e-01, -1.329781e-01},
  { 1.156147e-02, -8.598156e-01, -5.104737e-01, -5.069264e-01,  4.402713e-01, -3.099563e-01},
  { 4.011780e-01, -1.293295e-02, -9.159088e-01, -4.496976e-01,  6.286555e-01, -4.438166e-01},
  { 2.780453e-01,  3.658448e-01, -8.881714e-01, -4.671400e-01,  6.768109e-01, -4.379372e-01},
  {-1.144421e-01,  7.942934e-01, -5.966582e-01, -5.831661e-01,  7.240049e-01, -4.150086e-01},
  {-2.836926e-01,  8.912205e-01, -3.538989e-01, -6.078606e-01,  7.424268e-01, -3.736522e-01},
  {-3.900001e-01,  9.178482e-01, -7.385553e-02, -6.278510e-01,  7.464655e-01, -3.264193e-01},
  {-4.785594e-01,  8.542366e-01,  2.031271e-01, -6.417676e-01,  7.357444e-01, -2.780112e-01},
  {-5.219787e-01,  7.368024e-01,  4.297216e-01, -6.478429e-01,  7.112846e-01, -2.331289e-01},
  {-9.263773e-01,  2.739353e-01,  2.584271e-01, -6.321634e-01,  6.062143e-01, -1.645345e-01},
  { 4.515028e-01,  1.500889e-02, -8.921435e-01, -4.153988e-01,  6.110950e-01, -4.279428e-01},
  { 4.122549e-01,  2.545038e-01, -8.747993e-01, -4.267674e-01,  6.613662e-01, -4.277454e-01},
  { 7.658934e-03,  7.358276e-01, -6.771256e-01, -5.357374e-01,  7.243369e-01, -4.183401e-01},
  { 1.573383e-01,  6.360729e-01, -7.554176e-01, -4.890907e-01,  7.188103e-01, -4.177509e-01},
  {-1.704344e-01,  8.986617e-01, -4.041772e-01, -5.731702e-01,  7.569698e-01, -3.595427e-01},
  {-3.231851e-01,  9.460796e-01, -2.201974e-02, -5.945332e-01,  7.605570e-01, -3.128960e-01},
  {-4.502859e-01,  7.706641e-01,  4.509097e-01, -6.157004e-01,  7.378018e-01, -2.425372e-01},
  {-8.514405e-01,  5.171939e-01,  8.694538e-02, -6.115839e-01,  6.666191e-01, -1.692356e-01},
  { 4.605954e-03, -4.553510e-01, -8.903001e-01, -4.269633e-01,  4.927182e-01, -3.632660e-01},
  { 4.485541e-01, -3.890284e-01, -8.046466e-01, -4.114797e-01,  5.617253e-01, -4.136359e-01},
  {-3.115894e-03, -2.215947e-01, -9.751339e-01, -3.885496e-01,  5.280935e-01, -3.767893e-01},
  { 2.814047e-01,  5.287641e-01, -8.007621e-01, -4.444058e-01,  7.076391e-01, -4.134385e-01},
  { 4.048549e-01,  3.736381e-01, -8.345581e-01, -4.028564e-01,  6.912748e-01, -4.057947e-01},
  { 2.121906e-03,  8.371630e-01, -5.469495e-01, -5.135893e-01,  7.505416e-01, -3.854140e-01},
  {-1.401393e-01,  9.524173e-01, -2.706702e-01, -5.382853e-01,  7.689246e-01, -3.440576e-01},
  {-2.276894e-01,  9.718818e-01, -6.002801e-02, -5.267208e-01,  7.810767e-01, -2.815400e-01},
  {-3.672866e-01,  9.077584e-01,  2.026702e-01, -5.786579e-01,  7.598512e-01, -2.511590e-01},
  {-6.442841e-01,  7.296811e-01,  2.290489e-01, -5.794429e-01,  7.158900e-01, -1.806027e-01},
  { 4.646355e-01,  2.443170e-01, -8.511304e-01, -3.652263e-01,  6.703812e-01, -3.948193e-01},
  { 1.153299e-01,  7.824345e-01, -6.119602e-01, -4.665523e-01,  7.453665e-01, -3.861976e-01},
  { 2.856159e-01,  6.740452e-01, -6.812391e-01, -4.208865e-01,  7.341564e-01, -3.836496e-01},
  {-3.716100e-02,  9.193851e-01, -3.915994e-01, -4.908551e-01,  7.708460e-01, -3.487618e-01},
  {-3.490497e-02,  9.707755e-01, -2.374374e-01, -4.683168e-01,  7.846833e-01, -3.091728e-01},
  {-3.449188e-01,  8.958242e-01,  2.802320e-01, -5.467127e-01,  7.682592e-01, -2.358742e-01},
  { 3.814509e-01,  5.656582e-01, -7.311130e-01, -3.781619e-01,  7.173405e-01, -3.779646e-01},
  { 4.950084e-01,  3.943376e-01, -7.742510e-01, -3.393550e-01,  6.955079e-01, -3.693428e-01},
  { 1.338515e-01,  8.722699e-01, -4.703498e-01, -4.434263e-01,  7.663378e-01, -3.503318e-01},
  {-1.391114e-01,  9.901690e-01,  1.460921e-02, -4.928154e-01,  7.873868e-01, -2.638987e-01},
  {-5.900819e-01,  7.960600e-01, -1.345064e-01, -5.282894e-01,  7.612224e-01, -2.005946e-01},
  { 4.901965e-01, -8.723454e-02, -8.672356e-01, -3.599345e-01,  6.192293e-01, -3.981508e-01},
  { 2.411582e-01,  8.313925e-01, -5.006288e-01, -4.085400e-01,  7.700819e-01, -3.311234e-01},
  { 5.647845e-02,  9.717762e-01, -2.290442e-01, -4.334304e-01,  7.884066e-01, -2.897700e-01},
  { 8.568195e-02,  8.513475e-01, -5.175578e-01, -3.861976e-01,  7.820367e-01, -2.905536e-01},
  {-3.704599e-01,  9.147649e-01, -1.611352e-01, -4.743921e-01,  7.859573e-01, -2.247015e-01},
  { 2.707869e-01, -1.790671e-01, -9.458380e-01, -3.524865e-01,  5.691344e-01, -3.812960e-01},
  { 2.121624e-01,  3.922694e-02, -9.764468e-01, -3.338673e-01,  5.942596e-01, -3.787481e-01},
  { 3.437816e-01,  2.063323e-01, -9.161011e-01, -3.160331e-01,  6.331039e-01, -3.709098e-01},
  { 4.004257e-01,  6.793211e-01, -6.149652e-01, -3.534674e-01,  7.386646e-01, -3.450385e-01},
  {-1.227944e-01,  9.316248e-01, -3.420480e-01, -3.934482e-01,  7.889942e-01, -2.658605e-01},
  {-1.853237e-01,  9.149645e-01, -3.584623e-01, -4.191236e-01,  7.924438e-01, -2.515507e-01},
  { 3.365532e-01,  4.504815e-01, -8.269209e-01, -3.048619e-01,  6.932530e-01, -3.473921e-01},
  { 2.106645e-01,  6.300831e-01, -7.474060e-01, -3.181893e-01,  7.364112e-01, -3.225017e-01},
  {-1.739052e-01,  8.285763e-01, -5.321826e-01, -3.579742e-01,  8.201169e-01, -2.376356e-01},
  { 1.261547e-01,  4.482620e-01, -8.849555e-01, -2.672317e-01,  6.957815e-01, -3.432741e-01},
  { 1.560113e-01,  6.107063e-01, -7.763364e-01, -2.621358e-01,  7.453276e-01, -3.111316e-01},
  {-7.985193e-01,  3.272909e-02, -6.010789e-01, -6.300072e-01,  6.802994e-01,  8.319730e-02},
  {-6.027476e-02, -5.920219e-01,  8.036647e-01, -4.406825e-01,  5.451053e-01,  2.750714e-01},
  { 1.058261e-01, -1.552336e-01,  9.821932e-01, -3.987400e-01,  5.766796e-01,  2.823235e-01},
  { 1.875996e-01,  2.335555e-01,  9.540745e-01, -3.501344e-01,  6.683626e-01,  2.725235e-01},
  {-2.015630e-01,  2.800298e-01,  9.385924e-01, -3.403359e-01,  6.364758e-01,  2.866329e-01},
  { 2.103088e-01, -9.066607e-03,  9.775929e-01, -3.677742e-01,  6.192293e-01,  2.815370e-01},
  { 7.218468e-01,  4.518816e-01,  5.241568e-01, -3.556221e-01,  7.462098e-01,  2.495919e-01},
  { 3.413599e-01,  5.932855e-01,  7.290307e-01, -3.466071e-01,  7.415460e-01,  2.354795e-01},
  { 4.231124e-02,  5.164680e-01,  8.552605e-01, -3.119166e-01,  7.234158e-01,  2.492001e-01},
  { 2.431553e-02,  6.680152e-01,  7.437502e-01, -3.085851e-01,  7.690621e-01,  2.149014e-01},
  { 3.893869e-01,  7.379718e-01,  5.511584e-01, -3.587592e-01,  7.770783e-01,  2.037317e-01},
  { 3.863763e-01,  8.698522e-01,  3.067090e-01, -3.701263e-01,  7.928356e-01,  1.858960e-01},
  { 4.703603e-01,  8.706580e-01, -1.439300e-01, -4.234345e-01,  8.321315e-01,  1.792331e-01},
  { 9.921178e-02,  9.470898e-01,  3.052507e-01, -4.005044e-01,  8.142973e-01,  1.484602e-01},
  {-1.550381e-01,  8.764842e-01,  4.557835e-01, -3.654222e-01,  8.447726e-01,  1.118110e-01},
  {-7.948227e-02,  8.657206e-01, -4.941764e-01, -5.106496e-01,  8.363841e-01,  1.222001e-01},
  {-1.107814e-01,  9.852160e-01, -1.306785e-01, -4.608688e-01,  8.202545e-01,  9.848502e-02},
  {-3.862686e-01,  8.979807e-01, -2.107776e-01, -5.047702e-01,  8.057129e-01,  7.320286e-02},
  {-6.470093e-01,  7.609018e-01, -4.906469e-02, -5.469086e-01,  7.779800e-01,  5.752337e-02},
  {-4.968354e-01,  5.513087e-01, -6.702338e-01, -5.782661e-01,  7.697096e-01,  6.987137e-02},
  {-7.447659e-01,  5.690912e-01, -3.485096e-01, -5.825785e-01,  7.395274e-01,  5.281922e-02},
  {-7.858062e-01,  6.053122e-01,  1.269082e-01, -5.866935e-01,  7.495024e-01,  1.224932e-02},
  {-7.313235e-01,  6.772654e-01,  8.048264e-02, -5.672907e-01,  7.743928e-01,  2.057503e-03},
  {-6.297423e-01,  4.571197e-01, -6.280654e-01, -6.127607e-01,  7.631049e-01,  9.378088e-02},
  {-9.222939e-01,  3.861858e-01, -1.531730e-02, -5.970812e-01,  7.178698e-01,  5.497541e-02},
  {-9.238460e-01,  2.126782e-01, -3.182399e-01, -5.970812e-01,  7.176156e-01,  5.497541e-02},
  {-9.836716e-01,  1.728915e-01, -4.998618e-02, -6.153086e-01,  6.774958e-01,  6.555899e-02},
  {-9.582461e-01,  2.493278e-01,  1.400002e-01, -6.157004e-01,  6.761440e-01,  6.614514e-02},
  {-8.804463e-01,  4.084990e-01,  2.407132e-01, -6.166798e-01,  6.751841e-01,  6.477547e-02},
  {-7.581384e-01,  4.097891e-01,  5.072466e-01, -6.155045e-01,  6.768304e-01,  6.575338e-02},
  {-3.685454e-01,  1.858949e-01, -9.108334e-01, -6.155045e-01,  6.771623e-01,  6.575338e-02},
  {-7.344404e-01,  3.781644e-02, -6.776187e-01, -6.153086e-01,  6.773193e-01,  6.575338e-02},
  { 7.077537e-01,  2.528706e-01,  6.596524e-01, -3.464112e-01,  6.933711e-01,  2.642905e-01},
  { 2.375096e-01,  9.185169e-01, -3.160948e-01, -4.649853e-01,  8.418717e-01,  1.482658e-01},
  { 3.428411e-01,  9.242857e-01, -1.677972e-01, -4.551852e-01,  8.479874e-01,  1.843290e-01},
  {-4.344143e-01,  6.722641e-01, -5.994540e-01, -5.766990e-01,  8.011852e-01,  9.789588e-02},
  { 7.725266e-02,  9.511623e-01, -2.988683e-01, -5.016345e-01,  8.519858e-01,  1.596330e-01},
  { 1.856084e-02,  9.959721e-01,  8.772112e-02, -4.395057e-01,  8.220384e-01,  1.139671e-01},
  {-2.180309e-01,  8.680041e-01, -4.461293e-01, -5.494565e-01,  8.404422e-01,  1.404276e-01},
  {-8.588490e-02,  9.420158e-01, -3.243918e-01, -5.382853e-01,  8.579236e-01,  1.780548e-01},
  {-4.107172e-01,  7.337545e-01, -5.412169e-01, -5.937497e-01,  8.144723e-01,  1.284713e-01},
  {-7.622813e-01,  2.725827e-01, -5.870485e-01, -6.302031e-01,  7.766477e-01,  1.249425e-01},
  { 6.897573e-01,  7.142662e-01,  1.185699e-01, -4.281386e-01,  8.394030e-01,  2.474357e-01},
  { 2.837279e-01,  9.476404e-01, -1.465479e-01, -4.728250e-01,  8.616483e-01,  2.303865e-01},
  { 3.779939e-02,  9.720442e-01, -2.317358e-01, -5.228017e-01,  8.683890e-01,  2.150988e-01},
  {-4.696463e-01,  7.779216e-01, -4.174571e-01, -6.080565e-01,  8.255851e-01,  1.612000e-01},
  {-2.929476e-01,  9.150305e-01, -2.773102e-01, -5.733660e-01,  8.590016e-01,  2.031426e-01},
  {-5.783243e-01,  7.481692e-01, -3.252445e-01, -6.192278e-01,  8.343849e-01,  1.956961e-01},
  { 6.347055e-01, -7.153907e-01,  2.921727e-01, -4.157921e-01,  5.898694e-01,  3.050578e-01},
  { 8.233982e-01, -4.055087e-01,  3.969610e-01, -3.848249e-01,  6.324580e-01,  3.046660e-01},
  { 5.352263e-01,  8.441041e-01, -3.195094e-02, -4.357825e-01,  8.454784e-01,  3.058413e-01},
  { 1.902863e-01,  9.780836e-01, -8.451863e-02, -5.035949e-01,  8.718581e-01,  2.495919e-01},
  {-1.540036e-01,  9.777310e-01, -1.425659e-01, -5.555319e-01,  8.713093e-01,  2.403810e-01},
  {-3.770546e-01,  9.231089e-01, -7.549746e-02, -5.855182e-01,  8.685266e-01,  2.711508e-01},
  {-4.964314e-01,  8.547438e-01, -1.515548e-01, -6.274592e-01,  8.407353e-01,  2.317562e-01},
  {-6.900911e-01,  7.056370e-01, -1.607811e-01, -6.474511e-01,  8.235276e-01,  2.305809e-01},
  {-8.256170e-01,  5.606086e-01,  6.383175e-02, -6.835127e-01,  7.848388e-01,  2.682111e-01},
  { 1.341798e-01,  9.882846e-01, -7.272725e-02, -5.073181e-01,  8.747589e-01,  2.776194e-01},
  {-6.776356e-01,  7.246168e-01, -1.254607e-01, -6.525471e-01,  8.274273e-01,  2.680137e-01},
  { 2.720203e-01,  9.618470e-01, -2.924462e-02, -4.828195e-01,  8.694671e-01,  3.042742e-01},
  {-8.655570e-02,  9.962457e-01,  1.649383e-03, -5.612154e-01,  8.757188e-01,  3.025098e-01},
  {-5.379279e-01,  8.428732e-01, -1.408640e-02, -6.339278e-01,  8.457131e-01,  3.013345e-01},
  {-8.321063e-01,  5.546115e-01, -2.269767e-03, -6.711648e-01,  8.084956e-01,  3.011371e-01},
  {-9.931938e-01, -1.001350e-01,  5.948942e-02,  3.787481e-01, -7.111844e-01,  5.024166e-01},
  {-9.768034e-01,  2.114540e-01,  3.379800e-02,  3.732604e-01, -6.878625e-01,  5.041810e-01},
  {-9.759142e-01,  2.064055e-01,  7.062778e-02,  3.787481e-01, -7.638271e-01,  4.996742e-01},
  {-8.732478e-01,  4.801888e-01,  8.280648e-02,  3.622850e-01, -8.139220e-01,  4.981072e-01},
  {-9.787177e-01,  1.154813e-01,  1.696343e-01,  3.746331e-01, -7.607499e-01,  4.614549e-01},
  {-8.935593e-01,  4.098091e-01,  1.833255e-01,  3.581701e-01, -8.107086e-01,  4.583208e-01},
  {-9.377966e-01, -3.434090e-01,  5.106650e-02,  3.448412e-01, -8.406755e-01,  4.979098e-01},
  {-9.431977e-01,  1.992422e-01,  2.658584e-01,  3.616989e-01, -7.810946e-01,  4.210824e-01},
  { 1.968835e-01, -9.454592e-01, -2.595069e-01,  3.464112e-01, -8.418702e-01,  4.312742e-01},
  {-9.965129e-01,  7.470502e-02, -3.716424e-02,  3.360220e-01, -8.338152e-01,  4.312742e-01},
  {-9.636840e-01,  2.259630e-01,  1.423163e-01,  3.671866e-01, -6.955647e-01,  4.338222e-01},
  {-9.880664e-01, -8.485992e-02, -1.285437e-01,  3.487618e-01, -7.818004e-01,  3.824713e-01},
  {-8.805577e-01,  4.664917e-01,  8.368729e-02,  3.518988e-01, -7.151050e-01,  3.622850e-01},
  {-9.475024e-01,  1.961123e-01, -2.525450e-01,  3.436658e-01, -7.258650e-01,  3.417070e-01},
  {-1.108404e-01, -9.938381e-01,  3.852054e-04,  3.464112e-01, -8.418702e-01,  5.316194e-01},
  { 4.020254e-02, -9.991916e-01,  0.000000e+00,  3.464112e-01, -8.418702e-01,  5.484741e-01},
  {-8.938454e-01, -2.420150e-01,  3.774508e-01,  5.200579e-01, -4.990268e-01,  1.143589e-01},
  {-8.007781e-01, -5.966234e-01,  5.286857e-02,  5.094743e-01, -5.126278e-01,  7.261372e-02},
  {-5.842845e-01,  7.245972e-01,  3.654729e-01,  4.616523e-01, -5.741107e-01,  5.651345e-01},
  {-2.458700e-01,  1.232540e-01,  9.614346e-01,  6.370634e-01, -3.488604e-01,  2.809509e-01},
  {-6.478094e-01,  7.784077e-02,  7.578151e-01,  6.121730e-01, -3.807278e-01,  2.642905e-01},
  {-7.393945e-01, -4.364831e-02,  6.718560e-01,  5.839481e-01, -4.169465e-01,  2.360686e-01},
  {-8.736565e-01,  3.041274e-02,  4.855918e-01,  5.588633e-01, -4.492460e-01,  2.011838e-01},
  {-9.325842e-01,  1.578036e-01,  3.246301e-01,  5.374988e-01, -4.768413e-01,  1.602221e-01},
  {-4.120724e-01, -8.969712e-01, -1.601221e-01,  5.680743e-01, -5.570780e-01,  7.183019e-02},
  { 7.972693e-02, -9.404713e-01,  3.303898e-01,  5.788522e-01, -5.433588e-01,  1.137728e-01},
  { 3.792278e-01, -8.709981e-01,  3.123275e-01,  5.959044e-01, -5.212526e-01,  1.596330e-01},
  { 2.008166e-01, -6.338097e-01,  7.469658e-01,  6.705756e-01, -4.254725e-01,  2.631152e-01},
  { 2.327912e-01, -1.183886e-01,  9.652939e-01,  6.954660e-01, -3.933300e-01,  2.801673e-01},
  { 7.642379e-01, -4.386647e-01,  4.727724e-01,  5.196661e-01, -6.192472e-01,  5.651345e-01},
  { 3.497011e-01, -7.671079e-01,  5.378240e-01,  6.423537e-01, -4.615731e-01,  2.350877e-01},
  { 1.840355e-01, -8.208552e-01,  5.406734e-01,  6.172659e-01, -4.937544e-01,  2.004002e-01},
  { 6.860182e-01, -1.750064e-01, -7.062237e-01,  1.181129e+00,  3.376937e-02,  5.651345e-01},
  {-6.960902e-01, -5.553152e-02, -7.158036e-01,  1.116453e+00,  5.086040e-02,  5.651345e-01},
  { 7.849876e-01,  1.317817e-01, -6.053331e-01,  1.181129e+00,  6.796938e-02,  5.651345e-01},
  {-5.271704e-01, -2.489356e-01,  8.124793e-01,  1.112335e+00,  6.804863e-02,  6.386304e-01},
  {-6.960760e-01,  5.571007e-02,  7.158036e-01,  1.116453e+00,  5.086040e-02,  6.386304e-01},
  { 7.842414e-01,  4.249826e-01,  4.520567e-01,  1.169957e+00,  1.003078e-01,  6.386304e-01},
  { 5.393654e-01,  5.854072e-01, -6.052961e-01,  1.148987e+00,  1.272961e-01,  5.651345e-01},
  { 3.722728e-01,  4.040511e-01,  8.355571e-01,  1.148987e+00,  1.272961e-01,  6.386304e-01},
  { 6.174812e-01,  3.346148e-01, -7.118638e-01,  1.169957e+00,  1.003078e-01,  5.651345e-01},
  {-4.773696e-01, -3.298444e-01, -8.144452e-01,  1.112335e+00,  6.804863e-02,  5.651345e-01},
  {-2.385208e-01, -3.584528e-01, -9.025627e-01,  1.100773e+00,  8.147324e-02,  5.651345e-01},
  {-3.145322e-01, -6.159573e-01,  7.222645e-01,  1.090384e+00,  8.684428e-02,  6.386304e-01},
  { 9.583520e-02, -6.891326e-01, -7.182700e-01,  1.078625e+00,  8.868647e-02,  5.651345e-01},
  {-1.975624e-02,  7.000614e-01, -7.138093e-01,  1.087250e+00,  1.543815e-01,  5.651345e-01},
  { 2.903210e-01,  7.764053e-01, -5.593823e-01,  1.120370e+00,  1.459930e-01,  5.651345e-01},
  { 7.774922e-02,  6.960110e-01,  7.138093e-01,  1.087250e+00,  1.543815e-01,  6.386304e-01},
  { 1.257074e-01, -5.257400e-01,  8.413056e-01,  1.066866e+00,  8.684428e-02,  6.386304e-01},
  {-2.543191e-01,  6.515532e-01, -7.147028e-01,  1.036880e+00,  1.459930e-01,  5.651345e-01},
  { 3.474440e-01, -4.071726e-01, -8.446853e-01,  1.051776e+00,  7.761243e-02,  5.651345e-01},
  {-4.589082e-01,  5.385036e-01, -7.066945e-01,  1.008266e+00,  1.272766e-01,  5.651345e-01},
  {-3.632040e-02,  2.499204e-01, -9.675850e-01,  9.796527e-01,  9.293904e-02,  5.651345e-01},
  {-1.889085e-01,  6.748709e-01,  7.133462e-01,  9.967018e-01,  1.146550e-01,  6.386304e-01},
  { 8.459360e-01, -2.561626e-01, -4.677318e-01,  1.042565e+00,  6.256096e-02,  5.651345e-01},
  { 6.555504e-01, -2.127151e-01,  7.245729e-01,  1.042565e+00,  6.256096e-02,  6.386304e-01},
  { 6.484734e-01,  2.501847e-01, -7.189505e-01,  1.042565e+00,  3.917929e-02,  5.651345e-01},
  { 6.837119e-01,  1.250923e-01,  7.189505e-01,  1.042565e+00,  3.917929e-02,  6.386304e-01},
  {-5.553577e-01,  1.551279e-01,  8.170148e-01,  8.761705e-01, -4.001964e-02,  6.386304e-01},
  { 5.086085e-01, -5.598280e-02, -8.591760e-01,  8.563730e-01, -6.222602e-02,  5.651345e-01},
  { 5.316064e-01,  4.526716e-01,  7.158791e-01,  1.051776e+00,  2.412781e-02,  6.386304e-01},
  { 4.525976e-01,  5.316694e-01, -7.158791e-01,  1.051776e+00,  2.412781e-02,  5.651345e-01},
  { 2.138330e-01,  7.592820e-01,  6.146271e-01,  1.066866e+00,  1.489597e-02,  6.386304e-01},
  { 1.879914e-01,  6.675233e-01, -7.204664e-01,  1.066866e+00,  1.489597e-02,  5.651345e-01},
  {-1.575693e-01,  6.685444e-01, -7.267877e-01,  1.090384e+00,  1.489597e-02,  5.651345e-01},
  {-5.128087e-01,  6.374660e-01, -5.750343e-01,  1.131737e+00, -2.534049e-02,  5.651345e-01},
  {-3.749143e-01,  7.260631e-01,  5.764301e-01,  1.090384e+00,  1.489597e-02,  6.386304e-01},
  { 7.090809e-01, -2.093583e-01,  6.733301e-01,  1.160548e+00, -1.293416e-02,  6.386304e-01},
  {-5.879166e-01,  3.596790e-01, -7.245585e-01,  1.112335e+00,  3.369161e-02,  5.651345e-01},
  {-4.568307e-01,  2.794825e-01,  8.445089e-01,  1.112335e+00,  3.369161e-02,  6.386304e-01},
  { 6.936685e-01, -9.595773e-02,  7.138740e-01,  1.181129e+00,  3.376937e-02,  6.386304e-01},
  { 5.417852e-01,  9.095354e-02,  8.355814e-01,  1.181129e+00,  6.796938e-02,  6.386304e-01},
  { 4.929121e-01, -2.572698e-01, -8.311738e-01,  1.169957e+00,  1.430982e-03,  5.651345e-01},
  { 7.128705e-01,  3.228741e-01, -6.225495e-01,  1.143694e+00, -3.465009e-02,  5.651345e-01},
  { 5.085185e-01, -5.958249e-01,  6.216120e-01,  1.056283e+00,  8.147324e-02,  6.386304e-01},
  { 3.746324e-01,  7.394201e-01,  5.593823e-01,  1.120370e+00,  1.459930e-01,  6.386304e-01},
  {-3.017604e-01,  7.283518e-01,  6.151782e-01,  1.036880e+00,  1.459930e-01,  6.386304e-01},
  { 8.475823e-02,  6.052164e-01, -7.915359e-01,  1.010031e+00, -1.817003e-01,  5.651345e-01},
  { 1.018910e-01,  9.923499e-01,  6.971365e-02,  8.771483e-01, -4.202391e-01,  2.437125e-01},
  { 9.378766e-01,  2.650243e-01,  2.239414e-01,  8.736225e-01, -4.112629e-01,  2.495919e-01},
  { 8.400000e-01,  1.596603e-01,  5.185641e-01,  8.624498e-01, -3.875089e-01,  2.637043e-01},
  { 8.228777e-01,  2.135110e-01,  5.265788e-01,  8.528471e-01, -3.707708e-01,  2.723261e-01},
  { 8.500217e-01,  4.421533e-01,  2.862928e-01,  8.491238e-01, -3.647747e-01,  2.752658e-01},
  { 8.041447e-01,  5.064904e-01,  3.111570e-01,  8.336387e-01, -3.434505e-01,  2.840850e-01},
  { 6.765385e-01,  3.955298e-01,  6.211698e-01,  8.167840e-01, -3.229891e-01,  2.909453e-01},
  { 6.949418e-01,  6.179879e-01,  3.676231e-01,  7.985565e-01, -3.035086e-01,  2.958468e-01},
  { 6.614770e-01,  7.497095e-01,  1.958958e-02,  7.789594e-01, -2.851242e-01,  2.987866e-01},
  { 4.009523e-01,  4.764218e-01,  7.824701e-01,  7.581840e-01, -2.679360e-01,  2.997645e-01},
  { 9.974493e-01,  7.134993e-02, -2.028818e-03,  6.392196e-01, -1.754291e-01,  2.997645e-01},
  {-1.567664e-01,  1.063133e-01,  9.818970e-01,  8.918470e-01, -4.010128e-01,  2.456713e-01},
  { 1.679039e-01,  5.528401e-02,  9.842519e-01,  9.196801e-01, -3.659306e-01,  2.419480e-01},
  {-5.100411e-01,  6.832097e-01,  5.225731e-01,  9.475102e-01, -3.325335e-01,  2.303865e-01},
  { 2.943458e-01,  7.509342e-01,  5.911500e-01,  1.022181e+00, -2.522565e-01,  1.561041e-01},
  { 2.264502e-01,  6.434044e-01,  7.312669e-01,  9.996415e-01, -2.748935e-01,  1.866795e-01},
  { 2.756334e-01,  4.100655e-01,  8.694093e-01,  9.745567e-01, -3.019012e-01,  2.117673e-01},
  {-9.888469e-03,  8.977272e-01,  4.404408e-01,  1.034332e+00, -2.413006e-01,  1.343508e-01},
  { 4.240728e-02,  9.209966e-01,  3.872555e-01,  1.041779e+00, -2.346765e-01,  1.208275e-01},
  { 1.127812e-01,  9.586065e-01,  2.614458e-01,  1.057458e+00, -2.226814e-01,  8.221640e-02},
  { 8.137861e-01,  5.791441e-01,  4.841802e-02,  1.066083e+00, -2.178606e-01,  5.203569e-02},
  { 6.046627e-01, -2.609975e-01,  7.525046e-01,  6.574441e-01, -1.506553e-01,  2.974139e-01},
  { 7.142463e-01, -1.103942e-01,  6.911334e-01,  6.856689e-01, -1.063816e-01,  2.848715e-01},
  { 8.755321e-01, -1.850734e-01,  4.463085e-01,  7.099702e-01, -6.228433e-02,  2.642905e-01},
  { 8.376138e-01,  8.850998e-02,  5.390446e-01,  7.297647e-01, -1.944161e-02,  2.360686e-01},
  { 9.624954e-01, -6.067588e-03,  2.712300e-01,  7.442689e-01,  2.108941e-02,  2.011838e-01},
  { 7.718903e-01,  5.718308e-01,  2.778398e-01,  7.544608e-01,  6.896973e-02,  1.453261e-01},
  { 8.026580e-01,  1.018326e-01, -5.876821e-01,  9.780827e-01,  9.413376e-02,  5.651345e-01},
  { 1.679724e-01, -6.532829e-01,  7.382457e-01,  1.040211e+00, -1.676088e-01,  6.386304e-01},
  {-3.005628e-01, -2.081312e-02,  9.535348e-01,  5.998250e-01, -1.840523e-01,  3.009398e-01},
  {-3.238130e-01,  3.232372e-01,  8.891922e-01,  6.366717e-01, -1.345257e-01,  2.974139e-01},
  {-1.107833e-01, -1.396443e-01,  9.839850e-01,  1.794274e-01,  8.535349e-02,  2.974139e-01},
  { 4.435680e-02,  5.781821e-02,  9.973412e-01,  1.427782e-01,  1.818005e-01,  3.015289e-01},
  {-3.555760e-01,  4.751099e-01,  8.048828e-01,  6.650879e-01, -9.027146e-02,  2.848715e-01},
  {-2.382026e-01,  6.461653e-01,  7.250723e-01,  7.089893e-01, -3.331481e-03,  2.360686e-01},
  {-1.662762e-01,  5.276068e-01,  8.330566e-01,  6.893922e-01, -4.617420e-02,  2.642905e-01},
  {-5.375580e-01,  8.089046e-01,  2.381277e-01,  8.651951e-01,  9.987713e-02,  3.920770e-01},
  {-6.084779e-02,  6.857696e-01,  7.252707e-01,  7.234935e-01,  3.719954e-02,  2.011838e-01},
  { 4.355671e-01,  8.335647e-01,  3.397809e-01,  7.336853e-01,  8.507986e-02,  1.453261e-01},
  { 3.347012e-01, -6.553693e-01,  6.771013e-01,  8.634307e-01, -4.850534e-01,  2.107864e-01},
  { 6.598831e-01, -5.914676e-01,  4.633791e-01,  8.881237e-01, -4.510089e-01,  2.223509e-01},
  { 6.868027e-01, -5.246730e-01,  5.030112e-01,  9.132115e-01, -4.177689e-01,  2.258768e-01},
  { 7.660407e-01, -5.283205e-01,  3.661411e-01,  9.392772e-01, -3.850985e-01,  2.223509e-01},
  { 7.806480e-01, -4.183894e-01,  4.642617e-01,  9.902332e-01, -3.256941e-01,  1.939317e-01},
  { 9.749314e-01, -2.183528e-01, -4.278829e-02,  1.120568e+00, -1.306649e-01,  3.248523e-01},
  { 9.883279e-01,  5.576009e-02,  1.417707e-01,  1.080390e+00, -2.483957e-01,  1.107403e-02},
  { 9.119914e-01, -2.710046e-01,  3.079420e-01,  1.051776e+00, -2.647406e-01,  1.080877e-01},
  { 9.204947e-01, -3.187597e-01,  2.260126e-01,  1.065885e+00, -2.541779e-01,  7.222196e-02},
  { 8.743529e-01, -3.487228e-01,  3.374899e-01,  1.034138e+00, -2.803423e-01,  1.412111e-01},
  { 8.366011e-01, -3.202343e-01,  4.444643e-01,  1.013362e+00, -3.008231e-01,  1.702165e-01},
  {-2.438816e-01, -3.864923e-01,  8.894636e-01,  7.597510e-01, -3.096811e-01,  2.997645e-01},
  {-1.930085e-01, -4.458709e-01,  8.740405e-01,  7.971869e-01, -3.482907e-01,  2.907509e-01},
  {-5.332245e-02, -4.609767e-01,  8.858088e-01,  8.283485e-01, -3.915267e-01,  2.729152e-01},
  {-3.419479e-02, -5.833329e-01,  8.115130e-01,  8.518662e-01, -4.393278e-01,  2.452795e-01},
  {-7.490987e-02,  8.093876e-02,  9.939001e-01, -3.193646e-01,  5.414598e-01,  3.015289e-01},
  {-2.194892e-01,  7.546783e-02,  9.726917e-01, -3.881564e-01,  5.402651e-01,  2.938850e-01},
  {-3.323309e-01, -1.143720e-01,  9.362025e-01, -4.259824e-01,  4.917971e-01,  2.807535e-01},
  {-1.624780e-02,  1.586396e-01,  9.872028e-01, -3.350441e-01,  6.085664e-01,  2.938850e-01},
  {-2.453116e-01,  4.094664e-01,  8.787261e-01, -6.157004e-01,  6.765941e-01,  6.595076e-02},
  {-6.176813e-01,  7.363995e-01, -2.760170e-01, -6.155045e-01,  6.770457e-01,  6.575338e-02},
  {-7.720817e-01,  2.926578e-01, -5.641289e-01, -6.153086e-01,  6.772804e-01,  6.575338e-02},
  {-6.223934e-01,  7.122629e-01, -3.245117e-01, -5.327976e-01,  7.830953e-01, -1.582603e-01},
  {-7.815458e-01,  5.433054e-01, -3.066029e-01, -5.868893e-01,  7.287076e-01, -1.461097e-01},
  {-7.829924e-01,  6.068283e-01, -1.366837e-01, -5.825785e-01,  7.462890e-01, -1.214166e-01},
  {-7.434306e-01,  5.611145e-01, -3.639525e-01, -5.694469e-01,  7.360584e-01, -1.725671e-01},
  {-1.750447e-02,  2.645563e-02, -9.994967e-01, -3.193646e-01,  5.414598e-01, -3.844331e-01},
  { 1.087709e-01,  1.417009e-01, -9.839154e-01,  2.452795e-01,  1.700416e-01, -3.801208e-01},
  { 5.338772e-02, -6.833895e-02, -9.962327e-01,  7.652387e-01, -3.025860e-01, -3.832578e-01},
  { 1.655248e-01,  5.694183e-02, -9.845604e-01,  7.981647e-01, -2.603714e-01, -3.791398e-01},
  { 1.705066e-01, -1.419562e-01, -9.750774e-01,  8.071812e-01, -3.352385e-01, -3.748305e-01},
  { 2.842502e-01, -3.531119e-02, -9.580997e-01,  8.393238e-01, -2.940615e-01, -3.707125e-01},
  { 2.752364e-01, -2.310381e-01, -9.332021e-01,  8.475538e-01, -3.666752e-01, -3.581701e-01},
  { 4.114542e-01, -1.416072e-01, -9.003626e-01,  8.781292e-01, -3.275557e-01, -3.544468e-01},
  { 3.825434e-01, -2.995230e-01, -8.740404e-01,  8.669565e-01, -3.816878e-01, -3.470003e-01},
  { 3.993647e-01, -4.607001e-01, -7.926306e-01,  8.765622e-01, -4.441306e-01, -3.154440e-01},
  { 5.636113e-01, -3.052833e-01, -7.675574e-01,  9.449622e-01, -3.906640e-01, -2.989810e-01},
  { 5.730149e-01, -5.292268e-01, -6.257579e-01,  9.498608e-01, -4.462464e-01, -2.640961e-01},
  { 7.000021e-01, -4.130124e-01, -5.825958e-01,  9.823950e-01, -4.315867e-01, -2.405754e-01},
  { 7.197335e-01, -5.260629e-01, -4.530359e-01,  1.000231e+00, -4.545168e-01, -1.951069e-01},
  { 8.045770e-01, -5.244169e-01, -2.786445e-01,  1.021592e+00, -4.605548e-01, -1.421890e-01},
  { 7.254424e-01, -6.222678e-01, -2.941364e-01,  9.914116e-01, -4.994769e-01, -1.461097e-01},
  { 8.197083e-01, -5.633058e-01, -1.037533e-01,  1.026296e+00, -4.748810e-01, -8.927411e-02},
  { 1.321646e-01,  2.660561e-01, -9.548542e-01, -2.756591e-01,  6.413758e-01, -3.665974e-01},
  { 2.863112e-01,  1.651654e-01, -9.437936e-01,  8.506909e-01, -2.364005e-01, -3.636577e-01},
  { 4.247563e-01,  4.220849e-02, -9.043232e-01,  8.896937e-01, -2.716009e-01, -3.517015e-01},
  { 5.425211e-01, -9.233328e-02, -8.349523e-01,  9.249703e-01, -3.071736e-01, -3.321044e-01},
  { 6.710896e-01, -1.917734e-01, -7.161437e-01,  9.692635e-01, -3.592676e-01, -2.893783e-01},
  { 7.332616e-01, -3.024666e-01, -6.089675e-01,  9.921951e-01, -3.919185e-01, -2.533152e-01},
  { 8.397740e-01, -3.646887e-01, -4.022210e-01,  1.028650e+00, -4.179662e-01, -1.802110e-01},
  {-4.356106e-01,  7.715911e-01, -4.635629e-01, -4.655729e-01,  8.053795e-01, -2.045152e-01},
  { 2.478883e-01,  3.820587e-01, -8.902711e-01, -2.237221e-01,  6.643448e-01, -3.470003e-01},
  { 2.800168e-01,  3.573417e-01, -8.910093e-01,  3.079975e-01,  2.505728e-01, -3.470003e-01},
  { 3.205366e-01,  3.324946e-01, -8.869631e-01,  8.397155e-01, -1.631798e-01, -3.470003e-01},
  { 4.415297e-01,  2.110004e-01, -8.720839e-01,  9.002743e-01, -2.157433e-01, -3.385699e-01},
  { 5.687940e-01,  9.659323e-02, -8.167883e-01,  9.359457e-01, -2.531387e-01, -3.236770e-01},
  { 6.974195e-01, -4.772835e-02, -7.150720e-01,  9.806306e-01, -3.104662e-01, -2.885948e-01},
  { 8.119335e-01, -1.731296e-01, -5.574855e-01,  1.030217e+00, -3.429018e-01, -2.215644e-01},
  {-7.364102e-01,  6.761739e-01, -2.211369e-02, -5.600401e-01,  7.837622e-01, -7.300548e-02},
  {-3.188999e-01,  8.337354e-01, -4.507640e-01, -4.283345e-01,  8.259380e-01, -1.988302e-01},
  { 3.041129e-01,  4.969155e-01, -8.127671e-01, -2.170591e-01,  7.165958e-01, -3.179919e-01},
  { 4.156078e-01,  4.240444e-01, -8.046468e-01,  8.679374e-01, -1.269611e-01, -3.187754e-01},
  { 5.246984e-01,  3.045349e-01, -7.949528e-01,  9.277157e-01, -1.805250e-01, -3.111316e-01},
  { 6.780986e-01,  1.921235e-01, -7.094159e-01,  9.772991e-01, -2.399294e-01, -2.885948e-01},
  { 9.090578e-01,  1.982015e-02, -4.161983e-01,  1.055891e+00, -2.801659e-01, -1.839372e-01},
  { 8.867940e-01, -8.883185e-02, -4.535473e-01,  1.046680e+00, -3.219305e-01, -1.988302e-01},
  { 8.855097e-01, -4.237806e-01, -1.904800e-01,  1.041976e+00, -4.462076e-01, -9.809326e-02},
  {-4.769318e-01,  8.257818e-01, -3.010321e-01, -4.832112e-01,  8.285652e-01, -1.329781e-01},
  {-2.003627e-01,  8.941833e-01, -4.003634e-01, -3.901167e-01,  8.452436e-01, -1.839372e-01},
  { 1.148983e-01,  7.531765e-01, -6.477064e-01, -2.852633e-01,  7.988914e-01, -2.654688e-01},
  { 3.226678e-01,  6.390852e-01, -6.981803e-01, -1.919713e-01,  7.487966e-01, -2.831071e-01},
  { 4.176809e-01,  5.373759e-01, -7.326459e-01,  3.613042e-01,  3.190910e-01, -2.838906e-01},
  { 5.013102e-01,  5.420096e-01, -6.744729e-01,  9.137976e-01, -1.117915e-01, -2.831071e-01},
  { 5.555314e-01,  4.001345e-01, -7.288877e-01,  9.335951e-01, -1.299786e-01, -2.809509e-01},
  { 6.469902e-01,  3.296694e-01, -6.875476e-01,  9.694608e-01, -1.691175e-01, -2.721317e-01},
  { 8.295839e-01,  7.759047e-02, -5.529651e-01,  1.023748e+00, -2.550392e-01, -2.376356e-01},
  { 9.001678e-01, -2.268516e-01, -3.718013e-01,  1.052754e+00, -3.656554e-01, -1.680603e-01},
  {-4.931077e-02,  9.373590e-01, -3.448574e-01, -3.522906e-01,  8.616483e-01, -1.598303e-01},
  { 9.528286e-03,  8.648006e-01, -5.020249e-01, -3.154455e-01,  8.382263e-01, -2.133344e-01},
  { 2.300443e-01,  7.894976e-01, -5.690107e-01, -2.409686e-01,  8.148057e-01, -2.331289e-01},
  { 4.317230e-01,  6.926735e-01, -5.777704e-01, -1.706083e-01,  7.762948e-01, -2.423398e-01},
  { 5.549083e-01,  5.899234e-01, -5.865724e-01,  9.351622e-01, -8.429334e-02, -2.423398e-01},
  { 6.513102e-01,  4.937999e-01, -5.761569e-01,  9.729867e-01, -1.223153e-01, -2.374413e-01},
  { 7.490748e-01,  3.399841e-01, -5.685927e-01,  1.005129e+00, -1.643550e-01, -2.276412e-01},
  { 8.018680e-01,  2.784248e-01, -5.286656e-01,  1.018850e+00, -1.865809e-01, -2.209782e-01},
  {-5.123233e-01,  8.501436e-01, -1.215756e-01, -4.926195e-01,  8.345808e-01, -8.202201e-02},
  {-3.491235e-01,  9.021404e-01, -2.534865e-01, -4.520496e-01,  8.470663e-01, -1.227863e-01},
  {-1.423848e-01,  9.700825e-01, -1.966380e-01, -3.689495e-01,  8.724263e-01, -1.163207e-01},
  { 1.560371e-01,  9.017122e-01, -4.031965e-01, -2.748756e-01,  8.519858e-01, -1.802110e-01},
  { 3.654584e-01,  8.182440e-01, -4.437531e-01, -2.000070e-01,  8.251351e-01, -1.927564e-01},
  { 5.193856e-01,  7.416370e-01, -4.245152e-01, -1.316069e-01,  7.826243e-01, -1.970658e-01},
  { 5.335904e-01,  6.872485e-01, -4.929208e-01,  4.001126e-01,  3.688717e-01, -1.970658e-01},
  { 6.326877e-01,  6.316625e-01, -4.480052e-01,  9.524087e-01, -6.216621e-02, -1.966740e-01},
  { 7.768221e-01,  4.601342e-01, -4.299114e-01,  1.006305e+00, -1.217874e-01, -1.894249e-01},
  { 8.778951e-01,  2.705845e-01, -3.950751e-01,  1.045505e+00, -1.904805e-01, -1.741371e-01},
  { 9.271794e-01,  1.109102e-01, -3.578230e-01,  1.062554e+00, -2.394778e-01, -1.598303e-01},
  { 9.567748e-01, -7.863870e-02, -2.799965e-01,  1.073335e+00, -3.147188e-01, -1.329781e-01},
  { 9.821741e-01,  1.590811e-02, -1.872991e-01,  1.079998e+00, -2.790489e-01, -1.102439e-01},
  { 9.392554e-01, -2.869688e-01, -1.882768e-01,  1.070395e+00, -3.642648e-01, -1.120083e-01},
  { 1.225704e-01,  9.545457e-01, -2.716964e-01, -2.637043e-01,  8.664496e-01, -1.359178e-01},
  { 3.407657e-01,  8.897584e-01, -3.036589e-01, -1.876605e-01,  8.409507e-01, -1.445426e-01},
  { 5.043921e-01,  8.057984e-01, -3.102860e-01, -1.408194e-01,  8.146293e-01, -1.470906e-01},
  { 6.199608e-01,  7.212107e-01, -3.090366e-01,  9.443731e-01, -2.863309e-02, -1.472849e-01},
  { 7.439640e-01,  5.964860e-01, -3.012011e-01,  1.001995e+00, -8.492135e-02, -1.445426e-01},
  { 8.841820e-01,  4.054727e-01, -2.319786e-01,  1.045505e+00, -1.523225e-01, -1.359178e-01},
  { 9.566069e-01,  1.902866e-01, -2.206676e-01,  1.072160e+00, -2.271119e-01, -1.220028e-01},
  {-6.883041e-01,  7.190169e-01,  9.618805e-02, -5.339729e-01,  8.086915e-01, -2.890971e-02},
  {-2.882750e-01,  9.524859e-01, -9.832744e-02, -4.159880e-01,  8.690170e-01, -7.300548e-02},
  { 7.784802e-02,  9.890035e-01, -1.257452e-01, -3.101537e-01,  8.815594e-01, -8.476435e-02},
  { 2.504266e-01,  9.570153e-01, -1.463156e-01, -2.305824e-01,  8.690559e-01, -9.103854e-02},
  { 4.173278e-01,  8.952528e-01, -1.560772e-01, -1.802125e-01,  8.505937e-01, -9.358350e-02},
  { 5.429293e-01,  8.268765e-01, -1.466395e-01, -1.331755e-01,  8.245071e-01, -9.495617e-02},
  { 6.067837e-01,  7.807662e-01, -1.490553e-01,  4.204933e-01,  3.950361e-01, -9.495617e-02},
  { 6.962076e-01,  7.013602e-01, -1.529343e-01,  9.727923e-01, -3.606163e-02, -9.495617e-02},
  { 8.211308e-01,  5.504733e-01, -1.507427e-01,  1.025513e+00, -9.689555e-02, -9.240822e-02},
  { 9.590290e-01,  2.536051e-01, -1.262844e-01,  1.071570e+00, -1.935967e-01, -8.476435e-02},
  { 9.854870e-01, -1.521508e-01, -7.526868e-02,  1.079606e+00, -3.523684e-01, -6.575338e-02},
  { 8.817834e-01, -4.714989e-01, -1.211496e-02,  1.056480e+00, -4.277065e-01, -4.145211e-02},
  {-3.663770e-01,  9.302315e-01,  2.090942e-02, -4.400934e-01,  8.624901e-01, -4.145211e-02},
  {-4.893139e-01,  8.694019e-01,  6.864633e-02, -4.896798e-01,  8.383833e-01, -2.087409e-02},
  {-4.642554e-02,  9.989035e-01,  6.039404e-03, -3.348482e-01,  8.840879e-01, -4.145211e-02},
  { 1.588246e-01,  9.873068e-01, -2.334522e-04, -2.811468e-01,  8.823056e-01, -4.145211e-02},
  { 3.144747e-01,  9.491934e-01, -1.172863e-02, -2.025549e-01,  8.639794e-01, -4.145211e-02},
  { 5.314212e-01,  8.471019e-01, -3.140443e-03, -1.535576e-01,  8.417551e-01, -4.145211e-02},
  { 6.850529e-01,  7.284558e-01,  7.393433e-03,  9.753403e-01, -3.274959e-02, -4.145211e-02},
  { 8.281077e-01,  5.603811e-01, -1.451011e-02,  1.028061e+00, -9.372107e-02, -4.145211e-02},
  { 9.135178e-01,  4.055312e-01, -3.209037e-02,  1.054716e+00, -1.405233e-01, -4.145211e-02},
  { 9.711424e-01,  2.337773e-01,  4.722882e-02,  1.079998e+00, -2.170382e-01, -4.145211e-02},
  { 9.972262e-01,  6.098824e-02, -4.266733e-02,  1.086661e+00, -2.704450e-01, -4.145211e-02},
  { 9.718344e-01, -1.661395e-01,  1.671394e-01,  1.079606e+00, -3.523684e-01, -1.695347e-02},
  { 9.433456e-01, -3.295830e-01,  3.839443e-02,  1.065691e+00, -4.037760e-01, -2.479172e-02},
  {-2.081650e-01,  9.755960e-01,  6.985559e-02, -3.899208e-01,  8.752493e-01, -6.564273e-03},
  {-5.147742e-02,  9.881724e-01,  1.444479e-01, -3.368085e-01,  8.815594e-01, -6.848376e-04},
  { 1.425983e-01,  9.793611e-01,  1.432394e-01, -2.568440e-01,  8.752882e-01,  6.369886e-03},
  { 3.328698e-01,  9.312500e-01,  1.482262e-01, -2.051029e-01,  8.608050e-01,  9.701367e-03},
  { 4.625326e-01,  8.743362e-01,  1.469689e-01, -1.561056e-01,  8.384625e-01,  1.166018e-02},
  { 5.769193e-01,  8.052066e-01,  1.371369e-01, -1.112248e-01,  8.088096e-01,  1.224932e-02},
  { 6.036289e-01,  7.748355e-01,  1.877819e-01,  4.204933e-01,  3.950361e-01,  1.224932e-02},
  { 6.331959e-01,  7.638317e-01,  1.249961e-01,  9.522143e-01, -1.871640e-02,  1.224932e-02},
  { 7.559829e-01,  6.357658e-01,  1.558578e-01,  9.918033e-01, -5.495448e-02,  1.166018e-02},
  { 8.953565e-01,  4.211665e-01,  1.447597e-01,  1.052362e+00, -1.434824e-01,  6.369886e-03},
  { 9.827948e-01, -7.546569e-02,  1.685807e-01,  1.085288e+00, -2.993338e-01, -9.898744e-03},
  {-6.014000e-01,  7.656925e-01,  2.281072e-01, -5.041825e-01,  8.198627e-01,  3.576706e-02},
  { 3.593707e-02,  9.654575e-01,  2.580704e-01, -3.164249e-01,  8.735447e-01,  4.439183e-02},
  { 2.805815e-01,  9.147389e-01,  2.907349e-01, -2.123550e-01,  8.513772e-01,  5.948218e-02},
  { 4.897117e-01,  8.182297e-01,  3.011356e-01, -1.408194e-01,  8.146293e-01,  6.418633e-02},
  { 6.416771e-01,  6.943721e-01,  3.257267e-01,  9.649511e-01, -4.595888e-02,  6.418633e-02},
  { 7.342751e-01,  5.932202e-01,  3.300452e-01,  1.001995e+00, -8.492135e-02,  6.163837e-02},
  { 8.509620e-01,  4.537876e-01,  2.644626e-01,  1.032765e+00, -1.288422e-01,  5.654246e-02},
  {-3.785665e-01,  9.040029e-01,  1.986606e-01, -4.520496e-01,  8.470663e-01,  3.988506e-02},
  {-1.978504e-01,  9.398979e-01,  2.782933e-01, -4.032482e-01,  8.582570e-01,  5.967956e-02},
  {-3.348394e-02,  9.259162e-01,  3.762419e-01, -3.266167e-01,  8.603938e-01,  8.456996e-02},
  { 1.572529e-01,  9.042979e-01,  3.968840e-01, -2.748756e-01,  8.519858e-01,  9.730974e-02},
  { 3.545187e-01,  8.254801e-01,  4.392028e-01, -2.000070e-01,  8.251351e-01,  1.100465e-01},
  { 5.115303e-01,  7.255158e-01,  4.603950e-01, -1.316069e-01,  7.826243e-01,  1.143589e-01},
  { 5.537297e-01,  6.615816e-01,  5.056611e-01,  9.318307e-01, -4.488079e-02,  1.143589e-01},
  { 5.469967e-01,  7.057213e-01,  4.502801e-01,  4.001126e-01,  3.688717e-01,  1.143589e-01},
  { 7.546318e-01,  4.939251e-01,  4.319363e-01,  1.006305e+00, -1.217874e-01,  1.067150e-01},
  { 8.333068e-01,  3.132298e-01,  4.555074e-01,  1.034138e+00, -1.668058e-01,  9.730974e-02},
  { 9.527326e-01, -9.490020e-02,  2.886081e-01,  1.073335e+00, -3.147188e-01,  5.007389e-02},
  { 9.353417e-01, -2.731832e-01,  2.247375e-01,  1.070395e+00, -3.642648e-01,  2.930148e-02},
  {-3.667011e-01,  8.610533e-01,  3.523029e-01, -4.381346e-01,  8.405783e-01,  7.712048e-02},
  { 5.418219e-02,  8.549850e-01,  5.158148e-01, -2.903577e-01,  8.322107e-01,  1.382714e-01},
  { 2.019118e-01,  8.030878e-01,  5.606084e-01, -2.409686e-01,  8.148057e-01,  1.504220e-01},
  { 3.688647e-01,  7.171614e-01,  5.912853e-01, -1.933440e-01,  7.906988e-01,  1.576741e-01},
  { 4.289311e-01,  6.621174e-01,  6.145070e-01, -1.488535e-01,  7.604389e-01,  1.602221e-01},
  { 6.275453e-01,  5.697477e-01,  5.306358e-01,  9.547593e-01, -1.027361e-01,  1.576741e-01},
  { 7.168667e-01,  4.072078e-01,  5.659362e-01,  9.898415e-01, -1.428948e-01,  1.504220e-01},
  {-2.147320e-02,  7.860071e-01,  6.178445e-01, -3.336714e-01,  8.147085e-01,  1.653180e-01},
  { 2.119038e-01,  7.062130e-01,  6.755443e-01, -2.613523e-01,  7.885830e-01,  1.892275e-01},
  { 3.506399e-01,  6.182532e-01,  7.034305e-01, -1.919713e-01,  7.487966e-01,  2.004002e-01},
  { 4.707553e-01,  5.642161e-01,  6.782695e-01,  8.930252e-01, -9.466160e-02,  2.011838e-01},
  { 4.547151e-01,  5.816762e-01,  6.744531e-01,  2.766385e-01,  3.850223e-01,  2.011838e-01},
  { 5.704224e-01,  4.370528e-01,  6.954159e-01,  9.335951e-01, -1.299786e-01,  1.982440e-01},
  { 7.141016e-01,  2.714622e-01,  6.452652e-01,  9.853348e-01, -1.898540e-01,  1.827589e-01},
  { 8.976880e-01, -1.233010e-01,  4.230283e-01,  1.046680e+00, -3.219305e-01,  1.161233e-01},
  { 1.881576e-01,  5.818665e-01,  7.912194e-01, -2.621358e-01,  7.453276e-01,  2.284247e-01},
  { 3.240166e-01,  4.919574e-01,  8.080787e-01, -1.955002e-01,  7.005634e-01,  2.360686e-01},
  { 4.113382e-01,  4.141062e-01,  8.119833e-01,  8.887128e-01, -1.439729e-01,  2.352851e-01},
  { 5.428863e-01,  3.056408e-01,  7.822137e-01,  9.277157e-01, -1.805250e-01,  2.284247e-01},
  { 6.404777e-01,  1.607046e-01,  7.509742e-01,  9.620114e-01, -2.196833e-01,  2.149014e-01},
  { 8.525653e-01, -2.307949e-01,  4.688988e-01,  1.035899e+00, -3.629520e-01,  1.216110e-01},
  { 8.600929e-01, -4.799660e-01,  1.728373e-01,  1.036096e+00, -4.537528e-01,  2.342204e-02},
  { 2.006961e-01,  4.197574e-01,  8.851694e-01, -2.452810e-01,  6.804953e-01,  2.633126e-01},
  { 3.094748e-01,  3.998696e-01,  8.627454e-01,  2.329315e-01,  3.090756e-01,  2.642905e-01},
  { 3.648783e-01,  2.761706e-01,  8.891533e-01,  8.808716e-01, -1.976549e-01,  2.603728e-01},
  { 5.275425e-01,  1.307699e-01,  8.394035e-01,  9.186991e-01, -2.342847e-01,  2.492001e-01},
  { 8.453594e-01, -3.895169e-01,  3.655735e-01,  1.030803e+00, -4.336442e-01,  7.555343e-02},
  { 3.070504e-02,  3.437575e-01,  9.385563e-01, -2.974139e-01,  6.570149e-01,  2.807535e-01},
  { 1.592748e-01,  2.577603e-01,  9.529906e-01, -2.542960e-01,  6.251087e-01,  2.848715e-01},
  { 1.647725e-01,  2.121016e-01,  9.632564e-01,  2.054931e-01,  2.674081e-01,  2.848715e-01},
  { 2.178565e-01,  1.799150e-01,  9.592544e-01,  8.301129e-01, -2.192123e-01,  2.838906e-01},
  { 3.814704e-01,  7.812192e-02,  9.210740e-01,  8.704854e-01, -2.539028e-01,  2.758550e-01},
  { 5.221839e-01, -4.492353e-02,  8.516489e-01,  9.249703e-01, -3.071736e-01,  2.492001e-01},
  { 7.667514e-01, -3.023772e-01,  5.662687e-01,  1.001406e+00, -4.073034e-01,  1.504220e-01},
  { 7.476587e-01, -6.637323e-01,  2.157961e-02,  1.000623e+00, -5.132364e-01, -2.557524e-02},
  { 2.147267e-01,  2.576952e-02,  9.763342e-01,  8.189402e-01, -2.771873e-01,  2.931015e-01},
  { 3.702817e-01, -1.134762e-01,  9.219623e-01,  8.781292e-01, -3.275557e-01,  2.715426e-01},
  { 6.728712e-01, -4.014105e-01,  6.213806e-01,  9.823950e-01, -4.315867e-01,  1.576741e-01},
  { 5.208558e-01, -5.160214e-01,  6.800228e-01,  9.122306e-01, -4.649449e-01,  1.982440e-01},
  { 6.827905e-01, -5.476959e-01,  4.835558e-01,  9.749485e-01, -4.656686e-01,  1.378796e-01},
  {-1.423008e-01, -1.418408e-01,  9.796079e-01, -3.522906e-01,  4.991075e-01,  2.974139e-01},
  {-7.871701e-02, -1.502960e-01,  9.855022e-01,  7.111455e-01, -3.283991e-01,  2.974139e-01},
  { 3.736972e-02, -2.346402e-01,  9.713637e-01,  7.538716e-01, -3.608346e-01,  2.931015e-01},
  { 1.534811e-01, -4.726319e-01,  8.677918e-01,  8.089457e-01, -4.562230e-01,  2.492001e-01},
  { 7.152350e-01, -6.576046e-01,  2.366329e-01,  9.849430e-01, -5.195659e-01,  2.988763e-02},
  { 8.153402e-03, -3.816589e-01,  9.242673e-01,  7.438772e-01, -4.165742e-01,  2.758550e-01},
  { 5.103033e-01, -6.581401e-01,  5.535722e-01,  9.247730e-01, -5.056509e-01,  1.504220e-01},
  { 6.255649e-01, -6.926062e-01,  3.591173e-01,  9.575046e-01, -5.277002e-01,  7.555343e-02},
  {-3.426274e-01, -3.089748e-01,  8.872097e-01, -4.357825e-01,  4.354894e-01,  2.633126e-01},
  {-2.739166e-01, -3.493253e-01,  8.960701e-01,  9.867942e-02,  1.891378e-02,  2.642905e-01},
  {-5.631183e-02, -4.888760e-01,  8.705339e-01,  7.142826e-01, -4.547336e-01,  2.556687e-01},
  { 1.231945e-02, -5.865508e-01,  8.098187e-01,  7.593592e-01, -4.802117e-01,  2.409671e-01},
  { 2.103621e-01, -6.169577e-01,  7.583607e-01,  8.040442e-01, -5.009078e-01,  2.192138e-01},
  { 3.430229e-01, -6.801770e-01,  6.478383e-01,  8.679374e-01, -5.218986e-01,  1.747233e-01},
  {-5.046309e-01, -3.099063e-01,  8.057950e-01, -5.028113e-01,  4.359201e-01,  2.284247e-01},
  {-4.030185e-01, -4.275498e-01,  8.091831e-01, -4.430346e-01,  3.823562e-01,  2.360686e-01},
  {-1.965226e-01, -5.796368e-01,  7.908224e-01,  6.641100e-01, -4.761550e-01,  2.327371e-01},
  {-7.836775e-02, -6.632162e-01,  7.443136e-01,  7.099702e-01, -5.024764e-01,  2.225453e-01},
  { 1.530757e-01, -7.313972e-01,  6.645495e-01,  8.030663e-01, -5.385963e-01,  1.831507e-01},
  { 3.777264e-01, -7.724283e-01,  5.105657e-01,  8.695045e-01, -5.495717e-01,  1.388575e-01},
  {-9.109120e-01,  3.456655e-01,  2.252878e-01, -6.294196e-01,  6.741254e-01,  2.087409e-02},
  {-6.304073e-01, -3.916291e-01,  6.702338e-01, -5.273100e-01,  4.045222e-01,  1.945178e-01},
  {-5.175134e-01, -5.019066e-01,  6.930149e-01, -4.890907e-01,  3.671866e-01,  2.004002e-01},
  {-4.060073e-01, -5.224880e-01,  7.497762e-01,  4.536974e-02, -4.958493e-02,  2.011838e-01},
  {-1.178014e-01, -7.431752e-01,  6.586452e-01,  7.099702e-01, -5.434964e-01,  1.827589e-01},
  { 3.769781e-02, -7.866223e-01,  6.162826e-01,  7.585757e-01, -5.593134e-01,  1.653180e-01},
  { 2.193763e-01, -8.444403e-01,  4.886661e-01,  8.301129e-01, -5.703471e-01,  1.300384e-01},
  { 4.934469e-01, -7.988151e-01,  3.440994e-01,  9.177182e-01, -5.606457e-01,  6.869309e-02},
  {-8.767163e-01,  4.803342e-01,  2.545087e-02, -6.192278e-01,  7.076780e-01, -3.302472e-02},
  {-9.501147e-01,  2.219949e-01,  2.190897e-01, -6.456867e-01,  6.196599e-01,  2.930148e-02},
  {-7.133667e-01, -4.192987e-01,  5.615126e-01, -5.649387e-01,  3.982899e-01,  1.504220e-01},
  {-5.266340e-01, -6.081741e-01,  5.939536e-01, -4.896798e-01,  3.224807e-01,  1.602221e-01},
  {-5.179249e-01, -6.641941e-01,  5.390733e-01,  2.381082e-02, -7.718030e-02,  1.602221e-01},
  {-2.711155e-01, -7.303702e-01,  6.269416e-01,  6.415702e-01, -5.481616e-01,  1.547344e-01},
  {-1.513460e-01, -8.294145e-01,  5.377415e-01,  6.901757e-01, -5.689954e-01,  1.449344e-01},
  { 2.240068e-02, -8.853331e-01,  4.644174e-01,  7.401539e-01, -5.828311e-01,  1.304302e-01},
  { 3.854941e-01, -8.657798e-01,  3.190919e-01,  8.857731e-01, -5.800873e-01,  6.398895e-02},
  { 5.511054e-01, -8.119417e-01,  1.924409e-01,  9.288909e-01, -5.644677e-01,  3.576706e-02},
  {-8.257264e-01, -3.830433e-01,  4.140697e-01, -5.962976e-01,  3.992499e-01,  1.024056e-01},
  {-6.567602e-01, -5.815731e-01,  4.800404e-01, -5.471045e-01,  3.361999e-01,  1.124001e-01},
  {-3.246725e-01, -8.327877e-01,  4.483886e-01,  6.247154e-01, -5.697400e-01,  1.100465e-01},
  {-1.314340e-01, -9.083749e-01,  3.969637e-01,  6.997784e-01, -5.965907e-01,  9.730974e-02},
  { 2.119318e-01, -9.157693e-01,  3.412498e-01,  8.026745e-01, -6.055474e-01,  6.869309e-02},
  {-9.759564e-01,  1.831177e-01,  1.182242e-01, -6.548976e-01,  6.077635e-01, -1.695347e-02},
  {-9.273996e-01, -2.581286e-01,  2.707390e-01, -6.403949e-01,  4.570080e-01,  4.439183e-02},
  {-8.393117e-01, -4.540586e-01,  2.989762e-01, -6.080565e-01,  3.842372e-01,  5.654246e-02},
  {-7.413978e-01, -6.046213e-01,  2.911396e-01, -5.772867e-01,  3.403164e-01,  6.163837e-02},
  {-6.362283e-01, -7.007968e-01,  3.226412e-01, -5.196661e-01,  2.840282e-01,  6.457809e-02},
  {-5.779423e-01, -7.954840e-01,  1.821755e-01,  5.359318e-01, -5.534130e-01,  1.224932e-02},
  {-5.930417e-01, -7.592582e-01,  2.680084e-01,  1.205195e-02, -1.297244e-01,  6.457809e-02},
  {-3.999113e-01, -8.621898e-01,  3.109657e-01,  6.123674e-01, -5.855556e-01,  6.163837e-02},
  {-2.328374e-01, -9.338700e-01,  2.714290e-01,  6.625400e-01, -6.045082e-01,  5.654246e-02},
  { 2.365840e-02, -9.655738e-01,  2.590511e-01,  7.675923e-01, -6.186191e-01,  3.929592e-02},
  {-6.137687e-02, -5.583753e-01,  8.273149e-01,  8.034580e-01, -6.161295e-01,  2.851496e-02},
  {-3.742424e-01, -6.037592e-01,  7.038590e-01,  7.834662e-01, -6.207559e-01,  1.812876e-02},
  { 3.632654e-01, -5.552548e-01,  7.481513e-01,  8.746004e-01, -7.586146e-01,  3.126029e-02},
  { 5.708172e-01, -3.730501e-01,  7.314379e-01,  8.675457e-01, -6.002362e-01,  1.812876e-02},
  { 2.739061e-01, -5.377800e-01,  7.973507e-01,  8.365784e-01, -6.076438e-01,  3.126029e-02},
  {-9.963599e-01,  3.223141e-02,  7.891784e-02, -6.605812e-01,  5.547289e-01, -9.898744e-03},
  {-9.790354e-01, -1.672640e-01,  1.162422e-01, -6.533306e-01,  4.749603e-01, -6.848376e-04},
  {-9.203252e-01, -3.669787e-01,  1.353816e-01, -6.380428e-01,  4.235720e-01,  4.411072e-03},
  {-8.001395e-01, -5.773107e-01,  1.627546e-01, -6.008059e-01,  3.522906e-01,  9.701367e-03},
  {-6.654519e-01, -7.294110e-01,  1.585352e-01, -5.478880e-01,  2.914567e-01,  1.205195e-02},
  {-4.252006e-01, -8.914024e-01,  1.568642e-01,  5.810084e-01, -5.830674e-01,  1.166018e-02},
  {-1.472993e-01, -9.817204e-01,  1.205317e-01,  6.815510e-01, -6.198931e-01,  6.369886e-03},
  {-4.888703e-01, -7.385373e-01,  4.642935e-01,  7.677867e-01, -6.251266e-01,  1.863117e-03},
  {-9.981180e-01, -5.850665e-02, -1.836604e-02, -6.619538e-01,  5.258401e-01, -4.145211e-02},
  {-9.698592e-01, -2.054158e-01, -1.310625e-01, -6.533306e-01,  4.749603e-01, -8.221640e-02},
  {-9.590859e-01, -2.830899e-01, -3.776517e-03, -6.488223e-01,  4.462883e-01, -4.145211e-02},
  {-8.696640e-01, -4.936440e-01, -2.430361e-04, -6.174648e-01,  3.719879e-01, -4.145211e-02},
  {-7.389473e-01, -6.737526e-01, -3.784772e-03, -5.696428e-01,  3.070569e-01, -4.145211e-02},
  {-6.445241e-01, -7.645839e-01, -2.578257e-05, -5.298564e-01,  2.707800e-01, -4.145211e-02},
  {-6.125035e-01, -7.902502e-01, -1.855082e-02,  1.665740e-03, -1.429726e-01, -4.145211e-02},
  {-5.715748e-01, -8.205480e-01,  1.794668e-03,  5.553345e-01, -5.724241e-01, -4.145211e-02},
  {-4.129911e-01, -9.107289e-01, -3.375466e-03,  6.023729e-01, -5.984329e-01, -4.145211e-02},
  {-2.739880e-01, -9.614594e-01,  2.294479e-02,  6.531347e-01, -6.167381e-01, -4.145211e-02},
  {-6.014411e-01, -7.585108e-01,  2.508586e-01,  7.575948e-01, -6.273022e-01, -1.871790e-02},
  {-7.133185e-01, -7.008241e-01,  4.712011e-03,  7.542633e-01, -6.287317e-01, -4.145211e-02},
  { 9.866058e-01, -1.480506e-01, -6.848440e-02,  8.969429e-01, -5.928854e-01, -4.145211e-02},
  { 5.890285e-01, -8.075733e-01, -2.950993e-02,  9.580938e-01, -5.540799e-01, -4.145211e-02},
  {-9.760221e-01,  2.048780e-01, -7.352418e-02, -6.548976e-01,  6.077635e-01, -6.575338e-02},
  {-9.019215e-01, -4.075173e-01, -1.430640e-01, -6.276551e-01,  3.988775e-01, -8.927411e-02},
  {-7.815968e-01, -5.987037e-01, -1.751003e-01, -5.847347e-01,  3.306734e-01, -9.358350e-02},
  {-6.473586e-01, -7.480238e-01, -1.462435e-01, -5.273100e-01,  2.741115e-01, -9.495617e-02},
  {-4.849332e-01, -8.605185e-01, -1.560380e-01,  5.810084e-01, -5.830674e-01, -9.437002e-02},
  {-3.008589e-01, -9.411334e-01, -1.541165e-01,  6.298113e-01, -6.054099e-01, -9.240822e-02},
  {-9.945375e-02, -9.889588e-01, -1.098605e-01,  7.080114e-01, -6.240680e-01, -8.711792e-02},
  { 8.505479e-01, -3.487754e-01, -3.936038e-01,  8.891046e-01, -5.947276e-01, -7.476991e-02},
  {-9.271075e-01,  3.386818e-01, -1.605191e-01, -6.347113e-01,  6.672651e-01, -8.946849e-02},
  {-9.771232e-01, -4.622369e-02, -2.075900e-01, -6.552909e-01,  5.344440e-01, -1.102439e-01},
  {-8.938105e-01, -3.541136e-01, -2.751477e-01, -6.315758e-01,  4.320204e-01, -1.318028e-01},
  {-7.712292e-01, -5.609744e-01, -3.008540e-01, -5.772867e-01,  3.403164e-01, -1.445426e-01},
  {-6.504989e-01, -6.971514e-01, -3.013820e-01, -5.402442e-01,  3.013540e-01, -1.470906e-01},
  {-5.768159e-01, -7.372231e-01, -3.518316e-01,  1.205195e-02, -1.297244e-01, -1.472849e-01},
  {-5.576043e-01, -7.773198e-01, -2.912927e-01,  5.437700e-01, -5.434964e-01, -1.472849e-01},
  {-4.008716e-01, -8.595192e-01, -3.170625e-01,  6.123674e-01, -5.855556e-01, -1.445426e-01},
  {-2.160416e-01, -9.253855e-01, -3.114285e-01,  6.625400e-01, -6.045082e-01, -1.392493e-01},
  {-9.769845e-02, -9.651244e-01, -2.428784e-01,  7.146744e-01, -6.156211e-01, -1.318028e-01},
  {-2.141999e-01, -6.834073e-01, -6.979061e-01,  8.310907e-01, -7.695511e-01, -1.069124e-01},
  {-2.448621e-01, -7.956821e-01, -5.540149e-01,  7.834662e-01, -6.207559e-01, -1.008356e-01},
  {-1.723057e-01, -4.930068e-01, -8.527925e-01,  8.034580e-01, -6.161295e-01, -1.112248e-01},
  {-8.585181e-01,  4.781085e-01, -1.853622e-01, -6.172689e-01,  7.016026e-01, -9.809326e-02},
  {-7.764692e-01, -4.956396e-01, -3.891490e-01, -5.814017e-01,  3.771825e-01, -1.894249e-01},
  {-6.640136e-01, -5.985432e-01, -4.481428e-01, -5.471045e-01,  3.361999e-01, -1.951069e-01},
  {-5.565019e-01, -6.787894e-01, -4.791144e-01, -5.069264e-01,  3.002759e-01, -1.970658e-01},
  {-1.927395e-02, -9.253004e-01, -3.787448e-01,  7.513236e-01, -6.049986e-01, -1.672768e-01},
  { 1.123065e-01, -4.548521e-01, -8.834574e-01,  8.256031e-01, -6.106030e-01, -1.149480e-01},
  { 3.932304e-01, -5.091456e-01, -7.655981e-01,  8.475538e-01, -6.051751e-01, -1.112248e-01},
  { 7.002056e-01, -3.291356e-01, -6.335470e-01,  8.675457e-01, -6.002362e-01, -1.008356e-01},
  { 4.517435e-01, -8.602217e-01, -2.365299e-01,  9.000799e-01, -5.832438e-01, -1.120083e-01},
  {-6.818697e-01, -4.639246e-01, -5.655332e-01, -5.482798e-01,  3.776909e-01, -2.374413e-01},
  {-5.470381e-01, -5.911779e-01, -5.926702e-01, -5.104537e-01,  3.396690e-01, -2.423398e-01},
  {-9.116433e-01, -4.109804e-01,  1.278742e-03, -3.373961e-01,  2.075148e-01, -2.462604e-01},
  {-8.079165e-01, -5.765433e-01,  1.219370e-01, -3.156413e-01,  1.742149e-01, -2.264659e-01},
  {-6.903120e-01, -7.155817e-01,  1.068281e-01, -3.015304e-01,  1.585175e-01, -2.205865e-01},
  {-4.685152e-01, -8.671734e-01,  1.688303e-01, -2.497893e-01,  1.191423e-01, -2.215644e-01},
  {-3.469068e-01, -9.377122e-01, -1.875044e-02, -2.121591e-01,  1.024251e-01, -2.376356e-01},
  {-6.276493e-01, -7.630584e-01,  1.542669e-01, -2.854591e-01,  1.438772e-01, -2.176468e-01},
  { 2.220290e-01, -9.004060e-01, -3.741285e-01,  8.391264e-01, -5.884564e-01, -1.723727e-01},
  {-5.126137e-01, -4.812977e-01, -7.110413e-01, -5.086908e-01,  3.853737e-01, -2.809509e-01},
  {-1.656825e-01, -7.959813e-01, -5.822053e-01, -2.219577e-01,  3.676890e-02, -3.707125e-01},
  { 1.777675e-01, -9.496447e-01, -2.580184e-01, -1.416029e-01,  1.041686e-01, -2.895727e-01},
  {-5.553154e-02, -9.976894e-01, -3.914340e-02, -1.749207e-01,  9.723049e-02, -2.611564e-01},
  {-9.318495e-01, -2.521833e-01, -2.608831e-01, -3.466071e-01,  2.424983e-01, -2.719344e-01},
  { 2.869163e-01, -7.802029e-01, -5.558440e-01,  8.479456e-01, -5.475142e-01, -2.376356e-01},
  { 4.067029e-01, -8.109146e-01, -4.207259e-01,  8.755813e-01, -5.689759e-01, -1.839372e-01},
  { 6.257616e-01, -7.553905e-01, -1.944419e-01,  9.555458e-01, -5.455344e-01, -1.163207e-01},
  { 7.517908e-01, -6.507508e-01, -1.064620e-01,  9.919977e-01, -5.189977e-01, -8.476435e-02},
  {-4.161463e-01, -3.997447e-01, -8.167168e-01, -4.640044e-01,  3.993680e-01, -3.179919e-01},
  {-3.219529e-01, -4.046744e-01, -8.559118e-01,  2.290139e-01, -1.407386e-01, -3.187754e-01},
  { 4.640525e-01, -7.593243e-01, -4.561599e-01, -1.131836e-01,  1.255316e-01, -3.187754e-01},
  { 1.506222e-01, -7.697760e-01, -6.202884e-01, -1.568891e-01,  6.914616e-02, -4.165756e-01},
  {-8.903981e-01,  1.515246e-01, -4.292220e-01, -3.321044e-01,  2.959440e-01, -3.187754e-01},
  {-9.097499e-01, -7.924834e-02, -4.075229e-01, -3.424920e-01,  2.761106e-01, -2.999618e-01},
  { 5.565465e-01, -7.107811e-01, -4.301700e-01,  9.418251e-01, -5.295424e-01, -1.802110e-01},
  {-3.242432e-01, -3.036512e-01, -8.959142e-01, -4.357825e-01,  4.354894e-01, -3.460194e-01},
  { 5.970873e-01, -4.906495e-01, -6.346258e-01, -9.162469e-02,  1.670032e-01, -3.470003e-01},
  {-6.222849e-01,  2.890513e-01, -7.274687e-01, -3.109372e-01,  3.185616e-01, -3.377864e-01},
  {-6.125576e-01, -1.554129e-01, -7.749968e-01, -3.675784e-01,  2.506909e-01, -4.261783e-01},
  {-6.754521e-01,  5.051767e-01, -5.371788e-01, -3.387673e-01,  2.723859e-01, -4.506769e-01},
  { 4.178277e-01, -7.073746e-01, -5.701238e-01,  8.877319e-01, -5.260540e-01, -2.397918e-01},
  { 6.500075e-01, -6.400492e-01, -4.096673e-01,  9.692635e-01, -5.126876e-01, -1.662959e-01},
  { 5.732784e-01, -2.011560e-01, -7.942847e-01, -8.633439e-02,  2.162756e-01, -3.644412e-01},
  { 4.114448e-01, -4.946043e-01, -7.655584e-01, -1.335673e-01,  1.174571e-01, -4.532249e-01},
  {-2.161696e-01,  5.229662e-01, -8.244860e-01, -2.343057e-01,  3.461376e-01, -3.685563e-01},
  {-2.903435e-01,  5.915619e-01, -7.521671e-01, -2.827153e-01,  2.839310e-01, -4.810550e-01},
  {-4.560800e-01,  3.696256e-01, -8.095479e-01, -2.758550e-01,  3.377296e-01, -3.560139e-01},
  { 4.890248e-01, -6.052458e-01, -6.281180e-01,  9.075264e-01, -5.005550e-01, -2.533152e-01},
  { 1.264919e-01,  4.915628e-01, -8.616065e-01, -1.694330e-01,  3.360833e-01, -3.762001e-01},
  {-6.395588e-02,  4.260229e-01, -9.024491e-01, -2.119632e-01,  3.462751e-01, -3.718907e-01},
  { 2.209598e-01,  3.304833e-01, -9.175825e-01, -1.500303e-01,  3.260096e-01, -3.771810e-01},
  {-9.502905e-02, -1.482015e-01, -9.843809e-01,  7.111455e-01, -3.283991e-01, -3.801208e-01},
  { 4.090317e-01,  2.720642e-01, -8.710189e-01, -1.173001e-01,  2.971403e-01, -3.765919e-01},
  { 5.375204e-01,  8.044200e-02, -8.394051e-01, -9.554531e-02,  2.590989e-01, -3.724769e-01},
  {-7.528361e-01, -6.572913e-01,  3.472909e-02,  7.920909e-01, -7.793302e-01, -4.145211e-02},
  {-1.802092e-01, -9.719149e-01,  1.513472e-01,  7.999291e-01, -7.773699e-01, -7.936939e-03},
  { 4.529789e-01, -8.230390e-01,  3.426615e-01,  9.053702e-01, -7.508721e-01,  1.812876e-02},
  { 7.158691e-01, -5.965289e-01, -3.628838e-01, -1.384673e-01,  9.973957e-02, -4.414660e-01},
  { 3.334665e-01, -9.254801e-01, -1.796853e-01, -1.857001e-01,  4.744967e-02, -3.920770e-01},
  {-6.572496e-02, -9.814182e-01,  1.802737e-01, -2.623317e-01,  3.812063e-02, -3.540550e-01},
  {-4.136043e-01, -8.479807e-01, -3.314517e-01, -3.025098e-01,  5.140917e-02, -3.440576e-01},
  {-5.602820e-01, -7.487181e-01,  3.542672e-01, -3.213249e-01,  6.216920e-02, -3.419044e-01},
  {-7.262571e-01, -6.593000e-01, -1.946126e-01, -3.544468e-01,  9.056753e-02, -3.434715e-01},
  {-8.917286e-01, -3.988470e-01,  2.138714e-01, -3.783578e-01,  1.257470e-01, -3.526824e-01},
  {-6.123415e-01, -4.527112e-01, -6.481438e-01, -3.861976e-01,  1.448372e-01, -3.597371e-01},
  {-9.967449e-01, -4.781404e-02,  6.491171e-02, -3.924688e-01,  1.836232e-01, -3.785537e-01},
  {-9.356267e-01,  2.616447e-02, -3.520200e-01, -3.909002e-01,  2.023994e-01, -3.895290e-01},
  {-9.173164e-01,  2.667297e-01, -2.956111e-01, -3.783578e-01,  2.363437e-01, -4.136359e-01},
  {-5.370093e-01,  4.160517e-01, -7.338406e-01, -3.213249e-01,  2.792074e-01, -4.618497e-01},
  {-1.868190e-01,  2.770570e-01, -9.425169e-01, -2.419495e-01,  2.765024e-01, -4.945783e-01},
  { 1.194997e-01,  3.533360e-01, -9.278327e-01, -2.031426e-01,  2.576873e-01, -5.008495e-01},
  { 2.796526e-01,  2.400943e-01, -9.295962e-01, -1.857001e-01,  2.445169e-01, -5.010469e-01},
  { 6.045684e-01,  2.105625e-01, -7.682191e-01, -1.568891e-01,  2.123355e-01, -4.955592e-01},
  {-1.570314e-02, -3.768886e-01, -9.261255e-01, -1.384673e-01,  1.750194e-01, -4.830168e-01},
  { 6.766324e-01, -2.597889e-01, -6.889690e-01, -1.335673e-01,  1.555568e-01, -4.741947e-01},
  {-5.761639e-01, -7.402153e-01, -3.465782e-01, -3.581701e-01,  3.661190e-02, -3.742413e-01},
  {-5.970154e-01, -3.774008e-01, -7.079133e-01, -4.251989e-01,  1.692177e-01, -4.187318e-01},
  {-7.193361e-01, -5.473672e-01, -4.277205e-01, -3.571906e-01,  1.134393e-01, -4.171618e-01},
  {-6.167760e-01, -7.416309e-01,  2.637629e-01, -3.268126e-01,  7.698591e-02, -4.101070e-01},
  {-1.915916e-01, -7.069722e-01, -6.807958e-01, -2.133344e-01,  4.254067e-03, -4.187318e-01},
  { 6.107161e-02, -9.949633e-01,  7.948719e-02, -2.615481e-01,  5.431001e-02, -4.255892e-01},
  { 2.335060e-01, -9.433913e-01, -2.355586e-01, -2.401851e-01,  5.766093e-02, -4.365645e-01},
  { 5.567113e-01, -3.502074e-01,  7.532777e-01, -1.953043e-01,  2.732173e-02, -3.769867e-01},
  {-2.602237e-01, -3.339483e-01,  9.059592e-01, -3.403359e-01,  5.967956e-02, -3.324961e-01},
  { 2.094157e-01, -5.804093e-01, -7.869372e-01, -1.351343e-01,  1.045020e-01, -5.075155e-01},
  { 4.002069e-01, -5.077157e-01, -7.629281e-01, -1.935399e-01,  1.175349e-01, -4.896798e-01},
  { 9.906479e-01,  1.226185e-01, -5.984533e-02, -1.173001e-01,  1.275697e-01, -4.657673e-01},
  {-6.187548e-02, -2.040113e-01, -9.770111e-01, -2.021632e-01,  2.371078e-01, -5.520030e-01},
  { 2.623890e-01, -3.295925e-02, -9.643991e-01, -2.162741e-01,  1.799583e-01, -5.143728e-01},
  { 2.503971e-01,  2.626490e-01, -9.318352e-01, -2.337180e-01,  1.967159e-01, -5.163347e-01},
  {-5.208415e-01,  3.678558e-02, -8.528605e-01, -3.471947e-01,  2.694657e-01, -5.075155e-01},
  {-1.789438e-01,  4.195026e-01, -8.899419e-01, -2.764426e-01,  2.171369e-01, -5.090826e-01},
  {-3.926977e-01,  3.072583e-01, -8.668223e-01, -2.989824e-01,  2.194112e-01, -5.006552e-01},
  {-5.432990e-01,  5.610415e-01, -6.245468e-01, -3.201481e-01,  2.160393e-01, -4.896798e-01},
  {-8.422164e-01,  2.167103e-01, -4.936683e-01, -3.532715e-01,  1.937358e-01, -4.632193e-01},
  {-8.783682e-01, -2.328840e-02, -4.774169e-01, -3.628742e-01,  1.762933e-01, -4.493043e-01},
  {-9.990457e-01,  3.071789e-02, -3.104954e-02, -3.667948e-01,  1.561848e-01, -4.365645e-01},
  {-3.223544e-02, -6.685840e-01, -7.429376e-01, -2.880071e-01,  2.042251e-02, -6.011977e-01},
  { 5.431140e-01, -6.454959e-01, -5.369937e-01, -2.613523e-01,  3.498503e-02, -5.974745e-01},
  {-6.962683e-02, -3.565545e-01, -9.316764e-01, -2.852633e-01,  7.708310e-02, -6.337320e-01},
  { 3.862681e-01, -3.963412e-01, -8.328929e-01, -2.784029e-01,  4.692034e-02, -6.200113e-01},
  {-4.121727e-02, -8.613867e-01, -5.062746e-01, -3.113289e-01,  4.665269e-03, -5.823811e-01},
  {-3.187397e-01, -7.120815e-01, -6.255757e-01, -3.422962e-01,  3.901182e-03, -5.686634e-01},
  {-5.509816e-01, -8.047430e-01, -2.209251e-01, -3.724784e-01,  1.830669e-02, -5.637619e-01},
  {-6.336824e-01, -5.844095e-01, -5.068649e-01, -3.846290e-01,  3.014332e-02, -5.649402e-01},
  {-7.885967e-01, -3.583740e-01, -4.996832e-01, -3.993291e-01,  5.907248e-02, -5.747373e-01},
  {-7.419357e-01, -2.073178e-01, -6.376134e-01, -3.979564e-01,  8.839189e-02, -5.913976e-01},
  {-6.680003e-01,  1.151086e-01, -7.352045e-01, -3.809058e-01,  1.102843e-01, -6.109977e-01},
  {-1.972523e-01, -2.868675e-02, -9.799330e-01, -3.211290e-01,  1.117736e-01, -6.374552e-01},
  {-4.291370e-02,  4.662040e-01, -8.836358e-01, -3.295564e-01,  1.387215e-01, -6.254990e-01},
  {-3.942887e-01, -1.880111e-01, -8.995488e-01, -3.528783e-01,  1.188298e-01, -6.276551e-01},
  { 9.674438e-02,  1.409243e-01, -9.852821e-01, -3.066248e-01,  1.028168e-01, -6.386304e-01},
  { 4.271591e-01,  8.714509e-02, -8.999671e-01, -2.774235e-01,  1.065207e-01, -6.300087e-01},
  { 6.066781e-01, -6.964355e-01, -3.833006e-01, -2.070632e-01,  7.998394e-02, -4.632193e-01},
  { 9.686756e-01, -8.304694e-02,  2.340314e-01, -2.064755e-01,  8.588282e-02, -4.977154e-01},
  { 8.634765e-01, -4.130633e-01,  2.894600e-01, -2.109823e-01,  5.617163e-02, -4.934030e-01},
  { 6.728477e-01, -5.576392e-01,  4.861219e-01, -2.305824e-01,  5.489766e-02, -4.702771e-01},
  { 7.015072e-01, -5.768682e-01,  4.184624e-01, -2.274453e-01,  4.092278e-02, -4.779209e-01},
  { 5.854120e-01, -7.376796e-01, -3.363355e-01, -2.315618e-01,  2.973212e-02, -5.412250e-01},
  { 4.482804e-01, -8.762428e-01, -1.767575e-01, -2.480249e-01,  1.448476e-02, -5.257400e-01},
  { 6.238726e-01, -7.002763e-01, -3.469814e-01, -2.464563e-01,  3.182999e-02, -5.520030e-01},
  { 4.018945e-01, -8.832920e-01, -2.414044e-01, -2.607646e-01,  1.848314e-02, -5.382853e-01},
  { 6.820980e-01, -7.157954e-01, -1.495968e-01, -2.533166e-01,  2.295103e-02, -5.680743e-01},
  { 5.775072e-01, -5.669717e-01,  5.873913e-01, -2.492001e-01,  4.613682e-02, -4.575373e-01},
  { 4.952486e-01, -6.813226e-01,  5.390068e-01, -2.482207e-01,  3.108535e-02, -4.636111e-01},
  { 2.515207e-01, -9.614708e-01, -1.109556e-01, -2.688003e-01,  4.645830e-03, -5.114331e-01},
  { 2.797793e-01, -9.593459e-01,  3.713446e-02, -2.789906e-01,  9.858372e-03, -5.257400e-01},
  { 4.081485e-01, -9.106790e-01,  6.386468e-02, -2.858509e-01,  9.809027e-04, -5.418112e-01},
  { 2.013945e-01, -9.507467e-01, -2.356289e-01, -2.981974e-01,  5.502625e-04, -5.625866e-01},
  { 3.151633e-01, -6.724258e-01,  6.697131e-01, -2.721317e-01,  2.730229e-02, -4.512661e-01},
  { 1.068669e-01, -9.770051e-01,  1.845010e-01, -2.927097e-01,  8.627757e-04, -4.990851e-01},
  {-4.653813e-02, -9.987738e-01,  1.687968e-02, -2.999618e-01,  6.565768e-03, -5.149620e-01},
  { 9.543272e-02, -9.718614e-01,  2.153559e-01, -3.068222e-01, -2.331139e-03, -5.310332e-01},
  {-4.482410e-01, -8.734000e-01, -1.904008e-01, -3.062330e-01,  6.430446e-02, -4.118715e-01},
  {-3.083597e-01, -9.249099e-01, -2.223867e-01, -2.840865e-01,  5.658283e-02, -4.171618e-01},
  { 7.002460e-02, -5.811824e-01,  8.107549e-01, -2.929056e-01,  4.503928e-02, -4.379372e-01},
  { 9.478828e-02, -6.932770e-01,  7.144104e-01, -2.976098e-01,  2.985025e-02, -4.416604e-01},
  {-2.017657e-01, -9.700869e-01,  1.349887e-01, -3.181893e-01,  3.410730e-03, -4.894824e-01},
  {-2.936629e-01, -9.559041e-01, -3.085065e-03, -3.362194e-01, -3.917630e-04, -5.457318e-01},
  {-1.151932e-01, -6.327362e-01,  7.657515e-01, -3.152496e-01,  5.278034e-02, -4.326469e-01},
  {-1.384557e-01, -5.986788e-01,  7.889320e-01, -3.225002e-01,  3.855127e-02, -4.357810e-01},
  {-4.514330e-01, -8.882082e-01,  8.540666e-02, -3.430797e-01,  1.211325e-02, -4.836030e-01},
  {-4.044093e-01, -8.917919e-01,  2.028802e-01, -3.440591e-01,  1.640470e-02, -5.014387e-01},
  {-2.994910e-01, -9.067090e-01,  2.969579e-01, -3.509195e-01,  7.527232e-03, -5.175099e-01},
  {-3.889979e-01, -4.662903e-01,  7.945150e-01, -3.456277e-01,  5.279978e-02, -4.336248e-01},
  {-5.728308e-01, -7.772047e-01,  2.604184e-01, -3.662057e-01,  2.636176e-02, -4.816442e-01},
  {-5.623877e-01, -7.187236e-01,  4.088477e-01, -3.711057e-01,  1.999187e-02, -5.157455e-01},
  {-5.976504e-01, -1.450412e-01,  7.885284e-01, -3.530757e-01,  8.221789e-02, -4.326469e-01},
  {-5.039912e-01, -2.578531e-01,  8.243207e-01, -3.650304e-01,  7.165375e-02, -4.357810e-01},
  {-7.859415e-01, -5.748977e-01,  2.275711e-01, -3.856084e-01,  4.521573e-02, -4.836030e-01},
  {-7.569916e-01, -6.244594e-01,  1.923904e-01, -3.812975e-01,  4.537273e-02, -5.014387e-01},
  {-7.917677e-01, -5.079416e-01,  3.392627e-01, -3.881564e-01,  3.649377e-02, -5.175099e-01},
  {-7.633307e-01, -6.459603e-01,  7.841940e-03, -3.883522e-01,  3.181056e-02, -5.412250e-01},
  {-4.759247e-01,  4.538412e-01,  7.533418e-01, -4.071673e-01,  1.922853e-01, -3.769867e-01},
  {-6.593716e-01, -8.271168e-02,  7.472537e-01, -3.797290e-01,  9.380181e-02, -4.416604e-01},
  {-9.033520e-01, -4.173866e-01,  9.870990e-02, -4.003085e-01,  6.736230e-02, -4.894824e-01},
  {-9.233671e-01, -3.536619e-01, -1.493866e-01, -3.648345e-01,  1.347440e-01, -4.255892e-01},
  {-6.417539e-01,  1.093922e-01,  7.590687e-01, -3.738495e-01,  1.231990e-01, -4.463646e-01},
  {-7.123829e-01,  1.531485e-01,  6.848767e-01, -3.883522e-01,  1.177322e-01, -4.512661e-01},
  {-9.819668e-01, -1.547638e-01,  1.085792e-01, -4.089318e-01,  9.129274e-02, -4.990851e-01},
  {-9.577639e-01, -2.875299e-01,  3.874543e-03, -4.016797e-01,  8.570638e-02, -5.149620e-01},
  {-9.469289e-01, -2.352630e-01,  2.190363e-01, -4.085400e-01,  7.682890e-02, -5.310332e-01},
  {-7.856748e-01,  3.173665e-01,  5.310308e-01, -3.905084e-01,  1.418376e-01, -4.636111e-01},
  {-9.962419e-01,  5.409104e-02, -6.764809e-02, -4.110880e-01,  1.153996e-01, -5.114331e-01},
  {-9.937308e-01,  1.830884e-02, -1.102900e-01, -4.036400e-01,  1.068152e-01, -5.257400e-01},
  {-9.829919e-01,  1.408157e-01,  1.178899e-01, -4.105003e-01,  9.793626e-02, -5.418112e-01},
  {-9.779949e-01, -8.735142e-02, -1.894615e-01, -4.079524e-01,  8.590226e-02, -5.625866e-01},
  {-7.291406e-01,  5.824007e-01,  3.593933e-01, -3.718892e-01,  1.647692e-01, -4.702771e-01},
  {-6.909164e-01,  5.601797e-01,  4.569830e-01, -3.861976e-01,  1.644552e-01, -4.779209e-01},
  {-9.476845e-01,  2.498848e-01, -1.986245e-01, -4.067756e-01,  1.380157e-01, -5.257400e-01},
  {-9.521551e-01,  1.194683e-01, -2.812972e-01, -3.997208e-01,  1.266097e-01, -5.382853e-01},
  {-1.975968e-01,  9.668067e-01,  1.619887e-01, -3.291647e-01,  2.925348e-01, -4.657673e-01},
  {-5.491807e-01,  7.402741e-01,  3.878075e-01, -3.622866e-01,  1.821922e-01, -4.839948e-01},
  {-5.972483e-01,  7.361367e-01,  3.184295e-01, -3.754181e-01,  1.840538e-01, -4.934030e-01},
  {-8.452085e-01,  4.643365e-01, -2.646019e-01, -3.959961e-01,  1.576158e-01, -5.412250e-01},
  {-8.540173e-01,  3.665251e-01, -3.692069e-01, -3.903126e-01,  1.437591e-01, -5.520030e-01},
  {-9.149398e-01,  3.866784e-01, -1.156068e-01, -3.971729e-01,  1.348801e-01, -5.680743e-01},
  {-8.538697e-01,  2.650250e-01, -4.479601e-01, -3.961920e-01,  1.184365e-01, -5.857126e-01},
  {-4.479648e-01,  8.761529e-01,  1.779992e-01, -3.477838e-01,  1.957544e-01, -4.977154e-01},
  {-6.941770e-01,  2.155582e-01, -6.867700e-01, -3.387673e-01,  2.072785e-01, -4.769400e-01},
  {-5.222313e-01,  8.503834e-01,  6.420732e-02, -3.591509e-01,  1.993027e-01, -5.088851e-01},
  {-7.237573e-01,  4.272525e-01, -5.418770e-01, -3.797290e-01,  1.728632e-01, -5.567071e-01},
  {-7.186956e-01,  5.285996e-01, -4.517290e-01, -3.760057e-01,  1.571059e-01, -5.655263e-01},
  {-6.875639e-01,  6.633314e-01, -2.953764e-01, -3.828646e-01,  1.482270e-01, -5.815976e-01},
  {-2.617147e-01,  9.637651e-01,  5.159826e-02, -3.291647e-01,  2.045152e-01, -5.106496e-01},
  {-2.160738e-01,  9.721201e-01,  9.107506e-02, -3.381797e-01,  2.091416e-01, -5.231920e-01},
  {-5.411070e-01,  6.686968e-01, -5.099487e-01, -3.587592e-01,  1.827021e-01, -5.712113e-01},
  {-5.586053e-01,  5.652614e-01, -6.069922e-01, -3.577783e-01,  1.657292e-01, -5.780687e-01},
  {-4.924883e-01,  6.959763e-01, -5.225633e-01, -3.646386e-01,  1.568502e-01, -5.941399e-01},
  {-5.187976e-01,  5.006358e-01, -6.929739e-01, -3.675784e-01,  1.377809e-01, -6.086442e-01},
  {-5.106615e-02,  9.969608e-01, -5.883323e-02, -3.079975e-01,  2.078676e-01, -5.216249e-01},
  {-5.844479e-02,  9.874223e-01, -1.469059e-01, -3.142687e-01,  2.129232e-01, -5.357374e-01},
  {-3.582615e-01,  6.473613e-01, -6.727347e-01, -3.348482e-01,  1.864852e-01, -5.835564e-01},
  {-2.655146e-01,  5.767310e-01, -7.725823e-01, -3.368085e-01,  1.690412e-01, -5.888497e-01},
  { 4.922666e-01,  8.359877e-01,  2.424835e-01, -1.843290e-01,  2.601770e-01, -5.102578e-01},
  { 2.167309e-01,  9.737287e-01, -6.985820e-02, -2.854591e-01,  2.056128e-01, -5.300523e-01},
  { 1.795269e-01,  9.729081e-01, -1.456707e-01, -2.889865e-01,  2.103752e-01, -5.451427e-01},
  {-1.121421e-01,  6.681821e-01, -7.354977e-01, -3.095660e-01,  1.839372e-01, -5.929646e-01},
  {-8.893811e-02,  7.281808e-01, -6.795902e-01, -3.215208e-01,  1.579283e-01, -6.133483e-01},
  { 3.504397e-01,  8.966635e-01, -2.705302e-01, -2.631152e-01,  1.978717e-01, -5.353456e-01},
  { 6.879222e-02,  3.839303e-01, -9.207959e-01, -2.541002e-01,  2.093958e-01, -5.143728e-01},
  { 4.203512e-01,  9.052702e-01, -6.156769e-02, -2.639002e-01,  2.016742e-01, -5.510251e-01},
  { 1.151543e-01,  5.849674e-01, -8.028403e-01, -2.844782e-01,  1.752347e-01, -5.990415e-01},
  { 1.038713e-01,  5.566155e-01, -8.242512e-01, -2.927097e-01,  1.591829e-01, -6.023729e-01},
  { 5.905302e-01,  7.917958e-01, -1.559924e-01, -2.425372e-01,  1.851918e-01, -5.371071e-01},
  { 5.763633e-01,  7.400891e-01, -3.465162e-01, -2.407727e-01,  1.874257e-01, -5.531783e-01},
  { 2.686649e-01,  3.772649e-01, -8.862790e-01, -2.613523e-01,  1.609862e-01, -6.010003e-01},
  { 2.997290e-01,  3.535068e-01, -8.861125e-01, -2.725235e-01,  1.467182e-01, -6.041374e-01},
  { 3.866071e-01,  5.191258e-01, -7.622620e-01, -2.793823e-01,  1.378198e-01, -6.202086e-01},
  { 8.099636e-01,  5.422531e-01, -2.234286e-01, -2.252906e-01,  1.684342e-01, -5.353456e-01},
  { 7.637294e-01,  6.346990e-01, -1.177907e-01, -2.213700e-01,  1.685717e-01, -5.510251e-01},
  { 5.274060e-01,  2.996176e-01, -7.950297e-01, -2.419495e-01,  1.421322e-01, -5.990415e-01},
  { 4.977078e-01,  2.265240e-01, -8.372418e-01, -2.554728e-01,  1.302163e-01, -6.023729e-01},
  { 9.003161e-01,  3.939392e-01, -1.850486e-01, -2.068673e-01,  1.464237e-01, -5.451427e-01},
  { 5.665046e-01,  3.274865e-02, -8.234076e-01, -2.274453e-01,  1.199856e-01, -5.929646e-01},
  { 6.228734e-01,  9.532309e-02, -7.764937e-01, -2.427330e-01,  1.108330e-01, -5.970797e-01},
  { 6.896641e-01,  2.121826e-01, -6.923453e-01, -2.495919e-01,  1.019541e-01, -6.133483e-01},
  { 9.549303e-01,  2.964275e-01,  1.545278e-02, -2.045152e-01,  1.274336e-01, -5.216249e-01},
  { 4.999515e-01, -2.096579e-01, -8.402928e-01, -1.955002e-01,  1.389772e-01, -5.006552e-01},
  { 9.862837e-01,  1.591312e-01, -4.383709e-02, -1.980481e-01,  1.224947e-01, -5.357374e-01},
  { 7.446130e-01, -1.049727e-01, -6.591905e-01, -2.186262e-01,  9.605520e-02, -5.835564e-01},
  { 7.325861e-01, -1.399000e-01, -6.661423e-01, -2.419495e-01,  8.100373e-02, -6.049209e-01},
  { 5.909519e-01, -2.751895e-01, -7.583182e-01, -2.595878e-01,  7.100779e-02, -6.182469e-01},
  { 9.961955e-01, -1.805593e-02,  8.525570e-02, -2.025549e-01,  1.060108e-01, -5.106496e-01},
  { 9.962071e-01, -8.680166e-02, -6.076570e-03, -1.958920e-01,  9.838783e-02, -5.231920e-01},
  { 7.831932e-01, -3.149384e-01, -5.361177e-01, -2.164700e-01,  7.194832e-02, -5.712113e-01},
  { 6.693523e-01, -5.240678e-01, -5.266122e-01, -2.331289e-01,  6.877384e-02, -5.780687e-01},
  { 9.581098e-01, -2.249035e-01,  1.773247e-01, -2.003987e-01,  7.577025e-02, -5.088851e-01},
  { 7.289760e-01, -5.285968e-01, -4.349474e-01, -2.209782e-01,  4.933073e-02, -5.567071e-01},
  { 7.972953e-01, -4.450735e-01, -4.077128e-01, -2.439083e-01,  4.010038e-02, -5.815976e-01},
  {-4.617250e-01, -7.171044e-01, -5.220836e-01,  5.451427e-01, -6.663425e-01, -3.742413e-01},
  {-7.716640e-01, -2.884233e-01, -5.668745e-01,  4.781153e-01, -5.337367e-01, -4.187318e-01},
  {-8.541729e-01, -5.028663e-01, -1.323408e-01,  5.461236e-01, -5.894956e-01, -4.171618e-01},
  {-7.182092e-01, -6.486189e-01, -2.519309e-01,  5.590577e-01, -6.091929e-01, -4.118715e-01},
  {-6.026307e-01, -7.784181e-01, -1.757883e-01,  5.765017e-01, -6.259490e-01, -4.101070e-01},
  {-2.198658e-01, -6.710821e-01, -7.080311e-01,  6.899784e-01, -6.987003e-01, -4.187318e-01},
  { 5.069823e-03, -9.907123e-01, -1.358797e-01,  6.417646e-01, -6.486249e-01, -4.255892e-01},
  { 5.362951e-02, -9.226041e-01, -3.820022e-01,  6.631292e-01, -6.452740e-01, -4.365645e-01},
  { 5.568797e-01, -3.504643e-01,  7.530338e-01,  7.080114e-01, -6.756327e-01, -3.769867e-01},
  {-4.777232e-01, -3.260548e-01,  8.157626e-01,  5.629783e-01, -6.432748e-01, -3.324961e-01},
  { 4.599101e-02, -5.620925e-01, -8.257947e-01,  7.679840e-01, -5.984329e-01, -5.075155e-01},
  { 5.364966e-01, -6.331394e-01, -5.579479e-01,  7.056578e-01, -6.055265e-01, -4.769400e-01},
  { 5.812620e-01, -4.549921e-01, -6.746234e-01,  7.095785e-01, -5.853986e-01, -4.896798e-01},
  { 9.906912e-01,  1.213983e-01, -6.159100e-02,  7.860141e-01, -5.753638e-01, -4.657673e-01},
  {-6.223577e-02, -2.041595e-01, -9.769573e-01,  7.011511e-01, -4.658256e-01, -5.520030e-01},
  { 1.646752e-01, -2.381476e-01, -9.571666e-01,  6.999758e-01, -5.426739e-01, -5.090826e-01},
  { 4.010586e-01,  1.051355e-01, -9.099992e-01,  6.870386e-01, -5.229766e-01, -5.143728e-01},
  { 2.501875e-01,  2.624145e-01, -9.319575e-01,  6.695977e-01, -5.062191e-01, -5.163347e-01},
  {-4.299168e-01, -5.504949e-02, -9.011887e-01,  5.561180e-01, -4.334872e-01, -5.075155e-01},
  {-1.789211e-01,  4.193378e-01, -8.900242e-01,  6.268716e-01, -4.857981e-01, -5.090826e-01},
  {-3.926214e-01,  3.076460e-01, -8.667193e-01,  6.043318e-01, -4.835432e-01, -5.006552e-01},
  {-5.432668e-01,  5.609228e-01, -6.246812e-01,  5.831646e-01, -4.868956e-01, -4.896798e-01},
  {-8.211334e-01,  9.072887e-02, -5.634785e-01,  5.500442e-01, -5.092186e-01, -4.632193e-01},
  {-8.782438e-01, -2.345332e-02, -4.776375e-01,  5.404385e-01, -5.266416e-01, -4.493043e-01},
  {-9.990578e-01,  3.119951e-02, -3.016888e-02,  5.365209e-01, -5.467696e-01, -4.365645e-01},
  { 3.666376e-02, -4.804524e-01, -8.762541e-01,  6.249098e-01, -6.560146e-01, -6.200113e-01},
  { 1.102973e-01, -2.131551e-01, -9.707726e-01,  6.180525e-01, -6.258518e-01, -6.337320e-01},
  { 9.730832e-02, -7.024949e-01, -7.050050e-01,  6.153072e-01, -6.825318e-01, -6.011977e-01},
  { 5.755028e-01, -5.906249e-01, -5.656490e-01,  6.419619e-01, -6.679499e-01, -5.974745e-01},
  {-8.046093e-03, -8.859247e-01, -4.637593e-01,  5.919838e-01, -6.982697e-01, -5.823811e-01},
  { 3.438688e-01, -8.841456e-01, -3.162922e-01,  6.211866e-01, -6.948006e-01, -5.737593e-01},
  {-3.425177e-01, -7.359740e-01, -5.839725e-01,  5.610195e-01, -6.990532e-01, -5.686634e-01},
  {-5.635418e-01, -6.976566e-01, -4.423754e-01,  5.308359e-01, -6.846477e-01, -5.637619e-01},
  {-4.609970e-01, -8.868043e-01,  3.255613e-02,  5.478880e-01, -6.966234e-01, -5.412250e-01},
  {-5.978768e-01, -3.782875e-01, -7.067121e-01,  5.026140e-01, -6.287526e-01, -5.823811e-01},
  {-9.595656e-01, -2.631011e-01, -1.000591e-01,  4.971263e-01, -6.356115e-01, -5.531783e-01},
  {-7.845483e-01, -5.749790e-01, -2.321272e-01,  5.094743e-01, -6.589139e-01, -5.686634e-01},
  {-7.656671e-01,  2.574386e-02, -6.427217e-01,  5.120223e-01, -6.022339e-01, -6.011977e-01},
  {-9.422185e-01,  1.156293e-01, -3.144108e-01,  4.986933e-01, -5.996082e-01, -5.737593e-01},
  {-2.881800e-01, -8.862540e-02, -9.534662e-01,  5.663098e-01, -5.857126e-01, -6.337320e-01},
  {-3.111025e-01,  5.057313e-01, -8.046435e-01,  5.541592e-01, -5.622531e-01, -6.182469e-01},
  {-5.229247e-01,  4.273552e-02, -8.513069e-01,  5.355400e-01, -5.864767e-01, -6.200113e-01},
  { 5.649133e-04,  1.418611e-03, -9.999989e-01,  5.964935e-01, -6.001181e-01, -6.386304e-01},
  { 3.091654e-01, -8.823679e-01, -3.547446e-01,  6.815510e-01, -6.365132e-01, -4.493043e-01},
  { 1.411935e-01, -7.167076e-01, -6.829308e-01,  6.960552e-01, -6.229510e-01, -4.632193e-01},
  { 8.374668e-01, -4.588973e-01,  2.967536e-01,  6.872360e-01, -6.344945e-01, -4.839948e-01},
  { 8.608644e-01, -3.996152e-01,  3.149923e-01,  6.921346e-01, -6.467828e-01, -4.934030e-01},
  { 7.043546e-01, -5.245853e-01,  4.782205e-01,  6.758689e-01, -6.620107e-01, -4.779209e-01},
  { 6.030708e-01, -7.087795e-01, -3.659744e-01,  6.715565e-01, -6.732222e-01, -5.412250e-01},
  { 4.291185e-01, -8.719026e-01, -2.358878e-01,  6.552879e-01, -6.884502e-01, -5.257400e-01},
  { 4.884983e-01, -7.468482e-01, -4.512065e-01,  6.568579e-01, -6.711244e-01, -5.520030e-01},
  { 4.465787e-01, -8.766730e-01, -1.789187e-01,  6.425511e-01, -6.844518e-01, -5.382853e-01},
  { 5.680422e-01, -8.196077e-01, -7.463988e-02,  6.354934e-01, -6.933502e-01, -5.545509e-01},
  { 5.566596e-01, -6.065704e-01,  5.676288e-01,  6.541126e-01, -6.567981e-01, -4.575373e-01},
  { 5.340209e-01, -6.142778e-01,  5.809342e-01,  6.550935e-01, -6.718690e-01, -4.636111e-01},
  { 3.286797e-01, -9.419006e-01,  6.923113e-02,  6.345155e-01, -6.983085e-01, -5.114331e-01},
  { 2.231187e-01, -9.672922e-01, -1.206807e-01,  6.243237e-01, -6.930751e-01, -5.257400e-01},
  { 2.857167e-01, -6.504039e-01,  7.038045e-01,  6.327510e-01, -6.601685e-01, -4.463646e-01},
  { 3.207164e-01, -6.932374e-01,  6.454169e-01,  6.311840e-01, -6.756327e-01, -4.512661e-01},
  { 3.689541e-02, -9.990485e-01, -2.325529e-02,  6.106030e-01, -7.020721e-01, -4.990851e-01},
  {-5.030010e-02, -9.954877e-01,  8.046160e-02,  6.033509e-01, -6.963871e-01, -5.149620e-01},
  { 8.759724e-02, -9.783494e-01,  1.875082e-01,  5.964935e-01, -7.052661e-01, -5.310332e-01},
  { 2.393527e-02, -9.946691e-01, -1.003020e-01,  5.866935e-01, -7.053049e-01, -5.531783e-01},
  {-4.099495e-01, -9.030824e-01,  1.279980e-01,  5.970797e-01, -6.386304e-01, -4.118715e-01},
  {-2.506873e-01, -9.377440e-01, -2.404000e-01,  6.192278e-01, -6.463715e-01, -4.171618e-01},
  { 4.191472e-02, -6.797252e-01,  7.322683e-01,  6.102112e-01, -6.578956e-01, -4.379372e-01},
  { 9.741937e-02, -5.783677e-01,  8.099384e-01,  6.057044e-01, -6.731041e-01, -4.416604e-01},
  {-1.554745e-01, -9.804729e-01,  1.204187e-01,  5.851264e-01, -6.995242e-01, -4.894824e-01},
  {-6.479055e-02, -4.465839e-01,  8.923929e-01,  5.880662e-01, -6.501740e-01, -4.326469e-01},
  {-1.872926e-01, -5.961953e-01,  7.806872e-01,  5.806167e-01, -6.644031e-01, -4.357810e-01},
  {-3.903778e-01, -8.996251e-01,  1.956522e-01,  5.600386e-01, -6.908411e-01, -4.836030e-01},
  {-3.585506e-01, -9.301406e-01,  7.924484e-02,  5.592551e-01, -6.865497e-01, -5.014387e-01},
  {-2.746528e-01, -8.699861e-01,  4.094997e-01,  5.523947e-01, -6.954271e-01, -5.175099e-01},
  {-4.570001e-01, -4.370750e-01,  7.746717e-01,  5.674852e-01, -6.374926e-01, -4.308825e-01},
  {-2.694723e-01, -3.789728e-01,  8.853046e-01,  5.576881e-01, -6.501337e-01, -4.336248e-01},
  {-5.758229e-01, -7.404361e-01,  3.466732e-01,  5.371071e-01, -6.765732e-01, -4.816442e-01},
  {-5.906000e-01, -7.918117e-01,  1.556463e-01,  5.390689e-01, -6.740641e-01, -4.996742e-01},
  {-6.267239e-01, -6.994305e-01,  3.435318e-01,  5.322085e-01, -6.829430e-01, -5.157455e-01},
  {-4.750223e-01, -2.631378e-01,  8.397096e-01,  5.380880e-01, -6.312991e-01, -4.357810e-01},
  {-7.766883e-01, -5.989764e-01,  1.948910e-01,  5.175099e-01, -6.577386e-01, -4.836030e-01},
  {-8.063194e-01, -5.677170e-01,  1.659715e-01,  5.220167e-01, -6.575622e-01, -5.014387e-01},
  {-7.749431e-01, -6.320150e-01,  4.491911e-03,  5.149620e-01, -6.711244e-01, -5.412250e-01},
  {-1.630509e-01,  4.959660e-01,  8.528964e-01,  4.959510e-01, -5.106691e-01, -3.769867e-01},
  {-5.272066e-01, -5.663445e-02,  8.478477e-01,  5.371071e-01, -6.010197e-01, -4.379372e-01},
  {-6.767737e-01, -7.693155e-02,  7.321604e-01,  5.235838e-01, -6.091526e-01, -4.416604e-01},
  {-8.985053e-01, -4.367896e-01,  4.362385e-02,  5.030057e-01, -6.355920e-01, -4.894824e-01},
  {-8.906473e-01, -3.537098e-01,  2.857217e-01,  5.022222e-01, -6.470579e-01, -5.228002e-01},
  {-7.084904e-01,  9.253746e-02,  6.996272e-01,  5.294632e-01, -5.797344e-01, -4.463646e-01},
  {-8.941965e-01, -3.355652e-01, -2.963250e-01,  5.384797e-01, -5.682104e-01, -4.255892e-01},
  {-7.119268e-01,  1.508262e-01,  6.858658e-01,  5.149620e-01, -5.852027e-01, -4.512661e-01},
  {-9.729593e-01, -1.373409e-01,  1.857082e-01,  4.943810e-01, -6.116422e-01, -4.990851e-01},
  {-9.467966e-01, -3.206854e-01,  2.714952e-02,  5.016330e-01, -6.172271e-01, -5.149620e-01},
  {-8.086933e-01,  3.197361e-01,  4.937447e-01,  5.126084e-01, -5.611168e-01, -4.636111e-01},
  {-9.987254e-01,  2.025644e-02, -4.623045e-02,  4.920304e-01, -5.875548e-01, -5.114331e-01},
  {-9.988846e-01,  4.719143e-02, -1.563039e-03,  4.928139e-01, -6.050181e-01, -5.418112e-01},
  {-7.283564e-01,  5.833443e-01,  3.594529e-01,  5.314250e-01, -5.381851e-01, -4.702771e-01},
  {-6.247180e-01,  6.022217e-01,  4.970477e-01,  5.171182e-01, -5.384797e-01, -4.779209e-01},
  {-9.542729e-01,  2.655638e-01, -1.372552e-01,  4.965371e-01, -5.649177e-01, -5.257400e-01},
  {-9.391794e-01,  2.539047e-01, -2.312455e-01,  5.035949e-01, -5.763252e-01, -5.382853e-01},
  {-4.197690e-01,  9.005345e-01,  1.132767e-01,  5.739537e-01, -4.104196e-01, -4.657673e-01},
  {-5.896189e-01,  7.451769e-01,  3.115461e-01,  5.410277e-01, -5.207427e-01, -4.839948e-01},
  {-6.227292e-01,  7.376350e-01,  2.609658e-01,  5.278961e-01, -5.188811e-01, -4.934030e-01},
  {-8.645282e-01,  3.941275e-01, -3.118565e-01,  5.073181e-01, -5.453191e-01, -5.412250e-01},
  {-8.540354e-01,  3.664700e-01, -3.692198e-01,  5.130002e-01, -5.591758e-01, -5.520030e-01},
  {-8.842072e-01,  4.344633e-01, -1.715207e-01,  5.061428e-01, -5.680549e-01, -5.680743e-01},
  {-7.451990e-01,  3.623759e-01, -5.597876e-01,  5.645454e-01, -4.956564e-01, -4.769400e-01},
  {-4.432859e-01,  8.795343e-01,  1.729648e-01,  5.555319e-01, -5.071805e-01, -4.977154e-01},
  {-4.194025e-01,  8.945364e-01,  1.546166e-01,  5.441648e-01, -5.036517e-01, -5.088851e-01},
  {-7.468479e-01,  5.096385e-01, -4.271847e-01,  5.235838e-01, -5.300717e-01, -5.567071e-01},
  {-7.088928e-01,  4.775192e-01, -5.190822e-01,  5.273070e-01, -5.458290e-01, -5.655263e-01},
  {-6.564408e-01,  6.843008e-01, -3.175183e-01,  5.204496e-01, -5.547079e-01, -5.815976e-01},
  {-7.094670e-01,  4.170880e-01, -5.680618e-01,  5.196661e-01, -5.727575e-01, -5.974745e-01},
  {-2.377384e-01,  9.622622e-01,  1.324078e-01,  5.741511e-01, -4.984391e-01, -5.106496e-01},
  {-2.288344e-01,  9.729782e-01,  3.079275e-02,  5.651345e-01, -4.937933e-01, -5.231920e-01},
  {-5.579908e-01,  5.659732e-01, -6.068943e-01,  5.445565e-01, -5.202329e-01, -5.712113e-01},
  {-5.242842e-01,  6.533293e-01, -5.461565e-01,  5.455344e-01, -5.372252e-01, -5.780687e-01},
  {-8.776797e-02,  9.904239e-01, -1.065708e-01,  5.953153e-01, -4.950673e-01, -5.216249e-01},
  { 4.933088e-04,  9.999713e-01,  7.554012e-03,  5.890440e-01, -4.900118e-01, -5.357374e-01},
  {-2.847729e-01,  7.468745e-01, -6.009018e-01,  5.684660e-01, -5.164497e-01, -5.835564e-01},
  {-2.748700e-01,  5.592452e-01, -7.821069e-01,  5.665072e-01, -5.339131e-01, -5.888497e-01},
  {-3.806811e-01,  7.386268e-01, -5.563383e-01,  5.594495e-01, -5.427906e-01, -6.049209e-01},
  { 4.920131e-01,  8.361103e-01,  2.425753e-01,  7.189867e-01, -4.427580e-01, -5.102578e-01},
  { 2.140454e-01,  9.767528e-01, -1.177262e-02,  6.178551e-01, -4.973416e-01, -5.300523e-01},
  { 1.294065e-01,  9.535432e-01, -2.720468e-01,  6.143262e-01, -4.925597e-01, -5.451427e-01},
  {-1.185628e-01,  5.922543e-01, -7.969804e-01,  5.937482e-01, -5.189977e-01, -5.929646e-01},
  {-3.728087e-02,  7.128396e-01, -7.003355e-01,  5.817919e-01, -5.450261e-01, -6.133483e-01},
  { 3.894535e-01,  8.999864e-01, -1.958326e-01,  6.401975e-01, -5.050827e-01, -5.353456e-01},
  { 6.859427e-02,  3.835959e-01, -9.209501e-01,  6.492141e-01, -4.935391e-01, -5.143728e-01},
  { 4.028548e-01,  8.938556e-01, -1.967997e-01,  6.394140e-01, -5.012608e-01, -5.510251e-01},
  { 6.262165e-02,  5.495943e-01, -8.330814e-01,  6.188360e-01, -5.277002e-01, -5.990415e-01},
  { 1.728665e-01,  6.037549e-01, -7.782012e-01,  6.106030e-01, -5.437521e-01, -6.023729e-01},
  { 1.799175e-01,  6.259990e-01, -7.587851e-01,  6.037427e-01, -5.526295e-01, -6.184442e-01},
  { 5.637229e-01,  7.706038e-01, -2.972984e-01,  6.607755e-01, -5.177626e-01, -5.371071e-01},
  { 6.120438e-01,  7.866026e-01, -8.160022e-02,  6.623456e-01, -5.155287e-01, -5.531783e-01},
  { 3.512520e-01,  4.518427e-01, -8.200367e-01,  6.417646e-01, -5.419682e-01, -6.010003e-01},
  { 5.079257e-01,  4.477441e-01, -7.358918e-01,  6.237345e-01, -5.651136e-01, -6.202086e-01},
  { 1.533724e-01,  3.290665e-01, -9.317683e-01,  6.108003e-01, -5.819101e-01, -6.315758e-01},
  { 7.622420e-01,  6.313948e-01, -1.425753e-01,  6.780251e-01, -5.345202e-01, -5.353456e-01},
  { 7.571307e-01,  5.655333e-01, -3.269939e-01,  6.819427e-01, -5.343632e-01, -5.510251e-01},
  { 5.013030e-01,  2.547563e-01, -8.269187e-01,  6.613647e-01, -5.608027e-01, -5.990415e-01},
  { 3.577904e-01,  1.641319e-01, -9.192643e-01,  6.478414e-01, -5.727186e-01, -6.023729e-01},
  { 8.739961e-01,  4.218520e-01, -2.411881e-01,  6.909593e-01, -5.542175e-01, -5.300523e-01},
  { 8.901581e-01,  4.500252e-01, -7.138522e-02,  6.964469e-01, -5.565098e-01, -5.451427e-01},
  { 6.614987e-01,  1.021161e-01, -7.429614e-01,  6.758689e-01, -5.829493e-01, -5.929646e-01},
  { 6.134422e-01,  2.963683e-02, -7.891833e-01,  6.605812e-01, -5.921019e-01, -5.970797e-01},
  { 7.261747e-01,  1.417190e-01, -6.727452e-01,  6.537209e-01, -6.010003e-01, -6.133483e-01},
  { 5.439697e-01, -7.757213e-02, -8.355115e-01,  6.370634e-01, -6.135038e-01, -6.254990e-01},
  { 7.253533e-01, -1.411557e-01, -6.737489e-01,  7.076197e-01, -5.639772e-01, -5.006552e-01},
  { 9.729012e-01,  1.796537e-01, -1.455605e-01,  7.052661e-01, -5.804597e-01, -5.357374e-01},
  { 6.701225e-01, -1.949019e-01, -7.162046e-01,  6.846880e-01, -6.068797e-01, -5.835564e-01},
  { 6.497014e-01, -1.866443e-01, -7.369206e-01,  6.682250e-01, -6.130732e-01, -5.888497e-01},
  { 9.970672e-01, -5.867580e-02,  4.913479e-02,  7.007593e-01, -5.969436e-01, -5.106496e-01},
  { 9.980049e-01, -6.287555e-02,  5.754351e-03,  7.074223e-01, -6.045471e-01, -5.231920e-01},
  { 7.282575e-01, -3.683747e-01, -5.778764e-01,  6.868442e-01, -6.309866e-01, -5.712113e-01},
  { 6.549065e-01, -5.003335e-01, -5.663602e-01,  6.701838e-01, -6.341611e-01, -5.780687e-01},
  { 8.017376e-01, -2.111484e-01, -5.591361e-01,  6.631292e-01, -6.430401e-01, -5.941399e-01},
  { 9.620438e-01, -1.701271e-01,  2.133738e-01,  6.968387e-01, -6.170521e-01, -4.977154e-01},
  { 9.483816e-01, -2.922919e-01,  1.230355e-01,  7.029155e-01, -6.271841e-01, -5.088851e-01},
  { 7.283388e-01, -5.298434e-01, -4.344982e-01,  6.823345e-01, -6.536236e-01, -5.567071e-01},
  { 8.202825e-01, -5.267812e-01, -2.227966e-01,  6.594059e-01, -6.628540e-01, -5.815976e-01},
};

static GLushort mechanical_indices[][3] =
{
  {   9,    0,    1},
  {   9,    1,    6},
  {   6,    1,    2},
  {   6,    2,   14},
  {  14,    2,    7},
  {   2,    3,    7},
  {   0,    9,    5},
  {   7,    8,   10},
  {   9,   16,   11},
  {   9,   12,   16},
  {  12,    9,    6},
  {  12,    6,   13},
  {  13,    6,   14},
  {  13,   14,   15},
  {  15,    7,   18},
  {  15,   14,    7},
  {  12,   13,   17},
  {  17,   13,   15},
  {  18,    7,   10},
  {  12,   17,   19},
  {  17,   15,   19},
  {  20,   12,   19},
  {  19,   15,   21},
  {  21,   15,   18},
  {  21,   18,   24},
  {  20,   22,   16},
  {  24,   18,   10},
  {  22,   23,   16},
  {  19,   25,   26},
  {  20,   19,   26},
  {  25,   19,   21},
  {  25,   21,   27},
  {  27,   21,   24},
  {  26,   25,   30},
  {  27,   24,   10},
  {  28, 1604,   29},
  {  30,   29,   26},
  {  30,   25,   31},
  {  31,   25,   27},
  {  31,   27,   32},
  {  32,   27,   10},
  {  30,   31,   34},
  {  31,   32,   37},
  {  37,   10,    8},
  {  37,   32,   10},
  {  30,   33,   29},
  {  30,   34,   33},
  {1660,   34,   35},
  {  34,   31,   36},
  {  36,   31,   37},
  {  34,   36,   35},
  {  37,    8,   38},
  {   8,   39,   38},
  {1660,   35,   40},
  {  40,   35,   43},
  {  35,   36,   43},
  {  43,   36,   37},
  {  43,   37,   38},
  {1660,   44,   42},
  {1660,   40,   44},
  {  40,   43,   44},
  {  43,   51,   44},
  {  51,   43,   38},
  {  51,   38,   46},
  {  46,   38,   39},
  {  46,   39,   45},
  {  44,   47,   48},
  {  47,   49,   50},
  {  47,   44,   49},
  {  51,   46,   54},
  {  54,   46,   45},
  {  52,    3,   41},
  {  53,   49,   44},
  {  53,   44,   51},
  {  54,   45,   52},
  {  53,   51,   55},
  {  55,   51,   54},
  {   3,   52,   45},
  {  55,   54,   59},
  {  59,   54,   52},
  {  59,   52,   41},
  {  56,   53,   55},
  {   3,   45,   39},
  {  56,   55,   58},
  {  58,   55,   59},
  {   7,    3,   39},
  {  60,   61,   62},
  {  56,   58,   57},
  {  57,   63,   56},
  {  57,    0,   63},
  {  57,    1,    0},
  {   1,   58,   59},
  {   1,   59,    2},
  {   2,   59,   41},
  {  63,   62,   56},
  {  57,   58,    1},
  {   2,   41,    3},
  {   7,   39,    8},
  {  65,   66,   67},
  {  67,   68,   69},
  {  69,   70,   71},
  {  69,   71,   72},
  {  73,   75,   74},
  {  69,   72,   74},
  {  72,   73,   74},
  {  74,   76,   78},
  {  76,   77,   78},
  {  79,   80,   81},
  {  81,   82,   83},
  {  78,   79,   83},
  {  79,   81,   83},
  {  67,   69,   84},
  {  65,   67,   84},
  {  74,   78,   84},
  {  78,   83,   84},
  {  69,   74,   84},
  {  64,   65,   84},
  {  64,   84,   85},
  {  64,   85,   86},
  {  65,   64,   87},
  {  65,   87,  110},
  {  64,   86,   87},
  {  86,   85,   88},
  {  86,   88,   87},
  {  85,   84,   88},
  {  84,   89,   88},
  {  84,   83,   90},
  {  84,   90,   89},
  {  83,   91,   90},
  {  82,   92,   91},
  {  83,   82,   91},
  {  82,   81,   92},
  {  81,   80,   93},
  {  81,   93,   92},
  {  80,   94,   93},
  {  80,   79,   94},
  {  94,   79,   95},
  {  79,   78,   95},
  {  78,   77,   95},
  {  95,   77,   96},
  {  96,   77,   76},
  {  96,   97, 1634},
  {  76,   98,   97},
  {  96,   76,   97},
  {  98,   76,   74},
  {  98,   74,   75},
  {  98,   75,   99},
  {  99,   75,   73},
  {  99,   73,  101},
  { 101,   73,   72},
  { 101,   72,  102},
  { 102,   72,   71},
  { 103,  104, 1610},
  { 102,   71,  104},
  { 104,   71,   70},
  { 104,   70,  105},
  { 105,   70,   69},
  { 105,   69,  106},
  { 106,   69,  107},
  { 107,   69,   68},
  { 107,   68,  108},
  {  68,   67,  108},
  {  67,  109,  108},
  {  67,   66,  110},
  {  67,  110,  109},
  {  66,   65,  110},
  { 111,  113,  114},
  { 111,  114,  112},
  { 113,  115,  114},
  { 115,  117,  116},
  { 115,  116,  114},
  { 117,  118,  116},
  { 118,  117,  119},
  { 118,  119,  120},
  { 120,  119,  121},
  { 120,  121,  122},
  { 122,  121,  123},
  { 122,  123,  124},
  { 124,  123,  125},
  { 124,  125,  126},
  { 126,  125,  127},
  { 125,  128,  127},
  { 127,  128,  129},
  { 128,  130,  129},
  { 129,  130,  131},
  { 130,  132,  131},
  { 131,  132,  133},
  { 132,  134,  133},
  { 133,  134,  135},
  { 134,  136,  135},
  { 135,  136,  137},
  { 136,  138,  137},
  { 138,  139,  137},
  { 137,  139,  140},
  { 140,  139,  141},
  { 139,  142,  141},
  { 141,  142,  143},
  { 141,  143,  144},
  { 144,  143,  145},
  { 144,  145,  146},
  { 146,  145,  147},
  { 146,  147,  148},
  { 148,  147,  149},
  { 147,  150,  149},
  { 149,  150,  151},
  { 150,  152,  151},
  { 151,  152,  154},
  { 154,  152,  153},
  { 153,  155,  154},
  { 155,  156,  154},
  { 155,  157,  156},
  { 157,  158,  156},
  { 157,  111,  112},
  { 157,  112,  158},
  { 155,  153,  152},
  { 157,  155,  152},
  { 150,  147,  145},
  { 157,  152,  145},
  { 152,  150,  145},
  { 143,  142,  139},
  { 145,  143,  139},
  { 139,  138,  134},
  { 138,  136,  134},
  { 134,  132,  130},
  { 145,  139,  130},
  { 139,  134,  130},
  { 130,  128,  125},
  { 130,  125,  123},
  { 123,  121,  117},
  { 121,  119,  117},
  { 130,  123,  117},
  { 157,  145,  117},
  { 145,  130,  117},
  { 111,  157,  117},
  { 111,  117,  115},
  { 111,  115,  113},
  { 159,  161,  160},
  { 161,  162,  160},
  { 161,  163,  162},
  { 163,  164,  162},
  { 164,  163,  165},
  { 164,  165,  166},
  { 166,  165,  167},
  { 165,  168,  167},
  { 167,  168,  169},
  { 168,  170,  169},
  { 169,  170,  172},
  { 170,  171,  172},
  { 172,  171,  173},
  { 171,  174,  173},
  { 173,  174,  175},
  { 175,  174,  176},
  { 174,  177,  176},
  { 176,  177,  178},
  { 176,  178,  179},
  { 179,  178,  181},
  { 178,  180,  181},
  { 181,  180,  182},
  { 180,  183,  182},
  { 182,  183,  184},
  { 183,  185,  184},
  { 184,  185,  186},
  { 185,  187,  186},
  { 186,  187,  188},
  { 187,  189,  188},
  { 188,  189,  190},
  { 189,  191,  190},
  { 190,  191,  192},
  { 191,  193,  192},
  { 192,  193,  194},
  { 193,  195,  194},
  { 194,  195,  196},
  { 195,  197,  196},
  { 196,  197,  199},
  { 196,  199,  198},
  { 198,  199,  200},
  { 199,  201,  200},
  { 201,  202,  203},
  { 201,  203,  200},
  { 202,  205,  203},
  { 202,  204,  205},
  { 204,  159,  160},
  { 204,  160,  205},
  { 204,  202,  201},
  { 197,  195,  193},
  { 191,  189,  187},
  { 197,  193,  187},
  { 193,  191,  187},
  { 201,  199,  187},
  { 199,  197,  187},
  { 187,  185,  183},
  { 187,  183,  180},
  { 187,  180,  178},
  { 187,  178,  174},
  { 178,  177,  174},
  { 171,  170,  168},
  { 174,  171,  168},
  { 174,  168,  165},
  { 165,  163,  161},
  { 159,  204,  161},
  { 201,  187,  161},
  { 204,  201,  161},
  { 187,  174,  161},
  { 174,  165,  161},
  { 206,  207,  208},
  { 206,  249,  209},
  { 208,  207,  210},
  { 206,  209,  207},
  { 207,  213,  211},
  { 207,  211,  210},
  { 214,  215,  216},
  { 211,  213,  214},
  { 211,  214,  212},
  { 214,  217,  215},
  { 215,  218,  219},
  { 218,  217,  220},
  { 218,  220,  221},
  { 234,  222,  223},
  { 224,  225,  226},
  { 224,  226,  228},
  { 227,  224,  228},
  { 229,  227,  228},
  { 229,  228,  230},
  { 231,  229,  232},
  { 229,  230,  232},
  { 233,  231,  232},
  { 234,  233,  232},
  { 234,  232,  235},
  { 222,  234,  235},
  { 238,  239,  279},
  { 238,  279,  240},
  { 241,  286,  242},
  { 241,  242,  243},
  { 241,  243,  246},
  { 244,  245,  246},
  { 245,  241,  246},
  { 244,  246,  247},
  { 206,  244,  248},
  { 244,  247,  248},
  { 206,  248,  250},
  { 249,  206,  250},
  { 251,  249,  250},
  { 251,  250,  253},
  { 252,  251,  253},
  { 254,  252,  255},
  { 252,  253,  255},
  { 221,  254,  255},
  { 221,  255,  256},
  { 218,  221,  256},
  { 218,  256,  257},
  { 224,  218,  258},
  { 218,  257,  258},
  { 224,  258,  259},
  { 225,  224,  259},
  { 225,  259,  260},
  { 261,  225,  260},
  { 264,  261,  262},
  { 261,  260,  262},
  { 264,  262,  263},
  { 264,  263,  265},
  { 223,  264,  265},
  { 234,  223,  266},
  { 223,  265,  266},
  { 234,  266,  267},
  { 236,  234,  267},
  { 237,  236,  267},
  { 269,  236,  268},
  { 269,  268,  271},
  { 270,  269,  271},
  { 272,  270,  271},
  { 272,  271,  273},
  { 274,  275,  276},
  { 272,  273,  276},
  { 272,  276,  275},
  { 274,  276,  277},
  { 279,  239,  280},
  { 239,  278,  280},
  { 281,  279,  282},
  { 279,  280,  282},
  { 237,  281,  283},
  { 281,  282,  283},
  { 236,  237,  283},
  { 236,  283,  284},
  { 268,  236,  284},
  { 277,  278,  285},
  { 274,  277,  285},
  { 240,  242,  286},
  { 240,  286,  238},
  { 278,  239,  285},
  { 287,  219,  218},
  { 287,  288,  289},
  { 287,  289,  290},
  { 287,  290,  219},
  { 219,  216,  215},
  { 219,  290,  216},
  { 216,  212,  214},
  { 216,  290,  291},
  { 216,  291,  212},
  { 212,  210,  211},
  { 212,  291,  210},
  { 292,  208,  210},
  { 210,  291,  292},
  { 208,  292,  293},
  { 295,  307,  294},
  { 295,  294,  296},
  { 297,  295,  296},
  { 298,  297,  299},
  { 297,  296,  299},
  { 300,  298,  299},
  { 300,  299,  301},
  { 300,  301,  303},
  { 302,  300,  303},
  { 304,  302,  303},
  { 304,  303,  305},
  { 304,  305,  306},
  { 308,  205,  160},
  { 295,  308,  160},
  { 295,  160,  162},
  { 307,  295,  164},
  { 295,  162,  164},
  { 309,  307,  166},
  { 307,  164,  166},
  { 310,  309,  167},
  { 309,  166,  167},
  { 310,  167,  169},
  { 306,  310,  172},
  { 310,  169,  172},
  { 306,  172,  173},
  { 304,  306,  173},
  { 304,  173,  175},
  { 287,  304,  176},
  { 304,  175,  176},
  { 287,  176,  179},
  { 287,  179,  181},
  { 288,  287,  181},
  { 311,  288,  182},
  { 288,  181,  182},
  { 312,  311,  182},
  { 313,  312,  184},
  { 312,  182,  184},
  { 314,  313,  186},
  { 313,  184,  186},
  { 293,  314,  186},
  { 293,  186,  188},
  { 208,  293,  188},
  { 208,  188,  190},
  { 315,  328,  316},
  { 308,  315,  316},
  { 308,  316,  317},
  { 308,  317,  318},
  { 205,  308,  318},
  { 203,  205,  318},
  { 203,  318,  319},
  { 200,  203,  319},
  { 198,  200,  320},
  { 200,  319,  320},
  { 196,  198,  321},
  { 198,  320,  321},
  { 323,  321,  322},
  { 324,  272,  275},
  { 324,  323,  326},
  { 323,  322,  326},
  { 324,  326,  325},
  { 324,  325,  272},
  { 327,  325,  328},
  { 325,  326,  328},
  { 315,  327,  328},
  { 196,  321,  323},
  { 194,  196,  323},
  { 192,  194,  323},
  { 208,  190,  323},
  { 190,  192,  323},
  { 249,  314,  293},
  { 251,  314,  249},
  { 251,  313,  314},
  { 252,  312,  313},
  { 252,  313,  251},
  { 254,  312,  252},
  { 311,  312,  254},
  { 221,  288,  254},
  { 288,  311,  254},
  { 220,  289,  288},
  { 220,  288,  221},
  { 217,  290,  220},
  { 290,  289,  220},
  { 213,  291,  290},
  { 213,  290,  217},
  { 329,  292,  291},
  { 329,  291,  213},
  { 209,  292,  329},
  { 293,  292,  209},
  { 249,  293,  209},
  { 268,  316,  328},
  { 268,  328,  271},
  { 284,  316,  268},
  { 317,  316,  284},
  { 283,  318,  284},
  { 318,  317,  284},
  { 282,  318,  283},
  { 282,  319,  318},
  { 280,  319,  282},
  { 278,  320,  280},
  { 320,  319,  280},
  { 277,  321,  320},
  { 277,  320,  278},
  { 276,  322,  321},
  { 276,  321,  277},
  { 326,  322,  276},
  { 273,  326,  276},
  { 271,  328,  273},
  { 328,  326,  273},
  { 222,  294,  307},
  { 222,  307,  223},
  { 235,  296,  222},
  { 296,  294,  222},
  { 232,  296,  235},
  { 232,  299,  296},
  { 230,  301,  299},
  { 230,  299,  232},
  { 228,  303,  230},
  { 303,  301,  230},
  { 226,  305,  228},
  { 305,  303,  228},
  { 306,  305,  226},
  { 225,  306,  226},
  { 261,  310,  306},
  { 261,  306,  225},
  { 264,  310,  261},
  { 264,  309,  310},
  { 223,  307,  264},
  { 307,  309,  264},
  { 227,  302,  224},
  { 302,  304,  224},
  { 229,  300,  227},
  { 300,  302,  227},
  { 231,  298,  229},
  { 298,  300,  229},
  { 233,  297,  231},
  { 297,  298,  231},
  { 234,  295,  297},
  { 234,  297,  233},
  { 224,  304,  218},
  { 304,  287,  218},
  { 209,  329,  207},
  { 207,  329,  213},
  { 214,  213,  217},
  { 215,  217,  218},
  { 285,  206,  323},
  { 206,  208,  323},
  { 274,  285,  323},
  { 269,  315,  308},
  { 269,  308,  236},
  { 270,  327,  269},
  { 327,  315,  269},
  { 272,  325,  270},
  { 325,  327,  270},
  { 274,  323,  275},
  { 323,  324,  275},
  { 236,  308,  234},
  { 308,  295,  234},
  { 330,  331,  401},
  { 403,  408,  332},
  { 333,  403,  332},
  { 333,  332,  334},
  { 333,  334,  337},
  { 335,  333,  336},
  { 333,  337,  336},
  { 336,  337,  338},
  { 339,  336,  341},
  { 336,  338,  341},
  { 340,  339,  341},
  { 340,  341,  343},
  { 342,  340,  343},
  { 342,  343,  344},
  { 344,  343,  345},
  { 456,  346,  457},
  { 344,  349,  347},
  { 347,  349,  350},
  { 351,  352,  372},
  { 352,  351,  355},
  { 352,  355,  354},
  { 356,  354,  357},
  { 354,  355,  357},
  { 481,  358,  359},
  { 356,  357,  360},
  { 362,  360,  361},
  { 360,  357,  361},
  { 363,  362,  361},
  { 363,  361,  364},
  { 365,  363,  364},
  { 365,  364,  367},
  { 366,  365,  367},
  { 366,  367,  369},
  { 368,  366,  369},
  { 368,  369,  370},
  { 368,  370,  372},
  { 368,  371,  331},
  { 391,  374,  375},
  { 376,  377,  378},
  { 376,  379,  377},
  { 377,  379,  380},
  { 380,  381,  382},
  { 377,  380,  382},
  { 382,  381,  383},
  { 384,  382,  383},
  { 385,  386,  384},
  { 384,  383,  385},
  { 386,  385,  387},
  { 388,  390,  389},
  { 387,  388,  389},
  { 389,  390,  391},
  { 374,  391,  390},
  { 392,  429,  393},
  { 392,  395,  396},
  { 392,  396,  429},
  { 148,  149,  397},
  { 398,  445,  399},
  { 331,  400,  401},
  { 331,  373,  402},
  { 400,  403,  404},
  { 331,  402,  400},
  { 400,  402,  405},
  { 400,  405,  403},
  { 403,  405,  406},
  { 403,  406,  407},
  { 408,  403,  407},
  { 409,  408,  407},
  { 409,  407,  410},
  { 409,  410,  411},
  { 347,  412,  413},
  { 350,  409,  411},
  { 347,  411,  412},
  { 412,  411,  414},
  { 412,  414,  415},
  { 412,  415,  416},
  { 412,  376,  417},
  { 412,  416,  376},
  { 416,  418,  376},
  { 379,  376,  419},
  { 418,  420,  376},
  { 379,  419,  422},
  { 421,  379,  422},
  { 375,  421,  423},
  { 421,  422,  423},
  { 375,  423,  424},
  { 391,  375,  424},
  { 391,  392,  425},
  { 391,  426,  392},
  { 391,  424,  426},
  { 426,  427,  392},
  { 428,  392,  427},
  { 429,  434,  433},
  { 433,  434,  435},
  { 436,  432,  431},
  { 435,  437,  438},
  { 439,  438,  440},
  { 438,  437,  440},
  { 440,  437,  441},
  { 440,  441,  442},
  { 442,  441,  444},
  { 445,  398,  444},
  { 442,  444,  398},
  { 446,  445,  447},
  { 445,  444,  447},
  { 448,  446,  449},
  { 446,  447,  449},
  { 451,  448,  450},
  { 448,  449,  450},
  { 451,  450,  452},
  { 396,  451,  452},
  { 429,  396,  452},
  { 430,  429,  453},
  { 429,  452,  453},
  { 454,  401,  146},
  { 413,  348,  347},
  { 413,  455,  348},
  { 348,  455,  456},
  { 348,  344,  347},
  { 348,  456,  457},
  { 348,  457,  344},
  { 457,  342,  344},
  { 457,  346,  459},
  { 457,  459,  458},
  { 457,  458,  342},
  { 460,  458,  459},
  { 462,  460,  461},
  { 460,  459,  461},
  { 463,  462,  461},
  { 463,  461,  464},
  { 465,  335,  463},
  { 463,  464,  465},
  { 466,  335,  467},
  { 335,  465,  467},
  { 466,  467,  500},
  { 468,  352,  354},
  { 468,  353,  470},
  { 468,  470,  352},
  { 470,  371,  352},
  { 470,  353,  469},
  { 470,  454,  371},
  { 470,  471,  454},
  { 330,  454,  471},
  { 330,  471,  472},
  { 330,  472,  473},
  { 330,  473,  475},
  { 330,  474,  366},
  { 330,  475,  474},
  { 475,  476,  474},
  { 477,  474,  476},
  { 478,  477,  479},
  { 477,  476,  479},
  { 480,  478,  481},
  { 478,  479,  481},
  { 482,  480,  481},
  { 482,  356,  360},
  { 468,  359,  358},
  { 482,  481,  359},
  { 482,  359,  356},
  { 468,  358,  353},
  { 484,  483,  485},
  { 484,  389,  391},
  { 484,  485,  486},
  { 484,  486,  389},
  { 486,  387,  389},
  { 486,  487,  488},
  { 486,  488,  387},
  { 488,  386,  387},
  { 488,  490,  489},
  { 488,  489,  386},
  { 489,  384,  386},
  { 489,  491,  384},
  { 492,  491,  493},
  { 491,  490,  493},
  { 492,  493,  495},
  { 492,  377,  382},
  { 492,  495,  494},
  { 492,  494,  377},
  { 494,  378,  377},
  { 494,  495,  496},
  { 494,  496,  378},
  { 483,  484,  497},
  { 393,  158,  112},
  { 393,  425,  392},
  { 112,  114,  425},
  { 393,  112,  425},
  { 425,  114,  116},
  { 484,  425,  118},
  { 425,  116,  118},
  { 497,  484,  118},
  { 497,  118,  120},
  { 498,  497,  122},
  { 497,  120,  122},
  { 496,  498,  122},
  { 496,  122,  124},
  { 378,  417,  376},
  { 378,  496,  124},
  { 124,  126,  417},
  { 378,  124,  417},
  { 417,  126,  127},
  { 417,  413,  412},
  { 417,  127,  129},
  { 417,  129,  413},
  { 129,  131,  413},
  { 131,  133,  413},
  { 499,  455,  135},
  { 455,  413,  135},
  { 413,  133,  135},
  { 500,  499,  137},
  { 499,  135,  137},
  { 466,  500,  137},
  { 466,  137,  140},
  { 466,  140,  404},
  { 466,  404,  403},
  { 404,  401,  400},
  { 404,  141,  401},
  { 401,  141,  144},
  { 401,  144,  146},
  { 454,  398,  371},
  { 454,  397,  398},
  { 146,  148,  397},
  { 454,  146,  397},
  { 158,  394,  501},
  { 509,  429,  433},
  { 158,  393,  394},
  { 509,  502,  394},
  { 509,  394,  429},
  { 394,  502,  501},
  { 393,  429,  394},
  { 156,  158,  501},
  { 154,  156,  503},
  { 156,  501,  503},
  { 154,  503,  504},
  { 151,  154,  504},
  { 151,  504,  505},
  { 149,  151,  443},
  { 151,  505,  443},
  { 397,  442,  398},
  { 397,  149,  443},
  { 397,  443,  506},
  { 397,  506,  442},
  { 506,  440,  442},
  { 506,  443,  507},
  { 506,  436,  508},
  { 506,  508,  440},
  { 436,  439,  508},
  { 439,  431,  438},
  { 431,  509,  435},
  { 439,  436,  431},
  { 431,  435,  438},
  { 431,  432,  509},
  { 509,  433,  435},
  { 502,  509,  432},
  { 355,  353,  358},
  { 355,  358,  357},
  { 351,  469,  353},
  { 351,  353,  355},
  { 372,  471,  469},
  { 372,  469,  351},
  { 472,  471,  372},
  { 370,  473,  372},
  { 473,  472,  372},
  { 369,  475,  370},
  { 475,  473,  370},
  { 369,  476,  475},
  { 367,  476,  369},
  { 364,  479,  367},
  { 479,  476,  367},
  { 361,  481,  479},
  { 361,  479,  364},
  { 357,  481,  361},
  { 357,  358,  481},
  { 502,  432,  434},
  { 430,  502,  434},
  { 501,  502,  430},
  { 453,  501,  430},
  { 452,  501,  453},
  { 450,  503,  452},
  { 503,  501,  452},
  { 449,  504,  503},
  { 449,  503,  450},
  { 447,  505,  504},
  { 447,  504,  449},
  { 444,  443,  505},
  { 444,  505,  447},
  { 441,  507,  443},
  { 441,  443,  444},
  { 436,  507,  441},
  { 437,  436,  441},
  { 434,  432,  436},
  { 434,  436,  437},
  { 409,  499,  408},
  { 499,  500,  408},
  { 350,  455,  499},
  { 350,  499,  409},
  { 349,  456,  455},
  { 349,  455,  350},
  { 345,  346,  456},
  { 345,  456,  349},
  { 343,  459,  345},
  { 459,  346,  345},
  { 341,  461,  343},
  { 461,  459,  343},
  { 338,  464,  461},
  { 338,  461,  341},
  { 337,  465,  338},
  { 465,  464,  338},
  { 334,  465,  337},
  { 332,  467,  465},
  { 332,  465,  334},
  { 408,  500,  332},
  { 500,  467,  332},
  { 375,  483,  497},
  { 374,  483,  375},
  { 374,  485,  483},
  { 390,  485,  374},
  { 388,  487,  485},
  { 388,  485,  390},
  { 385,  490,  487},
  { 385,  487,  388},
  { 383,  493,  385},
  { 493,  490,  385},
  { 381,  495,  383},
  { 495,  493,  383},
  { 380,  495,  381},
  { 379,  496,  495},
  { 379,  495,  380},
  { 421,  498,  379},
  { 498,  496,  379},
  { 375,  497,  498},
  { 375,  498,  421},
  { 425,  484,  391},
  { 384,  491,  382},
  { 491,  492,  382},
  { 489,  490,  491},
  { 488,  487,  490},
  { 385,  388,  387},
  { 486,  485,  487},
  { 420,  419,  376},
  { 344,  345,  349},
  { 347,  350,  411},
  { 335,  336,  463},
  { 339,  462,  463},
  { 339,  463,  336},
  { 340,  460,  462},
  { 340,  462,  339},
  { 342,  458,  460},
  { 342,  460,  340},
  { 333,  335,  403},
  { 335,  466,  403},
  { 454,  330,  401},
  { 330,  368,  331},
  { 140,  141,  404},
  { 368,  330,  366},
  { 356,  359,  354},
  { 359,  468,  354},
  { 362,  480,  482},
  { 362,  482,  360},
  { 363,  478,  362},
  { 478,  480,  362},
  { 365,  477,  363},
  { 477,  478,  363},
  { 366,  474,  365},
  { 474,  477,  365},
  { 398,  373,  331},
  { 398,  331,  371},
  { 470,  469,  471},
  { 352,  371,  372},
  { 368,  372,  371},
  { 398,  399,  373},
  { 429,  430,  434},
  { 435,  434,  437},
  { 439,  440,  508},
  { 506,  507,  436},
  { 392,  428,  395},
  { 510,  511,  512},
  { 510,  512,  513},
  { 510,  513,  514},
  { 515,  510,  516},
  { 510,  514,  516},
  { 517,  528,  518},
  { 519,  520,  521},
  { 522,  523,  525},
  { 525,  524,  522},
  { 521,  535,  519},
  { 526,  527,  517},
  { 518,  526,  517},
  { 529,  528,  517},
  { 527,  526,  530},
  { 531,  527,  530},
  { 532,  533,  534},
  { 533,  535,  534},
  { 533,  532,  522},
  { 532,  523,  522},
  { 535,  533,  519},
  { 531,  520,  519},
  { 527,  531,  519},
  { 536,  546,  537},
  { 538,  539,  540},
  { 541,  547,  542},
  { 543,  544,  545},
  { 543,  545,  536},
  { 537,  543,  536},
  { 524,  546,  536},
  { 547,  529,  542},
  { 548,  549,  550},
  { 538,  540,  550},
  { 540,  548,  550},
  { 544,  539,  538},
  { 545,  544,  538},
  { 550,  549,  542},
  { 549,  541,  542},
  { 515,  522,  510},
  { 522,  524,  510},
  { 516,  522,  515},
  { 516,  533,  522},
  { 516,  519,  533},
  { 514,  517,  516},
  { 527,  519,  516},
  { 517,  527,  516},
  { 529,  517,  514},
  { 513,  529,  514},
  { 513,  542,  529},
  { 512,  538,  513},
  { 538,  550,  513},
  { 550,  542,  513},
  { 511,  538,  512},
  { 511,  545,  538},
  { 511,  536,  545},
  { 510,  524,  536},
  { 510,  536,  511},
  { 551,  553,  552},
  { 546,  524,  552},
  { 537,  546,  552},
  { 552,  554,  537},
  { 553,  555,  552},
  { 555,  556,  557},
  { 555,  557,  558},
  { 555,  558,  559},
  { 555,  559,  560},
  { 555,  560,  561},
  { 561,  562,  552},
  { 555,  561,  552},
  { 562,  554,  552},
  { 563,  543,  537},
  { 564,  565,  936},
  { 564,  554,  565},
  { 554,  564,  537},
  { 543,  563,  566},
  { 567,  562,  561},
  { 544,  543,  569},
  { 543,  566,  569},
  { 570,  567,  571},
  { 568,  572,  561},
  { 571,  573,  964},
  { 567,  574,  571},
  { 544,  569,  575},
  { 572,  576,  561},
  { 568,  577,  572},
  { 577,  579,  572},
  { 539,  544,  578},
  { 544,  575,  578},
  { 576,  582,  581},
  { 539,  578,  583},
  { 580,  572,  579},
  {1534,  580,  579},
  { 580,  585,  572},
  { 585,  582,  572},
  { 540,  539,  583},
  { 540,  583,  548},
  { 584,  580,  586},
  { 587,  588,  585},
  { 587,  584,  586},
  { 548,  589,  549},
  { 590,  937,  966},
  { 588,  590,  966},
  { 591,  588,  592},
  { 588,  587,  592},
  { 595,  549,  593},
  { 594,  597,  590},
  { 594,  590,  591},
  { 600,  549,  595},
  { 596,  603,  597},
  { 596,  597,  598},
  { 597,  594,  598},
  { 541,  549,  600},
  { 600,  599,  609},
  { 541,  600,  609},
  { 603,  596,  599},
  { 596,  601,  599},
  { 601,  602,  599},
  { 602,  604,  609},
  { 604,  605,  609},
  { 602,  609,  599},
  { 547,  541,  609},
  { 605,  606,  609},
  { 606,  607,  609},
  { 607,  608,  609},
  { 608,  610,  609},
  { 529,  547,  609},
  { 610,  611,  609},
  { 611,  612,  609},
  { 528,  529,  609},
  { 612,  613,  614},
  { 528,  612,  614},
  { 528,  609,  612},
  { 528,  614,  615},
  { 616,  617, 1125},
  { 528,  615,  518},
  { 526,  518,  615},
  { 526,  615,  618},
  { 526,  618,  619},
  { 530,  526,  619},
  { 531,  530,  619},
  { 531,  619,  620},
  { 520,  531,  620},
  { 521,  520,  620},
  { 521,  620,  621},
  { 535,  521,  621},
  { 535,  621,  622},
  { 535,  622,  623},
  { 532,  534,  623},
  { 534,  535,  623},
  { 532,  623,  624},
  { 523,  532,  624},
  { 525,  523,  624},
  { 525,  624,  625},
  { 625, 1180,  525},
  { 524,  525, 1180},
  { 551,  524, 1180},
  { 524,  551,  552},
  { 626,  556,  555},
  { 627,  626,  555},
  { 627,  555,  553},
  { 551,  627,  553},
  { 628,  629,  630},
  { 628,  631,  629},
  { 629,  632,  633},
  { 632,  631,  634},
  { 629,  631,  632},
  { 635,  632,  634},
  { 636,  637,  635},
  { 237,  638,  637},
  { 237,  267,  638},
  { 638,  639,  640},
  { 638,  267,  639},
  { 639,  266,  641},
  { 642,  641,  266},
  { 643,  642,  265},
  { 263,  643,  265},
  { 260,  259,  643},
  { 645,  250,  646},
  { 646,  647,  648},
  { 646,  649,  647},
  { 647,  650,  648},
  { 647,  246,  628},
  { 647,  628,  650},
  { 628,  630,  650},
  { 633,  630,  629},
  { 651,  633,  632},
  { 651,  632,  635},
  { 652,  651,  635},
  { 637,  652,  635},
  { 652,  654,  653},
  { 653,  655,  656},
  { 638,  654,  637},
  { 654,  640,  655},
  { 639,  672,  657},
  { 645,  648,  658},
  { 649,  250,  248},
  { 246,  649,  247},
  { 630,  659,  650},
  { 630,  660,  659},
  { 660,  630,  633},
  { 660,  662,  661},
  { 662,  633,  651},
  { 653,  662,  652},
  { 662,  651,  652},
  { 663,  656,  664},
  { 652,  637,  654},
  { 655,  639,  657},
  { 654,  638,  640},
  { 658,  666,  645},
  { 645,  646,  648},
  { 658,  659,  667},
  { 658,  648,  659},
  { 659,  668,  669},
  { 660,  670,  668},
  { 660,  668,  659},
  { 661,  670,  660},
  { 660,  633,  662},
  { 661,  663,  671},
  { 663,  662,  653},
  { 653,  654,  655},
  { 655,  657,  656},
  { 655,  640,  639},
  { 672,  639,  641},
  { 673,  672,  665},
  { 641,  643,  665},
  { 641,  642,  643},
  { 682,  665,  643},
  { 694,  684,  256},
  { 253,  250,  645},
  { 645,  666,  674},
  { 658,  667,  686},
  { 669,  667,  659},
  { 648,  650,  659},
  { 668,  675,  669},
  { 676,  675,  670},
  { 675,  668,  670},
  { 676,  671,  677},
  { 676,  661,  671},
  { 676,  670,  661},
  { 671,  664,  678},
  { 661,  662,  663},
  { 663,  653,  656},
  { 664,  680,  679},
  { 664,  657,  680},
  { 680,  673,  681},
  { 680,  672,  673},
  { 673,  665,  690},
  { 683,  682,  643},
  { 644,  643,  259},
  { 684,  257,  256},
  { 674,  256,  255},
  { 675,  667,  669},
  { 687,  675,  676},
  { 687,  677,  699},
  { 677,  688,  699},
  { 677,  678,  689},
  { 671,  663,  664},
  { 664,  679,  678},
  { 679,  681,  703},
  { 664,  656,  657},
  { 680,  657,  672},
  { 690,  681,  673},
  { 672,  641,  665},
  { 690,  692,  691},
  { 692,  682,  683},
  { 693,  643,  644},
  { 674,  694,  256},
  { 685,  686,  696},
  { 658,  686,  685},
  { 686,  697,  713},
  { 697,  667,  675},
  { 698,  699,  700},
  { 687,  697,  675},
  { 698,  687,  699},
  { 687,  676,  677},
  { 688,  689,  701},
  { 677,  671,  678},
  { 702,  689,  678},
  { 679,  702,  678},
  { 679,  703,  702},
  { 679,  680,  681},
  { 681,  704,  703},
  { 704,  681,  690},
  { 704,  690,  691},
  { 682,  690,  665},
  { 684,  644,  258},
  { 684,  258,  257},
  { 695,  743,  674},
  { 685,  674,  666},
  { 685,  695,  674},
  { 695,  696,  705},
  { 685,  666,  658},
  { 696,  713,  705},
  { 686,  713,  696},
  { 686,  667,  697},
  { 687,  698,  697},
  { 698,  713,  697},
  { 706,  700,  699},
  { 706,  699,  688},
  { 701,  706,  688},
  { 688,  677,  689},
  { 707,  708,  709},
  { 707,  702,  708},
  { 707,  689,  702},
  { 709,  710,  711},
  { 703,  708,  702},
  { 708,  712,  710},
  { 691,  712,  704},
  { 704,  712,  703},
  { 682,  692,  690},
  { 725,  644,  684},
  { 694,  674,  743},
  { 695,  705,  732},
  { 695,  685,  696},
  { 700,  715,  698},
  { 715,  713,  698},
  { 716,  717,  718},
  { 716,  700,  717},
  { 717,  719,  720},
  { 717,  706,  719},
  { 717,  700,  706},
  { 719,  721,  722},
  { 719,  706,  701},
  { 707,  721,  701},
  { 707,  701,  689},
  { 709,  721,  707},
  { 708,  703,  712},
  { 712,  723,  710},
  { 712,  691,  724},
  { 743,  695,  726},
  { 732,  705,  714},
  { 713,  716,  727},
  { 716,  715,  700},
  { 716,  718,  727},
  { 717,  720,  718},
  { 720,  722,  728},
  { 719,  701,  721},
  { 721,  729,  722},
  { 711,  729,  709},
  { 729,  721,  709},
  { 711,  723,  738},
  { 709,  708,  710},
  { 712,  724,  723},
  { 691,  723,  724},
  { 691,  692,  730},
  { 732,  714,  733},
  { 705,  713,  714},
  { 714,  727,  734},
  { 714,  713,  727},
  { 713,  715,  716},
  { 718,  736,  735},
  { 718,  735,  727},
  { 728,  736,  720},
  { 720,  736,  718},
  { 737,  728,  722},
  { 720,  719,  722},
  { 729,  737,  722},
  { 737,  738,  739},
  { 737,  711,  738},
  { 737,  729,  711},
  { 711,  710,  723},
  { 723,  740,  741},
  { 723,  691,  740},
  { 740,  730,  742},
  { 740,  691,  730},
  { 683,  643,  693},
  { 683,  693,  731},
  { 693,  644,  725},
  { 725,  731,  693},
  { 726,  695,  732},
  { 733,  734,  744},
  { 733,  714,  734},
  { 735,  734,  727},
  { 735,  745,  746},
  { 745,  735,  736},
  { 745,  747,  748},
  { 745,  736,  747},
  { 747,  749,  750},
  { 728,  737,  749},
  { 747,  728,  749},
  { 751,  749,  737},
  { 751,  752,  750},
  { 751,  739,  752},
  { 739,  753,  752},
  { 739,  738,  754},
  { 739,  754,  753},
  { 754,  738,  723},
  { 754,  741,  755},
  { 733,  726,  732},
  { 746,  758,  744},
  { 746,  734,  735},
  { 745,  748,  758},
  { 745,  758,  746},
  { 736,  728,  747},
  { 750,  748,  747},
  { 750,  749,  751},
  { 751,  737,  739},
  { 755,  753,  754},
  { 742,  755,  741},
  { 754,  723,  741},
  { 741,  740,  742},
  { 742,  730,  692},
  { 759,  725,  684},
  { 760,  759,  684},
  { 694,  743,  760},
  { 694,  760,  684},
  { 757,  743,  726},
  { 756,  757,  726},
  { 733,  756,  726},
  { 756,  733,  744},
  { 744,  734,  746},
  { 774,  771,  758},
  { 774,  758,  748},
  { 774,  748,  750},
  { 761,  774,  750},
  { 761,  750,  752},
  { 762,  761,  753},
  { 761,  752,  753},
  { 762,  753,  755},
  { 763,  762,  755},
  { 763,  755,  742},
  { 764,  763,  742},
  { 765,  764,  742},
  { 765,  742,  692},
  { 785,  765,  692},
  { 785,  692,  683},
  { 766,  785,  683},
  { 766,  683,  731},
  { 766,  768,  767},
  { 768,  731,  725},
  { 768,  725,  759},
  { 820,  768,  759},
  { 820,  759,  760},
  { 820,  760,  743},
  { 769,  820,  743},
  { 769,  743,  757},
  { 769,  757,  756},
  { 770,  769,  756},
  { 770,  756,  744},
  { 771,  770,  744},
  { 771,  744,  758},
  { 771,  774,  772},
  { 775,  776,  777},
  { 775,  761,  776},
  { 776,  778,  777},
  { 776,  761,  762},
  { 776,  779,  778},
  { 779,  762,  763},
  { 779,  780,  781},
  { 763,  764,  780},
  { 779,  763,  780},
  { 782,  780,  764},
  { 782,  783,  784},
  { 782,  765,  783},
  { 782,  764,  765},
  { 783,  765,  785},
  { 785,  786,  787},
  { 785,  767,  786},
  { 785,  766,  767},
  { 766,  731,  768},
  { 767,  768,  788},
  { 788,  820,  798},
  { 774,  777,  791},
  { 774,  761,  775},
  { 776,  762,  779},
  { 778,  781,  792},
  { 778,  779,  781},
  { 792,  781,  793},
  { 781,  794,  793},
  { 794,  784,  795},
  { 794,  780,  782},
  { 784,  785,  796},
  { 784,  783,  785},
  { 788,  797,  767},
  { 788,  768,  820},
  { 833,  770,  799},
  { 772,  774,  790},
  { 772,  790,  800},
  { 801,  790,  774},
  { 801,  791,  808},
  { 774,  775,  777},
  { 808,  791,  802},
  { 791,  778,  802},
  { 802,  778,  803},
  { 778,  792,  803},
  { 793,  795,  804},
  { 781,  780,  794},
  { 793,  794,  795},
  { 794,  782,  784},
  { 796,  795,  784},
  { 796,  787,  805},
  { 786,  797,  787},
  { 786,  767,  797},
  { 797,  788,  806},
  { 769,  789,  821},
  { 770,  771,  772},
  { 834,  800,  808},
  { 790,  801,  800},
  { 800,  801,  808},
  { 801,  774,  791},
  { 808,  809,  810},
  { 808,  802,  809},
  { 791,  777,  778},
  { 811,  812,  813},
  { 814,  792,  793},
  { 803,  792,  814},
  { 814,  815,  812},
  { 814,  804,  815},
  { 816,  804,  795},
  { 816,  805,  817},
  { 816,  796,  805},
  { 816,  795,  796},
  { 796,  785,  787},
  { 787,  818,  805},
  { 797,  818,  787},
  { 818,  806,  819},
  { 788,  798,  806},
  { 832,  831,  821},
  { 821,  820,  769},
  { 833,  789,  770},
  { 789,  769,  770},
  { 799,  770,  823},
  { 823,  772,  773},
  { 823,  770,  772},
  { 800,  773,  772},
  { 808,  810,  824},
  { 811,  802,  803},
  { 809,  811,  825},
  { 825,  811,  813},
  { 812,  803,  814},
  { 815,  826,  827},
  { 814,  793,  804},
  { 826,  817,  828},
  { 826,  804,  816},
  { 829,  817,  805},
  { 818,  829,  805},
  { 819,  807,  830},
  { 818,  797,  806},
  { 820,  831,  807},
  { 798,  807,  806},
  { 789,  833,  821},
  { 822,  833,  799},
  { 773,  800,  834},
  { 844,  773,  834},
  { 808,  824,  834},
  { 824,  825,  835},
  { 810,  809,  825},
  { 824,  810,  825},
  { 809,  802,  811},
  { 811,  803,  812},
  { 837,  813,  812},
  { 837,  827,  838},
  { 837,  815,  827},
  { 837,  812,  815},
  { 815,  804,  826},
  { 828,  827,  826},
  { 826,  816,  817},
  { 839,  828,  817},
  { 839,  817,  829},
  { 839,  840,  851},
  { 839,  841,  840},
  { 819,  841,  829},
  { 819,  829,  818},
  { 841,  819,  830},
  { 841,  830,  842},
  { 819,  806,  807},
  { 798,  820,  807},
  { 822,  799,  823},
  { 824,  845,  834},
  { 824,  835,  845},
  { 835,  836,  846},
  { 836,  813,  847},
  { 836,  825,  813},
  { 847,  813,  837},
  { 838,  847,  837},
  { 838,  848,  849},
  { 848,  850,  849},
  { 848,  827,  828},
  { 848,  851,  850},
  { 851,  828,  839},
  { 839,  829,  841},
  { 840,  841,  842},
  { 842,  852,  853},
  { 852,  830,  807},
  { 821,  831,  820},
  { 843,  821,  833},
  { 823,  773,  844},
  { 855,  845,  856},
  { 855,  844,  845},
  { 844,  834,  845},
  { 835,  857,  845},
  { 846,  857,  835},
  { 835,  825,  836},
  { 858,  836,  847},
  { 858,  859,  870},
  { 859,  849,  860},
  { 859,  847,  838},
  { 849,  871,  860},
  { 838,  827,  848},
  { 848,  828,  851},
  { 861,  850,  851},
  { 861,  851,  840},
  { 862,  840,  842},
  { 862,  861,  840},
  { 862,  853,  863},
  { 842,  830,  852},
  { 852,  807,  831},
  { 864,  877,  831},
  { 831,  865,  866},
  { 831,  832,  865},
  { 845,  857,  867},
  { 867,  868,  869},
  { 858,  868,  846},
  { 858,  846,  836},
  { 858,  847,  859},
  { 859,  860,  870},
  { 859,  838,  849},
  { 871,  849,  850},
  { 871,  872,  883},
  { 871,  850,  872},
  { 872,  873,  883},
  { 872,  850,  861},
  { 872,  874,  873},
  { 874,  863,  875},
  { 874,  861,  862},
  { 874,  862,  863},
  { 862,  842,  853},
  { 853,  854,  863},
  { 877,  852,  831},
  { 877,  876,  853},
  { 877,  853,  852},
  { 878,  831,  866},
  { 878,  864,  831},
  { 843,  832,  821},
  { 822,  879,  833},
  { 822,  823,  879},
  { 844,  879,  823},
  { 844,  855,  879},
  { 856,  845,  880},
  { 881,  867,  869},
  { 867,  857,  846},
  { 867,  846,  868},
  { 870,  869,  868},
  { 870,  868,  858},
  { 870,  882,  869},
  { 860,  882,  870},
  { 882,  883,  884},
  { 882,  860,  871},
  { 882,  871,  883},
  { 872,  861,  874},
  { 873,  875,  885},
  { 875,  863,  886},
  { 854,  894,  863},
  { 876,  854,  853},
  { 832,  887,  865},
  { 887,  832,  888},
  { 880,  845,  867},
  { 880,  867,  881},
  { 882,  890,  869},
  { 882,  891,  890},
  { 884,  891,  882},
  { 892,  885,  893},
  { 892,  883,  885},
  { 883,  873,  885},
  { 873,  874,  875},
  { 905,  885,  875},
  { 905,  875,  886},
  { 863,  894,  886},
  { 879,  843,  833},
  { 856,  929,  879},
  { 895,  856,  880},
  { 895,  896,  921},
  { 881,  897,  880},
  { 890,  897,  881},
  { 890,  881,  869},
  { 891,  898,  890},
  { 898,  900,  899},
  { 900,  891,  884},
  { 900,  901,  902},
  { 900,  884,  901},
  { 892,  901,  884},
  { 901,  893,  903},
  { 892,  884,  883},
  { 901,  892,  893},
  { 893,  905,  904},
  { 843,  888,  832},
  { 888,  843,  919},
  { 843,  879,  889},
  { 928,  913,  929},
  { 879,  855,  856},
  { 895,  880,  896},
  { 921,  896,  906},
  { 906,  907,  921},
  { 897,  906,  896},
  { 897,  896,  880},
  { 906,  908,  909},
  { 908,  914,  909},
  { 906,  897,  908},
  { 898,  908,  897},
  { 898,  897,  890},
  { 899,  902,  910},
  { 898,  891,  900},
  { 899,  900,  902},
  { 902,  911,  910},
  { 902,  903,  911},
  { 902,  901,  903},
  { 893,  904,  903},
  { 893,  885,  905},
  { 912,  919,  889},
  { 843,  889,  919},
  { 889,  913,  912},
  { 879,  913,  889},
  { 899,  914,  908},
  { 932,  915,  916},
  { 899,  908,  898},
  { 914,  910,  915},
  { 917,  911,  903},
  { 904,  917,  903},
  { 879,  929,  913},
  { 929,  856,  920},
  { 921,  856,  895},
  { 931,  921,  907},
  { 907,  906,  909},
  { 909,  932,  907},
  { 932,  909,  914},
  { 914,  899,  910},
  { 915,  924,  925},
  { 910,  911,  924},
  { 915,  910,  924},
  { 924,  926,  927},
  { 924,  911,  926},
  { 926,  911,  917},
  { 935,  926,  917},
  { 935,  917,  904},
  { 937,  918,  938},
  { 919,  912,  918},
  { 920,  856,  921},
  { 930,  947,  920},
  { 931,  932,  922},
  { 931,  907,  932},
  { 932,  916,  923},
  { 932,  914,  915},
  { 925,  927,  943},
  { 927,  933,  943},
  { 927,  935,  934},
  { 931,  920,  921},
  { 930,  922,  940},
  { 922,  923,  941},
  { 922,  932,  923},
  { 942,  923,  916},
  { 925,  942,  916},
  { 942,  943,  944},
  { 925,  916,  915},
  { 925,  924,  927},
  { 934,  933,  927},
  { 927,  926,  935},
  { 934,  936,  945},
  { 938,  918,  912},
  { 912,  913,  928},
  { 928,  929,  946},
  { 920,  939,  929},
  { 946,  929,  939},
  { 931,  930,  920},
  { 940,  956,  947},
  { 930,  931,  922},
  { 922,  941,  940},
  { 941,  948,  949},
  { 948,  944,  950},
  { 948,  923,  942},
  { 944,  958,  950},
  { 942,  925,  943},
  { 951,  952,  960},
  { 951,  943,  933},
  { 933,  934,  952},
  { 951,  933,  952},
  { 945,  952,  934},
  { 934,  935,  936},
  { 936,  953,  945},
  { 953,  936,  565},
  { 570,  953,  954},
  { 938,  912,  928},
  { 947,  930,  940},
  { 956,  949,  957},
  { 941,  956,  940},
  { 956,  941,  949},
  { 941,  923,  948},
  { 948,  950,  949},
  { 948,  942,  944},
  { 951,  958,  944},
  { 958,  960,  973},
  { 951,  944,  943},
  { 960,  959,  973},
  { 960,  961,  962},
  { 960,  945,  961},
  { 960,  952,  945},
  { 953,  961,  945},
  { 953,  565,  954},
  { 576,  573,  574},
  { 573,  581,  964},
  { 967,  966,  965},
  { 937,  965,  966},
  { 937,  938,  965},
  { 928,  955,  938},
  { 920,  947,  939},
  { 969,  947,  956},
  { 969,  956,  957},
  { 970,  969,  971},
  { 950,  972,  949},
  { 972,  973,  974},
  { 972,  958,  973},
  { 972,  950,  958},
  { 958,  951,  960},
  { 959,  962,  975},
  { 962,  976,  977},
  { 962,  961,  976},
  { 976,  979,  978},
  { 976,  953,  979},
  { 979,  964,  963},
  { 979,  953,  964},
  { 964,  581,  967},
  { 965,  938,  955},
  { 980,  939,  947},
  { 980,  946,  939},
  { 969,  957,  971},
  { 971,  983,  984},
  { 949,  971,  957},
  { 971,  949,  983},
  { 983,  974,  985},
  { 974,  986,  987},
  { 974,  973,  986},
  { 986,  975,  988},
  { 986,  973,  959},
  { 959,  960,  962},
  { 962,  977,  975},
  { 976,  978,  977},
  { 976,  961,  953},
  { 978,  963,  989},
  { 953,  571,  964},
  { 990,  963,  967},
  { 955,  928,  946},
  { 968,  980,  992},
  { 980,  947,  992},
  { 981,  947,  969},
  { 992,  947,  981},
  { 981,  982,  993},
  { 969,  970,  982},
  { 971,  984,  970},
  { 949,  972,  983},
  { 983,  985,  984},
  { 983,  972,  974},
  { 974,  987,  985},
  { 986,  988,  987},
  { 986,  959,  975},
  { 975,  994,  988},
  { 977,  994,  975},
  { 977,  995,  994},
  { 978,  995,  977},
  { 995,  989,  996},
  { 995,  978,  989},
  { 978,  979,  963},
  { 963,  964,  967},
  { 997, 1049,  965},
  { 980,  968,  946},
  { 981,  969,  982},
  { 998,  993,  982},
  { 970,  998,  982},
  { 998, 1000,  999},
  { 999, 1001, 1002},
  { 984, 1000,  970},
  {1000, 1003, 1001},
  {1001, 1016, 1004},
  { 985, 1003,  984},
  {1003, 1005, 1016},
  {1006, 1005,  987},
  { 987, 1005,  985},
  {1006, 1007, 1008},
  { 988, 1006,  987},
  {1007, 1009, 1010},
  { 994, 1007,  988},
  { 995, 1009,  994},
  {1009,  996, 1017},
  {1009,  995,  996},
  { 996,  990, 1011},
  { 990,  989,  963},
  { 990,  967, 1018},
  { 955,  946,  991},
  { 991,  968, 1034},
  { 968,  991,  946},
  {1012,  992,  993},
  { 992,  981,  993},
  {1012,  993,  998},
  {1012,  998, 1013},
  { 998, 1002, 1014},
  { 998,  970, 1000},
  {1002, 1004, 1015},
  {1000,  984, 1003},
  {1003,  985, 1005},
  {1016, 1005, 1006},
  {1008, 1016, 1006},
  {1006,  988, 1007},
  {1007, 1010, 1008},
  {1007,  994, 1009},
  {1009, 1017, 1010},
  { 996, 1011, 1017},
  { 996,  989,  990},
  { 990, 1032, 1011},
  {1032,  990, 1018},
  {1018,  967,  965},
  { 991,  965,  955},
  {1034,  968,  992},
  {1012, 1034,  992},
  {1021, 1013,  998},
  {1021, 1014, 1022},
  {1014, 1015, 1023},
  { 999, 1000, 1001},
  {1001, 1003, 1016},
  {1024, 1004, 1016},
  {1025, 1026, 1027},
  {1024, 1028, 1026},
  {1028, 1016, 1008},
  {1029, 1028, 1008},
  {1010, 1029, 1008},
  {1010, 1030, 1029},
  {1017, 1030, 1010},
  {1017, 1031, 1030},
  {1011, 1031, 1017},
  {1011, 1032, 1031},
  {1019,  997,  965},
  {1012, 1013, 1034},
  {1013, 1035, 1034},
  {1035, 1013, 1021},
  {1035, 1021, 1037},
  {1022, 1023, 1038},
  { 998,  999, 1002},
  {1015, 1025, 1039},
  {1002, 1001, 1004},
  {1015, 1004, 1025},
  {1039, 1027, 1066},
  {1025, 1004, 1024},
  {1024, 1016, 1028},
  {1028, 1040, 1026},
  {1040, 1028, 1029},
  {1040, 1041, 1042},
  {1040, 1029, 1041},
  {1030, 1041, 1029},
  {1030, 1043, 1041},
  {1031, 1043, 1030},
  {1043, 1044, 1045},
  {1043, 1046, 1044},
  {1043, 1031, 1046},
  {1032, 1046, 1031},
  {1032, 1047, 1046},
  {1047, 1032, 1018},
  {1049, 1048, 1018},
  { 965,  991, 1020},
  {1035, 1036, 1034},
  {1033, 1034, 1036},
  {1051, 1037, 1021},
  {1051, 1038, 1052},
  {1021,  998, 1014},
  {1038, 1053, 1054},
  {1014, 1002, 1015},
  {1023, 1015, 1039},
  {1023, 1039, 1053},
  {1053, 1066, 1055},
  {1056, 1027, 1026},
  {1025, 1024, 1026},
  {1040, 1056, 1026},
  {1040, 1042, 1056},
  {1042, 1057, 1058},
  {1042, 1041, 1057},
  {1043, 1057, 1041},
  {1043, 1045, 1057},
  {1045, 1044, 1068},
  {1044, 1047, 1059},
  {1044, 1046, 1047},
  {1047, 1048, 1060},
  {1048, 1049, 1061},
  {1049, 1018,  965},
  {1070, 1020,  991},
  { 965, 1020, 1019},
  {1034, 1033,  991},
  {1033, 1070,  991},
  {1062, 1070, 1033},
  {1036, 1035, 1037},
  {1036, 1037, 1051},
  {1036, 1051, 1064},
  {1051, 1021, 1022},
  {1022, 1014, 1023},
  {1054, 1055, 1065},
  {1039, 1025, 1027},
  {1066, 1027, 1056},
  {1067, 1066, 1056},
  {1042, 1067, 1056},
  {1042, 1058, 1067},
  {1057, 1077, 1058},
  {1045, 1077, 1057},
  {1045, 1068, 1077},
  {1068, 1044, 1059},
  {1018, 1048, 1047},
  {1624, 1070, 1633},
  {1624, 1020, 1070},
  {1051, 1022, 1038},
  {1052, 1065, 1072},
  {1038, 1023, 1053},
  {1053, 1039, 1066},
  {1073, 1055, 1066},
  {1074, 1073, 1066},
  {1074, 1066, 1067},
  {1075, 1074, 1067},
  {1058, 1075, 1067},
  {1058, 1076, 1075},
  {1077, 1076, 1058},
  {1060, 1059, 1047},
  {1063, 1033, 1036},
  {1063, 1088, 1087},
  {1036, 1064, 1063},
  {1063, 1064, 1088},
  {1071, 1051, 1052},
  {1071, 1088, 1064},
  {1088, 1071, 1079},
  {1071, 1072, 1080},
  {1052, 1038, 1054},
  {1065, 1081, 1082},
  {1054, 1053, 1055},
  {1065, 1055, 1081},
  {1083, 1081, 1073},
  {1081, 1055, 1073},
  {1083, 1073, 1074},
  {1084, 1083, 1074},
  {1084, 1074, 1075},
  {1076, 1084, 1075},
  {1076, 1085, 1084},
  {1077, 1085, 1076},
  {1085, 1086, 1096},
  {1085, 1068, 1086},
  {1085, 1077, 1068},
  {1078, 1086, 1068},
  {1087, 1062, 1063},
  {1062, 1033, 1063},
  {1080, 1090, 1091},
  {1052, 1054, 1065},
  {1072, 1065, 1082},
  {1072, 1082, 1090},
  {1092, 1082, 1081},
  {1092, 1081, 1083},
  {1093, 1092, 1083},
  {1093, 1083, 1084},
  {1093, 1095, 1094},
  {1093, 1084, 1095},
  {1085, 1095, 1084},
  {1085, 1096, 1095},
  {1087, 1088, 1089},
  {1071, 1064, 1051},
  {1079, 1091, 1097},
  {1071, 1052, 1072},
  {1090, 1098, 1099},
  {1082, 1092, 1098},
  {1090, 1082, 1098},
  {1100, 1098, 1093},
  {1098, 1092, 1093},
  {1100, 1094, 1101},
  {1100, 1093, 1094},
  {1094, 1102, 1106},
  {1102, 1112, 1106},
  {1094, 1095, 1102},
  {1096, 1107, 1102},
  {1096, 1102, 1095},
  {1108, 1088, 1079},
  {1079, 1071, 1080},
  {1097, 1103, 1104},
  {1080, 1072, 1090},
  {1091, 1090, 1099},
  {1091, 1099, 1103},
  {1105, 1099, 1098},
  {1105, 1098, 1100},
  {1101, 1105, 1100},
  {1101, 1106, 1110},
  {1101, 1094, 1106},
  {1102, 1107, 1112},
  {1088, 1113, 1089},
  {1108, 1113, 1088},
  {1097, 1108, 1079},
  {1079, 1080, 1091},
  {1109, 1103, 1099},
  {1109, 1099, 1105},
  {1109, 1110, 1111},
  {1110, 1105, 1101},
  {1110, 1106, 1118},
  {1106, 1112, 1118},
  {1113, 1108, 1114},
  {1097, 1115, 1108},
  {1104, 1115, 1097},
  {1116, 1104, 1103},
  {1097, 1091, 1103},
  {1116, 1103, 1109},
  {1111, 1110, 1117},
  {1110, 1118, 1117},
  {1115, 1114, 1108},
  {1116, 1120, 1119},
  {1104, 1116, 1119},
  {1116, 1111, 1120},
  {1116, 1109, 1111},
  {1111, 1117, 1121},
  {1109, 1105, 1110},
  {1122, 1119, 1120},
  { 243,  631,  628},
  { 243,  242,  631},
  { 246,  243,  628},
  { 240,  631,  242},
  { 631,  240,  634},
  { 634,  240,  279},
  { 634,  279,  636},
  { 635,  634,  636},
  { 279,  281,  636},
  { 636,  281,  237},
  { 637,  636,  237},
  { 639,  267,  266},
  { 642,  266,  265},
  { 263,  262,  643},
  { 262,  260,  643},
  { 644,  259,  258},
  { 674,  255,  253},
  { 645,  674,  253},
  { 649,  646,  250},
  { 246,  647,  649},
  { 247,  649,  248},
  { 589,  854,  876},
  { 589,  593,  549},
  { 589,  876,  593},
  { 583,  589,  548},
  { 583,  894,  854},
  { 583,  854,  589},
  { 583,  886,  894},
  { 578,  886,  583},
  { 575,  905,  886},
  { 575,  886,  578},
  { 569,  904,  905},
  { 569,  905,  575},
  { 566,  904,  569},
  { 566,  935,  904},
  { 563,  935,  566},
  { 935,  563,  564},
  { 936,  935,  564},
  { 564,  563,  537},
  { 554,  562,  565},
  { 562,  954,  565},
  { 570,  954,  562},
  { 562,  567,  570},
  { 953,  570,  571},
  { 567,  561,  574},
  { 571,  574,  573},
  { 576,  574,  561},
  { 573,  576,  581},
  { 576,  572,  582},
  { 581,  582,  967},
  { 967,  582,  585},
  { 967,  585,  966},
  { 588,  966,  585},
  { 597,  937,  590},
  { 588,  591,  590},
  { 597,  603,  918},
  { 937,  597,  918},
  { 918,  603,  919},
  { 603,  599,  888},
  { 919,  603,  888},
  { 599,  887,  888},
  { 599,  600,  887},
  { 600,  865,  887},
  { 595,  864,  878},
  { 595,  878,  866},
  { 600,  595,  865},
  { 595,  866,  865},
  { 595,  593,  864},
  { 593,  877,  864},
  { 593,  876,  877},
  {1124,  579,  577},
  {1125,  614,  613},
  {1127, 1129, 1128},
  {1131, 1132, 1133},
  {1131, 1134, 1130},
  {1135, 1137, 1136},
  {1138, 1161, 1137},
  {1141, 1139, 1140},
  {1142, 1143, 1141},
  {1144, 1145, 1148},
  {1143, 1147, 1159},
  {1148, 1149,  568},
  {1143, 1144,  568},
  {1148,  568, 1144},
  { 579, 1151, 1152},
  { 579, 1124, 1151},
  {1149, 1150, 1124},
  {1151, 1124, 1153},
  {1153, 1124, 1154},
  {1124, 1150, 1155},
  {1154, 1124, 1155},
  { 617,  614, 1125},
  {1131, 1156, 1132},
  {1131, 1130, 1156},
  {1139, 1157, 1140},
  {1157, 1158, 1136},
  {1159, 1139, 1141},
  {1143, 1159, 1141},
  { 568,  560, 1147},
  {1143, 1142, 1144},
  {1149, 1124,  577},
  {1149,  577,  568},
  { 614,  617,  615},
  {1166, 1134, 1135},
  {1135, 1136, 1166},
  {1157, 1136, 1161},
  {1136, 1158, 1166},
  {1158, 1160, 1167},
  {1157, 1139, 1160},
  {1158, 1157, 1160},
  {1160, 1162, 1163},
  {1160, 1139, 1162},
  {1164, 1162, 1139},
  {1164, 1139, 1159},
  { 626, 1164, 1159},
  {1147, 1165,  556},
  {1165,  557,  556},
  {1159, 1147,  556},
  {1159,  556,  626},
  {1165, 1147,  560},
  {1165,  560,  559},
  { 561,  560,  568},
  {1173, 1129, 1127},
  {1166, 1158, 1167},
  {1167, 1163, 1168},
  {1164, 1169, 1162},
  { 627, 1169,  626},
  {1169, 1164,  626},
  { 557, 1165,  558},
  { 558, 1165,  559},
  {1125, 1126,  616},
  {1173, 1172, 1126},
  {1167, 1160, 1163},
  {1170, 1168, 1163},
  {1169, 1170, 1163},
  {1169, 1163, 1162},
  {1171, 1170, 1169},
  {1171, 1169,  627},
  { 627,  551, 1171},
  { 616,  615,  617},
  {1126, 1172,  616},
  {1156, 1173, 1127},
  {1156, 1130, 1166},
  {1167, 1174, 1166},
  {1175, 1176, 1181},
  {1175, 1167, 1168},
  {1176, 1178, 1177},
  {1176, 1168, 1170},
  {1176, 1170, 1178},
  {1178, 1170, 1171},
  {1179, 1178, 1171},
  {1171,  551, 1179},
  { 616, 1172,  451},
  {1172,  448,  451},
  {1172, 1173,  448},
  {1173, 1156,  445},
  {1175, 1174, 1167},
  {1175, 1168, 1176},
  {1182, 1177, 1179},
  {1177, 1178, 1179},
  {1180, 1182, 1179},
  {1180, 1179,  551},
  {1181, 1183, 1174},
  {1175, 1181, 1174},
  {1181, 1184, 1183},
  {1177, 1184, 1181},
  {1177, 1181, 1176},
  {1177, 1185, 1184},
  {1185, 1177, 1182},
  {1186, 1185, 1182},
  {1186, 1182, 1180},
  { 625, 1186, 1180},
  { 625,  420,  418},
  { 419,  625,  624},
  { 419,  624,  422},
  { 623,  422,  624},
  { 623,  622,  422},
  { 622,  423,  422},
  { 622,  621,  423},
  { 620,  424,  621},
  { 426,  620,  427},
  { 427,  620,  619},
  { 615,  396,  618},
  { 615,  616,  396},
  { 451,  396,  616},
  {1156,  399,  445},
  {1166,  402,  373},
  {1174,  405,  402},
  {1174,  406,  405},
  {1184,  410,  407},
  {1184,  407, 1183},
  {1184,  411,  410},
  {1185,  414,  411},
  {1185,  411, 1184},
  {1185,  415,  414},
  {1185,  416,  415},
  { 625,  418,  416},
  {1185, 1186,  416},
  {1186,  625,  416},
  { 625,  419,  420},
  { 620,  426,  424},
  { 621,  424,  423},
  { 428,  427,  619},
  { 428,  619,  395},
  { 395,  619,  618},
  { 396,  395,  618},
  { 446,  448, 1173},
  { 446, 1173,  445},
  { 373,  399, 1156},
  { 373, 1156, 1166},
  { 402, 1166, 1174},
  { 407,  406, 1174},
  { 407, 1174, 1183},
  { 244, 1187,  241},
  { 245,  244,  241},
  { 244, 1188, 1187},
  { 241, 1187, 1189},
  { 241, 1189,  286},
  {1189, 1190,  286},
  { 286, 1190,  238},
  {1187, 1197, 1191},
  {1197, 1187, 1188},
  {1187, 1191, 1189},
  {1189, 1192, 1190},
  {1190, 1192, 1196},
  {1190, 1193,  238},
  {1190, 1196, 1193},
  {1191, 1197, 1194},
  {1191, 1192, 1189},
  {1191, 1194, 1192},
  {1194, 1198, 1192},
  {1198, 1196, 1192},
  {1197, 1198, 1194},
  {1199, 1198, 1197},
  {1198, 1199, 1200},
  {1193, 1196, 1195},
  { 238, 1193, 1201},
  {1193, 1195, 1201},
  { 238, 1201, 1202},
  {1202,  239,  238},
  {1203, 1204, 1200},
  {1188,  244,  206},
  {1197, 1188,  206},
  {1199, 1197, 1205},
  {1197,  206, 1205},
  {1205, 1206, 1207},
  {1205, 1207, 1208},
  {1199, 1205, 1209},
  {1205, 1208, 1209},
  {1199, 1209, 1210},
  {1203, 1200, 1210},
  {1200, 1199, 1210},
  {1195, 1211, 1212},
  {1195, 1212, 1213},
  {1214, 1215, 1216},
  {1217, 1214, 1216},
  {1218, 1217, 1216},
  {1213, 1218, 1216},
  {1195, 1213,  285},
  {1213, 1216,  285},
  {1195,  285, 1201},
  {1201,  285, 1202},
  { 239, 1202,  285},
  {1205, 1216, 1215},
  {1205, 1215, 1206},
  { 206,  285, 1216},
  { 206, 1216, 1205},
  {1195, 1196, 1198},
  {1211, 1195, 1198},
  {1211, 1198, 1200},
  {1200, 1204, 1211},
  {1219, 1220, 1221},
  {1222, 1220, 1223},
  {1224, 1225, 1226},
  {1224, 1227, 1225},
  {1227, 1228, 1225},
  {1230, 1229, 1228},
  {1229, 1231, 1232},
  {1233, 1232, 1234},
  {1229, 1230, 1231},
  {1238, 1236, 1231},
  {1238, 1239, 1240},
  {1237, 1261, 1241},
  {1242, 1261, 1240},
  {1243, 1239, 1241},
  {1244, 1242, 1240},
  {1244, 1241, 1242},
  {1244, 1240, 1245},
  {1243, 1246, 1239},
  {1247, 1243, 1244},
  {1247, 1244, 1245},
  {1248, 1249, 1250},
  {1248, 1250, 1264},
  {1252, 1251, 1255},
  {1256, 1253, 1254},
  {1257, 1221, 1258},
  {1259, 1255, 1219},
  {1260, 1259, 1254},
  {1253, 1251, 1249},
  {1260, 1252, 1259},
  {1252, 1255, 1259},
  {1261, 1242, 1241},
  {1238, 1237, 1239},
  {1237, 1231, 1261},
  {1231, 1235, 1261},
  {1237, 1238, 1231},
  {1231, 1230, 1235},
  {1231, 1236, 1232},
  {1262, 1233, 1234},
  {1233, 1225, 1229},
  {1222, 1228, 1220},
  {1228, 1227, 1221},
  {1228, 1221, 1220},
  {1223, 1256, 1257},
  {1220, 1219, 1255},
  {1254, 1259, 1219},
  {1255, 1251, 1253},
  {1256, 1255, 1253},
  {1263, 1240, 1261},
  {1263, 1232, 1236},
  {1235, 1263, 1261},
  {1230, 1234, 1235},
  {1263, 1234, 1232},
  {1230, 1262, 1234},
  {1230, 1226, 1262},
  {1222, 1226, 1230},
  {1230, 1228, 1222},
  {1224, 1221, 1227},
  {1258, 1222, 1223},
  {1224, 1258, 1221},
  {1223, 1255, 1256},
  {1223, 1220, 1255},
  {1256, 1254, 1257},
  {1254, 1219, 1257},
  {1257, 1258, 1223},
  {1257, 1219, 1221},
  {1224, 1222, 1258},
  {1222, 1224, 1226},
  {1228, 1229, 1225},
  {1226, 1225, 1262},
  {1225, 1233, 1262},
  {1233, 1229, 1232},
  {1263, 1235, 1234},
  {1263, 1236, 1238},
  {1263, 1238, 1240},
  {1237, 1241, 1239},
  {1264, 1265, 1266},
  {1264, 1266, 1267},
  {1264, 1267, 1268},
  {1264, 1268, 1269},
  {1264, 1269, 1270},
  {1264, 1270, 1271},
  {1264, 1271, 1272},
  {1264, 1272, 1273},
  {1274, 1275, 1246},
  {1264, 1273, 1246},
  {1273, 1274, 1246},
  {1276, 1265, 1264},
  {1277, 1276, 1264},
  {1278, 1277, 1264},
  {1279, 1280, 1252},
  {1280, 1281, 1252},
  {1281, 1278, 1252},
  {1278, 1264, 1252},
  {1282, 1279, 1252},
  {1283, 1282, 1252},
  {1284, 1283, 1252},
  {1285, 1284, 1252},
  {1246, 1275, 1286},
  {1246, 1286, 1287},
  {1246, 1287, 1288},
  {1289, 1290, 1292},
  {1290, 1291, 1292},
  {1246, 1288, 1292},
  {1288, 1289, 1292},
  {1246, 1292, 1239},
  {1244, 1243, 1241},
  {1264, 1246, 1248},
  {1248, 1246, 1243},
  {1251, 1252, 1264},
  {1251, 1264, 1250},
  {1249, 1251, 1250},
  {1293, 1254, 1249},
  {1254, 1253, 1249},
  {1247, 1245, 1293},
  {1247, 1293, 1249},
  {1248, 1247, 1249},
  {1247, 1248, 1243},
  {1294, 1295, 1296},
  {1295, 1297, 1296},
  {1298, 1295, 1245},
  {1299, 1300, 1301},
  {1245, 1240, 1301},
  {1300, 1298, 1301},
  {1298, 1245, 1301},
  {1302, 1299, 1301},
  {1303, 1302, 1301},
  {1293, 1304, 1305},
  {1293, 1305, 1306},
  {1293, 1306, 1307},
  {1308, 1309, 1307},
  {1311, 1312, 1309},
  {1312, 1310, 1309},
  {1313, 1311, 1309},
  {1314, 1313, 1309},
  {1308, 1314, 1309},
  {1254, 1293, 1309},
  {1240, 1239, 1292},
  {1291, 1303, 1292},
  {1303, 1301, 1292},
  {1301, 1240, 1292},
  {1310, 1285, 1309},
  {1309, 1285, 1252},
  {1252, 1260, 1309},
  {1260, 1254, 1309},
  {1245, 1294, 1315},
  {1293, 1245, 1315},
  {1293, 1315, 1316},
  {1293, 1316, 1317},
  {1293, 1317, 1318},
  {1293, 1318, 1304},
  {1319, 1320, 1505},
  {1505, 1320, 1321},
  {1319, 1126, 1320},
  {1319, 1322, 1126},
  {1126, 1129, 1173},
  {1128, 1129, 1126},
  { 613, 1321, 1125},
  {1156, 1127, 1492},
  {1127, 1128, 1492},
  {1323, 1151, 1153},
  {1323, 1153, 1324},
  {1324, 1153, 1154},
  {1324, 1154, 1325},
  {1325, 1154, 1155},
  {1150, 1325, 1155},
  {1149, 1148, 1525},
  {1327, 1328, 1326},
  {1329, 1327, 1326},
  {1330, 1113, 1114},
  {1333, 1332, 1331},
  {1330, 1114, 1331},
  {1334, 1332, 1333},
  {1334, 1333, 1335},
  {1336, 1334, 1335},
  {1336, 1335, 1337},
  {1338, 1336, 1337},
  {1338, 1337, 1340},
  {1339, 1338, 1340},
  {1341, 1340, 1342},
  {1632, 1346, 1421},
  {1362, 1326, 1328},
  {1329, 1326, 1107},
  {1115, 1122, 1347},
  {1347, 1114, 1115},
  {1348, 1333, 1331},
  {1114, 1347, 1331},
  {1335, 1333, 1348},
  {1335, 1348, 1349},
  {1337, 1335, 1349},
  {1337, 1349, 1350},
  {1340, 1337, 1350},
  {1340, 1350, 1351},
  {1340, 1351, 1352},
  {1340, 1352, 1342},
  {1342, 1352, 1353},
  {1342, 1353, 1343},
  {1345, 1343, 1344},
  {1344, 1343, 1353},
  {1344, 1632, 1345},
  {1123, 1122, 1120},
  {1115, 1119, 1122},
  {1104, 1119, 1115},
  {1347, 1122, 1355},
  {1347, 1355, 1356},
  {1347, 1356, 1331},
  {1357, 1348, 1331},
  {1356, 1357, 1331},
  {1348, 1357, 1358},
  {1349, 1348, 1358},
  {1349, 1358, 1359},
  {1350, 1349, 1359},
  {1350, 1359, 1360},
  {1351, 1350, 1360},
  {1351, 1360, 1361},
  {1351, 1361, 1352},
  {1352, 1361, 1353},
  {1370, 1346, 1344},
  {1346, 1632, 1344},
  {1107, 1326, 1112},
  {1112, 1326, 1354},
  {1112, 1354, 1118},
  {1118, 1363, 1121},
  {1123, 1120, 1111},
  {1122, 1123, 1364},
  {1355, 1122, 1364},
  {1365, 1357, 1375},
  {1375, 1357, 1356},
  {1355, 1364, 1356},
  {1364, 1375, 1356},
  {1358, 1357, 1366},
  {1357, 1365, 1366},
  {1359, 1358, 1366},
  {1359, 1366, 1367},
  {1360, 1359, 1367},
  {1379, 1368, 1369},
  {1353, 1402, 1370},
  {1344, 1353, 1370},
  {1362, 1389, 1326},
  {1326, 1389, 1371},
  {1326, 1371, 1354},
  {1363, 1371, 1390},
  {1118, 1354, 1363},
  {1117, 1118, 1121},
  {1121, 1373, 1111},
  {1123, 1111, 1373},
  {1123, 1373, 1374},
  {1364, 1123, 1374},
  {1364, 1374, 1375},
  {1376, 1365, 1375},
  {1365, 1376, 1377},
  {1366, 1365, 1377},
  {1367, 1366, 1377},
  {1367, 1377, 1378},
  {1360, 1367, 1379},
  {1361, 1369, 1380},
  {1361, 1380, 1353},
  {1363, 1354, 1371},
  {1121, 1363, 1372},
  {1121, 1372, 1382},
  {1373, 1121, 1382},
  {1373, 1382, 1383},
  {1374, 1373, 1383},
  {1374, 1383, 1384},
  {1385, 1376, 1395},
  {1395, 1376, 1375},
  {1374, 1384, 1375},
  {1384, 1395, 1375},
  {1377, 1376, 1386},
  {1376, 1385, 1386},
  {1378, 1377, 1386},
  {1378, 1386, 1387},
  {1367, 1378, 1387},
  {1367, 1387, 1388},
  {1379, 1367, 1388},
  {1379, 1361, 1360},
  {1379, 1369, 1361},
  {1369, 1368, 1400},
  {1369, 1400, 1380},
  {1353, 1380, 1402},
  {1370, 1421, 1346},
  {1390, 1371, 1389},
  {1372, 1363, 1390},
  {1372, 1381, 1382},
  {1381, 1372, 1391},
  {1382, 1381, 1392},
  {1383, 1382, 1392},
  {1383, 1392, 1393},
  {1384, 1383, 1393},
  {1384, 1393, 1394},
  {1384, 1394, 1395},
  {1396, 1385, 1395},
  {1386, 1385, 1396},
  {1386, 1396, 1397},
  {1387, 1386, 1397},
  {1388, 1387, 1397},
  {1388, 1397, 1398},
  {1379, 1398, 1399},
  {1379, 1388, 1398},
  {1379, 1399, 1368},
  {1400, 1368, 1399},
  {1400, 1399, 1401},
  {1400, 1402, 1380},
  {1390, 1391, 1372},
  {1392, 1381, 1403},
  {1392, 1403, 1404},
  {1393, 1392, 1404},
  {1393, 1404, 1405},
  {1394, 1393, 1405},
  {1394, 1405, 1416},
  {1394, 1416, 1395},
  {1406, 1396, 1395},
  {1416, 1406, 1395},
  {1396, 1406, 1407},
  {1397, 1396, 1407},
  {1397, 1407, 1408},
  {1398, 1397, 1408},
  {1398, 1409, 1399},
  {1398, 1408, 1409},
  {1399, 1409, 1401},
  {1400, 1401, 1420},
  {1400, 1420, 1402},
  {1390, 1389, 1411},
  {1390, 1411, 1391},
  {1381, 1391, 1403},
  {1391, 1412, 1403},
  {1403, 1412, 1413},
  {1404, 1403, 1413},
  {1404, 1413, 1414},
  {1405, 1404, 1414},
  {1405, 1414, 1415},
  {1405, 1415, 1416},
  {1417, 1406, 1416},
  {1407, 1406, 1417},
  {1407, 1417, 1418},
  {1408, 1407, 1418},
  {1409, 1408, 1419},
  {1409, 1419, 1432},
  {1409, 1432, 1401},
  {1402, 1434, 1421},
  {1370, 1402, 1421},
  {1328, 1146, 1362},
  {1410, 1389, 1362},
  {1423, 1389, 1410},
  {1389, 1422, 1411},
  {1411, 1422, 1435},
  {1411, 1435, 1391},
  {1412, 1391, 1424},
  {1412, 1424, 1425},
  {1413, 1412, 1426},
  {1412, 1425, 1426},
  {1414, 1413, 1426},
  {1415, 1414, 1427},
  {1414, 1426, 1427},
  {1428, 1417, 1416},
  {1415, 1427, 1416},
  {1417, 1428, 1429},
  {1418, 1417, 1429},
  {1408, 1418, 1429},
  {1408, 1429, 1430},
  {1419, 1408, 1430},
  {1419, 1430, 1431},
  {1419, 1431, 1432},
  {1401, 1432, 1420},
  {1420, 1433, 1434},
  {1402, 1420, 1434},
  {1422, 1389, 1423},
  {1422, 1453, 1435},
  {1424, 1391, 1435},
  {1424, 1436, 1437},
  {1425, 1424, 1437},
  {1426, 1425, 1438},
  {1425, 1437, 1438},
  {1427, 1426, 1439},
  {1426, 1438, 1439},
  {1427, 1439, 1440},
  {1427, 1440, 1441},
  {1427, 1441, 1416},
  {1442, 1428, 1416},
  {1441, 1442, 1416},
  {1428, 1442, 1443},
  {1429, 1428, 1443},
  {1429, 1443, 1444},
  {1430, 1429, 1444},
  {1431, 1430, 1444},
  {1431, 1310, 1432},
  {1432, 1310, 1445},
  {1432, 1445, 1420},
  {1420, 1445, 1433},
  {1422, 1423, 1453},
  {1435, 1453, 1454},
  {1435, 1436, 1424},
  {1435, 1454, 1436},
  {1436, 1454, 1447},
  {1436, 1447, 1437},
  {1437, 1447, 1448},
  {1438, 1437, 1448},
  {1439, 1438, 1449},
  {1438, 1448, 1449},
  {1440, 1439, 1449},
  {1440, 1449, 1441},
  {1450, 1442, 1441},
  {1443, 1442, 1450},
  {1443, 1450, 1451},
  {1443, 1451, 1452},
  {1444, 1443, 1452},
  {1444, 1452, 1285},
  {1431, 1444, 1285},
  {1431, 1285, 1310},
  {1445, 1310, 1433},
  {1434, 1464, 1486},
  {1421, 1434, 1486},
  {1410, 1362, 1446},
  {1446, 1362, 1146},
  {1454, 1455, 1447},
  {1448, 1447, 1456},
  {1447, 1455, 1456},
  {1448, 1456, 1457},
  {1449, 1448, 1457},
  {1449, 1457, 1458},
  {1459, 1450, 1460},
  {1460, 1450, 1441},
  {1449, 1458, 1441},
  {1458, 1460, 1441},
  {1451, 1450, 1470},
  {1450, 1459, 1470},
  {1451, 1470, 1461},
  {1452, 1451, 1461},
  {1285, 1452, 1462},
  {1452, 1461, 1462},
  {1285, 1462, 1284},
  {1310, 1463, 1433},
  {1433, 1463, 1464},
  {1464, 1434, 1433},
  {1446, 1423, 1410},
  {1465, 1453, 1446},
  {1446, 1453, 1423},
  {1453, 1465, 1454},
  {1465, 1446, 1141},
  {1138, 1454, 1465},
  {1454, 1138, 1455},
  {1138, 1465, 1161},
  {1455, 1138, 1466},
  {1456, 1455, 1466},
  {1456, 1466, 1467},
  {1457, 1456, 1467},
  {1457, 1467, 1468},
  {1458, 1457, 1468},
  {1458, 1468, 1469},
  {1291, 1475, 1459},
  {1303, 1291, 1459},
  {1458, 1469, 1476},
  {1458, 1476, 1460},
  {1476, 1303, 1460},
  {1303, 1459, 1460},
  {1459, 1475, 1470},
  {1461, 1470, 1471},
  {1462, 1461, 1471},
  {1284, 1462, 1283},
  {1310, 1312, 1463},
  {1312, 1311, 1463},
  {1463, 1479, 1491},
  {1463, 1491, 1464},
  {1466, 1138, 1472},
  {1467, 1466, 1472},
  {1467, 1472, 1473},
  {1468, 1467, 1473},
  {1469, 1468, 1473},
  {1469, 1473, 1474},
  {1290, 1475, 1291},
  {1302, 1303, 1476},
  {1469, 1474, 1476},
  {1470, 1475, 1477},
  {1471, 1470, 1477},
  {1471, 1477, 1478},
  {1462, 1471, 1478},
  {1462, 1478, 1279},
  {1462, 1282, 1283},
  {1282, 1462, 1279},
  {1311, 1313, 1479},
  {1463, 1311, 1479},
  {1464, 1491, 1486},
  {1141, 1446, 1142},
  {1157, 1161, 1140},
  {1465, 1141, 1140},
  {1465, 1140, 1161},
  {1136, 1137, 1161},
  {1472, 1138, 1137},
  {1137, 1135, 1472},
  {1473, 1472, 1133},
  {1473, 1133, 1480},
  {1474, 1473, 1480},
  {1474, 1480, 1481},
  {1289, 1482, 1475},
  {1289, 1475, 1290},
  {1299, 1302, 1488},
  {1474, 1481, 1476},
  {1481, 1488, 1476},
  {1488, 1302, 1476},
  {1477, 1475, 1482},
  {1477, 1482, 1483},
  {1478, 1477, 1483},
  {1478, 1483, 1484},
  {1279, 1478, 1280},
  {1478, 1484, 1280},
  {1313, 1314, 1479},
  {1479, 1314, 1485},
  {1479, 1485, 1491},
  {1446, 1146, 1142},
  {1135, 1134, 1472},
  {1134, 1133, 1472},
  {1166, 1130, 1134},
  {1131, 1133, 1134},
  {1132, 1480, 1133},
  {1480, 1132, 1487},
  {1481, 1480, 1487},
  {1288, 1489, 1482},
  {1288, 1482, 1289},
  {1300, 1299, 1488},
  {1481, 1487, 1488},
  {1483, 1482, 1489},
  {1483, 1489, 1490},
  {1484, 1483, 1490},
  {1484, 1490, 1281},
  {1280, 1484, 1281},
  {1314, 1498, 1485},
  {1492, 1132, 1156},
  {1487, 1132, 1492},
  {1487, 1492, 1493},
  {1287, 1495, 1489},
  {1287, 1489, 1288},
  {1298, 1300, 1494},
  {1487, 1493, 1488},
  {1493, 1494, 1488},
  {1494, 1300, 1488},
  {1489, 1495, 1496},
  {1490, 1489, 1496},
  {1281, 1490, 1497},
  {1490, 1496, 1497},
  {1281, 1497, 1278},
  {1308, 1498, 1314},
  {1498, 1491, 1485},
  {1509, 1491, 1504},
  {1486, 1491, 1509},
  {1421, 1499, 1632},
  {1322, 1492, 1128},
  {1493, 1492, 1322},
  {1286, 1274, 1495},
  {1286, 1495, 1287},
  {1295, 1298, 1297},
  {1493, 1322, 1494},
  {1322, 1297, 1494},
  {1297, 1298, 1494},
  {1495, 1274, 1500},
  {1496, 1495, 1500},
  {1496, 1500, 1501},
  {1497, 1496, 1501},
  {1497, 1501, 1277},
  {1278, 1497, 1277},
  {1309, 1293, 1307},
  {1143,  568, 1147},
  {1128, 1126, 1322},
  {1275, 1274, 1286},
  {1294, 1245, 1295},
  {1322, 1319, 1297},
  {1274, 1273, 1500},
  {1273, 1272, 1500},
  {1272, 1271, 1500},
  {1271, 1270, 1501},
  {1271, 1501, 1500},
  {1270, 1269, 1501},
  {1276, 1277, 1267},
  {1268, 1277, 1501},
  {1268, 1501, 1269},
  {1276, 1267, 1266},
  {1307, 1502, 1308},
  {1502, 1306, 1503},
  {1502, 1498, 1308},
  {1502, 1491, 1498},
  {1502, 1504, 1491},
  {1145, 1142, 1146},
  {1144, 1142, 1145},
  {1506, 1315, 1294},
  {1506, 1294, 1296},
  {1319, 1505, 1297},
  {1505, 1296, 1297},
  {1506, 1507, 1315},
  {1507, 1316, 1315},
  {1507, 1317, 1316},
  {1277, 1268, 1267},
  {1266, 1265, 1276},
  {1306, 1305, 1503},
  {1502, 1307, 1306},
  {1504, 1512, 1509},
  {1421, 1486, 1499},
  {1533, 1148, 1145},
  {1320, 1125, 1321},
  {1125, 1320, 1126},
  {1507, 1506, 1215},
  {1507, 1215, 1510},
  {1317, 1507, 1510},
  {1317, 1510, 1508},
  {1508, 1318, 1317},
  {1503, 1305, 1304},
  {1503, 1304, 1511},
  {1502, 1503, 1504},
  {1503, 1511, 1504},
  {1504, 1511, 1512},
  {1486, 1509, 1499},
  {1146, 1328, 1145},
  {1321,  613,  612},
  {1505, 1321, 1513},
  {1321,  612, 1513},
  {1506, 1296, 1206},
  {1505, 1513, 1514},
  {1207, 1206, 1296},
  {1514, 1207, 1296},
  {1505, 1514, 1296},
  {1506, 1206, 1215},
  {1214, 1510, 1215},
  {1510, 1214, 1515},
  {1508, 1510, 1515},
  {1508, 1515, 1516},
  {1318, 1517, 1304},
  {1508, 1516, 1517},
  {1318, 1508, 1517},
  {1304, 1517, 1518},
  {1304, 1518, 1511},
  {1525, 1152, 1150},
  {1152, 1323, 1324},
  {1152, 1324, 1325},
  {1152, 1325, 1150},
  {1323, 1152, 1151},
  { 612,  611, 1519},
  {1513,  612, 1519},
  {1513, 1519, 1520},
  {1513, 1520, 1528},
  {1208, 1207, 1514},
  {1528, 1208, 1514},
  {1513, 1528, 1514},
  {1217, 1521, 1214},
  {1515, 1214, 1521},
  {1516, 1515, 1521},
  {1516, 1521, 1522},
  {1517, 1516, 1523},
  {1516, 1522, 1523},
  {1517, 1523, 1518},
  {1518, 1523, 1524},
  {1518, 1524, 1511},
  {1525, 1150, 1149},
  {1152, 1525,  579},
  {1526,  611,  610},
  { 608, 1526,  610},
  {1519,  611, 1526},
  {1519, 1526, 1527},
  {1520, 1519, 1527},
  {1520, 1527, 1528},
  {1209, 1208, 1528},
  {1218, 1521, 1217},
  {1521, 1218, 1538},
  {1522, 1521, 1538},
  {1522, 1538, 1529},
  {1522, 1529, 1530},
  {1523, 1522, 1530},
  {1523, 1530, 1531},
  {1523, 1531, 1524},
  {1524, 1531, 1541},
  {1511, 1524, 1532},
  {1524, 1541, 1532},
  {1532, 1512, 1511},
  {1533, 1145, 1328},
  {1525, 1148, 1533},
  { 579, 1525, 1534},
  { 605, 1535,  606},
  { 606, 1535, 1526},
  { 606, 1526,  607},
  {1526,  608,  607},
  {1527, 1526, 1544},
  {1526, 1535, 1544},
  {1527, 1544, 1536},
  {1210, 1209, 1537},
  {1527, 1536, 1528},
  {1536, 1537, 1528},
  {1537, 1209, 1528},
  {1218, 1213, 1538},
  {1529, 1538, 1539},
  {1530, 1529, 1539},
  {1530, 1539, 1540},
  {1530, 1540, 1531},
  {1540, 1547, 1531},
  {1531, 1547, 1541},
  {1532, 1541,   61},
  {1532, 1542, 1512},
  {1542, 1532,   61},
  {1542, 1509, 1512},
  { 584,  585,  580},
  { 592,  587,  586},
  { 592,  586,  591},
  { 591, 1543,  594},
  { 591, 1549, 1543},
  { 598, 1543,  596},
  {1543,  601,  596},
  { 605, 1543, 1535},
  { 601, 1543,  602},
  { 605,  604, 1543},
  { 604,  602, 1543},
  {1535, 1543, 1544},
  {1203, 1210, 1537},
  {1536, 1544, 1537},
  {1538, 1213, 1545},
  {1213, 1212, 1545},
  {1539, 1538, 1545},
  {1539, 1545, 1546},
  {1540, 1539, 1546},
  {1540, 1546, 1557},
  {1547, 1540, 1557},
  {1547, 1561, 1541},
  {1541, 1561,   61},
  { 580, 1534, 1548},
  { 580, 1548,  586},
  { 587,  585,  584},
  { 591,  586, 1549},
  {1543,  598,  594},
  {1543, 1549, 1550},
  {1544, 1543, 1550},
  {1544, 1550, 1551},
  {1544, 1551, 1552},
  {1204, 1203, 1554},
  {1211, 1204, 1553},
  {1544, 1552, 1537},
  {1552, 1554, 1537},
  {1554, 1203, 1537},
  {1555, 1212, 1211},
  {1545, 1212, 1555},
  {1545, 1555, 1556},
  {1546, 1545, 1556},
  {1546, 1556, 1557},
  {1547, 1557, 1558},
  {  48, 1558, 1559},
  {  49,   53, 1560},
  {1547, 1562, 1561},
  {1542,   61,   60},
  {1548, 1525, 1585},
  {1534, 1525, 1548},
  {1548, 1563,  586},
  { 586, 1563, 1564},
  {1549,  586, 1564},
  {1549, 1564, 1565},
  {1550, 1549, 1565},
  {1550, 1565, 1566},
  {1551, 1550, 1566},
  {1552, 1551, 1566},
  {1552, 1566, 1567},
  {1552, 1567, 1554},
  {1204, 1554, 1553},
  {1555, 1211, 1568},
  {1211, 1553, 1568},
  {1556, 1555, 1568},
  {1556, 1568, 1569},
  {1557, 1556, 1569},
  {1559, 1570,   42},
  {1558, 1557, 1559},
  {  60, 1584, 1542},
  {1548, 1585, 1563},
  {1563, 1585, 1571},
  {1563, 1571, 1564},
  {1573, 1571, 1572},
  {1565, 1564, 1573},
  {1565, 1573, 1574},
  {1566, 1565, 1574},
  {1566, 1574, 1575},
  {1567, 1566, 1575},
  {1567, 1575, 1576},
  {1567, 1576, 1577},
  {1567, 1577, 1554},
  {1578, 1553, 1554},
  {1577, 1578, 1554},
  {1568, 1553, 1578},
  {1568, 1578, 1579},
  {1568, 1579, 1580},
  {1569, 1568, 1580},
  {1569, 1580, 1591},
  {1569, 1591, 1582},
  {1569, 1582, 1581},
  {1569, 1581, 1570},
  {1559, 1557, 1570},
  {1583,   60,   63},
  {1533, 1585, 1525},
  {1585, 1594, 1571},
  {1573, 1564, 1571},
  {1573, 1572, 1586},
  {1574, 1573, 1586},
  {1574, 1586, 1587},
  {1575, 1574, 1587},
  {1575, 1587, 1588},
  {1576, 1575, 1588},
  {1599, 1578, 1577},
  {1576, 1588, 1577},
  {1578, 1599, 1589},
  {1579, 1578, 1589},
  {1580, 1579, 1590},
  {1579, 1589, 1590},
  {1580, 1590, 1591},
  {1591,   28, 1582},
  {1584, 1583, 1592},
  {1584,   60, 1583},
  {1584, 1509, 1542},
  {1584, 1499, 1509},
  {1585, 1533, 1593},
  {1594, 1572, 1571},
  {1572, 1595, 1586},
  {1587, 1586, 1595},
  {1587, 1595, 1596},
  {1587, 1596, 1597},
  {1588, 1587, 1597},
  {1588, 1597, 1598},
  {1588, 1598, 1577},
  {1598, 1599, 1577},
  {1589, 1599, 1600},
  {1590, 1589, 1600},
  {1590, 1600, 1601},
  {1591, 1590, 1602},
  {1590, 1601, 1602},
  {1591, 1602, 1604},
  {  28, 1591, 1604},
  {1605, 1603, 1604},
  {1592, 1613, 1584},
  {1583,    5, 1592},
  {1606, 1533, 1328},
  {1593, 1533, 1606},
  {1585, 1069, 1594},
  {1594, 1069, 1048},
  {1572, 1594, 1595},
  {1594, 1048, 1061},
  {1594, 1061, 1595},
  {1595, 1061,  997},
  {1595,  997, 1050},
  {1596, 1595, 1607},
  {1595, 1050, 1607},
  {1596, 1607, 1608},
  {1597, 1596, 1608},
  {1597, 1608, 1609},
  {  99, 1599, 1598},
  {1597, 1609, 1598},
  {1599,   99,  101},
  {1600, 1599,  101},
  {1600,  101,  103},
  {1601, 1600,  103},
  {1602, 1601, 1610},
  {1604, 1602, 1610},
  {1604, 1610, 1623},
  {1605, 1611,   22},
  {1605, 1623, 1611},
  {1611, 1612,   23},
  {  16, 1613,   11},
  {1613, 1612, 1614},
  {1612, 1613,   16},
  {1613, 1614, 1584},
  {1585, 1593, 1078},
  {1585, 1078, 1069},
  {1069, 1078, 1060},
  {1069, 1060, 1048},
  {1061, 1049,  997},
  {1050, 1019, 1020},
  {1050, 1020, 1615},
  {1607, 1050, 1615},
  {1608, 1607, 1615},
  {1608, 1615, 1616},
  {1609, 1608, 1616},
  {1609, 1617, 1618},
  {1609, 1618, 1619},
  { 100,   99, 1598},
  { 100, 1598, 1621},
  {1620, 1621, 1598},
  {1622, 1620, 1598},
  {1609, 1619, 1598},
  {1619, 1622, 1598},
  { 101,  102,  103},
  {1601,  103, 1610},
  { 103,  102,  104},
  {1610,  104,  105},
  {1610,  106,  107},
  {1610,  107, 1623},
  {1623, 1612, 1611},
  {1612, 1623, 1614},
  {1614, 1631, 1584},
  {1499, 1584, 1631},
  {1593, 1086, 1078},
  {1060, 1078, 1059},
  {1059, 1078, 1068},
  {1050,  997, 1019},
  {1615, 1020, 1624},
  {1616, 1615, 1624},
  {1634,  100, 1626},
  {1627, 1625, 1626},
  {  97,   98,  100},
  {1634,   97,  100},
  {  98,   99,  100},
  {1621, 1627,  100},
  {1609, 1616, 1617},
  {1616, 1628, 1617},
  {1610,  105,  106},
  { 107, 1629, 1623},
  { 109,  110, 1629},
  {1623, 1630, 1614},
  {1631, 1632, 1499},
  {1593, 1606, 1086},
  {1635, 1634, 1626},
  {1635, 1626, 1636},
  {  95,   96, 1634},
  {1616, 1624, 1628},
  {1624, 1637, 1638},
  {1624, 1633, 1637},
  {1628, 1624, 1638},
  { 109, 1629,  108},
  { 108, 1629,  107},
  {1629, 1630, 1623},
  {1614, 1639, 1631},
  {1062, 1633, 1070},
  {1633, 1062, 1640},
  {1634, 1635, 1641},
  {  94,   95, 1634},
  {1637, 1642, 1643},
  {1637, 1633, 1642},
  {1629,  110, 1645},
  {1629, 1645, 1630},
  {1630, 1645, 1639},
  {1614, 1630, 1639},
  {1631, 1646, 1345},
  {1632, 1631, 1345},
  {1086, 1606, 1327},
  {1087, 1640, 1062},
  {1647, 1641, 1648},
  {  92,   93, 1634},
  {1634, 1647, 1656},
  {  94, 1634,   93},
  {1642, 1640, 1087},
  {1642, 1087, 1651},
  {1087, 1649, 1651},
  { 110, 1652, 1645},
  {1645, 1652, 1639},
  {1631, 1639, 1646},
  {1328, 1327, 1606},
  {1086, 1329, 1096},
  {1653, 1654, 1089},
  {1654, 1649, 1089},
  {1649, 1087, 1089},
  {1655, 1653, 1089},
  {  92, 1656,   91},
  {1656,   92, 1634},
  {1657, 1655, 1656},
  {1658, 1657, 1656},
  {1647, 1658, 1656},
  {1655, 1089, 1656},
  {  91, 1656,   90},
  {1339,   87,   88},
  { 110,   87, 1339},
  { 110, 1339, 1341},
  { 110, 1341, 1652},
  {1652, 1341, 1639},
  {1639, 1341, 1646},
  {1096, 1329, 1107},
  {1086, 1327, 1329},
  {1089, 1113, 1330},
  {1656, 1330, 1331},
  {1656, 1089, 1330},
  {1656, 1331, 1332},
  {1656, 1332,   90},
  {  90, 1332, 1334},
  {  90, 1334,   89},
  {1334, 1336,   89},
  {  88,   89, 1336},
  {1336, 1338,   88},
  {1339,   88, 1338},
  {1339, 1340, 1341},
  {1341, 1343, 1646},
  {1341, 1342, 1343},
  {1343, 1345, 1646},
  {   4,   63,    0},
  {1583,    4,    5},
  {1592,    5, 1613},
  {1612,   16,   23},
  {1611,   23,   22},
  {1604, 1623, 1605},
  {  20,   26,   22},
  {  29, 1603,   26},
  {  28,   33, 1582},
  {  33,   28,   29},
  {1660, 1659,   33},
  {1582, 1660, 1581},
  {1581, 1660, 1570},
  {1557, 1569, 1570},
  {1562, 1547, 1558},
  {1661, 1560,   53},
  {1562, 1560, 1561},
  {  62,   61, 1561},
  {  62, 1661,   56},
  {  62, 1561, 1661},
  {  63,   60,   62},
  {   4, 1583,   63},
  {1582, 1659, 1660},
  {  34, 1660,   33},
  {  42, 1570, 1660},
  {  42,   48, 1559},
  {  42,   44,   48},
  {  48,   47,   50},
  {1558,   48,   50},
  {  50, 1560, 1558},
  {  50,   49, 1560},
  {1560, 1562, 1558},
  {1661, 1561, 1560},
  {  56, 1661,   53},
  {   0,    5,    4},
  {   5,   11, 1613},
  {   5,    9,   11},
  {  26, 1603,   22},
  {1603, 1605,   22},
  {  16,   12,   20},
  {  29, 1604, 1603},
  {1582,   33, 1659},
  {1648, 1662, 1636},
  {1636, 1663, 1625},
  {1625, 1664, 1665},
  {1665, 1666, 1667},
  {1667, 1668, 1669},
  {1625, 1665, 1669},
  {1665, 1667, 1669},
  {1669, 1670, 1671},
  {1625, 1669, 1643},
  {1669, 1671, 1643},
  {1671, 1672, 1643},
  {1643, 1644, 1673},
  {1643, 1673, 1674},
  {1673, 1650, 1674},
  {1675, 1676, 1678},
  {1676, 1677, 1678},
  {1674, 1675, 1678},
  {1625, 1643, 1678},
  {1643, 1674, 1678},
  {1679, 1648, 1678},
  {1648, 1636, 1678},
  {1636, 1625, 1678},
  {1648, 1679, 1647},
  {1679, 1678, 1647},
  {1678, 1658, 1647},
  {1678, 1677, 1658},
  {1677, 1657, 1658},
  {1677, 1676, 1657},
  {1676, 1655, 1657},
  {1676, 1675, 1655},
  {1675, 1653, 1655},
  {1675, 1674, 1653},
  {1674, 1654, 1653},
  {1674, 1650, 1649},
  {1674, 1649, 1654},
  {1650, 1673, 1649},
  {1673, 1651, 1649},
  {1673, 1644, 1642},
  {1673, 1642, 1651},
  {1644, 1643, 1642},
  {1633, 1640, 1642},
  {1643, 1672, 1637},
  {1637, 1671, 1638},
  {1637, 1672, 1671},
  {1638, 1671, 1628},
  {1628, 1671, 1670},
  {1628, 1670, 1617},
  {1617, 1670, 1669},
  {1617, 1669, 1668},
  {1617, 1668, 1618},
  {1618, 1668, 1667},
  {1618, 1667, 1619},
  {1619, 1667, 1666},
  {1619, 1666, 1622},
  {1622, 1666, 1620},
  {1666, 1665, 1620},
  {1620, 1665, 1621},
  {1665, 1664, 1621},
  {1621, 1664, 1627},
  {1664, 1625, 1627},
  { 100, 1627, 1626},
  {1625, 1663, 1626},
  {1663, 1636, 1626},
  {1636, 1662, 1635},
  {1635, 1662, 1641},
  {1662, 1648, 1641},
  {1647, 1634, 1641},
  {1680, 1681, 1682},
  {1680, 1682, 1683},
  {1684, 1685, 1686},
  {1687, 1688, 1680},
  {1687, 1680, 1684},
  {1689, 1718, 1690},
  {1687, 1684, 1689},
  {1691, 1687, 1689},
  {1692, 1689, 1823},
  {1692, 1823, 1693},
  {1692, 1693, 1694},
  {1695, 1692, 1696},
  {1695, 1697, 1698},
  {1695, 1696, 1697},
  {1681, 1695, 1699},
  {1681, 1700, 1701},
  {1681, 1699, 1700},
  {1704, 1705, 1702},
  {1706, 1702, 1733},
  {1702, 1706, 1707},
  {1707, 1706, 1733},
  {1708, 1743, 1757},
  {1707, 1708, 1709},
  {1710, 1757, 1771},
  {1707, 1709, 1710},
  {1710, 1711, 1715},
  {1711, 1712, 1715},
  {1702, 1707, 1715},
  {1707, 1710, 1715},
  {1704, 1702, 1715},
  {1704, 1715, 1713},
  {1704, 1713, 1716},
  {1684, 1686, 1718},
  {1718, 1720, 1719},
  {1718, 1721, 1720},
  {1720, 1721, 1722},
  {1723, 1720, 1722},
  {1723, 1722, 1724},
  {1725, 1723, 1726},
  {1723, 1724, 1726},
  {1727, 1725, 1726},
  {1703, 1727, 1733},
  {1702, 1703, 1733},
  {1684, 1718, 1689},
  {1721, 1686, 1728},
  {1722, 1721, 1728},
  {1722, 1728, 1729},
  {1724, 1722, 1730},
  {1722, 1729, 1730},
  {1726, 1724, 1730},
  {1726, 1730, 1731},
  {1727, 1726, 1732},
  {1726, 1731, 1732},
  {1727, 1732, 1733},
  {1728, 1685, 1734},
  {1728, 1686, 1685},
  {1729, 1728, 1734},
  {1730, 1729, 1735},
  {1729, 1734, 1735},
  {1731, 1730, 1736},
  {1730, 1735, 1736},
  {1732, 1731, 1737},
  {1731, 1736, 1737},
  {1733, 1732, 1737},
  {1680, 1738, 1739},
  {1685, 1740, 1734},
  {1685, 1739, 1740},
  {1734, 1740, 1741},
  {1735, 1734, 1741},
  {1735, 1741, 1742},
  {1735, 1742, 1736},
  {1733, 1737, 1743},
  {1733, 1743, 1707},
  {1739, 1685, 1684},
  {1740, 1739, 1744},
  {1739, 1738, 1744},
  {1741, 1740, 1745},
  {1740, 1744, 1745},
  {1742, 1741, 1745},
  {1742, 1745, 1746},
  {1736, 1742, 1747},
  {1742, 1746, 1747},
  {1737, 1736, 1748},
  {1736, 1747, 1748},
  {1743, 1737, 1748},
  {1708, 1707, 1743},
  {1680, 1683, 1738},
  {1680, 1739, 1684},
  {1744, 1683, 1749},
  {1744, 1738, 1683},
  {1745, 1744, 1749},
  {1746, 1745, 1750},
  {1745, 1749, 1750},
  {1747, 1746, 1755},
  {1746, 1750, 1755},
  {1748, 1747, 1751},
  {1747, 1755, 1751},
  {1743, 1748, 1757},
  {1748, 1751, 1757},
  {1683, 1752, 1749},
  {1749, 1752, 1753},
  {1750, 1749, 1754},
  {1749, 1753, 1754},
  {1750, 1754, 1755},
  {1751, 1755, 1756},
  {1751, 1756, 1757},
  {1708, 1757, 1709},
  {1680, 1688, 1758},
  {1752, 1683, 1682},
  {1753, 1752, 1759},
  {1754, 1753, 1759},
  {1754, 1759, 1760},
  {1755, 1754, 1765},
  {1754, 1760, 1765},
  {1756, 1755, 1766},
  {1755, 1765, 1766},
  {1757, 1756, 1766},
  {1710, 1709, 1757},
  {1680, 1758, 1681},
  {1752, 1682, 1761},
  {1752, 1761, 1762},
  {1759, 1752, 1762},
  {1759, 1762, 1763},
  {1760, 1759, 1764},
  {1759, 1763, 1764},
  {1765, 1760, 1764},
  {1757, 1766, 1771},
  {1681, 1761, 1682},
  {1681, 1701, 1761},
  {1762, 1701, 1767},
  {1762, 1761, 1701},
  {1763, 1762, 1767},
  {1764, 1763, 1767},
  {1764, 1767, 1768},
  {1765, 1764, 1769},
  {1764, 1768, 1769},
  {1766, 1765, 1770},
  {1765, 1769, 1770},
  {1766, 1770, 1771},
  {1701, 1772, 1767},
  {1701, 1700, 1772},
  {1767, 1772, 1773},
  {1768, 1767, 1773},
  {1768, 1773, 1774},
  {1769, 1768, 1775},
  {1768, 1774, 1775},
  {1770, 1769, 1781},
  {1769, 1775, 1781},
  {1771, 1770, 1781},
  {1771, 1781, 1782},
  {1710, 1771, 1782},
  {1710, 1782, 1711},
  {1758, 1776, 1695},
  {1772, 1700, 1699},
  {1772, 1699, 1777},
  {1773, 1772, 1777},
  {1773, 1777, 1778},
  {1774, 1773, 1778},
  {1774, 1778, 1779},
  {1775, 1774, 1780},
  {1774, 1779, 1780},
  {1775, 1780, 1781},
  {1711, 1782, 1712},
  {1681, 1758, 1695},
  {1777, 1699, 1783},
  {1699, 1784, 1783},
  {1778, 1777, 1783},
  {1778, 1783, 1785},
  {1779, 1778, 1785},
  {1779, 1785, 1786},
  {1780, 1779, 1786},
  {1780, 1786, 1787},
  {1781, 1780, 1788},
  {1780, 1787, 1788},
  {1782, 1781, 1788},
  {1695, 1784, 1699},
  {1695, 1698, 1784},
  {1783, 1784, 1698},
  {1783, 1698, 1789},
  {1785, 1783, 1790},
  {1783, 1789, 1790},
  {1786, 1785, 1791},
  {1785, 1790, 1791},
  {1787, 1786, 1792},
  {1786, 1791, 1792},
  {1788, 1787, 1792},
  {1788, 1792, 1793},
  {1782, 1788, 1793},
  {1782, 1793, 1794},
  {1712, 1782, 1794},
  {1712, 1794, 1715},
  {1789, 1698, 1795},
  {1698, 1697, 1795},
  {1790, 1789, 1795},
  {1790, 1795, 1796},
  {1791, 1790, 1797},
  {1790, 1796, 1797},
  {1792, 1791, 1797},
  {1792, 1797, 1798},
  {1793, 1792, 1798},
  {1793, 1798, 1803},
  {1794, 1793, 1803},
  {1695, 1776, 1799},
  {1795, 1697, 1696},
  {1795, 1696, 1800},
  {1796, 1795, 1801},
  {1795, 1800, 1801},
  {1797, 1796, 1802},
  {1796, 1801, 1802},
  {1798, 1797, 1802},
  {1794, 1803, 1714},
  {1715, 1794, 1714},
  {1713, 1715, 1714},
  {1695, 1799, 1692},
  {1800, 1696, 1804},
  {1696, 1805, 1804},
  {1801, 1800, 1806},
  {1800, 1804, 1806},
  {1802, 1801, 1807},
  {1801, 1806, 1807},
  {1798, 1802, 1807},
  {1798, 1807, 1808},
  {1798, 1808, 1803},
  {1692, 1805, 1696},
  {1692, 1694, 1805},
  {1804, 1805, 1809},
  {1805, 1694, 1809},
  {1806, 1804, 1809},
  {1806, 1809, 1810},
  {1807, 1806, 1810},
  {1807, 1810, 1811},
  {1808, 1807, 1811},
  {1808, 1811, 1812},
  {1803, 1808, 1813},
  {1808, 1812, 1813},
  {1714, 1803, 1813},
  {1713, 1714, 1716},
  {1809, 1694, 1814},
  {1694, 1693, 1814},
  {1810, 1809, 1815},
  {1809, 1814, 1815},
  {1811, 1810, 1816},
  {1810, 1815, 1816},
  {1812, 1811, 1816},
  {1812, 1816, 1817},
  {1813, 1812, 1817},
  {1813, 1817, 1821},
  {1714, 1813, 1717},
  {1813, 1821, 1717},
  {1704, 1716, 1717},
  {1716, 1714, 1717},
  {1692, 1799, 1691},
  {1693, 1823, 1814},
  {1815, 1814, 1818},
  {1816, 1815, 1818},
  {1816, 1818, 1819},
  {1817, 1816, 1819},
  {1817, 1819, 1820},
  {1817, 1820, 1821},
  {1692, 1691, 1689},
  {1814, 1823, 1822},
  {1818, 1814, 1822},
  {1818, 1822, 1824},
  {1819, 1818, 1825},
  {1818, 1824, 1825},
  {1820, 1819, 1825},
  {1820, 1826, 1821},
  {1717, 1821, 1826},
  {1717, 1826, 1827},
  {1704, 1717, 1705},
  {1717, 1827, 1705},
  {1689, 1690, 1823},
  {1822, 1823, 1828},
  {1823, 1690, 1828},
  {1824, 1822, 1828},
  {1824, 1828, 1829},
  {1825, 1824, 1830},
  {1824, 1829, 1830},
  {1820, 1825, 1826},
  {1825, 1830, 1831},
  {1831, 1834, 1826},
  {1825, 1831, 1826},
  {1827, 1826, 1834},
  {1828, 1690, 1718},
  {1828, 1718, 1719},
  {1829, 1828, 1832},
  {1828, 1719, 1832},
  {1830, 1829, 1833},
  {1829, 1832, 1833},
  {1830, 1833, 1831},
  {1827, 1834, 1703},
  {1702, 1705, 1703},
  {1705, 1827, 1703},
  {1832, 1719, 1720},
  {1718, 1686, 1721},
  {1833, 1832, 1723},
  {1832, 1720, 1723},
  {1831, 1833, 1723},
  {1831, 1723, 1725},
  {1834, 1831, 1727},
  {1831, 1725, 1727},
  {1834, 1727, 1703},
  {1687, 1691, 1799},
  {1687, 1799, 1758},
  {1799, 1776, 1758},
  {1687, 1758, 1688},
  {1835, 1836, 1837},
  {1835, 1837, 1838},
  {1835, 1838, 1839},
  {1840, 1841, 1842},
  {1843, 1844, 1835},
  {1843, 1835, 1840},
  {1845, 1846, 1847},
  {1843, 1840, 1845},
  {1848, 1843, 1845},
  {1849, 1845, 1850},
  {1849, 1850, 1851},
  {1849, 1851, 1852},
  {1853, 1849, 1854},
  {1853, 1855, 1856},
  {1853, 1854, 1855},
  {1836, 1853, 1857},
  {1836, 1858, 1859},
  {1836, 1857, 1858},
  {1860, 1861, 1981},
  {1864, 1865, 1897},
  {1860, 1862, 1866},
  {1862, 1864, 1866},
  {1867, 1871, 1869},
  {1860, 1866, 1869},
  {1866, 1867, 1869},
  {1872, 1873, 1946},
  {1869, 1872, 1876},
  {1874, 1875, 1971},
  {1869, 1876, 1874},
  {1861, 1860, 1874},
  {1860, 1869, 1874},
  {1861, 1874, 1877},
  {1861, 1877, 1971},
  {1840, 1878, 1879},
  {1880, 1879, 1878},
  {1880, 1878, 1888},
  {1881, 1880, 1882},
  {1880, 1888, 1882},
  {1883, 1881, 1884},
  {1881, 1882, 1884},
  {1885, 1883, 1884},
  {1885, 1884, 1886},
  {1885, 1886, 1887},
  {1863, 1887, 1865},
  {1864, 1862, 1865},
  {1862, 1863, 1865},
  {1840, 1842, 1878},
  {1840, 1879, 1845},
  {1878, 1842, 1888},
  {1882, 1888, 1889},
  {1884, 1882, 1890},
  {1882, 1889, 1890},
  {1886, 1884, 1891},
  {1884, 1890, 1891},
  {1887, 1886, 1891},
  {1887, 1891, 1896},
  {1865, 1887, 1897},
  {1887, 1896, 1897},
  {1888, 1842, 1841},
  {1888, 1841, 1892},
  {1889, 1888, 1893},
  {1888, 1892, 1893},
  {1890, 1889, 1893},
  {1890, 1893, 1894},
  {1891, 1890, 1894},
  {1891, 1894, 1895},
  {1896, 1891, 1895},
  {1864, 1897, 1866},
  {1835, 1898, 1899},
  {1892, 1841, 1899},
  {1892, 1899, 1900},
  {1893, 1892, 1901},
  {1892, 1900, 1901},
  {1894, 1893, 1902},
  {1893, 1901, 1902},
  {1894, 1902, 1895},
  {1896, 1895, 1907},
  {1897, 1896, 1868},
  {1896, 1907, 1868},
  {1897, 1868, 1866},
  {1899, 1841, 1840},
  {1900, 1899, 1898},
  {1900, 1898, 1903},
  {1901, 1900, 1903},
  {1901, 1903, 1904},
  {1902, 1901, 1905},
  {1901, 1904, 1905},
  {1895, 1902, 1906},
  {1902, 1905, 1906},
  {1895, 1906, 1907},
  {1867, 1866, 1868},
  {1835, 1839, 1898},
  {1835, 1899, 1840},
  {1903, 1898, 1908},
  {1898, 1839, 1908},
  {1904, 1903, 1909},
  {1903, 1908, 1909},
  {1905, 1904, 1910},
  {1904, 1909, 1910},
  {1906, 1905, 1911},
  {1905, 1910, 1911},
  {1907, 1906, 1911},
  {1907, 1911, 1912},
  {1868, 1907, 1912},
  {1839, 1838, 1908},
  {1909, 1908, 1913},
  {1910, 1909, 1913},
  {1910, 1913, 1914},
  {1911, 1910, 1914},
  {1911, 1914, 1915},
  {1912, 1911, 1915},
  {1868, 1912, 1916},
  {1867, 1868, 1871},
  {1868, 1916, 1871},
  {1844, 1917, 1836},
  {1908, 1838, 1837},
  {1908, 1837, 1918},
  {1913, 1908, 1918},
  {1913, 1918, 1919},
  {1914, 1913, 1919},
  {1914, 1919, 1920},
  {1915, 1914, 1920},
  {1915, 1920, 1926},
  {1912, 1915, 1921},
  {1915, 1926, 1921},
  {1916, 1912, 1921},
  {1835, 1844, 1836},
  {1918, 1837, 1922},
  {1837, 1923, 1922},
  {1919, 1918, 1922},
  {1919, 1922, 1924},
  {1920, 1919, 1925},
  {1919, 1924, 1925},
  {1920, 1925, 1926},
  {1916, 1921, 1870},
  {1869, 1871, 1870},
  {1871, 1916, 1870},
  {1836, 1923, 1837},
  {1836, 1859, 1923},
  {1922, 1859, 1927},
  {1922, 1923, 1859},
  {1924, 1922, 1927},
  {1925, 1924, 1927},
  {1925, 1927, 1928},
  {1926, 1928, 1929},
  {1926, 1925, 1928},
  {1921, 1926, 1929},
  {1921, 1929, 1870},
  {1859, 1930, 1927},
  {1859, 1858, 1930},
  {1927, 1930, 1931},
  {1928, 1927, 1932},
  {1927, 1931, 1932},
  {1928, 1933, 1929},
  {1928, 1932, 1933},
  {1929, 1933, 1939},
  {1870, 1929, 1873},
  {1929, 1939, 1873},
  {1869, 1870, 1873},
  {1872, 1869, 1873},
  {1836, 1917, 1934},
  {1930, 1858, 1857},
  {1930, 1857, 1935},
  {1931, 1930, 1935},
  {1931, 1935, 1936},
  {1932, 1931, 1936},
  {1932, 1936, 1937},
  {1933, 1932, 1938},
  {1932, 1937, 1938},
  {1933, 1938, 1939},
  {1873, 1939, 1946},
  {1836, 1934, 1853},
  {1935, 1857, 1940},
  {1935, 1940, 1941},
  {1936, 1935, 1941},
  {1936, 1941, 1942},
  {1937, 1936, 1943},
  {1936, 1942, 1943},
  {1938, 1937, 1943},
  {1938, 1943, 1944},
  {1939, 1938, 1945},
  {1938, 1944, 1945},
  {1939, 1945, 1946},
  {1872, 1946, 1876},
  {1853, 1940, 1857},
  {1853, 1856, 1940},
  {1941, 1940, 1856},
  {1941, 1856, 1947},
  {1942, 1941, 1947},
  {1942, 1947, 1948},
  {1943, 1942, 1949},
  {1942, 1948, 1949},
  {1944, 1943, 1949},
  {1944, 1949, 1950},
  {1945, 1944, 1950},
  {1945, 1950, 1955},
  {1946, 1945, 1955},
  {1946, 1955, 1875},
  {1946, 1875, 1876},
  {1947, 1856, 1951},
  {1856, 1855, 1951},
  {1948, 1947, 1951},
  {1948, 1951, 1952},
  {1949, 1948, 1953},
  {1948, 1952, 1953},
  {1950, 1949, 1954},
  {1949, 1953, 1954},
  {1955, 1950, 1954},
  {1874, 1876, 1875},
  {1853, 1934, 1956},
  {1951, 1855, 1854},
  {1951, 1854, 1957},
  {1952, 1951, 1957},
  {1952, 1957, 1958},
  {1953, 1952, 1958},
  {1953, 1958, 1959},
  {1953, 1959, 1954},
  {1955, 1954, 1960},
  {1875, 1955, 1960},
  {1875, 1960, 1971},
  {1853, 1956, 1849},
  {1957, 1854, 1961},
  {1854, 1962, 1961},
  {1958, 1957, 1963},
  {1957, 1961, 1963},
  {1959, 1958, 1964},
  {1958, 1963, 1964},
  {1954, 1959, 1964},
  {1954, 1964, 1965},
  {1960, 1954, 1965},
  {1960, 1965, 1966},
  {1971, 1960, 1966},
  {1849, 1962, 1854},
  {1849, 1852, 1962},
  {1961, 1962, 1967},
  {1962, 1852, 1967},
  {1963, 1961, 1968},
  {1961, 1967, 1968},
  {1964, 1963, 1969},
  {1963, 1968, 1969},
  {1965, 1964, 1969},
  {1965, 1969, 1975},
  {1966, 1965, 1970},
  {1965, 1975, 1970},
  {1971, 1966, 1970},
  {1874, 1971, 1877},
  {1967, 1852, 1972},
  {1852, 1851, 1972},
  {1968, 1967, 1972},
  {1968, 1972, 1973},
  {1969, 1968, 1973},
  {1969, 1973, 1974},
  {1975, 1969, 1974},
  {1849, 1956, 1848},
  {1972, 1851, 1976},
  {1851, 1850, 1976},
  {1973, 1972, 1977},
  {1972, 1976, 1977},
  {1974, 1973, 1978},
  {1973, 1977, 1978},
  {1975, 1974, 1978},
  {1975, 1978, 1979},
  {1970, 1975, 1979},
  {1970, 1979, 1980},
  {1971, 1970, 1981},
  {1970, 1980, 1981},
  {1971, 1981, 1861},
  {1849, 1848, 1845},
  {1976, 1982, 1983},
  {1976, 1850, 1982},
  {1977, 1976, 1983},
  {1978, 1977, 1983},
  {1978, 1983, 1984},
  {1979, 1978, 1984},
  {1979, 1984, 1985},
  {1980, 1979, 1990},
  {1979, 1985, 1990},
  {1981, 1980, 1990},
  {1845, 1982, 1850},
  {1845, 1847, 1982},
  {1982, 1986, 1983},
  {1982, 1847, 1986},
  {1983, 1986, 1987},
  {1984, 1983, 1987},
  {1984, 1987, 1988},
  {1985, 1984, 1989},
  {1984, 1988, 1989},
  {1985, 1989, 1990},
  {1986, 1847, 1991},
  {1847, 1846, 1991},
  {1987, 1986, 1991},
  {1987, 1991, 1992},
  {1988, 1987, 1993},
  {1987, 1992, 1993},
  {1988, 1993, 1989},
  {1990, 1989, 1994},
  {1981, 1990, 1863},
  {1990, 1994, 1863},
  {1862, 1860, 1863},
  {1860, 1981, 1863},
  {1879, 1846, 1845},
  {1991, 1846, 1880},
  {1846, 1879, 1880},
  {1992, 1991, 1881},
  {1991, 1880, 1881},
  {1993, 1992, 1883},
  {1992, 1881, 1883},
  {1989, 1993, 1883},
  {1989, 1883, 1885},
  {1994, 1989, 1887},
  {1989, 1885, 1887},
  {1994, 1887, 1863},
  {1843, 1848, 1956},
  {1843, 1956, 1917},
  {1956, 1934, 1917},
  {1843, 1917, 1844},
};

SVV_NAMESPACE_BEGIN

svvModel mechanical( "mechanical",
                     mechanical_vertices, mechanical_nvertices,
                     mechanical_indices, mechanical_nindices );

SVV_NAMESPACE_END

#endif /* SVV_MECHANICAL_H_ */
/*
 * End of: $Id: mechanical.h,v 1.1.1.1 2006/12/19 22:58:56 christianh Exp $.
 * 
 */
