/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: motor.h,v 1.1.1.1 2006/12/19 22:58:58 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MOTOR_H_
#  define SVV_MOTOR_H_
#  include "svvModel.h"

static GLsizei motor_nvertices = 1696;
static GLsizei motor_nindices  = 3320;
static GLsizei motor_nedges    = 13280;

static GLfloat motor_vertices[][6] =
{
  { 5.043101e-01, -8.267917e-01, -2.491725e-01,  2.574770e-01,  1.636379e-02, -1.536018e-01},
  { 8.503663e-01, -5.261912e-01,  9.742203e-09,  2.786891e-01,  1.636379e-02, -4.695122e-02},
  { 7.439860e-01, -6.188871e-01, -2.519198e-01,  2.410422e-01, -1.510880e-01, -1.467925e-01},
  { 4.206944e-01, -9.072025e-01,  1.285249e-08,  2.609022e-01, -1.510880e-01, -4.695122e-02},
  { 4.682963e-01, -7.492644e-01, -4.682963e-01,  1.970642e-01,  1.636379e-02, -2.440155e-01},
  { 4.682975e-01, -7.492630e-01, -4.682975e-01,  1.844842e-01, -1.510880e-01, -2.314354e-01},
  { 2.491724e-01, -8.267916e-01, -5.043100e-01,  1.066505e-01,  1.636379e-02, -3.044282e-01},
  { 2.519197e-01, -6.188872e-01, -7.439860e-01,  9.984130e-02, -1.510880e-01, -2.879935e-01},
  {-3.247401e-09, -5.261912e-01, -8.503663e-01,  0.000000e+00,  1.636379e-02, -3.256403e-01},
  { 0.000000e+00, -9.072025e-01, -4.206944e-01,  0.000000e+00, -1.510880e-01, -3.078534e-01},
  {-2.491724e-01, -8.267916e-01, -5.043100e-01, -1.066505e-01,  1.636379e-02, -3.044282e-01},
  {-2.519197e-01, -6.188872e-01, -7.439860e-01, -9.984130e-02, -1.510880e-01, -2.879935e-01},
  {-4.682963e-01, -7.492644e-01, -4.682963e-01, -1.970642e-01,  1.636379e-02, -2.440155e-01},
  {-4.682975e-01, -7.492630e-01, -4.682975e-01, -1.844842e-01, -1.510880e-01, -2.314354e-01},
  {-5.043101e-01, -8.267917e-01, -2.491725e-01, -2.574770e-01,  1.636379e-02, -1.536018e-01},
  {-7.439860e-01, -6.188871e-01, -2.519198e-01, -2.410422e-01, -1.510880e-01, -1.467925e-01},
  {-8.503663e-01, -5.261912e-01,  6.494802e-09, -2.786891e-01,  1.636379e-02, -4.695122e-02},
  {-4.206944e-01, -9.072025e-01,  6.426244e-09, -2.609022e-01, -1.510880e-01, -4.695122e-02},
  {-5.043101e-01, -8.267916e-01,  2.491724e-01, -2.574770e-01,  1.636379e-02,  5.969931e-02},
  {-7.439860e-01, -6.188871e-01,  2.519198e-01, -2.410422e-01, -1.510880e-01,  5.289008e-02},
  {-4.682963e-01, -7.492645e-01,  4.682963e-01, -1.970642e-01,  1.636379e-02,  1.501130e-01},
  {-4.682974e-01, -7.492630e-01,  4.682974e-01, -1.844842e-01, -1.510880e-01,  1.375329e-01},
  {-2.491724e-01, -8.267916e-01,  5.043100e-01, -1.066505e-01,  1.636379e-02,  2.105258e-01},
  {-2.519198e-01, -6.188872e-01,  7.439860e-01, -9.984130e-02, -1.510880e-01,  1.940910e-01},
  {-3.247401e-09, -5.261912e-01,  8.503663e-01,  0.000000e+00,  1.636379e-02,  2.317379e-01},
  {-3.213122e-09, -9.072025e-01,  4.206944e-01,  0.000000e+00, -1.510880e-01,  2.139509e-01},
  { 2.491724e-01, -8.267916e-01,  5.043100e-01,  1.066505e-01,  1.636379e-02,  2.105258e-01},
  { 2.519198e-01, -6.188871e-01,  7.439860e-01,  9.984130e-02, -1.510880e-01,  1.940910e-01},
  { 4.682963e-01, -7.492645e-01,  4.682962e-01,  1.970642e-01,  1.636379e-02,  1.501130e-01},
  { 4.682974e-01, -7.492630e-01,  4.682974e-01,  1.844842e-01, -1.510880e-01,  1.375329e-01},
  { 5.043100e-01, -8.267916e-01,  2.491724e-01,  2.574770e-01,  1.636379e-02,  5.969931e-02},
  { 7.439860e-01, -6.188871e-01,  2.519198e-01,  2.410422e-01, -1.510880e-01,  5.289008e-02},
  { 8.697601e-02, -9.955589e-01, -3.602373e-02,  6.942201e-01,  1.636379e-02, -3.345002e-01},
  { 9.414124e-02, -9.955589e-01,  4.679026e-10,  7.514057e-01,  1.636379e-02, -4.695122e-02},
  { 6.653937e-02, -9.955627e-01, -6.653936e-02,  5.313290e-01,  1.636379e-02, -5.782803e-01},
  { 3.602371e-02, -9.955589e-01, -8.697599e-02,  2.875489e-01,  1.636379e-02, -7.411714e-01},
  { 0.000000e+00, -9.955589e-01, -9.414124e-02,  0.000000e+00,  1.636379e-02, -7.983570e-01},
  {-3.602371e-02, -9.955589e-01, -8.697598e-02, -2.875489e-01,  1.636379e-02, -7.411714e-01},
  {-6.653936e-02, -9.955627e-01, -6.653936e-02, -5.313290e-01,  1.636379e-02, -5.782803e-01},
  {-8.697602e-02, -9.955589e-01, -3.602373e-02, -6.942201e-01,  1.636379e-02, -3.345002e-01},
  {-9.414124e-02, -9.955589e-01, -9.358051e-10, -7.514057e-01,  1.636379e-02, -4.695122e-02},
  {-8.697598e-02, -9.955589e-01,  3.602371e-02, -6.942201e-01,  1.636379e-02,  2.405977e-01},
  {-6.653932e-02, -9.955627e-01,  6.653931e-02, -5.313290e-01,  1.636379e-02,  4.843778e-01},
  {-3.602367e-02, -9.955589e-01,  8.697587e-02, -2.875489e-01,  1.636379e-02,  6.472689e-01},
  { 4.679026e-10, -9.955589e-01,  9.414108e-02,  0.000000e+00,  1.636379e-02,  7.044545e-01},
  { 3.602367e-02, -9.955589e-01,  8.697587e-02,  2.875489e-01,  1.636379e-02,  6.472689e-01},
  { 6.653932e-02, -9.955627e-01,  6.653931e-02,  5.313290e-01,  1.636379e-02,  4.843778e-01},
  { 8.697599e-02, -9.955589e-01,  3.602371e-02,  6.942201e-01,  1.636379e-02,  2.405977e-01},
  { 4.352692e-01, -9.003004e-01,  8.880053e-09,  7.890937e-01,  2.355775e-02, -4.695122e-02},
  { 3.158398e-01, -9.372010e-01, -1.479847e-01,  7.290320e-01,  2.355775e-02, -3.489329e-01},
  { 2.652508e-01, -9.269757e-01, -2.652508e-01,  5.579982e-01,  2.355775e-02, -6.049494e-01},
  { 1.479847e-01, -9.372010e-01, -3.158400e-01,  3.019817e-01,  2.355775e-02, -7.759832e-01},
  { 0.000000e+00, -9.003003e-01, -4.352694e-01,  0.000000e+00,  2.355775e-02, -8.360449e-01},
  {-1.479847e-01, -9.372010e-01, -3.158400e-01, -3.019817e-01,  2.355775e-02, -7.759832e-01},
  {-2.652508e-01, -9.269758e-01, -2.652508e-01, -5.579982e-01,  2.355775e-02, -6.049494e-01},
  {-3.158398e-01, -9.372010e-01, -1.479847e-01, -7.290320e-01,  2.355775e-02, -3.489329e-01},
  {-4.352692e-01, -9.003004e-01,  0.000000e+00, -7.890937e-01,  2.355775e-02, -4.695122e-02},
  {-3.158399e-01, -9.372010e-01,  1.479847e-01, -7.290320e-01,  2.355775e-02,  2.550305e-01},
  {-2.652510e-01, -9.269756e-01,  2.652509e-01, -5.579982e-01,  2.355775e-02,  5.110470e-01},
  {-1.479847e-01, -9.372010e-01,  3.158399e-01, -3.019817e-01,  2.355775e-02,  6.820808e-01},
  { 0.000000e+00, -9.003003e-01,  4.352695e-01,  0.000000e+00,  2.355775e-02,  7.421425e-01},
  { 1.479847e-01, -9.372010e-01,  3.158399e-01,  3.019817e-01,  2.355775e-02,  6.820808e-01},
  { 2.652509e-01, -9.269756e-01,  2.652509e-01,  5.579982e-01,  2.355775e-02,  5.110470e-01},
  { 3.158399e-01, -9.372010e-01,  1.479847e-01,  7.290320e-01,  2.355775e-02,  2.550305e-01},
  { 7.065868e-01, -7.076264e-01,  7.684285e-09,  8.238682e-01,  4.637595e-02, -4.695122e-02},
  { 6.699360e-01, -7.069086e-01, -2.268614e-01,  7.611545e-01,  4.637595e-02, -3.622264e-01},
  { 4.996371e-01, -7.076195e-01, -4.996372e-01,  5.825383e-01,  4.637595e-02, -6.294895e-01},
  { 2.268614e-01, -7.069085e-01, -6.699359e-01,  3.152752e-01,  4.637595e-02, -8.081057e-01},
  { 3.842143e-09, -7.076263e-01, -7.065868e-01,  0.000000e+00,  4.637595e-02, -8.708194e-01},
  {-2.268614e-01, -7.069085e-01, -6.699359e-01, -3.152752e-01,  4.637595e-02, -8.081057e-01},
  {-4.996371e-01, -7.076195e-01, -4.996372e-01, -5.825383e-01,  4.637595e-02, -6.294895e-01},
  {-6.699360e-01, -7.069085e-01, -2.268614e-01, -7.611545e-01,  4.637595e-02, -3.622264e-01},
  {-7.065868e-01, -7.076264e-01,  3.842143e-09, -8.238682e-01,  4.637595e-02, -4.695122e-02},
  {-6.699361e-01, -7.069085e-01,  2.268614e-01, -7.611545e-01,  4.637595e-02,  2.683239e-01},
  {-4.996372e-01, -7.076195e-01,  4.996371e-01, -5.825383e-01,  4.637595e-02,  5.355871e-01},
  {-2.268614e-01, -7.069084e-01,  6.699360e-01, -3.152752e-01,  4.637595e-02,  7.142033e-01},
  {-3.842143e-09, -7.076261e-01,  7.065871e-01,  0.000000e+00,  4.637595e-02,  7.769169e-01},
  { 2.268614e-01, -7.069084e-01,  6.699360e-01,  3.152752e-01,  4.637595e-02,  7.142033e-01},
  { 4.996372e-01, -7.076195e-01,  4.996371e-01,  5.825383e-01,  4.637595e-02,  5.355871e-01},
  { 6.699361e-01, -7.069085e-01,  2.268615e-01,  7.611545e-01,  4.637595e-02,  2.683239e-01},
  { 8.310733e-01, -3.750798e-01, -4.106484e-01,  7.822209e-01,  8.110936e-02, -3.709555e-01},
  { 9.267150e-01, -3.757652e-01,  9.649945e-09,  8.466527e-01,  8.110936e-02, -4.695122e-02},
  { 6.552781e-01, -3.757940e-01, -6.552781e-01,  5.986743e-01,  8.110936e-02, -6.456255e-01},
  { 4.106483e-01, -3.750802e-01, -8.310732e-01,  3.240043e-01,  8.110936e-02, -8.291721e-01},
  { 3.859978e-09, -3.757655e-01, -9.267148e-01,  0.000000e+00,  8.110936e-02, -8.936040e-01},
  {-4.106484e-01, -3.750802e-01, -8.310732e-01, -3.240043e-01,  8.110936e-02, -8.291721e-01},
  {-6.552781e-01, -3.757940e-01, -6.552781e-01, -5.986743e-01,  8.110936e-02, -6.456255e-01},
  {-8.310734e-01, -3.750799e-01, -4.106484e-01, -7.822209e-01,  8.110936e-02, -3.709555e-01},
  {-9.267149e-01, -3.757652e-01,  1.157993e-08, -8.466527e-01,  8.110936e-02, -4.695122e-02},
  {-8.310734e-01, -3.750798e-01,  4.106484e-01, -7.822209e-01,  8.110936e-02,  2.770531e-01},
  {-6.552782e-01, -3.757939e-01,  6.552782e-01, -5.986743e-01,  8.110936e-02,  5.517231e-01},
  {-4.106484e-01, -3.750797e-01,  8.310735e-01, -3.240043e-01,  8.110936e-02,  7.352697e-01},
  {-3.859978e-09, -3.757651e-01,  9.267150e-01,  0.000000e+00,  8.110936e-02,  7.997015e-01},
  { 4.106484e-01, -3.750797e-01,  8.310734e-01,  3.240043e-01,  8.110936e-02,  7.352697e-01},
  { 6.552782e-01, -3.757938e-01,  6.552782e-01,  5.986743e-01,  8.110936e-02,  5.517231e-01},
  { 8.310734e-01, -3.750798e-01,  4.106485e-01,  7.822209e-01,  8.110936e-02,  2.770531e-01},
  { 9.963557e-01, -7.538422e-02,  3.990838e-02,  8.538616e-01,  1.188272e-01, -4.695122e-02},
  { 9.429749e-01, -9.400215e-02, -3.193146e-01,  7.888696e-01,  1.188272e-01, -3.737083e-01},
  { 7.228803e-01, -1.074528e-01, -6.825672e-01,  6.037542e-01,  1.188272e-01, -6.507054e-01},
  { 3.815337e-01, -9.420691e-02, -9.195418e-01,  3.267571e-01,  1.188272e-01, -8.358208e-01},
  { 3.990837e-02, -7.538424e-02, -9.963557e-01,  0.000000e+00,  1.188272e-01, -9.008129e-01},
  {-3.193146e-01, -9.400224e-02, -9.429749e-01, -3.267571e-01,  1.188272e-01, -8.358208e-01},
  {-6.825672e-01, -1.074528e-01, -7.228802e-01, -6.037542e-01,  1.188272e-01, -6.507054e-01},
  {-9.195418e-01, -9.420686e-02, -3.815336e-01, -7.888696e-01,  1.188272e-01, -3.737083e-01},
  {-9.963557e-01, -7.538424e-02, -3.990836e-02, -8.538616e-01,  1.188272e-01, -4.695122e-02},
  {-9.429749e-01, -9.400216e-02,  3.193147e-01, -7.888696e-01,  1.188272e-01,  2.798059e-01},
  {-7.228803e-01, -1.074523e-01,  6.825672e-01, -6.037542e-01,  1.188272e-01,  5.568029e-01},
  {-3.815337e-01, -9.420645e-02,  9.195418e-01, -3.267571e-01,  1.188272e-01,  7.419183e-01},
  {-3.990837e-02, -7.538424e-02,  9.963557e-01,  0.000000e+00,  1.188272e-01,  8.069104e-01},
  { 3.193147e-01, -9.400179e-02,  9.429750e-01,  3.267571e-01,  1.188272e-01,  7.419183e-01},
  { 6.825672e-01, -1.074523e-01,  7.228803e-01,  6.037542e-01,  1.188272e-01,  5.568029e-01},
  { 9.195418e-01, -9.420682e-02,  3.815337e-01,  7.888696e-01,  1.188272e-01,  2.798059e-01},
  { 5.920888e-01,  8.049161e-01, -3.925554e-02,  8.538616e-01,  4.062753e-01, -4.695122e-02},
  { 7.419578e-01,  5.613157e-01, -3.666378e-01,  7.888696e-01,  4.062753e-01, -3.737083e-01},
  { 3.909256e-01,  8.049127e-01, -4.464222e-01,  6.037542e-01,  4.062753e-01, -6.507054e-01},
  { 2.654446e-01,  5.613157e-01, -7.838775e-01,  3.267571e-01,  4.062753e-01, -8.358208e-01},
  {-3.925554e-02,  8.049161e-01, -5.920888e-01,  0.000000e+00,  4.062753e-01, -9.008129e-01},
  {-3.666378e-01,  5.613157e-01, -7.419578e-01, -3.267571e-01,  4.062753e-01, -8.358208e-01},
  {-4.464222e-01,  8.049127e-01, -3.909256e-01, -6.037542e-01,  4.062753e-01, -6.507054e-01},
  {-7.838775e-01,  5.613157e-01, -2.654445e-01, -7.888696e-01,  4.062753e-01, -3.737083e-01},
  {-5.920888e-01,  8.049161e-01,  3.925554e-02, -8.538616e-01,  4.062753e-01, -4.695122e-02},
  {-7.419578e-01,  5.613157e-01,  3.666378e-01, -7.888696e-01,  4.062753e-01,  2.798059e-01},
  {-3.909256e-01,  8.049127e-01,  4.464222e-01, -6.037542e-01,  4.062753e-01,  5.568029e-01},
  {-2.654446e-01,  5.613157e-01,  7.838775e-01, -3.267571e-01,  4.062753e-01,  7.419183e-01},
  { 3.925554e-02,  8.049161e-01,  5.920888e-01,  0.000000e+00,  4.062753e-01,  8.069104e-01},
  { 3.666378e-01,  5.613157e-01,  7.419578e-01,  3.267571e-01,  4.062753e-01,  7.419183e-01},
  { 4.464222e-01,  8.049127e-01,  3.909256e-01,  6.037542e-01,  4.062753e-01,  5.568029e-01},
  { 7.838775e-01,  5.613157e-01,  2.654446e-01,  7.888696e-01,  4.062753e-01,  2.798059e-01},
  { 5.620341e-01,  8.049172e-01, -1.903311e-01,  7.669441e-01,  4.062753e-01, -3.646318e-01},
  { 8.257890e-01,  5.613143e-01,  5.476069e-02,  8.301433e-01,  4.062753e-01, -4.695122e-02},
  { 6.226313e-01,  5.613094e-01, -5.452175e-01,  5.869832e-01,  4.062753e-01, -6.339344e-01},
  { 2.628731e-01,  8.049172e-01, -5.319831e-01,  3.176806e-01,  4.062753e-01, -8.138953e-01},
  { 5.476068e-02,  5.613143e-01, -8.257890e-01,  0.000000e+00,  4.062753e-01, -8.770945e-01},
  {-1.903311e-01,  8.049172e-01, -5.620341e-01, -3.176806e-01,  4.062753e-01, -8.138953e-01},
  {-5.452175e-01,  5.613094e-01, -6.226313e-01, -5.869832e-01,  4.062753e-01, -6.339344e-01},
  {-5.319831e-01,  8.049172e-01, -2.628731e-01, -7.669441e-01,  4.062753e-01, -3.646318e-01},
  {-8.257890e-01,  5.613143e-01, -5.476066e-02, -8.301433e-01,  4.062753e-01, -4.695122e-02},
  {-5.620341e-01,  8.049172e-01,  1.903311e-01, -7.669441e-01,  4.062753e-01,  2.707294e-01},
  {-6.226313e-01,  5.613094e-01,  5.452175e-01, -5.869832e-01,  4.062753e-01,  5.400320e-01},
  {-2.628731e-01,  8.049172e-01,  5.319831e-01, -3.176806e-01,  4.062753e-01,  7.199928e-01},
  {-5.476068e-02,  5.613143e-01,  8.257890e-01,  0.000000e+00,  4.062753e-01,  7.831920e-01},
  { 1.903311e-01,  8.049172e-01,  5.620341e-01,  3.176806e-01,  4.062753e-01,  7.199928e-01},
  { 5.452175e-01,  5.613094e-01,  6.226313e-01,  5.869832e-01,  4.062753e-01,  5.400320e-01},
  { 5.319831e-01,  8.049172e-01,  2.628731e-01,  7.669441e-01,  4.062753e-01,  2.707294e-01},
  { 8.257890e-01,  5.613143e-01, -5.476066e-02,  8.301433e-01,  4.418715e-01, -4.695122e-02},
  { 6.284568e-01,  7.131650e-01, -3.105443e-01,  7.669441e-01,  4.418715e-01, -3.646318e-01},
  { 3.909193e-01,  8.049142e-01, -4.464248e-01,  5.869832e-01,  4.418715e-01, -6.339344e-01},
  { 2.248471e-01,  7.131650e-01, -6.639575e-01,  3.176806e-01,  4.418715e-01, -8.138953e-01},
  {-5.476068e-02,  5.613143e-01, -8.257890e-01,  0.000000e+00,  4.418715e-01, -8.770945e-01},
  {-3.105443e-01,  7.131650e-01, -6.284568e-01, -3.176806e-01,  4.418715e-01, -8.138953e-01},
  {-4.464248e-01,  8.049142e-01, -3.909193e-01, -5.869832e-01,  4.418715e-01, -6.339344e-01},
  {-6.639575e-01,  7.131650e-01, -2.248471e-01, -7.669441e-01,  4.418715e-01, -3.646318e-01},
  {-8.257890e-01,  5.613143e-01,  5.476069e-02, -8.301433e-01,  4.418715e-01, -4.695122e-02},
  {-6.284568e-01,  7.131650e-01,  3.105443e-01, -7.669441e-01,  4.418715e-01,  2.707294e-01},
  {-3.909193e-01,  8.049142e-01,  4.464248e-01, -5.869832e-01,  4.418715e-01,  5.400320e-01},
  {-2.248471e-01,  7.131650e-01,  6.639575e-01, -3.176806e-01,  4.418715e-01,  7.199928e-01},
  { 5.476068e-02,  5.613143e-01,  8.257890e-01,  0.000000e+00,  4.418715e-01,  7.831920e-01},
  { 3.105443e-01,  7.131650e-01,  6.284568e-01,  3.176806e-01,  4.418715e-01,  7.199928e-01},
  { 4.464248e-01,  8.049142e-01,  3.909193e-01,  5.869832e-01,  4.418715e-01,  5.400320e-01},
  { 6.639575e-01,  7.131650e-01,  2.248471e-01,  7.669441e-01,  4.418715e-01,  2.707294e-01},
  {-5.920876e-01,  8.049168e-01, -3.925839e-02,  7.988425e-01,  4.418715e-01, -4.695122e-02},
  {-6.639675e-01,  7.131636e-01,  2.248218e-01,  7.380338e-01,  4.418715e-01, -3.526531e-01},
  {-6.226420e-01,  5.613141e-01,  5.452002e-01,  5.648710e-01,  4.418715e-01, -6.118222e-01},
  {-3.105105e-01,  7.131636e-01,  6.284751e-01,  3.057019e-01,  4.418715e-01, -7.849850e-01},
  {-3.925838e-02,  8.049168e-01,  5.920876e-01,  0.000000e+00,  4.418715e-01, -8.457937e-01},
  { 2.248218e-01,  7.131636e-01,  6.639675e-01, -3.057019e-01,  4.418715e-01, -7.849850e-01},
  { 5.452002e-01,  5.613141e-01,  6.226421e-01, -5.648710e-01,  4.418715e-01, -6.118222e-01},
  { 6.284751e-01,  7.131636e-01,  3.105105e-01, -7.380338e-01,  4.418715e-01, -3.526531e-01},
  { 5.920876e-01,  8.049168e-01,  3.925838e-02, -7.988425e-01,  4.418715e-01, -4.695122e-02},
  { 6.639675e-01,  7.131636e-01, -2.248218e-01, -7.380338e-01,  4.418715e-01,  2.587507e-01},
  { 6.226420e-01,  5.613141e-01, -5.452002e-01, -5.648710e-01,  4.418715e-01,  5.179198e-01},
  { 3.105104e-01,  7.131636e-01, -6.284752e-01, -3.057019e-01,  4.418715e-01,  6.910825e-01},
  { 3.925838e-02,  8.049168e-01, -5.920876e-01,  0.000000e+00,  4.418715e-01,  7.518913e-01},
  {-2.248218e-01,  7.131636e-01, -6.639675e-01,  3.057019e-01,  4.418715e-01,  6.910825e-01},
  {-5.452002e-01,  5.613141e-01, -6.226421e-01,  5.648710e-01,  4.418715e-01,  5.179198e-01},
  {-6.284751e-01,  7.131636e-01, -3.105105e-01,  7.380338e-01,  4.418715e-01,  2.587507e-01},
  {-9.937646e-01,  1.077894e-01,  2.851868e-02,  7.988425e-01,  1.188272e-01, -4.695122e-02},
  {-9.052194e-01,  7.572816e-02,  4.181424e-01,  7.380338e-01,  1.188272e-01, -3.526531e-01},
  {-6.825284e-01,  1.078075e-01,  7.228642e-01,  5.648710e-01,  1.188272e-01, -6.118222e-01},
  {-3.443987e-01,  7.572817e-02,  9.357642e-01,  3.057019e-01,  1.188272e-01, -7.849850e-01},
  { 2.851870e-02,  1.077894e-01,  9.937646e-01,  0.000000e+00,  1.188272e-01, -8.457937e-01},
  { 4.181424e-01,  7.572830e-02,  9.052194e-01, -3.057019e-01,  1.188272e-01, -7.849850e-01},
  { 7.228642e-01,  1.078075e-01,  6.825284e-01, -5.648710e-01,  1.188272e-01, -6.118222e-01},
  { 9.357642e-01,  7.572817e-02,  3.443987e-01, -7.380338e-01,  1.188272e-01, -3.526531e-01},
  { 9.937646e-01,  1.077894e-01, -2.851871e-02, -7.988425e-01,  1.188272e-01, -4.695122e-02},
  { 9.052194e-01,  7.572816e-02, -4.181424e-01, -7.380338e-01,  1.188272e-01,  2.587507e-01},
  { 6.825284e-01,  1.078072e-01, -7.228642e-01, -5.648710e-01,  1.188272e-01,  5.179198e-01},
  { 3.443987e-01,  7.572696e-02, -9.357644e-01, -3.057019e-01,  1.188272e-01,  6.910825e-01},
  {-2.851869e-02,  1.077874e-01, -9.937648e-01,  0.000000e+00,  1.188272e-01,  7.518913e-01},
  {-4.181423e-01,  7.572697e-02, -9.052195e-01,  3.057019e-01,  1.188272e-01,  6.910825e-01},
  {-7.228642e-01,  1.078071e-01, -6.825285e-01,  5.648710e-01,  1.188272e-01,  5.179198e-01},
  {-9.357642e-01,  7.572819e-02, -3.443987e-01,  7.380338e-01,  1.188272e-01,  2.587507e-01},
  {-8.560839e-01,  3.760054e-01,  3.545986e-01,  7.349336e-01,  1.013652e-01, -3.513757e-01},
  {-9.266900e-01,  3.758267e-01, -7.721042e-09,  7.955182e-01,  1.013652e-01, -4.695122e-02},
  {-6.552764e-01,  3.758001e-01,  6.552764e-01,  5.625178e-01,  1.013652e-01, -6.094690e-01},
  {-3.545985e-01,  3.760061e-01,  8.560837e-01,  3.044245e-01,  1.013652e-01, -7.818848e-01},
  { 0.000000e+00,  3.758267e-01,  9.266900e-01,  0.000000e+00,  1.013652e-01, -8.424694e-01},
  { 3.545985e-01,  3.760063e-01,  8.560837e-01, -3.044245e-01,  1.013652e-01, -7.818848e-01},
  { 6.552765e-01,  3.758001e-01,  6.552764e-01, -5.625178e-01,  1.013652e-01, -6.094690e-01},
  { 8.560839e-01,  3.760055e-01,  3.545986e-01, -7.349336e-01,  1.013652e-01, -3.513757e-01},
  { 9.266900e-01,  3.758267e-01, -3.860521e-09, -7.955182e-01,  1.013652e-01, -4.695122e-02},
  { 8.560839e-01,  3.760056e-01, -3.545986e-01, -7.349336e-01,  1.013652e-01,  2.574732e-01},
  { 6.552764e-01,  3.758002e-01, -6.552764e-01, -5.625178e-01,  1.013652e-01,  5.155666e-01},
  { 3.545986e-01,  3.760054e-01, -8.560840e-01, -3.044245e-01,  1.013652e-01,  6.879824e-01},
  { 0.000000e+00,  3.758264e-01, -9.266901e-01,  0.000000e+00,  1.013652e-01,  7.485670e-01},
  {-3.545986e-01,  3.760054e-01, -8.560840e-01,  3.044245e-01,  1.013652e-01,  6.879824e-01},
  {-6.552764e-01,  3.758002e-01, -6.552764e-01,  5.625178e-01,  1.013652e-01,  5.155666e-01},
  {-8.560839e-01,  3.760056e-01, -3.545985e-01,  7.349336e-01,  1.013652e-01,  2.574732e-01},
  {-7.535770e-01,  6.573597e-01, -7.675992e-09,  7.849476e-01,  8.528155e-02, -4.695122e-02},
  {-6.060815e-01,  7.547498e-01,  2.510338e-01,  7.251848e-01,  8.528155e-02, -3.473342e-01},
  {-5.328348e-01,  6.573995e-01,  5.328348e-01,  5.550474e-01,  8.528155e-02, -6.019986e-01},
  {-2.510335e-01,  7.547503e-01,  6.060809e-01,  3.003830e-01,  8.528155e-02, -7.721360e-01},
  {-5.117327e-09,  6.573604e-01,  7.535763e-01,  0.000000e+00,  8.528155e-02, -8.318989e-01},
  { 2.510335e-01,  7.547504e-01,  6.060808e-01, -3.003830e-01,  8.528155e-02, -7.721360e-01},
  { 5.328348e-01,  6.573996e-01,  5.328348e-01, -5.550474e-01,  8.528155e-02, -6.019986e-01},
  { 6.060815e-01,  7.547498e-01,  2.510338e-01, -7.251848e-01,  8.528155e-02, -3.473342e-01},
  { 7.535770e-01,  6.573597e-01, -2.558664e-09, -7.849476e-01,  8.528155e-02, -4.695122e-02},
  { 6.060815e-01,  7.547498e-01, -2.510337e-01, -7.251848e-01,  8.528155e-02,  2.534318e-01},
  { 5.328348e-01,  6.573997e-01, -5.328347e-01, -5.550474e-01,  8.528155e-02,  5.080962e-01},
  { 2.510334e-01,  7.547504e-01, -6.060809e-01, -3.003830e-01,  8.528155e-02,  6.782336e-01},
  { 2.558663e-09,  6.573611e-01, -7.535757e-01,  0.000000e+00,  8.528155e-02,  7.379964e-01},
  {-2.510334e-01,  7.547505e-01, -6.060808e-01,  3.003830e-01,  8.528155e-02,  6.782336e-01},
  {-5.328346e-01,  6.573998e-01, -5.328345e-01,  5.550474e-01,  8.528155e-02,  5.080962e-01},
  {-6.060814e-01,  7.547498e-01, -2.510337e-01,  7.251848e-01,  8.528155e-02,  2.534318e-01},
  {-4.352393e-01,  9.003147e-01, -2.537109e-09,  7.688490e-01,  7.472220e-02, -4.695122e-02},
  {-3.150389e-01,  9.411726e-01,  1.222489e-01,  7.103188e-01,  7.472220e-02, -3.411824e-01},
  {-2.650090e-01,  9.271140e-01,  2.650091e-01,  5.436551e-01,  7.472220e-02, -5.906063e-01},
  {-1.222490e-01,  9.411724e-01,  3.150390e-01,  2.942311e-01,  7.472220e-02, -7.572700e-01},
  {-6.342771e-10,  9.003147e-01,  4.352393e-01,  0.000000e+00,  7.472220e-02, -8.158002e-01},
  { 1.222490e-01,  9.411724e-01,  3.150391e-01, -2.942311e-01,  7.472220e-02, -7.572700e-01},
  { 2.650090e-01,  9.271140e-01,  2.650091e-01, -5.436551e-01,  7.472220e-02, -5.906063e-01},
  { 3.150389e-01,  9.411725e-01,  1.222488e-01, -7.103188e-01,  7.472220e-02, -3.411824e-01},
  { 4.352393e-01,  9.003147e-01,  1.268554e-09, -7.688490e-01,  7.472220e-02, -4.695122e-02},
  { 3.150389e-01,  9.411725e-01, -1.222489e-01, -7.103188e-01,  7.472220e-02,  2.472799e-01},
  { 2.650089e-01,  9.271141e-01, -2.650089e-01, -5.436551e-01,  7.472220e-02,  4.967039e-01},
  { 1.222488e-01,  9.411725e-01, -3.150389e-01, -2.942311e-01,  7.472220e-02,  6.633676e-01},
  { 6.342771e-09,  9.003147e-01, -4.352393e-01,  0.000000e+00,  7.472220e-02,  7.218978e-01},
  {-1.222489e-01,  9.411725e-01, -3.150389e-01,  2.942311e-01,  7.472220e-02,  6.633676e-01},
  {-2.650089e-01,  9.271141e-01, -2.650089e-01,  5.436551e-01,  7.472220e-02,  4.967039e-01},
  {-3.150389e-01,  9.411725e-01, -1.222489e-01,  7.103188e-01,  7.472220e-02,  2.472799e-01},
  {-9.423484e-02,  9.955500e-01, -2.339535e-09,  7.514057e-01,  7.139043e-02, -4.695122e-02},
  {-1.016180e-01,  9.935559e-01,  5.020453e-02,  6.942201e-01,  7.139043e-02, -3.345002e-01},
  {-4.440472e-02,  9.980263e-01,  4.440472e-02,  5.313290e-01,  7.139043e-02, -5.782803e-01},
  {-5.020459e-02,  9.935559e-01,  1.016182e-01,  2.875489e-01,  7.139043e-02, -7.411714e-01},
  { 0.000000e+00,  9.955500e-01,  9.423500e-02,  0.000000e+00,  7.139043e-02, -7.983570e-01},
  { 5.020460e-02,  9.935559e-01,  1.016183e-01, -2.875489e-01,  7.139043e-02, -7.411714e-01},
  { 4.440472e-02,  9.980263e-01,  4.440472e-02, -5.313290e-01,  7.139043e-02, -5.782803e-01},
  { 1.016180e-01,  9.935559e-01,  5.020452e-02, -6.942201e-01,  7.139043e-02, -3.345002e-01},
  { 9.423484e-02,  9.955500e-01,  0.000000e+00, -7.514057e-01,  7.139043e-02, -4.695122e-02},
  { 1.016180e-01,  9.935559e-01, -5.020453e-02, -6.942201e-01,  7.139043e-02,  2.405977e-01},
  { 4.440472e-02,  9.980263e-01, -4.440473e-02, -5.313290e-01,  7.139043e-02,  4.843778e-01},
  { 5.020451e-02,  9.935559e-01, -1.016180e-01, -2.875489e-01,  7.139043e-02,  6.472689e-01},
  { 0.000000e+00,  9.955500e-01, -9.423484e-02,  0.000000e+00,  7.139043e-02,  7.044545e-01},
  {-5.020452e-02,  9.935559e-01, -1.016180e-01,  2.875489e-01,  7.139043e-02,  6.472689e-01},
  {-4.440472e-02,  9.980263e-01, -4.440472e-02,  5.313290e-01,  7.139043e-02,  4.843778e-01},
  {-1.016180e-01,  9.935559e-01, -5.020452e-02,  6.942201e-01,  7.139043e-02,  2.405977e-01},
  { 5.620427e-01,  8.049171e-01, -1.903059e-01,  2.574770e-01,  7.139043e-02, -1.536018e-01},
  { 8.257918e-01,  5.613113e-01,  5.474815e-02,  2.786891e-01,  7.139043e-02, -4.695122e-02},
  { 6.226384e-01,  5.613124e-01, -5.452062e-01,  1.970642e-01,  7.139043e-02, -2.440155e-01},
  { 2.628489e-01,  8.049171e-01, -5.319951e-01,  1.066505e-01,  7.139043e-02, -3.044282e-01},
  { 5.474807e-02,  5.613113e-01, -8.257919e-01,  0.000000e+00,  7.139043e-02, -3.256403e-01},
  {-1.903058e-01,  8.049172e-01, -5.620427e-01, -1.066505e-01,  7.139043e-02, -3.044282e-01},
  {-5.452063e-01,  5.613124e-01, -6.226383e-01, -1.970642e-01,  7.139043e-02, -2.440155e-01},
  {-5.319951e-01,  8.049171e-01, -2.628489e-01, -2.574770e-01,  7.139043e-02, -1.536018e-01},
  {-8.257918e-01,  5.613113e-01, -5.474815e-02, -2.786891e-01,  7.139043e-02, -4.695122e-02},
  {-5.620427e-01,  8.049171e-01,  1.903058e-01, -2.574770e-01,  7.139043e-02,  5.969931e-02},
  {-6.226383e-01,  5.613124e-01,  5.452062e-01, -1.970642e-01,  7.139043e-02,  1.501130e-01},
  {-2.628489e-01,  8.049172e-01,  5.319951e-01, -1.066505e-01,  7.139043e-02,  2.105258e-01},
  {-5.474811e-02,  5.613113e-01,  8.257919e-01,  0.000000e+00,  7.139043e-02,  2.317379e-01},
  { 1.903058e-01,  8.049171e-01,  5.620427e-01,  1.066505e-01,  7.139043e-02,  2.105258e-01},
  { 5.452062e-01,  5.613124e-01,  6.226383e-01,  1.970642e-01,  7.139043e-02,  1.501130e-01},
  { 5.319951e-01,  8.049171e-01,  2.628489e-01,  2.574770e-01,  7.139043e-02,  5.969931e-02},
  { 8.982938e-01,  4.383344e-01, -3.051673e-02,  2.786891e-01,  2.450276e-01, -4.695122e-02},
  { 8.621014e-01,  3.067716e-01, -4.033267e-01,  2.574770e-01,  2.450276e-01, -1.536018e-01},
  { 6.136101e-01,  4.383316e-01, -6.567708e-01,  1.970642e-01,  2.450276e-01, -2.440155e-01},
  { 3.243879e-01,  3.067717e-01, -8.947981e-01,  1.066505e-01,  2.450276e-01, -3.044282e-01},
  {-3.051669e-02,  4.383343e-01, -8.982938e-01,  0.000000e+00,  2.450276e-01, -3.256403e-01},
  {-4.033267e-01,  3.067717e-01, -8.621013e-01, -1.066505e-01,  2.450276e-01, -3.044282e-01},
  {-6.567709e-01,  4.383316e-01, -6.136100e-01, -1.970642e-01,  2.450276e-01, -2.440155e-01},
  {-8.947981e-01,  3.067717e-01, -3.243880e-01, -2.574770e-01,  2.450276e-01, -1.536018e-01},
  {-8.982938e-01,  4.383344e-01,  3.051673e-02, -2.786891e-01,  2.450276e-01, -4.695122e-02},
  {-8.621014e-01,  3.067717e-01,  4.033267e-01, -2.574770e-01,  2.450276e-01,  5.969931e-02},
  {-6.136101e-01,  4.383317e-01,  6.567708e-01, -1.970642e-01,  2.450276e-01,  1.501130e-01},
  {-3.243879e-01,  3.067716e-01,  8.947981e-01, -1.066505e-01,  2.450276e-01,  2.105258e-01},
  { 3.051671e-02,  4.383344e-01,  8.982937e-01,  0.000000e+00,  2.450276e-01,  2.317379e-01},
  { 4.033267e-01,  3.067717e-01,  8.621014e-01,  1.066505e-01,  2.450276e-01,  2.105258e-01},
  { 6.567709e-01,  4.383317e-01,  6.136101e-01,  1.970642e-01,  2.450276e-01,  1.501130e-01},
  { 8.947981e-01,  3.067717e-01,  3.243880e-01,  2.574770e-01,  2.450276e-01,  5.969931e-02},
  { 4.653511e-01,  8.638845e-01, -1.927482e-01,  2.136522e-01,  2.924270e-01, -1.354488e-01},
  { 2.509007e-01,  9.680128e-01,  0.000000e+00,  2.312523e-01,  2.924270e-01, -4.695122e-02},
  { 1.774162e-01,  9.680119e-01, -1.774162e-01,  1.635223e-01,  2.924270e-01, -2.104736e-01},
  { 1.927482e-01,  8.638845e-01, -4.653511e-01,  8.849757e-02,  2.924270e-01, -2.606034e-01},
  {-2.670714e-09,  9.680128e-01, -2.509008e-01,  0.000000e+00,  2.924270e-01, -2.782035e-01},
  {-1.927482e-01,  8.638845e-01, -4.653511e-01, -8.849757e-02,  2.924270e-01, -2.606034e-01},
  {-1.774162e-01,  9.680119e-01, -1.774162e-01, -1.635223e-01,  2.924270e-01, -2.104736e-01},
  {-4.653511e-01,  8.638845e-01, -1.927482e-01, -2.136522e-01,  2.924270e-01, -1.354488e-01},
  {-2.509007e-01,  9.680128e-01,  5.341427e-09, -2.312523e-01,  2.924270e-01, -4.695122e-02},
  {-4.653512e-01,  8.638845e-01,  1.927482e-01, -2.136522e-01,  2.924270e-01,  4.154635e-02},
  {-1.774162e-01,  9.680119e-01,  1.774162e-01, -1.635223e-01,  2.924270e-01,  1.165711e-01},
  {-1.927482e-01,  8.638846e-01,  4.653511e-01, -8.849757e-02,  2.924270e-01,  1.667010e-01},
  { 2.670714e-09,  9.680128e-01,  2.509007e-01,  0.000000e+00,  2.924270e-01,  1.843011e-01},
  { 1.927482e-01,  8.638845e-01,  4.653511e-01,  8.849757e-02,  2.924270e-01,  1.667010e-01},
  { 1.774162e-01,  9.680119e-01,  1.774162e-01,  1.635223e-01,  2.924270e-01,  1.165711e-01},
  { 4.653511e-01,  8.638846e-01,  1.927482e-01,  2.136522e-01,  2.924270e-01,  4.154635e-02},
  {-5.620446e-01,  8.049180e-01,  1.902967e-01,  1.558017e-01,  2.924270e-01, -1.114876e-01},
  {-8.257936e-01,  5.613095e-01, -5.474065e-02,  1.686358e-01,  2.924270e-01, -4.695122e-02},
  {-6.226373e-01,  5.613120e-01,  5.452079e-01,  1.192456e-01,  2.924270e-01, -1.661968e-01},
  {-2.628463e-01,  8.049180e-01,  5.319951e-01,  6.453641e-02,  2.924270e-01, -2.027530e-01},
  {-5.474059e-02,  5.613095e-01,  8.257936e-01,  0.000000e+00,  2.924270e-01, -2.155870e-01},
  { 1.902967e-01,  8.049181e-01,  5.620446e-01, -6.453641e-02,  2.924270e-01, -2.027530e-01},
  { 5.452080e-01,  5.613120e-01,  6.226373e-01, -1.192456e-01,  2.924270e-01, -1.661968e-01},
  { 5.319951e-01,  8.049180e-01,  2.628463e-01, -1.558017e-01,  2.924270e-01, -1.114876e-01},
  { 8.257936e-01,  5.613095e-01,  5.474065e-02, -1.686358e-01,  2.924270e-01, -4.695122e-02},
  { 5.620446e-01,  8.049180e-01, -1.902967e-01, -1.558017e-01,  2.924270e-01,  1.758519e-02},
  { 6.226373e-01,  5.613120e-01, -5.452080e-01, -1.192456e-01,  2.924270e-01,  7.229433e-02},
  { 2.628463e-01,  8.049181e-01, -5.319951e-01, -6.453641e-02,  2.924270e-01,  1.088505e-01},
  { 5.474062e-02,  5.613095e-01, -8.257936e-01,  0.000000e+00,  2.924270e-01,  1.216846e-01},
  {-1.902967e-01,  8.049181e-01, -5.620446e-01,  6.453641e-02,  2.924270e-01,  1.088505e-01},
  {-5.452080e-01,  5.613120e-01, -6.226373e-01,  1.192456e-01,  2.924270e-01,  7.229433e-02},
  {-5.319951e-01,  8.049180e-01, -2.628463e-01,  1.558017e-01,  2.924270e-01,  1.758519e-02},
  {-5.920915e-01, -8.049144e-01,  3.924888e-02,  1.686358e-01,  1.833412e-01, -4.695122e-02},
  {-6.284711e-01, -7.131659e-01,  3.105129e-01,  1.558017e-01,  1.833412e-01, -1.114876e-01},
  {-5.452080e-01, -5.613120e-01,  6.226373e-01,  1.192456e-01,  1.833412e-01, -1.661968e-01},
  {-2.248065e-01, -7.131661e-01,  6.639701e-01,  6.453641e-02,  1.833412e-01, -2.027530e-01},
  { 3.924883e-02, -8.049144e-01,  5.920915e-01,  0.000000e+00,  1.833412e-01, -2.155870e-01},
  { 3.105129e-01, -7.131659e-01,  6.284711e-01, -6.453641e-02,  1.833412e-01, -2.027530e-01},
  { 6.226373e-01, -5.613120e-01,  5.452079e-01, -1.192456e-01,  1.833412e-01, -1.661968e-01},
  { 6.639701e-01, -7.131659e-01,  2.248066e-01, -1.558017e-01,  1.833412e-01, -1.114876e-01},
  { 5.920915e-01, -8.049144e-01, -3.924888e-02, -1.686358e-01,  1.833412e-01, -4.695122e-02},
  { 6.284711e-01, -7.131659e-01, -3.105129e-01, -1.558017e-01,  1.833412e-01,  1.758519e-02},
  { 5.452080e-01, -5.613120e-01, -6.226373e-01, -1.192456e-01,  1.833412e-01,  7.229433e-02},
  { 2.248065e-01, -7.131661e-01, -6.639701e-01, -6.453641e-02,  1.833412e-01,  1.088505e-01},
  {-3.924885e-02, -8.049144e-01, -5.920915e-01,  0.000000e+00,  1.833412e-01,  1.216846e-01},
  {-3.105128e-01, -7.131661e-01, -6.284712e-01,  6.453641e-02,  1.833412e-01,  1.088505e-01},
  {-6.226373e-01, -5.613120e-01, -5.452080e-01,  1.192456e-01,  1.833412e-01,  7.229433e-02},
  {-6.639701e-01, -7.131659e-01, -2.248066e-01,  1.558017e-01,  1.833412e-01,  1.758519e-02},
  {-8.257903e-01, -5.613129e-01, -5.475459e-02,  2.253246e-01,  1.833412e-01, -4.695122e-02},
  {-6.639647e-01, -7.131643e-01,  2.248279e-01,  2.081727e-01,  1.833412e-01, -1.331778e-01},
  {-4.464286e-01, -8.049165e-01,  3.909103e-01,  1.593277e-01,  1.833412e-01, -2.062790e-01},
  {-3.105211e-01, -7.131643e-01,  6.284692e-01,  8.622658e-02,  1.833412e-01, -2.551239e-01},
  {-5.475464e-02, -5.613129e-01,  8.257903e-01,  0.000000e+00,  1.833412e-01, -2.722758e-01},
  { 2.248279e-01, -7.131643e-01,  6.639647e-01, -8.622658e-02,  1.833412e-01, -2.551239e-01},
  { 3.909102e-01, -8.049165e-01,  4.464286e-01, -1.593277e-01,  1.833412e-01, -2.062790e-01},
  { 6.284691e-01, -7.131643e-01,  3.105211e-01, -2.081727e-01,  1.833412e-01, -1.331778e-01},
  { 8.257903e-01, -5.613129e-01,  5.475461e-02, -2.253246e-01,  1.833412e-01, -4.695122e-02},
  { 6.639647e-01, -7.131643e-01, -2.248279e-01, -2.081727e-01,  1.833412e-01,  3.927536e-02},
  { 4.464286e-01, -8.049165e-01, -3.909103e-01, -1.593277e-01,  1.833412e-01,  1.123765e-01},
  { 3.105211e-01, -7.131643e-01, -6.284690e-01, -8.622658e-02,  1.833412e-01,  1.612214e-01},
  { 5.475459e-02, -5.613129e-01, -8.257903e-01,  0.000000e+00,  1.833412e-01,  1.783734e-01},
  {-2.248279e-01, -7.131643e-01, -6.639647e-01,  8.622658e-02,  1.833412e-01,  1.612214e-01},
  {-3.909103e-01, -8.049165e-01, -4.464286e-01,  1.593277e-01,  1.833412e-01,  1.123765e-01},
  {-6.284690e-01, -7.131643e-01, -3.105211e-01,  2.081727e-01,  1.833412e-01,  3.927536e-02},
  {-5.920874e-01,  8.049169e-01,  3.925877e-02,  2.253246e-01,  1.636379e-02, -4.695122e-02},
  {-7.419768e-01,  5.613125e-01,  3.666043e-01,  2.081727e-01,  1.636379e-02, -1.331778e-01},
  {-3.909102e-01,  8.049165e-01,  4.464286e-01,  1.593277e-01,  1.636379e-02, -2.062790e-01},
  {-2.654340e-01,  5.613125e-01,  7.838833e-01,  8.622658e-02,  1.636379e-02, -2.551239e-01},
  { 3.925879e-02,  8.049169e-01,  5.920874e-01,  0.000000e+00,  1.636379e-02, -2.722758e-01},
  { 3.666042e-01,  5.613125e-01,  7.419769e-01, -8.622658e-02,  1.636379e-02, -2.551239e-01},
  { 4.464286e-01,  8.049165e-01,  3.909103e-01, -1.593277e-01,  1.636379e-02, -2.062790e-01},
  { 7.838833e-01,  5.613125e-01,  2.654340e-01, -2.081727e-01,  1.636379e-02, -1.331778e-01},
  { 5.920874e-01,  8.049169e-01, -3.925876e-02, -2.253246e-01,  1.636379e-02, -4.695122e-02},
  { 7.419767e-01,  5.613125e-01, -3.666043e-01, -2.081727e-01,  1.636379e-02,  3.927536e-02},
  { 3.909103e-01,  8.049165e-01, -4.464286e-01, -1.593277e-01,  1.636379e-02,  1.123765e-01},
  { 2.654340e-01,  5.613125e-01, -7.838833e-01, -8.622658e-02,  1.636379e-02,  1.612214e-01},
  {-3.925876e-02,  8.049169e-01, -5.920874e-01,  0.000000e+00,  1.636379e-02,  1.783734e-01},
  {-3.666043e-01,  5.613125e-01, -7.419767e-01,  8.622658e-02,  1.636379e-02,  1.612214e-01},
  {-4.464286e-01,  8.049165e-01, -3.909103e-01,  1.593277e-01,  1.636379e-02,  1.123765e-01},
  {-7.838833e-01,  5.613125e-01, -2.654340e-01,  2.081727e-01,  1.636379e-02,  3.927536e-02},
  {-5.620412e-01,  8.049191e-01,  1.903028e-01,  1.032104e-01,  1.636379e-02, -8.970033e-02},
  {-8.257937e-01,  5.613095e-01, -5.474025e-02,  1.117117e-01,  1.636379e-02, -4.695122e-02},
  {-6.226313e-01,  5.613094e-01,  5.452175e-01,  7.899154e-02,  1.636379e-02, -1.259428e-01},
  {-2.628591e-01,  8.049190e-01,  5.319872e-01,  4.274911e-02,  1.636379e-02, -1.501616e-01},
  {-5.474032e-02,  5.613095e-01,  8.257936e-01,  0.000000e+00,  1.636379e-02, -1.586629e-01},
  { 1.903029e-01,  8.049190e-01,  5.620411e-01, -4.274911e-02,  1.636379e-02, -1.501616e-01},
  { 5.452172e-01,  5.613094e-01,  6.226315e-01, -7.899154e-02,  1.636379e-02, -1.259428e-01},
  { 5.319872e-01,  8.049191e-01,  2.628592e-01, -1.032104e-01,  1.636379e-02, -8.970033e-02},
  { 8.257937e-01,  5.613095e-01,  5.474020e-02, -1.117117e-01,  1.636379e-02, -4.695122e-02},
  { 5.620412e-01,  8.049190e-01, -1.903028e-01, -1.032104e-01,  1.636379e-02, -4.202108e-03},
  { 6.226314e-01,  5.613094e-01, -5.452173e-01, -7.899154e-02,  1.636379e-02,  3.204032e-02},
  { 2.628591e-01,  8.049190e-01, -5.319872e-01, -4.274911e-02,  1.636379e-02,  5.625921e-02},
  { 5.474023e-02,  5.613095e-01, -8.257936e-01,  0.000000e+00,  1.636379e-02,  6.476048e-02},
  {-1.903028e-01,  8.049191e-01, -5.620412e-01,  4.274911e-02,  1.636379e-02,  5.625921e-02},
  {-5.452173e-01,  5.613094e-01, -6.226314e-01,  7.899154e-02,  1.636379e-02,  3.204032e-02},
  {-5.319872e-01,  8.049190e-01, -2.628591e-01,  1.032104e-01,  1.636379e-02, -4.202108e-03},
  {-8.257937e-01, -5.613095e-01,  5.474020e-02,  1.117117e-01, -1.510880e-01, -4.695122e-02},
  {-5.319872e-01, -8.049191e-01,  2.628592e-01,  1.032104e-01, -1.510880e-01, -8.970033e-02},
  {-5.452172e-01, -5.613094e-01,  6.226314e-01,  7.899154e-02, -1.510880e-01, -1.259428e-01},
  {-1.903029e-01, -8.049190e-01,  5.620411e-01,  4.274911e-02, -1.510880e-01, -1.501616e-01},
  { 5.474032e-02, -5.613095e-01,  8.257936e-01,  0.000000e+00, -1.510880e-01, -1.586629e-01},
  { 2.628591e-01, -8.049190e-01,  5.319872e-01, -4.274911e-02, -1.510880e-01, -1.501616e-01},
  { 6.226313e-01, -5.613094e-01,  5.452175e-01, -7.899154e-02, -1.510880e-01, -1.259428e-01},
  { 5.620411e-01, -8.049191e-01,  1.903028e-01, -1.032104e-01, -1.510880e-01, -8.970033e-02},
  { 8.257937e-01, -5.613095e-01, -5.474025e-02, -1.117117e-01, -1.510880e-01, -4.695122e-02},
  { 5.319872e-01, -8.049190e-01, -2.628591e-01, -1.032104e-01, -1.510880e-01, -4.202108e-03},
  { 5.452173e-01, -5.613094e-01, -6.226314e-01, -7.899154e-02, -1.510880e-01,  3.204032e-02},
  { 1.903028e-01, -8.049190e-01, -5.620412e-01, -4.274911e-02, -1.510880e-01,  5.625921e-02},
  {-5.474023e-02, -5.613095e-01, -8.257936e-01,  0.000000e+00, -1.510880e-01,  6.476048e-02},
  {-2.628591e-01, -8.049190e-01, -5.319872e-01,  4.274911e-02, -1.510880e-01,  5.625921e-02},
  {-6.226314e-01, -5.613095e-01, -5.452173e-01,  7.899154e-02, -1.510880e-01,  3.204032e-02},
  {-5.620412e-01, -8.049190e-01, -1.903028e-01,  1.032104e-01, -1.510880e-01, -4.202108e-03},
  { 6.284776e-01, -7.131641e-01, -3.105043e-01,  4.077320e-01, -4.999835e-01, -2.179551e-01},
  { 5.920892e-01, -8.049159e-01, -3.925382e-02,  4.412366e-01, -4.999835e-01, -4.950108e-02},
  {-6.639653e-01, -7.131643e-01,  2.248258e-01,  3.269102e-01, -4.999835e-01, -1.844767e-01},
  {-8.257904e-01, -5.613127e-01, -5.475561e-02,  3.537587e-01, -4.999835e-01, -4.950108e-02},
  { 5.451992e-01, -5.613144e-01, -6.226427e-01,  3.123169e-01, -4.999835e-01, -3.607622e-01},
  {-4.464287e-01, -8.049167e-01,  3.909099e-01,  2.504549e-01, -4.999835e-01, -2.989002e-01},
  { 2.248119e-01, -7.131640e-01, -6.639704e-01,  1.695098e-01, -4.999835e-01, -4.561773e-01},
  {-3.105196e-01, -7.131643e-01,  6.284698e-01,  1.360314e-01, -4.999835e-01, -3.753555e-01},
  {-3.925517e-02, -8.049159e-01, -5.920891e-01,  1.056271e-03, -4.999835e-01, -4.896818e-01},
  {-5.475319e-02, -5.613127e-01,  8.257905e-01,  1.056271e-03, -4.999835e-01, -4.022040e-01},
  {-3.105048e-01, -7.131640e-01, -6.284775e-01, -1.673957e-01, -4.999835e-01, -4.561773e-01},
  { 2.248271e-01, -7.131643e-01,  6.639650e-01, -1.339173e-01, -4.999835e-01, -3.753555e-01},
  {-5.273591e-01, -7.131627e-01, -4.618348e-01, -3.102028e-01, -4.999835e-01, -3.607622e-01},
  { 4.617967e-01, -7.131636e-01,  5.273911e-01, -2.483408e-01, -4.999835e-01, -2.989002e-01},
  {-7.838781e-01, -5.613160e-01, -2.654420e-01, -4.056403e-01, -4.999835e-01, -2.179551e-01},
  { 5.319896e-01, -8.049172e-01,  2.628598e-01, -3.247999e-01, -4.999835e-01, -1.844767e-01},
  {-5.920890e-01, -8.049159e-01,  3.925553e-02, -4.391448e-01, -4.999835e-01, -4.950108e-02},
  { 8.257906e-01, -5.613127e-01,  5.475256e-02, -3.516483e-01, -4.999835e-01, -4.950108e-02},
  {-7.419608e-01, -5.613155e-01,  3.666323e-01, -4.056403e-01, -4.999835e-01,  1.189504e-01},
  { 5.620400e-01, -8.049167e-01, -1.903157e-01, -3.247999e-01, -4.999835e-01,  8.547204e-02},
  {-3.909217e-01, -8.049133e-01,  4.464243e-01, -3.102028e-01, -4.999835e-01,  2.617612e-01},
  { 6.226360e-01, -5.613123e-01, -5.452091e-01, -2.483408e-01, -4.999835e-01,  1.998992e-01},
  {-2.654387e-01, -5.613152e-01,  7.838797e-01, -1.673957e-01, -4.999835e-01,  3.571950e-01},
  { 2.628526e-01, -8.049166e-01, -5.319942e-01, -1.339173e-01, -4.999835e-01,  2.763546e-01},
  { 3.925414e-02, -8.049159e-01,  5.920891e-01,  1.056271e-03, -4.999835e-01,  3.906996e-01},
  { 5.475498e-02, -5.613127e-01, -8.257905e-01,  1.056271e-03, -4.999835e-01,  3.032030e-01},
  { 3.666288e-01, -5.613154e-01,  7.419626e-01,  1.695098e-01, -4.999835e-01,  3.571950e-01},
  {-1.903133e-01, -8.049167e-01, -5.620410e-01,  1.360314e-01, -4.999835e-01,  2.763546e-01},
  { 5.274095e-01, -7.131636e-01,  4.617758e-01,  3.123169e-01, -4.999835e-01,  2.617612e-01},
  {-4.618025e-01, -7.131647e-01, -5.273846e-01,  2.504549e-01, -4.999835e-01,  1.998992e-01},
  { 6.639714e-01, -7.131636e-01,  2.248106e-01,  4.077320e-01, -4.999835e-01,  1.189504e-01},
  {-6.284732e-01, -7.131637e-01, -3.105141e-01,  3.269102e-01, -4.999835e-01,  8.547204e-02},
  { 6.639704e-01,  7.131640e-01, -2.248117e-01,  4.077320e-01, -4.288283e-01, -2.179551e-01},
  {-6.284698e-01,  7.131643e-01,  3.105195e-01,  3.269102e-01, -4.288283e-01, -1.844767e-01},
  { 3.351339e-01,  8.626956e-01,  3.787369e-01,  4.412366e-01, -4.288283e-01, -4.950108e-02},
  {-8.257906e-01,  5.613127e-01,  5.475262e-02,  3.537587e-01, -4.288283e-01, -4.950108e-02},
  { 6.226427e-01,  5.613144e-01, -5.451992e-01,  3.123169e-01, -4.288283e-01, -3.607622e-01},
  {-3.909099e-01,  8.049167e-01,  4.464287e-01,  2.504549e-01, -4.288283e-01, -2.989002e-01},
  { 3.105044e-01,  7.131640e-01, -6.284775e-01,  1.695098e-01, -4.288283e-01, -4.561773e-01},
  {-2.248261e-01,  7.131643e-01,  6.639653e-01,  1.360314e-01, -4.288283e-01, -3.753555e-01},
  {-3.189170e-01,  8.834619e-01, -3.432012e-01,  1.056271e-03, -4.288283e-01, -4.896818e-01},
  { 5.475504e-02,  5.613128e-01,  8.257905e-01,  1.056271e-03, -4.288283e-01, -4.022040e-01},
  {-2.248127e-01,  7.131640e-01, -6.639701e-01, -1.673957e-01, -4.288283e-01, -4.561773e-01},
  { 3.105201e-01,  7.131643e-01,  6.284696e-01, -1.339173e-01, -4.288283e-01, -3.753555e-01},
  {-4.617776e-01,  7.131627e-01, -5.274092e-01, -3.102028e-01, -4.288283e-01, -3.607622e-01},
  { 5.273807e-01,  7.131636e-01,  4.618087e-01, -2.483408e-01, -4.288283e-01, -2.989002e-01},
  {-7.419578e-01,  5.613160e-01, -3.666375e-01, -4.056403e-01, -4.288283e-01, -2.179551e-01},
  { 5.620389e-01,  8.049172e-01,  1.903169e-01, -3.247999e-01, -4.288283e-01, -1.844767e-01},
  {-3.432011e-01,  8.834618e-01,  3.189173e-01, -4.391448e-01, -4.288283e-01, -4.950108e-02},
  { 8.257904e-01,  5.613127e-01, -5.475554e-02, -3.516483e-01, -4.288283e-01, -4.950108e-02},
  {-7.838790e-01,  5.613154e-01,  2.654406e-01, -4.056403e-01, -4.288283e-01,  1.189504e-01},
  { 5.319926e-01,  8.049167e-01, -2.628553e-01, -3.247999e-01, -4.288283e-01,  8.547204e-02},
  {-4.464220e-01,  8.049133e-01,  3.909244e-01, -3.102028e-01, -4.288283e-01,  2.617612e-01},
  { 5.452045e-01,  5.613123e-01, -6.226400e-01, -2.483408e-01, -4.288283e-01,  1.998992e-01},
  {-4.429885e-01,  0.000000e+00,  8.965273e-01, -1.673957e-01, -4.288283e-01,  3.571950e-01},
  { 1.903142e-01,  8.049166e-01, -5.620407e-01, -1.339173e-01, -4.288283e-01,  2.763546e-01},
  {-3.787367e-01,  8.626956e-01,  3.351339e-01,  1.056271e-03, -4.288283e-01,  3.906996e-01},
  {-5.475312e-02,  5.613127e-01, -8.257906e-01,  1.056271e-03, -4.288283e-01,  3.032030e-01},
  { 2.654378e-01,  5.613154e-01,  7.838800e-01,  1.695098e-01, -4.288283e-01,  3.571950e-01},
  {-2.628522e-01,  8.049167e-01, -5.319943e-01,  1.360314e-01, -4.288283e-01,  2.763546e-01},
  { 4.618299e-01,  7.131636e-01,  5.273622e-01,  3.123169e-01, -4.288283e-01,  2.617612e-01},
  {-5.273916e-01,  7.131647e-01, -4.617945e-01,  2.504549e-01, -4.288283e-01,  1.998992e-01},
  { 6.284803e-01,  7.131636e-01,  3.105001e-01,  4.077320e-01, -4.288283e-01,  1.189504e-01},
  {-6.639666e-01,  7.131638e-01, -2.248243e-01,  3.269102e-01, -4.288283e-01,  8.547204e-02},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01,  5.141472e-01, -4.288283e-01, -6.772739e-02},
  {-6.666667e-01,  6.666667e-01, -3.333333e-01,  4.412366e-01, -4.288283e-01, -6.772739e-02},
  { 6.666667e-01,  6.666667e-01,  3.333333e-01,  5.141472e-01, -4.288283e-01, -4.950108e-02},
  { 4.082483e-01, -4.082483e-01,  8.164966e-01,  5.141472e-01, -6.565322e-01, -4.950108e-02},
  {-6.666667e-01, -6.666667e-01,  3.333333e-01,  4.412366e-01, -6.565322e-01, -4.950108e-02},
  { 6.666667e-01, -6.666667e-01, -3.333333e-01,  5.141472e-01, -6.565322e-01, -6.772739e-02},
  {-4.082483e-01, -4.082483e-01, -8.164966e-01,  4.412366e-01, -6.565322e-01, -6.772739e-02},
  {-4.082483e-01,  4.082483e-01, -8.164966e-01, -5.120555e-01, -4.288283e-01, -6.772739e-02},
  {-6.666667e-01,  6.666667e-01,  3.333333e-01, -5.120555e-01, -4.288283e-01, -4.950108e-02},
  { 6.666667e-01,  6.666667e-01, -3.333333e-01, -4.391448e-01, -4.288283e-01, -6.772739e-02},
  {-4.082483e-01, -4.082483e-01,  8.164966e-01, -5.120555e-01, -6.565322e-01, -4.950108e-02},
  {-6.666667e-01, -6.666667e-01, -3.333333e-01, -5.120555e-01, -6.565322e-01, -6.772739e-02},
  { 6.666667e-01, -6.666667e-01,  3.333333e-01, -4.391448e-01, -6.565322e-01, -4.950108e-02},
  { 4.082483e-01, -4.082483e-01, -8.164966e-01, -4.391448e-01, -6.565322e-01, -6.772739e-02},
  { 8.164966e-01,  4.082483e-01,  4.082483e-01,  1.928248e-02, -4.288283e-01,  4.635729e-01},
  { 3.333333e-01,  6.666667e-01, -6.666667e-01,  1.928248e-02, -4.288283e-01,  3.906996e-01},
  {-3.333333e-01,  6.666667e-01,  6.666667e-01,  1.056271e-03, -4.288283e-01,  4.635729e-01},
  {-8.164966e-01, -4.082483e-01,  4.082483e-01,  1.056271e-03, -6.565322e-01,  4.635729e-01},
  {-3.333333e-01, -6.666667e-01, -6.666667e-01,  1.056271e-03, -6.565322e-01,  3.906996e-01},
  { 3.333333e-01, -6.666667e-01,  6.666667e-01,  1.928248e-02, -6.565322e-01,  4.635729e-01},
  { 8.164966e-01, -4.082483e-01, -4.082483e-01,  1.928248e-02, -6.565322e-01,  3.906996e-01},
  { 8.164966e-01,  4.082483e-01, -4.082483e-01,  1.928248e-02, -4.288283e-01, -5.625925e-01},
  {-3.333333e-01,  6.666667e-01, -6.666667e-01,  1.056271e-03, -4.288283e-01, -5.625925e-01},
  { 3.333333e-01,  6.666667e-01,  6.666667e-01,  1.928248e-02, -4.288283e-01, -4.896818e-01},
  {-8.164966e-01, -4.082483e-01, -4.082483e-01,  1.056271e-03, -6.565322e-01, -5.625925e-01},
  { 3.333333e-01, -6.666667e-01, -6.666667e-01,  1.928248e-02, -6.565322e-01, -5.625925e-01},
  {-3.333333e-01, -6.666667e-01,  6.666667e-01,  1.056271e-03, -6.565322e-01, -4.896818e-01},
  { 8.164966e-01, -4.082483e-01,  4.082483e-01,  1.928248e-02, -6.565322e-01, -4.896818e-01},
  {-5.466355e-02,  4.082215e-01, -9.112448e-01,  4.363061e-01, -4.288283e-01, -3.218304e-01},
  {-7.441235e-01,  6.665756e-01,  4.424154e-02,  3.731592e-01, -4.288283e-01, -2.853788e-01},
  { 7.439800e-01,  6.667044e-01, -4.470924e-02,  4.454199e-01, -4.288283e-01, -3.060493e-01},
  { 5.447051e-02,  4.083241e-01,  9.112105e-01,  3.822581e-01, -4.288283e-01, -2.695940e-01},
  { 5.029260e-01, -4.082215e-01, -7.618535e-01,  4.363061e-01, -6.565322e-01, -3.218304e-01},
  { 6.219467e-01, -6.667044e-01,  4.107158e-01,  4.454199e-01, -6.565322e-01, -3.060493e-01},
  {-6.219952e-01, -6.665756e-01, -4.108514e-01,  3.731592e-01, -6.565322e-01, -2.853788e-01},
  {-5.034043e-01, -4.083241e-01,  7.614825e-01,  3.822581e-01, -6.565322e-01, -2.695940e-01},
  { 5.029473e-01,  4.082621e-01, -7.618176e-01, -3.892802e-01, -4.288283e-01,  1.548081e-01},
  {-6.220590e-01,  6.666667e-01, -4.106068e-01, -4.524047e-01, -4.288283e-01,  1.912635e-01},
  { 6.220425e-01,  6.666582e-01,  4.106458e-01, -3.801664e-01, -4.288283e-01,  1.705930e-01},
  {-5.028966e-01,  4.082422e-01,  7.618617e-01, -4.432909e-01, -4.288283e-01,  2.070446e-01},
  {-5.478838e-02, -4.082621e-01, -9.112191e-01, -3.892802e-01, -6.565322e-01,  1.548081e-01},
  { 7.440230e-01, -6.666582e-01, -4.468326e-02, -3.801664e-01, -6.565322e-01,  1.705930e-01},
  {-7.440113e-01, -6.666667e-01,  4.475028e-02, -4.524047e-01, -6.565322e-01,  1.912635e-01},
  { 5.477529e-02, -4.082422e-01,  9.112288e-01, -4.432909e-01, -6.565322e-01,  2.070446e-01},
  { 5.472425e-02,  4.082403e-01,  9.112328e-01,  2.576040e-01, -4.288283e-01,  3.948456e-01},
  { 7.440030e-01,  6.666782e-01, -4.471874e-02,  2.733889e-01, -4.288283e-01,  3.857318e-01},
  {-7.440405e-01,  6.666340e-01,  4.475160e-02,  2.211524e-01, -4.288283e-01,  3.317211e-01},
  {-5.493026e-02,  4.082758e-01, -9.112045e-01,  2.369335e-01, -4.288283e-01,  3.226036e-01},
  {-5.029333e-01, -4.082403e-01,  7.618385e-01,  2.576040e-01, -6.565322e-01,  3.948456e-01},
  {-6.221377e-01, -6.666340e-01, -4.105408e-01,  2.211524e-01, -6.565322e-01,  3.317211e-01},
  { 6.220145e-01, -6.666781e-01,  4.106558e-01,  2.733889e-01, -6.565322e-01,  3.857318e-01},
  { 5.028707e-01, -4.082758e-01, -7.618609e-01,  2.369335e-01, -6.565322e-01,  3.226036e-01},
  {-5.030804e-01,  4.082753e-01,  7.617226e-01, -2.190383e-01, -4.288283e-01, -4.307034e-01},
  { 6.220230e-01,  6.666372e-01,  4.107093e-01, -2.032534e-01, -4.288283e-01, -4.398172e-01},
  {-6.220222e-01,  6.666375e-01, -4.107101e-01, -2.554899e-01, -4.288283e-01, -4.938652e-01},
  { 5.030808e-01,  4.082751e-01, -7.617226e-01, -2.397050e-01, -4.288283e-01, -5.029790e-01},
  { 5.467772e-02, -4.082753e-01,  9.112199e-01, -2.190383e-01, -6.565322e-01, -4.307034e-01},
  {-7.440491e-01, -6.666376e-01,  4.455746e-02, -2.554899e-01, -6.565322e-01, -4.938652e-01},
  { 7.440493e-01, -6.666372e-01, -4.455775e-02, -2.032534e-01, -6.565322e-01, -4.398172e-01},
  {-5.467641e-02, -4.082750e-01, -9.112201e-01, -2.397050e-01, -6.565322e-01, -5.029790e-01},
  { 5.030805e-01,  4.082754e-01,  7.617226e-01,  2.211524e-01, -4.288283e-01, -4.307034e-01},
  { 6.220224e-01,  6.666374e-01, -4.107100e-01,  2.576040e-01, -4.288283e-01, -4.938652e-01},
  {-6.220232e-01,  6.666372e-01,  4.107092e-01,  2.053676e-01, -4.288283e-01, -4.398172e-01},
  {-5.030808e-01,  4.082751e-01, -7.617225e-01,  2.418191e-01, -4.288283e-01, -5.029790e-01},
  {-5.467802e-02, -4.082753e-01,  9.112198e-01,  2.211524e-01, -6.565322e-01, -4.307034e-01},
  {-7.440494e-01, -6.666372e-01, -4.455775e-02,  2.053676e-01, -6.565322e-01, -4.398172e-01},
  { 7.440492e-01, -6.666374e-01,  4.455740e-02,  2.576040e-01, -6.565322e-01, -4.938652e-01},
  { 5.467667e-02, -4.082751e-01, -9.112200e-01,  2.418191e-01, -6.565322e-01, -5.029790e-01},
  { 5.484796e-02,  4.082678e-01, -9.112130e-01, -2.348232e-01, -4.288283e-01,  3.226036e-01},
  {-7.440104e-01,  6.666716e-01, -4.469287e-02, -2.712748e-01, -4.288283e-01,  3.857318e-01},
  { 7.440280e-01,  6.666492e-01,  4.473565e-02, -2.190383e-01, -4.288283e-01,  3.317211e-01},
  {-5.472429e-02,  4.082402e-01,  9.112328e-01, -2.554899e-01, -4.288283e-01,  3.948456e-01},
  {-5.029150e-01, -4.082678e-01, -7.618359e-01, -2.348232e-01, -6.565322e-01,  3.226036e-01},
  { 6.220928e-01, -6.666491e-01, -4.105842e-01, -2.190383e-01, -6.565322e-01,  3.317211e-01},
  {-6.220158e-01, -6.666716e-01,  4.106645e-01, -2.712748e-01, -6.565322e-01,  3.857318e-01},
  { 5.029332e-01, -4.082402e-01,  7.618386e-01, -2.554899e-01, -6.565322e-01,  3.948456e-01},
  {-7.617226e-01,  4.082753e-01,  5.030806e-01,  3.822581e-01, -4.288283e-01,  1.705930e-01},
  { 4.106660e-01,  6.666221e-01,  6.220679e-01,  4.454199e-01, -4.288283e-01,  2.070446e-01},
  {-4.107006e-01,  6.666438e-01, -6.220217e-01,  3.913719e-01, -4.288283e-01,  1.548081e-01},
  { 7.617477e-01,  4.082832e-01, -5.030361e-01,  4.545338e-01, -4.288283e-01,  1.912635e-01},
  {-9.112199e-01, -4.082753e-01, -5.467768e-02,  3.822581e-01, -6.565322e-01,  1.705930e-01},
  { 4.458366e-02, -6.666438e-01, -7.440420e-01,  3.913719e-01, -6.565322e-01,  1.548081e-01},
  {-4.457369e-02, -6.666221e-01,  7.440619e-01,  4.454199e-01, -6.565322e-01,  2.070446e-01},
  { 9.112114e-01, -4.082832e-01,  5.476006e-02,  4.545338e-01, -6.565322e-01,  1.912635e-01},
  { 9.111931e-01,  4.082954e-01,  5.497148e-02, -3.710451e-01, -4.288283e-01, -2.853788e-01},
  { 4.469381e-02,  6.666527e-01, -7.440273e-01, -4.341771e-01, -4.288283e-01, -3.218304e-01},
  {-4.478930e-02,  6.666296e-01,  7.440423e-01, -3.801664e-01, -4.288283e-01, -2.695940e-01},
  {-9.112243e-01,  4.082482e-01, -5.480658e-02, -4.432909e-01, -4.288283e-01, -3.060493e-01},
  { 7.618330e-01, -4.082955e-01, -5.028970e-01, -3.710451e-01, -6.565322e-01, -2.853788e-01},
  { 4.105003e-01, -6.666296e-01,  6.221693e-01, -3.801664e-01, -6.565322e-01, -2.695940e-01},
  {-4.106261e-01, -6.666527e-01, -6.220614e-01, -4.341771e-01, -6.565322e-01, -3.218304e-01},
  {-7.618636e-01, -4.082482e-01,  5.028889e-01, -4.432909e-01, -6.565322e-01, -3.060493e-01},
  {-4.106261e-01,  6.666527e-01, -6.220614e-01, -4.341771e-01,  3.244375e-01, -3.218304e-01},
  { 7.618330e-01,  4.082954e-01, -5.028970e-01, -3.710451e-01,  3.244375e-01, -2.853788e-01},
  { 4.469384e-02, -6.666527e-01, -7.440273e-01, -4.341771e-01,  9.675229e-02, -3.218304e-01},
  { 9.111933e-01, -4.082954e-01,  5.497150e-02, -3.710451e-01,  9.675229e-02, -2.853788e-01},
  { 4.105004e-01,  6.666296e-01,  6.221693e-01, -3.801664e-01,  3.244375e-01, -2.695940e-01},
  {-7.618636e-01,  4.082482e-01,  5.028889e-01, -4.432909e-01,  3.244375e-01, -3.060493e-01},
  {-4.478928e-02, -6.666295e-01,  7.440424e-01, -3.801664e-01,  9.675229e-02, -2.695940e-01},
  {-9.112243e-01, -4.082482e-01, -5.480658e-02, -4.432909e-01,  9.675229e-02, -3.060493e-01},
  { 9.112114e-01,  4.082832e-01,  5.476004e-02,  4.545338e-01,  3.244375e-01,  1.912635e-01},
  { 7.617477e-01, -4.082832e-01, -5.030361e-01,  4.545338e-01,  9.675229e-02,  1.912635e-01},
  { 4.458366e-02,  6.666438e-01, -7.440419e-01,  3.913719e-01,  3.244375e-01,  1.548081e-01},
  {-4.107006e-01, -6.666438e-01, -6.220217e-01,  3.913719e-01,  9.675229e-02,  1.548081e-01},
  {-9.112199e-01,  4.082753e-01, -5.467770e-02,  3.822581e-01,  3.244375e-01,  1.705930e-01},
  {-7.617226e-01, -4.082753e-01,  5.030805e-01,  3.822581e-01,  9.675229e-02,  1.705930e-01},
  {-4.457366e-02,  6.666221e-01,  7.440619e-01,  4.454199e-01,  3.244375e-01,  2.070446e-01},
  { 4.106660e-01, -6.666221e-01,  6.220678e-01,  4.454199e-01,  9.675229e-02,  2.070446e-01},
  {-6.220158e-01,  6.666716e-01,  4.106644e-01, -2.712748e-01,  3.244375e-01,  3.857318e-01},
  {-5.029150e-01,  4.082678e-01, -7.618358e-01, -2.348232e-01,  3.244375e-01,  3.226036e-01},
  {-7.440104e-01, -6.666716e-01, -4.469289e-02, -2.712748e-01,  9.675229e-02,  3.857318e-01},
  { 5.484791e-02, -4.082678e-01, -9.112130e-01, -2.348232e-01,  9.675229e-02,  3.226036e-01},
  { 6.220928e-01,  6.666492e-01, -4.105843e-01, -2.190383e-01,  3.244375e-01,  3.317211e-01},
  { 5.029333e-01,  4.082403e-01,  7.618386e-01, -2.554899e-01,  3.244375e-01,  3.948456e-01},
  { 7.440280e-01, -6.666492e-01,  4.473563e-02, -2.190383e-01,  9.675229e-02,  3.317211e-01},
  {-5.472430e-02, -4.082403e-01,  9.112328e-01, -2.554899e-01,  9.675229e-02,  3.948456e-01},
  { 5.467670e-02,  4.082751e-01, -9.112200e-01,  2.418191e-01,  3.244375e-01, -5.029790e-01},
  {-5.030808e-01, -4.082751e-01, -7.617225e-01,  2.418191e-01,  9.675229e-02, -5.029790e-01},
  {-7.440494e-01,  6.666372e-01, -4.455771e-02,  2.053676e-01,  3.244375e-01, -4.398172e-01},
  {-6.220232e-01, -6.666372e-01,  4.107092e-01,  2.053676e-01,  9.675229e-02, -4.398172e-01},
  {-5.467800e-02,  4.082754e-01,  9.112198e-01,  2.211524e-01,  3.244375e-01, -4.307034e-01},
  { 5.030804e-01, -4.082754e-01,  7.617226e-01,  2.211524e-01,  9.675229e-02, -4.307034e-01},
  { 7.440491e-01,  6.666375e-01,  4.455741e-02,  2.576040e-01,  3.244375e-01, -4.938652e-01},
  { 6.220224e-01, -6.666375e-01, -4.107100e-01,  2.576040e-01,  9.675229e-02, -4.938652e-01},
  {-5.467644e-02,  4.082751e-01, -9.112200e-01, -2.397050e-01,  3.244375e-01, -5.029790e-01},
  { 7.440493e-01,  6.666372e-01, -4.455775e-02, -2.032534e-01,  3.244375e-01, -4.398172e-01},
  { 5.030807e-01, -4.082751e-01, -7.617226e-01, -2.397050e-01,  9.675229e-02, -5.029790e-01},
  { 6.220230e-01, -6.666372e-01,  4.107093e-01, -2.032534e-01,  9.675229e-02, -4.398172e-01},
  { 5.467775e-02,  4.082753e-01,  9.112199e-01, -2.190383e-01,  3.244375e-01, -4.307034e-01},
  {-7.440490e-01,  6.666376e-01,  4.455743e-02, -2.554899e-01,  3.244375e-01, -4.938652e-01},
  {-5.030804e-01, -4.082753e-01,  7.617227e-01, -2.190383e-01,  9.675229e-02, -4.307034e-01},
  {-6.220222e-01, -6.666375e-01, -4.107101e-01, -2.554899e-01,  9.675229e-02, -4.938652e-01},
  { 6.220146e-01,  6.666782e-01,  4.106557e-01,  2.733889e-01,  3.244375e-01,  3.857318e-01},
  { 7.440030e-01, -6.666782e-01, -4.471880e-02,  2.733889e-01,  9.675229e-02,  3.857318e-01},
  { 5.028707e-01,  4.082757e-01, -7.618609e-01,  2.369335e-01,  3.244375e-01,  3.226036e-01},
  {-5.493026e-02, -4.082758e-01, -9.112045e-01,  2.369335e-01,  9.675229e-02,  3.226036e-01},
  {-6.221377e-01,  6.666340e-01, -4.105408e-01,  2.211524e-01,  3.244375e-01,  3.317211e-01},
  {-7.440405e-01, -6.666340e-01,  4.475164e-02,  2.211524e-01,  9.675229e-02,  3.317211e-01},
  {-5.029333e-01,  4.082403e-01,  7.618385e-01,  2.576040e-01,  3.244375e-01,  3.948456e-01},
  { 5.472425e-02, -4.082403e-01,  9.112328e-01,  2.576040e-01,  9.675229e-02,  3.948456e-01},
  {-7.440113e-01,  6.666667e-01,  4.475024e-02, -4.524047e-01,  3.244375e-01,  1.912635e-01},
  {-5.478838e-02,  4.082621e-01, -9.112191e-01, -3.892802e-01,  3.244375e-01,  1.548081e-01},
  {-6.220590e-01, -6.666667e-01, -4.106068e-01, -4.524047e-01,  9.675229e-02,  1.912635e-01},
  { 5.029472e-01, -4.082621e-01, -7.618176e-01, -3.892802e-01,  9.675229e-02,  1.548081e-01},
  { 7.440230e-01,  6.666582e-01, -4.468326e-02, -3.801664e-01,  3.244375e-01,  1.705930e-01},
  { 5.477534e-02,  4.082422e-01,  9.112288e-01, -4.432909e-01,  3.244375e-01,  2.070446e-01},
  { 6.220426e-01, -6.666582e-01,  4.106458e-01, -3.801664e-01,  9.675229e-02,  1.705930e-01},
  {-5.028965e-01, -4.082422e-01,  7.618617e-01, -4.432909e-01,  9.675229e-02,  2.070446e-01},
  { 5.029260e-01,  4.082215e-01, -7.618535e-01,  4.363061e-01,  3.244375e-01, -3.218304e-01},
  {-5.466353e-02, -4.082215e-01, -9.112448e-01,  4.363061e-01,  9.675229e-02, -3.218304e-01},
  {-6.219952e-01,  6.665756e-01, -4.108514e-01,  3.731592e-01,  3.244375e-01, -2.853788e-01},
  {-7.441235e-01, -6.665756e-01,  4.424156e-02,  3.731592e-01,  9.675229e-02, -2.853788e-01},
  {-5.034043e-01,  4.083241e-01,  7.614824e-01,  3.822581e-01,  3.244375e-01, -2.695940e-01},
  { 5.447051e-02, -4.083241e-01,  9.112105e-01,  3.822581e-01,  9.675229e-02, -2.695940e-01},
  { 6.219467e-01,  6.667044e-01,  4.107158e-01,  4.454199e-01,  3.244375e-01, -3.060493e-01},
  { 7.439800e-01, -6.667044e-01, -4.470925e-02,  4.454199e-01,  9.675229e-02, -3.060493e-01},
  { 3.333333e-01,  6.666667e-01, -6.666667e-01,  1.928248e-02,  3.244375e-01, -5.625925e-01},
  { 8.164966e-01,  4.082483e-01,  4.082483e-01,  1.928248e-02,  3.244375e-01, -4.896818e-01},
  { 8.164966e-01, -4.082483e-01, -4.082483e-01,  1.928248e-02,  9.675229e-02, -5.625925e-01},
  { 3.333333e-01, -6.666667e-01,  6.666667e-01,  1.928248e-02,  9.675229e-02, -4.896818e-01},
  {-3.333333e-01,  6.666667e-01,  6.666667e-01,  1.056271e-03,  3.244375e-01, -4.896818e-01},
  {-8.164966e-01,  4.082483e-01, -4.082483e-01,  1.056271e-03,  3.244375e-01, -5.625925e-01},
  {-3.189170e-01, -8.834619e-01, -3.432012e-01,  1.056271e-03,  9.675229e-02, -4.896818e-01},
  {-3.333333e-01, -6.666667e-01, -6.666667e-01,  1.056271e-03,  9.675229e-02, -5.625925e-01},
  { 3.333333e-01,  6.666667e-01,  6.666667e-01,  1.928248e-02,  3.244375e-01,  4.635729e-01},
  { 8.164966e-01, -4.082483e-01,  4.082483e-01,  1.928248e-02,  9.675229e-02,  4.635729e-01},
  { 8.164966e-01,  4.082483e-01, -4.082483e-01,  1.928248e-02,  3.244375e-01,  3.906996e-01},
  { 3.333333e-01, -6.666667e-01, -6.666667e-01,  1.928248e-02,  9.675229e-02,  3.906996e-01},
  {-3.333333e-01,  6.666667e-01, -6.666667e-01,  1.056271e-03,  3.244375e-01,  3.906996e-01},
  {-3.787367e-01, -8.626956e-01,  3.351339e-01,  1.056271e-03,  9.675229e-02,  3.906996e-01},
  {-8.164966e-01,  4.082483e-01,  4.082483e-01,  1.056271e-03,  3.244375e-01,  4.635729e-01},
  {-3.333333e-01, -6.666667e-01,  6.666667e-01,  1.056271e-03,  9.675229e-02,  4.635729e-01},
  {-6.666667e-01,  6.666667e-01, -3.333333e-01, -5.120555e-01,  3.244375e-01, -6.772739e-02},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01, -4.391448e-01,  3.244375e-01, -6.772739e-02},
  {-4.082483e-01, -4.082483e-01, -8.164966e-01, -5.120555e-01,  9.675229e-02, -6.772739e-02},
  { 6.666667e-01, -6.666667e-01, -3.333333e-01, -4.391448e-01,  9.675229e-02, -6.772739e-02},
  { 6.666667e-01,  6.666667e-01,  3.333333e-01, -4.391448e-01,  3.244375e-01, -4.950108e-02},
  {-4.082483e-01,  4.082483e-01,  8.164966e-01, -5.120555e-01,  3.244375e-01, -4.950108e-02},
  {-3.432011e-01, -8.834618e-01,  3.189173e-01, -4.391448e-01,  9.675229e-02, -4.950108e-02},
  {-6.666667e-01, -6.666667e-01,  3.333333e-01, -5.120555e-01,  9.675229e-02, -4.950108e-02},
  { 6.666667e-01,  6.666667e-01, -3.333333e-01,  5.141472e-01,  3.244375e-01, -6.772739e-02},
  { 4.082483e-01, -4.082483e-01, -8.164966e-01,  5.141472e-01,  9.675229e-02, -6.772739e-02},
  {-4.082483e-01,  4.082483e-01, -8.164966e-01,  4.412366e-01,  3.244375e-01, -6.772739e-02},
  {-6.666667e-01, -6.666667e-01, -3.333333e-01,  4.412366e-01,  9.675229e-02, -6.772739e-02},
  {-6.666667e-01,  6.666667e-01,  3.333333e-01,  4.412366e-01,  3.244375e-01, -4.950108e-02},
  { 3.351339e-01, -8.626956e-01,  3.787369e-01,  4.412366e-01,  9.675229e-02, -4.950108e-02},
  { 4.082483e-01,  4.082483e-01,  8.164966e-01,  5.141472e-01,  3.244375e-01, -4.950108e-02},
  { 6.666667e-01, -6.666667e-01,  3.333333e-01,  5.141472e-01,  9.675229e-02, -4.950108e-02},
  {-8.257906e-01, -5.613127e-01,  5.475262e-02,  3.537587e-01,  9.675229e-02, -4.950108e-02},
  {-6.639665e-01, -7.131637e-01, -2.248243e-01,  3.269102e-01,  9.675229e-02,  8.547204e-02},
  {-8.257904e-01,  5.613127e-01, -5.475561e-02,  3.537587e-01,  1.679074e-01, -4.950108e-02},
  {-6.284732e-01,  7.131637e-01, -3.105141e-01,  3.269102e-01,  1.679074e-01,  8.547204e-02},
  {-5.273916e-01, -7.131647e-01, -4.617945e-01,  2.504549e-01,  9.675229e-02,  1.998992e-01},
  {-4.618025e-01,  7.131647e-01, -5.273845e-01,  2.504549e-01,  1.679074e-01,  1.998992e-01},
  {-2.628522e-01, -8.049167e-01, -5.319943e-01,  1.360314e-01,  9.675229e-02,  2.763546e-01},
  {-1.903133e-01,  8.049167e-01, -5.620410e-01,  1.360314e-01,  1.679074e-01,  2.763546e-01},
  {-5.475312e-02, -5.613127e-01, -8.257906e-01,  1.056271e-03,  9.675229e-02,  3.032030e-01},
  { 5.475497e-02,  5.613127e-01, -8.257905e-01,  1.056271e-03,  1.679074e-01,  3.032030e-01},
  { 1.903142e-01, -8.049166e-01, -5.620407e-01, -1.339173e-01,  9.675229e-02,  2.763546e-01},
  { 2.628526e-01,  8.049166e-01, -5.319942e-01, -1.339173e-01,  1.679074e-01,  2.763546e-01},
  { 5.452045e-01, -5.613123e-01, -6.226401e-01, -2.483408e-01,  9.675229e-02,  1.998992e-01},
  { 6.226360e-01,  5.613123e-01, -5.452091e-01, -2.483408e-01,  1.679074e-01,  1.998992e-01},
  { 5.319926e-01, -8.049167e-01, -2.628552e-01, -3.247999e-01,  9.675229e-02,  8.547204e-02},
  { 5.620400e-01,  8.049167e-01, -1.903157e-01, -3.247999e-01,  1.679074e-01,  8.547204e-02},
  { 8.257904e-01, -5.613127e-01, -5.475554e-02, -3.516483e-01,  9.675229e-02, -4.950108e-02},
  { 8.257906e-01,  5.613127e-01,  5.475256e-02, -3.516483e-01,  1.679074e-01, -4.950108e-02},
  { 5.620389e-01, -8.049172e-01,  1.903169e-01, -3.247999e-01,  9.675229e-02, -1.844767e-01},
  { 5.319897e-01,  8.049172e-01,  2.628597e-01, -3.247999e-01,  1.679074e-01, -1.844767e-01},
  { 5.273807e-01, -7.131636e-01,  4.618087e-01, -2.483408e-01,  9.675229e-02, -2.989002e-01},
  { 4.617967e-01,  7.131636e-01,  5.273912e-01, -2.483408e-01,  1.679074e-01, -2.989002e-01},
  { 3.105200e-01, -7.131642e-01,  6.284696e-01, -1.339173e-01,  9.675229e-02, -3.753555e-01},
  { 2.248271e-01,  7.131642e-01,  6.639650e-01, -1.339173e-01,  1.679074e-01, -3.753555e-01},
  { 5.475502e-02, -5.613127e-01,  8.257905e-01,  1.056271e-03,  9.675229e-02, -4.022040e-01},
  {-5.475319e-02,  5.613127e-01,  8.257906e-01,  1.056271e-03,  1.679074e-01, -4.022040e-01},
  {-2.248261e-01, -7.131643e-01,  6.639653e-01,  1.360314e-01,  9.675229e-02, -3.753555e-01},
  {-3.105196e-01,  7.131643e-01,  6.284698e-01,  1.360314e-01,  1.679074e-01, -3.753555e-01},
  {-3.909099e-01, -8.049167e-01,  4.464288e-01,  2.504549e-01,  9.675229e-02, -2.989002e-01},
  {-4.464287e-01,  8.049167e-01,  3.909099e-01,  2.504549e-01,  1.679074e-01, -2.989002e-01},
  {-6.284698e-01, -7.131643e-01,  3.105194e-01,  3.269102e-01,  9.675229e-02, -1.844767e-01},
  {-6.639654e-01,  7.131643e-01,  2.248258e-01,  3.269102e-01,  1.679074e-01, -1.844767e-01},
  { 5.920892e-01,  8.049159e-01, -3.925382e-02,  4.412366e-01,  1.679074e-01, -4.950108e-02},
  { 6.639714e-01,  7.131636e-01,  2.248106e-01,  4.077320e-01,  1.679074e-01,  1.189504e-01},
  { 6.284803e-01, -7.131636e-01,  3.105001e-01,  4.077320e-01,  9.675229e-02,  1.189504e-01},
  { 5.274095e-01,  7.131636e-01,  4.617758e-01,  3.123169e-01,  1.679074e-01,  2.617612e-01},
  { 4.618299e-01, -7.131636e-01,  5.273622e-01,  3.123169e-01,  9.675229e-02,  2.617612e-01},
  { 3.666288e-01,  5.613153e-01,  7.419626e-01,  1.695098e-01,  1.679074e-01,  3.571950e-01},
  { 2.654378e-01, -5.613153e-01,  7.838799e-01,  1.695098e-01,  9.675229e-02,  3.571950e-01},
  { 3.925414e-02,  8.049159e-01,  5.920891e-01,  1.056271e-03,  1.679074e-01,  3.906996e-01},
  {-2.654388e-01,  5.613152e-01,  7.838797e-01, -1.673957e-01,  1.679074e-01,  3.571950e-01},
  {-3.826803e-01,  0.000000e+00,  9.238808e-01, -1.673957e-01,  9.675229e-02,  3.571950e-01},
  {-3.909218e-01,  8.049133e-01,  4.464244e-01, -3.102028e-01,  1.679074e-01,  2.617612e-01},
  {-4.464221e-01, -8.049133e-01,  3.909244e-01, -3.102028e-01,  9.675229e-02,  2.617612e-01},
  {-7.419608e-01,  5.613155e-01,  3.666323e-01, -4.056403e-01,  1.679074e-01,  1.189504e-01},
  {-7.838790e-01, -5.613155e-01,  2.654406e-01, -4.056403e-01,  9.675229e-02,  1.189504e-01},
  {-5.920891e-01,  8.049159e-01,  3.925553e-02, -4.391448e-01,  1.679074e-01, -4.950108e-02},
  {-7.838782e-01,  5.613160e-01, -2.654420e-01, -4.056403e-01,  1.679074e-01, -2.179551e-01},
  {-7.419578e-01, -5.613160e-01, -3.666375e-01, -4.056403e-01,  9.675229e-02, -2.179551e-01},
  {-5.273591e-01,  7.131627e-01, -4.618349e-01, -3.102028e-01,  1.679074e-01, -3.607622e-01},
  {-4.617776e-01, -7.131627e-01, -5.274093e-01, -3.102028e-01,  9.675229e-02, -3.607622e-01},
  {-3.105048e-01,  7.131640e-01, -6.284774e-01, -1.673957e-01,  1.679074e-01, -4.561773e-01},
  {-2.248128e-01, -7.131640e-01, -6.639701e-01, -1.673957e-01,  9.675229e-02, -4.561773e-01},
  {-3.925518e-02,  8.049159e-01, -5.920891e-01,  1.056271e-03,  1.679074e-01, -4.896818e-01},
  { 2.248120e-01,  7.131640e-01, -6.639704e-01,  1.695098e-01,  1.679074e-01, -4.561773e-01},
  { 3.105044e-01, -7.131640e-01, -6.284775e-01,  1.695098e-01,  9.675229e-02, -4.561773e-01},
  { 5.451992e-01,  5.613144e-01, -6.226427e-01,  3.123169e-01,  1.679074e-01, -3.607622e-01},
  { 6.226427e-01, -5.613144e-01, -5.451992e-01,  3.123169e-01,  9.675229e-02, -3.607622e-01},
  { 6.284776e-01,  7.131640e-01, -3.105043e-01,  4.077320e-01,  1.679074e-01, -2.179551e-01},
  { 6.639704e-01, -7.131640e-01, -2.248118e-01,  4.077320e-01,  9.675229e-02, -2.179551e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  6.801759e-09,  1.203698e+00, -4.695122e-02},
  {-2.653768e-01,  5.613184e-01,  7.838984e-01, -2.615596e-02,  1.203698e+00,  1.619570e-02},
  { 5.471837e-02,  5.613042e-01,  8.257987e-01,  6.801759e-09,  1.203698e+00,  2.139507e-02},
  {-5.452179e-01,  5.613092e-01,  6.226310e-01, -4.832947e-02,  1.203698e+00,  1.378247e-03},
  {-7.419770e-01,  5.613185e-01,  3.665946e-01, -6.314692e-02,  1.203698e+00, -2.079526e-02},
  {-8.257987e-01,  5.613042e-01,  5.471832e-02, -6.834628e-02,  1.203698e+00, -4.695122e-02},
  {-7.838984e-01,  5.613184e-01, -2.653769e-01, -6.314692e-02,  1.203698e+00, -7.310717e-02},
  {-6.226311e-01,  5.613092e-01, -5.452179e-01, -4.832947e-02,  1.203698e+00, -9.528068e-02},
  {-3.665948e-01,  5.613185e-01, -7.419770e-01, -2.615596e-02,  1.203698e+00, -1.100981e-01},
  {-5.471826e-02,  5.613042e-01, -8.257987e-01,  6.801759e-09,  1.203698e+00, -1.152975e-01},
  { 2.653770e-01,  5.613185e-01, -7.838984e-01,  2.615596e-02,  1.203698e+00, -1.100981e-01},
  { 5.452180e-01,  5.613092e-01, -6.226310e-01,  4.832947e-02,  1.203698e+00, -9.528068e-02},
  { 7.419770e-01,  5.613185e-01, -3.665946e-01,  6.314692e-02,  1.203698e+00, -7.310717e-02},
  { 8.257987e-01,  5.613042e-01, -5.471832e-02,  6.834628e-02,  1.203698e+00, -4.695122e-02},
  { 7.838984e-01,  5.613184e-01,  2.653769e-01,  6.314692e-02,  1.203698e+00, -2.079526e-02},
  { 6.226311e-01,  5.613093e-01,  5.452179e-01,  4.832947e-02,  1.203698e+00,  1.378247e-03},
  { 3.665947e-01,  5.613185e-01,  7.419770e-01,  2.615596e-02,  1.203698e+00,  1.619570e-02},
  {-3.923300e-02,  8.049105e-01,  5.920979e-01,  6.801759e-09,  8.716410e-01,  2.139507e-02},
  {-3.665946e-01,  5.613184e-01,  7.419770e-01, -2.615596e-02,  8.716410e-01,  1.619570e-02},
  {-4.464246e-01,  8.049142e-01,  3.909196e-01, -4.832947e-02,  8.716410e-01,  1.378247e-03},
  {-7.838984e-01,  5.613185e-01,  2.653769e-01, -6.314692e-02,  8.716410e-01, -2.079526e-02},
  {-5.920979e-01,  8.049105e-01, -3.923305e-02, -6.834628e-02,  8.716410e-01, -4.695122e-02},
  {-7.419770e-01,  5.613185e-01, -3.665947e-01, -6.314692e-02,  8.716410e-01, -7.310717e-02},
  {-3.909197e-01,  8.049142e-01, -4.464246e-01, -4.832947e-02,  8.716410e-01, -9.528068e-02},
  {-2.653769e-01,  5.613184e-01, -7.838984e-01, -2.615596e-02,  8.716410e-01, -1.100981e-01},
  { 3.923308e-02,  8.049105e-01, -5.920979e-01,  6.801759e-09,  8.716410e-01, -1.152975e-01},
  { 3.665948e-01,  5.613185e-01, -7.419770e-01,  2.615596e-02,  8.716410e-01, -1.100981e-01},
  { 4.464247e-01,  8.049142e-01, -3.909196e-01,  4.832947e-02,  8.716410e-01, -9.528068e-02},
  { 7.838984e-01,  5.613185e-01, -2.653769e-01,  6.314692e-02,  8.716410e-01, -7.310717e-02},
  { 5.920979e-01,  8.049105e-01,  3.923305e-02,  6.834628e-02,  8.716410e-01, -4.695122e-02},
  { 7.419770e-01,  5.613185e-01,  3.665947e-01,  6.314692e-02,  8.716410e-01, -2.079526e-02},
  { 3.909196e-01,  8.049142e-01,  4.464246e-01,  4.832947e-02,  8.716410e-01,  1.378247e-03},
  { 2.653770e-01,  5.613185e-01,  7.838984e-01,  2.615596e-02,  8.716410e-01,  1.619570e-02},
  { 5.476092e-02,  5.613145e-01,  8.257889e-01,  6.801759e-09,  8.716410e-01,  3.871135e-02},
  {-1.903137e-01,  8.049147e-01,  5.620437e-01, -3.278179e-02,  8.716410e-01,  3.218973e-02},
  {-5.451925e-01,  5.613163e-01,  6.226470e-01, -6.057338e-02,  8.716410e-01,  1.362216e-02},
  {-5.320042e-01,  8.049147e-01,  2.628382e-01, -7.914095e-02,  8.716410e-01, -1.416943e-02},
  {-8.257889e-01,  5.613145e-01,  5.476093e-02, -8.566257e-02,  8.716410e-01, -4.695122e-02},
  {-5.620437e-01,  8.049147e-01, -1.903137e-01, -7.914095e-02,  8.716410e-01, -7.973301e-02},
  {-6.226470e-01,  5.613163e-01, -5.451924e-01, -6.057338e-02,  8.716410e-01, -1.075246e-01},
  {-2.628382e-01,  8.049146e-01, -5.320042e-01, -3.278179e-02,  8.716410e-01, -1.260922e-01},
  {-5.476082e-02,  5.613144e-01, -8.257890e-01,  6.801759e-09,  8.716410e-01, -1.326138e-01},
  { 1.903137e-01,  8.049146e-01, -5.620437e-01,  3.278179e-02,  8.716410e-01, -1.260922e-01},
  { 5.451925e-01,  5.613163e-01, -6.226470e-01,  6.057338e-02,  8.716410e-01, -1.075246e-01},
  { 5.320042e-01,  8.049147e-01, -2.628382e-01,  7.914095e-02,  8.716410e-01, -7.973301e-02},
  { 8.257889e-01,  5.613145e-01, -5.476089e-02,  8.566257e-02,  8.716410e-01, -4.695122e-02},
  { 5.620437e-01,  8.049147e-01,  1.903137e-01,  7.914095e-02,  8.716410e-01, -1.416943e-02},
  { 6.226470e-01,  5.613163e-01,  5.451925e-01,  6.057338e-02,  8.716410e-01,  1.362216e-02},
  { 2.628382e-01,  8.049146e-01,  5.320042e-01,  3.278179e-02,  8.716410e-01,  3.218973e-02},
  {-5.476084e-02,  5.613145e-01,  8.257889e-01,  6.801759e-09,  7.037075e-01,  3.871135e-02},
  {-3.105028e-01,  7.131618e-01,  6.284809e-01, -3.278179e-02,  7.037075e-01,  3.218973e-02},
  {-4.464334e-01,  8.049194e-01,  3.908990e-01, -6.057338e-02,  7.037075e-01,  1.362216e-02},
  {-6.639679e-01,  7.131618e-01,  2.248263e-01, -7.914095e-02,  7.037075e-01, -1.416943e-02},
  {-8.257889e-01,  5.613145e-01, -5.476089e-02, -8.566257e-02,  7.037075e-01, -4.695122e-02},
  {-6.284809e-01,  7.131618e-01, -3.105028e-01, -7.914095e-02,  7.037075e-01, -7.973301e-02},
  {-3.908990e-01,  8.049194e-01, -4.464334e-01, -6.057338e-02,  7.037075e-01, -1.075246e-01},
  {-2.248262e-01,  7.131618e-01, -6.639679e-01, -3.278179e-02,  7.037075e-01, -1.260922e-01},
  { 5.476088e-02,  5.613143e-01, -8.257890e-01,  6.801759e-09,  7.037075e-01, -1.326138e-01},
  { 3.105028e-01,  7.131618e-01, -6.284809e-01,  3.278179e-02,  7.037075e-01, -1.260922e-01},
  { 4.464334e-01,  8.049194e-01, -3.908990e-01,  6.057338e-02,  7.037075e-01, -1.075246e-01},
  { 6.639679e-01,  7.131618e-01, -2.248263e-01,  7.914095e-02,  7.037075e-01, -7.973301e-02},
  { 8.257889e-01,  5.613145e-01,  5.476093e-02,  8.566257e-02,  7.037075e-01, -4.695122e-02},
  { 6.284809e-01,  7.131618e-01,  3.105028e-01,  7.914095e-02,  7.037075e-01, -1.416943e-02},
  { 3.908990e-01,  8.049194e-01,  4.464334e-01,  6.057338e-02,  7.037075e-01,  1.362216e-02},
  { 2.248263e-01,  7.131618e-01,  6.639679e-01,  3.278179e-02,  7.037075e-01,  3.218973e-02},
  {-2.248150e-01,  7.131641e-01,  6.639693e-01, -4.952099e-02,  7.037075e-01,  7.260435e-02},
  { 3.925525e-02,  8.049160e-01,  5.920889e-01,  6.801759e-09,  7.037075e-01,  8.245401e-02},
  {-5.452007e-01,  5.613139e-01,  6.226418e-01, -9.150439e-02,  7.037075e-01,  4.455317e-02},
  {-6.284758e-01,  7.131641e-01,  3.105079e-01, -1.195556e-01,  7.037075e-01,  2.569770e-03},
  {-5.920889e-01,  8.049160e-01,  3.925524e-02, -1.294052e-01,  7.037075e-01, -4.695122e-02},
  {-6.639692e-01,  7.131641e-01, -2.248151e-01, -1.195556e-01,  7.037075e-01, -9.647220e-02},
  {-6.226417e-01,  5.613139e-01, -5.452008e-01, -9.150439e-02,  7.037075e-01, -1.384556e-01},
  {-3.105080e-01,  7.131641e-01, -6.284757e-01, -4.952099e-02,  7.037075e-01, -1.665068e-01},
  {-3.925525e-02,  8.049160e-01, -5.920889e-01,  6.801759e-09,  7.037075e-01, -1.763564e-01},
  { 2.248151e-01,  7.131641e-01, -6.639692e-01,  4.952099e-02,  7.037075e-01, -1.665068e-01},
  { 5.452008e-01,  5.613139e-01, -6.226417e-01,  9.150439e-02,  7.037075e-01, -1.384556e-01},
  { 6.284758e-01,  7.131641e-01, -3.105079e-01,  1.195556e-01,  7.037075e-01, -9.647220e-02},
  { 5.920889e-01,  8.049160e-01, -3.925524e-02,  1.294052e-01,  7.037075e-01, -4.695122e-02},
  { 6.639693e-01,  7.131641e-01,  2.248151e-01,  1.195556e-01,  7.037075e-01,  2.569770e-03},
  { 6.226417e-01,  5.613139e-01,  5.452008e-01,  9.150439e-02,  7.037075e-01,  4.455317e-02},
  { 3.105079e-01,  7.131641e-01,  6.284758e-01,  4.952099e-02,  7.037075e-01,  7.260435e-02},
  {-5.474959e-02,  5.613117e-01,  8.257916e-01,  6.801759e-09,  9.675229e-02,  8.245401e-02},
  {-2.628423e-01,  8.049165e-01,  5.319995e-01, -4.952099e-02,  9.675229e-02,  7.260435e-02},
  {-6.226417e-01,  5.613139e-01,  5.452008e-01, -9.150439e-02,  9.675229e-02,  4.455317e-02},
  {-5.620443e-01,  8.049165e-01,  1.903041e-01, -1.195556e-01,  9.675229e-02,  2.569770e-03},
  {-8.257915e-01,  5.613117e-01, -5.474962e-02, -1.294052e-01,  9.675229e-02, -4.695122e-02},
  {-5.319995e-01,  8.049165e-01, -2.628423e-01, -1.195556e-01,  9.675229e-02, -9.647220e-02},
  {-5.452008e-01,  5.613139e-01, -6.226417e-01, -9.150439e-02,  9.675229e-02, -1.384556e-01},
  {-1.903041e-01,  8.049165e-01, -5.620443e-01, -4.952099e-02,  9.675229e-02, -1.665068e-01},
  { 5.474969e-02,  5.613117e-01, -8.257915e-01,  6.801759e-09,  9.675229e-02, -1.763564e-01},
  { 2.628424e-01,  8.049165e-01, -5.319995e-01,  4.952099e-02,  9.675229e-02, -1.665068e-01},
  { 6.226417e-01,  5.613139e-01, -5.452008e-01,  9.150439e-02,  9.675229e-02, -1.384556e-01},
  { 5.620443e-01,  8.049165e-01, -1.903041e-01,  1.195556e-01,  9.675229e-02, -9.647220e-02},
  { 8.257915e-01,  5.613117e-01,  5.474962e-02,  1.294052e-01,  9.675229e-02, -4.695122e-02},
  { 5.319995e-01,  8.049165e-01,  2.628423e-01,  1.195556e-01,  9.675229e-02,  2.569770e-03},
  { 5.452007e-01,  5.613139e-01,  6.226418e-01,  9.150439e-02,  9.675229e-02,  4.455317e-02},
  { 1.903041e-01,  8.049165e-01,  5.620443e-01,  4.952099e-02,  9.675229e-02,  7.260435e-02},
  { 3.923875e-02,  8.049119e-01,  5.920956e-01,  6.801759e-09,  9.675229e-02,  3.904755e-01},
  {-3.909215e-01,  8.049137e-01,  4.464239e-01, -3.093101e-01,  9.675229e-02,  2.623588e-01},
  {-7.419718e-01,  5.613178e-01,  3.666063e-01, -4.041462e-01,  9.675229e-02,  1.204445e-01},
  {-5.920956e-01,  8.049119e-01,  3.923875e-02, -4.374267e-01,  9.675229e-02, -4.695122e-02},
  {-7.838929e-01,  5.613178e-01, -2.653944e-01, -4.041462e-01,  9.675229e-02, -2.143469e-01},
  {-4.464239e-01,  8.049137e-01, -3.909214e-01, -3.093101e-01,  9.675229e-02, -3.562613e-01},
  {-3.666064e-01,  5.613178e-01, -7.419719e-01, -1.673957e-01,  9.675229e-02, -4.510975e-01},
  {-3.923875e-02,  8.049119e-01, -5.920956e-01,  6.801759e-09,  9.675229e-02, -4.843779e-01},
  { 2.653944e-01,  5.613178e-01, -7.838929e-01,  1.673957e-01,  9.675229e-02, -4.510975e-01},
  { 3.909215e-01,  8.049137e-01, -4.464239e-01,  3.093101e-01,  9.675229e-02, -3.562613e-01},
  { 7.419718e-01,  5.613178e-01, -3.666063e-01,  4.041462e-01,  9.675229e-02, -2.143469e-01},
  { 5.920956e-01,  8.049119e-01, -3.923875e-02,  4.374267e-01,  9.675229e-02, -4.695122e-02},
  { 7.838929e-01,  5.613178e-01,  2.653944e-01,  4.041462e-01,  9.675229e-02,  1.204445e-01},
  { 4.464239e-01,  8.049137e-01,  3.909214e-01,  3.093101e-01,  9.675229e-02,  2.623588e-01},
  { 3.666064e-01,  5.613178e-01,  7.419719e-01,  1.673957e-01,  9.675229e-02,  3.571950e-01},
  {-3.923875e-02, -8.049119e-01,  5.920956e-01,  6.801759e-09, -4.288283e-01,  3.904755e-01},
  {-4.464239e-01, -8.049137e-01,  3.909214e-01, -3.093101e-01, -4.288283e-01,  2.623588e-01},
  {-7.838929e-01, -5.613178e-01,  2.653944e-01, -4.041462e-01, -4.288283e-01,  1.204445e-01},
  {-5.920956e-01, -8.049119e-01, -3.923875e-02, -4.374267e-01, -4.288283e-01, -4.695122e-02},
  {-7.419718e-01, -5.613178e-01, -3.666063e-01, -4.041462e-01, -4.288283e-01, -2.143469e-01},
  {-3.909215e-01, -8.049137e-01, -4.464239e-01, -3.093101e-01, -4.288283e-01, -3.562613e-01},
  {-2.653944e-01, -5.613178e-01, -7.838929e-01, -1.673957e-01, -4.288283e-01, -4.510975e-01},
  { 3.923875e-02, -8.049119e-01, -5.920956e-01,  6.801759e-09, -4.288283e-01, -4.843779e-01},
  { 3.666064e-01, -5.613178e-01, -7.419719e-01,  1.673957e-01, -4.288283e-01, -4.510975e-01},
  { 4.464239e-01, -8.049137e-01, -3.909214e-01,  3.093101e-01, -4.288283e-01, -3.562613e-01},
  { 7.838929e-01, -5.613178e-01, -2.653944e-01,  4.041462e-01, -4.288283e-01, -2.143469e-01},
  { 5.920956e-01, -8.049119e-01,  3.923875e-02,  4.374267e-01, -4.288283e-01, -4.695122e-02},
  { 7.419718e-01, -5.613178e-01,  3.666063e-01,  4.041462e-01, -4.288283e-01,  1.204445e-01},
  { 3.909215e-01, -8.049137e-01,  4.464239e-01,  3.093101e-01, -4.288283e-01,  2.623588e-01},
  { 2.653944e-01, -5.613178e-01,  7.838929e-01,  1.673957e-01, -4.288283e-01,  3.571950e-01},
  {-1.903040e-01, -8.049165e-01,  5.620444e-01, -4.952099e-02, -4.288283e-01,  7.260435e-02},
  { 5.474964e-02, -5.613117e-01,  8.257915e-01,  6.801759e-09, -4.288283e-01,  8.245401e-02},
  {-5.452008e-01, -5.613139e-01,  6.226417e-01, -9.150439e-02, -4.288283e-01,  4.455317e-02},
  {-5.319995e-01, -8.049165e-01,  2.628423e-01, -1.195556e-01, -4.288283e-01,  2.569770e-03},
  {-8.257915e-01, -5.613117e-01,  5.474963e-02, -1.294052e-01, -4.288283e-01, -4.695122e-02},
  {-5.620443e-01, -8.049165e-01, -1.903041e-01, -1.195556e-01, -4.288283e-01, -9.647220e-02},
  {-6.226417e-01, -5.613139e-01, -5.452008e-01, -9.150439e-02, -4.288283e-01, -1.384556e-01},
  {-2.628423e-01, -8.049165e-01, -5.319995e-01, -4.952099e-02, -4.288283e-01, -1.665068e-01},
  {-5.474965e-02, -5.613117e-01, -8.257915e-01,  6.801759e-09, -4.288283e-01, -1.763564e-01},
  { 1.903041e-01, -8.049165e-01, -5.620443e-01,  4.952099e-02, -4.288283e-01, -1.665068e-01},
  { 5.452008e-01, -5.613139e-01, -6.226417e-01,  9.150439e-02, -4.288283e-01, -1.384556e-01},
  { 5.319995e-01, -8.049165e-01, -2.628424e-01,  1.195556e-01, -4.288283e-01, -9.647220e-02},
  { 8.257915e-01, -5.613117e-01, -5.474962e-02,  1.294052e-01, -4.288283e-01, -4.695122e-02},
  { 5.620443e-01, -8.049165e-01,  1.903041e-01,  1.195556e-01, -4.288283e-01,  2.569770e-03},
  { 6.226417e-01, -5.613139e-01,  5.452008e-01,  9.150439e-02, -4.288283e-01,  4.455317e-02},
  { 2.628423e-01, -8.049165e-01,  5.319995e-01,  4.952099e-02, -4.288283e-01,  7.260435e-02},
  {-3.925521e-02, -8.049160e-01,  5.920889e-01,  6.801759e-09, -1.035802e+00,  8.245401e-02},
  {-3.105079e-01, -7.131641e-01,  6.284758e-01, -4.952099e-02, -1.035802e+00,  7.260435e-02},
  {-6.226417e-01, -5.613140e-01,  5.452008e-01, -9.150439e-02, -1.035802e+00,  4.455317e-02},
  {-6.639692e-01, -7.131641e-01,  2.248151e-01, -1.195556e-01, -1.035802e+00,  2.569770e-03},
  {-5.920889e-01, -8.049160e-01, -3.925523e-02, -1.294052e-01, -1.035802e+00, -4.695122e-02},
  {-6.284758e-01, -7.131641e-01, -3.105080e-01, -1.195556e-01, -1.035802e+00, -9.647220e-02},
  {-5.452007e-01, -5.613139e-01, -6.226418e-01, -9.150439e-02, -1.035802e+00, -1.384556e-01},
  {-2.248151e-01, -7.131641e-01, -6.639692e-01, -4.952099e-02, -1.035802e+00, -1.665068e-01},
  { 3.925528e-02, -8.049160e-01, -5.920889e-01,  6.801759e-09, -1.035802e+00, -1.763564e-01},
  { 3.105079e-01, -7.131641e-01, -6.284758e-01,  4.952099e-02, -1.035802e+00, -1.665068e-01},
  { 6.226417e-01, -5.613139e-01, -5.452008e-01,  9.150439e-02, -1.035802e+00, -1.384556e-01},
  { 6.639692e-01, -7.131641e-01, -2.248151e-01,  1.195556e-01, -1.035802e+00, -9.647220e-02},
  { 5.920889e-01, -8.049160e-01,  3.925524e-02,  1.294052e-01, -1.035802e+00, -4.695122e-02},
  { 6.284758e-01, -7.131641e-01,  3.105079e-01,  1.195556e-01, -1.035802e+00,  2.569770e-03},
  { 5.452008e-01, -5.613139e-01,  6.226417e-01,  9.150439e-02, -1.035802e+00,  4.455317e-02},
  { 2.248151e-01, -7.131641e-01,  6.639692e-01,  4.952099e-02, -1.035802e+00,  7.260435e-02},
  {-2.248262e-01, -7.131618e-01,  6.639679e-01, -3.278179e-02, -1.035802e+00,  3.218973e-02},
  { 5.476091e-02, -5.613144e-01,  8.257890e-01,  6.801759e-09, -1.035802e+00,  3.871135e-02},
  {-3.908990e-01, -8.049194e-01,  4.464334e-01, -6.057338e-02, -1.035802e+00,  1.362216e-02},
  {-6.284809e-01, -7.131618e-01,  3.105028e-01, -7.914095e-02, -1.035802e+00, -1.416943e-02},
  {-8.257890e-01, -5.613144e-01,  5.476091e-02, -8.566257e-02, -1.035802e+00, -4.695122e-02},
  {-6.639679e-01, -7.131618e-01, -2.248263e-01, -7.914095e-02, -1.035802e+00, -7.973301e-02},
  {-4.464334e-01, -8.049194e-01, -3.908990e-01, -6.057338e-02, -1.035802e+00, -1.075246e-01},
  {-3.105028e-01, -7.131618e-01, -6.284809e-01, -3.278179e-02, -1.035802e+00, -1.260922e-01},
  {-5.476081e-02, -5.613144e-01, -8.257890e-01,  6.801759e-09, -1.035802e+00, -1.326138e-01},
  { 2.248262e-01, -7.131618e-01, -6.639679e-01,  3.278179e-02, -1.035802e+00, -1.260922e-01},
  { 3.908991e-01, -8.049194e-01, -4.464334e-01,  6.057338e-02, -1.035802e+00, -1.075246e-01},
  { 6.284809e-01, -7.131618e-01, -3.105028e-01,  7.914095e-02, -1.035802e+00, -7.973301e-02},
  { 8.257890e-01, -5.613144e-01, -5.476090e-02,  8.566257e-02, -1.035802e+00, -4.695122e-02},
  { 6.639679e-01, -7.131618e-01,  2.248263e-01,  7.914095e-02, -1.035802e+00, -1.416943e-02},
  { 4.464334e-01, -8.049194e-01,  3.908990e-01,  6.057338e-02, -1.035802e+00,  1.362216e-02},
  { 3.105027e-01, -7.131618e-01,  6.284809e-01,  3.278179e-02, -1.035802e+00,  3.218973e-02},
  {-5.476084e-02, -5.613144e-01,  8.257890e-01,  6.801759e-09, -1.203698e+00,  3.871135e-02},
  {-3.665821e-01, -5.613098e-01,  7.419898e-01, -3.278179e-02, -1.203698e+00,  3.218973e-02},
  {-6.226470e-01, -5.613163e-01,  5.451924e-01, -6.057338e-02, -1.203698e+00,  1.362216e-02},
  {-7.838860e-01, -5.613098e-01,  2.654318e-01, -7.914095e-02, -1.203698e+00, -1.416943e-02},
  {-8.257890e-01, -5.613144e-01, -5.476090e-02, -8.566257e-02, -1.203698e+00, -4.695122e-02},
  {-7.419897e-01, -5.613098e-01, -3.665822e-01, -7.914095e-02, -1.203698e+00, -7.973301e-02},
  {-5.451925e-01, -5.613163e-01, -6.226470e-01, -6.057338e-02, -1.203698e+00, -1.075246e-01},
  {-2.654317e-01, -5.613099e-01, -7.838860e-01, -3.278179e-02, -1.203698e+00, -1.260922e-01},
  { 5.476088e-02, -5.613144e-01, -8.257890e-01,  6.801759e-09, -1.203698e+00, -1.326138e-01},
  { 3.665822e-01, -5.613098e-01, -7.419897e-01,  3.278179e-02, -1.203698e+00, -1.260922e-01},
  { 6.226470e-01, -5.613163e-01, -5.451924e-01,  6.057338e-02, -1.203698e+00, -1.075246e-01},
  { 7.838860e-01, -5.613098e-01, -2.654318e-01,  7.914095e-02, -1.203698e+00, -7.973301e-02},
  { 8.257889e-01, -5.613145e-01,  5.476092e-02,  8.566257e-02, -1.203698e+00, -4.695122e-02},
  { 7.419898e-01, -5.613098e-01,  3.665822e-01,  7.914095e-02, -1.203698e+00, -1.416943e-02},
  { 5.451924e-01, -5.613163e-01,  6.226470e-01,  6.057338e-02, -1.203698e+00,  1.362216e-02},
  { 2.654317e-01, -5.613098e-01,  7.838860e-01,  3.278179e-02, -1.203698e+00,  3.218973e-02},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00,  6.801759e-09, -1.203698e+00, -4.695122e-02},
  {-6.284811e-01, -7.131642e-01, -3.104971e-01,  7.340745e-01, -5.953127e-01,  2.571146e-01},
  {-6.639732e-01,  7.131642e-01, -2.248033e-01,  7.340745e-01,  2.931741e-01,  2.571146e-01},
  {-5.920904e-01, -8.049151e-01, -3.925163e-02,  7.945470e-01, -5.953127e-01, -4.695118e-02},
  {-5.920904e-01,  8.049151e-01,  3.925157e-02,  7.945470e-01,  2.931741e-01, -4.695118e-02},
  {-5.451968e-01, -5.613151e-01, -6.226443e-01,  5.618454e-01, -5.953127e-01,  5.148942e-01},
  {-6.226443e-01,  5.613151e-01, -5.451968e-01,  5.618454e-01,  2.931741e-01,  5.148942e-01},
  {-1.902941e-01, -8.049165e-01, -5.620476e-01,  3.040659e-01, -5.953127e-01,  6.871233e-01},
  {-2.628332e-01,  8.049165e-01, -5.320038e-01,  3.040659e-01,  2.931741e-01,  6.871233e-01},
  {-6.913015e-02, -7.088107e-01, -7.020031e-01,  0.000000e+00, -5.953127e-01,  7.475958e-01},
  {-8.757036e-02,  4.489416e-01, -8.892598e-01,  0.000000e+00,  2.931741e-01,  7.475958e-01},
  { 6.913055e-02, -7.088107e-01, -7.020031e-01, -3.040659e-01, -5.953127e-01,  6.871233e-01},
  { 8.757085e-02,  4.489416e-01, -8.892596e-01, -3.040659e-01,  2.931741e-01,  6.871233e-01},
  { 7.826518e-02, -6.018525e-01, -7.947628e-01, -1.787171e-06, -5.953127e-01,  7.475958e-01},
  { 5.418021e-02,  8.332825e-01, -5.501862e-01, -1.787171e-06,  2.931741e-01,  7.475958e-01},
  { 6.226456e-01, -5.613149e-01, -5.451954e-01, -5.618454e-01, -5.953127e-01,  5.148942e-01},
  { 5.451997e-01,  5.613149e-01, -6.226419e-01, -5.618454e-01,  2.931741e-01,  5.148942e-01},
  { 2.284634e-01, -6.168625e-01, -7.531834e-01, -3.040696e-01, -5.953127e-01,  6.871233e-01},
  { 1.561175e-01,  8.430502e-01, -5.146783e-01, -3.040696e-01,  2.931741e-01,  6.871233e-01},
  { 6.639732e-01, -7.131642e-01, -2.248033e-01, -7.340745e-01, -5.953127e-01,  2.571146e-01},
  { 6.284810e-01,  7.131641e-01, -3.104971e-01, -7.340745e-01,  2.931741e-01,  2.571146e-01},
  { 5.920904e-01, -8.049151e-01,  3.925157e-02, -7.945470e-01, -5.953127e-01, -4.695118e-02},
  { 5.920904e-01,  8.049151e-01, -3.925163e-02, -7.945470e-01,  2.931741e-01, -4.695118e-02},
  { 6.284810e-01, -7.131642e-01,  3.104971e-01, -7.340745e-01, -5.953127e-01, -3.510171e-01},
  { 6.639732e-01,  7.131642e-01,  2.248033e-01, -7.340745e-01,  2.931741e-01, -3.510171e-01},
  { 5.451996e-01, -5.613148e-01,  6.226419e-01, -5.618454e-01, -5.953127e-01, -6.087967e-01},
  { 6.226456e-01,  5.613149e-01,  5.451955e-01, -5.618454e-01,  2.931741e-01, -6.087967e-01},
  { 2.284633e-01,  6.168625e-01,  7.531834e-01, -3.040696e-01,  2.931741e-01, -7.810257e-01},
  { 1.561175e-01, -8.430502e-01,  5.146783e-01, -3.040696e-01, -5.953127e-01, -7.810257e-01},
  { 6.913055e-02,  7.088107e-01,  7.020031e-01, -3.040659e-01,  2.931741e-01, -7.810257e-01},
  { 8.757086e-02, -4.489417e-01,  8.892596e-01, -3.040659e-01, -5.953127e-01, -7.810257e-01},
  { 7.826518e-02,  6.018525e-01,  7.947628e-01, -1.787171e-06,  2.931741e-01, -8.414983e-01},
  { 5.418021e-02, -8.332825e-01,  5.501862e-01, -1.787171e-06, -5.953127e-01, -8.414983e-01},
  {-6.913015e-02,  7.088107e-01,  7.020031e-01,  0.000000e+00,  2.931741e-01, -8.414983e-01},
  {-8.757035e-02, -4.489416e-01,  8.892597e-01,  0.000000e+00, -5.953127e-01, -8.414983e-01},
  {-2.628331e-01, -8.049165e-01,  5.320039e-01,  3.040659e-01, -5.953127e-01, -7.810257e-01},
  {-1.902941e-01,  8.049165e-01,  5.620476e-01,  3.040659e-01,  2.931741e-01, -7.810257e-01},
  {-6.226443e-01, -5.613151e-01,  5.451968e-01,  5.618454e-01, -5.953127e-01, -6.087967e-01},
  {-5.451967e-01,  5.613151e-01,  6.226443e-01,  5.618454e-01,  2.931741e-01, -6.087967e-01},
  {-6.639732e-01, -7.131642e-01,  2.248033e-01,  7.340745e-01, -5.953127e-01, -3.510171e-01},
  {-6.284811e-01,  7.131642e-01,  3.104971e-01,  7.340745e-01,  2.931741e-01, -3.510171e-01},
  {-8.257919e-01, -5.613113e-01, -5.474805e-02,  8.303300e-01, -5.953127e-01, -4.695115e-02},
  {-6.639662e-01, -7.131654e-01,  2.248199e-01,  7.671308e-01, -5.953127e-01, -3.647065e-01},
  {-4.464265e-01, -8.049160e-01,  3.909137e-01,  5.871326e-01, -5.953127e-01, -6.340838e-01},
  {-3.666019e-01, -5.613135e-01,  7.419772e-01,  3.177516e-01, -5.953127e-01, -8.140820e-01},
  {-3.925430e-02, -8.049158e-01,  5.920893e-01, -1.787171e-06, -5.953127e-01, -8.772812e-01},
  { 1.903084e-01, -8.049175e-01,  5.620413e-01, -3.177553e-01, -5.953127e-01, -8.140820e-01},
  { 3.909129e-01, -8.049159e-01,  4.464275e-01, -5.871326e-01, -5.953127e-01, -6.340838e-01},
  { 6.284677e-01, -7.131654e-01,  3.105213e-01, -7.671308e-01, -5.953127e-01, -3.647065e-01},
  { 8.257919e-01, -5.613113e-01,  5.474797e-02, -8.303300e-01, -5.953127e-01, -4.695115e-02},
  { 6.639662e-01, -7.131654e-01, -2.248199e-01, -7.671308e-01, -5.953127e-01,  2.708041e-01},
  { 4.464275e-01, -8.049159e-01, -3.909129e-01, -5.871326e-01, -5.953127e-01,  5.401813e-01},
  { 2.628537e-01, -8.049175e-01, -5.319923e-01, -3.177553e-01, -5.953127e-01,  7.201796e-01},
  { 3.925429e-02, -8.049158e-01, -5.920893e-01, -1.787171e-06, -5.953127e-01,  7.833788e-01},
  {-2.654238e-01, -5.613135e-01, -7.838861e-01,  3.177516e-01, -5.953127e-01,  7.201796e-01},
  {-3.909108e-01, -8.049160e-01, -4.464290e-01,  5.871326e-01, -5.953127e-01,  5.401813e-01},
  {-6.284677e-01, -7.131654e-01, -3.105213e-01,  7.671308e-01, -5.953127e-01,  2.708041e-01},
  {-5.920894e-01, -8.049157e-01,  3.925406e-02,  8.303300e-01, -6.313945e-01, -4.695115e-02},
  {-7.419757e-01, -5.613137e-01,  3.666047e-01,  7.671308e-01, -6.313945e-01, -3.647065e-01},
  {-3.909108e-01, -8.049160e-01,  4.464290e-01,  5.871326e-01, -6.313945e-01, -6.340838e-01},
  {-2.654237e-01, -5.613135e-01,  7.838861e-01,  3.177516e-01, -6.313945e-01, -8.140820e-01},
  { 3.925425e-02, -8.049158e-01,  5.920893e-01, -1.787171e-06, -6.313945e-01, -8.772812e-01},
  { 3.666050e-01, -5.613137e-01,  7.419755e-01, -3.177553e-01, -6.313945e-01, -8.140820e-01},
  { 4.464275e-01, -8.049159e-01,  3.909129e-01, -5.871326e-01, -6.313945e-01, -6.340838e-01},
  { 7.838856e-01, -5.613137e-01,  2.654247e-01, -7.671308e-01, -6.313945e-01, -3.647065e-01},
  { 5.920894e-01, -8.049157e-01, -3.925413e-02, -8.303300e-01, -6.313945e-01, -4.695115e-02},
  { 7.419756e-01, -5.613137e-01, -3.666048e-01, -7.671308e-01, -6.313945e-01,  2.708041e-01},
  { 3.909129e-01, -8.049159e-01, -4.464275e-01, -5.871326e-01, -6.313945e-01,  5.401813e-01},
  { 2.654254e-01, -5.613137e-01, -7.838854e-01, -3.177553e-01, -6.313945e-01,  7.201796e-01},
  {-3.925435e-02, -8.049158e-01, -5.920893e-01, -1.787171e-06, -6.313945e-01,  7.833788e-01},
  {-3.666019e-01, -5.613135e-01, -7.419772e-01,  3.177516e-01, -6.313945e-01,  7.201796e-01},
  {-4.464265e-01, -8.049160e-01, -3.909137e-01,  5.871326e-01, -6.313945e-01,  5.401813e-01},
  {-7.838856e-01, -5.613137e-01, -2.654248e-01,  7.671308e-01, -6.313945e-01,  2.708041e-01},
  { 9.201803e-01, -3.753506e-01,  1.112664e-01,  8.657395e-01, -6.313945e-01, -4.695115e-02},
  { 5.620359e-01, -8.049142e-01, -1.903386e-01,  7.998136e-01, -6.313945e-01, -3.782503e-01},
  { 6.226408e-01, -5.613142e-01, -5.452016e-01,  6.121583e-01, -6.313945e-01, -6.591095e-01},
  { 2.628569e-01, -8.049141e-01, -5.319959e-01,  3.312953e-01, -6.313945e-01, -8.467649e-01},
  { 5.477523e-02, -5.613178e-01, -8.257857e-01, -1.787171e-06, -6.313945e-01, -9.126907e-01},
  {-1.903391e-01, -8.049142e-01, -5.620358e-01, -3.312991e-01, -6.313945e-01, -8.467649e-01},
  {-5.452004e-01, -5.613140e-01, -6.226420e-01, -6.121583e-01, -6.313945e-01, -6.591095e-01},
  {-5.319948e-01, -8.049142e-01, -2.628588e-01, -7.998136e-01, -6.313945e-01, -3.782503e-01},
  {-9.252829e-01, -3.773945e-01,  3.774948e-02, -8.657395e-01, -6.313945e-01, -4.695115e-02},
  {-5.620645e-01, -8.048965e-01,  1.903290e-01, -7.998136e-01, -6.313945e-01,  2.843479e-01},
  {-6.299674e-01, -4.541780e-01,  6.299710e-01, -6.121583e-01, -6.313945e-01,  5.652071e-01},
  {-3.803994e-01, -6.293830e-01,  6.776233e-01, -3.312991e-01, -6.313945e-01,  7.528624e-01},
  {-5.477522e-02, -5.613179e-01,  8.257857e-01, -1.787171e-06, -6.313945e-01,  8.187883e-01},
  { 3.666221e-01, -5.613087e-01,  7.419709e-01,  3.312953e-01, -6.313945e-01,  7.528624e-01},
  { 5.451978e-01, -5.613118e-01,  6.226462e-01,  6.121583e-01, -6.313945e-01,  5.652071e-01},
  { 6.469363e-01, -7.139074e-01,  2.679732e-01,  7.998136e-01, -6.313945e-01,  2.843479e-01},
  { 9.252829e-01,  3.773946e-01,  3.774948e-02,  8.657395e-01,  3.292186e-01, -4.695115e-02},
  { 5.319947e-01,  8.049142e-01, -2.628588e-01,  7.998136e-01,  3.292186e-01, -3.782503e-01},
  { 5.451978e-01,  5.613142e-01, -6.226441e-01,  6.121583e-01,  3.292186e-01, -6.591095e-01},
  { 1.903380e-01,  8.049141e-01, -5.620363e-01,  3.312953e-01,  3.292186e-01, -8.467649e-01},
  {-5.477516e-02,  5.613178e-01, -8.257857e-01, -1.787171e-06,  3.292186e-01, -9.126907e-01},
  {-2.628590e-01,  8.049142e-01, -5.319947e-01, -3.312991e-01,  3.292186e-01, -8.467649e-01},
  {-6.226420e-01,  5.613140e-01, -5.452004e-01, -6.121583e-01,  3.292186e-01, -6.591095e-01},
  {-5.620359e-01,  8.049142e-01, -1.903386e-01, -7.998136e-01,  3.292186e-01, -3.782503e-01},
  {-9.201803e-01,  3.753506e-01,  1.112664e-01, -8.657395e-01,  3.292186e-01, -4.695115e-02},
  {-6.284763e-01,  7.131641e-01,  3.105068e-01, -7.998136e-01, -4.238493e-01,  2.843479e-01},
  {-6.639696e-01, -7.131641e-01,  2.248137e-01, -7.998136e-01,  1.216734e-01,  2.843479e-01},
  {-9.601865e-01,  1.958594e-01, -1.992012e-01, -8.633490e-01, -4.238493e-01, -3.509203e-02},
  {-9.386504e-01, -3.191217e-01, -1.307547e-01, -8.633490e-01,  1.216734e-01, -3.509203e-02},
  {-6.284763e-01, -7.131641e-01,  3.105068e-01, -7.998136e-01, -5.187228e-01,  2.843479e-01},
  {-9.385989e-01, -3.189665e-01, -1.315014e-01, -8.633490e-01, -5.187228e-01, -3.509203e-02},
  {-6.284763e-01,  7.131641e-01,  3.105068e-01, -7.998136e-01,  2.165469e-01,  2.843479e-01},
  {-5.620645e-01,  8.048965e-01,  1.903290e-01, -7.998136e-01,  3.292186e-01,  2.843479e-01},
  {-8.619690e-01,  2.929252e-01, -4.137684e-01, -8.633490e-01,  2.165469e-01, -3.509203e-02},
  {-3.869646e-01, -8.369669e-01,  3.869689e-01, -6.121583e-01, -5.187228e-01,  5.652071e-01},
  {-4.617911e-01,  7.131661e-01,  5.273930e-01, -6.121583e-01, -4.238493e-01,  5.652071e-01},
  {-5.273878e-01, -7.131661e-01,  4.617970e-01, -6.121583e-01,  1.216734e-01,  5.652071e-01},
  {-3.869646e-01,  8.369669e-01,  3.869688e-01, -6.121583e-01,  2.165469e-01,  5.652071e-01},
  {-6.299674e-01,  4.541780e-01,  6.299709e-01, -6.121583e-01,  3.292186e-01,  5.652071e-01},
  {-2.716370e-01, -1.629663e-01,  9.485016e-01, -3.639408e-01,  1.216734e-01,  7.310489e-01},
  {-3.047488e-01,  2.742456e-01,  9.120951e-01, -3.639408e-01, -4.238493e-01,  7.310489e-01},
  {-3.047285e-01,  2.742366e-01,  9.121046e-01, -3.639408e-01,  2.165469e-01,  7.310489e-01},
  {-3.249095e-01,  6.317680e-01,  7.037777e-01, -3.312991e-01,  3.292186e-01,  7.528624e-01},
  {-1.288523e-01, -2.319111e-01,  9.641652e-01, -3.639408e-01, -5.187228e-01,  7.310489e-01},
  { 5.477528e-02,  5.613179e-01,  8.257857e-01, -1.787171e-06,  3.292186e-01,  8.187883e-01},
  { 3.315091e-01,  7.122044e-01,  6.187623e-01,  3.312953e-01,  3.292186e-01,  7.528624e-01},
  { 5.273878e-01,  7.131661e-01,  4.617970e-01,  6.121583e-01, -4.238493e-01,  5.652071e-01},
  { 4.617911e-01, -7.131661e-01,  5.273929e-01,  6.121583e-01,  1.216734e-01,  5.652071e-01},
  { 3.631671e-01,  2.178984e-01,  9.058862e-01,  3.639408e-01, -4.238493e-01,  7.310489e-01},
  { 2.133560e-01, -1.920129e-01,  9.579198e-01,  3.639408e-01,  1.216734e-01,  7.310489e-01},
  { 5.273878e-01,  7.131661e-01,  4.617969e-01,  6.121583e-01,  2.165469e-01,  5.652071e-01},
  { 5.451978e-01,  5.613118e-01,  6.226462e-01,  6.121583e-01,  3.292186e-01,  5.652071e-01},
  { 3.047134e-01,  2.742396e-01,  9.121088e-01,  3.639408e-01,  2.165469e-01,  7.310489e-01},
  { 5.273878e-01, -7.131661e-01,  4.617969e-01,  6.121583e-01, -5.187228e-01,  5.652071e-01},
  { 1.288401e-01, -2.319133e-01,  9.641662e-01,  3.639408e-01, -5.187228e-01,  7.310489e-01},
  { 5.056024e-01, -8.369654e-01,  2.094164e-01,  7.998136e-01, -5.187228e-01,  2.843479e-01},
  { 6.639696e-01,  7.131641e-01,  2.248137e-01,  7.998136e-01, -4.238493e-01,  2.843479e-01},
  { 6.284763e-01, -7.131641e-01,  3.105068e-01,  7.998136e-01,  1.216734e-01,  2.843479e-01},
  { 5.056024e-01,  8.369654e-01,  2.094163e-01,  7.998136e-01,  2.165469e-01,  2.843479e-01},
  { 6.469363e-01,  7.139074e-01,  2.679731e-01,  7.998136e-01,  3.292186e-01,  2.843479e-01},
  { 9.601865e-01, -1.958594e-01, -1.992012e-01,  8.633490e-01,  1.216734e-01, -3.509203e-02},
  { 8.621666e-01,  2.931188e-01, -4.132193e-01,  8.633490e-01, -4.238493e-01, -3.509203e-02},
  { 9.385988e-01,  3.189665e-01, -1.315014e-01,  8.633490e-01,  2.165469e-01, -3.509203e-02},
  { 9.385989e-01, -3.189665e-01, -1.315013e-01,  8.633490e-01, -5.187228e-01, -3.509203e-02},
  {-5.920894e-01,  8.049157e-01, -3.925412e-02,  8.303300e-01,  3.292186e-01, -4.695115e-02},
  {-7.838856e-01,  5.613137e-01,  2.654247e-01,  7.671308e-01,  3.292186e-01, -3.647065e-01},
  {-4.464265e-01,  8.049160e-01,  3.909137e-01,  5.871326e-01,  3.292186e-01, -6.340838e-01},
  {-3.666019e-01,  5.613135e-01,  7.419772e-01,  3.177516e-01,  3.292186e-01, -8.140820e-01},
  {-3.925430e-02,  8.049158e-01,  5.920893e-01, -1.787171e-06,  3.292186e-01, -8.772812e-01},
  { 2.654252e-01,  5.613137e-01,  7.838855e-01, -3.177553e-01,  3.292186e-01, -8.140820e-01},
  { 3.909129e-01,  8.049159e-01,  4.464275e-01, -5.871326e-01,  3.292186e-01, -6.340838e-01},
  { 7.419757e-01,  5.613137e-01,  3.666047e-01, -7.671308e-01,  3.292186e-01, -3.647065e-01},
  { 5.920894e-01,  8.049157e-01,  3.925406e-02, -8.303300e-01,  3.292186e-01, -4.695115e-02},
  { 7.838856e-01,  5.613137e-01, -2.654248e-01, -7.671308e-01,  3.292186e-01,  2.708041e-01},
  { 4.464275e-01,  8.049159e-01, -3.909129e-01, -5.871326e-01,  3.292186e-01,  5.401813e-01},
  { 3.666050e-01,  5.613137e-01, -7.419755e-01, -3.177553e-01,  3.292186e-01,  7.201796e-01},
  { 3.925429e-02,  8.049158e-01, -5.920892e-01, -1.787171e-06,  3.292186e-01,  7.833788e-01},
  {-2.654237e-01,  5.613135e-01, -7.838861e-01,  3.177516e-01,  3.292186e-01,  7.201796e-01},
  {-3.909108e-01,  8.049160e-01, -4.464290e-01,  5.871326e-01,  3.292186e-01,  5.401813e-01},
  {-7.419757e-01,  5.613137e-01, -3.666047e-01,  7.671308e-01,  3.292186e-01,  2.708041e-01},
  {-8.257919e-01,  5.613113e-01,  5.474797e-02,  8.303300e-01,  2.931741e-01, -4.695115e-02},
  {-6.284677e-01,  7.131654e-01,  3.105213e-01,  7.671308e-01,  2.931741e-01, -3.647065e-01},
  {-3.909108e-01,  8.049160e-01,  4.464290e-01,  5.871326e-01,  2.931741e-01, -6.340838e-01},
  {-2.654237e-01,  5.613135e-01,  7.838861e-01,  3.177516e-01,  2.931741e-01, -8.140820e-01},
  { 3.925425e-02,  8.049157e-01,  5.920893e-01, -1.787171e-06,  2.931741e-01, -8.772812e-01},
  { 2.628537e-01,  8.049175e-01,  5.319923e-01, -3.177553e-01,  2.931741e-01, -8.140820e-01},
  { 4.464275e-01,  8.049159e-01,  3.909129e-01, -5.871326e-01,  2.931741e-01, -6.340838e-01},
  { 6.639662e-01,  7.131654e-01,  2.248199e-01, -7.671308e-01,  2.931741e-01, -3.647065e-01},
  { 8.257919e-01,  5.613113e-01, -5.474804e-02, -8.303300e-01,  2.931741e-01, -4.695115e-02},
  { 6.284677e-01,  7.131654e-01, -3.105213e-01, -7.671308e-01,  2.931741e-01,  2.708041e-01},
  { 3.909129e-01,  8.049159e-01, -4.464275e-01, -5.871326e-01,  2.931741e-01,  5.401813e-01},
  { 1.903084e-01,  8.049175e-01, -5.620413e-01, -3.177553e-01,  2.931741e-01,  7.201796e-01},
  {-3.925433e-02,  8.049158e-01, -5.920892e-01, -1.787171e-06,  2.931741e-01,  7.833788e-01},
  {-3.666019e-01,  5.613135e-01, -7.419772e-01,  3.177516e-01,  2.931741e-01,  7.201796e-01},
  {-4.464265e-01,  8.049160e-01, -3.909137e-01,  5.871326e-01,  2.931741e-01,  5.401813e-01},
  {-6.639662e-01,  7.131654e-01, -2.248199e-01,  7.671308e-01,  2.931741e-01,  2.708041e-01},
  { 4.436316e-01, -4.202073e-02, -8.952236e-01, -5.742089e-01, -6.847702e-01,  8.273045e-01},
  { 5.345225e-01, -8.017837e-01, -2.672612e-01, -5.742089e-01, -5.187228e-01,  8.273045e-01},
  { 8.919495e-01, -5.615563e-02,  4.486342e-01, -5.742089e-01, -6.847702e-01,  9.126907e-01},
  { 5.937317e-01,  7.520901e-02, -8.011406e-01, -5.742089e-01,  3.825942e-01,  8.273045e-01},
  { 7.670633e-01,  2.407466e-02,  6.411197e-01, -5.742089e-01,  3.825942e-01,  9.126907e-01},
  { 5.345225e-01,  8.017837e-01, -2.672612e-01, -5.742089e-01,  2.165469e-01,  8.273045e-01},
  { 8.164966e-01, -4.082483e-01,  4.082483e-01, -5.742089e-01, -5.187228e-01,  8.899061e-01},
  { 6.666667e-01,  3.333333e-01,  6.666667e-01, -5.742089e-01,  2.165469e-01,  8.899061e-01},
  { 2.672612e-01,  8.017837e-01, -5.345225e-01, -5.742089e-01, -4.238493e-01,  8.273045e-01},
  { 5.345225e-01, -8.017837e-01, -2.672612e-01, -5.742089e-01,  1.216734e-01,  8.273045e-01},
  { 9.128709e-01,  1.825742e-01,  3.651484e-01, -5.742089e-01, -4.238493e-01,  8.899061e-01},
  { 9.045340e-01, -3.015113e-01,  3.015113e-01, -5.742089e-01,  1.216734e-01,  8.899061e-01},
  { 7.858505e-01,  2.595550e-01,  5.613112e-01, -5.792140e-01,  4.087779e-01,  9.126907e-01},
  { 6.307825e-01,  3.057969e-01, -7.131631e-01, -5.792140e-01,  4.087779e-01,  8.273045e-01},
  { 7.140805e-01,  6.218562e-01,  3.215337e-01, -5.950512e-01,  4.328697e-01,  9.126907e-01},
  { 6.221205e-01,  7.138503e-01, -3.215337e-01, -5.950512e-01,  4.328697e-01,  8.273045e-01},
  { 3.059492e-01,  6.306959e-01,  7.131745e-01, -6.191804e-01,  4.487442e-01,  9.126907e-01},
  { 2.596482e-01,  7.858107e-01, -5.613237e-01, -6.191804e-01,  4.487442e-01,  8.273045e-01},
  { 1.044344e-01,  8.244441e-01,  5.562241e-01, -6.453640e-01,  4.537494e-01,  9.126907e-01},
  { 3.760472e-02,  5.972935e-01, -8.011406e-01, -6.453640e-01,  4.537494e-01,  8.273045e-01},
  {-3.218933e-02,  5.119886e-01,  8.583890e-01, -8.113927e-01,  4.537494e-01,  9.126907e-01},
  {-1.042904e-01,  8.244652e-01, -5.562199e-01, -8.113927e-01,  4.537494e-01,  8.273045e-01},
  {-2.199540e-01,  6.655520e-01,  7.132046e-01, -8.376136e-01,  4.487442e-01,  9.126907e-01},
  {-3.614909e-01,  7.444481e-01, -5.613567e-01, -8.376136e-01,  4.487442e-01,  8.273045e-01},
  {-6.222197e-01,  7.137849e-01,  3.214866e-01, -8.617055e-01,  4.328697e-01,  9.126907e-01},
  {-6.236216e-01,  5.436242e-01, -5.617552e-01, -8.617055e-01,  4.328697e-01,  8.273045e-01},
  {-7.445567e-01,  3.612082e-01,  5.613947e-01, -8.775800e-01,  4.087779e-01,  9.126907e-01},
  {-8.993971e-01,  2.964875e-01, -3.212164e-01, -8.775800e-01,  4.087779e-01,  8.273045e-01},
  {-8.919854e-01,  5.574825e-02,  4.486136e-01, -8.825478e-01,  3.825942e-01,  9.126907e-01},
  {-3.135940e-01,  2.948564e-02, -9.490992e-01, -8.825478e-01,  3.825942e-01,  8.273045e-01},
  {-3.015113e-01,  9.045340e-01, -3.015113e-01, -8.825478e-01,  2.165469e-01,  8.273045e-01},
  {-5.938225e-01, -7.466565e-02, -8.011241e-01, -8.825478e-01, -6.847702e-01,  8.273045e-01},
  {-8.310214e-01, -2.589301e-02,  5.556374e-01, -8.825478e-01, -6.847702e-01,  9.126907e-01},
  {-3.015113e-01, -9.045340e-01, -3.015113e-01, -8.825478e-01, -5.187228e-01,  8.273045e-01},
  {-8.164966e-01,  4.082483e-01,  4.082483e-01, -8.825478e-01,  2.165469e-01,  8.899061e-01},
  {-8.164966e-01, -4.082483e-01,  4.082483e-01, -8.825478e-01, -5.187228e-01,  8.899061e-01},
  {-1.561738e-01, -9.370425e-01, -3.123475e-01, -8.825478e-01,  1.216734e-01,  8.273045e-01},
  {-3.123475e-01,  9.370425e-01, -1.561738e-01, -8.825478e-01, -4.238493e-01,  8.273045e-01},
  {-9.128709e-01, -1.825742e-01,  3.651484e-01, -8.825478e-01,  1.216734e-01,  8.899061e-01},
  {-8.017837e-01,  2.672612e-01,  5.345225e-01, -8.825478e-01, -4.238493e-01,  8.899061e-01},
  {-7.859449e-01, -2.590879e-01,  5.613947e-01, -8.775800e-01, -7.109538e-01,  9.126907e-01},
  {-7.445567e-01, -3.612080e-01, -5.613947e-01, -8.775800e-01, -7.109538e-01,  8.273045e-01},
  {-7.137842e-01, -6.222207e-01,  3.214866e-01, -8.617055e-01, -7.350457e-01,  9.126907e-01},
  {-6.222194e-01, -7.137852e-01, -3.214866e-01, -8.617055e-01, -7.350457e-01,  8.273045e-01},
  {-3.061830e-01, -6.305484e-01,  7.132045e-01, -8.376136e-01, -7.509201e-01,  9.126907e-01},
  {-1.861865e-01, -5.633751e-01, -8.049492e-01, -8.376136e-01, -7.509201e-01,  8.273045e-01},
  {-6.437904e-02, -5.089439e-01,  8.583890e-01, -8.113927e-01, -7.559253e-01,  9.126907e-01},
  {-5.214551e-02, -8.293975e-01, -5.562199e-01, -8.113927e-01, -7.559253e-01,  8.273045e-01},
  { 4.434246e-02, -7.043080e-01,  7.085083e-01, -6.453640e-01, -7.559253e-01,  9.126907e-01},
  { 1.191726e-01, -9.407877e-01, -3.173586e-01, -6.453640e-01, -7.559253e-01,  8.273045e-01},
  { 2.596486e-01, -7.858106e-01,  5.613237e-01, -6.191804e-01, -7.509201e-01,  9.126907e-01},
  { 1.925063e-01, -3.968405e-01, -8.974736e-01, -6.191804e-01, -7.509201e-01,  8.273045e-01},
  { 6.221202e-01, -7.138505e-01,  3.215337e-01, -5.950512e-01, -7.350457e-01,  9.126907e-01},
  { 7.140806e-01, -6.218562e-01, -3.215337e-01, -5.950512e-01, -7.350457e-01,  8.273045e-01},
  { 6.307827e-01, -3.057968e-01,  7.131631e-01, -5.792140e-01, -7.109538e-01,  9.126907e-01},
  { 7.858504e-01, -2.595551e-01, -5.613112e-01, -5.792140e-01, -7.109538e-01,  8.273045e-01},
  {-7.001081e-01,  8.868390e-02, -7.085083e-01,  5.742089e-01,  3.825942e-01,  8.273045e-01},
  {-4.850713e-01,  7.276069e-01, -4.850713e-01,  5.742089e-01,  2.165469e-01,  8.273045e-01},
  {-8.562363e-01,  3.226727e-02,  5.155756e-01,  5.742089e-01,  3.825942e-01,  9.126907e-01},
  {-5.505214e-01, -5.214532e-02, -8.331909e-01,  5.742089e-01, -6.847702e-01,  8.273045e-01},
  {-8.115515e-01, -4.375750e-02,  5.826401e-01,  5.742089e-01, -6.847702e-01,  9.126907e-01},
  {-4.850713e-01, -7.276069e-01, -4.850713e-01,  5.742089e-01, -5.187228e-01,  8.273045e-01},
  {-8.164966e-01,  4.082483e-01,  4.082483e-01,  5.742089e-01,  2.165469e-01,  8.899061e-01},
  {-6.666667e-01, -3.333333e-01,  6.666667e-01,  5.742089e-01, -5.187228e-01,  8.899061e-01},
  {-2.672612e-01, -8.017837e-01, -5.345225e-01,  5.742089e-01,  1.216734e-01,  8.273045e-01},
  {-5.345225e-01,  8.017837e-01, -2.672612e-01,  5.742089e-01, -4.238493e-01,  8.273045e-01},
  {-9.128709e-01, -1.825742e-01,  3.651484e-01,  5.742089e-01,  1.216734e-01,  8.899061e-01},
  {-9.045340e-01,  3.015113e-01,  3.015113e-01,  5.742089e-01, -4.238493e-01,  8.899061e-01},
  {-6.656313e-01,  2.198484e-01,  7.131631e-01,  5.792140e-01,  4.087779e-01,  9.126907e-01},
  {-7.447077e-01,  3.610266e-01, -5.613112e-01,  5.792140e-01,  4.087779e-01,  8.273045e-01},
  {-7.140805e-01,  6.218562e-01,  3.215337e-01,  5.950512e-01,  4.328697e-01,  9.126907e-01},
  {-6.221205e-01,  7.138503e-01, -3.215337e-01,  5.950512e-01,  4.328697e-01,  8.273045e-01},
  {-3.612086e-01,  7.446100e-01,  5.613238e-01,  6.191804e-01,  4.487442e-01,  9.126907e-01},
  {-1.383797e-01,  4.187984e-01, -8.974737e-01,  6.191804e-01,  4.487442e-01,  8.273045e-01},
  {-8.868440e-02,  7.001080e-01,  7.085083e-01,  6.453640e-01,  4.537494e-01,  9.126907e-01},
  {-5.958595e-02,  9.464318e-01, -3.173586e-01,  6.453640e-01,  4.537494e-01,  8.273045e-01},
  { 3.218933e-02,  5.119886e-01,  8.583890e-01,  8.113927e-01,  4.537494e-01,  9.126907e-01},
  { 1.042904e-01,  8.244652e-01, -5.562199e-01,  8.113927e-01,  4.537494e-01,  8.273045e-01},
  { 2.199540e-01,  6.655520e-01,  7.132046e-01,  8.376136e-01,  4.487442e-01,  9.126907e-01},
  { 2.591772e-01,  5.337452e-01, -8.049492e-01,  8.376136e-01,  4.487442e-01,  8.273045e-01},
  { 6.222197e-01,  7.137849e-01,  3.214866e-01,  8.617055e-01,  4.328697e-01,  9.126907e-01},
  { 7.137841e-01,  6.222208e-01, -3.214866e-01,  8.617055e-01,  4.328697e-01,  8.273045e-01},
  { 7.445567e-01,  3.612082e-01,  5.613947e-01,  8.775800e-01,  4.087779e-01,  9.126907e-01},
  { 7.859449e-01,  2.590878e-01, -5.613947e-01,  8.775800e-01,  4.087779e-01,  8.273045e-01},
  { 8.662342e-01,  4.636578e-02,  4.974821e-01,  8.825478e-01,  3.825942e-01,  9.126907e-01},
  { 3.683588e-01,  3.463488e-02, -9.290383e-01,  8.825478e-01,  3.825942e-01,  8.273045e-01},
  { 3.895521e-01, -4.898123e-02, -9.197010e-01,  8.825478e-01, -6.847702e-01,  8.273045e-01},
  { 3.123475e-01, -9.370425e-01, -1.561738e-01,  8.825478e-01, -5.187228e-01,  8.273045e-01},
  { 8.562545e-01, -3.203383e-02,  5.155599e-01,  8.825478e-01, -6.847702e-01,  9.126907e-01},
  { 3.123475e-01,  9.370425e-01, -1.561738e-01,  8.825478e-01,  2.165469e-01,  8.273045e-01},
  { 8.164966e-01, -4.082483e-01,  4.082483e-01,  8.825478e-01, -5.187228e-01,  8.899061e-01},
  { 6.666667e-01,  3.333333e-01,  6.666667e-01,  8.825478e-01,  2.165469e-01,  8.899061e-01},
  { 1.561738e-01,  9.370425e-01, -3.123475e-01,  8.825478e-01, -4.238493e-01,  8.273045e-01},
  { 3.123475e-01, -9.370425e-01, -1.561738e-01,  8.825478e-01,  1.216734e-01,  8.273045e-01},
  { 9.128709e-01,  1.825742e-01,  3.651484e-01,  8.825478e-01, -4.238493e-01,  8.899061e-01},
  { 9.045340e-01, -3.015113e-01,  3.015113e-01,  8.825478e-01,  1.216734e-01,  8.899061e-01},
  { 7.859449e-01, -2.590879e-01,  5.613947e-01,  8.775800e-01, -7.109538e-01,  9.126907e-01},
  { 8.520344e-01, -4.133488e-01, -3.212164e-01,  8.775800e-01, -7.109538e-01,  8.273045e-01},
  { 7.137842e-01, -6.222207e-01,  3.214866e-01,  8.617055e-01, -7.350457e-01,  9.126907e-01},
  { 5.436230e-01, -6.236225e-01, -5.617552e-01,  8.617055e-01, -7.350457e-01,  8.273045e-01},
  { 3.061830e-01, -6.305484e-01,  7.132045e-01,  8.376136e-01, -7.509201e-01,  9.126907e-01},
  { 2.596860e-01, -7.857747e-01, -5.613567e-01,  8.376136e-01, -7.509201e-01,  8.273045e-01},
  { 6.437904e-02, -5.089439e-01,  8.583890e-01,  8.113927e-01, -7.559253e-01,  9.126907e-01},
  { 5.214551e-02, -8.293975e-01, -5.562199e-01,  8.113927e-01, -7.559253e-01,  8.273045e-01},
  {-5.221749e-02, -8.293902e-01,  5.562242e-01,  6.453640e-01, -7.559253e-01,  9.126907e-01},
  {-7.520988e-02, -5.937315e-01, -8.011406e-01,  6.453640e-01, -7.559253e-01,  8.273045e-01},
  {-2.199263e-01, -6.655935e-01,  7.131745e-01,  6.191804e-01, -7.509201e-01,  9.126907e-01},
  {-3.612085e-01, -7.446101e-01, -5.613236e-01,  6.191804e-01, -7.509201e-01,  8.273045e-01},
  {-6.221202e-01, -7.138505e-01,  3.215337e-01,  5.950512e-01, -7.350457e-01,  9.126907e-01},
  {-7.140806e-01, -6.218562e-01, -3.215337e-01,  5.950512e-01, -7.350457e-01,  8.273045e-01},
  {-7.447078e-01, -3.610265e-01,  5.613112e-01,  5.792140e-01, -7.109538e-01,  9.126907e-01},
  {-6.656314e-01, -2.198485e-01, -7.131631e-01,  5.792140e-01, -7.109538e-01,  8.273045e-01},
  {-6.666667e-01, -6.666667e-01,  3.333333e-01, -8.835190e-01,  1.216734e-01,  8.899061e-01},
  {-3.333333e-01,  6.666667e-01,  6.666667e-01, -8.835190e-01,  2.165469e-01,  8.899061e-01},
  { 4.100725e-01, -4.931940e-01,  7.672029e-01, -4.728735e-01,  1.216734e-01,  8.899061e-01},
  { 3.117975e-01,  7.499974e-01,  5.833405e-01, -4.728735e-01,  2.165469e-01,  8.899061e-01},
  {-3.117975e-01, -7.499974e-01,  5.833405e-01,  4.728735e-01,  1.216734e-01,  8.899061e-01},
  {-4.100725e-01,  4.931940e-01,  7.672029e-01,  4.728735e-01,  2.165469e-01,  8.899061e-01},
  { 3.333333e-01, -6.666667e-01,  6.666667e-01,  8.835190e-01,  1.216734e-01,  8.899061e-01},
  { 6.666667e-01,  6.666667e-01,  3.333333e-01,  8.835190e-01,  2.165469e-01,  8.899061e-01},
  { 5.345225e-01, -8.017837e-01, -2.672612e-01,  8.835190e-01,  1.216734e-01, -3.509203e-02},
  { 2.672612e-01,  8.017837e-01, -5.345225e-01,  8.835190e-01,  2.165469e-01, -3.509203e-02},
  {-2.672612e-01, -8.017837e-01, -5.345225e-01, -8.835190e-01,  1.216734e-01, -3.509203e-02},
  {-5.345225e-01,  8.017837e-01, -2.672612e-01, -8.835190e-01,  2.165469e-01, -3.509203e-02},
  { 3.113353e-01, -8.978509e-01,  3.113423e-01, -3.689721e-01,  1.216734e-01,  7.344106e-01},
  {-4.464243e-01, -8.049167e-01,  3.909150e-01,  3.689721e-01,  1.216734e-01,  7.344106e-01},
  { 4.951209e-01,  7.139325e-01,  4.951320e-01, -3.689721e-01,  2.165469e-01,  7.344106e-01},
  {-3.909049e-01,  8.049167e-01,  4.464332e-01,  3.689721e-01,  2.165469e-01,  7.344106e-01},
  {-6.666667e-01,  6.666667e-01,  3.333333e-01, -8.835190e-01, -4.238493e-01,  8.899061e-01},
  {-3.333333e-01, -6.666667e-01,  6.666667e-01, -8.835190e-01, -5.187228e-01,  8.899061e-01},
  { 4.100726e-01, -4.931940e-01,  7.672029e-01, -4.728735e-01, -5.187228e-01,  8.899061e-01},
  { 3.117976e-01,  7.499974e-01,  5.833405e-01, -4.728735e-01, -4.238493e-01,  8.899061e-01},
  {-3.117976e-01, -7.499974e-01,  5.833405e-01,  4.728735e-01, -5.187228e-01,  8.899061e-01},
  {-4.100726e-01,  4.931940e-01,  7.672029e-01,  4.728735e-01, -4.238493e-01,  8.899061e-01},
  { 5.773503e-01, -5.773503e-01,  5.773503e-01,  8.835190e-01, -5.187228e-01,  8.899061e-01},
  { 4.082483e-01,  8.164966e-01,  4.082483e-01,  8.835190e-01, -4.238493e-01,  8.899061e-01},
  { 5.345225e-01,  8.017837e-01, -2.672612e-01,  8.835190e-01, -4.238493e-01, -3.509203e-02},
  { 2.672612e-01, -8.017837e-01, -5.345225e-01,  8.835190e-01, -5.187228e-01, -3.509203e-02},
  {-4.850713e-01, -7.276069e-01, -4.850713e-01, -8.835190e-01, -5.187228e-01, -3.509203e-02},
  {-3.015113e-01,  9.045340e-01, -3.015113e-01, -8.835190e-01, -4.238493e-01, -3.509203e-02},
  { 4.951209e-01,  7.139325e-01,  4.951320e-01, -3.689721e-01, -4.238493e-01,  7.344106e-01},
  {-3.909049e-01,  8.049167e-01,  4.464332e-01,  3.689721e-01, -4.238493e-01,  7.344106e-01},
  { 3.113353e-01, -8.978509e-01,  3.113423e-01, -3.689721e-01, -5.187228e-01,  7.344106e-01},
  {-4.464243e-01, -8.049167e-01,  3.909150e-01,  3.689721e-01, -5.187228e-01,  7.344106e-01},
  {-5.920877e-01,  8.049167e-01, -3.925820e-02,  5.412272e-01,  9.857132e-02, -4.695124e-02},
  {-7.838846e-01,  5.613123e-01,  2.654304e-01,  5.000283e-01,  9.857132e-02, -2.540706e-01},
  {-5.920877e-01, -8.049167e-01,  3.925822e-02,  5.412272e-01, -4.007472e-01, -4.695124e-02},
  {-7.419794e-01, -5.613124e-01,  3.665994e-01,  5.000283e-01, -4.007472e-01, -2.540706e-01},
  {-4.464293e-01,  8.049170e-01,  3.909086e-01,  3.827063e-01,  9.857132e-02, -4.296575e-01},
  {-3.909087e-01, -8.049170e-01,  4.464293e-01,  3.827063e-01, -4.007472e-01, -4.296575e-01},
  {-3.665994e-01,  5.613124e-01,  7.419794e-01,  2.071193e-01,  9.857132e-02, -5.469795e-01},
  {-2.654301e-01, -5.613124e-01,  7.838848e-01,  2.071193e-01, -4.007472e-01, -5.469795e-01},
  {-3.925790e-02,  8.049167e-01,  5.920877e-01, -5.637504e-07,  9.857132e-02, -5.881785e-01},
  { 3.925852e-02, -8.049168e-01,  5.920877e-01, -5.637504e-07, -4.007472e-01, -5.881785e-01},
  { 2.654307e-01,  5.613123e-01,  7.838846e-01, -2.071193e-01,  9.857132e-02, -5.469795e-01},
  { 3.665996e-01, -5.613123e-01,  7.419792e-01, -2.071193e-01, -4.007472e-01, -5.469795e-01},
  { 3.909087e-01,  8.049170e-01,  4.464293e-01, -3.827063e-01,  9.857132e-02, -4.296575e-01},
  { 4.464293e-01, -8.049170e-01,  3.909086e-01, -3.827063e-01, -4.007472e-01, -4.296575e-01},
  { 7.419794e-01,  5.613124e-01,  3.665994e-01, -5.000283e-01,  9.857132e-02, -2.540706e-01},
  { 7.838846e-01, -5.613123e-01,  2.654304e-01, -5.000283e-01, -4.007472e-01, -2.540706e-01},
  { 5.920877e-01,  8.049167e-01,  3.925822e-02, -5.412272e-01,  9.857132e-02, -4.695124e-02},
  { 5.920877e-01, -8.049167e-01, -3.925820e-02, -5.412272e-01, -4.007472e-01, -4.695124e-02},
  { 7.838847e-01,  5.613123e-01, -2.654304e-01, -5.000283e-01,  9.857132e-02,  1.601681e-01},
  { 7.419793e-01, -5.613123e-01, -3.665994e-01, -5.000283e-01, -4.007472e-01,  1.601681e-01},
  { 4.464293e-01,  8.049170e-01, -3.909086e-01, -3.827063e-01,  9.857132e-02,  3.357551e-01},
  { 3.909087e-01, -8.049170e-01, -4.464293e-01, -3.827063e-01, -4.007472e-01,  3.357551e-01},
  { 3.665996e-01,  5.613123e-01, -7.419792e-01, -2.071193e-01,  9.857132e-02,  4.530770e-01},
  { 2.654307e-01, -5.613123e-01, -7.838846e-01, -2.071193e-01, -4.007472e-01,  4.530770e-01},
  { 3.925852e-02,  8.049168e-01, -5.920877e-01, -5.637504e-07,  9.857132e-02,  4.942760e-01},
  {-3.925790e-02, -8.049167e-01, -5.920877e-01, -5.637504e-07, -4.007472e-01,  4.942760e-01},
  {-2.654301e-01,  5.613124e-01, -7.838848e-01,  2.071193e-01,  9.857132e-02,  4.530770e-01},
  {-3.665994e-01, -5.613124e-01, -7.419794e-01,  2.071193e-01, -4.007472e-01,  4.530770e-01},
  {-3.909087e-01,  8.049170e-01, -4.464293e-01,  3.827063e-01,  9.857132e-02,  3.357551e-01},
  {-4.464293e-01, -8.049170e-01, -3.909086e-01,  3.827063e-01, -4.007472e-01,  3.357551e-01},
  {-7.419793e-01,  5.613123e-01, -3.665994e-01,  5.000283e-01,  9.857132e-02,  1.601681e-01},
  {-7.838847e-01, -5.613123e-01, -2.654304e-01,  5.000283e-01, -4.007472e-01,  1.601681e-01},
  { 8.257931e-01, -5.613099e-01,  5.474247e-02,  7.548420e-01, -4.007472e-01, -4.695124e-02},
  { 5.620433e-01, -8.049181e-01, -1.903005e-01,  6.973950e-01, -4.007472e-01, -3.358149e-01},
  { 8.257931e-01,  5.613099e-01, -5.474250e-02,  7.548420e-01,  9.857132e-02, -4.695124e-02},
  { 5.319933e-01,  8.049180e-01, -2.628500e-01,  6.973950e-01,  9.857132e-02, -3.358149e-01},
  { 6.226361e-01, -5.613115e-01, -5.452096e-01,  5.337569e-01, -4.007472e-01, -5.807081e-01},
  { 5.452097e-01,  5.613115e-01, -6.226362e-01,  5.337569e-01,  9.857132e-02, -5.807081e-01},
  { 2.628499e-01, -8.049181e-01, -5.319933e-01,  2.888637e-01, -4.007472e-01, -7.443463e-01},
  { 1.903004e-01,  8.049181e-01, -5.620434e-01,  2.888637e-01,  9.857132e-02, -7.443463e-01},
  { 5.474217e-02, -5.613100e-01, -8.257932e-01, -5.637504e-07, -4.007472e-01, -8.017933e-01},
  {-5.474280e-02,  5.613099e-01, -8.257931e-01, -5.637504e-07,  9.857132e-02, -8.017933e-01},
  {-1.903006e-01, -8.049180e-01, -5.620432e-01, -2.888637e-01, -4.007472e-01, -7.443463e-01},
  {-2.628500e-01,  8.049180e-01, -5.319933e-01, -2.888637e-01,  9.857132e-02, -7.443463e-01},
  {-5.452097e-01, -5.613115e-01, -6.226362e-01, -5.337569e-01, -4.007472e-01, -5.807081e-01},
  {-6.226362e-01,  5.613115e-01, -5.452096e-01, -5.337569e-01,  9.857132e-02, -5.807081e-01},
  {-5.319933e-01, -8.049180e-01, -2.628500e-01, -6.973950e-01, -4.007472e-01, -3.358149e-01},
  {-5.620433e-01,  8.049181e-01, -1.903005e-01, -6.973950e-01,  9.857132e-02, -3.358149e-01},
  {-8.257931e-01, -5.613099e-01, -5.474250e-02, -7.548420e-01, -4.007472e-01, -4.695124e-02},
  {-8.257931e-01,  5.613099e-01,  5.474247e-02, -7.548420e-01,  9.857132e-02, -4.695124e-02},
  {-5.620433e-01, -8.049181e-01,  1.903005e-01, -6.973950e-01, -4.007472e-01,  2.419125e-01},
  {-5.319933e-01,  8.049180e-01,  2.628500e-01, -6.973950e-01,  9.857132e-02,  2.419125e-01},
  {-6.226362e-01, -5.613115e-01,  5.452096e-01, -5.337569e-01, -4.007472e-01,  4.868057e-01},
  {-5.452097e-01,  5.613115e-01,  6.226361e-01, -5.337569e-01,  9.857132e-02,  4.868057e-01},
  {-2.628501e-01, -8.049181e-01,  5.319933e-01, -2.888637e-01, -4.007472e-01,  6.504439e-01},
  {-1.903007e-01,  8.049181e-01,  5.620433e-01, -2.888637e-01,  9.857132e-02,  6.504439e-01},
  {-5.474280e-02, -5.613099e-01,  8.257931e-01, -5.637504e-07, -4.007472e-01,  7.078909e-01},
  { 5.474217e-02,  5.613099e-01,  8.257932e-01, -5.637504e-07,  9.857132e-02,  7.078909e-01},
  { 1.903004e-01, -8.049181e-01,  5.620434e-01,  2.888637e-01, -4.007472e-01,  6.504439e-01},
  { 2.628499e-01,  8.049181e-01,  5.319933e-01,  2.888637e-01,  9.857132e-02,  6.504439e-01},
  { 5.452097e-01, -5.613115e-01,  6.226361e-01,  5.337569e-01, -4.007472e-01,  4.868057e-01},
  { 6.226362e-01,  5.613115e-01,  5.452096e-01,  5.337569e-01,  9.857132e-02,  4.868057e-01},
  { 5.319933e-01, -8.049180e-01,  2.628500e-01,  6.973950e-01, -4.007472e-01,  2.419125e-01},
  { 5.620433e-01,  8.049181e-01,  1.903005e-01,  6.973950e-01,  9.857132e-02,  2.419125e-01},
  { 5.920923e-01,  8.049139e-01, -3.924676e-02,  7.210387e-01,  9.857132e-02, -4.695124e-02},
  { 7.419717e-01,  5.613160e-01, -3.666093e-01,  6.661690e-01,  9.857132e-02, -3.228800e-01},
  {-8.257893e-01,  5.613140e-01,  5.475920e-02,  5.750306e-01,  9.857132e-02, -4.695124e-02},
  {-5.320016e-01,  8.049152e-01,  2.628421e-01,  5.312544e-01,  9.857132e-02, -2.670055e-01},
  { 3.909185e-01,  8.049145e-01, -4.464252e-01,  5.098518e-01,  9.857132e-02, -5.568030e-01},
  {-5.451961e-01,  5.613152e-01,  6.226447e-01,  4.066115e-01,  9.857132e-02, -4.535627e-01},
  { 2.654121e-01,  5.613160e-01, -7.838883e-01,  2.759288e-01,  9.857132e-02, -7.131202e-01},
  {-1.903137e-01,  8.049152e-01,  5.620429e-01,  2.200543e-01,  9.857132e-02, -5.782056e-01},
  {-3.924704e-02,  8.049139e-01, -5.920923e-01, -5.637504e-07,  9.857132e-02, -7.679899e-01},
  { 5.475960e-02,  5.613140e-01,  8.257893e-01, -5.637504e-07,  9.857132e-02, -6.219819e-01},
  {-3.666094e-01,  5.613160e-01, -7.419716e-01, -2.759288e-01,  9.857132e-02, -7.131202e-01},
  { 2.628423e-01,  8.049151e-01,  5.320014e-01, -2.200543e-01,  9.857132e-02, -5.782056e-01},
  {-4.464251e-01,  8.049144e-01, -3.909186e-01, -5.098518e-01,  9.857132e-02, -5.568030e-01},
  { 6.226448e-01,  5.613152e-01,  5.451961e-01, -4.066115e-01,  9.857132e-02, -4.535627e-01},
  {-7.838882e-01,  5.613160e-01, -2.654122e-01, -6.661690e-01,  9.857132e-02, -3.228800e-01},
  { 5.620429e-01,  8.049152e-01,  1.903139e-01, -5.312544e-01,  9.857132e-02, -2.670055e-01},
  {-5.920923e-01,  8.049139e-01,  3.924676e-02, -7.210387e-01,  9.857132e-02, -4.695124e-02},
  { 8.257893e-01,  5.613140e-01, -5.475919e-02, -5.750306e-01,  9.857132e-02, -4.695124e-02},
  {-7.419717e-01,  5.613160e-01,  3.666093e-01, -6.661690e-01,  9.857132e-02,  2.289776e-01},
  { 5.320016e-01,  8.049152e-01, -2.628421e-01, -5.312544e-01,  9.857132e-02,  1.731030e-01},
  {-3.909186e-01,  8.049144e-01,  4.464251e-01, -5.098518e-01,  9.857132e-02,  4.629005e-01},
  { 5.451961e-01,  5.613152e-01, -6.226447e-01, -4.066115e-01,  9.857132e-02,  3.596602e-01},
  {-2.654125e-01,  5.613160e-01,  7.838881e-01, -2.759288e-01,  9.857132e-02,  6.192178e-01},
  { 1.903142e-01,  8.049152e-01, -5.620428e-01, -2.200543e-01,  9.857132e-02,  4.843031e-01},
  { 3.924657e-02,  8.049139e-01,  5.920923e-01, -5.637504e-07,  9.857132e-02,  6.740875e-01},
  {-5.475882e-02,  5.613140e-01, -8.257893e-01, -5.637504e-07,  9.857132e-02,  5.280795e-01},
  { 3.666093e-01,  5.613160e-01,  7.419717e-01,  2.759288e-01,  9.857132e-02,  6.192178e-01},
  {-2.628421e-01,  8.049152e-01, -5.320015e-01,  2.200543e-01,  9.857132e-02,  4.843031e-01},
  { 4.464251e-01,  8.049144e-01,  3.909186e-01,  5.098518e-01,  9.857132e-02,  4.629005e-01},
  {-6.226448e-01,  5.613152e-01, -5.451961e-01,  4.066115e-01,  9.857132e-02,  3.596602e-01},
  { 7.838882e-01,  5.613160e-01,  2.654122e-01,  6.661690e-01,  9.857132e-02,  2.289776e-01},
  {-5.620429e-01,  8.049152e-01, -1.903139e-01,  5.312544e-01,  9.857132e-02,  1.731030e-01},
  {-8.257893e-01, -5.613140e-01,  5.475920e-02,  5.750306e-01, -4.007472e-01, -4.695124e-02},
  {-5.320015e-01, -8.049152e-01,  2.628421e-01,  5.312544e-01, -4.007472e-01, -2.670055e-01},
  { 5.920923e-01, -8.049139e-01,  3.924675e-02,  7.210387e-01, -4.007472e-01, -4.695124e-02},
  { 7.838882e-01, -5.613160e-01, -2.654122e-01,  6.661690e-01, -4.007472e-01, -3.228800e-01},
  {-5.451961e-01, -5.613152e-01,  6.226447e-01,  4.066115e-01, -4.007472e-01, -4.535627e-01},
  { 4.464251e-01, -8.049144e-01, -3.909186e-01,  5.098518e-01, -4.007472e-01, -5.568030e-01},
  {-1.903137e-01, -8.049152e-01,  5.620429e-01,  2.200543e-01, -4.007472e-01, -5.782056e-01},
  { 3.666092e-01, -5.613160e-01, -7.419717e-01,  2.759288e-01, -4.007472e-01, -7.131202e-01},
  { 5.475960e-02, -5.613140e-01,  8.257893e-01, -5.637504e-07, -4.007472e-01, -6.219819e-01},
  { 3.924657e-02, -8.049139e-01, -5.920923e-01, -5.637504e-07, -4.007472e-01, -7.679899e-01},
  { 2.628423e-01, -8.049151e-01,  5.320014e-01, -2.200543e-01, -4.007472e-01, -5.782056e-01},
  {-2.654125e-01, -5.613160e-01, -7.838882e-01, -2.759288e-01, -4.007472e-01, -7.131202e-01},
  { 6.226447e-01, -5.613152e-01,  5.451961e-01, -4.066115e-01, -4.007472e-01, -4.535627e-01},
  {-3.909185e-01, -8.049145e-01, -4.464252e-01, -5.098518e-01, -4.007472e-01, -5.568030e-01},
  { 5.620429e-01, -8.049152e-01,  1.903139e-01, -5.312544e-01, -4.007472e-01, -2.670055e-01},
  {-7.419717e-01, -5.613160e-01, -3.666094e-01, -6.661690e-01, -4.007472e-01, -3.228800e-01},
  { 8.257893e-01, -5.613140e-01, -5.475919e-02, -5.750306e-01, -4.007472e-01, -4.695124e-02},
  {-5.920923e-01, -8.049139e-01, -3.924678e-02, -7.210387e-01, -4.007472e-01, -4.695124e-02},
  { 5.320015e-01, -8.049152e-01, -2.628421e-01, -5.312544e-01, -4.007472e-01,  1.731030e-01},
  {-7.838882e-01, -5.613160e-01,  2.654122e-01, -6.661690e-01, -4.007472e-01,  2.289776e-01},
  { 5.451961e-01, -5.613152e-01, -6.226447e-01, -4.066115e-01, -4.007472e-01,  3.596602e-01},
  {-4.464251e-01, -8.049144e-01,  3.909186e-01, -5.098518e-01, -4.007472e-01,  4.629005e-01},
  { 1.903142e-01, -8.049152e-01, -5.620428e-01, -2.200543e-01, -4.007472e-01,  4.843031e-01},
  {-3.666095e-01, -5.613160e-01,  7.419716e-01, -2.759288e-01, -4.007472e-01,  6.192178e-01},
  {-5.475883e-02, -5.613140e-01, -8.257893e-01, -5.637504e-07, -4.007472e-01,  5.280795e-01},
  {-3.924704e-02, -8.049139e-01,  5.920923e-01, -5.637504e-07, -4.007472e-01,  6.740875e-01},
  {-2.628421e-01, -8.049152e-01, -5.320015e-01,  2.200543e-01, -4.007472e-01,  4.843031e-01},
  { 2.654121e-01, -5.613160e-01,  7.838883e-01,  2.759288e-01, -4.007472e-01,  6.192178e-01},
  {-6.226447e-01, -5.613152e-01, -5.451961e-01,  4.066115e-01, -4.007472e-01,  3.596602e-01},
  { 3.909185e-01, -8.049145e-01,  4.464252e-01,  5.098518e-01, -4.007472e-01,  4.629005e-01},
  {-5.620429e-01, -8.049152e-01, -1.903139e-01,  5.312544e-01, -4.007472e-01,  1.731030e-01},
  { 7.419717e-01, -5.613160e-01,  3.666094e-01,  6.661690e-01, -4.007472e-01,  2.289776e-01},
  { 9.357910e-01,  7.538635e-02, -3.444012e-01,  6.661690e-01,  2.563079e-01, -3.228800e-01},
  { 9.937878e-01,  1.075777e-01,  2.850952e-02,  7.210387e-01,  2.563079e-01, -4.695124e-02},
  { 7.228704e-01,  1.076315e-01, -6.825494e-01,  5.098518e-01,  2.563079e-01, -5.568030e-01},
  { 4.181659e-01,  7.538560e-02, -9.052371e-01,  2.759288e-01,  2.563079e-01, -7.131202e-01},
  { 2.850917e-02,  1.075772e-01, -9.937879e-01, -5.637504e-07,  2.563079e-01, -7.679899e-01},
  {-3.444014e-01,  7.538554e-02, -9.357909e-01, -2.759288e-01,  2.563079e-01, -7.131202e-01},
  {-6.825494e-01,  1.076315e-01, -7.228705e-01, -5.098518e-01,  2.563079e-01, -5.568030e-01},
  {-9.052371e-01,  7.538632e-02, -4.181660e-01, -6.661690e-01,  2.563079e-01, -3.228800e-01},
  {-9.937878e-01,  1.075777e-01, -2.850954e-02, -7.210387e-01,  2.563079e-01, -4.695124e-02},
  {-9.357910e-01,  7.538632e-02,  3.444012e-01, -6.661690e-01,  2.563079e-01,  2.289776e-01},
  {-7.228705e-01,  1.076316e-01,  6.825494e-01, -5.098518e-01,  2.563079e-01,  4.629005e-01},
  {-4.181662e-01,  7.538553e-02,  9.052370e-01, -2.759288e-01,  2.563079e-01,  6.192178e-01},
  {-2.850996e-02,  1.075778e-01,  9.937878e-01, -5.637504e-07,  2.563079e-01,  6.740875e-01},
  { 3.444010e-01,  7.538553e-02,  9.357911e-01,  2.759288e-01,  2.563079e-01,  6.192178e-01},
  { 6.825494e-01,  1.076315e-01,  7.228705e-01,  5.098518e-01,  2.563079e-01,  4.629005e-01},
  { 9.052371e-01,  7.538623e-02,  4.181660e-01,  6.661690e-01,  2.563079e-01,  2.289776e-01},
  { 8.561103e-01,  3.492816e-01, -3.808905e-01,  6.614253e-01,  2.831638e-01, -3.209190e-01},
  { 8.999597e-01,  4.359730e-01, -1.026220e-08,  7.159215e-01,  2.831638e-01, -4.695124e-02},
  { 6.552384e-01,  3.759327e-01, -6.552383e-01,  5.062286e-01,  2.831638e-01, -5.531799e-01},
  { 3.808905e-01,  3.492811e-01, -8.561105e-01,  2.739678e-01,  2.831638e-01, -7.083765e-01},
  {-3.514802e-07,  4.359699e-01, -8.999612e-01, -5.637504e-07,  2.831638e-01, -7.628728e-01},
  {-3.808936e-01,  3.492703e-01, -8.561136e-01, -2.739678e-01,  2.831638e-01, -7.083765e-01},
  {-6.552384e-01,  3.759327e-01, -6.552383e-01, -5.062286e-01,  2.831638e-01, -5.531799e-01},
  {-8.561103e-01,  3.492815e-01, -3.808905e-01, -6.614253e-01,  2.831638e-01, -3.209190e-01},
  {-8.999597e-01,  4.359730e-01, -2.308995e-08, -7.159215e-01,  2.831638e-01, -4.695124e-02},
  {-8.561103e-01,  3.492815e-01,  3.808905e-01, -6.614253e-01,  2.831638e-01,  2.270166e-01},
  {-6.552383e-01,  3.759327e-01,  6.552383e-01, -5.062286e-01,  2.831638e-01,  4.592774e-01},
  {-3.808935e-01,  3.492710e-01,  8.561133e-01, -2.739678e-01,  2.831638e-01,  6.144741e-01},
  {-3.489147e-07,  4.359711e-01,  8.999608e-01, -5.637504e-07,  2.831638e-01,  6.689703e-01},
  { 3.808904e-01,  3.492818e-01,  8.561102e-01,  2.739678e-01,  2.831638e-01,  6.144741e-01},
  { 6.552384e-01,  3.759327e-01,  6.552383e-01,  5.062286e-01,  2.831638e-01,  4.592774e-01},
  { 8.561103e-01,  3.492815e-01,  3.808905e-01,  6.614253e-01,  2.831638e-01,  2.270166e-01},
  { 6.917873e-01,  6.774540e-01, -2.499730e-01,  6.464099e-01,  3.079281e-01, -3.146962e-01},
  { 6.559818e-01,  7.547767e-01, -1.658753e-08,  6.996735e-01,  3.079281e-01, -4.695124e-02},
  { 4.995812e-01,  7.076986e-01, -4.995811e-01,  4.947243e-01,  3.079281e-01, -5.416755e-01},
  { 2.499729e-01,  6.774540e-01, -6.917873e-01,  2.677450e-01,  3.079281e-01, -6.933611e-01},
  { 7.362312e-07,  7.547781e-01, -6.559801e-01, -5.637504e-07,  3.079281e-01, -7.466247e-01},
  {-2.499757e-01,  6.774500e-01, -6.917901e-01, -2.677487e-01,  3.079281e-01, -6.933611e-01},
  {-4.995835e-01,  7.076967e-01, -4.995816e-01, -4.947243e-01,  3.079281e-01, -5.416755e-01},
  {-6.917872e-01,  6.774540e-01, -2.499730e-01, -6.464099e-01,  3.079281e-01, -3.146962e-01},
  {-6.559818e-01,  7.547767e-01, -1.531157e-08, -6.996735e-01,  3.079281e-01, -4.695124e-02},
  {-6.917872e-01,  6.774541e-01,  2.499730e-01, -6.464099e-01,  3.079281e-01,  2.207938e-01},
  {-4.995835e-01,  7.076967e-01,  4.995816e-01, -4.947243e-01,  3.079281e-01,  4.477731e-01},
  {-2.499756e-01,  6.774502e-01,  6.917900e-01, -2.677487e-01,  3.079281e-01,  5.994586e-01},
  { 7.400591e-07,  7.547779e-01,  6.559804e-01, -5.637504e-07,  3.079281e-01,  6.527222e-01},
  { 2.499727e-01,  6.774542e-01,  6.917872e-01,  2.677450e-01,  3.079281e-01,  5.994586e-01},
  { 4.995811e-01,  7.076986e-01,  4.995811e-01,  4.947243e-01,  3.079281e-01,  4.477731e-01},
  { 6.917872e-01,  6.774540e-01,  2.499730e-01,  6.464099e-01,  3.079281e-01,  2.207938e-01},
  { 3.460657e-01,  9.271918e-01, -1.433662e-01,  6.235132e-01,  3.241761e-01, -3.052275e-01},
  { 3.744686e-01,  9.272396e-01, -4.763519e-09,  6.749093e-01,  3.241761e-01, -4.695124e-02},
  { 2.650619e-01,  9.270838e-01, -2.650619e-01,  4.772437e-01,  3.241761e-01, -5.241949e-01},
  { 1.433650e-01,  9.271927e-01, -3.460637e-01,  2.582763e-01,  3.241761e-01, -6.704645e-01},
  {-1.657705e-07,  9.272397e-01, -3.744685e-01, -5.637504e-07,  3.241761e-01, -7.218605e-01},
  {-1.433638e-01,  9.271943e-01, -3.460600e-01, -2.582763e-01,  3.241761e-01, -6.704645e-01},
  {-2.650619e-01,  9.270838e-01, -2.650618e-01, -4.772437e-01,  3.241761e-01, -5.241949e-01},
  {-3.460657e-01,  9.271918e-01, -1.433663e-01, -6.235132e-01,  3.241761e-01, -3.052275e-01},
  {-3.744686e-01,  9.272396e-01, -9.527038e-10, -6.749093e-01,  3.241761e-01, -4.695124e-02},
  {-3.460658e-01,  9.271918e-01,  1.433662e-01, -6.235132e-01,  3.241761e-01,  2.113251e-01},
  {-2.650620e-01,  9.270838e-01,  2.650619e-01, -4.772437e-01,  3.241761e-01,  4.302925e-01},
  {-1.433639e-01,  9.271942e-01,  3.460603e-01, -2.582763e-01,  3.241761e-01,  5.765620e-01},
  {-1.619597e-07,  9.272396e-01,  3.744687e-01, -5.637504e-07,  3.241761e-01,  6.279581e-01},
  { 1.433650e-01,  9.271926e-01,  3.460639e-01,  2.582763e-01,  3.241761e-01,  5.765620e-01},
  { 2.650620e-01,  9.270838e-01,  2.650619e-01,  4.772437e-01,  3.241761e-01,  4.302925e-01},
  { 3.460657e-01,  9.271918e-01,  1.433663e-01,  6.235132e-01,  3.241761e-01,  2.113251e-01},
  { 1.404101e-06,  1.000000e+00,  0.000000e+00,  6.480160e-01,  3.292933e-01, -4.695124e-02},
  {-3.215415e-02,  9.992514e-01,  2.151020e-02,  5.987117e-01,  3.292933e-01, -2.949446e-01},
  { 4.482695e-02,  9.979885e-01, -4.482624e-02,  4.582316e-01,  3.292933e-01, -5.051828e-01},
  {-2.151389e-02,  9.992512e-01,  3.216103e-02,  2.479897e-01,  3.292933e-01, -6.456629e-01},
  {-2.518844e-07,  1.000000e+00, -1.290255e-07, -5.637504e-07,  3.292933e-01, -6.949672e-01},
  { 2.151016e-02,  9.992514e-01,  3.215403e-02, -2.479934e-01,  3.292933e-01, -6.456629e-01},
  {-4.482838e-02,  9.979884e-01, -4.482837e-02, -4.582316e-01,  3.292933e-01, -5.051828e-01},
  { 3.215415e-02,  9.992514e-01,  2.151021e-02, -5.987117e-01,  3.292933e-01, -2.949446e-01},
  {-1.402204e-06,  1.000000e+00,  9.487171e-10, -6.480160e-01,  3.292933e-01, -4.695124e-02},
  { 3.215414e-02,  9.992514e-01, -2.151019e-02, -5.987117e-01,  3.292933e-01,  2.010422e-01},
  {-4.482837e-02,  9.979884e-01,  4.482833e-02, -4.582316e-01,  3.292933e-01,  4.112804e-01},
  { 2.151028e-02,  9.992514e-01, -3.215434e-02, -2.479934e-01,  3.292933e-01,  5.517604e-01},
  {-2.480895e-07,  1.000000e+00,  2.087178e-08, -5.637504e-07,  3.292933e-01,  6.010648e-01},
  {-2.151400e-02,  9.992512e-01, -3.216132e-02,  2.479897e-01,  3.292933e-01,  5.517604e-01},
  { 4.482694e-02,  9.979886e-01,  4.482619e-02,  4.582316e-01,  3.292933e-01,  4.112804e-01},
  {-3.215413e-02,  9.992514e-01, -2.151019e-02,  5.987117e-01,  3.292933e-01,  2.010422e-01},
  {-3.555279e-01,  9.268807e-01,  1.203835e-01,  5.738727e-01,  3.241761e-01, -2.846579e-01},
  {-3.745872e-01,  9.271917e-01, -1.905357e-09,  6.211601e-01,  3.241761e-01, -4.695124e-02},
  {-2.649992e-01,  9.271194e-01,  2.649998e-01,  4.392196e-01,  3.241761e-01, -4.861708e-01},
  {-1.203815e-01,  9.268827e-01,  3.555231e-01,  2.377067e-01,  3.241761e-01, -6.208239e-01},
  { 1.714821e-07,  9.271917e-01,  3.745872e-01, -5.637504e-07,  3.241761e-01, -6.681113e-01},
  { 1.203836e-01,  9.268806e-01,  3.555278e-01, -2.377067e-01,  3.241761e-01, -6.208239e-01},
  { 2.650015e-01,  9.271183e-01,  2.650015e-01, -4.392196e-01,  3.241761e-01, -4.861708e-01},
  { 3.555280e-01,  9.268806e-01,  1.203835e-01, -5.738727e-01,  3.241761e-01, -2.846579e-01},
  { 3.745872e-01,  9.271917e-01,  5.716071e-09, -6.211601e-01,  3.241761e-01, -4.695124e-02},
  { 3.555280e-01,  9.268806e-01, -1.203835e-01, -5.738727e-01,  3.241761e-01,  1.907555e-01},
  { 2.650015e-01,  9.271183e-01, -2.650015e-01, -4.392196e-01,  3.241761e-01,  3.922684e-01},
  { 1.203837e-01,  9.268806e-01, -3.555280e-01, -2.377067e-01,  3.241761e-01,  5.269215e-01},
  { 1.791036e-07,  9.271917e-01, -3.745872e-01, -5.637504e-07,  3.241761e-01,  5.742089e-01},
  {-1.203815e-01,  9.268827e-01, -3.555233e-01,  2.377067e-01,  3.241761e-01,  5.269215e-01},
  {-2.649992e-01,  9.271194e-01, -2.649997e-01,  4.392196e-01,  3.241761e-01,  3.922684e-01},
  {-3.555280e-01,  9.268806e-01, -1.203835e-01,  5.738727e-01,  3.241761e-01,  1.907555e-01},
  {-7.065899e-01,  7.076234e-01,  9.604994e-09,  5.963959e-01,  3.079281e-01, -4.695124e-02},
  {-6.342208e-01,  7.068166e-01,  3.133277e-01,  5.510135e-01,  3.079281e-01, -2.751893e-01},
  {-4.996456e-01,  7.076043e-01,  4.996502e-01,  4.217389e-01,  3.079281e-01, -4.686902e-01},
  {-3.133279e-01,  7.068131e-01,  6.342246e-01,  2.282343e-01,  3.079281e-01, -5.979646e-01},
  {-2.017051e-07,  7.076225e-01,  7.065907e-01, -5.637504e-07,  3.079281e-01, -6.433470e-01},
  { 3.133278e-01,  7.068167e-01,  6.342208e-01, -2.282380e-01,  3.079281e-01, -5.979646e-01},
  { 4.996479e-01,  7.076043e-01,  4.996479e-01, -4.217389e-01,  3.079281e-01, -4.686902e-01},
  { 6.342208e-01,  7.068166e-01,  3.133277e-01, -5.510135e-01,  3.079281e-01, -2.751893e-01},
  { 7.065899e-01,  7.076233e-01,  1.152599e-08, -5.963959e-01,  3.079281e-01, -4.695124e-02},
  { 6.342207e-01,  7.068167e-01, -3.133277e-01, -5.510135e-01,  3.079281e-01,  1.812868e-01},
  { 4.996478e-01,  7.076045e-01, -4.996478e-01, -4.217389e-01,  3.079281e-01,  3.747877e-01},
  { 3.133277e-01,  7.068168e-01, -6.342207e-01, -2.282380e-01,  3.079281e-01,  5.040622e-01},
  {-2.017051e-07,  7.076225e-01, -7.065907e-01, -5.637504e-07,  3.079281e-01,  5.494446e-01},
  {-3.133279e-01,  7.068132e-01, -6.342246e-01,  2.282343e-01,  3.079281e-01,  5.040622e-01},
  {-4.996456e-01,  7.076045e-01, -4.996502e-01,  4.217389e-01,  3.079281e-01,  3.747877e-01},
  {-6.342207e-01,  7.068168e-01, -3.133277e-01,  5.510135e-01,  3.079281e-01,  1.812868e-01},
  {-8.542116e-01,  4.120612e-01,  3.170617e-01,  5.359980e-01,  2.831638e-01, -2.689665e-01},
  {-9.495596e-01,  3.135865e-01,  5.139925e-09,  5.801478e-01,  2.831638e-01, -4.695124e-02},
  {-6.552477e-01,  3.758957e-01,  6.552503e-01,  4.102346e-01,  2.831638e-01, -4.571858e-01},
  {-3.170655e-01,  4.120453e-01,  8.542179e-01,  2.220152e-01,  2.831638e-01, -5.829492e-01},
  { 4.625933e-07,  3.135853e-01,  9.495600e-01, -5.637504e-07,  2.831638e-01, -6.270990e-01},
  { 3.170621e-01,  4.120601e-01,  8.542119e-01, -2.220152e-01,  2.831638e-01, -5.829492e-01},
  { 6.552469e-01,  3.759027e-01,  6.552470e-01, -4.102346e-01,  2.831638e-01, -4.571858e-01},
  { 8.542116e-01,  4.120612e-01,  3.170617e-01, -5.359980e-01,  2.831638e-01, -2.689665e-01},
  { 9.495596e-01,  3.135864e-01,  5.139925e-09, -5.801478e-01,  2.831638e-01, -4.695124e-02},
  { 8.542116e-01,  4.120612e-01, -3.170617e-01, -5.359980e-01,  2.831638e-01,  1.750640e-01},
  { 6.552469e-01,  3.759028e-01, -6.552470e-01, -4.102346e-01,  2.831638e-01,  3.632834e-01},
  { 3.170621e-01,  4.120605e-01, -8.542117e-01, -2.220152e-01,  2.831638e-01,  4.890468e-01},
  { 4.677331e-07,  3.135855e-01, -9.495599e-01, -5.637504e-07,  2.831638e-01,  5.331966e-01},
  {-3.170655e-01,  4.120457e-01, -8.542176e-01,  2.220152e-01,  2.831638e-01,  4.890468e-01},
  {-6.552477e-01,  3.758958e-01, -6.552502e-01,  4.102346e-01,  2.831638e-01,  3.632834e-01},
  {-8.542116e-01,  4.120613e-01, -3.170617e-01,  5.359980e-01,  2.831638e-01,  1.750640e-01},
  {-9.290544e-01,  1.076051e-01,  3.539479e-01,  5.312544e-01,  2.563079e-01, -2.670055e-01},
  {-9.963723e-01,  7.515956e-02, -3.991415e-02,  5.750306e-01,  2.563079e-01, -4.695124e-02},
  {-7.327631e-01,  7.525508e-02,  6.763098e-01,  4.066115e-01,  2.563079e-01, -4.535627e-01},
  {-4.066339e-01,  1.076046e-01,  9.072321e-01,  2.200543e-01,  2.563079e-01, -5.782056e-01},
  {-3.991367e-02,  7.515959e-02,  9.963724e-01, -5.637504e-07,  2.563079e-01, -6.219819e-01},
  { 3.539482e-01,  1.076045e-01,  9.290543e-01, -2.200543e-01,  2.563079e-01, -5.782056e-01},
  { 6.763098e-01,  7.525507e-02,  7.327630e-01, -4.066115e-01,  2.563079e-01, -4.535627e-01},
  { 9.072320e-01,  1.076051e-01,  4.066340e-01, -5.312544e-01,  2.563079e-01, -2.670055e-01},
  { 9.963723e-01,  7.515957e-02,  3.991418e-02, -5.750306e-01,  2.563079e-01, -4.695124e-02},
  { 9.290544e-01,  1.076050e-01, -3.539478e-01, -5.312544e-01,  2.563079e-01,  1.731030e-01},
  { 7.327631e-01,  7.525508e-02, -6.763098e-01, -4.066115e-01,  2.563079e-01,  3.596602e-01},
  { 4.066343e-01,  1.076048e-01, -9.072319e-01, -2.200543e-01,  2.563079e-01,  4.843031e-01},
  { 3.991468e-02,  7.515957e-02, -9.963723e-01, -5.637504e-07,  2.563079e-01,  5.280795e-01},
  {-3.539477e-01,  1.076048e-01, -9.290545e-01,  2.200543e-01,  2.563079e-01,  4.843031e-01},
  {-6.763098e-01,  7.525507e-02, -7.327630e-01,  4.066115e-01,  2.563079e-01,  3.596602e-01},
  {-9.072321e-01,  1.076051e-01, -4.066340e-01,  5.312544e-01,  2.563079e-01,  1.731030e-01},
  { 9.937878e-01, -1.075778e-01, -2.850955e-02,  7.210387e-01, -5.584838e-01, -4.695124e-02},
  { 9.052371e-01, -7.538640e-02, -4.181660e-01,  6.661690e-01, -5.584838e-01, -3.228800e-01},
  { 6.825494e-01, -1.076316e-01, -7.228706e-01,  5.098518e-01, -5.584838e-01, -5.568030e-01},
  { 3.444010e-01, -7.538562e-02, -9.357911e-01,  2.759288e-01, -5.584838e-01, -7.131202e-01},
  {-2.850995e-02, -1.075772e-01, -9.937879e-01, -5.637504e-07, -5.584838e-01, -7.679899e-01},
  {-4.181662e-01, -7.538563e-02, -9.052371e-01, -2.759288e-01, -5.584838e-01, -7.131202e-01},
  {-7.228705e-01, -1.076317e-01, -6.825494e-01, -5.098518e-01, -5.584838e-01, -5.568030e-01},
  {-9.357910e-01, -7.538642e-02, -3.444011e-01, -6.661690e-01, -5.584838e-01, -3.228800e-01},
  {-9.937878e-01, -1.075778e-01,  2.850952e-02, -7.210387e-01, -5.584838e-01, -4.695124e-02},
  {-9.052371e-01, -7.538632e-02,  4.181660e-01, -6.661690e-01, -5.584838e-01,  2.289776e-01},
  {-6.825494e-01, -1.076316e-01,  7.228705e-01, -5.098518e-01, -5.584838e-01,  4.629005e-01},
  {-3.444015e-01, -7.538562e-02,  9.357909e-01, -2.759288e-01, -5.584838e-01,  6.192178e-01},
  { 2.850917e-02, -1.075779e-01,  9.937878e-01, -5.637504e-07, -5.584838e-01,  6.740875e-01},
  { 4.181658e-01, -7.538567e-02,  9.052371e-01,  2.759288e-01, -5.584838e-01,  6.192178e-01},
  { 7.228705e-01, -1.076317e-01,  6.825494e-01,  5.098518e-01, -5.584838e-01,  4.629005e-01},
  { 9.357910e-01, -7.538640e-02,  3.444011e-01,  6.661690e-01, -5.584838e-01,  2.289776e-01},
  { 8.561103e-01, -3.492817e-01, -3.808905e-01,  6.614253e-01, -5.853397e-01, -3.209190e-01},
  { 8.999596e-01, -4.359730e-01, -1.795885e-08,  7.159215e-01, -5.853397e-01, -4.695124e-02},
  { 6.552383e-01, -3.759328e-01, -6.552383e-01,  5.062286e-01, -5.853397e-01, -5.531799e-01},
  { 3.808905e-01, -3.492812e-01, -8.561105e-01,  2.739678e-01, -5.853397e-01, -7.083765e-01},
  {-3.463491e-07, -4.359699e-01, -8.999612e-01, -5.637504e-07, -5.853397e-01, -7.628728e-01},
  {-3.808937e-01, -3.492704e-01, -8.561135e-01, -2.739678e-01, -5.853397e-01, -7.083765e-01},
  {-6.552383e-01, -3.759328e-01, -6.552383e-01, -5.062286e-01, -5.853397e-01, -5.531799e-01},
  {-8.561102e-01, -3.492817e-01, -3.808905e-01, -6.614253e-01, -5.853397e-01, -3.209190e-01},
  {-8.999597e-01, -4.359731e-01, -1.026220e-08, -7.159215e-01, -5.853397e-01, -4.695124e-02},
  {-8.561103e-01, -3.492816e-01,  3.808905e-01, -6.614253e-01, -5.853397e-01,  2.270166e-01},
  {-6.552383e-01, -3.759328e-01,  6.552383e-01, -5.062286e-01, -5.853397e-01,  4.592774e-01},
  {-3.808935e-01, -3.492711e-01,  8.561133e-01, -2.739678e-01, -5.853397e-01,  6.144741e-01},
  {-3.566113e-07, -4.359711e-01,  8.999607e-01, -5.637504e-07, -5.853397e-01,  6.689703e-01},
  { 3.808903e-01, -3.492819e-01,  8.561102e-01,  2.739678e-01, -5.853397e-01,  6.144741e-01},
  { 6.552383e-01, -3.759328e-01,  6.552382e-01,  5.062286e-01, -5.853397e-01,  4.592774e-01},
  { 8.561103e-01, -3.492817e-01,  3.808905e-01,  6.614253e-01, -5.853397e-01,  2.270166e-01},
  { 6.917874e-01, -6.774537e-01, -2.499731e-01,  6.464099e-01, -6.101040e-01, -3.146962e-01},
  { 6.559823e-01, -7.547764e-01, -1.658753e-08,  6.996735e-01, -6.101040e-01, -4.695124e-02},
  { 4.995814e-01, -7.076983e-01, -4.995814e-01,  4.947243e-01, -6.101040e-01, -5.416755e-01},
  { 2.499729e-01, -6.774538e-01, -6.917875e-01,  2.677450e-01, -6.101040e-01, -6.933611e-01},
  { 7.362312e-07, -7.547778e-01, -6.559805e-01, -5.637504e-07, -6.101040e-01, -7.466247e-01},
  {-2.499758e-01, -6.774498e-01, -6.917903e-01, -2.677487e-01, -6.101040e-01, -6.933611e-01},
  {-4.995838e-01, -7.076964e-01, -4.995818e-01, -4.947243e-01, -6.101040e-01, -5.416755e-01},
  {-6.917874e-01, -6.774537e-01, -2.499731e-01, -6.464099e-01, -6.101040e-01, -3.146962e-01},
  {-6.559823e-01, -7.547764e-01, -1.786349e-08, -6.996735e-01, -6.101040e-01, -4.695124e-02},
  {-6.917874e-01, -6.774538e-01,  2.499731e-01, -6.464099e-01, -6.101040e-01,  2.207938e-01},
  {-4.995837e-01, -7.076964e-01,  4.995818e-01, -4.947243e-01, -6.101040e-01,  4.477731e-01},
  {-2.499757e-01, -6.774499e-01,  6.917903e-01, -2.677487e-01, -6.101040e-01,  5.994586e-01},
  { 7.349552e-07, -7.547776e-01,  6.559808e-01, -5.637504e-07, -6.101040e-01,  6.527222e-01},
  { 2.499728e-01, -6.774539e-01,  6.917874e-01,  2.677450e-01, -6.101040e-01,  5.994586e-01},
  { 4.995813e-01, -7.076983e-01,  4.995813e-01,  4.947243e-01, -6.101040e-01,  4.477731e-01},
  { 6.917874e-01, -6.774538e-01,  2.499731e-01,  6.464099e-01, -6.101040e-01,  2.207938e-01},
  { 3.460661e-01, -9.271917e-01, -1.433664e-01,  6.235132e-01, -6.263520e-01, -3.052275e-01},
  { 3.744690e-01, -9.272394e-01, -6.668928e-09,  6.749093e-01, -6.263520e-01, -4.695124e-02},
  { 2.650622e-01, -9.270837e-01, -2.650621e-01,  4.772437e-01, -6.263520e-01, -5.241949e-01},
  { 1.433651e-01, -9.271926e-01, -3.460640e-01,  2.582763e-01, -6.263520e-01, -6.704645e-01},
  {-1.648178e-07, -9.272395e-01, -3.744689e-01, -5.637504e-07, -6.263520e-01, -7.218605e-01},
  {-1.433640e-01, -9.271941e-01, -3.460604e-01, -2.582763e-01, -6.263520e-01, -6.704645e-01},
  {-2.650622e-01, -9.270837e-01, -2.650622e-01, -4.772437e-01, -6.263520e-01, -5.241949e-01},
  {-3.460661e-01, -9.271916e-01, -1.433664e-01, -6.235132e-01, -6.263520e-01, -3.052275e-01},
  {-3.744690e-01, -9.272394e-01, -2.858112e-09, -6.749093e-01, -6.263520e-01, -4.695124e-02},
  {-3.460661e-01, -9.271916e-01,  1.433664e-01, -6.235132e-01, -6.263520e-01,  2.113251e-01},
  {-2.650623e-01, -9.270837e-01,  2.650622e-01, -4.772437e-01, -6.263520e-01,  4.302925e-01},
  {-1.433641e-01, -9.271941e-01,  3.460606e-01, -2.582763e-01, -6.263520e-01,  5.765620e-01},
  {-1.648178e-07, -9.272394e-01,  3.744690e-01, -5.637504e-07, -6.263520e-01,  6.279581e-01},
  { 1.433652e-01, -9.271925e-01,  3.460643e-01,  2.582763e-01, -6.263520e-01,  5.765620e-01},
  { 2.650623e-01, -9.270837e-01,  2.650622e-01,  4.772437e-01, -6.263520e-01,  4.302925e-01},
  { 3.460661e-01, -9.271916e-01,  1.433664e-01,  6.235132e-01, -6.263520e-01,  2.113251e-01},
  { 1.402204e-06, -1.000000e+00,  9.487171e-10,  6.480160e-01, -6.314692e-01, -4.695124e-02},
  {-3.215415e-02, -9.992514e-01,  2.151021e-02,  5.987117e-01, -6.314692e-01, -2.949446e-01},
  { 4.482695e-02, -9.979886e-01, -4.482622e-02,  4.582316e-01, -6.314692e-01, -5.051828e-01},
  {-2.151389e-02, -9.992512e-01,  3.216105e-02,  2.479897e-01, -6.314692e-01, -6.456629e-01},
  {-2.471408e-07, -1.000000e+00, -1.271281e-07, -5.637504e-07, -6.314692e-01, -6.949672e-01},
  { 2.151016e-02, -9.992514e-01,  3.215404e-02, -2.479934e-01, -6.314692e-01, -6.456629e-01},
  {-4.482838e-02, -9.979883e-01, -4.482836e-02, -4.582316e-01, -6.314692e-01, -5.051828e-01},
  { 3.215415e-02, -9.992514e-01,  2.151020e-02, -5.987117e-01, -6.314692e-01, -2.949446e-01},
  {-1.404101e-06, -1.000000e+00,  0.000000e+00, -6.480160e-01, -6.314692e-01, -4.695124e-02},
  { 3.215413e-02, -9.992514e-01, -2.151019e-02, -5.987117e-01, -6.314692e-01,  2.010422e-01},
  {-4.482837e-02, -9.979884e-01,  4.482833e-02, -4.582316e-01, -6.314692e-01,  4.112804e-01},
  { 2.151027e-02, -9.992514e-01, -3.215432e-02, -2.479934e-01, -6.314692e-01,  5.517604e-01},
  {-2.514100e-07, -1.000000e+00,  3.225638e-08, -5.637504e-07, -6.314692e-01,  6.010648e-01},
  {-2.151400e-02, -9.992512e-01, -3.216131e-02,  2.479897e-01, -6.314692e-01,  5.517604e-01},
  { 4.482693e-02, -9.979886e-01,  4.482620e-02,  4.582316e-01, -6.314692e-01,  4.112804e-01},
  {-3.215414e-02, -9.992514e-01, -2.151019e-02,  5.987117e-01, -6.314692e-01,  2.010422e-01},
  {-3.555283e-01, -9.268805e-01,  1.203837e-01,  5.738727e-01, -6.263520e-01, -2.846579e-01},
  {-3.745877e-01, -9.271915e-01,  5.716071e-09,  6.211601e-01, -6.263520e-01, -4.695124e-02},
  {-2.649995e-01, -9.271193e-01,  2.650000e-01,  4.392196e-01, -6.263520e-01, -4.861708e-01},
  {-1.203816e-01, -9.268826e-01,  3.555235e-01,  2.377067e-01, -6.263520e-01, -6.208239e-01},
  { 1.791036e-07, -9.271915e-01,  3.745877e-01, -5.637504e-07, -6.263520e-01, -6.681113e-01},
  { 1.203837e-01, -9.268805e-01,  3.555282e-01, -2.377067e-01, -6.263520e-01, -6.208239e-01},
  { 2.650018e-01, -9.271182e-01,  2.650018e-01, -4.392196e-01, -6.263520e-01, -4.861708e-01},
  { 3.555283e-01, -9.268805e-01,  1.203837e-01, -5.738727e-01, -6.263520e-01, -2.846579e-01},
  { 3.745877e-01, -9.271915e-01,  1.905357e-09, -6.211601e-01, -6.263520e-01, -4.695124e-02},
  { 3.555284e-01, -9.268805e-01, -1.203836e-01, -5.738727e-01, -6.263520e-01,  1.907555e-01},
  { 2.650017e-01, -9.271182e-01, -2.650018e-01, -4.392196e-01, -6.263520e-01,  3.922684e-01},
  { 1.203838e-01, -9.268805e-01, -3.555283e-01, -2.377067e-01, -6.263520e-01,  5.269215e-01},
  { 1.752929e-07, -9.271915e-01, -3.745876e-01, -5.637504e-07, -6.263520e-01,  5.742089e-01},
  {-1.203816e-01, -9.268825e-01, -3.555236e-01,  2.377067e-01, -6.263520e-01,  5.269215e-01},
  {-2.649995e-01, -9.271193e-01, -2.650000e-01,  4.392196e-01, -6.263520e-01,  3.922684e-01},
  {-3.555284e-01, -9.268805e-01, -1.203837e-01,  5.738727e-01, -6.263520e-01,  1.907555e-01},
  {-7.065902e-01, -7.076229e-01,  1.152599e-08,  5.963959e-01, -6.101040e-01, -4.695124e-02},
  {-6.342211e-01, -7.068163e-01,  3.133279e-01,  5.510135e-01, -6.101040e-01, -2.751893e-01},
  {-4.996458e-01, -7.076041e-01,  4.996505e-01,  4.217389e-01, -6.101040e-01, -4.686902e-01},
  {-3.133280e-01, -7.068128e-01,  6.342249e-01,  2.282343e-01, -6.101040e-01, -5.979646e-01},
  {-2.055471e-07, -7.076222e-01,  7.065910e-01, -5.637504e-07, -6.101040e-01, -6.433470e-01},
  { 3.133278e-01, -7.068164e-01,  6.342210e-01, -2.282380e-01, -6.101040e-01, -5.979646e-01},
  { 4.996481e-01, -7.076041e-01,  4.996482e-01, -4.217389e-01, -6.101040e-01, -4.686902e-01},
  { 6.342211e-01, -7.068163e-01,  3.133279e-01, -5.510135e-01, -6.101040e-01, -2.751893e-01},
  { 7.065901e-01, -7.076230e-01,  5.762995e-09, -5.963959e-01, -6.101040e-01, -4.695124e-02},
  { 6.342210e-01, -7.068164e-01, -3.133278e-01, -5.510135e-01, -6.101040e-01,  1.812868e-01},
  { 4.996480e-01, -7.076042e-01, -4.996480e-01, -4.217389e-01, -6.101040e-01,  3.747877e-01},
  { 3.133279e-01, -7.068164e-01, -6.342210e-01, -2.282380e-01, -6.101040e-01,  5.040622e-01},
  {-1.997841e-07, -7.076222e-01, -7.065910e-01, -5.637504e-07, -6.101040e-01,  5.494446e-01},
  {-3.133280e-01, -7.068129e-01, -6.342248e-01,  2.282343e-01, -6.101040e-01,  5.040622e-01},
  {-4.996457e-01, -7.076042e-01, -4.996503e-01,  4.217389e-01, -6.101040e-01,  3.747877e-01},
  {-6.342210e-01, -7.068164e-01, -3.133278e-01,  5.510135e-01, -6.101040e-01,  1.812868e-01},
  {-8.542116e-01, -4.120612e-01,  3.170617e-01,  5.359980e-01, -5.853397e-01, -2.689665e-01},
  {-9.495596e-01, -3.135866e-01,  1.284981e-08,  5.801478e-01, -5.853397e-01, -4.695124e-02},
  {-6.552477e-01, -3.758957e-01,  6.552502e-01,  4.102346e-01, -5.853397e-01, -4.571858e-01},
  {-3.170655e-01, -4.120454e-01,  8.542178e-01,  2.220152e-01, -5.853397e-01, -5.829492e-01},
  { 4.651632e-07, -3.135853e-01,  9.495600e-01, -5.637504e-07, -5.853397e-01, -6.270990e-01},
  { 3.170621e-01, -4.120602e-01,  8.542118e-01, -2.220152e-01, -5.853397e-01, -5.829492e-01},
  { 6.552469e-01, -3.759028e-01,  6.552470e-01, -4.102346e-01, -5.853397e-01, -4.571858e-01},
  { 8.542116e-01, -4.120612e-01,  3.170617e-01, -5.359980e-01, -5.853397e-01, -2.689665e-01},
  { 9.495596e-01, -3.135866e-01,  5.139925e-09, -5.801478e-01, -5.853397e-01, -4.695124e-02},
  { 8.542115e-01, -4.120613e-01, -3.170617e-01, -5.359980e-01, -5.853397e-01,  1.750640e-01},
  { 6.552469e-01, -3.759029e-01, -6.552469e-01, -4.102346e-01, -5.853397e-01,  3.632834e-01},
  { 3.170621e-01, -4.120606e-01, -8.542117e-01, -2.220152e-01, -5.853397e-01,  4.890468e-01},
  { 4.625932e-07, -3.135857e-01, -9.495599e-01, -5.637504e-07, -5.853397e-01,  5.331966e-01},
  {-3.170655e-01, -4.120457e-01, -8.542176e-01,  2.220152e-01, -5.853397e-01,  4.890468e-01},
  {-6.552477e-01, -3.758958e-01, -6.552502e-01,  4.102346e-01, -5.853397e-01,  3.632834e-01},
  {-8.542115e-01, -4.120613e-01, -3.170617e-01,  5.359980e-01, -5.853397e-01,  1.750640e-01},
  {-9.290543e-01, -1.076052e-01,  3.539479e-01,  5.312544e-01, -5.584838e-01, -2.670055e-01},
  {-9.963723e-01, -7.515965e-02, -3.991415e-02,  5.750306e-01, -5.584838e-01, -4.695124e-02},
  {-7.327631e-01, -7.525516e-02,  6.763098e-01,  4.066115e-01, -5.584838e-01, -4.535627e-01},
  {-4.066339e-01, -1.076047e-01,  9.072321e-01,  2.200543e-01, -5.584838e-01, -5.782056e-01},
  {-3.991368e-02, -7.515965e-02,  9.963724e-01, -5.637504e-07, -5.584838e-01, -6.219819e-01},
  { 3.539482e-01, -1.076046e-01,  9.290543e-01, -2.200543e-01, -5.584838e-01, -5.782056e-01},
  { 6.763098e-01, -7.525516e-02,  7.327630e-01, -4.066115e-01, -5.584838e-01, -4.535627e-01},
  { 9.072320e-01, -1.076053e-01,  4.066340e-01, -5.312544e-01, -5.584838e-01, -2.670055e-01},
  { 9.963723e-01, -7.515965e-02,  3.991417e-02, -5.750306e-01, -5.584838e-01, -4.695124e-02},
  { 9.290544e-01, -1.076052e-01, -3.539478e-01, -5.312544e-01, -5.584838e-01,  1.731030e-01},
  { 7.327631e-01, -7.525516e-02, -6.763098e-01, -4.066115e-01, -5.584838e-01,  3.596602e-01},
  { 4.066343e-01, -1.076050e-01, -9.072319e-01, -2.200543e-01, -5.584838e-01,  4.843031e-01},
  { 3.991468e-02, -7.515968e-02, -9.963723e-01, -5.637504e-07, -5.584838e-01,  5.280795e-01},
  {-3.539477e-01, -1.076049e-01, -9.290544e-01,  2.200543e-01, -5.584838e-01,  4.843031e-01},
  {-6.763098e-01, -7.525516e-02, -7.327630e-01,  4.066115e-01, -5.584838e-01,  3.596602e-01},
  {-9.072320e-01, -1.076052e-01, -4.066340e-01,  5.312544e-01, -5.584838e-01,  1.731030e-01},
  {-5.920870e-01,  8.049171e-01, -3.925973e-02,  1.684005e-01, -6.764783e-02, -4.695122e-02},
  {-6.639666e-01,  7.131634e-01,  2.248251e-01,  1.555814e-01, -6.764783e-02, -1.113942e-01},
  {-5.920870e-01, -8.049171e-01,  3.925973e-02,  1.684005e-01, -2.345281e-01, -4.695122e-02},
  {-6.284744e-01, -7.131634e-01,  3.105125e-01,  1.555814e-01, -2.345281e-01, -1.113942e-01},
  {-6.226419e-01,  5.613140e-01,  5.452005e-01,  1.190775e-01, -6.764783e-02, -1.660287e-01},
  {-5.452006e-01, -5.613140e-01,  6.226419e-01,  1.190775e-01, -2.345281e-01, -1.660287e-01},
  {-3.105125e-01,  7.131634e-01,  6.284743e-01,  6.444302e-02, -6.764783e-02, -2.025326e-01},
  {-2.248251e-01, -7.131634e-01,  6.639666e-01,  6.444302e-02, -2.345281e-01, -2.025326e-01},
  {-3.925973e-02,  8.049171e-01,  5.920870e-01,  0.000000e+00, -6.764783e-02, -2.153517e-01},
  { 3.925973e-02, -8.049171e-01,  5.920870e-01,  0.000000e+00, -2.345281e-01, -2.153517e-01},
  { 2.248251e-01,  7.131634e-01,  6.639666e-01, -6.444302e-02, -6.764783e-02, -2.025326e-01},
  { 3.105125e-01, -7.131634e-01,  6.284743e-01, -6.444302e-02, -2.345281e-01, -2.025326e-01},
  { 5.452006e-01,  5.613140e-01,  6.226419e-01, -1.190775e-01, -6.764783e-02, -1.660287e-01},
  { 6.226419e-01, -5.613140e-01,  5.452005e-01, -1.190775e-01, -2.345281e-01, -1.660287e-01},
  { 6.284744e-01,  7.131634e-01,  3.105125e-01, -1.555814e-01, -6.764783e-02, -1.113942e-01},
  { 6.639666e-01, -7.131634e-01,  2.248251e-01, -1.555814e-01, -2.345281e-01, -1.113942e-01},
  { 5.920870e-01,  8.049171e-01,  3.925973e-02, -1.684005e-01, -6.764783e-02, -4.695122e-02},
  { 5.920870e-01, -8.049171e-01, -3.925973e-02, -1.684005e-01, -2.345281e-01, -4.695122e-02},
  { 6.639666e-01,  7.131634e-01, -2.248251e-01, -1.555814e-01, -6.764783e-02,  1.749181e-02},
  { 6.284744e-01, -7.131634e-01, -3.105125e-01, -1.555814e-01, -2.345281e-01,  1.749181e-02},
  { 6.226419e-01,  5.613140e-01, -5.452005e-01, -1.190775e-01, -6.764783e-02,  7.212625e-02},
  { 5.452006e-01, -5.613140e-01, -6.226419e-01, -1.190775e-01, -2.345281e-01,  7.212625e-02},
  { 3.105125e-01,  7.131634e-01, -6.284743e-01, -6.444302e-02, -6.764783e-02,  1.086301e-01},
  { 2.248251e-01, -7.131634e-01, -6.639666e-01, -6.444302e-02, -2.345281e-01,  1.086301e-01},
  { 3.925973e-02,  8.049171e-01, -5.920870e-01,  0.000000e+00, -6.764783e-02,  1.214493e-01},
  {-3.925973e-02, -8.049171e-01, -5.920870e-01,  0.000000e+00, -2.345281e-01,  1.214493e-01},
  {-2.248251e-01,  7.131634e-01, -6.639666e-01,  6.444302e-02, -6.764783e-02,  1.086301e-01},
  {-3.105125e-01, -7.131634e-01, -6.284743e-01,  6.444302e-02, -2.345281e-01,  1.086301e-01},
  {-5.452006e-01,  5.613140e-01, -6.226419e-01,  1.190775e-01, -6.764783e-02,  7.212625e-02},
  {-6.226419e-01, -5.613140e-01, -5.452005e-01,  1.190775e-01, -2.345281e-01,  7.212625e-02},
  {-6.284744e-01,  7.131634e-01, -3.105125e-01,  1.555814e-01, -6.764783e-02,  1.749181e-02},
  {-6.639666e-01, -7.131634e-01, -2.248251e-01,  1.555814e-01, -2.345281e-01,  1.749181e-02},
  { 8.257903e-01, -5.613129e-01,  5.475459e-02,  2.253246e-01, -2.345281e-01, -4.695122e-02},
  { 6.639647e-01, -7.131643e-01, -2.248279e-01,  2.081727e-01, -2.345281e-01, -1.331778e-01},
  { 8.257903e-01,  5.613129e-01, -5.475461e-02,  2.253246e-01, -6.764783e-02, -4.695122e-02},
  { 6.284690e-01,  7.131643e-01, -3.105211e-01,  2.081727e-01, -6.764783e-02, -1.331778e-01},
  { 4.464285e-01, -8.049165e-01, -3.909103e-01,  1.593277e-01, -2.345281e-01, -2.062790e-01},
  { 3.909102e-01,  8.049165e-01, -4.464286e-01,  1.593277e-01, -6.764783e-02, -2.062790e-01},
  { 3.105211e-01, -7.131643e-01, -6.284691e-01,  8.622658e-02, -2.345281e-01, -2.551239e-01},
  { 2.248279e-01,  7.131643e-01, -6.639647e-01,  8.622658e-02, -6.764783e-02, -2.551239e-01},
  { 5.475464e-02, -5.613129e-01, -8.257903e-01,  0.000000e+00, -2.345281e-01, -2.722758e-01},
  {-5.475464e-02,  5.613129e-01, -8.257903e-01,  0.000000e+00, -6.764783e-02, -2.722758e-01},
  {-2.248279e-01, -7.131643e-01, -6.639647e-01, -8.622658e-02, -2.345281e-01, -2.551239e-01},
  {-3.105211e-01,  7.131643e-01, -6.284691e-01, -8.622658e-02, -6.764783e-02, -2.551239e-01},
  {-3.909102e-01, -8.049165e-01, -4.464286e-01, -1.593277e-01, -2.345281e-01, -2.062790e-01},
  {-4.464286e-01,  8.049166e-01, -3.909104e-01, -1.593277e-01, -6.764783e-02, -2.062790e-01},
  {-6.284690e-01, -7.131643e-01, -3.105211e-01, -2.081727e-01, -2.345281e-01, -1.331778e-01},
  {-6.639647e-01,  7.131643e-01, -2.248279e-01, -2.081727e-01, -6.764783e-02, -1.331778e-01},
  {-8.257903e-01, -5.613129e-01, -5.475461e-02, -2.253246e-01, -2.345281e-01, -4.695122e-02},
  {-8.257903e-01,  5.613129e-01,  5.475459e-02, -2.253246e-01, -6.764783e-02, -4.695122e-02},
  {-6.639647e-01, -7.131643e-01,  2.248279e-01, -2.081727e-01, -2.345281e-01,  3.927536e-02},
  {-6.284690e-01,  7.131643e-01,  3.105211e-01, -2.081727e-01, -6.764783e-02,  3.927536e-02},
  {-4.464286e-01, -8.049165e-01,  3.909103e-01, -1.593277e-01, -2.345281e-01,  1.123765e-01},
  {-3.909103e-01,  8.049165e-01,  4.464286e-01, -1.593277e-01, -6.764783e-02,  1.123765e-01},
  {-3.105211e-01, -7.131643e-01,  6.284690e-01, -8.622658e-02, -2.345281e-01,  1.612214e-01},
  {-2.248278e-01,  7.131643e-01,  6.639647e-01, -8.622658e-02, -6.764783e-02,  1.612214e-01},
  {-5.475460e-02, -5.613129e-01,  8.257903e-01,  0.000000e+00, -2.345281e-01,  1.783734e-01},
  { 5.475460e-02,  5.613129e-01,  8.257903e-01,  0.000000e+00, -6.764783e-02,  1.783734e-01},
  { 2.248279e-01, -7.131643e-01,  6.639647e-01,  8.622658e-02, -2.345281e-01,  1.612214e-01},
  { 3.105211e-01,  7.131643e-01,  6.284690e-01,  8.622658e-02, -6.764783e-02,  1.612214e-01},
  { 3.909103e-01, -8.049165e-01,  4.464286e-01,  1.593277e-01, -2.345281e-01,  1.123765e-01},
  { 4.464286e-01,  8.049165e-01,  3.909103e-01,  1.593277e-01, -6.764783e-02,  1.123765e-01},
  { 6.284690e-01, -7.131643e-01,  3.105211e-01,  2.081727e-01, -2.345281e-01,  3.927536e-02},
  { 6.639647e-01,  7.131643e-01,  2.248279e-01,  2.081727e-01, -6.764783e-02,  3.927536e-02},
};

static GLushort motor_indices[][3] =
{
  {   0,    1,    2},
  {   3,    2,    1},
  {   4,    0,    5},
  {   2,    5,    0},
  {   4,    5,    6},
  {   7,    6,    5},
  {   6,    7,    8},
  {   9,    8,    7},
  {  10,    8,   11},
  {   9,   11,    8},
  {  12,   10,   13},
  {  11,   13,   10},
  {  12,   13,   14},
  {  15,   14,   13},
  {  14,   15,   16},
  {  17,   16,   15},
  {  18,   16,   19},
  {  17,   19,   16},
  {  20,   18,   21},
  {  19,   21,   18},
  {  20,   21,   22},
  {  23,   22,   21},
  {  22,   23,   24},
  {  25,   24,   23},
  {  26,   24,   27},
  {  25,   27,   24},
  {  28,   26,   29},
  {  27,   29,   26},
  {  28,   29,   30},
  {  31,   30,   29},
  {  30,   31,    1},
  {   3,    1,   31},
  {  32,   33,    0},
  {   1,    0,   33},
  {  32,    0,   34},
  {  34,    0,    4},
  {  35,   34,    6},
  {  34,    4,    6},
  {  35,    6,   36},
  {   8,   36,    6},
  {  37,   36,   10},
  {   8,   10,   36},
  {  37,   10,   38},
  {  38,   10,   12},
  {  39,   38,   14},
  {  38,   12,   14},
  {  39,   14,   40},
  {  16,   40,   14},
  {  41,   40,   18},
  {  16,   18,   40},
  {  41,   18,   42},
  {  42,   18,   20},
  {  43,   42,   22},
  {  42,   20,   22},
  {  43,   22,   44},
  {  24,   44,   22},
  {  45,   44,   26},
  {  24,   26,   44},
  {  45,   26,   46},
  {  46,   26,   28},
  {  47,   46,   30},
  {  46,   28,   30},
  {  47,   30,   33},
  {   1,   33,   30},
  {  48,   33,   49},
  {  32,   49,   33},
  {  50,   49,   34},
  {  34,   49,   32},
  {  50,   34,   51},
  {  35,   51,   34},
  {  52,   51,   36},
  {  35,   36,   51},
  {  52,   36,   53},
  {  37,   53,   36},
  {  54,   53,   38},
  {  38,   53,   37},
  {  54,   38,   55},
  {  39,   55,   38},
  {  56,   55,   40},
  {  39,   40,   55},
  {  56,   40,   57},
  {  41,   57,   40},
  {  58,   57,   42},
  {  42,   57,   41},
  {  58,   42,   59},
  {  43,   59,   42},
  {  60,   59,   44},
  {  43,   44,   59},
  {  60,   44,   61},
  {  45,   61,   44},
  {  62,   61,   46},
  {  46,   61,   45},
  {  62,   46,   63},
  {  47,   63,   46},
  {  48,   63,   33},
  {  47,   33,   63},
  {  64,   48,   65},
  {  49,   65,   48},
  {  65,   49,   66},
  {  50,   66,   49},
  {  67,   66,   51},
  {  50,   51,   66},
  {  68,   67,   52},
  {  51,   52,   67},
  {  68,   52,   69},
  {  53,   69,   52},
  {  69,   53,   70},
  {  54,   70,   53},
  {  71,   70,   55},
  {  54,   55,   70},
  {  72,   71,   56},
  {  55,   56,   71},
  {  72,   56,   73},
  {  57,   73,   56},
  {  73,   57,   74},
  {  58,   74,   57},
  {  75,   74,   59},
  {  58,   59,   74},
  {  76,   75,   60},
  {  59,   60,   75},
  {  76,   60,   77},
  {  61,   77,   60},
  {  77,   61,   78},
  {  62,   78,   61},
  {  79,   78,   63},
  {  62,   63,   78},
  {  64,   79,   48},
  {  63,   48,   79},
  {  80,   81,   65},
  {  64,   65,   81},
  {  82,   80,   66},
  {  65,   66,   80},
  {  82,   66,   83},
  {  67,   83,   66},
  {  83,   67,   84},
  {  68,   84,   67},
  {  85,   84,   69},
  {  68,   69,   84},
  {  86,   85,   70},
  {  69,   70,   85},
  {  86,   70,   87},
  {  71,   87,   70},
  {  87,   71,   88},
  {  72,   88,   71},
  {  89,   88,   73},
  {  72,   73,   88},
  {  90,   89,   74},
  {  73,   74,   89},
  {  90,   74,   91},
  {  75,   91,   74},
  {  91,   75,   92},
  {  76,   92,   75},
  {  93,   92,   77},
  {  76,   77,   92},
  {  94,   93,   78},
  {  77,   78,   93},
  {  94,   78,   95},
  {  79,   95,   78},
  {  95,   79,   81},
  {  64,   81,   79},
  {  96,   81,   97},
  {  80,   97,   81},
  {  97,   80,   98},
  {  82,   98,   80},
  {  99,   98,   83},
  {  82,   83,   98},
  { 100,   99,   84},
  {  83,   84,   99},
  { 100,   84,  101},
  {  85,  101,   84},
  { 101,   85,  102},
  {  86,  102,   85},
  { 103,  102,   87},
  {  86,   87,  102},
  { 104,  103,   88},
  {  87,   88,  103},
  { 104,   88,  105},
  {  89,  105,   88},
  { 105,   89,  106},
  {  90,  106,   89},
  { 107,  106,   91},
  {  90,   91,  106},
  { 108,  107,   92},
  {  91,   92,  107},
  { 108,   92,  109},
  {  93,  109,   92},
  { 109,   93,  110},
  {  94,  110,   93},
  { 111,  110,   95},
  {  94,   95,  110},
  {  96,  111,   81},
  {  95,   81,  111},
  {  96,   97,  112},
  { 113,  112,   97},
  {  97,   98,  113},
  { 113,   98,  114},
  {  98,   99,  114},
  { 114,   99,  115},
  {  99,  100,  115},
  { 116,  115,  100},
  { 100,  101,  116},
  { 117,  116,  101},
  { 101,  102,  117},
  { 117,  102,  118},
  { 102,  103,  118},
  { 118,  103,  119},
  { 103,  104,  119},
  { 120,  119,  104},
  { 104,  105,  120},
  { 121,  120,  105},
  { 105,  106,  121},
  { 121,  106,  122},
  { 106,  107,  122},
  { 122,  107,  123},
  { 107,  108,  123},
  { 124,  123,  108},
  { 108,  109,  124},
  { 125,  124,  109},
  { 109,  110,  125},
  { 125,  110,  126},
  { 110,  111,  126},
  { 126,  111,  127},
  { 111,   96,  127},
  { 112,  127,   96},
  { 113,  128,  112},
  { 129,  112,  128},
  { 113,  114,  128},
  { 128,  114,  130},
  { 115,  131,  114},
  { 131,  130,  114},
  { 115,  116,  131},
  { 132,  131,  116},
  { 117,  133,  116},
  { 132,  116,  133},
  { 117,  118,  133},
  { 133,  118,  134},
  { 119,  135,  118},
  { 135,  134,  118},
  { 119,  120,  135},
  { 136,  135,  120},
  { 121,  137,  120},
  { 136,  120,  137},
  { 121,  122,  137},
  { 137,  122,  138},
  { 123,  139,  122},
  { 139,  138,  122},
  { 123,  124,  139},
  { 140,  139,  124},
  { 125,  141,  124},
  { 140,  124,  141},
  { 125,  126,  141},
  { 141,  126,  142},
  { 127,  143,  126},
  { 143,  142,  126},
  { 127,  112,  143},
  { 129,  143,  112},
  { 129,  128,  144},
  { 145,  144,  128},
  { 128,  130,  145},
  { 146,  145,  130},
  { 130,  131,  146},
  { 147,  146,  131},
  { 131,  132,  147},
  { 147,  132,  148},
  { 132,  133,  148},
  { 148,  133,  149},
  { 133,  134,  149},
  { 150,  149,  134},
  { 134,  135,  150},
  { 151,  150,  135},
  { 135,  136,  151},
  { 152,  151,  136},
  { 136,  137,  152},
  { 153,  152,  137},
  { 137,  138,  153},
  { 154,  153,  138},
  { 138,  139,  154},
  { 155,  154,  139},
  { 139,  140,  155},
  { 155,  140,  156},
  { 140,  141,  156},
  { 156,  141,  157},
  { 141,  142,  157},
  { 158,  157,  142},
  { 142,  143,  158},
  { 159,  158,  143},
  { 143,  129,  159},
  { 144,  159,  129},
  { 144,  145,  160},
  { 161,  160,  145},
  { 145,  146,  161},
  { 161,  146,  162},
  { 147,  163,  146},
  { 163,  162,  146},
  { 148,  164,  147},
  { 163,  147,  164},
  { 148,  149,  164},
  { 165,  164,  149},
  { 149,  150,  165},
  { 165,  150,  166},
  { 151,  167,  150},
  { 167,  166,  150},
  { 152,  168,  151},
  { 167,  151,  168},
  { 152,  153,  168},
  { 169,  168,  153},
  { 153,  154,  169},
  { 169,  154,  170},
  { 155,  171,  154},
  { 171,  170,  154},
  { 156,  172,  155},
  { 171,  155,  172},
  { 156,  157,  172},
  { 173,  172,  157},
  { 157,  158,  173},
  { 173,  158,  174},
  { 159,  175,  158},
  { 175,  174,  158},
  { 144,  160,  159},
  { 175,  159,  160},
  { 160,  161,  176},
  { 177,  176,  161},
  { 161,  162,  177},
  { 178,  177,  162},
  { 162,  163,  178},
  { 179,  178,  163},
  { 163,  164,  179},
  { 180,  179,  164},
  { 164,  165,  180},
  { 181,  180,  165},
  { 165,  166,  181},
  { 182,  181,  166},
  { 166,  167,  182},
  { 183,  182,  167},
  { 167,  168,  183},
  { 184,  183,  168},
  { 168,  169,  184},
  { 185,  184,  169},
  { 169,  170,  185},
  { 186,  185,  170},
  { 170,  171,  186},
  { 187,  186,  171},
  { 171,  172,  187},
  { 188,  187,  172},
  { 172,  173,  188},
  { 189,  188,  173},
  { 173,  174,  189},
  { 190,  189,  174},
  { 174,  175,  190},
  { 191,  190,  175},
  { 175,  160,  191},
  { 176,  191,  160},
  { 177,  192,  176},
  { 193,  176,  192},
  { 177,  178,  192},
  { 194,  192,  178},
  { 179,  195,  178},
  { 194,  178,  195},
  { 179,  180,  195},
  { 196,  195,  180},
  { 181,  197,  180},
  { 196,  180,  197},
  { 181,  182,  197},
  { 198,  197,  182},
  { 183,  199,  182},
  { 198,  182,  199},
  { 183,  184,  199},
  { 200,  199,  184},
  { 185,  201,  184},
  { 200,  184,  201},
  { 185,  186,  201},
  { 202,  201,  186},
  { 187,  203,  186},
  { 202,  186,  203},
  { 187,  188,  203},
  { 204,  203,  188},
  { 189,  205,  188},
  { 204,  188,  205},
  { 189,  190,  205},
  { 206,  205,  190},
  { 191,  207,  190},
  { 206,  190,  207},
  { 191,  176,  207},
  { 193,  207,  176},
  { 193,  192,  208},
  { 209,  208,  192},
  { 194,  210,  192},
  { 209,  192,  210},
  { 194,  195,  210},
  { 211,  210,  195},
  { 196,  212,  195},
  { 211,  195,  212},
  { 196,  197,  212},
  { 213,  212,  197},
  { 198,  214,  197},
  { 213,  197,  214},
  { 198,  199,  214},
  { 215,  214,  199},
  { 200,  216,  199},
  { 215,  199,  216},
  { 200,  201,  216},
  { 217,  216,  201},
  { 202,  218,  201},
  { 217,  201,  218},
  { 202,  203,  218},
  { 219,  218,  203},
  { 204,  220,  203},
  { 219,  203,  220},
  { 204,  205,  220},
  { 221,  220,  205},
  { 206,  222,  205},
  { 221,  205,  222},
  { 206,  207,  222},
  { 223,  222,  207},
  { 193,  208,  207},
  { 223,  207,  208},
  { 208,  209,  224},
  { 225,  224,  209},
  { 210,  226,  209},
  { 226,  225,  209},
  { 210,  211,  226},
  { 226,  211,  227},
  { 212,  228,  211},
  { 227,  211,  228},
  { 212,  213,  228},
  { 229,  228,  213},
  { 214,  230,  213},
  { 229,  213,  230},
  { 214,  215,  230},
  { 230,  215,  231},
  { 216,  232,  215},
  { 231,  215,  232},
  { 216,  217,  232},
  { 233,  232,  217},
  { 218,  234,  217},
  { 234,  233,  217},
  { 218,  219,  234},
  { 234,  219,  235},
  { 220,  236,  219},
  { 235,  219,  236},
  { 220,  221,  236},
  { 237,  236,  221},
  { 222,  238,  221},
  { 237,  221,  238},
  { 222,  223,  238},
  { 238,  223,  239},
  { 208,  224,  223},
  { 239,  223,  224},
  { 224,  225,  240},
  { 240,  225,  241},
  { 225,  226,  241},
  { 242,  241,  226},
  { 227,  243,  226},
  { 242,  226,  243},
  { 228,  244,  227},
  { 244,  243,  227},
  { 228,  229,  244},
  { 244,  229,  245},
  { 229,  230,  245},
  { 246,  245,  230},
  { 231,  247,  230},
  { 246,  230,  247},
  { 232,  248,  231},
  { 248,  247,  231},
  { 232,  233,  248},
  { 248,  233,  249},
  { 233,  234,  249},
  { 250,  249,  234},
  { 235,  251,  234},
  { 250,  234,  251},
  { 236,  252,  235},
  { 252,  251,  235},
  { 236,  237,  252},
  { 252,  237,  253},
  { 237,  238,  253},
  { 254,  253,  238},
  { 239,  255,  238},
  { 254,  238,  255},
  { 224,  240,  239},
  { 240,  255,  239},
  { 241,  256,  240},
  { 257,  240,  256},
  { 241,  242,  256},
  { 242,  258,  256},
  { 243,  259,  242},
  { 242,  259,  258},
  { 243,  244,  259},
  { 260,  259,  244},
  { 245,  261,  244},
  { 260,  244,  261},
  { 245,  246,  261},
  { 246,  262,  261},
  { 247,  263,  246},
  { 246,  263,  262},
  { 247,  248,  263},
  { 264,  263,  248},
  { 249,  265,  248},
  { 264,  248,  265},
  { 249,  250,  265},
  { 250,  266,  265},
  { 251,  267,  250},
  { 250,  267,  266},
  { 251,  252,  267},
  { 268,  267,  252},
  { 253,  269,  252},
  { 268,  252,  269},
  { 253,  254,  269},
  { 254,  270,  269},
  { 255,  271,  254},
  { 254,  271,  270},
  { 255,  240,  271},
  { 257,  271,  240},
  { 257,  256,  272},
  { 273,  272,  256},
  { 256,  258,  273},
  { 274,  273,  258},
  { 258,  259,  274},
  { 275,  274,  259},
  { 259,  260,  275},
  { 276,  275,  260},
  { 260,  261,  276},
  { 277,  276,  261},
  { 261,  262,  277},
  { 278,  277,  262},
  { 262,  263,  278},
  { 279,  278,  263},
  { 263,  264,  279},
  { 280,  279,  264},
  { 264,  265,  280},
  { 281,  280,  265},
  { 265,  266,  281},
  { 282,  281,  266},
  { 266,  267,  282},
  { 283,  282,  267},
  { 267,  268,  283},
  { 284,  283,  268},
  { 268,  269,  284},
  { 285,  284,  269},
  { 269,  270,  285},
  { 286,  285,  270},
  { 270,  271,  286},
  { 287,  286,  271},
  { 271,  257,  287},
  { 272,  287,  257},
  { 273,  288,  272},
  { 289,  272,  288},
  { 273,  274,  288},
  { 290,  288,  274},
  { 275,  291,  274},
  { 274,  291,  290},
  { 275,  276,  291},
  { 292,  291,  276},
  { 277,  293,  276},
  { 292,  276,  293},
  { 277,  278,  293},
  { 278,  294,  293},
  { 279,  295,  278},
  { 294,  278,  295},
  { 279,  280,  295},
  { 296,  295,  280},
  { 281,  297,  280},
  { 296,  280,  297},
  { 281,  282,  297},
  { 298,  297,  282},
  { 283,  299,  282},
  { 282,  299,  298},
  { 283,  284,  299},
  { 300,  299,  284},
  { 285,  301,  284},
  { 300,  284,  301},
  { 285,  286,  301},
  { 286,  302,  301},
  { 287,  303,  286},
  { 302,  286,  303},
  { 287,  272,  303},
  { 289,  303,  272},
  { 288,  304,  289},
  { 304,  305,  289},
  { 288,  290,  304},
  { 306,  304,  290},
  { 291,  307,  290},
  { 306,  290,  307},
  { 291,  292,  307},
  { 307,  292,  308},
  { 293,  309,  292},
  { 309,  308,  292},
  { 293,  294,  309},
  { 310,  309,  294},
  { 295,  311,  294},
  { 310,  294,  311},
  { 295,  296,  311},
  { 311,  296,  312},
  { 297,  313,  296},
  { 313,  312,  296},
  { 297,  298,  313},
  { 314,  313,  298},
  { 299,  315,  298},
  { 314,  298,  315},
  { 299,  300,  315},
  { 315,  300,  316},
  { 301,  317,  300},
  { 317,  316,  300},
  { 301,  302,  317},
  { 318,  317,  302},
  { 303,  319,  302},
  { 318,  302,  319},
  { 303,  289,  319},
  { 319,  289,  305},
  { 305,  304,  320},
  { 321,  320,  304},
  { 304,  306,  321},
  { 322,  321,  306},
  { 306,  307,  322},
  { 323,  322,  307},
  { 307,  308,  323},
  { 324,  323,  308},
  { 308,  309,  324},
  { 325,  324,  309},
  { 309,  310,  325},
  { 326,  325,  310},
  { 310,  311,  326},
  { 327,  326,  311},
  { 311,  312,  327},
  { 328,  327,  312},
  { 312,  313,  328},
  { 329,  328,  313},
  { 313,  314,  329},
  { 330,  329,  314},
  { 314,  315,  330},
  { 331,  330,  315},
  { 315,  316,  331},
  { 332,  331,  316},
  { 316,  317,  332},
  { 333,  332,  317},
  { 317,  318,  333},
  { 334,  333,  318},
  { 318,  319,  334},
  { 335,  334,  319},
  { 319,  305,  335},
  { 320,  335,  305},
  { 336,  320,  337},
  { 321,  337,  320},
  { 337,  321,  338},
  { 322,  338,  321},
  { 339,  338,  323},
  { 322,  323,  338},
  { 340,  339,  324},
  { 323,  324,  339},
  { 340,  324,  341},
  { 325,  341,  324},
  { 341,  325,  342},
  { 326,  342,  325},
  { 343,  342,  327},
  { 326,  327,  342},
  { 344,  343,  328},
  { 327,  328,  343},
  { 344,  328,  345},
  { 329,  345,  328},
  { 345,  329,  346},
  { 330,  346,  329},
  { 347,  346,  331},
  { 330,  331,  346},
  { 348,  347,  332},
  { 331,  332,  347},
  { 348,  332,  349},
  { 333,  349,  332},
  { 349,  333,  350},
  { 334,  350,  333},
  { 351,  350,  335},
  { 334,  335,  350},
  { 336,  351,  320},
  { 335,  320,  351},
  { 336,  337,  352},
  { 352,  337,  353},
  { 337,  338,  353},
  { 354,  353,  338},
  { 338,  339,  354},
  { 355,  354,  339},
  { 339,  340,  355},
  { 355,  340,  356},
  { 340,  341,  356},
  { 356,  341,  357},
  { 341,  342,  357},
  { 358,  357,  342},
  { 342,  343,  358},
  { 359,  358,  343},
  { 343,  344,  359},
  { 359,  344,  360},
  { 344,  345,  360},
  { 360,  345,  361},
  { 345,  346,  361},
  { 362,  361,  346},
  { 346,  347,  362},
  { 363,  362,  347},
  { 347,  348,  363},
  { 363,  348,  364},
  { 348,  349,  364},
  { 364,  349,  365},
  { 349,  350,  365},
  { 366,  365,  350},
  { 350,  351,  366},
  { 367,  366,  351},
  { 351,  336,  367},
  { 367,  336,  352},
  { 353,  368,  352},
  { 369,  352,  368},
  { 353,  354,  368},
  { 370,  368,  354},
  { 355,  371,  354},
  { 370,  354,  371},
  { 355,  356,  371},
  { 372,  371,  356},
  { 357,  373,  356},
  { 372,  356,  373},
  { 357,  358,  373},
  { 374,  373,  358},
  { 359,  375,  358},
  { 374,  358,  375},
  { 359,  360,  375},
  { 376,  375,  360},
  { 361,  377,  360},
  { 376,  360,  377},
  { 361,  362,  377},
  { 378,  377,  362},
  { 363,  379,  362},
  { 378,  362,  379},
  { 363,  364,  379},
  { 380,  379,  364},
  { 365,  381,  364},
  { 380,  364,  381},
  { 365,  366,  381},
  { 382,  381,  366},
  { 367,  383,  366},
  { 382,  366,  383},
  { 367,  352,  383},
  { 369,  383,  352},
  { 369,  368,  384},
  { 385,  384,  368},
  { 368,  370,  385},
  { 386,  385,  370},
  { 370,  371,  386},
  { 387,  386,  371},
  { 371,  372,  387},
  { 388,  387,  372},
  { 372,  373,  388},
  { 389,  388,  373},
  { 373,  374,  389},
  { 390,  389,  374},
  { 374,  375,  390},
  { 391,  390,  375},
  { 375,  376,  391},
  { 392,  391,  376},
  { 376,  377,  392},
  { 393,  392,  377},
  { 377,  378,  393},
  { 394,  393,  378},
  { 378,  379,  394},
  { 395,  394,  379},
  { 379,  380,  395},
  { 396,  395,  380},
  { 380,  381,  396},
  { 397,  396,  381},
  { 381,  382,  397},
  { 398,  397,  382},
  { 382,  383,  398},
  { 399,  398,  383},
  { 383,  369,  399},
  { 384,  399,  369},
  {   2,    3,  385},
  { 385,    3,  384},
  {   2,  385,    5},
  {   5,  385,  386},
  {   7,    5,  387},
  {   5,  386,  387},
  {   7,  387,    9},
  { 387,  388,    9},
  {  11,    9,  389},
  { 389,    9,  388},
  {  11,  389,   13},
  {  13,  389,  390},
  {  15,   13,  391},
  {  13,  390,  391},
  {  15,  391,   17},
  { 391,  392,   17},
  {  19,   17,  393},
  { 393,   17,  392},
  {  19,  393,   21},
  {  21,  393,  394},
  {  23,   21,  395},
  {  21,  394,  395},
  {  23,  395,   25},
  { 395,  396,   25},
  {  27,   25,  397},
  { 397,   25,  396},
  {  27,  397,   29},
  {  29,  397,  398},
  {  31,   29,  399},
  {  29,  398,  399},
  {  31,  399,    3},
  { 399,  384,    3},
  { 400,  401,  402},
  { 403,  402,  401},
  { 404,  400,  405},
  { 402,  405,  400},
  { 404,  405,  406},
  { 407,  406,  405},
  { 406,  407,  408},
  { 409,  408,  407},
  { 410,  408,  411},
  { 411,  408,  409},
  { 412,  410,  413},
  { 411,  413,  410},
  { 414,  412,  415},
  { 415,  412,  413},
  { 414,  415,  416},
  { 417,  416,  415},
  { 418,  416,  419},
  { 419,  416,  417},
  { 418,  419,  420},
  { 419,  421,  420},
  { 422,  420,  423},
  { 421,  423,  420},
  { 422,  423,  424},
  { 423,  425,  424},
  { 426,  424,  427},
  { 427,  424,  425},
  { 426,  427,  428},
  { 429,  428,  427},
  { 428,  429,  430},
  { 431,  430,  429},
  { 430,  431,  401},
  { 431,  403,  401},
  { 432,  433,  434},
  { 435,  434,  433},
  { 436,  437,  432},
  { 433,  432,  437},
  { 436,  438,  437},
  { 439,  437,  438},
  { 438,  440,  439},
  { 441,  439,  440},
  { 442,  443,  440},
  { 443,  441,  440},
  { 444,  445,  442},
  { 443,  442,  445},
  { 446,  447,  444},
  { 447,  445,  444},
  { 446,  448,  447},
  { 449,  447,  448},
  { 450,  451,  448},
  { 451,  449,  448},
  { 450,  452,  451},
  { 451,  452,  453},
  { 454,  455,  452},
  { 453,  452,  455},
  { 454,  456,  455},
  { 455,  456,  457},
  { 458,  459,  456},
  { 459,  457,  456},
  { 458,  460,  459},
  { 461,  459,  460},
  { 460,  462,  461},
  { 463,  461,  462},
  { 462,  434,  463},
  { 463,  434,  435},
  { 400,  432,  401},
  { 434,  401,  432},
  { 404,  436,  400},
  { 432,  400,  436},
  { 406,  438,  404},
  { 436,  404,  438},
  { 408,  440,  406},
  { 438,  406,  440},
  { 410,  442,  408},
  { 440,  408,  442},
  { 412,  444,  410},
  { 442,  410,  444},
  { 414,  446,  412},
  { 444,  412,  446},
  { 416,  448,  414},
  { 446,  414,  448},
  { 418,  450,  416},
  { 448,  416,  450},
  { 420,  452,  418},
  { 418,  452,  450},
  { 422,  454,  420},
  { 454,  452,  420},
  { 424,  456,  422},
  { 454,  422,  456},
  { 426,  458,  424},
  { 456,  424,  458},
  { 428,  460,  426},
  { 426,  460,  458},
  { 430,  462,  428},
  { 460,  428,  462},
  { 401,  434,  430},
  { 462,  430,  434},
  { 433,  402,  435},
  { 403,  435,  402},
  { 437,  405,  433},
  { 402,  433,  405},
  { 439,  407,  437},
  { 405,  437,  407},
  { 441,  409,  439},
  { 407,  439,  409},
  { 443,  411,  441},
  { 409,  441,  411},
  { 445,  413,  443},
  { 411,  443,  413},
  { 447,  415,  445},
  { 413,  445,  415},
  { 449,  417,  447},
  { 415,  447,  417},
  { 451,  419,  449},
  { 417,  449,  419},
  { 453,  421,  451},
  { 419,  451,  421},
  { 455,  423,  453},
  { 421,  453,  423},
  { 457,  425,  455},
  { 423,  455,  425},
  { 459,  427,  457},
  { 425,  457,  427},
  { 461,  429,  459},
  { 427,  459,  429},
  { 463,  431,  461},
  { 429,  461,  431},
  { 435,  403,  463},
  { 431,  463,  403},
  { 464,  465,  466},
  { 466,  465,  434},
  { 467,  468,  469},
  { 469,  468,  470},
  { 470,  468,  465},
  { 434,  465,  468},
  { 467,  469,  466},
  { 464,  466,  469},
  { 468,  467,  434},
  { 466,  434,  467},
  { 469,  470,  464},
  { 465,  464,  470},
  { 471,  472,  473},
  { 472,  448,  473},
  { 474,  475,  476},
  { 475,  477,  476},
  { 477,  473,  476},
  { 448,  476,  473},
  { 474,  472,  475},
  { 471,  475,  472},
  { 476,  448,  474},
  { 472,  474,  448},
  { 475,  471,  477},
  { 473,  477,  471},
  { 478,  479,  480},
  { 480,  479,  456},
  { 481,  482,  483},
  { 483,  482,  484},
  { 484,  482,  479},
  { 456,  479,  482},
  { 481,  483,  480},
  { 478,  480,  483},
  { 482,  481,  456},
  { 480,  456,  481},
  { 483,  484,  478},
  { 479,  478,  484},
  { 485,  486,  487},
  { 486,  440,  487},
  { 488,  489,  490},
  { 489,  491,  490},
  { 491,  487,  490},
  { 440,  490,  487},
  { 488,  486,  489},
  { 485,  489,  486},
  { 490,  440,  488},
  { 486,  488,  440},
  { 489,  485,  491},
  { 487,  491,  485},
  { 492,  493,  494},
  { 495,  494,  493},
  { 496,  497,  498},
  { 499,  498,  497},
  { 498,  499,  493},
  { 495,  493,  499},
  { 497,  496,  494},
  { 492,  494,  496},
  { 499,  497,  495},
  { 494,  495,  497},
  { 496,  498,  492},
  { 498,  493,  492},
  { 500,  501,  502},
  { 501,  503,  502},
  { 504,  505,  506},
  { 506,  505,  507},
  { 504,  500,  505},
  { 502,  505,  500},
  { 507,  503,  506},
  { 501,  506,  503},
  { 505,  502,  507},
  { 503,  507,  502},
  { 506,  501,  504},
  { 500,  504,  501},
  { 508,  509,  510},
  { 509,  511,  510},
  { 512,  513,  514},
  { 514,  513,  515},
  { 515,  513,  511},
  { 510,  511,  513},
  { 512,  514,  508},
  { 514,  509,  508},
  { 513,  512,  510},
  { 508,  510,  512},
  { 514,  515,  509},
  { 511,  509,  515},
  { 516,  517,  518},
  { 519,  518,  517},
  { 520,  521,  522},
  { 523,  522,  521},
  { 522,  517,  520},
  { 516,  520,  517},
  { 521,  518,  523},
  { 523,  518,  519},
  { 520,  516,  521},
  { 521,  516,  518},
  { 523,  519,  522},
  { 517,  522,  519},
  { 524,  525,  526},
  { 527,  526,  525},
  { 528,  529,  530},
  { 531,  530,  529},
  { 529,  528,  526},
  { 524,  526,  528},
  { 530,  531,  525},
  { 531,  527,  525},
  { 528,  530,  524},
  { 530,  525,  524},
  { 531,  529,  527},
  { 526,  527,  529},
  { 532,  533,  534},
  { 534,  533,  535},
  { 536,  537,  538},
  { 537,  539,  538},
  { 536,  532,  537},
  { 537,  532,  534},
  { 539,  535,  538},
  { 538,  535,  533},
  { 537,  534,  539},
  { 535,  539,  534},
  { 538,  533,  536},
  { 532,  536,  533},
  { 540,  541,  542},
  { 543,  542,  541},
  { 544,  545,  546},
  { 547,  546,  545},
  { 545,  544,  542},
  { 540,  542,  544},
  { 546,  547,  541},
  { 543,  541,  547},
  { 544,  546,  540},
  { 541,  540,  546},
  { 547,  545,  543},
  { 542,  543,  545},
  { 548,  549,  550},
  { 550,  549,  551},
  { 552,  553,  554},
  { 553,  555,  554},
  { 552,  548,  553},
  { 553,  548,  550},
  { 555,  551,  554},
  { 549,  554,  551},
  { 553,  550,  555},
  { 551,  555,  550},
  { 554,  549,  552},
  { 548,  552,  549},
  { 556,  557,  558},
  { 557,  559,  558},
  { 560,  561,  562},
  { 561,  563,  562},
  { 561,  556,  563},
  { 563,  556,  558},
  { 557,  560,  559},
  { 560,  562,  559},
  { 557,  556,  560},
  { 560,  556,  561},
  { 559,  562,  558},
  { 562,  563,  558},
  { 564,  565,  566},
  { 567,  566,  565},
  { 568,  569,  570},
  { 571,  570,  569},
  { 570,  571,  564},
  { 564,  571,  565},
  { 566,  567,  568},
  { 569,  568,  567},
  { 568,  570,  566},
  { 564,  566,  570},
  { 569,  567,  571},
  { 565,  571,  567},
  { 572,  573,  574},
  { 575,  574,  573},
  { 576,  577,  578},
  { 579,  578,  577},
  { 577,  572,  579},
  { 572,  574,  579},
  { 573,  576,  575},
  { 578,  575,  576},
  { 573,  572,  576},
  { 576,  572,  577},
  { 575,  578,  574},
  { 578,  579,  574},
  { 580,  581,  582},
  { 583,  582,  581},
  { 584,  585,  586},
  { 587,  586,  585},
  { 586,  587,  580},
  { 580,  587,  581},
  { 582,  583,  584},
  { 585,  584,  583},
  { 584,  586,  582},
  { 580,  582,  586},
  { 585,  583,  587},
  { 581,  587,  583},
  { 588,  589,  590},
  { 591,  590,  589},
  { 592,  593,  594},
  { 595,  594,  593},
  { 593,  588,  595},
  { 588,  590,  595},
  { 589,  592,  591},
  { 594,  591,  592},
  { 592,  589,  593},
  { 588,  593,  589},
  { 594,  595,  591},
  { 590,  591,  595},
  { 596,  597,  598},
  { 598,  597,  599},
  { 600,  601,  602},
  { 603,  602,  601},
  { 602,  603,  596},
  { 596,  603,  597},
  { 598,  599,  600},
  { 601,  600,  599},
  { 602,  596,  600},
  { 596,  598,  600},
  { 603,  601,  597},
  { 597,  601,  599},
  { 604,  605,  606},
  { 607,  606,  605},
  { 608,  609,  610},
  { 611,  610,  609},
  { 609,  604,  611},
  { 611,  604,  606},
  { 605,  608,  607},
  { 610,  607,  608},
  { 605,  604,  608},
  { 604,  609,  608},
  { 607,  610,  606},
  { 606,  610,  611},
  { 612,  613,  614},
  { 615,  614,  613},
  { 616,  617,  618},
  { 619,  618,  617},
  { 618,  619,  612},
  { 612,  619,  613},
  { 614,  615,  616},
  { 617,  616,  615},
  { 612,  614,  618},
  { 616,  618,  614},
  { 613,  619,  615},
  { 617,  615,  619},
  { 620,  621,  622},
  { 623,  622,  621},
  { 624,  625,  626},
  { 627,  626,  625},
  { 625,  620,  627},
  { 622,  627,  620},
  { 621,  624,  623},
  { 626,  623,  624},
  { 625,  624,  620},
  { 620,  624,  621},
  { 622,  623,  627},
  { 627,  623,  626},
  { 628,  629,  630},
  { 631,  630,  629},
  { 632,  633,  634},
  { 635,  634,  633},
  { 634,  635,  628},
  { 629,  628,  635},
  { 630,  631,  632},
  { 633,  632,  631},
  { 634,  628,  632},
  { 628,  630,  632},
  { 629,  635,  631},
  { 635,  633,  631},
  { 636,  637,  638},
  { 639,  638,  637},
  { 640,  641,  642},
  { 643,  642,  641},
  { 641,  636,  643},
  { 638,  643,  636},
  { 637,  640,  639},
  { 642,  639,  640},
  { 641,  640,  636},
  { 636,  640,  637},
  { 638,  639,  643},
  { 643,  639,  642},
  { 644,  645,  646},
  { 647,  646,  645},
  { 648,  649,  650},
  { 651,  650,  649},
  { 650,  651,  644},
  { 645,  644,  651},
  { 646,  647,  648},
  { 649,  648,  647},
  { 650,  644,  648},
  { 644,  646,  648},
  { 645,  651,  647},
  { 651,  649,  647},
  { 652,  653,  654},
  { 655,  654,  653},
  { 653,  656,  655},
  { 657,  655,  656},
  { 656,  658,  657},
  { 659,  657,  658},
  { 658,  660,  659},
  { 661,  659,  660},
  { 660,  662,  661},
  { 663,  661,  662},
  { 662,  664,  663},
  { 665,  663,  664},
  { 664,  666,  665},
  { 667,  665,  666},
  { 666,  668,  667},
  { 669,  667,  668},
  { 668,  670,  669},
  { 671,  669,  670},
  { 670,  672,  671},
  { 673,  671,  672},
  { 672,  674,  673},
  { 675,  673,  674},
  { 674,  676,  675},
  { 677,  675,  676},
  { 676,  678,  677},
  { 679,  677,  678},
  { 678,  680,  679},
  { 681,  679,  680},
  { 680,  682,  681},
  { 683,  681,  682},
  { 682,  652,  683},
  { 654,  683,  652},
  { 684,  685,  649},
  { 686,  649,  685},
  { 685,  687,  686},
  { 688,  686,  687},
  { 687,  689,  688},
  { 689,  690,  688},
  { 689,  691,  690},
  { 633,  690,  691},
  { 691,  692,  633},
  { 693,  633,  692},
  { 692,  694,  693},
  { 693,  694,  695},
  { 694,  696,  695},
  { 695,  696,  697},
  { 696,  698,  697},
  { 642,  697,  698},
  { 698,  699,  642},
  { 700,  642,  699},
  { 699,  701,  700},
  { 702,  700,  701},
  { 701,  703,  702},
  { 704,  702,  703},
  { 703,  705,  704},
  { 626,  704,  705},
  { 705,  706,  626},
  { 707,  626,  706},
  { 706,  708,  707},
  { 709,  707,  708},
  { 708,  710,  709},
  { 711,  709,  710},
  { 710,  684,  711},
  { 649,  711,  684},
  { 686,  653,  649},
  { 653,  652,  649},
  { 688,  656,  686},
  { 653,  686,  656},
  { 690,  658,  688},
  { 656,  688,  658},
  { 690,  633,  658},
  { 658,  633,  660},
  { 693,  662,  633},
  { 662,  660,  633},
  { 693,  695,  662},
  { 664,  662,  695},
  { 697,  666,  695},
  { 666,  664,  695},
  { 697,  642,  666},
  { 666,  642,  668},
  { 700,  670,  642},
  { 668,  642,  670},
  { 700,  702,  670},
  { 670,  702,  672},
  { 702,  704,  672},
  { 674,  672,  704},
  { 704,  626,  674},
  { 674,  626,  676},
  { 707,  678,  626},
  { 676,  626,  678},
  { 709,  680,  707},
  { 678,  707,  680},
  { 709,  711,  680},
  { 682,  680,  711},
  { 711,  649,  682},
  { 652,  682,  649},
  { 685,  684,  655},
  { 655,  684,  654},
  { 687,  685,  657},
  { 655,  657,  685},
  { 689,  687,  659},
  { 657,  659,  687},
  { 689,  659,  691},
  { 659,  661,  691},
  { 692,  691,  663},
  { 663,  691,  661},
  { 692,  663,  694},
  { 665,  694,  663},
  { 696,  694,  667},
  { 667,  694,  665},
  { 696,  667,  698},
  { 667,  669,  698},
  { 699,  698,  671},
  { 669,  671,  698},
  { 699,  671,  701},
  { 671,  673,  701},
  { 701,  673,  703},
  { 675,  703,  673},
  { 703,  675,  705},
  { 675,  677,  705},
  { 706,  705,  679},
  { 677,  679,  705},
  { 708,  706,  681},
  { 679,  681,  706},
  { 708,  681,  710},
  { 683,  710,  681},
  { 710,  683,  684},
  { 654,  684,  683},
  { 712,  713,  714},
  { 712,  715,  713},
  { 712,  716,  715},
  { 712,  717,  716},
  { 712,  718,  717},
  { 712,  719,  718},
  { 712,  720,  719},
  { 712,  721,  720},
  { 712,  722,  721},
  { 712,  723,  722},
  { 712,  724,  723},
  { 712,  725,  724},
  { 712,  726,  725},
  { 712,  727,  726},
  { 712,  728,  727},
  { 712,  714,  728},
  { 714,  713,  729},
  { 713,  730,  729},
  { 713,  715,  730},
  { 715,  731,  730},
  { 715,  716,  731},
  { 716,  732,  731},
  { 716,  717,  732},
  { 717,  733,  732},
  { 717,  718,  733},
  { 718,  734,  733},
  { 718,  719,  734},
  { 719,  735,  734},
  { 719,  720,  735},
  { 720,  736,  735},
  { 720,  721,  736},
  { 721,  737,  736},
  { 721,  722,  737},
  { 722,  738,  737},
  { 722,  723,  738},
  { 723,  739,  738},
  { 723,  724,  739},
  { 724,  740,  739},
  { 724,  725,  740},
  { 725,  741,  740},
  { 725,  726,  741},
  { 726,  742,  741},
  { 726,  727,  742},
  { 727,  743,  742},
  { 727,  728,  743},
  { 728,  744,  743},
  { 728,  714,  744},
  { 714,  729,  744},
  { 745,  729,  746},
  { 730,  746,  729},
  { 747,  746,  731},
  { 730,  731,  746},
  { 747,  731,  748},
  { 732,  748,  731},
  { 749,  748,  733},
  { 732,  733,  748},
  { 749,  733,  750},
  { 734,  750,  733},
  { 751,  750,  735},
  { 734,  735,  750},
  { 751,  735,  752},
  { 736,  752,  735},
  { 753,  752,  737},
  { 736,  737,  752},
  { 753,  737,  754},
  { 738,  754,  737},
  { 755,  754,  739},
  { 738,  739,  754},
  { 755,  739,  756},
  { 740,  756,  739},
  { 757,  756,  741},
  { 740,  741,  756},
  { 757,  741,  758},
  { 742,  758,  741},
  { 759,  758,  743},
  { 742,  743,  758},
  { 759,  743,  760},
  { 744,  760,  743},
  { 745,  760,  729},
  { 744,  729,  760},
  { 745,  746,  761},
  { 762,  761,  746},
  { 746,  747,  762},
  { 763,  762,  747},
  { 747,  748,  763},
  { 764,  763,  748},
  { 748,  749,  764},
  { 765,  764,  749},
  { 749,  750,  765},
  { 766,  765,  750},
  { 750,  751,  766},
  { 767,  766,  751},
  { 751,  752,  767},
  { 768,  767,  752},
  { 752,  753,  768},
  { 769,  768,  753},
  { 753,  754,  769},
  { 770,  769,  754},
  { 754,  755,  770},
  { 771,  770,  755},
  { 755,  756,  771},
  { 772,  771,  756},
  { 756,  757,  772},
  { 773,  772,  757},
  { 757,  758,  773},
  { 774,  773,  758},
  { 758,  759,  774},
  { 775,  774,  759},
  { 759,  760,  775},
  { 776,  775,  760},
  { 760,  745,  776},
  { 761,  776,  745},
  { 777,  778,  762},
  { 761,  762,  778},
  { 779,  777,  763},
  { 762,  763,  777},
  { 779,  763,  780},
  { 764,  780,  763},
  { 780,  764,  781},
  { 765,  781,  764},
  { 782,  781,  766},
  { 765,  766,  781},
  { 783,  782,  767},
  { 766,  767,  782},
  { 783,  767,  784},
  { 768,  784,  767},
  { 784,  768,  785},
  { 769,  785,  768},
  { 786,  785,  770},
  { 769,  770,  785},
  { 787,  786,  771},
  { 770,  771,  786},
  { 787,  771,  788},
  { 772,  788,  771},
  { 788,  772,  789},
  { 773,  789,  772},
  { 790,  789,  774},
  { 773,  774,  789},
  { 791,  790,  775},
  { 774,  775,  790},
  { 791,  775,  792},
  { 776,  792,  775},
  { 792,  776,  778},
  { 761,  778,  776},
  { 778,  777,  793},
  { 794,  793,  777},
  { 777,  779,  794},
  { 795,  794,  779},
  { 779,  780,  795},
  { 796,  795,  780},
  { 780,  781,  796},
  { 797,  796,  781},
  { 781,  782,  797},
  { 798,  797,  782},
  { 782,  783,  798},
  { 799,  798,  783},
  { 783,  784,  799},
  { 800,  799,  784},
  { 784,  785,  800},
  { 801,  800,  785},
  { 785,  786,  801},
  { 802,  801,  786},
  { 786,  787,  802},
  { 803,  802,  787},
  { 787,  788,  803},
  { 804,  803,  788},
  { 788,  789,  804},
  { 805,  804,  789},
  { 789,  790,  805},
  { 806,  805,  790},
  { 790,  791,  806},
  { 807,  806,  791},
  { 791,  792,  807},
  { 808,  807,  792},
  { 792,  778,  808},
  { 793,  808,  778},
  { 693,  809,  794},
  { 793,  794,  809},
  { 693,  794,  810},
  { 795,  810,  794},
  { 811,  810,  796},
  { 795,  796,  810},
  { 811,  796,  812},
  { 797,  812,  796},
  { 813,  812,  798},
  { 797,  798,  812},
  { 813,  798,  814},
  { 799,  814,  798},
  { 815,  814,  800},
  { 799,  800,  814},
  { 815,  800,  816},
  { 801,  816,  800},
  { 817,  816,  802},
  { 801,  802,  816},
  { 817,  802,  818},
  { 803,  818,  802},
  { 819,  818,  804},
  { 803,  804,  818},
  { 819,  804,  820},
  { 805,  820,  804},
  { 821,  820,  806},
  { 805,  806,  820},
  { 821,  806,  822},
  { 807,  822,  806},
  { 823,  822,  808},
  { 807,  808,  822},
  { 823,  808,  809},
  { 793,  809,  808},
  { 809,  693,  824},
  { 454,  824,  693},
  { 693,  810,  454},
  { 825,  454,  810},
  { 810,  811,  825},
  { 826,  825,  811},
  { 811,  812,  826},
  { 827,  826,  812},
  { 812,  813,  827},
  { 828,  827,  813},
  { 813,  814,  828},
  { 829,  828,  814},
  { 814,  815,  829},
  { 830,  829,  815},
  { 815,  816,  830},
  { 831,  830,  816},
  { 816,  817,  831},
  { 832,  831,  817},
  { 817,  818,  832},
  { 833,  832,  818},
  { 818,  819,  833},
  { 834,  833,  819},
  { 819,  820,  834},
  { 835,  834,  820},
  { 820,  821,  835},
  { 836,  835,  821},
  { 821,  822,  836},
  { 837,  836,  822},
  { 822,  823,  837},
  { 838,  837,  823},
  { 823,  809,  838},
  { 824,  838,  809},
  { 454,  839,  824},
  { 840,  824,  839},
  { 454,  825,  839},
  { 841,  839,  825},
  { 826,  842,  825},
  { 841,  825,  842},
  { 826,  827,  842},
  { 843,  842,  827},
  { 828,  844,  827},
  { 843,  827,  844},
  { 828,  829,  844},
  { 845,  844,  829},
  { 830,  846,  829},
  { 845,  829,  846},
  { 830,  831,  846},
  { 847,  846,  831},
  { 832,  848,  831},
  { 847,  831,  848},
  { 832,  833,  848},
  { 849,  848,  833},
  { 834,  850,  833},
  { 849,  833,  850},
  { 834,  835,  850},
  { 851,  850,  835},
  { 836,  852,  835},
  { 851,  835,  852},
  { 836,  837,  852},
  { 853,  852,  837},
  { 838,  854,  837},
  { 853,  837,  854},
  { 838,  824,  854},
  { 840,  854,  824},
  { 840,  839,  855},
  { 856,  855,  839},
  { 839,  841,  856},
  { 857,  856,  841},
  { 841,  842,  857},
  { 858,  857,  842},
  { 842,  843,  858},
  { 859,  858,  843},
  { 843,  844,  859},
  { 860,  859,  844},
  { 844,  845,  860},
  { 861,  860,  845},
  { 845,  846,  861},
  { 862,  861,  846},
  { 846,  847,  862},
  { 863,  862,  847},
  { 847,  848,  863},
  { 864,  863,  848},
  { 848,  849,  864},
  { 865,  864,  849},
  { 849,  850,  865},
  { 866,  865,  850},
  { 850,  851,  866},
  { 867,  866,  851},
  { 851,  852,  867},
  { 868,  867,  852},
  { 852,  853,  868},
  { 869,  868,  853},
  { 853,  854,  869},
  { 870,  869,  854},
  { 854,  840,  870},
  { 855,  870,  840},
  { 856,  871,  855},
  { 872,  855,  871},
  { 857,  873,  856},
  { 871,  856,  873},
  { 857,  858,  873},
  { 874,  873,  858},
  { 858,  859,  874},
  { 875,  874,  859},
  { 860,  876,  859},
  { 875,  859,  876},
  { 861,  877,  860},
  { 876,  860,  877},
  { 861,  862,  877},
  { 878,  877,  862},
  { 862,  863,  878},
  { 879,  878,  863},
  { 864,  880,  863},
  { 879,  863,  880},
  { 865,  881,  864},
  { 880,  864,  881},
  { 865,  866,  881},
  { 882,  881,  866},
  { 866,  867,  882},
  { 883,  882,  867},
  { 868,  884,  867},
  { 883,  867,  884},
  { 869,  885,  868},
  { 884,  868,  885},
  { 869,  870,  885},
  { 886,  885,  870},
  { 870,  855,  886},
  { 872,  886,  855},
  { 872,  871,  887},
  { 888,  887,  871},
  { 871,  873,  888},
  { 889,  888,  873},
  { 873,  874,  889},
  { 890,  889,  874},
  { 874,  875,  890},
  { 891,  890,  875},
  { 875,  876,  891},
  { 892,  891,  876},
  { 876,  877,  892},
  { 893,  892,  877},
  { 877,  878,  893},
  { 894,  893,  878},
  { 878,  879,  894},
  { 895,  894,  879},
  { 879,  880,  895},
  { 896,  895,  880},
  { 880,  881,  896},
  { 897,  896,  881},
  { 881,  882,  897},
  { 898,  897,  882},
  { 882,  883,  898},
  { 899,  898,  883},
  { 883,  884,  899},
  { 900,  899,  884},
  { 884,  885,  900},
  { 901,  900,  885},
  { 885,  886,  901},
  { 902,  901,  886},
  { 886,  872,  902},
  { 887,  902,  872},
  { 887,  888,  903},
  { 888,  889,  903},
  { 889,  890,  903},
  { 890,  891,  903},
  { 891,  892,  903},
  { 892,  893,  903},
  { 893,  894,  903},
  { 894,  895,  903},
  { 895,  896,  903},
  { 896,  897,  903},
  { 897,  898,  903},
  { 898,  899,  903},
  { 899,  900,  903},
  { 900,  901,  903},
  { 901,  902,  903},
  { 902,  887,  903},
  { 904,  905,  906},
  { 907,  906,  905},
  { 908,  909,  904},
  { 905,  904,  909},
  { 910,  911,  908},
  { 909,  908,  911},
  { 912,  913,  910},
  { 910,  913,  911},
  { 914,  915,  916},
  { 915,  917,  916},
  { 912,  916,  913},
  { 917,  913,  916},
  { 918,  919,  920},
  { 919,  921,  920},
  { 914,  920,  915},
  { 921,  915,  920},
  { 922,  923,  918},
  { 919,  918,  923},
  { 924,  925,  922},
  { 923,  922,  925},
  { 926,  927,  924},
  { 924,  927,  925},
  { 928,  929,  926},
  { 927,  926,  929},
  { 929,  928,  930},
  { 928,  931,  930},
  { 932,  930,  933},
  { 931,  933,  930},
  { 932,  933,  934},
  { 933,  935,  934},
  { 936,  934,  937},
  { 935,  937,  934},
  { 938,  939,  937},
  { 937,  939,  936},
  { 940,  941,  938},
  { 939,  938,  941},
  { 942,  943,  940},
  { 941,  940,  943},
  { 906,  907,  942},
  { 942,  907,  943},
  { 944,  906,  945},
  { 906,  942,  945},
  { 945,  942,  946},
  { 942,  940,  946},
  { 947,  946,  938},
  { 938,  946,  940},
  { 947,  938,  948},
  { 938,  937,  948},
  { 935,  948,  937},
  { 948,  935,  949},
  { 935,  933,  949},
  { 931,  949,  933},
  { 949,  931,  950},
  { 928,  950,  931},
  { 951,  950,  926},
  { 926,  950,  928},
  { 952,  951,  924},
  { 924,  951,  926},
  { 952,  924,  953},
  { 924,  922,  953},
  { 953,  922,  954},
  { 922,  918,  954},
  { 955,  954,  920},
  { 918,  920,  954},
  { 956,  955,  916},
  { 916,  955,  914},
  { 920,  914,  955},
  { 957,  956,  910},
  { 910,  956,  912},
  { 916,  912,  956},
  { 957,  910,  958},
  { 910,  908,  958},
  { 959,  958,  904},
  { 904,  958,  908},
  { 944,  959,  906},
  { 906,  959,  904},
  { 944,  945,  960},
  { 961,  960,  945},
  { 945,  946,  961},
  { 962,  961,  946},
  { 946,  947,  962},
  { 963,  962,  947},
  { 947,  948,  963},
  { 964,  963,  948},
  { 948,  949,  964},
  { 965,  964,  949},
  { 949,  950,  965},
  { 966,  965,  950},
  { 950,  951,  966},
  { 967,  966,  951},
  { 951,  952,  967},
  { 968,  967,  952},
  { 952,  953,  968},
  { 969,  968,  953},
  { 953,  954,  969},
  { 970,  969,  954},
  { 954,  955,  970},
  { 971,  970,  955},
  { 955,  956,  971},
  { 972,  971,  956},
  { 956,  957,  972},
  { 973,  972,  957},
  { 957,  958,  973},
  { 974,  973,  958},
  { 958,  959,  974},
  { 975,  974,  959},
  { 959,  944,  975},
  { 960,  975,  944},
  { 976,  960,  977},
  { 960,  961,  977},
  { 978,  977,  962},
  { 961,  962,  977},
  { 978,  962,  979},
  { 963,  979,  962},
  { 980,  979,  964},
  { 963,  964,  979},
  { 980,  964,  981},
  { 981,  964,  965},
  { 982,  981,  966},
  { 965,  966,  981},
  { 982,  966,  983},
  { 967,  983,  966},
  { 984,  983,  968},
  { 968,  983,  967},
  { 984,  968,  985},
  { 969,  985,  968},
  { 986,  985,  970},
  { 969,  970,  985},
  { 986,  970,  987},
  { 971,  987,  970},
  { 988,  987,  972},
  { 987,  971,  972},
  { 988,  972,  989},
  { 973,  989,  972},
  { 990,  989,  974},
  { 973,  974,  989},
  { 990,  974,  991},
  { 975,  991,  974},
  { 976,  991,  960},
  { 975,  960,  991},
  { 976,  977,  992},
  { 993,  992,  977},
  { 977,  978,  993},
  { 994,  993,  978},
  { 978,  979,  994},
  { 995,  994,  979},
  { 979,  980,  995},
  { 996,  995,  980},
  { 980,  981,  996},
  { 981,  997,  996},
  { 981,  982,  997},
  { 998,  997,  982},
  { 982,  983,  998},
  { 999,  998,  983},
  { 983,  984,  999},
  {1000,  999,  984},
  {1001, 1002, 1003},
  {1002, 1004, 1003},
  {1005, 1006,  985},
  { 985, 1006,  984},
  {1007, 1008, 1009},
  {1008, 1000, 1009},
  {1006, 1003,  984},
  {1009, 1000, 1004},
  { 984, 1003, 1000},
  {1004, 1000, 1003},
  { 985,  986, 1005},
  {1010, 1005,  986},
  {1011, 1012, 1001},
  {1002, 1001, 1012},
  {1013, 1014, 1007},
  {1008, 1007, 1014},
  {1012, 1011, 1015},
  {1011, 1016, 1015},
  {1013, 1017, 1014},
  {1014, 1017, 1018},
  {1010,  986, 1019},
  { 986,  987, 1019},
  {1017, 1015, 1018},
  {1019,  987, 1016},
  {1018, 1015,  987},
  { 987, 1015, 1016},
  { 987,  988, 1018},
  { 988, 1020, 1018},
  { 988,  989, 1020},
  {1021, 1020,  989},
  {1022, 1023, 1024},
  {1023, 1025, 1024},
  {1026, 1027, 1028},
  {1027, 1021, 1028},
  {1029, 1030,  990},
  { 990, 1030,  989},
  {1028, 1021, 1025},
  {1030, 1024,  989},
  {1021,  989, 1025},
  {1024, 1025,  989},
  { 990,  991, 1029},
  {1031, 1029,  991},
  {1032, 1033, 1022},
  {1023, 1022, 1033},
  {1034, 1035, 1026},
  {1027, 1026, 1035},
  {1033, 1032, 1036},
  {1032, 1037, 1036},
  {1034, 1038, 1035},
  {1035, 1038,  992},
  {1031,  991, 1039},
  { 991,  976, 1039},
  {1038, 1036,  992},
  {1039,  976, 1037},
  { 992, 1036,  976},
  {1037,  976, 1036},
  { 992,  993, 1040},
  {1040,  993, 1041},
  { 994, 1042,  993},
  {1041,  993, 1042},
  { 994,  995, 1042},
  {1043, 1042,  995},
  { 996, 1044,  995},
  {1043,  995, 1044},
  { 996,  997, 1044},
  { 997, 1045, 1044},
  { 998, 1046,  997},
  {1045,  997, 1046},
  { 998,  999, 1046},
  {1047, 1046,  999},
  {1000, 1048,  999},
  {1048, 1047,  999},
  {1000, 1008, 1048},
  {1049, 1048, 1008},
  {1014, 1050, 1008},
  {1049, 1008, 1050},
  {1014, 1018, 1050},
  {1051, 1050, 1018},
  {1020, 1052, 1018},
  {1018, 1052, 1051},
  {1020, 1021, 1052},
  {1053, 1052, 1021},
  {1027, 1054, 1021},
  {1053, 1021, 1054},
  {1027, 1035, 1054},
  {1055, 1054, 1035},
  { 992, 1040, 1035},
  {1055, 1035, 1040},
  {1040, 1041, 1056},
  {1056, 1041, 1057},
  {1041, 1042, 1057},
  {1057, 1042, 1058},
  {1042, 1043, 1058},
  {1059, 1058, 1043},
  {1043, 1044, 1059},
  {1060, 1059, 1044},
  {1044, 1045, 1060},
  {1061, 1060, 1045},
  {1045, 1046, 1061},
  {1061, 1046, 1062},
  {1046, 1047, 1062},
  {1062, 1047, 1063},
  {1047, 1048, 1063},
  {1063, 1048, 1064},
  {1048, 1049, 1064},
  {1064, 1049, 1065},
  {1049, 1050, 1065},
  {1065, 1050, 1066},
  {1050, 1051, 1066},
  {1066, 1051, 1067},
  {1051, 1052, 1067},
  {1068, 1067, 1052},
  {1052, 1053, 1068},
  {1069, 1068, 1053},
  {1053, 1054, 1069},
  {1070, 1069, 1054},
  {1054, 1055, 1070},
  {1070, 1055, 1071},
  {1055, 1040, 1071},
  {1071, 1040, 1056},
  {1056, 1057,  907},
  { 907, 1057,  943},
  {1057, 1058,  943},
  { 943, 1058,  941},
  {1059,  939, 1058},
  { 939,  941, 1058},
  {1059, 1060,  939},
  { 939, 1060,  936},
  { 934,  936, 1060},
  {1060, 1061,  934},
  { 934, 1061,  932},
  { 930,  932, 1061},
  {1061, 1062,  930},
  { 929,  930, 1062},
  {1063,  927, 1062},
  { 927,  929, 1062},
  {1064,  925, 1063},
  { 925,  927, 1063},
  {1064, 1065,  925},
  { 925, 1065,  923},
  {1065, 1066,  923},
  { 923, 1066,  919},
  {1067,  921, 1066},
  { 919, 1066,  921},
  {1068,  917, 1067},
  { 917,  915, 1067},
  { 921, 1067,  915},
  {1069,  911, 1068},
  { 911,  913, 1068},
  { 917, 1068,  913},
  {1069, 1070,  911},
  { 911, 1070,  909},
  {1071,  905, 1070},
  { 905,  909, 1070},
  {1056,  907, 1071},
  { 907,  905, 1071},
  {1072, 1073, 1074},
  {1075, 1076, 1077},
  {1073, 1078, 1074},
  {1077, 1076, 1079},
  {1080, 1081, 1082},
  {1081, 1083, 1082},
  {1078, 1082, 1074},
  {1079, 1076, 1083},
  {1074, 1082, 1076},
  {1076, 1082, 1083},
  {1076, 1075, 1084},
  {1085, 1084, 1075},
  {1084, 1085, 1086},
  {1085, 1087, 1086},
  {1086, 1087, 1088},
  {1089, 1088, 1087},
  {1088, 1089, 1090},
  {1091, 1090, 1089},
  {1090, 1091, 1092},
  {1093, 1092, 1091},
  {1092, 1093, 1094},
  {1095, 1094, 1093},
  {1094, 1095, 1096},
  {1097, 1096, 1095},
  {1096, 1097, 1098},
  {1098, 1097, 1099},
  {1098, 1099, 1100},
  {1100, 1099, 1101},
  {1101, 1102, 1100},
  {1103, 1104, 1105},
  {1102, 1106, 1100},
  {1105, 1104, 1107},
  {1108, 1109, 1110},
  {1109, 1111, 1110},
  {1106, 1110, 1100},
  {1107, 1104, 1111},
  {1100, 1110, 1104},
  {1104, 1110, 1111},
  {1104, 1103, 1112},
  {1112, 1103, 1113},
  {1112, 1113, 1114},
  {1114, 1113, 1115},
  {1114, 1115, 1116},
  {1117, 1116, 1115},
  {1116, 1117, 1118},
  {1119, 1118, 1117},
  {1118, 1119, 1120},
  {1121, 1120, 1119},
  {1120, 1121, 1122},
  {1123, 1122, 1121},
  {1122, 1123, 1124},
  {1125, 1124, 1123},
  {1124, 1125, 1126},
  {1125, 1127, 1126},
  {1126, 1127, 1074},
  {1072, 1074, 1127},
  {1124, 1126, 1122},
  {1122, 1126, 1120},
  {1126, 1074, 1120},
  {1120, 1074, 1118},
  {1074, 1076, 1118},
  {1086, 1088, 1084},
  {1084, 1088, 1076},
  {1088, 1090, 1076},
  {1090, 1092, 1076},
  {1076, 1092, 1118},
  {1114, 1116, 1112},
  {1112, 1116, 1104},
  {1116, 1118, 1104},
  {1096, 1098, 1094},
  {1098, 1100, 1094},
  {1094, 1100, 1092},
  {1118, 1092, 1104},
  {1100, 1104, 1092},
  {1077, 1102, 1075},
  {1102, 1101, 1075},
  {1087, 1085, 1089},
  {1089, 1085, 1091},
  {1085, 1075, 1091},
  {1075, 1101, 1091},
  {1091, 1101, 1093},
  {1093, 1101, 1095},
  {1095, 1101, 1097},
  {1101, 1099, 1097},
  {1081, 1080, 1108},
  {1109, 1108, 1080},
  {1073, 1072, 1105},
  {1105, 1072, 1103},
  {1125, 1123, 1127},
  {1127, 1123, 1072},
  {1072, 1123, 1103},
  {1115, 1113, 1117},
  {1113, 1103, 1117},
  {1103, 1123, 1117},
  {1117, 1123, 1119},
  {1123, 1121, 1119},
  {1128, 1129, 1130},
  {1131, 1132, 1133},
  {1129, 1134, 1130},
  {1133, 1132, 1135},
  {1136, 1137, 1138},
  {1137, 1139, 1138},
  {1134, 1138, 1130},
  {1135, 1132, 1139},
  {1130, 1138, 1132},
  {1132, 1138, 1139},
  {1130, 1140, 1128},
  {1141, 1128, 1140},
  {1140, 1142, 1141},
  {1141, 1142, 1143},
  {1142, 1144, 1143},
  {1145, 1143, 1144},
  {1144, 1146, 1145},
  {1147, 1145, 1146},
  {1146, 1148, 1147},
  {1149, 1147, 1148},
  {1148, 1150, 1149},
  {1151, 1149, 1150},
  {1150, 1152, 1151},
  {1153, 1151, 1152},
  {1152, 1154, 1153},
  {1154, 1155, 1153},
  {1154, 1156, 1155},
  {1156, 1157, 1155},
  {1158, 1159, 1160},
  {1157, 1156, 1161},
  {1159, 1162, 1160},
  {1161, 1156, 1163},
  {1164, 1165, 1166},
  {1165, 1167, 1166},
  {1162, 1166, 1160},
  {1163, 1156, 1167},
  {1160, 1166, 1156},
  {1156, 1166, 1167},
  {1160, 1168, 1158},
  {1168, 1169, 1158},
  {1168, 1170, 1169},
  {1170, 1171, 1169},
  {1170, 1172, 1171},
  {1173, 1171, 1172},
  {1172, 1174, 1173},
  {1175, 1173, 1174},
  {1174, 1176, 1175},
  {1177, 1175, 1176},
  {1176, 1178, 1177},
  {1179, 1177, 1178},
  {1178, 1180, 1179},
  {1181, 1179, 1180},
  {1180, 1182, 1181},
  {1181, 1182, 1183},
  {1182, 1132, 1183},
  {1131, 1183, 1132},
  {1142, 1140, 1144},
  {1144, 1140, 1146},
  {1140, 1130, 1146},
  {1146, 1130, 1148},
  {1130, 1132, 1148},
  {1180, 1178, 1182},
  {1182, 1178, 1132},
  {1178, 1176, 1132},
  {1176, 1174, 1132},
  {1132, 1174, 1148},
  {1152, 1150, 1154},
  {1154, 1150, 1156},
  {1150, 1148, 1156},
  {1170, 1168, 1172},
  {1168, 1160, 1172},
  {1172, 1160, 1174},
  {1148, 1174, 1156},
  {1160, 1156, 1174},
  {1161, 1129, 1157},
  {1129, 1128, 1157},
  {1143, 1145, 1141},
  {1141, 1145, 1128},
  {1128, 1145, 1157},
  {1153, 1155, 1151},
  {1155, 1157, 1151},
  {1157, 1145, 1151},
  {1151, 1145, 1149},
  {1145, 1147, 1149},
  {1165, 1164, 1136},
  {1137, 1136, 1164},
  {1159, 1158, 1133},
  {1133, 1158, 1131},
  {1181, 1183, 1179},
  {1179, 1183, 1177},
  {1183, 1131, 1177},
  {1131, 1158, 1177},
  {1177, 1158, 1175},
  {1175, 1158, 1173},
  {1173, 1158, 1171},
  {1158, 1169, 1171},
  {1184, 1110, 1185},
  {1106, 1185, 1110},
  {1083, 1186, 1079},
  {1187, 1079, 1186},
  {1188, 1138, 1189},
  {1134, 1189, 1138},
  {1167, 1190, 1163},
  {1191, 1163, 1190},
  {1192, 1036, 1193},
  {1038, 1193, 1036},
  {1004, 1194, 1009},
  {1195, 1009, 1194},
  {1194, 1184, 1195},
  {1195, 1184, 1185},
  {1190, 1192, 1191},
  {1191, 1192, 1193},
  {1083, 1081, 1186},
  {1186, 1081, 1196},
  {1081, 1108, 1196},
  {1004, 1002, 1194},
  {1015, 1196, 1012},
  {1196, 1108, 1012},
  {1012, 1108, 1002},
  {1002, 1108, 1194},
  {1110, 1184, 1108},
  {1194, 1108, 1184},
  {1138, 1188, 1136},
  {1188, 1197, 1136},
  {1136, 1197, 1165},
  {1036, 1192, 1033},
  {1025, 1023, 1197},
  {1197, 1023, 1165},
  {1023, 1033, 1165},
  {1033, 1192, 1165},
  {1167, 1165, 1190},
  {1192, 1190, 1165},
  {1079, 1187, 1077},
  {1187, 1198, 1077},
  {1077, 1198, 1102},
  {1009, 1195, 1007},
  {1017, 1013, 1198},
  {1198, 1013, 1102},
  {1013, 1007, 1102},
  {1007, 1195, 1102},
  {1106, 1102, 1185},
  {1195, 1185, 1102},
  {1134, 1129, 1189},
  {1189, 1129, 1199},
  {1129, 1161, 1199},
  {1038, 1034, 1193},
  {1028, 1199, 1026},
  {1199, 1161, 1026},
  {1026, 1161, 1034},
  {1034, 1161, 1193},
  {1163, 1191, 1161},
  {1193, 1161, 1191},
  {1196, 1198, 1186},
  {1186, 1198, 1187},
  {1017, 1198, 1015},
  {1196, 1015, 1198},
  {1197, 1199, 1025},
  {1028, 1025, 1199},
  {1199, 1197, 1189},
  {1189, 1197, 1188},
  {1200, 1201, 1111},
  {1107, 1111, 1201},
  {1078, 1202, 1082},
  {1203, 1082, 1202},
  {1204, 1135, 1205},
  {1139, 1205, 1135},
  {1162, 1206, 1166},
  {1207, 1166, 1206},
  {1208, 1209, 1037},
  {1039, 1037, 1209},
  {1006, 1210, 1003},
  {1211, 1003, 1210},
  {1211, 1210, 1200},
  {1210, 1201, 1200},
  {1207, 1206, 1208},
  {1206, 1209, 1208},
  {1082, 1203, 1080},
  {1203, 1212, 1080},
  {1080, 1212, 1109},
  {1003, 1211, 1001},
  {1016, 1011, 1212},
  {1212, 1011, 1109},
  {1011, 1001, 1109},
  {1001, 1211, 1109},
  {1111, 1109, 1200},
  {1211, 1200, 1109},
  {1139, 1137, 1205},
  {1205, 1137, 1213},
  {1137, 1164, 1213},
  {1037, 1032, 1208},
  {1024, 1213, 1022},
  {1213, 1164, 1022},
  {1022, 1164, 1032},
  {1032, 1164, 1208},
  {1166, 1207, 1164},
  {1208, 1164, 1207},
  {1078, 1073, 1202},
  {1202, 1073, 1214},
  {1073, 1105, 1214},
  {1006, 1005, 1210},
  {1019, 1214, 1010},
  {1214, 1105, 1010},
  {1010, 1105, 1005},
  {1005, 1105, 1210},
  {1107, 1201, 1105},
  {1210, 1105, 1201},
  {1135, 1204, 1133},
  {1204, 1215, 1133},
  {1133, 1215, 1159},
  {1039, 1209, 1031},
  {1030, 1029, 1215},
  {1215, 1029, 1159},
  {1029, 1031, 1159},
  {1031, 1209, 1159},
  {1162, 1159, 1206},
  {1209, 1206, 1159},
  {1214, 1212, 1202},
  {1202, 1212, 1203},
  {1016, 1212, 1019},
  {1214, 1019, 1212},
  {1215, 1213, 1030},
  {1024, 1030, 1213},
  {1213, 1215, 1205},
  {1205, 1215, 1204},
  {1216, 1217, 1218},
  {1219, 1218, 1217},
  {1217, 1220, 1219},
  {1221, 1219, 1220},
  {1220, 1222, 1221},
  {1223, 1221, 1222},
  {1222, 1224, 1223},
  {1224, 1225, 1223},
  {1224, 1226, 1225},
  {1226, 1227, 1225},
  {1226, 1228, 1227},
  {1229, 1227, 1228},
  {1228, 1230, 1229},
  {1231, 1229, 1230},
  {1230, 1232, 1231},
  {1233, 1231, 1232},
  {1232, 1234, 1233},
  {1235, 1233, 1234},
  {1234, 1236, 1235},
  {1237, 1235, 1236},
  {1236, 1238, 1237},
  {1239, 1237, 1238},
  {1238, 1240, 1239},
  {1240, 1241, 1239},
  {1240, 1242, 1241},
  {1242, 1243, 1241},
  {1242, 1244, 1243},
  {1245, 1243, 1244},
  {1244, 1246, 1245},
  {1247, 1245, 1246},
  {1246, 1216, 1247},
  {1218, 1247, 1216},
  {1248, 1249, 1250},
  {1249, 1251, 1250},
  {1249, 1252, 1251},
  {1253, 1251, 1252},
  {1252, 1254, 1253},
  {1255, 1253, 1254},
  {1254, 1256, 1255},
  {1257, 1255, 1256},
  {1256, 1258, 1257},
  {1259, 1257, 1258},
  {1258, 1260, 1259},
  {1261, 1259, 1260},
  {1260, 1262, 1261},
  {1263, 1261, 1262},
  {1262, 1264, 1263},
  {1264, 1265, 1263},
  {1264, 1266, 1265},
  {1267, 1265, 1266},
  {1266, 1268, 1267},
  {1269, 1267, 1268},
  {1268, 1270, 1269},
  {1271, 1269, 1270},
  {1270, 1272, 1271},
  {1273, 1271, 1272},
  {1272, 1274, 1273},
  {1275, 1273, 1274},
  {1274, 1276, 1275},
  {1277, 1275, 1276},
  {1276, 1278, 1277},
  {1279, 1277, 1278},
  {1278, 1248, 1279},
  {1250, 1279, 1248},
  {1250, 1251, 1280},
  {1281, 1280, 1251},
  {1282, 1283, 1216},
  {1217, 1216, 1283},
  {1253, 1284, 1251},
  {1281, 1251, 1284},
  {1285, 1220, 1283},
  {1220, 1217, 1283},
  {1253, 1255, 1284},
  {1286, 1284, 1255},
  {1285, 1287, 1220},
  {1220, 1287, 1222},
  {1257, 1288, 1255},
  {1288, 1286, 1255},
  {1289, 1224, 1287},
  {1222, 1287, 1224},
  {1257, 1259, 1288},
  {1290, 1288, 1259},
  {1289, 1291, 1224},
  {1291, 1226, 1224},
  {1261, 1292, 1259},
  {1290, 1259, 1292},
  {1293, 1228, 1291},
  {1228, 1226, 1291},
  {1261, 1263, 1292},
  {1294, 1292, 1263},
  {1293, 1295, 1228},
  {1228, 1295, 1230},
  {1265, 1296, 1263},
  {1294, 1263, 1296},
  {1297, 1232, 1295},
  {1230, 1295, 1232},
  {1265, 1267, 1296},
  {1298, 1296, 1267},
  {1297, 1299, 1232},
  {1234, 1232, 1299},
  {1269, 1300, 1267},
  {1298, 1267, 1300},
  {1301, 1236, 1299},
  {1236, 1234, 1299},
  {1269, 1271, 1300},
  {1302, 1300, 1271},
  {1301, 1303, 1236},
  {1236, 1303, 1238},
  {1273, 1304, 1271},
  {1302, 1271, 1304},
  {1305, 1240, 1303},
  {1303, 1240, 1238},
  {1273, 1275, 1304},
  {1304, 1275, 1306},
  {1305, 1307, 1240},
  {1242, 1240, 1307},
  {1277, 1308, 1275},
  {1306, 1275, 1308},
  {1309, 1244, 1307},
  {1244, 1242, 1307},
  {1277, 1279, 1308},
  {1310, 1308, 1279},
  {1309, 1311, 1244},
  {1244, 1311, 1246},
  {1250, 1280, 1279},
  {1310, 1279, 1280},
  {1282, 1216, 1311},
  {1246, 1311, 1216},
  {1312, 1218, 1313},
  {1219, 1313, 1218},
  {1248, 1314, 1249},
  {1315, 1249, 1314},
  {1316, 1313, 1221},
  {1221, 1313, 1219},
  {1252, 1249, 1317},
  {1315, 1317, 1249},
  {1316, 1221, 1318},
  {1221, 1223, 1318},
  {1252, 1317, 1254},
  {1319, 1254, 1317},
  {1320, 1318, 1225},
  {1223, 1225, 1318},
  {1256, 1254, 1321},
  {1321, 1254, 1319},
  {1320, 1225, 1322},
  {1322, 1225, 1227},
  {1256, 1321, 1258},
  {1323, 1258, 1321},
  {1324, 1322, 1229},
  {1229, 1322, 1227},
  {1260, 1258, 1325},
  {1323, 1325, 1258},
  {1324, 1229, 1326},
  {1229, 1231, 1326},
  {1260, 1325, 1262},
  {1327, 1262, 1325},
  {1328, 1326, 1233},
  {1231, 1233, 1326},
  {1264, 1262, 1329},
  {1327, 1329, 1262},
  {1328, 1233, 1330},
  {1235, 1330, 1233},
  {1264, 1329, 1266},
  {1331, 1266, 1329},
  {1332, 1330, 1237},
  {1237, 1330, 1235},
  {1268, 1266, 1333},
  {1331, 1333, 1266},
  {1332, 1237, 1334},
  {1237, 1239, 1334},
  {1268, 1333, 1270},
  {1335, 1270, 1333},
  {1336, 1334, 1241},
  {1334, 1239, 1241},
  {1272, 1270, 1337},
  {1335, 1337, 1270},
  {1336, 1241, 1338},
  {1243, 1338, 1241},
  {1272, 1337, 1274},
  {1337, 1339, 1274},
  {1340, 1338, 1245},
  {1245, 1338, 1243},
  {1276, 1274, 1341},
  {1339, 1341, 1274},
  {1340, 1245, 1342},
  {1245, 1247, 1342},
  {1276, 1341, 1278},
  {1343, 1278, 1341},
  {1312, 1342, 1218},
  {1247, 1218, 1342},
  {1248, 1278, 1314},
  {1343, 1314, 1278},
  {1281, 1344, 1280},
  {1345, 1280, 1344},
  {1284, 1346, 1281},
  {1344, 1281, 1346},
  {1286, 1347, 1284},
  {1346, 1284, 1347},
  {1288, 1348, 1286},
  {1347, 1286, 1348},
  {1290, 1349, 1288},
  {1348, 1288, 1349},
  {1292, 1350, 1290},
  {1349, 1290, 1350},
  {1294, 1351, 1292},
  {1350, 1292, 1351},
  {1296, 1352, 1294},
  {1351, 1294, 1352},
  {1298, 1353, 1296},
  {1352, 1296, 1353},
  {1300, 1354, 1298},
  {1353, 1298, 1354},
  {1302, 1355, 1300},
  {1354, 1300, 1355},
  {1304, 1356, 1302},
  {1355, 1302, 1356},
  {1306, 1357, 1304},
  {1356, 1304, 1357},
  {1308, 1358, 1306},
  {1357, 1306, 1358},
  {1310, 1359, 1308},
  {1358, 1308, 1359},
  {1280, 1345, 1310},
  {1359, 1310, 1345},
  {1344, 1360, 1345},
  {1361, 1345, 1360},
  {1344, 1346, 1360},
  {1362, 1360, 1346},
  {1347, 1363, 1346},
  {1362, 1346, 1363},
  {1347, 1348, 1363},
  {1364, 1363, 1348},
  {1349, 1365, 1348},
  {1364, 1348, 1365},
  {1349, 1350, 1365},
  {1366, 1365, 1350},
  {1351, 1367, 1350},
  {1366, 1350, 1367},
  {1351, 1352, 1367},
  {1368, 1367, 1352},
  {1353, 1369, 1352},
  {1368, 1352, 1369},
  {1353, 1354, 1369},
  {1370, 1369, 1354},
  {1355, 1371, 1354},
  {1370, 1354, 1371},
  {1355, 1356, 1371},
  {1372, 1371, 1356},
  {1357, 1373, 1356},
  {1372, 1356, 1373},
  {1357, 1358, 1373},
  {1374, 1373, 1358},
  {1359, 1375, 1358},
  {1374, 1358, 1375},
  {1359, 1345, 1375},
  {1361, 1375, 1345},
  {1360, 1376, 1361},
  {1376, 1377, 1361},
  {1362, 1378, 1360},
  {1378, 1376, 1360},
  {1362, 1363, 1378},
  {1378, 1363, 1379},
  {1363, 1364, 1379},
  {1380, 1379, 1364},
  {1365, 1381, 1364},
  {1381, 1380, 1364},
  {1366, 1382, 1365},
  {1382, 1381, 1365},
  {1366, 1367, 1382},
  {1382, 1367, 1383},
  {1367, 1368, 1383},
  {1383, 1368, 1384},
  {1369, 1385, 1368},
  {1385, 1384, 1368},
  {1370, 1386, 1369},
  {1386, 1385, 1369},
  {1370, 1371, 1386},
  {1386, 1371, 1387},
  {1371, 1372, 1387},
  {1387, 1372, 1388},
  {1373, 1389, 1372},
  {1388, 1372, 1389},
  {1374, 1390, 1373},
  {1390, 1389, 1373},
  {1374, 1375, 1390},
  {1390, 1375, 1391},
  {1375, 1361, 1391},
  {1391, 1361, 1377},
  {1376, 1392, 1377},
  {1392, 1393, 1377},
  {1376, 1378, 1392},
  {1392, 1378, 1394},
  {1379, 1395, 1378},
  {1395, 1394, 1378},
  {1379, 1380, 1395},
  {1395, 1380, 1396},
  {1381, 1397, 1380},
  {1397, 1396, 1380},
  {1381, 1382, 1397},
  {1397, 1382, 1398},
  {1383, 1399, 1382},
  {1399, 1398, 1382},
  {1383, 1384, 1399},
  {1399, 1384, 1400},
  {1385, 1401, 1384},
  {1401, 1400, 1384},
  {1385, 1386, 1401},
  {1401, 1386, 1402},
  {1387, 1403, 1386},
  {1403, 1402, 1386},
  {1387, 1388, 1403},
  {1403, 1388, 1404},
  {1389, 1405, 1388},
  {1405, 1404, 1388},
  {1389, 1390, 1405},
  {1405, 1390, 1406},
  {1391, 1407, 1390},
  {1407, 1406, 1390},
  {1391, 1377, 1407},
  {1407, 1377, 1393},
  {1393, 1392, 1408},
  {1409, 1408, 1392},
  {1394, 1410, 1392},
  {1409, 1392, 1410},
  {1394, 1395, 1410},
  {1411, 1410, 1395},
  {1396, 1412, 1395},
  {1411, 1395, 1412},
  {1396, 1397, 1412},
  {1413, 1412, 1397},
  {1398, 1414, 1397},
  {1413, 1397, 1414},
  {1398, 1399, 1414},
  {1415, 1414, 1399},
  {1400, 1416, 1399},
  {1415, 1399, 1416},
  {1400, 1401, 1416},
  {1417, 1416, 1401},
  {1402, 1418, 1401},
  {1417, 1401, 1418},
  {1402, 1403, 1418},
  {1419, 1418, 1403},
  {1404, 1420, 1403},
  {1419, 1403, 1420},
  {1404, 1405, 1420},
  {1421, 1420, 1405},
  {1406, 1422, 1405},
  {1421, 1405, 1422},
  {1406, 1407, 1422},
  {1423, 1422, 1407},
  {1393, 1408, 1407},
  {1423, 1407, 1408},
  {1409, 1424, 1408},
  {1425, 1408, 1424},
  {1410, 1426, 1409},
  {1426, 1424, 1409},
  {1410, 1411, 1426},
  {1426, 1411, 1427},
  {1411, 1412, 1427},
  {1428, 1427, 1412},
  {1413, 1429, 1412},
  {1428, 1412, 1429},
  {1414, 1430, 1413},
  {1430, 1429, 1413},
  {1414, 1415, 1430},
  {1430, 1415, 1431},
  {1415, 1416, 1431},
  {1432, 1431, 1416},
  {1417, 1433, 1416},
  {1432, 1416, 1433},
  {1418, 1434, 1417},
  {1434, 1433, 1417},
  {1418, 1419, 1434},
  {1434, 1419, 1435},
  {1419, 1420, 1435},
  {1436, 1435, 1420},
  {1421, 1437, 1420},
  {1436, 1420, 1437},
  {1422, 1438, 1421},
  {1438, 1437, 1421},
  {1422, 1423, 1438},
  {1438, 1423, 1439},
  {1423, 1408, 1439},
  {1425, 1439, 1408},
  {1425, 1424, 1440},
  {1441, 1440, 1424},
  {1424, 1426, 1441},
  {1442, 1441, 1426},
  {1427, 1443, 1426},
  {1426, 1443, 1442},
  {1428, 1444, 1427},
  {1444, 1443, 1427},
  {1428, 1429, 1444},
  {1444, 1429, 1445},
  {1429, 1430, 1445},
  {1446, 1445, 1430},
  {1431, 1447, 1430},
  {1446, 1430, 1447},
  {1432, 1448, 1431},
  {1447, 1431, 1448},
  {1432, 1433, 1448},
  {1449, 1448, 1433},
  {1433, 1434, 1449},
  {1450, 1449, 1434},
  {1435, 1451, 1434},
  {1450, 1434, 1451},
  {1436, 1452, 1435},
  {1452, 1451, 1435},
  {1436, 1437, 1452},
  {1452, 1437, 1453},
  {1437, 1438, 1453},
  {1438, 1454, 1453},
  {1439, 1455, 1438},
  {1454, 1438, 1455},
  {1425, 1440, 1439},
  {1455, 1439, 1440},
  {1441, 1456, 1440},
  {1457, 1440, 1456},
  {1442, 1458, 1441},
  {1456, 1441, 1458},
  {1442, 1443, 1458},
  {1459, 1458, 1443},
  {1443, 1444, 1459},
  {1460, 1459, 1444},
  {1445, 1461, 1444},
  {1460, 1444, 1461},
  {1446, 1462, 1445},
  {1461, 1445, 1462},
  {1446, 1447, 1462},
  {1463, 1462, 1447},
  {1447, 1448, 1463},
  {1464, 1463, 1448},
  {1449, 1465, 1448},
  {1464, 1448, 1465},
  {1450, 1466, 1449},
  {1465, 1449, 1466},
  {1450, 1451, 1466},
  {1467, 1466, 1451},
  {1451, 1452, 1467},
  {1468, 1467, 1452},
  {1453, 1469, 1452},
  {1468, 1452, 1469},
  {1454, 1470, 1453},
  {1469, 1453, 1470},
  {1454, 1455, 1470},
  {1471, 1470, 1455},
  {1455, 1440, 1471},
  {1457, 1471, 1440},
  {1456, 1472, 1457},
  {1473, 1457, 1472},
  {1456, 1458, 1472},
  {1474, 1472, 1458},
  {1459, 1475, 1458},
  {1474, 1458, 1475},
  {1459, 1460, 1475},
  {1476, 1475, 1460},
  {1461, 1477, 1460},
  {1476, 1460, 1477},
  {1461, 1462, 1477},
  {1478, 1477, 1462},
  {1463, 1479, 1462},
  {1478, 1462, 1479},
  {1463, 1464, 1479},
  {1480, 1479, 1464},
  {1465, 1481, 1464},
  {1481, 1480, 1464},
  {1465, 1466, 1481},
  {1482, 1481, 1466},
  {1467, 1483, 1466},
  {1482, 1466, 1483},
  {1467, 1468, 1483},
  {1484, 1483, 1468},
  {1469, 1485, 1468},
  {1484, 1468, 1485},
  {1469, 1470, 1485},
  {1486, 1485, 1470},
  {1471, 1487, 1470},
  {1486, 1470, 1487},
  {1471, 1457, 1487},
  {1487, 1457, 1473},
  {1473, 1472, 1282},
  {1283, 1282, 1472},
  {1472, 1474, 1283},
  {1285, 1283, 1474},
  {1474, 1475, 1285},
  {1287, 1285, 1475},
  {1475, 1476, 1287},
  {1289, 1287, 1476},
  {1476, 1477, 1289},
  {1291, 1289, 1477},
  {1477, 1478, 1291},
  {1293, 1291, 1478},
  {1478, 1479, 1293},
  {1295, 1293, 1479},
  {1479, 1480, 1295},
  {1297, 1295, 1480},
  {1480, 1481, 1297},
  {1299, 1297, 1481},
  {1481, 1482, 1299},
  {1301, 1299, 1482},
  {1482, 1483, 1301},
  {1303, 1301, 1483},
  {1483, 1484, 1303},
  {1305, 1303, 1484},
  {1484, 1485, 1305},
  {1307, 1305, 1485},
  {1485, 1486, 1307},
  {1309, 1307, 1486},
  {1486, 1487, 1309},
  {1311, 1309, 1487},
  {1487, 1473, 1311},
  {1282, 1311, 1473},
  {1314, 1488, 1315},
  {1489, 1315, 1488},
  {1315, 1489, 1317},
  {1490, 1317, 1489},
  {1317, 1490, 1319},
  {1491, 1319, 1490},
  {1319, 1491, 1321},
  {1492, 1321, 1491},
  {1321, 1492, 1323},
  {1493, 1323, 1492},
  {1323, 1493, 1325},
  {1494, 1325, 1493},
  {1325, 1494, 1327},
  {1495, 1327, 1494},
  {1327, 1495, 1329},
  {1496, 1329, 1495},
  {1329, 1496, 1331},
  {1497, 1331, 1496},
  {1331, 1497, 1333},
  {1498, 1333, 1497},
  {1333, 1498, 1335},
  {1499, 1335, 1498},
  {1335, 1499, 1337},
  {1500, 1337, 1499},
  {1337, 1500, 1339},
  {1501, 1339, 1500},
  {1339, 1501, 1341},
  {1502, 1341, 1501},
  {1341, 1502, 1343},
  {1503, 1343, 1502},
  {1343, 1503, 1314},
  {1488, 1314, 1503},
  {1489, 1488, 1504},
  {1505, 1504, 1488},
  {1489, 1504, 1490},
  {1506, 1490, 1504},
  {1491, 1490, 1507},
  {1506, 1507, 1490},
  {1491, 1507, 1492},
  {1508, 1492, 1507},
  {1493, 1492, 1509},
  {1508, 1509, 1492},
  {1493, 1509, 1494},
  {1510, 1494, 1509},
  {1495, 1494, 1511},
  {1510, 1511, 1494},
  {1495, 1511, 1496},
  {1512, 1496, 1511},
  {1497, 1496, 1513},
  {1512, 1513, 1496},
  {1497, 1513, 1498},
  {1514, 1498, 1513},
  {1499, 1498, 1515},
  {1514, 1515, 1498},
  {1499, 1515, 1500},
  {1516, 1500, 1515},
  {1501, 1500, 1517},
  {1516, 1517, 1500},
  {1501, 1517, 1502},
  {1518, 1502, 1517},
  {1503, 1502, 1519},
  {1518, 1519, 1502},
  {1503, 1519, 1488},
  {1505, 1488, 1519},
  {1504, 1505, 1520},
  {1520, 1505, 1521},
  {1506, 1504, 1522},
  {1522, 1504, 1520},
  {1506, 1522, 1507},
  {1522, 1523, 1507},
  {1507, 1523, 1508},
  {1524, 1508, 1523},
  {1509, 1508, 1525},
  {1525, 1508, 1524},
  {1510, 1509, 1526},
  {1526, 1509, 1525},
  {1510, 1526, 1511},
  {1526, 1527, 1511},
  {1511, 1527, 1512},
  {1527, 1528, 1512},
  {1513, 1512, 1529},
  {1529, 1512, 1528},
  {1514, 1513, 1530},
  {1530, 1513, 1529},
  {1514, 1530, 1515},
  {1530, 1531, 1515},
  {1515, 1531, 1516},
  {1531, 1532, 1516},
  {1517, 1516, 1533},
  {1532, 1533, 1516},
  {1518, 1517, 1534},
  {1534, 1517, 1533},
  {1518, 1534, 1519},
  {1534, 1535, 1519},
  {1519, 1535, 1505},
  {1535, 1521, 1505},
  {1520, 1521, 1536},
  {1536, 1521, 1537},
  {1520, 1536, 1522},
  {1536, 1538, 1522},
  {1523, 1522, 1539},
  {1539, 1522, 1538},
  {1523, 1539, 1524},
  {1539, 1540, 1524},
  {1525, 1524, 1541},
  {1541, 1524, 1540},
  {1525, 1541, 1526},
  {1541, 1542, 1526},
  {1527, 1526, 1543},
  {1543, 1526, 1542},
  {1527, 1543, 1528},
  {1543, 1544, 1528},
  {1529, 1528, 1545},
  {1545, 1528, 1544},
  {1529, 1545, 1530},
  {1545, 1546, 1530},
  {1531, 1530, 1547},
  {1547, 1530, 1546},
  {1531, 1547, 1532},
  {1547, 1548, 1532},
  {1533, 1532, 1549},
  {1549, 1532, 1548},
  {1533, 1549, 1534},
  {1549, 1550, 1534},
  {1535, 1534, 1551},
  {1551, 1534, 1550},
  {1535, 1551, 1521},
  {1551, 1537, 1521},
  {1537, 1552, 1536},
  {1553, 1536, 1552},
  {1538, 1536, 1554},
  {1553, 1554, 1536},
  {1538, 1554, 1539},
  {1555, 1539, 1554},
  {1540, 1539, 1556},
  {1555, 1556, 1539},
  {1540, 1556, 1541},
  {1557, 1541, 1556},
  {1542, 1541, 1558},
  {1557, 1558, 1541},
  {1542, 1558, 1543},
  {1559, 1543, 1558},
  {1544, 1543, 1560},
  {1559, 1560, 1543},
  {1544, 1560, 1545},
  {1561, 1545, 1560},
  {1546, 1545, 1562},
  {1561, 1562, 1545},
  {1546, 1562, 1547},
  {1563, 1547, 1562},
  {1548, 1547, 1564},
  {1563, 1564, 1547},
  {1548, 1564, 1549},
  {1565, 1549, 1564},
  {1550, 1549, 1566},
  {1565, 1566, 1549},
  {1550, 1566, 1551},
  {1567, 1551, 1566},
  {1537, 1551, 1552},
  {1567, 1552, 1551},
  {1553, 1552, 1568},
  {1569, 1568, 1552},
  {1554, 1553, 1570},
  {1570, 1553, 1568},
  {1554, 1570, 1555},
  {1570, 1571, 1555},
  {1555, 1571, 1556},
  {1572, 1556, 1571},
  {1557, 1556, 1573},
  {1572, 1573, 1556},
  {1558, 1557, 1574},
  {1574, 1557, 1573},
  {1558, 1574, 1559},
  {1574, 1575, 1559},
  {1559, 1575, 1560},
  {1576, 1560, 1575},
  {1561, 1560, 1577},
  {1576, 1577, 1560},
  {1562, 1561, 1578},
  {1578, 1561, 1577},
  {1562, 1578, 1563},
  {1578, 1579, 1563},
  {1563, 1579, 1564},
  {1580, 1564, 1579},
  {1565, 1564, 1581},
  {1580, 1581, 1564},
  {1566, 1565, 1582},
  {1582, 1565, 1581},
  {1566, 1582, 1567},
  {1582, 1583, 1567},
  {1567, 1583, 1552},
  {1569, 1552, 1583},
  {1569, 1584, 1568},
  {1585, 1568, 1584},
  {1568, 1585, 1570},
  {1586, 1570, 1585},
  {1571, 1570, 1587},
  {1570, 1586, 1587},
  {1572, 1571, 1588},
  {1588, 1571, 1587},
  {1572, 1588, 1573},
  {1588, 1589, 1573},
  {1573, 1589, 1574},
  {1590, 1574, 1589},
  {1575, 1574, 1591},
  {1590, 1591, 1574},
  {1576, 1575, 1592},
  {1591, 1592, 1575},
  {1576, 1592, 1577},
  {1593, 1577, 1592},
  {1577, 1593, 1578},
  {1594, 1578, 1593},
  {1579, 1578, 1595},
  {1594, 1595, 1578},
  {1580, 1579, 1596},
  {1596, 1579, 1595},
  {1580, 1596, 1581},
  {1596, 1597, 1581},
  {1581, 1597, 1582},
  {1582, 1597, 1598},
  {1583, 1582, 1599},
  {1598, 1599, 1582},
  {1569, 1583, 1584},
  {1599, 1584, 1583},
  {1585, 1584, 1600},
  {1601, 1600, 1584},
  {1586, 1585, 1602},
  {1600, 1602, 1585},
  {1586, 1602, 1587},
  {1603, 1587, 1602},
  {1587, 1603, 1588},
  {1604, 1588, 1603},
  {1589, 1588, 1605},
  {1604, 1605, 1588},
  {1590, 1589, 1606},
  {1605, 1606, 1589},
  {1590, 1606, 1591},
  {1607, 1591, 1606},
  {1591, 1607, 1592},
  {1608, 1592, 1607},
  {1593, 1592, 1609},
  {1608, 1609, 1592},
  {1594, 1593, 1610},
  {1609, 1610, 1593},
  {1594, 1610, 1595},
  {1611, 1595, 1610},
  {1595, 1611, 1596},
  {1612, 1596, 1611},
  {1597, 1596, 1613},
  {1612, 1613, 1596},
  {1598, 1597, 1614},
  {1613, 1614, 1597},
  {1598, 1614, 1599},
  {1615, 1599, 1614},
  {1599, 1615, 1584},
  {1601, 1584, 1615},
  {1600, 1601, 1616},
  {1617, 1616, 1601},
  {1600, 1616, 1602},
  {1618, 1602, 1616},
  {1603, 1602, 1619},
  {1618, 1619, 1602},
  {1603, 1619, 1604},
  {1620, 1604, 1619},
  {1605, 1604, 1621},
  {1620, 1621, 1604},
  {1605, 1621, 1606},
  {1622, 1606, 1621},
  {1607, 1606, 1623},
  {1622, 1623, 1606},
  {1607, 1623, 1608},
  {1624, 1608, 1623},
  {1609, 1608, 1625},
  {1625, 1608, 1624},
  {1609, 1625, 1610},
  {1626, 1610, 1625},
  {1611, 1610, 1627},
  {1626, 1627, 1610},
  {1611, 1627, 1612},
  {1628, 1612, 1627},
  {1613, 1612, 1629},
  {1628, 1629, 1612},
  {1613, 1629, 1614},
  {1630, 1614, 1629},
  {1615, 1614, 1631},
  {1630, 1631, 1614},
  {1615, 1631, 1601},
  {1631, 1617, 1601},
  {1617, 1312, 1616},
  {1313, 1616, 1312},
  {1616, 1313, 1618},
  {1316, 1618, 1313},
  {1618, 1316, 1619},
  {1318, 1619, 1316},
  {1619, 1318, 1620},
  {1320, 1620, 1318},
  {1620, 1320, 1621},
  {1322, 1621, 1320},
  {1621, 1322, 1622},
  {1324, 1622, 1322},
  {1622, 1324, 1623},
  {1326, 1623, 1324},
  {1623, 1326, 1624},
  {1328, 1624, 1326},
  {1624, 1328, 1625},
  {1330, 1625, 1328},
  {1625, 1330, 1626},
  {1332, 1626, 1330},
  {1626, 1332, 1627},
  {1334, 1627, 1332},
  {1627, 1334, 1628},
  {1336, 1628, 1334},
  {1628, 1336, 1629},
  {1338, 1629, 1336},
  {1629, 1338, 1630},
  {1340, 1630, 1338},
  {1630, 1340, 1631},
  {1342, 1631, 1340},
  {1631, 1342, 1617},
  {1312, 1617, 1342},
  {1632, 1633, 1634},
  {1635, 1634, 1633},
  {1633, 1636, 1635},
  {1636, 1637, 1635},
  {1636, 1638, 1637},
  {1638, 1639, 1637},
  {1638, 1640, 1639},
  {1641, 1639, 1640},
  {1640, 1642, 1641},
  {1643, 1641, 1642},
  {1642, 1644, 1643},
  {1644, 1645, 1643},
  {1644, 1646, 1645},
  {1646, 1647, 1645},
  {1646, 1648, 1647},
  {1649, 1647, 1648},
  {1648, 1650, 1649},
  {1651, 1649, 1650},
  {1650, 1652, 1651},
  {1652, 1653, 1651},
  {1652, 1654, 1653},
  {1654, 1655, 1653},
  {1654, 1656, 1655},
  {1657, 1655, 1656},
  {1656, 1658, 1657},
  {1659, 1657, 1658},
  {1658, 1660, 1659},
  {1660, 1661, 1659},
  {1660, 1662, 1661},
  {1662, 1663, 1661},
  {1662, 1632, 1663},
  {1634, 1663, 1632},
  {1664, 1665, 1666},
  {1667, 1666, 1665},
  {1665, 1668, 1667},
  {1667, 1668, 1669},
  {1668, 1670, 1669},
  {1669, 1670, 1671},
  {1670, 1672, 1671},
  {1673, 1671, 1672},
  {1672, 1674, 1673},
  {1675, 1673, 1674},
  {1674, 1676, 1675},
  {1675, 1676, 1677},
  {1676, 1678, 1677},
  {1677, 1678, 1679},
  {1678, 1680, 1679},
  {1681, 1679, 1680},
  {1680, 1682, 1681},
  {1683, 1681, 1682},
  {1682, 1684, 1683},
  {1683, 1684, 1685},
  {1684, 1686, 1685},
  {1685, 1686, 1687},
  {1686, 1688, 1687},
  {1689, 1687, 1688},
  {1688, 1690, 1689},
  {1691, 1689, 1690},
  {1690, 1692, 1691},
  {1691, 1692, 1693},
  {1692, 1694, 1693},
  {1693, 1694, 1695},
  {1694, 1664, 1695},
  {1666, 1695, 1664},
  {1666, 1667, 1632},
  {1633, 1632, 1667},
  {1667, 1669, 1633},
  {1636, 1633, 1669},
  {1671, 1638, 1669},
  {1636, 1669, 1638},
  {1673, 1640, 1671},
  {1638, 1671, 1640},
  {1673, 1675, 1640},
  {1642, 1640, 1675},
  {1675, 1677, 1642},
  {1644, 1642, 1677},
  {1679, 1646, 1677},
  {1644, 1677, 1646},
  {1681, 1648, 1679},
  {1646, 1679, 1648},
  {1681, 1683, 1648},
  {1650, 1648, 1683},
  {1683, 1685, 1650},
  {1652, 1650, 1685},
  {1687, 1654, 1685},
  {1652, 1685, 1654},
  {1689, 1656, 1687},
  {1654, 1687, 1656},
  {1689, 1691, 1656},
  {1658, 1656, 1691},
  {1691, 1693, 1658},
  {1660, 1658, 1693},
  {1695, 1662, 1693},
  {1660, 1693, 1662},
  {1666, 1632, 1695},
  {1662, 1695, 1632},
  {1664, 1634, 1665},
  {1635, 1665, 1634},
  {1665, 1635, 1668},
  {1637, 1668, 1635},
  {1670, 1668, 1639},
  {1637, 1639, 1668},
  {1672, 1670, 1641},
  {1639, 1641, 1670},
  {1672, 1641, 1674},
  {1643, 1674, 1641},
  {1674, 1643, 1676},
  {1645, 1676, 1643},
  {1678, 1676, 1647},
  {1645, 1647, 1676},
  {1680, 1678, 1649},
  {1647, 1649, 1678},
  {1680, 1649, 1682},
  {1651, 1682, 1649},
  {1682, 1651, 1684},
  {1653, 1684, 1651},
  {1686, 1684, 1655},
  {1653, 1655, 1684},
  {1688, 1686, 1657},
  {1655, 1657, 1686},
  {1688, 1657, 1690},
  {1659, 1690, 1657},
  {1690, 1659, 1692},
  {1661, 1692, 1659},
  {1694, 1692, 1663},
  {1661, 1663, 1692},
  {1664, 1694, 1634},
  {1663, 1634, 1694},
};

SVV_NAMESPACE_BEGIN

svvModel motor( "motor",
                motor_vertices, motor_nvertices,
                motor_indices, motor_nindices );

SVV_NAMESPACE_END

#endif /* SVV_MOTOR_H_ */
/*
 * End of: $Id: motor.h,v 1.1.1.1 2006/12/19 22:58:58 christianh Exp $.
 * 
 */
