/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: pialsurf.h,v 1.1.1.1 2006/12/19 22:59:09 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_PIALSURF_H_
#  define SVV_PIALSURF_H_
#  include "svvModel.h"

static GLsizei pialsurf_nvertices = 7751;
static GLsizei pialsurf_nindices  = 11831;
static GLsizei pialsurf_nedges    = 47324;

static GLfloat pialsurf_vertices[][6] =
{
  {-5.864321e-01, -7.231472e-01, -3.649046e-01,  1.891814e-01, -1.348383e+00, -4.508733e-01},
  {-7.127433e-01, -5.900723e-01, -3.792251e-01,  1.964028e-01, -1.338918e+00, -5.050918e-01},
  {-3.392697e-01, -5.876193e-01, -7.345746e-01,  2.103665e-01, -1.344521e+00, -5.125222e-01},
  { 1.971196e-01, -9.797383e-01, -3.545043e-02,  2.437008e-01, -1.347664e+00, -4.867486e-01},
  {-4.947306e-01, -8.681942e-01, -3.847789e-02,  1.550932e-01, -1.333068e+00, -3.588656e-01},
  {-1.157452e-01, -9.847967e-01,  1.295316e-01,  1.005689e-01, -1.334064e+00, -3.883983e-01},
  { 2.906686e-01, -9.426262e-01,  1.642178e-01,  2.100452e-01, -1.332020e+00, -3.019553e-01},
  {-7.512764e-01, -3.789805e-01, -5.403309e-01,  1.379070e-01, -1.316757e+00, -3.469305e-01},
  {-9.131126e-01,  2.039922e-01, -3.530051e-01,  1.635626e-01, -1.313678e+00, -4.058226e-01},
  {-1.807766e-01, -7.803645e-01,  5.986244e-01,  5.097612e-02, -1.307474e+00, -3.442536e-01},
  { 5.329459e-01, -3.867827e-01,  7.525741e-01,  1.263984e-01, -1.311743e+00, -3.520435e-01},
  { 8.052942e-01, -5.209939e-01, -2.829604e-01,  3.116428e-01, -1.304266e+00, -4.791171e-01},
  {-8.677657e-02, -5.486676e-01, -8.315248e-01,  2.797481e-01, -1.309826e+00, -5.444927e-01},
  { 1.600380e-01, -4.879190e-01, -8.580926e-01,  2.121384e-01, -1.303642e+00, -6.055158e-01},
  {-2.300198e-01, -8.875791e-01,  3.991167e-01,  1.325681e-01, -1.308602e+00, -1.906367e-01},
  {-3.632767e-01, -9.301242e-01,  5.384231e-02,  1.061358e-01, -1.305396e+00, -2.223980e-01},
  { 3.633471e-01, -8.854414e-01,  2.897803e-01,  2.104179e-01, -1.300194e+00, -2.415600e-01},
  { 4.557705e-01, -8.883445e-01, -5.583522e-02,  3.298537e-01, -1.304827e+00, -3.649804e-01},
  { 3.124432e-02,  3.074129e-02,  9.990389e-01,  6.941237e-02, -1.287961e+00, -3.395420e-01},
  { 6.143970e-01, -3.046400e-01, -7.278122e-01,  2.924603e-01, -1.283660e+00, -5.613525e-01},
  {-3.698760e-01, -7.988141e-01, -4.744343e-01,  1.278058e-01, -1.317356e+00, -5.739027e-01},
  {-4.389548e-01, -8.723345e-01, -2.152930e-01,  3.848452e-02, -1.309048e+00, -5.153540e-01},
  {-2.156450e-01, -4.826386e-01, -8.488564e-01,  1.431601e-01, -1.306235e+00, -5.958365e-01},
  {-7.053073e-01, -7.023523e-01,  9.613930e-02,  3.382641e-02, -1.282696e+00, -1.827594e-01},
  { 4.557531e-02, -6.828142e-01,  7.291691e-01,  2.634232e-01, -1.286734e+00, -1.456038e-01},
  {-5.770988e-01, -7.898958e-01,  2.074162e-01,  2.337958e-01, -1.289676e+00, -1.573875e-01},
  { 5.409542e-01, -6.294174e-01,  5.578552e-01,  1.672806e-01, -1.300426e+00, -1.733017e-01},
  { 8.533281e-02, -9.760537e-01,  2.000940e-01,  2.950852e-01, -1.300694e+00, -2.111464e-01},
  {-8.240922e-01,  5.445384e-01, -1.560448e-01,  5.144002e-02, -1.283033e+00, -2.769534e-01},
  { 7.414851e-01, -6.708731e-01, -1.135842e-02,  3.487245e-01, -1.298869e+00, -3.374164e-01},
  { 3.394478e-01,  2.587062e-01,  9.043486e-01,  1.460106e-02, -1.254787e+00, -3.165764e-01},
  { 4.769338e-01,  3.016647e-01,  8.255498e-01,  4.163672e-02, -1.258454e+00, -3.311031e-01},
  { 1.696451e-01,  2.581711e-01, -9.510880e-01,  3.170760e-01, -1.236844e+00, -5.379496e-01},
  { 2.990664e-01,  9.248024e-01,  2.351593e-01,  2.025852e-01, -1.275977e+00, -4.648384e-01},
  {-2.551610e-01,  4.281642e-01, -8.669304e-01,  2.928416e-01, -1.255584e+00, -5.554276e-01},
  {-5.647243e-01, -8.248728e-01, -2.590869e-02, -2.666540e-02, -1.270961e+00, -5.267736e-01},
  {-2.009398e-01,  4.914636e-01, -8.474000e-01,  1.409106e-01, -1.268104e+00, -6.028432e-01},
  {-9.352536e-02,  3.926117e-01, -9.149367e-01,  1.688345e-01, -1.257834e+00, -5.981171e-01},
  { 3.860655e-01,  2.799294e-01, -8.789726e-01,  2.106062e-01, -1.269670e+00, -6.110253e-01},
  { 3.573592e-01, -6.154172e-01,  7.025354e-01,  1.386208e-01, -1.266326e+00, -3.447703e-02},
  {-2.564408e-01, -6.804997e-01,  6.864096e-01,  9.456504e-02, -1.255629e+00, -2.797246e-02},
  { 1.314843e-01, -9.911627e-01,  1.755456e-02,  1.234900e-01, -1.279141e+00, -6.879330e-02},
  {-4.541093e-01, -8.496583e-01,  2.680776e-01,  4.055422e-02, -1.258321e+00, -7.952708e-02},
  {-9.125811e-01, -4.063812e-01,  4.527726e-02,  2.491229e-02, -1.263437e+00, -1.232491e-01},
  {-7.865322e-01, -1.134506e-01, -6.070387e-01,  4.993915e-02, -1.246754e+00, -3.011379e-01},
  {-5.679178e-01, -1.891532e-01, -8.010559e-01,  9.014714e-02, -1.244080e+00, -3.283075e-01},
  { 1.402881e-01,  1.744812e-01,  9.746156e-01, -6.036671e-02, -1.251951e+00, -3.057315e-01},
  {-4.620283e-01, -8.150403e-01,  3.496272e-01, -1.093014e-01, -1.252194e+00, -3.254417e-01},
  { 3.636062e-01,  2.294921e-01,  9.028421e-01, -1.666749e-02, -1.230719e+00, -3.141248e-01},
  {-7.164440e-01,  1.349792e-01, -6.844623e-01,  1.898167e-01, -1.258442e+00, -4.338013e-01},
  { 2.713592e-01, -4.200021e-01,  8.660038e-01,  1.590306e-01, -1.246199e+00, -4.162265e-01},
  { 6.351947e-01,  5.754828e-01,  5.151188e-01,  5.239341e-02, -1.223884e+00, -4.017548e-01},
  {-4.200900e-01,  3.102788e-02, -9.069519e-01,  7.858101e-02, -1.256719e+00, -5.681350e-01},
  {-1.514785e-01, -2.779046e-01, -9.485901e-01, -9.934259e-03, -1.268257e+00, -5.807797e-01},
  { 1.411838e-01, -9.248789e-01,  3.530809e-01,  2.288111e-01, -1.244317e+00, -3.962761e-03},
  { 4.266542e-01, -8.997045e-01,  9.218439e-02,  2.411840e-01, -1.237380e+00, -8.486958e-03},
  { 7.686386e-02, -8.964621e-01,  4.364031e-01,  1.898127e-01, -1.251730e+00, -3.686870e-02},
  { 2.792738e-01, -9.292873e-01,  2.417256e-01,  1.414665e-01, -1.269850e+00, -4.974255e-02},
  {-2.259894e-01, -3.853390e-01,  8.946747e-01,  2.635896e-01, -1.228685e+00, -1.129161e-01},
  {-7.741829e-01, -3.915561e-01,  4.973174e-01,  2.189031e-01, -1.242573e+00, -1.446024e-01},
  { 9.490136e-01, -2.314393e-01,  2.140303e-01,  3.714451e-01, -1.221406e+00, -2.376908e-01},
  {-8.843206e-01,  9.455996e-02, -4.572041e-01,  4.882859e-02, -1.232185e+00, -2.951966e-01},
  { 9.230158e-01, -5.101371e-03,  3.847284e-01,  2.330771e-01, -1.245637e+00, -2.767272e-01},
  {-3.214481e-01,  4.636202e-03,  9.469158e-01, -1.015870e-01, -1.234136e+00, -3.088219e-01},
  {-7.012993e-01,  1.555236e-01, -6.956951e-01,  1.966233e-01, -1.245102e+00, -3.944584e-01},
  { 7.610909e-01,  2.815080e-01, -5.843747e-01,  3.407391e-01, -1.215138e+00, -5.155784e-01},
  { 9.653659e-01,  2.476197e-01, -8.217840e-02,  2.547389e-01, -1.237638e+00, -5.096648e-01},
  {-4.713183e-01, -8.406959e-01, -2.666262e-01,  2.194133e-01, -1.215621e+00, -4.727843e-01},
  {-9.507893e-01, -3.028803e-01,  6.529410e-02, -4.502688e-02, -1.233609e+00, -5.100387e-01},
  { 1.372548e-01,  4.511933e-02, -9.895076e-01,  1.550725e-02, -1.262907e+00, -5.691540e-01},
  {-8.616360e-01, -8.211230e-02, -5.008403e-01, -3.941203e-02, -1.237898e+00, -5.651594e-01},
  { 7.019012e-02, -9.894277e-01, -1.269100e-01, -8.709449e-02, -1.249630e+00, -5.243223e-01},
  {-3.987195e-02, -9.926441e-01, -1.143152e-01,  7.723781e-02, -1.277548e+00, -6.308472e-01},
  { 4.923758e-01, -8.114924e-01, -3.147159e-01,  2.081941e-01, -1.223063e+00, -1.197959e-01},
  { 4.758317e-01, -8.474156e-01,  2.355230e-01,  1.644715e-01, -1.248258e+00, -1.250653e-01},
  {-9.387286e-01, -1.348398e-01, -3.171858e-01,  4.788131e-02, -1.209341e+00, -1.917181e-01},
  {-2.841128e-02, -9.949507e-01,  9.625873e-02, -6.393155e-02, -1.247355e+00, -2.122858e-01},
  { 9.777454e-01, -1.807839e-02,  2.090148e-01,  3.910041e-01, -1.187747e+00, -2.690859e-01},
  { 5.751726e-01, -8.088417e-01,  1.222766e-01,  3.926982e-01, -1.162293e+00, -3.212493e-01},
  { 6.034918e-01,  7.857479e-01, -1.356388e-01,  2.867833e-01, -1.165758e+00, -3.303632e-01},
  { 7.638068e-01,  5.468996e-01, -3.427827e-01,  3.795855e-01, -1.185648e+00, -3.821673e-01},
  {-3.156047e-01, -6.181126e-01,  7.199517e-01,  1.795845e-01, -1.205099e+00, -3.823556e-01},
  { 9.559558e-01, -1.637618e-01, -2.435784e-01,  3.663062e-01, -1.207492e+00, -4.423128e-01},
  {-6.529590e-01, -5.800024e-01,  4.870748e-01, -1.876598e-01, -1.194617e+00, -3.782527e-01},
  { 3.398560e-02,  4.458362e-01, -8.944691e-01,  2.738896e-01, -1.173433e+00, -5.118425e-01},
  {-4.843623e-01, -8.664973e-01,  1.207291e-01, -1.542065e-01, -1.228438e+00, -4.448515e-01},
  { 1.134488e-01,  7.542462e-01, -6.467162e-01,  1.627911e-01, -1.208954e+00, -4.652986e-01},
  { 2.829202e-01, -9.491357e-01,  1.381942e-01, -8.694524e-02, -1.247891e+00, -4.610840e-01},
  { 2.920437e-01,  5.519950e-01, -7.810326e-01,  3.941502e-03, -1.258480e+00, -5.674006e-01},
  {-2.042855e-01,  9.699012e-02, -9.740946e-01, -1.775244e-02, -1.247054e+00, -5.789592e-01},
  { 5.957159e-01, -7.996525e-01, -7.535625e-02, -5.074761e-02, -1.228660e+00, -5.718267e-01},
  {-6.303757e-01, -6.914254e-01, -3.529268e-01, -1.280876e-01, -1.224847e+00, -5.553301e-01},
  { 5.685748e-01, -8.225278e-01,  1.306389e-02,  1.573375e-01, -1.257571e+00, -6.810259e-01},
  { 9.398168e-02,  1.440099e-01, -9.851033e-01,  1.154614e-01, -1.250067e+00, -7.229298e-01},
  { 6.852499e-01, -5.715753e-01,  4.513694e-01,  3.100072e-01, -1.200531e+00,  1.469005e-02},
  { 7.643819e-01, -5.486439e-01, -3.386887e-01,  3.184593e-01, -1.198391e+00, -2.310119e-02},
  { 5.708811e-01, -7.104874e-01, -4.114636e-01,  2.933134e-01, -1.206182e+00, -5.188445e-02},
  {-4.482599e-01,  2.459381e-01,  8.594053e-01,  2.812510e-02, -1.177053e+00, -6.026099e-02},
  { 7.400979e-01, -6.100488e-01,  2.830115e-01,  3.537310e-01, -1.206085e+00, -1.099000e-01},
  { 7.846808e-01, -6.049803e-01,  1.351838e-01,  3.660986e-01, -1.200183e+00, -1.349600e-01},
  {-2.862213e-01, -9.579045e-01,  2.227945e-02,  1.612537e-03, -1.208816e+00, -1.411274e-01},
  { 8.768133e-01, -4.244741e-01,  2.258762e-01,  3.606553e-01, -1.207887e+00, -1.439113e-01},
  {-7.691262e-01, -4.561772e-01,  4.476016e-01, -1.061076e-01, -1.214756e+00, -1.842005e-01},
  { 9.591783e-01, -1.204202e-02,  2.825458e-01,  3.409380e-01, -1.183888e+00, -2.206209e-01},
  { 2.554814e-01, -8.117963e-01, -5.250868e-01, -2.556394e-02, -1.228247e+00, -2.692519e-01},
  {-7.020292e-01, -2.957406e-01,  6.478367e-01, -1.653089e-01, -1.192877e+00, -3.484827e-01},
  {-8.861728e-01, -2.410539e-01,  3.957157e-01, -2.144124e-01, -1.162295e+00, -3.962863e-01},
  { 7.374867e-01,  2.102183e-01,  6.418113e-01,  5.895132e-02, -1.171948e+00, -4.202662e-01},
  {-7.928019e-01, -1.418953e-01, -5.927318e-01, -1.908289e-01, -1.173967e+00, -4.892907e-01},
  { 6.927691e-01, -3.423083e-01, -6.347410e-01,  3.343648e-02, -1.237410e+00, -5.465720e-01},
  { 6.927691e-01, -3.423083e-01, -6.347410e-01, -5.777559e-03, -1.258877e+00, -5.777941e-01},
  {-7.950185e-01,  2.985455e-01, -5.280305e-01, -1.913287e-02, -1.207826e+00, -5.730307e-01},
  {-2.469398e-02, -9.803373e-01,  1.957778e-01,  1.692269e-02, -1.264091e+00, -5.771976e-01},
  {-7.850137e-01, -5.444524e-01, -2.955082e-01, -2.199672e-02, -1.242645e+00, -5.961528e-01},
  {-8.278589e-01, -3.179085e-01, -4.621512e-01, -8.275152e-03, -1.249862e+00, -6.112497e-01},
  { 2.808696e-01, -9.018141e-01, -3.283956e-01, -3.795435e-02, -1.214302e+00, -6.380790e-01},
  {-5.518151e-01,  5.141497e-01, -6.566202e-01,  1.013518e-01, -1.242351e+00, -6.843586e-01},
  {-5.518151e-01,  5.141497e-01, -6.566202e-01,  1.321899e-01, -1.226278e+00, -7.254038e-01},
  {-5.518151e-01,  5.141497e-01, -6.566202e-01,  1.317431e-01, -1.212570e+00, -7.134638e-01},
  {-5.036887e-01, -7.016137e-01, -5.040197e-01, -7.329252e-02, -1.197502e+00, -6.633163e-01},
  { 6.679839e-01, -5.903566e-01, -4.530746e-01,  1.490895e-01, -1.183196e+00, -1.827532e-01},
  { 5.174960e-01, -8.414784e-01, -1.552803e-01,  1.463475e-01, -1.180973e+00, -2.039380e-01},
  { 3.386646e-01, -3.347082e-01, -8.793615e-01,  4.285524e-02, -1.166409e+00, -2.390618e-01},
  { 7.902323e-01,  6.109931e-01,  4.712032e-02,  2.575394e-01, -1.147233e+00, -2.740115e-01},
  { 4.211545e-01,  8.878929e-01, -1.851355e-01,  1.239918e-01, -1.157209e+00, -3.113587e-01},
  {-7.268342e-01, -6.603870e-01,  1.886822e-01, -1.174541e-01, -1.202497e+00, -2.861017e-01},
  { 5.602296e-01, -8.215700e-01, -1.056672e-01,  1.959562e-02, -1.189143e+00, -3.271285e-01},
  {-4.890247e-01, -2.735175e-01,  8.282771e-01,  8.267362e-02, -1.155223e+00, -3.426327e-01},
  { 5.659794e-01,  7.802502e-01, -2.662272e-01,  2.898004e-01, -1.142548e+00, -4.571729e-01},
  {-2.646191e-01,  2.074481e-02,  9.641299e-01, -1.879202e-01, -1.167549e+00, -3.690785e-01},
  {-4.847051e-03,  3.348540e-01, -9.422576e-01,  2.419846e-01, -1.138893e+00, -4.976420e-01},
  {-9.110910e-01, -1.718057e-01, -3.746946e-01, -2.201243e-01, -1.141956e+00, -4.495717e-01},
  {-5.513517e-01, -8.246337e-01,  1.264540e-01,  1.237528e-01, -1.164730e+00, -4.641462e-01},
  {-7.709480e-01,  5.546620e-01,  3.130322e-01, -2.672584e-02, -1.197629e+00, -4.891052e-01},
  { 9.085417e-01,  1.009335e-01, -4.054186e-01,  6.943064e-02, -1.185095e+00, -5.153624e-01},
  { 9.285375e-01, -3.568848e-01, -1.022317e-01, -3.245993e-02, -1.168144e+00, -5.416963e-01},
  { 4.065073e-01, -7.366981e-01,  5.403960e-01,  9.510934e-02, -1.191004e+00, -5.583805e-01},
  {-7.855635e-01, -2.790449e-01, -5.522896e-01, -7.051527e-03, -1.238768e+00, -6.214686e-01},
  {-5.242372e-01, -6.145445e-01, -5.895003e-01, -1.663311e-01, -1.174309e+00, -5.918684e-01},
  { 4.801542e-01, -1.626941e-01,  8.619644e-01,  1.130085e-01, -1.181517e+00, -6.751871e-01},
  {-3.552465e-01,  2.677514e-01, -8.956055e-01,  1.271308e-01, -1.204165e+00, -6.831678e-01},
  { 2.510570e-01, -5.625333e-01,  7.877352e-01,  1.019201e-01, -1.228122e+00, -6.826572e-01},
  {-4.502518e-01, -6.197625e-01, -6.427813e-01,  7.187261e-02, -1.256045e+00, -6.818997e-01},
  { 2.683379e-02, -7.298402e-01, -6.830910e-01,  2.510790e-01, -1.221727e+00, -6.486363e-01},
  {-2.458170e-01, -7.519600e-01, -6.116618e-01, -4.768046e-02, -1.178433e+00, -7.060081e-01},
  { 6.959225e-01, -5.806811e-01, -4.224942e-01,  2.426710e-01, -1.149416e+00, -1.503140e-01},
  {-8.126638e-01,  2.605446e-01,  5.212428e-01, -6.785311e-02, -1.148965e+00, -1.306693e-01},
  { 5.174960e-01, -8.414784e-01, -1.552803e-01,  1.801021e-01, -1.163926e+00, -1.838250e-01},
  { 7.705884e-01,  5.930910e-01, -2.333165e-01,  3.970478e-01, -1.143490e+00, -2.173263e-01},
  { 8.037367e-01, -3.699381e-01, -4.659968e-01,  1.116231e-02, -1.180339e+00, -2.459657e-01},
  { 6.346828e-01,  6.542578e-01, -4.112474e-01,  3.753362e-01, -1.134100e+00, -2.651666e-01},
  {-4.842097e-01,  1.885661e-01, -8.543909e-01,  6.154438e-02, -1.120646e+00, -2.780673e-01},
  { 8.125186e-02, -8.026069e-01, -5.909486e-01,  2.345752e-02, -1.175283e+00, -3.465289e-01},
  { 3.021586e-01,  3.844913e-01,  8.722767e-01, -1.285457e-01, -1.129897e+00, -3.831679e-01},
  { 3.231401e-01,  4.976601e-01, -8.049317e-01,  2.314271e-01, -1.121605e+00, -4.922778e-01},
  { 6.700873e-01, -7.255009e-01,  1.569437e-01,  1.035399e-01, -1.144277e+00, -4.945177e-01},
  { 8.772163e-01, -1.493876e-01, -4.562618e-01, -1.462911e-02, -1.163756e+00, -5.088514e-01},
  {-5.619985e-01,  5.715436e-01,  5.979093e-01, -1.232620e-01, -1.143093e+00, -5.023297e-01},
  { 9.438277e-01, -3.295808e-01,  2.378502e-02, -2.445294e-02, -1.152032e+00, -5.207115e-01},
  {-7.517653e-02, -9.644361e-01, -2.533997e-01,  2.368281e-01, -1.237449e+00, -6.263810e-01},
  { 3.500119e-01, -9.108432e-01,  2.187608e-01,  1.914416e-03, -1.174365e+00, -6.384491e-01},
  { 9.636117e-01,  6.685479e-02,  2.588109e-01,  1.087400e-01, -1.173848e+00, -6.668094e-01},
  { 6.934374e-01, -3.154420e-01, -6.477970e-01,  1.162032e-01, -1.190353e+00, -7.334319e-01},
  {-5.249623e-01, -5.887870e-01, -6.146092e-01,  5.774886e-03, -1.175861e+00, -7.537060e-01},
  { 4.691592e-01, -1.467119e-01, -8.708417e-01,  9.297755e-02, -1.175865e+00, -7.656490e-01},
  { 1.196747e-01, -4.316009e-01, -8.940910e-01,  4.942148e-02, -1.158368e+00, -7.742533e-01},
  { 7.204268e-01, -2.197356e-01,  6.578006e-01,  3.388664e-01, -1.124761e+00,  3.877188e-02},
  {-1.723536e-01, -9.825290e-01,  7.022088e-02,  1.768181e-01, -1.169530e+00,  3.239300e-02},
  {-1.969805e-02, -6.198534e-01,  7.844703e-01,  2.810005e-01, -1.165728e+00,  6.352716e-02},
  {-1.854585e-01, -9.826422e-01,  4.421161e-03,  1.688409e-01, -1.166124e+00,  1.450544e-02},
  {-2.137946e-01, -9.445201e-01, -2.493461e-01, -3.754062e-02, -1.182991e+00,  1.007092e-02},
  {-6.971890e-01,  5.747899e-01,  4.284202e-01,  2.533605e-01, -1.140797e+00, -2.689631e-02},
  { 2.927098e-01, -9.458225e-01,  1.405017e-01,  2.389773e-01, -1.151324e+00, -1.554587e-01},
  { 9.596481e-01, -2.795666e-01, -3.029992e-02,  3.677001e-01, -1.142368e+00, -1.478274e-01},
  { 4.810299e-01, -7.720560e-01, -4.153791e-01,  4.083552e-01, -1.131999e+00, -2.418288e-01},
  { 6.902557e-01, -1.585191e-01, -7.059878e-01,  2.059109e-02, -1.144493e+00, -2.447956e-01},
  { 2.889887e-01, -4.688862e-01, -8.346444e-01,  4.270202e-02, -1.159446e+00, -3.623421e-01},
  {-9.138633e-01,  2.532208e-01,  3.173850e-01, -2.319175e-01, -1.122442e+00, -4.194251e-01},
  {-9.475902e-01,  7.458569e-02,  3.106602e-01,  8.220671e-02, -1.135987e+00, -4.061945e-01},
  {-5.995301e-01,  4.176806e-01, -6.827200e-01,  3.705227e-02, -1.113196e+00, -4.235563e-01},
  {-3.448418e-01,  4.700614e-01, -8.124816e-01, -1.257853e-01, -1.125516e+00, -4.656090e-01},
  { 0.000000e+00,  8.320503e-01,  5.547002e-01,  1.165211e-01, -1.144304e+00, -5.309944e-01},
  {-1.259204e-01, -9.918337e-01,  2.024723e-02,  1.657990e-01, -1.227358e+00, -5.629068e-01},
  {-2.901043e-01, -8.851569e-01,  3.637812e-01,  1.233333e-01, -1.163307e+00, -5.363434e-01},
  {-7.185367e-01, -6.952106e-01,  1.968047e-02, -2.583183e-03, -1.136790e+00, -5.730994e-01},
  {-2.392651e-01, -9.683664e-01, -7.084300e-02,  1.927904e-01, -1.222705e+00, -5.875961e-01},
  { 7.897909e-02,  9.277468e-01, -3.647577e-01,  7.189081e-02, -1.095087e+00, -5.866473e-01},
  {-4.155827e-01, -9.092310e-01,  2.428831e-02,  1.556382e-01, -1.201873e+00, -5.873080e-01},
  {-9.729570e-01, -9.323703e-02, -2.113331e-01,  2.253439e-02, -1.163716e+00, -6.072129e-01},
  {-6.416306e-01, -2.182812e-01, -7.352982e-01, -1.056884e-02, -1.124587e+00, -7.792430e-01},
  { 7.565759e-01, -5.422989e-02,  6.516534e-01,  3.224663e-01, -1.126772e+00,  5.507152e-02},
  {-3.955163e-01,  2.720820e-02,  9.180559e-01,  2.082052e-01, -1.134146e+00,  7.235323e-02},
  {-4.012090e-01, -6.574518e-01,  6.377997e-01,  2.553011e-01, -1.159483e+00,  2.760502e-02},
  { 8.743350e-02, -9.867818e-01, -1.364440e-01,  6.255499e-02, -1.167823e+00,  1.637582e-03},
  {-2.949580e-01, -8.384078e-01, -4.583364e-01,  2.500510e-01, -1.137936e+00, -3.394738e-03},
  { 8.527867e-01, -4.583878e-01, -2.502710e-01,  3.417629e-01, -1.128064e+00, -3.718959e-02},
  {-5.654728e-01, -7.812803e-01,  2.642755e-01,  2.292329e-01, -1.118688e+00, -5.072438e-02},
  {-9.388915e-01, -1.135815e-01,  3.249337e-01,  1.933261e-01, -1.095190e+00, -1.088894e-01},
  { 7.731875e-01, -6.276962e-01,  9.043603e-02,  2.602541e-01, -1.127596e+00, -1.491944e-01},
  {-4.159324e-01,  6.537181e-01,  6.321811e-01,  1.576716e-01, -1.085071e+00, -1.492687e-01},
  { 8.599612e-01, -4.962758e-01, -1.190678e-01,  1.849614e-02, -1.139966e+00, -2.586665e-01},
  { 4.987249e-01, -8.468922e-01,  1.845182e-01,  4.078580e-02, -1.120883e+00, -2.717805e-01},
  {-6.952122e-01, -4.217461e-01,  5.820741e-01, -2.016159e-01, -1.156479e+00, -2.946803e-01},
  {-6.952122e-01, -4.217461e-01,  5.820741e-01,  1.013712e-01, -1.104025e+00, -3.122233e-01},
  {-6.333444e-01, -4.631017e-01,  6.200095e-01,  1.031697e-01, -1.107194e+00, -3.136066e-01},
  { 7.349983e-01, -6.778188e-01,  1.841437e-02,  7.543351e-02, -1.144412e+00, -3.404321e-01},
  { 9.400247e-01,  2.489848e-01, -2.331524e-01,  2.320299e-01, -1.101472e+00, -3.823860e-01},
  { 7.920092e-01, -6.092038e-01,  3.990188e-02,  2.193461e-01, -1.088313e+00, -4.074716e-01},
  {-2.975422e-01,  3.869663e-01,  8.727690e-01, -1.522706e-01, -1.090389e+00, -3.912840e-01},
  {-6.034489e-01, -5.339187e-01,  5.922669e-01,  7.361662e-02, -1.126086e+00, -4.147632e-01},
  {-4.286556e-02, -3.978168e-01,  9.164630e-01, -2.084086e-02, -1.091029e+00, -4.266134e-01},
  { 6.130809e-01, -7.343198e-01,  2.913867e-01,  2.111289e-01, -1.191005e+00, -5.357541e-01},
  {-5.612170e-01, -6.059443e-01,  5.637970e-01, -2.098071e-01, -1.139612e+00, -5.100719e-01},
  { 6.763571e-01,  6.713304e-03, -7.365434e-01,  3.459818e-01, -1.122396e+00, -6.148836e-01},
  { 8.733031e-01,  2.206479e-01,  4.343458e-01,  3.495455e-01, -1.143616e+00, -6.000303e-01},
  {-2.889601e-01,  4.655323e-01,  8.365296e-01,  3.522108e-01, -1.147003e+00, -5.969453e-01},
  {-9.270694e-02, -4.809166e-01, -8.718513e-01,  3.474524e-01, -1.113246e+00, -6.197090e-01},
  {-8.554370e-01, -2.708974e-01, -4.414091e-01, -1.956637e-01, -1.149179e+00, -5.818000e-01},
  { 8.393672e-01,  5.410773e-01, -5.194096e-02,  3.277420e-01, -1.092209e+00, -6.293173e-01},
  { 9.229152e-01, -3.799548e-01,  6.214494e-02,  1.850868e-01, -1.182072e+00, -6.315288e-01},
  { 3.287948e-01, -4.499002e-01, -8.303516e-01,  1.756356e-01, -1.170056e+00, -6.919126e-01},
  {-4.591088e-01, -8.629145e-01,  2.111815e-01,  2.838701e-01, -1.101967e+00, -7.023076e-01},
  {-8.371350e-01,  4.799448e-01,  2.624081e-01,  9.728993e-02, -1.093837e+00, -7.264647e-01},
  {-7.440109e-01,  1.933892e-01, -6.395689e-01, -9.164936e-03, -1.103272e+00, -7.777165e-01},
  { 9.298959e-02, -4.229318e-02, -9.947684e-01,  2.769992e-02, -1.125733e+00, -7.851631e-01},
  { 3.822999e-01, -9.225317e-01,  5.274567e-02,  2.080113e-01, -1.132960e+00,  1.993319e-01},
  { 1.641861e-03, -9.951271e-01,  9.858723e-02,  1.490903e-01, -1.156533e+00,  1.887910e-01},
  { 3.252412e-01, -8.908654e-01, -3.171386e-01,  6.049257e-02, -1.151190e+00,  1.120305e-01},
  {-1.720431e-03, -7.693675e-01, -6.388041e-01, -2.053276e-03, -1.161081e+00,  8.790132e-02},
  { 7.095751e-02,  6.613202e-01,  7.467400e-01,  2.546296e-01, -1.103103e+00,  6.060676e-02},
  { 9.228666e-01, -2.035835e-01,  3.269111e-01,  3.670134e-01, -1.091938e+00,  1.855151e-02},
  { 2.523209e-01,  2.828365e-01,  9.253851e-01,  1.020974e-02, -1.147079e+00,  6.665791e-02},
  {-4.258664e-01, -8.053179e-01,  4.124327e-01, -4.418455e-02, -1.165342e+00,  5.557270e-02},
  { 3.847844e-01, -7.144433e-01,  5.843899e-01, -1.174634e-01, -1.139765e+00, -8.177817e-02},
  { 4.208338e-01, -2.024378e-01,  8.842612e-01,  4.102120e-01, -1.116716e+00, -8.643410e-02},
  { 3.381747e-01, -9.403003e-01,  3.838186e-02, -1.265054e-01, -1.156547e+00, -1.167024e-01},
  { 3.381747e-01, -9.403003e-01,  3.838186e-02,  3.493709e-01, -1.113501e+00, -1.590143e-01},
  { 9.661563e-01,  2.548983e-01, -3.960702e-02,  3.470299e-01, -1.108949e+00, -1.636606e-01},
  { 2.437790e-02, -9.985107e-01, -4.880867e-02, -1.693102e-01, -1.163263e+00, -1.586548e-01},
  { 1.105906e-01, -9.050930e-01, -4.105806e-01, -1.784417e-01, -1.156956e+00, -2.015049e-01},
  { 7.881856e-01, -3.525741e-02,  6.144269e-01,  4.100516e-01, -1.094152e+00, -1.982318e-01},
  {-1.763776e-01, -8.925787e-01, -4.149630e-01, -1.992434e-01, -1.142117e+00, -2.297992e-01},
  { 8.979716e-01, -2.954672e-01,  3.261077e-01,  8.260734e-02, -1.098857e+00, -3.189117e-01},
  {-4.882641e-01,  9.223250e-02,  8.678083e-01, -1.992283e-01, -1.134184e+00, -2.928003e-01},
  {-9.155739e-01, -3.974980e-01,  6.099027e-02, -2.349774e-01, -1.118552e+00, -3.550349e-01},
  {-3.107200e-01, -3.485408e-01, -8.842920e-01, -4.966445e-02, -1.102318e+00, -3.696325e-01},
  { 1.051194e-01,  8.304086e-01, -5.471485e-01,  2.120776e-01, -1.106595e+00, -4.813935e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  2.044386e-01, -1.120335e+00, -4.893051e-01},
  { 9.640239e-01, -2.645007e-01,  2.640495e-02,  2.029413e-01, -1.127693e+00, -4.963501e-01},
  { 6.397305e-01, -7.268557e-01,  2.498515e-01,  3.630883e-01, -1.163375e+00, -4.820919e-01},
  { 2.234260e-01, -5.280494e-01,  8.192952e-01,  2.261290e-01, -1.142178e+00, -5.355272e-01},
  {-2.702503e-01, -3.297743e-01, -9.045517e-01, -7.058870e-02, -1.080841e+00, -4.914223e-01},
  { 2.246091e-02,  2.923282e-01, -9.560542e-01,  8.194707e-02, -1.080992e+00, -5.505806e-01},
  { 8.631647e-01,  8.632009e-02, -4.974892e-01,  6.557845e-02, -1.071656e+00, -5.530987e-01},
  {-9.144405e-01, -2.020360e-01,  3.506850e-01, -2.229493e-01, -1.107149e+00, -5.005513e-01},
  {-1.312670e-01,  3.463681e-01,  9.288694e-01,  3.320477e-01, -1.108174e+00, -6.231686e-01},
  { 4.212954e-01, -4.130501e-01, -8.074031e-01,  3.355320e-01, -1.101668e+00, -6.228501e-01},
  { 2.279833e-01,  9.704764e-01,  7.873516e-02,  3.183894e-01, -1.099880e+00, -6.208017e-01},
  { 7.542480e-01,  1.959871e-01,  6.266571e-01,  2.882582e-01, -1.102438e+00, -6.030647e-01},
  {-4.625591e-01, -6.847829e-01, -5.631264e-01, -1.051458e-01, -1.118119e+00, -6.408297e-01},
  {-6.614697e-01, -4.620384e-01, -5.907438e-01, -8.091416e-02, -1.123108e+00, -6.748515e-01},
  {-5.211465e-01, -3.436304e-01, -7.812326e-01, -5.189421e-02, -1.113652e+00, -7.055086e-01},
  { 4.822842e-01,  4.939758e-01, -7.234569e-01,  1.964584e-01, -1.070719e+00, -7.795336e-01},
  {-1.539763e-01,  5.221281e-01, -8.388525e-01,  1.050633e-02, -1.091469e+00, -7.805136e-01},
  {-7.120115e-01, -5.860819e-01,  3.867141e-01,  1.162867e-01, -1.124012e+00,  2.458442e-01},
  {-6.225851e-01, -6.214973e-01, -4.755300e-01,  1.015829e-01, -1.132146e+00,  1.778916e-01},
  { 9.185360e-01, -3.021971e-01,  2.548892e-01,  2.446578e-01, -1.112551e+00,  1.662785e-01},
  { 8.378292e-01, -5.287654e-01, -1.358287e-01,  2.394108e-01, -1.121192e+00,  1.370790e-01},
  { 3.564664e-01, -8.932216e-01,  2.740202e-01,  8.512991e-02, -1.148478e+00,  1.437647e-01},
  {-2.139357e-01, -7.756180e-01,  5.938420e-01,  2.092648e-02, -1.143167e+00,  1.538019e-01},
  {-5.702273e-01, -5.117035e-01,  6.426511e-01, -4.743006e-02, -1.119191e+00,  1.470379e-01},
  { 4.170651e-01, -7.862521e-01, -4.559213e-01,  2.358160e-01, -1.117920e+00,  1.267461e-01},
  { 1.940600e-01, -8.483042e-01, -4.926670e-01,  2.037627e-01, -1.122138e+00,  1.091880e-01},
  {-9.443411e-01, -2.125677e-01,  2.510674e-01, -6.685989e-02, -1.124725e+00,  9.746548e-02},
  {-8.096792e-01, -3.950086e-01, -4.340365e-01, -6.738196e-02, -1.128323e+00,  9.507848e-02},
  { 3.051650e-01,  5.040151e-01,  8.079870e-01,  3.570915e-01, -1.061172e+00,  2.060652e-02},
  {-9.729874e-01, -1.913437e-01,  1.291628e-01, -6.711006e-02, -1.132218e+00,  2.470473e-02},
  {-1.125358e-01, -6.747788e-01,  7.293897e-01, -1.790496e-01, -1.150674e+00, -9.648938e-02},
  {-4.725444e-01, -8.002936e-01,  3.690960e-01, -2.061942e-01, -1.143384e+00, -1.007980e-01},
  { 8.317642e-01, -2.053156e-01, -5.157654e-01,  4.059678e-01, -1.087441e+00, -1.370301e-01},
  {-9.429036e-01,  2.201090e-01,  2.499695e-01,  1.623681e-01, -1.066736e+00, -1.476972e-01},
  { 9.326783e-01, -3.600572e-01, -2.167889e-02, -9.842731e-02, -1.135979e+00, -1.326995e-01},
  { 6.215617e-01, -6.476480e-01, -4.406962e-01, -1.233727e-01, -1.130245e+00, -1.833424e-01},
  { 6.868991e-01,  8.865813e-02,  7.213246e-01,  4.149134e-01, -1.070045e+00, -1.993886e-01},
  { 2.929172e-03,  2.095648e-01, -9.777904e-01,  2.528588e-01, -1.066625e+00, -2.323308e-01},
  { 9.013893e-01, -1.226273e-01, -4.152828e-01,  4.201762e-01, -1.088071e+00, -2.633540e-01},
  {-4.123827e-02, -3.109620e-01, -9.495273e-01,  3.597084e-01, -1.074512e+00, -2.658391e-01},
  {-2.254713e-01, -6.178092e-01, -7.533090e-01, -2.252186e-01, -1.123726e+00, -2.554363e-01},
  { 6.782938e-01,  7.332509e-01,  4.754720e-02,  1.871049e-01, -1.062238e+00, -2.717351e-01},
  { 7.702667e-01, -4.899842e-01,  4.081724e-01,  2.654912e-01, -1.080842e+00, -2.925349e-01},
  { 1.882613e-02, -1.542503e-01, -9.878524e-01,  1.344991e-02, -1.091401e+00, -3.894961e-01},
  { 8.289530e-01, -5.565861e-01,  5.521563e-02,  3.841428e-01, -1.114093e+00, -3.615950e-01},
  {-7.025320e-02, -8.706866e-01,  4.867949e-01,  3.442564e-01, -1.113409e+00, -3.370184e-01},
  {-9.689493e-02, -2.496492e-02,  9.949814e-01, -1.191871e-01, -1.062363e+00, -3.823291e-01},
  {-5.995301e-01,  4.176806e-01, -6.827200e-01,  4.322071e-02, -1.099884e+00, -4.208289e-01},
  {-7.722806e-01,  3.070306e-01, -5.561609e-01, -1.898883e-01, -1.051424e+00, -4.602265e-01},
  {-4.421651e-01, -7.464355e-01,  4.973170e-01,  2.823498e-01, -1.097647e+00, -4.506902e-01},
  { 5.039277e-02, -8.379288e-01,  5.434482e-01,  2.420374e-01, -1.111034e+00, -5.087774e-01},
  { 9.618580e-01, -6.820910e-02, -2.649089e-01,  3.852785e-01, -1.068745e+00, -5.711847e-01},
  { 2.236337e-01,  8.580048e-01, -4.624021e-01,  2.705100e-01, -1.098146e+00, -5.706131e-01},
  {-3.214750e-01,  9.084302e-01, -2.672236e-01,  2.733226e-01, -1.108803e+00, -5.821823e-01},
  { 1.469211e-02,  3.367467e-01,  9.414806e-01, -1.596273e-01, -1.090463e+00, -4.984401e-01},
  {-5.811161e-01, -6.264392e-01, -5.194978e-01, -1.439361e-01, -1.116960e+00, -6.268470e-01},
  { 6.096815e-01,  6.456602e-02, -7.900124e-01,  2.826523e-01, -1.073928e+00, -6.654497e-01},
  {-2.828513e-01, -9.069234e-01, -3.122260e-01, -1.672376e-01, -1.109854e+00, -6.700819e-01},
  {-3.829347e-01,  9.095607e-01, -1.614322e-01,  1.874250e-01, -1.037942e+00, -7.219253e-01},
  { 6.093856e-01,  5.041080e-01, -6.119840e-01,  7.144855e-02, -1.053122e+00, -7.225788e-01},
  { 3.719998e-01,  7.117288e-01, -5.958676e-01,  2.211639e-01, -1.046728e+00, -7.466834e-01},
  {-7.979789e-02,  7.972487e-01, -5.983534e-01,  3.637451e-03, -1.052807e+00, -7.549782e-01},
  { 7.193993e-02, -7.944840e-01,  6.030089e-01,  1.442984e-01, -1.109363e+00,  2.671921e-01},
  {-5.422489e-01, -6.403701e-01,  5.439599e-01,  1.006662e-01, -1.080743e+00,  2.637659e-01},
  { 8.296747e-01, -1.558320e-01,  5.360563e-01,  2.211762e-01, -1.106325e+00,  2.084986e-01},
  {-7.475791e-01, -1.832469e-01, -6.383933e-01,  9.004150e-02, -1.081971e+00,  1.664556e-01},
  { 6.172416e-01, -3.786073e-01,  6.896878e-01,  1.128158e-01, -1.127243e+00,  1.503369e-01},
  { 7.716241e-01, -3.409715e-01, -5.369681e-01,  1.040086e-01, -1.119457e+00,  1.149981e-01},
  { 5.318696e-01, -1.389176e-01, -8.353541e-01,  8.209694e-02, -1.112869e+00,  9.280048e-02},
  {-3.860707e-01, -6.485968e-01, -6.559508e-01,  1.594621e-01, -1.093091e+00,  8.107687e-02},
  { 6.100544e-01, -7.865800e-01, -9.552696e-02,  3.540541e-01, -1.113788e+00,  1.098989e-01},
  {-1.943091e-01, -9.571725e-01, -2.146271e-01,  3.252793e-01, -1.112961e+00,  9.391980e-02},
  {-9.117439e-01, -2.844656e-01,  2.963148e-01, -6.397735e-02, -1.128429e+00,  8.001950e-02},
  { 2.731740e-01,  9.399027e-01,  2.048386e-01, -3.571399e-02, -1.138830e+00,  9.005238e-02},
  {-2.717382e-01,  5.133296e-01,  8.140338e-01,  2.448032e-01, -1.036908e+00, -2.601884e-02},
  {-1.090522e-01,  6.494116e-01,  7.525770e-01,  2.321319e-01, -1.027015e+00, -3.791125e-02},
  {-8.796674e-01, -3.280151e-01, -3.443709e-01, -6.245877e-02, -1.093623e+00, -8.520871e-02},
  { 5.996153e-01, -4.842101e-01, -6.371829e-01,  3.188877e-01, -1.072238e+00, -7.363560e-02},
  {-5.489647e-01, -8.128136e-01, -1.948634e-01,  1.693276e-01, -1.065228e+00, -1.227733e-01},
  { 4.632490e-01, -1.922572e-01,  8.651229e-01, -1.013892e-01, -1.121536e+00, -7.980596e-02},
  {-1.102966e-01, -3.977298e-01,  9.108489e-01,  3.049102e-01, -1.075686e+00, -8.126920e-02},
  { 7.536476e-01, -4.485926e-01, -4.803958e-01,  4.079598e-01, -1.056811e+00, -1.633434e-01},
  {-6.810098e-01, -7.062384e-01,  1.935276e-01, -2.579107e-01, -1.114907e+00, -1.368551e-01},
  {-6.380802e-01, -5.845984e-01,  5.010971e-01,  9.756679e-02, -1.051842e+00, -1.985338e-01},
  {-8.373473e-02, -7.031958e-01, -7.060483e-01, -2.038312e-01, -1.122189e+00, -2.559804e-01},
  {-4.291937e-01,  3.632921e-01,  8.269291e-01,  4.293982e-01, -1.035481e+00, -2.202212e-01},
  { 5.206963e-01,  7.210989e-02, -8.506912e-01,  2.076242e-01, -1.049814e+00, -2.378114e-01},
  {-7.205037e-01,  5.650686e-02,  6.911450e-01, -2.182720e-01, -1.072320e+00, -3.160203e-01},
  { 1.450297e-01,  3.847831e-01,  9.115418e-01,  2.522569e-01, -1.057977e+00, -2.705472e-01},
  { 7.512997e-01, -6.119421e-01,  2.471346e-01,  4.071525e-01, -1.082737e+00, -3.254389e-01},
  { 2.197681e-01, -9.720002e-01, -8.317235e-02,  2.552027e-01, -1.067839e+00, -3.721652e-01},
  { 9.044364e-01,  4.211163e-01,  6.823437e-02,  3.825310e-01, -1.057991e+00, -4.759313e-01},
  { 6.678479e-01,  7.002763e-01, -2.521752e-01,  3.766578e-01, -1.040900e+00, -5.554335e-01},
  { 2.224233e-01,  6.201544e-01, -7.522876e-01,  3.586402e-01, -1.065071e+00, -6.027371e-01},
  { 9.102641e-01, -6.038427e-02,  4.096009e-01,  2.437713e-01, -1.065195e+00, -5.569741e-01},
  {-5.901980e-01,  7.970125e-01, -1.282076e-01,  1.097432e-01, -1.048597e+00, -5.497954e-01},
  {-5.684621e-01,  2.703937e-01,  7.770058e-01, -2.304808e-01, -1.065668e+00, -5.167565e-01},
  { 7.723211e-01,  6.297139e-01, -8.354994e-02,  6.722999e-02, -1.040866e+00, -6.577923e-01},
  {-4.957200e-01, -6.007884e-01, -6.271484e-01, -1.903298e-01, -1.066349e+00, -7.236077e-01},
  {-1.088892e-01,  9.133455e-01, -3.923559e-01,  1.644647e-01, -1.056214e+00, -7.749410e-01},
  {-3.731372e-02, -1.665361e-01, -9.853291e-01, -1.079379e-01, -1.072721e+00, -7.443669e-01},
  { 1.200088e-01, -4.534184e-01, -8.831815e-01, -1.476757e-01, -1.061911e+00, -7.466169e-01},
  {-1.119908e-01,  1.979250e-01, -9.737986e-01, -5.729422e-02, -1.054495e+00, -7.401653e-01},
  { 4.078746e-01, -8.344751e-01,  3.705260e-01,  3.240631e-01, -1.098670e+00,  3.053084e-01},
  { 7.114360e-01, -6.892468e-01,  1.371052e-01,  3.352646e-01, -1.087041e+00,  2.993549e-01},
  {-2.090005e-01, -9.732293e-01,  9.562063e-02,  2.597368e-01, -1.095961e+00,  3.000882e-01},
  {-6.029366e-03, -9.791779e-01, -2.029146e-01,  2.865620e-01, -1.109589e+00,  2.824384e-01},
  { 8.164966e-01,  4.082483e-01, -4.082483e-01,  1.075481e-01, -1.063806e+00,  1.562248e-01},
  { 8.164966e-01,  4.082483e-01, -4.082483e-01,  1.119187e-01, -1.070494e+00,  1.560005e-01},
  { 6.702982e-01, -2.364356e-01,  7.034191e-01,  1.015843e-01, -1.060209e+00,  1.617113e-01},
  { 5.286374e-02, -1.602047e-01,  9.856672e-01,  1.158447e-01, -1.069536e+00,  1.533574e-01},
  {-4.162598e-01, -5.031487e-01,  7.573434e-01, -3.634588e-03, -1.090823e+00,  2.021851e-01},
  {-8.793495e-01, -1.038077e-01,  4.647238e-01, -5.344763e-02, -1.075552e+00,  1.536958e-01},
  {-4.401580e-01, -8.367532e-01, -3.257375e-01,  3.096742e-01, -1.104784e+00,  8.843479e-02},
  { 1.145480e-02, -8.836381e-01, -4.680305e-01,  1.945601e-01, -1.078168e+00,  5.495190e-02},
  { 5.030687e-01, -1.048007e-01,  8.578687e-01, -5.391688e-02, -1.093914e+00,  1.008675e-01},
  { 3.404725e-01, -9.115931e-01,  2.303830e-01, -1.350974e-01, -1.112192e+00,  3.271677e-02},
  {-5.530632e-01, -8.179549e-01,  1.583380e-01, -1.729622e-01, -1.116322e+00,  1.391959e-02},
  { 2.668241e-01, -2.063747e-01,  9.413896e-01, -1.463345e-02, -1.112384e+00,  7.563931e-02},
  {-3.488293e-01, -9.141603e-01, -2.064685e-01, -1.598367e-01, -1.123127e+00, -4.006625e-03},
  { 6.778119e-01, -1.082948e-01,  7.272160e-01,  6.356171e-02, -1.026893e+00,  2.085368e-02},
  {-4.479878e-01,  4.868082e-01,  7.498832e-01,  2.251853e-01, -1.010262e+00, -5.535902e-02},
  { 4.277662e-01, -5.977622e-01, -6.780092e-01,  3.180487e-01, -1.066738e+00, -7.901387e-02},
  { 7.800813e-01,  2.186850e-01,  5.862166e-01, -1.072683e-01, -1.079617e+00, -8.052081e-02},
  { 8.355820e-01, -4.446066e-01,  3.226882e-01,  3.751469e-01, -1.046582e+00, -8.261418e-02},
  {-8.967587e-01, -9.030905e-02,  4.332066e-01, -2.539899e-01, -1.104755e+00, -9.912178e-02},
  { 8.389994e-01, -4.191964e-01, -3.469214e-01,  4.180918e-01, -1.034335e+00, -1.649600e-01},
  { 2.474836e-01,  1.805646e-01,  9.519182e-01,  3.518371e-01, -1.035908e+00, -1.924912e-01},
  { 5.366992e-01, -2.701049e-01, -7.993730e-01, -1.319129e-01, -1.081713e+00, -2.266320e-01},
  { 4.291936e-01, -3.632921e-01, -8.269291e-01,  4.217591e-01, -1.026392e+00, -2.281790e-01},
  { 2.628684e-01, -4.610859e-01, -8.475258e-01, -2.260165e-01, -1.097798e+00, -2.824636e-01},
  {-1.427126e-01, -4.551205e-02,  9.887173e-01,  3.782037e-02, -1.014879e+00, -2.101537e-01},
  { 8.597758e-02, -3.194695e-01, -9.436880e-01, -1.251525e-01, -1.073441e+00, -3.458199e-01},
  { 4.917036e-01, -1.382020e-01,  8.597254e-01,  3.907694e-01, -1.070123e+00, -3.105760e-01},
  { 3.125488e-01, -3.085272e-01,  8.984009e-01,  3.227293e-01, -1.056662e+00, -2.891888e-01},
  { 9.268563e-01, -1.499648e-02,  3.751165e-01,  4.092376e-01, -1.075152e+00, -3.305247e-01},
  { 7.519298e-01, -6.893381e-02, -6.556293e-01,  3.789133e-01, -1.049383e+00, -4.632163e-01},
  { 3.500955e-01,  9.341052e-01, -6.986368e-02,  3.464552e-01, -1.020748e+00, -5.211576e-01},
  { 7.042020e-02,  9.576160e-01, -2.793074e-01,  3.243562e-01, -1.017736e+00, -5.253091e-01},
  { 3.498760e-01,  6.906918e-01, -6.328758e-01, -1.759329e-02, -1.022799e+00, -5.997206e-01},
  { 8.394418e-01, -1.115893e-01, -5.318696e-01,  3.262679e-01, -1.032127e+00, -6.467512e-01},
  { 2.641425e-01,  7.400659e-01, -6.184911e-01,  2.748501e-01, -1.021280e+00, -6.707483e-01},
  {-7.966466e-01, -5.569214e-01, -2.349315e-01, -2.576826e-01, -1.047381e+00, -6.334234e-01},
  { 2.286281e-01,  4.293193e-01, -8.737358e-01,  2.854800e-01, -1.022494e+00, -6.705633e-01},
  { 6.149252e-01,  6.300837e-01, -4.741957e-01, -1.215521e-01, -1.031077e+00, -6.883816e-01},
  { 2.185408e-01, -5.217215e-01, -8.246494e-01, -1.469517e-01, -1.037156e+00, -7.598992e-01},
  {-1.681508e-01, -1.346344e-01,  9.765239e-01,  2.886085e-01, -1.058070e+00,  3.427884e-01},
  {-1.833467e-01, -3.217373e-01,  9.289075e-01,  1.719366e-01, -1.041414e+00,  3.224681e-01},
  {-1.151588e-01, -2.518068e-02,  9.930279e-01,  1.394992e-01, -1.029779e+00,  3.261171e-01},
  {-5.208584e-01, -3.243815e-01,  7.896095e-01,  1.018584e-01, -1.022736e+00,  3.104954e-01},
  { 7.893615e-01, -5.728801e-01,  2.207190e-01,  3.839582e-01, -1.054570e+00,  2.104969e-01},
  {-8.350502e-01, -5.486188e-01, -4.133350e-02,  8.122590e-02, -1.043911e+00,  1.837893e-01},
  { 6.868177e-02, -5.848695e-01,  8.082144e-01,  3.953315e-02, -1.040221e+00,  2.241559e-01},
  { 9.108865e-01, -2.434260e-01,  3.332110e-01,  3.766537e-01, -1.066082e+00,  1.136039e-01},
  { 0.000000e+00,  6.246951e-01,  7.808688e-01, -2.223530e-02, -1.082832e+00,  7.173622e-02},
  { 5.050586e-01,  1.276999e-01,  8.535858e-01, -3.959794e-02, -1.056756e+00,  8.683616e-02},
  { 4.516128e-01, -2.697266e-01,  8.504666e-01, -2.559123e-02, -1.073055e+00,  8.098684e-02},
  {-2.213964e-01,  2.668921e-01,  9.379511e-01, -1.104207e-01, -1.075522e+00,  1.720768e-01},
  { 8.176693e-02, -5.755601e-01,  8.136614e-01, -1.257531e-01, -1.076424e+00,  1.687146e-01},
  { 4.619925e-01, -6.271038e-01, -6.271394e-01,  3.705983e-01, -1.067395e+00,  6.026392e-02},
  { 3.030134e-01, -1.329105e-01,  9.436724e-01, -1.586555e-02, -1.078642e+00,  7.335673e-02},
  { 7.943594e-01, -5.926737e-01,  1.331581e-01, -1.045862e-01, -1.112127e+00, -2.292279e-02},
  { 3.794297e-02, -7.793067e-01, -6.254929e-01, -1.210261e-01, -1.108269e+00, -6.762377e-02},
  { 5.923692e-01, -3.536073e-01, -7.239203e-01, -1.143155e-01, -1.089109e+00, -7.631142e-02},
  {-8.774346e-02,  6.489848e-01,  7.557246e-01,  1.939161e-01, -9.737454e-01, -8.572923e-02},
  {-5.396900e-01, -5.377120e-01, -6.477659e-01, -4.972906e-02, -1.039808e+00, -1.355717e-01},
  {-7.464914e-01, -4.940391e-01,  4.457308e-01, -2.522841e-01, -1.078268e+00, -8.207903e-02},
  { 8.789215e-01, -4.355887e-01,  1.943180e-01,  4.411444e-01, -9.990838e-01, -1.043777e-01},
  { 8.942615e-01,  2.548729e-01,  3.678806e-01,  3.694772e-01, -1.011157e+00, -2.014502e-01},
  {-2.141711e-01,  6.199428e-01,  7.548521e-01, -2.283797e-02, -9.940627e-01, -1.906376e-01},
  { 9.587752e-01,  4.016947e-02, -2.813124e-01,  1.620566e-01, -1.014318e+00, -2.900782e-01},
  {-4.150578e-01, -8.898430e-01, -1.894902e-01, -1.213645e-01, -1.013188e+00, -2.742079e-01},
  {-9.439575e-03,  3.766662e-01,  9.263009e-01,  2.973561e-01, -1.015876e+00, -2.736844e-01},
  { 8.833294e-01,  4.306371e-01, -1.851508e-01,  1.492516e-01, -1.014877e+00, -3.300890e-01},
  {-8.988671e-01, -4.315049e-01, -7.642947e-02, -2.095934e-02, -1.025367e+00, -3.704345e-01},
  {-5.200079e-02, -2.029979e-01, -9.777974e-01, -8.673058e-02, -1.033142e+00, -3.502162e-01},
  {-2.215046e-01, -6.538516e-01, -7.234734e-01, -2.338644e-01, -1.064967e+00, -4.193687e-01},
  {-8.322293e-01,  3.651850e-01,  4.171743e-01, -1.701235e-01, -1.005102e+00, -4.286912e-01},
  { 6.211894e-01,  1.699919e-01,  7.650010e-01,  1.833861e-01, -1.002434e+00, -4.473394e-01},
  {-8.499898e-01,  3.286891e-01, -4.116805e-01, -1.744854e-01, -1.007889e+00, -4.587861e-01},
  {-8.181778e-01, -1.695048e-01, -5.494118e-01, -1.614203e-01, -1.019136e+00, -4.870899e-01},
  { 7.558729e-02, -2.831338e-01, -9.560971e-01, -7.080508e-02, -1.035520e+00, -5.078807e-01},
  { 3.677704e-02, -7.675284e-01, -6.399591e-01,  7.679655e-02, -1.030762e+00, -5.717809e-01},
  { 6.591692e-01, -2.114264e-01,  7.216612e-01,  3.269927e-01, -1.019136e+00, -5.682152e-01},
  { 1.403535e-01, -9.770015e-01, -1.605274e-01,  1.825982e-01, -1.028967e+00, -6.012150e-01},
  { 8.752174e-01,  8.642742e-02, -4.759460e-01,  3.518608e-01, -1.006718e+00, -6.177762e-01},
  { 1.399385e-01,  2.857160e-01,  9.480420e-01, -2.093784e-01, -1.020273e+00, -5.603098e-01},
  { 4.498424e-01,  3.984799e-01, -7.992844e-01,  3.134542e-01, -1.013409e+00, -6.524916e-01},
  {-7.111253e-01, -1.851440e-01,  6.782496e-01, -2.774428e-01, -1.027471e+00, -5.713469e-01},
  { 1.411722e-01,  3.491900e-01, -9.263567e-01, -1.234909e-01, -1.011023e+00, -6.479403e-01},
  { 1.235003e-01,  6.670472e-01, -7.347078e-01, -1.398557e-01, -1.021750e+00, -6.604301e-01},
  { 5.580050e-01,  6.218332e-03, -8.298143e-01, -1.531087e-01, -1.021749e+00, -7.755312e-01},
  { 5.314451e-01, -3.166867e-01,  7.856690e-01,  3.358015e-01, -1.027018e+00,  3.426555e-01},
  { 8.825806e-01, -1.398367e-01, -4.488844e-01,  3.925159e-01, -1.037491e+00,  1.815381e-01},
  {-4.967393e-01, -8.677778e-01,  1.455310e-02,  3.120542e-01, -1.069269e+00,  2.074936e-01},
  {-6.214749e-01, -2.160420e-01,  7.530569e-01, -6.063352e-03, -1.009879e+00,  2.453832e-01},
  {-4.953967e-01, -7.611532e-01, -4.186025e-01, -1.398309e-01, -1.060097e+00,  1.708557e-01},
  { 3.991115e-01, -1.533365e-01, -9.039900e-01,  1.236543e-01, -1.050758e+00,  1.577735e-01},
  {-6.358403e-01, -7.023160e-03,  7.717887e-01,  1.221949e-01, -1.043554e+00,  1.588255e-01},
  {-9.464450e-01,  1.297961e-02,  3.226039e-01, -3.915205e-02, -1.023407e+00,  1.799254e-01},
  {-2.477625e-01, -9.585694e-01,  1.405650e-01,  2.525593e-01, -1.052641e+00,  7.541753e-02},
  {-4.407830e-01, -6.322826e-01,  6.371256e-01, -1.670128e-01, -1.053706e+00,  1.647063e-01},
  {-1.499473e-01, -9.871502e-01,  5.522909e-02,  2.423682e-01, -1.042722e+00,  8.764778e-02},
  {-3.025002e-01,  5.565205e-01, -7.738078e-01,  2.784295e-03, -1.076932e+00,  6.729592e-02},
  {-3.025002e-01,  5.565205e-01, -7.738078e-01,  1.249387e-02, -1.058784e+00,  7.655208e-02},
  { 6.258657e-01,  6.796484e-01,  3.825836e-01, -9.791944e-02, -1.074319e+00,  1.494895e-01},
  { 2.548871e-01, -6.055788e-01, -7.538612e-01,  2.768098e-01, -1.049922e+00,  3.582355e-02},
  { 6.829569e-01, -1.686988e-01,  7.107113e-01,  1.211691e-02, -1.063269e+00,  7.704097e-02},
  {-9.913814e-01, -3.509988e-02,  1.262174e-01, -4.028950e-02, -1.046598e+00,  7.742675e-02},
  {-6.258657e-01, -6.796484e-01, -3.825836e-01, -9.656018e-02, -1.082635e+00,  1.620382e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -1.042551e-01, -1.083069e+00,  1.363810e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -1.165565e-01, -1.080817e+00,  1.226200e-01},
  {-6.501893e-01, -7.589074e-01,  3.624020e-02, -2.182718e-01, -1.067526e+00,  3.339449e-02},
  {-4.831517e-01, -4.672923e-01, -7.404068e-01, -1.464265e-01, -1.082663e+00, -6.924355e-02},
  {-3.444982e-01,  3.901121e-01,  8.538931e-01,  2.792517e-01, -9.815103e-01, -1.542637e-02},
  { 6.804153e-01,  4.743670e-01,  5.585793e-01,  3.812398e-01, -1.000840e+00, -5.051839e-02},
  { 5.797932e-01, -1.020355e-02,  8.146998e-01,  4.035670e-01, -1.002146e+00, -7.320277e-02},
  { 9.985567e-01,  4.520155e-02, -2.900583e-02, -1.138303e-01, -1.045093e+00, -9.102553e-02},
  { 8.705948e-03,  6.075081e-01,  7.942658e-01,  1.803292e-01, -9.674677e-01, -9.389365e-02},
  {-7.498329e-01,  1.510293e-01,  6.441590e-01,  4.506577e-01, -9.894612e-01, -9.555981e-02},
  {-8.712698e-01,  1.668431e-01, -4.615759e-01, -2.254693e-01, -1.038349e+00, -1.353144e-01},
  {-3.669855e-01,  3.279027e-01,  8.705179e-01, -2.506558e-01, -1.038321e+00, -1.485883e-01},
  {-2.984625e-01, -8.225580e-01, -4.840644e-01, -3.068476e-01, -1.070646e+00, -3.263733e-01},
  {-4.404679e-01, -4.991014e-01,  7.462478e-01, -1.562886e-01, -9.963424e-01, -2.768175e-01},
  {-6.316342e-01, -2.239956e-01, -7.422023e-01, -2.803585e-01, -1.036880e+00, -4.169969e-01},
  {-4.132725e-02,  6.522467e-01,  7.568794e-01,  1.552304e-01, -9.913367e-01, -3.641159e-01},
  { 7.383501e-01,  6.705053e-01,  7.253894e-02,  3.118268e-01, -1.012036e+00, -4.504686e-01},
  { 3.141774e-01, -1.783166e-01, -9.324676e-01, -1.211337e-01, -1.019174e+00, -5.256368e-01},
  {-4.982438e-01,  4.638270e-02,  8.657954e-01, -1.045415e-01, -9.994791e-01, -5.507861e-01},
  {-4.794870e-02, -9.775646e-01, -2.051060e-01,  1.372151e-01, -1.042646e+00, -6.300877e-01},
  {-5.571479e-01, -6.980222e-01, -4.498346e-01,  1.037200e-01, -1.036543e+00, -6.334700e-01},
  { 7.256532e-02,  2.671470e-01,  9.609197e-01, -1.886498e-01, -1.002859e+00, -5.782093e-01},
  {-4.178063e-01, -9.077678e-01, -3.735642e-02, -1.369609e-01, -1.003661e+00, -6.524836e-01},
  { 5.075749e-01, -6.241762e-01, -5.939460e-01,  1.725366e-01, -1.021907e+00, -6.916269e-01},
  {-6.079203e-01, -4.117818e-01, -6.788731e-01, -2.016532e-01, -1.019586e+00, -7.466637e-01},
  { 8.176333e-01,  3.758681e-01,  4.361182e-01,  3.909827e-01, -1.010186e+00,  2.908990e-01},
  { 2.829891e-01, -9.590645e-01, -1.059912e-02,  3.255354e-01, -1.068988e+00,  2.163718e-01},
  {-6.478730e-01, -6.765739e-02,  7.587378e-01,  3.092260e-03, -9.688709e-01,  2.649340e-01},
  { 2.545470e-01, -8.107981e-01,  5.270790e-01, -8.719628e-02, -1.060330e+00,  2.064390e-01},
  {-6.844573e-01, -7.209380e-01, -1.084742e-01,  2.866651e-01, -1.050106e+00,  1.959664e-01},
  {-3.327610e-01, -7.847881e-01, -5.228552e-01,  2.679837e-01, -1.030874e+00,  1.957452e-01},
  { 1.427323e-01, -9.661284e-01, -2.149961e-01, -1.099634e-01, -1.074625e+00,  1.810975e-01},
  { 9.240790e-01,  2.027526e-01, -3.239900e-01,  3.896082e-01, -1.010211e+00,  1.832571e-01},
  { 9.552051e-01,  2.384578e-01, -1.752744e-01,  3.323599e-01, -1.021778e+00,  1.430646e-01},
  {-1.596720e-01, -2.600033e-01, -9.523147e-01,  1.394518e-01, -1.023775e+00,  1.551954e-01},
  {-8.691030e-01, -3.338348e-01, -3.649856e-01,  9.976821e-02, -1.010131e+00,  7.786680e-02},
  { 7.980053e-01, -2.814323e-01, -5.329010e-01,  4.992515e-02, -1.018302e+00,  9.246292e-02},
  { 8.648898e-01, -4.992326e-01,  5.227285e-02, -8.965468e-02, -1.052523e+00,  1.503181e-01},
  { 9.379877e-01, -2.707428e-01, -2.165119e-01, -1.016030e-01, -1.060273e+00,  4.299405e-02},
  {-7.036849e-01,  2.936758e-01,  6.469793e-01,  2.296596e-01, -9.518045e-01, -4.841717e-02},
  { 1.326017e-01,  5.120893e-01,  8.486350e-01,  1.581226e-01, -9.596762e-01, -9.518734e-02},
  { 1.956796e-01,  4.880391e-01,  8.506041e-01,  1.352835e-01, -9.621550e-01, -8.979563e-02},
  {-9.410426e-01,  8.000551e-02, -3.286913e-01, -6.909015e-02, -9.950196e-01, -1.322153e-01},
  { 7.498329e-01, -1.510293e-01, -6.441590e-01,  4.521167e-01, -9.641564e-01, -9.979440e-02},
  {-2.429745e-01,  5.049070e-01,  8.282707e-01,  3.634672e-02, -9.859657e-01, -1.719599e-01},
  { 1.349050e-01,  9.146055e-01,  3.811791e-01,  2.842448e-01, -9.530380e-01, -1.512402e-01},
  { 9.644241e-01, -1.874489e-01, -1.864110e-01, -8.901840e-02, -9.972491e-01, -2.066064e-01},
  { 2.420615e-01,  1.750833e-01, -9.543333e-01, -1.974457e-01, -1.023925e+00, -2.406595e-01},
  { 3.347957e-01, -5.568367e-01, -7.601609e-01,  2.178655e-01, -9.968745e-01, -2.587426e-01},
  {-4.876139e-01,  1.288182e-01,  8.635036e-01, -2.533877e-02, -9.503164e-01, -2.117869e-01},
  {-9.784824e-01, -1.987695e-02, -2.053708e-01, -3.664854e-01, -1.018377e+00, -2.664004e-01},
  { 3.733166e-01, -7.454503e-01, -5.522124e-01, -2.753806e-01, -1.063490e+00, -3.365490e-01},
  {-8.791019e-01, -3.966233e-01, -2.643288e-01, -3.628781e-01, -1.026284e+00, -3.082815e-01},
  {-5.223247e-01, -5.233998e-01, -6.732233e-01, -3.298206e-01, -1.048048e+00, -3.417794e-01},
  {-4.972222e-01, -5.119277e-01, -7.005000e-01, -3.507459e-02, -9.987080e-01, -3.672816e-01},
  {-9.777118e-02,  2.471848e-01, -9.640231e-01, -2.486688e-01, -1.026007e+00, -4.235794e-01},
  { 3.034344e-01, -4.117373e-01, -8.593020e-01,  3.671916e-01, -1.016816e+00, -4.836954e-01},
  {-5.923647e-01, -7.318287e-01, -3.369431e-01,  3.068137e-01, -9.958789e-01, -4.675988e-01},
  { 3.667947e-01, -9.001403e-01,  2.349662e-01, -2.743298e-01, -1.048040e+00, -4.591715e-01},
  {-3.481328e-01, -9.371696e-01,  2.272906e-02, -3.124968e-01, -1.046780e+00, -4.857566e-01},
  {-1.175650e-01, -8.045450e-01, -5.821390e-01, -3.110357e-01, -1.044913e+00, -4.946977e-01},
  {-4.576679e-01, -7.680928e-01, -4.478544e-01, -1.282760e-01, -1.013041e+00, -5.314147e-01},
  { 6.417043e-01,  6.669949e-01,  3.785940e-01,  2.672621e-02, -9.795887e-01, -5.627001e-01},
  { 9.082749e-01,  1.335481e-01,  3.964866e-01,  3.562334e-01, -9.713975e-01, -5.834420e-01},
  {-2.792394e-02,  8.667064e-01, -4.980364e-01,  2.645180e-01, -9.985103e-01, -6.059460e-01},
  {-5.125726e-01,  8.378974e-01, -1.876093e-01,  2.764208e-01, -9.948454e-01, -6.061782e-01},
  {-5.134471e-01,  4.055752e-01, -7.562281e-01,  2.827114e-01, -9.889650e-01, -6.072955e-01},
  {-4.128717e-02,  7.745537e-01, -6.311593e-01,  2.949904e-01, -9.851437e-01, -6.135830e-01},
  {-1.714063e-01, -7.277636e-01, -6.640633e-01,  1.527282e-01, -1.025441e+00, -6.990129e-01},
  { 1.464751e-02, -8.044192e-01, -5.938815e-01, -1.519274e-01, -9.963132e-01, -7.769601e-01},
  { 4.261490e-01,  1.664352e-01, -8.892111e-01,  6.972270e-02, -1.003074e+00, -7.381746e-01},
  { 1.616744e-01, -8.895371e-01, -4.272999e-01, -9.482060e-02, -1.016648e+00, -7.235767e-01},
  {-1.418026e-01, -9.898935e-01, -1.717428e-03, -1.025605e-01, -1.016757e+00, -7.189893e-01},
  {-1.154384e-01, -9.469742e-01, -2.998564e-01,  2.579854e-02, -9.968256e-01, -7.602049e-01},
  {-8.571606e-03, -6.843114e-01, -7.291394e-01, -2.056245e-02, -1.009776e+00, -7.496302e-01},
  { 3.062228e-01, -9.338253e-01, -1.849270e-01,  1.475454e-01, -1.035447e+00,  3.956252e-01},
  { 2.923215e-01,  5.659452e-01,  7.708788e-01,  1.428354e-01, -9.573489e-01,  2.600381e-01},
  { 8.173897e-01, -5.091349e-01, -2.695470e-01, -7.866046e-02, -1.053772e+00,  1.736807e-01},
  { 4.080372e-01, -1.555862e-01, -8.996103e-01, -8.935916e-02, -1.049043e+00,  1.591004e-01},
  { 8.904525e-01, -2.546031e-02,  4.543634e-01,  2.452550e-01, -1.002614e+00,  1.671209e-01},
  { 5.183018e-01, -1.475057e-01, -8.423807e-01,  1.096713e-01, -1.006966e+00,  1.512097e-01},
  { 2.623830e-01,  1.711561e-01,  9.496635e-01,  2.968148e-01, -9.728672e-01,  1.160083e-01},
  {-8.689850e-01,  4.112091e-01,  2.752676e-01, -4.861210e-02, -9.682012e-01,  1.159800e-01},
  { 2.362467e-01,  1.196287e-01,  9.643011e-01, -1.636806e-01, -1.046629e+00,  1.645737e-01},
  {-4.013106e-01, -9.015719e-01,  1.616102e-01, -1.735795e-01, -1.040218e+00,  1.757607e-01},
  { 3.707550e-01,  5.994217e-01,  7.093902e-01, -1.842898e-01, -1.036346e+00,  1.707637e-01},
  { 8.346801e-01, -5.436631e-01,  8.797511e-02,  3.769453e-02, -1.015327e+00,  6.227678e-02},
  {-7.228774e-01, -4.481643e-01,  5.259248e-01, -2.073269e-01, -1.008306e+00,  1.311436e-01},
  {-7.973792e-01, -2.685575e-01, -5.404289e-01,  1.229918e-01, -9.816294e-01, -9.952419e-03},
  {-8.292250e-01, -3.067810e-02,  5.580723e-01, -3.085873e-01, -1.002614e+00,  4.108332e-02},
  {-6.129491e-01, -7.677205e-01,  1.868120e-01, -2.152180e-01, -1.026958e+00, -2.785312e-02},
  { 4.958845e-01,  6.960061e-01,  5.193015e-01,  7.149635e-02, -9.746755e-01, -1.959765e-02},
  {-5.152939e-01, -8.228770e-01,  2.394694e-01, -2.323906e-01, -1.018400e+00, -3.079141e-02},
  { 5.786600e-01,  4.084084e-01,  7.059427e-01,  1.093374e-01, -9.414973e-01, -9.394474e-02},
  {-2.556265e-02,  8.384498e-01,  5.443792e-01,  3.600506e-01, -9.477873e-01, -1.079426e-01},
  {-8.207038e-01, -6.580169e-02, -5.675521e-01, -3.659398e-02, -9.824168e-01, -1.690567e-01},
  { 8.989545e-01,  3.914723e-01, -1.965456e-01,  4.073428e-01, -9.440438e-01, -2.009594e-01},
  {-3.383057e-01,  1.775622e-01,  9.241325e-01, -2.241234e-01, -9.908421e-01, -1.588048e-01},
  { 3.899058e-01,  7.519767e-01,  5.315115e-01,  2.702934e-01, -9.419363e-01, -1.694539e-01},
  { 9.765741e-01,  4.959374e-02, -2.093881e-01, -8.236270e-02, -9.712257e-01, -2.191982e-01},
  { 4.758124e-01,  1.226197e-02, -8.794613e-01, -1.067469e-01, -9.850782e-01, -2.396742e-01},
  {-9.812729e-01, -1.634778e-01, -1.018752e-01, -3.767433e-01, -9.935032e-01, -2.272761e-01},
  { 6.130781e-01, -2.561274e-01, -7.473513e-01,  3.687337e-01, -9.677451e-01, -3.103296e-01},
  { 4.344231e-02, -8.416287e-01,  5.383067e-01, -2.320384e-01, -9.989939e-01, -3.273542e-01},
  {-3.852366e-01, -9.200701e-01, -7.115971e-02, -2.818357e-01, -1.054010e+00, -3.796556e-01},
  {-7.121580e-01,  1.053369e-01, -6.940715e-01, -3.060071e-01, -1.000567e+00, -3.692806e-01},
  {-7.073017e-03, -5.840566e-02, -9.982678e-01,  1.603969e-01, -9.412844e-01, -4.625917e-01},
  {-3.145450e-01, -9.252474e-01,  2.120818e-01, -3.338197e-01, -1.033180e+00, -4.235300e-01},
  { 3.802439e-01, -4.971616e-01, -7.799006e-01,  3.908272e-01, -9.723805e-01, -4.991245e-01},
  {-4.099714e-01, -4.228504e-01, -8.081591e-01,  2.992217e-01, -9.685397e-01, -5.136314e-01},
  { 6.278173e-01, -7.699276e-01,  1.142673e-01,  1.952586e-01, -9.538717e-01, -4.691461e-01},
  {-3.977213e-02, -2.935392e-01, -9.551193e-01, -3.114358e-01, -1.014887e+00, -5.149693e-01},
  { 2.448060e-01, -5.405378e-01, -8.049155e-01, -1.605410e-01, -9.953485e-01, -5.455634e-01},
  { 2.853006e-01, -9.511900e-01, -1.176484e-01,  1.346269e-02, -9.806362e-01, -5.922338e-01},
  {-8.300121e-01, -5.180987e-01,  2.065275e-01, -3.200430e-01, -9.859167e-01, -5.928950e-01},
  { 5.273139e-01, -7.747901e-01, -3.487697e-01,  2.471539e-01, -9.870225e-01, -6.453612e-01},
  { 6.240872e-01,  3.279500e-01, -7.091995e-01,  2.606331e-01, -9.677100e-01, -6.441971e-01},
  {-7.422357e-01, -4.136822e-01, -5.272126e-01, -2.312620e-01, -9.624237e-01, -6.663345e-01},
  { 1.783398e-01, -5.135904e-02, -9.826277e-01,  1.507760e-01, -9.880249e-01, -7.138779e-01},
  { 1.639310e-01,  3.163233e-01, -9.343802e-01, -2.139968e-01, -9.630783e-01, -7.765985e-01},
  { 2.912167e-01,  2.201301e-01, -9.309863e-01, -2.356942e-01, -9.298817e-01, -7.691669e-01},
  { 7.830716e-02, -5.668545e-01, -8.200879e-01, -4.986125e-02, -9.984207e-01, -7.569441e-01},
  {-1.109562e-02, -6.828642e-01,  7.304611e-01,  1.119989e-01, -1.011338e+00,  4.248598e-01},
  {-4.088847e-01, -9.040547e-01, -1.244924e-01,  2.112996e-02, -1.014837e+00,  3.606333e-01},
  {-2.179275e-01, -9.216267e-01,  3.211102e-01,  2.986651e-01, -1.034678e+00,  3.654742e-01},
  { 7.815658e-01, -6.228945e-01, -3.401946e-02,  3.472427e-01, -1.016049e+00,  3.513069e-01},
  { 2.741312e-01, -8.925377e-01, -3.580903e-01,  3.191029e-01, -1.038359e+00,  3.492597e-01},
  {-4.092633e-01,  5.214275e-01,  7.487436e-01,  5.077323e-02, -9.280736e-01,  2.832409e-01},
  { 1.780283e-01,  4.161246e-01,  8.917097e-01,  9.123795e-02, -9.024416e-01,  2.754295e-01},
  { 2.824979e-01,  2.863447e-01,  9.155335e-01,  1.461743e-01, -9.326615e-01,  2.194358e-01},
  {-8.171608e-01,  3.908527e-01,  4.236538e-01,  1.400428e-01, -9.644500e-01,  1.223680e-01},
  { 8.663995e-01,  7.854844e-03,  4.992896e-01,  3.951435e-01, -9.682804e-01,  1.172993e-01},
  { 6.198993e-01, -4.625471e-01, -6.338573e-01,  3.848980e-01, -9.917971e-01,  1.523062e-02},
  {-9.961466e-01,  8.451918e-02,  2.341754e-02, -6.253857e-02, -9.495009e-01,  5.114509e-02},
  {-8.228508e-01, -4.139538e-01,  3.893054e-01, -3.265570e-01, -9.991583e-01, -5.103599e-02},
  {-7.139241e-01, -6.833438e-01, -1.528193e-01, -3.545551e-01, -9.816169e-01, -8.246604e-02},
  {-7.754666e-01, -6.149225e-01, -1.432544e-01, -2.935952e-01, -1.020707e+00, -1.131699e-01},
  { 9.798595e-01, -1.993407e-01,  1.176835e-02, -1.175945e-01, -9.643053e-01, -1.250396e-01},
  {-8.515702e-01, -1.766414e-02,  5.239430e-01, -2.057728e-01, -9.594544e-01, -1.427253e-01},
  { 5.413896e-01,  6.901577e-01,  4.801872e-01,  2.455077e-01, -9.247816e-01, -1.614737e-01},
  { 5.715557e-01,  7.138065e-01,  4.047276e-01,  2.310590e-01, -9.165893e-01, -1.595654e-01},
  {-2.275874e-01, -1.265012e-01,  9.655058e-01, -2.328154e-01, -9.678651e-01, -1.604202e-01},
  {-3.502670e-01,  3.382489e-01,  8.734418e-01, -3.649082e-01, -9.499287e-01, -1.433907e-01},
  {-9.607434e-01,  1.269361e-01,  2.466969e-01, -3.851013e-01, -9.766332e-01, -1.516995e-01},
  {-6.871340e-01,  6.209006e-01, -3.772656e-01, -3.418820e-01, -9.593610e-01, -2.861944e-01},
  { 1.619467e-02, -1.492196e-01,  9.886714e-01, -1.119180e-01, -9.348651e-01, -2.859284e-01},
  {-2.411827e-01,  9.537133e-02,  9.657821e-01,  3.059479e-01, -9.426023e-01, -3.479468e-01},
  { 2.698094e-01, -7.566775e-01,  5.955183e-01, -2.964968e-01, -1.029622e+00, -4.359248e-01},
  { 1.384428e-01, -7.667418e-01,  6.268499e-01, -2.501209e-01, -1.024031e+00, -4.538070e-01},
  {-5.780214e-03, -3.048042e-01, -9.523975e-01,  3.152874e-01, -9.436399e-01, -5.354618e-01},
  {-4.952545e-01, -6.269968e-01, -6.013303e-01, -3.630942e-01, -9.794531e-01, -5.146966e-01},
  {-2.578087e-01, -1.287918e-01, -9.575737e-01, -1.004692e-01, -9.640836e-01, -5.185122e-01},
  { 4.584855e-01,  4.515072e-01,  7.654620e-01,  2.505717e-01, -9.208850e-01, -5.200160e-01},
  {-4.811084e-01, -8.684070e-01, -1.200169e-01,  5.575274e-02, -9.743896e-01, -5.907564e-01},
  { 4.504447e-01, -4.536820e-01, -7.689423e-01,  3.215459e-02, -9.710536e-01, -5.869380e-01},
  { 6.718457e-01,  7.001940e-01, -2.415610e-01,  3.307860e-01, -9.361976e-01, -5.880613e-01},
  {-6.413550e-01, -7.486531e-01, -1.678757e-01,  9.829854e-02, -1.001825e+00, -6.569787e-01},
  { 1.621741e-01,  5.451992e-01, -8.224703e-01, -1.273629e-01, -9.267934e-01, -7.592043e-01},
  { 1.918068e-01, -4.527273e-01,  8.707746e-01,  2.370645e-01, -9.686764e-01,  4.689134e-01},
  {-2.522544e-01, -6.457810e-01,  7.206487e-01,  1.999854e-01, -9.566876e-01,  4.670947e-01},
  { 7.839844e-01, -1.857711e-01,  5.923322e-01,  3.196968e-01, -9.869460e-01,  4.221747e-01},
  {-6.078618e-01, -7.921177e-01, -5.525719e-02, -1.955788e-02, -9.877225e-01,  3.643888e-01},
  {-1.262785e-01, -4.451440e-01, -8.865104e-01,  2.843409e-02, -9.831775e-01,  3.256268e-01},
  {-8.388740e-01, -5.097066e-01,  1.910226e-01,  2.814183e-01, -1.014261e+00,  3.070111e-01},
  {-7.300315e-01, -6.215313e-01,  2.841704e-01,  2.399841e-01, -9.658324e-01,  2.769172e-01},
  { 1.572345e-01, -7.149493e-01,  6.812671e-01, -9.621540e-02, -9.941089e-01,  2.964406e-01},
  {-3.493123e-01, -7.057697e-01,  6.163359e-01, -1.241010e-01, -9.868345e-01,  2.930876e-01},
  { 8.406292e-01, -5.354983e-01, -8.114253e-02, -6.016381e-02, -9.815323e-01,  2.625506e-01},
  {-8.113658e-01,  5.703788e-01, -1.278813e-01,  5.847602e-02, -9.163347e-01,  2.292468e-01},
  { 8.441048e-01,  5.089564e-01, -1.686726e-01,  3.280394e-01, -9.280847e-01,  1.613440e-01},
  {-5.729882e-01, -7.961015e-01,  1.946977e-01, -2.160358e-01, -1.006085e+00,  1.966687e-01},
  {-7.350152e-01,  6.666622e-01, -1.237503e-01,  6.958663e-02, -9.231391e-01,  2.024625e-01},
  {-6.627899e-01,  6.245828e-01,  4.130445e-01,  5.433321e-02, -9.296579e-01,  1.620155e-01},
  {-8.465601e-01,  1.824801e-01,  5.000372e-01, -1.912261e-01, -1.008760e+00,  1.585678e-01},
  { 8.159766e-01, -1.530290e-01,  5.574624e-01,  3.924158e-01, -9.507540e-01,  1.407102e-01},
  {-8.343882e-01,  2.518419e-01,  4.902775e-01, -5.384082e-02, -9.423292e-01,  9.942950e-02},
  { 1.496144e-02, -7.618372e-01, -6.475956e-01,  2.585186e-01, -9.629392e-01,  2.822577e-02},
  {-9.490827e-01,  3.109824e-01, -5.031788e-02,  1.160933e-01, -9.417167e-01,  2.121522e-02},
  { 2.575240e-01, -5.657117e-01, -7.833592e-01,  1.742180e-01, -9.604154e-01, -5.272478e-02},
  {-6.259696e-01,  4.778564e-01,  6.162916e-01, -2.935715e-01, -9.696895e-01,  3.617935e-02},
  { 9.664896e-01, -2.553416e-01,  2.642767e-02, -8.155792e-02, -9.648484e-01, -1.743660e-02},
  { 9.473788e-01, -3.092116e-01, -8.283472e-02, -7.376588e-02, -9.555969e-01, -3.176765e-02},
  { 1.849070e-01,  7.406139e-01,  6.459879e-01,  2.348173e-01, -9.018486e-01, -9.291551e-02},
  { 9.550198e-01,  2.320941e-03, -2.965333e-01,  4.073707e-01, -9.222244e-01, -2.030287e-01},
  {-4.987321e-01, -8.321532e-01, -2.424610e-01,  3.452806e-02, -9.370822e-01, -2.022923e-01},
  { 7.258084e-01, -1.980919e-01, -6.587578e-01, -2.282118e-01, -9.680763e-01, -2.520145e-01},
  {-9.445398e-01,  1.037455e-01,  3.115790e-01, -2.380731e-01, -9.750066e-01, -2.796012e-01},
  { 7.432083e-01, -2.550380e-01, -6.185444e-01,  4.150158e-01, -9.009302e-01, -3.078593e-01},
  {-9.445398e-01,  1.037455e-01,  3.115790e-01, -2.508249e-01, -9.979459e-01, -3.106196e-01},
  { 2.876551e-01, -1.257079e-02, -9.576515e-01,  1.636583e-01, -9.329615e-01, -3.343284e-01},
  {-3.368272e-01, -4.070868e-01, -8.490158e-01, -1.100986e-01, -9.419956e-01, -3.836032e-01},
  { 8.971735e-01,  1.916157e-01,  3.979487e-01,  4.143181e-01, -9.211082e-01, -3.575722e-01},
  {-7.188473e-01, -6.861162e-01,  1.118173e-01, -3.697693e-01, -1.007163e+00, -3.848739e-01},
  { 2.144119e-01, -8.948851e-01,  3.914182e-01, -3.685867e-01, -1.004469e+00, -3.573446e-01},
  { 9.426993e-01,  2.105711e-02, -3.329786e-01,  3.986611e-01, -9.369761e-01, -4.523864e-01},
  {-6.478443e-01,  7.221957e-01, -2.423449e-01, -1.002091e-01, -9.277113e-01, -4.184123e-01},
  { 5.967272e-01,  1.545179e-01, -7.874268e-01,  1.219955e-01, -9.155317e-01, -4.866395e-01},
  { 5.800669e-01,  4.010606e-03, -8.145590e-01,  3.541015e-01, -9.271951e-01, -5.345322e-01},
  { 3.899028e-01,  7.286158e-01,  5.631117e-01,  1.064723e-01, -9.096535e-01, -5.217872e-01},
  { 1.280161e-01,  3.337095e-01, -9.339432e-01, -1.812298e-01, -9.584585e-01, -5.410552e-01},
  { 5.185627e-03,  7.330121e-01,  6.801958e-01,  1.759717e-01, -9.174396e-01, -5.249294e-01},
  {-1.676437e-02, -5.168560e-01,  8.559083e-01, -1.808683e-01, -9.300873e-01, -5.602755e-01},
  { 1.673067e-01,  1.847443e-01,  9.684411e-01,  2.385488e-01, -9.306651e-01,  4.744496e-01},
  {-2.682930e-01, -6.734688e-01,  6.888095e-01,  4.815161e-02, -9.779396e-01,  4.421983e-01},
  {-5.004131e-01, -5.846189e-01,  6.385981e-01,  7.481856e-03, -9.720330e-01,  4.213727e-01},
  { 8.802881e-01,  3.473292e-01,  3.231953e-01,  3.052545e-01, -9.458274e-01,  4.286900e-01},
  { 1.617754e-01, -4.890561e-01, -8.571189e-01,  1.272098e-01, -9.649535e-01,  3.222762e-01},
  {-6.780955e-01, -7.290430e-01,  9.318119e-02,  2.518900e-01, -9.638718e-01,  3.117916e-01},
  { 8.979270e-01,  4.134467e-01,  1.509598e-01,  3.314158e-01, -9.789363e-01,  3.058930e-01},
  {-2.951981e-01,  4.759417e-01,  8.284549e-01,  1.795289e-01, -9.324264e-01,  2.220568e-01},
  { 6.684155e-01,  2.238951e-01, -7.092896e-01, -1.116550e-01, -1.028251e+00,  1.561327e-01},
  {-5.820531e-01, -7.393116e-01,  3.385744e-01, -2.738816e-01, -9.748250e-01,  1.871267e-01},
  {-3.522412e-01,  2.284596e-01,  9.075970e-01,  3.131594e-01, -9.320712e-01,  1.042526e-01},
  {-5.604714e-01, -1.732718e-02,  8.279924e-01, -3.568740e-01, -9.357234e-01, -3.464249e-02},
  {-9.796683e-01, -1.377674e-01,  1.458432e-01, -3.811839e-01, -9.285086e-01, -8.579504e-02},
  {-5.559382e-01, -4.968500e-01, -6.663880e-01, -3.274375e-01, -9.785593e-01, -1.170490e-01},
  { 7.361766e-01,  2.967110e-02, -6.761388e-01, -2.186789e-01, -9.360743e-01, -1.234329e-01},
  {-9.630783e-01, -2.423591e-01,  1.172275e-01, -2.071157e-01, -9.289622e-01, -1.303265e-01},
  { 3.270054e-01,  8.779184e-01,  3.497524e-01,  2.050454e-01, -8.791595e-01, -1.248237e-01},
  { 6.657693e-01, -2.711323e-01, -6.951535e-01, -8.275735e-02, -9.128867e-01, -2.320261e-01},
  { 6.357793e-01,  4.206968e-01,  6.471468e-01,  3.954045e-01, -8.895066e-01, -2.364772e-01},
  { 3.202333e-01, -3.445758e-01, -8.824500e-01, -1.931232e-01, -9.507316e-01, -2.401999e-01},
  {-9.259275e-01, -3.485469e-01,  1.455105e-01, -3.186325e-01, -9.194784e-01, -2.344689e-01},
  { 6.255302e-01,  4.369523e-01, -6.463625e-01,  6.295009e-02, -9.068660e-01, -3.669159e-01},
  { 3.763899e-01,  3.381405e-01,  8.625495e-01,  3.699322e-01, -9.184961e-01, -3.392600e-01},
  {-2.110615e-01, -6.659023e-01, -7.155606e-01, -1.073162e-01, -9.181860e-01, -3.969259e-01},
  { 8.768377e-01,  1.032535e-01, -4.695682e-01,  4.203783e-01, -9.001931e-01, -4.037451e-01},
  { 5.592709e-03, -9.183577e-02, -9.957584e-01,  1.677341e-01, -9.111565e-01, -4.511194e-01},
  {-1.595111e-01, -6.231872e-01, -7.656330e-01,  1.931834e-01, -9.121292e-01, -4.608478e-01},
  { 6.342498e-01,  5.345406e-01,  5.585638e-01,  8.496290e-02, -8.997441e-01, -5.203673e-01},
  { 2.787627e-01,  5.733451e-01,  7.704329e-01,  2.525972e-01, -8.865637e-01, -5.387025e-01},
  { 2.113475e-01,  5.406635e-01,  8.142574e-01,  1.235755e-01, -8.852038e-01, -5.547678e-01},
  { 7.341254e-01,  6.787069e-01,  2.041550e-02,  2.938066e-01, -8.924620e-01, -5.743921e-01},
  { 2.637137e-01,  4.713130e-01, -8.416170e-01,  8.894461e-02, -8.861245e-01, -6.434099e-01},
  {-2.939259e-01,  8.198995e-01, -4.912966e-01,  4.790977e-02, -9.020107e-01, -6.061463e-01},
  { 3.144259e-01,  8.743820e-01, -3.695843e-01,  6.815466e-02, -8.959263e-01, -6.625413e-01},
  {-3.373053e-01,  8.104146e-01, -4.790129e-01, -5.427932e-02, -9.077336e-01, -6.555412e-01},
  {-2.288277e-01,  7.975303e-01, -5.581965e-01, -1.920931e-01, -8.871832e-01, -7.445796e-01},
  {-3.704654e-01, -2.976774e-01,  8.798542e-01,  4.350466e-02, -9.512321e-01,  4.564230e-01},
  {-7.061270e-01, -6.969575e-01, -1.250393e-01, -6.667381e-02, -9.358776e-01,  3.588984e-01},
  {-5.127159e-01, -5.896226e-01,  6.240734e-01, -2.696818e-02, -9.651516e-01,  4.012226e-01},
  {-1.620493e-01, -8.428836e-01, -5.131153e-01,  1.429152e-01, -9.518424e-01,  3.136082e-01},
  {-6.897293e-01, -4.724173e-01,  5.487215e-01,  1.737947e-01, -9.009842e-01,  2.225879e-01},
  { 1.133144e-01, -1.063386e-01,  9.878522e-01, -1.438898e-01, -9.242485e-01,  3.223801e-01},
  {-6.044545e-01,  6.518449e-01,  4.579661e-01,  7.610383e-02, -8.745174e-01,  2.500759e-01},
  {-3.466974e-01, -6.720473e-01,  6.543342e-01, -2.261223e-01, -9.375213e-01,  2.201779e-01},
  { 8.189038e-01,  3.142524e-01,  4.802519e-01, -1.089024e-01, -9.690994e-01,  1.443075e-01},
  { 2.533677e-01, -4.707044e-01, -8.451285e-01,  2.490654e-01, -9.217767e-01, -1.477087e-03},
  { 9.642062e-01, -2.521783e-01, -8.193032e-02,  8.248533e-02, -9.012455e-01,  4.653838e-03},
  { 3.399509e-01,  3.826113e-01,  8.590937e-01,  2.447443e-01, -8.804174e-01, -1.699478e-01},
  {-1.905643e-01,  4.515340e-01,  8.716664e-01, -3.116116e-01, -8.881105e-01, -1.617754e-01},
  {-8.455989e-01,  2.391319e-01,  4.772616e-01, -3.575344e-01, -8.921671e-01, -1.596029e-01},
  {-6.708300e-01, -1.299224e-01,  7.301420e-01, -3.023297e-02, -8.833867e-01, -2.533708e-01},
  { 9.674292e-01,  2.126577e-01, -1.373221e-01,  4.221930e-01, -8.665276e-01, -3.083000e-01},
  {-2.516714e-01, -2.124681e-01,  9.442027e-01, -6.734334e-02, -8.904422e-01, -2.741749e-01},
  {-1.514663e-01, -9.208777e-01,  3.592244e-01, -3.972954e-01, -9.621497e-01, -2.914127e-01},
  { 5.280771e-02,  1.051186e-01,  9.930567e-01,  2.142858e-01, -8.897411e-01, -3.250405e-01},
  {-1.044953e-01, -1.499339e-01,  9.831585e-01,  1.721859e-01, -8.948468e-01, -3.316691e-01},
  {-3.060845e-01,  9.302518e-01, -2.023459e-01, -4.407001e-01, -9.113465e-01, -4.340358e-01},
  { 4.886081e-01, -4.283078e-01,  7.601411e-01, -2.863776e-01, -9.405938e-01, -4.288360e-01},
  {-8.909994e-01,  3.369599e-01, -3.042665e-01, -4.221848e-01, -9.204739e-01, -5.040051e-01},
  { 6.338678e-02, -3.182901e-01, -9.458718e-01, -3.563181e-01, -9.285691e-01, -5.522556e-01},
  {-5.706979e-01, -1.767012e-01, -8.019230e-01, -3.916122e-01, -9.125789e-01, -5.443026e-01},
  {-5.970632e-01, -6.800447e-01,  4.255053e-01, -1.295173e-01, -9.173997e-01, -5.349661e-01},
  { 2.910444e-01,  8.704037e-01,  3.971028e-01,  2.174845e-01, -8.470589e-01, -5.673365e-01},
  { 9.315193e-02,  8.532056e-01, -5.131892e-01, -1.492213e-01, -9.070932e-01, -6.310339e-01},
  { 5.141897e-01,  8.448046e-01, -1.480340e-01, -1.766738e-01, -8.992257e-01, -6.503319e-01},
  {-9.192941e-01, -1.148422e-01, -3.764434e-01, -5.068412e-02, -8.992900e-01, -6.537865e-01},
  {-5.344835e-01, -5.835781e-01, -6.113625e-01, -2.549276e-01, -9.083318e-01, -7.490374e-01},
  { 1.105023e-01, -1.791749e-01, -9.775918e-01, -2.344120e-01, -8.841123e-01, -7.665651e-01},
  {-7.191780e-01, -5.658282e-01, -4.032634e-01, -5.960330e-02, -9.265804e-01,  3.332438e-01},
  { 2.553405e-01,  1.600582e-01,  9.535108e-01,  1.475052e-01, -8.946252e-01,  3.965535e-01},
  {-7.834516e-01,  1.696191e-02,  6.212214e-01,  3.817485e-01, -9.618757e-01,  3.251510e-01},
  {-5.055628e-01, -8.602383e-01,  6.630506e-02,  3.698718e-01, -9.555719e-01,  3.100006e-01},
  { 7.957985e-01, -6.046273e-01, -3.362510e-02,  3.985919e-01, -9.566568e-01,  3.096816e-01},
  {-2.077433e-03,  5.563529e-01,  8.309435e-01, -1.789421e-01, -8.900856e-01,  3.084036e-01},
  {-2.112014e-01, -7.162126e-01,  6.651567e-01, -2.399848e-01, -8.981073e-01,  3.102740e-01},
  {-7.136375e-01,  3.602995e-01,  6.007543e-01,  8.212058e-02, -8.513924e-01,  2.235359e-01},
  {-8.920941e-01, -3.205517e-01,  3.184570e-01, -3.522040e-01, -9.224148e-01,  1.349833e-01},
  {-3.415059e-01, -9.237475e-01, -1.733907e-01, -3.031374e-01, -9.728140e-01,  8.573446e-02},
  { 8.232536e-01, -3.461863e-01,  4.498985e-01,  4.159143e-01, -8.662758e-01,  1.292765e-01},
  { 1.230325e-01, -2.693789e-02,  9.920369e-01,  3.793613e-01, -8.765393e-01,  1.381219e-01},
  {-6.935181e-01, -7.195018e-01,  3.673903e-02, -3.785145e-01, -9.236591e-01,  5.297226e-02},
  {-9.318228e-01, -3.228913e-02, -3.614743e-01, -1.681215e-02, -8.653940e-01, -3.531059e-02},
  { 9.972473e-01,  5.178629e-02, -5.306666e-02,  4.051593e-01, -9.100126e-01, -6.654776e-02},
  { 4.745494e-01, -7.574413e-01, -4.484255e-01,  3.693262e-01, -9.195260e-01, -1.079976e-01},
  {-9.867080e-01,  1.231003e-01,  1.060834e-01, -3.683974e-01, -8.766851e-01, -9.213863e-02},
  { 1.349406e-02, -3.586209e-01, -9.333858e-01, -2.259290e-01, -8.934249e-01, -1.294552e-01},
  { 7.113755e-01,  5.525709e-01, -4.342928e-01,  3.985940e-01, -8.385406e-01, -3.144976e-01},
  { 1.368942e-01,  2.426519e-01, -9.604061e-01,  1.000245e-01, -8.700621e-01, -3.102579e-01},
  { 2.463990e-01, -1.382129e-01,  9.592625e-01, -1.393690e-01, -8.941664e-01, -2.732268e-01},
  {-5.242871e-01, -2.747756e-01,  8.059909e-01, -4.330569e-01, -9.076945e-01, -2.310788e-01},
  {-4.544755e-01, -7.790307e-01,  4.319297e-01, -4.001563e-01, -9.346540e-01, -2.475196e-01},
  { 7.461469e-01, -6.307436e-01,  2.131368e-01, -3.207153e-01, -9.322211e-01, -3.724843e-01},
  {-1.872747e-01, -8.502795e-01,  4.918870e-01, -1.893905e-01, -8.977847e-01, -4.249794e-01},
  {-3.026980e-01, -5.604813e-01, -7.708661e-01, -1.947175e-01, -8.921419e-01, -5.032868e-01},
  { 9.237906e-01, -1.822192e-01,  3.367598e-01,  8.345950e-02, -8.621078e-01, -5.144498e-01},
  {-1.890475e-01,  1.235957e-01, -9.741587e-01, -3.668782e-01, -8.904363e-01, -5.538153e-01},
  { 3.897249e-01,  7.518156e-01, -5.318720e-01,  1.797062e-02, -8.696838e-01, -5.775312e-01},
  {-3.906098e-01,  3.418241e-01, -8.547399e-01, -1.395175e-01, -8.843907e-01, -6.072528e-01},
  {-3.270694e-01,  3.915897e-01, -8.600483e-01, -5.941947e-02, -8.870897e-01, -6.560770e-01},
  { 7.980740e-01,  4.979016e-01, -3.393699e-01,  2.132459e-02, -8.709098e-01, -6.906019e-01},
  {-2.532416e-01,  2.876667e-01, -9.236431e-01, -6.684840e-02, -8.897569e-01, -7.230190e-01},
  { 2.969868e-01, -8.227684e-01,  4.846142e-01,  2.237955e-01, -9.057697e-01,  5.636498e-01},
  { 8.939433e-01, -4.170742e-01,  1.640563e-01,  2.455442e-01, -8.951449e-01,  5.548745e-01},
  {-2.902099e-01, -7.109448e-01,  6.405745e-01,  1.513541e-01, -9.180814e-01,  5.473735e-01},
  { 7.808512e-01, -5.767243e-01, -2.401261e-01,  2.278870e-01, -9.104311e-01,  5.225682e-01},
  {-5.607110e-01, -4.439948e-01,  6.989076e-01,  1.089333e-01, -8.954961e-01,  5.419165e-01},
  { 5.103051e-01, -8.148850e-01, -2.748659e-01,  1.982122e-01, -9.231369e-01,  4.960067e-01},
  { 4.679398e-01, -8.712606e-01,  1.481123e-01,  1.536490e-01, -9.390931e-01,  4.719824e-01},
  { 5.708158e-01, -6.659671e-01,  4.802678e-01,  4.014555e-01, -9.312633e-01,  4.416702e-01},
  {-7.572263e-02, -9.963924e-01, -3.831578e-02,  3.686825e-01, -9.478263e-01,  4.144856e-01},
  {-4.825386e-01, -8.736543e-01,  6.232643e-02, -1.005559e-01, -9.079568e-01,  4.137965e-01},
  {-6.845528e-01, -7.266188e-01,  5.841701e-02, -1.236218e-01, -8.954839e-01,  4.143839e-01},
  { 6.201471e-01, -7.621079e-01, -1.860353e-01,  3.921567e-01, -9.433715e-01,  4.120172e-01},
  { 7.337175e-02,  4.993400e-01,  8.632938e-01,  2.337595e-01, -8.467477e-01,  4.225394e-01},
  { 9.243535e-01, -1.346632e-01,  3.569825e-01,  3.914680e-01, -9.455808e-01,  3.369639e-01},
  {-5.364243e-01, -7.919737e-01, -2.915934e-01,  3.698145e-01, -9.300263e-01,  2.287633e-01},
  { 7.568988e-02,  9.908603e-01,  1.116554e-01, -2.784514e-01, -8.922787e-01,  2.846253e-01},
  {-8.922466e-01,  2.714396e-01,  3.608555e-01,  7.881647e-02, -8.581231e-01,  1.484117e-01},
  { 3.103243e-01,  7.524702e-01,  5.809366e-01,  4.080037e-01, -8.543291e-01,  1.335848e-01},
  { 1.515289e-01, -7.833077e-01, -6.028832e-01, -3.027536e-01, -9.516879e-01,  4.987177e-02},
  {-8.399779e-01, -3.519573e-01,  4.129932e-01, -3.781649e-01, -8.991055e-01,  9.187061e-02},
  { 6.925051e-01,  6.246336e-01, -3.609285e-01,  4.066433e-01, -8.556127e-01,  6.716739e-02},
  { 4.720433e-01,  5.355855e-01,  7.002310e-01,  2.756247e-01, -8.460288e-01,  9.035708e-02},
  { 5.143997e-02,  6.305531e-01,  7.744397e-01, -1.199243e-01, -8.905537e-01,  8.108726e-02},
  {-9.945012e-01,  9.431253e-02,  4.552431e-02, -2.088558e-01, -8.750616e-01,  3.041801e-02},
  {-9.015734e-01,  3.031704e-01,  3.086314e-01, -5.163855e-02, -8.514755e-01,  3.678694e-02},
  { 8.686245e-01,  4.852145e-01, -1.002913e-01,  3.372412e-01, -8.654414e-01,  1.101716e-02},
  {-2.777993e-02, -3.526644e-01, -9.353375e-01,  1.718085e-01, -8.832633e-01, -8.039702e-02},
  {-7.475650e-01,  3.268732e-01,  5.781872e-01, -2.036839e-01, -8.520429e-01, -2.020509e-02},
  {-5.052816e-01, -7.444548e-01, -4.364373e-01,  2.977862e-01, -9.025730e-01, -1.447655e-01},
  {-9.213391e-01,  9.683447e-03, -3.886393e-01, -3.717233e-01, -8.488028e-01, -1.151242e-01},
  { 4.051253e-01,  5.284221e-01,  7.460854e-01,  1.763614e-01, -8.388978e-01, -1.937547e-01},
  {-2.528538e-02, -1.459902e-01, -9.889629e-01,  2.327501e-01, -8.435674e-01, -3.040114e-01},
  { 1.248265e-01, -6.755853e-02, -9.898759e-01,  1.256703e-01, -8.757890e-01, -3.044344e-01},
  {-9.539973e-01, -2.618992e-01,  1.459385e-01, -4.643692e-01, -8.541577e-01, -3.284683e-01},
  {-9.739702e-01,  1.851565e-01,  1.307634e-01, -4.672419e-01, -8.550104e-01, -3.462449e-01},
  { 8.242452e-01,  4.842694e-01, -2.934330e-01,  3.225701e-01, -8.495551e-01, -4.343551e-01},
  {-6.306100e-01,  3.070642e-01,  7.127711e-01, -3.542656e-01, -8.845943e-01, -4.417945e-01},
  { 4.364828e-02,  2.435774e-02, -9.987500e-01, -3.427629e-01, -8.745696e-01, -4.376657e-01},
  { 6.126855e-01,  5.588817e-01,  5.588092e-01,  3.476165e-01, -8.340294e-01, -4.550194e-01},
  {-9.094112e-01,  2.597135e-01, -3.248388e-01, -4.030138e-01, -8.665658e-01, -5.225869e-01},
  { 6.729400e-01,  6.432685e-01, -3.651812e-01, -2.367432e-01, -8.516746e-01, -6.527401e-01},
  {-8.597476e-01, -3.007654e-01,  4.127641e-01, -3.528427e-01, -8.805147e-01, -5.943830e-01},
  { 2.152519e-01, -3.590667e-01,  9.081507e-01,  1.917457e-02, -8.408617e-01, -6.782118e-01},
  {-5.006393e-01, -8.541802e-01,  1.404872e-01,  3.395725e-01, -9.341754e-01,  4.580688e-01},
  {-1.991625e-01, -6.201782e-01,  7.587578e-01, -7.378526e-02, -8.690104e-01,  4.606878e-01},
  {-4.014111e-01, -2.977597e-01,  8.661457e-01,  3.949761e-02, -8.689521e-01,  4.352574e-01},
  {-9.321991e-02, -3.282863e-01,  9.399671e-01,  1.952818e-02, -8.715889e-01,  4.392106e-01},
  { 5.430636e-01, -5.352234e-01, -6.470069e-01,  3.980155e-01, -9.104543e-01,  2.013091e-01},
  { 4.876549e-02, -2.984658e-02,  9.983643e-01, -3.140447e-01, -8.857111e-01,  2.504710e-01},
  { 7.063102e-01,  1.448096e-01,  6.929330e-01, -3.347554e-01, -8.416033e-01,  2.623638e-01},
  { 4.369037e-01, -7.877693e-01, -4.342059e-01,  1.483111e-02, -9.063981e-01,  1.742336e-01},
  { 4.034792e-01, -6.725978e-01, -6.203360e-01, -5.016624e-03, -9.130878e-01,  1.708256e-01},
  { 5.029951e-01,  7.480175e-01, -4.329731e-01,  2.429635e-01, -8.279733e-01,  1.006247e-01},
  { 5.365133e-02, -6.748705e-01, -7.359833e-01, -2.312495e-01, -8.994099e-01,  7.142635e-02},
  {-9.954045e-01,  7.091270e-02, -6.435225e-02,  1.518251e-01, -8.550432e-01,  1.248330e-02},
  { 9.639646e-01,  1.691708e-01, -2.053132e-01,  3.415381e-01, -8.641643e-01,  2.271890e-02},
  { 7.039728e-01, -3.088108e-01, -6.395766e-01,  3.202313e-01, -8.528704e-01, -5.705044e-03},
  {-3.312753e-02, -6.970656e-01, -7.162417e-01,  2.292403e-01, -8.808348e-01, -3.502072e-02},
  {-3.297113e-01, -8.158517e-01, -4.750541e-01, -3.970643e-01, -9.000046e-01, -2.067557e-02},
  {-7.419395e-03, -8.162872e-01, -5.775988e-01,  2.299712e-01, -8.675384e-01, -5.000015e-02},
  { 7.518750e-01, -3.748280e-01, -5.423908e-01,  1.007043e-01, -8.429990e-01, -5.497543e-03},
  {-1.378254e-02, -5.762246e-01, -8.171751e-01, -3.921438e-01, -8.942505e-01, -2.459363e-02},
  {-8.448231e-01, -4.508228e-01, -2.881543e-01,  1.257271e-01, -8.485757e-01, -7.379351e-02},
  {-9.455093e-01, -1.842084e-01, -2.684764e-01, -1.524341e-02, -8.357962e-01, -4.469999e-02},
  { 9.176758e-01, -3.967810e-01,  2.088261e-02, -6.203758e-02, -8.491892e-01, -8.299561e-02},
  { 8.795161e-01,  2.861500e-01,  3.802231e-01,  7.848714e-02, -8.353168e-01, -1.067218e-01},
  {-1.657694e-01, -2.978474e-01, -9.401104e-01,  3.704549e-01, -8.528826e-01, -2.156999e-01},
  { 9.467337e-01, -3.202441e-01,  3.375084e-02, -1.025846e-01, -8.604513e-01, -1.452473e-01},
  { 3.077272e-01, -9.514638e-01,  4.555404e-03, -6.151458e-02, -8.647770e-01, -2.254100e-01},
  {-5.293288e-01, -6.529537e-01,  5.417217e-01, -2.974408e-02, -8.615473e-01, -2.382854e-01},
  {-5.973601e-01,  4.690371e-01,  6.505114e-01, -3.611746e-01, -8.407940e-01, -1.921066e-01},
  { 1.861755e-01,  4.082378e-02, -9.816681e-01,  3.460035e-01, -8.080894e-01, -3.422573e-01},
  {-7.183896e-02, -9.617199e-01,  2.644504e-01, -7.472943e-02, -8.578039e-01, -2.631777e-01},
  { 3.439764e-01, -9.389777e-01,  1.067847e-03, -2.613413e-01, -8.740674e-01, -3.433468e-01},
  { 8.234109e-01,  3.300714e-01, -4.615706e-01,  3.997289e-01, -8.409201e-01, -3.651265e-01},
  {-7.876830e-01,  6.072738e-01,  1.037976e-01, -4.709592e-01, -8.343985e-01, -3.893184e-01},
  {-8.173748e-01, -3.262966e-02,  5.751815e-01, -4.584267e-01, -8.317068e-01, -4.407416e-01},
  {-2.699852e-01, -1.033786e-01, -9.572987e-01, -4.363977e-01, -8.317913e-01, -4.596865e-01},
  { 7.926744e-02, -6.631484e-02, -9.946452e-01, -3.228791e-01, -8.560365e-01, -4.479868e-01},
  { 6.844330e-01,  3.050244e-01, -6.622020e-01,  3.487872e-01, -8.312010e-01, -5.287684e-01},
  { 1.635863e-01,  5.412272e-02, -9.850433e-01,  2.946845e-01, -8.321388e-01, -5.477073e-01},
  {-5.603505e-01, -2.981692e-01, -7.727241e-01,  4.179752e-02, -8.401079e-01, -6.459946e-01},
  {-7.728653e-01, -4.455515e-01,  4.518442e-01, -3.744495e-01, -8.481681e-01, -6.112546e-01},
  {-7.728653e-01, -4.455515e-01,  4.518442e-01,  7.185867e-02, -8.351886e-01, -6.648396e-01},
  { 7.415086e-01,  4.416996e-01,  5.050410e-01, -5.064796e-03, -8.105487e-01, -6.604813e-01},
  { 5.363978e-01,  3.805990e-01, -7.532740e-01, -4.260027e-03, -8.258468e-01, -7.054963e-01},
  {-3.557089e-02, -2.499702e-01, -9.675999e-01, -7.728619e-02, -8.700711e-01, -7.276044e-01},
  { 2.637937e-01, -7.830076e-01,  5.633045e-01,  3.477812e-01, -8.723825e-01,  5.395966e-01},
  { 8.120710e-01, -2.289349e-01, -5.367770e-01,  2.059365e-01, -8.747196e-01,  4.791749e-01},
  {-8.938091e-01, -4.324785e-01, -1.186065e-01, -1.378480e-01, -8.690946e-01,  4.287166e-01},
  { 9.411004e-01, -2.227452e-01, -2.543911e-01,  4.189221e-01, -8.720793e-01,  4.052818e-01},
  {-5.740014e-01, -6.530826e-02, -8.162459e-01, -1.032443e-01, -8.596385e-01,  3.747894e-01},
  { 8.592904e-01,  3.049354e-01,  4.106512e-01,  3.772016e-01, -8.944976e-01,  3.580244e-01},
  {-7.612147e-01, -5.237678e-01, -3.823867e-01,  1.429561e-01, -8.315063e-01,  2.500694e-01},
  {-9.764328e-03,  6.097018e-01,  7.925708e-01, -2.779180e-01, -8.122454e-01,  2.830790e-01},
  { 3.883458e-01, -4.015163e-01, -8.294409e-01,  3.746709e-01, -8.772599e-01,  1.668216e-01},
  { 8.914165e-01, -4.518403e-01, -3.488444e-02,  3.965900e-02, -8.861182e-01,  1.808164e-01},
  { 4.443679e-01,  6.618105e-01,  6.037748e-01, -1.992843e-01, -8.192365e-01,  1.958293e-01},
  { 4.770026e-01, -5.981439e-01, -6.439662e-01, -9.245868e-03, -8.794636e-01,  1.265883e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -1.855424e-01, -8.218842e-01,  1.761281e-01},
  {-8.458074e-01, -2.645605e-01,  4.632683e-01, -4.002914e-01, -8.715239e-01,  6.420895e-02},
  { 9.653170e-01, -1.115739e-01,  2.360391e-01,  4.051732e-01, -8.327475e-01, -5.084506e-02},
  {-4.204659e-01, -7.935418e-01, -4.398861e-01,  2.491217e-01, -8.726128e-01, -1.462997e-01},
  { 8.899046e-01, -2.553920e-01, -3.779480e-01,  3.936237e-01, -8.526854e-01, -1.980723e-01},
  {-8.861705e-01, -1.629077e-02, -4.630727e-01, -3.582051e-01, -8.273442e-01, -1.438373e-01},
  { 1.198861e-01, -6.168279e-01, -7.779143e-01, -1.862520e-01, -8.140388e-01, -1.699331e-01},
  {-8.462930e-01,  5.310239e-01,  4.244654e-02, -1.843536e-01, -8.241597e-01, -1.963066e-01},
  {-5.814259e-01,  6.406682e-01,  5.014858e-01, -3.847874e-01, -8.270171e-01, -2.373780e-01},
  { 6.280414e-01, -2.407169e-01, -7.400131e-01, -2.886539e-01, -8.175293e-01, -4.314661e-01},
  { 6.797194e-01, -7.334543e-01, -5.119384e-03,  8.103776e-02, -8.273112e-01, -4.491759e-01},
  {-7.571174e-01, -6.134937e-01,  2.244967e-01, -2.230880e-01, -8.557410e-01, -4.994916e-01},
  { 2.491228e-01, -9.443921e-01, -2.146195e-01,  1.196107e-01, -7.995541e-01, -5.265414e-01},
  {-3.059151e-01,  2.143178e-01, -9.276227e-01, -5.218582e-02, -8.126048e-01, -5.546568e-01},
  {-8.601250e-02,  4.715023e-01, -8.776603e-01, -1.763518e-01, -8.135979e-01, -5.781469e-01},
  { 7.458984e-01, -5.559758e-02,  6.637353e-01,  1.321157e-01, -7.789024e-01, -6.029001e-01},
  { 4.277638e-01,  5.663992e-01, -7.044217e-01, -3.108946e-01, -8.007282e-01, -7.447613e-01},
  {-1.252388e-01, -2.000726e-01, -9.717439e-01, -1.489131e-01, -8.300000e-01, -7.475748e-01},
  {-1.675905e-01, -5.136423e-01,  8.414779e-01,  3.381339e-01, -8.500971e-01,  5.736827e-01},
  {-4.919770e-01, -6.347765e-01,  5.958335e-01,  2.956826e-01, -8.652237e-01,  5.454433e-01},
  {-5.918196e-01, -7.361153e-01,  3.284567e-01,  2.915751e-01, -8.983064e-01,  4.662417e-01},
  { 2.652038e-01,  7.294195e-01,  6.305665e-01,  4.304507e-01, -8.274351e-01,  4.623368e-01},
  {-1.431307e-01, -6.806940e-01,  7.184492e-01,  2.918486e-02, -8.292355e-01,  4.770515e-01},
  { 9.557948e-01,  2.927478e-01, -2.748057e-02,  2.104175e-01, -8.037941e-01,  2.888502e-01},
  { 4.128171e-01, -4.449125e-01,  7.947547e-01,  2.288044e-02, -8.673739e-01,  3.069779e-01},
  { 8.937300e-01, -2.301657e-01,  3.850591e-01,  3.908373e-02, -8.657419e-01,  2.926053e-01},
  { 2.995012e-02, -9.922372e-01,  1.206996e-01,  1.382988e-02, -8.875971e-01,  2.767500e-01},
  { 5.934825e-01, -8.003265e-01, -8.518239e-02,  3.712108e-02, -8.854680e-01,  2.645313e-01},
  {-3.909769e-01, -7.903849e-01, -4.716234e-01,  3.448531e-01, -8.894026e-01,  1.847797e-01},
  { 8.386114e-01, -3.107064e-01, -4.474287e-01,  4.119626e-01, -8.407905e-01,  1.967263e-01},
  {-8.673069e-01,  7.610160e-02,  4.919220e-01, -3.343708e-01, -8.031342e-01,  2.539325e-01},
  { 5.668712e-01, -3.147945e-01, -7.612894e-01,  3.274844e-02, -8.631754e-01,  1.442390e-01},
  { 3.686370e-01, -7.059036e-01,  6.048197e-01,  2.267110e-01, -8.035305e-01,  1.175262e-01},
  {-5.744337e-01, -4.957560e-01,  6.513462e-01, -3.489107e-01, -8.344239e-01,  1.060312e-01},
  { 8.281808e-01, -2.511482e-01, -5.010400e-01,  4.121695e-01, -8.243687e-01,  3.101874e-02},
  { 5.167243e-01, -4.620271e-01, -7.207822e-01,  3.695609e-01, -8.229480e-01,  4.951789e-03},
  {-6.842059e-01, -5.759337e-01, -4.473955e-01,  1.457963e-01, -8.294393e-01,  1.376905e-03},
  { 8.363251e-02, -4.293534e-01, -8.992560e-01, -2.183639e-01, -8.322420e-01, -1.212402e-03},
  {-3.330948e-02, -8.781956e-01, -4.771403e-01,  1.999723e-01, -8.473172e-01, -8.750454e-02},
  {-9.395481e-01, -8.533943e-02,  3.316122e-01, -2.016577e-01, -8.070527e-01, -3.503129e-02},
  { 5.103931e-01,  1.780643e-01,  8.413037e-01,  3.172248e-01, -8.170466e-01, -4.301934e-02},
  {-7.793517e-01, -5.824125e-01,  2.310987e-01, -1.707667e-02, -8.164734e-01, -7.271037e-02},
  {-5.520390e-01,  4.097261e-01,  7.262075e-01, -3.028181e-01, -7.822420e-01, -7.626028e-02},
  {-2.137479e-01,  2.275078e-01, -9.500274e-01,  2.748508e-01, -8.305005e-01, -1.808732e-01},
  { 1.411174e-02,  3.352884e-01, -9.420099e-01,  3.805916e-01, -8.375155e-01, -2.146054e-01},
  { 9.864938e-02, -8.948361e-01,  4.353581e-01, -7.628827e-02, -8.400459e-01, -1.749975e-01},
  { 6.244301e-01,  2.852764e-01,  7.271208e-01,  2.447991e-01, -7.887284e-01, -2.579396e-01},
  { 6.810127e-01,  3.621622e-01, -6.364433e-01,  3.164080e-01, -7.674435e-01, -3.342718e-01},
  { 2.445319e-01, -1.698567e-01, -9.546480e-01,  2.298772e-01, -7.875910e-01, -4.668553e-01},
  {-6.246597e-01,  1.027024e-02, -7.808295e-01,  1.365570e-02, -7.810807e-01, -6.354835e-01},
  { 1.313593e-01,  2.845673e-01, -9.496137e-01,  9.050029e-02, -7.853168e-01, -6.615523e-01},
  { 3.812214e-01,  6.553160e-01, -6.520975e-01, -5.052369e-02, -7.994658e-01, -7.025304e-01},
  {-4.664171e-01, -7.384859e-01, -4.869226e-01, -1.921529e-01, -8.277507e-01, -7.321025e-01},
  { 2.341068e-01,  4.955340e-01, -8.364449e-01, -9.713939e-02, -8.106276e-01, -7.320998e-01},
  {-4.802732e-01, -1.679545e-02, -8.769581e-01, -3.248747e-01, -7.914950e-01, -7.342911e-01},
  { 4.364874e-01, -6.519963e-01,  6.199836e-01,  2.219311e-01, -8.238984e-01,  6.262177e-01},
  {-6.703739e-01, -1.527136e-01,  7.261386e-01,  1.742585e-01, -8.283423e-01,  5.691522e-01},
  {-2.621273e-01, -3.333623e-01,  9.056262e-01, -4.569813e-02, -8.019004e-01,  5.230035e-01},
  {-1.018017e-01,  3.845035e-01,  9.174931e-01,  4.543503e-02, -7.766441e-01,  5.217932e-01},
  {-3.229069e-01, -6.764732e-02, -9.440100e-01,  1.179968e-04, -8.223853e-01,  3.679321e-01},
  {-5.575899e-03, -9.959524e-01, -8.970942e-02, -1.605958e-01, -8.734820e-01,  3.460428e-01},
  { 2.126946e-01, -5.757076e-01,  7.895074e-01, -5.570981e-02, -8.592964e-01,  3.258577e-01},
  {-3.038132e-01, -8.037935e-01, -5.114817e-01, -5.820530e-02, -8.698877e-01,  2.848589e-01},
  { 6.148819e-01, -7.838682e-01,  8.643429e-02,  2.047463e-01, -7.780836e-01,  2.676945e-01},
  { 9.520701e-01, -8.149718e-02,  2.948233e-01,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  {-9.307008e-01, -2.671109e-01,  2.498956e-01,  1.160478e-01, -7.952085e-01,  2.267317e-01},
  {-5.827960e-01, -7.852165e-01, -2.092462e-01,  2.931879e-01, -8.373290e-01,  1.382651e-01},
  {-8.290745e-02, -4.663588e-01, -8.807019e-01,  3.096974e-01, -8.346157e-01,  1.298719e-01},
  { 3.169088e-01, -7.664318e-01, -5.587049e-01,  2.277820e-01, -7.974953e-01,  1.356428e-01},
  {-7.940242e-01,  1.556308e-01,  5.876263e-01,  6.857234e-02, -7.874438e-01,  9.779448e-02},
  { 9.813217e-01, -8.546510e-02,  1.723470e-01, -8.982255e-02, -8.143793e-01,  1.706625e-02},
  { 8.295754e-01,  4.546981e-01, -3.241207e-01,  2.780817e-01, -7.893898e-01, -1.034742e-02},
  {-6.523435e-01, -7.356690e-01, -1.823156e-01, -4.416551e-01, -8.678545e-01, -1.718633e-02},
  { 8.074951e-01, -4.912111e-01,  3.265935e-01, -8.164360e-02, -8.027271e-01, -1.824952e-02},
  {-5.463647e-01, -3.224374e-01, -7.729941e-01,  1.478532e-01, -8.103496e-01, -1.353538e-01},
  {-3.533658e-02, -9.855387e-01, -1.657253e-01, -5.938868e-02, -8.137622e-01, -1.004959e-01},
  { 3.621716e-01, -9.295591e-01, -6.893110e-02, -6.624820e-02, -8.105757e-01, -1.119773e-01},
  {-1.661595e-01,  4.067729e-01, -8.982911e-01,  2.182887e-01, -7.976554e-01, -1.640778e-01},
  {-6.868544e-01,  7.107729e-01, -1.517660e-01, -3.439538e-01, -7.965132e-01, -1.441807e-01},
  {-3.847686e-01, -1.799337e-01, -9.053050e-01, -2.944773e-01, -8.044934e-01, -1.941808e-01},
  { 5.003139e-01,  6.521080e-02,  8.633849e-01,  1.225634e-01, -7.742069e-01, -1.727503e-01},
  { 2.045551e-01,  5.919709e-01, -7.795689e-01,  2.444825e-01, -7.670867e-01, -3.583080e-01},
  {-1.317400e-01, -3.732896e-01, -9.183134e-01,  1.128713e-01, -8.072541e-01, -3.590605e-01},
  { 3.638867e-01,  7.879922e-01, -4.966435e-01,  3.107189e-02, -7.799681e-01, -4.460575e-01},
  { 5.407858e-01,  8.364107e-01, -8.926290e-02,  3.140444e-01, -7.627618e-01, -5.008240e-01},
  { 7.320149e-01,  5.182726e-01,  4.422076e-01,  9.000579e-02, -7.638833e-01, -4.927033e-01},
  {-7.225120e-01, -6.057501e-01, -3.332314e-01, -4.013190e-01, -8.054783e-01, -4.945859e-01},
  { 6.154183e-02, -1.708576e-01, -9.833719e-01,  2.008664e-01, -8.070708e-01, -5.696148e-01},
  { 2.530659e-01, -9.530081e-01, -1.665326e-01, -5.932211e-02, -7.708737e-01, -5.451498e-01},
  {-5.225373e-01, -7.978036e-01,  3.007728e-01, -4.172451e-01, -7.984430e-01, -5.117909e-01},
  {-8.537853e-01, -4.950286e-01,  1.612369e-01, -3.048322e-01, -8.012711e-01, -5.531423e-01},
  {-8.858749e-01, -4.619708e-01,  4.252934e-02, -3.893309e-01, -8.075715e-01, -6.175094e-01},
  { 2.566210e-01,  6.569809e-01, -7.088877e-01, -1.017168e-01, -7.596432e-01, -6.596682e-01},
  { 4.508037e-01, -4.920669e-01,  7.447457e-01,  2.676438e-01, -7.909193e-01,  6.515792e-01},
  { 9.815881e-01, -1.899463e-01,  2.012991e-02,  1.616586e-01, -7.866992e-01,  4.012235e-01},
  {-3.151523e-01, -3.254945e-02,  9.484828e-01, -1.666776e-01, -8.542502e-01,  4.190156e-01},
  {-5.719556e-01, -8.202842e-01, -7.873597e-04, -4.334200e-02, -7.920970e-01,  3.833595e-01},
  {-6.260111e-01, -5.555102e-01,  5.472828e-01, -2.042026e-01, -8.458897e-01,  4.068341e-01},
  {-7.413802e-01, -6.459289e-01, -1.820199e-01, -1.911955e-01, -8.514013e-01,  3.305011e-01},
  { 2.325327e-01,  6.506920e-01,  7.228612e-01, -2.326401e-01, -7.522842e-01,  1.871745e-01},
  { 2.595569e-01, -2.612447e-01, -9.297212e-01,  8.557462e-03, -7.728520e-01,  3.286284e-02},
  { 6.356189e-01,  3.875508e-01,  6.676772e-01,  2.712503e-01, -7.744091e-01, -1.192177e-02},
  { 2.186029e-01, -4.707976e-01, -8.547294e-01, -3.838444e-01, -8.355142e-01, -6.704266e-02},
  {-2.594872e-01, -6.559130e-01, -7.088332e-01, -4.279127e-01, -8.477935e-01, -8.151639e-02},
  {-6.208834e-01, -7.813683e-01,  6.298574e-02, -4.672685e-02, -8.015792e-01, -3.118063e-02},
  {-2.620955e-01,  3.998574e-01, -8.783052e-01,  1.257238e-01, -7.737275e-01, -1.243953e-01},
  {-6.488854e-01,  6.128597e-01,  4.509443e-01, -2.613558e-01, -7.498403e-01, -6.760328e-02},
  { 8.680820e-01,  1.864176e-01, -4.600893e-01,  3.922941e-01, -7.857406e-01, -1.506020e-01},
  {-2.690888e-01,  6.742239e-01, -6.877597e-01,  3.672728e-01, -8.133974e-01, -1.731155e-01},
  {-1.108488e-01, -8.429742e-01,  5.264096e-01,  3.816118e-01, -8.112080e-01, -1.758549e-01},
  { 4.208897e-01,  4.650614e-02,  9.059189e-01,  1.015504e-01, -7.634510e-01, -1.666694e-01},
  {-8.929543e-01, -4.077357e-01,  1.907464e-01, -1.712571e-01, -7.655979e-01, -2.330543e-01},
  { 7.145976e-01,  6.484556e-01, -2.624037e-01,  2.790065e-01, -7.374728e-01, -3.126618e-01},
  {-2.297071e-01,  6.034980e-01, -7.635607e-01,  1.316428e-01, -7.706977e-01, -3.616480e-01},
  {-5.317299e-01, -5.231182e-01,  6.660411e-01, -3.276559e-01, -7.945959e-01, -3.569550e-01},
  {-5.072128e-01, -5.799129e-01,  6.375235e-01, -3.759754e-01, -7.893716e-01, -3.773402e-01},
  {-4.134618e-02,  9.098146e-02,  9.949939e-01,  2.366287e-01, -7.621493e-01, -3.851586e-01},
  {-2.079103e-01,  2.385814e-01, -9.486054e-01, -4.291933e-01, -7.640558e-01, -4.556406e-01},
  { 5.035043e-01,  2.810382e-01, -8.170074e-01,  3.592107e-01, -7.287763e-01, -4.302598e-01},
  { 6.385201e-01,  7.610602e-01,  1.143649e-01,  2.618385e-01, -7.507838e-01, -5.306776e-01},
  { 7.624135e-01,  5.642631e-01, -3.167535e-01,  2.548328e-01, -7.413919e-01, -5.351633e-01},
  {-3.593653e-01, -8.814012e-01,  3.065756e-01, -3.414261e-01, -7.869523e-01, -5.723289e-01},
  { 6.135839e-03,  7.131463e-02, -9.974350e-01, -2.039496e-01, -7.928013e-01, -7.437143e-01},
  {-3.638424e-02, -2.820858e-01,  9.586990e-01,  2.183851e-01, -7.898113e-01,  6.623658e-01},
  { 3.313878e-01,  8.026171e-01,  4.959717e-01,  3.557267e-01, -7.810398e-01,  4.400957e-01},
  {-9.355103e-02, -4.137667e-01, -9.055636e-01, -1.018803e-01, -7.890490e-01,  3.802248e-01},
  {-7.579052e-01, -6.415866e-01, -1.180942e-01,  2.603604e-01, -7.838810e-01,  3.798343e-01},
  {-3.419871e-01, -8.644106e-01, -3.685637e-01, -5.891141e-02, -7.812388e-01,  3.810968e-01},
  { 3.971096e-01, -3.467677e-01, -8.497389e-01,  3.966707e-01, -8.178249e-01,  3.328171e-01},
  { 9.632387e-01, -2.668199e-01,  3.128065e-02,  2.113368e-01, -7.621132e-01,  3.182544e-01},
  { 7.504652e-01, -6.494046e-01,  1.227829e-01,  2.139731e-01, -7.666932e-01,  2.979578e-01},
  {-2.829695e-01, -9.363517e-01,  2.077831e-01,  2.642607e-01, -7.806895e-01,  2.053038e-01},
  {-2.408413e-01, -9.352135e-01,  2.595595e-01,  2.549836e-01, -7.797834e-01,  1.951641e-01},
  {-6.832649e-01, -5.971675e-01, -4.201666e-01, -1.011112e-02, -8.112773e-01,  2.191204e-01},
  {-7.403341e-02, -9.409125e-01,  3.304586e-01,  2.341025e-01, -7.833062e-01,  1.735689e-01},
  { 6.197077e-01, -1.946030e-01,  7.603237e-01, -3.432073e-01, -7.521589e-01,  1.758652e-01},
  {-8.628043e-01,  5.068389e-02,  5.029910e-01, -3.575515e-01, -7.742161e-01,  1.690304e-01},
  {-9.609632e-02, -1.584060e-02,  9.952459e-01, -3.690818e-01, -8.064537e-01,  1.493229e-01},
  { 7.089365e-01, -4.470813e-01, -5.454607e-01,  2.518061e-01, -7.733427e-01,  9.570503e-02},
  {-2.650939e-01, -4.035836e-01,  8.756971e-01, -3.787763e-01, -8.170177e-01,  1.449098e-01},
  {-3.398080e-01, -8.327134e-01,  4.371716e-01, -4.501257e-01, -8.212406e-01,  1.032262e-01},
  {-6.635157e-01, -6.593760e-01,  3.535112e-01, -4.541870e-01, -8.202934e-01,  9.528461e-02},
  {-8.884974e-01, -4.588816e-01,  3.197178e-04, -4.999585e-01, -7.838122e-01, -9.305446e-03},
  { 8.150006e-01,  1.220033e-01,  5.664710e-01,  7.036185e-02, -7.425728e-01, -1.477745e-01},
  {-3.797502e-01, -9.232112e-01,  5.891440e-02,  3.549432e-01, -8.260735e-01, -2.052758e-01},
  {-1.739801e-01, -8.839104e-01, -4.340892e-01,  3.916545e-01, -8.374389e-01, -2.353142e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.779038e-01, -7.639193e-01, -2.138485e-01},
  {-5.153373e-01, -6.728243e-01, -5.307870e-01, -1.787575e-01, -7.624854e-01, -2.223147e-01},
  { 7.158511e-01, -4.623636e-01, -5.232370e-01,  3.951132e-01, -8.156040e-01, -2.632325e-01},
  { 7.970701e-01,  3.321989e-01,  5.043045e-01,  2.195656e-01, -7.165693e-01, -2.079000e-01},
  {-4.100807e-01, -7.608776e-01,  5.028907e-01, -2.023802e-01, -7.458681e-01, -2.801913e-01},
  { 7.345268e-03,  7.223135e-01, -6.915268e-01,  1.952715e-01, -7.223359e-01, -3.425660e-01},
  {-5.890189e-01, -7.636399e-01,  2.644062e-01, -4.124536e-01, -7.768624e-01, -3.945789e-01},
  {-9.586098e-02, -4.049463e-01, -9.093015e-01,  2.045172e-01, -7.488258e-01, -4.788222e-01},
  {-3.257793e-01,  8.217435e-01, -4.675525e-01, -2.675797e-01, -7.499256e-01, -4.355713e-01},
  {-7.724602e-01, -5.127445e-01,  3.746974e-01, -4.500759e-01, -7.701861e-01, -5.084743e-01},
  { 2.598873e-01,  6.623130e-01, -7.027090e-01, -2.429043e-01, -7.525013e-01, -5.529402e-01},
  {-5.800853e-01, -7.731748e-01,  2.563233e-01, -3.714170e-01, -7.783610e-01, -5.680918e-01},
  { 9.084440e-01, -4.135468e-01,  6.089731e-02, -2.484256e-02, -7.419323e-01, -5.879028e-01},
  { 4.870796e-02,  5.212808e-01, -8.519941e-01, -3.471877e-01, -7.279263e-01, -7.176082e-01},
  {-6.853908e-01, -7.277124e-01, -2.596362e-02, -2.446687e-01, -7.832637e-01, -7.234714e-01},
  { 7.754642e-01,  3.164622e-01,  5.463579e-01,  3.576706e-01, -7.751659e-01,  6.163588e-01},
  {-5.362800e-01,  1.204447e-01,  8.354023e-01,  1.229106e-01, -7.703194e-01,  6.392759e-01},
  { 1.433813e-01, -8.320361e-01,  5.358711e-01,  3.080537e-01, -7.870892e-01,  6.168188e-01},
  {-4.428805e-02, -8.707440e-01,  4.897379e-01,  3.381518e-01, -7.976139e-01,  5.991663e-01},
  {-2.425865e-02,  7.362081e-01,  6.763203e-01,  1.649803e-01, -7.813631e-01,  5.312180e-01},
  {-2.438474e-01, -9.615443e-01,  1.263758e-01,  2.456776e-01, -7.694010e-01,  5.031718e-01},
  { 2.716662e-01,  9.371288e-01,  2.190593e-01,  1.347185e-01, -7.409768e-01,  4.701645e-01},
  { 5.938027e-02,  6.281473e-01,  7.758254e-01, -6.782657e-02, -7.265517e-01,  5.031934e-01},
  {-1.458871e-01,  6.262736e-01,  7.658317e-01, -1.202138e-01, -7.108167e-01,  4.883009e-01},
  {-5.689877e-01,  6.471185e-02,  8.197960e-01, -1.797000e-01, -7.227795e-01,  4.717576e-01},
  {-2.650841e-01,  5.606362e-01,  7.844855e-01,  3.572563e-01, -7.593066e-01,  4.105860e-01},
  { 1.056326e-01,  8.711344e-01,  4.795485e-01,  7.913485e-02, -7.273410e-01,  4.100535e-01},
  {-6.999493e-01,  3.520447e-01,  6.213980e-01, -2.164956e-01, -7.201376e-01,  4.285268e-01},
  { 5.765787e-01, -7.750477e-01,  2.585696e-01, -1.242169e-01, -7.951277e-01,  3.688496e-01},
  { 6.531801e-01, -5.603431e-01,  5.092852e-01, -1.387852e-01, -8.073250e-01,  3.701777e-01},
  {-4.396949e-01,  8.434543e-01,  3.086313e-01, -2.014478e-01, -6.912946e-01,  4.372989e-01},
  { 8.454517e-01, -2.813163e-01, -4.539521e-01,  4.245922e-01, -7.726747e-01,  3.447370e-01},
  {-9.726623e-01,  2.306349e-01, -2.712451e-02, -2.506043e-01, -7.479256e-01,  3.295005e-01},
  { 9.028637e-01,  3.199358e-01,  2.871900e-01,  3.108694e-01, -7.463759e-01,  3.050541e-01},
  {-6.096315e-01, -3.591177e-01, -7.066710e-01,  9.745229e-02, -7.505605e-01,  2.370188e-01},
  { 6.487386e-01,  5.022139e-01,  5.717688e-01,  3.212874e-01, -7.287267e-01,  2.526404e-01},
  { 9.970236e-01, -7.704430e-02,  2.856329e-03,  4.259647e-01, -7.328252e-01,  2.009619e-01},
  {-7.859546e-01, -5.386838e-01, -3.034717e-01, -2.306111e-02, -7.860781e-01,  2.072077e-01},
  { 6.327717e-01, -5.725858e-01, -5.212922e-01,  4.135615e-01, -7.776944e-01,  1.412195e-01},
  { 2.869312e-01, -4.816014e-01, -8.280885e-01,  3.115055e-01, -7.540737e-01,  1.235666e-01},
  { 6.450639e-01, -7.573303e-01, -1.017025e-01,  3.705576e-02, -7.679860e-01,  1.143105e-01},
  {-7.998742e-01, -4.492760e-01,  3.979350e-01,  7.216673e-02, -7.513477e-01,  1.212144e-01},
  { 3.075345e-01, -9.067793e-01,  2.883986e-01, -4.844332e-02, -7.607313e-01,  1.354369e-02},
  {-8.580942e-01, -7.042291e-03, -5.134439e-01, -2.049783e-01, -7.511976e-01,  1.105984e-04},
  {-1.210903e-01, -4.547934e-01, -8.823266e-01, -4.295966e-01, -8.032019e-01, -1.177550e-01},
  {-7.702485e-01, -3.033742e-01, -5.609645e-01,  1.008724e-01, -7.538195e-01, -1.032420e-01},
  {-6.430019e-01, -1.977645e-01, -7.398903e-01, -4.660225e-01, -7.750402e-01, -1.109626e-01},
  {-5.174082e-01, -8.555946e-01, -1.570396e-02,  2.083913e-01, -7.427842e-01, -8.847255e-02},
  {-7.231064e-01, -4.955434e-01, -4.812005e-01,  3.144056e-01, -7.782915e-01, -1.372955e-01},
  {-8.589849e-01,  4.733170e-01,  1.952329e-01, -1.974241e-01, -7.260047e-01, -1.598986e-01},
  {-3.630086e-01, -8.408648e-01, -4.014612e-01,  3.323406e-01, -8.172680e-01, -2.414911e-01},
  { 5.308244e-01,  7.623324e-01,  3.702364e-01,  1.993931e-01, -6.937904e-01, -1.924338e-01},
  {-8.187633e-01, -4.958151e-01, -2.894723e-01, -2.456786e-01, -7.515448e-01, -2.366325e-01},
  { 2.095595e-01, -9.516394e-01,  2.246493e-01, -3.952161e-01, -7.981928e-01, -1.725135e-01},
  {-3.479748e-01, -3.660153e-01,  8.631027e-01, -4.476033e-01, -7.793142e-01, -1.641444e-01},
  {-8.569356e-01, -3.505693e-01,  3.778393e-01, -4.939712e-01, -7.620368e-01, -1.854457e-01},
  {-9.351516e-01, -6.914975e-02,  3.474329e-01, -5.010314e-01, -7.313180e-01, -1.849435e-01},
  {-6.546958e-01, -7.146109e-01,  2.463832e-01, -4.849979e-01, -7.937122e-01, -2.137717e-01},
  {-1.239976e-01, -9.804820e-01,  1.525762e-01, -4.465299e-01, -8.168795e-01, -2.312407e-01},
  { 4.399100e-01,  4.617141e-02, -8.968542e-01,  1.271378e-02, -7.351706e-01, -3.237192e-01},
  { 4.119692e-01,  6.154262e-01, -6.719613e-01,  2.491615e-01, -7.116993e-01, -3.253917e-01},
  {-4.657709e-01, -8.473424e-01, -2.550848e-01, -4.750710e-01, -7.900984e-01, -3.298308e-01},
  {-9.595395e-01,  3.886342e-02, -2.788793e-01, -4.848122e-01, -7.506143e-01, -3.719869e-01},
  { 8.066396e-01,  1.868625e-01, -5.607271e-01,  1.412803e-04, -7.421876e-01, -3.441440e-01},
  { 2.059749e-01, -9.274529e-01,  3.120987e-01, -2.981347e-01, -7.622254e-01, -3.266113e-01},
  {-8.433005e-01,  3.227807e-02, -5.364722e-01, -4.620281e-01, -7.303881e-01, -4.222215e-01},
  { 8.243972e-01,  5.658879e-01, -1.184148e-02,  3.775597e-01, -7.045463e-01, -3.931974e-01},
  { 8.937466e-02,  5.555038e-01, -8.266969e-01, -3.706576e-01, -7.190718e-01, -4.327858e-01},
  {-8.245131e-01, -5.229070e-01, -2.162094e-01, -2.661766e-01, -7.630248e-01, -7.095659e-01},
  { 3.059871e-01,  2.168427e-01,  9.270120e-01,  3.034456e-01, -7.416579e-01,  6.407041e-01},
  { 3.173915e-01, -9.264606e-01, -2.023199e-01,  1.789457e-01, -7.493268e-01,  3.943365e-01},
  { 3.986512e-01, -6.179665e-02,  9.150183e-01,  3.350413e-01, -7.260026e-01,  3.964039e-01},
  {-3.910403e-01, -9.105406e-01, -1.341769e-01,  2.223929e-01, -7.373194e-01,  3.615765e-01},
  { 1.816247e-01,  8.543741e-01,  4.868852e-01, -1.544794e-01, -7.032835e-01,  3.967645e-01},
  {-9.498177e-01,  1.309319e-01,  2.840831e-01, -2.327342e-01, -6.999924e-01,  3.982628e-01},
  {-3.941457e-01,  8.026270e-01,  4.477041e-01, -2.264029e-01, -6.886480e-01,  3.974037e-01},
  { 7.257457e-02,  9.408989e-01,  3.308204e-01, -1.297261e-01, -7.175707e-01,  3.698786e-01},
  { 7.397788e-01, -2.227495e-01,  6.349093e-01,  2.555124e-02, -7.426490e-01,  2.950259e-01},
  {-9.163000e-01, -1.175217e-01, -3.828616e-01, -2.098899e-01, -7.400918e-01,  1.982350e-01},
  { 5.801491e-01, -4.767638e-01, -6.603963e-01,  4.000807e-01, -7.730831e-01,  1.157301e-01},
  { 2.043691e-01, -9.780959e-01, -3.951727e-02,  3.189455e-01, -7.378523e-01,  1.215477e-01},
  { 3.538217e-01, -5.193409e-01,  7.778787e-01,  2.801364e-01, -7.448717e-01,  9.652611e-02},
  {-8.368178e-02,  5.934920e-01,  8.004777e-01, -1.254678e-01, -7.167090e-01,  9.788399e-02},
  { 3.308497e-01, -5.345469e-01, -7.776877e-01, -2.738914e-01, -7.401453e-01, -1.382994e-02},
  { 6.699259e-01,  3.441555e-01, -6.578421e-01,  2.500344e-01, -7.209271e-01,  1.961551e-02},
  { 5.920703e-01, -2.241715e-01, -7.740800e-01, -3.355502e-01, -7.649106e-01, -4.918638e-02},
  {-8.767192e-01,  8.867106e-03, -4.809208e-01, -5.095208e-01, -7.294679e-01, -5.414934e-02},
  {-3.306967e-01, -4.881603e-01, -8.076752e-01,  1.004973e-01, -7.432680e-01, -1.083001e-01},
  { 2.718830e-01, -6.273568e-01, -7.297281e-01,  8.265351e-02, -7.400107e-01, -6.681632e-02},
  { 3.299933e-01, -2.946922e-02,  9.435232e-01,  3.342605e-01, -7.054312e-01, -2.020680e-02},
  { 5.936769e-01,  4.027998e-01,  6.966349e-01,  3.872114e-01, -7.128496e-01, -3.458420e-02},
  {-2.541150e-01,  2.528179e-01, -9.335462e-01,  2.506599e-01, -7.482728e-01, -1.017366e-01},
  { 9.106942e-01,  3.972039e-01,  1.134247e-01,  4.071700e-01, -7.302143e-01, -1.341044e-01},
  { 9.818428e-01,  1.884606e-01,  2.162073e-02,  4.092103e-01, -7.194081e-01, -1.407672e-01},
  {-5.895693e-01, -7.980521e-01, -1.245831e-01,  3.020884e-01, -7.551860e-01, -1.403899e-01},
  { 3.395307e-01,  8.319642e-02,  9.369084e-01,  1.624631e-01, -7.078829e-01, -1.599638e-01},
  {-2.201671e-01, -1.281428e-01,  9.670087e-01, -4.006374e-01, -7.676906e-01, -1.478711e-01},
  {-3.879537e-01, -6.699333e-01, -6.329938e-01,  3.503912e-01, -7.868970e-01, -2.791343e-01},
  { 4.136740e-01, -7.903897e-01,  4.518385e-01, -3.568841e-01, -7.829413e-01, -1.724395e-01},
  { 2.817360e-01,  9.557683e-01,  8.445078e-02,  2.233744e-01, -6.852394e-01, -2.463373e-01},
  { 6.758242e-01,  7.342916e-01,  6.385586e-02,  2.399445e-01, -6.952410e-01, -2.960408e-01},
  {-2.786919e-01, -9.592845e-01,  4.586888e-02, -3.489888e-01, -7.699337e-01, -3.138504e-01},
  {-1.836587e-01,  7.563661e-01, -6.278374e-01, -4.247002e-01, -7.040396e-01, -4.232274e-01},
  { 8.750381e-01,  4.518597e-01, -1.735835e-01,  3.610805e-01, -6.936030e-01, -3.928589e-01},
  {-7.391270e-01, -3.813204e-01, -5.552350e-01,  1.160097e-01, -7.287658e-01, -5.830628e-01},
  { 2.802482e-01,  4.313871e-02, -9.589578e-01, -2.199656e-01, -6.983465e-01, -5.187576e-01},
  {-9.517574e-01, -6.475174e-03,  3.067833e-01, -4.773539e-01, -7.059269e-01, -5.088999e-01},
  { 4.469289e-01,  8.053573e-01, -3.894282e-01, -3.036723e-01, -6.911137e-01, -6.059853e-01},
  {-3.229173e-01, -9.065832e-01, -2.717195e-01, -1.276924e-01, -7.280589e-01, -6.044495e-01},
  {-7.152922e-01, -5.683652e-01, -4.065932e-01, -4.490497e-01, -7.236714e-01, -6.329789e-01},
  { 7.981548e-01,  3.901800e-01,  4.590299e-01,  2.499429e-01, -6.922293e-01,  4.582198e-01},
  { 6.131780e-02,  9.862017e-01,  1.537735e-01, -7.170392e-02, -6.942843e-01,  4.328507e-01},
  {-4.966580e-01,  5.764285e-01,  6.488923e-01,  9.692344e-02, -7.000734e-01,  3.792644e-01},
  {-3.220609e-01,  8.174539e-01,  4.775416e-01, -3.127522e-02, -6.753361e-01,  3.997817e-01},
  { 1.961092e-01, -7.193781e-01,  6.663606e-01,  2.126240e-01, -7.410231e-01,  3.370678e-01},
  { 6.769375e-01, -4.346215e-01, -5.940200e-01,  4.283623e-01, -7.306007e-01,  2.857923e-01},
  { 8.492035e-01,  5.280641e-01, -1.334915e-03,  3.104547e-01, -7.112241e-01,  2.850818e-01},
  { 8.837027e-01,  2.221158e-01,  4.119881e-01,  1.858299e-02, -7.432512e-01,  2.705402e-01},
  {-2.830949e-02, -9.007171e-01, -4.334826e-01,  4.989926e-02, -7.227693e-01,  2.521286e-01},
  { 7.983145e-01, -5.506409e-01, -2.439029e-01,  8.196565e-02, -7.266506e-01,  1.819761e-01},
  {-4.423670e-01, -7.239336e-01, -5.293689e-01, -5.053854e-02, -7.300080e-01,  1.804244e-01},
  { 2.489289e-01,  7.252209e-01,  6.419417e-01,  4.257550e-01, -6.570602e-01,  2.070226e-01},
  {-6.498842e-01, -7.579774e-01, -5.586372e-02, -8.072792e-02, -7.006863e-01,  1.152458e-01},
  {-8.010379e-01, -2.646655e-01,  5.369268e-01, -4.557471e-01, -7.415089e-01,  1.141140e-01},
  { 1.286898e-01, -1.365818e-01,  9.822344e-01, -3.801940e-01, -7.520489e-01,  1.278238e-01},
  { 4.149267e-01,  2.398212e-01, -8.776797e-01,  3.832617e-01, -7.048606e-01,  3.682994e-04},
  {-6.518067e-01,  7.054724e-01, -2.783106e-01, -1.771915e-01, -7.136503e-01, -9.763553e-03},
  {-8.325531e-01,  3.508657e-01, -4.286591e-01, -5.153273e-01, -7.028062e-01, -2.300785e-02},
  { 4.137921e-01, -1.536672e-01, -8.973085e-01, -3.615177e-01, -7.421330e-01, -1.245421e-01},
  {-4.099338e-01,  5.040100e-01, -7.602159e-01, -4.362344e-01, -7.197192e-01, -1.113810e-01},
  {-3.712133e-01,  4.139575e-01, -8.311678e-01, -4.166472e-01, -7.094501e-01, -1.142598e-01},
  {-4.863707e-01,  3.247072e-01,  8.111774e-01, -1.526004e-01, -6.973622e-01, -9.686951e-02},
  {-5.631939e-01, -7.336358e-01, -3.802513e-01,  2.154787e-01, -7.322527e-01, -1.436024e-01},
  { 3.911954e-01, -3.601778e-01,  8.468990e-01, -3.330261e-01, -7.411706e-01, -1.380142e-01},
  {-2.884265e-01, -4.678206e-01, -8.354364e-01,  3.753937e-01, -7.514295e-01, -3.220567e-01},
  { 6.887360e-02,  9.971040e-01, -3.224835e-02,  1.646421e-01, -6.796985e-01, -2.446165e-01},
  {-6.362868e-02, -3.280921e-01,  9.425004e-01, -4.779319e-01, -6.371254e-01, -2.146137e-01},
  {-5.922092e-01,  2.309451e-01,  7.719797e-01, -5.183271e-01, -6.270902e-01, -2.219189e-01},
  {-9.470359e-01, -3.107046e-01, -8.115266e-02, -5.287133e-01, -6.343846e-01, -2.330247e-01},
  { 4.924359e-01, -7.632714e-01,  4.182387e-01, -2.789377e-01, -7.362235e-01, -2.664464e-01},
  { 6.882602e-02,  9.884200e-01, -1.352368e-01, -5.232871e-01, -6.449023e-01, -2.560784e-01},
  {-4.327421e-02, -8.971666e-02, -9.950268e-01,  9.849744e-02, -7.031555e-01, -3.443161e-01},
  {-3.294978e-01,  8.668748e-01, -3.741111e-01, -4.581942e-01, -6.918073e-01, -3.632940e-01},
  {-7.477486e-01,  3.981540e-01, -5.313619e-01, -2.510301e-01, -6.985283e-01, -3.799570e-01},
  { 1.157727e-01,  8.593665e-02,  9.895512e-01,  3.067211e-01, -6.887940e-01, -3.284399e-01},
  { 9.164332e-01,  2.667250e-01, -2.983421e-01, -7.072745e-03, -7.002776e-01, -4.307188e-01},
  {-8.684285e-01, -1.768581e-01,  4.631989e-01, -2.540461e-01, -7.077263e-01, -4.141889e-01},
  {-3.290321e-01, -2.677409e-01,  9.055676e-01, -3.518568e-01, -7.117544e-01, -4.779844e-01},
  {-4.276053e-01, -3.484535e-01,  8.341066e-01, -4.183820e-01, -7.106529e-01, -4.862701e-01},
  {-2.961258e-01, -1.222397e-01, -9.472946e-01,  1.275460e-01, -7.010113e-01, -5.952256e-01},
  { 2.100507e-01,  9.774735e-01,  2.059603e-02, -3.285415e-01, -6.695737e-01, -6.153160e-01},
  { 4.039777e-01,  8.544607e-01, -3.266482e-01, -3.277422e-01, -6.770629e-01, -6.445649e-01},
  { 1.666435e-01,  7.732952e-01, -6.117552e-01, -3.534995e-01, -6.810958e-01, -6.692879e-01},
  {-5.075202e-01,  6.500915e-01, -5.655123e-01, -4.304792e-01, -6.946136e-01, -6.586718e-01},
  {-4.311536e-01, -7.167373e-01,  5.480824e-01,  1.430009e-01, -7.112315e-01,  7.058353e-01},
  { 3.901516e-02,  8.699206e-01,  4.916462e-01,  2.398249e-01, -6.679623e-01,  5.760616e-01},
  { 3.902758e-01,  9.109361e-01,  1.337172e-01,  2.676076e-01, -6.498966e-01,  5.458229e-01},
  {-9.863671e-01, -8.575135e-02,  1.404511e-01,  1.107326e-01, -6.933615e-01,  4.015258e-01},
  {-5.899836e-01,  8.035182e-01, -7.923299e-02, -2.191062e-01, -6.819913e-01,  3.504463e-01},
  {-3.908992e-01,  8.724186e-01,  2.934000e-01, -1.854160e-01, -6.623515e-01,  3.575670e-01},
  {-6.390558e-01,  7.439414e-01, -1.953428e-01, -1.744629e-01, -6.819990e-01,  2.848360e-01},
  { 4.991801e-01,  7.456678e-01, -4.413600e-01,  2.287886e-01, -6.734442e-01,  2.215788e-01},
  {-3.566199e-01, -6.713654e-01, -6.496851e-01, -1.889973e-01, -6.996232e-01,  1.527363e-01},
  { 7.585694e-01,  6.255036e-01,  1.825315e-01,  4.271556e-01, -6.395288e-01,  1.673128e-01},
  { 7.507375e-01, -5.067016e-01, -4.238474e-01,  3.876917e-01, -7.278774e-01,  8.837588e-02},
  {-1.701639e-01,  5.039715e-01,  8.467922e-01, -1.011348e-01, -6.934341e-01,  8.892155e-02},
  { 4.382445e-01, -3.626608e-01,  8.224468e-01, -3.352034e-01, -7.144618e-01,  1.088627e-01},
  { 7.580487e-01,  9.630662e-03, -6.521269e-01,  4.152214e-01, -6.875267e-01,  1.457985e-02},
  {-8.020604e-01,  2.287867e-01, -5.516845e-01, -5.204220e-01, -6.593153e-01,  2.554990e-02},
  { 2.692268e-01, -8.794784e-01, -3.924725e-01,  1.504210e-01, -7.046726e-01, -9.830129e-02},
  { 9.468557e-01, -3.039089e-01, -1.053736e-01,  3.581030e-01, -6.900181e-01, -6.930938e-02},
  {-3.122032e-01, -2.928034e-01, -9.037673e-01, -1.244572e-01, -6.754497e-01, -8.147820e-02},
  { 3.951457e-01,  8.044371e-01,  4.435547e-01,  3.352099e-01, -6.931412e-01, -1.376212e-01},
  { 7.619286e-01, -5.341543e-01, -3.662568e-01,  7.382044e-02, -6.984716e-01, -1.299868e-01},
  {-3.528679e-01,  5.689856e-01,  7.427918e-01, -3.672398e-01, -7.199420e-01, -1.497975e-01},
  { 7.551517e-02, -9.794015e-01,  1.872705e-01, -2.909548e-01, -7.208834e-01, -1.458749e-01},
  { 6.862822e-01, -4.387614e-01,  5.800907e-01,  1.606936e-01, -6.752504e-01, -2.206149e-01},
  {-2.276179e-01,  5.354403e-01,  8.133227e-01, -3.978001e-01, -6.973194e-01, -2.119126e-01},
  { 1.039091e-01,  8.886374e-01,  4.466840e-01, -4.549907e-01, -6.540734e-01, -2.298256e-01},
  { 9.857042e-01,  2.900612e-02, -1.659694e-01,  3.837919e-01, -7.354206e-01, -3.276883e-01},
  { 4.764479e-01, -6.430359e-01,  5.995851e-01, -2.722284e-01, -7.031857e-01, -2.338725e-01},
  {-4.089529e-01,  8.220944e-01, -3.961291e-01, -4.671691e-01, -6.581713e-01, -2.918188e-01},
  {-1.608524e-01,  8.670193e-01, -4.715974e-01, -5.031988e-01, -6.462144e-01, -2.457321e-01},
  {-7.485822e-02,  8.437941e-01, -5.314206e-01, -3.691083e-01, -6.657642e-01, -3.454337e-01},
  { 1.000424e-01, -5.238201e-02,  9.936033e-01, -1.642181e-04, -6.851586e-01, -3.438312e-01},
  { 8.221847e-01, -3.306472e-02,  5.682597e-01, -8.088635e-03, -6.727185e-01, -4.497942e-01},
  { 7.658221e-01, -1.098592e-01,  6.335989e-01,  4.484507e-02, -6.799069e-01, -4.785064e-01},
  { 2.175727e-01,  4.404231e-01, -8.710279e-01, -2.487596e-01, -6.446325e-01, -5.507244e-01},
  { 3.978470e-01,  4.818790e-01, -7.807114e-01, -2.810112e-01, -6.532820e-01, -5.752102e-01},
  {-8.664592e-01,  4.986216e-01, -2.500254e-02, -4.897748e-01, -6.771632e-01, -5.374932e-01},
  { 1.801852e-01, -8.404495e-01, -5.110557e-01, -2.171534e-02, -7.452116e-01, -6.600624e-01},
  { 3.983993e-01, -9.072067e-01,  1.351075e-01, -2.263406e-02, -7.446630e-01, -6.393925e-01},
  {-1.721107e-01, -7.999743e-01, -5.748208e-01, -6.596115e-02, -7.390990e-01, -6.567883e-01},
  { 2.757837e-01, -5.342821e-01,  7.990531e-01,  2.893291e-01, -7.078568e-01,  7.716099e-01},
  {-4.701737e-01, -3.810048e-01,  7.960981e-01,  1.590243e-01, -6.944651e-01,  7.284433e-01},
  {-9.650123e-02, -9.564829e-01,  2.753687e-01,  2.636734e-01, -7.395315e-01,  6.978868e-01},
  {-8.621000e-02, -9.788975e-01,  1.852766e-01,  2.163551e-01, -7.356865e-01,  6.733513e-01},
  {-1.756340e-01, -8.865271e-01, -4.280447e-01,  1.612766e-01, -7.263125e-01,  6.679686e-01},
  {-3.521225e-01, -8.518823e-01, -3.876935e-01,  1.276694e-01, -7.164714e-01,  6.673496e-01},
  {-3.662076e-01, -2.204738e-01,  9.040373e-01,  1.789759e-02, -6.858868e-01,  6.180242e-01},
  {-3.135127e-01, -2.640942e-01,  9.121206e-01,  4.259003e-01, -7.327082e-01,  5.253302e-01},
  { 3.135127e-01,  2.640942e-01, -9.121206e-01,  3.728820e-01, -7.460018e-01,  5.032578e-01},
  {-5.692583e-01, -7.886047e-01, -2.324814e-01,  3.111386e-02, -7.260758e-01,  5.167829e-01},
  { 1.742505e-01, -4.346952e-01,  8.835592e-01,  2.728687e-01, -6.842725e-01,  4.350574e-01},
  { 4.302353e-02, -8.509259e-01,  5.235208e-01, -3.208654e-01, -7.369258e-01,  3.384063e-01},
  {-7.347095e-01, -6.525924e-01, -1.852703e-01, -3.540114e-01, -7.441611e-01,  3.081980e-01},
  {-1.170745e-01,  8.512024e-01,  5.116131e-01, -1.359133e-01, -6.618457e-01,  2.718591e-01},
  {-1.187446e-01, -9.861832e-01, -1.155099e-01, -3.341889e-01, -7.538399e-01,  2.946166e-01},
  { 8.193784e-01,  5.727442e-01, -2.415042e-02,  4.255479e-01, -6.347141e-01,  1.418476e-01},
  { 2.372822e-01,  9.189138e-01,  3.151105e-01,  2.958631e-01, -6.645774e-01,  1.460103e-01},
  { 2.231234e-01, -9.702261e-01,  9.421864e-02, -4.002149e-01, -7.635477e-01,  2.010398e-01},
  {-1.022829e-01,  7.392933e-01,  6.655701e-01,  2.905233e-01, -6.673147e-01,  1.116022e-01},
  { 9.771261e-01,  8.044001e-02, -1.968606e-01,  2.768514e-01, -6.569188e-01,  1.063555e-01},
  { 7.212259e-01, -6.523228e-01,  2.330411e-01, -3.965075e-01, -7.631144e-01,  1.808676e-01},
  { 7.481433e-01, -4.739547e-01,  4.643797e-01, -3.591312e-01, -7.122679e-01,  1.163110e-01},
  {-4.608651e-01,  4.494472e-01, -7.652454e-01, -5.003102e-01, -6.446885e-01,  7.918642e-03},
  {-6.339395e-01,  1.529497e-01, -7.581076e-01, -4.544940e-01, -6.561694e-01,  1.334778e-03},
  { 5.971388e-02, -2.398571e-01, -9.689699e-01, -2.610753e-01, -7.023047e-01, -7.241041e-02},
  {-6.054517e-01,  5.220789e-01, -6.007178e-01, -4.111196e-01, -6.856724e-01, -4.589504e-02},
  {-2.045256e-01, -9.665948e-01,  1.544791e-01,  1.758485e-01, -7.032916e-01, -8.395340e-02},
  {-3.951457e-01, -8.044372e-01, -4.435547e-01,  3.218640e-01, -6.846022e-01, -1.412183e-01},
  {-5.696766e-01, -6.852094e-01, -4.538245e-01,  1.967761e-01, -7.155370e-01, -1.536326e-01},
  { 3.408103e-03, -3.359210e-01, -9.418840e-01,  3.713324e-01, -7.164105e-01, -3.328039e-01},
  {-4.884722e-01, -8.714056e-01,  4.524546e-02, -2.317747e-01, -6.753682e-01, -2.264891e-01},
  { 3.894998e-01, -9.203714e-01, -3.473453e-02, -2.606490e-01, -6.768444e-01, -2.123932e-01},
  { 1.341790e-02,  9.924693e-01,  1.217563e-01, -4.933974e-01, -6.440951e-01, -2.503717e-01},
  { 8.611137e-01,  4.085022e-01,  3.026702e-01, -5.159207e-01, -6.170954e-01, -2.422548e-01},
  {-1.574497e-01,  7.312845e-01, -6.636509e-01, -2.905163e-01, -6.592252e-01, -3.067050e-01},
  { 4.969349e-01,  1.564053e-01,  8.535767e-01,  3.099087e-01, -6.674418e-01, -3.247928e-01},
  {-9.947373e-01, -8.326913e-02, -5.969711e-02, -2.499790e-01, -6.769239e-01, -3.781917e-01},
  {-3.556677e-01, -8.338897e-01,  4.220526e-01, -4.103710e-01, -6.486007e-01, -4.090253e-01},
  {-9.047360e-01, -4.127923e-01,  1.051443e-01, -4.502591e-01, -6.527304e-01, -4.237190e-01},
  { 7.613655e-01,  1.926332e-01, -6.190437e-01,  2.870061e-01, -6.830449e-01, -5.014825e-01},
  { 1.272690e-01,  9.144850e-01,  3.840832e-01,  2.569252e-01, -6.716134e-01, -5.187328e-01},
  { 7.564522e-01,  2.259926e-01,  6.137649e-01,  2.117135e-01, -6.650108e-01, -5.194720e-01},
  {-9.047360e-01, -4.127923e-01,  1.051443e-01, -4.627765e-01, -6.350921e-01, -4.621804e-01},
  {-7.031621e-01,  3.076172e-01, -6.410419e-01, -1.835695e-01, -6.664466e-01, -5.295564e-01},
  { 5.702146e-01, -8.170430e-01,  8.541685e-02, -2.349602e-02, -6.963323e-01, -5.703210e-01},
  {-8.915018e-01,  2.364516e-01,  3.864131e-01, -1.895822e-01, -6.659497e-01, -5.535510e-01},
  { 6.342601e-01, -4.322604e-01, -6.409875e-01,  2.534348e-02, -7.191350e-01, -6.578158e-01},
  {-4.350287e-01, -7.834269e-01, -4.438381e-01, -1.613517e-01, -6.706989e-01, -6.539301e-01},
  { 3.832409e-01, -1.682295e-01, -9.081989e-01,  2.212727e-03, -7.134618e-01, -6.724098e-01},
  {-9.266919e-01, -2.313897e-01, -2.961434e-01, -3.137123e-01, -6.812953e-01, -6.985496e-01},
  {-6.655090e-01, -7.288813e-01,  1.607168e-01,  9.698968e-02, -6.956796e-01,  6.780037e-01},
  { 8.156117e-01, -4.014398e-01,  4.166818e-01,  4.091988e-01, -7.072176e-01,  6.157732e-01},
  {-8.145145e-01, -5.624781e-01,  1.420728e-01, -2.475265e-02, -6.841566e-01,  5.599681e-01},
  {-6.241738e-01, -7.377129e-01,  2.572679e-01,  3.311357e-01, -7.346210e-01,  4.815913e-01},
  { 8.270981e-01, -5.406482e-01, -1.536501e-01,  4.273812e-01, -6.904742e-01,  4.257478e-01},
  {-1.907981e-02, -9.889535e-01, -1.469928e-01,  3.642888e-01, -7.166885e-01,  4.284958e-01},
  {-6.166542e-01, -4.324150e-01,  6.578410e-01,  2.838752e-01, -6.710227e-01,  4.461423e-01},
  { 1.013868e-01, -7.511634e-01,  6.522838e-01,  2.543369e-01, -6.537445e-01,  4.478439e-01},
  { 6.886944e-01,  6.948470e-01, -2.070935e-01,  4.211380e-01, -6.414390e-01,  3.470423e-01},
  {-6.687171e-01, -5.007205e-01,  5.496329e-01,  8.069664e-02, -6.412172e-01,  3.451873e-01},
  { 6.687530e-01,  6.975256e-01, -2.573469e-01,  4.234471e-01, -6.494309e-01,  2.617959e-01},
  { 5.155977e-01,  6.346297e-01, -5.756772e-01,  4.070752e-01, -6.352600e-01,  2.583770e-01},
  { 2.013709e-01, -4.126149e-01,  8.883685e-01, -3.047947e-01, -6.754791e-01,  3.945048e-01},
  { 4.796521e-01, -7.675468e-01,  4.252125e-01, -2.788163e-01, -7.121424e-01,  3.482608e-01},
  {-2.525841e-01,  7.138893e-01,  6.531181e-01, -1.847639e-02, -6.434495e-01,  2.902824e-01},
  { 6.545833e-01, -1.287285e-01, -7.449494e-01,  2.061306e-01, -6.345934e-01,  2.170788e-01},
  { 5.943639e-01, -8.033459e-01, -3.697358e-02, -2.734416e-01, -7.230675e-01,  2.392873e-01},
  { 8.374603e-01,  4.623314e-01, -2.913933e-01,  4.195202e-01, -6.345009e-01,  9.637618e-02},
  { 7.308290e-01,  4.757407e-01, -4.894485e-01,  4.117635e-01, -6.303636e-01,  8.822206e-02},
  { 3.918101e-02,  9.979948e-01,  4.971145e-02,  3.593060e-01, -6.124431e-01,  1.056645e-01},
  {-7.776278e-01,  7.568508e-02,  6.241529e-01, -5.137480e-01, -6.583945e-01,  1.119848e-01},
  { 4.111395e-01, -8.947574e-01,  1.742802e-01, -2.691788e-01, -6.570535e-01,  8.852836e-02},
  {-9.499769e-01,  3.108804e-01, -2.995338e-02, -5.453009e-01, -6.434246e-01,  7.453614e-02},
  {-5.495645e-01,  8.354287e-01, -6.145919e-03, -5.377350e-01, -6.389638e-01,  6.779420e-02},
  {-7.654319e-01,  2.260266e-01, -6.025163e-01, -3.887254e-01, -6.837709e-01, -1.124682e-01},
  { 2.118921e-01, -8.668880e-01, -4.512281e-01, -3.677509e-01, -6.850427e-01, -1.202861e-01},
  { 6.270173e-02, -1.446312e-01,  9.874970e-01, -2.904577e-01, -6.627620e-01, -1.084898e-01},
  { 7.964690e-01, -1.846890e-01, -5.757838e-01,  4.003330e-01, -6.765825e-01, -3.399979e-01},
  { 7.946334e-02, -9.830229e-01,  1.653829e-01, -4.255934e-01, -6.492051e-01, -2.423792e-01},
  {-1.225436e-01, -6.945199e-01, -7.089607e-01, -4.149312e-01, -6.533560e-01, -2.721746e-01},
  {-9.458398e-01,  1.609618e-01, -2.819189e-01, -2.675891e-01, -6.534186e-01, -3.097409e-01},
  {-6.390409e-01, -3.387032e-03, -7.691653e-01,  7.670776e-02, -6.452163e-01, -4.452796e-01},
  {-4.270487e-01,  7.772833e-01,  4.620174e-01, -4.273142e-01, -6.195743e-01, -4.195433e-01},
  { 5.365696e-01, -8.336563e-01,  1.308068e-01,  6.534949e-02, -6.898343e-01, -5.260596e-01},
  { 2.198560e-01, -9.664131e-01,  1.330756e-01, -7.383616e-03, -6.878709e-01, -5.753515e-01},
  { 8.316699e-01, -5.384952e-01, -1.354550e-01,  8.475406e-02, -6.968665e-01, -5.978698e-01},
  { 6.896819e-01, -6.750379e-01, -2.620354e-01,  6.763777e-02, -6.921243e-01, -6.269613e-01},
  { 3.152291e-01, -1.779537e-03, -9.490139e-01, -6.122784e-02, -6.824391e-01, -6.898738e-01},
  {-1.289997e-01, -5.480509e-01, -8.264377e-01, -9.142257e-02, -6.981181e-01, -6.980632e-01},
  { 2.322804e-01, -2.849710e-01, -9.299663e-01, -1.942517e-01, -6.617919e-01, -6.855534e-01},
  {-7.861654e-01, -2.871095e-01,  5.472771e-01, -2.919867e-01, -6.708625e-01, -6.487675e-01},
  {-3.515639e-01, -4.689008e-01,  8.102684e-01,  2.091073e-01, -6.616612e-01,  7.664077e-01},
  { 6.452463e-01, -1.039932e-01,  7.568637e-01,  3.366092e-01, -6.697136e-01,  7.508081e-01},
  { 5.251551e-01, -1.136495e-01,  8.433836e-01,  3.134893e-01, -6.646889e-01,  7.602580e-01},
  {-4.453131e-01,  1.764849e-01,  8.778095e-01,  1.439152e-01, -6.668997e-01,  7.139269e-01},
  { 1.594027e-01, -9.456993e-01, -2.832728e-01,  3.479033e-01, -7.153346e-01,  6.569644e-01},
  {-1.310735e-02,  6.114083e-01,  7.912068e-01,  2.747573e-02, -6.247807e-01,  5.915764e-01},
  { 8.867753e-02,  6.741642e-01,  7.332387e-01,  2.124028e-01, -5.926940e-01,  4.797950e-01},
  { 3.225035e-01,  9.242057e-01,  2.045368e-01,  3.452005e-01, -6.452410e-01,  3.388366e-01},
  { 1.955457e-01,  9.549387e-01, -2.232798e-01,  3.348930e-01, -6.441216e-01,  3.504836e-01},
  {-4.531368e-01, -1.589186e-01,  8.771613e-01, -3.404003e-01, -6.169963e-01,  4.155810e-01},
  {-4.881465e-01,  8.280810e-01,  2.756717e-01, -1.368459e-01, -6.143064e-01,  3.104761e-01},
  { 6.863148e-01, -8.417221e-02,  7.224175e-01, -2.441366e-01, -6.784834e-01,  3.576568e-01},
  {-7.434921e-01, -3.504733e-01,  5.695506e-01, -3.959007e-01, -6.732414e-01,  3.425850e-01},
  { 5.562599e-01,  4.176967e-01, -7.184040e-01,  3.495392e-01, -6.252564e-01,  2.227891e-01},
  { 9.636539e-02, -2.575352e-01, -9.614516e-01,  3.213499e-01, -6.388619e-01,  2.156660e-01},
  {-8.409836e-01,  5.088825e-01,  1.838076e-01, -4.513030e-01, -6.354421e-01,  2.347276e-01},
  { 8.722644e-01,  4.274853e-02,  4.871626e-01,  1.912950e-01, -6.274648e-01,  1.874957e-01},
  {-6.967161e-01,  7.132323e-01,  7.672215e-02, -1.075023e-01, -6.271588e-01,  2.073996e-01},
  { 5.332137e-01, -8.072532e-01, -2.530321e-01, -2.517045e-01, -6.875742e-01,  1.791708e-01},
  { 3.587061e-01, -8.842885e-01,  2.989378e-01,  2.462152e-01, -6.352830e-01,  1.699464e-01},
  { 9.556948e-01,  2.528927e-01, -1.506412e-01,  2.552291e-01, -6.389992e-01,  1.481373e-01},
  { 3.807678e-01, -9.111272e-01, -1.576810e-01, -3.213137e-01, -6.698545e-01,  1.440865e-01},
  { 8.107133e-01,  1.421088e-01,  5.679340e-01,  2.575090e-01, -6.363202e-01,  1.073715e-01},
  {-7.104294e-01,  6.592481e-01,  2.463374e-01, -4.773705e-01, -6.282601e-01,  1.264308e-01},
  {-4.050470e-01, -6.275681e-01,  6.649024e-01, -1.108447e-01, -6.510523e-01,  8.143628e-02},
  {-4.089881e-03, -9.754316e-01,  2.202645e-01, -1.728726e-01, -6.318306e-01,  6.179241e-02},
  { 6.026444e-01, -7.959238e-01,  5.766090e-02,  2.378524e-01, -6.213066e-01,  2.645844e-02},
  { 7.607957e-01, -1.903709e-01,  6.204426e-01,  2.404436e-01, -6.390294e-01, -8.745088e-03},
  {-8.550187e-01, -4.247107e-01, -2.975969e-01, -4.468102e-01, -6.509201e-01, -2.648693e-02},
  { 1.652299e-01, -4.069235e-01,  8.983943e-01,  2.589735e-01, -6.448205e-01, -1.406059e-02},
  { 4.805200e-01, -4.778978e-01, -7.353327e-01,  3.899914e-01, -6.522366e-01, -1.457670e-01},
  {-7.702845e-01, -8.258148e-02, -6.323307e-01,  2.635432e-01, -6.479201e-01, -2.686958e-01},
  {-2.827478e-01,  2.726721e-01,  9.196215e-01, -3.592575e-01, -6.512489e-01, -2.257269e-01},
  { 6.371700e-02,  9.973387e-01, -3.543624e-02, -3.958724e-01, -6.526742e-01, -2.298988e-01},
  { 2.290137e-01,  9.302092e-01, -2.868164e-01, -4.316677e-01, -6.520817e-01, -2.565584e-01},
  { 2.404595e-01, -5.628955e-01, -7.907767e-01,  1.524673e-01, -6.643927e-01, -3.343942e-01},
  { 6.253310e-01, -2.185872e-01,  7.491199e-01, -3.778349e-03, -6.415772e-01, -3.204200e-01},
  {-5.036137e-01, -2.286130e-01,  8.331322e-01, -3.048927e-01, -6.300586e-01, -3.458111e-01},
  {-1.314555e-01,  4.354737e-01,  8.905516e-01,  2.798097e-01, -6.327283e-01, -3.360381e-01},
  { 4.960599e-01, -5.890673e-01, -6.379061e-01, -3.939670e-01, -6.183928e-01, -3.712470e-01},
  { 4.960599e-01, -5.890673e-01, -6.379061e-01, -4.167784e-01, -6.260457e-01, -3.819189e-01},
  { 8.852087e-01,  3.821971e-01,  2.651999e-01,  3.376156e-01, -6.296812e-01, -3.804511e-01},
  {-1.445694e-01,  2.652881e-01,  9.532691e-01,  2.112073e-01, -6.239218e-01, -3.895992e-01},
  {-4.449744e-01,  3.678063e-01, -8.165271e-01, -2.369728e-01, -6.163697e-01, -4.313248e-01},
  {-5.884261e-01,  6.249887e-01,  5.129756e-01, -4.465232e-01, -6.274181e-01, -4.038065e-01},
  {-4.862377e-01,  8.718361e-01,  5.894666e-02, -2.104394e-01, -6.239235e-01, -4.657313e-01},
  {-8.252887e-02,  8.797266e-01, -4.682627e-01, -3.250335e-01, -6.203706e-01, -4.649751e-01},
  { 4.832316e-02, -2.820142e-01, -9.581925e-01, -1.241253e-01, -6.570409e-01, -7.061721e-01},
  {-7.839637e-01,  6.079360e-01,  1.257564e-01,  1.787377e-01, -6.399919e-01,  7.099506e-01},
  {-8.031812e-01,  5.953231e-01, -2.214752e-02,  7.082949e-02, -6.371205e-01,  7.200576e-01},
  {-4.498109e-01, -6.424675e-01,  6.204076e-01,  6.114548e-02, -6.506410e-01,  7.078196e-01},
  {-8.315922e-01, -4.871447e-01,  2.667291e-01,  3.373908e-01, -6.799883e-01,  5.392378e-01},
  {-7.933133e-01, -2.009029e-02,  6.084821e-01, -4.211321e-02, -6.321943e-01,  5.423316e-01},
  { 8.666055e-01,  4.913732e-01, -8.687536e-02,  4.478469e-01, -5.941237e-01,  4.394511e-01},
  { 7.120877e-01,  5.037859e-01, -4.890102e-01,  2.834902e-01, -6.118318e-01,  3.565468e-01},
  { 6.877745e-01,  5.955588e-01,  4.150612e-01, -2.976497e-01, -5.968211e-01,  3.950569e-01},
  {-2.986132e-01,  8.243320e-01,  4.809437e-01, -1.133292e-01, -5.952996e-01,  2.897925e-01},
  {-5.819685e-01,  4.791511e-01,  6.570592e-01,  2.470891e-02, -5.914460e-01,  2.713566e-01},
  {-8.726179e-01,  3.741597e-01,  3.139148e-01, -4.483878e-01, -6.177374e-01,  2.728146e-01},
  {-4.104509e-01,  8.710909e-01,  2.696858e-01, -8.822213e-02, -6.075568e-01,  2.002573e-01},
  {-9.684732e-01, -1.985973e-01, -1.503956e-01, -1.734404e-01, -6.246006e-01,  1.701521e-01},
  { 5.800161e-01, -7.918434e-01, -1.912204e-01, -2.251413e-01, -6.629022e-01,  1.544047e-01},
  {-6.169004e-01, -7.559984e-01, -2.188613e-01, -1.214885e-01, -6.407542e-01,  8.467221e-02},
  {-2.922980e-01,  2.542261e-01,  9.219170e-01,  2.944641e-01, -5.834815e-01,  9.218831e-02},
  {-6.257482e-01,  7.427844e-01, -2.381394e-01, -4.571436e-01, -6.006963e-01,  7.574620e-03},
  {-6.257482e-01,  7.427844e-01, -2.381394e-01, -2.970421e-01, -6.266226e-01, -5.635662e-02},
  { 8.425134e-01, -3.996536e-01, -3.611761e-01, -3.255359e-01, -6.426864e-01, -7.649279e-02},
  {-9.040098e-01,  2.584629e-01,  3.405339e-01, -4.658284e-01, -6.138933e-01, -4.206423e-03},
  {-9.835065e-01,  3.399922e-02, -1.776485e-01, -1.248191e-01, -6.203189e-01, -6.829353e-02},
  { 7.767666e-01, -5.671420e-01, -2.738312e-01,  4.167140e-01, -6.644561e-01, -1.070894e-01},
  { 6.221017e-01, -7.442293e-01, -2.431303e-01,  9.225385e-02, -6.571549e-01, -1.252121e-01},
  {-4.506887e-01, -8.856407e-01,  1.118931e-01, -5.364549e-01, -6.857219e-01, -1.061124e-01},
  { 8.075905e-02, -9.600479e-01, -2.679293e-01, -4.377495e-01, -6.905754e-01, -1.583200e-01},
  { 8.567051e-01, -3.041888e-03, -5.157976e-01,  3.320725e-01, -6.292059e-01, -1.612554e-01},
  {-1.779840e-01, -9.120065e-01, -3.695482e-01, -4.973056e-01, -6.778105e-01, -1.725253e-01},
  { 7.667599e-01, -4.871661e-01,  4.180294e-01,  3.341088e-01, -6.209718e-01, -1.719620e-01},
  {-5.228957e-01,  8.454739e-01,  1.084159e-01, -2.679495e-01, -6.442618e-01, -1.222754e-01},
  { 1.476333e-01, -9.607851e-01,  2.347265e-01, -4.709105e-01, -6.524378e-01, -2.333340e-01},
  {-1.595250e-01,  4.025789e-01, -9.013777e-01,  2.135118e-02, -6.284162e-01, -2.988810e-01},
  {-4.794676e-01,  8.775513e-01,  3.807128e-03, -4.362999e-01, -6.090732e-01, -4.248395e-01},
  {-8.735121e-01, -1.911047e-01, -4.477227e-01,  9.907503e-02, -5.932289e-01, -4.827814e-01},
  { 7.269104e-01,  5.512335e-01,  4.095643e-01,  3.455373e-02, -6.124911e-01, -4.797673e-01},
  { 9.485255e-01,  1.114890e-01,  2.964276e-01,  8.170840e-02, -6.411244e-01, -5.455293e-01},
  { 4.180007e-01,  4.729862e-01, -7.756026e-01, -5.315253e-02, -6.328021e-01, -6.228623e-01},
  { 7.821734e-01,  2.487381e-01, -5.712566e-01, -5.658671e-02, -6.333345e-01, -6.654702e-01},
  { 7.544350e-02, -8.096036e-02, -9.938580e-01, -1.477298e-01, -6.364701e-01, -7.103847e-01},
  {-3.477780e-01, -2.647758e-01,  8.994133e-01,  2.374521e-01, -6.264160e-01,  8.013887e-01},
  { 4.115734e-01, -7.386974e-02,  9.083781e-01,  8.387040e-02, -6.193360e-01,  7.251745e-01},
  {-9.810640e-01, -1.053325e-01, -1.625376e-01,  5.743831e-02, -6.303498e-01,  6.618098e-01},
  { 5.302133e-01,  8.150391e-01, -2.336345e-01,  4.133903e-01, -5.860869e-01,  4.801778e-01},
  {-1.865392e-01, -1.807868e-01,  9.656704e-01,  2.623863e-01, -6.128279e-01,  4.479415e-01},
  {-5.876583e-01,  1.159421e-01,  8.007592e-01,  1.754081e-01, -5.778317e-01,  4.189307e-01},
  { 1.679506e-01,  7.382761e-01,  6.532542e-01,  1.280684e-01, -5.893034e-01,  4.193407e-01},
  {-2.760906e-01, -8.728824e-01,  4.023063e-01, -1.943143e-01, -6.518046e-01,  4.101566e-01},
  { 9.879773e-01, -1.496437e-01, -3.882846e-02,  2.706921e-01, -6.058693e-01,  3.229209e-01},
  {-4.390657e-01,  5.817194e-01,  6.847070e-01, -3.508947e-01, -5.827107e-01,  4.197631e-01},
  { 5.221528e-01,  4.916779e-01,  6.968567e-01, -3.135805e-01, -5.837072e-01,  4.052636e-01},
  {-3.231733e-01,  9.443513e-01,  6.131607e-02, -3.445408e-01, -5.805064e-01,  3.706589e-01},
  { 6.810263e-01,  3.785699e-01, -6.268078e-01,  3.117006e-01, -5.703573e-01,  2.341015e-01},
  { 7.720695e-01, -1.959583e-01,  6.045734e-01, -1.959761e-01, -6.296245e-01,  3.111004e-01},
  { 7.954644e-01, -3.602231e-01,  4.873148e-01, -1.781425e-01, -6.250833e-01,  2.892433e-01},
  {-5.140325e-01,  8.531165e-01,  8.923430e-02, -4.310230e-01, -6.002832e-01,  2.105182e-01},
  { 4.589447e-01,  1.077864e-01,  8.819024e-01,  2.556604e-01, -6.325074e-01,  1.657831e-01},
  { 4.625694e-01, -8.810011e-01,  9.933075e-02, -2.093853e-01, -6.414078e-01,  1.121833e-01},
  {-4.222802e-01,  8.949687e-01,  1.439111e-01, -3.511838e-01, -6.093392e-01,  4.808675e-02},
  { 6.829835e-02, -3.066613e-01, -9.493651e-01, -2.525841e-01, -6.123329e-01, -5.867792e-02},
  { 6.829835e-02, -3.066613e-01, -9.493651e-01, -2.902480e-01, -6.217691e-01, -5.794315e-02},
  { 8.336093e-01, -3.996147e-01, -3.813183e-01, -3.187920e-01, -6.254155e-01, -7.149211e-02},
  {-6.602839e-01,  3.436667e-01,  6.677712e-01, -4.652565e-01, -6.105111e-01, -8.418363e-03},
  { 7.443635e-01, -5.669492e-01,  3.528337e-01,  4.139028e-01, -6.608738e-01, -4.564795e-02},
  {-8.953729e-01,  4.058026e-01,  1.833894e-01, -1.202383e-01, -6.010231e-01, -9.299985e-02},
  {-5.478145e-01, -3.767304e-01,  7.469762e-01, -5.011779e-01, -6.329110e-01, -3.129866e-02},
  { 8.498805e-01, -4.833018e-01, -2.100538e-01,  3.518233e-01, -5.975772e-01, -1.541164e-01},
  {-3.191886e-01, -8.109805e-01, -4.903358e-01,  1.426959e-01, -6.374757e-01, -1.590106e-01},
  { 1.381011e-01, -5.409516e-01, -8.296382e-01, -4.093199e-01, -6.602405e-01, -1.874559e-01},
  {-6.314443e-01, -5.988135e-01, -4.926465e-01, -5.414894e-01, -6.653302e-01, -1.579877e-01},
  {-8.548338e-02,  3.141643e-01,  9.455122e-01, -1.821376e-01, -6.002050e-01, -1.647214e-01},
  { 1.661411e-01, -9.859444e-01,  1.762481e-02, -5.102331e-01, -6.469650e-01, -2.629355e-01},
  { 7.160741e-03, -2.710302e-01, -9.625442e-01,  3.579884e-01, -6.070435e-01, -3.573222e-01},
  {-3.821896e-01,  8.969174e-01,  2.224194e-01, -4.028913e-01, -5.909352e-01, -3.982064e-01},
  { 9.863734e-02,  2.096606e-01,  9.727863e-01,  2.156500e-01, -5.977121e-01, -4.067691e-01},
  { 6.336465e-01,  3.826103e-01,  6.723849e-01,  3.322377e-01, -5.876306e-01, -3.976330e-01},
  {-1.923719e-01,  5.407142e-02, -9.798313e-01,  1.274754e-01, -5.723187e-01, -5.965712e-01},
  {-8.409227e-01,  2.507601e-01,  4.795502e-01, -3.157933e-01, -6.054761e-01, -6.955363e-01},
  { 7.072042e-01,  3.247103e-01,  6.280331e-01,  3.181894e-01, -5.876102e-01,  7.167568e-01},
  { 5.810561e-01,  2.445025e-01,  7.762682e-01,  3.891276e-01, -5.836750e-01,  7.083260e-01},
  { 2.293623e-01, -1.591810e-01,  9.602366e-01,  7.106098e-02, -5.798689e-01,  7.274923e-01},
  {-4.584420e-01, -6.923911e-01, -5.571584e-01,  2.928338e-01, -6.269733e-01,  5.691094e-01},
  { 5.396614e-01,  5.974714e-01,  5.931218e-01,  5.625558e-02, -5.596483e-01,  5.087175e-01},
  { 8.524463e-01,  3.465153e-01, -3.914875e-01,  3.331475e-01, -5.744551e-01,  4.363557e-01},
  {-9.460116e-02, -5.250946e-01,  8.457696e-01, -2.210347e-01, -6.374887e-01,  4.356424e-01},
  {-1.249129e-01, -7.351992e-01, -6.662424e-01, -4.851563e-02, -6.353070e-01,  3.695092e-01},
  { 5.020300e-02, -8.017974e-01, -5.954834e-01, -1.134033e-01, -6.503738e-01,  3.867556e-01},
  {-4.167011e-01, -6.842449e-01, -5.984723e-01, -2.293985e-01, -6.277243e-01,  3.860377e-01},
  { 3.535717e-01,  4.809795e-01,  8.022753e-01, -2.243179e-01, -6.044011e-01,  3.262085e-01},
  { 5.320573e-02,  7.191221e-01,  6.928438e-01, -3.474645e-02, -5.627365e-01,  2.775896e-01},
  {-4.459948e-01,  8.502516e-01,  2.795725e-01, -4.916138e-02, -5.540833e-01,  2.457831e-01},
  { 8.020568e-01, -5.951363e-01, -5.017464e-02, -1.555175e-01, -6.233322e-01,  2.466974e-01},
  { 8.009036e-01, -5.899822e-01, -1.023443e-01, -2.184547e-01, -6.324252e-01,  1.973135e-01},
  {-8.078852e-01, -7.239074e-02,  5.848770e-01, -1.709395e-01, -6.126723e-01,  1.820311e-01},
  {-7.535749e-01, -4.990192e-01,  4.279074e-01, -1.840979e-01, -6.088435e-01,  1.270142e-01},
  { 1.313035e-01,  3.509139e-01, -9.271563e-01,  2.374499e-01, -5.944756e-01,  2.149743e-02},
  { 7.688330e-03, -5.868101e-01, -8.096880e-01, -2.329330e-01, -6.085777e-01, -5.893899e-02},
  { 1.557636e-03, -6.553820e-01, -7.552959e-01, -2.321076e-01, -6.059734e-01, -6.179253e-02},
  { 1.113033e-01, -4.619913e-01, -8.798725e-01, -2.648664e-01, -6.108365e-01, -6.187277e-02},
  { 5.340464e-01, -5.345948e-01, -6.549830e-01, -3.141600e-01, -6.228973e-01, -6.758301e-02},
  { 6.400946e-01, -3.807711e-01,  6.673023e-01,  3.709273e-01, -5.848437e-01, -1.378831e-01},
  {-8.045537e-01, -4.965590e-01,  3.257643e-01, -5.752364e-01, -6.372459e-01, -1.218457e-01},
  { 4.572916e-01, -1.981281e-01, -8.669658e-01, -3.566458e-01, -6.114531e-01, -1.910892e-01},
  { 1.563341e-02, -7.568126e-01, -6.534449e-01,  1.960248e-01, -5.978836e-01, -1.728947e-01},
  { 3.843312e-01, -9.109444e-01, -1.498993e-01,  2.137396e-01, -5.905588e-01, -1.866960e-01},
  {-3.500029e-01,  5.367944e-01,  7.676913e-01, -1.566798e-01, -5.922357e-01, -1.656943e-01},
  { 2.292173e-02, -2.251614e-01, -9.740518e-01,  3.663303e-01, -5.848440e-01, -3.604582e-01},
  {-2.569285e-01, -4.475943e-01,  8.565320e-01, -5.292047e-01, -6.372110e-01, -2.538208e-01},
  { 5.092228e-01, -5.004576e-01, -7.001674e-01,  2.371072e-01, -6.097911e-01, -3.552138e-01},
  { 7.440789e-01, -6.320112e-01, -2.165836e-01,  2.455737e-01, -6.105511e-01, -3.383743e-01},
  {-5.614573e-01, -7.212763e-02, -8.243562e-01, -2.568267e-01, -6.080989e-01, -3.098066e-01},
  { 8.956897e-03, -3.865622e-01, -9.222199e-01, -3.623906e-01, -6.144981e-01, -3.198371e-01},
  {-6.239337e-02, -2.378670e-01, -9.692917e-01,  6.887723e-03, -5.859927e-01, -4.223433e-01},
  { 6.540399e-01,  1.186792e-01, -7.470924e-01, -1.614271e-02, -5.797896e-01, -4.345751e-01},
  { 6.540399e-01,  1.186792e-01, -7.470924e-01, -4.258445e-02, -5.813392e-01, -4.734710e-01},
  { 8.080460e-01,  3.264386e-01, -4.904075e-01,  1.242376e-01, -5.337930e-01, -5.762616e-01},
  {-1.380986e-02,  2.423533e-01, -9.700898e-01,  1.411291e-01, -5.283702e-01, -5.745899e-01},
  {-9.150580e-01,  3.710447e-01,  1.580976e-01, -1.683064e-01, -5.801235e-01, -5.397674e-01},
  {-7.934095e-01,  1.640261e-01,  5.861714e-01, -2.298578e-01, -5.778835e-01, -6.293828e-01},
  { 1.118211e-01, -9.865617e-01, -1.191308e-01,  2.015203e-01, -5.841345e-01,  7.590408e-01},
  { 7.225857e-01,  5.945747e-01,  3.526340e-01,  3.226948e-01, -5.567287e-01,  6.878533e-01},
  { 1.118211e-01, -9.865617e-01, -1.191308e-01,  1.929208e-01, -5.719622e-01,  6.501667e-01},
  { 9.469776e-01, -2.394675e-01,  2.142162e-01,  4.413401e-01, -5.730200e-01,  6.180236e-01},
  { 1.933761e-01, -8.324912e-01,  5.191956e-01, -4.068998e-02, -6.308279e-01,  6.492507e-01},
  {-1.924653e-01, -9.333207e-01,  3.031001e-01, -1.038017e-01, -6.402280e-01,  6.222948e-01},
  {-3.883497e-01, -8.670784e-01, -3.120250e-01,  2.650600e-01, -6.011772e-01,  5.594687e-01},
  {-2.582905e-01, -7.845302e-01, -5.637361e-01,  1.363790e-01, -6.140888e-01,  5.311258e-01},
  { 1.188067e-01, -8.520102e-01, -5.098662e-01, -1.106231e-01, -6.364283e-01,  5.489690e-01},
  { 5.806687e-01, -6.592193e-01, -4.777591e-01,  3.595073e-01, -5.511253e-01,  5.062133e-01},
  {-7.287430e-01, -6.714994e-01,  1.342467e-01,  2.790516e-01, -5.943441e-01,  4.841283e-01},
  {-6.061434e-01, -7.853322e-01,  1.258706e-01, -2.507504e-01, -6.262317e-01,  4.224428e-01},
  { 9.594312e-01, -2.694036e-01, -8.314704e-02,  3.023486e-01, -5.591071e-01,  3.922228e-01},
  {-2.314433e-01, -1.172357e-01,  9.657587e-01,  1.377714e-01, -5.621577e-01,  4.001589e-01},
  { 3.919804e-01, -3.953975e-02,  9.191235e-01,  1.146661e-01, -5.590439e-01,  4.019918e-01},
  {-1.613380e-01,  6.201516e-01,  7.677122e-01,  4.773320e-02, -5.897171e-01,  3.472233e-01},
  {-7.800283e-01,  5.507141e-01,  2.971025e-01,  4.333130e-02, -5.773671e-01,  3.023737e-01},
  { 7.958882e-01,  6.050802e-01,  2.097809e-02, -3.319595e-01, -5.783841e-01,  2.798629e-01},
  {-3.380587e-01,  8.919041e-01,  3.003722e-01,  3.669728e-02, -5.517041e-01,  2.355441e-01},
  { 4.938402e-01, -8.126966e-01,  3.092671e-01, -1.473814e-01, -6.135918e-01,  2.368255e-01},
  { 6.739298e-01, -4.624103e-01,  5.761904e-01, -1.224772e-01, -5.923704e-01,  2.306007e-01},
  { 8.863969e-01, -2.369241e-01,  3.977029e-01, -1.080242e-01, -5.771489e-01,  2.256030e-01},
  { 2.943227e-01, -9.521916e-01, -8.188548e-02, -1.931976e-01, -5.984628e-01,  1.811037e-01},
  { 2.937292e-01, -4.953714e-01,  8.175147e-01,  2.557184e-01, -6.158220e-01,  1.637136e-01},
  {-7.488439e-01, -5.839372e-01,  3.134488e-01, -3.268841e-01, -5.800217e-01,  5.929979e-02},
  { 3.662906e-01, -8.211258e-01,  4.377027e-01,  4.150003e-01, -6.246198e-01,  1.989617e-02},
  {-5.400583e-01, -7.329217e-01, -4.137181e-01, -1.389447e-01, -5.780006e-01, -8.186737e-02},
  {-6.631095e-01,  3.680634e-01,  6.517785e-01, -4.060900e-01, -5.647922e-01, -3.892718e-02},
  {-9.028149e-01, -1.232818e-01,  4.119793e-01, -1.351985e-01, -5.802812e-01, -1.560604e-01},
  { 9.298237e-01,  3.612855e-01,  7.000445e-02,  4.292849e-01, -5.591798e-01, -1.903139e-01},
  { 9.628232e-01, -2.595264e-01, -7.495078e-02,  4.298518e-01, -5.683386e-01, -2.073757e-01},
  {-7.541131e-01, -3.249579e-01, -5.707152e-01,  2.560334e-01, -5.754400e-01, -2.320964e-01},
  { 8.544291e-01, -5.044555e-01,  1.244005e-01,  2.442236e-01, -6.033194e-01, -2.863498e-01},
  {-2.273661e-01, -2.791748e-01,  9.329342e-01, -4.951334e-01, -6.204235e-01, -2.247046e-01},
  { 8.849709e-01, -4.619358e-01,  5.866760e-02,  2.494492e-01, -6.053110e-01, -3.210437e-01},
  {-4.393749e-01,  3.645688e-01, -8.209990e-01,  5.156900e-02, -5.779357e-01, -2.980095e-01},
  {-1.522581e-01, -3.251689e-01,  9.333181e-01, -5.249822e-01, -6.188769e-01, -2.547399e-01},
  {-7.014046e-01, -3.981320e-01,  5.912042e-01, -5.412793e-01, -6.161874e-01, -2.549331e-01},
  {-4.114131e-01,  1.616195e-01, -8.970052e-01,  1.247108e-01, -5.785469e-01, -3.482846e-01},
  {-5.725529e-02, -7.318660e-01, -6.790390e-01, -5.027035e-01, -6.104288e-01, -3.180770e-01},
  {-1.637540e-01, -3.704166e-01, -9.143174e-01, -2.752631e-01, -5.788458e-01, -3.103789e-01},
  {-6.745484e-01, -7.416907e-03, -7.381933e-01, -2.564581e-01, -5.616514e-01, -4.190263e-01},
  { 6.708474e-01,  5.301335e-01, -5.185770e-01,  3.170574e-01, -5.290400e-01, -3.961776e-01},
  { 9.655924e-01,  2.128787e-01,  1.493786e-01, -4.058766e-02, -5.772319e-01, -4.909677e-01},
  { 9.530342e-01,  2.911346e-01, -8.346508e-02,  5.993922e-02, -5.834441e-01, -5.703425e-01},
  { 4.076172e-01, -4.164844e-01,  8.126432e-01,  2.922687e-01, -5.720485e-01,  8.040918e-01},
  {-6.830176e-01, -1.459983e-01,  7.156616e-01,  2.197845e-01, -5.704741e-01,  7.906622e-01},
  { 1.118211e-01, -9.865617e-01, -1.191308e-01,  2.058792e-01, -5.753548e-01,  6.904250e-01},
  {-2.670312e-02,  7.329915e-01,  6.797134e-01,  3.705100e-01, -5.363451e-01,  6.902218e-01},
  { 5.199540e-01, -5.698620e-01,  6.363216e-01, -4.039402e-02, -5.983829e-01,  6.897500e-01},
  { 6.032181e-01, -7.918009e-01, -9.580915e-02, -3.720537e-02, -6.276631e-01,  5.985273e-01},
  { 7.832837e-01, -4.688718e-01, -4.081983e-01,  3.707373e-01, -5.554978e-01,  5.263418e-01},
  {-2.155591e-01, -7.466314e-01, -6.293455e-01,  1.221903e-01, -5.814000e-01,  4.843537e-01},
  { 1.723911e-01, -7.864819e-01, -5.930663e-01, -1.515720e-01, -6.154878e-01,  5.041134e-01},
  {-5.292091e-01, -7.981555e-01,  2.878985e-01, -2.575945e-01, -5.898479e-01,  5.234585e-01},
  { 5.732917e-01, -7.092006e-01, -4.103306e-01,  3.567345e-01, -5.412797e-01,  4.868174e-01},
  {-9.691021e-01, -1.954663e-01,  1.504457e-01, -2.748902e-01, -5.938719e-01,  4.824056e-01},
  { 3.995436e-01, -9.159822e-01,  3.662676e-02,  3.336894e-01, -5.404206e-01,  4.428138e-01},
  { 6.382761e-01, -7.637743e-01, -9.618934e-02,  3.193343e-01, -5.443668e-01,  4.119865e-01},
  {-1.959104e-01,  4.371862e-01,  8.777741e-01, -8.921675e-02, -5.602509e-01,  4.607988e-01},
  {-7.266390e-01, -2.950847e-01, -6.204200e-01, -2.339695e-01, -5.879919e-01,  3.658272e-01},
  { 7.287475e-01, -6.469567e-01,  2.244419e-01, -2.895268e-01, -5.814705e-01,  3.359143e-01},
  { 5.991219e-01,  3.370373e-01,  7.262636e-01, -1.677364e-01, -5.502580e-01,  2.607206e-01},
  { 8.164667e-01,  3.146430e-01, -4.841300e-01,  1.980235e-01, -5.473872e-01,  1.820837e-01},
  { 6.671180e-01,  3.566014e-01,  6.540559e-01, -1.132470e-01, -5.465519e-01,  2.263698e-01},
  { 4.408990e-01, -8.205397e-01,  3.637618e-01,  4.275696e-01, -6.049408e-01,  1.961677e-01},
  { 4.675851e-02, -9.952493e-01,  8.539686e-02,  3.681696e-01, -5.930216e-01,  2.083314e-01},
  {-3.591436e-01,  7.692187e-01,  5.285060e-01, -1.904394e-02, -5.297972e-01,  1.570144e-01},
  { 4.743078e-01, -8.542293e-01, -2.128951e-01,  2.942158e-01, -6.243396e-01,  1.447205e-01},
  { 7.736687e-01,  7.401496e-02,  6.292523e-01,  2.055761e-01, -5.690076e-01,  1.610564e-01},
  { 8.343790e-02, -4.820190e-01,  8.721787e-01,  2.741086e-01, -5.711016e-01,  2.445597e-02},
  {-3.620152e-01,  7.908310e-01, -4.934890e-01,  4.077188e-01, -5.241088e-01, -1.238634e-01},
  { 8.672482e-01, -3.363214e-01, -3.671083e-01,  3.970943e-01, -5.341197e-01, -1.225369e-01},
  {-2.789934e-01, -2.192956e-01, -9.349182e-01, -5.538120e-01, -5.794172e-01, -1.969074e-01},
  { 5.217796e-01,  9.496333e-02,  8.477783e-01,  4.145454e-01, -5.308025e-01, -1.707820e-01},
  {-6.972245e-01, -5.209624e-01,  4.924187e-01, -1.530751e-01, -5.592660e-01, -1.712587e-01},
  {-6.278736e-01, -7.773445e-01, -3.886044e-02,  2.751647e-01, -5.639423e-01, -2.792789e-01},
  {-2.102479e-01,  4.695516e-01,  8.575063e-01, -2.821358e-01, -5.513634e-01, -1.899907e-01},
  {-4.206532e-01, -2.574466e-01,  8.699265e-01, -5.346376e-01, -5.949082e-01, -2.363586e-01},
  { 6.447017e-01, -2.844374e-01,  7.095458e-01, -5.393305e-01, -6.119698e-01, -2.389340e-01},
  { 3.689021e-01, -2.373857e-01, -8.986430e-01,  3.407672e-02, -5.821975e-01, -2.965932e-01},
  { 6.030079e-01, -7.950921e-01,  6.488475e-02,  3.560545e-02, -5.644579e-01, -3.091796e-01},
  {-8.793334e-01, -2.176539e-01, -4.235558e-01, -2.408410e-01, -5.619996e-01, -3.448300e-01},
  {-8.761352e-01,  4.395770e-01, -1.978867e-01, -2.744490e-01, -5.224946e-01, -4.008266e-01},
  { 5.724471e-01,  8.787683e-02,  8.152189e-01,  2.936843e-01, -5.102595e-01, -3.938975e-01},
  { 7.817780e-01, -1.148165e-02, -6.234511e-01,  2.791313e-01, -5.019546e-01, -4.585462e-01},
  { 1.597249e-01, -9.130308e-01, -3.753168e-01, -1.825277e-01, -5.799614e-01, -4.946317e-01},
  {-5.764093e-01, -6.146394e-01, -5.384892e-01, -2.002005e-01, -5.841637e-01, -4.883432e-01},
  {-2.152782e-03,  2.105068e-01, -9.775900e-01,  1.479570e-01, -5.089851e-01, -5.722275e-01},
  { 2.494883e-01, -9.680598e-01, -2.481773e-02, -3.383476e-01, -6.154956e-01, -5.976596e-01},
  {-3.577768e-01, -9.327307e-01,  4.482490e-02, -3.889181e-01, -6.151847e-01, -5.949960e-01},
  {-6.200656e-01, -6.864110e-01, -3.799456e-01, -4.355657e-01, -5.819331e-01, -5.836290e-01},
  { 7.898322e-01, -4.953579e-03, -6.133030e-01, -5.665607e-02, -5.576983e-01, -5.972164e-01},
  {-4.197598e-01, -5.114621e-01, -7.498055e-01, -3.611143e-01, -6.121729e-01, -6.724672e-01},
  {-4.197598e-01, -5.114621e-01, -7.498055e-01, -3.780281e-01, -6.041493e-01, -6.829535e-01},
  { 7.358520e-01, -1.032692e-01, -6.692214e-01, -5.044780e-02, -5.531606e-01, -6.501419e-01},
  { 6.553283e-01, -5.819156e-01,  4.815796e-01, -5.271337e-03, -5.609846e-01,  6.894116e-01},
  {-5.721754e-01,  8.031502e-02,  8.161892e-01, -4.822464e-02, -5.338217e-01,  6.962957e-01},
  { 5.431948e-01,  6.217375e-01,  5.642534e-01,  4.269868e-01, -5.107213e-01,  6.372779e-01},
  { 9.570554e-01,  9.455597e-02,  2.740515e-01,  4.548354e-01, -5.300061e-01,  5.926939e-01},
  {-5.388716e-01, -2.876085e-01,  7.917694e-01, -1.287493e-01, -5.963785e-01,  6.396323e-01},
  { 3.107894e-01, -7.035737e-01, -6.390570e-01,  1.784610e-01, -5.609960e-01,  4.862410e-01},
  {-1.616536e-01,  2.652874e-02, -9.864909e-01,  4.307682e-01, -5.606039e-01,  3.894837e-01},
  { 1.241870e-01, -2.838729e-01,  9.507859e-01,  9.292876e-02, -5.149505e-01,  4.210317e-01},
  { 9.283478e-01, -2.182559e-01,  3.008899e-01,  4.309653e-01, -5.543051e-01,  3.622359e-01},
  {-2.856048e-01, -8.998515e-01,  3.296927e-01, -3.265750e-01, -5.820397e-01,  4.122753e-01},
  { 4.645294e-01, -7.643229e-01,  4.472393e-01, -3.025936e-01, -5.840684e-01,  3.927495e-01},
  { 9.095414e-01, -3.606615e-01, -2.065377e-01,  4.438169e-01, -5.810876e-01,  2.945276e-01},
  { 4.264245e-02, -6.695273e-01, -7.415624e-01,  4.314311e-01, -5.720951e-01,  2.705259e-01},
  {-1.987090e-01, -8.572187e-01, -4.750692e-01,  3.960206e-01, -5.751617e-01,  2.712584e-01},
  { 3.319522e-01,  6.775430e-01,  6.563103e-01, -2.539203e-01, -5.552903e-01,  2.820320e-01},
  { 7.330833e-01, -6.588311e-01,  1.689102e-01, -2.473015e-01, -5.445201e-01,  2.504800e-01},
  {-6.117679e-01, -6.383202e-01,  4.672123e-01, -5.189684e-01, -6.009489e-01,  2.234555e-01},
  { 8.852351e-01, -2.648397e-01,  3.823853e-01,  4.319548e-01, -5.797606e-01,  2.083338e-01},
  {-2.142977e-02, -9.696747e-01, -2.434579e-01,  7.647234e-03, -5.170131e-01,  1.602431e-01},
  {-2.696002e-01, -9.606621e-01,  6.666455e-02, -3.280965e-01, -5.570707e-01,  1.429705e-01},
  { 2.067827e-02, -9.987553e-01, -4.539215e-02, -5.296160e-01, -5.996111e-01,  1.577837e-01},
  { 1.478411e-01, -9.785768e-01, -1.432843e-01, -4.940786e-01, -5.946360e-01,  1.470327e-01},
  {-7.357218e-01, -6.772270e-01,  8.780442e-03, -5.749295e-01, -5.611855e-01,  1.071583e-01},
  { 8.093312e-01, -5.720180e-01, -1.333358e-01,  4.319373e-01, -5.846319e-01,  9.445369e-02},
  { 3.120586e-01, -9.271306e-01,  2.074809e-01,  4.110053e-01, -5.861020e-01,  8.910324e-02},
  { 9.126405e-02,  9.883939e-01, -1.214431e-01,  3.501273e-01, -5.291815e-01, -1.176423e-01},
  { 3.478369e-01, -6.211349e-01, -7.022827e-01, -2.847288e-01, -5.600440e-01, -1.629293e-01},
  {-2.268422e-01, -2.058902e-01, -9.519202e-01, -5.636481e-01, -5.404021e-01, -1.997767e-01},
  {-9.262393e-01, -2.086405e-01, -3.139264e-01, -5.938266e-01, -5.829642e-01, -1.504440e-01},
  { 8.672482e-01, -3.363214e-01, -3.671083e-01,  3.857834e-01, -5.151940e-01, -1.665959e-01},
  {-1.503528e-02, -8.945619e-01, -4.466912e-01,  2.633071e-01, -5.640519e-01, -2.951596e-01},
  {-9.040407e-02,  3.365413e-01,  9.373191e-01, -3.106639e-01, -5.412418e-01, -1.985025e-01},
  {-2.883359e-01,  5.584469e-02, -9.558995e-01,  8.834160e-02, -5.521854e-01, -3.011523e-01},
  {-2.051233e-01,  6.449133e-02, -9.766091e-01,  2.182662e-01, -5.481335e-01, -3.829995e-01},
  {-6.231511e-01, -8.486652e-02, -7.774834e-01, -5.616673e-01, -5.247530e-01, -2.882110e-01},
  { 6.513058e-01,  1.306075e-01, -7.474907e-01,  2.146236e-01, -4.808807e-01, -4.799218e-01},
  {-3.409431e-01, -8.274107e-01,  4.462616e-01, -2.838531e-01, -5.730151e-01, -4.880915e-01},
  { 4.053307e-02, -7.521901e-01,  6.576983e-01, -3.251117e-01, -5.732253e-01, -4.876412e-01},
  {-3.726602e-01, -5.868829e-01,  7.188134e-01, -3.753341e-01, -5.732819e-01, -4.845182e-01},
  {-4.766951e-01, -8.766537e-01,  6.511585e-02, -4.551728e-01, -5.688309e-01, -5.364994e-01},
  { 5.631797e-01, -7.194814e-01, -4.064173e-01, -1.740139e-01, -5.478085e-01, -5.218571e-01},
  {-7.976714e-01, -2.746082e-01, -5.369458e-01, -4.021449e-01, -5.990523e-01, -6.055902e-01},
  { 4.455057e-01,  4.249240e-01, -7.880127e-01, -4.136609e-01, -5.927291e-01, -5.976752e-01},
  { 6.475294e-01, -2.496673e-01,  7.199805e-01,  5.965248e-02, -5.378746e-01, -5.560165e-01},
  { 5.055585e-01, -6.887715e-01, -5.196195e-01, -2.516341e-01, -5.815554e-01, -5.844498e-01},
  {-5.042719e-01,  4.055066e-01, -7.624134e-01, -1.335537e-01, -5.513673e-01, -6.453006e-01},
  {-5.549222e-01,  1.241265e-01, -8.225898e-01, -3.001447e-01, -4.907722e-01, -7.416912e-01},
  { 2.461699e-01, -3.234864e-01,  9.136503e-01,  2.909082e-01, -5.457335e-01,  8.194135e-01},
  { 8.009298e-01, -5.805296e-01,  1.466176e-01,  3.273062e-01, -5.434415e-01,  7.883875e-01},
  { 9.843355e-01, -1.635942e-01,  6.573213e-02,  3.322753e-01, -5.353796e-01,  7.590448e-01},
  {-2.656766e-01, -9.247500e-01,  2.724948e-01,  2.842064e-01, -4.986536e-01,  6.406643e-01},
  { 8.360042e-01,  4.704895e-01,  2.823770e-01,  4.405778e-01, -5.041019e-01,  6.050605e-01},
  { 2.358496e-01,  9.196773e-01,  3.139565e-01,  3.038900e-01, -5.039237e-01,  6.036423e-01},
  {-9.519010e-01,  2.933997e-01,  8.832438e-02,  1.630071e-01, -5.091025e-01,  5.939788e-01},
  { 6.891274e-01,  3.595288e-01,  6.291601e-01,  1.510199e-01, -5.068446e-01,  6.038843e-01},
  { 3.913346e-01,  3.712222e-01,  8.420519e-01, -6.010999e-02, -5.334826e-01,  6.317730e-01},
  {-3.676730e-01, -8.532428e-01,  3.698556e-01,  2.061588e-01, -5.464326e-01,  4.650721e-01},
  {-4.432747e-01, -8.240360e-01,  3.528059e-01,  1.695981e-01, -5.466630e-01,  4.415206e-01},
  {-1.616536e-01,  2.652874e-02, -9.864909e-01,  4.227894e-01, -5.267236e-01,  3.917022e-01},
  {-2.317776e-01,  1.891888e-01,  9.541944e-01,  8.157244e-02, -5.014416e-01,  4.260192e-01},
  { 7.102785e-02, -8.139374e-01, -5.765944e-01, -7.201982e-02, -5.456859e-01,  3.267373e-01},
  { 1.657118e-01, -5.634968e-01, -8.093274e-01, -1.027619e-01, -5.625268e-01,  3.375040e-01},
  { 6.783856e-01, -1.372741e-01,  7.217678e-01, -2.934939e-01, -5.337769e-01,  3.991631e-01},
  {-2.876044e-01, -6.770148e-01,  6.774473e-01,  4.401935e-01, -5.533932e-01,  3.130820e-01},
  {-4.799031e-01, -8.467659e-01,  2.295223e-01, -3.568270e-01, -5.772276e-01,  3.992027e-01},
  {-5.249993e-01, -7.098507e-01,  4.695612e-01, -3.870857e-01, -5.423719e-01,  3.773565e-01},
  { 4.955444e-01, -2.344459e-01, -8.363438e-01,  4.175570e-01, -5.599170e-01,  2.587330e-01},
  {-2.791341e-01,  9.265078e-01,  2.523237e-01, -2.486223e-01, -5.388743e-01,  2.423685e-01},
  {-4.023922e-01,  8.769068e-01,  2.628973e-01, -2.005457e-01, -5.172772e-01,  1.837109e-01},
  { 2.184349e-01, -9.676598e-01,  1.261770e-01, -4.033117e-01, -5.481345e-01,  1.674303e-01},
  { 7.590811e-01,  4.623388e-01,  4.582997e-01, -1.375432e-01, -5.114316e-01,  1.609855e-01},
  {-5.167945e-01, -7.244939e-01, -4.561052e-01, -9.283156e-03, -5.000684e-01,  1.317412e-01},
  { 5.224106e-01, -6.407518e-01, -5.626049e-01,  2.726765e-01, -5.722840e-01,  1.202164e-01},
  { 1.460451e-01,  2.469950e-01,  9.579479e-01, -9.560840e-02, -5.050647e-01,  1.425048e-01},
  {-2.634004e-01, -9.596547e-01,  9.840268e-02,  3.213439e-01, -5.388605e-01,  8.229344e-02},
  {-1.957900e-01, -9.754997e-01, -1.003330e-01,  2.911192e-01, -5.292986e-01,  7.621959e-02},
  {-5.054636e-02, -9.983742e-01,  2.634148e-02, -4.256985e-01, -5.442912e-01,  1.701571e-03},
  { 4.768753e-01, -7.376647e-01,  4.779548e-01,  3.468054e-01, -4.919485e-01, -4.212905e-02},
  { 3.192334e-01, -9.294813e-01,  1.848098e-01,  3.655422e-01, -5.165703e-01, -8.084272e-02},
  { 7.512028e-01,  6.577941e-01, -5.478483e-02,  3.670606e-01, -5.197719e-01, -9.846386e-02},
  {-4.289912e-01, -1.999366e-01,  8.809040e-01, -4.900997e-01, -5.403120e-01, -7.356080e-02},
  {-8.439994e-01, -4.823463e-01,  2.345361e-01, -6.065759e-01, -5.571285e-01, -6.635395e-02},
  { 2.395232e-01, -2.394408e-01, -9.409021e-01, -4.641448e-01, -5.226657e-01, -1.724591e-01},
  {-6.336453e-02,  8.664653e-01,  4.951999e-01,  3.473852e-01, -5.233240e-01, -1.691056e-01},
  { 6.856138e-01,  6.614311e-01,  3.040438e-01,  3.737931e-01, -4.922793e-01, -2.223030e-01},
  {-1.277474e-02,  2.316131e-01,  9.727241e-01, -4.350966e-01, -5.152512e-01, -2.112449e-01},
  {-9.170798e-01, -1.026765e-01,  3.852559e-01, -5.692479e-01, -5.158439e-01, -2.568926e-01},
  {-9.773781e-01, -2.111558e-01, -1.205686e-02, -2.496268e-01, -5.219927e-01, -3.538290e-01},
  {-5.512810e-01, -8.317637e-01, -6.525545e-02, -5.140409e-01, -5.974287e-01, -4.020962e-01},
  {-1.228095e-01, -8.278586e-03, -9.923957e-01, -2.027930e-02, -5.095721e-01, -4.644940e-01},
  {-9.847746e-01,  1.629414e-01,  6.057132e-02, -2.482371e-01, -5.334452e-01, -4.473969e-01},
  { 7.600467e-01,  2.632379e-01, -5.941673e-01,  2.063084e-01, -4.856190e-01, -5.361611e-01},
  {-9.717048e-01,  1.724675e-01,  1.613840e-01, -4.545715e-01, -5.541860e-01, -5.509863e-01},
  { 3.457106e-01,  6.882563e-01, -6.377989e-01,  1.627922e-01, -4.622021e-01, -5.586368e-01},
  {-4.887363e-01,  7.178740e-01, -4.957758e-01, -3.596399e-01, -5.491276e-01, -5.608213e-01},
  { 9.236627e-01, -3.241125e-01, -2.044462e-01,  7.909001e-02, -5.297797e-01, -5.827634e-01},
  { 3.758190e-02, -8.736946e-02, -9.954668e-01, -3.421469e-01, -5.214843e-01, -6.777974e-01},
  { 8.138186e-01,  5.074568e-01, -2.831729e-01,  2.916097e-01, -5.021037e-01,  6.877124e-01},
  {-7.484137e-01,  6.172255e-01,  2.427128e-01, -3.841758e-02, -4.925644e-01,  6.970462e-01},
  {-7.962427e-01, -6.030378e-01,  4.840306e-02,  7.486087e-02, -5.107667e-01,  6.576843e-01},
  {-1.028741e-02, -1.499019e-01,  9.886474e-01, -1.402774e-01, -5.232276e-01,  6.585697e-01},
  { 3.642526e-01,  8.043311e-01,  4.694374e-01,  4.171198e-01, -4.823560e-01,  5.800493e-01},
  { 3.265058e-01,  7.124187e-01,  6.211712e-01,  3.003971e-01, -4.814396e-01,  5.752379e-01},
  {-8.277024e-01,  3.375152e-01,  4.483215e-01,  1.675087e-01, -4.871166e-01,  5.712397e-01},
  {-8.608148e-01, -1.611609e-01,  4.827270e-01, -1.876185e-01, -5.484568e-01,  5.658497e-01},
  { 9.774249e-01, -1.573246e-01, -1.410304e-01,  4.513170e-01, -5.184602e-01,  4.965294e-01},
  { 8.029172e-01, -4.380025e-01, -4.043239e-01,  4.314942e-01, -5.314656e-01,  4.763968e-01},
  {-9.518285e-01, -2.445625e-01,  1.849639e-01, -2.976877e-01, -5.253829e-01,  4.946437e-01},
  { 6.194172e-01, -7.794245e-01, -9.391336e-02,  4.181443e-01, -5.356793e-01,  4.458632e-01},
  { 2.759211e-01, -6.270237e-01,  7.284977e-01, -1.832683e-01, -5.668339e-01,  4.396298e-01},
  { 5.875853e-02, -8.720686e-01,  4.858434e-01,  4.297546e-02, -4.976581e-01,  4.081092e-01},
  { 1.834616e-01,  2.116662e-01,  9.599684e-01, -3.078256e-03, -5.070916e-01,  4.059064e-01},
  {-6.771987e-01, -3.266922e-01,  6.592981e-01, -3.505419e-01, -5.601286e-01,  4.196717e-01},
  { 4.927791e-01, -1.083969e-02,  8.700869e-01, -3.513143e-01, -5.414672e-01,  4.246698e-01},
  {-5.032182e-01, -2.259292e-02,  8.638640e-01, -4.532358e-01, -4.979740e-01,  3.878016e-01},
  { 7.736812e-01, -2.989478e-01,  5.586121e-01, -2.368326e-01, -5.085781e-01,  3.452354e-01},
  { 7.817866e-01,  2.746568e-02, -6.229410e-01,  4.374576e-01, -5.230334e-01,  2.702719e-01},
  {-3.420707e-01, -7.871307e-01, -5.132377e-01,  2.694730e-01, -5.214505e-01,  2.732272e-01},
  {-2.647046e-01, -8.331089e-01,  4.856553e-01, -4.748402e-01, -5.561336e-01,  3.297545e-01},
  {-3.904403e-01, -9.168537e-01, -8.328140e-02,  2.681342e-01, -5.177783e-01,  2.390759e-01},
  {-8.922437e-01, -3.113735e-01,  3.270285e-01, -4.952275e-01, -5.167158e-01,  3.305538e-01},
  { 4.795425e-02,  1.465298e-01,  9.880432e-01,  3.853415e-02, -5.151845e-01,  2.266797e-01},
  {-3.042121e-01, -8.489126e-01,  4.322064e-01, -4.608002e-01, -5.904309e-01,  2.387729e-01},
  {-7.793533e-01, -4.862496e-03,  6.265659e-01, -5.539203e-01, -5.331303e-01,  1.950520e-01},
  {-4.284697e-01,  8.921432e-01,  1.431585e-01, -5.402737e-01, -4.922094e-01,  1.545625e-01},
  {-2.484768e-01,  7.730873e-01,  5.836055e-01, -1.683539e-01, -4.946202e-01,  1.674037e-01},
  { 3.724262e-01, -5.480332e-01,  7.489715e-01, -1.213608e-01, -5.037282e-01,  1.501550e-01},
  {-8.374842e-01,  4.084043e-01,  3.630786e-01, -5.783566e-01, -5.108273e-01,  1.274593e-01},
  {-6.436357e-02, -9.805257e-01, -1.855446e-01,  3.296304e-01, -5.480527e-01,  1.151833e-01},
  {-9.428483e-01,  2.861634e-01,  1.707262e-01, -5.844414e-01, -5.092687e-01,  1.099396e-01},
  { 9.745562e-01, -1.815817e-01, -1.314094e-01,  4.485361e-01, -4.991010e-01,  4.530259e-02},
  { 3.932677e-01, -8.597547e-01, -3.258256e-01,  2.710524e-01, -5.295151e-01,  8.542226e-02},
  {-1.358714e-01,  9.662328e-01, -2.189366e-01, -3.519641e-01, -4.893564e-01,  5.419719e-02},
  {-8.629628e-01, -4.384121e-01,  2.511771e-01, -5.944147e-01, -5.468222e-01, -3.958913e-03},
  {-8.996624e-01,  4.346639e-01, -4.092711e-02,  3.634696e-01, -5.285535e-01, -1.127902e-01},
  {-3.902800e-02, -9.849606e-01, -1.683135e-01,  3.642888e-01, -5.300106e-01, -1.462743e-01},
  { 1.262989e-01, -1.126688e-01, -9.855731e-01, -4.188512e-01, -5.136141e-01, -1.589302e-01},
  {-8.171538e-01, -2.870959e-01,  4.998356e-01, -1.799842e-01, -5.083448e-01, -1.951096e-01},
  {-2.421602e-01,  6.989993e-02,  9.677150e-01, -5.210618e-01, -5.031558e-01, -2.240239e-01},
  {-4.351201e-01,  5.731449e-01,  6.943887e-01, -2.100476e-01, -5.063666e-01, -2.457280e-01},
  { 2.188381e-01,  3.192287e-01, -9.220645e-01,  1.129126e-01, -5.301976e-01, -3.234234e-01},
  { 9.984139e-02, -5.265440e-01, -8.442648e-01, -3.089067e-01, -5.210527e-01, -3.449059e-01},
  { 4.100068e-01, -7.886802e-01,  4.581244e-01, -4.778580e-01, -5.956696e-01, -4.010974e-01},
  {-2.209613e-01, -3.356475e-01,  9.157057e-01, -5.176865e-01, -5.782779e-01, -3.846900e-01},
  {-8.561453e-01, -5.074103e-01,  9.772404e-02, -2.405078e-01, -5.162501e-01, -4.347588e-01},
  { 7.394596e-01,  1.536213e-01, -6.554387e-01, -3.916530e-01, -5.329825e-01, -5.605648e-01},
  {-9.274419e-01, -9.797494e-03, -3.738389e-01, -4.400521e-01, -5.468520e-01, -5.932994e-01},
  {-1.070356e-02, -4.711179e-01, -8.820053e-01, -3.268667e-01, -5.129720e-01, -6.734017e-01},
  {-5.808972e-01, -1.901584e-01,  7.914533e-01, -3.737853e-01, -5.128013e-01, -6.578918e-01},
  { 4.292108e-01, -7.418374e-01, -5.152237e-01, -2.692479e-01, -4.572832e-01, -7.055846e-01},
  { 9.870987e-01,  1.197226e-01, -1.063139e-01,  2.807387e-01, -4.918126e-01,  6.604993e-01},
  { 4.681267e-01, -8.690158e-01,  1.602154e-01,  4.531914e-02, -5.081340e-01,  6.133215e-01},
  {-6.778342e-01, -4.766028e-01,  5.598130e-01, -2.030290e-01, -5.225903e-01,  6.276225e-01},
  {-8.872617e-01, -3.094255e-01,  3.420858e-01, -9.546170e-02, -4.991928e-01,  5.710979e-01},
  {-8.944272e-01,  0.000000e+00,  4.472136e-01, -9.572984e-02, -5.045856e-01,  5.846297e-01},
  {-1.858835e-01, -8.152317e-01, -5.484929e-01, -9.552107e-02, -5.076765e-01,  4.577878e-01},
  { 4.863807e-01, -7.874458e-01, -3.786329e-01, -1.236834e-01, -5.145503e-01,  4.585998e-01},
  { 7.167045e-01,  6.153995e-01, -3.280520e-01,  3.787411e-01, -4.695661e-01,  4.004574e-01},
  { 1.125160e-01, -9.126717e-01,  3.928999e-01, -7.091036e-02, -5.057604e-01,  4.219756e-01},
  { 5.012596e-01,  8.159625e-01, -2.879998e-01,  3.186611e-01, -4.959961e-01,  3.456275e-01},
  { 1.160874e-01,  2.109851e-01,  9.705715e-01, -3.432813e-01, -4.970971e-01,  4.209419e-01},
  {-2.250874e-01,  3.316523e-01,  9.161564e-01, -3.643028e-01, -4.750268e-01,  4.151847e-01},
  { 2.773874e-01,  6.060565e-01,  7.454876e-01,  3.957155e-01, -5.190657e-01,  3.285048e-01},
  {-7.413741e-01,  9.971722e-02, -6.636422e-01, -1.451232e-01, -5.134516e-01,  2.643599e-01},
  { 7.367898e-02,  8.607920e-01,  5.035956e-01, -4.026903e-01, -4.360582e-01,  3.617114e-01},
  {-7.145256e-01, -1.172897e-01,  6.897073e-01, -4.878227e-01, -4.768502e-01,  3.533910e-01},
  {-4.974057e-02,  5.365176e-03, -9.987477e-01,  4.091054e-01, -5.234613e-01,  2.531511e-01},
  { 5.305145e-01,  8.460275e-01, -5.283743e-02, -3.686649e-01, -4.584048e-01,  2.918813e-01},
  { 3.430587e-01,  9.266471e-01,  1.537399e-01, -3.576883e-01, -4.661890e-01,  2.739805e-01},
  {-6.791012e-01, -3.116560e-01, -6.645992e-01, -7.801852e-02, -4.985354e-01,  1.912331e-01},
  { 6.690779e-01, -6.347613e-01,  3.865396e-01, -1.907773e-01, -4.963566e-01,  2.701054e-01},
  {-8.829272e-02,  9.775199e-01,  1.914659e-01, -3.171515e-01, -4.662212e-01,  2.663656e-01},
  { 9.230800e-01, -1.929245e-01, -3.327216e-01,  2.028761e-01, -4.896292e-01,  1.906140e-01},
  {-8.884019e-01, -2.972214e-01,  3.498592e-01, -5.088874e-01, -5.048894e-01,  2.477456e-01},
  {-9.928848e-01, -9.546909e-02,  7.117300e-02, -5.694841e-01, -5.016834e-01,  1.838692e-01},
  {-1.612952e-01,  1.562329e-03, -9.869050e-01, -4.801881e-01, -4.689159e-01,  1.435756e-01},
  {-4.218002e-01,  8.583896e-01, -2.919793e-01, -4.150254e-01, -4.872283e-01,  9.279868e-02},
  {-2.639962e-01,  9.319063e-01, -2.487098e-01, -4.077973e-01, -4.891507e-01,  7.815819e-02},
  {-4.305897e-01,  8.535128e-01,  2.934423e-01, -3.046928e-01, -4.824015e-01,  4.339444e-02},
  { 9.203150e-01,  5.826987e-02, -3.868136e-01,  4.425706e-01, -4.798670e-01,  1.721277e-02},
  {-4.597476e-01,  7.893246e-01,  4.069383e-01, -5.309065e-01, -4.509976e-01,  6.582993e-02},
  { 1.290467e-01,  9.212534e-01,  3.669319e-01, -5.134373e-01, -4.431667e-01,  5.424727e-02},
  { 4.768753e-01, -7.376647e-01,  4.779548e-01,  3.499086e-01, -4.782854e-01, -2.413800e-02},
  {-7.636815e-01,  5.883942e-01, -2.656743e-01, -3.043625e-01, -4.554514e-01,  1.368231e-03},
  {-8.501359e-01,  4.268005e-01,  3.083997e-01, -5.987828e-01, -4.656328e-01,  2.278207e-03},
  { 3.044474e-01, -7.533883e-01,  5.828531e-01,  3.666642e-01, -5.161866e-01, -8.362672e-02},
  { 1.386191e-01,  4.148936e-01, -8.992486e-01, -2.901627e-01, -5.247698e-01, -1.474922e-01},
  { 3.044780e-01, -9.516332e-01, -4.107925e-02,  3.910855e-01, -5.342342e-01, -1.302216e-01},
  { 3.044780e-01, -9.516332e-01, -4.107925e-02,  3.818052e-01, -5.340748e-01, -1.592269e-01},
  { 1.159234e-01, -9.074457e-01, -4.038616e-01,  3.754304e-01, -5.226846e-01, -1.709628e-01},
  {-7.643721e-01, -5.986806e-01,  2.394095e-01, -1.664835e-01, -5.155518e-01, -1.700277e-01},
  {-3.485620e-01,  1.768944e-01,  9.204417e-01, -5.586771e-01, -4.596720e-01, -2.336820e-01},
  {-6.357409e-01, -3.403720e-01,  6.928061e-01, -2.245229e-01, -4.826152e-01, -2.634822e-01},
  { 3.720737e-02,  4.808033e-01,  8.760387e-01, -3.145050e-01, -4.760219e-01, -2.675344e-01},
  {-2.305464e-01, -4.441287e-02, -9.720472e-01,  1.968261e-01, -5.009379e-01, -3.439130e-01},
  {-4.831186e-01, -8.008324e-01, -3.539265e-01, -4.264909e-01, -4.963434e-01, -3.274457e-01},
  { 2.788245e-02, -6.872710e-01, -7.258659e-01, -3.568507e-01, -5.264938e-01, -3.767602e-01},
  { 5.396928e-01, -7.093511e-01, -4.533794e-01, -3.821140e-01, -5.227429e-01, -3.921900e-01},
  {-9.944933e-01, -8.134042e-02,  6.608085e-02, -5.333557e-01, -5.523401e-01, -4.118813e-01},
  { 4.482962e-02,  4.053338e-01,  9.130689e-01,  2.645148e-01, -4.313245e-01, -4.096343e-01},
  { 6.683685e-01, -7.429661e-01,  3.584974e-02, -4.449826e-01, -5.629430e-01, -4.264013e-01},
  { 2.350291e-01, -8.434430e-01, -4.830789e-01, -4.806356e-01, -5.893846e-01, -4.402061e-01},
  { 9.397336e-01,  3.366507e-01, -5.972414e-02,  3.040188e-01, -4.338374e-01, -4.145243e-01},
  {-3.405482e-01, -6.571009e-01,  6.724918e-01, -2.601784e-01, -4.995324e-01, -4.412255e-01},
  {-3.113903e-02,  7.387966e-01, -6.732088e-01,  1.336964e-01, -4.301336e-01, -5.195191e-01},
  { 4.259274e-01, -2.647320e-01, -8.651605e-01, -3.453718e-02, -4.833237e-01, -6.026244e-01},
  { 4.221441e-01,  2.084764e-01, -8.822312e-01, -1.238864e-01, -4.863059e-01, -5.924343e-01},
  {-7.155602e-01,  6.933138e-01,  8.537855e-02, -3.590546e-01, -4.720006e-01, -6.490515e-01},
  { 8.363982e-02,  1.857369e-01, -9.790333e-01,  3.369419e-02, -4.828117e-01, -6.246614e-01},
  { 5.364375e-01, -5.079150e-01, -6.739861e-01, -2.333987e-01, -4.854526e-01, -6.314756e-01},
  { 2.632997e-01,  9.494175e-02, -9.600309e-01, -2.646216e-01, -4.366323e-01, -7.305773e-01},
  { 4.715151e-01,  2.352482e-01, -8.499010e-01, -2.216152e-01, -4.475642e-01, -7.292545e-01},
  { 8.985456e-01, -1.877227e-01, -3.967065e-01,  2.854065e-01, -4.878214e-01,  6.869518e-01},
  {-6.568189e-01,  2.958647e-01,  6.935799e-01,  4.476897e-02, -4.714038e-01,  7.514571e-01},
  { 1.731835e-01,  7.128602e-01,  6.795865e-01,  7.013147e-02, -4.672083e-01,  7.506830e-01},
  {-5.884504e-02, -9.753457e-01,  2.126922e-01,  4.518544e-02, -4.952276e-01,  6.745018e-01},
  {-9.885185e-01,  6.395498e-02,  1.368971e-01,  1.829692e-01, -4.716668e-01,  5.881519e-01},
  {-6.117512e-01, -1.184445e-01,  7.821326e-01, -1.977003e-01, -4.845353e-01,  6.446488e-01},
  { 9.812350e-01,  4.751896e-02,  1.868688e-01, -1.010055e-01, -4.797651e-01,  6.370898e-01},
  { 1.230904e-01,  4.481983e-01,  8.854192e-01,  2.749704e-01, -4.648218e-01,  5.674926e-01},
  { 1.538640e-01, -9.754814e-01, -1.573591e-01,  7.691218e-02, -5.059103e-01,  5.497717e-01},
  { 8.301219e-01,  4.724852e-01, -2.960664e-01,  4.453617e-01, -4.735814e-01,  4.854404e-01},
  {-3.272313e-01, -8.513860e-01, -4.099532e-01,  9.637605e-02, -5.003989e-01,  4.928397e-01},
  { 2.433339e-01, -9.421096e-01, -2.306908e-01,  5.441344e-02, -5.044452e-01,  5.054089e-01},
  {-8.079629e-01, -3.366688e-01,  4.835806e-01, -2.191153e-01, -4.973913e-01,  5.233386e-01},
  {-6.310041e-01, -7.217130e-01,  2.845422e-01,  1.044530e-01, -4.884400e-01,  4.460240e-01},
  { 2.472677e-01, -9.548803e-01,  1.645063e-01,  1.536185e-02, -4.896917e-01,  4.167437e-01},
  {-5.113714e-01, -1.882886e-01, -8.384788e-01, -1.646772e-01, -4.780231e-01,  3.755967e-01},
  { 8.984658e-02,  3.934244e-01,  9.149562e-01,  2.933284e-01, -4.743935e-01,  3.383803e-01},
  { 3.021461e-01,  8.731597e-01,  3.824916e-01, -3.409478e-01, -4.529399e-01,  3.940645e-01},
  { 8.650276e-02,  9.480323e-01,  3.061897e-01, -3.733826e-01, -4.372321e-01,  3.777105e-01},
  { 4.472136e-01,  0.000000e+00, -8.944272e-01,  3.041837e-01, -4.734060e-01,  3.294744e-01},
  { 4.580081e-02, -9.275050e-01, -3.709942e-01, -3.982042e-02, -5.158312e-01,  2.853408e-01},
  {-3.007931e-01,  4.238750e-01,  8.543147e-01, -4.772876e-01, -4.140730e-01,  3.287314e-01},
  {-8.520823e-02, -8.773655e-01, -4.721964e-01,  3.099197e-02, -4.982490e-01,  2.052233e-01},
  {-7.835436e-01, -3.619971e-01, -5.049927e-01, -6.105093e-02, -4.862411e-01,  1.684333e-01},
  { 6.424195e-01,  1.918481e-01,  7.419510e-01,  4.319711e-01, -5.115704e-01,  2.055725e-01},
  { 7.019279e-01,  1.725411e-01,  6.910331e-01,  4.332007e-01, -4.986484e-01,  1.980066e-01},
  {-4.364322e-01,  8.969191e-01, -7.115681e-02, -2.621923e-01, -4.465873e-01,  1.767617e-01},
  {-2.441044e-01, -8.061792e-02,  9.663921e-01,  3.084791e-01, -4.705524e-01,  1.665419e-01},
  {-6.458709e-01, -6.877158e-01, -3.315083e-01, -1.471269e-01, -4.879271e-01,  1.675752e-01},
  {-7.154368e-01,  1.024287e-01, -6.911284e-01, -3.099080e-01, -4.610357e-01,  6.683644e-02},
  {-4.000715e-01,  5.774254e-01, -7.117041e-01, -2.891148e-01, -4.399832e-01, -1.613132e-03},
  {-5.847401e-01,  7.304763e-01, -3.528221e-01,  3.583014e-01, -4.644227e-01, -4.192761e-03},
  { 1.097613e-01,  9.219950e-01,  3.713188e-01, -2.814454e-01, -4.390607e-01, -7.918674e-03},
  {-4.636220e-01, -7.963301e-01,  3.884753e-01,  3.521112e-01, -4.827323e-01, -3.241742e-02},
  {-7.138568e-02,  9.480947e-01,  3.098717e-01, -5.212341e-01, -3.994740e-01, -3.477716e-02},
  {-1.649042e-01,  6.006234e-01,  7.823414e-01, -3.604266e-01, -4.522515e-01, -1.838871e-02},
  {-3.904697e-01,  9.081805e-01, -1.508027e-01, -5.816749e-01, -4.136464e-01, -4.713542e-02},
  { 1.825547e-01, -9.717504e-01,  1.495826e-01,  5.078042e-01, -5.087135e-01, -6.173939e-02},
  {-8.566683e-01, -2.782075e-01,  4.344192e-01, -3.868549e-01, -4.541192e-01, -7.439440e-02},
  { 6.384351e-01, -7.631255e-01, -1.002002e-01,  5.049272e-01, -4.987847e-01, -1.141387e-01},
  { 7.328790e-01, -6.711794e-01,  1.113851e-01,  3.989753e-01, -5.273687e-01, -1.200603e-01},
  {-4.772638e-01, -2.468052e-01,  8.433899e-01, -5.263093e-01, -4.494753e-01, -1.061494e-01},
  { 2.962243e-01, -9.407759e-01,  1.648999e-01,  4.327748e-01, -4.857314e-01, -1.523080e-01},
  { 6.887791e-02, -6.674638e-01, -7.414498e-01, -4.026489e-01, -4.908971e-01, -1.748516e-01},
  { 4.512008e-01, -8.139743e-01, -3.658738e-01,  5.084152e-01, -4.908058e-01, -1.647195e-01},
  {-6.597521e-01,  2.048958e-02, -7.512039e-01, -6.059735e-01, -4.488521e-01, -1.876828e-01},
  {-7.978645e-01, -1.295373e-01,  5.887549e-01, -2.065791e-01, -4.738546e-01, -2.466775e-01},
  { 8.064001e-01,  2.044263e-01, -5.549134e-01,  3.469208e-01, -4.564567e-01, -3.695956e-01},
  {-3.528556e-01, -4.984218e-01, -7.918767e-01, -2.761459e-01, -4.823106e-01, -3.694950e-01},
  { 1.521431e-01, -6.224467e-01, -7.677321e-01, -3.611382e-01, -5.166691e-01, -3.871349e-01},
  { 3.097552e-01,  8.572508e-01, -4.113061e-01,  1.156661e-01, -4.178388e-01, -4.639419e-01},
  {-8.314891e-02, -7.977639e-01, -5.972093e-01, -4.961902e-01, -5.568613e-01, -4.686335e-01},
  { 9.163795e-01,  4.001534e-01,  1.122495e-02,  2.863168e-01, -4.177391e-01, -4.436993e-01},
  {-1.189326e-01,  5.078544e-01, -8.531933e-01,  2.787240e-02, -4.260563e-01, -4.977650e-01},
  {-9.938685e-01, -2.034538e-02, -1.086809e-01, -4.383436e-01, -5.325865e-01, -6.115946e-01},
  {-5.371098e-01,  7.766161e-01,  3.292123e-01, -2.486033e-01, -4.453523e-01, -5.893641e-01},
  {-2.097692e-01, -5.132225e-01, -8.322257e-01, -4.549907e-01, -5.206103e-01, -6.474938e-01},
  { 2.304026e-01, -2.383458e-01, -9.434542e-01, -1.687185e-02, -4.624080e-01, -6.116171e-01},
  { 9.201883e-01, -1.038596e-01, -3.774475e-01,  9.240960e-02, -4.759284e-01, -5.944422e-01},
  {-8.179220e-01,  5.720024e-01,  6.178015e-02, -3.257149e-01, -4.436454e-01, -6.827315e-01},
  {-9.241005e-01,  3.598095e-01, -1.287453e-01, -3.125283e-01, -4.327570e-01, -6.937801e-01},
  {-9.460024e-01, -2.105829e-01,  2.464433e-01,  1.791594e-01, -4.598817e-01,  7.712524e-01},
  {-5.267711e-02,  9.763388e-01,  2.097322e-01,  5.521303e-02, -4.514679e-01,  7.020972e-01},
  {-7.859625e-01, -5.542997e-01,  2.738886e-01, -2.472678e-01, -4.843365e-01,  5.793685e-01},
  { 7.870463e-01,  6.002086e-01,  1.425053e-01, -1.329042e-01, -4.577494e-01,  5.608189e-01},
  {-5.084138e-01, -7.318780e-01,  4.537290e-01, -2.361237e-01, -4.780862e-01,  5.172580e-01},
  {-4.402620e-01, -6.308196e-01,  6.389336e-01, -2.633788e-01, -4.754180e-01,  5.105883e-01},
  { 9.917699e-03, -9.751183e-01,  2.214631e-01,  6.488677e-02, -4.779219e-01,  4.424614e-01},
  {-7.611455e-01,  2.587805e-03, -6.485760e-01, -1.217311e-01, -4.584936e-01,  3.447299e-01},
  {-7.377244e-01, -4.694768e-01,  4.851333e-01, -5.251704e-01, -4.098481e-01,  3.165100e-01},
  {-8.328806e-01, -1.183256e-01,  5.406561e-01, -5.321345e-01, -4.125811e-01,  3.032752e-01},
  { 4.955790e-01,  3.777375e-01,  7.821227e-01, -1.750694e-01, -4.214919e-01,  2.694721e-01},
  { 6.205214e-01, -1.153976e-01,  7.756524e-01,  2.134430e-01, -4.730092e-01,  1.675142e-01},
  { 7.649559e-01, -4.065350e-01,  4.995716e-01,  4.279549e-01, -4.778332e-01,  2.064429e-01},
  { 3.809125e-01,  8.948024e-01,  2.328827e-01, -3.349699e-01, -4.334653e-01,  1.696527e-01},
  {-3.073552e-01, -4.755591e-01, -8.242428e-01, -4.505974e-01, -4.582543e-01,  1.393434e-01},
  {-9.148248e-01, -1.110180e-01, -3.882916e-01, -4.823680e-02, -4.549854e-01,  1.293065e-01},
  { 6.017073e-01, -6.615521e-01,  4.475456e-01,  5.134493e-01, -4.785797e-01, -2.228769e-02},
  { 6.147012e-01, -5.905493e-01,  5.228708e-01,  5.142109e-01, -4.549258e-01,  4.935029e-03},
  {-3.607281e-01,  5.684808e-01, -7.393950e-01, -2.431785e-01, -4.233820e-01, -2.334470e-02},
  {-9.336104e-02,  4.926485e-01,  8.652058e-01, -2.599007e-01, -4.268523e-01, -3.048737e-02},
  { 9.881208e-01, -1.533813e-01, -9.573965e-03,  5.222653e-01, -4.684555e-01, -1.015663e-01},
  {-7.707888e-01,  6.211367e-01, -1.416823e-01, -6.056827e-01, -4.412533e-01, -1.855255e-01},
  {-8.225079e-01, -5.672421e-01,  4.143955e-02, -5.470513e-01, -4.258946e-01, -1.950627e-01},
  { 2.947667e-01, -8.031152e-01, -5.178016e-01,  3.661723e-01, -4.880119e-01, -2.381454e-01},
  {-3.722004e-01, -6.541610e-01, -6.584377e-01,  3.450949e-01, -4.637744e-01, -2.574597e-01},
  { 1.472778e-01,  6.696501e-01,  7.279272e-01,  3.392508e-01, -4.495685e-01, -2.656938e-01},
  { 9.352753e-01,  9.509350e-02, -3.409066e-01,  3.716868e-01, -4.370344e-01, -3.023225e-01},
  { 4.063903e-01, -2.402464e-01, -8.815490e-01,  2.756235e-01, -4.645907e-01, -3.768339e-01},
  {-4.024307e-01, -6.606796e-01,  6.336814e-01, -4.701339e-01, -4.528311e-01, -3.418693e-01},
  { 9.436203e-01, -1.174574e-01,  3.094908e-01,  1.002202e-01, -4.590832e-01, -3.792620e-01},
  {-3.500421e-01, -3.438372e-01, -8.713475e-01,  1.839395e-01, -4.259104e-01, -5.102599e-01},
  {-3.448214e-01, -8.842852e-01, -3.148617e-01, -2.652709e-01, -4.365575e-01, -4.775159e-01},
  { 4.068015e-01, -7.176321e-01, -5.652582e-01, -2.116301e-01, -4.466413e-01, -5.079408e-01},
  {-5.286481e-01, -7.371765e-01,  4.208349e-01, -4.474609e-01, -4.957152e-01, -5.351202e-01},
  {-3.755322e-01, -9.028029e-01, -2.095769e-01, -5.148449e-01, -5.259303e-01, -5.530121e-01},
  { 5.736491e-01, -1.942962e-01,  7.957234e-01,  4.481956e-03, -4.564641e-01, -5.358258e-01},
  { 9.605302e-01, -3.703380e-02, -2.756995e-01, -4.124861e-01, -4.963867e-01, -6.380624e-01},
  {-1.873010e-01,  5.711300e-01, -7.992051e-01, -1.146860e-01, -4.584255e-01, -5.938336e-01},
  {-1.873010e-01,  5.711300e-01, -7.992051e-01,  1.033249e-01, -4.697990e-01, -5.850251e-01},
  {-5.496138e-01,  4.500046e-02, -8.342060e-01, -2.956153e-01, -4.028967e-01, -7.483277e-01},
  { 3.328027e-01,  5.376803e-01, -7.746885e-01, -2.812512e-01, -3.942939e-01, -7.440867e-01},
  {-3.890858e-01, -2.452811e-01,  8.879467e-01,  2.253069e-01, -4.434558e-01,  8.556533e-01},
  { 6.076685e-01, -7.196668e-01,  3.358850e-01,  4.094105e-01, -4.698506e-01,  7.254099e-01},
  { 3.837533e-02,  3.320448e-01,  9.424827e-01,  2.669947e-01, -4.336767e-01,  5.690118e-01},
  {-4.402752e-01, -8.386205e-01,  3.207387e-01, -2.797753e-01, -4.657369e-01,  5.678448e-01},
  { 2.022563e-02,  5.039907e-01,  8.634723e-01,  1.644665e-01, -4.277969e-01,  5.486748e-01},
  { 9.214498e-01, -1.359331e-01, -3.639401e-01,  2.455828e-01, -4.092594e-01,  3.743917e-01},
  {-2.899055e-01, -7.134347e-01, -6.379387e-01, -1.428386e-01, -4.518210e-01,  3.637365e-01},
  {-9.737850e-01,  5.571422e-02, -2.205420e-01, -1.035956e-01, -4.495886e-01,  3.208279e-01},
  { 8.876678e-01,  7.206051e-02, -4.548112e-01,  4.425211e-01, -4.607943e-01,  3.000190e-01},
  { 3.784650e-01, -7.540970e-01, -5.367514e-01,  2.218201e-01, -4.632829e-01,  1.745966e-01},
  {-4.602711e-01, -4.385378e-01, -7.719035e-01, -4.410938e-01, -4.464421e-01,  1.250919e-01},
  { 5.259096e-01, -4.547944e-01,  7.187358e-01, -6.762633e-02, -4.438437e-01,  1.427623e-01},
  {-1.299235e-01,  6.054547e-01, -7.852034e-01,  3.634997e-01, -4.318084e-01,  3.167176e-02},
  {-4.867159e-03, -7.268087e-01,  6.868228e-01,  4.054346e-01, -4.627785e-01, -4.227875e-03},
  {-2.199880e-01,  4.342656e-01,  8.735095e-01, -2.651983e-01, -4.223557e-01, -3.361938e-02},
  {-8.964303e-02,  2.568680e-01,  9.622801e-01, -4.620836e-01, -4.216166e-01, -1.258315e-01},
  {-1.509544e-01, -4.257250e-01, -8.921721e-01, -4.169169e-01, -4.622731e-01, -2.154431e-01},
  { 2.133066e-01, -6.301226e-01, -7.466229e-01,  3.632924e-01, -4.677824e-01, -2.607879e-01},
  { 8.709629e-01, -3.445875e-01, -3.502614e-01,  3.609192e-01, -4.556530e-01, -2.786220e-01},
  { 2.583044e-01,  3.838150e-01,  8.865467e-01,  3.181449e-01, -4.149960e-01, -2.799758e-01},
  {-4.073831e-01,  7.532439e-01,  5.163940e-01, -5.371903e-01, -3.917585e-01, -2.530075e-01},
  { 9.659722e-02,  6.017786e-01,  7.927998e-01,  3.734128e-01, -4.262955e-01, -2.875216e-01},
  {-3.254968e-01,  9.284634e-01, -1.789066e-01, -5.184913e-01, -3.875039e-01, -2.649478e-01},
  {-8.543629e-02, -9.794006e-02,  9.915183e-01, -3.827894e-01, -4.182936e-01, -2.838925e-01},
  { 1.291567e-01,  1.471320e-01,  9.806482e-01, -4.796942e-01, -3.937281e-01, -2.691710e-01},
  {-9.517339e-01, -2.517041e-01, -1.756348e-01, -5.449179e-01, -4.104726e-01, -3.051736e-01},
  { 5.245488e-01, -6.402970e-01, -5.611313e-01,  1.149502e-01, -4.464504e-01, -3.621097e-01},
  {-6.968781e-01, -5.011148e-01, -5.130740e-01, -5.776097e-01, -4.851994e-01, -3.653419e-01},
  {-2.620537e-01, -8.747750e-01, -4.075496e-01, -3.107539e-01, -4.634711e-01, -3.883024e-01},
  {-2.524772e-02, -9.967162e-01,  7.693636e-02, -3.578997e-01, -4.567113e-01, -3.972812e-01},
  {-8.584029e-01,  4.944305e-01,  1.366856e-01, -5.159094e-01, -4.652198e-01, -4.105994e-01},
  { 8.727373e-01,  5.452972e-02, -4.851351e-01,  2.730794e-01, -3.779255e-01, -4.797903e-01},
  {-7.065985e-01, -6.958123e-01, -1.287015e-01, -3.179352e-01, -4.143933e-01, -4.820887e-01},
  { 5.058215e-01, -8.048245e-02, -8.588756e-01,  2.289890e-01, -3.760772e-01, -5.297568e-01},
  { 4.617399e-01, -8.650441e-01,  1.962013e-01, -4.468402e-01, -4.663010e-01, -4.919539e-01},
  {-9.351397e-01, -3.494741e-01, -5.815215e-02, -5.463691e-01, -4.794123e-01, -5.541106e-01},
  { 6.031953e-01,  3.102790e-01, -7.347669e-01, -4.100932e-01, -4.524379e-01, -6.138428e-01},
  {-7.715260e-01, -9.137690e-02, -6.296013e-01, -5.297992e-01, -4.742214e-01, -5.973598e-01},
  { 1.259452e-01,  3.734912e-01, -9.190441e-01, -4.517222e-01, -4.434481e-01, -6.308722e-01},
  { 9.012954e-01, -4.097979e-01, -1.404715e-01,  1.074637e-01, -4.470901e-01, -5.668581e-01},
  {-1.121982e-01,  9.919190e-01,  5.923179e-02, -2.140668e-01, -3.965363e-01, -6.074343e-01},
  { 4.624843e-01,  7.590673e-01, -4.581758e-01, -2.469154e-01, -3.934031e-01, -7.048530e-01},
  {-9.755826e-02, -3.344441e-01, -9.373524e-01, -1.259840e-01, -4.565897e-01, -6.934093e-01},
  {-5.041531e-01,  8.632475e-01, -2.516741e-02, -3.017879e-01, -3.882537e-01, -7.285641e-01},
  {-4.367889e-01, -1.398146e-01,  8.886322e-01,  2.132533e-01, -4.132929e-01,  8.556548e-01},
  { 7.535647e-01, -1.168274e-01,  6.469092e-01,  3.993254e-01, -4.193376e-01,  8.085252e-01},
  { 1.953900e-01, -9.376421e-01, -2.874893e-01,  3.983929e-01, -4.765185e-01,  6.149104e-01},
  {-8.633656e-01, -4.971677e-01, -8.616268e-02,  1.760162e-01, -4.237586e-01,  6.333601e-01},
  {-7.314291e-02,  7.169563e-02,  9.947411e-01, -1.570465e-01, -4.069613e-01,  6.710303e-01},
  {-3.954072e-01, -5.123485e-01,  7.623333e-01, -2.975204e-01, -4.319721e-01,  5.928658e-01},
  {-7.620201e-01, -5.941273e-01,  2.575619e-01, -3.304140e-01, -4.324048e-01,  5.462341e-01},
  { 6.363354e-01,  5.124800e-01,  5.765774e-01, -1.055355e-01, -3.955426e-01,  4.684580e-01},
  {-8.219684e-01,  3.953103e-01, -4.099972e-01, -3.307415e-01, -4.116482e-01,  4.253654e-01},
  {-6.353652e-01,  1.090756e-01, -7.644694e-01, -3.054102e-01, -4.142043e-01,  3.931261e-01},
  {-5.831095e-01, -1.049579e-01, -8.055849e-01, -2.083029e-01, -4.434571e-01,  3.404061e-01},
  { 9.829961e-01,  1.514571e-01,  1.038231e-01,  2.364701e-01, -3.989168e-01,  3.413912e-01},
  {-4.135997e-01, -2.908544e-01,  8.627508e-01,  4.144303e-01, -4.558552e-01,  3.996203e-01},
  {-4.907573e-01, -7.058892e-01, -5.107618e-01, -1.085830e-01, -4.351824e-01,  2.891310e-01},
  {-4.738669e-01,  6.403959e-01,  6.044364e-01, -5.382435e-01, -3.571391e-01,  2.482495e-01},
  { 1.009957e-01,  6.840701e-01,  7.223905e-01, -1.076086e-01, -3.990974e-01,  2.111531e-01},
  { 9.902020e-01, -1.395315e-01, -5.560382e-03,  4.494617e-01, -4.318880e-01,  1.791033e-01},
  {-1.444550e-01,  1.344554e-01,  9.803339e-01,  2.496940e-01, -4.485031e-01,  1.548556e-01},
  {-2.336556e-01, -5.523002e-01,  8.002309e-01,  5.083603e-01, -4.243321e-01,  4.442631e-02},
  {-7.541296e-01,  5.936189e-01,  2.809005e-01, -2.154006e-01, -3.838325e-01, -1.983076e-03},
  { 1.284112e-02,  1.161236e-01, -9.931517e-01, -3.728299e-01, -4.184854e-01, -2.469150e-01},
  {-7.149369e-01, -1.951017e-01, -6.714168e-01, -2.448169e-01, -4.170588e-01, -2.200631e-01},
  {-1.986878e-01, -3.078915e-01, -9.304439e-01, -4.191744e-01, -4.071796e-01, -2.435258e-01},
  { 5.858680e-01, -3.213995e-01, -7.439496e-01,  5.043006e-01, -4.239695e-01, -2.473948e-01},
  {-8.521606e-01, -3.396589e-01,  3.980632e-01, -2.363067e-01, -4.219159e-01, -2.480450e-01},
  { 1.482297e-01, -7.818083e-02,  9.858578e-01,  2.892371e-01, -3.738180e-01, -2.893805e-01},
  { 8.022137e-01,  3.490906e-01,  4.843437e-01,  3.587141e-01, -3.929431e-01, -3.013435e-01},
  {-4.244958e-01, -7.219985e-01,  5.463712e-01, -5.957213e-01, -4.352351e-01, -3.346290e-01},
  {-2.042573e-01,  4.859772e-01, -8.497676e-01,  8.446157e-03, -3.885516e-01, -4.711759e-01},
  { 6.317390e-01, -5.212998e-01, -5.737181e-01, -4.405526e-01, -4.665051e-01, -4.543230e-01},
  { 6.934012e-01,  6.882434e-01,  2.133442e-01,  2.485247e-01, -3.397757e-01, -4.822740e-01},
  {-2.173463e-02,  2.054593e-01, -9.784243e-01,  2.059406e-01, -3.590084e-01, -5.389567e-01},
  { 5.541946e-01, -2.438402e-02, -8.320299e-01, -3.281871e-01, -3.955894e-01, -4.958251e-01},
  {-9.653559e-01,  1.311790e-01, -2.255662e-01, -5.578671e-01, -4.048764e-01, -4.996421e-01},
  {-4.373897e-01,  9.979322e-02, -8.937179e-01, -1.838612e-01, -3.975101e-01, -4.919221e-01},
  {-5.419016e-01,  6.206970e-01, -5.666373e-01, -5.064245e-01, -3.991992e-01, -6.022923e-01},
  {-8.265477e-01,  2.719519e-01, -4.928094e-01, -1.310289e-01, -3.993420e-01, -5.744224e-01},
  { 3.945971e-01, -2.289845e-01,  8.898647e-01,  3.204178e-01, -3.757890e-01,  8.750365e-01},
  {-6.579763e-01, -7.194374e-01,  2.224344e-01,  1.792119e-01, -4.124409e-01,  7.178274e-01},
  { 8.584316e-01, -4.906908e-01,  1.493912e-01,  4.571707e-01, -4.360889e-01,  6.720059e-01},
  { 9.011681e-01,  3.969570e-01,  1.741297e-01, -1.489038e-01, -4.028747e-01,  5.196083e-01},
  {-9.973096e-01, -5.521993e-02, -4.821059e-02, -3.492390e-01, -4.066776e-01,  4.795755e-01},
  {-3.383663e-01,  8.730682e-01, -3.510843e-01, -2.900476e-01, -3.847013e-01,  4.209275e-01},
  { 9.336438e-01, -2.545989e-01, -2.519693e-01,  2.539514e-01, -3.998011e-01,  4.238594e-01},
  { 7.809294e-01,  5.618169e-01, -2.729669e-01,  2.533786e-01, -4.001302e-01,  4.054140e-01},
  { 6.483413e-01,  9.807667e-02,  7.550063e-01, -9.443252e-02, -3.835162e-01,  4.436871e-01},
  {-9.509574e-02, -9.954547e-01, -5.171555e-03,  2.827051e-02, -3.903828e-01,  4.223933e-01},
  {-1.099043e-01,  9.147549e-01,  3.887731e-01,  7.610513e-03, -4.039725e-01,  4.214399e-01},
  {-6.252148e-01, -9.454152e-02, -7.747053e-01, -7.850213e-02, -4.132156e-01,  2.508386e-01},
  { 8.767354e-01, -1.230157e-01, -4.649755e-01,  2.829615e-01, -4.113417e-01,  2.044323e-01},
  {-8.880343e-01,  1.322902e-01, -4.403344e-01, -3.563632e-02, -4.255570e-01,  2.129327e-01},
  {-8.659836e-01, -4.524153e-01,  2.130561e-01, -2.303035e-02, -4.271978e-01,  1.841055e-01},
  { 7.783827e-03, -4.520231e-01,  8.919724e-01,  4.219021e-01, -4.265884e-01,  2.392056e-01},
  { 9.501199e-01, -2.609780e-02,  3.107910e-01,  4.448778e-01, -4.078963e-01,  2.451082e-01},
  { 6.740014e-01, -5.698401e-01,  4.701108e-01,  4.545628e-01, -4.243231e-01,  2.177099e-01},
  {-7.261019e-01,  6.349430e-01, -2.638623e-01, -3.715273e-02, -4.227764e-01,  1.619429e-01},
  {-2.172968e-01, -7.275560e-01,  6.507260e-01, -3.662328e-02, -4.178098e-01,  1.717493e-01},
  { 2.979381e-01,  2.318960e-01,  9.259898e-01, -2.737338e-01, -4.177457e-01,  1.732523e-01},
  {-1.064569e-01,  4.926746e-02, -9.930960e-01, -3.366808e-01, -3.850562e-01,  1.468305e-02},
  {-1.825143e-01,  5.164648e-01, -8.366318e-01, -2.993972e-01, -3.724438e-01,  1.125717e-02},
  {-2.072298e-01, -5.692509e-01,  7.956187e-01,  4.743491e-01, -4.191566e-01,  3.806753e-02},
  {-4.888791e-01, -2.930325e-01,  8.216625e-01, -4.050946e-01, -3.859640e-01, -1.220739e-01},
  { 4.991214e-02, -3.065421e-01,  9.505475e-01, -4.640127e-01, -3.795964e-01, -1.314091e-01},
  {-8.318951e-01, -2.128685e-02, -5.545245e-01, -5.846885e-01, -3.686419e-01, -1.584001e-01},
  { 8.789857e-02,  1.126834e-01, -9.897355e-01,  3.838198e-01, -4.036375e-01, -2.728500e-01},
  { 3.478979e-01, -3.996197e-01, -8.480985e-01,  1.666774e-01, -3.994991e-01, -3.808780e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -4.760522e-01, -4.263788e-01, -4.015874e-01},
  { 1.647096e-01, -9.406508e-01, -2.967269e-01,  1.862322e-01, -3.392276e-01, -4.692055e-01},
  {-4.300219e-01,  8.652366e-01, -2.577727e-01,  1.449640e-01, -3.478000e-01, -4.848408e-01},
  {-2.766473e-01,  7.817333e-01,  5.588912e-01,  1.583155e-01, -3.356630e-01, -4.952081e-01},
  {-8.947444e-03,  8.017164e-01, -5.976377e-01,  1.964140e-01, -3.350496e-01, -5.253190e-01},
  { 7.578817e-01, -3.269557e-01,  5.645487e-01, -5.961949e-02, -3.962942e-01, -4.581758e-01},
  {-9.380017e-01,  3.447154e-01, -3.638848e-02, -5.560455e-01, -3.772290e-01, -4.861770e-01},
  {-3.514510e-01,  8.248271e-01, -4.428797e-01, -5.311965e-01, -3.513304e-01, -4.985429e-01},
  {-9.893454e-02,  6.329481e-01, -7.678467e-01, -4.698281e-01, -3.800405e-01, -6.063093e-01},
  { 8.424554e-01, -3.867547e-01,  3.750861e-01,  1.353359e-01, -4.034036e-01, -5.583246e-01},
  {-9.138101e-01, -3.490831e-01,  2.075863e-01, -1.172892e-01, -4.195724e-01, -6.134387e-01},
  { 3.385683e-01, -9.737383e-02, -9.358900e-01,  9.185856e-02, -3.968934e-01, -6.067682e-01},
  { 4.163313e-01,  2.029819e-01, -8.862655e-01, -7.081687e-03, -3.778632e-01, -6.620846e-01},
  { 3.078862e-01,  3.863177e-02, -9.506386e-01, -1.152712e-01, -4.169642e-01, -6.988445e-01},
  {-6.037635e-01, -4.996694e-01, -6.211281e-01, -1.470065e-01, -4.280429e-01, -7.039617e-01},
  {-1.469277e-01,  2.053271e-01,  9.676017e-01,  2.304326e-01, -3.731933e-01,  8.714139e-01},
  {-4.753644e-01, -7.883468e-01,  3.905611e-01, -1.461321e-02, -4.256450e-01,  7.119473e-01},
  { 2.319640e-01, -6.117497e-01, -7.562771e-01,  2.838031e-01, -4.070293e-01,  5.615862e-01},
  { 8.607715e-01, -4.546734e-01, -2.287894e-01,  4.581518e-01, -4.158941e-01,  5.140049e-01},
  { 8.831211e-01, -1.153953e-02,  4.690032e-01,  2.792220e-01, -3.861729e-01,  5.214643e-01},
  {-9.030587e-01,  3.316209e-01, -2.729698e-01, -2.702014e-01, -3.655420e-01,  4.833300e-01},
  { 9.579003e-01, -2.722167e-01,  9.124263e-02, -1.441159e-01, -3.832715e-01,  5.126845e-01},
  { 7.118440e-01, -2.756792e-01,  6.459714e-01, -1.152668e-01, -3.582684e-01,  4.661306e-01},
  { 5.480658e-01,  6.074758e-01,  5.749756e-01, -5.458642e-02, -3.693354e-01,  3.907235e-01},
  { 9.796883e-01, -1.602181e-01,  1.205859e-01,  2.527425e-01, -3.671174e-01,  3.015581e-01},
  {-5.608603e-01, -5.485674e-01, -6.200883e-01, -5.354488e-02, -3.907225e-01,  2.283280e-01},
  {-2.860438e-01,  8.935558e-01,  3.460302e-01, -5.440839e-01, -3.325017e-01,  2.074181e-01},
  { 6.007233e-01, -2.648181e-01,  7.543228e-01,  2.741538e-01, -4.228146e-01,  1.675671e-01},
  { 1.204109e-01,  9.321429e-01,  3.414833e-01, -5.068156e-01, -3.276884e-01,  1.774863e-01},
  {-7.449928e-01, -6.656629e-01, -4.334264e-02, -4.280159e-01, -3.627394e-01,  1.680510e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -5.848413e-01, -4.058722e-01,  6.731744e-02},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -5.845059e-01, -3.751197e-01,  4.893769e-02},
  { 5.844635e-01,  5.020331e-01, -6.374679e-01,  4.295695e-01, -3.736829e-01,  6.555895e-02},
  {-1.111687e-01,  6.752682e-01, -7.291463e-01, -4.972901e-01, -3.896450e-01,  2.218845e-02},
  {-2.076156e-01, -1.429709e-01, -9.677061e-01, -4.191378e-01, -3.827087e-01,  1.669683e-02},
  {-2.331341e-01, -3.668189e-01,  9.006067e-01, -3.838702e-01, -4.145898e-01, -1.788968e-02},
  {-5.693511e-01, -8.086028e-01, -1.483268e-01, -3.962989e-01, -3.817818e-01, -1.027708e-01},
  {-1.787108e-01, -1.006196e-01,  9.787431e-01, -5.460351e-01, -3.556505e-01, -1.039446e-01},
  { 2.977437e-01, -2.236796e-01, -9.280711e-01, -3.510199e-01, -3.791559e-01, -2.160048e-01},
  { 3.006251e-01,  9.537424e-01,  3.754840e-04,  3.230529e-01, -3.844742e-01, -2.962041e-01},
  {-2.265196e-02, -7.948057e-02,  9.965790e-01, -5.591133e-01, -3.505102e-01, -2.322405e-01},
  {-7.172162e-01, -3.806763e-01,  5.836835e-01, -6.004292e-01, -3.697024e-01, -2.559694e-01},
  { 7.556294e-01,  6.181941e-01, -2.164724e-01,  3.356675e-01, -3.617426e-01, -3.186395e-01},
  {-2.540556e-01,  2.152730e-03,  9.671872e-01, -3.480812e-01, -3.661988e-01, -2.578637e-01},
  {-8.268281e-02,  3.745402e-01,  9.235168e-01, -3.690953e-01, -3.624822e-01, -2.617697e-01},
  {-9.586449e-01, -1.359148e-01, -2.500545e-01, -6.085131e-01, -3.663850e-01, -3.496325e-01},
  { 1.647096e-01, -9.406508e-01, -2.967269e-01,  1.716540e-01, -3.356586e-01, -4.886119e-01},
  { 1.647096e-01, -9.406508e-01, -2.967269e-01,  1.816661e-01, -3.344951e-01, -4.867424e-01},
  {-5.663706e-01, -3.561170e-02, -8.233809e-01,  1.192460e-01, -3.557017e-01, -4.684603e-01},
  { 1.625679e-01,  4.278416e-01, -8.891137e-01, -4.387594e-01, -3.881645e-01, -4.851900e-01},
  { 6.552064e-02,  8.246552e-01, -5.618281e-01, -4.297990e-01, -3.467489e-01, -5.625491e-01},
  { 8.093325e-01, -2.560267e-01, -5.286126e-01,  1.355757e-01, -3.956763e-01, -5.858135e-01},
  { 5.148463e-01,  3.557750e-01, -7.799727e-01,  3.778444e-02, -3.708355e-01, -6.290824e-01},
  {-4.048195e-01, -4.132340e-01, -8.156953e-01, -1.655774e-01, -4.214476e-01, -6.870202e-01},
  { 3.596357e-01,  6.469758e-01,  6.723723e-01,  3.405201e-01, -3.490182e-01,  8.548310e-01},
  {-3.348213e-01,  4.875804e-01,  8.063251e-01,  2.160885e-01, -3.403934e-01,  8.544568e-01},
  { 7.366015e-01,  4.254891e-01,  5.257159e-01,  3.927218e-01, -3.522705e-01,  8.142585e-01},
  {-6.358213e-01, -5.845637e-02,  7.696195e-01,  1.635060e-01, -3.474678e-01,  8.316522e-01},
  {-5.369135e-02, -9.585022e-01,  2.799835e-01,  5.951435e-02, -4.204895e-01,  7.443814e-01},
  {-2.104436e-01, -9.643563e-01, -1.604071e-01, -4.220020e-02, -4.103001e-01,  5.702599e-01},
  {-3.647321e-01, -2.535304e-01,  8.959313e-01, -2.149898e-01, -3.655494e-01,  6.224543e-01},
  {-1.393570e-01, -8.712781e-01, -4.705889e-01,  2.860568e-01, -3.881284e-01,  5.427402e-01},
  {-9.254569e-01,  7.873877e-02,  3.705800e-01, -3.418932e-01, -3.683533e-01,  5.798787e-01},
  {-8.819645e-01, -3.936164e-01,  2.592388e-01,  1.515667e-01, -3.835472e-01,  5.222829e-01},
  {-6.974401e-01,  6.936945e-01, -1.799037e-01, -3.311528e-01, -3.545398e-01,  5.453768e-01},
  { 6.140053e-01, -5.106269e-01, -6.018786e-01,  4.170026e-01, -4.096529e-01,  4.664934e-01},
  {-3.301542e-01, -8.957751e-01, -2.976328e-01,  3.467008e-01, -4.243168e-01,  4.449301e-01},
  {-3.301542e-01, -8.957751e-01, -2.976328e-01,  2.728539e-01, -3.835638e-01,  4.578081e-01},
  {-4.243634e-01,  7.565525e-01, -4.975379e-01, -2.221731e-01, -3.761179e-01,  4.695953e-01},
  {-7.888193e-02, -8.183692e-01, -5.692536e-01,  3.427283e-01, -4.129721e-01,  4.100362e-01},
  {-7.726625e-01, -2.374104e-01, -5.887519e-01, -1.504939e-01, -3.890414e-01,  2.626701e-01},
  {-4.124952e-01,  1.646091e-02,  9.108111e-01, -4.142395e-01, -3.786315e-01,  3.247862e-01},
  { 5.873841e-02, -9.221086e-01,  3.824469e-01, -3.153036e-01, -4.208321e-01,  2.990345e-01},
  {-1.286031e-01, -2.849508e-01,  9.498760e-01, -3.474236e-01, -3.930933e-01,  3.321180e-01},
  { 3.028964e-01, -8.811473e-01,  3.630883e-01, -4.008164e-01, -4.029625e-01,  2.986079e-01},
  { 8.991922e-01, -3.843448e-01, -2.091230e-01,  2.836899e-01, -3.802631e-01,  1.975833e-01},
  { 2.555463e-01, -4.814610e-01,  8.383862e-01,  2.857601e-01, -3.946730e-01,  1.688239e-01},
  {-5.759893e-01,  1.672289e-01,  8.001692e-01, -9.711702e-02, -3.692503e-01,  1.800944e-01},
  {-7.917003e-01,  6.028976e-01,  9.861517e-02, -5.816715e-01, -3.321314e-01,  1.097974e-01},
  { 7.028846e-01,  2.041771e-01, -6.813700e-01,  4.314580e-01, -3.527947e-01,  7.826512e-02},
  { 2.923054e-01,  8.590535e-01, -4.202198e-01, -3.487054e-01, -3.581105e-01,  4.226107e-02},
  {-3.004385e-01,  5.031954e-01, -8.102661e-01, -2.201305e-01, -3.506592e-01,  3.919324e-02},
  { 8.376116e-02,  5.887441e-01, -8.039680e-01,  1.619348e-01, -3.820617e-01, -3.532689e-02},
  { 4.531929e-02,  9.970012e-01,  6.272648e-02, -1.309052e-01, -3.478404e-01, -3.423879e-02},
  {-3.762200e-01, -8.076995e-01,  4.539603e-01, -4.352183e-01, -4.003565e-01, -3.269375e-02},
  { 8.030643e-01,  1.724350e-01, -5.703981e-01,  9.959582e-02, -3.866840e-01, -8.719949e-02},
  {-6.746855e-01, -8.278841e-02,  7.334477e-01,  2.224439e-01, -3.496508e-01, -1.470080e-01},
  {-1.932090e-02,  9.705228e-01, -2.402336e-01,  1.013618e-01, -4.618540e-01, -1.363807e-01},
  {-9.377249e-01, -2.060870e-02,  3.467668e-01,  2.097574e-01, -3.178649e-01, -1.327019e-01},
  {-7.814006e-01,  5.466329e-01, -3.010077e-01,  1.990430e-01, -3.305782e-01, -1.565818e-01},
  {-7.979206e-01,  3.856504e-01,  4.632456e-01,  1.950392e-01, -3.567255e-01, -1.685681e-01},
  { 8.623254e-01, -7.593219e-02, -5.006287e-01,  5.572395e-02, -4.362220e-01, -1.707591e-01},
  {-2.502565e-01, -8.128882e-01,  5.259129e-01, -4.703030e-01, -3.655283e-01, -1.128992e-01},
  {-2.595570e-01,  5.671632e-01,  7.816368e-01, -5.420874e-01, -3.274117e-01, -1.108833e-01},
  {-8.441334e-01,  2.019349e-01,  4.966499e-01, -5.842587e-01, -3.444237e-01, -1.338606e-01},
  {-7.552159e-01, -1.740536e-01,  6.319448e-01,  1.913899e-01, -3.419309e-01, -1.688545e-01},
  {-7.778651e-01,  3.759868e-01,  5.035473e-01,  1.981034e-01, -3.413009e-01, -1.736153e-01},
  { 6.313242e-01,  9.113507e-02, -7.701457e-01,  3.268045e-02, -4.878789e-01, -1.957617e-01},
  { 4.906344e-01,  4.875208e-01, -7.222197e-01,  2.250762e-02, -4.989378e-01, -2.099700e-01},
  { 9.343374e-01,  6.918769e-02, -3.496093e-01,  5.272670e-01, -3.624012e-01, -2.411766e-01},
  {-6.681706e-01, -3.479151e-01,  6.576498e-01,  1.580776e-01, -3.459673e-01, -2.021542e-01},
  {-8.982580e-01,  4.363059e-01,  5.262928e-02,  1.518854e-01, -4.206811e-01, -2.479711e-01},
  {-5.363279e-01,  8.429036e-01,  4.319586e-02,  4.340698e-02, -5.229722e-01, -2.569632e-01},
  {-6.646481e-01,  3.937417e-01,  6.349886e-01,  1.205872e-01, -4.501538e-01, -2.727557e-01},
  {-3.361046e-01,  9.371720e-01, -9.350072e-02, -3.528228e-02, -5.452074e-01, -3.032823e-01},
  {-8.944272e-01,  0.000000e+00, -4.472136e-01, -3.557330e-02, -5.598572e-01, -3.264597e-01},
  { 2.600854e-02,  9.957753e-01, -8.806276e-02,  8.301276e-02, -3.438508e-01, -2.601469e-01},
  { 9.452280e-01,  3.242237e-01, -3.772232e-02, -3.070202e-02, -5.516541e-01, -3.433885e-01},
  { 3.324630e-01,  8.061702e-01, -4.894465e-01, -6.150451e-01, -3.198692e-01, -2.994796e-01},
  {-7.556409e-01, -4.008521e-01,  5.180003e-01,  6.059936e-02, -3.733806e-01, -3.156942e-01},
  {-7.424877e-01,  2.427504e-01,  6.243269e-01, -3.844499e-02, -5.334478e-01, -3.606922e-01},
  {-5.799258e-01,  7.384729e-01, -3.440114e-01, -6.174412e-01, -3.330553e-01, -3.228260e-01},
  {-5.981845e-01,  7.444615e-01, -2.965674e-01,  5.700923e-02, -3.493015e-01, -2.992402e-01},
  {-5.257873e-01,  2.476856e-01,  8.137565e-01, -1.711097e-02, -4.710188e-01, -3.629108e-01},
  { 9.626200e-01,  1.465430e-01, -2.277890e-01, -5.432592e-02, -4.929146e-01, -3.705183e-01},
  {-4.988590e-01,  2.397001e-01, -8.328766e-01, -5.824185e-01, -3.462520e-01, -3.862623e-01},
  {-3.061843e-01,  1.727268e-01, -9.361713e-01,  8.481132e-02, -3.563496e-01, -4.427671e-01},
  {-7.079347e-01, -2.668886e-01, -6.539105e-01, -4.789949e-01, -3.785321e-01, -3.997501e-01},
  { 1.123527e-01, -9.905415e-01,  7.876801e-02,  1.687061e-01, -3.329170e-01, -4.875719e-01},
  {-8.593282e-01, -2.631112e-01,  4.385517e-01, -4.797718e-01, -3.543792e-01, -4.479073e-01},
  { 1.872377e-01,  9.811239e-01, -4.835212e-02, -4.599110e-01, -3.582999e-01, -4.746865e-01},
  { 1.424815e-01,  9.862871e-01, -8.328734e-02, -4.759339e-01, -3.559213e-01, -4.661681e-01},
  { 9.753698e-01, -1.011578e-01,  1.960123e-01, -5.951645e-02, -3.531043e-01, -4.563167e-01},
  { 3.949597e-01,  2.209199e-01, -8.917405e-01, -3.912753e-01, -3.361029e-01, -5.615873e-01},
  { 7.024379e-01, -2.657161e-01,  6.602847e-01,  1.352480e-01, -3.772853e-01, -5.415949e-01},
  {-6.127593e-01, -7.820420e-01, -1.137382e-01, -1.754095e-01, -3.988885e-01, -7.062421e-01},
  { 2.485888e-02,  8.727819e-01,  4.874770e-01,  2.607511e-01, -3.239735e-01,  8.385365e-01},
  {-8.370656e-02,  4.764554e-03,  9.964790e-01,  2.045193e-02, -3.738697e-01,  7.527851e-01},
  {-9.171522e-01, -2.909214e-01,  2.723904e-01, -7.310864e-02, -3.823895e-01,  6.706615e-01},
  {-6.425117e-01, -7.539356e-01, -1.369659e-01,  1.426445e-01, -3.779479e-01,  5.629566e-01},
  { 5.771823e-01, -7.449635e-01, -3.344999e-01,  2.977181e-01, -3.783655e-01,  4.995963e-01},
  {-3.227685e-01, -3.816604e-01, -8.661153e-01, -2.419480e-01, -3.558932e-01,  4.856922e-01},
  { 6.801373e-01, -7.142825e-01,  1.649660e-01, -1.132129e-01, -3.340379e-01,  5.068604e-01},
  {-3.641322e-01, -9.191460e-01, -1.502609e-01, -2.850075e-02, -3.851691e-01,  4.574757e-01},
  {-3.301739e-01, -7.212177e-01,  6.089583e-01,  1.003736e-01, -3.500232e-01,  4.703372e-01},
  { 2.549542e-01, -6.501610e-01, -7.157437e-01,  3.351475e-01, -3.662023e-01,  3.789869e-01},
  {-8.165028e-01,  1.402504e-01,  5.600473e-01, -4.731831e-02, -3.465231e-01,  3.890266e-01},
  { 8.140516e-01, -4.988924e-02, -5.786459e-01,  4.366828e-01, -3.548108e-01,  3.031495e-01},
  { 4.890485e-01, -1.508370e-01, -8.591157e-01,  3.807614e-01, -3.469795e-01,  2.905242e-01},
  { 2.724401e-01,  1.393770e-01,  9.520245e-01,  4.355155e-01, -3.443643e-01,  2.578202e-01},
  {-7.844929e-01, -6.057179e-01, -1.329541e-01, -4.959747e-02, -3.791933e-01,  2.096256e-01},
  {-2.528486e-01, -6.973134e-02,  9.649897e-01,  3.966307e-01, -3.402884e-01,  2.468145e-01},
  {-2.528486e-01, -6.973134e-02,  9.649897e-01, -2.271582e-01, -3.675658e-01,  1.653426e-01},
  { 6.400925e-02,  9.298915e-01,  3.622218e-01, -4.881830e-01, -3.115695e-01,  1.229840e-01},
  {-3.052364e-01,  1.702989e-01, -9.369254e-01, -2.967210e-01, -3.533230e-01,  8.347080e-02},
  { 4.806346e-01,  4.415720e-01, -7.576308e-01, -3.305386e-01, -3.492093e-01,  8.279222e-02},
  {-2.326302e-01,  9.550192e-01,  1.839064e-01, -5.295694e-01, -2.950901e-01,  8.029941e-02},
  {-3.330816e-01,  4.529714e-01, -8.269665e-01, -1.942312e-01, -3.356673e-01,  3.920764e-02},
  { 6.426719e-02, -9.607012e-01, -2.700427e-01, -1.668867e-01, -3.335093e-01,  3.026150e-02},
  {-4.973423e-01,  5.603243e-01, -6.623349e-01, -1.198533e-01, -3.393685e-01, -1.256743e-02},
  {-5.886607e-01,  7.297343e-01, -3.478024e-01,  2.835488e-01, -3.350879e-01, -7.430364e-02},
  {-6.963553e-01,  2.789608e-01,  6.612641e-01,  2.846270e-01, -3.254004e-01, -1.008313e-01},
  {-2.410855e-01, -5.845793e-01,  7.746902e-01, -4.619601e-01, -3.772457e-01, -1.606229e-02},
  { 1.686848e-02,  5.590987e-01,  8.289294e-01, -2.494891e-01, -3.235680e-01, -2.595261e-02},
  {-4.511993e-01, -8.490354e-01, -2.748784e-01, -4.982719e-01, -3.886587e-01, -6.201506e-02},
  {-5.456796e-01, -4.702552e-01,  6.936092e-01,  2.561808e-01, -2.840188e-01, -8.561508e-02},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  2.093762e-01, -3.123422e-01, -1.298317e-01},
  { 4.825019e-02,  1.901229e-01,  9.805739e-01, -4.885770e-01, -3.385799e-01, -1.113510e-01},
  {-7.243493e-01,  6.753038e-01,  1.388628e-01,  2.108276e-01, -3.185843e-01, -1.653929e-01},
  {-7.083761e-01,  6.452682e-01, -2.860635e-01, -5.698103e-01, -3.233812e-01, -1.547703e-01},
  { 5.571180e-02, -2.354339e-01, -9.702923e-01, -3.006679e-01, -3.613214e-01, -2.131057e-01},
  {-7.004800e-01,  6.561949e-01,  2.805993e-01, -2.498683e-01, -3.624904e-01, -2.126469e-01},
  {-6.077616e-01,  1.023227e-01, -7.874998e-01, -4.547009e-01, -3.304817e-01, -2.376459e-01},
  { 4.554717e-01,  1.365639e-01, -8.797135e-01,  5.121660e-01, -3.581015e-01, -2.593170e-01},
  {-5.232231e-01,  8.215833e-01, -2.263593e-01,  2.295174e-01, -2.954525e-01, -2.528813e-01},
  { 1.975899e-01,  4.043441e-01, -8.930084e-01,  4.162725e-01, -3.461785e-01, -2.618599e-01},
  { 5.938787e-02,  3.966440e-01,  9.160495e-01, -5.494620e-01, -3.007611e-01, -2.544072e-01},
  { 2.948071e-02,  8.715586e-01, -4.894043e-01, -5.793893e-01, -3.083648e-01, -2.563109e-01},
  { 1.164295e-01,  9.655859e-01,  2.325682e-01, -4.606804e-01, -3.044786e-01, -2.808222e-01},
  {-1.427588e-01,  9.783943e-01,  1.495479e-01,  1.487895e-01, -3.504891e-01, -3.157825e-01},
  { 3.725097e-01,  2.249444e-01, -9.003536e-01,  2.867009e-01, -3.487124e-01, -3.873990e-01},
  {-1.343071e-01, -9.748330e-01, -1.779387e-01, -5.321099e-01, -3.582268e-01, -3.972794e-01},
  { 1.093509e-01,  9.812914e-01,  1.584604e-01,  1.870266e-01, -3.403117e-01, -4.544217e-01},
  { 1.702300e-01, -7.730227e-03, -9.853741e-01, -1.361356e-02, -3.435676e-01, -4.229971e-01},
  {-5.214490e-01,  5.608256e-01,  6.430907e-01, -3.791538e-01, -3.538840e-01, -4.577957e-01},
  {-1.199036e-01,  8.458309e-01, -5.198011e-01, -3.900480e-01, -3.193143e-01, -5.444778e-01},
  { 0.000000e+00, -8.944272e-01, -4.472136e-01, -3.901948e-01, -3.190671e-01, -5.483418e-01},
  { 4.520168e-01, -2.223433e-01,  8.638543e-01,  8.708599e-02, -3.429052e-01, -4.940687e-01},
  {-8.497747e-01, -5.267542e-01, -2.032161e-02, -1.447543e-01, -3.347928e-01, -5.607814e-01},
  { 9.692041e-01,  5.522267e-02,  2.399874e-01,  1.428155e-01, -3.405147e-01, -5.616007e-01},
  { 1.018510e-01,  9.112864e-01,  3.989782e-01, -2.301222e-02, -3.525167e-01, -5.903329e-01},
  {-3.859933e-02, -9.688558e-01, -2.445989e-01, -3.353303e-01, -3.878539e-01, -6.526958e-01},
  {-7.261303e-01, -6.867843e-01, -3.259182e-02, -3.867885e-01, -3.908301e-01, -6.719779e-01},
  {-2.645801e-01, -3.220571e-01, -9.089975e-01, -3.785349e-01, -3.794096e-01, -6.878749e-01},
  {-1.244462e-01,  9.552116e-01,  2.684845e-01,  1.757678e-01, -2.986977e-01,  7.766725e-01},
  {-1.549082e-01,  9.836603e-01,  9.173805e-02,  2.839503e-01, -3.196343e-01,  7.460762e-01},
  { 1.012421e-01,  9.388133e-01,  3.292109e-01,  3.487478e-01, -3.002897e-01,  7.278274e-01},
  {-8.345172e-01, -3.858776e-01,  3.932931e-01, -6.542931e-02, -3.683567e-01,  7.455209e-01},
  {-4.187127e-02,  9.916038e-01,  1.223464e-01,  2.696313e-01, -3.212943e-01,  7.110429e-01},
  { 6.955390e-01,  2.023440e-01,  6.894073e-01,  4.205125e-01, -3.399534e-01,  7.197170e-01},
  {-9.588918e-01, -2.670441e-01,  9.598999e-02, -8.587530e-02, -3.466933e-01,  6.766270e-01},
  { 3.930173e-01, -3.366770e-01,  8.556787e-01, -1.690290e-01, -3.288218e-01,  6.502881e-01},
  { 6.872319e-02, -9.513420e-01, -3.003757e-01,  8.018118e-02, -3.651602e-01,  5.589573e-01},
  {-5.688735e-01, -2.161536e-01,  7.935115e-01, -2.816905e-01, -3.383947e-01,  6.387568e-01},
  {-8.505744e-01, -5.164329e-01, -9.909732e-02, -7.888976e-02, -3.549830e-01,  5.586095e-01},
  {-9.130163e-01, -2.889867e-01, -2.879030e-01, -6.036166e-02, -3.549418e-01,  4.509127e-01},
  {-8.230102e-01, -4.414285e-01, -3.574843e-01, -4.522178e-02, -3.550954e-01,  4.243644e-01},
  {-3.227050e-01, -5.214084e-01, -7.899334e-01, -1.960741e-01, -3.396781e-01,  4.237177e-01},
  {-6.636368e-01,  2.040203e-01,  7.196957e-01, -5.147318e-02, -3.172988e-01,  3.659073e-01},
  { 2.237973e-01,  1.036600e-01,  9.691075e-01,  2.607041e-01, -3.273553e-01,  2.878938e-01},
  { 5.638505e-01, -8.062116e-01,  1.791525e-01, -2.248583e-01, -3.895438e-01,  2.988218e-01},
  { 8.643149e-02, -5.812337e-01,  8.091335e-01, -2.394288e-01, -3.856063e-01,  3.346363e-01},
  {-6.833687e-02,  8.026329e-02,  9.944284e-01, -2.812502e-01, -3.827128e-01,  3.378195e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.150887e-01, -3.438751e-01,  2.247310e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -2.132747e-01, -3.520499e-01,  1.786976e-01},
  {-8.079511e-01,  2.116180e-01,  5.499390e-01, -4.841583e-01, -3.123474e-01,  1.241600e-01},
  { 7.716735e-01, -1.652402e-01,  6.141788e-01,  3.645782e-01, -3.236278e-01,  8.454281e-02},
  {-2.444050e-01, -7.742320e-01, -5.838074e-01, -2.658482e-01, -3.353395e-01,  6.681953e-02},
  { 1.718666e-01, -3.324786e-01, -9.273187e-01, -5.313342e-01, -2.966361e-01,  3.065303e-02},
  { 6.509215e-01,  2.251381e-01, -7.249925e-01,  1.411606e-01, -3.328426e-01, -1.670341e-02},
  {-7.467518e-01, -1.835230e-01,  6.392816e-01,  3.050399e-01, -3.081545e-01, -8.232161e-02},
  {-7.852451e-01, -2.227317e-02,  6.187844e-01,  2.676919e-01, -2.720417e-01, -6.465672e-02},
  {-4.846075e-01,  8.696483e-01, -9.416600e-02, -6.263742e-02, -3.090735e-01, -7.639414e-02},
  { 3.829812e-01,  2.291998e-01,  8.948703e-01, -3.744048e-01, -3.237587e-01, -5.449939e-03},
  {-7.184559e-01, -6.057476e-01,  3.418933e-01, -5.313321e-01, -3.666289e-01, -4.824248e-02},
  { 6.022703e-02,  8.174788e-01,  5.728012e-01, -1.803347e-01, -3.206777e-01, -9.911797e-02},
  {-5.410152e-01,  8.045319e-01, -2.450123e-01, -4.871259e-01, -2.977373e-01, -1.309454e-01},
  {-3.272835e-01,  9.369748e-01, -1.223266e-01, -5.291048e-01, -3.015439e-01, -1.715997e-01},
  {-9.640780e-01, -2.169720e-01, -1.532210e-01, -2.443686e-01, -3.375747e-01, -2.825344e-01},
  {-2.417192e-01,  8.934301e-01,  3.786218e-01,  1.997056e-01, -3.275074e-01, -3.350055e-01},
  {-1.555031e-01,  6.989033e-01,  6.981067e-01,  1.638051e-01, -3.271528e-01, -3.512026e-01},
  {-3.496081e-01,  8.100964e-01,  4.706571e-01, -3.899215e-01, -3.196487e-01, -3.503707e-01},
  {-4.407765e-02,  9.389161e-01, -3.413118e-01, -5.264499e-01, -3.370389e-01, -3.617909e-01},
  {-5.953007e-01,  5.674094e-01,  5.689145e-01, -5.498244e-01, -3.527142e-01, -3.706157e-01},
  {-5.953007e-01,  5.674094e-01,  5.689145e-01, -5.602701e-01, -3.517774e-01, -3.824802e-01},
  {-1.244382e-01,  2.898659e-01, -9.489430e-01,  6.077417e-02, -3.486281e-01, -4.344421e-01},
  {-4.828912e-01, -8.598606e-01, -1.656982e-01, -5.778158e-01, -3.571226e-01, -3.923743e-01},
  { 1.423529e-01,  1.971489e-02,  9.896197e-01,  1.560647e-02, -3.378217e-01, -4.281602e-01},
  {-5.177642e-01, -8.263838e-01, -2.213822e-01, -4.862112e-01, -3.510163e-01, -4.226440e-01},
  {-3.425668e-01, -9.105093e-01,  2.315616e-01,  4.195363e-01, -3.694400e-01, -4.650910e-01},
  { 9.099609e-01,  3.499595e-01,  2.224849e-01, -5.369468e-02, -3.245577e-01, -4.574698e-01},
  {-5.680568e-01,  7.338673e-01, -3.724920e-01, -3.716265e-01, -3.115782e-01, -5.237442e-01},
  {-1.638077e-01, -5.942969e-01, -7.873870e-01, -1.719152e-01, -3.294958e-01, -5.184122e-01},
  {-9.948718e-01,  7.772835e-02,  6.471819e-02, -3.030566e-01, -3.228572e-01, -5.313232e-01},
  { 5.733778e-01,  3.660990e-01,  7.329457e-01,  9.189373e-02, -3.340818e-01, -4.918605e-01},
  {-3.715810e-01,  6.673427e-01,  6.454310e-01, -3.559785e-01, -3.293774e-01, -6.141462e-01},
  { 3.709555e-01,  2.860174e-01, -8.835078e-01,  1.396440e-02, -3.477162e-01, -5.831419e-01},
  { 3.799004e-01, -6.792740e-02, -9.225299e-01, -5.337125e-02, -3.403889e-01, -5.980285e-01},
  {-9.736199e-01,  2.269431e-01,  2.368862e-02, -3.884822e-01, -3.675618e-01, -6.719607e-01},
  {-2.734679e-02,  2.840694e-01, -9.584136e-01, -3.588832e-01, -3.481076e-01, -6.877627e-01},
  {-1.351523e-01, -5.452059e-01,  8.273357e-01, -2.130489e-02, -3.620957e-01,  7.779799e-01},
  {-7.614552e-04,  9.538105e-01,  3.004079e-01,  1.453250e-01, -2.989068e-01,  6.935788e-01},
  { 9.388576e-01,  1.300855e-01,  3.187853e-01, -9.779596e-02, -2.785102e-01,  5.574284e-01},
  { 9.908148e-01, -5.076582e-03, -1.351299e-01,  4.653147e-01, -3.290660e-01,  5.047323e-01},
  { 7.336625e-02, -9.972647e-01,  8.982386e-03,  8.426728e-02, -3.473229e-01,  4.974154e-01},
  {-9.259484e-01,  3.180275e-01, -2.036615e-01, -6.623746e-02, -3.389549e-01,  4.714877e-01},
  {-2.995977e-01, -9.526885e-01, -5.124195e-02, -3.892956e-01, -3.738593e-01,  3.783155e-01},
  { 9.893272e-01,  5.725206e-02, -1.339924e-01,  2.492858e-01, -3.124208e-01,  3.256417e-01},
  {-8.928103e-01, -2.434151e-01, -3.789971e-01, -1.355855e-01, -3.396738e-01,  3.168184e-01},
  { 3.822930e-01, -8.537329e-01,  3.535424e-01,  3.427190e-01, -3.188889e-01,  2.388028e-01},
  {-6.770062e-01, -5.756226e-01,  4.586080e-01, -4.501584e-01, -3.572568e-01,  2.892430e-01},
  { 9.311204e-02,  5.854133e-01,  8.053703e-01, -3.828975e-01, -3.185669e-01,  2.586926e-01},
  { 9.830875e-01,  2.569962e-02,  1.813237e-01,  4.549040e-01, -3.043888e-01,  2.231486e-01},
  {-3.901201e-01, -7.149228e-01,  5.802513e-01, -1.134875e-01, -3.429438e-01,  1.873253e-01},
  {-1.627634e-01, -2.894281e-01,  9.432600e-01, -1.510286e-01, -3.426293e-01,  1.742484e-01},
  {-7.933204e-01, -2.865603e-01,  5.371462e-01, -5.072761e-01, -2.991372e-01,  1.041899e-01},
  {-3.610004e-01, -6.737664e-01, -6.447616e-01, -3.111791e-01, -3.206292e-01,  7.750530e-02},
  {-3.994920e-01, -1.054561e-01, -9.106510e-01, -4.369623e-01, -3.072767e-01,  4.560370e-02},
  {-5.619817e-01, -7.166647e-01, -4.129991e-01, -4.985873e-01, -3.006216e-01,  3.815122e-02},
  {-1.073405e-01,  9.874486e-01,  1.158582e-01, -5.179420e-01, -2.956316e-01,  5.582890e-02},
  {-2.612094e-02,  8.978524e-01, -4.395210e-01, -1.411109e-01, -3.193981e-01,  6.195916e-04},
  {-1.057708e-01, -1.775963e-01,  9.784029e-01, -4.514274e-01, -3.169444e-01,  8.951331e-04},
  {-6.482912e-01,  3.461908e-01,  6.781375e-01, -4.388568e-02, -2.887960e-01, -8.478266e-02},
  {-7.799948e-01, -1.004882e-01, -6.176651e-01, -5.131132e-01, -3.305511e-01, -1.014147e-01},
  { 3.028549e-01,  7.366233e-01,  6.047024e-01, -2.522187e-01, -2.968153e-01, -9.433686e-02},
  {-9.276833e-02,  9.938507e-01,  6.045474e-02,  2.689447e-01, -2.750495e-01, -1.460245e-01},
  { 4.740815e-01,  5.693403e-01, -6.716385e-01,  5.107432e-01, -3.171546e-01, -2.352369e-01},
  { 5.808496e-02,  4.792515e-01, -8.757535e-01,  3.484997e-01, -2.699413e-01, -2.677604e-01},
  {-4.275053e-01, -8.293731e-01, -3.596936e-01, -2.561907e-01, -3.104266e-01, -3.030553e-01},
  { 8.327646e-01, -1.292506e-01,  5.383283e-01,  2.871340e-01, -3.086254e-01, -3.784442e-01},
  {-1.348859e-01, -7.461967e-01,  6.519175e-01,  4.150929e-01, -3.369225e-01, -3.686736e-01},
  {-3.121674e-01,  9.489003e-01, -4.625640e-02, -3.937043e-01, -3.203610e-01, -3.596204e-01},
  { 8.903579e-01, -4.317535e-01,  1.444012e-01,  5.174401e-01, -3.497794e-01, -4.036000e-01},
  {-5.392957e-01, -4.176824e-01,  7.312328e-01, -5.740155e-01, -3.442138e-01, -3.767303e-01},
  { 8.302191e-01, -5.454205e-01, -1.151205e-01,  5.132835e-01, -3.671093e-01, -4.479821e-01},
  {-7.257709e-01, -6.738726e-01,  1.383920e-01,  4.037993e-01, -3.583270e-01, -4.446752e-01},
  {-5.139784e-01,  5.131210e-01,  6.874103e-01, -3.157398e-01, -3.143428e-01, -4.480430e-01},
  { 3.804673e-02, -8.287386e-01, -5.583410e-01,  1.961919e-01, -3.319894e-01, -5.151128e-01},
  { 4.917909e-01, -4.123460e-01, -7.668849e-01, -4.662622e-01, -3.600614e-01, -4.856527e-01},
  { 7.942592e-02, -9.588497e-01, -2.725781e-01, -5.038629e-01, -3.616729e-01, -4.985415e-01},
  { 4.147604e-01, -1.913508e-01, -8.895835e-01,  4.990702e-01, -3.496697e-01, -4.974755e-01},
  { 3.605960e-02,  1.689488e-01, -9.849650e-01, -2.504787e-01, -3.399602e-01, -6.274851e-01},
  {-8.466825e-03,  5.361746e-01,  8.440646e-01, -5.983134e-02, -3.251368e-01, -6.154165e-01},
  { 6.627083e-01,  3.995291e-01, -6.333989e-01, -3.260882e-01, -3.352097e-01, -6.714110e-01},
  { 8.538015e-01,  1.112760e-01, -5.085672e-01,  1.151939e-01, -2.971680e-01, -6.044100e-01},
  {-3.224901e-01, -4.432491e-01, -8.363793e-01, -2.405776e-01, -3.402579e-01, -7.438543e-01},
  {-6.566629e-01, -1.920788e-01,  7.293146e-01, -6.157614e-02, -3.184376e-01,  7.769591e-01},
  { 5.276604e-02, -7.856215e-01,  6.164532e-01,  4.283513e-01, -3.298070e-01,  7.305601e-01},
  { 9.911522e-01, -2.471114e-02,  1.304097e-01,  4.683352e-01, -3.160689e-01,  6.609537e-01},
  {-7.011050e-01, -3.868004e-01,  5.990302e-01,  3.633977e-01, -2.986323e-01,  7.188151e-01},
  {-2.886081e-01,  8.240138e-01,  4.875516e-01,  2.851748e-01, -2.898934e-01,  6.400190e-01},
  { 6.954660e-02,  8.254529e-01,  5.601702e-01,  2.121616e-01, -2.921998e-01,  6.316462e-01},
  { 5.189927e-01, -1.399118e-01,  8.432504e-01, -1.399395e-01, -2.952363e-01,  6.657059e-01},
  { 1.327258e-01, -9.862710e-01, -9.825076e-02, -3.012129e-01, -3.611751e-01,  4.080003e-01},
  {-4.267735e-01, -7.311380e-01, -5.322608e-01, -1.825615e-01, -3.139094e-01,  3.754561e-01},
  { 2.216788e-01, -9.750512e-01, -1.156171e-02, -3.037391e-01, -3.642642e-01,  3.838439e-01},
  {-8.744622e-01,  4.092768e-01,  2.604002e-01, -1.164403e-02, -2.903025e-01,  3.890739e-01},
  {-1.755932e-01,  3.319117e-02,  9.839032e-01,  4.247470e-01, -2.868292e-01,  4.058342e-01},
  {-8.847377e-01, -4.659283e-01,  1.224786e-02, -1.241491e-01, -3.166049e-01,  2.622537e-01},
  { 8.422642e-01, -2.925215e-01, -4.527937e-01,  4.303716e-01, -3.022269e-01,  2.828811e-01},
  {-7.188908e-01, -6.950926e-01, -6.489026e-03, -2.715732e-01, -3.311420e-01,  3.036902e-01},
  { 6.824597e-01, -7.308987e-01, -5.989416e-03, -1.775727e-01, -3.525057e-01,  2.371065e-01},
  { 9.304731e-02, -2.045441e-01,  9.744250e-01, -4.661536e-01, -3.289201e-01,  3.108023e-01},
  {-1.564524e-01, -9.837952e-01,  8.757568e-02, -1.421647e-01, -3.228734e-01,  2.135941e-01},
  { 7.366419e-01, -1.358986e-01, -6.624880e-01,  4.454672e-01, -2.858707e-01,  9.836037e-02},
  { 3.397259e-01, -3.521688e-01, -8.721029e-01, -3.786751e-01, -2.977648e-01,  7.199570e-02},
  {-2.327040e-01, -8.256568e-01, -5.139451e-01, -2.843140e-01, -3.240412e-01,  2.365250e-02},
  {-9.100568e-01, -2.366185e-01,  3.403064e-01, -5.515357e-01, -3.162940e-01, -3.098094e-02},
  { 7.244801e-01, -6.022766e-01, -3.352486e-01,  1.054054e-01, -3.167407e-01, -9.641949e-02},
  {-8.666462e-01,  4.932524e-01, -7.501078e-02, -2.807819e-02, -2.730269e-01, -6.905586e-02},
  { 7.052108e-01,  4.288331e-01,  5.646061e-01, -3.928870e-01, -2.846440e-01, -4.834122e-02},
  {-1.007809e-01,  5.568346e-01, -8.244867e-01,  3.274724e-01, -2.986429e-01, -1.150957e-01},
  { 2.112722e-01,  6.890715e-01,  6.932132e-01, -3.235128e-01, -2.872495e-01, -8.724179e-02},
  { 7.492114e-01,  6.583610e-01,  7.240981e-02, -4.427744e-01, -2.918392e-01, -1.448280e-01},
  {-3.037217e-01,  9.342502e-01, -1.868950e-01, -4.433313e-01, -2.894571e-01, -1.607247e-01},
  { 1.376120e-01,  9.883639e-01,  6.480516e-02,  3.266638e-01, -3.073637e-01, -1.314121e-01},
  {-1.042753e-01,  6.118745e-01,  7.840512e-01, -1.640217e-01, -2.870825e-01, -1.276658e-01},
  { 5.323572e-01, -8.411394e-01, -9.529077e-02,  6.991847e-02, -3.255523e-01, -1.790212e-01},
  { 6.279274e-01,  6.974832e-01, -3.452888e-01,  5.116746e-01, -2.889232e-01, -2.004758e-01},
  {-1.741726e-01,  9.639003e-01,  2.013956e-01,  3.184332e-01, -2.589046e-01, -1.990438e-01},
  {-1.206612e-01,  9.913807e-01, -5.104204e-02,  2.979290e-01, -2.585096e-01, -2.251647e-01},
  { 2.251904e-01, -6.600211e-01, -7.167018e-01, -5.062889e-02, -3.051649e-01, -3.766731e-01},
  {-4.244621e-01,  3.876696e-01,  8.182569e-01, -3.521272e-01, -3.037968e-01, -3.275572e-01},
  { 9.003295e-01, -2.884753e-01, -3.258660e-01,  2.621590e-01, -2.961476e-01, -4.269416e-01},
  {-4.080248e-01, -3.760916e-01, -8.319080e-01,  1.012060e-01, -3.231023e-01, -4.581359e-01},
  {-1.182049e-01, -2.169778e-01, -9.689934e-01, -2.993513e-02, -3.048011e-01, -4.393072e-01},
  { 1.437195e-01, -1.085009e-01, -9.836525e-01, -3.431948e-01, -3.083439e-01, -4.379616e-01},
  { 2.881292e-01, -8.598872e-01, -4.213973e-01, -1.867471e-01, -3.214830e-01, -5.404267e-01},
  {-4.498293e-01, -8.894309e-01,  8.103113e-02, -1.623463e-01, -3.154823e-01, -5.777695e-01},
  {-9.174179e-01,  3.689032e-01,  1.491809e-01, -3.047691e-01, -3.037310e-01, -5.913261e-01},
  {-2.286963e-01,  9.341726e-01, -2.738967e-01, -3.462721e-01, -3.077977e-01, -6.479996e-01},
  {-9.119210e-01, -3.073694e-01, -2.718897e-01, -2.639698e-01, -3.161831e-01, -7.306693e-01},
  { 8.602144e-01, -4.542154e-01,  2.317747e-01,  4.623418e-01, -3.053258e-01,  7.120078e-01},
  {-5.132694e-01,  5.092682e-01,  6.907969e-01,  2.956901e-01, -2.695087e-01,  6.256160e-01},
  { 4.274637e-01, -6.652158e-01,  6.121787e-01,  1.193146e-01, -2.760116e-01,  6.441504e-01},
  {-1.017582e-01, -7.705136e-02,  9.918208e-01, -2.345373e-01, -2.745270e-01,  6.757694e-01},
  { 9.838659e-01,  1.582333e-01, -8.348823e-02,  4.348179e-01, -2.924601e-01,  5.621817e-01},
  {-7.631613e-02,  6.724347e-01,  7.362115e-01,  2.251373e-01, -2.665028e-01,  6.095203e-01},
  { 8.956949e-01,  3.154798e-01,  3.133739e-01, -1.151461e-01, -2.673819e-01,  6.160746e-01},
  {-1.286134e-01, -9.916007e-01, -1.365883e-02, -2.782625e-01, -2.898273e-01,  5.495690e-01},
  { 2.910619e-01,  9.488384e-01,  1.224275e-01, -1.717258e-01, -2.697152e-01,  5.127530e-01},
  {-4.602855e-01, -8.663435e-01,  1.938716e-01, -2.755868e-01, -2.844804e-01,  5.079538e-01},
  {-1.487859e-01, -8.035886e-01,  5.762882e-01, -2.981713e-01, -2.923074e-01,  4.791745e-01},
  { 3.226247e-01,  1.553048e-01, -9.336990e-01,  3.543175e-01, -2.853416e-01,  4.174435e-01},
  {-5.500553e-01, -6.861924e-01,  4.760033e-01, -4.056841e-01, -3.105913e-01,  4.632148e-01},
  { 9.969814e-01, -6.692069e-02,  3.936451e-02, -2.572729e-02, -2.635027e-01,  4.019189e-01},
  {-6.241770e-01, -5.193685e-01, -5.836604e-01, -4.314773e-01, -3.187851e-01,  3.382060e-01},
  { 1.614200e-01, -9.666620e-01,  1.987666e-01, -1.696545e-01, -3.071876e-01,  3.273508e-01},
  { 7.127129e-02, -9.971730e-01,  2.380240e-02, -1.461640e-01, -3.116942e-01,  2.606563e-01},
  {-6.528918e-01, -1.116333e-01,  7.491797e-01, -2.945215e-01, -2.995506e-01,  2.475680e-01},
  {-4.812925e-02,  3.012944e-01,  9.523157e-01, -3.513422e-01, -2.827849e-01,  2.212193e-01},
  {-7.821314e-01, -6.135641e-01,  1.086717e-01, -5.381074e-01, -2.809274e-01,  9.300438e-02},
  {-7.688453e-01, -5.974787e-01, -2.278072e-01, -5.364057e-01, -2.698690e-01,  3.624803e-02},
  {-3.142829e-02, -1.656664e-01, -9.856809e-01, -3.918202e-01, -2.854360e-01,  1.040502e-02},
  { 3.463579e-01, -1.896447e-01,  9.187334e-01,  5.099643e-01, -2.778437e-01,  8.535820e-02},
  {-3.115328e-01,  7.400995e-01, -5.959865e-01,  2.159199e-01, -2.694795e-01,  4.960615e-02},
  { 7.189742e-01, -2.168547e-01, -6.603410e-01,  1.744484e-01, -2.731175e-01,  4.644413e-02},
  {-1.355155e-01, -6.715093e-01, -7.284991e-01, -3.193142e-01, -2.901497e-01, -3.493448e-02},
  {-9.491538e-01,  2.066508e-01,  2.374920e-01,  3.284053e-01, -2.629448e-01, -2.899060e-02},
  {-2.186048e-01,  8.166209e-01, -5.341743e-01, -3.475179e-02, -2.509849e-01, -3.122898e-02},
  { 2.281301e-01,  1.850306e-02, -9.734548e-01, -6.455721e-02, -2.698047e-01, -6.318206e-02},
  {-6.931252e-01,  4.473084e-01,  5.652369e-01,  2.973362e-01, -2.359119e-01, -4.650065e-02},
  { 9.589386e-02, -9.278650e-01,  3.603760e-01,  1.381829e-01, -2.928111e-01, -1.187163e-01},
  { 8.729649e-01,  4.700367e-01, -1.303760e-01,  5.200292e-01, -2.828860e-01, -1.166719e-01},
  { 4.308248e-01,  5.980043e-01,  6.758555e-01, -3.682817e-01, -2.846236e-01, -7.308271e-02},
  { 1.233811e-01,  8.698280e-01, -4.776780e-01,  4.251524e-01, -2.718665e-01, -1.492139e-01},
  { 4.303933e-01, -8.872261e-01, -1.661065e-01, -4.545126e-01, -2.798104e-01, -2.345587e-01},
  { 5.498120e-01, -4.133371e-01, -7.258507e-01, -6.948738e-02, -2.694359e-01, -3.964069e-01},
  {-1.870113e-01, -2.476452e-01,  9.506306e-01, -5.192923e-01, -3.010599e-01, -3.650234e-01},
  { 2.622842e-01, -3.204178e-02, -9.644586e-01, -4.169819e-01, -3.158641e-01, -4.612832e-01},
  { 6.811366e-01, -5.626177e-01, -4.685237e-01,  2.235066e-01, -3.096332e-01, -5.072091e-01},
  {-8.791775e-01, -4.617954e-01,  1.174392e-01, -5.436413e-01, -3.340732e-01, -4.969831e-01},
  {-4.222780e-01, -4.480402e-01, -7.879983e-01, -5.384949e-01, -3.276657e-01, -5.544150e-01},
  {-5.062571e-01,  7.615815e-01, -4.045952e-01, -3.236329e-01, -2.776372e-01, -5.199089e-01},
  {-5.089461e-01,  7.522278e-01, -4.184819e-01, -3.015663e-01, -2.952285e-01, -5.812727e-01},
  {-4.283508e-01,  7.863802e-01, -4.451089e-01, -2.907053e-01, -2.923112e-01, -5.891657e-01},
  { 2.201930e-01, -4.537270e-01, -8.635085e-01,  3.137783e-02, -3.140709e-01, -6.488900e-01},
  { 2.919503e-01, -1.643140e-01, -9.422133e-01, -1.748114e-01, -2.919566e-01, -7.450168e-01},
  {-4.103386e-01,  1.476966e-01, -8.998933e-01, -2.445176e-01, -3.035359e-01, -7.493632e-01},
  { 2.815958e-01, -6.412544e-01,  7.137903e-01,  5.706941e-02, -2.940812e-01,  8.079787e-01},
  {-9.066253e-01,  2.612993e-01, -3.312904e-01, -8.449752e-02, -2.564343e-01,  6.409639e-01},
  { 3.345607e-01,  5.283037e-01,  7.803617e-01,  7.336315e-02, -2.830345e-01,  6.686054e-01},
  { 3.020028e-01,  6.462576e-01,  7.008177e-01, -1.740938e-01, -2.481906e-01,  6.625741e-01},
  {-8.002519e-02, -3.217109e-01,  9.434501e-01,  2.687649e-01, -2.636659e-01,  6.222849e-01},
  { 8.644858e-01,  1.216522e-01, -4.877141e-01,  4.520234e-01, -2.694692e-01,  4.511368e-01},
  { 2.371411e-01, -9.540114e-01, -1.833747e-01, -2.600397e-01, -3.112113e-01,  3.649752e-01},
  { 1.391283e-01, -9.534003e-01,  2.677146e-01, -2.102068e-01, -2.921617e-01,  3.615968e-01},
  { 2.509150e-01, -9.381599e-01, -2.385321e-01, -2.756700e-01, -3.185400e-01,  3.512650e-01},
  {-4.986629e-01, -5.696370e-02, -8.649222e-01, -4.231044e-01, -2.736156e-01,  3.145208e-01},
  { 9.747273e-01,  8.684064e-02, -2.058282e-01,  4.536312e-01, -2.679453e-01,  4.022621e-01},
  {-5.076420e-01,  3.164685e-01, -8.013409e-01, -3.770696e-01, -2.604379e-01,  2.835896e-01},
  {-8.909644e-01, -1.156369e-03, -4.540715e-01, -3.550903e-01, -2.679277e-01,  2.545393e-01},
  {-4.220584e-01, -4.449947e-01,  7.898395e-01, -5.148640e-01, -2.727702e-01,  2.965360e-01},
  { 7.658930e-01,  3.450254e-02,  6.420416e-01,  4.166445e-01, -2.524303e-01,  2.251882e-01},
  {-9.901431e-01, -1.207370e-01,  7.098809e-02, -5.344483e-01, -2.461229e-01,  2.569105e-01},
  { 9.997264e-01, -3.822322e-04, -2.338899e-02,  4.732989e-01, -2.500325e-01,  1.413758e-01},
  {-1.121705e-01,  7.845370e-01, -6.098521e-01, -3.022040e-01, -2.480109e-01,  1.512677e-01},
  { 2.058991e-01,  8.382542e-01, -5.049112e-01, -4.062163e-01, -2.421495e-01,  1.317196e-01},
  {-2.066758e-02,  9.948445e-01,  9.928405e-02, -3.327763e-01, -2.552456e-01,  1.044110e-01},
  {-5.585901e-01,  8.046411e-01, -2.013204e-01, -2.802469e-01, -2.508038e-01,  1.181079e-01},
  {-9.542197e-01, -2.819462e-01, -9.985571e-02, -5.695803e-01, -2.403893e-01,  7.856981e-02},
  { 3.746870e-01,  6.272925e-01, -6.827253e-01,  1.959202e-01, -2.669421e-01,  6.051175e-02},
  { 4.838268e-01,  5.888404e-01, -6.474401e-01,  1.916226e-01, -2.593852e-01,  6.764866e-02},
  {-4.246317e-01, -1.465406e-02, -9.052476e-01, -4.266632e-01, -2.481557e-01,  3.743069e-03},
  {-4.553958e-01, -1.001188e-01, -8.846417e-01, -3.319946e-01, -2.698377e-01, -4.074732e-02},
  {-3.719186e-01,  8.611381e-01,  3.465801e-01, -9.548860e-03, -2.376646e-01, -1.248780e-02},
  {-3.651445e-01,  5.898125e-01, -7.202714e-01, -2.915338e-01, -2.548821e-01, -6.162733e-02},
  {-8.503886e-01,  4.575766e-01,  2.597359e-01,  3.308195e-01, -2.414321e-01, -2.130346e-02},
  { 2.584001e-02, -8.245887e-01, -5.651423e-01, -1.604931e-01, -3.007688e-01, -6.303321e-02},
  { 8.646004e-01, -4.956457e-01,  8.247120e-02,  1.475407e-01, -2.838099e-01, -2.176777e-02},
  {-6.159477e-01,  7.634009e-01,  1.944933e-01,  3.212050e-01, -2.237063e-01, -5.053912e-02},
  {-8.350224e-01, -3.919852e-01,  3.861155e-01, -5.471492e-01, -2.858914e-01, -2.091708e-02},
  { 9.848168e-01,  1.090978e-01, -1.350316e-01,  5.190116e-01, -2.513816e-01, -6.193880e-02},
  { 8.261481e-01,  4.878049e-01, -2.820030e-01,  5.200209e-01, -2.617909e-01, -7.483834e-02},
  { 6.577924e-01, -6.904985e-01,  3.008673e-01,  1.817367e-01, -2.772808e-01, -8.140472e-02},
  {-7.252409e-01, -1.000402e-01, -6.811883e-01, -4.832194e-01, -2.684427e-01, -1.006827e-01},
  { 3.116063e-01, -8.737999e-01,  3.733299e-01,  2.297458e-01, -3.069088e-01, -1.060746e-01},
  {-3.688479e-01,  7.298359e-01, -5.755787e-01, -4.659065e-01, -2.694862e-01, -1.087210e-01},
  { 3.068107e-01, -8.819878e-01,  3.577217e-01,  2.015024e-01, -3.264217e-01, -1.594658e-01},
  { 4.303933e-01, -8.872261e-01, -1.661065e-01, -4.575020e-01, -2.834986e-01, -2.226049e-01},
  {-9.385502e-02, -8.513740e-01,  5.160944e-01,  1.852467e-01, -3.474953e-01, -1.819159e-01},
  {-1.606821e-01,  3.153099e-01, -9.352866e-01, -4.386525e-01, -2.580102e-01, -2.603059e-01},
  {-5.698168e-02, -8.925599e-01, -4.473141e-01,  9.502057e-02, -3.466347e-01, -2.411073e-01},
  {-3.323910e-01, -8.679492e-01,  3.690264e-01,  3.799534e-01, -2.631143e-01, -3.105264e-01},
  { 6.988395e-01, -3.671756e-01,  6.138448e-01,  5.150596e-01, -3.031882e-01, -3.401075e-01},
  {-6.724874e-01, -3.464853e-01,  6.539943e-01, -3.666508e-01, -2.921804e-01, -3.367423e-01},
  {-8.819814e-01, -5.792764e-02, -4.677106e-01, -5.923490e-01, -2.714325e-01, -4.148054e-01},
  { 6.393175e-01, -2.393528e-01, -7.307417e-01, -4.532428e-02, -2.748341e-01, -4.520705e-01},
  { 4.357887e-01,  1.989596e-01, -8.777831e-01,  4.899969e-01, -2.826959e-01, -4.867997e-01},
  {-9.646796e-01, -5.114199e-02, -2.584138e-01, -5.422565e-01, -3.094447e-01, -5.452342e-01},
  { 2.873634e-01, -2.097196e-01, -9.345800e-01,  4.674685e-01, -2.895585e-01, -4.909878e-01},
  { 4.268458e-01, -9.009882e-01,  7.760682e-02,  4.652288e-01, -2.889168e-01, -5.163642e-01},
  {-6.521413e-01,  5.060105e-01,  5.645043e-01, -3.198247e-01, -2.592140e-01, -4.922485e-01},
  { 3.294277e-01, -8.842822e-01, -3.309415e-01,  4.126136e-01, -3.541429e-01, -6.610640e-01},
  {-4.327419e-01, -8.999457e-01, -5.321739e-02,  3.866763e-01, -3.504759e-01, -6.621110e-01},
  { 2.590484e-01,  5.793553e-01,  7.728140e-01, -2.234560e-02, -2.620361e-01, -5.639386e-01},
  {-7.317131e-01,  3.397469e-01, -5.909044e-01, -2.594823e-01, -2.709922e-01, -6.003481e-01},
  { 1.609121e-01,  6.636269e-02, -9.847352e-01, -2.733326e-01, -2.800546e-01, -5.848776e-01},
  { 8.423727e-02, -9.478624e-01,  3.073449e-01, -3.025055e-01, -3.021332e-01, -5.945417e-01},
  {-1.848206e-01, -9.308901e-01,  3.150952e-01, -3.428801e-01, -3.077268e-01, -5.957496e-01},
  {-9.810892e-01,  1.851004e-01,  5.658413e-02, -2.581520e-01, -2.799247e-01, -6.211681e-01},
  {-1.902166e-01, -9.665474e-01,  1.720578e-01, -3.899680e-01, -3.159819e-01, -6.454064e-01},
  {-2.044235e-01,  1.487141e-01, -9.675201e-01, -3.448839e-01, -2.928079e-01, -7.263197e-01},
  {-8.944272e-01,  0.000000e+00,  4.472136e-01, -3.885089e-01, -3.217105e-01, -6.980927e-01},
  {-5.997433e-01, -3.305732e-01, -7.287177e-01, -3.779109e-01, -3.060037e-01, -7.189531e-01},
  {-7.692552e-01, -6.346887e-01, -7.359843e-02, -4.018751e-01, -3.135862e-01, -6.675688e-01},
  {-4.136732e-01,  7.368540e-01, -5.347157e-01, -3.594102e-01, -3.051392e-01, -7.320745e-01},
  { 3.300068e-01,  1.472040e-01, -9.324303e-01,  8.543681e-02, -2.523689e-01, -6.411205e-01},
  {-8.590171e-01, -3.424715e-01,  3.805299e-01, -2.678342e-01, -2.897237e-01, -6.791933e-01},
  {-9.629359e-01, -1.019140e-01,  2.497359e-01, -2.621058e-01, -2.857628e-01, -6.637374e-01},
  { 1.250250e-01, -1.859080e-01,  9.745804e-01,  8.434781e-02, -2.594665e-01,  8.260581e-01},
  {-2.754864e-01, -9.080023e-01,  3.156566e-01,  2.418925e-01, -2.892337e-01,  7.699511e-01},
  {-3.243743e-02, -9.574956e-01,  2.866183e-01,  3.342380e-01, -2.525529e-01,  6.609848e-01},
  { 1.181197e-01, -9.869950e-01,  1.090348e-01,  1.274659e-01, -2.658473e-01,  6.495034e-01},
  {-2.991731e-01,  4.425059e-01,  8.453899e-01, -2.799519e-01, -2.229531e-01,  6.498131e-01},
  {-7.208682e-01, -4.390594e-01,  5.362610e-01, -3.509319e-01, -2.807322e-01,  5.735538e-01},
  {-4.659974e-02, -9.761541e-01,  2.120180e-01, -3.455558e-01, -3.054475e-01,  5.234987e-01},
  {-8.080716e-01, -3.420421e-01,  4.796118e-01, -3.948519e-01, -2.720810e-01,  5.216346e-01},
  {-8.386843e-01,  5.312736e-01, -1.198208e-01,  1.620354e-02, -2.358648e-01,  4.408228e-01},
  {-9.648944e-01, -2.513490e-01,  7.617314e-02, -4.731662e-01, -2.343464e-01,  3.789162e-01},
  {-7.512621e-01,  4.727367e-01,  4.605704e-01, -5.266415e-01, -2.119658e-01,  2.653702e-01},
  {-9.681183e-01,  1.348753e-01,  2.110826e-01, -5.271842e-01, -1.947562e-01,  2.121771e-01},
  { 2.520407e-01,  8.291988e-01, -4.989037e-01, -4.366860e-01, -1.912553e-01,  1.689680e-01},
  {-7.248157e-01, -6.273731e-02, -6.860803e-01, -2.942824e-01, -2.309791e-01,  1.582173e-01},
  {-1.652387e-01,  9.476511e-01, -2.732279e-01, -5.112047e-01, -1.834108e-01,  9.003215e-02},
  {-9.123033e-01,  3.672910e-01,  1.811076e-01, -5.659727e-01, -2.126100e-01,  9.091679e-02},
  { 9.967873e-02,  7.363161e-01, -6.692553e-01, -4.280783e-01, -2.197028e-01,  1.949619e-02},
  {-2.326959e-01,  4.955735e-01, -8.368151e-01, -5.062971e-01, -2.107260e-01,  4.032883e-02},
  {-2.667055e-01,  3.308121e-01, -9.052246e-01,  2.322478e-01, -2.364497e-01,  8.223842e-02},
  { 3.284125e-01,  5.526941e-01, -7.659467e-01,  1.995767e-01, -2.410609e-01,  8.497959e-02},
  {-6.018193e-01,  3.103564e-01, -7.358617e-01, -5.595391e-01, -2.173391e-01,  5.562481e-02},
  { 7.586449e-01,  1.257351e-01,  6.392564e-01,  5.123717e-01, -2.525881e-01,  8.002973e-02},
  { 1.198667e-01,  5.286652e-01, -8.403243e-01, -3.348954e-02, -2.298454e-01,  2.289159e-03},
  {-7.006817e-01,  6.610788e-01,  2.683654e-01,  3.409756e-01, -2.365378e-01, -1.418382e-02},
  { 1.838525e-01, -9.596524e-02, -9.782581e-01, -2.681719e-01, -2.429885e-01, -5.699357e-02},
  { 2.675578e-01, -2.732719e-01, -9.239780e-01, -1.309213e-01, -2.591763e-01, -9.356596e-02},
  { 1.415944e-02, -2.943818e-01, -9.555830e-01, -2.013506e-01, -2.424361e-01, -1.111117e-01},
  {-5.996532e-01, -7.949616e-01, -9.193590e-02, -4.539279e-01, -2.645073e-01, -1.324865e-01},
  { 6.228142e-01, -7.518191e-01, -2.164960e-01,  2.742837e-01, -2.602872e-01, -1.797524e-01},
  {-1.174896e-01,  2.079525e-01,  9.710571e-01, -1.809134e-01, -2.350568e-01, -1.534026e-01},
  { 6.945907e-01, -6.441984e-01,  3.202377e-01,  2.498221e-01, -2.741137e-01, -2.312195e-01},
  { 4.909320e-01, -8.390112e-01,  2.346189e-01,  2.626249e-01, -3.090036e-01, -2.702538e-01},
  { 4.520079e-01, -8.919801e-01, -7.774159e-03,  3.284774e-01, -2.766473e-01, -3.163389e-01},
  {-7.746738e-01, -3.930419e-01,  4.953772e-01,  2.823306e-01, -2.735866e-01, -3.345926e-01},
  { 9.570890e-02, -8.556412e-01, -5.086432e-01,  1.717095e-01, -2.994561e-01, -3.597386e-01},
  {-3.420846e-01, -5.694723e-01, -7.474487e-01,  1.665825e-01, -2.979621e-01, -3.584156e-01},
  {-3.534211e-01, -8.237044e-01,  4.434010e-01, -5.744645e-01, -2.607687e-01, -3.209443e-01},
  {-4.893172e-03,  5.271969e-01,  8.497290e-01, -7.399485e-02, -2.521879e-01, -4.192427e-01},
  {-8.702299e-01, -3.245801e-01, -3.706045e-01, -5.414469e-01, -2.615366e-01, -4.513430e-01},
  { 9.311553e-01,  4.201709e-02, -3.621936e-01,  5.154486e-01, -2.742994e-01, -4.584884e-01},
  { 8.084792e-01, -5.840088e-02, -5.856199e-01,  2.323226e-01, -2.641714e-01, -5.196780e-01},
  {-4.186876e-01, -5.689012e-01, -7.078503e-01,  4.032143e-03, -2.489646e-01, -4.835971e-01},
  { 7.095262e-01, -7.022921e-01, -5.795183e-02,  5.144528e-01, -2.916894e-01, -5.170322e-01},
  {-6.557162e-02, -4.609681e-01, -8.849909e-01,  3.950708e-01, -3.384221e-01, -6.790726e-01},
  { 6.583457e-01,  3.198373e-01,  6.813846e-01, -4.430666e-02, -2.391644e-01, -5.647342e-01},
  {-2.812429e-02,  3.127784e-01, -9.494097e-01, -2.716478e-01, -2.717675e-01, -5.819592e-01},
  { 6.242144e-01, -7.576048e-01, -1.907652e-01, -3.166580e-01, -2.948059e-01, -6.226574e-01},
  { 2.146195e-01,  3.915100e-01,  8.947952e-01,  1.322491e-02, -2.291387e-01, -5.939960e-01},
  {-5.467591e-02, -8.725634e-01, -4.854314e-01, -6.683902e-02, -2.801629e-01, -6.954677e-01},
  { 3.230081e-01, -2.425662e-01, -9.147827e-01, -3.267801e-02, -2.913063e-01, -6.910592e-01},
  { 9.697587e-01, -1.838139e-01, -1.605626e-01, -3.181350e-01, -2.480635e-01, -7.425394e-01},
  {-8.665760e-01,  4.405933e-01, -2.343574e-01, -2.631122e-01, -2.663196e-01, -7.123458e-01},
  {-1.754464e-01, -5.419621e-01, -8.218854e-01, -3.559513e-01, -1.960481e-01, -7.687665e-01},
  {-4.435446e-01,  6.415648e-01, -6.258296e-01, -2.247207e-01, -2.444025e-01, -7.295501e-01},
  { 7.593752e-02, -9.736367e-01,  2.150930e-01,  3.135119e-01, -2.883373e-01,  8.327522e-01},
  {-6.713209e-01, -5.319377e-01,  5.161110e-01,  2.594019e-01, -2.734889e-01,  8.224231e-01},
  { 7.670029e-01, -5.502360e-01,  3.300712e-01,  4.514348e-01, -2.583801e-01,  8.071796e-01},
  { 3.285052e-01, -5.467016e-01,  7.701958e-01,  1.238374e-01, -2.600238e-01,  8.118958e-01},
  {-2.823333e-01, -9.756552e-03,  9.592668e-01,  1.151204e-03, -2.461973e-01,  8.213568e-01},
  {-2.742846e-01, -4.919378e-01,  8.262962e-01,  2.064417e-01, -2.603829e-01,  7.609374e-01},
  { 6.027818e-01, -4.159416e-01,  6.809160e-01,  2.023211e-01, -2.417517e-01,  7.794042e-01},
  { 2.035112e-01, -9.510442e-01,  2.325899e-01,  1.283678e-01, -2.691762e-01,  7.127981e-01},
  { 5.546631e-01,  7.800991e-01,  2.894725e-01, -2.676431e-01, -2.141536e-01,  4.555224e-01},
  { 7.238837e-02,  9.755985e-01,  2.072862e-01, -1.231237e-01, -2.126441e-01,  4.097238e-01},
  {-2.142293e-01,  3.436123e-01, -9.143503e-01, -3.942706e-01, -2.272632e-01,  3.359141e-01},
  {-2.142293e-01,  3.436123e-01, -9.143503e-01, -3.295373e-01, -2.351082e-01,  3.394785e-01},
  {-3.866619e-01,  8.205290e-01,  4.209806e-01,  1.416486e-02, -2.104669e-01,  3.560098e-01},
  { 7.590539e-02,  2.963522e-01,  9.520576e-01,  4.400735e-01, -2.263596e-01,  3.885293e-01},
  { 8.355857e-02,  9.964985e-01,  2.949224e-03, -1.296460e-01, -2.206622e-01,  3.240108e-01},
  { 9.776852e-01, -2.094579e-01, -1.609276e-02,  4.412938e-01, -2.232325e-01,  3.252376e-01},
  { 1.348040e-01,  9.460415e-01,  2.946750e-01, -1.352330e-01, -2.174113e-01,  2.974531e-01},
  {-7.087512e-02,  7.990269e-01,  5.971036e-01, -3.311131e-01, -2.117063e-01,  2.842293e-01},
  { 3.923448e-01, -8.158212e-02,  9.161932e-01, -3.430689e-01, -2.152030e-01,  2.959429e-01},
  { 8.389976e-02,  9.958371e-01, -3.562677e-02, -4.514739e-01, -1.586599e-01,  1.987581e-01},
  {-2.898689e-01,  9.465836e-01,  1.412639e-01, -4.930374e-01, -1.619302e-01,  2.112624e-01},
  { 5.645083e-01,  1.847523e-01, -8.044856e-01,  4.597023e-01, -2.201466e-01,  1.021059e-01},
  { 9.004943e-01, -3.222760e-01, -2.919731e-01,  3.849988e-01, -2.211472e-01,  1.074415e-01},
  { 4.520814e-01, -1.598265e-01, -8.775409e-01,  1.915272e-01, -2.339841e-01,  8.602182e-02},
  { 7.745984e-01,  1.017912e-01,  6.242082e-01,  5.173056e-01, -2.417947e-01,  7.023568e-02},
  {-2.996202e-01,  8.899340e-01, -3.438681e-01, -2.931092e-01, -2.264808e-01, -1.491773e-02},
  { 5.555135e-01,  3.385260e-01, -7.594767e-01, -7.446647e-02, -2.087870e-01, -1.382298e-02},
  {-7.121845e-01, -3.629797e-02, -7.010532e-01,  1.160892e-02, -2.221359e-01, -2.200761e-02},
  {-4.603974e-01, -5.080125e-01, -7.279819e-01, -2.351315e-01, -2.460013e-01, -9.786133e-02},
  { 8.096123e-01, -3.956763e-01,  4.335530e-01,  3.942071e-01, -1.943248e-01, -7.491224e-02},
  { 2.875398e-01, -8.021211e-01,  5.233762e-01,  2.735468e-01, -2.514820e-01, -4.911113e-02},
  { 5.150226e-01, -8.571503e-01,  6.729107e-03,  2.797053e-01, -2.492930e-01, -5.718549e-02},
  {-4.808423e-01, -7.907757e-01, -3.787671e-01, -5.044877e-01, -2.707006e-01, -2.199350e-01},
  {-2.377519e-01,  4.037109e-01, -8.834544e-01, -3.686584e-01, -2.315927e-01, -2.103258e-01},
  { 2.507261e-01, -8.898076e-01, -3.812858e-01,  2.797393e-01, -2.665133e-01, -1.985806e-01},
  { 2.805741e-01, -9.328697e-01, -2.259030e-01,  2.689586e-01, -2.611589e-01, -2.082843e-01},
  { 2.805741e-01, -9.328697e-01, -2.259030e-01, -3.240042e-01, -2.350421e-01, -2.222943e-01},
  {-7.636835e-01,  1.969869e-01, -6.148037e-01, -2.778793e-01, -2.360199e-01, -2.514684e-01},
  { 2.779814e-01, -8.861640e-01,  3.707286e-01,  3.874339e-01, -2.480962e-01, -2.957314e-01},
  { 6.772656e-01, -7.329636e-01, -6.384238e-02,  3.160518e-01, -2.899978e-01, -2.948803e-01},
  {-5.945932e-01, -4.291829e-01,  6.798978e-01, -2.750751e-01, -2.485029e-01, -2.836009e-01},
  {-1.163437e-01, -6.001978e-01,  7.913448e-01, -4.718590e-01, -2.265837e-01, -2.630838e-01},
  {-1.562551e-01, -5.014843e-01,  8.509393e-01, -5.498877e-01, -2.340870e-01, -2.638547e-01},
  {-9.967873e-01, -6.805778e-02, -4.222940e-02, -6.060461e-01, -2.272612e-01, -3.720250e-01},
  {-4.987117e-01, -7.260306e-01, -4.734618e-01,  3.225935e-01, -2.280139e-01, -3.854564e-01},
  { 8.508141e-01,  4.291820e-01,  3.031800e-01,  2.548746e-01, -2.189605e-01, -4.293436e-01},
  {-9.096946e-01, -2.142659e-01, -3.557326e-01, -5.501444e-01, -2.433058e-01, -4.446635e-01},
  { 8.660312e-01,  3.642793e-01,  3.424768e-01,  2.690155e-01, -2.161845e-01, -4.591892e-01},
  { 4.581661e-01, -1.568944e-01, -8.749102e-01, -4.594117e-01, -2.370440e-01, -5.474047e-01},
  {-2.988825e-01,  1.928846e-01, -9.345934e-01, -5.092325e-01, -2.491968e-01, -5.614781e-01},
  { 4.176719e-01, -8.531631e-01,  3.125106e-01,  5.150343e-01, -2.787309e-01, -4.730347e-01},
  { 1.125681e-01, -6.769274e-01, -7.273911e-01, -6.305359e-02, -2.312159e-01, -5.000055e-01},
  { 9.691800e-01, -6.376272e-02, -2.379588e-01,  5.193831e-01, -2.582089e-01, -5.462204e-01},
  {-4.835234e-01, -8.544095e-02,  8.711514e-01, -3.403870e-01, -2.333862e-01, -4.988914e-01},
  {-5.486152e-01, -5.837651e-02,  8.340344e-01, -3.502731e-01, -2.284952e-01, -5.044349e-01},
  { 8.107142e-01, -3.264962e-01, -4.859453e-01,  4.724586e-01, -2.842209e-01, -6.525093e-01},
  { 5.998881e-01, -3.323500e-01, -7.277897e-01,  4.478086e-01, -2.987933e-01, -6.760584e-01},
  {-6.226470e-01, -3.578249e-01, -6.958966e-01,  3.446960e-01, -2.905900e-01, -6.752832e-01},
  {-5.687796e-01,  2.829431e-01, -7.722906e-01, -1.743095e-01, -2.177377e-01, -5.752339e-01},
  {-6.034734e-01, -5.726370e-01,  5.548935e-01, -3.844501e-01, -2.536449e-01, -5.504539e-01},
  {-9.242961e-01, -3.119510e-01,  2.199164e-01, -4.166324e-01, -2.520122e-01, -6.240798e-01},
  {-7.607980e-01,  6.299031e-01,  1.562321e-01, -2.355755e-01, -2.303127e-01, -6.375018e-01},
  {-1.252697e-01,  9.704277e-01,  2.063437e-01, -3.249000e-01, -1.937853e-01, -7.605572e-01},
  {-1.075702e-01,  9.560344e-01,  2.728128e-01, -3.480738e-01, -2.058925e-01, -7.311618e-01},
  { 3.127569e-02, -5.689844e-01,  8.217533e-01,  3.439665e-01, -2.495919e-01,  8.939127e-01},
  { 6.489389e-01, -4.704584e-01,  5.979525e-01,  4.262299e-01, -2.330092e-01,  8.623733e-01},
  {-4.195741e-01, -5.765334e-01,  7.011182e-01,  2.981344e-01, -2.623421e-01,  8.690162e-01},
  { 2.913127e-01,  1.330995e-01,  9.473233e-01,  1.451736e-01, -2.052163e-01,  8.183110e-01},
  {-9.137095e-01, -3.389119e-02,  4.049521e-01, -8.026665e-02, -2.299668e-01,  7.475001e-01},
  {-9.880002e-01,  6.933799e-02, -1.380139e-01, -9.386054e-02, -2.114397e-01,  6.838608e-01},
  {-7.596346e-01, -5.645580e-01,  3.228460e-01,  3.441421e-01, -2.487235e-01,  6.877043e-01},
  { 9.724445e-01,  1.647377e-01, -1.649645e-01,  4.714637e-01, -2.153401e-01,  6.284400e-01},
  {-8.056064e-01,  3.366084e-02,  5.914941e-01, -3.258034e-01, -1.824695e-01,  6.021864e-01},
  {-9.540661e-01,  2.630263e-01, -1.434400e-01,  2.440866e-02, -2.174703e-01,  4.664285e-01},
  {-9.413621e-01, -1.685088e-01, -2.923050e-01,  3.030986e-02, -2.175755e-01,  3.834306e-01},
  { 1.268427e-01,  9.393259e-01,  3.187129e-01, -4.193589e-02, -2.076078e-01,  3.860827e-01},
  {-7.801966e-01,  1.559858e-01, -6.057737e-01, -4.692199e-01, -1.904478e-01,  3.566256e-01},
  {-5.375812e-01,  7.927510e-01,  2.873194e-01, -6.354880e-02, -1.985747e-01,  2.949097e-01},
  { 8.606589e-01, -3.463917e-01, -3.732011e-01,  4.379349e-01, -2.151894e-01,  3.191548e-01},
  {-5.321149e-02,  9.082031e-01,  4.151333e-01, -9.844076e-02, -2.134084e-01,  2.660945e-01},
  {-9.160279e-01,  3.529488e-01, -1.905784e-01, -2.442169e-01, -2.176007e-01,  5.292867e-02},
  { 8.583229e-01, -2.297713e-01,  4.587887e-01,  5.121474e-01, -2.181197e-01,  7.541043e-02},
  {-8.889714e-01,  4.579518e-01,  3.151656e-03, -2.367839e-01, -2.162658e-01,  3.554082e-03},
  {-8.048871e-01,  5.241321e-01, -2.782844e-01,  3.536212e-01, -2.066520e-01,  9.656589e-03},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.550218e-01, -1.965638e-01,  1.853863e-02},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.591561e-01, -2.011633e-01,  1.291194e-02},
  { 2.568887e-01,  7.337565e-01, -6.289750e-01,  5.213092e-01, -1.939254e-01, -1.901575e-02},
  { 9.701425e-01,  0.000000e+00,  2.425356e-01,  5.237932e-01, -1.951097e-01, -2.957483e-02},
  {-8.293574e-01, -1.458734e-01,  5.393396e-01, -5.762081e-01, -2.300706e-01, -1.171104e-02},
  { 6.391143e-01, -7.686121e-01,  2.771949e-02,  2.958336e-01, -2.372414e-01, -9.487583e-02},
  { 4.293684e-01, -8.417658e-01,  3.272202e-01,  3.069710e-01, -2.533377e-01, -1.098515e-01},
  { 4.281417e-01, -9.019779e-01,  5.595011e-02,  3.117848e-01, -2.705253e-01, -1.681454e-01},
  { 2.074910e-01,  1.399705e-01,  9.681714e-01, -2.222194e-01, -1.932502e-01, -1.528619e-01},
  {-1.455087e-01,  1.833848e-01, -9.722126e-01, -3.781483e-01, -2.209488e-01, -2.052013e-01},
  { 6.727008e-01,  4.509254e-01, -5.866345e-01,  3.129654e-01, -2.567881e-01, -2.782313e-01},
  { 3.083027e-01, -6.742423e-01,  6.710787e-01,  4.790429e-01, -2.249662e-01, -3.013464e-01},
  { 6.891754e-01, -1.681939e-01,  7.048035e-01,  3.143382e-01, -2.729387e-01, -2.799660e-01},
  {-1.145740e-01, -6.765367e-01, -7.274414e-01,  1.006475e-01, -2.653477e-01, -3.344434e-01},
  {-3.093623e-01,  8.748077e-02,  9.469119e-01, -5.615892e-01, -2.103479e-01, -2.543950e-01},
  {-9.131920e-01, -3.188311e-02,  4.062804e-01, -6.074487e-01, -1.904868e-01, -2.900878e-01},
  {-3.597080e-01,  8.720599e-01, -3.318456e-01, -2.976343e-01, -1.974815e-01, -3.540843e-01},
  {-6.706036e-02,  9.925551e-01, -1.016725e-01, -5.613597e-01, -1.434547e-01, -3.308489e-01},
  {-4.970184e-01, -4.278812e-01, -7.549109e-01,  2.876381e-01, -2.181146e-01, -3.649636e-01},
  {-1.221013e-01,  9.523675e-01,  2.794412e-01, -3.114280e-01, -2.050830e-01, -3.632320e-01},
  {-5.574800e-01,  8.280441e-01,  5.965831e-02, -5.766066e-01, -1.475128e-01, -3.447278e-01},
  { 2.632080e-01,  6.541559e-01,  7.090852e-01, -4.366502e-01, -2.034780e-01, -3.792406e-01},
  { 9.880198e-01, -1.486781e-01,  4.137260e-02,  5.177600e-01, -2.554866e-01, -4.231065e-01},
  {-4.343671e-01, -2.947449e-01, -8.511467e-01, -2.805841e-01, -2.234911e-01, -4.619108e-01},
  { 5.189864e-02, -3.321081e-01, -9.418124e-01, -3.555877e-01, -2.229393e-01, -4.676794e-01},
  {-3.643164e-01, -3.877704e-01, -8.467041e-01,  3.147273e-02, -2.235300e-01, -5.400578e-01},
  { 8.190761e-01, -3.691195e-01, -4.391642e-01,  4.866741e-01, -2.569331e-01, -6.378367e-01},
  { 1.042651e-01,  2.685377e-01, -9.576097e-01,  3.932486e-01, -2.745692e-01, -6.886074e-01},
  { 8.760175e-01,  1.153899e-01,  4.682719e-01, -6.011383e-02, -2.008660e-01, -5.521001e-01},
  { 3.375185e-02,  2.593607e-01, -9.651906e-01, -2.394549e-01, -2.328089e-01, -5.632254e-01},
  {-7.859375e-01,  2.575661e-01,  5.621049e-01, -3.855808e-01, -1.959885e-01, -5.347933e-01},
  { 7.498522e-01, -2.969871e-01, -5.912024e-01, -2.910481e-01, -2.412560e-01, -5.958957e-01},
  { 4.232412e-01, -1.010023e-01,  9.003696e-01, -1.952098e-02, -1.965536e-01, -5.858840e-01},
  { 9.312906e-01, -3.205088e-01, -1.731241e-01,  1.051014e-01, -2.074922e-01, -6.124111e-01},
  {-8.878896e-01, -1.678837e-02, -4.597501e-01, -4.223444e-01, -2.205995e-01, -6.593904e-01},
  { 9.815202e-01, -8.862364e-02, -1.695992e-01, -3.169982e-01, -2.016252e-01, -7.260847e-01},
  { 4.121947e-02,  2.960172e-01, -9.542928e-01, -1.151055e-01, -1.832657e-01, -7.214837e-01},
  { 3.394483e-01, -2.127435e-01,  9.162505e-01,  3.992742e-01, -2.020323e-01,  8.992667e-01},
  { 7.956163e-02,  5.257499e-01,  8.469103e-01,  9.656914e-02, -1.888795e-01,  8.128293e-01},
  {-3.130304e-01, -9.242039e-01,  2.187670e-01,  3.595555e-01, -2.605371e-01,  7.707055e-01},
  { 2.526754e-01,  6.835946e-01,  6.847288e-01,  1.676062e-01, -1.787426e-01,  7.933026e-01},
  { 3.294270e-01,  6.655255e-01,  6.697415e-01,  6.407171e-02, -1.663259e-01,  7.893374e-01},
  {-8.748857e-01,  6.577684e-02, -4.798420e-01, -5.226809e-04, -1.954348e-01,  5.870023e-01},
  {-9.689333e-01, -1.204320e-01, -2.160196e-01,  1.472753e-02, -2.100962e-01,  5.489907e-01},
  { 4.967037e-01,  5.301002e-01, -6.872258e-01,  3.544426e-01, -1.825020e-01,  4.089484e-01},
  {-9.818196e-01, -9.636474e-02,  1.635359e-01, -4.770185e-01, -1.565070e-01,  3.917430e-01},
  {-1.393066e-01, -9.822783e-01,  1.253913e-01,  3.190722e-01, -1.849957e-01,  3.501180e-01},
  {-4.869648e-02,  3.452048e-01,  9.372631e-01, -5.487125e-03, -1.858026e-01,  3.314611e-01},
  { 4.291968e-01,  8.443626e-01,  3.206898e-01, -2.000778e-01, -1.870136e-01,  2.922825e-01},
  { 4.291968e-01,  8.443626e-01,  3.206898e-01, -6.895956e-02, -2.040004e-01,  2.677575e-01},
  {-7.292895e-01, -2.329444e-01,  6.433302e-01, -7.203388e-02, -2.012246e-01,  2.671795e-01},
  { 1.197506e-01,  6.664929e-01,  7.358308e-01, -9.813138e-02, -1.984730e-01,  2.512360e-01},
  {-4.684224e-02,  7.381847e-01,  6.729704e-01, -4.349301e-01, -1.689580e-01,  2.886279e-01},
  {-1.531747e-02,  9.161339e-01, -4.005797e-01, -3.640314e-01, -1.441761e-01,  1.961139e-01},
  {-1.538309e-01,  9.692708e-01, -1.919639e-01, -3.795143e-01, -1.457540e-01,  2.016332e-01},
  {-1.859553e-01,  9.785678e-01,  8.846237e-02, -3.975154e-01, -1.513316e-01,  2.114446e-01},
  { 5.391413e-01, -4.117798e-01,  7.346864e-01,  3.893345e-01, -1.925427e-01,  1.158174e-01},
  { 9.284767e-01, -3.713907e-01,  0.000000e+00,  3.629454e-01, -1.916178e-01,  1.912677e-02},
  {-8.815196e-01,  4.441122e-01, -1.602735e-01,  3.627521e-01, -1.804075e-01,  2.538050e-02},
  { 8.096123e-01, -3.956763e-01,  4.335530e-01,  4.077351e-01, -1.553373e-01, -6.459288e-02},
  {-1.694656e-01,  4.155888e-02,  9.846595e-01, -5.480766e-01, -1.975620e-01,  6.724358e-03},
  { 4.954031e-01,  4.076029e-01,  7.670956e-01, -3.983607e-01, -1.866841e-01, -4.556376e-02},
  {-7.548164e-01, -6.501963e-01, -8.658622e-02, -6.003605e-01, -2.366374e-01, -1.548495e-01},
  { 8.259315e-01, -1.536968e-01, -5.424154e-01,  3.104296e-01, -2.583125e-01, -1.736695e-01},
  { 2.850058e-01, -9.168057e-01,  2.797123e-01,  4.648665e-01, -2.183326e-01, -2.609752e-01},
  { 1.440828e-01,  5.445767e-01,  8.262423e-01, -3.626757e-01, -1.582503e-01, -2.574198e-01},
  { 2.142784e-02,  4.595573e-01,  8.878896e-01, -4.133305e-01, -1.622092e-01, -2.429386e-01},
  { 1.329052e-01,  5.523548e-01,  8.229462e-01,  5.147253e-01, -2.028980e-01, -2.812657e-01},
  { 7.121006e-01, -6.514842e-01, -2.616885e-01,  2.777904e-01, -2.103452e-01, -3.258928e-01},
  {-5.852137e-01, -7.121271e-01,  3.878143e-01,  3.051635e-01, -2.392392e-01, -2.828287e-01},
  {-7.794306e-01, -1.506013e-01,  6.081178e-01,  2.728704e-01, -2.372244e-01, -3.205361e-01},
  {-1.073385e-01,  8.898644e-01, -4.434184e-01, -4.622707e-01, -1.417394e-01, -3.023666e-01},
  {-7.290246e-02,  5.938491e-01,  8.012668e-01, -5.441616e-01, -1.556802e-01, -2.699174e-01},
  {-5.198588e-01,  7.270580e-01,  4.484791e-01, -5.832338e-01, -1.585688e-01, -2.930632e-01},
  { 8.263140e-01, -4.153303e-01, -3.804022e-01,  2.779950e-01, -2.467445e-01, -3.506235e-01},
  {-7.349328e-02, -4.858571e-01, -8.709430e-01,  1.315192e-01, -2.317131e-01, -3.964382e-01},
  { 1.467865e-01,  2.224703e-01,  9.638261e-01, -3.942308e-01, -1.996326e-01, -3.858554e-01},
  { 9.883507e-01,  1.127427e-01,  1.022344e-01,  2.689659e-01, -1.891563e-01, -4.887980e-01},
  { 2.470957e-01, -3.232051e-01, -9.135000e-01,  1.663415e-01, -2.304455e-01, -5.752009e-01},
  {-9.286888e-01, -1.864932e-01, -3.205577e-01,  3.190709e-01, -2.196665e-01, -6.664848e-01},
  {-8.171628e-01,  5.422279e-01, -1.955351e-01, -1.438061e-01, -1.604084e-01, -6.059703e-01},
  {-5.040185e-01,  7.627645e-01, -4.051614e-01, -1.285506e-01, -1.473961e-01, -6.903528e-01},
  {-2.265381e-01,  8.728797e-01, -4.321590e-01, -1.082779e-01, -1.407534e-01, -7.013927e-01},
  { 2.270366e-01, -9.860510e-02,  9.688815e-01,  3.816444e-01, -1.667120e-01,  9.102215e-01},
  { 9.196085e-01,  3.512758e-01,  1.758564e-01,  4.590407e-01, -1.784816e-01,  8.146568e-01},
  { 8.896587e-01,  4.558051e-01,  2.736845e-02,  4.681751e-01, -1.717423e-01,  6.987313e-01},
  { 3.053102e-01,  9.321198e-01,  1.947779e-01,  7.462820e-02, -1.589672e-01,  7.401483e-01},
  {-8.402684e-01, -4.317141e-01, -3.279814e-01, -9.342181e-02, -1.799202e-01,  7.033247e-01},
  { 4.441160e-01,  8.862073e-01,  1.318998e-01,  8.878119e-02, -1.654841e-01,  7.162851e-01},
  {-1.119931e-02,  9.606092e-01,  2.776770e-01,  1.521048e-01, -1.670997e-01,  6.074542e-01},
  {-5.900190e-01,  5.030787e-03,  8.073737e-01, -4.106708e-01, -1.231647e-01,  4.785693e-01},
  {-6.985785e-01,  2.596905e-01,  6.667450e-01, -4.403764e-01, -1.199948e-01,  4.495046e-01},
  { 4.542162e-01,  8.872059e-01, -8.095248e-02, -3.170244e-01, -1.393158e-01,  4.285150e-01},
  {-8.845724e-01, -2.040103e-01,  4.194178e-01,  2.558181e-02, -1.915343e-01,  3.566429e-01},
  {-7.113273e-01,  6.820092e-01,  1.699318e-01, -3.064222e-01, -1.942011e-01,  3.173283e-01},
  { 9.450669e-02,  3.109280e-01,  9.457232e-01,  4.240706e-01, -1.797009e-01,  3.603328e-01},
  { 7.664401e-02, -1.159048e-01,  9.902989e-01,  2.963657e-01, -1.839556e-01,  2.838045e-01},
  { 7.664401e-02, -1.159048e-01,  9.902989e-01, -7.243943e-02, -1.971641e-01,  2.679580e-01},
  { 1.645649e-01,  3.139141e-01,  9.350810e-01, -1.122136e-01, -1.747293e-01,  2.391427e-01},
  { 5.637333e-01,  3.580973e-01, -7.442923e-01,  4.497587e-01, -1.674734e-01,  1.331615e-01},
  {-4.810283e-01, -8.598970e-01,  1.708480e-01, -3.065858e-01, -2.119415e-01,  1.190911e-01},
  {-9.274797e-01,  3.658912e-01, -7.684412e-02,  3.611534e-01, -1.501499e-01,  9.132583e-03},
  {-7.010498e-01, -7.095991e-01, -7.069837e-02, -2.550141e-01, -2.023568e-01, -5.675317e-02},
  {-7.010498e-01, -7.095991e-01, -7.069837e-02,  4.033367e-01, -1.386513e-01, -4.411780e-02},
  { 4.400089e-01,  6.802152e-01,  5.862589e-01,  1.890437e-02, -1.649967e-01, -9.377963e-02},
  {-2.443099e-01,  4.227972e-01,  8.726712e-01, -7.822240e-03, -1.673903e-01, -7.094313e-02},
  {-4.839996e-01, -3.451157e-01,  8.041391e-01, -8.131437e-02, -1.963746e-01, -7.124081e-02},
  { 3.188873e-01,  1.862814e-01,  9.293063e-01, -2.519483e-01, -1.668626e-01, -1.487374e-01},
  {-4.922853e-01, -8.314811e-01,  2.574769e-01,  3.132579e-01, -2.500689e-01, -1.603979e-01},
  { 1.904373e-01, -9.805066e-01,  4.837692e-02,  3.711899e-01, -2.697046e-01, -2.391369e-01},
  { 8.406652e-02,  9.531778e-01,  2.904907e-01,  3.012172e-01, -2.236265e-01, -2.829618e-01},
  {-8.006999e-01,  5.855106e-01,  1.267164e-01,  2.931414e-01, -2.051989e-01, -3.410905e-01},
  {-7.281352e-01,  5.986254e-01, -3.338661e-01,  2.876340e-01, -2.130582e-01, -3.137084e-01},
  { 1.492833e-01, -8.051225e-01, -5.740141e-01,  2.876342e-01, -2.065111e-01, -3.540826e-01},
  { 1.953847e-01, -4.112043e-01, -8.903571e-01, -1.204463e-02, -2.172223e-01, -3.826288e-01},
  {-9.841855e-01,  1.767927e-01,  1.110346e-02,  2.908965e-01, -2.159764e-01, -3.418411e-01},
  {-9.717215e-01,  1.656544e-01,  1.682737e-01,  2.875343e-01, -2.027113e-01, -3.743151e-01},
  { 2.010979e-01, -8.898991e-02, -9.755206e-01, -4.810668e-02, -1.712483e-01, -4.017991e-01},
  {-4.034912e-01,  5.154895e-01,  7.559533e-01, -2.825466e-01, -1.782046e-01, -3.827278e-01},
  {-6.637250e-01,  4.344294e-01,  6.088843e-01, -5.695418e-01, -1.308547e-01, -3.572452e-01},
  {-9.653949e-01,  4.209809e-02, -2.573720e-01, -5.866168e-01, -1.681563e-01, -4.426537e-01},
  {-1.189363e-01,  3.803077e-01,  9.171805e-01,  7.047278e-02, -1.787649e-01, -4.639645e-01},
  { 5.038911e-02,  3.623239e-01,  9.306892e-01, -7.902458e-02, -1.694572e-01, -4.594940e-01},
  {-3.077235e-01,  4.475514e-01, -8.396451e-01, -5.066796e-01, -1.587579e-01, -5.236964e-01},
  {-6.394646e-01,  3.800223e-01,  6.683323e-01, -2.778671e-01, -1.676774e-01, -5.173170e-01},
  { 5.605504e-01,  2.750554e-01, -7.811068e-01,  4.714852e-01, -2.064136e-01, -6.386999e-01},
  { 1.420211e-01, -6.218421e-01, -7.701575e-01, -2.322142e-01, -1.978730e-01, -5.710943e-01},
  { 7.791541e-01, -5.720536e-01, -2.562685e-01, -2.816844e-01, -1.942420e-01, -6.319002e-01},
  { 8.650202e-01,  1.539697e-01,  4.775285e-01,  1.127257e-01, -1.736746e-01, -6.082596e-01},
  { 9.250816e-01,  7.690517e-02, -3.718999e-01,  1.130532e-01, -1.775347e-01, -6.366760e-01},
  { 8.154309e-01,  1.564580e-01,  5.573089e-01,  4.310499e-01, -1.495751e-01,  8.687918e-01},
  {-7.518734e-01, -4.175869e-02,  6.579838e-01,  2.896749e-01, -1.715259e-01,  8.891564e-01},
  { 6.115167e-01,  7.795027e-01,  1.357305e-01,  4.445567e-01, -1.458727e-01,  7.758242e-01},
  { 9.111395e-01,  2.733309e-01, -3.084074e-01,  2.662398e-01, -1.475483e-01,  6.665502e-01},
  {-7.160451e-01,  3.109757e-01,  6.249589e-01,  2.363129e-01, -1.415061e-01,  6.260179e-01},
  {-7.185519e-01, -1.477779e-01,  6.795917e-01, -1.860890e-01, -1.779223e-01,  6.490796e-01},
  {-4.892452e-01,  7.852483e-01,  3.795053e-01,  1.928323e-01, -1.464881e-01,  5.919762e-01},
  {-1.642675e-01,  9.192977e-01, -3.576423e-01,  1.887892e-01, -1.480584e-01,  5.897970e-01},
  {-4.368185e-01,  7.940767e-01,  4.226485e-01,  1.816210e-01, -1.502797e-01,  5.873796e-01},
  {-2.162595e-01, -8.914359e-01,  3.982133e-01, -6.140144e-05, -1.928256e-01,  5.624973e-01},
  {-2.521600e-01, -9.415042e-01,  2.235737e-01, -1.740655e-01, -2.076083e-01,  6.138491e-01},
  {-1.203859e-01,  9.630868e-01,  2.407717e-01,  1.601538e-01, -1.513718e-01,  5.739753e-01},
  {-3.018792e-01,  4.909090e-01,  8.172376e-01,  1.550538e-01, -1.521471e-01,  5.731024e-01},
  { 7.491527e-01,  7.207278e-04, -6.623968e-01,  4.814059e-01, -1.785670e-01,  5.221216e-01},
  { 8.346315e-01, -3.382255e-01, -4.347342e-01,  4.733529e-01, -1.590726e-01,  5.137286e-01},
  { 5.102552e-01,  4.648074e-01, -7.235977e-01,  3.595714e-01, -1.651555e-01,  4.757338e-01},
  { 1.545640e-01,  7.892783e-01,  5.942641e-01, -3.804253e-01, -1.188851e-01,  4.936020e-01},
  { 4.928165e-01,  8.586586e-01,  1.408442e-01, -3.508835e-01, -1.092279e-01,  4.531168e-01},
  { 5.188774e-01,  5.654073e-01,  6.411559e-01, -3.228487e-01, -1.296216e-01,  3.626456e-01},
  { 6.524764e-01,  2.133839e-01,  7.271464e-01, -2.873289e-01, -1.412334e-01,  3.391164e-01},
  {-2.472389e-01,  4.879166e-01, -8.371441e-01, -3.614469e-01, -1.603972e-01,  3.288668e-01},
  { 9.720761e-01, -2.327074e-01,  3.025391e-02,  4.717727e-01, -1.803031e-01,  3.115337e-01},
  { 5.547909e-01, -4.627662e-01,  6.914148e-01,  2.871645e-01, -1.695752e-01,  2.920890e-01},
  {-5.796427e-01, -4.645146e-01,  6.695077e-01, -5.035628e-02, -1.773449e-01,  3.070467e-01},
  {-3.807135e-01, -4.245517e-01,  8.214701e-01,  3.426216e-01, -1.686622e-01,  3.091065e-01},
  { 4.334843e-01,  4.356897e-01,  7.888383e-01, -1.920053e-01, -1.405868e-01,  2.460133e-01},
  {-7.960298e-01,  9.950373e-02,  5.970224e-01,  2.413796e-01, -1.606580e-01,  1.324431e-01},
  { 9.291692e-01, -3.651866e-01,  5.730138e-02,  5.244777e-01, -1.508130e-01,  2.579402e-02},
  {-3.665394e-01, -8.992015e-01, -2.389256e-01, -2.718653e-01, -1.793930e-01,  4.897689e-02},
  {-6.397265e-01, -7.682334e-01,  2.382030e-02, -2.515303e-01, -1.757019e-01, -9.664316e-04},
  { 4.964832e-01,  4.980155e-01, -7.109748e-01, -1.223624e-01, -1.150239e-01, -4.674924e-02},
  {-2.039031e-01,  6.346673e-01, -7.453998e-01,  4.026375e-01, -1.345816e-01, -3.623620e-02},
  { 3.383175e-01, -6.430065e-01,  6.870836e-01,  3.415543e-01, -1.810851e-01,  1.332612e-04},
  {-6.843597e-01,  2.645967e-01,  6.794414e-01, -5.660265e-01, -1.363477e-01, -2.136227e-02},
  { 5.663021e-02,  5.730404e-01,  8.175682e-01, -5.243317e-01, -1.183004e-01, -1.272317e-02},
  {-9.761041e-01,  3.801439e-02,  2.139529e-01, -6.020107e-01, -1.652243e-01, -9.574524e-02},
  {-6.686271e-01, -3.702858e-01, -6.448458e-01, -5.969465e-01, -2.178859e-01, -2.031088e-01},
  { 1.097038e-01,  3.301415e-01, -9.375349e-01, -4.647249e-01, -1.663539e-01, -1.945612e-01},
  {-9.453530e-01, -1.319964e-01, -2.981354e-01, -3.054457e-01, -1.666910e-01, -2.543727e-01},
  {-6.482455e-01, -6.795855e-01,  3.434258e-01,  2.935497e-01, -2.170200e-01, -3.637118e-01},
  {-9.715744e-01,  1.928063e-01,  1.373647e-01,  2.885116e-01, -2.139700e-01, -3.615256e-01},
  { 9.644164e-01, -2.244514e-01, -1.397230e-01,  2.896060e-01, -2.033797e-01, -3.709843e-01},
  {-1.858598e-01, -5.036914e-01, -8.436534e-01,  2.513122e-01, -1.688716e-01, -4.163227e-01},
  {-4.782890e-01,  1.953978e-01,  8.561889e-01, -5.608019e-01, -1.238607e-01, -3.587387e-01},
  { 2.795874e-01,  3.973309e-01,  8.740475e-01,  1.608569e-01, -1.422438e-01, -4.262225e-01},
  { 8.626246e-01,  3.236082e-01,  3.887883e-01,  2.660788e-01, -1.609155e-01, -4.984018e-01},
  { 6.407061e-01,  1.657147e-01, -7.496895e-01,  4.848823e-01, -1.782697e-01, -6.143702e-01},
  {-6.483207e-01,  1.706474e-01, -7.419971e-01,  3.093107e-01, -1.722228e-01, -6.380330e-01},
  { 6.048784e-01, -6.257609e-01, -4.924890e-01, -2.485988e-01, -1.851526e-01, -6.011320e-01},
  {-3.267038e-01,  9.008836e-01,  2.857855e-01, -3.799867e-01, -1.094274e-01, -5.906619e-01},
  {-5.500320e-01,  8.297604e-01,  9.466939e-02, -3.955755e-01, -1.116785e-01, -6.065450e-01},
  { 5.051823e-01,  2.787284e-02,  8.625625e-01,  5.143194e-02, -1.483620e-01, -5.792258e-01},
  { 4.089252e-01,  4.190983e-01, -8.106397e-01, -3.939688e-01, -1.191318e-01, -6.666522e-01},
  { 9.968672e-02, -7.674710e-02, -9.920547e-01, -4.386491e-02, -1.352959e-01, -6.844142e-01},
  { 6.819220e-01,  3.003322e-01,  6.669205e-01,  4.084164e-01, -1.341937e-01,  8.936509e-01},
  { 3.864919e-01,  3.596514e-01,  8.492790e-01,  3.747675e-01, -1.157083e-01,  9.102737e-01},
  { 2.523441e-01,  6.353889e-01,  7.297968e-01,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  { 5.829009e-01,  7.958055e-01,  1.640731e-01,  4.330664e-01, -1.274343e-01,  6.885504e-01},
  {-2.006455e-01,  9.700581e-01,  1.368529e-01,  2.712068e-01, -1.445141e-01,  6.839134e-01},
  {-8.816763e-01,  1.227709e-01,  4.556032e-01,  2.555528e-01, -1.369092e-01,  6.444061e-01},
  {-2.286024e-01,  1.549038e-01,  9.611170e-01,  1.361782e-01, -1.385718e-01,  5.609283e-01},
  { 4.451088e-01,  5.315495e-01,  7.206479e-01,  1.144025e-01, -1.265052e-01,  5.634076e-01},
  { 6.084569e-01,  4.317015e-01, -6.658933e-01,  3.355628e-01, -1.460066e-01,  4.720639e-01},
  {-1.663229e-01,  9.495965e-01,  2.657125e-01, -4.092608e-01, -9.710729e-02,  4.524812e-01},
  {-7.070563e-01,  6.307743e-01,  3.196797e-01, -4.504829e-01, -9.747259e-02,  4.250043e-01},
  {-9.734203e-02,  9.949576e-01, -2.416517e-02, -3.586448e-01, -1.301674e-01,  3.659786e-01},
  {-3.456548e-01, -9.249071e-01,  1.583338e-01, -2.395488e-02, -1.612034e-01,  3.367952e-01},
  {-5.328073e-01, -7.708732e-01, -3.491000e-01, -1.435618e-01, -1.845996e-01,  2.824966e-01},
  { 3.322249e-01,  4.495090e-01, -8.291973e-01,  4.487222e-01, -1.286066e-01,  1.468544e-01},
  { 3.553048e-01, -5.413240e-01,  7.620544e-01,  5.011178e-01, -1.538685e-01,  1.141892e-01},
  {-8.656417e-01,  3.866124e-01, -3.181120e-01,  3.800340e-01, -1.422057e-01,  4.595317e-02},
  {-1.609296e-01,  4.112468e-01, -8.972055e-01, -2.588126e-02, -1.403109e-01,  1.184123e-02},
  {-8.394501e-02,  3.379813e-01, -9.374017e-01,  5.300128e-01, -1.415650e-01, -1.020006e-02},
  {-2.814187e-01, -9.535493e-01, -1.074587e-01, -3.374961e-01, -1.794479e-01, -2.326714e-02},
  { 4.821379e-01, -5.362831e-01,  6.927795e-01,  3.546392e-01, -1.624149e-01,  9.258995e-03},
  { 4.821379e-01, -5.362831e-01,  6.927795e-01, -3.675977e-01, -1.675810e-01, -5.168984e-02},
  {-4.218572e-01, -5.265079e-01, -7.381233e-01, -3.004029e-01, -1.663665e-01, -8.095674e-02},
  {-3.429807e-01, -4.523405e-01, -8.232571e-01, -3.123205e-01, -1.679527e-01, -7.528017e-02},
  {-4.301361e-01, -3.455104e-01, -8.340297e-01, -3.299880e-01, -1.573189e-01, -7.246434e-02},
  { 8.493400e-02,  4.600740e-01, -8.838089e-01, -2.255767e-01, -1.314312e-01, -1.108736e-01},
  { 6.027068e-01, -5.708845e-01,  5.575263e-01,  3.331724e-01, -2.024292e-01, -7.006013e-02},
  { 1.072815e-01, -7.072321e-01,  6.987942e-01,  3.421642e-01, -2.231953e-01, -8.197000e-02},
  { 5.312296e-01, -7.823328e-01,  3.251930e-01,  3.684465e-01, -2.480575e-01, -1.215446e-01},
  {-1.596596e-01,  7.747994e-01,  6.117145e-01,  1.430565e-02, -1.466551e-01, -1.270396e-01},
  { 1.059257e-01, -9.700176e-02,  9.896314e-01, -4.140494e-01, -1.371759e-01, -1.149170e-01},
  { 3.110050e-01, -1.914171e-01,  9.309325e-01, -2.926364e-01, -1.323746e-01, -1.479470e-01},
  { 1.913645e-01, -3.793954e-01, -9.052286e-01, -4.902159e-01, -1.485123e-01, -1.916649e-01},
  {-2.444564e-01, -4.270461e-01, -8.705589e-01, -3.885180e-01, -1.226583e-01, -2.218344e-01},
  { 7.684766e-01,  1.148977e-02,  6.397747e-01,  4.777557e-01, -1.581620e-01, -3.053215e-01},
  {-1.128533e-01,  1.962124e-01, -9.740456e-01, -3.197317e-01, -1.368607e-01, -3.444346e-01},
  {-6.802167e-01,  5.491735e-01, -4.855036e-01, -2.203199e-01, -1.355691e-01, -3.316299e-01},
  {-1.083024e-01,  2.522641e-01, -9.615785e-01, -3.075053e-01, -1.423253e-01, -3.472944e-01},
  {-7.529118e-01,  6.624253e-02,  6.547793e-01, -2.277398e-01, -1.371728e-01, -3.682397e-01},
  {-8.811494e-01,  4.644636e-01, -8.859643e-02, -5.807374e-01, -1.043842e-01, -4.014575e-01},
  {-2.797867e-01, -2.234217e-01, -9.337035e-01, -4.188867e-01, -1.344763e-01, -4.895501e-01},
  {-2.709845e-01, -3.576352e-01, -8.936804e-01, -2.906998e-01, -1.512163e-01, -4.865717e-01},
  { 7.003750e-01,  3.549860e-01,  6.192414e-01,  2.509480e-01, -1.297376e-01, -5.016015e-01},
  { 9.751325e-01,  2.996788e-02, -2.195871e-01,  5.240655e-01, -1.475940e-01, -5.619907e-01},
  { 8.736085e-01,  4.330534e-01,  2.219755e-01, -2.917806e-01, -1.246197e-01, -5.465608e-01},
  {-7.274455e-01, -3.270095e-02, -6.853858e-01,  2.913800e-01, -1.470436e-01, -6.241210e-01},
  { 1.533696e-01, -5.399048e-03, -9.881542e-01,  1.644893e-01, -1.613997e-01, -5.865080e-01},
  { 6.282671e-01,  4.252520e-01,  6.514916e-01,  8.424995e-02, -1.404683e-01, -6.040812e-01},
  {-6.250755e-01, -1.069587e-01,  7.732015e-01, -2.709985e-01, -1.816910e-01, -6.682554e-01},
  { 2.004745e-01,  9.265392e-01, -3.183316e-01, -3.540635e-01, -1.209944e-01, -6.428440e-01},
  { 5.572929e-01, -7.051868e-01, -4.383335e-01, -2.803093e-01, -2.196368e-01, -7.308967e-01},
  { 3.732021e-01, -8.167026e-01, -4.401331e-01, -3.050467e-01, -2.289627e-01, -7.345673e-01},
  { 3.320568e-02, -4.106369e-01, -9.111941e-01, -3.094063e-01, -2.096026e-01, -7.483556e-01},
  { 8.116228e-01,  5.837859e-01, -2.150521e-02,  3.516676e-01, -1.027052e-01,  7.961488e-01},
  { 9.928076e-01,  4.407474e-02, -1.113126e-01,  3.394223e-01, -1.121986e-01,  7.549506e-01},
  {-6.916828e-02, -4.298566e-01,  9.002439e-01, -1.818210e-01, -1.387261e-01,  6.892450e-01},
  {-4.068107e-01, -6.431138e-01,  6.487756e-01, -2.069372e-01, -1.402889e-01,  6.785085e-01},
  { 8.639919e-01, -3.915077e-01, -3.166067e-01,  2.487065e-01, -1.239593e-01,  6.381412e-01},
  {-7.680911e-01, -6.232671e-01,  1.468819e-01, -2.654634e-01, -1.619092e-01,  5.547960e-01},
  {-4.595920e-01, -8.783778e-01, -1.312538e-01, -2.216141e-01, -1.788382e-01,  4.550114e-01},
  { 7.959756e-01, -9.121826e-02, -5.984164e-01,  2.884490e-01, -1.305913e-01,  4.251273e-01},
  {-1.688941e-01, -9.856027e-01,  7.884242e-03, -1.634604e-01, -1.854130e-01,  3.293076e-01},
  { 8.885676e-01,  1.169267e-01,  4.435941e-01,  4.604204e-01, -1.285284e-01,  3.210046e-01},
  { 2.113916e-01, -7.173746e-01,  6.638429e-01,  3.754412e-01, -1.451709e-01,  3.395412e-01},
  { 2.405410e-01, -7.417673e-01,  6.260361e-01,  2.985454e-01, -1.406147e-01,  3.105769e-01},
  { 9.944484e-01, -4.883699e-02, -9.320623e-02,  4.690298e-01, -1.253891e-01,  2.161329e-01},
  { 6.235954e-01, -3.873960e-01, -6.790090e-01, -2.802853e-01, -1.434750e-01,  2.312091e-01},
  {-4.234324e-01, -3.242620e-02,  9.053472e-01, -1.149877e-01, -1.262530e-01,  2.318878e-01},
  { 9.044264e-01,  3.112206e-01, -2.918127e-01,  4.706081e-01, -1.185679e-01,  1.853800e-01},
  { 4.238834e-01, -5.485955e-01,  7.206705e-01,  4.000654e-01, -1.308071e-01,  1.431343e-01},
  { 4.329697e-01, -7.093596e-01,  5.561890e-01,  5.142737e-01, -1.387163e-01,  1.270828e-01},
  {-3.419735e-01, -9.389065e-01, -3.884184e-02, -4.335817e-01, -1.724800e-01,  1.185887e-01},
  {-3.800170e-01, -6.626511e-01,  6.453531e-01, -4.419290e-01, -1.634813e-01,  1.359056e-01},
  { 6.338387e-02,  9.951475e-01, -7.525893e-02, -2.001634e-01, -1.119252e-01,  6.058776e-02},
  {-1.653323e-01,  2.925339e-02, -9.858040e-01,  5.695981e-01, -1.241786e-01,  2.290873e-04},
  {-7.253584e-01, -5.276979e-01, -4.420295e-01, -4.593605e-01, -1.350158e-01,  9.480630e-03},
  {-8.524231e-02,  7.117552e-01, -6.972362e-01, -2.325263e-02, -1.323764e-01,  3.044801e-02},
  { 3.293588e-01,  9.338756e-01, -1.392805e-01, -1.121974e-01, -9.451955e-02,  1.500627e-03},
  {-4.551989e-01, -3.368243e-02, -8.897524e-01, -4.349309e-01, -1.522339e-01, -1.756992e-02},
  { 3.860784e-02,  9.975367e-01, -5.856638e-02, -2.193819e-01, -6.492536e-02, -1.161797e-02},
  { 2.047508e-01,  8.440565e-01, -4.956266e-01, -2.113101e-01, -7.122723e-02, -4.155888e-02},
  {-5.339422e-01, -6.174433e-01, -5.776414e-01, -4.149453e-01, -1.367401e-01, -2.891623e-02},
  {-3.056106e-01,  5.755540e-01, -7.585115e-01, -2.710026e-01, -9.287993e-02, -7.203393e-02},
  {-9.501399e-01, -1.119925e-01, -2.910185e-01,  1.483046e-02, -1.454212e-01, -3.563720e-02},
  { 4.498863e-01, -7.132419e-01,  5.374833e-01,  4.073787e-01, -1.964066e-01, -7.240718e-02},
  {-5.431105e-01, -4.350696e-01,  7.181542e-01, -1.267935e-01, -1.414151e-01, -7.404500e-02},
  { 4.813602e-01, -2.679961e-01,  8.345481e-01, -3.162530e-01, -1.304023e-01, -1.276918e-01},
  { 2.384414e-02, -1.073913e-01, -9.939309e-01, -5.497631e-01, -1.641785e-01, -2.310507e-01},
  {-3.020378e-01,  2.273125e-01, -9.257981e-01, -5.720522e-01, -1.668018e-01, -2.380058e-01},
  {-7.373335e-01, -4.445393e-01,  5.086493e-01, -1.388123e-01, -1.419969e-01, -1.316355e-01},
  {-5.957079e-01, -1.215736e-01,  7.939471e-01, -1.637519e-01, -1.201129e-01, -1.453874e-01},
  {-5.551434e-01, -8.316587e-01, -1.264083e-02, -3.428652e-01, -9.955603e-02, -2.633787e-01},
  { 7.846916e-01, -4.526895e-01,  4.234752e-01,  4.751171e-01, -1.801968e-01, -1.654715e-01},
  { 9.825141e-01, -1.417517e-03,  1.861828e-01,  5.157143e-01, -1.435514e-01, -3.197996e-01},
  {-2.457092e-01, -1.391580e-01, -9.593030e-01, -2.398912e-02, -1.397618e-01, -4.154255e-01},
  {-3.918742e-01, -8.393176e-02, -9.161823e-01, -3.276690e-02, -1.420565e-01, -4.118624e-01},
  { 7.641053e-02, -3.116486e-01, -9.471201e-01,  1.810028e-01, -1.488048e-01, -3.960947e-01},
  { 2.838910e-01, -2.501291e-01, -9.256573e-01,  1.334963e-01, -1.475839e-01, -4.419129e-01},
  {-6.229452e-01, -5.194638e-01, -5.848902e-01,  2.493561e-01, -1.343314e-01, -4.307012e-01},
  {-1.440250e-01, -2.182636e-01,  9.652035e-01, -3.509220e-01, -1.145384e-01, -3.920871e-01},
  {-9.399663e-01,  3.044634e-01,  1.541604e-01, -5.681458e-01, -7.905094e-02, -3.887548e-01},
  {-4.706388e-01,  6.735557e-01, -5.699315e-01, -5.286921e-01, -7.467391e-02, -4.396884e-01},
  {-9.587693e-01, -2.196532e-01, -1.803163e-01, -2.766763e-01, -1.266693e-01, -5.069090e-01},
  {-8.289631e-01, -5.164295e-01, -2.147571e-01,  2.682316e-01, -1.456598e-01, -5.055718e-01},
  { 4.412950e-01, -4.044054e-01,  8.010712e-01, -3.751567e-02, -1.366296e-01, -5.370420e-01},
  {-3.960580e-01,  1.456335e-01, -9.066030e-01, -1.455815e-01, -1.303672e-01, -5.558668e-01},
  { 3.213267e-03,  2.935799e-01, -9.559291e-01, -1.566506e-01, -1.376242e-01, -5.580740e-01},
  {-4.572238e-01,  8.049344e-01, -3.781889e-01, -3.479750e-01, -1.009728e-01, -5.884238e-01},
  {-9.878510e-01, -1.216351e-01, -9.672338e-02, -3.188034e-01, -1.618077e-01, -6.488538e-01},
  {-6.566966e-01,  2.579032e-01, -7.086858e-01, -3.196875e-01, -1.688983e-01, -6.522642e-01},
  {-9.345996e-01,  3.167576e-01, -1.618281e-01, -3.159873e-01, -1.673632e-01, -6.706289e-01},
  { 3.124315e-01, -5.004721e-01,  8.074121e-01, -3.843923e-01, -1.996776e-01, -7.131875e-01},
  {-3.152849e-01, -7.866472e-02, -9.457310e-01, -3.574361e-01, -1.960313e-01, -7.359030e-01},
  {-3.954676e-01,  2.342948e-01,  8.880942e-01,  3.204027e-01, -9.038606e-02,  9.037380e-01},
  { 7.058582e-01,  6.851434e-01,  1.798407e-01,  3.723567e-01, -6.084343e-02,  8.443329e-01},
  { 6.066073e-01,  7.943864e-01,  3.126896e-02,  3.445804e-01, -1.089492e-01,  7.051585e-01},
  {-9.621098e-01, -1.846690e-01, -2.006044e-01, -7.307250e-02, -1.138106e-01,  6.438525e-01},
  { 8.423851e-01,  3.767482e-01,  3.852895e-01,  4.169746e-01, -9.466553e-02,  6.309505e-01},
  {-3.475496e-01, -7.096705e-01,  6.128435e-01,  1.986407e-01, -1.261236e-01,  6.028763e-01},
  { 8.566992e-01,  5.672362e-02,  5.126879e-01,  4.929761e-01, -9.512579e-02,  5.834787e-01},
  {-5.674796e-01, -2.146074e-01,  7.949281e-01, -2.509542e-01, -1.334086e-01,  5.881133e-01},
  {-6.977527e-01,  7.157020e-01,  3.019802e-02, -1.574477e-01, -9.036683e-02,  5.298026e-01},
  { 4.478182e-01,  2.984317e-01,  8.428507e-01, -1.807975e-01, -1.032567e-01,  5.360461e-01},
  {-7.054826e-01, -5.118679e-01, -4.901893e-01, -2.235318e-01, -1.355832e-01,  3.089529e-01},
  { 7.689761e-01, -6.355588e-01,  6.885327e-02,  4.624849e-01, -1.177405e-01,  3.376495e-01},
  {-4.433567e-01, -8.616097e-01,  2.471105e-01,  3.143632e-01, -1.329929e-01,  3.202549e-01},
  { 2.167380e-01, -2.008163e-01,  9.553519e-01, -1.334430e-01, -1.023735e-01,  2.283573e-01},
  {-9.884583e-01,  1.503858e-01,  1.828801e-02, -2.983370e-01, -1.264860e-01,  1.638131e-01},
  { 1.502304e-01,  5.119157e-01, -8.457974e-01, -2.565918e-01, -9.435421e-02,  7.231928e-02},
  {-6.084319e-01, -7.159448e-01, -3.423937e-01, -4.842844e-01, -1.385214e-01,  4.885299e-02},
  {-2.663213e-02,  8.342124e-01, -5.507999e-01, -3.753734e-01, -7.115861e-02,  1.846782e-02},
  {-5.566514e-02,  9.980693e-01, -2.754934e-02, -3.191145e-01, -6.350823e-02,  1.854404e-02},
  { 4.761234e-01,  3.333682e-01, -8.137396e-01,  5.690641e-01, -9.520256e-02, -1.386767e-02},
  { 5.180545e-01, -5.457671e-01,  6.586030e-01,  3.725569e-01, -1.319231e-01,  2.509690e-02},
  { 5.640290e-01, -8.244642e-01,  4.615261e-02,  4.342633e-01, -1.784967e-01, -8.193111e-02},
  {-9.692590e-01, -2.388524e-01,  5.904527e-02,  1.850726e-02, -1.233489e-01, -1.286559e-01},
  { 1.147193e-01, -8.739933e-01, -4.722025e-01, -4.681339e-01, -1.118952e-01, -2.360250e-01},
  {-8.127766e-01, -5.791238e-01, -6.332354e-02, -1.669757e-01, -1.039042e-01, -1.779272e-01},
  {-2.169923e-01, -8.350189e-01, -5.056262e-01, -3.678575e-01, -9.642658e-02, -2.471569e-01},
  {-7.522651e-01, -2.180012e-01,  6.217498e-01, -3.403920e-01, -1.243607e-01, -3.134120e-01},
  { 7.729487e-01, -5.934438e-01,  2.244434e-01,  4.749583e-01, -1.247552e-01, -2.623562e-01},
  {-9.882286e-01, -1.242308e-02,  1.524788e-01, -2.125826e-01, -1.046993e-01, -3.206851e-01},
  {-2.139208e-01, -1.538450e-01,  9.646603e-01, -5.257092e-01, -7.842675e-02, -3.376693e-01},
  {-5.020602e-01, -4.515455e-02,  8.636531e-01, -5.505025e-01, -5.713339e-02, -3.406003e-01},
  { 3.949032e-01,  4.205385e-01,  8.168224e-01,  1.739642e-01, -7.941338e-02, -4.533060e-01},
  {-4.034609e-01, -7.021589e-01, -5.866789e-01,  9.717962e-02, -1.198666e-01, -5.418252e-01},
  { 7.026042e-01,  3.157952e-01, -6.376683e-01,  5.169641e-01, -1.091197e-01, -5.772992e-01},
  {-8.966770e-01, -2.182041e-01, -3.851719e-01,  2.757860e-01, -1.154797e-01, -6.040779e-01},
  {-5.121873e-01,  5.582164e-01, -6.527317e-01, -3.013054e-01, -1.404301e-01, -6.587886e-01},
  { 5.943542e-01, -7.704928e-01, -2.303998e-01, -2.058013e-01, -1.647987e-01, -7.365924e-01},
  { 3.124315e-01, -5.004721e-01,  8.074121e-01, -3.687897e-01, -1.433316e-01, -6.842991e-01},
  {-3.577186e-01, -6.578479e-01, -6.627772e-01, -3.889423e-01, -2.017404e-01, -7.132316e-01},
  {-2.724450e-01,  7.074443e-01,  6.521474e-01,  3.436476e-01, -6.033086e-02,  8.908279e-01},
  {-5.513828e-01, -1.305233e-01,  8.239786e-01, -1.051115e-01, -8.326994e-02,  7.691144e-01},
  { 7.677963e-01,  5.827270e-01,  2.663044e-01,  3.337318e-01, -9.043971e-02,  6.803042e-01},
  {-2.400388e-01, -9.575613e-01,  1.595547e-01, -1.058661e-01, -1.006604e-01,  6.734371e-01},
  {-4.751881e-01, -7.642476e-01,  4.360298e-01, -1.178994e-01, -9.467721e-02,  6.912417e-01},
  { 6.495411e-01, -5.887168e-01, -4.811537e-01,  2.195704e-01, -1.158283e-01,  6.185338e-01},
  { 4.547556e-01,  4.058890e-01,  7.927493e-01,  6.990020e-02, -6.858259e-02,  5.615160e-01},
  { 3.046332e-01, -1.927632e-01, -9.327599e-01,  3.508371e-01, -9.528553e-02,  4.775557e-01},
  {-7.688348e-02, -9.100674e-01,  4.072666e-01,  3.756756e-01, -1.443594e-01,  4.357586e-01},
  { 7.319496e-01, -5.600619e-01, -3.880469e-01,  4.618391e-01, -1.227417e-01,  3.974017e-01},
  { 6.991745e-01, -3.317252e-02,  7.141811e-01, -3.114262e-01, -7.855868e-02,  3.732969e-01},
  { 6.581004e-01,  1.309725e-02,  7.528163e-01, -2.997048e-01, -7.732961e-02,  3.609425e-01},
  {-5.560183e-01,  3.040468e-02, -8.306138e-01, -1.963398e-01, -1.061616e-01,  2.854718e-01},
  {-5.224227e-01,  2.060420e-01, -8.274185e-01, -1.751962e-01, -1.051577e-01,  2.731690e-01},
  { 4.920634e-02, -9.539168e-01, -2.960091e-01, -2.956558e-01, -1.132444e-01,  1.998455e-01},
  {-3.017671e-01, -3.289661e-01,  8.948284e-01, -4.374052e-01, -1.363526e-01,  1.659994e-01},
  { 9.835451e-01, -1.138245e-01,  1.402960e-01,  5.641227e-01, -6.357869e-02,  4.663927e-02},
  {-4.239166e-01, -5.716848e-01, -7.024750e-01, -5.182843e-01, -1.139970e-01,  4.724933e-02},
  {-1.049569e-01,  8.229588e-02, -9.910659e-01, -1.081258e-01, -9.714602e-02,  6.886025e-02},
  {-7.352081e-01,  4.629152e-01, -4.951551e-01, -3.696737e-02, -9.507468e-02,  4.533849e-02},
  {-4.609390e-01,  3.623541e-01, -8.100832e-01,  4.173623e-01, -6.492850e-02,  2.751926e-02},
  { 2.178988e-01, -6.882449e-01,  6.919819e-01,  4.299069e-01, -1.311517e-01, -1.602160e-02},
  {-9.428209e-01,  3.246090e-01,  7.561661e-02, -5.919752e-01, -5.654380e-02, -9.477867e-02},
  {-6.993048e-01,  1.625390e-01,  6.960990e-01, -5.525990e-01, -3.868506e-02, -8.680561e-02},
  {-6.272265e-01,  3.100652e-01,  7.144554e-01, -4.789617e-02, -7.682487e-02, -2.322804e-01},
  { 3.866731e-01, -7.479469e-01, -5.394992e-01,  4.900202e-01, -1.186174e-01, -2.277436e-01},
  { 6.983315e-01,  7.149796e-01,  3.372073e-02, -1.040219e-01, -7.665262e-02, -2.402392e-01},
  {-2.143569e-01,  8.857070e-02, -9.727315e-01, -3.529644e-01, -1.185356e-01, -3.379145e-01},
  {-6.385926e-01,  5.401514e-01,  5.481204e-01, -5.515350e-01, -4.583007e-02, -3.444394e-01},
  { 4.395193e-02, -1.623717e-01, -9.857503e-01,  1.311815e-01, -8.964004e-02, -4.437630e-01},
  {-4.980043e-01,  8.520726e-01, -1.611336e-01, -5.306177e-01, -2.427927e-02, -3.632796e-01},
  {-5.587635e-01, -3.763596e-01, -7.390108e-01,  2.260002e-01, -9.777733e-02, -4.365500e-01},
  {-7.846457e-01, -2.593489e-01, -5.630892e-01, -4.305855e-01, -1.002190e-01, -4.870310e-01},
  {-1.332630e-01, -6.037900e-01, -7.859253e-01, -3.913486e-01, -1.387839e-01, -5.266536e-01},
  {-4.737183e-01, -7.187584e-01, -5.088982e-01, -3.002101e-01, -7.746671e-02, -5.254813e-01},
  { 2.402708e-01, -2.667903e-01, -9.333235e-01,  4.229577e-01, -1.016174e-01, -6.051394e-01},
  { 6.000528e-01, -7.653408e-01,  2.327877e-01, -1.738137e-01, -1.283688e-01, -6.575356e-01},
  {-3.823184e-01,  5.331652e-01, -7.546970e-01, -2.733316e-01, -1.060204e-01, -6.298031e-01},
  { 8.079814e-01,  5.548265e-01,  1.983274e-01,  3.621181e-01, -3.882020e-02,  8.272422e-01},
  {-8.343923e-01,  8.853477e-02,  5.440139e-01,  2.261138e-01, -6.380370e-02,  7.828143e-01},
  {-7.096025e-02, -9.417700e-01,  3.286850e-01,  1.314513e-01, -1.362626e-01,  7.504544e-01},
  {-1.428974e-01, -4.940972e-01,  8.575828e-01,  2.286527e-01, -1.002637e-01,  7.407159e-01},
  { 5.299186e-01, -4.910173e-01,  6.914394e-01,  1.730136e-01, -1.224425e-01,  7.686571e-01},
  {-4.615158e-01, -2.453739e-01,  8.525227e-01,  2.189630e-01, -9.565759e-02,  7.410332e-01},
  {-5.802659e-01, -7.841719e-01, -2.199227e-01,  1.252891e-01, -1.147685e-01,  6.234248e-01},
  {-6.621183e-01, -7.471049e-01, -5.859816e-02,  1.338032e-01, -1.149148e-01,  6.098190e-01},
  {-9.158549e-01, -6.822864e-02,  3.956701e-01, -2.140773e-01, -8.723960e-02,  6.780103e-01},
  {-2.125929e-01, -3.590836e-01,  9.087701e-01, -2.715029e-01, -9.860472e-02,  5.945864e-01},
  { 3.879347e-01,  8.568071e-01, -3.396888e-01,  1.214427e-02, -6.205826e-02,  5.120136e-01},
  { 4.999559e-01, -3.960168e-02, -8.651450e-01,  3.021520e-01, -8.012068e-02,  4.487270e-01},
  {-6.481850e-01,  7.509553e-01,  1.261837e-01, -9.821198e-02, -6.354804e-02,  4.302713e-01},
  { 7.505253e-01, -5.143184e-01,  4.149561e-01,  4.643871e-01, -1.507968e-01,  4.425027e-01},
  {-2.971152e-03, -7.324177e-02,  9.973098e-01,  4.302439e-01, -1.347875e-01,  4.588330e-01},
  {-7.396083e-01, -5.383035e-01,  4.039913e-01, -4.303183e-01, -1.103754e-01,  3.792207e-01},
  { 1.630227e-01,  9.416594e-01,  2.944507e-01, -2.619511e-01, -3.609143e-02,  2.921947e-01},
  {-6.200038e-01, -7.651901e-01,  1.734341e-01, -4.660140e-01, -1.071683e-01,  3.017437e-01},
  {-2.489731e-01,  3.347520e-01, -9.088198e-01, -9.774859e-02, -9.008265e-02,  2.575048e-01},
  {-1.532170e-01, -8.362170e-01, -5.265604e-01, -4.475952e-01, -1.085229e-01,  2.161592e-01},
  { 1.939254e-01,  3.744936e-01, -9.067235e-01,  2.471170e-01, -6.498249e-02,  1.520454e-01},
  { 2.156000e-01,  8.928464e-01, -3.954009e-01, -3.710633e-01, -7.140937e-02,  7.711662e-02},
  {-2.789166e-01,  2.071771e-01, -9.377010e-01, -4.617420e-01, -7.394206e-02,  4.733754e-03},
  {-3.041037e-01,  1.199693e-01, -9.450547e-01, -4.814158e-01, -7.783347e-02,  8.332102e-03},
  { 5.664910e-01, -6.508582e-01,  5.054420e-01,  4.440469e-01, -1.526382e-01, -5.460253e-02},
  { 2.011975e-01, -4.109643e-01,  8.891726e-01, -3.783675e-01, -8.055947e-02, -3.652072e-02},
  {-2.898462e-02, -7.577052e-01,  6.519530e-01, -4.123254e-01, -1.125407e-01, -6.387138e-02},
  { 5.209226e-01, -8.428887e-01,  1.348273e-01,  4.654455e-01, -1.515010e-01, -1.479623e-01},
  {-4.224470e-01, -6.239554e-01, -6.574330e-01, -5.451605e-01, -1.047359e-01, -2.796201e-01},
  { 5.099225e-01, -8.502725e-01, -1.304444e-01,  4.905902e-01, -1.406799e-01, -1.767238e-01},
  {-8.994138e-01, -1.496023e-01, -4.106993e-01, -5.670064e-01, -7.364893e-02, -2.822015e-01},
  {-1.256414e-01, -4.413234e-01, -8.885088e-01, -4.444891e-01, -8.912534e-02, -3.107731e-01},
  {-2.842391e-01, -8.912143e-01, -3.534760e-01, -3.977042e-01, -1.035710e-01, -3.193561e-01},
  {-5.199573e-01,  3.877091e-01,  7.611347e-01, -7.316550e-02, -6.703773e-02, -2.515874e-01},
  { 5.538715e-01, -3.403037e-01, -7.598814e-01,  4.881553e-01, -8.922135e-02, -2.552551e-01},
  { 9.420453e-02,  6.109817e-01, -7.860197e-01, -3.115135e-01, -5.834304e-02, -3.362747e-01},
  {-5.598807e-02,  2.242596e-01, -9.729198e-01, -2.222899e-01, -9.143723e-02, -3.102305e-01},
  {-4.810585e-01,  3.911909e-02, -8.758153e-01, -2.774154e-02, -7.941592e-02, -3.962630e-01},
  { 2.293913e-01,  1.476405e-01,  9.620717e-01, -3.679318e-01, -4.378286e-02, -3.585691e-01},
  {-7.449703e-01,  4.032458e-01, -5.314245e-01, -4.447368e-01, -3.585577e-02, -4.400227e-01},
  { 4.712901e-01,  2.915850e-01,  8.323843e-01, -6.323543e-02, -8.052414e-02, -4.864812e-01},
  {-3.519825e-01,  8.418570e-01,  4.091274e-01, -3.216735e-01, -6.041588e-02, -5.541698e-01},
  {-3.841039e-01, -6.970621e-01, -6.054492e-01, -4.159138e-01, -1.100099e-01, -5.491466e-01},
  { 7.421132e-02, -2.726351e-01, -9.592512e-01,  4.047689e-01, -9.529200e-02, -6.064320e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  3.832276e-01, -8.573972e-02, -6.095508e-01},
  {-2.665165e-01, -4.027214e-01, -8.756623e-01,  3.598521e-01, -8.464587e-02, -6.195952e-01},
  { 2.919169e-01,  4.363835e-01, -8.510898e-01,  4.483185e-01, -9.965955e-02, -5.967145e-01},
  { 9.436737e-01,  3.307977e-01,  7.255982e-03,  6.670097e-02, -6.885840e-02, -6.671627e-01},
  { 9.310267e-01, -3.301292e-01,  1.555762e-01, -1.446881e-01, -1.005919e-01, -6.873378e-01},
  { 6.994861e-01, -5.843893e-01, -4.113494e-01, -1.314276e-01, -1.042406e-01, -7.266658e-01},
  {-8.474989e-01,  2.690238e-01, -4.575717e-01, -3.800197e-01, -8.363820e-02, -7.006337e-01},
  {-9.378940e-01,  1.538672e-01, -3.109337e-01, -3.891236e-01, -1.128072e-01, -7.186676e-01},
  { 8.459748e-01,  5.301634e-01,  5.703917e-02,  3.691429e-01, -4.444951e-02,  8.072223e-01},
  {-3.132366e-02,  8.414769e-01,  5.393844e-01,  2.834626e-01, -2.949445e-02,  8.294172e-01},
  { 4.327181e-01, -6.384457e-01,  6.365078e-01,  1.475126e-01, -1.125880e-01,  7.983847e-01},
  {-5.008646e-01, -7.862931e-01,  3.617705e-01,  9.086984e-02, -1.110281e-01,  7.943568e-01},
  { 2.475785e-01,  5.949185e-01,  7.647070e-01, -5.340562e-02, -3.280372e-02,  7.511147e-01},
  {-4.783040e-01,  2.422642e-01,  8.441169e-01,  2.090840e-01, -6.373939e-02,  7.388511e-01},
  {-3.221188e-01,  4.998741e-01,  8.039685e-01, -1.238651e-01, -3.096303e-02,  7.559494e-01},
  { 6.580743e-01,  1.058222e-01,  7.454796e-01,  3.667450e-01, -5.011567e-02,  5.944048e-01},
  {-5.347537e-01, -2.134773e-01,  8.175977e-01,  1.252570e-01, -8.257152e-02,  5.648021e-01},
  {-9.344944e-01, -2.941480e-01,  2.004926e-01, -3.252954e-01, -6.678990e-02,  5.201905e-01},
  {-2.148226e-01,  8.716523e-01, -4.405377e-01,  1.106895e-02, -2.560069e-02,  4.667930e-01},
  { 7.097171e-01,  3.155765e-01,  6.298515e-01, -1.905740e-01, -6.431042e-02,  5.119128e-01},
  { 3.463404e-01,  7.113824e-01,  6.115418e-01, -1.009284e-01, -4.978978e-02,  4.053186e-01},
  {-9.168216e-02,  5.838130e-02,  9.940755e-01, -4.051385e-01, -7.444186e-02,  4.287835e-01},
  { 3.057982e-01,  3.772964e-01,  8.741481e-01, -3.768581e-01, -5.855817e-02,  4.132178e-01},
  { 4.780979e-01,  4.746254e-01,  7.390217e-01, -3.447011e-01, -5.557764e-02,  4.002181e-01},
  { 4.682291e-01,  8.033884e-01,  3.678704e-01, -2.965299e-01, -3.875548e-02,  3.082554e-01},
  { 1.543189e-01,  7.249309e-01,  6.713127e-01, -2.734997e-01, -4.567030e-02,  2.321875e-01},
  { 1.887273e-01,  7.838283e-01,  5.916039e-01, -2.837864e-01, -4.236316e-02,  2.324948e-01},
  {-2.999293e-01, -9.118073e-01,  2.804458e-01, -3.748538e-01, -9.707153e-02,  1.868322e-01},
  {-6.703626e-01, -7.100328e-01,  2.155631e-01, -3.861715e-01, -8.524179e-02,  1.761858e-01},
  {-8.244247e-01, -5.581753e-01,  9.361806e-02, -5.474037e-01, -8.574789e-02,  1.027994e-01},
  { 5.329750e-01, -4.328525e-01, -7.270325e-01,  5.799573e-01,  1.742730e-02,  1.886809e-02},
  { 5.841311e-01, -4.392711e-01,  6.825187e-01,  3.908490e-01, -8.727577e-02,  4.168751e-02},
  {-2.604667e-02, -2.153267e-01,  9.761946e-01, -4.297590e-01, -5.212822e-02, -2.403110e-02},
  {-3.747739e-01, -5.270935e-01,  7.627037e-01, -4.610385e-01, -7.002660e-02, -3.322290e-02},
  {-6.715367e-01, -7.050381e-01,  2.279467e-01, -1.935860e-01, -7.545835e-02, -9.652615e-02},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.858804e-01, -6.112499e-02, -7.073650e-02},
  {-5.646993e-01, -8.217999e-01, -7.589182e-02, -2.152584e-01, -5.407261e-02, -1.668420e-01},
  {-8.777677e-02,  4.232904e-01, -9.017320e-01, -4.543303e-01, -2.654832e-02, -3.168930e-01},
  {-4.631710e-01,  9.826058e-02, -8.808050e-01, -5.506298e-01, -4.177983e-02, -3.005537e-01},
  {-9.049093e-01,  3.376445e-01,  2.591052e-01, -1.882326e-01, -6.048279e-02, -3.832567e-01},
  {-2.170597e-01,  4.922560e-01,  8.429525e-01, -4.416832e-01, -1.112274e-02, -3.472769e-01},
  {-9.903326e-01, -8.377045e-02,  1.105618e-01, -4.405091e-01, -1.676917e-02, -4.312837e-01},
  { 9.044372e-01,  3.956413e-01,  1.595660e-01,  5.288737e-03, -6.859037e-02, -5.353465e-01},
  {-7.925726e-01, -3.057047e-01, -5.276111e-01,  2.648569e-01, -6.456526e-02, -6.081464e-01},
  { 6.668338e-01, -4.952001e-01, -5.568747e-01, -1.523446e-01, -7.297684e-02, -5.767245e-01},
  { 7.255047e-01,  6.755108e-01,  1.316366e-01, -2.690284e-02, -5.767165e-02, -5.848027e-01},
  { 8.943081e-01,  3.934086e-01,  2.131728e-01,  6.626350e-02, -4.504580e-02, -6.868393e-01},
  {-5.014517e-01, -4.196808e-01, -7.565806e-01, -8.875925e-02, -8.149166e-02, -7.124315e-01},
  { 1.626658e-01, -5.244131e-01, -8.357815e-01, -2.463534e-02, -7.366873e-02, -7.398493e-01},
  { 5.696483e-01, -8.028504e-01,  1.758750e-01,  4.731325e-01, -9.790367e-02,  7.783573e-01},
  { 6.327796e-01,  5.001816e-01,  5.911077e-01,  3.568682e-01, -2.462012e-02,  7.905751e-01},
  {-1.202879e-01, -9.831465e-01, -1.376724e-01,  4.402729e-01, -1.042472e-01,  7.393814e-01},
  {-5.493890e-01, -8.206761e-01,  1.570428e-01,  4.142656e-01, -9.380335e-02,  7.745234e-01},
  {-1.576983e-01, -9.780621e-01, -1.361091e-01,  4.150608e-01, -9.654165e-02,  7.105513e-01},
  { 3.174915e-01, -9.141988e-01, -2.518723e-01,  3.484974e-01, -5.425494e-02,  6.421872e-01},
  {-5.501015e-01,  7.282550e-01,  4.086967e-01, -1.722988e-01, -1.312713e-02,  7.026443e-01},
  { 3.757588e-01,  8.673447e-01,  3.263718e-01, -7.649436e-02,  1.262638e-02,  6.843671e-01},
  {-7.425806e-01,  6.387155e-01, -2.015355e-01, -1.777036e-01, -1.526005e-02,  6.168618e-01},
  {-3.210749e-02,  9.907291e-01, -1.320037e-01, -7.423279e-02,  1.573513e-02,  5.764301e-01},
  {-6.657457e-01,  6.975017e-01, -2.650924e-01, -1.658810e-01, -1.959939e-02,  5.830575e-01},
  { 7.311816e-01,  1.080403e-01,  6.735730e-01,  4.954301e-01, -3.987309e-02,  5.606503e-01},
  {-2.621787e-01,  8.969805e-01, -3.559331e-01, -1.139809e-01,  1.103211e-02,  5.523329e-01},
  { 8.824756e-01, -8.362484e-02, -4.628648e-01,  4.859608e-01, -3.717390e-02,  4.894721e-01},
  {-2.164733e-01, -3.445940e-01,  9.134519e-01, -2.741248e-01, -5.529273e-02,  6.144624e-01},
  { 1.468819e-01, -5.671346e-01, -8.104222e-01,  3.042650e-01, -5.478958e-02,  4.407758e-01},
  { 9.631667e-01, -6.186140e-02,  2.616931e-01,  3.087087e-01, -4.616522e-02,  4.326217e-01},
  {-4.002679e-01,  6.890418e-01, -6.041581e-01,  5.892453e-02, -1.682824e-02,  4.513269e-01},
  {-8.556678e-01, -1.131426e-03, -5.175242e-01, -2.988113e-01, -4.342288e-02,  3.995109e-01},
  {-9.522319e-01,  3.051518e-01,  1.170192e-02,  3.127162e-01, -4.553131e-02,  4.063941e-01},
  {-4.746660e-01,  8.227342e-01,  3.127309e-01, -8.965567e-02, -3.709100e-02,  3.932916e-01},
  {-3.512610e-01,  6.256428e-01,  6.965535e-01, -4.315160e-01, -3.482966e-02,  3.890444e-01},
  {-9.808730e-02,  9.464343e-01,  3.076376e-01, -4.328349e-01, -1.138718e-02,  3.597351e-01},
  {-8.354194e-01,  1.788481e-01,  5.196999e-01, -4.713240e-01, -3.246739e-02,  3.556937e-01},
  { 1.132295e-01,  8.105787e-01,  5.745791e-01, -3.653174e-01, -3.122220e-02,  2.328586e-01},
  { 1.498082e-01,  8.368546e-01,  5.265281e-01, -4.122088e-01, -1.312259e-02,  2.483007e-01},
  { 9.433067e-01,  2.881674e-01,  1.647181e-01,  4.255250e-01, -4.283814e-02,  2.143137e-01},
  {-6.148016e-01, -7.863510e-01, -6.059030e-02, -5.203801e-01, -7.668959e-02,  2.069585e-01},
  { 3.932087e-01, -4.796592e-01,  7.844195e-01,  5.106332e-01, -5.434210e-02,  2.077770e-01},
  {-3.034567e-02, -5.251358e-01,  8.504773e-01,  4.775694e-01, -5.449559e-02,  1.915030e-01},
  {-2.658057e-01, -9.374986e-01,  2.245966e-01, -4.310682e-01, -5.624624e-02,  1.835046e-01},
  {-6.388162e-01, -4.867037e-01,  5.958468e-01, -5.386861e-01, -8.100450e-02,  1.476398e-01},
  { 9.227341e-01,  1.211158e-01,  3.659136e-01,  5.768594e-01,  5.257561e-02,  2.070257e-02},
  {-3.067585e-03, -7.191958e-01, -6.948006e-01, -2.436791e-01, -6.876343e-02,  7.770000e-02},
  { 2.021578e-01, -4.148777e-01, -8.871351e-01, -4.152570e-01, -4.961557e-02,  7.240174e-02},
  {-8.211071e-01, -2.287645e-01, -5.229244e-01, -5.541269e-01, -6.395771e-02,  4.655468e-02},
  { 6.285833e-01,  2.402432e-01, -7.397069e-01,  5.650796e-01,  6.035814e-02, -2.338425e-02},
  {-6.678737e-01, -4.197424e-01, -6.146227e-01, -3.909870e-02, -5.520688e-02,  4.693558e-02},
  { 3.577171e-01, -3.838400e-01,  8.512963e-01,  2.945817e-01, -4.424343e-02,  8.685849e-02},
  { 4.429818e-01, -3.490264e-01,  8.258012e-01,  4.130464e-01, -5.127143e-02,  4.306992e-02},
  {-5.866241e-01,  2.577811e-01, -7.677377e-01, -3.148637e-02, -3.783985e-02,  1.882309e-02},
  { 1.811482e-01,  4.332726e-01,  8.828704e-01, -3.900631e-01, -3.870250e-02, -2.901400e-02},
  { 5.040137e-01,  3.979615e-02,  8.627784e-01, -3.220904e-01, -3.191015e-02, -3.926214e-02},
  {-1.290000e-01,  3.910132e-01,  9.113000e-01, -3.558895e-01, -2.275529e-02, -3.185898e-02},
  { 5.022599e-01, -8.100854e-01,  3.024839e-01,  5.210121e-01, -1.474043e-01, -1.133631e-01},
  {-5.590497e-02,  1.642947e-01,  9.848258e-01, -1.962332e-01, -4.393646e-02, -7.395712e-02},
  { 2.592726e-01, -2.101280e-01,  9.426686e-01, -2.597447e-01, -4.826818e-02, -9.118133e-02},
  {-6.445239e-01,  6.428981e-01, -4.138489e-01, -5.682074e-01, -8.130860e-03, -2.220120e-01},
  { 9.156626e-01,  4.018902e-01,  6.798675e-03, -8.956081e-02, -1.144999e-02, -1.761416e-01},
  { 4.183992e-01, -2.964804e-01, -8.585112e-01,  5.340438e-01, -8.382252e-02, -2.646191e-01},
  {-3.924849e-02,  4.165127e-01, -9.082822e-01, -4.136746e-01, -3.352203e-02, -3.096573e-01},
  { 6.389638e-01, -1.555315e-01, -7.533494e-01,  5.131092e-01, -6.628674e-02, -2.632509e-01},
  {-3.261490e-01,  2.541113e-02, -9.449768e-01,  4.891971e-01, -7.270877e-02, -2.551706e-01},
  {-3.980150e-01,  6.196007e-01, -6.765198e-01, -2.711547e-01, -5.262426e-02, -2.914297e-01},
  {-3.526067e-01,  6.357792e-01,  6.866246e-01, -1.994304e-01, -3.836727e-02, -4.119722e-01},
  { 5.539927e-02, -9.138761e-01, -4.021959e-01,  4.195689e-01, -9.830902e-02, -6.516588e-01},
  {-4.393511e-02, -4.509177e-01, -8.914835e-01,  4.093952e-01, -8.029690e-02, -6.631538e-01},
  {-8.977220e-01, -3.204975e-02,  4.393950e-01,  2.684609e-01, -5.185730e-02, -5.786051e-01},
  { 3.469107e-01, -1.200236e-01, -9.301867e-01, -3.427799e-01, -6.455827e-02, -6.215650e-01},
  {-1.052062e-01, -4.172273e-01, -9.026921e-01,  3.584916e-01, -6.074953e-02, -6.646264e-01},
  { 7.530335e-01,  4.634440e-02,  6.563480e-01,  2.402345e-01, -2.671977e-02, -5.289343e-01},
  {-6.614193e-01, -7.920902e-02, -7.458220e-01, -1.201594e-01, -5.738818e-02, -5.855543e-01},
  { 8.386658e-01, -4.267652e-01, -3.383949e-01,  2.332853e-01, -6.622016e-02, -6.221321e-01},
  { 1.182128e-01, -7.712128e-01, -6.255050e-01,  1.696925e-01, -9.180053e-02, -6.706830e-01},
  {-5.988389e-01, -7.965161e-02,  7.968988e-01, -2.495943e-01, -4.857253e-02, -6.231815e-01},
  { 9.366209e-01, -1.348165e-01, -3.233662e-01,  6.268016e-02, -3.264242e-02, -7.018936e-01},
  { 8.594912e-01, -8.339262e-02,  5.043021e-01, -1.159762e-01, -6.819503e-02, -7.102546e-01},
  {-1.163408e-01, -2.193988e-01, -9.686739e-01, -2.779267e-01, -4.683516e-02, -7.741719e-01},
  { 8.096138e-02, -9.136490e-01,  3.983598e-01,  4.586902e-01, -9.738662e-02,  7.945598e-01},
  { 9.840587e-01, -1.083808e-02,  1.775135e-01,  3.748571e-01, -3.031214e-02,  7.812521e-01},
  { 9.315799e-01, -3.594279e-01, -5.450242e-02,  4.867764e-01, -8.203948e-02,  7.480920e-01},
  { 8.628093e-01,  4.972959e-01,  9.086782e-02,  3.900491e-01, -5.677094e-02,  7.818030e-01},
  { 3.158531e-01, -8.449701e-01, -4.315813e-01,  4.638535e-01, -8.549458e-02,  6.937324e-01},
  { 7.935516e-01, -8.113705e-02,  6.030693e-01,  1.798437e-01, -5.043914e-02,  7.398939e-01},
  {-9.873158e-02,  4.195541e-01,  9.023450e-01,  2.002597e-01, -3.101592e-02,  7.164332e-01},
  {-2.642762e-01,  9.573836e-01,  1.165104e-01, -1.313548e-01,  1.467897e-02,  6.719452e-01},
  { 5.017573e-01, -8.622897e-01, -6.852824e-02,  3.784904e-01, -2.250551e-02,  6.112900e-01},
  {-5.357038e-01, -8.357047e-01, -1.209097e-01,  8.405110e-02, -3.402466e-02,  6.162206e-01},
  { 5.805340e-01, -6.766794e-01,  4.528633e-01,  4.055887e-01, -1.302207e-02,  5.868416e-01},
  {-6.438327e-01, -7.442526e-01,  1.776723e-01,  1.059707e-01, -4.920622e-02,  5.631077e-01},
  { 5.735753e-01, -3.556510e-02, -8.183804e-01,  4.869284e-01, -2.692980e-03,  4.897213e-01},
  {-3.320789e-01, -1.570757e-01,  9.300811e-01, -2.753178e-01, -3.658601e-02,  6.194406e-01},
  { 1.672953e-01,  9.107395e-02, -9.816913e-01,  4.077235e-01, -1.225888e-02,  4.578949e-01},
  {-6.242943e-01,  7.188137e-01, -3.058816e-01,  8.618556e-02, -9.121560e-03,  4.383607e-01},
  {-8.679907e-01,  4.953472e-01,  3.497346e-02,  8.485755e-02, -1.123727e-02,  4.241452e-01},
  {-1.515623e-01,  9.354476e-01,  3.193222e-01,  4.092424e-02, -2.307913e-02,  4.066665e-01},
  { 8.471231e-01,  6.340761e-02,  5.276000e-01,  4.815401e-01, -4.249480e-02,  4.227557e-01},
  {-2.303529e-01, -1.068830e-01,  9.672195e-01,  3.905134e-01, -3.067656e-02,  4.106094e-01},
  {-1.932233e-01,  9.620725e-01,  1.925651e-01, -3.067001e-02, -2.372451e-02,  3.856987e-01},
  {-6.985794e-01, -6.420500e-01,  3.158458e-01, -5.299900e-01, -6.824621e-02,  2.023613e-01},
  { 4.763797e-02, -9.987754e-01, -1.335973e-02, -5.010180e-01, -6.855629e-02,  1.797680e-01},
  {-3.341761e-01, -8.901329e-01,  3.098219e-01, -4.518621e-01, -5.813024e-02,  1.742255e-01},
  {-9.484748e-01, -2.882151e-03,  3.168395e-01, -5.508178e-01, -4.034269e-02,  1.519432e-01},
  { 9.009480e-01,  3.655665e-01,  2.337814e-01,  5.727416e-01,  9.353854e-02,  9.209109e-03},
  {-5.956220e-02, -5.370232e-01, -8.414620e-01, -3.447813e-01, -5.014731e-02,  8.107467e-02},
  {-7.619029e-01, -7.260801e-02, -6.436086e-01, -5.545307e-01, -3.936665e-02,  5.159551e-02},
  {-5.254389e-02, -6.019213e-01, -7.968249e-01, -2.677984e-01, -4.978487e-02,  6.427088e-02},
  { 9.668708e-02, -5.747752e-01, -8.125793e-01, -1.088862e-01, -4.200429e-02,  1.733602e-02},
  { 1.358086e-01, -5.379377e-01, -8.319730e-01, -1.313967e-01, -4.228653e-02,  9.174579e-03},
  { 2.106893e-01, -5.528613e-01, -8.061975e-01, -1.474052e-01, -4.337265e-02,  1.021511e-02},
  {-8.418882e-01, -2.237723e-01,  4.910704e-01, -1.041669e-01, -5.077009e-02, -2.128125e-02},
  { 5.021630e-01,  6.804238e-01,  5.337189e-01, -4.264260e-01,  3.794605e-03, -4.985059e-02},
  { 5.216283e-01,  5.958938e-01,  6.105853e-01, -4.434511e-01,  1.828248e-02, -5.231372e-02},
  {-1.383749e-01,  2.751354e-01,  9.513952e-01, -4.905181e-01,  6.249217e-04, -3.763154e-02},
  { 2.848214e-01,  9.350165e-01, -2.112372e-01, -3.764501e-01, -1.538050e-02, -1.076800e-01},
  { 9.398848e-01,  2.748957e-01, -2.026054e-01,  5.256234e-01, -6.615756e-02, -1.501908e-01},
  {-9.048104e-01,  4.174596e-01,  8.393774e-02, -5.622053e-01,  3.201218e-02, -1.295587e-01},
  { 7.625881e-01,  1.476036e-01,  6.298195e-01,  5.216538e-01, -6.205511e-02, -1.797569e-01},
  { 6.907564e-01,  2.748424e-01, -6.688176e-01,  5.763329e-01, -9.390795e-02, -1.675668e-01},
  { 5.173777e-01,  8.250184e-01,  2.272990e-01, -4.118115e-01, -9.032325e-03, -1.158224e-01},
  {-2.484497e-02,  3.198259e-01,  9.471505e-01,  5.478579e-01, -4.867346e-02, -1.835882e-01},
  { 7.601041e-01,  6.400831e-01,  1.119625e-01,  5.420755e-01, -7.270935e-02, -1.942367e-01},
  { 6.692674e-01,  6.990322e-01,  2.518634e-01,  5.725313e-01, -1.046856e-01, -1.864178e-01},
  { 5.532208e-01,  6.838583e-01,  4.756937e-01, -3.959124e-01, -1.135711e-02, -1.474070e-01},
  { 2.826974e-01, -3.051833e-01, -9.093653e-01,  5.648220e-01, -6.108575e-02, -1.910662e-01},
  {-3.928630e-02,  2.331432e-01,  9.716486e-01,  5.470437e-01, -6.312542e-02, -2.049333e-01},
  { 8.741141e-02,  3.337386e-01,  9.386042e-01,  5.754007e-01, -8.581145e-02, -1.983433e-01},
  { 9.366341e-01,  3.275617e-01,  1.241771e-01, -9.504669e-02,  1.524473e-02, -1.712095e-01},
  { 1.798385e-01, -8.504505e-01, -4.943603e-01,  5.280268e-01, -1.299075e-01, -2.337220e-01},
  {-7.805618e-01,  3.714603e-01, -5.027330e-01, -4.720666e-01,  1.802837e-02, -2.268126e-01},
  { 5.091041e-02,  6.733167e-01, -7.375994e-01, -3.595703e-01, -2.447820e-02, -2.564220e-01},
  { 4.627798e-01,  4.754058e-01,  7.482140e-01, -1.273801e-01, -2.262037e-02, -2.715896e-01},
  {-6.278669e-01, -3.658253e-01, -6.869898e-01, -2.443106e-01, -4.865712e-02, -3.239769e-01},
  { 9.694544e-01, -1.894392e-01, -1.557918e-01, -5.680219e-02, -3.052956e-02, -4.525971e-01},
  {-7.393367e-01,  2.013559e-01, -6.425239e-01,  2.469757e-01, -2.186233e-02, -5.190423e-01},
  {-8.553241e-01, -4.749743e-01,  2.069301e-01, -4.730028e-01, -5.353866e-02, -5.114666e-01},
  {-8.944772e-01,  3.913224e-01, -2.162804e-01,  2.963600e-01, -2.768919e-02, -5.497523e-01},
  { 8.345010e-01,  5.206591e-02,  5.485409e-01, -5.519076e-02, -2.926554e-02, -4.973057e-01},
  {-2.132892e-02, -3.677875e-01, -9.296652e-01, -3.674411e-01, -4.724339e-02, -6.403307e-01},
  { 7.205807e-01, -3.650566e-01, -5.894888e-01,  4.938543e-01, -2.608771e-02, -6.301287e-01},
  {-1.648555e-01,  3.527602e-01, -9.210770e-01, -3.927950e-01, -2.607195e-02, -6.355168e-01},
  { 9.107198e-01,  3.094548e-01,  2.735454e-01, -3.794979e-02, -1.882358e-02, -5.986722e-01},
  { 2.563530e-01, -5.989560e-01,  7.586401e-01,  1.360553e-01, -5.041461e-02,  8.614341e-01},
  {-7.023859e-01, -1.120013e-01,  7.029294e-01,  4.810660e-02, -2.664098e-02,  8.402131e-01},
  {-9.053886e-01, -2.760536e-01,  3.225926e-01,  7.090738e-03, -1.251357e-03,  7.642193e-01},
  { 5.596421e-01, -6.530966e-01, -5.101623e-01,  4.785202e-01, -2.874769e-02,  6.376160e-01},
  {-5.104935e-01,  5.247598e-01,  6.811928e-01,  3.230510e-01, -1.256754e-02,  3.877765e-01},
  {-2.311085e-01, -2.463434e-01,  9.412246e-01,  2.359115e-02, -1.619267e-02,  4.025156e-01},
  { 9.538764e-01,  1.557335e-01,  2.566454e-01,  5.148966e-01, -5.694524e-03,  2.177691e-01},
  {-8.140084e-02,  4.254192e-01,  9.013281e-01, -3.181180e-01,  2.905306e-02,  2.254117e-01},
  {-8.440618e-02,  7.657537e-01,  6.375710e-01, -4.661362e-01,  4.604983e-02,  2.359616e-01},
  { 8.740784e-01, -4.781340e-01,  8.587631e-02,  2.521421e-01,  5.319319e-03,  1.657792e-01},
  {-6.578540e-02,  5.481598e-01,  8.337824e-01, -1.389916e-01,  3.350072e-03,  2.105724e-01},
  { 2.762766e-01,  6.202681e-01,  7.341245e-01, -2.786582e-01,  3.868512e-02,  2.132058e-01},
  {-9.666850e-01,  2.403679e-01,  8.799714e-02,  4.321869e-01,  3.401256e-02,  4.440238e-02},
  {-2.208439e-01,  3.411226e-01, -9.137086e-01,  4.972705e-01,  1.181904e-01, -7.234966e-03},
  {-7.455952e-01,  1.893275e-01, -6.389390e-01,  4.417647e-01,  4.562405e-02,  2.131774e-02},
  { 5.827623e-02, -7.191534e-02, -9.957068e-01, -4.455422e-01, -2.537891e-02,  4.885426e-02},
  { 4.726180e-01,  8.713713e-03,  8.812243e-01,  4.302497e-01, -1.406552e-02,  3.621610e-02},
  { 6.748412e-01, -1.085383e-01,  7.299375e-01,  4.737340e-01, -1.874109e-02, -1.995238e-03},
  { 9.137227e-01,  2.047188e-02,  4.058222e-01,  5.602781e-01, -6.917126e-02, -6.892682e-02},
  { 9.539667e-01,  9.427495e-02,  2.847097e-01,  5.505204e-01, -3.474993e-02, -5.969529e-02},
  { 3.940530e-01,  5.563054e-01,  7.316054e-01, -4.466386e-01,  3.789748e-02, -6.519357e-02},
  {-4.039144e-01,  3.627747e-01,  8.397903e-01, -5.224075e-01,  3.166537e-02, -5.941594e-02},
  {-8.017214e-01,  3.628573e-01,  4.749499e-01, -5.491768e-01,  3.735294e-02, -8.784822e-02},
  { 4.857121e-01,  4.441361e-01,  7.528790e-01, -1.422013e-01, -6.876083e-03, -1.057956e-01},
  {-3.962091e-01, -2.376251e-01,  8.868781e-01,  5.422451e-01, -2.316025e-02, -1.963690e-01},
  {-5.481516e-01,  7.878837e-01, -2.806581e-01, -5.282197e-01,  6.846565e-02, -1.603093e-01},
  {-7.685238e-01,  3.892461e-01, -5.077977e-01, -4.768802e-01,  3.965075e-02, -2.112501e-01},
  { 8.462572e-01,  3.848814e-01,  3.683955e-01, -1.619585e-01,  4.406777e-03, -2.426856e-01},
  {-5.751858e-01, -5.375760e-01, -6.165819e-01, -2.789580e-01, -2.782440e-02, -2.895907e-01},
  { 8.024266e-01,  1.826024e-01, -5.681267e-01,  5.071716e-01, -5.291427e-03, -2.969342e-01},
  {-8.354331e-01, -3.660734e-01, -4.099290e-01, -1.917753e-01, -1.144227e-02, -3.882254e-01},
  {-6.264210e-02,  2.112179e-01, -9.754297e-01,  1.740368e-01, -9.291425e-04, -4.204765e-01},
  { 2.512820e-01,  2.895579e-01, -9.235873e-01,  7.270758e-02,  5.498944e-05, -4.662941e-01},
  { 2.366222e-01,  5.665308e-01,  7.893369e-01, -2.507306e-01,  4.336189e-03, -4.470284e-01},
  {-9.543542e-01, -2.488713e-01, -1.651396e-01, -4.989012e-01, -6.592480e-03, -5.325701e-01},
  {-6.998010e-01,  1.871384e-02, -7.140926e-01, -4.843188e-01, -1.301317e-02, -5.679997e-01},
  { 8.697788e-01, -4.480051e-01, -2.068242e-01,  5.111275e-01,  4.447028e-03, -6.230559e-01},
  {-9.433890e-01,  4.224890e-02, -3.289867e-01,  2.647495e-01,  1.628520e-02, -6.477744e-01},
  { 4.094689e-02,  5.982203e-01,  8.002848e-01,  1.446292e-01,  2.166140e-02, -5.097473e-01},
  {-5.493625e-01,  5.089647e-01, -6.626884e-01, -4.052655e-01,  1.415979e-02, -6.077943e-01},
  { 9.516223e-01,  1.495454e-01,  2.684234e-01, -1.665200e-01, -1.572574e-02, -6.773245e-01},
  {-4.083654e-01, -6.391532e-01, -6.517062e-01,  1.195214e-01, -3.627095e-02, -6.879535e-01},
  {-7.278469e-01,  1.072606e-02, -6.856558e-01, -7.457795e-02, -9.376011e-03, -7.407809e-01},
  { 3.944091e-01, -3.290325e-01, -8.580087e-01, -1.291238e-01, -2.238745e-02, -7.792853e-01},
  {-3.076929e-02, -8.375008e-02, -9.960116e-01, -3.366534e-03,  1.162891e-02, -7.919284e-01},
  {-1.055383e-01, -3.364474e-01,  9.357696e-01,  1.048820e-01, -1.813108e-02,  8.778545e-01},
  {-8.019742e-01,  5.501889e-01,  2.326576e-01,  6.692921e-02,  1.446457e-02,  7.702588e-01},
  {-2.137353e-01,  9.194596e-01,  3.300169e-01,  9.063955e-02,  1.537377e-02,  7.430446e-01},
  {-4.108640e-01,  6.825377e-01,  6.044278e-01,  1.097563e-02,  3.578894e-02,  7.420689e-01},
  {-9.608480e-01,  1.936081e-01,  1.982095e-01, -1.810693e-02,  3.260702e-02,  6.842167e-01},
  { 5.597022e-01,  8.881446e-02,  8.239207e-01, -2.295427e-01,  2.269311e-02,  6.070958e-01},
  { 3.255828e-01,  4.395136e-01, -8.371521e-01,  3.795656e-01,  2.803771e-02,  4.683546e-01},
  {-9.818168e-01,  1.255626e-01,  1.423724e-01,  8.753696e-02,  1.403294e-02,  4.203361e-01},
  {-6.671439e-01, -6.268592e-01, -4.024505e-01, -1.880098e-01, -7.005403e-03,  3.231168e-01},
  {-3.927240e-01, -7.112672e-01, -5.829811e-01, -1.491999e-01, -1.191743e-02,  2.871934e-01},
  {-3.993458e-01, -2.988341e-01, -8.667301e-01, -1.038070e-01, -1.598515e-02,  2.577796e-01},
  { 9.043545e-01, -1.407361e-01,  4.029101e-01,  4.153463e-01,  8.887135e-03,  2.372110e-01},
  {-5.495800e-01,  5.773497e-01,  6.038452e-01, -5.120988e-01,  2.558385e-02,  2.304619e-01},
  { 2.344557e-01,  6.752664e-01,  6.993181e-01, -3.963249e-01,  4.848678e-02,  2.182076e-01},
  {-7.171427e-01,  4.957531e-01,  4.898320e-01, -1.709974e-01,  1.564816e-02,  1.948181e-01},
  { 2.219710e-01,  9.651590e-01,  1.385534e-01, -2.512826e-01,  4.512640e-02,  1.873157e-01},
  { 7.332473e-02,  9.888492e-01,  1.296175e-01, -3.262669e-01,  5.751007e-02,  1.817363e-01},
  { 2.161972e-01,  9.378463e-01, -2.714832e-01, -3.720233e-01,  6.694889e-02,  1.720738e-01},
  { 1.069703e-01,  9.942306e-01, -7.941923e-03, -4.167313e-01,  7.161909e-02,  1.721023e-01},
  {-2.134569e-01,  9.396234e-01,  2.674771e-01, -4.828636e-01,  7.592088e-02,  1.291500e-01},
  {-9.399032e-01, -9.279131e-02,  3.285906e-01,  4.515324e-01,  6.358201e-03,  9.192884e-02},
  { 4.603266e-02,  9.973277e-01, -5.673044e-02, -2.738720e-01,  1.868091e-02,  1.431740e-01},
  { 1.332272e-01,  9.711599e-01, -1.977343e-01, -3.257312e-01,  1.905762e-02,  1.415979e-01},
  { 7.005642e-01,  7.108042e-01, -6.298637e-02,  5.442213e-01,  1.264166e-01,  2.648059e-02},
  {-7.356765e-01,  6.393955e-01, -2.235022e-01,  4.682395e-01,  1.181382e-01,  1.086671e-02},
  {-7.496482e-01, -4.959352e-02, -6.599758e-01, -5.363464e-01,  1.039120e-02,  1.020400e-02},
  { 1.056131e-01, -7.275240e-01, -6.779047e-01, -1.988967e-01, -1.812152e-02, -3.906377e-02},
  { 7.874615e-01,  1.723605e-02,  6.161228e-01,  5.452025e-01, -8.054297e-03, -3.970873e-02},
  { 2.666582e-01,  8.043498e-01, -5.309566e-01, -3.669090e-01,  1.112021e-02, -6.274214e-02},
  { 9.921822e-01, -3.062750e-02,  1.209809e-01,  5.210294e-01,  7.242950e-04, -1.638581e-01},
  { 6.185065e-01,  4.466422e-01,  6.464987e-01, -4.523939e-01,  8.127157e-02, -9.873690e-02},
  { 6.956165e-01,  7.007473e-01, -1.583375e-01, -1.079024e-01,  4.783409e-02, -1.951242e-01},
  {-6.883642e-01,  6.312788e-01, -3.572699e-01, -2.980469e-01,  8.299232e-03, -1.903211e-01},
  {-8.084094e-01,  5.278062e-01, -2.605664e-01, -4.674113e-01,  7.341991e-02, -1.871025e-01},
  { 4.515458e-01,  7.045255e-01, -5.474945e-01, -1.450846e-01,  5.374631e-02, -2.026442e-01},
  {-9.688140e-01,  2.001968e-01,  1.460160e-01, -7.992190e-02,  5.951438e-02, -2.454346e-01},
  { 9.123400e-01, -9.697397e-02, -3.977835e-01,  5.419484e-01, -4.475782e-03, -2.605702e-01},
  { 1.466523e-01, -2.831498e-01, -9.477970e-01, -3.793428e-01,  4.222457e-03, -2.483702e-01},
  {-5.741522e-01, -6.264330e-01, -5.271916e-01, -2.721059e-01, -1.613539e-02, -3.527460e-01},
  { 9.177794e-01,  1.037243e-01,  3.833043e-01, -4.132624e-01,  3.413477e-02, -3.771011e-01},
  {-1.765268e-01, -4.551603e-01, -8.727356e-01, -4.164669e-02,  5.690560e-03, -4.585234e-01},
  {-9.569919e-01, -1.930255e-01,  2.165819e-01, -4.949676e-01,  3.301774e-02, -4.472069e-01},
  {-2.645062e-01,  5.132422e-01, -8.164674e-01, -4.613373e-01,  4.532813e-02, -5.599231e-01},
  { 3.268071e-02,  7.082771e-01, -7.051777e-01, -3.674418e-01,  3.744695e-02, -5.965062e-01},
  { 2.687415e-01, -8.998442e-01,  3.435963e-01,  5.261364e-01,  2.324336e-02, -5.855693e-01},
  { 5.424576e-01,  8.116960e-02, -8.361526e-01,  4.649970e-01,  5.246248e-02, -6.716162e-01},
  {-3.851106e-01,  1.496387e-01, -9.106581e-01,  3.171545e-01,  5.950361e-02, -6.786067e-01},
  { 6.058092e-01, -3.539561e-01, -7.125379e-01, -4.054331e-02,  1.217304e-02, -5.821992e-01},
  {-2.870438e-01, -2.145035e-01, -9.335920e-01, -1.390819e-01, -1.282537e-03, -5.926273e-01},
  {-1.482829e-01, -4.767652e-01, -8.664335e-01,  1.360180e-01, -1.271888e-02, -7.154685e-01},
  { 7.169899e-01, -1.420539e-01, -6.824559e-01, -9.825248e-02, -1.508231e-02, -7.449266e-01},
  { 3.805716e-01,  1.860306e-01, -9.058464e-01,  2.934054e-02,  2.496221e-02, -7.809602e-01},
  {-3.862295e-01, -4.943352e-01, -7.787551e-01, -3.419858e-01,  5.888536e-03, -7.881317e-01},
  { 6.281058e-01, -5.114629e-01,  5.864203e-01,  4.727751e-01, -2.904217e-02,  8.665109e-01},
  {-4.718056e-01, -6.718972e-01,  5.709234e-01,  4.300535e-01, -7.554083e-02,  8.252132e-01},
  {-8.458447e-01, -2.464555e-01,  4.730817e-01,  3.932943e-01, -2.192728e-02,  7.852954e-01},
  {-7.690616e-01,  5.994507e-01, -2.218176e-01,  1.164699e-01,  3.616272e-02,  7.384511e-01},
  {-3.163795e-01, -2.707603e-01,  9.091715e-01,  2.770965e-01,  2.698858e-02,  6.961947e-01},
  { 7.019108e-01, -6.127163e-01,  3.631803e-01,  2.266943e-01,  9.970581e-03,  7.004108e-01},
  {-6.920489e-01, -6.656858e-01, -2.791607e-01, -2.594526e-03,  1.468054e-03,  6.122410e-01},
  {-8.729458e-01,  3.456290e-01, -3.442474e-01, -1.855130e-02,  4.443174e-02,  5.969521e-01},
  { 2.952465e-01,  5.250822e-01,  7.981968e-01, -2.287131e-01,  4.509455e-02,  6.030785e-01},
  {-8.662248e-01, -4.137750e-01,  2.800799e-01, -3.416654e-01,  6.152893e-03,  5.393506e-01},
  {-9.671212e-01,  2.403807e-01, -8.302828e-02,  9.412016e-02,  4.845763e-02,  4.657562e-01},
  {-5.319743e-01, -8.317872e-01, -1.585358e-01, -3.056862e-01,  1.552363e-02,  4.739761e-01},
  {-6.756774e-01, -6.213341e-01, -3.967417e-01, -2.276091e-01,  2.221083e-02,  3.723505e-01},
  { 8.887863e-01, -2.252650e-01,  3.991424e-01,  4.790661e-01,  1.672670e-02,  4.217948e-01},
  { 3.420079e-01,  6.684225e-03,  9.396732e-01,  3.509159e-01,  2.250896e-02,  3.834051e-01},
  {-6.085617e-01,  7.144111e-01,  3.453538e-01, -5.074658e-01,  5.906875e-02,  1.819767e-01},
  {-7.677490e-01,  6.121129e-01,  1.894183e-01, -5.234397e-01,  5.160559e-02,  1.604767e-01},
  {-8.170995e-01,  2.852152e-01, -5.009999e-01,  4.458590e-01,  4.237809e-02,  1.072902e-01},
  {-2.748216e-01,  5.170989e-01, -8.106058e-01, -2.382274e-01,  3.264764e-02,  1.247236e-01},
  {-9.199715e-01,  2.525048e-01,  2.998230e-01, -2.373277e-01,  3.724292e-02,  1.273500e-01},
  {-4.824030e-01,  8.726888e-01, -7.550970e-02, -2.493467e-01,  2.411143e-02,  1.230480e-01},
  {-1.555592e-01,  9.878192e-01, -3.816303e-03,  5.047209e-01,  1.428574e-01,  3.591578e-02},
  { 2.990113e-01,  5.946124e-01,  7.463433e-01,  5.114301e-01,  1.331973e-01,  5.845600e-02},
  { 7.659333e-01,  1.551682e-03,  6.429182e-01,  4.906810e-01,  1.216892e-01,  6.244941e-02},
  { 2.147449e-01,  9.733776e-01, -8.012856e-02, -3.516247e-01,  2.207023e-02,  1.297436e-01},
  {-1.330310e-01, -5.638510e-01, -8.150920e-01, -4.935656e-01,  1.242977e-02, -8.258399e-03},
  {-1.670969e-01, -5.965906e-01, -7.849575e-01, -3.476169e-01,  2.154211e-03, -1.487337e-02},
  {-8.403652e-01,  2.389132e-01,  4.865254e-01, -1.408225e-02,  3.705917e-02, -1.541564e-03},
  { 8.480948e-01, -1.140318e-02,  5.297218e-01,  4.466648e-01,  2.732616e-02,  1.082625e-02},
  { 1.902048e-03, -4.164997e-01, -9.091339e-01, -2.137376e-01,  1.820946e-02, -6.167686e-02},
  {-6.202495e-01,  4.083655e-01,  6.697224e-01, -8.839849e-02,  2.959980e-02, -1.538511e-02},
  { 8.092580e-01, -4.163467e-02,  5.859761e-01,  5.496835e-01,  1.600997e-02, -4.172298e-02},
  {-9.708960e-01, -1.651968e-01,  1.734097e-01, -1.251915e-01,  1.701971e-02, -8.015023e-02},
  {-8.975619e-01,  1.257868e-01,  4.225640e-01, -5.754544e-02,  4.954893e-02, -3.164717e-01},
  {-1.249712e-01,  1.212935e-01, -9.847183e-01,  1.866464e-01,  3.790158e-02, -4.109431e-01},
  {-8.413879e-01, -9.128239e-02,  5.326667e-01, -4.890845e-01,  6.444419e-02, -3.996598e-01},
  {-6.676005e-01,  2.346113e-01,  7.065883e-01, -1.988890e-01,  4.148222e-02, -4.625798e-01},
  { 9.546178e-01, -1.208638e-01,  2.722071e-01, -5.939499e-02,  8.876646e-03, -4.990104e-01},
  {-8.376354e-01,  4.197801e-01, -3.495020e-01, -4.857869e-01,  7.616057e-02, -5.080395e-01},
  {-8.213457e-01,  4.415048e-01,  3.611990e-01,  2.872123e-01,  4.289128e-02, -5.940676e-01},
  { 1.178535e-01,  4.487997e-01, -8.858269e-01,  3.928216e-01,  1.026622e-01, -6.864518e-01},
  {-8.782326e-01,  4.533169e-01, -1.523523e-01,  2.759296e-01,  7.192576e-02, -6.352506e-01},
  { 4.187805e-01, -4.137701e-01,  8.083422e-01,  2.767885e-01,  2.352503e-02, -5.552396e-01},
  { 9.773698e-01,  1.730182e-01, -1.217088e-01, -2.569376e-01,  1.729835e-02, -5.790385e-01},
  { 5.829028e-03,  3.176723e-01,  9.481826e-01,  1.776704e-01,  5.710412e-02, -5.423941e-01},
  {-3.433924e-01,  5.007270e-01,  7.945779e-01,  1.208883e-01,  4.506081e-02, -5.505924e-01},
  {-7.656050e-01, -3.133410e-01, -5.618420e-01,  4.944713e-02,  1.102336e-02, -6.299358e-01},
  { 8.074254e-01, -2.584092e-01, -5.303666e-01, -1.523320e-01,  1.972276e-02, -6.306071e-01},
  {-7.780924e-01, -4.106026e-01,  4.753711e-01, -2.546087e-01,  1.199324e-02, -6.192738e-01},
  {-7.697723e-01, -2.354309e-01, -5.933151e-01,  9.517200e-02,  8.703577e-03, -6.988143e-01},
  { 9.719304e-01, -2.134018e-01,  9.904965e-02, -1.704945e-01,  1.731829e-02, -6.737930e-01},
  { 9.384847e-01,  3.430884e-01,  3.920253e-02,  4.565420e-02,  4.286505e-02, -7.307991e-01},
  {-5.839304e-01, -8.118013e-01,  2.004887e-03, -4.034366e-01, -6.764203e-03, -7.113768e-01},
  { 9.347914e-01,  3.203432e-01, -1.534441e-01,  4.104439e-02,  4.304941e-02, -7.584975e-01},
  { 7.354224e-01,  2.747722e-01, -6.193981e-01,  3.351985e-02,  3.358700e-02, -7.756371e-01},
  {-4.877458e-01, -6.783123e-01, -5.495421e-01, -3.885080e-01,  1.065484e-03, -7.727494e-01},
  {-1.315266e-02, -5.871812e-01,  8.093487e-01,  4.236916e-01, -2.373775e-02,  8.875803e-01},
  {-5.401545e-01,  9.262036e-02,  8.364536e-01,  1.037221e-01,  3.568631e-02,  8.876361e-01},
  {-1.758630e-01,  8.661306e-01,  4.678570e-01,  1.628865e-02,  6.294219e-02,  6.990831e-01},
  { 9.137608e-01, -3.200963e-01, -2.501588e-01,  5.105335e-01,  5.230292e-02,  6.010813e-01},
  {-2.541263e-01,  9.666636e-01,  3.132517e-02,  1.568397e-02,  8.478482e-02,  6.043314e-01},
  {-1.144567e-01,  9.857734e-01,  1.230877e-01,  1.298234e-01,  6.409826e-02,  5.611752e-01},
  { 7.422978e-01,  5.262875e-01, -4.147474e-01,  3.247859e-01,  5.001255e-02,  4.989113e-01},
  {-7.566606e-01,  4.813681e-01, -4.424356e-01,  9.588346e-02,  5.232156e-02,  4.441267e-01},
  { 6.879017e-01, -6.140651e-01,  3.869306e-01,  4.711050e-01,  3.114822e-02,  4.416752e-01},
  {-8.070037e-01, -5.905138e-01,  6.204000e-03, -4.350274e-01,  2.528194e-02,  3.976863e-01},
  {-6.933306e-01, -7.154323e-01, -8.630995e-02, -4.083166e-01,  1.004140e-02,  3.553248e-01},
  {-8.998168e-02, -9.895303e-01, -1.128413e-01, -2.998889e-01, -6.954293e-03,  3.002353e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.183611e-01,  4.657666e-02,  2.488656e-01},
  {-1.703860e-01, -5.692044e-02, -9.837320e-01,  2.883626e-01,  4.342011e-02,  1.838993e-01},
  { 8.142213e-01,  4.919425e-02,  5.784665e-01,  2.689212e-01,  5.207885e-02,  1.841137e-01},
  {-5.760615e-01, -8.078653e-01, -1.245261e-01, -1.764402e-01,  4.643483e-02,  1.851206e-01},
  {-5.398796e-01,  3.123101e-01,  7.816601e-01, -2.216414e-01,  4.763650e-02,  1.461626e-01},
  {-8.588091e-01,  5.093685e-01,  5.468631e-02, -5.345694e-01,  4.611151e-02,  4.505964e-02},
  { 7.524065e-01, -6.296270e-01,  1.935311e-01, -1.420251e-01,  3.716411e-02,  2.267498e-02},
  {-1.771690e-02, -3.720579e-01, -9.280404e-01, -3.827612e-01,  4.332305e-02, -3.163345e-02},
  { 7.013443e-01, -1.859704e-01,  6.881361e-01,  4.521022e-01,  4.956398e-02,  2.001162e-02},
  {-3.977176e-01,  3.436446e-01,  8.507227e-01, -5.364089e-02,  4.818856e-02, -1.094272e-02},
  { 9.742708e-01,  2.442911e-02,  2.240526e-01,  5.539165e-01,  2.931509e-02, -4.850081e-02},
  {-3.985575e-01,  8.391247e-01,  3.701644e-01, -4.994984e-01,  9.210668e-02, -9.473984e-02},
  {-8.054425e-01, -5.602089e-01, -1.934640e-01, -3.920224e-02,  3.872633e-02, -1.543902e-01},
  { 3.758750e-01,  5.614356e-01,  7.372300e-01, -1.819238e-01,  4.629510e-02, -9.458768e-02},
  {-8.050295e-01, -1.692201e-01, -5.685877e-01, -2.834988e-01,  3.805412e-02, -2.001246e-01},
  {-8.164966e-01,  4.082483e-01,  4.082483e-01, -2.795199e-01,  3.953287e-02, -2.060196e-01},
  {-8.164966e-01,  4.082483e-01,  4.082483e-01, -2.779317e-01,  4.177744e-02, -2.110450e-01},
  { 7.813757e-01,  2.683689e-01, -5.634095e-01, -1.939729e-01,  6.732909e-02, -2.187509e-01},
  {-2.172358e-01, -6.477824e-01, -7.301962e-01, -4.212851e-01,  4.417976e-02, -3.226444e-01},
  { 2.070165e-01,  3.312184e-01,  9.205642e-01, -8.396985e-02,  5.837528e-02, -3.296634e-01},
  {-6.279812e-01, -3.276433e-01, -7.058963e-01, -2.796569e-01,  3.926047e-02, -3.983832e-01},
  { 5.706474e-01,  2.414988e-01, -7.848821e-01,  6.175862e-02,  3.662617e-02, -4.377352e-01},
  {-8.398314e-01, -4.426960e-01, -3.141713e-01, -1.930130e-01,  4.833494e-02, -4.354735e-01},
  { 9.944979e-01,  3.660997e-02, -9.815076e-02,  4.815134e-01,  6.449857e-02, -4.426244e-01},
  { 6.120206e-01, -4.351293e-01, -6.603736e-01, -2.563475e-02,  3.406222e-02, -4.686561e-01},
  {-1.947665e-01,  8.091724e-01, -5.543519e-01, -3.719033e-01,  5.603606e-02, -5.252948e-01},
  { 9.152298e-01, -1.841369e-01,  3.583966e-01, -4.711411e-02,  4.697284e-02, -5.166882e-01},
  {-3.306324e-01,  9.088665e-02, -9.393731e-01, -3.412777e-01,  5.427554e-02, -5.476961e-01},
  {-1.323230e-01,  7.121181e-01, -6.894769e-01, -2.957476e-01,  4.523826e-02, -5.676110e-01},
  { 9.716846e-01,  1.743152e-01,  1.595091e-01,  5.016528e-01,  9.154813e-02, -6.022291e-01},
  { 6.037759e-03,  8.779483e-01, -4.787172e-01,  4.599068e-01,  1.297704e-01, -6.597171e-01},
  {-3.287361e-01,  8.630767e-01, -3.834464e-01,  3.745010e-01,  1.224705e-01, -6.682637e-01},
  {-3.726123e-01,  9.174335e-01,  1.395556e-01,  3.327991e-01,  1.103538e-01, -6.541369e-01},
  {-5.845491e-01,  8.112599e-01,  1.263452e-02,  2.981841e-01,  9.789040e-02, -6.332340e-01},
  { 8.728715e-01,  4.364358e-01,  2.182179e-01, -2.597010e-01,  2.398582e-02, -5.769650e-01},
  {-9.008231e-01,  5.829753e-02, -4.302548e-01, -1.024898e-01,  3.392568e-02, -6.185299e-01},
  {-4.488644e-01,  5.936357e-02, -8.916258e-01,  1.307258e-01,  3.963668e-02, -7.246205e-01},
  {-4.087751e-01, -6.169345e-01,  6.725287e-01, -3.662415e-01,  1.609723e-02, -6.454337e-01},
  {-5.752190e-01, -5.429547e-01,  6.118197e-01, -4.160188e-01,  2.457890e-02, -6.513100e-01},
  {-9.783079e-01, -1.835437e-01, -9.604805e-02, -4.307507e-01,  2.867131e-02, -6.838760e-01},
  {-8.375573e-01,  2.158036e-01, -5.019230e-01, -4.019370e-01,  2.979484e-02, -7.477591e-01},
  {-1.952242e-01,  6.997280e-01, -6.872177e-01, -8.318637e-03,  5.245766e-02, -7.514201e-01},
  {-6.829200e-02, -2.970929e-01, -9.524033e-01, -2.022958e-01,  2.815959e-02, -7.751663e-01},
  {-7.316849e-01,  3.663518e-01, -5.748248e-01, -3.822938e-01,  4.615190e-02, -7.762086e-01},
  { 5.406702e-01, -8.635109e-02,  8.367910e-01,  4.514863e-01,  3.040064e-02,  9.037151e-01},
  {-5.064647e-01, -5.298919e-01,  6.802265e-01,  3.935553e-01,  1.530560e-02,  9.017368e-01},
  {-6.824966e-01,  1.811626e-01,  7.080808e-01,  6.913968e-02,  7.466079e-02,  8.582172e-01},
  {-6.736994e-01, -7.358872e-01,  6.781671e-02,  3.697267e-01,  2.517361e-02,  7.720993e-01},
  { 1.709593e-02,  6.857844e-01,  7.276039e-01,  3.352533e-01,  4.581533e-02,  7.406725e-01},
  {-2.709902e-01, -9.038596e-01,  3.310623e-01,  3.083663e-01,  4.772542e-02,  7.261463e-01},
  {-8.030859e-01,  4.195602e-01, -4.231102e-01,  1.594379e-01,  7.523312e-02,  6.452891e-01},
  { 9.338072e-01,  2.127288e-02,  3.571437e-01,  5.136567e-01,  1.044880e-01,  6.509738e-01},
  { 3.348793e-01,  1.871537e-01, -9.234876e-01,  3.725880e-01,  8.125979e-02,  5.376241e-01},
  {-1.689295e-01,  6.611754e-01,  7.309651e-01,  1.304696e-01,  8.607784e-02,  5.166593e-01},
  {-4.885257e-01,  1.825776e-01,  8.532339e-01, -3.200195e-01,  7.260783e-02,  5.770187e-01},
  { 9.246385e-01, -3.552616e-01, -1.372328e-01,  3.253650e-01,  6.282221e-02,  4.884094e-01},
  {-5.652139e-01, -6.476165e-01,  5.110050e-01, -3.680210e-01,  2.396084e-02,  5.321199e-01},
  {-3.422723e-01, -8.714262e-01,  3.513774e-01, -3.800362e-01,  2.607446e-04,  4.595955e-01},
  {-2.649524e-01, -8.552097e-01,  4.454398e-01,  3.474561e-01,  5.769845e-02,  4.579055e-01},
  { 2.474109e-01, -8.113903e-01,  5.295598e-01, -1.557520e-02,  1.963499e-02,  4.688832e-01},
  {-1.881649e-01, -9.422281e-01,  2.771282e-01, -3.691371e-01, -7.969627e-03,  4.477029e-01},
  { 7.092937e-02, -9.953216e-01,  6.560491e-02, -3.527488e-01, -1.345269e-02,  4.272408e-01},
  { 6.741298e-01, -4.430086e-01,  5.910097e-01,  4.903625e-01,  6.825822e-02,  4.566745e-01},
  { 2.438860e-01, -9.608044e-01,  1.318122e-01, -2.710304e-01,  3.873646e-02,  4.080923e-01},
  { 2.026897e-01, -9.636639e-01,  1.739789e-01, -3.158840e-01, -3.024389e-03,  3.825564e-01},
  {-8.606576e-01,  5.066156e-01, -5.107971e-02, -4.126405e-01,  7.108949e-02,  3.859059e-01},
  {-3.128778e-01, -8.145357e-01, -4.885069e-01, -1.586760e-01,  3.967196e-02,  2.072426e-01},
  {-5.512927e-01,  3.593878e-01, -7.529387e-01,  4.647904e-01,  7.330044e-02,  1.111981e-01},
  {-5.487015e-01,  7.178062e-01,  4.285801e-01, -4.522334e-01,  9.830303e-02,  8.378661e-02},
  {-2.129606e-01,  5.300251e-01,  8.208052e-01, -2.875425e-01,  8.550719e-02,  6.029323e-02},
  {-8.749547e-01,  2.802998e-01,  3.948244e-01, -3.497027e-03,  6.570597e-02, -2.234920e-03},
  {-1.778420e-01, -2.342416e-01, -9.557735e-01, -2.972165e-01,  5.277502e-02, -2.274659e-02},
  {-9.661435e-01,  5.972612e-03,  2.579364e-01, -1.395083e-01,  4.864131e-02, -7.512878e-02},
  {-6.385201e-01, -4.914885e-01, -5.922254e-01, -1.069797e-01,  6.232677e-02, -1.566207e-01},
  {-4.644910e-01, -4.418184e-01, -7.674924e-01, -9.832303e-02,  6.685683e-02, -1.652992e-01},
  {-8.874295e-01, -2.942602e-01, -3.547956e-01, -3.848911e-01,  4.976664e-02, -1.361121e-01},
  {-8.624726e-01, -3.483175e-02, -5.049037e-01, -3.593935e-02,  8.881307e-02, -1.982220e-01},
  {-2.823695e-01,  7.917267e-01,  5.416976e-01, -4.457026e-01,  1.252234e-01, -1.719325e-01},
  {-3.005439e-01,  9.417751e-01,  1.507749e-01, -2.323854e-01,  6.936045e-02, -3.033942e-01},
  {-2.201198e-01,  6.945800e-01,  6.849131e-01, -2.976143e-01,  7.388026e-02, -2.941477e-01},
  {-7.159094e-01, -5.690004e-01, -4.046137e-01, -4.619606e-01,  6.633781e-02, -3.130285e-01},
  { 7.662457e-01, -1.138232e-01, -6.323858e-01,  6.174640e-02,  5.735469e-02, -4.306754e-01},
  {-1.019528e-01,  3.399009e-01,  9.349187e-01, -4.545128e-01,  1.148444e-01, -3.862495e-01},
  {-2.997423e-01,  8.119916e-01, -5.008235e-01, -4.525004e-01,  1.364655e-01, -4.558019e-01},
  {-8.346611e-01,  5.496421e-01,  3.513224e-02,  2.975015e-01,  8.861355e-02, -5.597257e-01},
  { 3.472405e-02,  9.182727e-01, -3.944230e-01,  4.042133e-01,  1.335128e-01, -6.469648e-01},
  { 6.019533e-01, -2.080972e-01,  7.709395e-01,  2.818731e-01,  3.772151e-02, -5.489173e-01},
  {-2.978044e-01, -4.159658e-01, -8.592351e-01, -2.304487e-03,  5.994577e-02, -5.867012e-01},
  { 8.644683e-02,  6.119067e-01, -7.861915e-01, -2.609034e-01,  3.348478e-02, -5.878754e-01},
  { 4.797128e-01, -4.380983e-01, -7.602273e-01,  2.303908e-01,  5.420406e-02, -7.288012e-01},
  {-5.773503e-01,  5.773503e-01,  5.773503e-01, -3.197565e-01,  5.720821e-02, -7.199461e-01},
  {-5.773503e-01,  5.773503e-01,  5.773503e-01, -3.263187e-01,  6.185405e-02, -7.273635e-01},
  {-4.082483e-01,  4.082483e-01,  8.164966e-01, -3.057798e-01,  6.471121e-02, -7.147349e-01},
  {-3.953872e-01,  8.717570e-01, -2.893247e-01, -3.524360e-01,  5.986205e-02, -7.236631e-01},
  {-6.442373e-02,  8.988423e-01,  4.335112e-01,  3.963457e-01,  9.019584e-02,  6.780361e-01},
  { 9.956297e-01, -8.239042e-02, -4.396922e-02,  3.820285e-01,  8.658609e-02,  6.829400e-01},
  { 5.375382e-01,  8.195987e-01,  1.982692e-01,  5.268655e-01,  1.267315e-01,  6.174192e-01},
  { 6.099687e-01,  3.890433e-01, -6.903503e-01,  4.817361e-01,  1.213484e-01,  5.396355e-01},
  {-8.319909e-01,  5.166008e-01,  2.022737e-01,  1.748474e-01,  7.460310e-02,  5.467688e-01},
  { 2.903512e-01, -9.518703e-01,  9.817856e-02,  1.601191e-01,  7.779493e-02,  5.302544e-01},
  {-7.556623e-01,  1.245318e-01,  6.430134e-01, -3.805172e-01,  6.794080e-02,  5.303023e-01},
  { 4.712954e-01, -1.630914e-01,  8.667652e-01,  3.350715e-01,  7.884602e-02,  4.861467e-01},
  {-9.119436e-01, -1.737898e-01,  3.716934e-01, -4.050459e-01,  3.443577e-02,  4.876250e-01},
  {-4.920428e-01,  2.493428e-01,  8.340996e-01, -4.127036e-01,  7.710858e-02,  3.754160e-01},
  {-2.676100e-01, -7.896045e-01, -5.521863e-01, -4.346854e-01,  4.628194e-02,  2.819134e-01},
  {-3.310514e-01,  1.984073e-01,  9.225181e-01, -2.650588e-01,  4.776091e-02,  1.111579e-01},
  { 8.015212e-01, -2.734469e-01,  5.317806e-01,  3.490981e-01,  7.026734e-02,  1.014831e-01},
  {-5.552258e-01,  7.984510e-02, -8.278581e-01, -4.759125e-01,  9.925912e-02, -3.770696e-02},
  { 5.155337e-01, -4.634728e-01, -7.207065e-01, -1.896724e-01,  6.642427e-02, -6.702343e-02},
  { 7.749446e-01,  3.835057e-01,  5.023785e-01,  5.091511e-01,  8.029005e-02, -4.267704e-02},
  {-5.951299e-01,  2.267303e-02,  8.033096e-01, -3.796155e-01,  7.970091e-02, -7.038218e-02},
  { 9.192211e-01,  3.510338e-01, -1.783472e-01,  5.348470e-01,  8.638343e-02, -2.283799e-01},
  {-1.704537e-01,  9.289079e-01,  3.287487e-01, -4.465734e-01,  1.534002e-01, -1.967179e-01},
  { 7.728450e-01,  2.601513e-01,  5.788193e-01, -1.896397e-01,  1.021262e-01, -2.170438e-01},
  {-7.978076e-01,  5.487785e-01,  2.496902e-01, -4.812723e-01,  1.296390e-01, -2.377641e-01},
  { 4.857323e-01,  4.060808e-01,  7.740558e-01, -3.305407e-01,  9.680741e-02, -2.843214e-01},
  {-9.816318e-01,  1.626581e-01, -9.970535e-02, -4.754801e-01,  1.044368e-01, -2.809468e-01},
  {-8.658612e-01,  1.533561e-01, -4.761999e-01, -4.679919e-01,  1.069591e-01, -3.266656e-01},
  {-4.571851e-01,  8.642465e-01,  2.099041e-01, -2.113163e-01,  8.651753e-02, -3.240612e-01},
  { 4.249545e-01, -5.244731e-01, -7.377952e-01,  7.219997e-02,  6.995413e-02, -4.282310e-01},
  {-3.827218e-01,  5.969976e-01,  7.050660e-01, -4.676896e-01,  1.294865e-01, -3.943357e-01},
  { 2.468174e-01,  7.762939e-01,  5.800421e-01, -4.004242e-01,  1.434751e-01, -4.260477e-01},
  {-7.710021e-01,  6.324688e-01,  7.442407e-02, -4.799510e-01,  1.279344e-01, -4.113137e-01},
  {-8.584772e-01,  5.109291e-01, -4.436559e-02,  3.425066e-01,  8.496941e-02, -5.061807e-01},
  { 1.632080e-01,  4.670505e-01,  8.690379e-01, -2.974986e-01,  8.545844e-02, -4.851255e-01},
  { 8.620960e-01,  3.816798e-01,  3.333335e-01,  4.646698e-01,  9.845839e-02, -5.468353e-01},
  {-4.935150e-01,  8.696717e-01, -1.068695e-02,  3.320538e-01,  1.142376e-01, -5.433046e-01},
  { 6.488887e-01,  6.943438e-01,  3.111753e-01,  4.872903e-01,  1.431897e-01, -5.714388e-01},
  { 6.971539e-01,  6.696452e-01, -2.560308e-01,  4.884956e-01,  1.476639e-01, -5.962793e-01},
  { 1.018668e-02, -4.308313e-01, -9.023750e-01, -5.701777e-04,  7.232495e-02, -5.925280e-01},
  {-7.461703e-01, -2.111772e-01,  6.313748e-01, -4.061119e-01,  8.163694e-02, -6.269941e-01},
  { 8.830674e-01, -4.459172e-01, -1.461157e-01, -1.507051e-01,  6.562864e-02, -6.923703e-01},
  {-5.123742e-01,  6.751702e-01, -5.306767e-01, -2.598208e-01,  8.278617e-02, -6.804583e-01},
  {-9.027011e-01,  2.078912e-01,  3.767120e-01, -4.264679e-01,  7.650055e-02, -6.441897e-01},
  {-5.742385e-01,  2.947107e-01,  7.638035e-01, -2.972572e-01,  9.102100e-02, -7.390850e-01},
  {-5.922953e-01,  8.047389e-01,  3.976857e-02, -3.522001e-01,  8.986262e-02, -7.802914e-01},
  {-5.258569e-01,  2.480961e-01,  8.135865e-01,  2.337513e-01,  9.078509e-02,  8.696750e-01},
  { 2.572538e-01, -9.935316e-02,  9.612229e-01,  2.278126e-01,  8.680469e-02,  8.680997e-01},
  { 6.308885e-01,  7.758731e-01,  7.875808e-04,  4.163736e-01,  1.035897e-01,  7.419105e-01},
  { 9.355375e-01,  3.508282e-01,  4.110086e-02,  3.710250e-01,  1.030761e-01,  6.595826e-01},
  {-8.786871e-01,  4.594853e-01, -1.295464e-01,  1.916310e-01,  1.085695e-01,  5.963270e-01},
  { 8.793682e-01,  2.947880e-01, -3.739138e-01,  5.229629e-01,  1.340770e-01,  5.881668e-01},
  { 3.361135e-01,  6.170266e-01, -7.115518e-01,  4.480873e-01,  1.440315e-01,  5.541065e-01},
  { 4.882274e-01, -6.120957e-01,  6.220715e-01, -2.204633e-02,  4.813183e-02,  5.279768e-01},
  { 1.220975e-01,  1.359913e-01,  9.831575e-01,  3.812695e-01,  1.103422e-01,  4.993300e-01},
  { 8.411769e-01,  4.968864e-02,  5.384723e-01,  4.923878e-01,  9.609109e-02,  4.669492e-01},
  { 2.067169e-01,  5.800353e-02,  9.766800e-01,  4.599852e-01,  1.094008e-01,  4.858794e-01},
  { 2.895819e-01, -3.409054e-01,  8.943857e-01,  6.014766e-02,  8.472669e-02,  4.440793e-01},
  { 9.648032e-01,  2.331546e-01, -1.216293e-01,  4.938302e-01,  1.228181e-01,  4.159933e-01},
  {-8.502305e-01,  4.867727e-01, -2.004007e-01, -3.326041e-01,  9.274324e-02,  3.604860e-01},
  {-9.128802e-01, -2.945375e-01,  2.826612e-01, -4.609316e-01,  7.979880e-02,  3.186092e-01},
  { 6.087278e-01, -5.438058e-01, -5.776901e-01, -1.173318e-01,  5.619953e-02, -1.139771e-02},
  {-7.351901e-02,  3.826365e-01,  9.209691e-01, -4.236981e-01,  1.342552e-01,  6.251600e-02},
  { 6.163450e-01,  3.232579e-01,  7.180691e-01,  4.468390e-01,  9.610087e-02,  2.402831e-02},
  {-7.789401e-01,  1.459479e-02,  6.269284e-01, -8.502384e-02,  1.214636e-01, -8.057257e-02},
  {-1.533310e-01,  1.445259e-01,  9.775489e-01, -3.900681e-01,  9.124138e-02, -7.475200e-02},
  { 3.085842e-01,  4.524418e-01,  8.367032e-01, -3.009554e-01,  1.171958e-01, -1.340534e-01},
  {-9.594439e-01, -2.496390e-01, -1.309499e-01, -4.205341e-01,  1.055427e-01, -1.061511e-01},
  { 4.252985e-01,  4.824255e-01,  7.657589e-01, -2.732427e-01,  1.158305e-01, -1.397498e-01},
  { 3.485953e-01,  4.729282e-01,  8.092096e-01, -3.444986e-01,  1.312858e-01, -2.863874e-01},
  { 4.371714e-01,  2.724099e-01,  8.571312e-01, -1.939904e-01,  9.694682e-02, -3.277131e-01},
  {-4.391661e-01, -3.867878e-02, -8.975729e-01, -4.196147e-01,  1.322283e-01, -3.622088e-01},
  {-8.786604e-01, -4.491985e-01,  1.617919e-01, -2.655780e-01,  1.163150e-01, -3.882621e-01},
  {-2.616882e-02,  1.844040e-01, -9.825020e-01,  2.302990e-01,  1.027953e-01, -3.972925e-01},
  { 4.044927e-01, -3.248921e-01, -8.548864e-01,  1.088311e-01,  8.634598e-02, -4.310913e-01},
  { 6.852071e-01, -5.791631e-01, -4.416575e-01,  7.379915e-02,  7.805622e-02, -4.706852e-01},
  { 4.529850e-01,  8.851576e-01,  1.063043e-01,  4.515786e-01,  1.051726e-01, -5.247108e-01},
  {-3.414532e-01,  8.977966e-01, -2.781565e-01,  3.537906e-01,  1.236721e-01, -5.453766e-01},
  {-9.480569e-01,  2.426092e-01,  2.057399e-01, -3.996622e-01,  1.228572e-01, -4.926102e-01},
  { 5.846067e-01,  4.865112e-01,  6.492626e-01,  4.519057e-01,  1.553351e-01, -5.411354e-01},
  {-3.407451e-01,  9.313382e-01, -1.284598e-01,  4.432663e-01,  1.478068e-01, -5.833548e-01},
  {-1.130382e-01,  1.024041e-01,  9.882994e-01, -2.654275e-01,  1.202140e-01, -5.111282e-01},
  {-3.254255e-01,  8.380390e-01, -4.379371e-01,  3.432425e-01,  7.929534e-02, -5.887290e-01},
  {-2.238532e-01, -4.970712e-01, -8.383376e-01, -3.070921e-01,  7.017706e-02, -5.662528e-01},
  { 2.243345e-01,  2.766185e-01,  9.344283e-01,  1.000150e-01,  1.171508e-01, -5.887829e-01},
  { 2.197699e-01, -3.991904e-01, -8.901394e-01,  4.894135e-03,  8.946541e-02, -6.015304e-01},
  {-1.956495e-01,  5.976400e-01,  7.775267e-01,  1.148277e-01,  1.112549e-01, -5.670684e-01},
  { 1.618776e-01, -7.190001e-01, -6.758953e-01, -1.109960e-01,  7.133149e-02, -6.454558e-01},
  {-5.368558e-01,  3.035616e-01,  7.871698e-01, -2.463076e-01,  1.020297e-01, -7.027340e-01},
  {-3.804965e-01,  3.903916e-01, -8.383417e-01, -3.727989e-01,  1.156092e-01, -7.141513e-01},
  {-6.429240e-01,  4.602314e-01, -6.122382e-01, -4.021347e-01,  1.094400e-01, -7.050216e-01},
  {-5.064890e-01, -1.949296e-01,  8.399234e-01, -3.486679e-01,  1.012709e-01, -7.677077e-01},
  {-7.694497e-01, -2.194793e-01, -5.998133e-01, -3.303421e-01,  9.195736e-02, -7.992805e-01},
  { 1.322979e-01,  1.527338e-01,  9.793720e-01,  4.372049e-01,  1.012198e-01,  9.015923e-01},
  {-9.652747e-01, -1.471197e-01, -2.158717e-01,  5.076527e-02,  1.000457e-01,  7.804683e-01},
  { 6.831518e-01,  1.510961e-01, -7.144743e-01,  3.927747e-01,  1.399963e-01,  5.273494e-01},
  {-5.000008e-01, -8.614780e-01,  8.862695e-02, -1.291057e-01,  5.341074e-02,  5.576854e-01},
  {-7.906992e-01, -6.117930e-01,  2.244892e-02, -1.209949e-01,  5.683231e-02,  5.249795e-01},
  { 4.799387e-01, -3.236707e-01, -8.154117e-01,  3.166344e-01,  1.200531e-01,  4.860339e-01},
  {-8.600921e-01,  4.129576e-01,  2.995124e-01, -4.018958e-01,  1.184192e-01,  4.588819e-01},
  { 3.424978e-01,  5.239410e-01,  7.798597e-01, -1.891181e-01,  1.292550e-01,  4.541459e-01},
  {-6.622354e-01,  6.220662e-01, -4.177055e-01, -2.942423e-01,  1.201936e-01,  3.584196e-01},
  {-3.947265e-01, -6.962712e-01, -5.994976e-01, -2.462588e-01,  7.663951e-02,  2.080377e-01},
  {-2.441659e-01, -9.276430e-01, -2.825978e-01, -2.851965e-01,  8.406338e-02,  2.194275e-01},
  {-4.372800e-01,  1.212267e-01, -8.911174e-01,  2.818579e-01,  1.238269e-01,  1.988474e-01},
  {-3.568797e-01, -8.376758e-01,  4.134443e-01, -2.363753e-01,  7.594941e-02,  1.557443e-01},
  { 8.047172e-01, -1.576941e-01,  5.723310e-01,  3.611017e-01,  1.092061e-01,  1.061457e-01},
  { 4.712766e-01,  1.090655e-01,  8.752161e-01,  4.019653e-01,  1.109769e-01,  1.872056e-02},
  {-8.309416e-01,  5.562894e-01, -8.835832e-03, -4.872096e-01,  1.502772e-01,  8.915877e-03},
  {-2.530771e-01,  2.832339e-01, -9.250571e-01, -4.283750e-01,  1.669545e-01, -4.382884e-02},
  {-9.665737e-01, -2.351487e-01,  1.021790e-01, -7.534382e-03,  1.224369e-01, -1.687013e-02},
  {-9.363752e-01,  2.378712e-01, -2.581062e-01, -1.144622e-01,  1.550390e-01, -1.761869e-01},
  {-9.382442e-01, -2.435659e-01, -2.457104e-01, -4.207308e-01,  1.318055e-01, -1.251955e-01},
  {-5.824326e-01,  7.262979e-01,  3.650530e-01, -4.354979e-01,  1.656180e-01, -2.693694e-01},
  {-8.029831e-01,  3.516786e-01, -4.811864e-01, -4.504150e-01,  1.613319e-01, -3.387981e-01},
  { 7.663280e-01, -5.400721e-01,  3.479417e-01,  5.215459e-01,  1.342146e-01, -4.184428e-01},
  {-4.902439e-01,  6.298097e-01, -6.024954e-01,  3.053190e-01,  1.306161e-01, -4.609658e-01},
  {-2.288705e-02,  9.994245e-01, -2.503588e-02,  4.250452e-01,  1.186329e-01, -5.106581e-01},
  {-1.624893e-01,  9.269013e-01, -3.383062e-01,  3.994676e-01,  1.351902e-01, -5.464867e-01},
  {-4.472136e-01,  0.000000e+00,  8.944272e-01,  3.873812e-01,  8.422680e-02, -5.663497e-01},
  {-4.472136e-01,  0.000000e+00,  8.944272e-01,  2.974019e-01,  1.164007e-01, -5.512915e-01},
  {-1.243330e-01, -1.862603e-02,  9.920657e-01,  1.010707e-01,  1.327245e-01, -5.898877e-01},
  {-4.240327e-01, -6.634843e-01,  6.164292e-01, -3.481624e-01,  9.022365e-02, -5.909733e-01},
  {-6.932087e-01, -1.959855e-01, -6.935787e-01,  4.789336e-02,  1.165903e-01, -6.303838e-01},
  { 7.873404e-02, -5.449377e-01, -8.347718e-01, -1.168086e-01,  1.045308e-01, -6.734145e-01},
  { 2.780429e-01, -1.949253e-01, -9.405829e-01,  2.094307e-01,  1.104504e-01, -7.652070e-01},
  {-9.529698e-01, -5.169141e-02,  2.986245e-01, -3.540784e-01,  1.157978e-01, -7.741629e-01},
  {-6.034006e-01, -5.285919e-01, -5.970748e-01, -3.439710e-01,  9.677540e-02, -8.243276e-01},
  {-2.793822e-01, -2.498919e-01, -9.270920e-01, -3.239040e-01,  1.045598e-01, -8.273225e-01},
  { 4.545658e-01,  5.981472e-01,  6.599923e-01,  2.171875e-01,  1.316241e-01,  7.638474e-01},
  { 8.991029e-01,  2.083169e-01, -3.849910e-01,  3.668248e-01,  1.121594e-01,  6.776555e-01},
  { 1.588091e-01, -9.530188e-01,  2.579434e-01, -5.863177e-02,  8.015855e-02,  7.149708e-01},
  {-4.718209e-02, -5.089068e-01,  8.595275e-01, -4.583997e-02,  1.025109e-01,  7.412534e-01},
  {-2.247781e-01, -8.424287e-01,  4.896824e-01, -1.433039e-01,  7.789918e-02,  6.795425e-01},
  { 7.905179e-01, -2.205479e-01,  5.713494e-01,  1.862852e-01,  1.277498e-01,  5.492860e-01},
  { 5.679098e-01,  6.603868e-01,  4.912918e-01,  4.814037e-01,  1.308853e-01,  4.629352e-01},
  { 3.081106e-02,  8.246973e-01,  5.647345e-01,  4.069298e-01,  1.432348e-01,  4.750186e-01},
  {-3.189801e-01,  6.192712e-01,  7.174642e-01,  3.885172e-01,  1.472658e-01,  4.680353e-01},
  {-1.988263e-01,  3.729703e-01,  9.062898e-01, -2.992471e-01,  1.408851e-01,  3.407978e-01},
  { 7.278118e-01, -1.252003e-01, -6.742515e-01,  4.797957e-01,  1.422552e-01,  2.803032e-01},
  { 6.224123e-01, -6.428955e-02, -7.800447e-01,  4.192163e-01,  1.298444e-01,  2.707746e-01},
  {-4.093215e-01, -8.869858e-01, -2.138038e-01, -3.450617e-01,  1.039783e-01,  2.161779e-01},
  {-3.834422e-01, -8.928953e-01,  2.360298e-01, -3.491932e-01,  7.575338e-02,  1.604359e-01},
  { 3.078024e-01, -1.424775e-01, -9.407220e-01,  5.110259e-01,  1.395574e-01,  1.162913e-01},
  {-3.911469e-01, -8.470479e-01, -3.598805e-01, -3.639535e-01,  9.099236e-02,  1.071510e-01},
  {-1.984306e-01, -3.265361e-01, -9.241210e-01, -3.253885e-01,  9.789059e-02,  8.460268e-02},
  {-7.293915e-02,  8.727431e-01,  4.827000e-01, -4.093114e-01,  1.864490e-01,  4.830782e-02},
  {-5.762547e-01,  8.116015e-01,  9.609190e-02, -4.529961e-01,  1.839443e-01,  1.944314e-02},
  {-3.987699e-02,  6.249552e-01, -7.796414e-01, -3.369695e-01,  1.364735e-01, -7.654566e-02},
  {-8.290194e-01,  3.810940e-02, -5.579198e-01, -3.199387e-01,  1.377278e-01, -7.419766e-02},
  {-5.956894e-01,  1.836177e-01, -7.819455e-01, -1.046625e-01,  1.661898e-01, -1.925891e-01},
  { 9.900140e-01,  2.211600e-02,  1.392239e-01,  5.008580e-01,  1.233009e-01, -2.645205e-01},
  {-1.874833e-01, -2.487314e-01,  9.502540e-01,  4.936821e-01,  1.213650e-01, -2.664430e-01},
  {-5.294781e-01,  6.850640e-01, -5.003402e-01, -4.229575e-01,  1.755745e-01, -3.535334e-01},
  { 8.073166e-01, -9.459481e-03,  5.900428e-01,  5.292161e-01,  1.605885e-01, -3.891759e-01},
  { 8.394465e-01, -5.067897e-01,  1.961981e-01,  5.198891e-01,  1.467364e-01, -3.961776e-01},
  {-5.013533e-01,  3.563793e-01,  7.884406e-01, -7.997482e-02,  1.489931e-01, -3.456273e-01},
  { 4.880574e-01, -7.111125e-01, -5.060820e-01,  5.698677e-01,  1.331108e-01, -4.538261e-01},
  { 2.707965e-01,  4.727871e-01, -8.385354e-01,  5.493774e-01,  1.337288e-01, -4.744551e-01},
  {-7.885941e-01, -3.228183e-01,  5.233619e-01, -2.245428e-01,  1.104757e-01, -4.801849e-01},
  {-1.514304e-01,  4.346432e-01,  8.877804e-01, -3.663524e-01,  1.656039e-01, -4.718072e-01},
  {-1.402141e-01, -1.254516e-01,  9.821415e-01, -3.791299e-01,  1.673101e-01, -4.754548e-01},
  {-7.522557e-01, -6.437712e-01,  1.402499e-01, -4.409611e-01,  1.073100e-01, -5.549312e-01},
  {-4.887315e-01,  2.423428e-01, -8.381000e-01,  7.018257e-02,  1.265776e-01, -6.859877e-01},
  {-3.176717e-01, -3.502104e-01, -8.811569e-01, -9.777216e-02,  1.126894e-01, -6.802256e-01},
  { 4.133874e-02,  2.445662e-01, -9.687510e-01, -3.237512e-01,  1.509639e-01, -7.227644e-01},
  {-1.972238e-01, -8.479544e-01, -4.920125e-01, -3.420663e-02,  7.827710e-02, -7.920863e-01},
  {-4.332587e-01,  4.324498e-01,  7.907428e-01,  2.821961e-01,  1.698202e-01,  8.763244e-01},
  {-7.140558e-01,  6.926885e-01,  1.015234e-01,  2.583504e-01,  1.838665e-01,  8.346741e-01},
  { 4.220578e-01, -4.876038e-01,  7.642707e-01,  1.136206e-03,  1.079544e-01,  7.299428e-01},
  {-7.472550e-01, -3.879288e-01,  5.395564e-01, -2.105639e-01,  1.011884e-01,  6.231751e-01},
  {-9.317285e-01,  2.183507e-01,  2.901810e-01,  1.158954e-01,  1.276843e-01,  4.760582e-01},
  {-8.624111e-01, -1.248966e-01,  4.905588e-01,  7.779171e-02,  1.324360e-01,  4.584315e-01},
  {-3.667750e-01, -9.912737e-02,  9.250134e-01, -1.099368e-01,  1.146792e-01,  4.539405e-01},
  {-7.011338e-01,  2.193785e-01, -6.784426e-01, -2.610899e-01,  1.686592e-01,  3.575437e-01},
  {-2.237135e-01,  6.075837e-01,  7.620986e-01, -3.991404e-01,  1.823207e-01,  3.457827e-01},
  {-7.340390e-01,  3.215785e-01,  5.981422e-01, -4.575935e-01,  1.566350e-01,  3.310044e-01},
  {-9.420699e-01, -2.714771e-01, -1.969886e-01, -4.793983e-01,  1.267110e-01,  2.277456e-01},
  { 7.327406e-02, -9.638448e-01,  2.561918e-01, -3.633721e-01,  1.104940e-01,  1.926551e-01},
  {-1.515015e-01, -9.883855e-01,  1.189500e-02, -3.820404e-01,  1.046138e-01,  1.764403e-01},
  {-5.807935e-01,  3.092093e-01, -7.530395e-01, -2.568714e-01,  1.473285e-01,  9.569030e-02},
  { 7.711939e-01,  2.315354e-01, -5.930019e-01, -6.354456e-02,  1.425749e-01,  6.049971e-02},
  {-9.233754e-01,  3.792595e-01, -5.949738e-02, -2.505404e-01,  1.488180e-01,  8.125030e-02},
  {-5.815064e-01,  8.134928e-01, -8.932482e-03, -2.872678e-01,  1.708820e-01, -5.243837e-03},
  { 9.921528e-02,  9.825712e-01, -1.571946e-01, -4.206401e-01,  1.988200e-01,  6.770524e-03},
  {-4.969763e-01, -3.278359e-01, -8.034539e-01, -2.850342e-01,  1.295473e-01, -1.173428e-01},
  {-9.343124e-01, -2.599289e-01, -2.439206e-01, -4.251971e-01,  1.719249e-01, -1.580825e-01},
  {-2.477039e-01,  4.394553e-01,  8.634360e-01, -3.926997e-01,  2.178803e-01, -2.851151e-01},
  { 8.834413e-01,  4.351809e-02,  4.665165e-01,  5.531827e-01,  1.624606e-01, -4.094574e-01},
  {-1.363689e-01,  4.454108e-01, -8.848800e-01,  3.667168e-01,  1.673747e-01, -4.240923e-01},
  {-9.759144e-01, -1.582364e-01, -1.501748e-01, -4.559866e-01,  1.316781e-01, -5.545338e-01},
  {-8.445001e-01,  1.511102e-01, -5.137951e-01, -4.020558e-01,  1.542448e-01, -6.433995e-01},
  { 3.405649e-01,  1.698131e-01,  9.247590e-01,  2.850311e-01,  1.455598e-01, -5.511396e-01},
  {-1.767105e-01, -2.898518e-01, -9.406165e-01,  2.065596e-02,  1.586594e-01, -6.165825e-01},
  { 4.933064e-01,  4.267313e-01, -7.579902e-01, -3.059830e-01,  1.922911e-01, -7.013600e-01},
  { 9.789479e-01, -6.229929e-02, -1.943707e-01,  3.091699e-01,  1.432731e-01, -6.615661e-01},
  { 8.288399e-01,  9.857194e-02, -5.507341e-01,  2.892971e-01,  1.393529e-01, -6.863478e-01},
  {-4.995127e-01, -5.112284e-01, -6.993802e-01, -7.351319e-02,  1.426357e-01, -7.082744e-01},
  { 4.803838e-01, -7.947614e-01, -3.709256e-01, -1.086948e-01,  1.393571e-01, -7.147200e-01},
  {-7.318966e-01,  2.844468e-01,  6.192071e-01, -3.190263e-01,  1.692043e-01, -7.512777e-01},
  { 7.388724e-01, -6.584811e-01,  1.430742e-01, -1.026030e-01,  1.005669e-01, -8.214257e-01},
  {-1.247288e-01, -1.640472e-01, -9.785352e-01, -2.721302e-01,  1.626740e-01, -8.385165e-01},
  { 3.770075e-01, -9.001641e-01, -2.181053e-01,  8.311054e-02,  9.300835e-02, -8.026782e-01},
  { 8.749834e-01, -9.514768e-02,  4.747115e-01,  4.979384e-01,  1.820269e-01,  8.521396e-01},
  {-7.544429e-01,  9.659230e-02,  6.492193e-01,  8.000583e-02,  1.719777e-01,  8.222564e-01},
  { 7.426093e-01,  1.355714e-01,  6.558597e-01,  2.079938e-01,  1.701723e-01,  7.613199e-01},
  {-4.861921e-01, -1.252322e-01,  8.648319e-01, -7.974695e-02,  1.332715e-01,  7.450987e-01},
  { 5.661671e-01, -5.653828e-01,  5.998309e-01,  6.673034e-02,  1.297569e-01,  6.893046e-01},
  { 6.942804e-01, -3.159137e-01,  6.466631e-01,  1.044948e-01,  1.361756e-01,  6.600881e-01},
  { 7.765498e-01, -8.542896e-02,  6.242373e-01,  1.316522e-01,  1.333380e-01,  6.270332e-01},
  { 3.545369e-01, -9.312161e-01,  8.449915e-02, -3.639280e-03,  1.346342e-01,  5.591902e-01},
  {-7.319111e-01, -6.757687e-01, -8.742352e-02,  1.259997e-01,  1.229885e-01,  5.149245e-01},
  {-1.995967e-01, -9.784132e-01, -5.356212e-02,  8.120567e-02,  1.447104e-01,  5.105955e-01},
  {-7.133104e-01, -6.629102e-01, -2.274609e-01, -1.170637e-01,  1.341841e-01,  4.757824e-01},
  {-5.015869e-01, -5.559548e-01,  6.628157e-01, -1.265863e-01,  1.364869e-01,  4.555052e-01},
  {-3.150344e-01,  5.252002e-01,  7.905176e-01, -3.455293e-01,  2.085234e-01,  4.917614e-01},
  {-9.007831e-01,  2.164930e-01,  3.764579e-01, -3.737618e-01,  1.981944e-01,  4.808562e-01},
  { 1.066337e-01,  2.976492e-01,  9.487013e-01, -1.908141e-01,  1.535791e-01,  4.369330e-01},
  { 3.219524e-01,  6.288930e-01, -7.077007e-01, -2.565200e-01,  2.021558e-01,  4.502089e-01},
  { 3.219524e-01,  6.288930e-01, -7.077007e-01, -2.032630e-01,  1.605592e-01,  4.374725e-01},
  { 6.316768e-02,  8.825899e-01,  4.658808e-01,  3.633576e-01,  1.535943e-01,  3.987356e-01},
  {-8.644784e-01,  4.584536e-01,  2.061488e-01, -2.439923e-01,  2.093966e-01,  3.410814e-01},
  {-1.204348e-01,  9.328988e-01, -3.394043e-01, -3.857247e-02,  1.770006e-01,  2.925832e-01},
  { 2.479586e-01,  9.411338e-01, -2.297469e-01, -6.322064e-02,  1.757720e-01,  2.855365e-01},
  {-1.696626e-01,  9.036248e-01,  3.932897e-01, -3.472434e-01,  2.152281e-01,  3.274754e-01},
  {-3.993843e-01,  8.146030e-01,  4.206116e-01, -2.588712e-02,  1.768612e-01,  2.677706e-01},
  { 9.800496e-02,  9.951758e-01, -4.482308e-03, -2.262632e-01,  2.029433e-01,  2.451732e-01},
  { 2.187378e-01,  8.744781e-01,  4.329454e-01, -7.153323e-02,  1.784392e-01,  2.486612e-01},
  { 1.781742e-01,  2.943558e-01, -9.389402e-01, -2.414343e-01,  1.789312e-01,  2.481538e-01},
  {-9.078407e-01,  2.788868e-01,  3.131250e-01, -4.821399e-01,  1.604452e-01,  2.573621e-01},
  {-6.997867e-01, -5.463866e-01, -4.601741e-01, -4.414656e-01,  1.132786e-01,  1.482985e-01},
  { 7.676142e-02, -1.026976e-01, -9.917464e-01,  4.953672e-01,  1.673920e-01,  1.069521e-01},
  { 7.733557e-01,  3.232179e-02, -6.331478e-01,  5.000117e-01,  1.778420e-01,  1.059656e-01},
  {-8.257690e-01, -5.493193e-01,  1.278823e-01, -2.504309e-02,  1.618234e-01,  3.015146e-03},
  { 8.756101e-01,  3.869718e-01, -2.890670e-01, -1.230323e-01,  1.543946e-01, -7.068893e-02},
  { 8.790609e-01,  6.629068e-02,  4.720779e-01,  4.013281e-01,  1.660479e-01, -3.175021e-03},
  { 9.591483e-01, -2.665363e-01,  9.483169e-02,  5.056056e-01,  1.573379e-01, -9.602476e-02},
  {-7.398285e-01,  1.776589e-01,  6.489154e-01, -4.145480e-01,  1.834823e-01, -1.063706e-01},
  { 9.520524e-01, -3.057343e-01, -1.107841e-02,  5.012675e-01,  1.742018e-01, -1.554057e-01},
  { 9.633956e-01, -2.300481e-01, -1.376476e-01,  5.072634e-01,  1.668943e-01, -1.976813e-01},
  {-9.646284e-01,  7.017309e-02, -2.541019e-01, -2.622412e-02,  1.708566e-01, -2.807590e-01},
  {-6.009018e-01,  7.431650e-01,  2.943175e-01, -4.080190e-01,  2.209693e-01, -3.072874e-01},
  {-2.257561e-02,  9.993166e-01,  2.926884e-02, -3.668643e-01,  2.287351e-01, -3.052558e-01},
  { 4.839189e-01, -2.670188e-01, -8.333807e-01,  2.121224e-01,  1.772937e-01, -3.983820e-01},
  { 8.427801e-01,  5.368626e-01,  3.873262e-02,  4.068864e-01,  1.798046e-01, -4.170483e-01},
  { 5.593121e-01,  6.634580e-01,  4.969844e-01, -1.527977e-01,  1.597093e-01, -4.137635e-01},
  {-6.884509e-01, -6.778207e-01,  2.580588e-01, -3.154117e-01,  1.475138e-01, -4.062718e-01},
  { 9.058750e-01, -3.267802e-01,  2.694534e-01, -7.839495e-03,  1.598811e-01, -5.423210e-01},
  {-9.480498e-01, -5.865223e-02,  3.126683e-01, -4.493740e-01,  1.650109e-01, -5.188930e-01},
  {-2.937154e-01,  3.770556e-01, -8.783850e-01, -3.369634e-01,  2.019146e-01, -6.982900e-01},
  {-6.227689e-01,  3.541009e-01, -6.976901e-01, -3.630144e-01,  2.115441e-01, -6.824118e-01},
  {-2.035854e-01,  6.130370e-01, -7.633732e-01,  8.471409e-02,  1.495521e-01, -6.878183e-01},
  {-7.976703e-01, -2.553242e-01, -5.463805e-01,  6.241601e-02,  1.646230e-01, -6.704575e-01},
  { 9.650325e-01, -2.345959e-01, -1.169487e-01, -5.450828e-03,  1.485254e-01, -6.684520e-01},
  { 1.297667e-01,  1.525776e-01, -9.797351e-01,  2.296675e-01,  1.673226e-01, -7.598725e-01},
  { 5.348330e-01, -4.219919e-01,  7.320359e-01,  1.450222e-02,  1.274340e-01, -7.274244e-01},
  { 7.587067e-01, -6.185459e-01,  2.043652e-01, -9.663421e-02,  1.524886e-01, -7.688649e-01},
  { 5.893165e-01, -5.656120e-01,  5.768788e-01,  1.113499e-01,  1.252988e-01, -7.709149e-01},
  {-7.494418e-01,  4.264916e-01, -5.064009e-01, -3.275106e-01,  1.603863e-01, -8.174550e-01},
  { 2.150747e-02,  3.805158e-01,  9.245242e-01,  4.104968e-01,  2.199320e-01,  8.828011e-01},
  {-4.207293e-01,  8.420894e-01,  3.374497e-01,  3.168646e-01,  2.198406e-01,  8.506732e-01},
  { 7.005412e-01, -7.119603e-01,  4.852245e-02,  4.984596e-01,  1.517896e-01,  7.624105e-01},
  {-9.934226e-01,  6.852423e-02, -9.173936e-02,  5.665003e-02,  1.838219e-01,  7.673753e-01},
  { 7.500848e-01, -4.499310e-02,  6.598094e-01,  2.175580e-01,  1.982106e-01,  7.373361e-01},
  { 1.933518e-01, -6.491880e-01, -7.356426e-01,  3.532135e-01,  1.760643e-01,  6.358685e-01},
  {-1.638415e-01, -1.012994e-01,  9.812718e-01, -2.355159e-01,  1.581890e-01,  6.458370e-01},
  {-8.485931e-01, -2.239033e-01,  4.793299e-01, -2.551045e-01,  1.696115e-01,  6.328587e-01},
  {-6.795779e-01, -7.064780e-01, -1.976428e-01, -2.535495e-01,  1.584859e-01,  5.745164e-01},
  {-9.452420e-01,  3.122902e-01,  9.482840e-02, -3.924212e-01,  1.989878e-01,  4.419494e-01},
  {-9.776043e-01, -1.233960e-01, -1.704797e-01,  3.309063e-01,  1.764769e-01,  4.188348e-01},
  { 9.848613e-01,  8.443988e-02,  1.513879e-01,  4.886195e-01,  1.988556e-01,  3.893527e-01},
  {-1.451761e-01,  5.828103e-01,  7.995350e-01,  4.228279e-01,  1.834592e-01,  3.842999e-01},
  {-4.545320e-02,  4.943475e-01,  8.680753e-01,  3.893202e-01,  1.723326e-01,  3.742851e-01},
  {-7.931726e-01,  4.674684e-01, -3.903208e-01, -5.089274e-03,  1.968463e-01,  3.109069e-01},
  {-6.506290e-01,  4.986879e-01,  5.727061e-01, -1.447206e-02,  1.883942e-01,  2.724754e-01},
  {-3.592906e-01,  9.102951e-01, -2.056044e-01, -2.108059e-01,  1.764290e-01,  2.370808e-01},
  { 3.043801e-01,  4.096582e-01,  8.599610e-01, -3.763228e-01,  2.061793e-01,  2.577603e-01},
  {-3.785135e-01,  6.430364e-02, -9.233594e-01,  2.965944e-01,  1.918256e-01,  1.823315e-01},
  {-4.625121e-01,  1.747221e-01, -8.692265e-01, -4.466056e-01,  1.867007e-01,  9.571069e-02},
  {-4.009015e-01, -2.683946e-01, -8.759238e-01, -4.183843e-01,  1.725585e-01,  7.854877e-02},
  {-4.415493e-01,  2.458233e-01, -8.629050e-01, -5.977741e-02,  2.269194e-01, -1.722394e-01},
  {-6.756313e-01, -3.138031e-01, -6.671207e-01, -4.051135e-01,  1.961777e-01, -2.076671e-01},
  {-9.815323e-01,  1.887807e-01, -3.092459e-02, -4.416403e-02,  1.941617e-01, -2.653562e-01},
  { 8.641587e-01, -9.603415e-02, -4.939708e-01,  5.037999e-01,  1.984452e-01, -3.798639e-01},
  { 4.538212e-01,  3.957599e-01,  7.983862e-01, -2.512928e-01,  1.933608e-01, -3.291284e-01},
  { 8.091413e-01,  2.033535e-01, -5.513054e-01,  4.899737e-01,  2.040298e-01, -3.940902e-01},
  { 3.236894e-01,  6.145236e-01,  7.194344e-01, -3.174370e-01,  2.366807e-01, -3.168092e-01},
  {-1.521206e-01,  9.451072e-01, -2.891913e-01, -2.644616e-01,  2.148058e-01, -3.622907e-01},
  {-1.393292e-01,  5.170243e-01,  8.445550e-01, -7.618483e-02,  1.949620e-01, -3.764223e-01},
  {-8.241205e-01, -5.473925e-01, -1.455567e-01, -3.598284e-01,  1.805550e-01, -4.069658e-01},
  { 4.945885e-01, -4.375103e-01, -7.509773e-01,  9.575628e-02,  1.826026e-01, -4.770319e-01},
  { 1.131211e-01,  8.861609e-01,  4.493580e-01, -1.554010e-01,  1.875142e-01, -4.679411e-01},
  { 5.127383e-01,  7.820705e-01,  3.542106e-01, -1.813305e-01,  1.925700e-01, -4.713838e-01},
  {-7.829523e-01, -6.195604e-01,  5.595198e-02, -2.997511e-01,  1.974465e-01, -5.158842e-01},
  { 8.434591e-01, -4.728550e-01, -2.549213e-01,  6.784044e-03,  1.781872e-01, -5.561341e-01},
  { 4.432530e-01,  5.162090e-01,  7.328403e-01,  2.909442e-01,  2.194708e-01, -5.568771e-01},
  {-2.308956e-01,  4.220516e-01,  8.766753e-01,  1.815789e-01,  1.783607e-01, -6.214501e-01},
  { 6.468169e-01, -2.718790e-01, -7.125375e-01,  1.268715e-02,  1.792569e-01, -6.177705e-01},
  {-7.938768e-01,  5.924944e-01, -1.367843e-01, -1.274109e-01,  1.910819e-01, -6.224596e-01},
  { 7.651770e-01,  2.217020e-01, -6.044438e-01,  3.104295e-01,  1.890943e-01, -6.627607e-01},
  {-5.141572e-01,  5.024466e-01,  6.951185e-01, -2.542702e-01,  2.366638e-01, -7.300370e-01},
  {-7.458142e-01,  4.924783e-01,  4.485824e-01, -2.998123e-01,  2.163570e-01, -7.633157e-01},
  { 8.729604e-01, -4.861931e-01,  3.945040e-02,  1.474538e-01,  1.436854e-01, -7.784823e-01},
  {-1.876701e-01, -3.484388e-01, -9.183520e-01, -1.113206e-01,  1.542601e-01, -8.679156e-01},
  { 4.640397e-01,  4.554005e-01,  7.597879e-01,  4.657145e-01,  2.405723e-01,  8.604022e-01},
  {-7.472921e-01,  5.479429e-01,  3.759162e-01,  3.768347e-01,  2.327114e-01,  7.732187e-01},
  {-9.967031e-01,  4.954486e-02, -6.425110e-02,  5.970273e-02,  2.092766e-01,  7.535320e-01},
  {-9.218695e-01, -1.674894e-01, -3.494339e-01,  6.927825e-02,  2.141861e-01,  7.296342e-01},
  { 3.569643e-01, -6.192048e-01, -6.994011e-01,  4.860121e-01,  1.613425e-01,  6.667349e-01},
  {-2.479468e-01, -3.493015e-02,  9.681437e-01, -3.707530e-02,  1.920896e-01,  7.585245e-01},
  {-8.743027e-01, -4.123928e-01, -2.559826e-01,  1.804431e-01,  1.913204e-01,  6.228694e-01},
  { 6.312304e-01,  6.442313e-01,  4.318728e-01,  8.876047e-02,  2.077578e-01,  6.380760e-01},
  {-9.038128e-01, -4.174024e-01, -9.432675e-02,  1.839961e-01,  2.034402e-01,  5.351949e-01},
  { 9.646977e-01, -2.502243e-01,  8.213603e-02,  3.158340e-01,  1.845489e-01,  4.486546e-01},
  {-8.771316e-01, -1.220010e-01, -4.644952e-01, -2.862750e-02,  2.105929e-01,  3.802713e-01},
  { 2.089870e-02,  9.944004e-01, -1.035911e-01, -5.057413e-02,  2.087810e-01,  3.696381e-01},
  {-8.345469e-01,  2.756366e-01, -4.770283e-01, -3.669599e-01,  2.297171e-01,  3.725503e-01},
  { 8.902786e-01,  2.564074e-03, -4.554090e-01,  4.847133e-01,  2.109391e-01,  2.882029e-01},
  { 2.401105e-01,  6.163607e-01, -7.499643e-01, -1.762751e-01,  2.453238e-01,  2.605724e-01},
  { 9.360852e-01, -1.726491e-01,  3.064910e-01,  4.399232e-01,  2.132819e-01,  2.534415e-01},
  { 8.299721e-01,  7.269636e-02,  5.530477e-01,  5.201645e-01,  2.051886e-01,  2.291305e-01},
  { 7.159510e-02,  6.742435e-01,  7.350306e-01, -3.404717e-01,  2.188107e-01,  2.316461e-01},
  {-9.795556e-01,  1.707402e-01, -1.063891e-01, -4.796638e-01,  2.051722e-01,  1.415483e-01},
  { 1.002778e-01,  3.240289e-01, -9.407176e-01, -3.690097e-01,  1.940795e-01,  7.535961e-02},
  { 8.498241e-01, -1.835174e-01,  4.940854e-01,  3.379352e-01,  2.101006e-01,  1.497482e-01},
  { 2.094414e-01,  8.461746e-03, -9.777846e-01, -8.284777e-02,  2.003096e-01,  8.556040e-02},
  {-9.833694e-01, -5.433673e-02,  1.732982e-01, -2.392439e-01,  1.881136e-01,  7.583527e-02},
  { 6.878118e-01,  3.904168e-01, -6.119556e-01, -1.508643e-01,  1.946815e-01,  1.868344e-02},
  { 7.605619e-01,  3.904032e-01, -5.187783e-01, -1.686395e-01,  1.972796e-01, -4.760654e-03},
  {-7.338801e-01, -3.082783e-01,  6.052970e-01, -2.984701e-01,  1.810174e-01, -5.122403e-02},
  {-9.182868e-01,  8.778440e-02,  3.860613e-01, -9.452691e-02,  2.235754e-01, -9.460157e-03},
  { 5.989692e-01,  4.107929e-02, -7.997177e-01, -1.606659e-01,  2.080520e-01, -1.272290e-01},
  {-6.312210e-02, -1.894771e-01, -9.798540e-01, -2.623742e-01,  1.798483e-01, -1.312131e-01},
  { 9.992710e-01,  2.805547e-02, -2.589173e-02,  5.054712e-01,  1.976735e-01, -5.750569e-02},
  { 3.534279e-01, -6.640642e-01,  6.588684e-01,  5.367077e-01,  1.754922e-01, -6.623105e-02},
  {-6.980668e-01,  1.519513e-01, -6.997238e-01, -4.726796e-02,  2.398793e-01, -1.751524e-01},
  { 9.913161e-01, -1.095133e-01, -7.279679e-02,  5.195974e-01,  1.946503e-01, -2.994440e-01},
  { 7.843895e-01, -3.420029e-01, -5.174622e-01,  5.094566e-01,  2.441452e-01, -4.110861e-01},
  { 6.705250e-01, -7.076395e-01, -2.228065e-01,  4.981108e-01,  2.055746e-01, -3.988029e-01},
  {-2.702248e-01, -1.051015e-02, -9.627398e-01,  2.523113e-01,  2.205878e-01, -3.953339e-01},
  {-2.119590e-01,  3.793403e-01, -9.006522e-01,  3.483295e-01,  2.315335e-01, -4.218574e-01},
  { 6.221971e-01,  6.817062e-01,  3.848990e-01, -2.396013e-01,  2.482468e-01, -3.858305e-01},
  {-4.959554e-01, -2.024876e-01,  8.444092e-01, -3.675344e-01,  2.075441e-01, -3.939330e-01},
  {-6.292968e-01,  5.372327e-01, -5.615751e-01, -1.699460e-01,  2.147104e-01, -4.868520e-01},
  { 2.620390e-01,  2.532432e-01,  9.312376e-01, -3.306851e-01,  2.194316e-01, -5.292413e-01},
  { 4.186099e-01, -5.277429e-01, -7.390895e-01, -2.201382e-01,  1.792519e-01, -6.365832e-01},
  {-3.740224e-01, -5.999270e-01, -7.072445e-01, -2.708847e-01,  1.965650e-01, -6.396124e-01},
  {-4.192165e-01, -7.637123e-01, -4.909186e-01, -3.985474e-02,  1.865178e-01, -7.897707e-01},
  {-7.186027e-01,  6.795260e-01, -1.478328e-01, -2.831983e-01,  2.385827e-01, -7.870818e-01},
  { 0.000000e+00, -7.071068e-01,  7.071068e-01,  1.486323e-01,  1.669214e-01, -7.808608e-01},
  { 0.000000e+00, -7.071068e-01,  7.071068e-01,  1.491112e-01,  1.822904e-01, -7.918415e-01},
  { 2.219774e-01, -8.659616e-01, -4.481479e-01, -4.438005e-02,  1.509152e-01, -8.632201e-01},
  { 5.055093e-01, -5.316585e-01, -6.795584e-01,  1.236148e-01,  1.663196e-01, -8.367462e-01},
  {-2.036462e-01,  1.476536e-01,  9.678463e-01,  1.070031e-01,  2.178382e-01,  8.339263e-01},
  {-8.151984e-01,  1.313719e-01,  5.640860e-01,  7.279301e-02,  2.206551e-01,  8.112924e-01},
  {-2.083481e-01,  7.630575e-01,  6.118287e-01,  3.316544e-01,  2.182911e-01,  7.061575e-01},
  {-1.052517e-01,  5.332012e-02,  9.930151e-01, -3.816053e-02,  2.088106e-01,  7.585176e-01},
  { 8.780836e-01, -4.468488e-01, -1.711582e-01,  5.179290e-01,  1.796690e-01,  6.833252e-01},
  { 5.271062e-01, -4.176181e-01,  7.401041e-01,  2.413569e-01,  2.257307e-01,  7.253634e-01},
  { 6.670819e-01,  1.695524e-01,  7.254335e-01,  2.293811e-02,  2.062791e-01,  7.308492e-01},
  {-7.946791e-02, -8.498127e-01, -5.210598e-01,  3.573995e-01,  2.104504e-01,  6.087307e-01},
  { 2.853879e-01,  3.206475e-01,  9.031827e-01, -1.646229e-01,  2.423250e-01,  6.241992e-01},
  {-4.049574e-01,  3.851009e-01,  8.292809e-01, -2.279076e-01,  2.358089e-01,  6.336330e-01},
  { 9.889977e-02,  6.553416e-01,  7.488300e-01, -7.852396e-02,  2.352543e-01,  5.728010e-01},
  { 3.661141e-01,  7.271150e-01,  5.807445e-01,  9.456021e-02,  2.217425e-01,  5.338547e-01},
  {-9.663447e-01, -1.484167e-01,  2.101202e-01, -2.855333e-01,  2.267670e-01,  5.506891e-01},
  { 7.629806e-01, -5.528149e-01, -3.350468e-01,  3.232984e-01,  1.905391e-01,  4.522834e-01},
  { 3.460559e-01, -8.469994e-01,  4.035313e-01,  3.280519e-01,  1.874099e-01,  4.272894e-01},
  {-1.487104e-01,  7.165822e-01, -6.814655e-01, -5.563400e-02,  2.245741e-01,  4.191731e-01},
  { 3.710373e-01,  7.189897e-01, -5.876947e-01, -7.972495e-02,  2.289963e-01,  4.192792e-01},
  { 2.809058e-01,  8.519894e-01, -4.418211e-01, -1.148932e-01,  2.595806e-01,  4.259242e-01},
  {-4.029719e-01, -1.603557e-01,  9.010549e-01, -2.509997e-01,  2.360469e-01,  4.428358e-01},
  { 8.939001e-01, -7.525704e-02,  4.419039e-01,  3.597899e-01,  1.942820e-01,  3.748592e-01},
  {-5.213687e-01,  7.059345e-01,  4.794071e-01, -1.558059e-02,  2.285211e-01,  3.515079e-01},
  {-5.140340e-01,  5.366507e-03, -8.577530e-01, -3.280380e-01,  2.571508e-01,  3.482949e-01},
  { 7.852920e-01,  9.060513e-03, -6.190591e-01,  4.811768e-01,  2.282139e-01,  2.818177e-01},
  {-8.853137e-01,  1.788539e-01, -4.292213e-01,  3.309306e-02,  2.237526e-01,  2.857670e-01},
  { 7.569778e-01,  3.335409e-02,  6.525887e-01,  5.041145e-01,  2.221603e-01,  2.435471e-01},
  {-4.040680e-01, -1.899718e-01,  8.947848e-01, -7.518183e-02,  2.084721e-01,  2.412419e-01},
  {-4.625045e-02,  5.305749e-01,  8.463753e-01, -1.715409e-01,  2.126265e-01,  2.252948e-01},
  { 2.935185e-01, -4.137347e-01,  8.617833e-01, -3.466224e-01,  2.280921e-01,  2.346804e-01},
  { 1.092314e-01, -2.521043e-01, -9.615154e-01,  3.448183e-01,  2.250754e-01,  1.466038e-01},
  {-7.847923e-01,  2.631638e-02, -6.191999e-01, -4.654372e-01,  2.353611e-01,  1.182977e-01},
  {-1.334824e-01, -2.275023e-02, -9.907900e-01, -4.459142e-02,  2.123944e-01,  8.012890e-02},
  {-7.182480e-01,  8.618815e-02,  6.904284e-01,  4.588825e-01,  2.056565e-01, -9.811781e-02},
  {-5.143616e-01,  3.242503e-01,  7.939105e-01,  4.973700e-01,  2.195311e-01, -5.548677e-02},
  { 8.800174e-01, -4.749019e-01,  6.121201e-03,  5.619090e-01,  1.978919e-01, -8.232817e-02},
  { 6.312650e-01,  1.588361e-01,  7.591282e-01,  5.516301e-01,  2.194615e-01, -5.527572e-02},
  { 9.848367e-01, -1.666651e-01,  4.816188e-02,  5.612579e-01,  2.224465e-01, -1.059663e-01},
  {-8.353386e-01, -1.608465e-01, -5.256786e-01, -4.306216e-02,  2.551630e-01, -1.825790e-01},
  { 6.736140e-01,  7.273604e-02, -7.354955e-01,  4.922312e-01,  2.907948e-01, -4.594867e-01},
  { 8.334256e-01, -5.421481e-01, -1.071312e-01,  2.535241e-01,  2.176500e-01, -3.996326e-01},
  {-6.760909e-01,  5.522110e-01, -4.878156e-01, -1.525348e-01,  2.231262e-01, -4.825877e-01},
  { 2.954948e-01,  7.145202e-01,  6.341480e-01,  2.876241e-01,  2.319645e-01, -5.832314e-01},
  { 5.633046e-03, -1.562860e-01,  9.876958e-01,  2.149732e-01,  2.308068e-01, -6.273209e-01},
  { 2.301131e-02,  4.592130e-01, -8.880281e-01,  1.161997e-01,  1.835099e-01, -6.450984e-01},
  { 9.743145e-01,  1.620689e-01, -1.563491e-01,  3.070441e-01,  2.279425e-01, -6.257346e-01},
  {-5.515286e-01,  3.959908e-01, -7.341713e-01,  1.529276e-01,  1.948608e-01, -6.601052e-01},
  {-1.270955e-01, -7.069116e-01, -6.957894e-01,  1.871922e-02,  2.140965e-01, -6.609024e-01},
  {-8.955012e-01,  5.428947e-03,  4.450261e-01, -1.215677e-01,  2.379740e-01, -7.550852e-01},
  {-2.928334e-01,  6.579078e-01,  6.938344e-01, -2.255008e-01,  2.692293e-01, -7.382733e-01},
  { 5.443026e-01, -7.575479e-01,  3.603553e-01, -4.666521e-03,  1.873060e-01, -8.141729e-01},
  {-3.688117e-01,  5.707189e-01, -7.336606e-01, -2.185713e-01,  2.767840e-01, -8.486679e-01},
  { 5.622248e-02, -6.403905e-01, -7.659889e-01,  8.433913e-03,  1.687590e-01, -8.548640e-01},
  { 3.408304e-01, -5.411649e-01, -7.687491e-01,  4.561240e-03,  1.910918e-01, -9.050944e-01},
  { 1.766513e-02,  1.535385e-01, -9.879848e-01, -4.532072e-02,  2.095029e-01, -9.090495e-01},
  { 6.620672e-01, -3.110178e-02,  7.487988e-01,  2.995866e-01,  2.326989e-01,  6.986707e-01},
  { 5.129571e-01, -7.673567e-01,  3.847581e-01,  2.794049e-01,  2.347706e-01,  7.144900e-01},
  { 5.196305e-01,  4.262840e-01,  7.404499e-01,  3.268416e-01,  2.434390e-01,  6.726884e-01},
  {-2.107593e-01, -9.771000e-01,  2.925893e-02,  3.421693e-01,  2.233753e-01,  5.437018e-01},
  { 7.074099e-01, -5.857953e-01,  3.954934e-01,  4.979122e-01,  1.893755e-01,  5.414053e-01},
  { 1.379511e-01, -9.445508e-01,  2.979819e-01,  4.627329e-01,  1.751694e-01,  5.447981e-01},
  {-6.061805e-01, -7.788044e-01, -1.612725e-01,  1.565466e-01,  2.312821e-01,  5.197098e-01},
  { 6.435671e-01, -6.909801e-01, -3.291925e-01,  4.989038e-01,  2.021946e-01,  4.764644e-01},
  { 3.335015e-01, -6.932653e-01, -6.388741e-01,  4.714148e-01,  1.929582e-01,  4.674149e-01},
  { 5.779785e-01,  8.001823e-01, -1.601533e-01, -1.538080e-01,  2.797281e-01,  4.353314e-01},
  {-7.966139e-01, -5.933653e-01,  1.154288e-01, -2.650932e-01,  2.534018e-01,  4.549488e-01},
  {-6.416041e-02,  6.645505e-01, -7.444837e-01, -2.091220e-01,  2.835212e-01,  2.827666e-01},
  { 7.708465e-01,  6.828679e-02,  6.333503e-01,  5.095445e-01,  2.399511e-01,  2.407942e-01},
  {-5.166078e-01,  5.637677e-01, -6.444240e-01, -3.442569e-02,  2.363433e-01,  7.059121e-02},
  { 9.984862e-01, -5.446236e-02, -7.697830e-03,  3.399029e-01,  2.475310e-01,  1.401577e-01},
  {-8.804005e-01, -3.665817e-01,  3.008534e-01,  3.388847e-01,  2.489069e-01,  1.299088e-01},
  {-6.311696e-01,  3.978266e-01,  6.658521e-01,  3.476240e-01,  2.393856e-01,  1.438816e-01},
  {-5.232790e-01,  8.465975e-01, -9.722117e-02, -6.204269e-03,  2.418637e-01,  3.668293e-02},
  {-7.791623e-01, -2.260910e-01,  5.846273e-01, -2.686582e-01,  2.172788e-01, -3.280033e-03},
  {-3.469733e-01,  8.654109e-01,  3.614877e-01, -6.306331e-03,  2.461757e-01, -9.130988e-03},
  {-6.841003e-01, -6.419905e-01, -3.462008e-01, -3.482127e-01,  1.836884e-01, -8.448155e-02},
  { 2.406566e-01,  5.849260e-01,  7.745618e-01,  4.655766e-01,  2.154199e-01, -9.767754e-02},
  { 1.018377e-01,  6.734667e-01,  7.321692e-01,  5.294310e-01,  2.572910e-01, -6.756371e-02},
  {-7.322673e-01, -1.161791e-01, -6.710343e-01, -1.242454e-01,  2.889386e-01, -1.575689e-01},
  {-9.935383e-01,  1.076592e-01,  3.593180e-02, -4.310625e-01,  2.542909e-01, -1.663206e-01},
  { 8.606932e-01,  2.138238e-01,  4.620461e-01, -1.614964e-01,  2.409002e-01, -2.589917e-01},
  {-9.789836e-01,  3.494757e-02,  2.009222e-01, -5.823367e-02,  2.310303e-01, -2.659659e-01},
  {-7.365959e-01, -1.074518e-01, -6.677428e-01, -2.036733e-01,  2.304581e-01, -3.181656e-01},
  { 8.653265e-01, -3.425443e-01, -3.658873e-01,  5.076321e-01,  2.089798e-01, -3.809637e-01},
  { 3.336697e-01, -5.697222e-01, -7.510535e-01,  5.022129e-01,  2.871381e-01, -4.512646e-01},
  {-9.864743e-01, -5.083835e-02, -1.558331e-01,  2.521794e-01,  2.367260e-01, -3.997642e-01},
  { 8.669440e-01, -8.196590e-02, -4.916196e-01,  2.486482e-01,  2.377146e-01, -4.049824e-01},
  {-3.642590e-01,  9.053521e-01, -2.182955e-01,  4.307556e-01,  3.322928e-01, -4.598471e-01},
  {-5.578240e-01,  8.229238e-01,  1.078376e-01,  2.661940e-01,  2.451408e-01, -3.914835e-01},
  {-2.578655e-01,  4.776417e-01, -8.398593e-01,  2.524278e-01,  2.399514e-01, -3.848271e-01},
  { 8.672514e-01, -2.608220e-01,  4.240836e-01,  2.448585e-01,  2.348465e-01, -3.859197e-01},
  { 8.283829e-01, -4.876543e-01,  2.756357e-01,  2.557831e-01,  2.211603e-01, -4.035105e-01},
  { 8.130210e-01, -1.142232e-01, -5.709203e-01,  2.220696e-01,  2.404637e-01, -4.497265e-01},
  { 6.505371e-01,  2.776602e-01, -7.068990e-01,  1.931069e-01,  2.485079e-01, -4.941587e-01},
  {-4.152777e-02,  4.097397e-01,  9.112568e-01, -2.936184e-01,  2.864316e-01, -3.885086e-01},
  { 2.621471e-01, -3.178270e-01,  9.111887e-01,  5.788946e-02,  2.392833e-01, -5.851476e-01},
  {-6.806654e-01, -2.963238e-01, -6.699902e-01, -3.296056e-01,  2.725720e-01, -6.400763e-01},
  {-7.107525e-01,  4.881665e-01, -5.064824e-01, -3.817119e-01,  2.687107e-01, -6.277490e-01},
  { 5.311396e-02, -6.450674e-01, -7.622775e-01, -2.361339e-01,  2.072471e-01, -6.670514e-01},
  { 1.938149e-01,  4.734347e-01, -8.592412e-01,  2.259802e-01,  2.459508e-01, -7.418312e-01},
  { 8.255313e-01, -5.126106e-01,  2.360688e-01,  2.060146e-02,  2.262621e-01, -7.044691e-01},
  { 3.929920e-01, -6.645859e-01,  6.355180e-01,  8.449993e-02,  2.338833e-01, -7.834155e-01},
  { 6.505566e-02,  9.970511e-01,  4.070564e-02, -1.869621e-01,  2.971380e-01, -7.981724e-01},
  {-3.897698e-01,  9.200577e-01, -3.966642e-02, -2.188426e-01,  2.948650e-01, -8.073668e-01},
  { 8.650485e-01, -4.148382e-01, -2.821351e-01,  1.590882e-01,  2.472635e-01, -8.457451e-01},
  { 1.262323e-01,  7.538743e-02, -9.891320e-01,  6.728198e-02,  2.126599e-01, -8.813364e-01},
  { 2.807350e-01, -2.590489e-03, -9.597818e-01,  4.233905e-02,  2.141558e-01, -8.821359e-01},
  { 3.038007e-02,  7.322593e-01, -6.803480e-01, -1.003328e-01,  2.759661e-01, -8.720981e-01},
  { 2.981240e-01, -9.816490e-03, -9.544767e-01,  1.174264e-01,  2.412032e-01, -8.671924e-01},
  { 8.527465e-01,  1.974874e-02,  5.219516e-01,  5.389177e-01,  2.511528e-01,  7.677017e-01},
  { 2.076632e-02,  7.677488e-01,  6.404144e-01,  4.624290e-01,  2.797061e-01,  8.214380e-01},
  {-8.280809e-01,  2.204157e-01,  5.154598e-01,  7.504051e-02,  2.693262e-01,  7.919234e-01},
  { 8.059377e-01, -2.978435e-01, -5.116187e-01,  5.246425e-01,  2.209062e-01,  6.516505e-01},
  {-7.380520e-01,  5.043166e-01,  4.482680e-01,  3.765084e-01,  2.631609e-01,  6.893015e-01},
  {-7.619799e-01, -2.953768e-01,  5.763150e-01, -1.034101e-01,  2.341157e-01,  7.107555e-01},
  {-9.009128e-01, -3.376191e-01, -2.727077e-01,  9.173048e-02,  2.569660e-01,  6.199822e-01},
  { 5.250459e-01, -8.216506e-01, -2.218488e-01,  4.407022e-01,  2.088349e-01,  6.100957e-01},
  {-1.320764e-01, -9.610515e-01, -2.427671e-01,  4.116910e-01,  2.100962e-01,  6.010283e-01},
  {-9.341654e-01,  3.073808e-01,  1.812515e-01,  3.708286e-01,  2.234746e-01,  5.484439e-01},
  { 8.441306e-01,  4.452317e-01,  2.986842e-01,  4.068961e-02,  2.554182e-01,  5.870012e-01},
  {-8.545008e-01, -1.687202e-01, -4.912859e-01, -5.000084e-02,  2.649380e-01,  5.554559e-01},
  {-9.341654e-01,  3.073808e-01,  1.812515e-01,  3.635629e-01,  2.169182e-01,  5.221158e-01},
  {-1.172172e-01,  6.890014e-01,  7.152182e-01, -2.118297e-01,  2.870062e-01,  6.000145e-01},
  {-3.791270e-01, -8.686977e-01,  3.187899e-01,  3.583361e-01,  2.077106e-01,  5.107918e-01},
  {-5.749425e-01,  3.764813e-01,  7.264317e-01, -2.789902e-01,  2.900030e-01,  5.664122e-01},
  { 6.347260e-01,  1.646871e-01,  7.549841e-01,  7.206055e-02,  2.617193e-01,  5.150720e-01},
  {-2.674668e-01,  3.891481e-01,  8.814903e-01,  1.079730e-01,  2.641275e-01,  5.155715e-01},
  { 8.447745e-01, -1.560793e-01, -5.118548e-01,  3.717025e-01,  2.406605e-01,  3.974694e-01},
  { 5.804541e-01,  7.924519e-01, -1.873317e-01, -1.610906e-01,  2.975577e-01,  3.695698e-01},
  {-8.839989e-01,  4.617219e-02, -4.652031e-01, -3.648655e-01,  2.916652e-01,  3.791202e-01},
  {-8.633016e-01, -4.117542e-01, -2.918373e-01, -2.396825e-02,  2.441019e-01,  3.373610e-01},
  { 2.172095e-01,  2.393055e-01,  9.463366e-01,  1.131765e-02,  2.558797e-01,  2.627198e-01},
  { 7.600315e-01,  5.012603e-02,  6.479503e-01,  5.019801e-01,  2.580359e-01,  2.429036e-01},
  {-7.584531e-01, -2.977462e-02,  6.510472e-01, -4.558834e-01,  2.433393e-01,  2.874379e-01},
  {-7.059107e-01, -4.015837e-01, -5.834557e-01, -3.018318e-01,  2.377828e-01,  1.179990e-01},
  {-2.317405e-01, -6.455691e-01, -7.276928e-01, -3.205617e-01,  2.530206e-01,  1.299896e-01},
  { 3.079052e-01,  1.098353e-01,  9.450559e-01,  3.731054e-01,  2.767207e-01,  1.279829e-01},
  {-5.882789e-01,  1.777058e-01,  7.888907e-01,  3.291721e-01,  2.661254e-01,  1.182786e-01},
  {-4.854130e-01, -8.062274e-01,  3.381888e-01, -2.691474e-01,  2.256045e-01,  3.593642e-03},
  {-4.495747e-01, -8.606502e-01,  2.390893e-01, -3.736370e-01,  1.942992e-01, -6.271718e-02},
  { 1.885570e-01,  2.278060e-01, -9.552752e-01, -2.130091e-01,  2.837651e-01, -1.175802e-01},
  {-5.952967e-01,  2.825346e-01,  7.521942e-01,  4.727158e-01,  2.453767e-01, -1.164247e-01},
  {-4.905627e-01,  7.841033e-01,  3.801714e-01, -1.219306e-01,  3.126125e-01, -1.264558e-01},
  { 8.630077e-01,  2.158388e-01, -4.567618e-01,  5.204331e-01,  2.952875e-01, -3.294739e-01},
  {-4.712912e-01, -5.613093e-01, -6.803062e-01, -2.542835e-01,  2.476584e-01, -2.886100e-01},
  { 8.487195e-01,  4.870981e-01, -2.059386e-01,  5.080410e-01,  2.941268e-01, -3.585987e-01},
  {-2.291929e-01,  9.733472e-01,  8.121300e-03,  4.249453e-01,  2.870616e-01, -4.007329e-01},
  {-3.624282e-01,  9.001261e-01, -2.416997e-01,  4.046795e-01,  2.783065e-01, -3.978680e-01},
  { 7.016018e-01,  4.959269e-01, -5.116751e-01,  2.317588e-01,  2.666261e-01, -3.992225e-01},
  { 8.381632e-01, -2.319561e-01, -4.936382e-01,  2.551257e-01,  2.492381e-01, -3.906717e-01},
  {-9.211192e-01,  2.827511e-01,  2.675652e-01, -3.299977e-02,  2.633828e-01, -3.789285e-01},
  {-9.264934e-01, -3.533102e-01, -1.295447e-01, -3.698668e-01,  2.996604e-01, -3.858312e-01},
  {-7.636114e-01,  6.874323e-02, -6.420062e-01, -1.435200e-01,  2.517882e-01, -4.732527e-01},
  { 4.341996e-01,  5.477555e-01,  7.151465e-01, -3.109201e-01,  2.972983e-01, -4.676085e-01},
  {-6.572254e-01,  6.379225e-01, -4.013847e-01, -3.453031e-01,  2.780077e-01, -4.604645e-01},
  {-8.778250e-01,  1.289199e-01,  4.613054e-01, -4.019333e-01,  2.682498e-01, -4.890458e-01},
  { 5.840541e-01, -8.063931e-01,  9.279590e-02,  5.092139e-02,  2.457494e-01, -5.723681e-01},
  {-9.560105e-01, -5.259326e-03, -2.932852e-01, -1.017203e-01,  2.563455e-01, -6.018889e-01},
  { 7.902449e-01,  5.990670e-01, -1.289639e-01,  2.957188e-01,  2.560167e-01, -6.377735e-01},
  { 2.016976e-01,  3.044834e-01,  9.309177e-01,  2.623935e-01,  2.520237e-01, -6.234343e-01},
  { 9.830221e-01,  1.793200e-01, -3.888509e-02,  2.930959e-01,  2.612395e-01, -6.409524e-01},
  { 7.278653e-02, -9.776014e-01, -1.974783e-01,  4.751770e-02,  2.435251e-01, -7.057407e-01},
  { 1.808853e-01,  6.859509e-01,  7.048063e-01, -8.350945e-02,  2.616093e-01, -7.533341e-01},
  { 6.645790e-01, -6.365900e-01,  3.912645e-01,  1.223454e-01,  2.466631e-01, -7.854989e-01},
  { 1.075229e-01,  8.109432e-01, -5.751608e-01, -1.783802e-02,  2.507959e-01, -8.499963e-01},
  { 2.844715e-01, -7.847450e-01,  5.506825e-01,  2.315980e-01,  2.292991e-01,  8.310998e-01},
  {-3.385671e-01,  2.967870e-01,  8.929109e-01,  3.495412e-01,  2.680608e-01,  6.577704e-01},
  { 9.805932e-01,  1.397950e-01, -1.374568e-01,  5.213377e-01,  2.451715e-01,  5.323792e-01},
  {-2.829023e-02,  9.862279e-01, -1.629543e-01, -1.356421e-01,  3.197696e-01,  5.309441e-01},
  { 3.978625e-01,  9.075085e-01,  1.346618e-01, -1.968062e-01,  3.409968e-01,  4.956897e-01},
  {-8.844642e-01, -1.114181e-01,  4.531104e-01, -3.657587e-01,  3.038887e-01,  4.144322e-01},
  {-6.860172e-01, -4.442149e-01, -5.762410e-01, -3.503324e-02,  2.597035e-01,  3.281837e-01},
  {-4.473380e-01,  3.383751e-01, -8.278834e-01, -2.785411e-01,  3.089456e-01,  3.358136e-01},
  { 9.437039e-01, -6.824961e-02,  3.236739e-01,  3.706248e-01,  2.610242e-01,  3.598693e-01},
  {-5.760077e-01,  5.989257e-01,  5.563301e-01,  3.636962e-02,  2.789000e-01,  2.594558e-01},
  { 1.131486e-02, -3.776665e-01,  9.258725e-01, -6.571562e-02,  2.592407e-01,  3.046145e-01},
  {-7.446378e-01,  1.610270e-01,  6.477537e-01, -4.507911e-01,  2.713741e-01,  2.960874e-01},
  { 1.149422e-01, -3.630255e-01,  9.246625e-01, -4.012458e-01,  2.527204e-01,  3.040946e-01},
  { 5.286112e-01, -3.498384e-01, -7.734231e-01,  5.071582e-01,  2.609987e-01,  8.988127e-02},
  {-6.083513e-01, -2.249962e-01, -7.611080e-01, -1.843448e-02,  2.661762e-01,  5.290995e-02},
  { 1.567893e-01, -5.406950e-01, -8.264782e-01, -7.823496e-02,  2.621916e-01,  7.212233e-02},
  { 4.479463e-01, -2.870038e-01, -8.467426e-01, -1.366841e-01,  2.656809e-01,  3.717763e-02},
  { 2.337557e-01,  1.667372e-01,  9.578919e-01,  3.668063e-01,  2.942283e-01,  1.280723e-01},
  {-3.084014e-01, -9.377142e-01,  1.599392e-01, -3.201112e-01,  2.389911e-01,  3.263932e-02},
  { 8.517687e-01,  5.751925e-02,  5.207510e-01,  4.185935e-01,  2.884032e-01,  7.355294e-02},
  {-9.156573e-01,  4.013920e-01,  2.135485e-02,  2.629836e-02,  2.781453e-01, -1.028919e-02},
  {-6.137924e-01, -7.614591e-01, -2.084197e-01, -4.256302e-01,  2.416561e-01, -4.656583e-02},
  {-5.932373e-01,  5.453593e-01,  5.921595e-01, -1.672435e-02,  2.859086e-01, -6.980603e-02},
  {-4.972297e-02,  3.954273e-01, -9.171504e-01, -2.511654e-01,  2.887128e-01, -1.221682e-01},
  { 1.390162e-01,  8.118069e-01,  5.671367e-01,  5.199380e-01,  2.937135e-01, -1.282398e-01},
  { 6.684583e-01,  6.407347e-01,  3.776540e-01,  6.010078e-01,  2.951580e-01, -2.022406e-01},
  { 9.802365e-01, -1.726470e-01, -9.658910e-02,  6.073659e-01,  2.904268e-01, -2.347766e-01},
  {-9.505447e-01, -2.382028e-01, -1.993088e-01, -2.579694e-02,  2.851363e-01, -2.321923e-01},
  { 7.837822e-01, -1.178863e-02, -6.209238e-01,  5.903875e-01,  2.892732e-01, -2.649324e-01},
  { 6.831756e-01,  1.738425e-01,  7.092601e-01, -2.084467e-01,  2.803952e-01, -1.927853e-01},
  { 4.332820e-01,  6.938770e-01, -5.751534e-01,  2.187867e-01,  2.825699e-01, -3.870726e-01},
  { 1.339551e-01,  6.260830e-01, -7.681641e-01,  1.919783e-01,  3.066904e-01, -4.447948e-01},
  { 8.616885e-01, -4.606301e-01,  2.128683e-01,  9.368716e-02,  3.276759e-01, -4.500290e-01},
  { 7.877138e-02,  7.655674e-01,  6.385152e-01, -3.528433e-01,  3.061817e-01, -3.998469e-01},
  {-7.927486e-01,  7.695568e-02,  6.046713e-01, -4.166631e-02,  2.890167e-01, -4.236622e-01},
  { 8.787866e-01, -4.119722e-02, -4.754335e-01,  1.290126e-01,  2.833227e-01, -5.181760e-01},
  {-4.832860e-01,  8.025872e-01, -3.496978e-01, -3.305089e-01,  2.931477e-01, -4.551716e-01},
  {-1.658235e-01,  2.607882e-01,  9.510479e-01, -1.359150e-01,  2.655302e-01, -4.998299e-01},
  { 2.431998e-01, -9.010758e-01,  3.590489e-01, -3.646348e-01,  2.870535e-01, -4.400482e-01},
  {-9.598933e-01, -1.657485e-01,  2.261247e-01, -3.954501e-01,  2.888477e-01, -4.657281e-01},
  { 6.667315e-01, -7.218392e-01,  1.855187e-01,  1.062803e-01,  2.609394e-01, -5.672421e-01},
  { 2.392408e-01, -6.071453e-01,  7.577192e-01,  1.964795e-01,  2.849205e-01, -6.074107e-01},
  {-5.115971e-01, -8.446629e-02, -8.550637e-01, -2.789767e-01,  2.594006e-01, -7.014398e-01},
  {-2.300200e-01,  1.081258e-02, -9.731258e-01,  1.296448e-01,  2.554618e-01, -6.341384e-01},
  { 4.741369e-01, -8.759533e-01, -8.888257e-02,  1.015959e-01,  2.137638e-01, -7.022945e-01},
  { 2.748196e-01,  9.592221e-01, -6.608572e-02, -1.377825e-02,  2.598962e-01, -8.241856e-01},
  {-1.508997e-01,  8.679848e-01,  4.731085e-01,  5.375268e-02,  2.542913e-01, -8.335750e-01},
  {-2.947118e-01, -3.098636e-01,  9.039522e-01,  2.206148e-01,  2.738254e-01,  8.563845e-01},
  { 2.916041e-01, -7.775915e-01,  5.570626e-01,  2.629479e-01,  2.471736e-01,  8.435203e-01},
  { 4.378333e-01, -5.815652e-02,  8.971732e-01,  2.645119e-01,  2.603275e-01,  8.544883e-01},
  {-9.377997e-02,  2.013742e-01,  9.750147e-01,  4.517157e-01,  2.957013e-01,  8.142273e-01},
  {-9.922087e-01,  7.480870e-02, -9.962650e-02,  5.726247e-02,  3.205127e-01,  7.247701e-01},
  {-9.250412e-01,  2.397568e-01, -2.946445e-01,  7.386694e-02,  3.267194e-01,  6.479899e-01},
  { 3.202107e-01, -8.634549e-02,  9.434031e-01,  3.325939e-01,  2.877556e-01,  6.567297e-01},
  {-6.610990e-01,  6.646559e-01, -3.481101e-01,  1.016456e-01,  3.136799e-01,  5.763965e-01},
  { 7.731978e-01,  5.282558e-01,  3.508718e-01,  4.573745e-01,  2.880172e-01,  5.244018e-01},
  {-6.062471e-01,  7.542341e-01,  2.521807e-01,  1.065066e-01,  2.976624e-01,  5.152507e-01},
  { 9.993922e-01, -2.117329e-02, -2.769600e-02,  5.336908e-01,  2.580034e-01,  4.675727e-01},
  {-7.810623e-01,  4.981350e-01,  3.765678e-01, -3.046310e-01,  3.320181e-01,  5.029901e-01},
  { 1.428256e-01,  9.887307e-01,  4.486055e-02, -2.299351e-01,  3.539132e-01,  4.705763e-01},
  { 1.435385e-01,  8.690270e-01, -4.734857e-01, -2.449424e-01,  3.522045e-01,  3.749751e-01},
  {-7.781608e-01,  6.082213e-01, -1.566294e-01, -3.639851e-01,  3.186770e-01,  4.033055e-01},
  { 6.675782e-01, -1.164951e-01, -7.353696e-01,  4.450476e-01,  2.767217e-01,  2.693038e-01},
  {-5.869548e-01, -7.657193e-02,  8.059905e-01,  7.008913e-02,  3.025428e-01,  2.792116e-01},
  { 9.132361e-01, -2.463206e-01,  3.245396e-01,  4.422616e-01,  2.897196e-01,  2.545608e-01},
  {-5.369760e-01,  3.228875e-01,  7.793590e-01, -4.265702e-01,  2.945509e-01,  3.065923e-01},
  { 3.595983e-02, -5.227808e-01,  8.517084e-01, -2.253901e-01,  2.750713e-01,  2.343705e-01},
  {-4.810614e-01, -1.922739e-01, -8.553424e-01,  4.105204e-01,  2.757357e-01,  1.352781e-01},
  {-4.810614e-01, -1.922739e-01, -8.553424e-01, -3.514152e-01,  2.868681e-01,  1.449698e-01},
  {-7.530541e-01,  6.579586e-01,  0.000000e+00,  3.171087e-01,  2.854961e-01,  1.107677e-01},
  {-7.530541e-01,  6.579586e-01,  0.000000e+00,  3.121261e-01,  2.894416e-01,  1.095672e-01},
  {-3.046813e-01, -9.174218e-01,  2.559423e-01, -4.051486e-01,  2.389468e-01,  2.747308e-02},
  {-5.937632e-01, -6.302807e-01,  5.001915e-01, -4.562011e-01,  2.684000e-01,  5.218014e-02},
  {-9.015951e-01,  2.176497e-01, -3.738381e-01,  2.966494e-02,  2.937977e-01, -4.279680e-03},
  {-8.965056e-01, -4.376143e-01,  6.907597e-02, -4.661738e-01,  2.711212e-01,  2.846322e-02},
  {-8.835173e-01, -2.354763e-02, -4.678063e-01, -4.602589e-01,  2.839167e-01, -2.440841e-02},
  {-4.629498e-01, -2.059780e-01, -8.621199e-01, -3.882765e-01,  2.681595e-01, -9.063625e-02},
  { 9.757449e-01, -3.721865e-02,  2.157237e-01,  4.282841e-01,  2.792698e-01, -8.629690e-02},
  { 9.896948e-01, -3.036955e-02,  1.399347e-01,  4.318741e-01,  2.785802e-01, -1.044917e-01},
  {-4.396472e-01,  6.414916e-01,  6.286484e-01, -3.794041e-01,  3.143143e-01, -1.405140e-01},
  { 2.748834e-01,  3.002635e-01,  9.133898e-01, -3.053563e-01,  3.123189e-01, -1.478069e-01},
  {-8.498759e-01,  4.161020e-01,  3.233728e-01, -4.200033e-01,  3.046377e-01, -1.886171e-01},
  { 3.457943e-01,  7.033530e-01, -6.210644e-01,  9.380428e-02,  3.337334e-01, -4.217664e-01},
  {-7.181250e-01, -6.805829e-01, -1.452693e-01, -1.927728e-01,  2.783348e-01, -4.004061e-01},
  { 8.926171e-01, -2.176930e-01,  3.947713e-01,  1.117384e-01,  3.341206e-01, -4.779226e-01},
  {-7.898133e-01,  1.625442e-01,  5.914173e-01, -1.194529e-01,  2.926935e-01, -4.960454e-01},
  { 5.593333e-01, -7.719235e-01,  3.021264e-01, -3.555520e-01,  2.960175e-01, -4.258411e-01},
  { 9.286174e-01, -2.091682e-01,  3.064612e-01,  1.289732e-01,  3.004918e-01, -5.080509e-01},
  { 3.881374e-01, -5.882995e-01,  7.094033e-01,  1.669911e-01,  3.102533e-01, -5.772127e-01},
  {-9.232646e-01,  5.787404e-02,  3.797804e-01, -1.459893e-01,  2.755891e-01, -6.735774e-01},
  { 9.116263e-01,  6.794824e-02,  4.053646e-01,  1.800030e-01,  2.900889e-01, -7.801468e-01},
  { 9.639335e-01,  1.006809e-01, -2.463646e-01,  1.866435e-01,  3.011468e-01, -8.195435e-01},
  { 4.600273e-01,  1.452693e-01, -8.759404e-01,  1.490573e-01,  3.116210e-01, -8.687349e-01},
  {-8.912051e-01, -3.235308e-01,  3.179329e-01,  3.238334e-01,  2.865463e-01,  8.304607e-01},
  {-6.858913e-01,  6.450763e-01,  3.367931e-01,  3.089241e-01,  2.913956e-01,  7.908094e-01},
  {-2.935864e-03,  4.846544e-01,  8.747008e-01,  2.776068e-01,  2.879468e-01,  8.565899e-01},
  { 7.557991e-01, -5.377489e-01,  3.736225e-01,  3.318721e-01,  2.755992e-01,  8.209645e-01},
  { 5.251842e-01, -8.497183e-01,  4.647774e-02,  3.224862e-01,  2.695864e-01,  8.094258e-01},
  { 8.234267e-01, -5.507053e-01,  1.367190e-01,  3.461686e-01,  2.862817e-01,  8.074194e-01},
  { 6.175660e-01, -3.500546e-01,  7.043253e-01,  3.020147e-01,  2.605027e-01,  8.116034e-01},
  {-4.867028e-01,  5.016111e-01,  7.151969e-01,  1.052480e-01,  3.386511e-01,  7.968771e-01},
  {-8.230445e-02, -1.127481e-01,  9.902089e-01,  4.625609e-01,  3.111107e-01,  8.173444e-01},
  { 9.934769e-01,  8.701985e-02, -7.369622e-02,  5.408589e-01,  2.990800e-01,  7.304202e-01},
  {-9.406859e-01,  2.984219e-01,  1.614140e-01,  6.204132e-02,  3.492993e-01,  7.303979e-01},
  {-1.987040e-01,  2.037070e-01,  9.586554e-01, -5.483650e-02,  3.162515e-01,  7.445235e-01},
  {-8.350384e-01, -2.333053e-01,  4.982765e-01, -1.250951e-01,  2.905352e-01,  6.997595e-01},
  { 3.475114e-01,  6.966171e-01, -6.276627e-01,  4.745810e-01,  3.172426e-01,  5.453803e-01},
  {-3.667695e-01,  8.961826e-01, -2.496736e-01,  1.786251e-01,  3.217198e-01,  5.723297e-01},
  {-2.614781e-01,  9.370182e-01,  2.315734e-01,  1.570665e-01,  3.121354e-01,  5.210984e-01},
  {-1.310577e-01,  8.989049e-01,  4.180835e-01, -2.625370e-01,  3.457470e-01,  5.083835e-01},
  { 2.165743e-01, -1.025258e-01,  9.708676e-01,  1.005233e-01,  3.106729e-01,  4.883556e-01},
  { 3.871838e-01, -3.863396e-01, -8.371562e-01,  4.962435e-01,  2.844155e-01,  4.181875e-01},
  {-7.102650e-01, -6.931220e-01, -1.229048e-01, -3.506793e-02,  2.896299e-01,  4.264359e-01},
  {-2.927625e-01,  9.420049e-01, -1.640636e-01, -3.060154e-01,  3.607388e-01,  4.107315e-01},
  { 8.755054e-01, -1.426006e-01, -4.616877e-01,  4.945290e-01,  3.029238e-01,  2.873585e-01},
  {-7.657381e-01,  5.227664e-01,  3.746473e-01, -4.251051e-01,  3.217075e-01,  2.909514e-01},
  { 8.626353e-01, -1.796013e-02,  5.055075e-01,  5.144439e-01,  3.068824e-01,  2.260252e-01},
  {-8.924989e-01,  3.185955e-01, -3.192846e-01, -4.352557e-01,  3.575407e-01,  1.570574e-01},
  {-9.594096e-01, -2.762348e-01,  5.681152e-02, -3.693545e-01,  3.081999e-01,  1.358055e-01},
  {-7.475668e-02, -2.421758e-01, -9.673481e-01, -1.568719e-01,  2.909060e-01,  2.565682e-02},
  {-8.786516e-01, -6.013797e-02,  4.736609e-01, -4.561252e-01,  3.180479e-01,  7.720887e-02},
  { 1.990653e-01,  4.368211e-01,  8.772459e-01,  3.668689e-01,  3.205300e-01,  1.211401e-01},
  { 5.666508e-01,  7.959732e-01, -2.129168e-01,  5.602364e-01,  3.313650e-01, -2.473082e-01},
  { 2.357061e-01,  1.266998e-01,  9.635299e-01, -6.671190e-02,  3.195372e-01, -4.301929e-01},
  { 4.403930e-01, -7.493920e-01,  4.944347e-01, -3.701575e-01,  3.108015e-01, -3.904246e-01},
  {-4.604145e-01, -7.824444e-01,  4.192843e-01, -3.859615e-01,  3.059464e-01, -4.092877e-01},
  {-7.092737e-01,  5.478726e-01, -4.435837e-01, -3.490125e-01,  3.603118e-01, -5.742263e-01},
  { 5.616403e-01, -2.303130e-01, -7.946798e-01, -1.916058e-01,  2.753932e-01, -6.818191e-01},
  { 7.212490e-02, -1.850714e-01, -9.800748e-01,  1.864136e-01,  2.968647e-01, -6.889735e-01},
  {-2.993211e-01, -1.458517e-01, -9.429391e-01, -6.703877e-02,  3.044546e-01, -7.619790e-01},
  {-5.830476e-01, -7.820724e-01, -2.200413e-01, -2.347764e-02,  3.182579e-01, -7.817358e-01},
  {-6.858913e-01,  6.450763e-01,  3.367931e-01,  3.286133e-01,  2.969272e-01,  8.203121e-01},
  { 3.871055e-01,  1.304901e-01,  9.127550e-01,  3.276558e-01,  3.008841e-01,  8.293405e-01},
  {-1.919958e-01,  4.112543e-01,  8.910710e-01,  1.696767e-01,  3.568209e-01,  8.094065e-01},
  {-5.164928e-01,  8.354871e-01,  1.876078e-01,  7.513854e-02,  3.727686e-01,  7.455017e-01},
  {-5.591165e-01,  7.836292e-01, -2.707654e-01,  8.612943e-02,  3.624651e-01,  6.907548e-01},
  {-6.386136e-01, -1.615208e-02,  7.693580e-01,  3.749663e-01,  3.299119e-01,  6.736060e-01},
  { 9.350413e-01,  2.383554e-01, -2.624585e-01,  5.009295e-01,  3.406484e-01,  5.959594e-01},
  {-8.122019e-01,  5.310633e-01,  2.414539e-01,  2.155240e-01,  3.277082e-01,  5.338244e-01},
  {-5.167031e-01,  4.261902e-01,  7.425495e-01,  1.998012e-01,  3.298395e-01,  5.155805e-01},
  { 2.161417e-01,  8.106784e-01,  5.441353e-01, -2.894623e-02,  3.219190e-01,  4.853601e-01},
  {-3.414317e-01,  7.492824e-01,  5.674507e-01,  1.497588e-01,  3.285138e-01,  5.005380e-01},
  {-8.006791e-01,  4.126298e-01, -4.343382e-01, -2.446790e-02,  3.027618e-01,  4.344014e-01},
  { 8.951758e-01,  8.544489e-02,  4.374465e-01,  4.982671e-01,  3.230329e-01,  3.348370e-01},
  {-4.348945e-01,  8.111937e-01, -3.909367e-01,  9.016718e-02,  3.391283e-01,  3.047385e-01},
  { 1.944262e-02,  2.373762e-01, -9.712232e-01,  4.526552e-01,  3.324864e-01,  2.521344e-01},
  {-4.662642e-02, -1.697120e-01,  9.843901e-01, -3.192621e-01,  3.170976e-01,  3.085174e-01},
  {-4.668900e-01,  6.114246e-01, -6.388848e-01,  4.649059e-01,  3.305281e-01,  2.413076e-01},
  { 1.986369e-01,  9.132715e-01, -3.556379e-01, -2.650470e-01,  3.363649e-01,  1.781685e-01},
  {-7.928211e-01,  6.091554e-01, -1.908864e-02, -2.398632e-01,  3.338097e-01,  1.456719e-01},
  { 3.160362e-01,  9.445768e-01,  8.885852e-02, -3.026792e-01,  3.434559e-01,  3.946364e-02},
  {-8.463081e-01,  3.626841e-01,  3.901576e-01, -4.532597e-01,  3.466083e-01,  7.636726e-02},
  {-3.460177e-01, -5.857409e-01, -7.329252e-01, -1.860989e-01,  3.119045e-01,  2.999446e-02},
  {-9.164604e-01,  3.957958e-01, -5.870360e-02, -4.568515e-01,  3.493378e-01,  3.991597e-02},
  { 4.846986e-01,  3.985968e-01,  7.785807e-01,  3.589961e-01,  3.464478e-01,  1.019916e-01},
  { 5.109551e-02, -2.037225e-01, -9.776944e-01, -9.589007e-03,  3.119507e-01,  1.303289e-02},
  { 4.859250e-01, -2.449118e-01, -8.389845e-01, -2.464085e-02,  3.154845e-01,  5.692145e-03},
  {-8.156207e-01,  3.899925e-01,  4.273977e-01, -1.686216e-02,  3.100959e-01, -1.071791e-01},
  {-8.524508e-01,  4.387249e-01,  2.843380e-01, -1.750786e-02,  3.215775e-01, -1.142293e-01},
  {-9.493988e-01,  1.884383e-01,  2.512629e-01, -1.787602e-02,  3.217786e-01, -1.371042e-01},
  { 1.869006e-01,  9.409503e-01,  2.822777e-01,  4.532026e-01,  3.244287e-01, -1.864398e-01},
  { 8.216667e-01, -3.971846e-01,  4.087887e-01,  4.895131e-01,  3.542309e-01, -2.304677e-01},
  {-8.115843e-01, -1.203680e-01, -5.717014e-01, -3.854848e-01,  3.357302e-01, -2.809075e-01},
  { 3.242323e-01,  8.475725e-01, -4.201122e-01,  4.767883e-01,  3.516862e-01, -3.193930e-01},
  {-9.379798e-01,  2.634629e-01, -2.253470e-01, -2.235748e-02,  3.289188e-01, -2.817932e-01},
  { 1.269089e-01,  8.181456e-01, -5.608316e-01,  4.249513e-01,  3.604175e-01, -3.243769e-01},
  { 2.490324e-01,  3.238211e-03, -9.684898e-01,  3.664535e-01,  3.678374e-01, -3.431667e-01},
  { 9.114735e-01,  1.283034e-01,  3.908380e-01, -1.914321e-01,  3.292915e-01, -2.984210e-01},
  { 3.868083e-01,  6.266874e-01, -6.764926e-01,  2.040072e-01,  3.171671e-01, -3.615732e-01},
  { 6.175473e-01,  1.165124e-01, -7.778561e-01,  1.062298e-01,  3.646819e-01, -4.217713e-01},
  { 8.281341e-01, -2.627098e-01, -4.951541e-01,  1.010005e-01,  3.541048e-01, -4.224431e-01},
  {-7.259954e-01, -2.635993e-01, -6.351740e-01, -2.332583e-01,  3.191979e-01, -4.340170e-01},
  { 1.035587e-01, -3.835640e-01,  9.176897e-01,  1.105915e-01,  3.666838e-01, -4.641350e-01},
  { 5.789263e-01, -1.360113e-01,  8.039560e-01, -3.399995e-01,  3.582142e-01, -4.153023e-01},
  {-1.351849e-01, -3.894083e-01, -9.110907e-01,  1.273632e-01,  3.061409e-01, -6.408883e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00,  1.244682e-01,  3.132863e-01, -7.009926e-01},
  { 8.271912e-01,  1.741249e-01,  5.342613e-01,  1.158312e-01,  3.353721e-01, -7.104714e-01},
  { 6.968549e-01,  7.161050e-01, -3.983440e-02,  1.688442e-01,  3.308147e-01, -8.251585e-01},
  { 4.240618e-01,  8.803993e-01, -2.122934e-01,  1.133723e-01,  3.589928e-01, -8.409546e-01},
  {-3.368073e-01, -6.112192e-01, -7.162206e-01,  3.509950e-02,  3.100439e-01, -9.010953e-01},
  {-3.271485e-01,  1.974095e-01,  9.241230e-01,  2.911795e-01,  3.387815e-01,  8.111013e-01},
  {-5.579479e-01,  7.863191e-01,  2.653234e-01,  1.431505e-01,  4.054453e-01,  7.649198e-01},
  {-8.941916e-01, -2.298007e-01,  3.842044e-01,  1.775390e-01,  3.635475e-01,  6.471300e-01},
  { 8.405414e-01, -2.726178e-01,  4.681557e-01,  5.445438e-02,  3.524465e-01,  5.770110e-01},
  {-6.069062e-01, -5.837301e-01, -5.393737e-01, -5.342294e-02,  3.235610e-01,  5.412753e-01},
  { 9.978513e-01,  2.261951e-02,  6.149083e-02,  3.723623e-01,  3.380815e-01,  4.993385e-01},
  {-7.322873e-01, -6.809215e-01,  1.005945e-02, -1.264748e-01,  3.010316e-01,  3.731728e-01},
  { 5.413998e-01,  2.932210e-01,  7.879770e-01,  4.761564e-01,  3.378222e-01,  3.532229e-01},
  {-9.140418e-01,  3.581392e-01,  1.904309e-01,  9.350151e-02,  3.538405e-01,  2.721010e-01},
  { 7.194598e-02, -2.375714e-01,  9.687020e-01, -1.550901e-01,  3.239075e-01,  3.269746e-01},
  {-6.848124e-01,  6.605748e-01,  3.076897e-01, -3.912682e-01,  3.774226e-01,  2.691370e-01},
  { 6.839460e-01,  3.028848e-02,  7.289036e-01,  5.156132e-01,  3.438798e-01,  2.210461e-01},
  {-3.746740e-01, -6.435888e-02, -9.249203e-01, -2.629061e-01,  3.755535e-01,  2.236270e-01},
  { 2.283878e-01,  9.706049e-01,  7.592819e-02, -1.218114e-01,  3.759540e-01,  1.919333e-01},
  {-2.120663e-01,  6.904623e-01, -6.915849e-01, -2.508228e-01,  3.604188e-01,  2.166183e-01},
  {-7.606604e-02,  9.706105e-01, -2.283185e-01, -3.175838e-01,  4.208419e-01,  2.050920e-01},
  {-9.835991e-01, -3.220719e-02, -1.774699e-01, -2.457117e-01,  3.699596e-01,  1.968144e-01},
  {-7.068733e-01,  5.053782e-01,  4.948969e-01, -4.241461e-01,  4.031149e-01,  1.634207e-01},
  {-5.260295e-01,  8.502953e-01,  1.705486e-02, -4.169304e-01,  4.161977e-01,  1.261044e-01},
  {-7.885827e-01,  5.834133e-01, -1.943351e-01, -4.090139e-01,  4.183205e-01,  1.075942e-01},
  { 2.161369e-01, -2.304013e-01, -9.487887e-01,  3.239188e-01,  3.323759e-01,  1.045738e-01},
  {-8.816221e-01,  3.920623e-01,  2.627346e-01, -2.512466e-01,  3.396658e-01,  8.661229e-02},
  {-4.432794e-01,  8.944029e-01, -5.955525e-02, -4.010618e-01,  3.984734e-01,  3.313766e-02},
  {-4.432794e-01,  8.944029e-01, -5.955525e-02, -2.166032e-01,  3.490258e-01, -1.019898e-02},
  {-6.460068e-01,  3.101930e-01,  6.974637e-01, -2.859703e-01,  3.490282e-01,  2.454964e-02},
  { 4.195191e-01,  8.304339e-01,  3.665832e-01, -3.069204e-01,  3.529041e-01,  9.938596e-03},
  { 9.694698e-01, -2.392694e-01,  5.365143e-02,  4.657344e-01,  3.491391e-01, -6.282336e-02},
  {-3.300375e-01,  6.279123e-01,  7.048414e-01,  4.416250e-01,  3.295292e-01, -1.598802e-01},
  {-9.515669e-01,  2.952352e-01, -8.577052e-02, -7.996423e-02,  3.650262e-01, -2.253716e-01},
  {-2.991969e-02,  4.589109e-01, -8.879784e-01,  2.154016e-01,  3.294204e-01, -3.460625e-01},
  { 8.417303e-01, -1.367018e-01,  5.223052e-01, -1.766921e-01,  3.575356e-01, -3.256764e-01},
  { 1.210241e-01,  1.610649e-01, -9.794955e-01,  1.099609e-01,  3.704821e-01, -4.191263e-01},
  { 7.445918e-01, -8.461645e-02,  6.621352e-01, -1.052745e-01,  3.447059e-01, -3.648310e-01},
  {-3.997496e-01,  9.166242e-01,  5.026790e-04,  1.157194e-02,  3.889678e-01, -4.267018e-01},
  {-9.359803e-01, -9.818572e-02, -3.380835e-01, -1.194849e-01,  3.256209e-01, -4.913729e-01},
  {-8.719144e-01,  4.246059e-01, -2.438751e-01, -3.698129e-01,  3.483780e-01, -4.057888e-01},
  { 1.180126e-01,  6.552909e-01,  7.461011e-01, -1.143914e-01,  3.408442e-01, -5.098420e-01},
  { 2.248196e-01,  4.100227e-01,  8.839330e-01, -2.325418e-01,  4.081733e-01, -4.934132e-01},
  { 9.667806e-02, -1.227615e-01, -9.877161e-01, -1.027905e-01,  3.193296e-01, -6.042025e-01},
  { 5.494304e-01, -3.891754e-01, -7.393705e-01, -1.489176e-01,  3.320241e-01, -6.253198e-01},
  { 4.225179e-01, -7.230507e-01,  5.465129e-01,  2.852412e-01,  3.145887e-01, -5.816931e-01},
  { 3.623937e-01, -1.654066e-01, -9.172303e-01,  8.876622e-02,  3.112752e-01, -6.538680e-01},
  {-7.699813e-01,  6.370803e-01, -3.545975e-02, -5.319096e-02,  3.415899e-01, -6.488534e-01},
  { 6.521003e-01, -1.359241e-01,  7.458485e-01,  5.012972e-01,  3.491334e-01,  8.162469e-01},
  { 9.027578e-01, -1.084712e-01,  4.162481e-01,  3.252079e-01,  3.418956e-01,  6.816868e-01},
  { 8.509648e-01,  1.305368e-01, -5.087424e-01,  4.353725e-01,  3.550266e-01,  6.042811e-01},
  { 6.897352e-01,  6.024618e-01, -4.016281e-01,  4.178820e-01,  3.462352e-01,  5.811220e-01},
  { 6.055146e-01, -6.114752e-01, -5.093625e-01,  3.776500e-01,  3.447016e-01,  5.213003e-01},
  {-7.935435e-01,  2.570470e-01,  5.515575e-01,  2.344867e-01,  3.566448e-01,  5.372086e-01},
  { 7.028288e-01, -6.352307e-01, -3.201776e-01,  3.714318e-01,  3.420086e-01,  5.129936e-01},
  { 3.872220e-01, -7.200873e-01,  5.757893e-01,  8.218762e-02,  3.560363e-01,  5.521556e-01},
  {-7.349374e-01, -6.777793e-01, -2.195754e-02, -3.403740e-02,  3.402044e-01,  4.947604e-01},
  {-7.425340e-01, -6.160867e-01, -2.628317e-01, -3.539160e-02,  3.402390e-01,  4.606262e-01},
  {-5.485547e-01, -7.026049e-01, -4.532484e-01, -1.624311e-01,  3.270940e-01,  4.061532e-01},
  {-1.598442e-01,  3.003507e-01, -9.403400e-01, -5.857011e-02,  3.591987e-01,  3.331472e-01},
  {-4.843073e-01,  2.282923e-02, -8.746000e-01,  6.172145e-02,  3.570129e-01,  3.238181e-01},
  {-1.989025e-01, -2.939751e-01,  9.348885e-01, -2.748833e-01,  3.939122e-01,  3.535502e-01},
  { 5.073291e-01,  8.544435e-01, -1.119977e-01, -3.391645e-01,  4.283169e-01,  1.557449e-01},
  { 5.704726e-01, -2.597266e-01, -7.791682e-01,  3.607786e-01,  3.337134e-01,  1.126458e-01},
  { 2.054105e-01,  5.991275e-01,  7.738557e-01, -1.055539e-01,  3.806918e-01,  1.718880e-01},
  { 8.530422e-02,  9.735965e-01, -2.117386e-01, -3.688734e-01,  4.217334e-01,  9.796213e-02},
  { 5.541286e-01,  2.662140e-02, -8.320053e-01, -5.113195e-02,  3.512544e-01, -2.014842e-02},
  { 7.775754e-01,  1.953023e-01, -5.976902e-01, -2.226661e-01,  3.597016e-01, -2.990687e-02},
  {-8.206680e-01,  4.523151e-01, -3.491634e-01, -4.028728e-01,  3.679922e-01, -6.376515e-02},
  {-9.254043e-01,  8.382895e-03,  3.788886e-01, -2.910537e-02,  3.695005e-01, -8.305231e-02},
  {-8.639283e-01, -1.963558e-01,  4.637590e-01, -2.912324e-02,  3.663999e-01, -1.809355e-01},
  { 6.404041e-02,  2.222410e-01,  9.728863e-01, -3.415165e-01,  4.036328e-01, -1.728825e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  3.475764e-01,  3.897232e-01, -3.032986e-01},
  {-1.955855e-01, -2.022490e-01, -9.596050e-01,  2.334048e-01,  3.529313e-01, -3.467438e-01},
  { 7.118883e-01, -3.313352e-02, -7.015108e-01,  2.040825e-01,  3.420064e-01, -3.493202e-01},
  { 1.745863e-01,  9.410679e-01,  2.896737e-01,  7.288951e-02,  3.880279e-01, -3.990846e-01},
  { 5.821253e-01,  8.064516e-01, -1.037590e-01,  9.537809e-02,  4.001302e-01, -4.389617e-01},
  { 1.510211e-01,  7.270958e-01,  6.697196e-01, -3.112085e-01,  4.040163e-01, -4.491979e-01},
  { 1.922299e-01, -5.918284e-01,  7.828071e-01,  1.340592e-01,  3.733566e-01, -4.773818e-01},
  {-3.416712e-01,  8.008860e-01,  4.917748e-01, -2.661586e-01,  4.525349e-01, -5.144731e-01},
  {-7.052786e-01,  7.080061e-01,  3.618474e-02, -3.129767e-01,  4.176043e-01, -5.265118e-01},
  { 3.251119e-01, -3.558609e-01,  8.761650e-01,  2.610416e-01,  3.708148e-01, -5.017313e-01},
  { 8.541264e-01, -3.300194e-01,  4.019395e-01,  3.005660e-01,  3.354770e-01, -5.542645e-01},
  { 7.639637e-02, -3.915147e-01, -9.169950e-01, -2.264153e-01,  3.339213e-01, -7.305912e-01},
  { 5.690922e-01, -6.988545e-01, -4.332857e-01,  2.514037e-01,  3.182184e-01, -7.256774e-01},
  {-1.317039e-01, -4.071290e-02, -9.904527e-01, -3.561742e-02,  3.519862e-01, -8.868061e-01},
  { 5.727077e-01, -1.947849e-01,  7.962818e-01,  3.408627e-01,  3.679179e-01,  6.638440e-01},
  {-9.248004e-01, -2.831770e-01,  2.540768e-01, -1.861959e-01,  3.539923e-01,  6.368802e-01},
  { 7.585391e-01, -1.903362e-01, -6.232098e-01,  4.062317e-01,  3.523637e-01,  5.454243e-01},
  { 9.701702e-02, -4.014348e-01,  9.107347e-01,  1.863274e-01,  3.603030e-01,  5.425130e-01},
  {-2.503466e-01, -9.203619e-01,  3.004335e-01, -5.848718e-02,  3.531219e-01,  4.956763e-01},
  { 9.864523e-01, -7.150164e-02,  1.476462e-01,  5.227620e-01,  3.731110e-01,  4.834869e-01},
  {-2.679991e-01,  7.157663e-01,  6.448683e-01,  4.181994e-01,  3.837293e-01,  4.562980e-01},
  {-3.664511e-01, -7.734860e-01,  5.171391e-01, -1.382610e-01,  3.279987e-01,  4.454499e-01},
  { 9.426015e-02, -3.106149e-01,  9.458507e-01, -2.499310e-01,  3.906852e-01,  3.524431e-01},
  {-2.009451e-02,  2.401695e-01,  9.705229e-01, -2.611098e-01,  4.074646e-01,  3.558725e-01},
  {-5.521706e-01,  5.459910e-01,  6.300806e-01, -3.214273e-01,  4.174590e-01,  3.168607e-01},
  { 5.469897e-02,  6.487715e-01,  7.590149e-01, -1.313309e-02,  3.907320e-01,  2.723515e-01},
  {-5.647938e-01,  6.147931e-01, -5.504883e-01, -2.594829e-01,  4.243544e-01,  2.089766e-01},
  { 9.765172e-01, -1.172813e-01,  1.807186e-01,  3.551798e-01,  3.558310e-01,  1.400650e-01},
  {-4.218970e-01,  4.415803e-01,  7.918395e-01, -4.458758e-03,  3.797651e-01,  1.860277e-01},
  {-4.611528e-01,  8.868614e-01, -2.854858e-02, -1.398834e-01,  3.983980e-01,  1.464705e-01},
  {-4.025615e-01,  6.929920e-01, -5.980856e-01,  6.349205e-02,  3.770610e-01,  3.550079e-02},
  {-8.213945e-01, -4.362051e-01,  3.674726e-01, -2.606731e-01,  3.737669e-01,  6.558285e-02},
  {-1.667880e-01, -9.441289e-01, -2.842575e-01, -2.257223e-01,  3.688698e-01, -4.768991e-02},
  { 1.536847e-01, -6.336807e-01, -7.581753e-01, -1.074555e-01,  3.418866e-01, -5.897287e-02},
  { 1.797273e-01, -8.293985e-01, -5.289577e-01, -3.167840e-01,  3.448098e-01, -1.163097e-01},
  {-8.168649e-01,  1.860715e-03, -5.768260e-01, -3.854080e-01,  3.869014e-01, -1.129933e-01},
  { 8.135007e-01, -4.031037e-01,  4.191945e-01,  4.608674e-01,  3.776100e-01, -1.501742e-01},
  {-8.315425e-02,  2.216588e-01,  9.715723e-01, -3.483627e-01,  4.269301e-01, -1.761715e-01},
  {-8.130606e-01,  5.621928e-01,  1.512339e-01, -3.842871e-01,  4.306086e-01, -2.201038e-01},
  { 9.781419e-01, -1.793201e-02, -2.071640e-01,  3.494755e-01,  3.992632e-01, -2.947531e-01},
  {-3.669874e-01,  9.251328e-01,  9.720925e-02,  2.255959e-02,  3.862252e-01, -3.591195e-01},
  {-4.362583e-01, -4.681475e-01, -7.684508e-01,  6.877755e-02,  3.878078e-01, -3.958272e-01},
  { 9.534134e-01, -2.799051e-01, -1.124992e-01,  3.028981e-01,  3.537454e-01, -6.136498e-01},
  {-9.977989e-01,  6.012825e-02, -2.796100e-02, -3.331889e-02,  3.820311e-01, -6.567152e-01},
  {-3.681611e-01, -6.229308e-01, -6.902279e-01,  1.423140e-01,  3.526940e-01, -6.722797e-01},
  { 4.421111e-01, -8.884138e-01, -1.235255e-01,  9.219572e-02,  3.610330e-01, -7.160777e-01},
  { 3.905602e-01, -2.745239e-01, -8.786919e-01,  6.042399e-02,  3.901044e-01, -8.309591e-01},
  {-4.433384e-01, -7.841176e-01, -4.342933e-01, -1.158833e-01,  3.290980e-01, -8.463554e-01},
  {-5.703452e-01, -6.421097e-01, -5.122513e-01, -1.761194e-01,  3.556408e-01, -8.132014e-01},
  {-7.920319e-01, -1.778554e-01, -5.839974e-01, -1.723050e-01,  3.657302e-01, -8.312430e-01},
  {-4.508061e-01, -3.738765e-01, -8.105493e-01, -1.354915e-01,  3.453674e-01, -8.579379e-01},
  { 9.883754e-01, -5.382375e-02, -1.421872e-01,  3.599209e-01,  3.579603e-01,  7.670830e-01},
  {-5.892023e-01,  6.512184e-01,  4.782837e-01,  1.653956e-01,  4.313365e-01,  7.456069e-01},
  {-3.468607e-01, -3.866666e-02,  9.371192e-01,  2.256098e-01,  4.135090e-01,  7.562036e-01},
  { 8.468997e-01, -1.964473e-01, -4.941350e-01,  4.759619e-01,  3.774083e-01,  6.616816e-01},
  { 1.784136e-01, -5.461601e-01,  8.184606e-01,  3.488110e-01,  3.802120e-01,  6.664906e-01},
  {-7.382618e-01,  4.092886e-01,  5.361459e-01, -5.804990e-02,  4.041444e-01,  7.152436e-01},
  { 6.891882e-01, -7.238764e-01, -3.197788e-02,  4.459582e-01,  3.808257e-01,  6.107447e-01},
  {-7.026659e-01,  1.734922e-01,  6.900443e-01, -1.965259e-01,  3.927754e-01,  6.003453e-01},
  { 7.371200e-01,  7.703783e-02,  6.713564e-01,  1.610954e-01,  3.872741e-01,  5.936057e-01},
  { 5.614814e-01, -6.074818e-01,  5.618760e-01,  1.736590e-01,  3.719717e-01,  5.745028e-01},
  { 8.588468e-01,  1.385820e-01, -4.931300e-01,  3.837867e-01,  3.867887e-01,  4.512707e-01},
  {-4.924584e-02,  5.227414e-01,  8.510677e-01,  5.036271e-01,  3.966703e-01,  5.091584e-01},
  {-6.448949e-01, -4.327629e-01, -6.299420e-01, -1.982997e-01,  3.913985e-01,  3.747250e-01},
  {-8.269730e-01, -3.864757e-01, -4.083530e-01,  9.982651e-02,  3.873467e-01,  2.824170e-01},
  { 4.107645e-01,  5.582998e-01,  7.208147e-01, -2.089086e-01,  4.256537e-01,  3.296947e-01},
  { 9.572207e-01, -1.209884e-01, -2.628506e-01,  5.042029e-01,  3.954056e-01,  2.706874e-01},
  { 7.580854e-01, -1.518668e-01, -6.342263e-01,  5.013415e-01,  3.837825e-01,  2.656463e-01},
  { 5.427093e-01, -2.832216e-01, -7.907289e-01,  4.585796e-01,  3.989701e-01,  2.354858e-01},
  { 6.868809e-02,  9.974465e-01, -1.955646e-02, -2.587582e-01,  4.509045e-01,  2.734568e-01},
  {-6.682444e-01,  5.809445e-01,  4.647073e-01,  9.685823e-02,  4.030647e-01,  2.286618e-01},
  {-4.228701e-01,  6.408790e-02,  9.039212e-01,  2.209304e-02,  4.039944e-01,  2.061879e-01},
  { 1.898104e-01, -2.799965e-01, -9.410493e-01,  3.639622e-01,  3.698241e-01,  1.016905e-01},
  {-2.434758e-01,  9.222616e-01,  3.002552e-01, -1.811559e-01,  4.168202e-01,  1.198030e-01},
  { 5.673754e-01, -3.231609e-01, -7.573985e-01,  5.377856e-01,  3.725396e-01,  3.158210e-02},
  { 5.251340e-01,  1.756909e-01, -8.326866e-01,  5.291828e-01,  3.665635e-01,  1.666142e-02},
  { 1.092635e-01,  1.772717e-01, -9.780778e-01,  1.192017e-02,  3.737611e-01,  4.647331e-02},
  { 4.529287e-01, -1.978136e-01, -8.693247e-01, -2.189496e-02,  3.748533e-01,  2.361226e-02},
  { 4.817970e-02, -9.889625e-01, -1.401140e-01, -2.328430e-01,  3.720264e-01, -6.754640e-02},
  {-7.487859e-01,  5.782815e-01,  3.238985e-01,  6.744161e-02,  3.891406e-01, -1.141650e-02},
  {-3.429787e-01, -2.767023e-01, -8.976644e-01, -3.535271e-01,  3.799324e-01, -1.479417e-01},
  { 9.070987e-01,  3.100901e-01,  2.846334e-01,  4.583637e-01,  4.233750e-01, -5.339804e-02},
  {-8.624530e-01,  9.403396e-02,  4.973251e-01, -5.025741e-02,  3.993155e-01, -1.112807e-01},
  {-7.130716e-01,  4.409738e-01, -5.450423e-01, -3.692451e-01,  4.339375e-01, -2.521735e-01},
  { 8.590112e-01, -1.269399e-01,  4.959696e-01, -1.777206e-01,  4.143546e-01, -2.514125e-01},
  {-1.589203e-01, -8.991218e-01,  4.078289e-01,  3.549948e-01,  3.746046e-01, -3.469660e-01},
  {-5.938833e-01, -2.035162e-01, -7.783854e-01, -9.149179e-03,  4.145086e-01, -3.778200e-01},
  { 4.983740e-01,  8.330584e-02, -8.629504e-01,  1.209382e-01,  4.030550e-01, -4.021998e-01},
  {-8.339333e-01,  2.839006e-01, -4.732396e-01, -2.571572e-01,  4.211779e-01, -3.252697e-01},
  {-2.710681e-01, -7.363119e-01, -6.199734e-01,  3.109400e-01,  3.851376e-01, -4.070774e-01},
  { 2.572903e-01,  9.639256e-01, -6.818414e-02, -1.366170e-01,  4.155343e-01, -3.870628e-01},
  { 2.572902e-01,  9.639257e-01, -6.818414e-02, -9.628538e-02,  4.013705e-01, -4.351079e-01},
  {-5.445775e-02,  6.334997e-01,  7.718241e-01,  4.277841e-02,  4.075577e-01, -4.892389e-01},
  { 6.495667e-01,  5.363902e-01,  5.388402e-01,  2.695830e-01,  4.017429e-01, -5.093049e-01},
  {-7.838361e-01,  5.491724e-01, -2.898459e-01, -2.870802e-01,  4.340175e-01, -6.612388e-01},
  { 9.262650e-01, -3.414777e-01, -1.594556e-01,  2.892597e-01,  3.693711e-01, -6.980193e-01},
  { 2.429031e-01, -7.886233e-01, -5.648639e-01,  9.063590e-02,  3.626293e-01, -6.921961e-01},
  {-9.425985e-01,  2.496458e-01,  2.217771e-01, -1.812553e-01,  3.988797e-01, -7.897505e-01},
  {-2.573924e-01,  3.089238e-01, -9.155956e-01, -8.194534e-02,  4.074956e-01, -8.715667e-01},
  { 6.484432e-01, -1.914788e-01,  7.367885e-01,  3.354773e-01,  3.725507e-01,  8.310212e-01},
  {-6.556715e-01,  1.077581e-02,  7.549694e-01,  4.374501e-01,  4.032933e-01,  8.189738e-01},
  {-2.716309e-01,  6.400719e-01,  7.186965e-01, -2.934198e-02,  4.311728e-01,  7.108980e-01},
  {-8.749374e-01,  4.491247e-02, -4.821487e-01,  2.268024e-01,  3.901637e-01,  5.860602e-01},
  { 7.551478e-01, -2.884852e-02,  6.549194e-01,  1.352907e-01,  4.152491e-01,  6.178448e-01},
  {-7.915752e-01, -4.895599e-01,  3.657047e-01, -1.996847e-01,  3.852450e-01,  5.569558e-01},
  {-3.637219e-01, -9.301684e-01,  4.993039e-02, -1.300607e-01,  3.702599e-01,  4.935607e-01},
  { 3.740014e-01,  6.299446e-01,  6.806560e-01,  1.925925e-01,  4.131249e-01,  4.808164e-01},
  {-7.914393e-01, -6.095443e-01, -4.560326e-02, -2.256592e-01,  3.870340e-01,  4.266889e-01},
  { 2.176251e-01,  1.098852e-01,  9.698270e-01,  4.158564e-01,  4.246535e-01,  4.343314e-01},
  {-4.427634e-01,  1.042074e-01,  8.905624e-01,  4.406332e-01,  4.240137e-01,  4.482017e-01},
  { 4.755070e-01, -4.310358e-01, -7.668776e-01,  4.021762e-01,  3.957607e-01,  3.600350e-01},
  {-2.512823e-02,  6.806670e-01,  7.321619e-01, -2.498259e-01,  4.361497e-01,  3.417982e-01},
  { 7.780504e-03,  9.531670e-01,  3.023443e-01, -2.513987e-01,  4.476131e-01,  3.227946e-01},
  { 9.414431e-01, -2.689729e-01,  2.033185e-01,  3.661294e-01,  3.985122e-01,  1.296072e-01},
  {-9.682848e-01, -4.402795e-02,  2.459391e-01, -2.856048e-01,  4.246819e-01,  1.431581e-01},
  {-5.982950e-01,  4.714251e-01,  6.479209e-01, -3.600706e-01,  4.313012e-01,  1.798795e-02},
  { 6.496634e-01, -6.091229e-01, -4.548700e-01, -1.246852e-01,  3.710750e-01, -9.179454e-02},
  { 1.304407e-01, -9.206119e-01, -3.680474e-01, -2.430867e-01,  3.611894e-01, -1.380005e-01},
  { 6.689072e-01, -6.169060e-01, -4.147169e-01, -1.249350e-01,  3.766438e-01, -1.124241e-01},
  { 2.841412e-01, -6.929453e-01, -6.626391e-01, -1.710991e-01,  3.816564e-01, -1.568130e-01},
  {-9.524863e-01,  5.350968e-03,  3.045343e-01, -6.576813e-02,  4.294219e-01, -1.636453e-01},
  { 3.153356e-01,  2.390892e-02,  9.486790e-01, -2.321104e-01,  4.587609e-01, -1.953138e-01},
  { 1.721830e-01,  2.009844e-01, -9.643435e-01,  1.750761e-01,  4.063307e-01, -3.635778e-01},
  {-8.244637e-01,  5.388880e-01, -1.727989e-01, -9.159483e-03,  4.367630e-01, -3.674740e-01},
  {-3.936740e-01, -7.850607e-01, -4.782265e-01,  5.611790e-02,  4.380986e-01, -4.063678e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -1.438696e-01,  4.209656e-01, -3.758418e-01},
  { 3.003896e-01,  9.533789e-01, -2.889503e-02, -1.316137e-01,  4.135751e-01, -3.996895e-01},
  { 1.794165e-01,  3.867593e-01,  9.045590e-01,  1.468814e-01,  4.308398e-01, -4.795082e-01},
  {-8.483597e-01,  3.896324e-01,  3.584305e-01, -1.198120e-01,  4.099949e-01, -5.562673e-01},
  { 1.817304e-01,  9.532292e-01,  2.415122e-01, -2.242109e-01,  4.756083e-01, -5.861360e-01},
  { 5.913618e-01,  3.304293e-01,  7.356002e-01,  2.171779e-01,  4.317365e-01, -5.445727e-01},
  {-2.757496e-01,  9.562142e-01, -9.806317e-02, -2.599685e-01,  4.804001e-01, -5.949280e-01},
  {-5.017570e-01, -7.518346e-01, -4.277671e-01,  2.871352e-01,  3.938649e-01, -7.216300e-01},
  { 3.924837e-02, -9.619780e-01, -2.702922e-01,  1.384519e-01,  3.840681e-01, -7.161939e-01},
  {-4.078446e-01,  5.166595e-03, -9.130368e-01, -2.322694e-01,  4.359556e-01, -7.535819e-01},
  {-6.522185e-01,  6.372724e-01,  4.104811e-01, -1.213536e-01,  4.836119e-01, -7.692965e-01},
  {-5.903051e-01,  6.161085e-01, -5.214885e-01, -1.592124e-01,  4.442488e-01, -8.236287e-01},
  {-8.122744e-02,  7.104415e-01, -6.990529e-01, -2.113571e-02,  4.583667e-01, -8.392866e-01},
  { 8.779978e-01, -4.757445e-01, -5.279120e-02,  3.464381e-01,  4.108644e-01,  7.374507e-01},
  { 3.274786e-01, -6.378628e-02,  9.427031e-01,  6.468127e-02,  4.436757e-01,  7.132527e-01},
  { 8.716425e-01, -8.737167e-02,  4.822921e-01,  9.731927e-02,  4.302463e-01,  6.710591e-01},
  { 5.270519e-01, -8.202782e-01, -2.221712e-01,  4.892198e-01,  3.830806e-01,  5.450026e-01},
  {-8.212706e-01, -2.486821e-01,  5.134898e-01,  2.170514e-01,  4.131147e-01,  4.956907e-01},
  {-7.402924e-01,  2.887934e-01, -6.070959e-01, -2.137735e-01,  4.323345e-01,  3.756795e-01},
  { 5.891925e-01, -5.587873e-01, -5.836171e-01,  4.758209e-01,  4.302082e-01,  2.087123e-01},
  {-2.789380e-01, -5.358043e-01,  7.969362e-01,  3.574657e-03,  4.073879e-01,  1.909106e-01},
  { 9.909258e-01,  1.156096e-01,  6.855935e-02,  5.239346e-01,  4.187439e-01,  1.529126e-01},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  3.421121e-01,  4.080066e-01,  8.562010e-02},
  { 7.242173e-01,  5.056575e-01, -4.688495e-01,  5.226593e-01,  4.083313e-01,  2.353228e-02},
  { 5.668342e-01,  2.840041e-01, -7.733310e-01,  5.147256e-01,  4.116021e-01,  2.141430e-02},
  {-5.272848e-01,  2.525332e-01, -8.112938e-01,  8.432370e-02,  4.131772e-01,  4.686678e-02},
  { 2.016070e-01, -3.636371e-01, -9.094629e-01,  3.988333e-02,  4.061079e-01,  4.450659e-02},
  {-7.419397e-01,  4.470786e-01,  4.996461e-01, -3.107173e-01,  4.440397e-01,  9.834343e-02},
  { 3.877100e-01, -2.039046e-01, -8.989460e-01, -3.728134e-02,  3.998722e-01,  8.379159e-03},
  { 3.568650e-01, -4.712965e-01, -8.065525e-01, -1.068359e-01,  4.245888e-01, -8.527325e-03},
  { 1.296042e-01,  4.302427e-01,  8.933610e-01,  3.695287e-01,  4.440192e-01,  6.451672e-02},
  { 8.178626e-01, -7.977928e-02, -5.698562e-01, -1.174131e-01,  4.247544e-01, -2.737828e-02},
  {-7.620869e-01,  3.993671e-01,  5.096366e-01,  7.908834e-02,  4.192021e-01, -4.060617e-02},
  { 7.573360e-01,  9.055258e-03, -6.529626e-01, -1.595302e-01,  3.997546e-01, -1.605505e-01},
  {-6.774642e-01, -3.200659e-02, -7.348591e-01, -5.099674e-02,  4.481823e-01, -2.245637e-01},
  {-6.356561e-01,  6.119575e-02, -7.695430e-01, -4.396198e-02,  4.387307e-01, -2.284603e-01},
  {-4.335328e-01,  5.973468e-01,  6.747044e-01, -3.007379e-01,  5.049804e-01, -2.082921e-01},
  { 6.766905e-01,  2.680103e-01,  6.857553e-01, -1.887083e-01,  4.903565e-01, -2.485049e-01},
  {-5.274586e-01,  8.098801e-01, -2.566743e-01, -2.871462e-01,  5.259443e-01, -2.410320e-01},
  {-2.551980e-01,  8.085783e-01, -5.301651e-01,  3.470526e-02,  4.509832e-01, -3.882690e-01},
  { 3.254631e-01, -6.375108e-01, -6.983222e-01,  1.013417e-01,  4.377267e-01, -4.429853e-01},
  {-3.402092e-01,  7.349703e-01, -5.865803e-01, -2.537757e-01,  4.668080e-01, -3.004217e-01},
  { 7.743071e-01, -3.758326e-01,  5.091152e-01, -1.546898e-01,  4.483180e-01, -3.388454e-01},
  {-9.196255e-01, -2.179374e-01, -3.267908e-01, -2.767115e-01,  4.477548e-01, -3.712906e-01},
  { 2.617290e-01,  8.745514e-02,  9.611709e-01,  8.585903e-02,  4.374715e-01, -5.035854e-01},
  {-7.682974e-01,  4.922355e-02,  6.381975e-01, -1.331595e-01,  4.427377e-01, -5.868813e-01},
  {-4.490149e-01,  7.063020e-01,  5.472870e-01, -1.996810e-01,  4.752192e-01, -6.209021e-01},
  { 7.683914e-01,  3.137610e-01,  5.577891e-01,  2.400993e-01,  4.417873e-01, -5.669867e-01},
  {-5.806510e-02, -7.162719e-01, -6.954014e-01,  2.151286e-01,  3.618429e-01, -7.750022e-01},
  {-5.806510e-02, -7.162719e-01, -6.954014e-01,  1.476019e-02,  4.267644e-01, -7.495482e-01},
  {-5.806510e-02, -7.162719e-01, -6.954014e-01,  2.289628e-02,  4.316828e-01, -7.448624e-01},
  { 5.305597e-01,  7.641609e-01, -3.668303e-01, -1.898500e-02,  4.497590e-01, -7.502682e-01},
  { 3.770860e-01,  6.697146e-01, -6.397567e-01, -7.562911e-02,  4.930168e-01, -7.711450e-01},
  {-6.606996e-02,  9.946221e-01,  7.975990e-02, -9.310567e-02,  5.002692e-01, -7.703592e-01},
  { 5.104749e-02, -1.931160e-01, -9.798471e-01,  1.057164e-01,  4.536002e-01, -8.647538e-01},
  { 4.433079e-01, -4.062467e-01,  7.990256e-01,  3.400458e-01,  4.268366e-01,  8.388131e-01},
  {-2.322039e-01, -1.602227e-01,  9.593800e-01,  2.864387e-01,  4.157935e-01,  8.460200e-01},
  { 9.649256e-01, -4.638090e-02, -2.583939e-01,  5.405369e-01,  4.256884e-01,  7.210367e-01},
  { 9.324889e-01, -2.946516e-01, -2.089138e-01,  5.329727e-01,  4.063046e-01,  5.886669e-01},
  {-8.470266e-01, -5.225571e-01, -9.736570e-02,  2.117398e-01,  4.316701e-01,  5.456719e-01},
  {-5.518213e-01,  4.488230e-01,  7.028878e-01, -5.918067e-02,  4.629324e-01,  5.938269e-01},
  {-9.474601e-01, -1.247622e-01,  2.945399e-01, -2.565172e-01,  4.435592e-01,  5.196165e-01},
  {-5.172102e-01,  7.075722e-01, -4.814927e-01,  1.097788e-01,  4.448173e-01,  4.681234e-01},
  {-6.513705e-01,  7.336155e-01, -1.937131e-01, -2.370303e-01,  4.512381e-01,  4.243000e-01},
  { 7.546768e-01, -1.930435e-01,  6.270545e-01,  5.372732e-01,  4.596899e-01,  4.771602e-01},
  {-1.059080e-01, -4.497323e-01, -8.868621e-01, -5.656467e-02,  4.049049e-01,  3.448826e-01},
  {-4.139906e-01, -3.507710e-01,  8.399830e-01,  8.960070e-02,  4.422996e-01,  2.210695e-01},
  {-2.700171e-01, -2.477676e-01, -9.304311e-01,  4.135262e-01,  4.227888e-01,  9.538185e-02},
  { 1.772309e-01,  2.241707e-01,  9.582988e-01,  3.424809e-01,  4.488109e-01,  6.545690e-02},
  { 6.549420e-01,  8.076989e-02,  7.513502e-01,  3.517636e-01,  4.580013e-01,  5.996799e-02},
  {-9.390274e-01,  3.216015e-01,  1.216560e-01,  1.013840e-01,  4.438992e-01,  3.767431e-03},
  {-8.556860e-01,  1.286843e-01,  5.012403e-01, -2.493199e-01,  4.649785e-01, -2.714747e-03},
  { 1.468209e-01,  1.654916e-01, -9.752210e-01, -2.305769e-01,  4.521076e-01, -1.645713e-01},
  {-9.964811e-01, -8.162338e-02, -1.905473e-02, -8.329561e-02,  4.559015e-01, -1.712426e-01},
  {-7.068716e-01,  5.714316e-01,  4.168915e-01, -7.678785e-02,  4.701177e-01, -1.806462e-01},
  {-3.917385e-01,  2.733995e-01, -8.785179e-01,  9.178665e-03,  4.659396e-01, -2.271429e-01},
  { 4.194537e-01,  3.276054e-01,  8.466011e-01, -2.277347e-01,  5.266121e-01, -2.033856e-01},
  {-7.655079e-01,  5.681211e-01, -3.020528e-01,  3.902227e-02,  4.546010e-01, -2.673431e-01},
  { 3.203377e-01,  9.398965e-01, -1.182300e-01, -2.226669e-01,  5.448240e-01, -2.207123e-01},
  { 1.930152e-01,  6.811002e-01, -7.062915e-01, -2.384842e-01,  5.230492e-01, -2.693967e-01},
  {-1.190196e-01, -4.016412e-01, -9.080302e-01,  2.116295e-01,  4.215268e-01, -3.740674e-01},
  { 2.420726e-01,  7.921162e-02, -9.670193e-01,  1.343835e-01,  4.578921e-01, -3.920851e-01},
  { 8.227945e-02,  7.455194e-01, -6.613855e-01, -2.322779e-01,  4.909949e-01, -2.825846e-01},
  {-7.927864e-01, -4.326885e-02,  6.079617e-01, -2.587883e-01,  4.735657e-01, -2.978685e-01},
  { 5.712508e-01, -2.351268e-01,  7.863765e-01, -2.474783e-02,  4.568444e-01, -4.794966e-01},
  {-9.839191e-01,  8.406124e-02,  1.575973e-01, -1.766167e-01,  4.788456e-01, -6.169973e-01},
  { 9.680706e-01,  2.196109e-01,  1.208738e-01,  2.969144e-01,  4.418985e-01, -6.390391e-01},
  { 3.436714e-01,  9.321678e-02, -9.344520e-01, -1.829825e-01,  4.874441e-01, -7.492217e-01},
  { 7.660187e-01, -1.470344e-01, -6.257766e-01,  2.654370e-01,  4.425113e-01, -7.816786e-01},
  {-8.619146e-01,  3.505895e-01,  3.663199e-01,  1.357383e-03,  4.901090e-01, -7.886571e-01},
  {-3.487709e-01, -6.053299e-01,  7.154961e-01,  1.874374e-01,  4.906317e-01,  8.028443e-01},
  { 3.268435e-01, -8.027253e-01,  4.988039e-01,  3.930160e-01,  4.542164e-01,  7.329586e-01},
  { 8.758952e-01,  4.465269e-01,  1.828150e-01,  7.980557e-02,  4.704845e-01,  5.788702e-01},
  {-5.435761e-01,  5.228663e-01,  6.566093e-01, -2.227992e-01,  4.769383e-01,  5.480791e-01},
  {-7.137938e-01,  1.350534e-01,  6.872110e-01, -2.483929e-01,  4.777925e-01,  5.213275e-01},
  { 8.811148e-01,  4.547929e-01,  1.296158e-01,  9.934729e-02,  4.551972e-01,  5.209612e-01},
  {-5.368456e-01,  8.012448e-01, -2.642036e-01, -1.272698e-01,  4.787412e-01,  4.638679e-01},
  {-6.965017e-01,  5.207076e-01,  4.937093e-01, -1.367598e-01,  4.806864e-01,  4.257850e-01},
  {-8.006421e-01,  4.523259e-01, -3.929042e-01,  1.697008e-01,  4.579589e-01,  4.230684e-01},
  {-2.029511e-01, -2.521319e-01, -9.461715e-01,  2.953417e-02,  4.281163e-01,  2.538582e-01},
  { 3.301227e-02, -1.447195e-01, -9.889218e-01,  3.899961e-01,  4.305497e-01,  8.620459e-02},
  { 2.443596e-01, -1.626056e-01, -9.559538e-01, -1.984393e-01,  4.948293e-01, -1.140624e-01},
  {-5.232391e-01,  3.054678e-01,  7.955565e-01,  8.823944e-03,  4.529062e-01, -1.156907e-01},
  {-2.717079e-01,  6.347117e-01,  7.234057e-01, -2.687076e-01,  5.282795e-01, -2.084847e-01},
  { 8.399674e-01, -4.996567e-01,  2.116549e-01,  3.654687e-01,  4.364500e-01, -2.948453e-01},
  { 6.856146e-01, -7.050041e-01, -1.813884e-01,  4.413197e-01,  4.114753e-01, -4.097056e-01},
  { 2.260024e-01, -5.041965e-01, -8.334919e-01,  4.366793e-01,  4.165404e-01, -4.214642e-01},
  {-5.817205e-01,  4.383588e-02,  8.122067e-01, -2.326506e-01,  5.091740e-01, -2.743092e-01},
  { 1.415379e-01,  2.949078e-01, -9.449849e-01,  3.728261e-01,  4.553061e-01, -4.494044e-01},
  { 8.513062e-01, -1.668527e-01,  4.974315e-01, -1.078214e-01,  4.935642e-01, -3.160687e-01},
  { 1.878160e-01, -3.244139e-01,  9.270818e-01,  1.389399e-02,  4.747092e-01, -4.876826e-01},
  {-4.332833e-01,  7.249504e-01, -5.354553e-01, -4.289928e-02,  4.674777e-01, -6.278965e-01},
  {-2.261781e-01,  9.721841e-01,  6.084174e-02,  9.843943e-02,  4.628870e-01, -7.076946e-01},
  { 1.619987e-01,  6.752993e-01, -7.195327e-01,  3.303872e-02,  4.527093e-01, -7.159583e-01},
  { 7.652961e-01,  5.423995e-01, -3.465899e-01,  2.800156e-01,  4.722648e-01, -7.367504e-01},
  {-8.570538e-01,  2.577305e-01, -4.461320e-01, -9.120703e-02,  5.181789e-01, -7.635363e-01},
  { 4.641331e-01, -9.570341e-03, -8.857138e-01,  2.007866e-01,  4.823568e-01, -8.391727e-01},
  {-4.265599e-01,  8.837429e-01,  1.924710e-01,  3.123185e-02,  5.259262e-01, -8.103701e-01},
  {-9.241195e-02,  5.194860e-01, -8.494672e-01,  9.069620e-02,  5.092992e-01, -8.567758e-01},
  {-3.779730e-01,  6.245448e-01,  6.834328e-01,  2.689905e-01,  4.726976e-01,  8.329871e-01},
  { 9.146669e-01,  6.124636e-02,  3.995414e-01,  5.502941e-01,  4.630969e-01,  7.866395e-01},
  {-3.531077e-01, -5.551486e-01,  7.530770e-01,  4.251114e-01,  4.598055e-01,  7.943303e-01},
  { 6.369612e-01,  1.937581e-01, -7.461489e-01,  5.178627e-01,  4.552910e-01,  5.384430e-01},
  { 7.106166e-01,  3.094001e-01,  6.318983e-01,  6.471885e-02,  5.327915e-01,  6.648863e-01},
  {-7.556292e-01,  6.477472e-01, -9.720147e-02, -1.713822e-01,  5.339966e-01,  5.447071e-01},
  {-9.687456e-01,  1.540603e-02,  2.475776e-01, -1.127083e-01,  5.122994e-01,  4.794281e-01},
  {-2.816845e-01, -5.653850e-01, -7.752377e-01, -5.971716e-02,  4.422553e-01,  2.641746e-01},
  {-1.293533e-01, -6.111769e-02,  9.897133e-01, -3.629103e-02,  4.767691e-01,  2.352359e-01},
  {-1.054957e-01, -5.642396e-01,  8.188432e-01, -1.094060e-01,  4.291066e-01,  2.211999e-01},
  {-4.179671e-01, -2.761670e-01, -8.654683e-01,  3.823426e-01,  4.695332e-01,  8.534034e-02},
  { 9.227155e-01,  3.772148e-01,  7.940283e-02,  3.754554e-01,  4.601098e-01,  8.227411e-02},
  {-8.821598e-01, -4.606588e-01,  9.791632e-02, -1.635834e-01,  4.478024e-01,  1.256306e-01},
  {-2.977165e-01,  6.090111e-02, -9.527098e-01,  3.554192e-01,  4.517618e-01,  6.160238e-02},
  { 8.947103e-01, -4.444078e-01,  4.466661e-02,  3.639358e-01,  4.738132e-01,  6.035059e-02},
  { 3.598707e-01, -5.563935e-01, -7.489455e-01,  3.549778e-04,  4.299264e-01, -3.977906e-02},
  {-6.361104e-01,  6.264739e-01, -4.504374e-01, -3.349848e-01,  5.369445e-01, -9.956438e-02},
  {-7.785008e-01,  6.263997e-01, -3.949616e-02, -3.854478e-01,  5.379225e-01, -8.273235e-02},
  {-1.179079e-01,  2.954628e-01, -9.480504e-01, -2.681557e-01,  5.055491e-01, -1.556099e-01},
  {-6.644303e-01, -7.082390e-01,  2.386000e-01,  5.140076e-01,  4.126809e-01, -1.297116e-01},
  {-9.161866e-01,  3.992393e-01, -3.478884e-02, -4.868324e-02,  5.258883e-01, -1.507499e-01},
  { 4.167280e-01, -8.147999e-01,  4.030371e-01,  4.612931e-01,  4.100388e-01, -3.279185e-01},
  { 4.167280e-01, -8.147999e-01,  4.030371e-01,  4.843241e-01,  4.602674e-01, -4.443904e-01},
  { 1.293823e-01,  2.936863e-01, -9.471053e-01,  2.651505e-01,  4.425625e-01, -4.381904e-01},
  {-9.872204e-01, -4.563087e-03, -1.592955e-01, -2.777954e-01,  5.345436e-01, -4.491540e-01},
  {-8.054285e-01, -4.528780e-01,  3.823432e-01, -1.830715e-01,  4.933206e-01, -6.179497e-01},
  {-7.390058e-01,  2.342014e-02,  6.732919e-01, -2.291136e-01,  5.234382e-01, -6.700776e-01},
  {-1.169784e-02,  9.975359e-01, -6.917574e-02,  2.412898e-01,  5.073122e-01, -6.910473e-01},
  {-2.781645e-01, -3.629842e-01, -8.893071e-01,  2.542588e-01,  5.096055e-01, -6.902735e-01},
  {-2.269889e-01,  8.638417e-01, -4.497260e-01,  1.953649e-01,  4.993311e-01, -6.711240e-01},
  {-6.014428e-01, -6.761917e-01, -4.254780e-01, -2.095203e-01,  5.346345e-01, -7.155678e-01},
  { 1.398806e-01,  9.122530e-01, -3.850040e-01,  1.458278e-01,  5.534644e-01, -7.990808e-01},
  { 5.272776e-01,  6.975065e-01, -4.852451e-01,  1.968444e-01,  5.285213e-01, -8.260125e-01},
  { 2.298737e-01,  8.002344e-01, -5.538799e-01,  1.553134e-01,  5.337626e-01, -8.371119e-01},
  { 9.496521e-02, -1.616418e-01,  9.822695e-01,  5.063303e-01,  4.774010e-01,  8.397059e-01},
  { 9.915707e-01, -7.643627e-02, -1.046190e-01,  5.554650e-01,  4.859618e-01,  7.617884e-01},
  { 2.020348e-02,  8.953700e-01,  4.448645e-01,  1.204734e-01,  5.223567e-01,  7.397841e-01},
  { 3.133251e-01,  2.499379e-01,  9.161651e-01,  2.990144e-01,  5.116307e-01,  6.785007e-01},
  { 7.219906e-01,  3.963811e-01, -5.671080e-01,  5.355400e-01,  4.882195e-01,  5.677346e-01},
  {-9.264271e-01, -2.991231e-01, -2.286006e-01,  1.381215e-01,  4.875838e-01,  5.811459e-01},
  {-9.937568e-01,  1.060232e-01, -3.473439e-02,  1.557122e-01,  5.003058e-01,  5.003251e-01},
  { 9.652669e-01,  2.464792e-01,  8.664732e-02,  3.886442e-01,  4.970630e-01,  4.748307e-01},
  { 2.409062e-02,  5.805856e-02,  9.980224e-01,  4.858881e-01,  5.180662e-01,  5.081989e-01},
  { 6.252701e-01, -1.247233e-01,  7.703775e-01,  1.439931e-01,  4.911462e-01,  4.194224e-01},
  { 4.946008e-01, -7.491890e-01, -4.405518e-01,  4.323994e-01,  4.929146e-01,  3.106053e-01},
  {-1.540239e-01, -3.396632e-01, -9.278499e-01, -1.025091e-01,  4.539220e-01,  2.627872e-01},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  4.307125e-01,  4.920923e-01,  3.018232e-01},
  { 7.345709e-01, -4.699827e-01, -4.894099e-01,  4.395860e-01,  4.966432e-01,  3.030813e-01},
  { 8.176166e-01, -1.656153e-01, -5.514296e-01,  4.853890e-01,  4.909247e-01,  1.810604e-01},
  { 9.973554e-01, -4.551636e-02, -5.666187e-02,  3.687287e-01,  4.844255e-01,  6.993248e-02},
  { 4.962818e-01,  6.107955e-04, -8.681613e-01,  7.043292e-02,  4.873782e-01,  5.509894e-02},
  {-8.677751e-01, -4.143403e-01,  2.743876e-01, -1.932263e-01,  4.804444e-01,  6.418027e-02},
  { 2.912907e-01, -6.012032e-01, -7.441132e-01, -5.203668e-02,  4.616068e-01, -7.460735e-02},
  { 3.415155e-01, -4.297514e-01, -8.358713e-01, -1.046813e-01,  4.671183e-01, -9.061684e-02},
  {-4.687819e-01, -1.081147e-01,  8.766726e-01, -2.173147e-02,  5.252002e-01, -1.059199e-01},
  { 9.574729e-01,  9.422511e-02, -2.727037e-01,  4.945774e-01,  4.222001e-01, -1.865988e-01},
  {-6.263081e-01,  5.152672e-01, -5.850111e-01,  1.969288e-02,  5.327863e-01, -2.254707e-01},
  {-6.479628e-01,  5.821951e-01, -4.911142e-01,  5.445931e-02,  5.232182e-01, -2.887748e-01},
  { 7.692716e-01, -6.129065e-01,  1.804626e-01,  4.706783e-01,  4.351005e-01, -3.015147e-01},
  {-5.332083e-01, -4.984139e-01, -6.835733e-01,  1.974901e-01,  4.680244e-01, -3.963736e-01},
  {-7.535545e-01, -6.334985e-01, -1.755995e-01,  1.833611e-01,  4.857544e-01, -3.796141e-01},
  { 2.698259e-01, -5.847598e-01, -7.650164e-01,  5.002145e-01,  4.719816e-01, -4.294005e-01},
  { 2.557371e-01,  1.778237e-01, -9.502512e-01,  2.273798e-01,  4.416879e-01, -4.485192e-01},
  { 2.736177e-01,  9.615068e-01,  2.526091e-02, -1.606460e-01,  5.747057e-01, -3.488558e-01},
  {-8.263679e-01,  2.575257e-01, -5.007960e-01, -1.447914e-01,  5.502601e-01, -3.956243e-01},
  { 3.152442e-01, -9.457325e-01,  7.881104e-02, -1.368623e-01,  5.416728e-01, -4.071166e-01},
  {-1.450147e-01,  9.850106e-01, -9.340728e-02, -1.300022e-01,  5.333138e-01, -4.287425e-01},
  { 5.050524e-01,  8.608255e-01, -6.246187e-02, -1.133237e-01,  5.213079e-01, -4.593446e-01},
  { 6.097379e-01,  3.491553e-01,  7.115548e-01, -1.072711e-01,  5.149037e-01, -4.986652e-01},
  {-7.848141e-01,  5.507292e-01,  2.841906e-01, -7.748488e-02,  5.375043e-01, -7.336057e-01},
  { 1.071049e-01,  9.586592e-01,  2.636303e-01,  1.859513e-01,  5.479490e-01, -7.747373e-01},
  {-1.951825e-01,  1.449278e-01,  9.699998e-01,  3.647465e-01,  5.420190e-01,  8.389541e-01},
  {-6.209141e-01,  7.648607e-01,  1.716211e-01,  3.473666e-01,  5.221183e-01,  6.704958e-01},
  {-5.946275e-02,  2.251345e-01,  9.725115e-01,  1.853138e-02,  5.711160e-01,  6.771416e-01},
  { 8.060580e-01,  5.041370e-01,  3.100264e-01,  6.299185e-02,  5.689036e-01,  6.433458e-01},
  {-5.676861e-01,  4.539333e-01,  6.867875e-01, -8.967178e-02,  5.642523e-01,  6.335714e-01},
  { 2.856647e-01,  2.786929e-01, -9.169112e-01,  3.973557e-01,  4.998544e-01,  5.237918e-01},
  { 6.128780e-01,  2.999160e-01,  7.310478e-01,  5.207167e-01,  5.239998e-01,  4.954157e-01},
  {-9.693846e-01, -2.280352e-01,  9.106883e-02, -1.456701e-01,  4.899377e-01,  4.149278e-01},
  {-6.698775e-01,  2.724931e-01,  6.906604e-01,  1.794185e-01,  4.985043e-01,  4.060116e-01},
  {-4.309384e-01, -9.015039e-01, -3.978429e-02, -1.460929e-01,  4.445623e-01,  2.968077e-01},
  {-8.789319e-01, -2.460463e-02, -4.763121e-01,  9.929864e-02,  4.856268e-01,  2.654257e-01},
  { 3.996412e-02, -6.538586e-01,  7.555606e-01, -1.803280e-01,  4.704561e-01,  2.403385e-01},
  {-1.048047e-01, -9.607258e-01,  2.569471e-01, -2.756448e-01,  4.713439e-01,  2.275736e-01},
  {-5.000138e-01, -7.673808e-01,  4.013885e-01, -2.979277e-01,  4.745900e-01,  2.252563e-01},
  {-2.612856e-01,  8.121615e-01,  5.216547e-01,  1.355575e-02,  5.155281e-01,  2.264208e-01},
  {-9.509103e-01,  1.271115e-01,  2.821566e-01, -3.252629e-01,  4.859381e-01,  2.021932e-01},
  {-4.395014e-01, -8.904527e-01, -1.180361e-01, -3.324825e-01,  4.890417e-01,  1.451533e-01},
  { 9.935162e-01,  9.068773e-02, -6.856629e-02,  5.132670e-01,  4.705881e-01, -1.369574e-02},
  { 5.030556e-01,  2.869157e-01, -8.152389e-01, -7.407449e-02,  5.198154e-01, -8.289091e-02},
  {-7.700618e-01,  6.299006e-01,  1.011439e-01, -2.915749e-01,  5.824652e-01, -8.390264e-02},
  { 6.229061e-01, -1.335213e-01, -7.708178e-01, -1.237959e-01,  5.296206e-01, -1.314209e-01},
  {-7.562029e-01,  4.440020e-01,  4.806449e-01, -3.000421e-02,  5.594842e-01, -1.063642e-01},
  {-2.548024e-01,  9.314969e-01, -2.595947e-01,  5.303138e-02,  5.610053e-01, -1.679716e-01},
  {-4.928148e-01,  7.680175e-01, -4.090021e-01, -1.816700e-02,  5.667074e-01, -1.500773e-01},
  { 5.869880e-01, -8.027629e-01,  1.049605e-01,  4.747209e-01,  4.726921e-01, -2.308885e-01},
  { 8.893733e-01,  4.005875e-01, -2.203288e-01,  3.693595e-01,  5.015036e-01, -2.444622e-01},
  {-1.324923e-01, -7.414417e-01,  6.578070e-01,  4.161763e-01,  4.794478e-01, -2.704703e-01},
  {-5.187426e-01,  3.962111e-01, -7.575770e-01,  4.293173e-01,  4.988891e-01, -3.614562e-01},
  { 6.701933e-01, -1.220820e-02, -7.420862e-01,  2.942458e-01,  5.039465e-01, -3.756495e-01},
  { 9.856335e-01, -7.953593e-02, -1.489991e-01,  4.995506e-01,  4.901843e-01, -3.829224e-01},
  { 4.667684e-01,  7.396619e-01, -4.847963e-01,  4.773776e-01,  4.949605e-01, -4.538057e-01},
  { 4.639386e-02,  7.243318e-01, -6.878889e-01,  4.574576e-01,  5.004525e-01, -4.493662e-01},
  {-6.035107e-01,  6.617291e-01,  4.448475e-01, -2.133018e-01,  5.629340e-01, -2.977051e-01},
  { 4.196463e-01,  1.913313e-01,  8.872932e-01, -6.415205e-02,  5.338809e-01, -3.276589e-01},
  { 7.046867e-01, -4.246942e-01,  5.683761e-01, -1.381091e-02,  5.251442e-01, -3.690193e-01},
  { 6.789391e-01, -5.407397e-02,  7.322006e-01,  1.143477e-02,  5.608461e-01, -4.050222e-01},
  { 8.004090e-01,  5.297216e-02,  5.971092e-01,  2.469687e-01,  5.296372e-01, -5.534998e-01},
  { 5.151130e-01,  1.729981e-01,  8.394821e-01,  2.204637e-01,  5.308170e-01, -5.328503e-01},
  { 2.310727e-02, -3.216057e-02, -9.992156e-01,  1.604955e-01,  5.187091e-01, -6.439538e-01},
  {-1.407165e-01,  8.609384e-01, -4.888599e-01, -2.638657e-02,  5.466583e-01, -7.544665e-01},
  { 4.093846e-01,  1.473927e-01,  9.003775e-01,  4.831995e-01,  5.201010e-01,  8.516433e-01},
  {-6.286986e-01,  7.608011e-01,  1.609960e-01,  3.543825e-01,  5.746194e-01,  7.798414e-01},
  { 8.241240e-02,  9.122903e-01,  4.011667e-01,  9.486607e-02,  5.582072e-01,  6.743009e-01},
  {-1.101086e-01,  5.306837e-01,  8.403874e-01,  3.324580e-01,  5.215859e-01,  6.580813e-01},
  { 2.345691e-01,  9.246044e-01,  3.001401e-01,  2.455083e-01,  5.316874e-01,  6.696164e-01},
  {-4.173285e-01,  4.731558e-01,  7.758611e-01, -2.390897e-02,  5.869268e-01,  6.549083e-01},
  {-6.840256e-01,  5.163205e-01, -5.152883e-01,  1.568825e-01,  5.347555e-01,  5.337846e-01},
  {-5.312340e-01,  8.129760e-01,  2.384542e-01, -1.025944e-01,  5.746018e-01,  6.019692e-01},
  { 9.510706e-01, -1.333593e-01, -2.787113e-01,  3.809564e-01,  5.143087e-01,  5.114167e-01},
  {-2.538144e-01,  9.330515e-01,  2.549376e-01, -1.027690e-01,  5.399169e-01,  4.654692e-01},
  { 7.012139e-02,  6.454987e-01,  7.605357e-01,  4.941495e-01,  5.563045e-01,  4.872774e-01},
  {-1.959686e-01,  8.755615e-01,  4.415749e-01,  4.799292e-01,  5.705560e-01,  4.699655e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  5.202900e-01,  5.636442e-01,  3.158312e-01},
  {-4.213583e-02, -2.766007e-01, -9.600607e-01, -9.833648e-03,  5.096256e-01,  2.780662e-01},
  {-4.723351e-02, -8.372218e-02, -9.953691e-01, -4.823748e-02,  5.135338e-01,  2.775033e-01},
  {-3.779677e-01, -5.155883e-01, -7.689661e-01, -1.945741e-01,  4.812811e-01,  2.768970e-01},
  {-9.939185e-01, -5.968703e-02, -9.254007e-02,  8.105284e-02,  5.084723e-01,  2.712138e-01},
  {-1.916272e-01, -3.622953e-01,  9.121519e-01, -2.822697e-01,  5.054954e-01,  2.668089e-01},
  { 9.694391e-01, -2.453308e-01, -7.632980e-04,  5.054426e-01,  5.326942e-01,  2.075148e-01},
  {-8.944729e-01, -2.564545e-02,  4.463863e-01, -3.220769e-01,  5.223190e-01,  2.208091e-01},
  {-5.355149e-01,  6.999597e-01,  4.725254e-01,  4.274186e-02,  5.313026e-01,  1.939770e-01},
  { 8.107509e-01,  5.472900e-01,  2.077419e-01,  3.454163e-01,  4.961847e-01,  1.044690e-01},
  {-9.204422e-01, -3.050206e-01, -2.444351e-01, -3.586934e-01,  5.194508e-01,  1.232424e-01},
  {-7.531233e-01,  1.603415e-01, -6.380407e-01,  1.166949e-01,  5.239143e-01,  4.909335e-02},
  {-9.472392e-01,  1.008419e-01, -3.042516e-01, -2.981668e-01,  5.778605e-01, -5.051043e-02},
  { 7.618279e-01, -4.631678e-01, -4.528728e-01,  3.723289e-01,  5.522135e-01, -1.790841e-03},
  {-8.384243e-01, -1.911308e-02,  5.446827e-01,  9.994835e-02,  5.575905e-01, -4.162286e-02},
  { 4.162807e-01,  9.443910e-02, -9.043183e-01, -1.385359e-01,  5.457090e-01, -1.415519e-01},
  {-3.269237e-02,  2.062865e-02, -9.992526e-01, -1.773684e-01,  5.586129e-01, -1.474450e-01},
  { 9.270020e-01, -2.980324e-01, -2.276926e-01,  5.182179e-01,  5.137728e-01, -3.338315e-01},
  {-1.320795e-01,  5.635485e-01, -8.154558e-01,  3.841116e-01,  5.419520e-01, -3.142921e-01},
  { 8.097497e-03, -2.591389e-01, -9.658061e-01, -2.552940e-01,  5.904517e-01, -4.967348e-01},
  {-3.920619e-01,  3.736286e-01,  8.406481e-01,  1.804221e-02,  5.629697e-01, -5.593126e-01},
  { 2.534154e-01,  1.901585e-01,  9.484832e-01, -2.314374e-02,  5.387602e-01, -5.536421e-01},
  {-9.906449e-01,  1.231348e-02, -1.359085e-01, -2.382593e-01,  5.368292e-01, -6.339659e-01},
  { 9.827042e-02,  2.272327e-03,  9.951571e-01,  1.342743e-01,  5.578358e-01, -5.336992e-01},
  { 2.396328e-01, -1.996056e-01, -9.501230e-01,  2.465010e-01,  5.456155e-01, -7.170913e-01},
  { 1.560674e-01, -5.775561e-01, -8.012938e-01,  4.346263e-03,  5.428142e-01, -6.398680e-01},
  {-8.000139e-01,  5.102490e-01, -3.156321e-01, -2.302080e-01,  5.466660e-01, -6.665620e-01},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01,  4.610260e-02,  5.521666e-01, -6.628189e-01},
  {-6.900225e-01,  5.271730e-01, -4.959411e-01,  4.528632e-02,  5.606396e-01, -6.645090e-01},
  {-4.728671e-01,  6.229116e-01, -6.231997e-01, -1.739379e-01,  5.588768e-01, -7.237530e-01},
  { 3.223834e-01,  3.562258e-01,  8.770246e-01,  4.467813e-01,  5.526286e-01,  8.544866e-01},
  { 6.573498e-01,  1.717332e-01,  7.337568e-01,  5.284001e-01,  5.694323e-01,  8.080165e-01},
  {-8.546159e-01,  3.363501e-01, -3.956013e-01,  1.450644e-01,  5.567546e-01,  5.719377e-01},
  {-3.055553e-01,  9.518191e-01,  2.600651e-02,  9.265756e-05,  6.090328e-01,  6.046620e-01},
  { 2.310239e-01,  9.718473e-01, -4.626993e-02,  2.457191e-02,  6.066684e-01,  5.719689e-01},
  { 2.161523e-01,  9.722154e-01,  8.986336e-02,  4.044391e-02,  6.063750e-01,  6.085593e-01},
  { 2.523164e-01,  9.609008e-01,  1.140443e-01,  5.845873e-02,  5.967144e-01,  5.499909e-01},
  {-6.611243e-01,  6.284921e-01,  4.097711e-01,  4.365519e-02,  6.051573e-01,  5.131607e-01},
  { 3.709909e-01, -2.343145e-01,  8.985891e-01,  1.781902e-02,  5.549152e-01,  4.591977e-01},
  { 7.208669e-01,  5.591928e-01,  4.094562e-01,  5.267259e-01,  5.838864e-01,  4.218794e-01},
  {-2.189446e-01, -9.757295e-01,  3.900380e-03, -1.695307e-01,  5.079334e-01,  3.852787e-01},
  {-6.376843e-01, -7.301611e-01,  2.454049e-01, -2.771037e-01,  5.060875e-01,  3.814327e-01},
  { 7.695083e-01,  6.371800e-01,  4.311260e-02,  5.436541e-01,  5.921535e-01,  3.852877e-01},
  { 7.992043e-01,  1.677328e-01, -5.771812e-01,  5.328240e-01,  5.877969e-01,  3.475680e-01},
  {-2.831657e-01, -9.577678e-01, -4.997995e-02, -2.392334e-01,  4.799607e-01,  3.604625e-01},
  {-2.831657e-01, -9.577678e-01, -4.997995e-02,  5.286652e-01,  5.743849e-01,  3.218978e-01},
  {-6.443872e-01, -2.175889e-01, -7.330894e-01, -2.611526e-01,  4.997733e-01,  3.170139e-01},
  {-2.660081e-01, -3.167036e-01, -9.104607e-01,  3.283894e-01,  5.214418e-01,  1.006580e-01},
  {-9.610134e-01,  2.664065e-01,  7.403294e-02, -3.649576e-01,  5.407152e-01,  1.270732e-01},
  {-4.935633e-01, -4.794398e-01, -7.256258e-01,  3.597292e-01,  5.206541e-01,  9.177549e-02},
  {-1.886009e-01, -7.803424e-01, -5.962343e-01,  3.476667e-01,  5.162641e-01,  1.013367e-01},
  {-8.545573e-01,  4.773635e-01, -2.045872e-01, -3.281119e-01,  5.639200e-01,  5.013522e-02},
  {-9.859627e-01,  1.393679e-01, -9.194601e-02, -3.158588e-01,  5.836933e-01, -1.185408e-02},
  {-7.486173e-01, -5.774735e-01, -3.257247e-01,  4.345381e-01,  5.365402e-01, -3.902746e-04},
  {-9.939526e-01,  4.235662e-02,  1.013125e-01,  1.309036e-01,  5.604780e-01,  1.959365e-02},
  {-3.390418e-01,  9.407617e-01,  4.250277e-03, -2.733963e-01,  6.064052e-01, -4.761942e-02},
  { 6.222957e-01,  7.803206e-01, -6.203068e-02, -1.322927e-01,  5.746188e-01, -1.060002e-01},
  { 1.339853e-01,  8.982251e-01,  4.186164e-01, -2.263088e-01,  6.146162e-01, -8.382090e-02},
  {-2.057565e-01,  9.474992e-01,  2.447640e-01, -2.609791e-01,  6.102754e-01, -7.083125e-02},
  { 1.686440e-01,  9.856755e-01, -1.772505e-03, -2.064196e-01,  6.164251e-01, -1.002450e-01},
  { 3.773229e-01,  7.121841e-01, -5.919639e-01, -1.756719e-01,  6.019640e-01, -1.279219e-01},
  {-4.423663e-01,  8.272635e-01, -3.463338e-01, -2.639304e-01,  6.063129e-01, -1.095322e-01},
  {-6.886926e-02,  5.067962e-01, -8.593105e-01, -2.211460e-01,  6.051679e-01, -1.344116e-01},
  { 9.829369e-01, -1.586148e-01, -9.314671e-02,  5.196144e-01,  5.021844e-01, -1.378663e-01},
  {-7.640465e-02,  9.530573e-01, -2.929916e-01,  1.047473e-01,  5.653746e-01, -1.533302e-01},
  { 9.769648e-01,  1.988417e-01, -7.747128e-02,  3.600068e-01,  5.429352e-01, -1.809943e-01},
  { 2.766120e-01, -7.481881e-01,  6.030757e-01,  3.592826e-01,  5.355601e-01, -2.111480e-01},
  {-7.410471e-01,  3.923077e-01, -5.449256e-01,  1.531780e-01,  5.608616e-01, -2.739741e-01},
  { 6.656783e-01,  3.948111e-01, -6.332429e-01,  3.810565e-01,  5.579371e-01, -2.989537e-01},
  { 4.123584e-01,  4.592297e-02, -9.098635e-01,  1.982778e-01,  5.151466e-01, -3.777197e-01},
  {-9.761871e-01, -2.169305e-01,  0.000000e+00,  2.003530e-01,  5.018759e-01, -3.899074e-01},
  { 7.351441e-01,  4.122398e-01, -5.381650e-01,  4.592208e-01,  5.293496e-01, -4.188192e-01},
  {-1.655089e-01,  7.875891e-01,  5.935572e-01, -6.314095e-02,  6.275524e-01, -3.995713e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  1.053941e-02,  6.115218e-01, -4.154730e-01},
  {-3.850983e-01,  7.776995e-01,  4.968730e-01, -2.273284e-01,  6.087101e-01, -4.630865e-01},
  { 8.097497e-03, -2.591389e-01, -9.658061e-01, -2.375666e-01,  6.101801e-01, -5.018796e-01},
  { 8.079958e-01,  4.981906e-01,  3.145615e-01,  8.303529e-02,  6.216383e-01, -5.053446e-01},
  { 2.523805e-01,  8.131360e-01,  5.245131e-01, -1.705621e-01,  6.211863e-01, -4.794126e-01},
  { 4.697442e-02, -4.582544e-02,  9.978444e-01,  9.538171e-02,  5.947686e-01, -5.172180e-01},
  {-6.633105e-01,  6.944646e-01, -2.788157e-01, -2.248017e-01,  5.809009e-01, -6.261300e-01},
  { 1.551418e-01,  4.037677e-01, -9.016111e-01,  2.445588e-01,  5.827461e-01, -7.099549e-01},
  { 4.115140e-02, -4.970863e-01, -8.667247e-01,  1.723525e-01,  5.587952e-01, -6.829453e-01},
  { 3.693471e-01, -2.107765e-01, -9.050723e-01,  1.653436e-02,  5.711573e-01, -7.306300e-01},
  {-8.048142e-01,  2.957616e-01, -5.145865e-01,  5.866813e-02,  5.603099e-01, -7.540027e-01},
  { 5.581456e-02,  8.930329e-01, -4.465165e-01,  3.640011e-02,  5.621881e-01, -7.513599e-01},
  { 8.051134e-01, -1.330079e-01, -5.780149e-01,  4.576199e-01,  5.457506e-01,  5.703028e-01},
  { 1.826434e-01,  8.144484e-01,  5.507407e-01,  5.526955e-03,  6.008367e-01,  6.545998e-01},
  { 4.160283e-01, -1.757935e-01, -8.921980e-01,  4.230798e-01,  5.411389e-01,  5.318424e-01},
  {-8.143805e-01,  5.800208e-01, -1.897680e-02,  2.707597e-01,  5.718686e-01,  4.861712e-01},
  { 8.758448e-01, -2.013712e-01,  4.385722e-01,  1.310561e-01,  5.452840e-01,  5.031972e-01},
  { 8.758448e-01, -2.013712e-01,  4.385722e-01,  2.119498e-03,  5.541120e-01,  4.424659e-01},
  {-2.972242e-01,  7.740970e-01,  5.589559e-01,  2.104747e-01,  5.520491e-01,  4.400875e-01},
  {-2.642723e-01,  5.609815e-01,  7.845125e-01, -6.016725e-02,  5.671389e-01,  4.356600e-01},
  {-5.554922e-01, -4.599649e-01,  6.927199e-01, -2.298498e-01,  5.197501e-01,  4.578095e-01},
  {-9.492345e-01, -3.674908e-02,  3.124153e-01, -2.752789e-01,  5.283061e-01,  4.173934e-01},
  { 1.854370e-02,  9.975950e-01,  6.678680e-02,  4.961264e-01,  6.104705e-01,  3.603681e-01},
  {-9.644756e-01, -9.724922e-02, -2.456205e-01, -2.689508e-01,  5.155623e-01,  3.248269e-01},
  { 4.314269e-01,  4.847435e-01, -7.608513e-01,  4.953111e-01,  5.979539e-01,  3.433855e-01},
  {-1.967388e-01,  2.500102e-02, -9.801371e-01, -6.232035e-02,  5.564951e-01,  2.457283e-01},
  {-2.174506e-01,  1.992663e-01, -9.555146e-01, -1.137327e-01,  5.650361e-01,  2.592917e-01},
  {-9.827084e-01, -1.410464e-01, -1.199589e-01, -2.297547e-01,  5.772322e-01,  1.675985e-01},
  {-4.107149e-01, -8.549716e-01, -3.167602e-01, -2.450608e-01,  5.797839e-01,  9.679758e-02},
  { 7.979869e-01,  4.456440e-01,  4.057318e-01,  3.230973e-01,  5.311190e-01,  9.953985e-02},
  {-5.129001e-01,  8.507579e-01,  1.146495e-01, -3.284077e-01,  5.634787e-01,  8.526609e-02},
  {-5.874120e-01, -6.672731e-01, -4.579234e-01,  4.132227e-01,  5.583902e-01, -4.253124e-03},
  {-5.299022e-01,  8.178982e-01,  2.241569e-01,  3.368157e-02,  6.089233e-01, -1.185654e-01},
  {-4.369599e-01, -8.490500e-01,  2.969512e-01,  4.150708e-01,  5.249490e-01, -1.751090e-01},
  {-9.624674e-02, -9.519342e-01,  2.907881e-01,  3.785811e-01,  5.467605e-01, -2.060600e-01},
  { 9.872907e-01, -8.794884e-02,  1.323709e-01,  5.301122e-01,  5.477116e-01, -2.904623e-01},
  { 9.716436e-01, -3.863643e-02,  2.332723e-01,  5.377000e-01,  5.528318e-01, -3.071962e-01},
  {-3.770757e-01,  6.030540e-01, -7.029507e-01,  4.016791e-01,  5.522993e-01, -3.010138e-01},
  { 4.370808e-01, -5.736398e-01, -6.927465e-01,  2.803718e-01,  4.913706e-01, -4.816462e-01},
  {-2.155046e-01, -6.568816e-01, -7.225402e-01,  1.989691e-01,  5.018075e-01, -5.062010e-01},
  { 2.621229e-01,  7.451729e-01,  6.131956e-01, -1.697112e-02,  6.402899e-01, -4.150165e-01},
  {-6.433243e-01,  7.473021e-01, -1.663533e-01, -8.901321e-02,  6.480781e-01, -4.635971e-01},
  { 0.000000e+00, -7.071068e-01, -7.071068e-01,  5.274111e-02,  6.515142e-01, -5.301111e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  6.086465e-02,  6.448147e-01, -5.317647e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  6.593356e-02,  6.397370e-01, -5.418901e-01},
  {-2.078329e-01,  8.448249e-01,  4.930278e-01, -1.453115e-01,  6.458176e-01, -5.098218e-01},
  { 7.559698e-01,  6.545489e-01,  8.690466e-03,  8.179546e-02,  6.233012e-01, -5.227410e-01},
  {-4.885695e-01,  8.565140e-01, -1.663840e-01, -2.258903e-01,  6.107967e-01, -5.595916e-01},
  { 8.395370e-01,  3.480945e-01,  4.171424e-01,  2.522873e-01,  5.791555e-01, -5.992843e-01},
  { 9.210964e-01,  2.702376e-01, -2.802732e-01,  2.762982e-01,  5.883846e-01, -6.752095e-01},
  {-7.583511e-01,  1.594012e-01, -6.320561e-01,  4.491989e-02,  5.922920e-01, -6.714518e-01},
  { 2.361436e-01, -8.364696e-01, -4.945248e-01,  1.180309e-01,  5.580902e-01, -7.582498e-01},
  {-2.337907e-01,  4.056787e-01,  8.836101e-01,  5.018256e-01,  6.122463e-01,  8.095222e-01},
  {-7.810453e-01,  6.098816e-01, -1.342107e-01,  1.079394e-01,  5.981200e-01,  6.638386e-01},
  { 7.974980e-01, -1.358837e-01, -5.878201e-01,  5.136073e-01,  5.787098e-01,  6.380494e-01},
  {-4.586226e-01,  7.757646e-01, -4.334218e-01,  2.689209e-01,  5.885515e-01,  5.613227e-01},
  { 9.728978e-01,  1.453391e-01,  1.798508e-01,  3.882875e-01,  5.703365e-01,  3.875443e-01},
  { 3.663456e-01, -6.011400e-01,  7.102265e-01,  1.997603e-01,  5.637360e-01,  4.432537e-01},
  {-1.749241e-01, -3.388896e-01,  9.244217e-01, -1.942511e-01,  5.581383e-01,  4.967584e-01},
  { 8.424828e-01, -5.149652e-01,  1.582199e-01,  4.869069e-01,  5.857996e-01,  3.162574e-01},
  {-3.454732e-01,  1.783851e-02, -9.382591e-01,  2.825014e-02,  5.684214e-01,  2.314103e-01},
  {-9.482345e-01, -3.159479e-01,  3.206499e-02,  5.804782e-02,  5.698607e-01,  1.957852e-01},
  {-6.515633e-01, -6.078741e-01, -4.538220e-01,  4.019378e-01,  5.650541e-01, -1.682126e-04},
  {-8.673565e-01,  3.692726e-01,  3.336625e-01,  5.747107e-02,  6.225049e-01, -8.768240e-02},
  {-8.763386e-01, -1.655421e-01,  4.523565e-01,  1.414909e-01,  5.882217e-01, -1.469360e-01},
  {-4.127545e-01, -6.654132e-01,  6.219799e-01,  1.399005e-01,  5.861121e-01, -1.762707e-01},
  {-7.987031e-01, -3.662821e-01, -4.774001e-01,  1.479671e-01,  4.992680e-01, -4.724889e-01},
  { 7.018763e-01, -4.846988e-01, -5.219548e-01,  3.234982e-01,  5.238209e-01, -4.634109e-01},
  {-4.156832e-01,  8.082675e-01, -4.170264e-01, -6.197862e-02,  6.627663e-01, -4.682202e-01},
  { 4.907064e-01,  8.299887e-01,  2.651904e-01,  3.374965e-02,  6.712076e-01, -4.952419e-01},
  {-6.956481e-01, -4.272054e-01,  5.775546e-01,  8.233554e-02,  6.315550e-01, -5.161695e-01},
  {-7.984640e-01, -5.117449e-01,  3.171315e-01,  7.309382e-02,  6.299897e-01, -5.421520e-01},
  { 5.975898e-01, -3.452105e-01, -7.236824e-01,  1.470245e-01,  5.839646e-01, -7.647375e-01},
  { 9.819974e-02, -4.841066e-02, -9.939885e-01,  1.281799e-01,  5.929095e-01, -7.753619e-01},
  { 9.901575e-01, -1.372198e-01, -2.754643e-02,  5.196325e-01,  5.871951e-01,  6.476256e-01},
  {-2.919384e-01,  1.664114e-01,  9.418489e-01,  3.790498e-01,  5.925106e-01,  6.563907e-01},
  { 7.930265e-01, -3.835725e-01, -4.732665e-01,  4.758226e-01,  5.707589e-01,  5.987185e-01},
  {-6.818314e-01, -1.789601e-01,  7.092807e-01,  2.931283e-01,  6.054292e-01,  4.994992e-01},
  { 1.752964e-01, -2.288420e-01,  9.575503e-01, -9.769114e-02,  5.900449e-01,  4.271522e-01},
  {-9.072353e-01,  2.953716e-01,  2.994656e-01, -2.676966e-01,  5.859433e-01,  4.061769e-01},
  { 9.528434e-01, -1.494316e-01,  2.641206e-01,  4.045454e-01,  5.949555e-01,  3.195884e-01},
  {-8.304287e-01,  1.103670e-01,  5.460837e-01, -2.599165e-01,  6.030539e-01,  2.724947e-01},
  { 2.146573e-01, -1.350309e-01,  9.673101e-01, -2.111313e-01,  5.939735e-01,  2.742320e-01},
  { 5.261842e-01,  1.242244e-01,  8.412482e-01,  4.573157e-01,  5.987309e-01,  1.617940e-01},
  {-9.796540e-01,  1.740678e-01, -9.989334e-02,  1.344067e-01,  6.077437e-01, -1.127899e-01},
  {-6.460180e-01,  8.318220e-02, -7.587763e-01,  4.019535e-01,  5.890578e-01, -2.937901e-01},
  {-9.489852e-01, -8.504100e-02,  3.036363e-01,  1.910004e-01,  5.658532e-01, -3.517411e-01},
  { 9.766014e-01, -2.143824e-01, -1.702728e-02,  3.702597e-01,  5.763667e-01, -3.620494e-01},
  {-9.690303e-01, -2.604225e-02, -2.455646e-01,  4.458628e-01,  5.766794e-01, -4.349964e-01},
  {-5.396316e-01,  3.536080e-02, -8.411584e-01,  1.414889e-01,  5.245345e-01, -4.810363e-01},
  {-2.841839e-01, -3.783276e-01, -8.809698e-01,  1.258855e-01,  5.384441e-01, -4.769842e-01},
  {-1.514219e-01,  8.220926e-03, -9.884350e-01,  2.215970e-01,  5.619646e-01, -5.106407e-01},
  {-1.760291e-01,  9.507702e-01, -2.550488e-01, -3.032818e-02,  6.668943e-01, -4.811293e-01},
  { 7.640706e-01, -6.383567e-01, -9.325661e-02,  8.644489e-02,  6.341152e-01, -5.000257e-01},
  { 1.526280e-01, -2.677404e-01,  9.513252e-01,  1.025753e-01,  6.529083e-01, -4.965076e-01},
  {-7.969983e-01, -1.791391e-01,  5.768042e-01,  6.772504e-02,  6.537786e-01, -5.030516e-01},
  {-7.827373e-01,  4.429991e-01, -4.371202e-01,  7.180770e-02,  6.173947e-01, -5.726734e-01},
  {-7.274649e-02,  6.934168e-01,  7.168550e-01, -7.377378e-02,  6.861203e-01, -5.476014e-01},
  { 6.682809e-01,  5.463762e-01,  5.048501e-01,  2.140054e-01,  6.201796e-01, -5.690327e-01},
  { 5.374536e-01,  2.391385e-01,  8.086757e-01,  1.403922e-01,  6.443576e-01, -5.114249e-01},
  {-7.827373e-01,  4.429991e-01, -4.371202e-01,  8.275292e-02,  6.134863e-01, -5.962336e-01},
  { 7.783986e-01,  4.570656e-01, -4.303331e-01,  2.481337e-01,  6.335694e-01, -6.720340e-01},
  {-4.729750e-01,  5.233789e-01, -7.087801e-01,  9.961352e-02,  6.161602e-01, -7.645305e-01},
  {-5.395877e-02, -3.896730e-01,  9.193712e-01,  2.695273e-01,  6.175318e-01,  7.500010e-01},
  { 7.867106e-01, -1.521463e-01,  5.982791e-01,  3.424473e-01,  5.987484e-01,  7.050810e-01},
  { 5.106145e-01, -7.817640e-01, -3.579353e-01,  4.675424e-01,  5.611506e-01,  5.250312e-01},
  {-9.161755e-02, -7.134824e-01,  6.946574e-01,  1.261964e-01,  5.783967e-01,  5.458113e-01},
  { 5.709528e-01, -7.834396e-01, -2.454287e-01,  3.977559e-01,  6.000425e-01,  4.519271e-01},
  { 9.557077e-01, -2.913339e-01,  4.180147e-02,  3.794096e-01,  5.878365e-01,  4.178036e-01},
  {-7.697677e-01,  6.313837e-01,  9.387340e-02,  4.130207e-02,  6.107274e-01,  4.564009e-01},
  {-7.478355e-01,  2.801543e-01,  6.018769e-01, -2.113570e-01,  6.020341e-01,  4.878381e-01},
  {-2.384204e-01,  1.541783e-01, -9.588456e-01, -1.836800e-01,  6.101499e-01,  3.160820e-01},
  { 4.472136e-01, -8.944272e-01,  0.000000e+00, -8.283678e-02,  6.124278e-01,  3.028334e-01},
  {-1.984887e-01,  2.684340e-01, -9.426269e-01, -8.587406e-02,  6.141143e-01,  3.053144e-01},
  {-7.170743e-01,  4.426200e-01, -5.384161e-01,  7.309888e-02,  6.006991e-01,  2.461398e-01},
  { 9.991247e-01, -4.045304e-02,  1.065211e-02,  4.689371e-01,  6.159086e-01,  1.519885e-01},
  { 1.856340e-01, -6.845761e-01, -7.049082e-01, -3.525275e-02,  5.639717e-01, -3.847687e-02},
  { 8.943781e-01,  4.119167e-01,  1.743914e-01,  3.095746e-01,  6.119243e-01, -2.733897e-02},
  {-2.888520e-01, -6.562023e-01,  6.971106e-01,  3.560090e-01,  5.808482e-01, -1.469627e-01},
  { 9.992148e-01, -2.433603e-02, -3.126335e-02,  5.459228e-01,  6.099085e-01, -2.190108e-01},
  { 7.952635e-01,  6.036443e-01,  5.629784e-02,  4.774021e-01,  5.942299e-01, -2.782674e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  1.768378e-01,  5.951958e-01, -2.654431e-01},
  {-3.645596e-01, -8.547448e-01,  3.694694e-01,  1.316793e-01,  5.364047e-01, -4.133496e-01},
  {-4.354258e-01, -8.926596e-01, -1.164610e-01,  9.113906e-02,  5.380367e-01, -4.203687e-01},
  {-5.595829e-01,  6.032356e-01, -5.683078e-01,  1.962048e-01,  6.159142e-01, -4.976835e-01},
  {-6.895083e-02,  5.838661e-01, -8.089167e-01,  2.181823e-01,  6.325782e-01, -4.985484e-01},
  { 3.729196e-02,  4.705668e-01, -8.815759e-01,  2.310411e-01,  6.185315e-01, -5.055861e-01},
  {-3.267290e-01,  2.543633e-01, -9.102458e-01,  1.169783e-01,  5.665743e-01, -4.756116e-01},
  {-4.338366e-01,  6.044573e-01, -6.681446e-01, -7.890961e-02,  6.864913e-01, -6.011215e-01},
  {-7.150377e-01,  6.344081e-01,  2.936790e-01,  1.007452e-01,  6.293654e-01, -6.034516e-01},
  {-2.684467e-01,  7.093739e-01,  6.517092e-01,  9.327132e-02,  6.249965e-01, -6.034036e-01},
  {-6.879365e-01,  6.769306e-01, -2.617407e-01,  1.098078e-01,  6.482285e-01, -5.995455e-01},
  {-8.588374e-01, -8.266307e-02,  5.055344e-01,  3.993832e-01,  6.457347e-01,  7.136518e-01},
  {-6.483581e-01,  6.090270e-01,  4.568566e-01,  1.957119e-01,  6.573135e-01,  7.284595e-01},
  {-8.882305e-01,  1.011163e-01,  4.481317e-01,  3.006601e-01,  6.415464e-01,  5.137181e-01},
  {-2.254538e-01, -7.981096e-01,  5.587411e-01,  1.048138e-01,  6.038901e-01,  5.683714e-01},
  { 3.705202e-01, -7.820281e-01, -5.011456e-01,  4.338941e-01,  6.086891e-01,  4.719307e-01},
  { 4.651695e-01, -1.197212e-01,  8.770884e-01,  2.539238e-01,  6.517212e-01,  5.389852e-01},
  {-9.094965e-01, -3.975244e-01,  1.216154e-01,  8.596091e-02,  6.217163e-01,  5.458410e-01},
  {-8.796741e-01, -6.978262e-02,  4.704294e-01,  7.821277e-02,  6.286541e-01,  5.134915e-01},
  {-6.583942e-01, -4.489227e-01,  6.041404e-01,  3.550795e-02,  6.243755e-01,  4.610389e-01},
  {-8.240560e-02, -7.836326e-01,  6.157346e-01,  3.142471e-02,  6.328039e-01,  4.738906e-01},
  {-7.102330e-01,  3.787342e-01,  5.934049e-01, -1.780429e-01,  6.259379e-01,  5.109569e-01},
  { 6.171712e-01, -5.013798e-01,  6.063976e-01,  1.961621e-01,  6.425334e-01,  4.261898e-01},
  { 5.323630e-02,  9.766792e-01, -2.079994e-01,  1.982744e-01,  6.497759e-01,  4.497595e-01},
  { 6.872986e-02,  9.921916e-01,  1.040771e-01,  1.584561e-01,  6.380867e-01,  3.959852e-01},
  {-9.224125e-01,  3.734858e-01, -9.830309e-02, -2.410173e-01,  6.344991e-01,  3.323019e-01},
  { 1.799269e-01,  9.098018e-03,  9.836379e-01,  3.945419e-01,  6.359487e-01,  2.974640e-01},
  { 8.794996e-01, -4.600421e-01,  1.218260e-01,  5.231993e-01,  6.317705e-01,  3.537359e-01},
  {-8.313381e-01, -5.555898e-01, -1.403239e-02, -2.598803e-01,  6.120340e-01,  2.052203e-01},
  {-6.933074e-01, -7.186098e-01, -5.408216e-02, -2.328597e-01,  6.077535e-01,  1.753404e-01},
  { 7.305627e-01,  6.826272e-01, -1.727274e-02,  3.161176e-01,  6.138206e-01,  5.545474e-02},
  {-7.728024e-01, -1.764910e-01, -6.096125e-01,  1.231786e-01,  6.174435e-01,  4.777369e-02},
  {-2.930524e-01, -5.929179e-01, -7.500458e-01, -8.540135e-02,  6.034787e-01,  3.235042e-02},
  { 6.807056e-01,  2.958470e-02, -7.319594e-01,  8.545524e-03,  6.072238e-01, -4.151387e-02},
  { 8.081274e-01,  1.013196e-01, -5.802279e-01, -2.809433e-03,  5.959693e-01, -5.672596e-02},
  {-2.706856e-01, -8.627199e-01, -4.271343e-01, -5.846158e-02,  5.730101e-01, -5.188910e-02},
  {-2.685161e-01, -8.103709e-01, -5.207670e-01, -5.774549e-02,  5.832748e-01, -6.597764e-02},
  {-7.808379e-01, -6.079816e-01,  1.437027e-01,  3.694763e-01,  6.139107e-01, -8.047234e-02},
  { 7.698081e-01,  2.441250e-01, -5.897446e-01,  5.415819e-01,  6.212123e-01, -2.308760e-01},
  {-4.112107e-01, -8.518687e-01,  3.243848e-01, -1.455994e-01,  5.681387e-01, -2.123591e-01},
  {-2.530617e-01, -9.288078e-01, -2.706950e-01, -5.726844e-02,  5.485391e-01, -2.755723e-01},
  { 2.808396e-01, -9.587731e-01,  4.339602e-02, -2.411586e-02,  5.575951e-01, -2.394014e-01},
  {-6.699345e-01, -5.955944e-01, -4.432324e-01, -1.561536e-01,  5.767420e-01, -2.299197e-01},
  { 1.073325e-01, -8.527122e-01, -5.112352e-01, -3.750642e-02,  5.538872e-01, -2.981988e-01},
  { 6.725001e-01,  5.596756e-02, -7.379778e-01,  3.598010e-01,  6.343427e-01, -2.916962e-01},
  {-3.159319e-01,  8.662131e-01, -3.871199e-01,  2.258313e-01,  6.625511e-01, -4.398516e-01},
  {-6.881088e-01, -1.729142e-01, -7.047035e-01,  5.487362e-02,  5.758362e-01, -4.155499e-01},
  { 8.758686e-01,  1.960720e-02, -4.821512e-01,  3.921667e-01,  6.294434e-01, -4.345535e-01},
  { 1.796747e-01,  3.686355e-01,  9.120443e-01,  1.033784e-01,  6.860672e-01, -4.979918e-01},
  { 1.254514e-01,  9.327850e-01,  3.378966e-01,  8.471236e-02,  7.013969e-01, -5.109289e-01},
  {-3.382573e-01,  9.320272e-01,  1.300277e-01, -5.260472e-02,  7.116824e-01, -5.748526e-01},
  {-6.883713e-01,  5.832658e-01, -4.312145e-01,  8.640071e-02,  6.950999e-01, -5.542064e-01},
  { 4.351541e-01,  3.725485e-01,  8.196636e-01,  4.787123e-02,  6.944165e-01, -6.038229e-01},
  {-2.169701e-02,  7.138919e-01, -6.999198e-01,  1.760373e-01,  6.877102e-01, -7.234524e-01},
  {-2.072288e-01,  3.223646e-01,  9.236543e-01,  4.558412e-01,  6.705541e-01,  7.828647e-01},
  {-8.565506e-01,  1.005607e-01,  5.061705e-01,  4.124725e-01,  6.648484e-01,  7.517385e-01},
  { 7.095363e-01, -2.550792e-01,  6.568812e-01,  3.408099e-01,  6.482642e-01,  7.499291e-01},
  { 9.576358e-01, -2.110060e-01,  1.959852e-01,  5.522285e-01,  6.255890e-01,  6.196454e-01},
  { 8.125694e-01, -5.477627e-01,  1.992161e-01,  5.482162e-01,  6.055775e-01,  6.032394e-01},
  { 8.274433e-01, -5.583017e-01, -6.030636e-02,  5.652135e-01,  6.015158e-01,  5.778916e-01},
  { 4.346499e-01, -4.960192e-01,  7.516944e-01,  1.948465e-01,  6.668473e-01,  6.071061e-01},
  {-2.534282e-01, -7.895535e-01,  5.589093e-01,  8.908828e-02,  6.249405e-01,  6.056285e-01},
  {-4.978193e-01, -8.512421e-01,  1.660204e-01,  6.363109e-02,  6.482761e-01,  5.153434e-01},
  {-5.122197e-01,  3.599438e-01,  7.797894e-01, -1.053115e-01,  6.552972e-01,  5.632456e-01},
  { 5.620623e-01,  4.894101e-01,  6.667562e-01,  1.177652e-01,  6.547727e-01,  3.583519e-01},
  { 9.182197e-01,  2.707945e-01,  2.890376e-01,  3.761291e-01,  6.412796e-01,  3.136744e-01},
  { 1.039180e-01, -5.564845e-02,  9.930278e-01,  1.516537e-01,  6.539997e-01,  3.318702e-01},
  {-3.561983e-01,  2.363891e-01, -9.040149e-01,  3.982611e-02,  6.227264e-01,  2.705206e-01},
  {-9.971530e-01,  7.441727e-02, -1.216309e-02,  6.983056e-02,  6.274439e-01,  2.505168e-01},
  { 5.648507e-02,  4.044837e-01,  9.127992e-01, -2.312866e-01,  6.510128e-01,  2.748128e-01},
  { 2.162916e-01,  3.355871e-01,  9.168420e-01, -1.580653e-01,  6.533533e-01,  2.595911e-01},
  { 7.045894e-01,  2.879616e-01,  6.485615e-01,  5.146757e-01,  6.376168e-01,  1.201743e-01},
  { 9.206964e-01,  1.180869e-01, -3.719860e-01,  3.005868e-01,  6.300509e-01,  3.999630e-02},
  {-5.042049e-01, -8.632534e-01, -2.390056e-02, -9.094822e-02,  6.095487e-01, -1.066759e-03},
  { 5.025974e-01,  2.340790e-01, -8.322276e-01,  2.340850e-02,  6.396390e-01, -1.135443e-02},
  { 2.765373e-01, -4.128633e-01, -8.677967e-01, -2.225825e-02,  6.072255e-01, -7.432429e-02},
  {-3.045695e-01, -7.777467e-01, -5.498614e-01, -9.456926e-02,  5.971258e-01, -7.539937e-02},
  { 8.695024e-01,  3.086289e-01,  3.856344e-01,  3.211243e-01,  6.347013e-01, -9.378609e-02},
  { 9.833207e-01,  8.377464e-03,  1.816869e-01,  5.019728e-01,  6.593765e-01, -1.429179e-01},
  {-8.885323e-01, -4.192089e-01,  1.864786e-01, -1.783581e-01,  6.060283e-01, -2.013511e-01},
  { 6.264284e-01,  4.946902e-01, -6.023862e-01,  4.626908e-01,  6.365480e-01, -2.460631e-01},
  { 9.980312e-01,  1.059398e-02,  6.181911e-02,  3.546691e-01,  6.484295e-01, -3.243562e-01},
  {-5.260050e-01, -8.059049e-01,  2.717278e-01,  1.205072e-02,  5.821066e-01, -3.483401e-01},
  { 3.508138e-01,  8.489064e-01, -3.953322e-01,  1.957352e-01,  6.523960e-01, -4.110832e-01},
  { 2.659922e-01,  2.600248e-01, -9.282431e-01,  3.820934e-01,  6.523027e-01, -4.323339e-01},
  { 8.557844e-01,  1.470837e-01,  4.959835e-01,  3.794508e-01,  6.676567e-01, -4.196322e-01},
  { 1.445181e-01,  1.585227e-01, -9.767216e-01,  3.859566e-01,  6.641979e-01, -4.298317e-01},
  {-3.069114e-02,  7.869916e-01, -6.161999e-01,  2.666899e-01,  6.788797e-01, -4.373379e-01},
  {-2.130207e-01,  3.966751e-01, -8.929004e-01,  1.727855e-01,  6.479368e-01, -4.356858e-01},
  {-2.662962e-02,  9.974140e-01,  6.675543e-02,  1.539681e-01,  6.948726e-01, -5.936152e-01},
  { 9.223948e-02,  9.796559e-01, -1.782306e-01,  1.150925e-01,  6.974460e-01, -5.592356e-01},
  { 3.153299e-01,  7.197540e-01,  6.184831e-01,  2.294313e-02,  7.171993e-01, -5.959601e-01},
  { 2.789650e-02,  8.337309e-01,  5.514659e-01,  8.145473e-02,  7.097310e-01, -6.480464e-01},
  { 4.159190e-01,  8.819091e-01,  2.219183e-01,  1.845232e-01,  7.064515e-01, -6.474585e-01},
  {-2.651707e-01,  8.459358e-01, -4.626846e-01, -1.220979e-02,  7.107823e-01, -6.415050e-01},
  { 8.048157e-01, -2.139538e-01,  5.536203e-01,  3.535294e-01,  6.705737e-01,  7.330771e-01},
  {-1.189818e-01,  4.812558e-01,  8.684677e-01,  4.142957e-01,  6.850753e-01,  6.397170e-01},
  { 1.501605e-02, -1.921445e-01,  9.812518e-01,  9.695973e-02,  6.687225e-01,  6.462996e-01},
  {-1.633794e-01, -6.834902e-01,  7.114409e-01,  7.501291e-02,  6.547560e-01,  6.371838e-01},
  { 4.423566e-01,  8.779522e-01,  1.830863e-01,  1.669013e-01,  7.010499e-01,  5.905389e-01},
  { 2.386400e-01,  3.327630e-01,  9.123156e-01,  2.910203e-01,  6.735991e-01,  4.827624e-01},
  {-1.358461e-01, -9.902128e-01,  3.200616e-02,  3.732495e-02,  6.509344e-01,  5.360095e-01},
  {-1.290746e-01, -6.413771e-01,  7.562903e-01, -3.365253e-02,  6.314715e-01,  5.666888e-01},
  { 5.449625e-01,  8.202835e-01, -1.736404e-01,  3.983993e-02,  6.814537e-01,  4.033641e-01},
  {-9.949149e-01,  2.156086e-02,  9.838413e-02, -7.148369e-02,  6.813828e-01,  3.998404e-01},
  {-5.603750e-01,  8.132533e-01,  1.568401e-01, -1.182529e-01,  6.875602e-01,  4.267402e-01},
  {-7.018246e-01,  4.169641e-01,  5.775665e-01,  1.375203e-01,  6.610704e-01,  3.364767e-01},
  { 4.269737e-01,  3.571130e-01,  8.307609e-01,  1.564148e-01,  6.745323e-01,  3.190962e-01},
  { 2.016895e-01,  1.860695e-01,  9.616129e-01,  5.294884e-01,  6.798067e-01,  3.384094e-01},
  {-7.383062e-01,  3.940332e-03,  6.744543e-01, -2.836972e-01,  6.548754e-01,  2.508438e-01},
  {-9.014826e-01,  2.637119e-01,  3.431984e-01,  6.148132e-02,  6.567584e-01,  1.873926e-01},
  { 3.419891e-02,  7.820565e-01,  6.222686e-01, -1.177327e-02,  6.547928e-01,  1.671755e-01},
  { 9.892140e-01, -1.323342e-01, -6.279577e-02,  2.930835e-01,  6.529453e-01, -9.068568e-03},
  {-3.795580e-02, -7.703075e-01,  6.365420e-01, -8.003688e-02,  6.110417e-01, -1.275669e-01},
  {-7.923212e-01, -1.007137e-01,  6.017340e-01, -1.622775e-01,  6.303213e-01, -1.612381e-01},
  {-9.348075e-01, -1.019296e-01, -3.402133e-01, -1.796764e-01,  6.275669e-01, -2.226332e-01},
  { 7.052721e-01, -4.442572e-02,  7.075434e-01,  4.795631e-01,  6.444590e-01, -2.904707e-01},
  { 8.579815e-02,  9.474378e-01, -3.082210e-01,  2.219420e-01,  6.822872e-01, -3.099143e-01},
  { 6.191245e-01, -7.727798e-01,  1.396295e-01, -7.810383e-02,  6.212846e-01, -3.294747e-01},
  {-1.738910e-01,  9.529191e-01, -2.484091e-01,  2.714977e-01,  7.020080e-01, -3.481274e-01},
  { 8.281070e-01, -5.639194e-02, -5.577264e-01,  5.377792e-01,  6.284500e-01, -3.439821e-01},
  {-5.956085e-01, -3.761661e-01, -7.097532e-01, -7.544883e-03,  6.271725e-01, -3.534910e-01},
  { 4.371738e-01,  4.148692e-01,  7.979741e-01,  1.421768e-01,  6.937926e-01,  6.479890e-01},
  { 7.103174e-01, -4.459925e-01, -5.445548e-01,  5.435533e-01,  6.331476e-01,  4.563248e-01},
  {-5.454363e-01, -6.691679e-01,  5.046914e-01,  2.238434e-02,  6.679556e-01,  6.208244e-01},
  {-2.932788e-01, -6.056259e-01,  7.397330e-01,  7.463396e-03,  6.598527e-01,  5.981503e-01},
  {-4.263845e-01,  3.719389e-01,  8.245348e-01, -5.187840e-02,  7.101340e-01,  5.668001e-01},
  {-6.538491e-01,  3.790077e-01,  6.548546e-01, -7.367206e-02,  6.782304e-01,  3.784013e-01},
  {-5.200252e-01,  7.174601e-01,  4.634920e-01, -1.779309e-01,  6.998879e-01,  4.042283e-01},
  {-7.985957e-01,  1.723882e-01,  5.766517e-01, -2.155354e-01,  7.038897e-01,  3.641529e-01},
  {-8.170567e-01,  9.146165e-03, -5.764848e-01, -2.298270e-01,  6.831343e-01,  3.060521e-01},
  { 3.554514e-01,  5.670243e-01,  7.430596e-01,  5.311570e-01,  7.113631e-01,  3.298722e-01},
  {-9.362182e-02,  5.352376e-01,  8.394972e-01,  4.564534e-01,  7.045916e-01,  3.253485e-01},
  { 9.941419e-01,  4.606481e-02,  9.777480e-02,  5.401450e-01,  7.237902e-01,  2.994691e-01},
  {-8.710711e-01,  1.249484e-02,  4.909979e-01, -3.115655e-01,  6.671078e-01,  2.177904e-01},
  {-3.389756e-01,  6.614485e-01,  6.690153e-01, -2.568314e-01,  7.335802e-01,  2.170715e-01},
  {-8.690451e-01, -4.795814e-01,  1.215003e-01, -3.153597e-01,  6.263757e-01,  1.723331e-01},
  { 9.386129e-01,  3.243494e-02,  3.434441e-01,  4.700539e-01,  6.912854e-01,  1.156144e-01},
  {-5.371693e-01, -8.380319e-01, -9.566416e-02, -3.030185e-01,  6.178914e-01,  6.908968e-02},
  {-1.121543e-01, -3.422660e-01, -9.328855e-01,  9.011289e-02,  6.601046e-01,  4.438823e-02},
  {-7.773196e-01, -5.562314e-01, -2.939061e-01, -3.234958e-01,  6.482649e-01,  1.482983e-02},
  {-2.346805e-01, -8.335174e-01, -5.001739e-01,  3.135852e-01,  6.625829e-01,  7.114642e-03},
  {-3.073364e-01, -6.750012e-01, -6.707590e-01, -2.408145e-01,  6.407088e-01, -4.388776e-02},
  { 2.450834e-02,  2.913762e-01, -9.562945e-01, -1.565276e-01,  6.413493e-01, -8.117426e-02},
  { 5.865963e-01, -4.432011e-01,  6.778479e-01,  3.248509e-01,  6.677259e-01, -9.182268e-02},
  {-5.333431e-01, -5.269848e-01,  6.616890e-01,  1.255660e-01,  6.467241e-01, -1.226472e-01},
  { 1.009144e-01, -9.029863e-01,  4.176504e-01,  1.466276e-03,  6.369441e-01, -1.394777e-01},
  {-8.011882e-01,  3.174624e-01,  5.072623e-01, -1.643658e-01,  6.666919e-01, -1.773380e-01},
  { 9.070024e-01,  2.778708e-01, -3.164404e-01,  5.354358e-01,  6.906840e-01, -2.062053e-01},
  {-6.637613e-01, -2.058035e-01, -7.190729e-01, -1.003149e-01,  6.615723e-01, -2.414386e-01},
  {-6.438144e-01,  7.651667e-01, -4.780805e-03,  1.246860e-01,  6.426595e-01, -2.208584e-01},
  {-7.846229e-01, -5.702847e-01,  2.431917e-01,  1.335905e-01,  6.460031e-01, -2.548074e-01},
  {-7.846229e-01, -5.702847e-01,  2.431917e-01,  2.204369e-01,  6.921124e-01, -2.755986e-01},
  {-1.210458e-01, -4.613923e-01, -8.788999e-01,  3.733981e-01,  6.902723e-01, -2.891818e-01},
  { 2.404542e-01, -7.362814e-01, -6.325121e-01, -8.350406e-03,  6.077248e-01, -3.394337e-01},
  {-4.472136e-01,  8.944272e-01,  0.000000e+00,  4.797213e-01,  6.604326e-01, -4.267538e-01},
  {-4.472136e-01,  8.944272e-01,  0.000000e+00,  4.728841e-01,  6.652789e-01, -4.266524e-01},
  { 1.243779e-01,  2.108228e-01, -9.695792e-01,  1.348681e-01,  6.788424e-01, -4.528686e-01},
  { 9.153345e-01,  1.634742e-01,  3.680204e-01,  5.339547e-01,  7.259704e-01,  7.289053e-01},
  {-8.625186e-02,  2.826578e-01,  9.553351e-01,  3.177897e-01,  7.287233e-01,  7.560484e-01},
  { 2.967691e-01,  8.093009e-01,  5.069124e-01,  1.239483e-01,  7.192242e-01,  6.303360e-01},
  {-3.734929e-01,  2.552365e-01,  8.918281e-01,  5.964151e-02,  7.097275e-01,  6.400652e-01},
  { 4.392068e-01,  8.750899e-01, -2.032608e-01,  7.298531e-02,  7.633820e-01,  5.563411e-01},
  {-7.553129e-01, -2.389164e-01,  6.102634e-01,  2.882547e-01,  6.995955e-01,  4.911879e-01},
  {-5.888422e-01,  6.924932e-01,  4.167950e-01, -8.465366e-02,  7.401915e-01,  5.192629e-01},
  { 1.633965e-02,  9.933431e-01,  1.140286e-01,  3.279053e-03,  7.775599e-01,  5.211931e-01},
  {-2.781170e-01,  9.066320e-01,  3.172845e-01, -2.315882e-02,  7.779897e-01,  5.188525e-01},
  { 6.324126e-01, -3.203757e-01, -7.052757e-01,  5.260771e-01,  6.568676e-01,  4.331739e-01},
  { 7.012014e-01, -5.163595e-01, -4.916192e-01,  5.138867e-01,  6.637912e-01,  4.171147e-01},
  {-5.729147e-01,  8.185289e-01, -4.218004e-02, -9.019125e-02,  7.516871e-01,  4.930737e-01},
  {-7.512652e-01, -4.612040e-01,  4.721138e-01, -8.420166e-02,  7.304739e-01,  4.275593e-01},
  {-1.735991e-01,  6.152648e-01,  7.689685e-01, -1.679861e-01,  7.298865e-01,  3.827011e-01},
  { 2.701751e-01,  4.967935e-01,  8.247434e-01, -1.084567e-01,  7.273889e-01,  3.499208e-01},
  {-3.691045e-01,  5.619017e-01,  7.402893e-01,  1.941128e-01,  7.138771e-01,  3.086735e-01},
  { 5.184889e-01, -1.923195e-01,  8.331761e-01,  1.557418e-01,  7.025969e-01,  3.098281e-01},
  {-5.254502e-01, -6.166654e-01, -5.861962e-01,  3.446731e-02,  6.818749e-01,  2.504400e-01},
  {-9.412316e-02,  6.384550e-01,  7.638822e-01,  4.423696e-01,  7.236079e-01,  2.715381e-01},
  { 1.204417e-01,  9.303129e-01,  3.464273e-01, -2.135500e-01,  7.466120e-01,  1.976700e-01},
  {-9.250935e-01,  3.493891e-01,  1.487593e-01, -3.174614e-01,  6.966102e-01,  8.797910e-02},
  {-8.509449e-01, -4.022820e-01, -3.377307e-01,  1.184706e-01,  6.746641e-01,  1.832223e-02},
  { 1.973569e-01, -8.713093e-01, -4.492998e-01,  2.972506e-01,  6.736028e-01, -1.812793e-02},
  {-5.931819e-01, -8.048370e-01, -1.929983e-02,  3.241719e-01,  6.741244e-01, -7.939135e-02},
  {-6.089063e-01, -4.732547e-01,  6.366028e-01,  1.298617e-01,  6.652040e-01, -1.048003e-01},
  {-1.553864e-01, -9.469233e-01,  2.814097e-01, -2.336602e-02,  6.403583e-01, -9.090497e-02},
  { 1.793986e-01, -7.536082e-01,  6.323692e-01,  6.766358e-03,  6.436591e-01, -1.348908e-01},
  { 4.375480e-01, -4.493663e-01, -7.788593e-01, -3.989305e-02,  6.844894e-01, -2.300532e-01},
  { 5.932510e-01, -5.574338e-01, -5.807934e-01,  3.630590e-01,  6.932080e-01, -2.991388e-01},
  {-9.043637e-01,  2.666439e-01, -3.332078e-01, -9.245154e-02,  6.988266e-01, -3.366735e-01},
  {-2.478387e-01, -9.660669e-01, -7.273740e-02,  3.692595e-01,  6.776294e-01, -3.539437e-01},
  {-5.393813e-02,  9.364269e-01, -3.466921e-01,  3.319259e-01,  6.814193e-01, -3.576967e-01},
  {-5.747383e-01,  1.598350e-01, -8.025762e-01, -6.933302e-02,  6.979594e-01, -3.633222e-01},
  {-1.429651e-01,  5.511531e-01, -8.220652e-01,  3.601651e-01,  6.814681e-01, -3.739407e-01},
  {-4.432533e-01,  3.326105e-01, -8.324043e-01,  3.645581e-01,  6.843827e-01, -3.738891e-01},
  { 7.047162e-01,  3.936774e-01, -5.902484e-01,  1.938496e-01,  7.179995e-01, -3.871653e-01},
  {-2.428431e-01,  2.072328e-01, -9.476718e-01,  7.657120e-02,  7.259627e-01, -4.163511e-01},
  { 5.894532e-01, -3.981230e-01, -7.028820e-01,  4.841647e-01,  6.660721e-01, -4.133861e-01},
  {-6.806685e-01, -3.853123e-02, -7.315776e-01,  4.719842e-01,  6.774880e-01, -4.159974e-01},
  {-7.836938e-01,  3.077006e-01,  5.395778e-01,  4.356722e-01,  7.555828e-01,  7.271234e-01},
  { 6.793475e-01,  3.001228e-01,  6.696367e-01,  3.590752e-01,  7.507051e-01,  7.254847e-01},
  {-9.606642e-01,  1.816060e-02, -2.771181e-01,  2.650822e-01,  7.140535e-01,  6.359581e-01},
  {-8.393643e-01, -8.585017e-02,  5.367470e-01,  4.194753e-01,  7.451233e-01,  6.128203e-01},
  { 6.505007e-02,  7.462003e-01,  6.625357e-01,  3.916525e-01,  7.512982e-01,  5.992035e-01},
  {-8.539768e-02,  8.513889e-01,  5.175367e-01,  5.213589e-02,  7.625418e-01,  5.958898e-01},
  { 9.986250e-01,  2.268645e-02, -4.725733e-02,  5.406343e-01,  7.088886e-01,  4.888057e-01},
  {-8.585696e-02,  9.601326e-01, -2.660336e-01, -6.564937e-02,  7.456027e-01,  4.289079e-01},
  { 9.231727e-01,  4.940787e-04, -3.843852e-01,  3.724439e-01,  7.034894e-01,  3.322171e-01},
  {-1.179629e-03,  5.588617e-01,  8.292599e-01,  4.187668e-01,  7.288889e-01,  2.440613e-01},
  {-5.382245e-01,  8.367234e-01,  1.010370e-01, -2.777780e-01,  7.394707e-01,  1.852102e-01},
  {-9.008752e-01, -3.821795e-01,  2.058222e-01,  5.114129e-02,  7.186982e-01,  1.323638e-01},
  { 7.861049e-02,  7.124186e-01,  6.973379e-01, -1.404837e-01,  7.436913e-01,  1.230638e-01},
  { 9.928073e-01, -1.196120e-01,  5.166633e-03,  4.842619e-01,  7.147185e-01,  8.169857e-02},
  { 5.394897e-02,  3.219520e-01,  9.452177e-01, -9.923041e-02,  7.461441e-01,  1.214549e-01},
  {-3.999610e-02,  4.408535e-01,  8.966876e-01, -1.820618e-01,  7.388054e-01,  1.113939e-01},
  {-5.528290e-01,  4.049934e-01,  7.282586e-01, -2.857609e-01,  7.313550e-01,  9.195569e-02},
  {-7.872671e-02, -6.267661e-01,  7.752202e-01, -2.500283e-01,  7.408831e-01,  1.061714e-01},
  { 9.607342e-01,  7.725882e-02,  2.664976e-01,  4.431594e-01,  7.074930e-01, -2.120542e-01},
  {-8.741961e-01,  3.358986e-01,  3.506470e-01, -3.660539e-03,  7.208992e-01, -2.239561e-01},
  {-8.664778e-01,  4.424084e-01,  2.312813e-01, -1.786972e-01,  7.155486e-01, -2.508037e-01},
  {-5.802331e-01,  5.644903e-01, -5.870948e-01,  2.413821e-01,  7.296449e-01, -2.380651e-01},
  {-5.901949e-01,  5.439559e-01, -5.964747e-01,  2.813374e-01,  7.020120e-01, -3.225300e-01},
  { 7.927011e-01, -5.399982e-01, -2.828904e-01,  3.753291e-01,  6.785943e-01, -3.715549e-01},
  {-2.795761e-01, -6.898264e-01, -6.678150e-01,  3.790499e-01,  6.766583e-01, -3.744053e-01},
  {-4.659708e-01, -8.293012e-01,  3.084328e-01,  2.526749e-01,  7.265430e-01,  4.721656e-01},
  {-5.102377e-02, -3.594758e-01,  9.317585e-01,  2.316181e-01,  7.203964e-01,  4.544823e-01},
  { 4.720732e-01,  8.224188e-01, -3.174495e-01,  8.658490e-03,  7.417791e-01,  4.047150e-01},
  { 7.057016e-01, -2.528147e-01,  6.618685e-01,  1.178642e-01,  7.224512e-01,  3.812512e-01},
  {-6.688466e-02,  4.859768e-01,  8.714087e-01, -1.597485e-01,  7.796311e-01,  3.457614e-01},
  {-9.917759e-01, -1.255265e-01,  2.497157e-02, -2.202380e-01,  7.678119e-01,  3.074163e-01},
  {-5.369319e-01, -8.220331e-01, -1.896468e-01, -1.740996e-01,  7.258880e-01,  2.359791e-01},
  {-2.393463e-01, -8.324403e-01, -4.997566e-01,  5.112221e-04,  7.066335e-01,  1.774583e-01},
  {-2.466637e-02, -2.146740e-01, -9.763743e-01, -1.956401e-01,  7.013311e-01, -5.105765e-02},
  { 9.723340e-01, -2.334626e-01, -7.858536e-03,  5.319111e-01,  7.494661e-01, -1.548386e-02},
  {-5.094302e-01, -8.596082e-01,  3.942779e-02,  1.148251e-01,  6.949709e-01, -5.740699e-02},
  {-5.045870e-02, -9.388093e-01,  3.407213e-01,  1.039783e-01,  6.943887e-01, -7.413876e-02},
  {-4.686005e-01, -5.784845e-01,  6.676595e-01, -8.073103e-02,  6.794170e-01, -6.302761e-02},
  {-8.936484e-01,  2.193410e-01,  3.915124e-01, -9.758439e-02,  6.813670e-01, -1.382738e-01},
  {-7.606740e-01,  9.271092e-02, -6.424793e-01, -1.712988e-01,  7.262278e-01, -2.712393e-01},
  {-3.946443e-01, -4.849796e-01, -7.804170e-01, -1.412570e-01,  7.163199e-01, -2.936283e-01},
  { 8.932706e-01,  2.276419e-01, -3.876171e-01,  5.401978e-01,  6.933274e-01, -3.202409e-01},
  { 8.680314e-01, -6.619918e-02, -4.920763e-01,  3.678652e-01,  7.241240e-01, -3.161338e-01},
  { 4.109820e-01, -8.774874e-01, -2.472039e-01,  3.704310e-01,  6.852434e-01, -3.795622e-01},
  { 4.698346e-01,  7.233142e-01, -5.060356e-01,  1.778707e-01,  7.778167e-01, -3.518179e-01},
  { 2.178151e-01,  3.716784e-01,  9.024477e-01,  4.857660e-01,  7.705159e-01,  7.451534e-01},
  { 5.963897e-01,  6.839516e-01,  4.201541e-01,  3.621955e-01,  7.758489e-01,  6.968538e-01},
  { 2.266580e-02,  9.712642e-01,  2.369220e-01,  3.720577e-01,  7.713967e-01,  5.492975e-01},
  { 1.151754e-01, -1.206707e-04,  9.933451e-01,  2.048050e-01,  7.589408e-01,  2.895299e-01},
  {-5.849670e-01, -4.702030e-01, -6.608500e-01, -1.835412e-01,  7.521913e-01,  2.116988e-01},
  {-6.254308e-01,  7.425375e-01, -2.397380e-01,  6.099093e-02,  7.583689e-01,  1.465517e-01},
  { 9.251437e-01, -3.777181e-01,  3.792360e-02,  5.172403e-01,  7.539406e-01,  8.511195e-02},
  { 4.717875e-01, -1.299632e-01, -8.720814e-01, -1.778416e-01,  7.171639e-01, -4.366630e-02},
  {-7.934799e-01, -1.259578e-01, -5.954193e-01, -2.976786e-01,  7.270446e-01, -4.804296e-02},
  {-1.642185e-01, -8.745705e-01,  4.562441e-01,  6.475773e-02,  7.021841e-01, -1.131481e-02},
  {-7.828782e-01, -8.193389e-02, -6.167564e-01,  2.289417e-01,  7.604861e-01, -2.217267e-01},
  { 1.633731e-03, -6.792572e-01, -7.338985e-01,  1.831679e-01,  7.615631e-01, -2.113835e-01},
  { 1.786412e-01,  7.031285e-01,  6.882570e-01,  1.091501e-01,  7.676966e-01, -2.426173e-01},
  { 4.878367e-02, -2.901660e-01, -9.557322e-01, -9.854475e-02,  7.465079e-01, -3.146605e-01},
  {-7.811005e-01,  6.242403e-01,  1.435307e-02,  1.825504e-02,  8.238156e-01, -2.915309e-01},
  { 1.500070e-01,  9.884886e-01, -1.970419e-02,  6.649705e-02,  8.395845e-01, -3.049878e-01},
  { 9.758244e-01,  2.113638e-01, -5.560739e-02,  5.370771e-01,  7.284337e-01, -2.923599e-01},
  {-4.863923e-01,  4.533651e-02, -8.725635e-01,  2.885922e-01,  7.116396e-01, -3.234433e-01},
  { 5.383088e-01, -8.121110e-01, -2.251650e-01,  5.034066e-01,  6.746029e-01, -4.102541e-01},
  {-4.923101e-01, -5.669540e-01, -6.604499e-01,  4.988810e-01,  6.836719e-01, -4.484459e-01},
  {-8.388827e-01,  2.694467e-02,  5.436448e-01,  4.188333e-01,  8.067170e-01,  6.784900e-01},
  { 6.615928e-01,  7.488692e-01, -3.859835e-02,  3.520629e-01,  7.984133e-01,  6.410805e-01},
  {-4.057418e-01,  2.449589e-01,  8.805502e-01,  2.107978e-01,  7.840520e-01,  6.773318e-01},
  { 9.699924e-01,  1.067019e-01, -2.184708e-01,  5.499958e-01,  7.873079e-01,  5.714738e-01},
  { 5.705379e-01,  8.209513e-01,  2.292285e-02,  3.256659e-01,  7.818467e-01,  5.561589e-01},
  { 9.913735e-01,  7.209271e-02,  1.094583e-01,  5.212028e-01,  7.606444e-01,  5.179428e-01},
  {-1.637360e-01, -7.703362e-02,  9.834919e-01,  3.567171e-01,  7.825052e-01,  5.188488e-01},
  { 8.121605e-01, -5.812784e-01,  5.010815e-02,  5.720091e-01,  7.397525e-01,  4.650059e-01},
  {-9.401891e-01,  2.487647e-01, -2.327240e-01,  1.444620e-01,  7.611656e-01,  4.388321e-01},
  { 3.733252e-01, -5.369385e-01,  7.565218e-01,  7.890728e-02,  7.496667e-01,  4.623977e-01},
  { 5.125825e-01, -4.604324e-01,  7.247490e-01,  7.782540e-02,  7.645196e-01,  4.722503e-01},
  {-3.008941e-01, -1.016180e-01,  9.482281e-01, -6.852414e-02,  8.046870e-01,  4.666195e-01},
  {-9.038292e-01,  1.357567e-01,  4.057867e-01, -1.197471e-01,  8.096041e-01,  4.315394e-01},
  {-3.781942e-01,  7.473176e-01,  5.463383e-01, -1.688260e-01,  8.264526e-01,  3.090758e-01},
  {-9.913585e-01,  5.252000e-02, -1.202083e-01, -2.283459e-01,  7.845978e-01,  2.636911e-01},
  {-8.510842e-01, -2.574918e-01, -4.575517e-01, -2.086448e-01,  7.796768e-01,  2.203305e-01},
  { 6.709479e-01,  2.955669e-01,  6.800508e-01,  5.297685e-01,  7.878056e-01,  2.573941e-01},
  {-5.038936e-01, -1.650070e-01, -8.478584e-01, -1.632882e-01,  7.829025e-01,  1.743364e-01},
  { 9.581280e-01,  7.628057e-02,  2.759930e-01,  5.404628e-01,  7.976472e-01,  2.266375e-01},
  {-1.806447e-01, -2.741947e-01, -9.445553e-01, -7.773738e-02,  7.616110e-01,  1.478984e-01},
  {-1.501928e-03,  2.140689e-01, -9.768174e-01, -3.048916e-02,  7.848542e-01,  1.454239e-01},
  { 9.195270e-02, -4.964367e-01, -8.631890e-01,  2.087890e-02,  7.414664e-01,  1.175631e-02},
  {-6.275652e-01, -7.570904e-01, -1.815931e-01,  6.207918e-02,  7.442747e-01,  9.321370e-03},
  { 1.661028e-01, -6.379275e-01, -7.519696e-01, -2.374450e-01,  7.176924e-01, -9.784474e-02},
  {-4.361434e-01,  1.385624e-01,  8.891453e-01, -9.200425e-02,  7.338991e-01, -5.462750e-02},
  {-4.459732e-01, -8.919336e-01,  7.458183e-02, -1.515464e-01,  7.093922e-01, -9.147643e-02},
  {-7.818654e-01,  6.024444e-01,  1.604596e-01,  1.465592e-02,  8.351375e-01, -2.546977e-01},
  {-3.677929e-01,  9.111302e-01, -1.859298e-01,  3.334756e-02,  8.448365e-01, -2.859967e-01},
  {-3.366503e-01, -6.812291e-02, -9.391623e-01,  3.825071e-01,  7.600030e-01, -3.075658e-01},
  { 9.873770e-01,  4.131221e-02, -1.529049e-01,  4.944795e-01,  7.103671e-01, -3.459290e-01},
  { 4.017218e-01, -9.098369e-01, -1.040017e-01,  3.710725e-01,  6.750136e-01, -4.053536e-01},
  {-5.895906e-01, -4.467802e-01, -6.728821e-01,  3.571245e-01,  6.795489e-01, -4.053688e-01},
  { 2.529822e-01,  9.486833e-01,  1.897367e-01,  4.995008e-01,  6.786373e-01, -3.891544e-01},
  {-4.028899e-01, -6.775047e-01, -6.153594e-01,  5.359158e-01,  6.782901e-01, -4.528202e-01},
  { 1.045276e-01,  9.010635e-01,  4.209021e-01,  2.762536e-01,  8.236008e-01,  6.610109e-01},
  { 1.624397e-02,  9.254391e-01,  3.785480e-01,  2.411325e-01,  8.286614e-01,  6.464975e-01},
  {-5.504448e-01, -3.024570e-01,  7.781584e-01,  1.765389e-01,  7.809361e-01,  6.576408e-01},
  {-5.605075e-01, -8.131143e-01,  1.570875e-01,  1.353543e-01,  7.746955e-01,  5.973518e-01},
  {-8.905110e-01, -3.675571e-02,  4.534746e-01,  1.208142e-01,  7.988835e-01,  6.142957e-01},
  {-8.337694e-01,  1.856672e-02,  5.518005e-01,  4.141207e-01,  8.065346e-01,  5.476097e-01},
  { 5.605519e-01,  6.629001e-01,  4.963315e-01,  3.202974e-01,  7.996138e-01,  5.158024e-01},
  { 9.282712e-01, -4.925133e-02, -3.686284e-01,  5.773697e-01,  7.570978e-01,  4.106222e-01},
  {-2.143915e-01, -4.458354e-01,  8.690610e-01,  3.767986e-03,  7.990634e-01,  4.862915e-01},
  {-2.620193e-01,  1.980177e-01,  9.445290e-01, -3.431676e-02,  8.062330e-01,  4.699552e-01},
  {-6.130455e-01,  6.432397e-01,  4.587133e-01, -1.126055e-01,  8.288376e-01,  4.318121e-01},
  {-8.942457e-01,  4.463074e-01, -3.368003e-02,  2.655722e-01,  7.928163e-01,  3.477495e-01},
  { 7.070521e-01, -5.087464e-01,  4.911767e-01,  1.223194e-01,  7.934608e-01,  3.750792e-01},
  {-4.283955e-01,  8.913329e-01, -1.483340e-01, -9.836423e-02,  8.435168e-01,  3.517002e-01},
  { 2.373239e-01,  9.263791e-01,  2.924022e-01, -1.115663e-01,  8.339635e-01,  3.024407e-01},
  {-1.190319e-01,  1.760264e-01,  9.771622e-01,  2.590547e-01,  8.001155e-01,  2.874416e-01},
  {-6.623796e-01,  4.302177e-01,  6.133236e-01, -2.154288e-02,  7.918090e-01,  2.817495e-01},
  {-6.876971e-01,  7.237672e-01,  5.686621e-02, -2.102920e-01,  8.174428e-01,  2.636878e-01},
  {-6.876971e-01,  7.237672e-01,  5.686621e-02,  2.385494e-01,  7.960029e-01,  2.764800e-01},
  {-8.069529e-01,  3.201425e-01, -4.963222e-01, -1.747596e-01,  8.319471e-01,  1.897428e-01},
  { 3.993600e-02,  6.969894e-01,  7.159685e-01,  4.472745e-01,  8.197972e-01,  2.237644e-01},
  { 3.226693e-01, -1.679059e-01, -9.315000e-01, -1.245901e-01,  7.609982e-01, -1.592233e-02},
  {-1.253796e-01, -2.578712e-01, -9.580096e-01, -2.470566e-01,  7.522843e-01, -1.110744e-01},
  { 5.081432e-01,  6.213309e-01, -5.964380e-01,  4.447832e-01,  7.916744e-01, -1.351106e-01},
  {-8.186262e-01, -4.502394e-01,  3.565610e-01, -1.974078e-01,  7.112343e-01, -1.529056e-01},
  { 2.120989e-01, -8.253533e-01, -5.232648e-01, -1.653131e-01,  7.298528e-01, -1.794914e-01},
  {-4.863849e-01,  5.181410e-01,  7.035336e-01,  3.624265e-02,  8.279245e-01, -1.992266e-01},
  { 6.388108e-01, -3.696315e-01,  6.747542e-01,  4.462973e-01,  7.657882e-01, -2.118634e-01},
  {-4.757089e-01, -7.444189e-01, -4.685527e-01,  2.183764e-01,  7.859244e-01, -2.416671e-01},
  { 4.776486e-01, -7.633574e-02, -8.752284e-01,  3.755706e-01,  7.866870e-01, -3.200487e-01},
  {-2.601274e-01,  7.759458e-01, -5.746666e-01,  4.289201e-02,  8.214167e-01, -3.556717e-01},
  { 9.516354e-01, -1.206288e-01,  2.825577e-01,  4.935074e-01,  7.403069e-01, -3.308875e-01},
  { 3.742615e-01, -3.753915e-01, -8.479443e-01,  3.988682e-01,  7.361941e-01, -4.155449e-01},
  { 8.830302e-01, -4.033369e-01,  2.399523e-01,  5.510447e-01,  7.251778e-01, -4.285040e-01},
  {-4.942197e-02,  4.872153e-01,  8.718823e-01,  4.974491e-01,  8.491738e-01,  7.093084e-01},
  { 7.145224e-01, -5.475875e-01, -4.354374e-01,  5.499941e-01,  7.699577e-01,  3.753318e-01},
  {-8.698845e-02,  6.675771e-01, -7.394416e-01, -2.075506e-02,  8.333713e-01,  4.928606e-01},
  { 3.766091e-01, -5.394842e-01, -7.530752e-01,  4.841191e-01,  7.530230e-01,  3.695504e-01},
  { 4.303192e-01, -3.117920e-01,  8.471193e-01,  1.042968e-01,  8.242691e-01,  4.920784e-01},
  {-2.172921e-01,  8.574250e-01,  4.664831e-01, -5.706222e-02,  8.526354e-01,  4.234292e-01},
  {-1.896114e-01, -3.292711e-01,  9.250016e-01,  2.102991e-02,  7.998932e-01,  3.318590e-01},
  { 9.405001e-01, -2.510686e-01, -2.289632e-01,  3.868976e-01,  7.866396e-01,  2.518914e-01},
  {-4.340433e-01, -9.986086e-02,  8.953403e-01, -1.033762e-01,  8.274164e-01,  2.311319e-01},
  { 6.318525e-02,  7.729391e-01,  6.313263e-01, -1.330590e-01,  8.685574e-01,  2.292367e-01},
  { 2.505498e-01,  5.850896e-01,  7.712944e-01,  5.090860e-01,  8.365883e-01,  2.313817e-01},
  { 9.791330e-01,  7.888790e-02,  1.872840e-01,  5.418764e-01,  8.437757e-01,  1.831020e-01},
  {-2.990534e-01,  8.204318e-01,  4.872974e-01,  4.578641e-01,  8.538411e-01,  1.915725e-01},
  {-2.044139e-01,  4.301551e-01, -8.793074e-01, -1.325730e-01,  8.404226e-01,  1.649238e-01},
  { 9.925108e-01,  8.871377e-03, -1.218340e-01,  5.443124e-01,  8.223717e-01,  1.164424e-01},
  { 9.531403e-01,  8.319952e-02, -2.908631e-01,  5.414215e-01,  8.285715e-01,  1.087426e-01},
  {-3.196384e-01, -1.087279e-01,  9.412808e-01,  1.252774e-03,  8.214529e-01,  1.076637e-01},
  {-9.683986e-02, -1.556552e-01,  9.830531e-01, -2.651411e-02,  8.313420e-01,  1.150010e-01},
  { 3.591798e-01, -3.988608e-01,  8.437417e-01, -2.102652e-01,  8.349881e-01,  1.434042e-01},
  {-1.497203e-01, -8.948856e-01, -4.204326e-01, -6.667997e-02,  7.891262e-01, -3.193678e-02},
  { 7.690095e-01,  5.657301e-01, -2.976134e-01,  5.363305e-01,  8.620783e-01, -7.308241e-02},
  { 7.907978e-01,  4.615423e-01, -4.020168e-01,  5.387168e-01,  8.572034e-01, -8.891758e-02},
  { 5.561128e-01,  4.141509e-01, -7.205676e-01,  5.185903e-01,  8.222407e-01, -1.239009e-01},
  {-2.713707e-01, -4.881230e-01, -8.295142e-01, -9.500358e-02,  7.963449e-01, -1.894450e-01},
  {-6.848537e-01, -6.103627e-01, -3.980362e-01, -2.152465e-01,  7.556612e-01, -1.919324e-01},
  {-5.427783e-01,  8.397825e-01, -1.253185e-02, -8.786967e-02,  8.108934e-01, -2.394850e-01},
  {-5.916497e-01, -1.029616e-01, -7.995934e-01, -2.029308e-01,  7.635862e-01, -2.321734e-01},
  {-6.145656e-01, -7.868016e-01, -5.703048e-02, -7.570893e-02,  8.046591e-01, -2.845210e-01},
  { 8.445237e-01, -2.666210e-01, -4.644274e-01, -5.949492e-02,  7.886092e-01, -3.011376e-01},
  { 6.469385e-01,  2.002128e-01, -7.357890e-01, -6.294975e-02,  7.906271e-01, -3.185554e-01},
  {-4.120231e-02,  8.544218e-01, -5.179439e-01, -8.165933e-02,  8.028510e-01, -3.124397e-01},
  {-4.412810e-01,  3.946626e-03, -8.973603e-01,  2.346142e-01,  7.953387e-01, -3.383748e-01},
  { 2.962886e-02, -3.126486e-01, -9.494067e-01,  5.509577e-01,  7.503174e-01, -4.997914e-01},
  { 8.259459e-01,  2.879135e-01,  4.846847e-01,  5.454781e-01,  8.664231e-01,  6.517367e-01},
  { 9.894586e-01, -1.447932e-01, -2.606238e-03,  5.251790e-01,  8.223913e-01,  5.447141e-01},
  {-4.227406e-01,  7.026892e-01,  5.722921e-01,  1.480519e-01,  8.537571e-01,  5.994399e-01},
  {-9.565245e-01,  1.599190e-01, -2.438991e-01,  1.192251e-01,  8.343202e-01,  5.661572e-01},
  { 9.552829e-01,  9.502361e-02,  2.800092e-01,  5.750319e-01,  8.236476e-01,  4.929640e-01},
  {-4.928603e-02,  9.780996e-01, -2.022176e-01,  5.221071e-02,  8.483880e-01,  4.978340e-01},
  { 5.963694e-01, -6.616347e-01, -4.545140e-01,  5.415551e-01,  7.744197e-01,  3.548035e-01},
  {-5.791135e-01,  1.530440e-01,  8.007529e-01,  8.467273e-02,  8.485025e-01,  3.361092e-01},
  { 3.595860e-01,  6.827708e-01,  6.360204e-01,  5.138433e-01,  8.702381e-01,  2.033229e-01},
  { 3.298493e-01,  9.411857e-01, -7.327419e-02,  3.985103e-01,  8.293452e-01,  1.543993e-01},
  {-8.704335e-01, -2.683848e-01,  4.126925e-01,  9.008122e-02,  8.262923e-01,  1.640550e-01},
  {-2.378465e-01,  8.812900e-01, -4.083590e-01,  5.008989e-01,  8.829201e-01,  1.196961e-01},
  {-3.162399e-01,  8.838404e-01,  3.447005e-01,  4.355528e-01,  8.402743e-01,  1.146707e-01},
  { 7.175866e-01, -3.271393e-01,  6.148571e-01,  5.393805e-01,  8.589857e-01,  1.151626e-01},
  { 9.951190e-01, -7.604177e-02,  6.289586e-02,  5.433085e-01,  8.452439e-01,  1.032669e-01},
  {-9.032337e-02,  8.199699e-01, -5.652353e-01,  5.019294e-01,  8.592153e-01, -9.962765e-02},
  {-4.801300e-01, -6.884951e-01,  5.435528e-01, -4.692339e-02,  7.816867e-01, -5.869936e-02},
  { 5.296170e-01, -4.412227e-01, -7.244504e-01,  4.640109e-02,  8.026435e-01, -1.514156e-01},
  {-2.615297e-01,  9.259955e-01,  2.722766e-01,  9.944572e-02,  8.475176e-01, -2.044800e-01},
  { 2.014609e-01, -6.323904e-01, -7.479946e-01, -1.879633e-01,  7.756574e-01, -2.401567e-01},
  { 9.838740e-01,  1.785285e-01, -1.093459e-02,  5.443479e-01,  7.966256e-01, -2.551016e-01},
  { 8.936154e-01,  3.093395e-01, -3.252085e-01,  4.874343e-01,  7.941426e-01, -2.762031e-01},
  { 3.201851e-01,  7.307878e-01, -6.028522e-01,  2.155422e-01,  8.051421e-01, -3.223690e-01},
  { 9.309289e-01, -2.349357e-01, -2.796007e-01,  3.828695e-01,  8.260902e-01, -3.262982e-01},
  { 8.709683e-01, -3.185805e-01,  3.740599e-01,  5.514433e-01,  7.585183e-01, -3.810498e-01},
  {-8.021702e-01,  6.937433e-02, -5.930517e-01,  5.169225e-01,  7.941483e-01, -4.864159e-01},
  {-2.972216e-01,  1.872409e-01, -9.362693e-01,  5.347031e-01,  7.948953e-01, -5.032904e-01},
  {-7.054995e-01,  5.623553e-01, -4.313084e-01,  1.534459e-01,  8.678479e-01,  5.468305e-01},
  { 9.469886e-01,  5.058958e-02,  3.172590e-01,  5.444479e-01,  8.226457e-01,  4.161855e-01},
  { 3.426463e-01, -4.517475e-01,  8.237219e-01,  5.367256e-01,  8.298563e-01,  4.233522e-01},
  { 8.974726e-01, -1.193659e-01,  4.246112e-01,  5.358594e-01,  8.409048e-01,  4.297718e-01},
  { 2.645307e-01, -6.892676e-01,  6.744876e-01,  1.699879e-01,  8.338618e-01,  4.434653e-01},
  {-6.534600e-01, -4.668227e-01,  5.958747e-01, -4.479540e-02,  8.277759e-01,  2.641022e-01},
  {-1.632447e-01,  2.842901e-01, -9.447383e-01, -1.169122e-01,  8.817675e-01,  2.094692e-01},
  {-1.803629e-01,  2.781947e-01, -9.434389e-01,  5.412796e-02,  8.488083e-01,  1.921948e-01},
  {-2.021712e-01,  5.429818e-01, -8.150445e-01, -1.411818e-01,  8.945552e-01,  2.191600e-01},
  {-8.470036e-01,  1.333401e-01, -5.145924e-01,  8.330347e-02,  8.343391e-01,  1.794426e-01},
  { 9.538958e-01,  2.962073e-01,  4.841593e-02,  5.444837e-01,  8.744850e-01,  1.562910e-01},
  { 3.016225e-03,  9.995009e-01,  3.144476e-02,  5.282453e-01,  8.990780e-01,  1.489316e-01},
  { 5.570418e-01,  3.787235e-01, -7.391028e-01,  5.247103e-01,  8.850320e-01,  1.209074e-01},
  {-1.265897e-01, -1.572866e-02,  9.918305e-01,  5.107534e-01,  8.776629e-01,  1.182085e-01},
  { 8.777567e-01,  2.319731e-01, -4.192035e-01,  5.462616e-01,  8.567290e-01,  1.158058e-01},
  { 7.176180e-01, -2.582654e-02,  6.959578e-01,  5.435758e-01,  8.716445e-01,  1.184357e-01},
  {-6.123479e-01,  3.946567e-01,  6.850374e-01,  4.223140e-01,  8.642718e-01,  9.777933e-02},
  {-6.870714e-01,  3.736255e-01,  6.231669e-01, -2.409424e-01,  8.634506e-01,  1.080556e-01},
  { 8.770325e-01,  3.518773e-01, -3.271030e-01,  5.391474e-01,  8.850907e-01, -2.743761e-02},
  { 1.543037e-01,  8.047027e-01, -5.732747e-01,  5.077158e-01,  8.865556e-01, -6.839000e-02},
  { 1.377383e-01, -9.698093e-01, -2.012413e-01, -1.337102e-01,  8.154575e-01, -8.673180e-02},
  { 5.137247e-01,  7.730238e-01, -3.721842e-01,  4.268479e-01,  8.491208e-01, -7.707059e-02},
  { 9.778837e-01,  1.275379e-01,  1.657636e-01,  4.230835e-01,  8.296053e-01, -1.446892e-01},
  {-5.019951e-01,  8.408279e-01,  2.025075e-01,  1.692004e-01,  8.395525e-01, -1.679301e-01},
  {-9.423740e-01, -2.190563e-01,  2.528749e-01, -2.221156e-01,  7.926396e-01, -1.511046e-01},
  {-7.457604e-01,  6.618573e-01,  7.606759e-02,  1.807270e-01,  8.731031e-01, -2.119162e-01},
  { 8.907430e-01, -3.193662e-01, -3.233916e-01, -1.267051e-02,  8.289179e-01, -2.089603e-01},
  {-7.916954e-02,  3.907712e-02, -9.960949e-01, -1.636711e-01,  8.165625e-01, -2.420372e-01},
  {-8.664225e-01,  2.033471e-01, -4.560283e-01, -2.013812e-01,  8.215773e-01, -2.252730e-01},
  {-6.741753e-01, -7.000691e-01, -2.353527e-01, -9.736671e-02,  8.195273e-01, -2.562580e-01},
  { 9.871709e-01, -1.589642e-01,  1.496673e-02,  5.438752e-01,  8.180880e-01, -2.159215e-01},
  { 7.523451e-01, -1.359308e-01, -6.445927e-01, -5.018274e-02,  7.830231e-01, -3.135716e-01},
  {-4.220517e-01,  9.041591e-01,  6.609533e-02,  1.322428e-01,  8.548788e-01, -3.063190e-01},
  { 1.607872e-01,  8.434255e-02, -9.833787e-01,  4.091569e-01,  8.525575e-01, -3.050999e-01},
  { 9.675480e-01, -2.480817e-01,  4.802265e-02,  5.619816e-01,  8.169758e-01, -3.614442e-01},
  { 4.316781e-02,  9.207904e-01,  3.876618e-01,  4.637590e-01,  9.175336e-01,  6.668543e-01},
  { 7.491102e-01,  5.822163e-01,  3.160035e-01,  5.479485e-01,  8.998325e-01,  6.199628e-01},
  {-6.537635e-01,  6.479197e-01,  3.908878e-01,  4.169357e-01,  9.175443e-01,  6.365948e-01},
  {-4.777088e-01, -5.369925e-01,  6.952938e-01,  3.684301e-01,  8.339678e-01,  5.944971e-01},
  { 3.095569e-02, -9.588537e-02,  9.949109e-01,  3.617387e-01,  8.507499e-01,  5.991558e-01},
  {-8.034483e-01,  5.061454e-01, -3.135089e-01,  2.783032e-01,  8.622789e-01,  4.495748e-01},
  { 8.854112e-01, -4.541925e-01,  9.877361e-02,  2.132301e-01,  8.316633e-01,  4.111172e-01},
  {-9.789315e-01, -1.735823e-01,  1.075274e-01,  1.452925e-01,  8.847606e-01,  4.302649e-01},
  { 9.297592e-01, -2.009269e-01,  3.085063e-01,  2.255823e-01,  8.350466e-01,  3.555999e-01},
  {-7.161756e-01, -5.595288e-01,  4.171571e-01,  1.348324e-01,  8.862593e-01,  3.954232e-01},
  { 4.452372e-01, -4.046072e-01, -7.987846e-01,  4.454515e-01,  8.318853e-01,  2.897177e-01},
  {-3.594142e-01,  9.299061e-01,  7.807757e-02, -2.003291e-01,  9.167494e-01,  6.294414e-02},
  { 9.855582e-01,  1.148312e-01, -1.244547e-01,  5.463430e-01,  8.997810e-01,  5.163358e-03},
  {-1.881621e-01,  6.843473e-01, -7.044600e-01,  4.619270e-01,  8.854946e-01, -1.733933e-02},
  {-5.675399e-02,  9.588165e-01, -2.782981e-01, -1.128678e-01,  8.750699e-01,  1.562027e-02},
  { 5.238953e-01,  8.444676e-01, -1.113918e-01,  4.195019e-01,  8.614060e-01, -4.096145e-02},
  { 2.135725e-01,  8.567634e-01, -4.694075e-01,  4.173416e-01,  8.627720e-01, -3.195817e-02},
  {-9.006423e-01,  4.343228e-01,  1.438803e-02, -2.423644e-01,  8.703318e-01, -6.490287e-02},
  { 8.765229e-02, -3.070835e-02, -9.956777e-01, -2.120654e-01,  8.010067e-01, -1.179263e-01},
  {-1.603193e-01,  3.598362e-01, -9.191385e-01,  1.626714e-01,  8.409307e-01, -1.424500e-01},
  { 5.731861e-01,  4.070387e-01, -7.111802e-01,  2.952598e-01,  8.493378e-01, -2.264549e-01},
  {-2.161940e-01, -3.393976e-01, -9.154613e-01, -5.599293e-02,  8.137444e-01, -3.268315e-01},
  {-8.358449e-01,  4.998767e-01, -2.269064e-01,  2.423951e-01,  8.624108e-01, -3.500008e-01},
  { 9.470631e-01,  1.813821e-02, -3.205348e-01,  5.669690e-01,  8.676922e-01, -4.750890e-01},
  {-5.177907e-01,  6.788735e-01,  5.205991e-01,  4.070644e-01,  9.095947e-01,  5.975702e-01},
  { 4.882942e-01, -4.702261e-01,  7.351572e-01,  3.383082e-01,  8.508502e-01,  6.241972e-01},
  {-9.153330e-01,  1.609076e-01,  3.691533e-01,  1.695354e-01,  8.946223e-01,  5.738444e-01},
  { 9.399747e-01,  2.744414e-01, -2.028038e-01,  5.496723e-01,  8.899699e-01,  4.618959e-01},
  { 1.732148e-01,  9.582216e-01,  2.276137e-01,  4.338680e-01,  8.884857e-01,  4.802856e-01},
  { 9.179711e-01,  1.367084e-01,  3.723437e-01,  5.388927e-01,  8.836237e-01,  4.316776e-01},
  { 4.810762e-01,  9.984509e-02,  8.709746e-01,  1.372037e-01,  8.886686e-01,  4.552906e-01},
  { 9.768870e-01, -2.075653e-01,  5.107364e-02,  5.774544e-01,  8.501757e-01,  3.706566e-01},
  { 7.259296e-01, -5.484902e-01, -4.149514e-01,  5.524076e-01,  8.202786e-01,  3.094366e-01},
  {-4.715729e-01, -2.687209e-01,  8.398857e-01,  8.232387e-02,  8.789496e-01,  3.426602e-01},
  {-8.707949e-01, -1.029453e-01, -4.807480e-01, -1.479413e-01,  8.950772e-01,  2.210206e-01},
  {-5.269291e-03,  6.166967e-01, -7.871832e-01, -5.604251e-02,  9.256122e-01,  2.098879e-01},
  {-2.427616e-01,  5.033692e-01, -8.292686e-01, -9.936337e-02,  9.067858e-01,  2.015160e-01},
  { 8.272371e-01,  4.958523e-02,  5.596608e-01,  5.482064e-01,  9.043611e-01,  1.163656e-01},
  { 2.574455e-03,  2.835826e-01,  9.589443e-01,  5.171881e-01,  9.250666e-01,  1.200633e-01},
  { 6.917321e-01, -5.590996e-01,  4.570715e-01, -1.426306e-01,  9.288521e-01,  1.558623e-01},
  {-1.556325e-02,  9.757144e-01,  2.184933e-01, -4.060117e-02,  8.949367e-01,  4.173214e-02},
  {-1.358135e-01,  6.297522e-01,  7.648313e-01, -6.549586e-02,  8.774557e-01, -6.266220e-03},
  {-1.090028e-03,  6.362522e-01,  7.714804e-01, -1.203577e-01,  8.920537e-01, -2.802807e-02},
  {-4.244339e-01,  0.000000e+00,  9.054589e-01, -9.758393e-02,  9.004202e-01, -1.598130e-01},
  { 6.020985e-01,  7.371093e-01, -3.068344e-01, -9.093870e-02,  8.975926e-01, -1.576573e-01},
  {-8.937899e-01,  2.231756e-01,  3.890143e-01, -1.008852e-01,  9.076579e-01, -1.767605e-01},
  { 8.960733e-01, -4.154166e-01,  1.564664e-01,  5.631515e-01,  8.619918e-01, -2.073355e-01},
  { 4.591412e-01, -3.790663e-01, -8.034289e-01, -1.678189e-02,  8.498978e-01, -3.351786e-01},
  {-4.182197e-01, -3.775872e-01,  8.261479e-01,  2.711791e-01,  8.932058e-01,  6.496937e-01},
  { 8.328223e-01,  5.518151e-01,  4.366885e-02,  5.429987e-01,  9.192076e-01,  5.244155e-01},
  { 5.279937e-01,  6.512100e-01,  5.451129e-01,  3.551524e-01,  8.913589e-01,  5.705412e-01},
  { 3.398025e-01,  8.920053e-01,  2.980956e-01,  5.021627e-01,  9.297017e-01,  4.520414e-01},
  { 1.070131e-01,  6.712215e-01,  7.334917e-01,  4.425264e-01,  9.021812e-01,  4.622662e-01},
  {-2.675459e-02, -6.160727e-01,  7.872348e-01,  1.741305e-01,  8.906628e-01,  5.038910e-01},
  { 6.994390e-01, -4.307653e-01,  5.702863e-01,  2.224490e-01,  8.753841e-01,  4.555313e-01},
  {-7.384288e-01,  5.658516e-02,  6.719532e-01, -7.452284e-02,  8.895795e-01,  3.347609e-01},
  {-9.085705e-01, -1.270650e-02,  4.175382e-01, -1.416103e-01,  8.964248e-01,  2.530802e-01},
  {-2.765653e-01,  2.056952e-01,  9.387232e-01,  2.249455e-01,  8.727762e-01,  2.745355e-01},
  {-7.430650e-01,  6.202087e-01, -2.513874e-01, -1.377115e-01,  9.194562e-01,  2.268671e-01},
  {-9.171284e-01,  2.359292e-01, -3.212678e-01,  1.014786e-01,  8.800294e-01,  1.684065e-01},
  {-1.353605e-01,  7.381258e-01,  6.609446e-01, -1.869100e-02,  9.211931e-01,  1.643140e-01},
  {-3.162278e-01,  0.000000e+00, -9.486833e-01, -8.949075e-02,  9.353169e-01,  1.485534e-01},
  {-3.495558e-01,  4.575430e-01,  8.175972e-01,  4.753061e-01,  9.461396e-01,  1.004315e-01},
  { 6.469863e-01,  5.894998e-01, -4.836308e-01,  5.330546e-01,  9.574753e-01,  4.545718e-02},
  {-5.654899e-01,  8.002089e-01,  1.997172e-01, -2.704799e-02,  9.023691e-01,  5.307757e-02},
  { 1.849878e-01, -8.240775e-01, -5.354211e-01, -3.023059e-02,  9.049628e-01,  4.052055e-02},
  { 3.293473e-01, -6.379696e-01, -6.960784e-01, -2.790134e-02,  9.197809e-01,  1.851841e-02},
  {-2.468427e-01,  7.649162e-01,  5.949553e-01, -1.874929e-01,  9.468328e-01, -5.452950e-02},
  {-3.268376e-01,  1.740534e-01,  9.289148e-01, -1.375409e-01,  9.571373e-01, -6.419653e-02},
  { 9.619942e-01, -3.438048e-04,  2.730699e-01,  4.106873e-01,  8.715080e-01, -9.374040e-02},
  {-6.954992e-01,  3.256006e-01, -6.405194e-01,  2.005098e-01,  8.823620e-01, -1.402448e-01},
  { 1.975682e-04,  9.519043e-01, -3.063953e-01, -3.705747e-02,  8.904131e-01, -1.251789e-01},
  {-2.102855e-01,  8.175496e-01,  5.360901e-01, -6.152839e-02,  8.906726e-01, -1.586678e-01},
  {-6.652088e-01,  4.649218e-01, -5.842474e-01, -1.951902e-01,  9.201074e-01, -1.936777e-01},
  { 6.403248e-02,  4.808849e-01, -8.744425e-01,  2.283511e-01,  9.434561e-01, -2.539822e-01},
  { 6.234155e-01, -6.768991e-01, -3.913576e-01, -5.193005e-03,  8.769887e-01, -2.437248e-01},
  {-3.565865e-02,  3.560881e-01, -9.337718e-01, -1.542462e-01,  9.083324e-01, -2.394603e-01},
  { 5.380302e-01, -3.211571e-01, -7.793469e-01,  2.390822e-01,  9.193994e-01, -2.591493e-01},
  { 5.380302e-01, -3.211571e-01, -7.793469e-01,  2.102158e-01,  9.252289e-01, -2.814797e-01},
  { 5.738269e-01,  2.941470e-01, -7.643300e-01,  4.649088e-01,  8.790427e-01, -2.230051e-01},
  {-6.600517e-01,  3.184721e-02, -7.505448e-01, -1.111928e-01,  8.956837e-01, -3.146662e-01},
  { 8.391718e-01, -3.544528e-01,  4.124970e-01,  4.436803e-01,  8.886312e-01, -3.856099e-01},
  {-1.335999e-01, -1.057629e-01,  9.853758e-01,  3.003782e-01,  8.977786e-01,  6.583279e-01},
  {-4.958393e-01,  3.699209e-01,  7.856857e-01,  2.252939e-01,  9.257540e-01,  6.186408e-01},
  {-8.927069e-01,  4.460850e-01,  6.389584e-02,  2.669634e-01,  9.195625e-01,  3.739558e-01},
  {-5.085357e-01, -4.250135e-01,  7.488357e-01,  1.076308e-01,  9.130473e-01,  4.963059e-01},
  { 9.538559e-01,  2.388339e-01, -1.819814e-01,  5.772646e-01,  8.896409e-01,  3.616896e-01},
  { 2.628082e-01, -5.276932e-01, -8.077572e-01,  4.479561e-01,  8.834493e-01,  2.633463e-01},
  {-9.182101e-01,  3.929672e-01,  4.966762e-02,  1.159043e-02,  9.503509e-01,  3.000725e-01},
  { 6.508281e-01, -6.374626e-01, -4.123886e-01,  4.137541e-01,  8.866608e-01,  2.311226e-01},
  { 2.479963e-02,  6.946144e-01, -7.189547e-01,  3.538682e-02,  9.270378e-01,  2.454627e-01},
  {-1.169815e-02,  9.813408e-01, -1.919200e-01, -4.994934e-02,  9.516247e-01,  2.316893e-01},
  { 6.276999e-02, -5.663596e-01,  8.217643e-01,  1.013961e-01,  8.838930e-01,  1.507051e-01},
  {-4.575911e-01,  8.344136e-01,  3.071879e-01, -2.286341e-03,  9.134770e-01,  1.103672e-01},
  { 2.866100e-01,  7.334422e-01,  6.163741e-01,  5.343274e-01,  9.567255e-01,  9.522961e-02},
  { 7.092940e-01,  7.046111e-01, -2.062339e-02,  5.476480e-01,  9.563034e-01,  6.915957e-02},
  {-9.551365e-01, -1.995330e-01,  2.188626e-01, -3.658586e-02,  9.119826e-01,  2.021789e-02},
  {-4.521455e-01,  4.408551e-01,  7.753782e-01, -1.120241e-01,  9.955438e-01, -3.433552e-02},
  {-4.925023e-01,  7.402375e-01,  4.577008e-01, -1.696079e-01,  9.910070e-01, -8.572527e-02},
  {-8.852103e-01,  2.762564e-01, -3.742795e-01, -2.010318e-01,  9.697851e-01, -1.221604e-01},
  {-7.503798e-01,  2.618076e-01, -6.069489e-01,  2.092218e-01,  9.157610e-01, -1.507383e-01},
  { 3.995901e-01,  5.756738e-01, -7.133915e-01, -1.180534e-01,  9.827797e-01, -1.596413e-01},
  { 7.014293e-01, -5.640305e-02, -7.105038e-01,  1.493668e-01,  8.959901e-01, -1.742819e-01},
  {-3.920452e-01,  8.002354e-01, -4.537884e-01, -1.823095e-01,  9.755046e-01, -1.608460e-01},
  { 7.698547e-01,  4.657399e-01, -4.363601e-01,  2.838579e-01,  9.104903e-01, -1.845557e-01},
  {-9.805993e-01,  1.636478e-01, -1.079083e-01,  3.041125e-01,  9.172274e-01, -2.476911e-01},
  {-8.258637e-01,  5.580347e-01, -8.090981e-02, -1.306189e-01,  9.402394e-01, -2.634359e-01},
  { 7.655900e-01, -2.022025e-01, -6.107259e-01,  7.271057e-03,  8.895648e-01, -3.368250e-01},
  {-6.625180e-01,  4.217726e-01, -6.190136e-01,  4.996900e-01,  9.256057e-01, -3.311545e-01},
  { 2.175078e-01,  4.283929e-01, -8.770233e-01,  5.671895e-01,  9.419819e-01, -4.238605e-01},
  {-8.588176e-02,  6.095089e-01, -7.881137e-01,  5.509558e-01,  9.403802e-01, -4.368135e-01},
  { 8.237758e-01,  4.709892e-01, -3.155357e-01,  5.810545e-01,  8.997921e-01,  3.757495e-01},
  {-7.446281e-01, -3.307857e-01,  5.797498e-01,  8.605558e-02,  9.305953e-01,  4.819010e-01},
  { 9.964370e-01, -1.283779e-02,  8.335775e-02,  5.635247e-01,  9.052804e-01,  3.015487e-01},
  {-7.369490e-01,  3.136761e-01,  5.987599e-01, -2.923594e-02,  9.416238e-01,  3.959790e-01},
  {-6.243546e-01,  4.703754e-01,  6.236413e-01,  2.862403e-01,  9.255064e-01,  3.083838e-01},
  { 8.984932e-01, -2.143459e-01,  3.831000e-01,  2.048485e-01,  8.935377e-01,  3.074334e-01},
  { 2.794240e-01, -9.189817e-01, -2.781993e-01,  4.555407e-01,  9.031432e-01,  2.502056e-01},
  {-3.234119e-01,  9.342613e-01, -1.502018e-01, -9.357893e-02,  9.467260e-01,  2.552046e-01},
  {-5.428475e-01,  8.384320e-01,  4.846089e-02, -1.156266e-01,  9.342118e-01,  2.541044e-01},
  {-5.569379e-01,  2.535876e-01,  7.908941e-01,  4.117426e-02,  9.275591e-01,  1.213894e-01},
  {-2.388881e-01,  9.399589e-01,  2.437413e-01,  4.751149e-01,  9.691155e-01,  7.147533e-02},
  { 1.678620e-02, -9.922453e-01,  1.231557e-01, -5.214624e-02,  9.220142e-01,  2.178831e-02},
  {-7.244135e-01, -5.489574e-01,  4.169782e-01, -4.118560e-02,  9.225045e-01,  9.736799e-03},
  { 7.439100e-02,  8.278189e-01, -5.560412e-01,  1.390390e-02,  9.358568e-01, -2.124888e-02},
  {-8.540738e-01, -1.854903e-01,  4.859541e-01,  4.953537e-02,  9.256102e-01, -5.598540e-02},
  {-6.419858e-01,  7.656182e-01,  4.102515e-02, -1.898530e-01,  9.919395e-01, -1.084096e-01},
  { 4.093820e-01, -5.496485e-01,  7.282121e-01,  4.613397e-01,  9.144360e-01, -1.249021e-01},
  { 8.997731e-01, -4.257461e-01, -9.564871e-02,  5.862815e-01,  9.230254e-01, -1.894323e-01},
  { 6.764015e-01, -4.405454e-01, -5.902548e-01,  1.328576e-01,  9.231812e-01, -2.306042e-01},
  {-8.184299e-01,  4.670078e-01,  3.347777e-01, -8.669735e-02,  9.563436e-01, -2.303649e-01},
  {-7.962048e-01,  4.048187e-01, -4.496440e-01,  3.143705e-01,  9.370257e-01, -2.662108e-01},
  {-8.812039e-01,  4.103595e-01, -2.347013e-01, -1.170789e-01,  9.565679e-01, -2.857201e-01},
  { 7.295598e-01, -3.467924e-01,  5.894723e-01,  5.696636e-01,  9.249207e-01, -2.961891e-01},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  4.549074e-01,  9.137100e-01, -3.912283e-01},
  { 7.646251e-01, -5.878226e-01,  2.642216e-01,  3.619057e-01,  9.335499e-01,  5.525770e-01},
  { 6.259289e-01,  3.155339e-01,  7.131980e-01,  3.891176e-01,  9.203112e-01,  5.140111e-01},
  { 9.016935e-01, -4.171792e-02,  4.303585e-01,  5.788473e-01,  9.305921e-01,  4.159612e-01},
  {-2.358945e-02,  9.523414e-01,  3.041206e-01,  1.784877e-02,  9.830000e-01,  4.107623e-01},
  { 8.401951e-01,  4.957058e-01, -2.198818e-01,  5.475091e-01,  9.224983e-01,  3.220644e-01},
  {-8.087968e-01,  5.842040e-01, -6.747862e-02,  1.160926e-01,  9.710577e-01,  3.844094e-01},
  {-7.188427e-01,  6.911704e-01, -7.448984e-02,  1.209699e-01,  9.480249e-01,  3.621801e-01},
  {-7.964854e-01,  5.850419e-01,  1.527652e-01,  3.124114e-01,  9.425495e-01,  3.163823e-01},
  {-4.189791e-01,  9.030237e-01,  9.489355e-02,  1.165297e-02,  1.013217e+00,  3.639776e-01},
  { 4.068565e-01, -5.334638e-01, -7.415417e-01,  4.542383e-01,  9.248229e-01,  1.593846e-01},
  { 4.068565e-01, -5.334638e-01, -7.415417e-01,  8.364096e-02,  9.232627e-01,  1.761852e-01},
  { 4.035040e-01,  6.853644e-01, -6.061850e-01,  8.179286e-02,  9.349620e-01,  1.351926e-02},
  {-3.701620e-01,  9.289148e-01, -9.870125e-03,  8.973472e-02,  9.577532e-01,  3.189426e-02},
  {-2.294427e-01, -6.096877e-01, -7.587075e-01, -6.932025e-02,  9.384158e-01, -1.035499e-02},
  {-3.583559e-01, -6.875563e-01, -6.315438e-01, -2.209216e-02,  9.549997e-01, -2.339273e-02},
  {-3.583559e-01, -6.875563e-01, -6.315438e-01, -4.737983e-02,  9.565688e-01, -1.075211e-02},
  { 4.904169e-01,  8.581840e-01, -1.516949e-01, -6.012231e-02,  9.872854e-01, -1.907565e-02},
  { 1.153221e-01,  9.864808e-01, -1.164325e-01, -1.336381e-01,  1.014384e+00, -1.034412e-01},
  {-6.640091e-01, -4.246818e-02,  7.465175e-01,  9.676842e-03,  9.468255e-01, -1.271588e-01},
  {-7.227601e-01,  4.156384e-01, -5.521435e-01,  2.295649e-01,  9.589703e-01, -2.393250e-01},
  { 7.949290e-01, -3.529339e-02, -6.056750e-01,  5.913302e-01,  9.355252e-01, -2.030945e-01},
  { 9.996436e-02, -1.281361e-01, -9.867058e-01,  1.019585e-01,  9.482163e-01, -2.729259e-01},
  { 1.004142e-01, -1.094365e-01, -9.889088e-01,  8.068080e-02,  9.333824e-01, -2.702429e-01},
  { 5.748841e-01, -3.326945e-01, -7.475445e-01,  5.864016e-02,  9.160798e-01, -2.739241e-01},
  { 9.069938e-01,  3.369555e-01, -2.526325e-01,  4.526569e-01,  9.232836e-01, -2.064958e-01},
  {-7.006106e-01,  3.093506e-02, -7.128729e-01,  3.122994e-01,  9.481412e-01, -2.627268e-01},
  { 9.040561e-01, -3.757817e-01, -2.036434e-01,  4.244927e-01,  9.433042e-01, -2.995956e-01},
  { 8.675901e-01, -4.161433e-01,  2.722353e-01,  4.526711e-01,  9.428785e-01, -3.900482e-01},
  { 9.565169e-01,  1.207252e-01, -2.655202e-01,  5.847974e-01,  9.728352e-01, -4.039852e-01},
  { 1.922477e-01,  1.113997e-01,  9.750031e-01,  3.334001e-01,  9.859720e-01,  6.320214e-01},
  {-4.972654e-01,  6.784959e-01,  5.407129e-01,  2.663352e-01,  9.917091e-01,  5.928704e-01},
  {-2.768885e-01,  2.274650e-01,  9.335911e-01,  1.505784e-01,  9.724988e-01,  5.208195e-01},
  { 3.460468e-01,  8.557021e-02,  9.343068e-01,  5.022232e-01,  9.570131e-01,  4.303908e-01},
  { 8.178588e-01, -1.087701e-02,  5.753163e-01,  2.206712e-01,  9.831498e-01,  5.096764e-01},
  { 9.098099e-01, -3.712842e-01,  1.854561e-01,  2.120171e-01,  9.456715e-01,  3.624706e-01},
  { 9.098099e-01, -3.712842e-01,  1.854561e-01,  1.009220e-01,  9.423796e-01,  3.196092e-01},
  { 5.410963e-01,  7.275940e-01,  4.216891e-01,  9.420533e-02,  9.586225e-01,  3.109780e-01},
  { 6.668239e-01, -4.360420e-01, -6.043288e-01,  5.759249e-01,  9.226699e-01,  2.301081e-01},
  { 2.196210e-01,  7.700171e-01,  5.990328e-01,  1.070158e-01,  9.627624e-01,  2.901929e-01},
  { 2.196210e-01,  7.700171e-01,  5.990328e-01,  6.373068e-02,  9.438425e-01,  2.285949e-01},
  {-5.022730e-01, -7.888173e-01,  3.542446e-01,  2.585373e-02,  9.507443e-01,  1.143581e-01},
  { 9.335008e-01,  3.069998e-01,  1.852764e-01,  3.380604e-01,  9.343563e-01,  9.764422e-02},
  {-5.179860e-02, -6.720366e-01,  7.387040e-01, -5.250656e-02,  9.503070e-01,  7.658976e-02},
  { 9.550324e-01,  2.728557e-01,  1.160302e-01,  3.736803e-01,  9.329032e-01, -2.329178e-02},
  { 2.720780e-01, -8.772938e-01,  3.953848e-01,  4.760273e-01,  9.461758e-01, -8.704879e-02},
  { 9.866835e-02, -8.384689e-01,  5.359428e-01,  5.058845e-01,  9.537216e-01, -1.083894e-01},
  { 9.611113e-01, -2.697695e-02,  2.748407e-01,  4.521529e-01,  9.468115e-01, -1.897068e-01},
  { 3.455704e-01,  2.253487e-01, -9.109331e-01,  1.165757e-01,  9.639542e-01, -2.710113e-01},
  { 1.512334e-01,  6.918846e-01, -7.059916e-01,  4.519362e-02,  9.678292e-01, -2.447882e-01},
  {-5.861061e-01,  5.564461e-01, -5.889375e-01,  3.709626e-01,  9.681711e-01, -2.993703e-01},
  {-2.891458e-01,  4.066883e-01, -8.666022e-01, -5.579763e-02,  9.809312e-01, -3.266208e-01},
  { 2.496107e-01, -8.909523e-01,  3.793395e-01,  4.442374e-01,  9.532622e-01,  5.753374e-01},
  {-7.395697e-01,  2.965056e-01,  6.042525e-01,  1.444594e-01,  1.036513e+00,  4.924349e-01},
  {-9.172296e-01,  3.410525e-01, -2.058472e-01,  1.182048e-01,  1.032130e+00,  2.761017e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  3.790747e-02,  1.015084e+00,  3.400988e-01},
  {-6.516806e-01,  7.476544e-01,  1.277700e-01,  2.155749e-02,  1.007835e+00,  3.406508e-01},
  { 2.909269e-01,  6.104793e-01,  7.366659e-01,  1.083108e-01,  9.982063e-01,  2.639828e-01},
  { 6.195452e-01, -3.200713e-01, -7.167413e-01,  3.773383e-01,  9.531780e-01,  1.444701e-01},
  { 7.960221e-01, -4.569426e-01, -3.969286e-01,  3.487783e-01,  9.505373e-01,  1.178328e-01},
  { 9.808728e-01, -1.942011e-01, -1.320640e-02,  3.487470e-01,  9.498127e-01,  6.483264e-02},
  {-7.601461e-01, -6.475694e-01,  5.321416e-02, -1.224438e-01,  9.653364e-01,  5.518634e-02},
  {-9.847813e-01, -1.436584e-01, -9.781713e-02, -1.158168e-01,  9.772074e-01, -2.073471e-02},
  {-8.218746e-01, -3.016543e-01, -4.832462e-01, -1.186544e-01,  9.799734e-01, -3.306680e-02},
  {-5.938828e-01, -1.732006e-01, -7.856874e-01,  1.835750e-01,  9.660455e-01, -1.209858e-01},
  { 7.725827e-01,  2.204326e-01, -5.954204e-01,  5.728916e-01,  9.754049e-01, -1.657140e-01},
  {-5.189782e-01,  1.279659e-01, -8.451546e-01,  2.678686e-01,  9.817285e-01, -1.696016e-01},
  { 6.669964e-01,  5.695278e-01, -4.803685e-01,  1.225203e-01,  9.943119e-01, -2.463563e-01},
  {-5.501412e-01,  3.468325e-01, -7.596393e-01,  3.621849e-01,  9.803903e-01, -2.773849e-01},
  {-1.230063e-01,  6.807544e-01, -7.221102e-01,  5.660353e-01,  1.022861e+00, -3.753940e-01},
  { 3.734676e-01, -6.283481e-01,  6.824226e-01,  4.738322e-01,  9.768169e-01,  6.018381e-01},
  {-6.054093e-01,  7.938437e-01,  5.737167e-02,  3.245616e-01,  1.042769e+00,  5.132816e-01},
  { 4.119450e-01,  3.993845e-01,  8.190198e-01,  2.213540e-01,  1.045350e+00,  5.001497e-01},
  { 8.453761e-01,  3.532094e-01, -4.007274e-01,  5.826135e-01,  1.012143e+00,  3.190433e-01},
  { 8.498688e-01,  2.206249e-01, -4.785894e-01,  5.869189e-01,  1.021287e+00,  3.206928e-01},
  { 8.623741e-01, -4.968021e-01,  9.746144e-02,  2.303344e-01,  9.760609e-01,  3.948794e-01},
  {-7.055554e-01, -7.022472e-01,  9.508165e-02,  1.087608e-01,  1.070776e+00,  3.309519e-01},
  { 4.500135e-01,  7.779901e-01,  4.384282e-01,  5.452269e-02,  1.011830e+00,  3.284729e-01},
  {-1.937397e-01,  5.960009e-01,  7.792611e-01,  1.008454e-02,  1.016234e+00,  3.286497e-01},
  { 8.124375e-01, -4.416076e-02,  5.813735e-01,  1.653636e-01,  1.037798e+00,  2.619099e-01},
  { 3.582212e-01,  9.015578e-01, -2.426336e-01,  2.146519e-01,  1.005460e+00,  2.176759e-01},
  {-6.568444e-01,  6.805520e-01, -3.246607e-01,  2.441567e-01,  9.998634e-01,  1.877012e-01},
  {-5.064886e-01,  8.041955e-01, -3.110289e-01,  1.109733e-01,  1.001114e+00,  9.817420e-02},
  {-9.891930e-01,  1.062548e-01, -1.010309e-01, -1.288899e-01,  9.891708e-01,  3.426550e-02},
  {-6.357031e-01,  7.387958e-01, -2.237464e-01,  1.177588e-01,  9.940008e-01,  6.797373e-02},
  {-7.373594e-01, -9.962051e-04,  6.754999e-01,  1.156315e-01,  9.988162e-01,  3.933257e-02},
  {-3.305888e-01,  6.772233e-01, -6.573276e-01, -1.067496e-01,  1.002156e+00, -2.958265e-02},
  { 5.302536e-01, -7.675111e-01,  3.602192e-01,  5.691853e-01,  9.499999e-01, -8.534729e-02},
  { 9.575922e-01, -2.572644e-01, -1.297387e-01,  5.908909e-01,  9.696354e-01, -1.197003e-01},
  { 2.352559e-01,  8.239296e-01, -5.155528e-01,  1.031380e-01,  1.016728e+00, -2.078848e-01},
  {-6.296454e-01,  6.273957e-01, -4.581716e-01,  7.712868e-02,  9.900787e-01, -1.632712e-01},
  { 3.127076e-02,  6.589312e-01, -7.515529e-01,  6.299103e-02,  1.000064e+00, -1.551744e-01},
  {-6.249102e-01,  2.220752e-01, -7.484449e-01,  1.904458e-01,  9.994230e-01, -2.298428e-01},
  { 7.621801e-01,  6.040210e-01, -2.328952e-01,  2.770779e-02,  1.034637e+00, -2.385956e-01},
  { 7.925470e-01, -3.602591e-01,  4.920188e-01,  4.517496e-01,  9.721233e-01, -1.919081e-01},
  {-6.871530e-01,  1.769995e-01, -7.046218e-01,  3.010918e-01,  9.860817e-01, -2.534420e-01},
  { 4.489013e-01,  5.862544e-01, -6.743837e-01,  1.034375e-02,  1.031806e+00, -2.841315e-01},
  { 9.405534e-01,  2.833118e-02, -3.384622e-01,  4.483377e-01,  9.968776e-01, -2.763923e-01},
  { 8.438391e-01,  5.280690e-01,  9.528316e-02,  5.874825e-01,  1.035025e+00, -3.509552e-01},
  { 9.183061e-01, -3.958335e-01, -5.446724e-03,  4.807824e-01,  9.785858e-01, -3.739392e-01},
  { 9.183061e-01, -3.958335e-01, -5.446724e-03,  5.734236e-01,  1.034993e+00, -3.739363e-01},
  { 4.955432e-01, -5.592632e-02,  8.667810e-01,  4.927970e-01,  1.002142e+00,  6.017644e-01},
  { 8.075541e-01, -3.598627e-01,  4.672849e-01,  5.390503e-01,  9.901556e-01,  5.430700e-01},
  { 5.517448e-01, -8.315458e-01,  6.410392e-02,  5.534232e-01,  9.811376e-01,  4.758168e-01},
  {-9.918444e-01,  9.559675e-02,  8.429734e-02,  3.815950e-01,  1.075930e+00,  4.751926e-01},
  { 9.684663e-01,  3.947137e-02,  2.459981e-01,  5.840741e-01,  1.041709e+00,  4.349888e-01},
  {-6.179557e-01,  7.862124e-01,  7.798561e-04,  3.697996e-01,  1.038550e+00,  4.147269e-01},
  { 6.731740e-01,  7.325668e-01,  1.009092e-01,  2.190992e-01,  1.056924e+00,  4.717100e-01},
  { 8.756625e-01, -7.770044e-02,  4.766318e-01,  2.472079e-01,  1.024146e+00,  4.652290e-01},
  { 4.326840e-02, -9.858838e-02,  9.941872e-01,  2.350600e-01,  1.039571e+00,  4.714658e-01},
  {-7.055554e-01, -7.022472e-01,  9.508165e-02,  1.043854e-01,  1.081120e+00,  3.748842e-01},
  { 7.055554e-01,  7.022473e-01, -9.508166e-02,  1.004312e-01,  1.082191e+00,  3.534542e-01},
  {-1.227928e-01,  8.863522e-01, -4.464322e-01,  1.761760e-01,  1.024628e+00,  3.621618e-01},
  { 3.367478e-02,  9.974150e-01,  6.347739e-02,  1.834626e-01,  1.012079e+00,  3.182949e-01},
  { 6.835328e-01, -1.426425e-01, -7.158464e-01,  5.808471e-01,  9.970047e-01,  1.653219e-01},
  {-7.625081e-01, -3.041469e-01,  5.710307e-01,  7.270337e-02,  1.035076e+00,  2.259312e-01},
  {-8.454306e-01, -1.403442e-01,  5.153160e-01, -3.757322e-02,  1.031124e+00,  2.807240e-01},
  {-3.979557e-01, -8.418447e-01,  3.645939e-01, -7.021453e-02,  9.827240e-01,  2.011547e-01},
  { 2.866316e-02,  6.343083e-01, -7.725486e-01,  1.063350e-01,  1.027565e+00,  1.368558e-01},
  { 1.589853e-01,  6.779445e-01, -7.177151e-01,  5.513412e-02,  1.023321e+00,  1.085759e-01},
  {-9.239318e-01,  4.783162e-02,  3.795552e-01, -1.163029e-01,  1.000704e+00,  1.334416e-01},
  {-4.747326e-01,  6.113863e-01, -6.331158e-01,  2.482333e-01,  1.002793e+00,  1.032664e-01},
  { 6.170900e-01, -3.660483e-01, -6.965692e-01,  2.334497e-01,  1.007364e+00,  8.776727e-02},
  { 4.112461e-01, -9.079726e-01, -8.038986e-02,  3.851381e-01,  9.907431e-01,  7.336971e-02},
  {-6.706781e-01,  6.962329e-01, -2.558333e-01, -1.068752e-01,  1.038072e+00,  5.652033e-02},
  {-4.179214e-02, -7.173853e-01,  6.954219e-01,  5.145154e-01,  9.658686e-01, -2.258598e-02},
  { 3.905335e-01, -8.112504e-01,  4.351510e-01,  5.566790e-01,  9.671911e-01, -3.290028e-02},
  { 5.819466e-01,  4.238651e-01, -6.940293e-01,  5.842639e-01,  1.008456e+00, -1.436879e-01},
  { 5.210677e-01,  1.898115e-01, -8.321418e-01,  1.594802e-01,  1.016063e+00, -1.227067e-01},
  {-5.002540e-01,  5.017611e-01, -7.056783e-01,  7.624865e-02,  1.026550e+00, -1.344244e-01},
  {-5.214539e-01,  1.512101e-01, -8.397745e-01,  1.062790e-01,  1.025817e+00, -2.017348e-01},
  {-6.876275e-01,  4.077422e-01, -6.007618e-01,  4.214786e-01,  1.021595e+00, -3.392854e-01},
  { 8.586277e-01,  3.423847e-01,  3.814855e-01,  5.576735e-01,  1.051545e+00,  5.230820e-01},
  { 7.569150e-02,  9.397855e-01, -3.332775e-01,  5.335858e-01,  1.078501e+00,  4.092394e-01},
  { 2.820512e-01,  9.567868e-01,  7.075568e-02,  1.836739e-01,  1.090924e+00,  4.583635e-01},
  { 7.702537e-01, -4.193117e-01,  4.805069e-01,  2.693797e-01,  1.031275e+00,  4.455564e-01},
  { 7.075503e-01,  6.614384e-01, -2.487405e-01,  2.129185e-01,  1.058024e+00,  4.539325e-01},
  { 8.285912e-01, -2.991032e-01,  4.732589e-01,  2.932315e-01,  1.049154e+00,  4.070670e-01},
  {-1.775111e-01, -2.050460e-02,  9.839051e-01,  3.563894e-01,  1.050546e+00,  3.534110e-01},
  { 8.210220e-01,  5.122292e-01,  2.520796e-01,  5.016472e-01,  1.019663e+00,  2.743841e-01},
  {-8.201058e-01,  3.321986e-01, -4.659083e-01,  1.974607e-01,  1.027092e+00,  3.390762e-01},
  { 1.687636e-01,  4.512674e-01, -8.762856e-01,  5.409428e-01,  1.022675e+00,  1.495173e-01},
  { 7.856158e-01,  3.361655e-01,  5.194234e-01,  7.153469e-02,  1.067059e+00,  2.114978e-01},
  {-8.113146e-01, -3.405702e-01, -4.751639e-01,  6.959537e-02,  1.070615e+00,  2.110331e-01},
  {-8.113146e-01, -3.405702e-01, -4.751639e-01,  5.791048e-02,  1.087601e+00,  2.188094e-01},
  {-1.944605e-01,  3.178113e-01,  9.279984e-01,  4.162852e-02,  1.109434e+00,  2.195304e-01},
  { 5.149601e-02,  7.613609e-01, -6.462799e-01, -4.217631e-02,  1.057717e+00,  6.978884e-02},
  {-7.447632e-01,  6.528729e-01, -1.381481e-01, -1.213848e-01,  1.036608e+00,  9.502033e-02},
  {-9.209470e-02,  7.790590e-01,  6.201497e-01,  2.558699e-01,  1.046578e+00,  4.183547e-02},
  { 9.611096e-01, -1.004270e-01,  2.572604e-01,  5.892632e-01,  9.902294e-01, -4.551696e-02},
  { 9.847997e-01, -1.912616e-02,  1.726374e-01,  5.939564e-01,  1.003532e+00, -6.645671e-02},
  { 9.211609e-01,  2.367327e-01, -3.089019e-01,  9.454075e-02,  1.062034e+00, -1.921183e-01},
  { 1.899559e-02,  7.084160e-01, -7.055394e-01,  5.692666e-02,  1.039158e+00, -1.174280e-01},
  { 4.023348e-01,  4.194509e-01, -8.137491e-01,  4.602747e-01,  1.009384e+00, -1.258774e-01},
  {-8.769901e-01,  3.989604e-01, -2.678036e-01, -9.308098e-02,  1.053302e+00, -1.771571e-01},
  {-7.430272e-02,  8.963247e-01, -4.371284e-01, -3.305133e-02,  1.078612e+00, -2.238216e-01},
  {-7.818775e-01,  4.860844e-01, -3.903710e-01,  3.176698e-01,  1.035266e+00, -2.418747e-01},
  { 6.508310e-01,  5.691999e-02, -7.570860e-01,  4.881692e-01,  1.037675e+00, -3.576472e-01},
  {-7.969622e-03,  4.243816e-01, -9.054484e-01,  5.666082e-01,  1.066401e+00, -3.399819e-01},
  { 6.931925e-01,  4.143896e-01,  5.897164e-01,  5.307158e-01,  1.064596e+00,  5.564116e-01},
  { 1.521863e-01,  5.836979e-01,  7.975815e-01,  4.990009e-01,  1.072219e+00,  5.787570e-01},
  { 7.732822e-01,  6.337157e-01,  2.095399e-02,  5.617592e-01,  1.068575e+00,  4.943798e-01},
  { 7.914931e-01,  3.554567e-01, -4.971812e-01,  4.651426e-01,  1.059331e+00,  4.244159e-01},
  { 5.068619e-01, -1.093847e-01,  8.550591e-01,  2.707441e-01,  1.059475e+00,  4.781428e-01},
  { 6.742151e-01, -3.927429e-01,  6.254494e-01,  4.537665e-01,  1.053484e+00,  3.816281e-01},
  { 7.356066e-01, -4.063984e-01,  5.419624e-01,  4.818235e-01,  1.052656e+00,  3.027986e-01},
  { 9.062579e-01,  4.092618e-01, -1.058369e-01,  5.828054e-01,  1.031006e+00,  1.936434e-01},
  {-5.694956e-01, -3.830062e-01,  7.273108e-01,  9.727186e-02,  1.069366e+00,  3.161910e-01},
  { 4.511812e-01,  1.155464e-02,  8.923576e-01,  1.315037e-01,  1.076111e+00,  3.192843e-01},
  { 5.076252e-01,  3.226632e-01, -7.988774e-01,  4.685913e-01,  1.048775e+00,  1.943322e-01},
  {-3.832533e-01,  6.180004e-01,  6.864345e-01, -1.994360e-02,  1.108097e+00,  2.317152e-01},
  {-5.769833e-01,  3.519537e-01,  7.370338e-01,  3.003211e-02,  1.143386e+00,  2.073608e-01},
  { 6.984921e-01, -1.414117e-01, -7.015066e-01,  4.033364e-01,  1.015512e+00,  1.465303e-01},
  {-1.551695e-01,  7.964193e-01, -5.844988e-01, -4.491969e-02,  1.089488e+00,  1.118700e-01},
  { 5.341396e-01, -8.277681e-01,  1.717403e-01,  4.359671e-01,  1.015608e+00,  8.657241e-02},
  {-8.091917e-01,  5.741838e-01, -1.245861e-01,  2.980423e-01,  1.063250e+00,  5.065277e-02},
  { 1.205877e-01, -8.297366e-01,  5.449730e-01,  4.573471e-01,  1.008124e+00, -7.258997e-03},
  {-9.118949e-01,  1.021623e-01, -3.975054e-01, -9.543718e-02,  1.080789e+00, -9.084287e-02},
  {-7.077448e-01,  2.774430e-01, -6.497097e-01,  1.875179e-01,  1.044919e+00, -1.159472e-01},
  {-7.328997e-01,  6.280786e-01, -2.614867e-01, -9.463546e-02,  1.077321e+00, -9.684571e-02},
  { 3.989228e-01,  9.039063e-01, -1.543175e-01, -2.713273e-02,  1.093631e+00, -1.452795e-01},
  { 2.663684e-01,  9.593358e-01,  9.339529e-02,  4.714132e-01,  1.121190e+00,  5.161080e-01},
  {-1.716811e-01,  3.526490e-01,  9.198719e-01,  2.450724e-01,  1.094927e+00,  4.685471e-01},
  { 8.959129e-01, -4.434996e-01,  2.546041e-02,  4.514241e-01,  1.093244e+00,  3.859700e-01},
  {-2.692749e-01,  8.652536e-01, -4.228796e-01,  4.445660e-02,  1.169378e+00,  2.017360e-01},
  {-3.905392e-01,  9.194941e-01,  4.482910e-02,  2.626310e-02,  1.157365e+00,  1.909074e-01},
  {-6.754815e-01,  6.187695e-01,  4.010599e-01, -3.303318e-02,  1.125655e+00,  1.991532e-01},
  {-6.749860e-01,  7.371223e-01,  3.232173e-02, -4.277623e-02,  1.120038e+00,  1.850981e-01},
  {-3.046945e-02,  8.267622e-01, -5.617257e-01,  7.438486e-03,  1.145651e+00,  1.595110e-01},
  {-2.662626e-01,  4.344704e-01, -8.604299e-01,  1.522777e-01,  1.104421e+00,  1.732534e-01},
  { 5.530166e-01,  2.889071e-01,  7.814764e-01,  1.826523e-01,  1.080792e+00,  4.177639e-02},
  {-7.973559e-01, -1.792841e-01,  5.762645e-01, -7.674204e-02,  1.067210e+00,  6.052999e-04},
  { 8.251963e-01,  4.302551e-01, -3.659668e-01,  5.773848e-01,  1.054239e+00, -1.111617e-01},
  {-6.219986e-01, -3.406183e-01, -7.050509e-01,  3.491335e-02,  1.091329e+00, -9.917672e-02},
  {-3.876312e-01, -4.514001e-01, -8.037289e-01, -1.110425e-03,  1.096520e+00, -8.723488e-02},
  { 5.139933e-02,  7.477821e-01, -6.619517e-01, -5.159355e-02,  1.091407e+00, -8.970892e-02},
  { 9.877429e-01, -1.271348e-02,  1.555707e-01,  4.455885e-01,  1.038822e+00, -1.186410e-01},
  {-5.932230e-01, -2.251358e-01, -7.729167e-01,  9.649429e-02,  1.074852e+00, -1.837662e-01},
  {-6.158013e-01,  7.828296e-01, -8.925499e-02, -7.885000e-02,  1.089710e+00, -1.388206e-01},
  {-8.884488e-01,  4.570303e-01, -4.221310e-02,  3.519634e-01,  1.059638e+00, -1.914358e-01},
  { 9.219305e-01, -2.176754e-01,  3.204085e-01,  5.592303e-01,  1.051019e+00, -1.893925e-01},
  {-1.611472e-01,  2.039441e-01, -9.656286e-01,  5.085366e-01,  1.094316e+00, -2.461927e-01},
  {-1.597954e-02,  4.150668e-01, -9.096506e-01,  4.808226e-01,  1.061237e+00, -3.593726e-01},
  { 9.355958e-01, -2.179284e-01,  2.777908e-01,  4.897309e-01,  1.115736e+00,  4.868440e-01},
  { 8.171003e-01,  4.328312e-01,  3.807942e-01,  2.902752e-01,  1.124806e+00,  4.225908e-01},
  {-8.004245e-01, -3.908303e-01,  4.545022e-01,  3.427320e-01,  1.112952e+00,  3.237627e-01},
  {-9.677821e-01, -9.992354e-02, -2.311125e-01,  1.954102e-01,  1.108114e+00,  3.182426e-01},
  { 9.707435e-01,  4.578759e-02, -2.357129e-01,  5.695736e-01,  1.090715e+00,  2.710872e-01},
  {-2.745524e-01,  1.588348e-01,  9.483631e-01,  9.281011e-02,  1.128139e+00,  3.212446e-01},
  { 7.271354e-01, -6.537056e-01,  2.096259e-01,  4.318855e-01,  1.060965e+00,  1.567039e-01},
  { 2.023417e-01, -8.060147e-01,  5.562358e-01,  5.254977e-01,  1.036122e+00,  1.087175e-01},
  { 6.929142e-01, -6.529258e-01,  3.058721e-01,  5.614169e-01,  1.038608e+00,  1.067766e-01},
  {-6.161376e-01,  1.414914e-01,  7.748256e-01,  3.286738e-01,  1.109203e+00,  6.512213e-02},
  {-1.679248e-01, -1.514644e-01,  9.740943e-01,  2.449083e-01,  1.099389e+00,  6.402890e-02},
  {-4.234697e-01, -5.721467e-01,  7.023684e-01, -2.920162e-03,  1.075941e+00,  4.590087e-02},
  {-9.131119e-01,  3.938503e-01, -1.053978e-01, -9.759358e-02,  1.111108e+00, -6.381269e-02},
  {-3.237521e-01, -1.214579e-01, -9.383137e-01,  5.025024e-02,  1.108175e+00, -1.631653e-01},
  {-4.436514e-01,  4.373958e-02, -8.951314e-01,  1.835723e-01,  1.082337e+00, -1.200156e-01},
  {-2.644364e-01, -2.778796e-02, -9.640027e-01,  2.192116e-01,  1.082303e+00, -2.174642e-01},
  {-8.056901e-01,  2.423937e-01, -5.404708e-01,  3.575901e-01,  1.088705e+00, -1.794056e-01},
  { 6.141610e-01,  2.007955e-01, -7.632087e-01,  5.930910e-01,  1.118820e+00, -3.053426e-01},
  { 7.158809e-01, -2.837598e-01, -6.379614e-01,  4.878929e-01,  1.107409e+00, -2.510224e-01},
  { 3.957238e-01,  2.137707e-01, -8.931432e-01,  4.813952e-01,  1.100310e+00, -3.383635e-01},
  { 2.199177e-01,  8.085395e-01,  5.458022e-01,  2.655683e-01,  1.137900e+00,  4.460886e-01},
  {-4.752135e-02,  5.804272e-01,  8.129243e-01,  3.577845e-01,  1.151932e+00,  4.502210e-01},
  {-7.130790e-01,  5.149183e-01,  4.757913e-01,  2.110526e-01,  1.147673e+00,  3.965113e-01},
  { 6.895040e-01, -5.426239e-01,  4.797328e-01,  4.916245e-01,  1.113827e+00,  3.859954e-01},
  {-9.698102e-01, -3.211449e-02,  2.417372e-01,  1.834252e-01,  1.141155e+00,  3.564896e-01},
  { 7.284048e-01, -6.579120e-01,  1.912545e-01,  5.730332e-01,  1.123391e+00,  3.095885e-01},
  { 1.812460e-01,  1.340619e-01,  9.742573e-01,  3.301644e-01,  1.121166e+00,  3.202293e-01},
  { 4.110441e-01,  5.669107e-01,  7.139012e-01,  2.562470e-01,  1.143300e+00,  3.431164e-01},
  {-9.462574e-01,  8.302665e-02, -3.125757e-01,  2.712975e-01,  1.135728e+00,  2.166295e-01},
  { 1.970838e-01,  5.119413e-01,  8.361065e-01,  1.262763e-01,  1.150558e+00,  3.121441e-01},
  {-8.081112e-01,  3.211609e-01,  4.937733e-01,  6.097024e-02,  1.165096e+00,  2.795160e-01},
  { 6.763770e-01, -7.365523e-01,  2.215991e-03,  4.594922e-01,  1.090859e+00,  1.849541e-01},
  { 9.373753e-01,  3.135693e-01,  1.516633e-01,  2.090316e-01,  1.150525e+00,  2.069214e-01},
  { 2.614747e-01, -6.918515e-01,  6.730323e-01,  4.806373e-01,  1.076751e+00,  1.392524e-01},
  { 9.421927e-01, -3.224460e-01, -9.111196e-02,  5.806776e-01,  1.062605e+00,  9.077512e-02},
  {-6.424284e-01, -3.897887e-01,  6.598110e-01, -1.701761e-03,  1.103904e+00,  9.812602e-02},
  {-2.896153e-01,  3.598587e-02,  9.564664e-01,  2.315821e-01,  1.131535e+00,  5.859856e-02},
  { 6.756362e-02,  3.626173e-02,  9.970558e-01,  1.764529e-01,  1.118898e+00,  3.406526e-02},
  {-4.193182e-01,  8.749872e-01, -2.420116e-01,  1.264839e-02,  1.116104e+00,  3.177885e-02},
  {-3.964569e-01,  6.017217e-01,  6.933634e-01, -3.856576e-02,  1.114131e+00,  3.829634e-02},
  {-3.029712e-01,  2.026480e-01, -9.312047e-01,  1.129632e-01,  1.098999e+00, -1.822402e-02},
  { 7.138869e-01,  2.989460e-01, -6.332430e-01,  5.726072e-01,  1.104884e+00, -1.038097e-01},
  {-2.129452e-01, -9.336905e-03, -9.770195e-01,  3.587385e-01,  1.119091e+00, -1.740125e-01},
  { 9.177634e-01,  4.297801e-02, -3.947953e-01,  4.902429e-01,  1.115613e+00, -3.161298e-01},
  { 9.481881e-01, -2.304468e-01, -2.187093e-01,  4.877055e-01,  1.116133e+00, -3.276777e-01},
  { 5.060587e-01,  5.426255e-01,  6.704195e-01,  4.628668e-01,  1.193866e+00,  4.264230e-01},
  { 3.065965e-01, -1.233133e-01,  9.438180e-01,  5.354667e-01,  1.130145e+00,  3.946476e-01},
  { 8.011439e-01,  3.808036e-01,  4.616892e-01,  4.769561e-01,  1.143462e+00,  3.939881e-01},
  { 7.751137e-01, -5.730186e-02,  6.292179e-01,  5.751184e-01,  1.141500e+00,  3.643346e-01},
  { 9.546194e-01, -2.793535e-01,  1.032643e-01,  5.845087e-01,  1.133242e+00,  3.415233e-01},
  { 1.459925e-01,  8.352054e-01,  5.302057e-01,  2.333256e-01,  1.162218e+00,  3.417348e-01},
  {-8.966830e-01,  4.018188e-01,  1.857448e-01,  1.907328e-01,  1.161623e+00,  3.290347e-01},
  {-9.363999e-01,  1.739174e-01, -3.048078e-01,  2.050866e-01,  1.167377e+00,  2.986146e-01},
  {-9.693323e-01, -1.772082e-01,  1.702707e-01,  2.536583e-01,  1.173560e+00,  2.106761e-01},
  { 9.006085e-01, -8.013368e-02, -4.271801e-01,  4.749933e-01,  1.105673e+00,  2.308014e-01},
  {-1.380068e-01,  9.888957e-01,  5.513270e-02,  1.182830e-01,  1.213605e+00,  2.533759e-01},
  {-3.515188e-01,  8.889133e-01, -2.937139e-01,  7.254251e-02,  1.192764e+00,  2.361693e-01},
  {-3.423063e-01,  9.025068e-01, -2.613575e-01,  8.492445e-02,  1.198863e+00,  2.352163e-01},
  { 5.875342e-01, -5.662507e-01,  5.780690e-01,  5.644550e-01,  1.096689e+00,  1.542011e-01},
  {-8.226881e-01,  4.377314e-01, -3.627333e-01,  3.361400e-01,  1.127645e+00,  9.998400e-02},
  { 9.512543e-01,  2.381778e-01,  1.959251e-01,  5.761234e-01,  1.091695e+00,  1.082280e-01},
  { 4.411269e-01, -8.964089e-01, -4.310792e-02,  5.600798e-01,  1.094909e+00,  4.372398e-02},
  { 8.357082e-01,  4.777167e-01, -2.708847e-01,  1.432306e-01,  1.147022e+00,  7.419868e-02},
  {-2.096752e-01, -3.530868e-01,  9.117928e-01, -3.503249e-02,  1.121044e+00,  5.598221e-02},
  { 4.023424e-01,  9.150870e-01, -2.713454e-02,  5.317540e-01,  1.106054e+00, -4.264820e-04},
  {-2.567658e-01,  7.955219e-01, -5.488318e-01,  7.075530e-02,  1.120192e+00,  2.214378e-02},
  { 6.968704e-01,  7.083762e-01, -1.121379e-01,  5.486422e-01,  1.098504e+00, -4.647284e-03},
  {-5.161032e-01,  4.642138e-01, -7.198215e-01,  1.644627e-01,  1.128803e+00, -2.849364e-02},
  {-8.055345e-01,  4.418907e-01,  3.947740e-01, -7.484775e-02,  1.139925e+00, -2.712112e-02},
  {-6.168271e-01,  7.322226e-01, -2.887464e-01,  2.888091e-01,  1.142588e+00, -3.562321e-02},
  { 8.356979e-01,  5.060339e-01, -2.133978e-01,  2.915374e-01,  1.114155e+00, -8.317319e-02},
  { 1.665257e-01,  2.591303e-01, -9.513783e-01,  5.901630e-02,  1.166554e+00, -1.738641e-01},
  { 6.620425e-01, -2.365080e-01,  7.111706e-01,  4.856739e-01,  1.099073e+00, -1.483577e-01},
  { 1.369652e-01,  8.023898e-02, -9.873207e-01,  2.758283e-01,  1.112066e+00, -2.072919e-01},
  {-1.210164e-01,  2.713453e-01, -9.548438e-01,  4.825665e-01,  1.132930e+00, -3.066184e-01},
  { 5.923004e-01, -4.161621e-01,  6.899199e-01,  4.843231e-01,  1.127859e+00,  5.108078e-01},
  { 4.620959e-01,  7.935707e-01,  3.958698e-01,  4.715534e-01,  1.165045e+00,  3.750992e-01},
  {-6.144772e-01, -7.037839e-02,  7.857892e-01,  3.331819e-01,  1.164224e+00,  4.305519e-01},
  { 9.011502e-01,  3.136365e-01, -2.992665e-01,  5.703496e-01,  1.183452e+00,  3.078069e-01},
  {-3.403861e-01,  6.307530e-01,  6.973434e-01,  8.786505e-02,  1.184742e+00,  2.907224e-01},
  { 1.531805e-01,  9.871022e-01, -4.653056e-02,  1.844264e-01,  1.204241e+00,  2.292890e-01},
  { 5.213561e-02,  6.190309e-01,  7.836344e-01,  1.589025e-01,  1.228553e+00,  1.744318e-01},
  {-9.743229e-01,  2.118885e-01, -7.614631e-02, -2.414260e-02,  1.142159e+00,  6.666337e-02},
  {-8.277066e-01,  2.909434e-01,  4.798476e-01,  3.316269e-01,  1.122085e+00, -1.071659e-02},
  {-4.781393e-01,  1.911689e-01, -8.572265e-01,  1.793579e-01,  1.182711e+00, -1.250900e-02},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  2.026286e-01,  1.180557e+00, -3.473875e-02},
  {-1.431255e-01,  7.329801e-01,  6.650228e-01, -1.166841e-02,  1.192483e+00, -1.347995e-02},
  { 4.514379e-01,  1.659344e-01, -8.767381e-01,  5.584265e-01,  1.138240e+00, -9.435039e-02},
  {-5.299053e-01, -1.939107e-04, -8.480569e-01,  1.956880e-02,  1.164990e+00, -1.567183e-01},
  {-1.770351e-01,  6.542757e-01, -7.352427e-01,  4.657685e-02,  1.189605e+00, -1.626769e-01},
  { 5.878854e-01,  7.418898e-01,  3.224751e-01,  2.691738e-01,  1.146725e+00, -9.988569e-02},
  {-5.719899e-01, -2.328738e-02, -8.199300e-01,  1.516476e-01,  1.132994e+00, -1.643121e-01},
  { 5.713898e-02,  1.146101e-01, -9.917659e-01,  2.907759e-01,  1.153459e+00, -1.992443e-01},
  { 2.498343e-02,  2.185561e-01, -9.755045e-01,  5.288478e-01,  1.161999e+00, -2.466050e-01},
  {-2.140295e-02,  7.825248e-01,  6.222515e-01,  5.230547e-01,  1.198770e+00,  3.601582e-01},
  { 8.704165e-01,  4.853883e-01, -8.229991e-02,  4.408167e-01,  1.235795e+00,  3.634517e-01},
  { 3.922516e-01,  9.119139e-01, -1.206306e-01,  4.457208e-01,  1.178037e+00,  3.320739e-01},
  { 8.223200e-01,  5.647337e-01, -6.975399e-02,  4.290490e-01,  1.175807e+00,  3.007897e-01},
  { 6.271400e-01,  4.372537e-01, -6.445965e-01,  5.459658e-01,  1.195823e+00,  2.927430e-01},
  {-4.935001e-01,  8.250258e-01,  2.752998e-01,  4.779413e-01,  1.201986e+00,  2.940628e-01},
  {-1.605534e-01,  9.870074e-01, -6.251112e-03,  4.350114e-01,  1.163748e+00,  2.905644e-01},
  { 4.213536e-01,  6.885587e-01,  5.902101e-01,  4.459964e-01,  1.179088e+00,  2.749195e-01},
  { 2.034036e-01,  8.838721e-01, -4.211853e-01,  3.544527e-01,  1.145814e+00,  2.091730e-01},
  {-9.342906e-01,  1.219117e-01, -3.350203e-01,  2.506719e-01,  1.220088e+00,  1.906693e-01},
  { 9.092789e-01,  3.062431e-01,  2.818280e-01,  1.994584e-01,  1.190223e+00,  2.358360e-01},
  { 4.245883e-01,  7.124032e-01,  5.587544e-01,  2.873170e-01,  1.201908e+00,  1.880417e-01},
  { 1.172558e-01,  7.393924e-01, -6.629856e-01,  2.415619e-01,  1.207637e+00,  1.863390e-01},
  { 6.870740e-01,  7.240978e-01,  6.009628e-02,  1.941093e-01,  1.195728e+00,  2.278476e-01},
  { 1.294878e-01,  7.322543e-01,  6.686080e-01,  3.672113e-01,  1.151164e+00,  1.691197e-01},
  {-3.943075e-01,  8.727192e-01, -2.878936e-01,  4.263495e-01,  1.148595e+00,  1.494308e-01},
  {-1.114411e-01,  9.937706e-01,  9.583012e-04,  4.454733e-01,  1.157922e+00,  1.164088e-01},
  {-4.698607e-01,  4.542649e-01,  7.568846e-01,  7.328132e-02,  1.211338e+00,  1.480595e-01},
  {-7.632524e-01,  3.317349e-01,  5.544345e-01, -2.379763e-04,  1.172985e+00,  1.008189e-01},
  {-4.519557e-01,  6.803731e-01, -5.769129e-01,  1.915678e-02,  1.190464e+00,  6.906307e-02},
  {-3.002163e-01,  1.086151e-01,  9.476671e-01,  2.860717e-01,  1.175886e+00,  5.466390e-02},
  {-3.324890e-01,  9.320787e-01,  1.438069e-01,  1.148018e-01,  1.225701e+00,  4.981479e-02},
  { 7.943278e-01, -4.351569e-01,  4.238890e-01,  5.999552e-01,  1.127902e+00,  2.432199e-02},
  { 5.570548e-01,  1.534800e-01,  8.161702e-01,  2.275063e-01,  1.211514e+00,  5.924833e-02},
  {-7.035508e-01,  7.105350e-01, -1.250064e-02, -3.202793e-02,  1.191745e+00, -4.253748e-02},
  { 6.193172e-01,  1.187934e-01, -7.761020e-01,  4.841398e-01,  1.162498e+00, -6.761594e-02},
  { 6.386226e-01,  7.523917e-01, -1.614559e-01,  2.287640e-01,  1.185135e+00, -1.076255e-01},
  {-9.208794e-01, -6.044512e-02, -3.851332e-01,  1.351020e-01,  1.186859e+00, -1.670196e-01},
  {-1.834872e-02, -3.291267e-01, -9.441075e-01,  3.440723e-01,  1.187514e+00, -1.783299e-01},
  {-4.092800e-01,  5.196553e-02, -9.109278e-01,  3.739153e-01,  1.223708e+00, -2.066692e-01},
  {-7.505714e-01,  2.678817e-01, -6.040546e-01,  3.786986e-01,  1.206814e+00, -2.199373e-01},
  {-6.733277e-01, -1.428843e-01,  7.254060e-01,  3.099635e-01,  1.194344e+00,  4.178435e-01},
  {-3.168578e-01,  4.794436e-01,  8.183734e-01,  2.803112e-01,  1.212553e+00,  3.468858e-01},
  { 5.608568e-01,  8.254485e-01,  6.383113e-02,  5.578274e-01,  1.213731e+00,  3.346864e-01},
  { 5.051569e-01,  8.318163e-01, -2.299961e-01,  4.006136e-01,  1.251545e+00,  2.905398e-01},
  {-6.051320e-01,  7.117534e-01,  3.566824e-01,  2.337159e-01,  1.217106e+00,  3.373241e-01},
  {-3.649147e-02,  9.992566e-01, -1.243155e-02,  5.235284e-01,  1.211891e+00,  3.015244e-01},
  {-3.814761e-01,  7.003777e-01, -6.032802e-01,  3.831212e-01,  1.182278e+00,  2.256760e-01},
  {-8.491211e-01,  5.228205e-01, -7.518040e-02,  2.650931e-01,  1.253152e+00,  2.173706e-01},
  {-9.601471e-01, -4.172587e-02, -2.763628e-01,  2.277608e-01,  1.233341e+00,  1.558140e-01},
  {-7.140437e-01,  6.691982e-01, -2.057069e-01,  4.688140e-01,  1.183922e+00,  1.377205e-01},
  {-8.356671e-01,  5.377433e-01, -1.117702e-01,  4.865082e-01,  1.201050e+00,  1.181765e-01},
  {-1.151601e-01, -9.564474e-01, -2.682286e-01,  2.545591e-01,  1.237789e+00,  1.284498e-01},
  { 7.321894e-01,  5.769981e-01, -3.619002e-01,  1.874582e-01,  1.218510e+00,  1.422865e-01},
  { 5.432343e-01,  7.571840e-01,  3.627243e-01,  1.857680e-01,  1.225009e+00,  1.555379e-01},
  {-1.274507e-01,  9.293116e-01,  3.466069e-01,  1.254426e-01,  1.244600e+00,  1.379213e-01},
  {-8.927383e-01, -3.867451e-01,  2.311851e-01,  3.625041e-01,  1.232693e+00,  1.002772e-01},
  {-5.909544e-01,  8.055072e-01,  4.394422e-02,  3.975521e-02,  1.213627e+00,  1.087898e-01},
  { 8.489327e-01,  1.529419e-01, -5.058872e-01,  5.973028e-01,  1.167784e+00,  7.617255e-02},
  {-3.842920e-02,  9.635603e-01, -2.647164e-01,  9.775126e-02,  1.246943e+00,  8.217981e-02},
  { 9.697214e-01, -2.428626e-01,  2.565380e-02,  5.936737e-01,  1.151900e+00,  5.369623e-02},
  {-1.577340e-01,  9.193848e-01,  3.603492e-01,  4.408049e-01,  1.182148e+00,  3.738780e-02},
  { 8.150091e-01, -2.775075e-01,  5.086746e-01,  4.353710e-01,  1.185182e+00,  4.092740e-02},
  { 7.040873e-01,  6.161236e-01,  3.530622e-01,  2.441621e-01,  1.238886e+00,  1.844766e-02},
  { 5.018978e-01,  4.668854e-01, -7.280911e-01,  5.993513e-01,  1.183456e+00, -8.329421e-02},
  {-2.020937e-02,  6.860117e-01, -7.273098e-01,  5.570741e-01,  1.196055e+00, -6.884596e-02},
  { 2.924241e-01,  4.056292e-01, -8.659983e-01,  5.513958e-01,  1.208040e+00, -5.868285e-02},
  {-2.915877e-01,  6.279358e-01,  7.215769e-01,  2.240757e-01,  1.232054e+00, -4.243907e-02},
  {-3.837409e-01,  9.234406e-01, -4.416262e-04,  3.740003e-01,  1.165445e+00, -1.025801e-01},
  {-3.837409e-01,  9.234406e-01, -4.416262e-04,  3.893786e-01,  1.170326e+00, -1.081652e-01},
  {-9.726408e-01,  2.278580e-01, -4.528484e-02,  1.262543e-01,  1.242662e+00, -9.011147e-02},
  {-9.726408e-01,  2.278580e-01, -4.528484e-02,  3.838537e-01,  1.166567e+00, -1.083043e-01},
  { 4.466336e-02,  8.181981e-01,  5.731990e-01,  2.119222e-01,  1.223824e+00, -1.329024e-01},
  { 5.626771e-01, -3.710293e-01,  7.387365e-01,  5.825869e-01,  1.147871e+00, -1.536056e-01},
  { 9.179386e-01, -1.611383e-01, -3.625234e-01,  3.701325e-01,  1.246576e+00, -1.964788e-01},
  {-9.214259e-02,  1.198493e-01, -9.885069e-01,  2.909951e-01,  1.192451e+00, -1.970105e-01},
  { 1.086484e-01,  9.516158e-01,  2.874422e-01,  4.206544e-01,  1.236236e+00,  4.025138e-01},
  { 3.291049e-01,  8.271052e-01, -4.556171e-01,  3.562025e-01,  1.266638e+00,  2.664683e-01},
  {-1.768425e-01,  9.414737e-01, -2.869736e-01,  2.655173e-01,  1.254695e+00,  2.430568e-01},
  { 8.003990e-01, -4.966931e-01,  3.356450e-01,  5.673892e-01,  1.191736e+00,  2.699200e-01},
  { 9.813184e-01, -5.960255e-02,  1.829251e-01,  5.873796e-01,  1.225152e+00,  2.183574e-01},
  {-6.444634e-01,  7.632952e-01, -4.524847e-02,  4.327585e-01,  1.240193e+00,  2.271712e-01},
  {-4.850471e-01,  6.992832e-01,  5.251021e-01,  2.382568e-01,  1.250024e+00,  1.760662e-01},
  { 3.621244e-01,  6.115928e-01, -7.034345e-01,  5.570401e-01,  1.178099e+00,  3.155604e-02},
  { 3.535307e-01, -3.247996e-01,  8.772236e-01,  4.752017e-01,  1.224422e+00,  2.179626e-02},
  {-5.913197e-01, -1.944060e-01,  7.826541e-01,  2.946315e-01,  1.220371e+00,  4.593680e-02},
  {-8.527845e-01,  1.419642e-01, -5.025979e-01,  3.061757e-01,  1.233779e+00,  3.858716e-02},
  {-4.815111e-01,  7.335752e-01, -4.795983e-01,  9.518895e-02,  1.238127e+00,  1.783585e-02},
  { 6.429315e-01,  5.932398e-01,  4.844642e-01,  5.829657e-01,  1.206500e+00, -1.604850e-04},
  {-7.969818e-01,  3.180979e-01,  5.134527e-01,  3.750029e-01,  1.200094e+00,  8.283205e-03},
  { 5.907520e-01,  8.063593e-01, -2.822903e-02,  2.222862e-01,  1.263108e+00,  3.579816e-02},
  { 5.296360e-01,  8.475211e-01, -3.454922e-02,  2.212126e-01,  1.264785e+00,  1.847665e-02},
  { 8.949662e-01,  3.773402e-01, -2.380125e-01,  6.126480e-01,  1.175897e+00, -5.013848e-02},
  { 8.370079e-01,  5.346498e-01,  1.164790e-01,  2.850947e-01,  1.243983e+00, -2.081757e-02},
  { 7.201950e-01,  5.582561e-01, -4.119093e-01,  2.665062e-01,  1.251729e+00, -2.127180e-02},
  { 7.069875e-01,  6.595574e-01,  2.552503e-01,  2.497679e-01,  1.263311e+00, -5.153668e-02},
  {-3.235230e-01,  2.802207e-01,  9.037749e-01,  1.604491e-01,  1.257179e+00, -4.623335e-02},
  { 4.249952e-01,  8.635102e-01, -2.715308e-01,  6.881671e-02,  1.245928e+00, -8.087275e-02},
  { 9.856541e-01,  7.600483e-02,  1.506961e-01,  4.852725e-01,  1.220974e+00, -6.098383e-02},
  {-4.310519e-01,  8.247886e-01, -3.659480e-01,  4.031372e-01,  1.186346e+00, -9.353093e-02},
  {-5.370118e-01,  3.150097e-01, -7.825518e-01,  1.420876e-01,  1.224460e+00, -1.689274e-01},
  {-6.630240e-02,  9.588960e-01,  2.759027e-01,  4.476291e-01,  1.187411e+00, -1.902960e-01},
  { 4.013855e-01,  4.822711e-01,  7.786554e-01,  4.546082e-01,  1.211419e+00, -1.996308e-01},
  { 7.127964e-01,  9.324605e-03, -7.013091e-01,  5.932726e-01,  1.243137e+00, -2.669350e-01},
  { 5.061956e-01,  4.655261e-01, -7.259831e-01,  5.217418e-01,  1.243416e+00, -2.763021e-01},
  {-2.547697e-01, -6.671227e-01,  7.000284e-01,  4.988503e-01,  1.238139e+00,  3.159219e-01},
  { 3.656880e-01,  2.737285e-01,  8.895757e-01,  5.380011e-01,  1.229672e+00,  3.221015e-01},
  { 7.883160e-01,  8.739711e-02,  6.090317e-01,  5.663469e-01,  1.220611e+00,  2.933998e-01},
  { 7.214142e-01,  2.087264e-01,  6.602989e-01,  5.534262e-01,  1.229634e+00,  3.072577e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.418305e-01,  1.246274e+00,  2.636199e-01},
  { 8.853089e-01,  3.457720e-01,  3.109179e-01,  5.767862e-01,  1.234257e+00,  2.645206e-01},
  { 1.834096e-02,  9.948346e-01, -9.983826e-02,  5.282244e-01,  1.281248e+00,  1.828048e-01},
  { 8.523799e-01,  5.009770e-01, -1.499017e-01,  5.989404e-01,  1.225734e+00,  1.016560e-01},
  { 3.355885e-02,  8.145221e-01,  5.791612e-01,  3.491342e-01,  1.268628e+00,  1.668358e-01},
  { 5.251981e-02,  7.088096e-01, -7.034420e-01,  5.510119e-01,  1.242677e+00,  9.149345e-02},
  { 4.357774e-01,  8.708475e-02,  8.958317e-01,  4.036944e-01,  1.248020e+00,  1.748160e-01},
  { 1.771685e-01,  9.383421e-01,  2.968592e-01,  3.750407e-01,  1.264231e+00,  1.652724e-01},
  { 6.348113e-01, -5.140939e-01,  5.768205e-01,  4.650417e-01,  1.234219e+00,  3.487970e-02},
  {-9.136047e-01, -7.098939e-02,  4.003585e-01,  2.971302e-01,  1.235637e+00,  6.149446e-02},
  {-6.607089e-01,  3.264653e-01, -6.759321e-01,  3.053959e-01,  1.258570e+00,  3.809169e-02},
  { 5.655462e-01,  8.104855e-01, -1.525476e-01,  5.833552e-01,  1.218415e+00, -1.664167e-02},
  { 9.263371e-01, -2.717328e-01,  2.608848e-01,  5.911780e-01,  1.223669e+00,  1.543095e-03},
  { 1.646909e-01,  3.013385e-02,  9.858848e-01,  5.851799e-01,  1.233696e+00,  7.003075e-03},
  {-3.028374e-01,  9.420418e-01, -1.443844e-01,  4.670420e-02,  1.245173e+00, -9.920276e-02},
  { 4.842810e-01,  8.107029e-01, -3.289873e-01,  2.077290e-01,  1.299133e+00, -8.348984e-02},
  {-6.389211e-01,  1.327803e-01, -7.577264e-01,  4.314782e-01,  1.224102e+00, -1.012143e-01},
  {-4.494742e-01,  2.807156e-01, -8.480399e-01,  4.433944e-01,  1.224190e+00, -1.173911e-01},
  {-1.127904e-01,  8.096234e-01, -5.760106e-01,  1.516316e-01,  1.266868e+00, -1.421287e-01},
  {-2.365800e-01,  3.678525e-01,  8.992854e-01,  2.847900e-01,  1.242449e+00, -1.199595e-01},
  { 1.879073e-01,  9.821868e-01,  1.286243e-04,  5.456560e-01,  1.217460e+00, -2.047414e-01},
  {-2.869293e-01,  9.423971e-01,  1.719278e-01,  5.771282e-01,  1.278232e+00, -2.391810e-01},
  { 4.261997e-01,  7.237701e-01, -5.426884e-01,  5.971724e-01,  1.271716e+00, -2.497823e-01},
  { 3.519315e-01,  6.620198e-01, -6.617205e-01,  5.167222e-01,  1.256840e+00, -2.711944e-01},
  { 3.400657e-01,  8.969536e-01,  2.825413e-01,  5.429786e-01,  1.268932e+00,  2.322065e-01},
  { 3.699293e-01,  6.565520e-01, -6.573368e-01,  5.810943e-01,  1.234545e+00,  8.137745e-02},
  { 4.810271e-01,  5.791033e-01, -6.582190e-01,  3.333817e-01,  1.288539e+00,  5.568061e-02},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  5.955787e-01,  1.241762e+00,  1.874303e-03},
  { 8.158113e-01, -1.078420e-01, -5.681742e-01,  5.980603e-01,  1.254934e+00, -1.282964e-02},
  { 7.402393e-01,  2.283513e-01, -6.323777e-01,  4.907218e-01,  1.248140e+00, -4.672844e-02},
  {-7.661336e-01, -8.554520e-02, -6.369626e-01,  3.302143e-01,  1.237669e+00, -5.696831e-02},
  { 2.066814e-01,  7.005137e-01,  6.830544e-01,  1.995000e-01,  1.299780e+00, -5.834342e-02},
  { 6.400433e-01, -1.884929e-01,  7.448590e-01,  5.911753e-01,  1.247083e+00, -1.132813e-01},
  { 7.758114e-01,  2.185865e-01,  5.918923e-01,  5.983130e-01,  1.268610e+00, -1.203092e-01},
  {-8.121905e-01,  5.425727e-01, -2.143860e-01,  2.448277e-01,  1.247395e+00, -1.605435e-01},
  { 9.483699e-01,  3.043469e-01,  8.926186e-02,  6.200768e-01,  1.256644e+00, -1.838852e-01},
  { 2.474943e-01,  7.822632e-01, -5.716736e-01,  3.841352e-01,  1.287033e+00, -1.790057e-01},
  { 1.417043e-01,  9.873261e-01,  7.146348e-02,  4.335624e-01,  1.302800e+00, -1.977439e-01},
  {-3.546698e-01,  4.339320e-01, -8.281982e-01,  4.246639e-01,  1.277719e+00, -2.264269e-01},
  { 6.565576e-01,  1.837411e-01,  7.315541e-01,  4.674403e-01,  1.285057e+00,  1.381550e-01},
  { 6.452879e-01, -3.592097e-01,  6.742194e-01,  5.183228e-01,  1.285435e+00,  7.543416e-02},
  { 8.614966e-01, -5.755544e-02, -5.044909e-01,  6.047605e-01,  1.272066e+00, -3.342569e-03},
  {-6.178923e-01,  6.812510e-01,  3.925636e-01,  1.534195e-01,  1.302299e+00, -5.524419e-02},
  { 3.409761e-01,  2.728631e-01,  8.996005e-01,  5.463433e-01,  1.299611e+00, -9.889344e-02},
  { 7.163577e-01,  4.503296e-02,  6.962785e-01,  3.784188e-01,  1.304551e+00, -1.417442e-01},
  {-4.725543e-02,  9.011530e-01, -4.309179e-01,  3.944764e-01,  1.297705e+00, -1.578221e-01},
  {-3.641204e-02,  1.824675e-01,  9.825374e-01,  3.159397e-01,  1.290426e+00, -1.144232e-01},
  {-8.818422e-01,  4.366299e-01,  1.780692e-01,  2.591049e-01,  1.275194e+00, -1.687093e-01},
  { 1.525092e-02,  7.397757e-01, -6.726807e-01,  4.837052e-01,  1.286673e+00, -2.317445e-01},
  { 5.608594e-01,  4.237649e-01,  7.112384e-01,  4.030200e-01,  1.299509e+00, -2.044721e-01},
  {-6.048946e-01,  1.498564e-01,  7.820777e-01,  3.690989e-01,  1.312484e+00,  1.847927e-01},
  { 6.557525e-01,  2.705294e-01,  7.048422e-01,  4.555253e-01,  1.295680e+00,  1.425131e-01},
  { 4.357236e-02,  9.829581e-01,  1.785915e-01,  4.361040e-01,  1.310888e+00,  9.728332e-02},
  {-7.680880e-01,  6.325905e-01,  9.934822e-02,  3.564697e-01,  1.308860e+00, -4.230218e-02},
  {-5.414525e-01,  3.558106e-01, -7.617271e-01,  4.689891e-01,  1.330080e+00, -9.276380e-02},
  {-2.570980e-01,  7.456779e-01, -6.147074e-01,  4.355008e-01,  1.327187e+00, -1.017586e-01},
  { 6.478330e-01,  7.577277e-01, -7.849198e-02,  5.878694e-01,  1.302530e+00, -1.349397e-01},
  {-1.439355e-01,  2.306065e-01, -9.623426e-01,  5.294350e-01,  1.326651e+00, -1.673811e-01},
  { 3.738770e-01,  8.712807e-01,  3.179400e-01,  3.742820e-01,  1.310779e+00, -1.411106e-01},
  {-4.085262e-01,  6.622866e-01,  6.280786e-01,  3.077455e-01,  1.305005e+00, -1.255381e-01},
  {-2.627696e-01,  7.385243e-01, -6.209138e-01,  2.818463e-01,  1.309065e+00, -1.658370e-01},
  { 8.000000e-01, -6.000000e-01,  0.000000e+00,  4.156715e-01,  1.309726e+00, -2.027253e-01},
  { 3.121858e-01,  8.660622e-01,  3.904821e-01,  4.159644e-01,  1.322821e+00,  1.421100e-01},
  { 4.936225e-01,  5.024220e-01,  7.098654e-01,  5.071824e-01,  1.308438e+00,  8.154133e-02},
  { 3.180460e-01,  7.838422e-01, -5.333273e-01,  5.118794e-01,  1.329842e+00, -4.296726e-02},
  { 4.225576e-01,  8.695104e-01, -2.557280e-01,  5.603749e-01,  1.316692e+00, -4.526925e-03},
  { 6.183089e-01,  7.552410e-01, -2.174975e-01,  5.148860e-01,  1.354800e+00, -1.609160e-01},
  {-9.917179e-02,  9.942537e-01,  4.030618e-02,  4.315678e-01,  1.336393e+00, -6.013007e-02},
  { 2.455755e-01, -5.541403e-01,  7.953749e-01,  2.605053e-01, -1.266289e+00, -5.227747e-01},
  { 2.455755e-01, -5.541403e-01,  7.953749e-01,  2.217757e-01, -1.269859e+00, -5.133043e-01},
  { 9.191202e-01, -2.648346e-02,  3.930861e-01,  2.215206e-01, -1.277346e+00, -5.092056e-01},
  { 2.455755e-01, -5.541403e-01,  7.953749e-01,  2.633061e-01, -1.278499e+00, -5.321460e-01},
  { 8.562675e-01, -5.055956e-01, -1.057307e-01,  2.691940e-01, -1.302160e+00, -5.417698e-01},
  { 9.425119e-01, -7.364846e-02, -3.259557e-01,  2.589513e-01, -1.276229e+00, -5.764639e-01},
  { 2.685814e-01, -9.626571e-01, -3.398749e-02,  1.897561e-01, -1.342760e+00, -5.335897e-01},
  {-4.159181e-02, -9.597456e-01, -2.777744e-01,  1.097750e-01, -1.252405e+00, -6.993098e-01},
  {-4.109965e-01, -2.748260e-01, -8.692253e-01,  1.168261e-01, -1.246336e+00, -7.160262e-01},
  { 2.510570e-01, -5.625333e-01,  7.877352e-01,  1.093080e-01, -1.247199e+00, -6.986352e-01},
  { 6.838642e-01, -5.529796e-01,  4.759656e-01,  3.517028e-01, -1.191077e+00, -7.676636e-02},
  {-2.480928e-01, -8.602617e-01,  4.454210e-01,  1.718046e-01, -1.218207e+00, -5.227609e-01},
  { 3.767616e-01, -8.779612e-01, -2.953553e-01,  3.207281e-01, -1.208168e+00, -5.645075e-01},
  { 6.346705e-01, -6.320949e-01,  4.445779e-01,  3.266555e-01, -1.194869e+00, -5.446817e-01},
  { 7.903301e-01, -5.378450e-01, -2.934301e-01,  3.453994e-01, -1.172448e+00, -5.849119e-01},
  { 8.540796e-01,  1.329129e-01,  5.028740e-01,  3.488044e-01, -1.164589e+00, -5.844439e-01},
  {-4.168974e-01, -3.466948e-01,  8.402376e-01,  2.500067e-01, -1.134187e+00,  8.723167e-02},
  { 3.626165e-01, -8.872911e-01,  2.849978e-01,  3.367144e-01, -1.112221e+00,  1.531035e-01},
  {-5.190554e-01, -8.463747e-01,  1.192956e-01,  3.072625e-01, -1.110982e+00,  1.226694e-01},
  {-1.164336e-01, -2.263619e-01, -9.670592e-01, -1.365447e-01, -1.017970e+00,  1.508909e-01},
  { 1.497952e-01,  2.834699e-01,  9.472097e-01, -1.422503e-01, -1.029336e+00,  1.514216e-01},
  {-3.824005e-01, -3.815865e-01, -8.415233e-01, -1.592820e-01, -1.026821e+00,  1.676244e-01},
  { 3.069775e-01,  2.221070e-01,  9.254368e-01, -1.720674e-01, -1.030998e+00,  1.661248e-01},
  {-3.745874e-01, -4.502654e-01, -8.105217e-01, -1.583085e-01, -1.036258e+00,  1.626884e-01},
  { 1.995906e-01,  1.245125e-01,  9.719363e-01, -1.299906e-01, -1.011735e+00,  1.457248e-01},
  {-4.199083e-01, -4.269156e-01, -8.008871e-01, -1.689392e-01, -1.025433e+00,  1.708362e-01},
  {-1.354034e-01, -9.904075e-01,  2.755006e-02,  9.397112e-02, -1.032272e+00,  3.846073e-01},
  {-2.397705e-01, -9.707465e-01,  1.270583e-02,  5.744752e-02, -1.025085e+00,  3.705580e-01},
  { 4.688467e-01, -5.567904e-01, -6.856874e-01,  3.243428e-01, -1.009349e+00,  3.320867e-01},
  { 2.724377e-01, -7.535076e-01, -5.983344e-01,  3.004263e-01, -1.022947e+00,  3.213472e-01},
  { 5.162233e-01,  3.717485e-01, -7.715676e-01,  1.013226e-01, -9.564896e-01, -3.829792e-01},
  { 5.019469e-01, -1.459015e-02, -8.647754e-01, -2.254423e-01, -9.057015e-01, -7.636243e-01},
  {-7.705210e-01, -3.344307e-01,  5.426356e-01,  1.906576e-01, -8.493665e-01,  5.815162e-01},
  {-8.288473e-01, -2.500102e-01,  5.005069e-01,  3.407625e-01, -8.160682e-01,  5.950335e-01},
  {-5.962803e-01, -5.425829e-01,  5.916533e-01,  3.319387e-01, -8.037328e-01,  5.865830e-01},
  {-3.197223e-01,  3.144674e-02,  9.469893e-01, -2.247024e-01, -6.584976e-01, -9.867156e-02},
  {-1.582001e-01,  5.969959e-01,  7.864913e-01, -2.124214e-01, -6.386271e-01, -9.944552e-02},
  { 4.316009e-01,  8.486556e-01,  3.057847e-01, -3.069139e-01, -5.830441e-01,  3.315948e-01},
  { 3.034337e-01,  5.471452e-01,  7.801026e-01, -2.715285e-01, -5.752519e-01,  3.149121e-01},
  {-3.358344e-01, -9.396491e-01, -6.538171e-02, -3.214153e-01, -5.874716e-01,  3.166261e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  7.607965e-02, -5.274378e-01,  7.507126e-01},
  {-1.610388e-01, -2.972697e-01,  9.411149e-01,  6.972667e-02, -4.960594e-01,  7.530438e-01},
  {-9.827452e-01,  1.626876e-01, -8.800397e-02,  4.631891e-02, -4.706710e-01,  7.219280e-01},
  {-9.246207e-01, -3.764667e-01, -5.787425e-02,  4.047056e-02, -4.550889e-01,  7.140027e-01},
  {-3.435696e-01,  9.271468e-01,  1.495285e-01,  3.740146e-02, -4.543912e-01,  7.074778e-01},
  { 8.520713e-01, -4.978637e-01,  1.615743e-01,  4.431219e-02, -4.660281e-01,  7.205223e-01},
  { 9.255055e-01,  1.474453e-01, -3.488544e-01,  3.116982e-01, -4.874209e-01, -4.092864e-01},
  { 8.440948e-01,  2.633849e-01,  4.670464e-01,  3.050191e-01, -4.616321e-01, -4.230857e-01},
  {-7.794199e-01,  5.746731e-01,  2.495102e-01, -5.626976e-01, -4.030418e-01, -2.492590e-01},
  {-7.995998e-01,  5.996646e-01, -3.229025e-02, -5.413872e-01, -3.989544e-01, -2.827160e-01},
  { 8.738272e-01, -6.373241e-02, -4.820418e-01, -6.224070e-02, -3.992938e-01, -3.787200e-01},
  {-4.496079e-01, -8.232681e-02, -8.894240e-01, -2.397566e-01, -1.746729e-01, -1.143606e-01},
  { 4.391443e-01,  2.977462e-01, -8.476434e-01, -1.847825e-01, -1.371977e-01, -9.407830e-02},
  { 8.640503e-01,  5.000723e-01, -5.783575e-02, -3.896027e-01, -1.306512e-01, -7.010247e-01},
  {-6.156685e-01, -4.860411e-01,  6.202551e-01, -3.121447e-01, -1.853268e-01, -6.872833e-01},
  { 7.748786e-01, -5.850844e-01,  2.392474e-01, -2.951013e-01, -2.239717e-01, -6.935894e-01},
  {-9.337968e-02,  5.952228e-01, -7.981165e-01, -4.331648e-01, -1.435435e-01,  3.482287e-01},
  {-2.117624e-01,  7.494696e-01, -6.272577e-01, -4.368367e-01, -1.077023e-01,  3.704081e-01},
  {-2.498171e-01,  5.788505e-01, -7.762238e-01, -3.717177e-01, -1.372012e-01,  3.548779e-01},
  {-1.826671e-01,  6.968514e-01, -6.935639e-01, -3.676897e-01, -1.297335e-01,  3.613201e-01},
  {-5.157452e-01,  7.499117e-01, -4.142936e-01, -4.657651e-01, -1.166248e-01,  3.889554e-01},
  { 3.228622e-01, -5.336737e-01,  7.816344e-01, -3.821576e-01, -1.141999e-01,  4.077159e-01},
  {-5.719885e-01, -5.759980e-01,  5.839996e-01, -4.218308e-01, -1.064673e-01,  4.112059e-01},
  { 4.321725e-01, -6.537245e-01,  6.211854e-01,  4.001581e-01, -1.298672e-01, -3.632286e-02},
  { 7.227817e-01,  2.265382e-02,  6.907049e-01,  4.772315e-01,  1.184664e-01,  8.817438e-01},
  {-6.588079e-01, -4.760748e-01,  5.825160e-01, -8.099261e-02,  1.852400e-01, -5.663214e-02},
  {-8.281671e-01,  3.734140e-01,  4.179728e-01, -1.263596e-01,  2.581752e-01, -7.405911e-02},
  {-9.971440e-01,  4.428880e-02, -6.117547e-02, -1.352302e-01,  2.841268e-01, -1.252847e-01},
  { 1.035587e-01, -3.835640e-01,  9.176897e-01,  9.527490e-02,  3.887525e-01, -4.531825e-01},
  {-3.384973e-01,  6.924035e-01,  6.371790e-01, -1.868297e-02,  3.504831e-01, -4.326778e-01},
  { 8.304679e-01,  2.654114e-01,  4.897754e-01,  1.016328e-01,  3.921019e-01, -4.512885e-01},
  {-4.552723e-03,  4.420097e-01, -8.969988e-01,  1.065854e-01,  3.861090e-01, -4.545425e-01},
  { 1.035587e-01, -3.835640e-01,  9.176897e-01,  1.035173e-01,  3.879191e-01, -4.544610e-01},
  {-8.950309e-01,  3.569347e-01,  2.674274e-01, -7.424083e-02,  4.765279e-01, -1.846984e-01},
  { 9.695280e-01,  3.759239e-02,  2.420790e-01,  2.870185e-01,  4.940002e-01, -6.323119e-01},
  { 9.528839e-01,  2.219604e-01, -2.067505e-01,  2.865581e-01,  4.970790e-01, -6.652564e-01},
  { 7.718737e-01, -1.785021e-01, -6.102033e-01,  2.783559e-01,  5.040376e-01, -6.793735e-01},
  { 9.552785e-01,  2.126320e-02, -2.949423e-01,  2.887827e-01,  5.011420e-01, -6.577581e-01},
  { 7.649462e-01,  4.433785e-01, -4.671968e-01,  2.664594e-01,  5.079143e-01, -6.878812e-01},
  { 2.383466e-01,  9.004604e-01,  3.638159e-01, -1.706433e-01,  5.591516e-01, -2.923251e-01},
  { 4.722308e-01,  6.986601e-01,  5.374683e-01, -1.326664e-01,  5.498944e-01, -3.189942e-01},
  { 8.114028e-01,  5.280180e-01,  2.506442e-01, -1.204297e-01,  5.420485e-01, -3.250051e-01},
  { 5.699732e-01,  7.841522e-01,  2.454298e-01,  2.163213e-01,  6.847960e-01,  5.801874e-01},
  { 9.801077e-01, -1.795694e-01, -8.452046e-02,  3.937688e-01,  7.990413e-01, -4.173456e-01},
  { 1.216764e-01, -1.274933e-01,  9.843476e-01,  1.666940e-01,  9.542588e-01,  5.289125e-01},
  {-3.318498e-02,  8.923374e-01, -4.501474e-01,  4.702716e-01,  1.084455e+00,  4.767913e-01},
  {-4.215944e-01,  8.381454e-01,  3.460786e-01,  4.332374e-01,  1.101492e+00,  5.065364e-01},
  {-2.829601e-01,  8.975673e-01, -3.380924e-01,  4.086682e-01,  1.099687e+00,  4.993729e-01},
  { 2.425341e-01, -2.333996e-01,  9.416485e-01,  4.385160e-01,  1.106550e+00,  5.020766e-01},
  { 2.748633e-01,  6.722541e-01, -6.874043e-01,  1.766375e-01,  1.184812e+00,  1.968957e-01},
  {-6.613093e-01,  2.454850e-01,  7.088069e-01,  1.676382e-01,  1.172148e+00,  1.887038e-01},
  {-1.170932e-01,  8.088807e-01,  5.761954e-01,  3.825662e-01,  1.229215e+00,  4.266689e-01},
  {-1.148665e-01,  1.675809e-01,  9.791436e-01,  3.683087e-01,  1.209910e+00,  4.392067e-01},
  {-9.331495e-02,  6.315293e-01,  7.697163e-01,  1.057356e-01,  1.226898e+00, -5.899253e-02},
  { 9.949472e-01,  1.003869e-01,  1.573309e-03,  4.002388e-01,  1.240628e+00, -1.600591e-01},
  { 8.705373e-01, -7.630357e-02, -4.861509e-01,  3.810898e-01,  1.263855e+00, -1.764147e-01},
  { 6.666417e-01,  6.775938e-01,  3.105733e-01,  4.021575e-01,  1.237583e+00, -1.665178e-01},
  { 7.002800e-01,  7.069385e-01, -9.922578e-02,  3.897066e-01,  1.255428e+00, -1.756451e-01},
  {-7.034508e-01, -9.969388e-02,  7.037174e-01,  3.754390e-01,  1.253597e+00, -1.901666e-01},
  {-3.490025e-01, -6.446236e-02,  9.349020e-01,  3.874761e-01,  1.270310e+00, -1.705979e-01},
  {-9.531379e-01,  2.996931e-01, -4.137855e-02,  3.794607e-01,  1.266152e+00, -1.843678e-01},
  { 1.826416e-01,  1.327718e-01,  9.741733e-01,  3.925613e-01,  1.283132e+00, -1.732594e-01},
  {-7.351705e-01,  5.780940e-01,  3.540221e-01,  3.992411e-01,  1.299547e+00, -1.768015e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  5.347421e-01,  1.227811e+00,  3.315183e-01},
  { 1.533637e-01,  8.160797e-01,  5.572194e-01,  2.146453e-01,  1.270320e+00,  5.114979e-02},
  {-5.883484e-02,  9.842694e-01, -1.665902e-01,  1.703115e-01,  1.307635e+00, -8.239356e-02},
  { 3.083747e-01, -7.899451e-02,  9.479794e-01,  2.693117e-01, -1.137488e+00,  9.255343e-02},
  { 6.649987e-01,  2.295708e-01,  7.106856e-01,  1.182028e-01, -4.903750e-01,  7.310677e-01},
  {-6.046720e-01,  3.155617e-01,  7.312952e-01, -1.144538e-01,  2.486276e-01, -3.665022e-02},
  {-8.469588e-02,  8.698676e-01,  4.859599e-01, -1.354286e-01, -1.019949e+00,  1.594810e-01},
  {-8.240922e-01,  5.445384e-01, -1.560448e-01,  4.338166e-02, -1.290755e+00, -2.613423e-01},
  { 6.133392e-01, -4.147120e-01,  6.721823e-01,  2.025852e-01, -1.275977e+00, -4.648384e-01},
  {-5.994874e-01, -5.498818e-01,  5.815883e-01,  3.941502e-03, -1.258480e+00, -5.674006e-01},
  { 6.927691e-01, -3.423083e-01, -6.347410e-01,  3.941502e-03, -1.258480e+00, -5.674006e-01},
  {-8.264349e-01, -4.832602e-01,  2.889028e-01, -1.775244e-02, -1.247054e+00, -5.789592e-01},
  {-6.404063e-02, -9.914668e-01, -1.135442e-01,  1.154614e-01, -1.250067e+00, -7.229298e-01},
  {-6.747056e-01, -4.114010e-01, -6.127983e-01,  5.224332e-02, -1.204048e+00, -2.000742e-01},
  {-7.566389e-01,  5.705974e-01, -3.192431e-01, -7.542343e-02, -1.243796e+00, -4.562029e-01},
  {-2.461319e-01, -3.750698e-02,  9.685104e-01,  5.895132e-02, -1.171948e+00, -4.202662e-01},
  { 4.296321e-01,  1.265555e-01, -8.940918e-01,  3.343648e-02, -1.237410e+00, -5.465720e-01},
  {-3.552465e-01,  2.677514e-01, -8.956055e-01,  1.013518e-01, -1.242351e+00, -6.843586e-01},
  { 7.512704e-01, -2.368290e-01,  6.160397e-01,  1.013518e-01, -1.242351e+00, -6.843586e-01},
  {-6.854199e-01,  4.190672e-01, -5.954681e-01,  1.062896e-01, -1.208414e+00, -6.812409e-01},
  { 4.801542e-01, -1.626941e-01,  8.619644e-01,  1.208330e-01, -1.213942e+00, -6.856660e-01},
  { 7.330949e-01, -6.464410e-01, -2.113903e-01, -2.672584e-02, -1.197629e+00, -4.891052e-01},
  { 7.512704e-01, -2.368290e-01,  6.160397e-01,  1.180478e-01, -1.194420e+00, -6.862930e-01},
  { 7.512704e-01, -2.368290e-01,  6.160397e-01,  1.130085e-01, -1.181517e+00, -6.751871e-01},
  {-2.510570e-01,  5.625333e-01, -7.877352e-01,  1.019201e-01, -1.228122e+00, -6.826572e-01},
  { 3.661190e-01, -8.707734e-01, -3.281930e-01,  1.907368e-01, -1.164007e+00, -1.717475e-01},
  {-5.855178e-01,  2.140753e-01,  7.818828e-01,  2.389773e-01, -1.151324e+00, -1.554587e-01},
  { 8.936060e-01, -3.597870e-01,  2.683686e-01, -2.583183e-03, -1.136790e+00, -5.730994e-01},
  { 8.484489e-01, -3.436533e-01, -4.025382e-01,  3.504126e-01, -1.135065e+00, -6.062593e-01},
  {-4.430618e-01, -7.574210e-01, -4.795934e-01,  1.835757e-01, -1.191694e+00, -6.291927e-01},
  {-4.430618e-01, -7.574210e-01, -4.795934e-01,  3.528919e-01, -1.117463e+00, -1.563957e-01},
  {-1.508331e-01,  2.019982e-01,  9.677014e-01,  3.474524e-01, -1.113246e+00, -6.197090e-01},
  {-3.440804e-01, -7.649189e-01, -5.445252e-01,  1.756916e-01, -1.198671e+00, -6.108906e-01},
  {-4.233391e-01, -7.895415e-01, -4.443066e-01,  1.850868e-01, -1.182072e+00, -6.315288e-01},
  { 3.897837e-01, -7.837251e-01,  4.835738e-01,  2.120776e-01, -1.106595e+00, -4.813935e-01},
  { 2.163673e-01,  5.809612e-01,  7.846460e-01,  3.197320e-01, -1.097308e+00, -6.245699e-01},
  { 4.331274e-01,  5.412353e-01,  7.207391e-01,  3.117305e-01, -1.097391e+00, -6.209602e-01},
  { 8.300893e-01, -2.023964e-01, -5.196033e-01,  8.506460e-02, -1.112967e+00, -3.378322e-01},
  { 8.149385e-01, -3.138493e-01,  4.872102e-01,  2.733226e-01, -1.108803e+00, -5.821823e-01},
  { 6.370416e-01, -4.870599e-01, -5.974534e-01,  2.895543e-01, -1.083770e+00, -9.551112e-02},
  { 4.291936e-01, -3.632921e-01, -8.269291e-01,  4.293982e-01, -1.035481e+00, -2.202212e-01},
  {-9.571597e-01, -8.777764e-02,  2.759354e-01, -5.182353e-02, -1.106386e+00,  8.594772e-02},
  { 2.915713e-01, -4.965508e-01, -8.175717e-01,  3.478794e-01, -1.045275e+00, -1.861328e-01},
  { 4.742986e-01,  8.791412e-01,  4.638480e-02,  3.581391e-01, -1.038187e+00, -4.761482e-01},
  {-9.642435e-01,  9.862224e-02, -2.459840e-01, -3.959794e-02, -1.056756e+00,  8.683616e-02},
  {-3.025002e-01,  5.565205e-01, -7.738078e-01, -1.586555e-02, -1.078642e+00,  7.335673e-02},
  { 3.016399e-01, -8.714072e-01, -3.868631e-01,  1.825982e-01, -1.028967e+00, -6.012150e-01},
  {-3.325005e-01,  9.394311e-01, -8.314199e-02,  1.825982e-01, -1.028967e+00, -6.012150e-01},
  { 3.029057e-01, -3.357392e-01,  8.919234e-01,  1.236543e-01, -1.050758e+00,  1.577735e-01},
  { 3.014769e-01, -5.482211e-01,  7.801061e-01,  2.784295e-03, -1.076932e+00,  6.729592e-02},
  { 2.586420e-01, -9.988100e-02,  9.607956e-01,  3.202691e-03, -1.072662e+00,  8.138730e-02},
  { 6.258657e-01,  6.796484e-01,  3.825836e-01, -9.656018e-02, -1.082635e+00,  1.620382e-01},
  { 1.627807e-01, -1.060175e-01,  9.809499e-01, -1.464265e-01, -1.082663e+00, -6.924355e-02},
  { 7.498329e-01, -1.510293e-01, -6.441590e-01,  4.506577e-01, -9.894612e-01, -9.555981e-02},
  { 4.013106e-01,  9.015720e-01, -1.616102e-01, -1.735795e-01, -1.040218e+00,  1.757607e-01},
  { 5.437992e-01, -7.104872e-01, -4.466436e-01,  2.471539e-01, -9.870225e-01, -6.453612e-01},
  {-7.309832e-02, -8.929727e-01, -4.441356e-01,  2.814183e-01, -1.014261e+00,  3.070111e-01},
  {-3.389087e-01, -9.148511e-01, -2.195185e-01,  2.814183e-01, -1.014261e+00,  3.070111e-01},
  {-1.572039e-01, -8.342484e-01, -5.285040e-01, -1.912261e-01, -1.008760e+00,  1.585678e-01},
  {-5.436928e-01,  6.703827e-01,  5.049607e-01, -2.205296e-01, -9.025204e-01, -7.548356e-01},
  {-6.639868e-01, -7.456736e-01,  5.560984e-02,  2.518900e-01, -9.638718e-01,  3.117916e-01},
  {-5.436928e-01,  6.703827e-01,  5.049607e-01, -1.920931e-01, -8.871832e-01, -7.445796e-01},
  {-3.581303e-01,  3.083806e-01,  8.812742e-01, -1.108711e-01, -1.017795e+00,  1.556152e-01},
  { 3.599833e-01,  6.500252e-01, -6.692378e-01, -5.960330e-02, -9.265804e-01,  3.332438e-01},
  { 7.568988e-02,  9.908603e-01,  1.116554e-01, -2.399848e-01, -8.981073e-01,  3.102740e-01},
  {-2.179905e-01, -5.577570e-01, -8.008665e-01,  1.451309e-01, -9.023165e-01,  5.231268e-02},
  { 1.662741e-01,  2.612129e-01,  9.508527e-01,  1.428509e-01, -8.562274e-01,  2.226803e-01},
  { 8.123621e-02, -3.098316e-01, -9.473147e-01, -3.427629e-01, -8.745696e-01, -4.376657e-01},
  { 9.258233e-01,  1.094117e-01,  3.617738e-01,  3.749554e-01, -9.412742e-01,  3.779192e-01},
  { 4.112279e-01, -6.762941e-01, -6.111611e-01,  3.746267e-01, -9.313692e-01,  3.716766e-01},
  { 7.568988e-02,  9.908603e-01,  1.116554e-01, -3.140447e-01, -8.857111e-01,  2.504710e-01},
  { 1.228081e-01, -3.379593e-01, -9.331140e-01,  3.772016e-01, -8.944976e-01,  3.580244e-01},
  { 1.130803e-01,  4.473126e-01,  8.872002e-01,  2.298772e-01, -7.875910e-01, -4.668553e-01},
  {-7.309482e-01, -6.529892e-01, -1.982924e-01,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  { 4.338174e-01, -8.466343e-01, -3.082417e-01, -1.603299e-01, -8.463802e-01,  4.213949e-01},
  { 5.719556e-01,  8.202842e-01,  7.874302e-04, -4.334200e-02, -7.920970e-01,  3.833595e-01},
  {-4.060017e-01,  7.610265e-01, -5.059657e-01,  3.816118e-01, -8.112080e-01, -1.758549e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.770379e-01, -7.685767e-01, -2.057912e-01},
  { 1.130803e-01,  4.473126e-01,  8.872002e-01,  2.103602e-01, -7.605381e-01, -4.780074e-01},
  { 3.503065e-01,  7.012244e-01, -6.209426e-01, -5.891141e-02, -7.812388e-01,  3.810968e-01},
  { 8.123776e-01,  1.965211e-01,  5.490193e-01,  2.045172e-01, -7.488258e-01, -4.788222e-01},
  { 6.537061e-01,  5.931680e-01, -4.699151e-01,  1.060376e-01, -7.392733e-01,  4.324163e-01},
  { 6.197077e-01, -1.946030e-01,  7.603237e-01, -3.269689e-01, -7.365552e-01,  1.666237e-01},
  { 6.769763e-01,  4.762189e-01, -5.611762e-01,  1.646421e-01, -6.796985e-01, -2.446165e-01},
  { 6.618485e-01, -7.496173e-01,  5.501290e-03,  1.646421e-01, -6.796985e-01, -2.446165e-01},
  {-7.884452e-01, -4.990549e-01, -3.595808e-01, -5.232871e-01, -6.449023e-01, -2.560784e-01},
  {-3.135127e-01, -2.640942e-01,  9.121206e-01,  3.922919e-01, -7.534553e-01,  5.077713e-01},
  {-4.390803e-01, -4.543840e-02,  8.972981e-01,  4.042302e-01, -7.072245e-01,  4.297415e-01},
  {-7.520887e-01,  5.403931e-01, -3.772770e-01, -1.359133e-01, -6.618457e-01,  2.718591e-01},
  { 4.693480e-01,  8.684129e-01,  1.599108e-01, -5.003647e-01, -6.450074e-01, -2.488408e-01},
  { 8.080460e-01,  3.264386e-01, -4.904075e-01,  2.117135e-01, -6.650108e-01, -5.194720e-01},
  {-4.475227e-02, -9.989456e-01,  1.024247e-02, -3.887254e-01, -6.837709e-01, -1.124682e-01},
  { 5.660938e-01, -2.166878e-02, -8.240560e-01, -3.677509e-01, -6.850427e-01, -1.202861e-01},
  { 6.244498e-02,  9.980369e-01,  4.814742e-03, -4.255934e-01, -6.492051e-01, -2.423792e-01},
  {-4.868323e-01, -1.206985e-01, -8.651164e-01, -5.146338e-01, -6.185260e-01, -2.431602e-01},
  {-4.740008e-01,  3.097985e-01,  8.242258e-01, -4.417795e-01, -6.403803e-01, -4.071318e-01},
  {-6.695631e-01, -7.332639e-01, -1.183608e-01, -4.605616e-01, -6.424230e-01, -4.292938e-01},
  { 5.531547e-01,  1.686732e-01,  8.158243e-01,  2.462152e-01, -6.352830e-01,  1.699464e-01},
  { 3.315126e-02, -2.966674e-01,  9.544053e-01, -4.227870e-01, -6.482350e-01, -2.463989e-01},
  {-1.488754e-01, -9.746967e-01, -1.667406e-01, -4.316677e-01, -6.520817e-01, -2.565584e-01},
  {-2.771811e-01,  8.488535e-01, -4.501314e-01, -4.102846e-01, -6.079087e-01, -4.432414e-01},
  {-2.311006e-01, -7.967995e-01, -5.583038e-01, -4.102846e-01, -6.079087e-01, -4.432414e-01},
  {-7.091185e-01, -6.331457e-01, -3.102857e-01,  7.068599e-02, -6.559319e-01,  6.570113e-01},
  {-3.351521e-01, -2.036917e-01, -9.198819e-01, -1.143001e-01, -6.458164e-01,  8.317413e-02},
  { 9.582284e-02, -8.878973e-01, -4.499516e-01, -4.815312e-01, -6.517119e-01, -2.321034e-01},
  { 5.964251e-01,  2.388451e-02, -8.023133e-01, -3.357650e-03, -6.092564e-01, -4.231498e-01},
  {-3.475552e-01,  7.370570e-01,  5.796139e-01, -1.821376e-01, -6.002050e-01, -1.647214e-01},
  { 3.889921e-01,  9.076202e-01,  1.578317e-01, -1.703453e-02, -5.841410e-01, -5.156518e-01},
  { 3.889921e-01,  9.076202e-01,  1.578317e-01,  1.275683e-01, -5.463325e-01, -5.912398e-01},
  { 6.754671e-01,  5.393133e-01, -5.028770e-01,  2.650600e-01, -6.011772e-01,  5.594687e-01},
  {-3.035870e-01,  9.358066e-01,  1.791674e-01, -3.319595e-01, -5.783841e-01,  2.798629e-01},
  { 5.406696e-01,  5.588218e-01,  6.288041e-01, -2.895268e-01, -5.814705e-01,  3.359143e-01},
  { 7.958882e-01,  6.050802e-01,  2.097809e-02, -3.293589e-01, -5.811729e-01,  2.616392e-01},
  {-4.852685e-01, -8.734069e-01,  4.092618e-02, -4.441509e-01, -5.770977e-01, -5.822313e-01},
  { 2.537011e-02,  9.451092e-01,  3.257683e-01, -2.429596e-01, -5.398430e-01,  2.363629e-01},
  { 3.598667e-02, -9.982603e-01,  4.670598e-02,  3.501273e-01, -5.291815e-01, -1.176423e-01},
  {-8.996624e-01,  4.346639e-01, -4.092711e-02,  3.670606e-01, -5.197719e-01, -9.846386e-02},
  { 1.610736e-01, -8.957613e-01, -4.143273e-01,  3.473852e-01, -5.233240e-01, -1.691056e-01},
  { 1.610736e-01, -8.957613e-01, -4.143273e-01,  3.428349e-01, -5.175011e-01, -1.834634e-01},
  { 4.803718e-01, -3.267969e-01, -8.139083e-01,  2.681342e-01, -5.177783e-01,  2.390759e-01},
  {-1.422500e-01, -6.920964e-01, -7.076493e-01, -5.402737e-01, -4.922094e-01,  1.545625e-01},
  {-2.041667e-01, -9.375089e-01,  2.817676e-01,  3.634696e-01, -5.285535e-01, -1.127902e-01},
  {-8.996624e-01,  4.346639e-01, -4.092711e-02,  3.642888e-01, -5.300106e-01, -1.462743e-01},
  {-8.944272e-01,  0.000000e+00,  4.472136e-01, -9.214512e-02, -5.045194e-01,  5.957640e-01},
  {-8.944272e-01,  0.000000e+00,  4.472136e-01, -9.556206e-02, -5.020185e-01,  5.776576e-01},
  { 7.367116e-01, -4.386525e-01,  5.146261e-01,  3.613628e-01, -5.057603e-01, -6.715044e-02},
  {-4.676999e-01, -6.649250e-01, -5.823500e-01,  3.393305e-01, -4.929736e-01, -2.194906e-01},
  { 4.000201e-01, -8.250040e-01, -3.991896e-01,  4.453505e-02, -4.672993e-01,  7.478225e-01},
  {-6.292709e-01, -5.669792e-01, -5.315568e-01,  3.392508e-01, -4.495685e-01, -2.656938e-01},
  {-6.324214e-01,  4.000015e-01, -6.633567e-01, -4.098283e-01, -4.770969e-01, -6.289646e-01},
  { 7.808251e-01,  5.578719e-01,  2.812311e-01, -5.289320e-01, -3.985800e-01,  3.046018e-01},
  {-6.470873e-02, -9.147411e-02, -9.937028e-01,  3.181449e-01, -4.149960e-01, -2.799758e-01},
  {-2.766473e-01,  7.817333e-01,  5.588912e-01,  1.449640e-01, -3.478000e-01, -4.848408e-01},
  {-5.461864e-01,  4.768535e-01, -6.886880e-01,  1.583155e-01, -3.356630e-01, -4.952081e-01},
  {-5.461864e-01,  4.768535e-01, -6.886880e-01,  2.677988e-01, -3.877818e-01,  4.518062e-01},
  {-2.766473e-01,  7.817333e-01,  5.588912e-01,  1.716540e-01, -3.356586e-01, -4.886119e-01},
  { 1.093509e-01,  9.812914e-01,  1.584604e-01,  1.816661e-01, -3.344951e-01, -4.867424e-01},
  {-4.300219e-01,  8.652366e-01, -2.577727e-01,  1.192460e-01, -3.557017e-01, -4.684603e-01},
  {-8.319548e-01,  5.434033e-01,  1.120894e-01, -5.326867e-01, -3.407793e-01, -4.895087e-01},
  {-8.319548e-01,  5.434033e-01,  1.120894e-01,  2.802197e-01, -3.809185e-01,  4.648960e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  2.237751e-01, -3.090734e-01, -1.245969e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  2.099349e-01, -3.172332e-01, -1.449311e-01},
  { 8.783851e-01, -4.775469e-01,  1.971481e-02,  3.940048e-02, -4.667832e-01, -1.837498e-01},
  {-9.898453e-01,  1.393179e-01, -2.822690e-02, -2.478101e-01, -3.565545e-01, -2.555285e-01},
  {-7.372483e-01,  3.454536e-01,  5.806261e-01,  1.044477e-01, -3.496335e-01, -2.294895e-01},
  { 1.402254e-02,  3.865408e-01, -9.221657e-01, -4.599110e-01, -3.582999e-01, -4.746865e-01},
  { 3.369274e-01, -9.332132e-01, -1.248723e-01, -4.759339e-01, -3.559213e-01, -4.661681e-01},
  {-2.214954e-01,  8.653798e-01,  4.495082e-01, -5.091901e-01, -3.002276e-01,  1.031080e-01},
  {-1.153507e-02,  9.732357e-01,  2.295196e-01, -5.091901e-01, -3.002276e-01,  1.031080e-01},
  { 1.096241e-01, -5.386404e-01,  8.353736e-01,  3.708170e-01, -3.430246e-01,  7.753097e-02},
  {-5.421202e-01, -4.680347e-01, -6.978891e-01, -4.885770e-01, -3.385799e-01, -1.113510e-01},
  {-1.543257e-01,  7.642019e-01, -6.262420e-01, -5.494620e-01, -3.007611e-01, -2.544072e-01},
  { 5.585473e-01, -7.977861e-01, -2.270730e-01,  1.870266e-01, -3.403117e-01, -4.544217e-01},
  { 9.710990e-01, -1.630929e-01,  1.742623e-01, -5.147318e-02, -3.172988e-01,  3.659073e-01},
  { 3.741098e-01,  9.271495e-01,  2.087563e-02, -5.232517e-01, -2.939372e-01,  7.572800e-02},
  {-1.394843e-02,  9.991054e-01,  3.992232e-02, -5.232517e-01, -2.939372e-01,  7.572800e-02},
  { 1.180858e-02,  3.354348e-01, -9.419894e-01,  3.645782e-01, -3.236278e-01,  8.454281e-02},
  {-5.953007e-01,  5.674094e-01,  5.689145e-01, -5.264499e-01, -3.370389e-01, -3.617909e-01},
  { 4.203777e-01, -9.064003e-01, -4.148674e-02, -5.264499e-01, -3.370389e-01, -3.617909e-01},
  { 5.953007e-01, -5.674093e-01, -5.689146e-01, -5.498244e-01, -3.527142e-01, -3.706157e-01},
  {-5.703170e-01,  1.853541e-01,  8.002389e-01, -5.602701e-01, -3.517774e-01, -3.824802e-01},
  {-6.272002e-01, -7.591496e-01, -1.741034e-01, -5.179420e-01, -2.956316e-01,  5.582890e-02},
  { 4.218241e-01,  8.796922e-01, -2.195588e-01,  2.646194e-01, -2.737926e-01, -1.161068e-01},
  {-6.272624e-01,  7.746263e-01, -8.059768e-02,  2.646194e-01, -2.737926e-01, -1.161068e-01},
  {-1.874727e-01, -5.467531e-03, -9.822546e-01, -3.157398e-01, -3.143428e-01, -4.480430e-01},
  { 7.623022e-02,  8.946548e-01, -4.402065e-01, -3.057962e-01, -2.914245e-01, -9.265890e-02},
  { 2.636981e-01, -9.587383e-01, -1.062270e-01, -2.782625e-01, -2.898273e-01,  5.495690e-01},
  { 4.303933e-01, -8.872261e-01, -1.661065e-01, -4.458688e-01, -2.868084e-01, -1.747836e-01},
  { 4.696787e-01, -8.817368e-01,  4.407026e-02,  7.336315e-02, -2.830345e-01,  6.686054e-01},
  {-4.323280e-01, -8.876009e-01,  1.589250e-01, -3.237188e-01, -2.777623e-01,  2.374717e-01},
  {-4.769216e-01,  8.018996e-01, -3.598650e-01, -2.733326e-01, -2.800546e-01, -5.848776e-01},
  {-9.178833e-01,  3.801859e-01,  1.137935e-01, -3.392349e-01, -2.374704e-01,  2.740830e-01},
  { 9.004943e-01, -3.222760e-01, -2.919731e-01,  3.782415e-01, -2.386922e-01,  1.059667e-01},
  { 9.004943e-01, -3.222760e-01, -2.919731e-01,  3.730386e-01, -2.436777e-01,  9.542292e-02},
  {-1.135802e-01,  9.614007e-01,  2.506157e-01, -3.559513e-01, -1.960481e-01, -7.687665e-01},
  { 1.370260e-01, -9.627195e-01, -2.332276e-01,  3.123114e-01, -2.917272e-01, -3.123755e-01},
  { 1.113038e-02, -9.667748e-01,  2.553873e-01,  5.177156e-01, -2.732073e-01, -4.591829e-01},
  { 6.178685e-01, -7.251858e-01,  3.038816e-01,  5.129109e-01, -2.777423e-01, -4.663580e-01},
  {-9.316556e-01, -3.617218e-01, -3.428197e-02,  2.467440e-02, -2.144520e-01,  4.714754e-01},
  {-4.127724e-01,  9.106630e-01,  1.765943e-02, -3.288997e-01, -1.969916e-01, -7.419928e-01},
  {-1.393066e-01, -9.822783e-01,  1.253913e-01,  3.544426e-01, -1.825020e-01,  4.089484e-01},
  {-1.393066e-01, -9.822783e-01,  1.253913e-01,  3.000425e-01, -1.845034e-01,  3.328329e-01},
  {-3.443300e-01, -6.810867e-01, -6.461871e-01, -2.769146e-01, -1.999341e-01,  2.665164e-01},
  {-3.443300e-01, -6.810867e-01, -6.461871e-01,  4.023100e-01, -1.528243e-01, -5.216849e-02},
  { 8.619806e-01, -4.070535e-02,  5.053043e-01,  2.968405e-01, -2.346588e-01, -9.106564e-02},
  {-8.416817e-02, -8.122382e-01,  5.772218e-01,  3.219006e-01, -2.614082e-01, -1.538412e-01},
  { 7.706254e-01, -2.355410e-01, -5.921630e-01,  2.779950e-01, -2.467445e-01, -3.506235e-01},
  { 7.706254e-01, -2.355410e-01, -5.921630e-01,  3.981157e-01, -1.367740e-01, -3.965966e-02},
  { 7.895986e-01, -6.107907e-01,  5.889779e-02,  4.571109e-01, -2.068442e-01, -2.181023e-01},
  { 9.644164e-01, -2.244514e-01, -1.397230e-01,  2.908965e-01, -2.159764e-01, -3.418411e-01},
  {-1.203859e-01,  9.630868e-01,  2.407717e-01,  1.696927e-01, -1.488538e-01,  5.790180e-01},
  { 2.228113e-01, -8.966303e-01, -3.826345e-01,  3.008783e-01, -2.326493e-01, -8.385773e-02},
  {-3.046615e-01, -1.963554e-03,  9.524587e-01, -2.882164e-01, -1.910130e-01, -6.796411e-01},
  { 9.283569e-02, -8.660795e-03,  9.956438e-01, -3.586448e-01, -1.301674e-01,  3.659786e-01},
  {-3.454606e-01, -9.383957e-01,  8.400694e-03, -3.707534e-01, -1.403389e-01,  3.457538e-01},
  {-3.949692e-01,  5.428768e-01, -7.411371e-01, -3.575979e-01, -2.045662e-01, -7.300340e-01},
  {-3.949692e-01,  5.428768e-01, -7.411371e-01, -3.668106e-01, -1.959864e-01, -7.188396e-01},
  { 4.696536e-02,  4.602767e-01, -8.865324e-01,  4.000654e-01, -1.308071e-01,  1.431343e-01},
  { 7.577813e-01,  6.523029e-01, -1.638548e-02, -3.188034e-01, -1.618077e-01, -6.488538e-01},
  { 7.127332e-01, -6.090579e-02,  6.987860e-01, -7.307250e-02, -1.138106e-01,  6.438525e-01},
  {-9.803545e-01, -1.402437e-02, -1.967447e-01, -3.889423e-01, -2.017404e-01, -7.132316e-01},
  { 7.948526e-02, -9.801415e-01,  1.816720e-01,  4.452125e-01, -1.583950e-01,  4.435886e-01},
  { 7.696033e-01, -1.229299e-01,  6.265773e-01,  4.654455e-01, -1.515010e-01, -1.479623e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  4.047689e-01, -9.529200e-02, -6.064320e-01},
  { 2.888502e-01,  7.319911e-01,  6.170533e-01,  5.216538e-01, -6.205511e-02, -1.797569e-01},
  { 2.826974e-01, -3.051833e-01, -9.093653e-01,  5.420755e-01, -7.270935e-02, -1.942367e-01},
  {-2.826974e-01,  3.051833e-01,  9.093653e-01,  5.420755e-01, -7.270935e-02, -1.942367e-01},
  {-2.826974e-01,  3.051833e-01,  9.093653e-01,  5.648220e-01, -6.108575e-02, -1.910662e-01},
  { 7.966459e-01,  2.709471e-01, -5.403175e-01,  5.754007e-01, -8.581145e-02, -1.983433e-01},
  { 2.826974e-01, -3.051833e-01, -9.093653e-01,  5.410858e-01, -5.250262e-02, -2.013257e-01},
  { 9.177794e-01,  1.037243e-01,  3.833043e-01, -4.118168e-01,  2.195658e-02, -3.772669e-01},
  { 9.184947e-01, -3.923663e-01, -4.915540e-02, -4.164669e-02,  5.690560e-03, -4.585234e-01},
  { 5.547128e-01, -2.878868e-01, -7.806503e-01, -1.420251e-01,  3.716411e-02,  2.267498e-02},
  {-1.227458e-01, -7.254214e-01, -6.772719e-01, -1.024898e-01,  3.392568e-02, -6.185299e-01},
  {-4.424681e-01,  6.154239e-01,  6.522847e-01, -2.766116e-01,  7.579233e-02,  7.687390e-02},
  {-5.700595e-01,  3.276052e-01, -7.534634e-01, -2.715888e-01,  1.073713e-01,  6.531885e-02},
  {-8.334047e-01,  1.567413e-01, -5.299705e-01, -3.486679e-01,  1.012709e-01, -7.677077e-01},
  {-9.838127e-01,  8.937471e-02, -1.553212e-01,  1.862852e-01,  1.277498e-01,  5.492860e-01},
  {-7.434953e-01, -3.321446e-02, -6.679159e-01,  7.018257e-02,  1.265776e-01, -6.859877e-01},
  {-2.506772e-01, -9.676815e-01,  2.744865e-02, -3.565670e-01,  1.142283e-01,  2.046140e-01},
  { 3.219524e-01,  6.288930e-01, -7.077007e-01, -1.908141e-01,  1.535791e-01,  4.369330e-01},
  { 8.083370e-01, -5.970560e-02,  5.856847e-01,  2.494556e-01,  2.041579e-01, -3.953929e-01},
  { 9.984862e-01, -5.446236e-02, -7.697830e-03,  3.379352e-01,  2.101006e-01,  1.497482e-01},
  { 1.092314e-01, -2.521043e-01, -9.615154e-01,  3.379352e-01,  2.101006e-01,  1.497482e-01},
  {-2.803402e-01,  6.651422e-01,  6.920949e-01, -4.732112e-01,  2.276958e-01,  1.225156e-01},
  { 6.065162e-01, -3.324495e-01, -7.222295e-01,  3.407160e-01,  2.211192e-01,  1.498986e-01},
  { 9.984862e-01, -5.446236e-02, -7.697830e-03,  3.387620e-01,  2.266728e-01,  1.397328e-01},
  { 7.985108e-01, -3.780250e-01, -4.684843e-01,  2.530796e-01,  2.285938e-01, -4.004845e-01},
  { 6.832218e-02, -4.466301e-01, -8.921062e-01,  2.490119e-01,  2.130764e-01, -3.951834e-01},
  { 8.046378e-01, -9.166894e-02, -5.866471e-01,  3.399029e-01,  2.475310e-01,  1.401577e-01},
  { 3.582451e-01, -1.159595e-01,  9.263983e-01,  3.476240e-01,  2.393856e-01,  1.438816e-01},
  {-5.597994e-01,  6.958851e-01, -4.498540e-01,  6.787323e-03,  2.433854e-01,  3.019923e-02},
  {-5.578240e-01,  8.229238e-01,  1.078376e-01,  2.521794e-01,  2.367260e-01, -3.997642e-01},
  {-9.620554e-01,  8.566385e-02, -2.590581e-01,  2.493703e-01,  2.323025e-01, -3.805385e-01},
  {-7.245464e-01,  5.605053e-01, -4.010815e-01, -3.449278e-01,  2.673413e-01, -4.760486e-01},
  {-8.775188e-01, -4.530985e-01, -1.570434e-01,  1.079730e-01,  2.641275e-01,  5.155715e-01},
  {-1.663254e-01, -2.731674e-01,  9.474785e-01, -1.784186e-01,  2.513977e-01,  2.229631e-01},
  { 5.882790e-01, -1.777058e-01, -7.888907e-01,  3.368511e-01,  2.568505e-01,  1.260941e-01},
  { 5.882790e-01, -1.777058e-01, -7.888907e-01,  3.291721e-01,  2.661254e-01,  1.182786e-01},
  {-7.554697e-01, -6.546797e-01,  2.569327e-02, -3.639498e-01,  2.912501e-01, -4.261497e-01},
  { 1.417164e-01, -5.990863e-01,  7.880431e-01, -3.453031e-01,  2.780077e-01, -4.604645e-01},
  {-9.129055e-01, -1.991996e-01,  3.562625e-01,  4.618704e-01,  2.615283e-01, -1.351844e-01},
  { 3.826648e-01, -4.414788e-01,  8.115813e-01, -3.305089e-01,  2.931477e-01, -4.551716e-01},
  {-2.359379e-01, -7.204256e-01, -6.521658e-01,  7.943055e-02,  2.666120e-01, -8.479891e-01},
  {-4.768116e-01, -4.289349e-02, -8.779583e-01,  3.507709e-01,  2.825378e-01,  1.673952e-01},
  {-4.512973e-01,  1.803003e-01,  8.739694e-01,  3.171087e-01,  2.854961e-01,  1.107677e-01},
  { 8.319434e-01, -2.804387e-01,  4.787738e-01,  1.240674e-01,  3.171403e-01, -4.897745e-01},
  {-6.700521e-01,  2.554803e-01,  6.969647e-01,  3.074759e-01,  2.895587e-01,  7.876740e-01},
  {-6.858913e-01,  6.450763e-01,  3.367931e-01,  3.238334e-01,  2.865463e-01,  8.304607e-01},
  { 4.379816e-01,  2.440350e-01,  8.652278e-01,  2.887616e-01,  2.900604e-01,  7.846617e-01},
  {-4.983736e-01,  4.189227e-01,  7.590306e-01,  3.224862e-01,  2.695864e-01,  8.094258e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00,  1.293245e-01,  2.861763e-01, -6.960611e-01},
  { 2.638159e-01, -9.551526e-01,  1.344796e-01,  3.286133e-01,  2.969272e-01,  8.203121e-01},
  {-4.552723e-03,  4.420097e-01, -8.969988e-01,  1.105915e-01,  3.666838e-01, -4.641350e-01},
  { 7.939451e-01, -3.381139e-01, -5.053020e-01,  3.293273e-01,  3.595397e-01,  9.819147e-02},
  {-4.287309e-01, -2.300393e-01, -8.736543e-01, -3.541672e-01,  3.710405e-01, -4.194339e-01},
  {-6.746039e-01, -3.138447e-01,  6.681400e-01, -2.571572e-01,  4.211779e-01, -3.252697e-01},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  3.416834e-01,  4.044198e-01,  8.757494e-02},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  3.390189e-01,  4.140138e-01,  7.696865e-02},
  {-6.746039e-01, -3.138447e-01,  6.681400e-01, -2.458415e-01,  4.805840e-01, -2.859398e-01},
  {-1.904139e-01, -4.674080e-01,  8.632916e-01, -2.537757e-01,  4.668080e-01, -3.004217e-01},
  {-5.017570e-01, -7.518346e-01, -4.277671e-01,  2.778696e-01,  4.198309e-01, -7.563991e-01},
  {-2.977165e-01,  6.090111e-02, -9.527098e-01,  3.424809e-01,  4.488109e-01,  6.545690e-02},
  {-3.438577e-01, -4.145457e-01,  8.425638e-01, -2.322779e-01,  4.909949e-01, -2.825846e-01},
  {-3.799210e-01,  5.468536e-01, -7.460638e-01, -2.219627e-01,  4.905686e-01, -7.528511e-01},
  {-9.556997e-01,  2.356259e-01, -1.764044e-01, -2.483929e-01,  4.777925e-01,  5.213275e-01},
  {-6.596089e-01, -7.143035e-01,  2.338517e-01,  4.239942e-01,  4.646595e-01,  7.729846e-01},
  { 8.859054e-01,  9.690989e-03, -4.637647e-01,  3.692772e-01,  4.654942e-01,  7.058479e-02},
  {-7.922819e-01,  3.751991e-01, -4.811601e-01, -2.291136e-01,  5.234382e-01, -6.700776e-01},
  {-6.014428e-01, -6.761917e-01, -4.254780e-01, -2.291136e-01,  5.234382e-01, -6.700776e-01},
  {-1.737724e-01,  9.847671e-01, -6.074845e-03,  2.542588e-01,  5.096055e-01, -6.902735e-01},
  {-8.871746e-01,  2.999838e-01,  3.506150e-01, -1.431385e-01,  5.576042e-01, -3.599155e-01},
  { 6.226704e-01,  7.794442e-01, -6.890831e-02, -1.431385e-01,  5.576042e-01, -3.599155e-01},
  {-6.014428e-01, -6.761917e-01, -4.254780e-01, -2.231887e-01,  5.311975e-01, -6.907845e-01},
  { 3.199699e-01,  1.442099e-01,  9.363882e-01,  1.355575e-02,  5.155281e-01,  2.264208e-01},
  { 3.199699e-01,  1.442099e-01,  9.363882e-01,  5.076126e-01,  5.455812e-01,  3.026834e-01},
  {-9.761871e-01, -2.169305e-01,  0.000000e+00,  1.986604e-01,  4.930477e-01, -3.968679e-01},
  {-8.871746e-01,  2.999838e-01,  3.506150e-01, -1.405497e-01,  5.908069e-01, -3.817730e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  1.288266e-03,  6.013772e-01, -4.050100e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  5.328240e-01,  5.877969e-01,  3.475680e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  5.328240e-01,  5.877969e-01,  3.475680e-01},
  { 9.524792e-01,  2.931693e-01, -8.267469e-02,  3.592826e-01,  5.355601e-01, -2.111480e-01},
  {-9.761871e-01, -2.169305e-01,  0.000000e+00,  1.982778e-01,  5.151466e-01, -3.777197e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  2.556914e-02,  6.293260e-01, -4.468511e-01},
  { 0.000000e+00, -7.071068e-01, -7.071068e-01,  3.903937e-02,  6.534709e-01, -5.168937e-01},
  { 0.000000e+00, -7.071068e-01, -7.071068e-01,  6.086465e-02,  6.448147e-01, -5.317647e-01},
  { 5.392496e-02,  7.075782e-01, -7.045745e-01,  6.086465e-02,  6.448147e-01, -5.317647e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  6.893563e-02,  6.347597e-01, -5.403150e-01},
  {-8.791085e-01, -2.603393e-01,  3.992388e-01,  8.179546e-02,  6.233012e-01, -5.227410e-01},
  { 1.826861e-01, -2.274125e-02,  9.829082e-01, -1.056227e-01,  5.721798e-01,  2.077529e-01},
  { 9.171435e-01,  3.977197e-01,  2.582372e-02,  7.411940e-02,  6.296854e-01, -5.390965e-01},
  { 3.068485e-01, -7.855896e-01,  5.373015e-01,  8.233554e-02,  6.315550e-01, -5.161695e-01},
  { 2.081354e-01,  8.101358e-01, -5.480509e-01,  7.309382e-02,  6.299897e-01, -5.421520e-01},
  { 4.472136e-01, -8.944272e-01,  0.000000e+00, -7.383808e-02,  6.122088e-01,  2.918026e-01},
  { 4.552342e-01, -2.581941e-01, -8.521136e-01,  4.573157e-01,  5.987309e-01,  1.617940e-01},
  { 6.933453e-01, -5.002171e-02, -7.188672e-01,  4.458628e-01,  5.766794e-01, -4.349964e-01},
  {-9.073689e-01,  2.964378e-01, -2.980037e-01,  7.180770e-02,  6.173947e-01, -5.726734e-01},
  {-3.872527e-01,  4.895670e-01,  7.812551e-01,  5.131842e-01,  6.194186e-01,  3.581089e-01},
  { 6.191245e-01, -7.727798e-01,  1.396295e-01, -1.338835e-01,  5.888138e-01, -2.618543e-01},
  {-3.766779e-01, -4.662080e-01,  8.004772e-01,  3.420417e-01,  6.236779e-01, -1.097654e-01},
  { 1.753348e-01,  9.353617e-01, -3.071742e-01,  3.794508e-01,  6.676567e-01, -4.196322e-01},
  {-7.268238e-01,  3.591938e-01, -5.854118e-01,  3.859566e-01,  6.641979e-01, -4.298317e-01},
  {-6.948354e-01, -5.364813e-01,  4.789485e-01, -2.445750e-04,  6.140829e-01, -3.303601e-01},
  {-8.329883e-01, -3.883891e-01, -3.940614e-01, -6.694023e-02,  7.116119e-01,  3.604423e-01},
  {-6.538491e-01,  3.790077e-01,  6.548546e-01, -7.545239e-02,  7.233509e-01,  3.505095e-01},
  { 6.276186e-01, -5.239676e-01,  5.758063e-01,  1.148445e-01,  6.889082e-01,  3.679382e-01},
  { 5.607365e-01, -7.233372e-01,  4.029366e-01,  3.040763e-01,  6.792365e-01, -4.224875e-02},
  {-8.890674e-01, -2.352744e-01, -3.926897e-01,  3.142968e-01,  6.794240e-01, -6.020883e-02},
  {-4.650393e-01,  5.280151e-01,  7.105902e-01, -4.888328e-02,  6.813958e-01, -2.296418e-01},
  { 9.559932e-01,  1.118551e-01,  2.712292e-01,  3.692595e-01,  6.776294e-01, -3.539437e-01},
  {-4.432533e-01,  3.326105e-01, -8.324043e-01,  3.319259e-01,  6.814193e-01, -3.576967e-01},
  {-3.040235e-01, -2.366464e-01,  9.228045e-01, -2.500283e-01,  7.408831e-01,  1.061714e-01},
  { 8.494896e-01, -3.173115e-01,  4.215219e-01,  3.790499e-01,  6.766583e-01, -3.744053e-01},
  {-8.806250e-01,  2.284242e-01,  4.151168e-01,  2.234762e-02,  7.561963e-01, -1.949420e-01},
  { 2.529822e-01,  9.486833e-01,  1.897367e-01,  4.964173e-01,  6.826951e-01, -3.713670e-01},
  { 2.529822e-01,  9.486833e-01,  1.897367e-01,  5.034066e-01,  6.746029e-01, -4.102541e-01},
  {-7.359362e-01, -3.308330e-01, -5.907179e-01,  5.171151e-01,  6.705491e-01, -4.250622e-01},
  { 9.473577e-01, -2.952516e-01,  1.238541e-01,  5.359158e-01,  6.782901e-01, -4.528202e-01},
  {-4.614941e-01, -8.675793e-01, -1.852815e-01, -8.786967e-02,  8.108934e-01, -2.394850e-01},
  { 3.841488e-01,  9.124457e-01, -1.409700e-01, -7.570893e-02,  8.046591e-01, -2.845210e-01},
  {-4.972824e-02, -2.345411e-01,  9.708335e-01,  5.393805e-01,  8.589857e-01,  1.151626e-01},
  { 5.737075e-02,  2.457340e-01, -9.676381e-01,  5.393805e-01,  8.589857e-01,  1.151626e-01},
  {-8.842416e-01,  3.626362e-01,  2.942988e-01,  1.543106e-01,  8.476835e-01,  4.506959e-01},
  {-5.409925e-01,  9.060090e-02, -8.361331e-01, -2.238527e-01,  8.141224e-01, -1.193685e-01},
  {-8.014157e-01, -4.055205e-01, -4.396431e-01, -5.018274e-02,  7.830231e-01, -3.135716e-01},
  {-7.433925e-01, -6.457701e-01,  1.742084e-01,  1.490379e-01,  8.654610e-01,  4.515711e-01},
  {-1.351136e-01, -1.726544e-01,  9.756715e-01, -1.896570e-02,  9.093722e-01,  1.774591e-01},
  {-4.244339e-01,  0.000000e+00,  9.054589e-01, -1.019913e-01,  9.058414e-01, -1.644273e-01},
  { 3.696721e-01,  1.074617e-01,  9.229271e-01,  5.272318e-01,  9.142035e-01,  4.453446e-01},
  { 2.713457e-01,  8.622260e-01,  4.277123e-01, -2.790134e-02,  9.197809e-01,  1.851841e-02},
  {-6.533954e-01,  4.205385e-01,  6.294616e-01, -3.492714e-02,  9.252861e-01,  1.208007e-02},
  {-3.112841e-01,  2.558690e-01,  9.152231e-01, -4.491188e-02,  9.375256e-01, -6.461397e-03},
  { 1.884251e-01, -7.074898e-01, -6.811418e-01, -4.118560e-02,  9.225045e-01,  9.736799e-03},
  {-3.583559e-01, -6.875563e-01, -6.315438e-01, -4.731928e-03,  9.467640e-01, -2.427729e-02},
  { 9.930700e-01, -1.116959e-01, -3.655113e-02,  5.475091e-01,  9.224983e-01,  3.220644e-01},
  { 3.269704e-02,  6.750324e-01, -7.370632e-01, -2.209216e-02,  9.549997e-01, -2.339273e-02},
  {-4.067388e-03,  1.062280e-01, -9.943334e-01, -4.737983e-02,  9.565688e-01, -1.075211e-02},
  { 1.161638e-01, -7.780682e-01,  6.173458e-01,  1.748233e-01,  1.030220e+00,  2.532947e-01},
  {-6.288087e-01,  7.051644e-01, -3.276321e-01,  3.815950e-01,  1.075930e+00,  4.751926e-01},
  {-7.055554e-01, -7.022472e-01,  9.508165e-02,  1.004312e-01,  1.082191e+00,  3.534542e-01},
  { 3.138811e-01, -7.069911e-01,  6.337526e-01,  1.451596e-01,  1.047145e+00,  2.802068e-01},
  {-2.829601e-01,  8.975673e-01, -3.380924e-01,  3.897223e-01,  1.090723e+00,  4.914331e-01},
  {-7.621810e-01,  2.375999e-01,  6.021847e-01,  2.129185e-01,  1.058024e+00,  4.539325e-01},
  {-9.515474e-01,  2.210675e-01,  2.137444e-01,  1.959917e-01,  1.050385e+00,  4.034915e-01},
  { 6.495383e-01, -5.922717e-01,  4.767749e-01,  4.847683e-01,  1.026924e+00,  3.063990e-01},
  {-2.829601e-01,  8.975673e-01, -3.380924e-01,  3.783267e-01,  1.081987e+00,  4.777771e-01},
  { 2.287362e-01, -6.894640e-01,  6.872548e-01,  1.315037e-01,  1.076111e+00,  3.192843e-01},
  {-1.835354e-01, -3.912050e-01,  9.018168e-01,  2.213325e-01,  1.052778e+00,  3.749645e-02},
  { 3.858733e-01, -7.894656e-01, -4.773320e-01,  8.519967e-02,  1.167611e+00,  1.860531e-01},
  {-3.806686e-01,  7.367282e-02,  9.217721e-01, -1.809099e-02,  1.103040e+00,  4.908866e-02},
  { 9.833673e-01, -4.182439e-02,  1.767469e-01,  4.969431e-01,  1.099265e+00, -3.231389e-01},
  { 9.534543e-03, -9.796522e-01, -2.004764e-01,  5.351780e-01,  1.100333e+00,  1.603628e-02},
  { 2.082335e-01, -9.778989e-01, -1.877445e-02,  5.318552e-01,  1.102787e+00,  3.886855e-03},
  {-3.738257e-01,  4.475092e-01,  8.123977e-01,  2.533914e-01,  1.208279e+00,  1.914285e-01},
  {-1.122962e-01,  8.780360e-01, -4.652337e-01,  3.652633e-01,  1.262934e+00,  1.491850e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  5.239858e-01,  1.233278e+00,  3.218431e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  5.380011e-01,  1.229672e+00,  3.221015e-01},
  { 4.297527e-01,  1.074541e-01,  8.965300e-01,  6.047605e-01,  1.272066e+00, -3.342569e-03},
  {-7.573702e-01, -2.532094e-01, -6.018932e-01,  5.148860e-01,  1.354800e+00, -1.609160e-01},
  {-6.979973e-01,  5.050063e-01, -5.077089e-01,  1.097750e-01, -1.252405e+00, -6.993098e-01},
  {-2.463358e-01,  7.342950e-01, -6.325580e-01,  9.662370e-02, -1.258558e+00, -7.013311e-01},
  {-2.510570e-01,  5.625333e-01, -7.877352e-01,  9.518989e-02, -1.255549e+00, -7.000985e-01},
  { 2.510570e-01, -5.625333e-01,  7.877352e-01,  9.518989e-02, -1.255549e+00, -7.000985e-01},
  {-2.510570e-01,  5.625333e-01, -7.877352e-01,  1.093080e-01, -1.247199e+00, -6.986352e-01},
  {-2.676252e-01, -5.226141e-01, -8.094760e-01,  1.024788e-01, -1.260073e+00, -7.048989e-01},
  {-8.469588e-02,  8.698676e-01,  4.859599e-01, -1.592820e-01, -1.026821e+00,  1.676244e-01},
  {-3.745874e-01, -4.502654e-01, -8.105217e-01, -1.720674e-01, -1.030998e+00,  1.661248e-01},
  { 5.156364e-01, -1.924482e-01,  8.349149e-01, -1.583085e-01, -1.036258e+00,  1.626884e-01},
  {-1.005051e-01, -5.699936e-01, -8.154790e-01, -1.299906e-01, -1.011735e+00,  1.457248e-01},
  {-8.469588e-02,  8.698676e-01,  4.859599e-01, -1.299906e-01, -1.011735e+00,  1.457248e-01},
  {-3.370757e-01, -5.018515e-01, -7.965708e-01, -1.299906e-01, -1.011735e+00,  1.457248e-01},
  {-4.265538e-01,  4.810925e-01,  7.658994e-01,  3.243428e-01, -1.009349e+00,  3.320867e-01},
  { 6.065841e-01, -6.447730e-01, -4.651060e-01,  3.243428e-01, -1.009349e+00,  3.320867e-01},
  { 4.315855e-01,  5.853063e-01,  6.864040e-01,  3.243428e-01, -1.009349e+00,  3.320867e-01},
  {-1.574295e-01,  4.625127e-01,  8.725240e-01,  3.004263e-01, -1.022947e+00,  3.213472e-01},
  { 6.065841e-01, -6.447730e-01, -4.651060e-01,  3.075008e-01, -1.023728e+00,  3.300548e-01},
  { 6.065841e-01, -6.447730e-01, -4.651060e-01,  3.332195e-01, -9.962400e-01,  3.254899e-01},
  {-5.436928e-01,  6.703827e-01,  5.049607e-01, -2.135097e-01, -8.949842e-01, -7.572823e-01},
  {-8.753489e-01, -3.731053e-01,  3.075007e-01,  3.635954e-02, -4.866417e-01,  7.472391e-01},
  {-2.450275e-03, -8.213236e-01,  5.704574e-01, -5.413872e-01, -3.989544e-01, -2.827160e-01},
  { 8.116173e-02, -7.101134e-01,  6.993938e-01, -3.149943e-01, -1.683261e-01, -6.696914e-01},
  {-8.580489e-02, -2.451688e-01,  9.656759e-01, -3.020466e-01, -1.826094e-01, -6.856962e-01},
  {-8.346959e-01, -2.870913e-01,  4.699588e-01, -2.951013e-01, -2.239717e-01, -6.935894e-01},
  {-4.197044e-01, -3.695768e-01, -8.290122e-01, -3.588996e-01, -1.161544e-01, -6.857341e-01},
  { 4.826559e-01, -4.879940e-01, -7.272587e-01, -2.996049e-01, -1.848156e-01, -6.851438e-01},
  { 1.766494e-01,  5.407966e-01,  8.223953e-01,  4.332374e-01,  1.101492e+00,  5.065364e-01},
  { 6.612303e-03, -3.912727e-01,  9.202511e-01,  4.086682e-01,  1.099687e+00,  4.993729e-01},
  { 7.350745e-01,  6.729366e-01, -8.259476e-02,  3.810898e-01,  1.263855e+00, -1.764147e-01},
  {-7.693356e-01, -2.346438e-01,  5.941928e-01,  3.897066e-01,  1.255428e+00, -1.756451e-01},
  { 3.135127e-01,  2.640942e-01, -9.121206e-01,  3.922919e-01, -7.534553e-01,  5.077713e-01},
  {-5.744514e-01, -6.981726e-01,  4.272712e-01, -4.938388e-01, -6.437354e-01, -2.356167e-01},
  {-3.619221e-01, -3.314998e-01,  8.712751e-01, -4.938388e-01, -6.437354e-01, -2.356167e-01},
  { 3.908676e-01, -5.905172e-01,  7.060538e-01, -3.392349e-01, -2.374704e-01,  2.740830e-01},
  { 3.267036e-01, -2.605057e-01, -9.085161e-01,  3.171087e-01,  2.854961e-01,  1.107677e-01},
  {-5.623252e-01,  8.183109e-01,  1.189862e-01,  3.897223e-01,  1.090723e+00,  4.914331e-01},
  {-3.635948e-01,  8.001216e-01,  4.770789e-01,  3.897223e-01,  1.090723e+00,  4.914331e-01},
  { 9.170513e-01, -2.947615e-01, -2.685752e-01, -2.996049e-01, -1.848156e-01, -6.851438e-01},
  {-1.005051e-01, -5.699936e-01, -8.154790e-01, -1.155813e-01, -1.029567e+00,  1.564130e-01},
  {-4.300219e-01,  8.652366e-01, -2.577727e-01,  1.716540e-01, -3.356586e-01, -4.886119e-01},
  {-4.286388e-01, -6.236741e-01, -6.536814e-01, -2.769293e-01,  6.637898e-02,  8.289160e-02},
  { 7.939451e-01, -3.381139e-01, -5.053020e-01,  3.390189e-01,  4.140138e-01,  7.696865e-02},
  { 7.183473e-01,  6.636478e-01, -2.086838e-01,  2.350600e-01,  1.039571e+00,  4.714658e-01},
  { 2.807756e-01,  1.129139e-01,  9.531083e-01, -1.422503e-01, -1.029336e+00,  1.514216e-01},
  {-3.745874e-01, -4.502654e-01, -8.105217e-01, -1.422503e-01, -1.029336e+00,  1.514216e-01},
  {-6.250755e-01, -1.069587e-01,  7.732015e-01, -2.883961e-01, -1.899404e-01, -6.834612e-01},
  { 3.966689e-01,  7.905102e-01, -4.666341e-01,  2.664594e-01,  5.079143e-01, -6.878812e-01},
  {-2.339016e-02, -8.907300e-01,  4.539306e-01,  2.949570e-01, -2.302021e-01, -9.029441e-02},
  { 9.644164e-01, -2.244514e-01, -1.397230e-01,  2.885116e-01, -2.139700e-01, -3.615256e-01},
  {-8.952912e-01, -1.041221e-01,  4.331424e-01,  4.983253e-01,  2.019603e-01, -3.962345e-01},
  {-3.127464e-01, -7.423785e-01, -5.925065e-01,  2.255959e-02,  3.862252e-01, -3.591195e-01},
  {-2.897184e-01,  9.299335e-01,  2.264661e-01, -2.431785e-01, -4.233820e-01, -2.334470e-02},
  { 2.145186e-01,  4.819129e-01,  8.495538e-01,  3.181449e-01, -4.149960e-01, -2.799758e-01},
  { 8.181916e-01, -4.431432e-01, -3.663146e-01,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  { 4.291936e-01, -3.632921e-01, -8.269291e-01,  4.266287e-01, -1.051863e+00, -2.144618e-01},
  {-4.291937e-01,  3.632921e-01,  8.269291e-01,  4.266287e-01, -1.051863e+00, -2.144618e-01},
  { 8.931835e-01,  4.360454e-01, -1.099434e-01,  4.217591e-01, -1.026392e+00, -2.281790e-01},
  {-4.291937e-01,  3.632921e-01,  8.269291e-01,  4.217591e-01, -1.026392e+00, -2.281790e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.208450e-01,  3.234155e-02,  2.454507e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.198737e-01,  5.394820e-02,  2.537632e-01},
  {-8.986204e-01,  7.002000e-02, -4.331033e-01,  1.317431e-01, -1.212570e+00, -7.134638e-01},
  {-8.986204e-01,  7.002000e-02, -4.331033e-01,  1.389892e-01, -1.231750e+00, -7.210289e-01},
  {-2.113539e-01,  3.235696e-01,  9.222973e-01,  4.462335e-01,  6.856661e-02,  4.374387e-02},
  { 7.654860e-01, -3.964976e-01,  5.067749e-01,  4.462335e-01,  6.856661e-02,  4.374387e-02},
  { 7.654860e-01, -3.964976e-01,  5.067749e-01,  3.809628e-01, -5.310987e-01, -1.515899e-01},
  {-3.029044e-01,  7.183476e-01, -6.262792e-01, -3.263187e-01,  6.185405e-02, -7.273635e-01},
  { 5.311308e-02, -9.575173e-01, -2.834426e-01,  2.797053e-01, -2.492930e-01, -5.718549e-02},
  { 6.391143e-01, -7.686121e-01,  2.771949e-02,  2.797053e-01, -2.492930e-01, -5.718549e-02},
  {-3.253536e-01, -5.562342e-01, -7.646885e-01,  3.608607e-01, -4.249812e-01, -2.908870e-01},
  { 9.284767e-01, -3.713907e-01,  0.000000e+00,  3.550218e-01, -1.965638e-01,  1.853863e-02},
  {-3.014899e-02, -9.650522e-01, -2.603174e-01,  3.473852e-01, -5.233240e-01, -1.691056e-01},
  { 9.950518e-01,  7.765273e-02, -6.198415e-02,  3.789133e-01, -1.049383e+00, -4.632163e-01},
  { 6.723017e-03,  9.680275e-01,  2.507541e-01,  3.472570e-01, -5.241305e-01, -1.597634e-01},
  {-2.897184e-01,  9.299335e-01,  2.264661e-01, -2.814454e-01, -4.390607e-01, -7.918674e-03},
  { 4.283902e-01, -3.556345e-01, -8.306660e-01,  3.443910e-01,  2.393067e-01,  1.446129e-01},
  { 6.065162e-01, -3.324495e-01, -7.222295e-01,  3.307003e-01,  2.684117e-01,  1.197184e-01},
  {-9.162735e-01,  1.908032e-01, -3.521889e-01,  4.797213e-01,  6.604326e-01, -4.267538e-01},
  {-2.262821e-01, -6.305031e-01, -7.424703e-01,  3.283894e-01,  5.214418e-01,  1.006580e-01},
  { 3.152442e-01, -9.457325e-01,  7.881104e-02, -1.447914e-01,  5.502601e-01, -3.956243e-01},
  { 2.664470e-01,  8.903759e-01, -3.691024e-01, -1.447914e-01,  5.502601e-01, -3.956243e-01},
  { 8.283680e-01,  6.480305e-02,  5.564233e-01,  2.315821e-01,  1.131535e+00,  5.859856e-02},
  {-2.348832e-01,  1.022378e-01, -9.666319e-01,  2.431529e-01,  1.888946e-01, -3.914871e-01},
  {-2.348832e-01,  1.022378e-01, -9.666319e-01, -7.772604e-02, -1.959218e-01,  2.706147e-01},
  {-2.348832e-01,  1.022378e-01, -9.666319e-01, -6.880279e-02, -2.100888e-01,  2.718283e-01},
  { 6.893454e-01, -6.614317e-01, -2.954845e-01,  4.683919e-01, -2.040871e-01, -2.243648e-01},
  { 4.142791e-01,  8.960833e-02, -9.057280e-01, -2.122628e-01,  1.194816e-01, -5.978041e-01},
  {-1.681811e-01,  3.975826e-01, -9.020218e-01,  7.943055e-02,  2.666120e-01, -8.479891e-01},
  {-2.945482e-01, -5.388157e-01, -7.892522e-01,  3.181449e-01, -4.149960e-01, -2.799758e-01},
  {-4.661021e-01, -8.365341e-01, -2.880269e-01, -4.459883e-01, -6.219641e-01, -4.084028e-01},
  {-6.635747e-02, -8.476689e-01,  5.263593e-01, -2.101630e-01,  7.371075e-01,  1.051169e-01},
  { 9.850686e-01,  1.647938e-01, -4.982986e-02, -5.293623e-02,  7.955460e-01, -3.265892e-01},
  {-9.452056e-01, -1.950332e-01,  2.618177e-01, -5.391688e-02, -1.093914e+00,  1.008675e-01},
  { 4.417713e-01,  2.928606e-01,  8.479805e-01, -5.391688e-02, -1.093914e+00,  1.008675e-01},
  { 1.423529e-01,  1.971489e-02,  9.896197e-01,  6.077417e-02, -3.486281e-01, -4.344421e-01},
  {-5.639637e-01,  8.057405e-01,  1.809068e-01,  1.003736e-01, -3.500232e-01,  4.703372e-01},
  {-8.410727e-01, -4.534054e-01,  2.949921e-01, -3.159873e-01, -1.673632e-01, -6.706289e-01},
  { 0.000000e+00, -8.944272e-01, -4.472136e-01, -3.931502e-01, -3.270122e-01, -5.525517e-01},
  { 0.000000e+00, -8.944272e-01, -4.472136e-01, -3.900480e-01, -3.193143e-01, -5.444778e-01},
  { 1.780154e-01, -9.512638e-01, -2.518089e-01, -1.018803e-01, -7.890490e-01,  3.802248e-01},
  { 1.707979e-01, -3.720734e-01, -9.123538e-01,  3.308326e-01,  3.719346e-01,  9.462774e-02},
  { 7.939451e-01, -3.381139e-01, -5.053020e-01,  3.416834e-01,  4.044198e-01,  8.757494e-02},
  { 9.585890e-01, -2.680019e-01, -9.634319e-02,  3.639622e-01,  3.698241e-01,  1.016905e-01},
  {-3.428210e-01,  4.791735e-01,  8.080016e-01, -7.881925e-02,  2.050832e-01,  6.174588e-01},
  {-1.661460e-01,  2.125595e-01,  9.629195e-01,  3.166344e-01,  1.200531e-01,  4.860339e-01},
  {-5.333855e-01, -3.924851e-01,  7.493032e-01,  8.644489e-02,  6.341152e-01, -5.000257e-01},
  { 2.537011e-02,  9.451092e-01,  3.257683e-01, -2.539203e-01, -5.552903e-01,  2.820320e-01},
  {-1.897621e-01, -3.345764e-01, -9.230650e-01,  2.914792e-02, -3.381573e-01, -4.293698e-01},
  {-8.898656e-02, -7.454457e-01, -6.605998e-01,  2.823306e-01, -2.735866e-01, -3.345926e-01},
  {-8.898656e-02, -7.454457e-01, -6.605998e-01,  9.667772e-02, -1.101489e+00, -3.122618e-01},
  { 6.893313e-02,  3.482255e-01, -9.348729e-01,  5.107534e-01,  8.776629e-01,  1.182085e-01},
  {-3.423162e-01,  9.363455e-01, -7.795411e-02,  1.204271e-01,  1.053956e+00,  3.023618e-01},
  { 8.771566e-02, -4.077759e-01, -9.088591e-01, -2.902480e-01, -6.217691e-01, -5.794315e-02},
  { 8.771566e-02, -4.077759e-01, -9.088591e-01, -3.072116e-01, -6.319752e-01, -5.993966e-02},
  {-5.908159e-01, -8.068054e-01,  1.337992e-03,  1.253155e-02, -2.004877e-01,  4.990475e-01},
  {-4.546825e-01, -8.836222e-01, -1.116943e-01,  1.253155e-02, -2.004877e-01,  4.990475e-01},
  { 6.524900e-01, -3.722190e-01,  6.600832e-01,  4.702716e-01,  1.084455e+00,  4.767913e-01},
  {-6.240689e-01, -2.016824e-02,  7.811091e-01,  3.352533e-01,  4.581533e-02,  7.406725e-01},
  {-7.993251e-01, -5.790229e-01,  1.606606e-01,  3.352533e-01,  4.581533e-02,  7.406725e-01},
  {-7.261765e-01, -2.000657e-01,  6.577550e-01,  3.900491e-01, -5.677094e-02,  7.818030e-01},
  { 3.767195e-01,  2.666540e-01,  8.871179e-01,  3.262679e-01, -1.032127e+00, -6.467512e-01},
  { 2.836321e-01,  4.708331e-01,  8.353856e-01,  3.117305e-01, -1.097391e+00, -6.209602e-01},
  {-5.642096e-01,  8.248190e-01, -3.662118e-02,  2.561808e-01, -2.840188e-01, -8.561508e-02},
  {-3.863721e-01, -8.296400e-01, -4.030064e-01, -1.211337e-01, -1.019174e+00, -5.256368e-01},
  { 9.741622e-01, -1.866610e-01,  1.271443e-01,  3.021520e-01, -8.012068e-02,  4.487270e-01},
  {-2.891373e-01,  4.625590e-01,  8.381162e-01, -2.474052e-01, -7.619705e-01, -3.176157e-01},
  { 8.220203e-01, -3.171682e-02,  5.685743e-01,  3.875364e-01,  3.756464e-01,  3.472412e-01},
  {-2.438351e-01, -8.737850e-01, -4.207664e-01, -1.474441e-01, -1.009723e+00, -5.155744e-01},
  { 1.269607e-01,  4.831178e-01, -8.663014e-01,  4.223140e-01,  8.642718e-01,  9.777933e-02},
  { 3.704242e-01, -8.717686e-01,  3.206327e-01,  4.305948e-01, -5.907114e-01,  3.335273e-01},
  { 3.704242e-01, -8.717686e-01,  3.206327e-01, -2.069754e-01,  3.389329e-01,  3.306905e-03},
  { 1.342014e-01, -9.852173e-01, -1.064753e-01,  2.797393e-01, -2.665133e-01, -1.985806e-01},
  { 8.944272e-01,  4.472136e-01,  0.000000e+00,  4.252763e-01,  4.827949e-01,  3.008098e-01},
  { 9.701425e-01,  0.000000e+00,  2.425356e-01,  5.176280e-01, -2.039269e-01, -3.397274e-02},
  { 9.701425e-01,  0.000000e+00,  2.425356e-01,  5.213092e-01, -1.939254e-01, -1.901575e-02},
  { 1.508641e-01,  4.016601e-01,  9.032770e-01,  3.559672e-01,  6.160334e-01,  6.559629e-01},
  { 8.672381e-01, -2.042179e-01,  4.540851e-01,  3.506826e-01,  6.370232e-01,  6.543024e-01},
  { 8.186827e-01, -9.043322e-03,  5.741749e-01,  1.491112e-01,  1.822904e-01, -7.918415e-01},
  { 0.000000e+00, -7.071068e-01,  7.071068e-01,  1.443796e-01,  1.512472e-01, -7.777120e-01},
  { 3.661190e-01, -8.707734e-01, -3.281930e-01,  2.199599e-01, -1.155462e+00, -1.618200e-01},
  { 5.876127e-01, -8.062613e-02,  8.051153e-01,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  {-2.625718e-01,  7.357530e-01,  6.242785e-01, -8.072792e-02, -7.006863e-01,  1.152458e-01},
  { 5.311308e-02, -9.575173e-01, -2.834426e-01,  2.958336e-01, -2.372414e-01, -9.487583e-02},
  { 9.841802e-01,  1.598625e-01,  7.637651e-02,  4.153463e-01,  8.887135e-03,  2.372110e-01},
  { 5.311308e-02, -9.575173e-01, -2.834426e-01,  2.978022e-01, -2.398212e-01, -8.579197e-02},
  { 6.391143e-01, -7.686121e-01,  2.771949e-02,  3.008783e-01, -2.326493e-01, -8.385773e-02},
  { 8.568028e-01, -1.727477e-01, -4.858468e-01, -2.774154e-02, -7.941592e-02, -3.962630e-01},
  {-6.030769e-01, -7.230747e-01,  3.368403e-01, -4.137564e-01, -8.251778e-01,  4.533340e-02},
  {-5.474311e-01, -8.066527e-01,  2.227794e-01, -4.427744e-01, -2.918392e-01, -1.448280e-01},
  { 7.492114e-01,  6.583610e-01,  7.240981e-02, -4.433313e-01, -2.894571e-01, -1.607247e-01},
  {-4.511931e-01,  6.872099e-01, -5.693569e-01,  4.638991e-02, -6.039208e-01, -3.303516e-01},
  { 5.858669e-02, -1.046595e-01, -9.927809e-01,  6.611314e-02, -5.942652e-01, -3.409265e-01},
  { 3.138840e-01, -6.424606e-01, -6.990860e-01, -2.031324e-01,  7.992647e-01, -1.128837e-01},
  { 4.063771e-01, -5.847772e-01,  7.020636e-01,  5.459658e-01,  1.195823e+00,  2.927430e-01},
  { 4.999200e-01,  8.197613e-01, -2.794127e-01,  3.468054e-01, -4.919485e-01, -4.212905e-02},
  { 5.246027e-01,  5.274172e-01,  6.682987e-01,  1.839961e-01,  2.034402e-01,  5.351949e-01},
  { 4.399576e-01, -8.608060e-01,  2.558326e-01,  3.089363e-01, -2.947221e-01, -3.018427e-01},
  {-4.210042e-01,  2.137555e-01,  8.815123e-01, -2.603184e-01, -1.836483e-01, -3.638504e-01},
  {-2.655936e-01,  4.010865e-01, -8.766924e-01, -2.603184e-01, -1.836483e-01, -3.638504e-01},
  { 3.617031e-01,  9.311422e-01,  4.631595e-02,  9.084281e-02,  3.628946e-01, -7.434518e-01},
  { 4.732635e-01,  4.851887e-01,  7.352643e-01,  7.878287e-02,  8.519024e-01,  4.902661e-01},
  {-8.401532e-01,  4.585508e-01, -2.896097e-01, -4.545126e-01, -2.798104e-01, -2.345587e-01},
  { 8.754455e-01, -1.812915e-01,  4.480276e-01,  5.016472e-01,  1.019663e+00,  2.743841e-01},
  {-4.235743e-01, -2.168625e-02,  9.056017e-01, -2.431785e-01, -4.233820e-01, -2.334470e-02},
  {-8.984846e-01, -1.401444e-01,  4.160348e-01,  4.435986e-01,  2.981426e-01, -1.615326e-01},
  { 7.229604e-01,  3.724653e-01,  5.818916e-01,  4.435986e-01,  2.981426e-01, -1.615326e-01},
  { 8.051639e-01, -4.089381e-01,  4.295123e-01,  4.416250e-01,  3.295292e-01, -1.598802e-01},
  { 3.679564e-01, -6.189514e-01, -6.939072e-01,  2.496940e-01, -4.485031e-01,  1.548556e-01},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01,  4.071895e-02,  5.433713e-01, -6.593022e-01},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01,  4.179752e-02, -8.401079e-01, -6.459946e-01},
  { 4.082483e-01,  4.082483e-01, -8.164966e-01,  8.540714e-02, -8.324999e-01, -6.689990e-01},
  { 6.258657e-01,  6.796484e-01,  3.825836e-01, -1.104207e-01, -1.075522e+00,  1.720768e-01},
  {-6.258657e-01, -6.796484e-01, -3.825836e-01, -1.104207e-01, -1.075522e+00,  1.720768e-01},
  {-3.478992e-02, -9.990040e-01, -2.794258e-02, -1.165565e-01, -1.080817e+00,  1.226200e-01},
  {-6.258657e-01, -6.796484e-01, -3.825836e-01, -9.791944e-02, -1.074319e+00,  1.494895e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -9.791944e-02, -1.074319e+00,  1.494895e-01},
  { 9.111395e-01,  2.733309e-01, -3.084074e-01,  2.555528e-01, -1.369092e-01,  6.444061e-01},
  { 9.111395e-01,  2.733309e-01, -3.084074e-01,  2.712068e-01, -1.445141e-01,  6.839134e-01},
  { 9.423025e-01,  1.914927e-01,  2.745842e-01,  3.723289e-01,  5.522135e-01, -1.790841e-03},
  { 1.862629e-01,  5.098796e-01,  8.398387e-01,  3.723289e-01,  5.522135e-01, -1.790841e-03},
  { 8.904445e-01,  4.549878e-01, -9.730837e-03,  3.723289e-01,  5.522135e-01, -1.790841e-03},
  { 7.649508e-01, -3.613115e-01, -5.332021e-01,  2.895543e-01, -1.083770e+00, -9.551112e-02},
  {-8.534119e-01, -1.559312e-01, -4.973667e-01, -4.489541e-01, -5.778590e-01, -5.731065e-01},
  {-4.703604e-01, -8.527348e-02,  8.783448e-01,  2.588511e-01, -1.123261e+00, -1.461525e-01},
  {-1.051766e-01, -6.590616e-01,  7.446983e-01, -1.842898e-01, -1.036346e+00,  1.707637e-01},
  {-4.552723e-03,  4.420097e-01, -8.969988e-01,  9.527490e-02,  3.887525e-01, -4.531825e-01},
  {-4.819824e-01, -5.775434e-01,  6.588904e-01, -3.522001e-01,  8.986262e-02, -7.802914e-01},
  {-3.623642e-01,  1.559768e-01, -9.188925e-01,  8.471409e-02,  1.495521e-01, -6.878183e-01},
  { 3.093752e-01,  4.089759e-01, -8.585020e-01, -1.920931e-01, -8.871832e-01, -7.445796e-01},
  { 6.488116e-01,  2.348198e-01,  7.238116e-01,  2.543084e-01,  2.112616e-01, -4.014741e-01},
  { 3.300636e-01,  6.895310e-01, -6.446744e-01,  2.892371e-01, -3.738180e-01, -2.893805e-01},
  {-3.026159e-01, -4.090579e-01, -8.608689e-01,  2.892371e-01, -3.738180e-01, -2.893805e-01},
  { 2.435029e-01, -1.310976e-01,  9.609993e-01,  3.730386e-01, -2.436777e-01,  9.542292e-02},
  { 3.152162e-01,  9.479878e-01, -4.424795e-02, -1.813318e-01, -8.865926e-01, -7.246915e-01},
  {-5.173789e-01,  7.417783e-01, -4.267131e-01, -2.825903e-01, -4.454995e-01, -7.422893e-01},
  { 4.386424e-01,  2.684006e-01,  8.576444e-01,  4.568590e-01,  5.886245e-01,  1.650768e-01},
  {-6.311696e-01,  3.978266e-01,  6.658521e-01,  3.388458e-01,  2.061426e-01,  1.554223e-01},
  {-1.564603e-01, -3.235230e-01,  9.331951e-01, -6.564937e-02,  7.456027e-01,  4.289079e-01},
  {-1.005051e-01, -5.699936e-01, -8.154790e-01, -1.365447e-01, -1.017970e+00,  1.508909e-01},
  {-9.693846e-01, -2.280352e-01,  9.106883e-02, -1.473410e-01,  4.808553e-01,  3.743995e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.988503e-01,  1.238139e+00,  3.159219e-01},
  {-1.589203e-01, -8.991218e-01,  4.078289e-01,  3.523111e-01,  3.699990e-01, -3.581655e-01},
  {-7.186694e-01,  1.952359e-01, -6.673809e-01, -2.149896e-01, -1.008893e+00, -1.452304e-01},
  {-5.139810e-01,  4.210441e-03, -8.577912e-01, -2.186789e-01, -9.360743e-01, -1.234329e-01},
  { 7.878890e-01, -4.609414e-01,  4.083676e-01,  2.911038e-01,  8.302957e-03, -5.747041e-01},
  { 2.225762e-01, -5.193715e-01, -8.250534e-01,  3.008868e-01, -2.389238e-01, -8.320441e-02},
  { 7.889956e-01,  1.200848e-01,  6.025492e-01,  2.475182e-01, -6.605741e-01,  4.635292e-01},
  {-4.548931e-01, -7.270219e-01, -5.143069e-01,  2.475182e-01, -6.605741e-01,  4.635292e-01},
  { 9.710978e-01, -5.343505e-02, -2.326238e-01,  5.513216e-01,  7.239743e-02, -4.750882e-02},
  {-2.644181e-01, -8.967298e-01, -3.549067e-01, -4.575020e-01, -2.834986e-01, -2.226049e-01},
  {-2.596470e-01,  2.035059e-01, -9.440174e-01, -3.014927e-01, -1.489391e-01,  1.778862e-01},
  { 7.875574e-02,  6.171322e-01, -7.829083e-01,  2.914792e-02, -3.381573e-01, -4.293698e-01},
  { 1.423529e-01,  1.971489e-02,  9.896197e-01,  3.605149e-02, -3.378387e-01, -4.311008e-01},
  { 7.127332e-01, -6.090579e-02,  6.987860e-01, -1.178994e-01, -9.467721e-02,  6.912417e-01},
  { 7.127332e-01, -6.090579e-02,  6.987860e-01, -6.140144e-05, -1.928256e-01,  5.624973e-01},
  { 6.821250e-01, -7.038910e-01, -1.980984e-01,  5.725313e-01, -1.046856e-01, -1.864178e-01},
  { 3.733311e-01,  8.586267e-01,  3.512607e-01,  5.763329e-01, -9.390795e-02, -1.675668e-01},
  {-6.888632e-01, -6.654058e-02,  7.218309e-01,  2.963600e-01, -2.768919e-02, -5.497523e-01},
  {-2.977165e-01,  6.090111e-02, -9.527098e-01,  3.639358e-01,  4.738132e-01,  6.035059e-02},
  {-2.977165e-01,  6.090111e-02, -9.527098e-01, -6.016725e-02,  5.671389e-01,  4.356600e-01},
  {-2.977165e-01,  6.090111e-02, -9.527098e-01, -2.093945e-03,  5.521404e-01,  4.499967e-01},
  {-6.601505e-01,  5.687741e-01,  4.906093e-01,  1.929208e-01, -5.719622e-01,  6.501667e-01},
  {-9.784881e-01,  5.195867e-02,  1.996529e-01,  1.929208e-01, -5.719622e-01,  6.501667e-01},
  {-8.715742e-01,  2.750490e-01,  4.058407e-01,  2.015203e-01, -5.841345e-01,  7.590408e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.117346e-01, -3.474237e-01,  2.071085e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.265569e-01, -3.450932e-01,  2.431599e-01},
  {-4.922853e-01, -8.314811e-01,  2.574769e-01,  3.299662e-01, -2.604620e-01, -1.620149e-01},
  {-4.922853e-01, -8.314811e-01,  2.574769e-01,  3.191962e-01, -2.441615e-01, -1.299669e-01},
  { 9.433321e-01, -4.409485e-02, -3.289078e-01,  3.215335e-01, -2.538932e-01, -1.424152e-01},
  { 7.029356e-01,  3.533331e-01,  6.172820e-01,  2.054091e-02, -7.617705e-01, -4.608514e-01},
  { 9.228526e-01,  1.866533e-01, -3.369027e-01, -5.949492e-02,  7.886092e-01, -3.011376e-01},
  {-3.180853e-01, -6.649013e-01, -6.758167e-01, -4.273142e-01, -6.195743e-01, -4.195433e-01},
  {-3.974932e-01,  6.373898e-01, -6.601011e-01,  2.082622e-01, -3.281026e-01, -2.611101e-01},
  {-6.746039e-01, -3.138447e-01,  6.681400e-01, -2.537757e-01,  4.668080e-01, -3.004217e-01},
  {-6.045436e-01, -7.589384e-01, -2.419493e-01, -9.500358e-02,  7.963449e-01, -1.894450e-01},
  {-7.469273e-02, -9.313149e-01,  3.564740e-01,  3.299662e-01, -2.604620e-01, -1.620149e-01},
  { 5.598857e-01, -4.683030e-01,  6.835351e-01,  4.521011e-01,  9.412922e-01,  4.399116e-01},
  { 6.916130e-01, -1.090621e-01,  7.139868e-01,  2.536115e-01, -6.365382e-01,  1.625901e-01},
  {-2.205649e-01,  1.574614e-01,  9.625783e-01, -9.412017e-02, -3.519939e-01,  1.961115e-01},
  {-9.647226e-01,  2.484268e-01, -8.714545e-02, -9.412017e-02, -3.519939e-01,  1.961115e-01},
  {-4.081778e-01,  9.128941e-01, -3.907460e-03,  4.000576e-01,  9.232528e-02, -5.776516e-01},
  {-9.208409e-01,  3.895677e-01, -1.699926e-02, -2.120654e-01,  8.010067e-01, -1.179263e-01},
  { 2.257258e-01,  8.090561e-01,  5.426564e-01,  1.572395e-01, -2.684841e-01,  6.191337e-01},
  {-1.255607e-01,  2.673021e-01,  9.553974e-01, -1.108447e-01, -6.510523e-01,  8.143628e-02},
  {-6.491476e-02,  4.311399e-01,  8.999469e-01, -1.384987e-01, -6.465561e-01,  6.710699e-02},
  { 2.454910e-01, -1.131467e-01, -9.627731e-01, -4.124861e-01, -4.963867e-01, -6.380624e-01},
  { 8.344553e-01,  2.562396e-01, -4.878786e-01,  4.902429e-01,  1.115613e+00, -3.161298e-01},
  {-1.304146e-01, -9.434610e-01, -3.047515e-01,  2.057637e-01,  4.661338e-01, -4.497620e-01},
  { 4.490857e-01, -8.766354e-01, -1.727206e-01, -3.015663e-01, -2.952285e-01, -5.812727e-01},
  { 1.770033e-01, -9.784487e-01,  1.063395e-01,  4.680476e-01, -2.858301e-01, -4.926547e-01},
  {-1.033451e-01,  9.944733e-01, -1.851263e-02, -2.500283e-01,  7.408831e-01,  1.061714e-01},
  {-8.942137e-01,  4.212384e-01,  1.514596e-01,  2.058792e-01, -5.753548e-01,  6.904250e-01},
  {-6.311696e-01,  3.978266e-01,  6.658521e-01,  3.388847e-01,  2.489069e-01,  1.299088e-01},
  {-4.965731e-01, -3.334404e-01, -8.013942e-01, -9.840877e-02, -1.108734e+00, -4.729419e-01},
  {-6.015098e-02, -4.113453e-01, -9.094927e-01, -9.840877e-02, -1.108734e+00, -4.729419e-01},
  { 1.056567e-01, -3.958690e-01,  9.122086e-01, -7.135249e-02, -1.240953e+00, -4.598791e-01},
  { 3.765609e-01, -7.524390e-01, -5.404049e-01, -7.135249e-02, -1.240953e+00, -4.598791e-01},
  { 8.941421e-01,  2.453181e-01,  3.746051e-01,  9.538171e-02,  5.947686e-01, -5.172180e-01},
  { 8.557844e-01,  1.470837e-01,  4.959835e-01,  3.916000e-01,  6.425173e-01, -4.331396e-01},
  { 8.557844e-01,  1.470837e-01,  4.959835e-01,  3.859566e-01,  6.641979e-01, -4.298317e-01},
  {-2.684197e-01,  7.320327e-01, -6.261621e-01,  2.547389e-01, -1.237638e+00, -5.096648e-01},
  { 9.499967e-01,  1.192332e-01,  2.885997e-01,  5.422451e-01, -2.316025e-02, -1.963690e-01},
  { 9.773698e-01,  1.730182e-01, -1.217088e-01, -2.526205e-01, -1.943455e-02, -5.965888e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  3.479287e-01,  3.857984e-01, -3.160482e-01},
  {-6.992943e-01,  1.705640e-01, -6.941869e-01,  4.526711e-01,  9.428785e-01, -3.900482e-01},
  {-2.223657e-01, -6.390417e-01,  7.363282e-01, -1.813305e-01,  1.925700e-01, -4.713838e-01},
  {-9.026015e-01,  1.965390e-01, -3.829923e-01, -1.813305e-01,  1.925700e-01, -4.713838e-01},
  {-7.177628e-01, -5.808609e-01,  3.839494e-01, -1.554010e-01,  1.875142e-01, -4.679411e-01},
  {-6.484863e-01,  4.931529e-01, -5.798841e-01, -1.927728e-01,  2.783348e-01, -4.004061e-01},
  {-8.450417e-01,  3.862191e-01, -3.697828e-01, -1.435200e-01,  2.517882e-01, -4.732527e-01},
  {-4.247964e-01,  6.158271e-01, -6.635548e-01,  1.161910e-01,  1.013992e+00,  2.679841e-01},
  { 2.132872e-01,  9.710867e-01, -1.072338e-01, -1.462428e-01,  4.203219e-01, -3.628522e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -1.462428e-01,  4.203219e-01, -3.628522e-01},
  { 6.257601e-01,  1.704763e-01,  7.611584e-01, -9.628538e-02,  4.013705e-01, -4.351079e-01},
  {-2.208174e-01, -2.167140e-02,  9.750744e-01, -9.774859e-02, -9.008265e-02,  2.575048e-01},
  {-6.310247e-01,  6.673298e-02, -7.728872e-01, -1.149877e-01, -1.262530e-01,  2.318878e-01},
  { 1.546924e-01,  9.727939e-01, -1.724600e-01,  3.652633e-01,  1.262934e+00,  1.491850e-01},
  { 1.635254e-01,  4.190771e-01,  8.931035e-01, -4.103710e-01, -6.486007e-01, -4.090253e-01},
  { 7.962776e-01,  5.196124e-01, -3.097500e-01, -1.418010e-01, -9.996885e-01, -7.498550e-01},
  { 9.296917e-01,  3.670118e-01, -3.123900e-02, -1.429655e-01, -9.929867e-01, -7.057766e-01},
  {-1.708457e-01,  7.120529e-01, -6.810231e-01,  5.217418e-01,  1.243416e+00, -2.763021e-01},
  { 6.065162e-01, -3.324495e-01, -7.222295e-01,  3.443910e-01,  2.393067e-01,  1.446129e-01},
  { 8.000000e-01, -6.000000e-01,  0.000000e+00,  4.030200e-01,  1.299509e+00, -2.044721e-01},
  {-8.031045e-01, -2.957910e-01,  5.172340e-01,  4.021575e-01,  1.237583e+00, -1.665178e-01},
  { 5.882790e-01, -1.777058e-01, -7.888907e-01,  3.332536e-01,  2.815293e-01,  1.178524e-01},
  { 6.446831e-01, -7.262931e-01,  2.384999e-01,  2.883626e-01,  4.342011e-02,  1.838993e-01},
  { 3.535013e-01,  7.809644e-01,  5.149092e-01,  2.883626e-01,  4.342011e-02,  1.838993e-01},
  { 2.707578e-01,  3.334728e-01, -9.030427e-01,  3.509950e-02,  3.100439e-01, -9.010953e-01},
  { 9.977799e-01, -1.716255e-02,  6.434929e-02,  5.083603e-01, -4.243321e-01,  4.442631e-02},
  {-8.102202e-01, -5.342745e-01, -2.410270e-01,  4.592208e-01,  5.293496e-01, -4.188192e-01},
  {-4.560924e-01,  6.339048e-01, -6.246156e-01,  2.788854e-01, -1.155154e+00, -2.819297e-01},
  {-2.490935e-01,  9.368063e-01,  2.456550e-01,  2.783559e-01,  5.040376e-01, -6.793735e-01},
  {-2.490935e-01,  9.368063e-01,  2.456550e-01,  2.870185e-01,  4.940002e-01, -6.323119e-01},
  {-2.490935e-01,  9.368063e-01,  2.456550e-01,  2.887827e-01,  5.011420e-01, -6.577581e-01},
  {-6.168271e-01,  7.322226e-01, -2.887464e-01,  2.315821e-01,  1.131535e+00,  5.859856e-02},
  { 3.940996e-01,  7.624127e-01,  5.132372e-01, -5.251704e-01, -4.098481e-01,  3.165100e-01},
  { 1.612633e-01, -3.466501e-01, -9.240281e-01, -6.788595e-03, -1.073069e+00,  8.183745e-02},
  { 2.985223e-01, -5.555385e-01,  7.760550e-01,  1.249387e-02, -1.058784e+00,  7.655208e-02},
  {-9.939340e-01,  9.990512e-02, -4.597803e-02,  6.114548e-02, -6.506410e-01,  7.078196e-01},
  {-1.660265e-01,  4.127547e-01, -8.955830e-01,  3.754554e-01,  4.601098e-01,  8.227411e-02},
  { 3.238644e-01, -1.728910e-01, -9.301723e-01,  3.754554e-01,  4.601098e-01,  8.227411e-02},
  { 9.907126e-01,  7.367134e-02, -1.142849e-01,  2.986643e-01, -2.135931e-01, -2.986250e-01},
  {-5.214840e-01, -8.509964e-01, -6.212721e-02,  3.012172e-01, -2.236265e-01, -2.829618e-01},
  {-5.214840e-01, -8.509964e-01, -6.212721e-02,  2.876340e-01, -2.130582e-01, -3.137084e-01},
  { 1.783190e-01, -1.249746e-01,  9.760040e-01,  1.211691e-02, -1.063269e+00,  7.704097e-02},
  { 3.244436e-01, -6.892589e-01,  6.478105e-01,  1.020974e-02, -1.147079e+00,  6.665791e-02},
  {-1.066699e-01,  7.248120e-01,  6.806387e-01, -1.075023e-01, -6.271588e-01,  2.073996e-01},
  {-8.123206e-01, -7.238726e-02, -5.787014e-01,  8.364096e-02,  9.232627e-01,  1.761852e-01},
  {-8.123206e-01, -7.238726e-02, -5.787014e-01,  3.428212e-02,  9.620585e-01,  2.785141e-01},
  {-5.744514e-01, -6.981726e-01,  4.272712e-01, -5.102331e-01, -6.469650e-01, -2.629355e-01},
  {-5.744514e-01, -6.981726e-01,  4.272712e-01, -4.815312e-01, -6.517119e-01, -2.321034e-01},
  { 6.792703e-01, -5.081258e-01, -5.295282e-01, -1.089024e-01, -9.690994e-01,  1.443075e-01},
  { 3.367540e-01,  4.560947e-01, -8.237563e-01,  4.069425e-01,  3.029319e-01,  5.183198e-01},
  {-1.909764e-01, -6.039096e-01, -7.738354e-01,  1.525681e-01, -7.015438e-01, -1.038397e-01},
  { 3.563545e-01, -4.298114e-01,  8.296225e-01,  4.466648e-01,  2.732616e-02,  1.082625e-02},
  {-9.856261e-01, -1.652190e-01, -3.526637e-02, -2.569376e-01,  1.729835e-02, -5.790385e-01},
  { 8.728715e-01,  4.364358e-01,  2.182179e-01, -2.569376e-01,  1.729835e-02, -5.790385e-01},
  { 8.728715e-01,  4.364358e-01,  2.182179e-01, -2.609034e-01,  3.348478e-02, -5.878754e-01},
  {-9.612115e-01, -2.695407e-01, -5.848380e-02, -3.112114e-01, -2.879754e-01, -5.580587e-01},
  {-5.226762e-01,  1.085137e-01, -8.455971e-01, -3.112114e-01, -2.879754e-01, -5.580587e-01},
  {-1.865697e-01, -6.247523e-01, -7.582061e-01, -3.030566e-01, -3.228572e-01, -5.313232e-01},
  {-5.556628e-01,  8.314012e-01, -3.300533e-03,  2.616563e-02, -2.023749e-01,  3.739881e-01},
  { 9.724559e-01,  9.147898e-02,  2.143855e-01,  4.440461e-01,  7.216586e-02,  4.691034e-02},
  { 1.096241e-01, -5.386404e-01,  8.353736e-01,  3.581593e-01, -4.549611e-01,  7.016506e-03},
  {-8.177868e-01,  3.351764e-01, -4.678478e-01,  4.077351e-01, -1.553373e-01, -6.459288e-02},
  { 3.661190e-01, -8.707734e-01, -3.281930e-01,  1.801021e-01, -1.163926e+00, -1.838250e-01},
  {-3.921710e-02, -9.330905e-01, -3.574970e-01,  3.817485e-01, -9.618757e-01,  3.251510e-01},
  { 6.031941e-01, -6.716444e-01,  4.301752e-01,  3.817485e-01, -9.618757e-01,  3.251510e-01},
  {-5.845230e-01, -7.277780e-01,  3.587090e-01,  3.914680e-01, -9.455808e-01,  3.369639e-01},
  {-9.839954e-01,  1.351745e-01, -1.161067e-01, -1.255684e-01,  7.834932e-01,  4.135272e-01},
  {-4.280987e-01, -2.657252e-01,  8.637833e-01, -1.255684e-01,  7.834932e-01,  4.135272e-01},
  { 4.000201e-01, -8.250040e-01, -3.991896e-01,  3.267090e-02, -4.737350e-01,  7.492343e-01},
  {-8.856726e-02,  7.037970e-01, -7.048585e-01,  3.468054e-01, -4.919485e-01, -4.212905e-02},
  {-4.876828e-01,  1.337788e-01, -8.627101e-01, -9.548860e-03, -2.376646e-01, -1.248780e-02},
  {-6.656826e-01, -7.332175e-01, -1.387763e-01,  3.050839e-02, -1.154098e+00, -2.416217e-01},
  { 1.799687e-01, -6.911929e-01, -6.999027e-01,  3.050839e-02, -1.154098e+00, -2.416217e-01},
  {-6.656826e-01, -7.332175e-01, -1.387763e-01,  2.059109e-02, -1.144493e+00, -2.447956e-01},
  {-6.656826e-01, -7.332175e-01, -1.387763e-01,  1.849614e-02, -1.139966e+00, -2.586665e-01},
  {-2.551913e-01, -9.477792e-01, -1.912903e-01, -7.135249e-02, -1.240953e+00, -4.598791e-01},
  {-5.308772e-01,  2.965860e-01,  7.938552e-01,  8.364096e-02,  9.232627e-01,  1.761852e-01},
  {-2.806075e-01,  5.562077e-01,  7.822356e-01, -1.462911e-02, -1.163756e+00, -5.088514e-01},
  {-9.425753e-01,  3.225915e-01, -8.652604e-02, -2.445294e-02, -1.152032e+00, -5.207115e-01},
  {-6.477284e-01, -7.276916e-01, -2.256387e-01,  5.132670e-01,  4.705881e-01, -1.369574e-02},
  {-8.113146e-01, -3.405702e-01, -4.751639e-01,  6.940515e-02,  1.055380e+00,  2.222770e-01},
  { 7.856158e-01,  3.361655e-01,  5.194234e-01,  6.940515e-02,  1.055380e+00,  2.222770e-01},
  { 7.856158e-01,  3.361655e-01,  5.194234e-01,  5.791048e-02,  1.087601e+00,  2.188094e-01},
  { 6.002757e-01, -3.921753e-02, -7.988311e-01, -9.500358e-02,  7.963449e-01, -1.894450e-01},
  { 9.532405e-01,  3.020675e-01,  9.373453e-03,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  { 9.336365e-01, -2.722106e-01, -2.328609e-01,  3.274844e-02, -8.631754e-01,  1.442390e-01},
  {-1.182428e-01,  8.986251e-02, -9.889101e-01, -3.287012e-01, -4.603144e-01, -6.738465e-01},
  {-6.814477e-01,  7.316745e-01,  1.677670e-02, -3.287012e-01, -4.603144e-01, -6.738465e-01},
  {-4.472136e-01,  0.000000e+00,  8.944272e-01,  3.432425e-01,  7.929534e-02, -5.887290e-01},
  {-4.472136e-01,  0.000000e+00,  8.944272e-01,  4.000576e-01,  9.232528e-02, -5.776516e-01},
  { 5.558612e-01, -8.061599e-01, -2.027923e-01,  5.224332e-02, -1.204048e+00, -2.000742e-01},
  { 5.472236e-01, -7.290999e-01,  4.110473e-01,  3.986997e-02, -1.200939e+00, -1.780871e-01},
  { 4.416154e-01,  4.881269e-01,  7.528001e-01,  4.002388e-01,  1.240628e+00, -1.600591e-01},
  { 2.865151e-01, -9.083554e-01,  3.046301e-01,  2.876342e-01, -2.065111e-01, -3.540826e-01},
  { 3.873952e-01, -2.783071e-01, -8.789029e-01,  3.942071e-01, -1.943248e-01, -7.491224e-02},
  { 8.096123e-01, -3.956763e-01,  4.335530e-01,  4.023100e-01, -1.528243e-01, -5.216849e-02},
  {-8.501161e-01,  3.908748e-01,  3.528732e-01, -5.205531e-01, -6.188343e-01, -2.364266e-01},
  {-1.666548e-01,  5.321956e-01, -8.300567e-01, -5.287133e-01, -6.343846e-01, -2.330247e-01},
  {-2.048421e-01,  1.753795e-01,  9.629546e-01, -5.314541e-01, -6.537492e-01, -2.240139e-01},
  { 5.623062e-01,  8.009978e-01, -2.054608e-01, -5.183271e-01, -6.270902e-01, -2.219189e-01},
  { 7.958882e-01,  6.050802e-01,  2.097809e-02, -3.260550e-01, -5.866332e-01,  2.937846e-01},
  {-3.931914e-02, -9.731056e-01,  2.269790e-01,  3.600068e-01,  5.429352e-01, -1.809943e-01},
  {-6.447017e-01,  2.844374e-01, -7.095458e-01, -5.346376e-01, -5.949082e-01, -2.363586e-01},
  {-2.350392e-01, -5.415052e-01,  8.071732e-01, -5.346376e-01, -5.949082e-01, -2.363586e-01},
  { 1.706879e-01, -8.636987e-01,  4.742259e-01, -5.602701e-01, -3.517774e-01, -3.824802e-01},
  { 2.459859e-01,  4.586516e-01,  8.538910e-01,  1.730136e-01, -1.224425e-01,  7.686571e-01},
  {-9.298557e-01,  4.224604e-02,  3.654909e-01, -3.014927e-01, -1.489391e-01,  1.778862e-01},
  { 4.417713e-01,  2.928606e-01,  8.479805e-01, -4.500780e-02, -1.091007e+00,  9.522201e-02},
  {-9.894898e-01, -1.286032e-01, -6.611548e-02, -3.759556e-02, -1.071470e+00,  8.548837e-02},
  { 9.429036e-01, -2.201090e-01, -2.499695e-01,  1.576716e-01, -1.085071e+00, -1.492687e-01},
  {-7.029901e-01, -3.852810e-01,  5.977988e-01,  1.576716e-01, -1.085071e+00, -1.492687e-01},
  { 9.429036e-01, -2.201090e-01, -2.499695e-01,  1.623681e-01, -1.066736e+00, -1.476972e-01},
  { 9.429036e-01, -2.201090e-01, -2.499695e-01,  1.693276e-01, -1.065228e+00, -1.227733e-01},
  {-9.949256e-01, -1.271211e-02,  9.980711e-02, -3.014927e-01, -1.489391e-01,  1.778862e-01},
  {-9.925588e-01,  1.156897e-01, -3.798778e-02, -2.983370e-01, -1.264860e-01,  1.638131e-01},
  {-9.925588e-01,  1.156897e-01, -3.798778e-02, -1.614271e-02, -5.797896e-01, -4.345751e-01},
  {-9.925588e-01,  1.156897e-01, -3.798778e-02, -4.058766e-02, -5.772319e-01, -4.909677e-01},
  { 9.822491e-01, -1.134654e-01,  1.493725e-01,  3.537080e-01,  3.434208e-01,  1.473011e-01},
  { 9.673404e-01, -1.102539e-01,  2.282469e-01,  3.607786e-01,  3.337134e-01,  1.126458e-01},
  { 9.938545e-01,  3.393895e-02,  1.053625e-01,  2.401289e-01, -1.029681e+00,  9.953606e-02},
  {-8.472114e-01, -4.738787e-01,  2.401496e-01, -5.292047e-01, -6.372110e-01, -2.538208e-01},
  { 6.925470e-01, -7.052429e-01,  1.516945e-01,  3.970478e-01, -1.143490e+00, -2.173263e-01},
  {-5.263305e-01,  7.245021e-01, -4.450538e-01, -3.112114e-01, -2.879754e-01, -5.580587e-01},
  { 5.168110e-01, -7.592633e-01,  3.955070e-01, -3.019896e-01, -2.908264e-01, -5.735101e-01},
  { 1.301188e-01,  6.092628e-02,  9.896247e-01,  3.166344e-01,  1.200531e-01,  4.860339e-01},
  {-5.957714e-02,  7.112705e-01,  7.003891e-01,  2.399841e-01, -9.658324e-01,  2.769172e-01},
  {-6.439947e-01, -7.324896e-01,  2.207483e-01,  8.506460e-02, -1.112967e+00, -3.378322e-01},
  {-6.123334e-01, -6.251559e-02,  7.881241e-01,  3.219619e-02,  5.855008e-01,  4.553823e-01},
  { 8.720276e-01, -2.334762e-01,  4.301825e-01,  3.550795e-02,  6.243755e-01,  4.610389e-01},
  {-3.956838e-01, -4.785531e-01, -7.838503e-01,  2.761922e-01, -2.402970e-01, -3.456430e-01},
  {-5.549047e-01, -6.939529e-01, -4.588138e-01,  2.875343e-01, -2.027113e-01, -3.743151e-01},
  { 1.668425e-01,  9.660900e-02,  9.812392e-01,  2.616563e-02, -2.023749e-01,  3.739881e-01},
  {-1.407928e-01, -1.576699e-02,  9.899135e-01, -4.193589e-02, -2.076078e-01,  3.860827e-01},
  {-6.675388e-01,  1.146026e-01,  7.357026e-01,  1.192830e-01,  1.016466e+00,  2.710941e-01},
  {-7.150649e-02,  7.563426e-01,  6.502559e-01,  5.339642e-01,  1.187129e+00,  1.698191e-02},
  { 2.991041e-01, -1.209267e-01,  9.465271e-01,  5.339642e-01,  1.187129e+00,  1.698191e-02},
  {-2.579853e-02,  5.033845e-01, -8.636774e-01,  4.627785e-01,  1.176779e+00,  3.360206e-02},
  { 6.191245e-01, -7.727798e-01,  1.396295e-01, -1.561536e-01,  5.767420e-01, -2.299197e-01},
  {-6.016359e-01, -3.683452e-01, -7.087708e-01, -7.810383e-02,  6.212846e-01, -3.294747e-01},
  { 1.264358e-01,  6.921980e-01,  7.105461e-01,  1.866698e-01,  1.065222e+00,  5.001901e-01},
  {-3.666289e-01, -6.648350e-01,  6.508285e-01,  1.002716e-01,  5.710308e-01,  5.236828e-01},
  { 5.178415e-01,  8.553917e-01, -1.205307e-02,  1.002716e-01,  5.710308e-01,  5.236828e-01},
  { 5.174960e-01, -8.414784e-01, -1.552803e-01,  1.490895e-01, -1.183196e+00, -1.827532e-01},
  { 3.428530e-02,  6.494110e-01, -7.596642e-01, -3.296056e-01,  2.725720e-01, -6.400763e-01},
  {-1.548002e-01, -6.479846e-01,  7.457566e-01, -4.373434e-01, -2.755863e-01, -3.680287e-01},
  {-5.681877e-01, -3.867031e-01, -7.263770e-01, -1.011348e-01, -6.934341e-01,  8.892155e-02},
  { 2.923042e-01,  8.268881e-01, -4.804313e-01, -4.779319e-01, -6.371254e-01, -2.146137e-01},
  { 9.138734e-01,  3.876442e-01,  1.206956e-01,  1.463475e-01, -1.180973e+00, -2.039380e-01},
  { 5.535812e-01, -7.785727e-01,  2.955883e-01, -1.142547e-01, -8.704189e-01, -2.578186e-01},
  { 2.107617e-01,  4.520701e-01,  8.667250e-01,  3.734128e-01, -4.262955e-01, -2.875216e-01},
  { 1.999246e-01,  8.531246e-01,  4.818802e-01,  3.633977e-01, -2.986323e-01,  7.188151e-01},
  { 1.204275e-01, -3.091058e-02,  9.922408e-01,  4.435799e-01,  9.053364e-01, -3.901144e-01},
  {-4.406223e-02,  3.378463e-01, -9.401693e-01,  4.526711e-01,  9.428785e-01, -3.900482e-01},
  { 4.382038e-01,  3.249707e-02,  8.982881e-01, -9.399933e-02, -6.641073e-02,  2.548195e-01},
  { 5.330200e-01,  4.347069e-01,  7.258923e-01, -1.169122e-01,  8.817675e-01,  2.094692e-01},
  {-3.174488e-01, -6.968410e-01, -6.431477e-01,  2.689212e-01,  5.207885e-02,  1.841137e-01},
  { 2.644275e-01, -2.739880e-01, -9.246668e-01, -3.249000e-01, -1.937853e-01, -7.605572e-01},
  {-7.021648e-01, -3.890873e-01, -5.963017e-01, -1.122136e-01, -1.747293e-01,  2.391427e-01},
  {-3.162278e-01,  0.000000e+00, -9.486833e-01, -1.869100e-02,  9.211931e-01,  1.643140e-01},
  { 3.163666e-02,  9.867290e-01,  1.592634e-01, -1.869100e-02,  9.211931e-01,  1.643140e-01},
  {-3.162278e-01,  0.000000e+00, -9.486833e-01, -1.175298e-01,  9.363922e-01,  1.270980e-01},
  { 1.208802e-01, -1.619121e-01,  9.793735e-01, -1.175298e-01,  9.363922e-01,  1.270980e-01},
  { 1.651801e-01,  6.892254e-01,  7.054671e-01,  1.160892e-02, -2.221359e-01, -2.200761e-02},
  { 6.236351e-01,  2.030009e-01, -7.548974e-01,  2.117135e-01, -6.650108e-01, -5.194720e-01},
  { 9.396235e-01,  2.966661e-01, -1.705783e-01,  4.981108e-01,  2.055746e-01, -3.988029e-01},
  {-3.126195e-03, -7.059447e-02,  9.975002e-01,  7.878287e-02,  8.519024e-01,  4.902661e-01},
  {-3.949692e-01,  5.428768e-01, -7.411371e-01, -3.439476e-01, -1.992289e-01, -7.333990e-01},
  { 5.825708e-01,  3.814159e-01, -7.177278e-01,  5.253651e-02, -1.010726e+00, -5.515913e-01},
  { 6.417043e-01,  6.669949e-01,  3.785940e-01,  5.253651e-02, -1.010726e+00, -5.515913e-01},
  { 9.865190e-01, -1.623385e-01, -2.065144e-02,  3.820505e-01, -2.350568e-01,  1.020554e-01},
  {-4.099978e-01, -7.778895e-01, -4.762244e-01, -7.307250e-02, -1.138106e-01,  6.438525e-01},
  {-2.213125e-02, -6.648631e-01, -7.466373e-01, -8.026665e-02, -2.299668e-01,  7.475001e-01},
  { 7.492114e-01,  6.583610e-01,  7.240981e-02, -4.659065e-01, -2.694862e-01, -1.087210e-01},
  {-7.358860e-01,  5.436681e-03, -6.770836e-01, -4.427744e-01, -2.918392e-01, -1.448280e-01},
  {-6.354864e-01, -2.849699e-01, -7.175996e-01, -4.124861e-01, -4.963867e-01, -6.380624e-01},
  { 4.810762e-01,  9.984509e-02,  8.709746e-01,  1.493544e-01,  8.380522e-01,  4.543817e-01},
  { 4.810762e-01,  9.984509e-02,  8.709746e-01,  1.699879e-01,  8.338618e-01,  4.434653e-01},
  { 9.632453e-01,  2.228455e-01, -1.499947e-01, -1.405497e-01,  5.908069e-01, -3.817730e-01},
  {-6.384406e-01,  4.573189e-01,  6.190743e-01, -1.204297e-01,  5.420485e-01, -3.250051e-01},
  {-9.107823e-01, -1.449480e-01, -3.866078e-01,  1.014124e-01, -7.012822e-01, -5.747607e-01},
  {-6.458709e-01, -6.877158e-01, -3.315083e-01, -1.213608e-01, -5.037282e-01,  1.501550e-01},
  { 5.578977e-01, -5.191666e-03,  8.298935e-01, -1.213608e-01, -5.037282e-01,  1.501550e-01},
  {-6.458709e-01, -6.877158e-01, -3.315083e-01, -1.907773e-01, -4.963566e-01,  2.701054e-01},
  { 1.923318e-01,  7.567558e-01,  6.247632e-01, -1.471269e-01, -4.879271e-01,  1.675752e-01},
  {-6.218368e-01, -7.826573e-01,  2.768682e-02,  7.187261e-02, -1.256045e+00, -6.818997e-01},
  {-3.706078e-01, -6.468344e-01,  6.665246e-01,  1.192830e-01,  1.016466e+00,  2.710941e-01},
  { 9.773698e-01,  1.730182e-01, -1.217088e-01, -2.609034e-01,  3.348478e-02, -5.878754e-01},
  { 6.748484e-01, -6.198205e-01,  4.005024e-01,  2.742837e-01, -2.602872e-01, -1.797524e-01},
  {-6.650504e-01, -6.050483e-01,  4.377493e-01, -2.879459e-01, -1.018727e+00,  5.174761e-02},
  {-8.104837e-01,  5.792566e-01, -8.705121e-02, -3.102722e-01, -2.373320e-01,  3.236339e-01},
  {-3.887706e-03, -8.999009e-01,  4.360773e-01,  5.174401e-01, -3.497794e-01, -4.036000e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  5.452269e-02,  1.011830e+00,  3.284729e-01},
  { 8.961381e-02,  8.547575e-01, -5.112329e-01,  4.104439e-02,  4.304941e-02, -7.584975e-01},
  {-2.273851e-01, -8.811041e-01, -4.146707e-01,  4.104439e-02,  4.304941e-02, -7.584975e-01},
  { 1.206270e-01, -8.015146e-01, -5.856820e-01, -8.318637e-03,  5.245766e-02, -7.514201e-01},
  { 5.645459e-01,  7.731996e-01, -2.888778e-01, -3.420663e-02,  7.827710e-02, -7.920863e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  5.851799e-01,  1.233696e+00,  7.003075e-03},
  {-5.737849e-01,  7.357072e-01, -3.598694e-01, -8.420166e-02,  7.304739e-01,  4.275593e-01},
  {-2.897184e-01,  9.299335e-01,  2.264661e-01, -2.599007e-01, -4.268523e-01, -3.048737e-02},
  {-5.734421e-01, -1.791106e-01, -7.994270e-01,  1.156661e-01, -4.178388e-01, -4.639419e-01},
  {-1.028084e-01,  8.030727e-01, -5.869452e-01,  4.689071e-01,  6.021841e-01,  3.537982e-01},
  {-5.490340e-01,  8.255054e-01,  1.307769e-01,  2.827051e-02, -3.903828e-01,  4.223933e-01},
  { 1.550030e-01,  1.125249e-02, -9.878499e-01,  1.231008e-01, -1.183877e+00, -4.656785e-01},
  {-3.448463e-02,  9.904179e-01, -1.337277e-01,  2.102991e-02,  7.998932e-01,  3.318590e-01},
  { 1.280287e-01,  7.225537e-01,  6.793563e-01,  2.089945e-01,  1.056192e+00,  4.044323e-02},
  {-1.217105e-01,  3.254229e-01,  9.377027e-01, -1.411818e-01,  8.945552e-01,  2.191600e-01},
  { 1.581545e-01,  9.848021e-01,  7.177705e-02, -3.868549e-01, -4.541192e-01, -7.439440e-02},
  { 2.548857e-01, -9.279572e-01,  2.718983e-01,  4.695431e-01, -2.034523e-01, -2.203387e-01},
  {-2.442884e-01, -6.573917e-01,  7.128530e-01,  8.658490e-03,  7.417791e-01,  4.047150e-01},
  {-2.547144e-01, -9.624018e-01, -9.435771e-02,  2.931414e-01, -2.051989e-01, -3.410905e-01},
  {-2.139763e-01, -9.610077e-01, -1.751529e-01, -1.614203e-01, -1.019136e+00, -4.870899e-01},
  { 9.084883e-01, -4.103933e-01, -7.890688e-02,  1.862322e-01, -3.392276e-01, -4.692055e-01},
  { 5.295258e-01,  2.726103e-01, -8.032970e-01, -5.983134e-02, -3.251368e-01, -6.154165e-01},
  { 5.089121e-02, -4.231767e-01, -9.046168e-01,  1.396440e-02, -3.477162e-01, -5.831419e-01},
  {-4.085374e-01, -7.233106e-01, -5.567036e-01,  2.672621e-02, -9.795887e-01, -5.627001e-01},
  { 6.417043e-01,  6.669949e-01,  3.785940e-01,  3.215459e-02, -9.710536e-01, -5.869380e-01},
  {-8.617935e-02, -9.506800e-01,  2.979610e-01,  3.215459e-02, -9.710536e-01, -5.869380e-01},
  {-1.321671e-01, -6.042933e-01,  7.857236e-01,  3.983993e-02,  6.814537e-01,  4.033641e-01},
  { 3.492220e-01, -7.630623e-01, -5.438565e-01, -1.390819e-01, -1.282537e-03, -5.926273e-01},
  { 1.500200e-01, -6.457564e-01, -7.486606e-01,  1.097432e-01, -1.048597e+00, -5.497954e-01},
  {-3.273439e-01,  8.372016e-01,  4.381089e-01,  4.297126e-01,  5.735108e-01,  3.512256e-01},
  {-3.844091e-01,  5.928472e-01,  7.076454e-01,  4.297126e-01,  5.735108e-01,  3.512256e-01},
  {-3.210962e-01,  3.603411e-01,  8.758147e-01,  4.689071e-01,  6.021841e-01,  3.537982e-01},
  {-4.214127e-01, -7.350447e-01,  5.311502e-01, -3.236329e-01, -2.776372e-01, -5.199089e-01},
  {-1.651296e-01,  2.903842e-01, -9.425547e-01,  2.892371e-01, -3.738180e-01, -2.893805e-01},
  { 9.459426e-01, -2.316167e-01,  2.270382e-01,  3.678652e-01,  7.241240e-01, -3.161338e-01},
  {-5.017570e-01, -7.518346e-01, -4.277671e-01,  2.654370e-01,  4.425113e-01, -7.816786e-01},
  {-5.299824e-01, -7.339214e-01, -4.248271e-01,  3.703606e-01,  1.038069e-02,  7.580913e-01},
  {-5.165807e-01,  6.864194e-01,  5.118327e-01, -2.122628e-01,  1.194816e-01, -5.978041e-01},
  {-5.165807e-01,  6.864194e-01,  5.118327e-01, -1.898500e-02,  4.497590e-01, -7.502682e-01},
  {-5.731317e-01,  8.093524e-01,  1.283314e-01,  2.289628e-02,  4.316828e-01, -7.448624e-01},
  {-9.272197e-01,  2.190897e-01,  3.037488e-01,  5.895132e-02, -1.171948e+00, -4.202662e-01},
  {-4.002172e-01, -8.801610e-01,  2.552309e-01,  1.344991e-02, -1.091401e+00, -3.894961e-01},
  {-3.724484e-01, -5.431441e-01,  7.525136e-01,  3.705227e-02, -1.113196e+00, -4.235563e-01},
  { 1.464520e-01,  4.406213e-01,  8.856662e-01,  3.705227e-02, -1.113196e+00, -4.235563e-01},
  { 3.582312e-01, -4.015684e-01, -8.428601e-01,  3.694772e-01, -1.011157e+00, -2.014502e-01},
  {-9.223017e-01,  1.638306e-01,  3.500275e-01, -2.769146e-01, -1.999341e-01,  2.665164e-01},
  {-9.298557e-01,  4.224604e-02,  3.654909e-01, -2.802853e-01, -1.434750e-01,  2.312091e-01},
  {-6.874177e-01, -6.489976e-01, -3.259741e-01, -3.064222e-01, -1.942011e-01,  3.173283e-01},
  { 2.854951e-01,  6.912937e-01, -6.637812e-01, -3.707534e-01, -1.403389e-01,  3.457538e-01},
  { 9.818168e-01, -1.255626e-01, -1.423724e-01,  8.485755e-02, -1.123727e-02,  4.241452e-01},
  {-6.809799e-02, -4.129157e-01,  9.082199e-01,  8.485755e-02, -1.123727e-02,  4.241452e-01},
  { 9.818168e-01, -1.255626e-01, -1.423724e-01,  8.753696e-02,  1.403294e-02,  4.203361e-01},
  { 9.818168e-01, -1.255626e-01, -1.423724e-01,  9.588346e-02,  5.232156e-02,  4.441267e-01},
  {-3.851177e-01, -7.851930e-01,  4.849291e-01, -4.468102e-01, -6.509201e-01, -2.648693e-02},
  { 2.278646e-01,  9.721562e-01, -5.468195e-02, -1.703453e-02, -5.841410e-01, -5.156518e-01},
  { 5.481120e-01, -7.655764e-01, -3.368470e-01, -4.169819e-01, -3.158641e-01, -4.612832e-01},
  {-3.133775e-01, -1.661139e-01,  9.349870e-01, -4.169819e-01, -3.158641e-01, -4.612832e-01},
  {-3.205678e-01,  5.645341e-01, -7.606167e-01, -4.759339e-01, -3.559213e-01, -4.661681e-01},
  {-3.133775e-01, -1.661139e-01,  9.349870e-01, -5.038629e-01, -3.616729e-01, -4.985415e-01},
  { 8.046378e-01, -9.166894e-02, -5.866471e-01,  3.238327e-01,  2.797806e-01,  1.130767e-01},
  { 1.092314e-01, -2.521043e-01, -9.615154e-01,  3.399029e-01,  2.475310e-01,  1.401577e-01},
  {-6.597715e-01, -7.506028e-01,  3.601417e-02,  1.316793e-01,  5.364047e-01, -4.133496e-01},
  {-2.939257e-01,  8.990905e-01,  3.244134e-01,  3.882875e-01,  5.703365e-01,  3.875443e-01},
  { 3.878232e-01, -8.646286e-01,  3.193908e-01,  3.583014e-01, -4.644227e-01, -4.192761e-03},
  {-9.209470e-02,  7.790590e-01,  6.201497e-01,  2.334497e-01,  1.007364e+00,  8.776727e-02},
  {-2.826974e-01,  3.051833e-01,  9.093653e-01,  5.410858e-01, -5.250262e-02, -2.013257e-01},
  { 8.229054e-01, -3.516239e-01, -4.463042e-01,  3.129654e-01, -2.567881e-01, -2.782313e-01},
  {-7.447936e-01, -5.311481e-01, -4.039358e-01,  4.150708e-01,  5.249490e-01, -1.751090e-01},
  {-4.848279e-01,  2.804807e-01,  8.284157e-01, -5.458642e-02, -3.693354e-01,  3.907235e-01},
  { 9.919439e-01,  1.110753e-01,  6.090644e-02,  5.083603e-01, -4.243321e-01,  4.442631e-02},
  {-2.375905e-01,  5.921558e-01, -7.700015e-01, -3.158355e-01, -1.571773e-01, -6.515682e-01},
  {-6.939207e-01,  3.250407e-01, -6.425128e-01, -3.158355e-01, -1.571773e-01, -6.515682e-01},
  { 2.471271e-01,  1.212910e-01, -9.613619e-01,  5.213092e-01, -1.939254e-01, -1.901575e-02},
  { 9.976559e-01, -6.825673e-02, -4.873510e-03,  5.213092e-01, -1.939254e-01, -1.901575e-02},
  {-5.870902e-01,  6.073424e-01,  5.352198e-01,  5.456560e-01,  1.217460e+00, -2.047414e-01},
  { 4.879356e-01, -7.921419e-01,  3.666471e-01,  2.663673e-01, -1.003867e+00, -4.545453e-01},
  {-2.429002e-01, -6.234325e-01, -7.431901e-01,  1.833861e-01, -1.002434e+00, -4.473394e-01},
  {-2.126328e-01,  8.625434e-01,  4.591364e-01,  3.988830e-01, -5.284969e-01, -1.355381e-01},
  { 1.753707e-01,  9.813110e-01,  7.920706e-02,  3.857834e-01, -5.151940e-01, -1.665959e-01},
  { 1.096241e-01, -5.386404e-01,  8.353736e-01,  4.054346e-01, -4.627785e-01, -4.227875e-03},
  { 9.644087e-01,  2.630327e-01,  2.701188e-02,  5.600798e-01,  1.094909e+00,  4.372398e-02},
  { 9.970154e-01,  6.815840e-02,  3.626020e-02,  5.100190e-01,  4.326710e-01, -9.635669e-02},
  {-2.866847e-02,  9.858081e-01, -1.654103e-01, -4.149312e-01, -6.533560e-01, -2.721746e-01},
  { 2.107617e-01,  4.520701e-01,  8.667250e-01,  3.587141e-01, -3.929431e-01, -3.013435e-01},
  {-1.601451e-01, -7.631080e-01,  6.261148e-01, -3.571399e-02, -1.138830e+00,  9.005238e-02},
  {-2.359699e-01, -8.585573e-01, -4.551896e-01,  3.645581e-01,  6.843827e-01, -3.738891e-01},
  {-4.432533e-01,  3.326105e-01, -8.324043e-01,  2.813374e-01,  7.020120e-01, -3.225300e-01},
  {-1.001027e-01, -9.796336e-01,  1.740622e-01,  2.813374e-01,  7.020120e-01, -3.225300e-01},
  {-1.182195e-01, -8.249071e-01,  5.527680e-01, -4.502591e-01, -6.527304e-01, -4.237190e-01},
  { 3.572105e-01,  4.172185e-01,  8.356611e-01,  5.071716e-01, -5.291427e-03, -2.969342e-01},
  { 9.497259e-01, -2.629941e-01,  1.698675e-01,  5.071716e-01, -5.291427e-03, -2.969342e-01},
  { 2.456015e-01,  7.596694e-01,  6.021482e-01,  7.270337e-02,  1.035076e+00,  2.259312e-01},
  { 6.207415e-01, -5.113240e-01,  5.943297e-01,  2.025852e-01, -1.275977e+00, -4.648384e-01},
  { 8.876716e-01, -2.550750e-01,  3.833742e-01,  3.417028e-01,  2.549679e-01,  1.708768e-01},
  { 4.472136e-01,  0.000000e+00, -8.944272e-01,  2.933284e-01, -4.743935e-01,  3.383803e-01},
  { 4.472136e-01,  0.000000e+00, -8.944272e-01,  3.349807e-01, -4.806961e-01,  3.269732e-01},
  {-4.562779e-01, -4.512073e-01,  7.669566e-01,  3.350715e-01,  7.884602e-02,  4.861467e-01},
  { 6.288112e-01,  6.855283e-01,  3.669435e-01, -1.613517e-01, -6.706989e-01, -6.539301e-01},
  { 4.425633e-01,  2.557019e-01, -8.595082e-01, -1.613517e-01, -6.706989e-01, -6.539301e-01},
  { 4.770460e-01,  7.170376e-01, -5.082167e-01, -5.064796e-03, -8.105487e-01, -6.604813e-01},
  { 9.191202e-01, -2.648346e-02,  3.930861e-01,  1.898167e-01, -1.258442e+00, -4.338013e-01},
  { 9.191202e-01, -2.648346e-02,  3.930861e-01,  2.025852e-01, -1.275977e+00, -4.648384e-01},
  { 9.883973e-01, -1.316890e-01,  7.568850e-02,  4.042302e-01, -7.072245e-01,  4.297415e-01},
  { 3.706058e-01,  3.409050e-01, -8.639647e-01,  1.504210e-01, -7.046726e-01, -9.830129e-02},
  { 1.843745e-01, -2.842754e-01, -9.408473e-01,  1.242376e-01, -5.337930e-01, -5.762616e-01},
  {-6.152304e-01, -2.568680e-01, -7.453257e-01,  3.661294e-01,  3.985122e-01,  1.296072e-01},
  {-6.120238e-02, -6.174315e-01, -7.842402e-01,  2.517810e-01, -1.004400e+00,  1.761666e-01},
  {-7.769006e-01, -6.232871e-01,  8.909909e-02,  2.452550e-01, -1.002614e+00,  1.671209e-01},
  { 5.718901e-01,  5.273448e-01, -6.283703e-01,  3.754390e-01,  1.253597e+00, -1.901666e-01},
  { 4.699971e-01, -2.157080e-01, -8.559046e-01,  1.081070e-01, -1.157158e+00, -4.806457e-01},
  { 3.750527e-01,  6.042631e-01,  7.029948e-01,  1.081070e-01, -1.157158e+00, -4.806457e-01},
  { 6.768401e-01, -2.268768e-02, -7.357804e-01,  1.081070e-01, -1.157158e+00, -4.806457e-01},
  { 3.750527e-01,  6.042631e-01,  7.029948e-01,  1.231008e-01, -1.183877e+00, -4.656785e-01},
  { 3.750527e-01,  6.042631e-01,  7.029948e-01,  1.627911e-01, -1.208954e+00, -4.652986e-01},
  { 4.482990e-01,  7.571288e-01, -4.751673e-01,  1.627911e-01, -1.208954e+00, -4.652986e-01},
  { 2.401833e-01, -7.923543e-01,  5.607911e-01,  3.343648e-02, -1.237410e+00, -5.465720e-01},
  {-5.007468e-01, -8.385132e-01,  2.148214e-01, -5.777559e-03, -1.258877e+00, -5.777941e-01},
  { 4.660294e-01, -7.419846e-01, -4.819497e-01,  9.510934e-02, -1.191004e+00, -5.583805e-01},
  { 5.235381e-02,  4.543759e-02,  9.975945e-01, -2.485936e-01,  1.790809e-01,  2.332672e-01},
  {-5.162691e-01, -7.283794e-01,  4.504771e-01, -3.687897e-01, -1.433316e-01, -6.842991e-01},
  {-8.663206e-01, -4.424535e-01,  2.317835e-01, -3.094063e-01, -2.096026e-01, -7.483556e-01},
  {-6.360089e-01, -7.272692e-01,  2.580160e-01,  1.795289e-01, -9.324264e-01,  2.220568e-01},
  {-8.893496e-01, -3.439524e-01, -3.012541e-01, -3.449278e-01,  2.673413e-01, -4.760486e-01},
  {-7.603669e-01, -5.973728e-01, -2.549273e-01, -3.306851e-01,  2.194316e-01, -5.292413e-01},
  {-1.833809e-01,  4.597398e-01,  8.689135e-01, -5.062889e-02, -3.051649e-01, -3.766731e-01},
  { 8.821874e-01, -4.467220e-01,  1.489461e-01,  3.645978e-01,  4.822693e-01,  5.673808e-02},
  { 6.197077e-01, -1.946030e-01,  7.603237e-01, -2.906238e-01, -7.145052e-01,  1.426440e-01},
  { 5.402657e-01, -8.414265e-01,  1.070036e-02,  5.833552e-01,  1.218415e+00, -1.664167e-02},
  {-3.407743e-01, -1.115386e-02, -9.400790e-01,  3.454163e-01,  4.961847e-01,  1.044690e-01},
  { 9.978513e-01,  2.261951e-02,  6.149083e-02,  3.730067e-01,  3.754857e-01,  4.751215e-01},
  {-1.611495e-01,  8.739578e-01,  4.585070e-01,  3.730067e-01,  3.754857e-01,  4.751215e-01},
  {-4.020157e-01,  8.393775e-01,  3.658262e-01,  3.723623e-01,  3.380815e-01,  4.993385e-01},
  { 9.978513e-01,  2.261951e-02,  6.149083e-02,  3.714318e-01,  3.420086e-01,  5.129936e-01},
  { 9.712457e-02, -2.906393e-03,  9.952680e-01,  3.776500e-01,  3.447016e-01,  5.213003e-01},
  { 1.093509e-01,  9.812914e-01,  1.584604e-01,  1.687061e-01, -3.329170e-01, -4.875719e-01},
  { 9.177794e-01,  1.037243e-01,  3.833043e-01, -4.128381e-01,  1.060162e-01, -3.975686e-01},
  {-7.521603e-01,  6.211210e-01, -2.201446e-01,  1.087608e-01,  1.070776e+00,  3.309519e-01},
  { 7.055554e-01,  7.022473e-01, -9.508166e-02,  1.087608e-01,  1.070776e+00,  3.309519e-01},
  { 2.094812e-02,  9.564418e-01, -2.911704e-01,  1.043854e-01,  1.081120e+00,  3.748842e-01},
  { 7.055554e-01,  7.022473e-01, -9.508166e-02,  1.043854e-01,  1.081120e+00,  3.748842e-01},
  { 6.775042e-01,  3.062533e-01, -6.687279e-01,  2.089945e-01,  1.056192e+00,  4.044323e-02},
  { 2.721262e-01, -9.133890e-01, -3.027671e-01,  3.753362e-01, -1.134100e+00, -2.651666e-01},
  {-1.864222e-01, -6.041788e-01, -7.747352e-01,  2.608273e-01, -1.020752e+00, -2.388682e-01},
  { 2.750386e-01,  6.762432e-01, -6.834096e-01,  2.608273e-01, -1.020752e+00, -2.388682e-01},
  {-9.685489e-01, -2.236986e-01, -1.089588e-01,  2.867833e-01, -1.165758e+00, -3.303632e-01},
  { 8.216650e-03, -1.502670e-01, -9.886113e-01,  5.375268e-02,  2.542913e-01, -8.335750e-01},
  {-5.763789e-01, -7.380221e-01,  3.508714e-01, -1.783802e-02,  2.507959e-01, -8.499963e-01},
  { 2.000378e-01,  2.939351e-01, -9.346588e-01, -1.783802e-02,  2.507959e-01, -8.499963e-01},
  {-7.998259e-01,  3.447826e-01,  4.913283e-01,  2.539238e-01,  6.517212e-01,  5.389852e-01},
  { 6.774880e-01, -3.100615e-01,  6.669871e-01,  2.539238e-01,  6.517212e-01,  5.389852e-01},
  { 9.522319e-01, -3.051516e-01, -1.170191e-02,  3.127162e-01, -4.553131e-02,  4.063941e-01},
  { 7.667754e-01,  2.008196e-01,  6.096941e-01,  5.936737e-01,  1.151900e+00,  5.369623e-02},
  {-2.361366e-01, -5.447602e-02,  9.701917e-01,  2.558699e-01,  1.046578e+00,  4.183547e-02},
  {-3.071389e-01,  7.925972e-01,  5.267404e-01,  2.482333e-01,  1.002793e+00,  1.032664e-01},
  {-3.951457e-01, -8.044372e-01, -4.435547e-01,  3.458363e-01, -6.720456e-01, -1.853470e-01},
  { 3.951457e-01,  8.044371e-01,  4.435547e-01,  3.458363e-01, -6.720456e-01, -1.853470e-01},
  { 8.950539e-01,  4.309999e-01, -1.145321e-01,  3.352099e-01, -6.931412e-01, -1.376212e-01},
  {-3.951457e-01, -8.044372e-01, -4.435547e-01,  3.352099e-01, -6.931412e-01, -1.376212e-01},
  { 8.046378e-01, -9.166894e-02, -5.866471e-01,  3.399779e-01,  2.157234e-01,  1.452308e-01},
  {-7.827373e-01,  4.429991e-01, -4.371202e-01,  9.327132e-02,  6.249965e-01, -6.034036e-01},
  {-7.948079e-01, -1.185883e-01, -5.951615e-01, -7.457795e-02, -9.376011e-03, -7.407809e-01},
  {-6.478507e-01,  7.544868e-02,  7.580217e-01,  5.091511e-01,  8.029005e-02, -4.267704e-02},
  {-3.312088e-01, -2.761489e-01,  9.022430e-01,  5.054712e-01,  1.976735e-01, -5.750569e-02},
  { 3.862665e-01,  5.084170e-01,  7.696170e-01, -1.669757e-01, -1.039042e-01, -1.779272e-01},
  { 4.755801e-01, -7.146962e-01, -5.128673e-01, -4.400521e-01, -5.468520e-01, -5.932994e-01},
  { 9.785969e-02, -7.348223e-01,  6.711630e-01, -1.009284e-01, -4.978978e-02,  4.053186e-01},
  {-9.871990e-01, -6.965662e-03, -1.593411e-01, -1.009284e-01, -4.978978e-02,  4.053186e-01},
  {-9.552802e-02,  8.490488e-01, -5.196063e-01,  3.625041e-01,  1.232693e+00,  1.002772e-01},
  {-6.532194e-02,  9.264460e-01,  3.707167e-01,  1.274659e-01, -2.658473e-01,  6.495034e-01},
  {-2.919708e-01,  8.274523e-01,  4.796621e-01,  1.193146e-01, -2.760116e-01,  6.441504e-01},
  { 4.767727e-02, -9.900094e-01,  1.326960e-01,  1.572395e-01, -2.684841e-01,  6.191337e-01},
  { 4.768753e-01, -7.376647e-01,  4.779548e-01,  3.621618e-01, -5.044701e-01, -7.677630e-02},
  {-5.578240e-01,  8.229238e-01,  1.078376e-01,  2.493703e-01,  2.323025e-01, -3.805385e-01},
  { 4.777010e-01,  1.151056e-03, -8.785217e-01,  2.661940e-01,  2.451408e-01, -3.914835e-01},
  {-7.245433e-01,  4.415964e-01, -5.291783e-01,  1.298617e-01,  6.652040e-01, -1.048003e-01},
  {-5.809591e-01, -3.470532e-01,  7.362341e-01, -1.887083e-01,  4.903565e-01, -2.485049e-01},
  { 7.156700e-01,  1.514122e-01, -6.818290e-01,  1.344067e-01,  6.077437e-01, -1.127899e-01},
  {-2.907403e-01, -4.824722e-01, -8.262510e-01,  3.084203e-01,  1.748490e-01,  4.569274e-01},
  { 9.111464e-01,  3.990247e-01,  1.029148e-01,  2.413821e-01,  7.296449e-01, -2.380651e-01},
  { 1.947654e-01, -6.117784e-01, -7.666769e-01,  1.091501e-01,  7.676966e-01, -2.426173e-01},
  { 1.301594e-01,  8.886995e-01, -4.396269e-01,  1.091501e-01,  7.676966e-01, -2.426173e-01},
  { 5.683090e-01,  8.458246e-02, -8.184564e-01,  3.711899e-01, -2.697046e-01, -2.391369e-01},
  {-5.214840e-01, -8.509964e-01, -6.212721e-02,  3.711899e-01, -2.697046e-01, -2.391369e-01},
  { 2.946020e-01, -9.184880e-01,  2.637980e-01,  3.129654e-01, -2.567881e-01, -2.782313e-01},
  { 9.186242e-01,  1.794083e-01, -3.520542e-01,  3.012172e-01, -2.236265e-01, -2.829618e-01},
  { 4.655074e-01, -2.537500e-01, -8.478879e-01,  3.711221e-01, -1.041344e+00, -4.729971e-01},
  { 7.623022e-02,  8.946548e-01, -4.402065e-01, -2.522187e-01, -2.968153e-01, -9.433686e-02},
  { 7.623022e-02,  8.946548e-01, -4.402065e-01, -3.235128e-01, -2.872495e-01, -8.724179e-02},
  {-4.212152e-01, -8.794050e-01, -2.218661e-01, -9.813138e-02, -1.984730e-01,  2.512360e-01},
  { 4.211545e-01,  8.878929e-01, -1.851355e-01,  1.581309e-01, -1.183901e+00, -3.617108e-01},
  {-2.071173e-01, -2.686579e-01, -9.407047e-01,  1.239918e-01, -1.157209e+00, -3.113587e-01},
  { 4.211545e-01,  8.878929e-01, -1.851355e-01,  6.154438e-02, -1.120646e+00, -2.780673e-01},
  { 9.501778e-01,  8.563282e-02, -2.997153e-01,  3.089363e-01, -2.947221e-01, -3.018427e-01},
  { 6.763735e-01,  4.221170e-01,  6.036026e-01,  2.085500e-01, -7.412518e-01, -4.875005e-01},
  {-6.800791e-01, -4.123271e-01,  6.062003e-01, -1.002091e-01, -9.277113e-01, -4.184123e-01},
  { 2.681787e-01,  6.667745e-01,  6.953359e-01,  1.929208e-01, -5.719622e-01,  6.501667e-01},
  {-8.851396e-02,  4.304999e-01,  8.982400e-01,  5.478579e-01, -4.867346e-02, -1.835882e-01},
  { 5.997511e-01, -3.645350e-02, -7.993559e-01,  5.422451e-01, -2.316025e-02, -1.963690e-01},
  {-6.447017e-01,  2.844374e-01, -7.095458e-01, -5.249822e-01, -6.188769e-01, -2.547399e-01},
  { 2.537011e-02,  9.451092e-01,  3.257683e-01, -1.677364e-01, -5.502580e-01,  2.607206e-01},
  { 3.324376e-01, -8.935745e-01,  3.016786e-01,  1.426596e-01, -3.415123e-01, -4.843292e-01},
  {-4.424212e-01,  8.966810e-01, -1.505334e-02, -1.456701e-01,  4.899377e-01,  4.149278e-01},
  {-2.378048e-01, -8.897691e-01,  3.895635e-01, -1.456701e-01,  4.899377e-01,  4.149278e-01},
  { 4.809371e-01,  2.302859e-01, -8.459716e-01,  2.543084e-01,  2.112616e-01, -4.014741e-01},
  { 1.618843e-01,  1.754117e-01, -9.710943e-01, -1.420251e-01,  3.716411e-02,  2.267498e-02},
  {-7.620753e-01, -7.171112e-02, -6.435050e-01, -6.354456e-02,  1.425749e-01,  6.049971e-02},
  {-8.860204e-01,  4.030061e-01,  2.292467e-01,  2.316181e-01,  7.203964e-01,  4.544823e-01},
  { 9.172093e-01, -1.612431e-01, -3.643182e-01,  3.841352e-01,  1.287033e+00, -1.790057e-01},
  { 4.417713e-01,  2.928606e-01,  8.479805e-01, -4.028950e-02, -1.046598e+00,  7.742675e-02},
  { 4.417713e-01,  2.928606e-01,  8.479805e-01,  1.308228e-01, -5.480970e-01, -5.885836e-01},
  { 1.411203e-02,  8.283196e-02,  9.964635e-01,  4.069425e-01,  3.029319e-01,  5.183198e-01},
  { 3.175733e-02, -9.981897e-01, -5.107377e-02,  2.251373e-01, -2.665028e-01,  6.095203e-01},
  { 4.670710e-01, -5.007266e-01, -7.287781e-01, -1.199243e-01, -8.905537e-01,  8.108726e-02},
  { 5.178244e-01, -8.041105e-01, -2.920003e-01, -8.982255e-02, -8.143793e-01,  1.706625e-02},
  { 6.405880e-01, -7.433918e-01, -1.923942e-01,  2.015024e-01, -3.264217e-01, -1.594658e-01},
  {-9.341654e-01,  3.073808e-01,  1.812515e-01,  3.583361e-01,  2.077106e-01,  5.107918e-01},
  { 2.514746e-01, -8.762211e-01,  4.110926e-01, -8.965567e-02, -3.709100e-02,  3.932916e-01},
  {-2.963865e-01,  4.018997e-01,  8.663900e-01,  2.108276e-01, -3.185843e-01, -1.653929e-01},
  {-9.546247e-01,  2.954091e-01, -3.775177e-02,  2.108276e-01, -3.185843e-01, -1.653929e-01},
  { 6.125621e-01, -2.500594e-01,  7.498252e-01,  4.737340e-01, -1.874109e-02, -1.995238e-03},
  {-7.993251e-01, -5.790229e-01,  1.606606e-01,  3.932943e-01, -2.192728e-02,  7.852954e-01},
  {-7.174965e-01, -1.697395e-01,  6.755645e-01,  3.697267e-01,  2.517361e-02,  7.720993e-01},
  {-6.451805e-01,  6.938800e-01, -3.198012e-01,  1.821399e-02, -4.997928e-01,  2.276526e-01},
  { 1.517609e-01,  1.384919e-01,  9.786668e-01,  1.821399e-02, -4.997928e-01,  2.276526e-01},
  {-8.336818e-01, -1.906945e-01, -5.182762e-01,  1.821399e-02, -4.997928e-01,  2.276526e-01},
  {-6.219510e-01,  7.620866e-01, -1.800027e-01,  3.099197e-02, -4.982490e-01,  2.052233e-01},
  {-2.078890e-01, -1.038564e-01,  9.726232e-01, -8.822213e-02, -6.075568e-01,  2.002573e-01},
  { 1.973640e-01, -8.594003e-01, -4.716763e-01,  4.333130e-02, -5.773671e-01,  3.023737e-01},
  {-3.845064e-01, -7.077782e-01, -5.926256e-01,  2.555124e-02, -7.426490e-01,  2.950259e-01},
  {-7.302011e-01, -5.057920e-01,  4.593265e-01,  1.428509e-01, -8.562274e-01,  2.226803e-01},
  {-8.944272e-01,  0.000000e+00,  4.472136e-01, -3.779109e-01, -3.060037e-01, -7.189531e-01},
  {-7.457437e-01,  4.892406e-01,  4.522278e-01, -7.058870e-02, -1.080841e+00, -4.914223e-01},
  { 1.820766e-01, -7.575170e-01, -6.269099e-01, -1.104207e-01, -1.075522e+00,  1.720768e-01},
  { 6.293311e-01, -5.760272e-01,  5.216656e-01,  9.518989e-02, -1.255549e+00, -7.000985e-01},
  { 8.000873e-01, -4.017163e-01, -4.455158e-01, -3.166580e-01, -2.948059e-01, -6.226574e-01},
  {-6.161506e-01,  5.377859e-01, -5.754518e-01, -6.788595e-03, -1.073069e+00,  8.183745e-02},
  {-8.033820e-01, -1.314684e-01,  5.807695e-01, -3.804253e-01, -1.188851e-01,  4.936020e-01},
  { 4.759935e-01,  8.794443e-01, -2.834147e-03, -3.804253e-01, -1.188851e-01,  4.936020e-01},
  {-8.954794e-01, -4.083602e-01, -1.770838e-01, -3.140447e-01, -8.857111e-01,  2.504710e-01},
  {-7.063102e-01, -1.448096e-01, -6.929330e-01, -3.347554e-01, -8.416033e-01,  2.623638e-01},
  {-5.234879e-01,  3.121072e-01,  7.928112e-01, -5.793893e-01, -3.083648e-01, -2.563109e-01},
  {-9.179346e-01,  7.149521e-02,  3.902365e-01, -6.150451e-01, -3.198692e-01, -2.994796e-01},
  {-7.960298e-01,  9.950373e-02,  5.970224e-01,  2.322478e-01, -2.364497e-01,  8.223842e-02},
  {-7.960298e-01,  9.950373e-02,  5.970224e-01,  2.471170e-01, -6.498249e-02,  1.520454e-01},
  { 5.723398e-01, -6.302850e-01, -5.245644e-01,  3.230510e-01, -1.256754e-02,  3.877765e-01},
  { 9.741622e-01, -1.866610e-01,  1.271443e-01,  3.230510e-01, -1.256754e-02,  3.877765e-01},
  { 7.441323e-01, -2.230563e-01, -6.296927e-01, -7.399485e-02, -2.521879e-01, -4.192427e-01},
  {-5.467591e-02, -8.725634e-01, -4.854314e-01,  1.396440e-02, -3.477162e-01, -5.831419e-01},
  { 3.833480e-01,  8.532222e-01, -3.536328e-01,  3.685434e-01, -2.742746e-01, -2.611663e-01},
  { 7.263992e-01,  4.334773e-01,  5.333306e-01,  1.630071e-01, -5.091025e-01,  5.939788e-01},
  { 9.153808e-01,  1.832955e-01,  3.584423e-01,  1.675087e-01, -4.871166e-01,  5.712397e-01},
  {-2.803402e-01,  6.651422e-01,  6.920949e-01, -4.654372e-01,  2.353611e-01,  1.182977e-01},
  {-2.803402e-01,  6.651422e-01,  6.920949e-01, -4.796638e-01,  2.051722e-01,  1.415483e-01},
  {-6.714762e-01,  3.698197e-01,  6.421472e-01,  7.411940e-02,  6.296854e-01, -5.390965e-01},
  { 6.485649e-01,  4.731965e-01,  5.961950e-01,  8.275292e-02,  6.134863e-01, -5.962336e-01},
  {-2.848189e-01, -7.830847e-01, -5.528623e-01,  3.129654e-01, -2.567881e-01, -2.782313e-01},
  { 8.489115e-01,  2.330749e-01, -4.743682e-01,  3.129654e-01, -2.567881e-01, -2.782313e-01},
  { 9.763903e-01,  2.040217e-01, -7.097234e-02,  2.931414e-01, -2.051989e-01, -3.410905e-01},
  { 1.109842e-01, -4.143302e-01,  9.033344e-01, -5.184913e-01, -3.875039e-01, -2.649478e-01},
  { 1.109842e-01, -4.143302e-01,  9.033344e-01,  1.074637e-01, -4.470901e-01, -5.668581e-01},
  {-7.345217e-01, -6.374332e-01, -2.327161e-01,  3.141379e-01, -1.947469e-01, -4.542324e-01},
  { 1.130803e-01,  4.473126e-01,  8.872002e-01,  2.085500e-01, -7.412518e-01, -4.875005e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.962332e-01, -4.393646e-02, -7.395712e-02},
  { 9.769198e-02, -9.495847e-01, -2.979015e-01,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  {-8.476244e-01, -5.100940e-01,  1.460723e-01,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  { 8.639919e-01, -3.915077e-01, -3.166067e-01,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  {-7.715191e-01, -3.477722e-01,  5.327408e-01,  2.195704e-01, -1.158283e-01,  6.185338e-01},
  { 8.639919e-01, -3.915077e-01, -3.166067e-01,  2.363129e-01, -1.415061e-01,  6.260179e-01},
  { 6.400853e-01, -7.236205e-01,  2.581941e-01, -2.486223e-01, -5.388743e-01,  2.423685e-01},
  { 3.858733e-01, -7.894656e-01, -4.773320e-01,  7.438486e-03,  1.145651e+00,  1.595110e-01},
  { 3.858733e-01, -7.894656e-01, -4.773320e-01,  1.492018e-01,  1.181276e+00,  2.151913e-01},
  { 4.318362e-01,  8.649549e-01,  2.556767e-01,  9.756679e-02, -1.051842e+00, -1.985338e-01},
  { 6.565945e-01,  1.911974e-01,  7.296076e-01,  4.853890e-01,  4.909247e-01,  1.810604e-01},
  {-1.988978e-01, -4.313330e-01, -8.799951e-01, -3.641523e-02,  3.829678e-01,  3.547729e-01},
  { 2.758747e-01, -1.554662e-01,  9.485375e-01,  1.061768e-01, -7.657879e-01,  2.287099e-01},
  { 5.592296e-01, -4.697301e-01, -6.830928e-01,  1.061768e-01, -7.657879e-01,  2.287099e-01},
  { 6.911933e-01, -1.753332e-02,  7.224572e-01,  4.989926e-02, -7.227693e-01,  2.521286e-01},
  {-9.212186e-01, -2.852825e-01,  2.645186e-01,  8.196565e-02, -7.266506e-01,  1.819761e-01},
  {-8.621032e-01, -5.023093e-01, -6.680929e-02, -1.842898e-01, -1.036346e+00,  1.707637e-01},
  { 1.491872e-01,  4.309652e-01,  8.899506e-01, -1.912261e-01, -1.008760e+00,  1.585678e-01},
  {-7.130115e-02,  5.065630e-01, -8.592497e-01,  3.820934e-01,  6.523027e-01, -4.323339e-01},
  { 2.022942e-01, -2.089908e-01, -9.567653e-01,  1.316428e-01, -7.706977e-01, -3.616480e-01},
  { 6.400853e-01, -7.236205e-01,  2.581941e-01, -2.005457e-01, -5.172772e-01,  1.837109e-01},
  { 6.400853e-01, -7.236205e-01,  2.581941e-01, -1.683539e-01, -4.946202e-01,  1.674037e-01},
  { 4.464616e-01, -8.886065e-01,  1.051210e-01, -1.683539e-01, -4.946202e-01,  1.674037e-01},
  { 6.588144e-01,  7.200131e-01,  2.180473e-01, -1.614271e-02, -5.797896e-01, -4.345751e-01},
  { 6.849537e-02,  4.626052e-02,  9.965783e-01,  2.234762e-02,  7.561963e-01, -1.949420e-01},
  {-1.641083e-01,  8.178845e-01,  5.514829e-01, -7.881925e-02,  2.050832e-01,  6.174588e-01},
  {-4.130611e-01,  5.290936e-01, -7.412425e-01,  1.804221e-02,  5.629697e-01, -5.593126e-01},
  { 2.403999e-01,  1.916872e-01,  9.515587e-01, -3.698129e-01,  3.483780e-01, -4.057888e-01},
  {-2.183973e-01,  2.989446e-01,  9.289429e-01, -3.859615e-01,  3.059464e-01, -4.092877e-01},
  {-6.665394e-01,  6.316789e-01,  3.958622e-01, -3.701575e-01,  3.108015e-01, -3.904246e-01},
  {-4.104742e-01,  9.005209e-01, -1.434330e-01,  4.453505e-02, -4.672993e-01,  7.478225e-01},
  {-2.256587e-01, -3.509423e-01,  9.088001e-01, -2.356942e-01, -9.298817e-01, -7.691669e-01},
  { 5.406027e-01,  7.603989e-01, -3.599198e-01, -2.708847e-01,  1.965650e-01, -6.396124e-01},
  { 3.260223e-01,  9.121302e-01, -2.484513e-01, -2.201382e-01,  1.792519e-01, -6.365832e-01},
  {-7.921613e-02, -2.922105e-01, -9.530676e-01, -2.563475e-02,  3.406222e-02, -4.686561e-01},
  {-9.694110e-01, -4.668186e-02,  2.409631e-01, -3.050467e-01, -2.289627e-01, -7.345673e-01},
  { 8.097497e-03, -2.591389e-01, -9.658061e-01, -2.665324e-01,  5.632172e-01, -4.895217e-01},
  {-4.091653e-01,  4.310801e-01, -8.042099e-01, -2.314374e-02,  5.387602e-01, -5.536421e-01},
  {-7.273057e-01,  2.512343e-01, -6.386766e-01, -1.072711e-01,  5.149037e-01, -4.986652e-01},
  { 3.487789e-01, -9.367425e-01,  2.944250e-02, -2.951013e-01, -2.239717e-01, -6.935894e-01},
  { 9.170643e-01, -2.253403e-01, -3.289603e-01,  3.695287e-01,  4.440192e-01,  6.451672e-02},
  {-1.064596e-01, -5.227507e-02, -9.929420e-01, -5.941947e-02, -8.870897e-01, -6.560770e-01},
  { 3.277577e-01, -7.465708e-01,  5.789706e-01, -5.941947e-02, -8.870897e-01, -6.560770e-01},
  { 3.277577e-01, -7.465708e-01,  5.789706e-01, -1.395175e-01, -8.843907e-01, -6.072528e-01},
  { 7.740353e-01,  4.982975e-01, -3.906008e-01,  1.917457e-02, -8.408617e-01, -6.782118e-01},
  {-3.221835e-01,  4.419833e-01, -8.371670e-01,  3.264870e-01,  1.189332e+00, -6.035629e-02},
  {-7.658798e-01,  2.067659e-01,  6.088316e-01,  3.264870e-01,  1.189332e+00, -6.035629e-02},
  {-8.842261e-01,  4.060492e-01,  2.307990e-01,  3.744883e-01,  1.193989e+00,  2.558044e-03},
  { 1.476333e-01, -9.607851e-01,  2.347265e-01, -4.227870e-01, -6.482350e-01, -2.463989e-01},
  { 2.922199e-01, -9.316127e-01, -2.161143e-01, -4.383436e-01, -5.325865e-01, -6.115946e-01},
  { 7.107861e-02, -9.964988e-01,  4.402254e-02,  3.083986e-01,  2.872586e-01,  7.912961e-01},
  {-4.308709e-01,  8.857329e-01, -1.727066e-01,  2.741538e-01, -4.228146e-01,  1.675671e-01},
  { 7.605007e-01, -5.725958e-01, -3.062234e-01,  2.741538e-01, -4.228146e-01,  1.675671e-01},
  {-4.308709e-01,  8.857329e-01, -1.727066e-01,  2.829615e-01, -4.113417e-01,  2.044323e-01},
  {-4.308709e-01,  8.857329e-01, -1.727066e-01,  3.807614e-01, -3.469795e-01,  2.905242e-01},
  { 9.890410e-01,  3.802915e-02, -1.426595e-01,  4.153463e-01,  8.887135e-03,  2.372110e-01},
  { 9.893961e-01,  1.201740e-01,  8.156922e-02,  4.690298e-01, -1.253891e-01,  2.161329e-01},
  { 9.753700e-01,  1.081704e-01, -1.922305e-01,  3.734128e-01, -4.262955e-01, -2.875216e-01},
  { 8.892025e-01, -4.153648e-01, -1.918100e-01, -6.011383e-02, -2.008660e-01, -5.521001e-01},
  { 5.455236e-01,  7.104075e-01,  4.446631e-01, -6.305359e-02, -2.312159e-01, -5.000055e-01},
  { 3.880601e-01, -9.047068e-01,  1.758265e-01,  4.307682e-01, -5.606039e-01,  3.894837e-01},
  { 8.682315e-01,  4.819955e-01,  1.177054e-01,  4.307682e-01, -5.606039e-01,  3.894837e-01},
  { 2.013344e-01, -1.965614e-01, -9.595979e-01,  5.288737e-03, -6.859037e-02, -5.353465e-01},
  {-1.528257e-01,  5.887710e-02,  9.864978e-01, -2.132747e-01, -3.520499e-01,  1.786976e-01},
  {-1.528257e-01,  5.887710e-02,  9.864978e-01, -2.301926e-01, -3.864239e-01,  1.659516e-01},
  { 1.476333e-01, -9.607851e-01,  2.347265e-01, -4.316677e-01, -6.520817e-01, -2.565584e-01},
  {-4.247964e-01,  6.158271e-01, -6.635548e-01,  1.451596e-01,  1.047145e+00,  2.802068e-01},
  {-4.247964e-01,  6.158271e-01, -6.635548e-01,  1.204271e-01,  1.053956e+00,  3.023618e-01},
  {-7.929459e-01, -1.719333e-02,  6.090494e-01, -7.080508e-02, -1.035520e+00, -5.078807e-01},
  {-3.089571e-01,  2.719323e-01,  9.113717e-01,  3.021520e-01, -8.012068e-02,  4.487270e-01},
  {-1.938576e-01, -8.501467e-01,  4.895610e-01,  2.884490e-01, -1.305913e-01,  4.251273e-01},
  { 5.845654e-02, -8.550066e-01,  5.153122e-01,  3.684465e-01, -2.480575e-01, -1.215446e-01},
  { 7.050510e-01, -7.025037e-01,  9.690993e-02,  3.549948e-01,  3.746046e-01, -3.469660e-01},
  { 1.127806e-01,  9.757006e-01, -1.878530e-01, -4.620836e-01, -4.216166e-01, -1.258315e-01},
  { 3.124315e-01, -5.004721e-01,  8.074121e-01, -3.094063e-01, -2.096026e-01, -7.483556e-01},
  {-9.801700e-01, -3.179911e-02, -1.955908e-01, -1.542462e-01,  9.083324e-01, -2.394603e-01},
  {-2.274805e-01,  6.562088e-01, -7.194740e-01, -1.642181e-04, -6.851586e-01, -3.438312e-01},
  { 6.543753e-01, -1.309911e-01, -7.447377e-01, -1.642181e-04, -6.851586e-01, -3.438312e-01},
  { 5.931184e-01,  1.591412e-01, -7.892304e-01, -3.778349e-03, -6.415772e-01, -3.204200e-01},
  {-7.890712e-01,  5.153198e-01, -3.343834e-01,  4.784307e-02, -6.141101e-01, -3.393487e-01},
  { 4.580516e-01, -1.529977e-01, -8.756601e-01,  2.429635e-01, -8.279733e-01,  1.006247e-01},
  { 2.066485e-01, -4.597846e-01,  8.636519e-01,  2.429635e-01, -8.279733e-01,  1.006247e-01},
  { 7.117664e-01,  6.527164e-01, -2.595188e-01,  2.267110e-01, -8.035305e-01,  1.175262e-01},
  { 1.968378e-01,  8.724164e-01,  4.473750e-01, -3.014927e-01, -1.489391e-01,  1.778862e-01},
  {-7.710411e-01, -5.634526e-01, -2.966763e-01,  4.747209e-01,  4.726921e-01, -2.308885e-01},
  {-5.882789e-01,  1.777058e-01,  7.888907e-01,  3.332536e-01,  2.815293e-01,  1.178524e-01},
  {-5.882789e-01,  1.777058e-01,  7.888907e-01,  3.368511e-01,  2.568505e-01,  1.260941e-01},
  { 9.169598e-01, -2.229662e-01,  3.308639e-01,  3.344559e-01, -8.269599e-02,  6.619356e-01},
  { 1.162060e-01, -8.892439e-01,  4.424268e-01, -3.067001e-02, -2.372451e-02,  3.856987e-01},
  {-9.405941e-01,  1.544486e-01,  3.023711e-01,  5.239341e-02, -1.223884e+00, -4.017548e-01},
  {-1.943492e-01,  9.486288e-01, -2.496633e-01,  1.013417e-01,  4.377267e-01, -4.429853e-01},
  {-3.384925e-01,  1.350611e-01, -9.312257e-01,  5.611790e-02,  4.380986e-01, -4.063678e-01},
  {-3.873647e-01,  5.940306e-01, -7.050364e-01,  5.611790e-02,  4.380986e-01, -4.063678e-01},
  { 9.231389e-01,  2.042404e-01,  3.257307e-01,  5.012639e-01,  1.356157e+00, -1.443342e-01},
  { 4.399450e-02,  9.948689e-01,  9.110609e-02,  1.831679e-01,  7.615631e-01, -2.113835e-01},
  { 4.192903e-01,  3.669505e-01, -8.303872e-01,  1.322428e-01,  8.548788e-01, -3.063190e-01},
  {-5.935745e-02, -7.576168e-01, -6.499950e-01,  1.322428e-01,  8.548788e-01, -3.063190e-01},
  {-7.530541e-01,  6.579586e-01,  0.000000e+00,  3.139093e-01,  2.957263e-01,  1.076630e-01},
  {-9.884583e-01,  1.503858e-01,  1.828801e-02, -3.014927e-01, -1.489391e-01,  1.778862e-01},
  { 8.638862e-01,  2.680815e-01, -4.264188e-01,  5.810545e-01,  8.997921e-01,  3.757495e-01},
  { 2.025516e-01, -2.625642e-02, -9.789196e-01, -3.030566e-01, -3.228572e-01, -5.313232e-01},
  { 6.870630e-01,  2.472142e-01,  6.832492e-01,  4.758209e-01,  4.302082e-01,  2.087123e-01},
  { 7.924526e-01,  8.077648e-02,  6.045611e-01,  4.585796e-01,  3.989701e-01,  2.354858e-01},
  {-4.597763e-02, -4.092956e-01, -9.112427e-01,  3.108694e-01, -7.463759e-01,  3.050541e-01},
  { 6.361382e-02, -5.839335e-01, -8.093053e-01,  3.104547e-01, -7.112241e-01,  2.850818e-01},
  { 5.044335e-01, -5.929109e-01, -6.276971e-01, -1.802327e-01, -9.177987e-01, -2.609485e-01},
  { 3.940037e-01, -2.173008e-01,  8.930518e-01, -1.802327e-01, -9.177987e-01, -2.609485e-01},
  {-9.445398e-01,  1.037455e-01,  3.115790e-01, -2.282118e-01, -9.680763e-01, -2.520145e-01},
  { 3.073366e-01, -9.776469e-02,  9.465656e-01, -2.282118e-01, -9.680763e-01, -2.520145e-01},
  {-3.184122e-01,  1.451205e-01,  9.367784e-01, -1.213645e-01, -1.013188e+00, -2.742079e-01},
  { 4.521115e-01, -3.939806e-01, -8.002340e-01, -1.393690e-01, -8.941664e-01, -2.732268e-01},
  {-5.877704e-01,  6.748807e-01, -4.461636e-01, -8.029869e-02,  7.384931e-01,  4.377305e-01},
  {-8.804453e-01, -4.721594e-01,  4.337741e-02, -7.148369e-02,  6.813828e-01,  3.998404e-01},
  { 1.258002e-01,  9.902059e-01,  6.055294e-02, -7.148369e-02,  6.813828e-01,  3.998404e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  2.240757e-01,  1.232054e+00, -4.243907e-02},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  1.644627e-01,  1.128803e+00, -2.849364e-02},
  {-6.489325e-02, -4.603171e-01, -8.853796e-01,  3.230529e-01, -3.844742e-01, -2.962041e-01},
  { 5.034297e-01, -1.160159e-01, -8.562120e-01,  3.838198e-01, -4.036375e-01, -2.728500e-01},
  {-3.445364e-02,  6.664404e-01, -7.447618e-01,  3.608607e-01, -4.249812e-01, -2.908870e-01},
  {-4.326073e-01, -7.261599e-01, -5.343620e-01, -3.719033e-01,  5.603606e-02, -5.252948e-01},
  { 4.339274e-01,  1.779294e-01,  8.832034e-01,  1.902093e-02,  2.430048e-01,  2.662534e-01},
  {-3.375829e-01,  1.782647e-01,  9.242616e-01, -2.259290e-01, -8.934249e-01, -1.294552e-01},
  {-7.737300e-01,  6.128685e-01,  1.604188e-01, -1.862520e-01, -8.140388e-01, -1.699331e-01},
  { 1.268413e-01,  2.704938e-01,  9.543293e-01, -7.545239e-02,  7.233509e-01,  3.505095e-01},
  {-8.804453e-01, -4.721594e-01,  4.337741e-02, -1.255684e-01,  7.834932e-01,  4.135272e-01},
  { 4.221994e-02, -7.123519e-02, -9.965656e-01, -4.985873e-01, -3.006216e-01,  3.815122e-02},
  {-6.478824e-01, -7.222897e-01,  2.419628e-01,  2.057637e-01,  4.661338e-01, -4.497620e-01},
  {-2.557371e-01, -1.778237e-01,  9.502512e-01,  2.273798e-01,  4.416879e-01, -4.485192e-01},
  {-9.569351e-01, -2.759003e-01, -9.030066e-02,  1.316793e-01,  5.364047e-01, -4.133496e-01},
  { 1.323488e-02, -9.491692e-01, -3.144879e-01,  4.314311e-01, -5.720951e-01,  2.705259e-01},
  {-1.658144e-01, -3.970091e-01, -9.027123e-01,  3.960206e-01, -5.751617e-01,  2.712584e-01},
  { 3.964905e-01, -9.144254e-01,  8.137249e-02,  2.776068e-01,  2.879468e-01,  8.565899e-01},
  {-5.589914e-01, -7.963319e-01, -2.310502e-01, -4.136609e-01, -5.927291e-01, -5.976752e-01},
  {-2.409240e-01,  3.471043e-01,  9.063522e-01, -1.183601e-01, -1.061210e+00,  1.677639e-01},
  { 7.396933e-01,  6.682622e-01,  7.924317e-02, -1.276924e-01, -7.280589e-01, -6.044495e-01},
  {-4.605412e-02,  2.143949e-01, -9.756607e-01, -5.932211e-02, -7.708737e-01, -5.451498e-01},
  { 5.853216e-01, -7.652184e-01,  2.680291e-01,  2.958336e-01, -2.372414e-01, -9.487583e-02},
  {-3.968757e-01,  3.239437e-02,  9.173005e-01,  3.886442e-01,  4.970630e-01,  4.748307e-01},
  {-4.069534e-01,  7.669986e-01,  4.960869e-01,  2.482333e-01,  1.002793e+00,  1.032664e-01},
  {-3.390035e-01, -1.388227e-01,  9.304864e-01, -2.733316e-01, -1.060204e-01, -6.298031e-01},
  { 2.156069e-01,  4.364940e-01, -8.734911e-01, -2.526205e-01, -1.943455e-02, -5.965888e-01},
  {-5.837917e-01, -8.043275e-01, -1.106542e-01,  2.651505e-01,  4.425625e-01, -4.381904e-01},
  {-8.157800e-01,  3.031650e-01,  4.925383e-01, -4.459142e-02,  2.123944e-01,  8.012890e-02},
  {-8.157800e-01,  3.031650e-01,  4.925383e-01,  2.453803e-01,  7.800792e-01,  2.980011e-01},
  {-8.157800e-01,  3.031650e-01,  4.925383e-01,  2.413743e-01,  8.182038e-01,  2.672447e-01},
  { 4.318626e-01,  6.825686e-01,  5.895718e-01,  4.223140e-01,  8.642718e-01,  9.777933e-02},
  { 6.462775e-01, -5.060430e-02,  7.614228e-01, -3.698668e-01,  2.996604e-01, -3.858312e-01},
  { 1.665075e-01,  9.820464e-01, -8.865768e-02, -5.083697e-01, -2.996866e-01,  3.999266e-02},
  {-1.106544e-01, -7.423843e-01, -6.607731e-01, -5.845059e-01, -3.751197e-01,  4.893769e-02},
  {-6.059547e-01,  5.454342e-01,  5.790686e-01, -5.845059e-01, -3.751197e-01,  4.893769e-02},
  {-4.535504e-03,  1.164370e-01, -9.931877e-01, -5.845059e-01, -3.751197e-01,  4.893769e-02},
  { 1.140697e-01, -8.421151e-01, -5.270961e-01, -4.972901e-01, -3.896450e-01,  2.218845e-02},
  {-2.695760e-01, -8.739617e-01, -4.043759e-01, -4.972901e-01, -3.896450e-01,  2.218845e-02},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -5.752460e-01, -4.727758e-01,  1.578656e-01},
  {-5.431953e-01,  8.386438e-01, -4.019150e-02, -5.313342e-01, -2.966361e-01,  3.065303e-02},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -1.992843e-01, -8.192365e-01,  1.958293e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -1.254678e-01, -7.167090e-01,  9.788399e-02},
  { 1.252493e-01, -6.067349e-01, -7.849748e-01,  6.649705e-02,  8.395845e-01, -3.049878e-01},
  {-7.627757e-01,  1.330186e-01,  6.328343e-01,  3.051635e-01, -2.392392e-01, -2.828287e-01},
  { 9.054802e-01,  2.740449e-01,  3.240447e-01,  3.051635e-01, -2.392392e-01, -2.828287e-01},
  {-1.155784e-01,  7.243151e-01,  6.797127e-01,  3.711899e-01, -2.697046e-01, -2.391369e-01},
  {-4.007014e-01,  6.390063e-01, -6.565892e-01,  1.242376e-01, -5.337930e-01, -5.762616e-01},
  { 5.120243e-01,  7.102765e-01, -4.830512e-01,  1.959917e-01,  1.050385e+00,  4.034915e-01},
  { 6.317066e-01,  1.530288e-01,  7.599533e-01, -3.265750e-01, -5.820397e-01,  4.122753e-01},
  { 4.475406e-01,  2.986774e-01, -8.429111e-01, -1.369609e-01, -1.003661e+00, -6.524836e-01},
  { 9.591486e-01,  1.932166e-01,  2.066431e-01, -1.369609e-01, -1.003661e+00, -6.524836e-01},
  { 7.135687e-01, -3.743480e-01,  5.921851e-01, -1.398557e-01, -1.021750e+00, -6.604301e-01},
  {-5.467591e-02, -8.725634e-01, -4.854314e-01, -5.983134e-02, -3.251368e-01, -6.154165e-01},
  { 3.704419e-01, -2.221025e-01, -9.019109e-01, -6.683902e-02, -2.801629e-01, -6.954677e-01},
  {-8.952912e-01, -1.041221e-01,  4.331424e-01,  5.108875e-01,  1.922383e-01, -3.726059e-01},
  {-8.952912e-01, -1.041221e-01,  4.331424e-01,  5.039051e-01,  2.039286e-01, -3.842282e-01},
  {-6.447017e-01,  2.844374e-01, -7.095458e-01, -5.393305e-01, -6.119698e-01, -2.389340e-01},
  { 5.953583e-01, -6.746399e-01,  4.363595e-01,  3.069710e-01, -2.533377e-01, -1.098515e-01},
  {-3.214820e-01, -9.190524e-01,  2.280177e-01,  2.742837e-01, -2.602872e-01, -1.797524e-01},
  { 2.240736e-01,  6.973129e-01,  6.808419e-01,  2.298772e-01, -7.875910e-01, -4.668553e-01},
  {-5.999307e-01, -5.649045e-01,  5.665386e-01,  4.250173e-02,  6.210790e-01,  4.662113e-01},
  {-5.545881e-02,  2.869064e-01, -9.563520e-01,  2.494556e-01,  2.041579e-01, -3.953929e-01},
  { 7.026852e-01, -5.229120e-01,  4.824902e-01, -3.705328e-01, -4.436761e-01,  2.103792e-01},
  {-8.127414e-01, -5.825362e-01, -1.015090e-02, -3.705328e-01, -4.436761e-01,  2.103792e-01},
  { 5.262806e-01,  7.902300e-01,  3.139514e-01, -4.280159e-01, -3.627394e-01,  1.680510e-01},
  { 3.028964e-01, -8.811473e-01,  3.630883e-01, -3.349699e-01, -4.334653e-01,  1.696527e-01},
  { 6.781547e-01,  3.500054e-01,  6.462217e-01, -4.008164e-01, -4.029625e-01,  2.986079e-01},
  {-5.054927e-01, -8.340260e-01,  2.210831e-01, -4.008164e-01, -4.029625e-01,  2.986079e-01},
  {-1.884943e-01, -9.729058e-01,  1.338812e-01, -2.621923e-01, -4.465873e-01,  1.767617e-01},
  {-7.647702e-01, -6.412669e-01, -6.247632e-02,  3.748571e-01, -3.031214e-02,  7.812521e-01},
  {-6.879148e-01, -6.821640e-01,  2.478420e-01,  3.748571e-01, -3.031214e-02,  7.812521e-01},
  { 8.856711e-01, -4.556184e-01, -8.943479e-02,  3.484974e-01, -5.425494e-02,  6.421872e-01},
  {-9.776043e-01, -1.233960e-01, -1.704797e-01,  3.232984e-01,  1.905391e-01,  4.522834e-01},
  { 1.479020e-01, -9.730902e-01,  1.766935e-01,  3.232984e-01,  1.905391e-01,  4.522834e-01},
  { 8.125729e-01,  2.315740e-01, -5.348819e-01,  3.583361e-01,  2.077106e-01,  5.107918e-01},
  { 6.809872e-01,  7.321621e-01, -1.396963e-02,  3.421693e-01,  2.233753e-01,  5.437018e-01},
  { 7.386008e-01,  4.330963e-01,  5.166204e-01,  3.573995e-01,  2.104504e-01,  6.087307e-01},
  { 3.845569e-01,  8.824277e-01,  2.709934e-01,  3.573995e-01,  2.104504e-01,  6.087307e-01},
  {-7.075653e-01, -5.419545e-01,  4.534719e-01,  4.203783e-01, -9.001931e-01, -4.037451e-01},
  { 5.471411e-01,  5.886371e-01,  5.950992e-01,  4.203783e-01, -9.001931e-01, -4.037451e-01},
  {-6.431171e-01, -7.480115e-01, -1.639488e-01,  2.902383e-01, -1.246809e-01,  3.769660e-01},
  {-1.397062e-01, -9.821791e-01, -1.257236e-01,  2.902383e-01, -1.246809e-01,  3.769660e-01},
  { 2.225762e-01, -5.193715e-01, -8.250534e-01,  2.949570e-01, -2.302021e-01, -9.029441e-02},
  { 2.225762e-01, -5.193715e-01, -8.250534e-01,  3.421642e-01, -2.231953e-01, -8.197000e-02},
  { 6.329175e-01, -5.667506e-01,  5.274553e-01,  3.191962e-01, -2.441615e-01, -1.299669e-01},
  {-6.449547e-01,  7.627077e-01, -4.806520e-02, -1.821376e-01, -6.002050e-01, -1.647214e-01},
  {-5.562208e-01, -6.581199e-01,  5.074412e-01, -1.377825e-02,  2.598962e-01, -8.241856e-01},
  {-6.065974e-01,  3.017620e-01, -7.355130e-01, -1.377825e-02,  2.598962e-01, -8.241856e-01},
  { 5.626338e-01,  8.235508e-01, -7.216196e-02, -3.865052e-02,  9.586822e-01, -1.409653e-02},
  {-2.708230e-01,  3.966830e-01,  8.770961e-01, -3.865052e-02,  9.586822e-01, -1.409653e-02},
  { 3.179554e-01,  9.229093e-01, -2.171245e-01,  1.117384e-01,  3.341206e-01, -4.779226e-01},
  {-2.637978e-01,  3.697571e-01, -8.908930e-01, -1.671741e-02,  1.096375e+00,  5.021036e-02},
  { 1.970749e-01,  3.596992e-01, -9.120186e-01, -3.503249e-02,  1.121044e+00,  5.598221e-02},
  { 1.970749e-01,  3.596992e-01, -9.120186e-01,  5.002145e-01,  4.719816e-01, -4.294005e-01},
  { 1.970749e-01,  3.596992e-01, -9.120186e-01,  4.366793e-01,  4.165404e-01, -4.214642e-01},
  {-5.708259e-01, -8.192839e-01,  5.414486e-02,  4.574576e-01,  5.004525e-01, -4.493662e-01},
  {-3.300922e-01, -8.216248e-01, -4.647278e-01,  4.773776e-01,  4.949605e-01, -4.538057e-01},
  { 3.143074e-01,  1.602258e-01, -9.357022e-01,  1.425734e-01, -1.174068e+00, -4.574578e-01},
  {-9.693846e-01, -2.280352e-01,  9.106883e-02, -1.460929e-01,  4.445623e-01,  2.968077e-01},
  { 1.187045e-01, -9.177208e-01,  3.790749e-01, -1.474420e-01,  4.675028e-01,  3.527679e-01},
  {-5.345155e-01,  6.927542e-01, -4.841330e-01, -1.474420e-01,  4.675028e-01,  3.527679e-01},
  { 4.829810e-01,  8.395764e-01,  2.486785e-01, -3.258034e-01, -1.824695e-01,  6.021864e-01},
  {-8.608634e-01,  1.244252e-01,  4.933890e-01,  3.710250e-01,  1.030761e-01,  6.595826e-01},
  { 5.125223e-01,  2.507412e-01, -8.212489e-01,  2.117135e-01, -6.650108e-01, -5.194720e-01},
  { 9.586018e-02,  5.282525e-01,  8.436588e-01, -1.728726e-01, -6.318306e-01,  6.179241e-02},
  {-4.844014e-02, -4.324975e-01, -9.003330e-01,  2.117135e-01, -6.650108e-01, -5.194720e-01},
  { 9.401319e-01, -2.065498e-01,  2.710888e-01,  4.462335e-01,  6.856661e-02,  4.374387e-02},
  { 8.867463e-01, -2.192763e-01, -4.069384e-01, -7.902458e-02, -1.694572e-01, -4.594940e-01},
  {-1.282580e-02,  7.848650e-01,  6.195341e-01, -2.443686e-01, -3.375747e-01, -2.825344e-01},
  {-9.172781e-01, -7.414946e-02, -3.912835e-01,  2.041443e-02, -1.952407e-01, -5.008930e-02},
  {-8.224815e-01, -5.098189e-01, -2.522080e-01, -7.881925e-02,  2.050832e-01,  6.174588e-01},
  {-9.592171e-01,  2.752041e-01,  6.453922e-02,  1.013961e-01,  8.838930e-01,  1.507051e-01},
  { 9.340338e-01,  1.124960e-01, -3.390068e-01,  5.851799e-01,  1.233696e+00,  7.003075e-03},
  { 4.823643e-01, -6.577005e-01, -5.785798e-01,  2.606331e-01, -9.677100e-01, -6.441971e-01},
  {-8.523075e-01, -2.281570e-01, -4.706552e-01,  3.537906e-01,  1.236721e-01, -5.453766e-01},
  {-2.436191e-01,  9.451352e-01, -2.176447e-01,  3.537906e-01,  1.236721e-01, -5.453766e-01},
  {-9.951199e-01,  9.504324e-02,  2.651543e-02, -1.447914e-01,  5.502601e-01, -3.956243e-01},
  { 2.419639e-01,  9.702210e-01,  1.116809e-02,  9.510934e-02, -1.191004e+00, -5.583805e-01},
  {-3.837441e-01, -5.179011e-01,  7.645383e-01,  2.561808e-01, -2.840188e-01, -8.561508e-02},
  {-7.310939e-01,  1.063090e-01, -6.739436e-01, -2.484256e-02, -7.419323e-01, -5.879028e-01},
  { 2.666954e-01,  9.370937e-01, -2.252311e-01, -2.483929e-01,  4.777925e-01,  5.213275e-01},
  { 8.259121e-01,  4.899561e-01,  2.789485e-01,  2.694730e-01, -5.214505e-01,  2.732272e-01},
  { 9.881592e-01, -7.211600e-03, -1.532627e-01,  3.944764e-01,  1.297705e+00, -1.578221e-01},
  { 6.244932e-01,  5.990165e-01,  5.011861e-01,  3.784188e-01,  1.304551e+00, -1.417442e-01},
  {-5.183995e-01,  5.261320e-01, -6.741269e-01, -2.495943e-01, -4.857253e-02, -6.231815e-01},
  {-1.121112e-01, -7.962720e-01, -5.944595e-01,  1.195604e-01,  3.374462e-01,  4.942684e-01},
  { 9.249245e-02, -6.743177e-01,  7.326260e-01,  1.195604e-01,  3.374462e-01,  4.942684e-01},
  {-4.011787e-01,  7.864195e-01,  4.696808e-01,  1.005233e-01,  3.106729e-01,  4.883556e-01},
  {-1.121112e-01, -7.962720e-01, -5.944595e-01,  1.497588e-01,  3.285138e-01,  5.005380e-01},
  {-9.731863e-01, -1.992473e-01, -1.149306e-01,  9.588346e-02,  5.232156e-02,  4.441267e-01},
  {-2.141251e-01,  9.314536e-01, -2.941846e-01, -1.855130e-02,  4.443174e-02,  5.969521e-01},
  {-4.301341e-01, -6.398010e-01,  6.368982e-01, -1.855130e-02,  4.443174e-02,  5.969521e-01},
  {-9.166463e-01,  8.202457e-02,  3.911924e-01,  1.101294e-01,  3.027241e-01,  5.125315e-01},
  { 9.565284e-01, -5.408175e-02, -2.865808e-01, -2.458415e-01,  4.805840e-01, -2.859398e-01},
  { 8.565592e-01,  2.998157e-01,  4.200203e-01,  3.309063e-01,  1.764769e-01,  4.188348e-01},
  {-1.121112e-01, -7.962720e-01, -5.944595e-01,  1.570665e-01,  3.121354e-01,  5.210984e-01},
  {-3.753869e-01,  3.389668e-01, -8.626623e-01, -2.894623e-02,  3.219190e-01,  4.853601e-01},
  {-6.137813e-01, -7.010917e-01,  3.629641e-01, -2.894623e-02,  3.219190e-01,  4.853601e-01},
  { 4.036135e-01, -5.104051e-01,  7.593305e-01, -3.539160e-02,  3.402390e-01,  4.606262e-01},
  {-5.853124e-01,  3.433721e-01, -7.345101e-01, -3.539160e-02,  3.402390e-01,  4.606262e-01},
  { 2.161417e-01,  8.106784e-01,  5.441353e-01, -3.539160e-02,  3.402390e-01,  4.606262e-01},
  { 2.161417e-01,  8.106784e-01,  5.441353e-01, -1.356421e-01,  3.197696e-01,  5.309441e-01},
  {-3.870834e-01,  6.914485e-02,  9.194485e-01, -2.399848e-01, -8.981073e-01,  3.102740e-01},
  {-6.955974e-01, -3.585513e-01,  6.225635e-01, -4.502591e-01, -6.527304e-01, -4.237190e-01},
  {-6.955974e-01, -3.585513e-01,  6.225635e-01, -2.778793e-01, -2.360199e-01, -2.514684e-01},
  {-6.955974e-01, -3.585513e-01,  6.225635e-01, -3.686584e-01, -2.315927e-01, -2.103258e-01},
  { 8.172835e-01,  5.736211e-01,  5.483232e-02,  4.815134e-01,  6.449857e-02, -4.426244e-01},
  { 6.310956e-02, -4.673150e-01, -8.818355e-01,  4.815134e-01,  6.449857e-02, -4.426244e-01},
  { 9.014653e-01,  4.126054e-01, -1.308322e-01,  5.261364e-01,  2.324336e-02, -5.855693e-01},
  { 6.859417e-01, -6.526026e-01,  3.218600e-01,  4.815134e-01,  6.449857e-02, -4.426244e-01},
  { 6.360895e-01, -7.679070e-01, -7.555784e-02,  4.483185e-01, -9.965955e-02, -5.967145e-01},
  {-7.489125e-01, -3.256894e-01,  5.771104e-01,  3.750407e-01,  1.264231e+00,  1.652724e-01},
  { 1.104296e-01,  5.399512e-01,  8.344208e-01,  5.157143e-01, -1.435514e-01, -3.197996e-01},
  { 6.299610e-01, -4.302909e-01, -6.465284e-01,  5.157143e-01, -1.435514e-01, -3.197996e-01},
  { 6.299610e-01, -4.302909e-01, -6.465284e-01,  5.147253e-01, -2.028980e-01, -2.812657e-01},
  { 6.299610e-01, -4.302909e-01, -6.465284e-01,  4.790429e-01, -2.249662e-01, -3.013464e-01},
  {-7.401022e-02, -6.314338e-01,  7.718897e-01,  5.486422e-01,  1.098504e+00, -4.647284e-03},
  {-2.715845e-01,  4.105398e-02,  9.615386e-01, -6.224070e-02, -3.992938e-01, -3.787200e-01},
  {-8.944272e-01,  0.000000e+00, -4.472136e-01, -3.070202e-02, -5.516541e-01, -3.433885e-01},
  {-2.529981e-01,  9.551027e-02,  9.627408e-01, -5.432592e-02, -4.929146e-01, -3.705183e-01},
  {-8.944272e-01,  0.000000e+00, -4.472136e-01, -3.528228e-02, -5.452074e-01, -3.032823e-01},
  { 1.772066e-01,  9.023838e-01, -3.928119e-01,  2.589513e-01, -1.276229e+00, -5.764639e-01},
  {-6.181495e-01, -5.152491e-01, -5.936410e-01,  6.154438e-02, -1.120646e+00, -2.780673e-01},
  {-9.124736e-01,  4.293972e-02,  4.068760e-01,  8.260734e-02, -1.098857e+00, -3.189117e-01},
  {-2.071173e-01, -2.686579e-01, -9.407047e-01,  8.260734e-02, -1.098857e+00, -3.189117e-01},
  {-4.991850e-01, -6.041566e-01,  6.211353e-01,  1.239918e-01, -1.157209e+00, -3.113587e-01},
  { 8.407927e-01,  4.821962e-01, -2.460780e-01,  4.608674e-01,  3.776100e-01, -1.501742e-01},
  { 8.135007e-01, -4.031037e-01,  4.191945e-01,  4.532026e-01,  3.244287e-01, -1.864398e-01},
  { 2.956114e-01,  9.256271e-01,  2.362801e-01,  4.895131e-01,  3.542309e-01, -2.304677e-01},
  {-4.979810e-01,  8.325594e-01,  2.426101e-01,  7.647234e-03, -5.170131e-01,  1.602431e-01},
  {-8.941343e-01,  4.201315e-01, -1.549626e-01, -2.002005e-01, -5.841637e-01, -4.883432e-01},
  { 5.855541e-02,  9.706354e-01, -2.333198e-01, -2.002005e-01, -5.841637e-01, -4.883432e-01},
  {-7.607502e-01,  6.022985e-01, -2.418586e-01, -1.825277e-01, -5.799614e-01, -4.946317e-01},
  { 6.747155e-01, -2.865173e-01,  6.801963e-01,  4.066433e-01, -8.556127e-01,  6.716739e-02},
  {-1.431349e-01, -3.946429e-01,  9.076174e-01,  3.793613e-01, -8.765393e-01,  1.381219e-01},
  {-7.498329e-01,  1.510293e-01,  6.441590e-01,  4.521167e-01, -9.641564e-01, -9.979440e-02},
  { 7.228396e-01,  4.373597e-01,  5.349948e-01,  4.521167e-01, -9.641564e-01, -9.979440e-02},
  {-7.498329e-01,  1.510293e-01,  6.441590e-01,  4.411444e-01, -9.990838e-01, -1.043777e-01},
  { 7.498329e-01, -1.510293e-01, -6.441590e-01,  4.411444e-01, -9.990838e-01, -1.043777e-01},
  { 3.551765e-01, -7.265444e-01, -5.882031e-01, -1.871183e-01, -8.812859e-01, -7.414988e-01},
  { 5.082229e-01,  8.379772e-01, -1.987554e-01, -1.871183e-01, -8.812859e-01, -7.414988e-01},
  {-2.288277e-01,  7.975303e-01, -5.581965e-01, -2.205296e-01, -9.025204e-01, -7.548356e-01},
  {-2.288277e-01,  7.975303e-01, -5.581965e-01, -2.549276e-01, -9.083318e-01, -7.490374e-01},
  {-3.332060e-01, -7.791253e-01, -5.309780e-01,  4.755851e-01,  6.760399e-01, -4.226282e-01},
  {-7.283683e-01,  1.248445e-01,  6.737162e-01,  1.862852e-01,  1.277498e-01,  5.492860e-01},
  {-8.405764e-01, -3.211945e-01,  4.361942e-01,  3.160518e-01, -2.899978e-01, -2.948803e-01},
  {-8.766774e-01,  3.560399e-01,  3.235311e-01, -4.551728e-01, -5.688309e-01, -5.364994e-01},
  { 6.769946e-01, -5.996906e-01,  4.266725e-01,  3.613628e-01, -5.057603e-01, -6.715044e-02},
  {-7.554658e-01, -6.107033e-01,  2.373035e-01, -1.456701e-01,  4.899377e-01,  4.149278e-01},
  {-9.546407e-01, -5.142865e-03,  2.977158e-01, -5.159094e-01, -4.652198e-01, -4.105994e-01},
  { 2.928503e-01, -9.558879e-01, -2.274240e-02, -5.159094e-01, -4.652198e-01, -4.105994e-01},
  {-7.353386e-01,  6.490052e-01,  1.951141e-01,  1.013618e-01, -4.618540e-01, -1.363807e-01},
  {-9.881620e-01,  1.533494e-01, -4.447725e-03,  1.990430e-01, -3.305782e-01, -1.565818e-01},
  {-3.289834e-01,  8.591023e-01,  3.920628e-01,  1.439297e-01, -3.430518e-01, -2.107819e-01},
  {-5.791047e-01,  7.896049e-01,  2.028838e-01,  1.580776e-01, -3.459673e-01, -2.021542e-01},
  {-7.896520e-01,  2.602714e-02,  6.130027e-01,  8.301276e-02, -3.438508e-01, -2.601469e-01},
  { 1.677435e-01,  2.886094e-01,  9.426382e-01, -9.283156e-03, -5.000684e-01,  1.317412e-01},
  { 5.313028e-01, -9.242345e-02,  8.421254e-01, -4.823680e-02, -4.549854e-01,  1.293065e-01},
  {-7.574656e-01, -3.826251e-01,  5.290027e-01,  1.463475e-01, -1.180973e+00, -2.039380e-01},
  {-2.890714e-01,  7.165530e-02,  9.546220e-01, -6.012231e-02,  9.872854e-01, -1.907565e-02},
  { 9.015689e-01,  2.841703e-01, -3.262217e-01,  3.228713e-01, -4.828720e-01,  7.319188e-01},
  {-1.646579e-01, -9.620555e-01,  2.175707e-01,  3.228713e-01, -4.828720e-01,  7.319188e-01},
  { 3.240652e-01,  9.371145e-01,  1.296083e-01,  2.842064e-01, -4.986536e-01,  6.406643e-01},
  {-2.577142e-01,  1.467948e-01,  9.550050e-01, -3.228791e-01, -8.560365e-01, -4.479868e-01},
  {-2.247335e-01,  5.424057e-01,  8.095005e-01, -1.489038e-01, -4.028747e-01,  5.196083e-01},
  {-7.896563e-01, -7.726005e-02,  6.086655e-01, -3.687897e-01, -1.433316e-01, -6.842991e-01},
  {-4.012715e-01, -2.316213e-01,  8.861901e-01, -3.159873e-01, -1.673632e-01, -6.706289e-01},
  { 5.989683e-01,  1.941682e-01,  7.768756e-01, -1.104207e-01, -1.075522e+00,  1.720768e-01},
  { 1.033974e-01, -4.303035e-01,  8.967429e-01,  4.453505e-02, -4.672993e-01,  7.478225e-01},
  { 4.000201e-01, -8.250040e-01, -3.991896e-01,  7.877953e-03, -4.765080e-01,  7.301207e-01},
  {-3.010688e-01, -2.778435e-01, -9.122283e-01, -4.407001e-01, -9.113465e-01, -4.340358e-01},
  { 7.519341e-01, -6.238834e-01, -2.129900e-01,  3.509159e-01,  2.250896e-02,  3.834051e-01},
  { 4.224102e-01,  4.715596e-01, -7.740808e-01, -5.364057e-01, -2.698690e-01,  3.624803e-02},
  { 1.528768e-01, -8.670538e-01, -4.741797e-01,  5.157143e-01, -1.435514e-01, -3.197996e-01},
  { 5.204402e-01, -6.307101e-01,  5.756273e-01,  5.157143e-01, -1.435514e-01, -3.197996e-01},
  { 2.990664e-01,  9.248024e-01,  2.351593e-01,  2.633061e-01, -1.278499e+00, -5.321460e-01},
  { 2.990664e-01,  9.248024e-01,  2.351593e-01,  2.217757e-01, -1.269859e+00, -5.133043e-01},
  { 9.702178e-01,  1.568702e-01,  1.845785e-01,  2.633061e-01, -1.278499e+00, -5.321460e-01},
  { 8.485079e-01, -1.208898e-01, -5.151893e-01, -5.062889e-02, -3.051649e-01, -3.766731e-01},
  { 5.005493e-01,  4.202106e-01, -7.568840e-01,  1.852467e-01, -3.474953e-01, -1.819159e-01},
  { 7.510200e-01, -1.688596e-01,  6.383224e-01, -5.018274e-02,  7.830231e-01, -3.135716e-01},
  {-7.544724e-01,  6.122711e-01, -2.364224e-01,  2.234762e-02,  7.561963e-01, -1.949420e-01},
  { 6.996478e-01, -2.036965e-01, -6.848363e-01, -3.660539e-03,  7.208992e-01, -2.239561e-01},
  { 3.365554e-01, -4.869132e-01, -8.060063e-01, -1.003149e-01,  6.615723e-01, -2.414386e-01},
  { 2.999865e-01, -9.526640e-01,  4.939089e-02, -1.471269e-01, -4.879271e-01,  1.675752e-01},
  {-7.221088e-01, -6.777663e-01, -1.385335e-01, -5.255628e-01, -6.534656e-01, -2.730475e-01},
  {-8.258287e-01, -4.159942e-01,  3.807306e-01, -4.407001e-01, -9.113465e-01, -4.340358e-01},
  {-7.399356e-01, -6.554231e-01, -1.513803e-01, -4.221848e-01, -9.204739e-01, -5.040051e-01},
  { 2.963964e-01, -9.278728e-01, -2.262769e-01, -1.418010e-01, -9.996885e-01, -7.498550e-01},
  { 2.551848e-01,  2.307524e-01, -9.389537e-01, -1.519274e-01, -9.963132e-01, -7.769601e-01},
  {-9.233885e-01, -7.997552e-02,  3.754431e-01, -2.956558e-01, -1.132444e-01,  1.998455e-01},
  { 1.582635e-01, -7.409030e-01,  6.526986e-01, -2.983370e-01, -1.264860e-01,  1.638131e-01},
  { 6.975093e-01, -6.878448e-01,  2.008738e-01, -2.931601e-01, -1.145879e-01,  1.865791e-01},
  {-1.118335e-01,  3.637360e-01, -9.247645e-01,  2.448585e-01,  2.348465e-01, -3.859197e-01},
  { 2.555432e-01,  7.014109e-01, -6.653723e-01,  3.664535e-01,  3.678374e-01, -3.431667e-01},
  {-6.708723e-01,  7.085989e-01, -2.186732e-01,  3.942071e-01, -1.943248e-01, -7.491224e-02},
  { 2.003582e-01, -8.705875e-01, -4.493708e-01,  3.212050e-01, -2.237063e-01, -5.053912e-02},
  {-9.570034e-01, -1.532147e-01,  2.463121e-01, -1.740139e-01, -5.478085e-01, -5.218571e-01},
  {-7.945847e-01,  3.203052e-01,  5.157905e-01, -2.692479e-01, -4.572832e-01, -7.055846e-01},
  { 5.581456e-02,  8.930329e-01, -4.465165e-01,  1.653436e-02,  5.711573e-01, -7.306300e-01},
  { 8.953000e-02,  7.775732e-01,  6.223860e-01,  7.055546e-02,  1.118157e+00, -1.330763e-02},
  { 7.926918e-01,  6.083487e-01, -3.939140e-02,  7.055546e-02,  1.118157e+00, -1.330763e-02},
  {-9.354454e-01,  2.247263e-01,  2.728367e-01,  7.055546e-02,  1.118157e+00, -1.330763e-02},
  { 9.535297e-02,  2.148263e-01,  9.719864e-01,  1.129632e-01,  1.098999e+00, -1.822402e-02},
  {-6.486967e-02, -1.937485e-01, -9.789042e-01, -8.350945e-02,  2.616093e-01, -7.533341e-01},
  { 3.277577e-01, -7.465708e-01,  5.789706e-01, -1.492213e-01, -9.070932e-01, -6.310339e-01},
  { 9.318153e-01,  3.613861e-01, -3.347042e-02,  3.560090e-01,  5.808482e-01, -1.469627e-01},
  {-8.065326e-01, -5.654019e-01,  1.727021e-01,  3.498571e-01,  5.809668e-01, -1.382090e-01},
  { 9.189443e-01,  3.418592e-01,  1.966561e-01,  3.926982e-01, -1.162293e+00, -3.212493e-01},
  {-6.523433e-01,  8.012264e-03, -7.578812e-01, -4.584267e-01, -8.317068e-01, -4.407416e-01},
  {-4.584517e-01,  8.867444e-01,  5.921588e-02,  4.640109e-02,  8.026435e-01, -1.514156e-01},
  { 6.715908e-01, -7.401714e-01,  3.334958e-02, -2.709985e-01, -1.816910e-01, -6.682554e-01},
  {-6.250755e-01, -1.069587e-01,  7.732015e-01, -2.951013e-01, -2.239717e-01, -6.935894e-01},
  { 4.232242e-01,  4.394138e-01, -7.923363e-01,  1.758485e-01, -7.032916e-01, -8.395340e-02},
  { 2.380027e-01,  5.362428e-01, -8.098137e-01,  2.083913e-01, -7.427842e-01, -8.847255e-02},
  { 4.928800e-02,  5.265778e-01,  8.486970e-01, -1.084567e-01,  7.273889e-01,  3.499208e-01},
  { 6.388674e-01, -6.644038e-01, -3.878353e-01,  2.842064e-01, -4.986536e-01,  6.406643e-01},
  { 5.584978e-01, -3.980074e-01, -7.277845e-01,  2.749704e-01, -4.648218e-01,  5.674926e-01},
  { 4.830333e-01, -4.756154e-01, -7.351658e-01,  2.669947e-01, -4.336767e-01,  5.690118e-01},
  { 3.149247e-01,  1.105322e-01,  9.426585e-01, -6.397735e-02, -1.128429e+00,  8.001950e-02},
  { 6.035248e-01, -1.152164e-01,  7.889758e-01,  4.526552e-01,  3.324864e-01,  2.521344e-01},
  { 5.624743e-01, -1.772195e-01,  8.075988e-01,  4.649059e-01,  3.305281e-01,  2.413076e-01},
  {-8.406674e-01, -5.190251e-01,  1.545680e-01, -3.719033e-01,  5.603606e-02, -5.252948e-01},
  { 3.386445e-01, -8.791724e-01, -3.352250e-01, -3.719033e-01,  5.603606e-02, -5.252948e-01},
  {-1.420208e-01,  5.439496e-01, -8.270120e-01,  6.059936e-02, -3.733806e-01, -3.156942e-01},
  {-5.230376e-01,  3.419064e-02,  8.516236e-01,  6.059936e-02, -3.733806e-01, -3.156942e-01},
  {-1.429333e-01,  9.790199e-01, -1.452246e-01,  3.970943e-01, -5.341197e-01, -1.225369e-01},
  {-1.020761e-01,  9.180874e-01,  3.830090e-01,  3.988830e-01, -5.284969e-01, -1.355381e-01},
  {-4.425289e-01,  1.260431e-01,  8.878521e-01, -2.886539e-01, -8.175293e-01, -4.314661e-01},
  { 3.336697e-01, -5.697222e-01, -7.510535e-01,  4.947603e-01,  2.883242e-01, -4.554753e-01},
  { 3.336697e-01, -5.697222e-01, -7.510535e-01,  5.030776e-01,  2.588857e-01, -4.294491e-01},
  { 3.336697e-01, -5.697222e-01, -7.510535e-01, -3.205617e-01,  2.530206e-01,  1.299896e-01},
  { 3.336697e-01, -5.697222e-01, -7.510535e-01, -3.693545e-01,  3.081999e-01,  1.358055e-01},
  {-4.106529e-01, -1.955607e-01, -8.905730e-01, -2.259290e-01, -8.934249e-01, -1.294552e-01},
  {-8.359597e-01, -4.522652e-01, -3.108497e-01, -6.694023e-02,  7.116119e-01,  3.604423e-01},
  { 5.693954e-01,  3.622704e-01,  7.379358e-01,  2.082622e-01, -3.281026e-01, -2.611101e-01},
  { 1.801012e-02,  5.479098e-01, -8.363436e-01, -4.773539e-01, -7.059269e-01, -5.088999e-01},
  {-5.462380e-01, -5.276797e-01,  6.505216e-01, -4.773539e-01, -7.059269e-01, -5.088999e-01},
  {-2.773422e-01,  9.239905e-01, -2.632920e-01, -4.102846e-01, -6.079087e-01, -4.432414e-01},
  { 9.462652e-01,  3.038998e-01, -1.105758e-01,  5.247103e-01,  8.850320e-01,  1.209074e-01},
  {-3.049773e-01,  9.422931e-01,  1.381034e-01, -3.280965e-01, -5.570707e-01,  1.429705e-01},
  { 3.749844e-01, -8.635393e-01, -3.371745e-01,  4.195363e-01, -3.694400e-01, -4.650910e-01},
  { 3.531159e-02, -9.920979e-01, -1.203948e-01,  2.444825e-01, -7.670867e-01, -3.583080e-01},
  {-5.783423e-01,  2.135386e-02,  8.155148e-01,  2.691738e-01,  1.146725e+00, -9.988569e-02},
  {-5.815906e-01, -7.451282e-01, -3.263992e-01, -1.583085e-01, -1.036258e+00,  1.626884e-01},
  { 4.619084e-01, -1.972399e-01,  8.647178e-01, -1.689392e-01, -1.025433e+00,  1.708362e-01},
  { 3.532209e-01, -3.159169e-01,  8.805859e-01, -2.160358e-01, -1.006085e+00,  1.966687e-01},
  {-5.249290e-01, -5.037639e-01, -6.860551e-01, -5.402737e-01, -4.922094e-01,  1.545625e-01},
  {-8.215538e-01, -5.254728e-01,  2.211962e-01, -5.539203e-01, -5.331303e-01,  1.950520e-01},
  {-3.850810e-01, -6.941198e-01, -6.082026e-01, -5.694841e-01, -5.016834e-01,  1.838692e-01},
  { 3.762899e-01, -9.113540e-01,  1.668527e-01, -5.088874e-01, -5.048894e-01,  2.477456e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -4.789949e-01, -3.785321e-01, -3.997501e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00, -4.899677e-01, -4.287857e-01, -4.137154e-01},
  { 5.733337e-01, -7.406203e-01,  3.503857e-01,  1.002391e-01, -1.256279e+00, -7.099020e-01},
  { 8.197421e-01, -3.979343e-01,  4.119116e-01,  1.168261e-01, -1.246336e+00, -7.160262e-01},
  { 9.374789e-01, -3.480000e-01,  5.417059e-03,  2.650931e-01,  1.253152e+00,  2.173706e-01},
  { 9.374789e-01, -3.480000e-01,  5.417059e-03,  1.209699e-01,  9.480249e-01,  3.621801e-01},
  {-7.075653e-01, -5.419545e-01,  4.534719e-01,  3.997289e-01, -8.409201e-01, -3.651265e-01},
  {-6.480089e-01, -2.799949e-01,  7.082989e-01,  8.557462e-03, -7.728520e-01,  3.286284e-02},
  { 3.990389e-01, -9.129785e-01, -8.507762e-02,  8.557462e-03, -7.728520e-01,  3.286284e-02},
  { 9.113143e-02, -1.791730e-01, -9.795877e-01, -3.404717e-01,  2.188107e-01,  2.316461e-01},
  { 9.704609e-02,  2.632344e-01, -9.598384e-01,  4.153463e-01,  8.887135e-03,  2.372110e-01},
  {-2.413635e-01,  1.311330e-01, -9.615341e-01, -2.262632e-01,  2.029433e-01,  2.451732e-01},
  { 6.727008e-01,  4.509254e-01, -5.866345e-01,  3.040179e-01, -2.942777e-01, -3.173083e-01},
  { 1.982874e-01,  6.842074e-01, -7.018136e-01,  1.717095e-01, -2.994561e-01, -3.597386e-01},
  { 9.370308e-01, -9.365259e-02, -3.364556e-01,  5.071716e-01, -5.291427e-03, -2.969342e-01},
  { 9.921181e-01,  8.786420e-02, -8.933953e-02,  5.348470e-01,  8.638343e-02, -2.283799e-01},
  {-8.970872e-01,  4.401698e-01,  3.853610e-02, -1.586760e-01,  3.967196e-02,  2.072426e-01},
  { 1.045526e-01,  1.468353e-01,  9.836199e-01, -1.586760e-01,  3.967196e-02,  2.072426e-01},
  {-5.858062e-01, -7.763151e-01, -2.327358e-01, -1.389916e-01,  3.350072e-03,  2.105724e-01},
  {-7.824751e-02,  3.308815e-01,  9.404227e-01, -1.038070e-01, -1.598515e-02,  2.577796e-01},
  {-7.824751e-02,  3.308815e-01,  9.404227e-01, -3.611143e-01, -6.121729e-01, -6.724672e-01},
  {-8.585849e-01,  1.780916e-01, -4.807447e-01, -3.737853e-01, -5.128013e-01, -6.578918e-01},
  { 5.808972e-01,  1.901584e-01, -7.914533e-01, -3.737853e-01, -5.128013e-01, -6.578918e-01},
  {-3.898785e-01,  9.034099e-01, -1.784526e-01,  3.776500e-01,  3.447016e-01,  5.213003e-01},
  {-2.672020e-02, -7.332080e-01,  6.794792e-01,  1.186283e-01,  6.890221e-01, -8.414272e-02},
  { 1.610736e-01, -8.957613e-01, -4.143273e-01,  3.661723e-01, -4.880119e-01, -2.381454e-01},
  { 7.969769e-01, -6.031398e-01, -3.240679e-02,  5.300128e-01, -1.415650e-01, -1.020006e-02},
  { 3.341852e-01,  8.392857e-01, -4.288585e-01,  4.953537e-02,  9.256102e-01, -5.598540e-02},
  { 5.673529e-01,  7.392586e-01, -3.627775e-01,  4.953537e-02,  9.256102e-01, -5.598540e-02},
  {-6.148430e-01, -5.080121e-01,  6.032345e-01,  8.179286e-02,  9.349620e-01,  1.351926e-02},
  { 7.872713e-01, -2.235500e-01,  5.746559e-01,  2.965944e-01,  1.918256e-01,  1.823315e-01},
  {-3.303271e-01,  3.292365e-01, -8.845832e-01,  2.693878e-01,  7.121836e-02,  1.839235e-01},
  { 9.780437e-01, -1.926630e-01,  7.944580e-02,  2.818579e-01,  1.238269e-01,  1.988474e-01},
  {-9.884583e-01,  1.503858e-01,  1.828801e-02, -2.956558e-01, -1.132444e-01,  1.998455e-01},
  { 2.550148e-01,  7.551295e-01,  6.039428e-01,  5.012639e-01,  1.356157e+00, -1.443342e-01},
  { 9.682482e-01,  2.496673e-01, -1.271081e-02,  4.689891e-01,  1.330080e+00, -9.276380e-02},
  { 7.597011e-01,  6.499194e-01, -2.142322e-02, -3.020466e-01, -1.826094e-01, -6.856962e-01},
  { 5.447468e-01,  8.380699e-01,  2.983052e-02, -3.588996e-01, -1.161544e-01, -6.857341e-01},
  {-4.282938e-01, -2.372237e-01,  8.719457e-01, -1.603299e-01, -8.463802e-01,  4.213949e-01},
  { 0.000000e+00,  8.320503e-01,  5.547002e-01,  1.035399e-01, -1.144277e+00, -4.945177e-01},
  {-7.038383e-01, -7.102910e-01, -9.911202e-03,  1.035399e-01, -1.144277e+00, -4.945177e-01},
  { 0.000000e+00,  8.320503e-01,  5.547002e-01,  1.233333e-01, -1.163307e+00, -5.363434e-01},
  {-6.745974e-01,  5.355223e-01, -5.080692e-01, -3.330261e-01, -7.411706e-01, -1.380142e-01},
  {-2.127197e-01,  2.336370e-01, -9.487697e-01,  4.458590e-01,  4.237809e-02,  1.072902e-01},
  {-6.766820e-01,  4.849096e-02, -7.346769e-01,  4.435799e-01,  9.053364e-01, -3.901144e-01},
  {-6.342692e-01,  2.576585e-01, -7.289134e-01,  4.436803e-01,  8.886312e-01, -3.856099e-01},
  {-7.617427e-01,  6.476712e-01,  1.643300e-02,  1.961621e-01,  6.425334e-01,  4.261898e-01},
  {-8.945169e-01, -3.585103e-01, -2.670389e-01,  2.155422e-01,  8.051421e-01, -3.223690e-01},
  {-9.400537e-01,  2.931162e-01,  1.743042e-01,  2.952598e-01,  8.493378e-01, -2.264549e-01},
  { 7.458857e-01, -1.834585e-01, -6.403104e-01,  4.611290e-01,  6.304877e-01, -4.240164e-01},
  { 7.963496e-01,  1.936718e-01, -5.729909e-01,  4.797213e-01,  6.604326e-01, -4.267538e-01},
  { 4.934098e-01, -8.615867e-01, -1.192273e-01,  1.858299e-02, -7.432512e-01,  2.705402e-01},
  { 3.270282e-01,  2.654503e-01,  9.069667e-01, -3.639252e-01, -2.551250e-02, -1.546701e-01},
  { 3.846276e-01,  9.181241e-01, -9.544599e-02, -3.639252e-01, -2.551250e-02, -1.546701e-01},
  {-9.672644e-01, -2.286292e-01, -1.101283e-01, -3.764501e-01, -1.538050e-02, -1.076800e-01},
  { 3.818370e-01, -9.150309e-01, -1.300728e-01, -2.737338e-01, -4.177457e-01,  1.732523e-01},
  { 4.966912e-01, -8.600655e-01, -1.165555e-01, -2.132747e-01, -3.520499e-01,  1.786976e-01},
  {-7.376566e-01,  4.173357e-01,  5.307482e-01, -2.954926e-01, -2.862064e-01, -4.509250e-01},
  { 7.368860e-02,  9.081311e-01, -4.121505e-01,  3.655422e-01, -5.165703e-01, -8.084272e-02},
  {-5.929452e-01, -5.147799e-01, -6.192073e-01, -1.211337e-01, -1.019174e+00, -5.256368e-01},
  {-3.413516e-03, -3.928126e-01,  9.196122e-01,  4.448778e-01, -4.078963e-01,  2.451082e-01},
  { 1.057082e-01, -6.078676e-01, -7.869707e-01,  4.773320e-02, -5.897171e-01,  3.472233e-01},
  { 2.347581e-01,  6.309159e-01, -7.394821e-01,  4.145454e-01, -5.308025e-01, -1.707820e-01},
  { 2.988647e-01,  3.085292e-01,  9.030446e-01,  3.857834e-01, -5.151940e-01, -1.665959e-01},
  { 8.672482e-01, -3.363214e-01, -3.671083e-01,  3.709273e-01, -5.848437e-01, -1.378831e-01},
  {-1.974392e-01,  9.352187e-01, -2.939112e-01,  3.468683e-01,  1.315088e+00,  1.468958e-01},
  { 8.062815e-01,  5.252396e-01, -2.720909e-01,  3.468683e-01,  1.315088e+00,  1.468958e-01},
  {-2.003310e-01,  2.567452e-01, -9.454890e-01,  3.750029e-01,  1.200094e+00,  8.283205e-03},
  {-8.784782e-01,  4.711248e-01,  7.948282e-02,  3.333817e-01,  1.288539e+00,  5.568061e-02},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  6.708128e-02, -5.382216e-01,  7.325268e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  1.076292e-01, -5.019289e-01,  7.468377e-01},
  { 7.061611e-01,  6.900443e-01,  1.586675e-01,  3.355320e-01, -1.101668e+00, -6.228501e-01},
  { 2.107617e-01,  4.520701e-01,  8.667250e-01,  3.181449e-01, -4.149960e-01, -2.799758e-01},
  {-9.488270e-01, -5.745733e-02, -3.105252e-01,  2.838579e-01,  9.104903e-01, -1.845557e-01},
  { 7.070857e-01,  6.029143e-01,  3.694919e-01, -2.152584e-01, -5.407261e-02, -1.668420e-01},
  { 1.149761e-01,  3.208450e-01, -9.401271e-01, -3.791538e-01, -3.538840e-01, -4.577957e-01},
  {-4.497433e-01,  7.966364e-01,  4.038582e-01, -4.387594e-01, -3.881645e-01, -4.851900e-01},
  { 9.365500e-01,  2.171833e-01,  2.751462e-01,  5.110259e-01,  1.395574e-01,  1.162913e-01},
  {-8.182668e-01,  5.615621e-01,  1.228316e-01,  5.110259e-01,  1.395574e-01,  1.162913e-01},
  { 4.131471e-02,  5.990646e-01,  7.996340e-01, -2.691788e-01, -6.570535e-01,  8.852836e-02},
  { 4.714027e-01, -6.945114e-01,  5.435377e-01, -3.512976e-01, -1.262007e-01,  3.690652e-01},
  { 2.069827e-01, -8.763787e-01, -4.348777e-01,  1.219955e-01, -9.155317e-01, -4.866395e-01},
  {-1.087170e-01, -3.570415e-01, -9.277403e-01,  8.496290e-02, -8.997441e-01, -5.203673e-01},
  {-5.465693e-01,  4.740100e-01, -6.903453e-01,  8.345950e-02, -8.621078e-01, -5.144498e-01},
  {-9.192181e-01,  1.109411e-01, -3.777964e-01,  7.634816e-02, -8.427919e-01, -4.675116e-01},
  { 2.393014e-01,  8.762173e-01,  4.183038e-01,  1.603969e-01, -9.412844e-01, -4.625917e-01},
  {-5.020030e-01,  6.185235e-01,  6.045011e-01,  1.347185e-01, -7.409768e-01,  4.701645e-01},
  {-5.191118e-01,  8.518066e-01,  7.034492e-02, -6.010999e-02, -5.334826e-01,  6.317730e-01},
  {-8.872617e-01, -3.094255e-01,  3.420858e-01, -6.010999e-02, -5.334826e-01,  6.317730e-01},
  {-8.872617e-01, -3.094255e-01,  3.420858e-01, -1.489038e-01, -4.028747e-01,  5.196083e-01},
  {-5.560610e-01,  8.131543e-01, -1.719780e-01,  9.368716e-02,  3.276759e-01, -4.500290e-01},
  {-7.171252e-01,  3.299535e-01, -6.138910e-01,  2.215206e-01, -1.277346e+00, -5.092056e-01},
  {-6.083890e-01,  7.006393e-01, -3.727832e-01,  2.605053e-01, -1.266289e+00, -5.227747e-01},
  { 4.100769e-01, -3.983843e-01, -8.204431e-01, -2.495943e-01, -4.857253e-02, -6.231815e-01},
  {-8.387022e-01, -3.400855e-01,  4.253476e-01, -3.216735e-01, -6.041588e-02, -5.541698e-01},
  {-8.387022e-01, -3.400855e-01,  4.253476e-01, -3.102722e-01, -2.373320e-01,  3.236339e-01},
  {-8.387022e-01, -3.400855e-01,  4.253476e-01, -3.942706e-01, -2.272632e-01,  3.359141e-01},
  {-2.960603e-02,  2.090145e-01, -9.774643e-01, -3.064222e-01, -1.942011e-01,  3.173283e-01},
  {-7.515481e-01,  5.610383e-01, -3.470037e-01, -2.816695e-01, -6.552453e-01, -1.103187e-01},
  { 6.049701e-01,  6.043357e-01,  5.184493e-01,  8.103776e-02, -8.273112e-01, -4.491759e-01},
  {-8.205180e-01, -1.879374e-02, -5.713116e-01,  8.103776e-02, -8.273112e-01, -4.491759e-01},
  {-1.253072e-01,  9.536188e-01, -2.736955e-01, -5.263093e-01, -4.494753e-01, -1.061494e-01},
  { 4.370994e-01,  5.975423e-01, -6.722257e-01,  4.083552e-01, -1.131999e+00, -2.418288e-01},
  {-6.139391e-01, -7.884796e-01,  3.713022e-02, -5.941947e-02, -8.870897e-01, -6.560770e-01},
  {-6.989630e-01, -7.141019e-01,  3.884880e-02, -1.763518e-01, -8.135979e-01, -5.781469e-01},
  { 3.290750e-01, -7.668854e-01,  5.509958e-01,  2.565700e-01, -5.463113e-01,  5.088366e-02},
  {-5.647877e-01,  2.848696e-01,  7.745090e-01,  2.565700e-01, -5.463113e-01,  5.088366e-02},
  { 4.558669e-01,  7.245454e-01, -5.169325e-01,  2.944641e-01, -5.834815e-01,  9.218831e-02},
  { 6.800804e-02, -2.295535e-01,  9.709171e-01,  2.374499e-01, -5.944756e-01,  2.149743e-02},
  {-8.172248e-01, -2.709554e-01,  5.086519e-01, -2.205296e-01, -9.025204e-01, -7.548356e-01},
  { 4.646749e-02, -8.298441e-01, -5.560572e-01, -2.205296e-01, -9.025204e-01, -7.548356e-01},
  { 3.951457e-01,  8.044371e-01,  4.435547e-01,  3.218640e-01, -6.846022e-01, -1.412183e-01},
  { 3.717093e-01, -5.297974e-01, -7.623299e-01,  1.962048e-01,  6.159142e-01, -4.976835e-01},
  { 3.105912e-01,  8.609878e-01, -4.027818e-01,  2.102991e-02,  7.998932e-01,  3.318590e-01},
  {-2.341072e-01,  8.230435e-01,  5.174875e-01,  2.390822e-01,  9.193994e-01, -2.591493e-01},
  { 4.765375e-01,  2.408611e-01, -8.455163e-01,  2.390822e-01,  9.193994e-01, -2.591493e-01},
  { 1.714299e-01,  7.660514e-01, -6.194974e-01, -2.349602e-02, -6.963323e-01, -5.703210e-01},
  { 7.647578e-01,  3.222838e-01,  5.579236e-01,  1.196107e-01, -7.995541e-01, -5.265414e-01},
  { 7.482959e-01,  5.521002e-01, -3.677481e-01,  1.321157e-01, -7.789024e-01, -6.029001e-01},
  {-7.787586e-01,  5.983539e-01,  1.884350e-01, -1.405497e-01,  5.908069e-01, -3.817730e-01},
  {-9.541690e-01,  2.717730e-01, -1.253036e-01,  1.083108e-01,  9.982063e-01,  2.639828e-01},
  {-3.339524e-01, -9.372944e-01,  9.977433e-02, -2.282118e-01, -9.680763e-01, -2.520145e-01},
  { 6.666856e-01,  6.861715e-01,  2.910309e-01,  9.063590e-02,  3.626293e-01, -6.921961e-01},
  {-4.787746e-01, -7.970580e-01,  3.680671e-01, -2.609034e-01,  3.348478e-02, -5.878754e-01},
  {-4.686268e-01, -5.759846e-01,  6.697990e-01, -2.957476e-01,  4.523826e-02, -5.676110e-01},
  {-5.970789e-01, -3.118612e-01,  7.390801e-01, -3.070921e-01,  7.017706e-02, -5.662528e-01},
  {-2.170028e-01, -7.675962e-01, -6.030803e-01, -3.481624e-01,  9.022365e-02, -5.909733e-01},
  {-8.069728e-01,  6.517863e-02, -5.869809e-01,  4.078580e-02, -1.120883e+00, -2.717805e-01},
  { 5.950925e-01, -6.979083e-01,  3.984832e-01,  6.154438e-02, -1.120646e+00, -2.780673e-01},
  { 3.329869e-01, -3.386709e-03,  9.429254e-01,  1.412803e-04, -7.421876e-01, -3.441440e-01},
  {-1.917137e-01,  9.487014e-01,  2.514191e-01, -3.269044e-01, -2.009050e-01, -7.282904e-01},
  { 9.759154e-01,  5.124577e-02, -2.120450e-01, -3.249000e-01, -1.937853e-01, -7.605572e-01},
  {-7.214207e-02,  1.540494e-01, -9.854259e-01,  4.068864e-01,  1.798046e-01, -4.170483e-01},
  { 2.991187e-01,  1.232557e-02, -9.541363e-01, -2.230880e-01, -8.557410e-01, -4.994916e-01},
  {-2.468744e-01, -2.330771e-01,  9.405999e-01, -2.230880e-01, -8.557410e-01, -4.994916e-01},
  {-2.144185e-01, -2.350723e-01,  9.480326e-01,  9.588346e-02,  5.232156e-02,  4.441267e-01},
  { 1.552833e-01, -7.798386e-01,  6.064148e-01,  7.779171e-02,  1.324360e-01,  4.584315e-01},
  { 9.706630e-01,  1.547269e-01, -1.840461e-01,  5.100190e-01,  4.326710e-01, -9.635669e-02},
  { 8.392310e-01,  5.047938e-01, -2.021749e-01,  5.140076e-01,  4.126809e-01, -1.297116e-01},
  {-7.608694e-01, -6.052653e-01, -2.339483e-01,  4.945774e-01,  4.222001e-01, -1.865988e-01},
  {-1.598477e-01, -7.051950e-01,  6.907596e-01,  4.322071e-02, -1.099884e+00, -4.208289e-01},
  {-5.995301e-01,  4.176806e-01, -6.827200e-01,  1.344991e-02, -1.091401e+00, -3.894961e-01},
  {-4.309796e-01, -8.137296e-01,  3.900007e-01,  1.344991e-02, -1.091401e+00, -3.894961e-01},
  { 4.060972e-02, -4.274243e-01, -9.031386e-01,  2.569252e-01, -6.716134e-01, -5.187328e-01},
  {-2.902327e-01, -7.143297e-01, -6.367872e-01,  3.173577e-02, -8.627794e-01,  2.344635e-01},
  {-9.378917e-01,  3.047283e-01, -1.658309e-01, -3.959007e-01, -6.732414e-01,  3.425850e-01},
  { 1.074758e-01, -8.396338e-01,  5.324134e-01, -3.959007e-01, -6.732414e-01,  3.425850e-01},
  {-6.478935e-01, -1.339877e-02, -7.616131e-01, -3.959007e-01, -6.732414e-01,  3.425850e-01},
  {-9.378917e-01,  3.047283e-01, -1.658309e-01, -3.965075e-01, -7.631144e-01,  1.808676e-01},
  {-6.323116e-02, -3.365728e-01,  9.395321e-01,  6.295009e-02, -9.068660e-01, -3.669159e-01},
  {-7.075653e-01, -5.419545e-01,  4.534719e-01,  3.067211e-01, -6.887940e-01, -3.284399e-01},
  { 7.261515e-01,  6.284115e-01, -2.789317e-01,  4.537665e-01,  1.053484e+00,  3.816281e-01},
  { 2.659417e-01,  6.927559e-01,  6.703464e-01,  2.768514e-01, -6.569188e-01,  1.063555e-01},
  {-8.847480e-01, -4.660566e-01,  3.487599e-03,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  {-8.747351e-01, -2.667074e-01,  4.046057e-01,  2.487065e-01, -1.239593e-01,  6.381412e-01},
  {-7.176557e-01, -6.623070e-01, -2.152201e-01,  3.138881e-02, -9.400853e-01, -1.855282e-01},
  { 4.578972e-01, -2.218647e-01, -8.608752e-01,  3.138881e-02, -9.400853e-01, -1.855282e-01},
  {-7.474644e-01, -6.503572e-01,  1.353975e-01,  3.138881e-02, -9.400853e-01, -1.855282e-01},
  {-2.426330e-01,  5.020427e-01,  8.301099e-01,  3.452806e-02, -9.370822e-01, -2.022923e-01},
  {-2.545781e-01, -6.908301e-01, -6.767154e-01,  3.634672e-02, -9.859657e-01, -1.719599e-01},
  {-5.988438e-01,  4.079102e-01, -6.891991e-01, -4.491188e-02,  9.375256e-01, -6.461397e-03},
  { 1.326449e-01,  8.097236e-01,  5.716231e-01, -4.491188e-02,  9.375256e-01, -6.461397e-03},
  {-4.210599e-01,  1.413723e-01, -8.959478e-01, -6.549586e-02,  8.774557e-01, -6.266220e-03},
  { 2.861678e-01,  9.508502e-01, -1.182868e-01, -1.175298e-01,  9.363922e-01,  1.270980e-01},
  {-4.381846e-01, -4.115021e-01,  7.991623e-01,  1.891814e-01, -1.348383e+00, -4.508733e-01},
  {-8.372664e-01,  2.311694e-01, -4.955256e-01,  1.891814e-01, -1.348383e+00, -4.508733e-01},
  {-3.994542e-01, -4.171303e-01,  8.163568e-01,  1.966233e-01, -1.245102e+00, -3.944584e-01},
  {-5.496543e-01,  1.135824e-01, -8.276347e-01,  1.795845e-01, -1.205099e+00, -3.823556e-01},
  {-4.363970e-01,  1.707621e-01, -8.834014e-01,  1.590306e-01, -1.246199e+00, -4.162265e-01},
  {-8.663879e-02, -8.822158e-01,  4.628056e-01,  1.898167e-01, -1.258442e+00, -4.338013e-01},
  {-7.902221e-01,  5.592175e-01, -2.506487e-01, -1.115663e-01,  8.339635e-01,  3.024407e-01},
  {-4.591088e-01, -8.629145e-01,  2.111815e-01,  1.644647e-01, -1.056214e+00, -7.749410e-01},
  { 1.568908e-01, -5.158996e-01, -8.421596e-01,  1.644647e-01, -1.056214e+00, -7.749410e-01},
  { 8.002396e-01,  3.403805e-01, -4.937183e-01,  2.838701e-01, -1.101967e+00, -7.023076e-01},
  {-5.070365e-01, -7.951406e-01,  3.326643e-01,  3.355320e-01, -1.101668e+00, -6.228501e-01},
  {-4.012422e-01, -9.120077e-01,  8.512705e-02,  1.964584e-01, -1.070719e+00, -7.795336e-01},
  {-2.334926e-01,  8.821939e-01, -4.089194e-01,  2.545591e-01,  1.237789e+00,  1.284498e-01},
  { 5.815306e-01, -4.431088e-01, -6.822587e-01,  3.424809e-01,  4.488109e-01,  6.545690e-02},
  {-3.241002e-01,  7.236438e-01, -6.093428e-01,  3.581593e-01, -4.549611e-01,  7.016506e-03},
  {-3.241002e-01,  7.236438e-01, -6.093428e-01, -4.149453e-01, -1.367401e-01, -2.891623e-02},
  {-3.241002e-01,  7.236438e-01, -6.093428e-01, -3.374961e-01, -1.794479e-01, -2.326714e-02},
  {-6.326900e-01, -9.439589e-02, -7.686304e-01, -2.734416e-01, -7.230675e-01,  2.392873e-01},
  {-3.744187e-01,  5.982091e-01,  7.084889e-01,  1.601191e-01,  7.779493e-02,  5.302544e-01},
  { 9.927387e-01,  5.056293e-03, -1.201846e-01,  4.518575e-01, -4.335860e-01,  3.973953e-01},
  {-4.073857e-01,  3.849310e-01,  8.281696e-01,  4.518575e-01, -4.335860e-01,  3.973953e-01},
  { 1.509133e-02, -1.149562e-01,  9.932559e-01,  4.536312e-01, -2.679453e-01,  4.022621e-01},
  { 9.865859e-01,  1.332303e-01, -9.432969e-02,  4.401935e-01, -5.533932e-01,  3.130820e-01},
  {-9.630182e-01,  2.574320e-01,  7.952772e-02,  8.387040e-02, -6.193360e-01,  7.251745e-01},
  {-4.505190e-01,  7.506845e-01, -4.832239e-01,  1.781902e-02,  5.549152e-01,  4.591977e-01},
  { 9.241411e-01,  2.944393e-03, -3.820398e-01,  4.077188e-01, -5.241088e-01, -1.238634e-01},
  { 3.605923e-02,  9.263020e-01, -3.750526e-01,  4.425706e-01, -4.798670e-01,  1.721277e-02},
  { 3.214175e-01,  3.851091e-01, -8.650906e-01,  2.057637e-01,  4.661338e-01, -4.497620e-01},
  {-2.305513e-01, -9.546055e-01,  1.886120e-01,  1.316793e-01,  5.364047e-01, -4.133496e-01},
  { 4.082043e-01, -7.182540e-01,  5.634541e-01,  1.479671e-01,  4.992680e-01, -4.724889e-01},
  {-1.294919e-01, -6.408544e-01,  7.566621e-01, -1.139809e-01,  1.103211e-02,  5.523329e-01},
  {-3.513722e-01, -6.436085e-01,  6.799306e-01,  1.214427e-02, -6.205826e-02,  5.120136e-01},
  {-5.867077e-01,  7.056178e-01, -3.973381e-01, -3.698668e-01,  2.996604e-01, -3.858312e-01},
  { 5.496266e-01,  3.994742e-01, -7.337105e-01,  4.515324e-01,  6.358201e-03,  9.192884e-02},
  {-1.744605e-01,  2.429283e-02,  9.843644e-01,  2.980423e-01,  1.063250e+00,  5.065277e-02},
  { 8.248326e-01,  3.185884e-01,  4.670680e-01,  3.161176e-01,  6.138206e-01,  5.545474e-02},
  {-5.607511e-01, -5.715050e-01, -5.991163e-01,  3.161176e-01,  6.138206e-01,  5.545474e-02},
  { 1.562604e-01,  6.145308e-01,  7.732624e-01, -4.709105e-01, -6.524378e-01, -2.333340e-01},
  {-2.965844e-01,  8.009133e-01,  5.201688e-01,  3.783267e-01,  1.081987e+00,  4.777771e-01},
  {-3.029081e-01,  9.081047e-01, -2.891240e-01,  4.179636e-01,  1.105463e+00,  5.099882e-01},
  {-4.384811e-01,  8.792945e-01,  1.859451e-01,  4.843231e-01,  1.127859e+00,  5.108078e-01},
  {-8.202705e-01, -5.117903e-01,  2.553959e-01,  3.577845e-01,  1.151932e+00,  4.502210e-01},
  {-9.714358e-01, -1.400823e-01, -1.915446e-01,  7.106098e-02, -5.798689e-01,  7.274923e-01},
  {-5.757310e-01,  2.440827e-01, -7.803573e-01,  1.204271e-01,  1.053956e+00,  3.023618e-01},
  { 7.916430e-01,  2.434366e-01,  5.603928e-01,  4.648665e-01, -2.183326e-01, -2.609752e-01},
  { 3.860423e-01, -8.789645e-01,  2.799870e-01,  5.147253e-01, -2.028980e-01, -2.812657e-01},
  {-2.298296e-01,  4.905795e-01,  8.405415e-01, -1.078214e-01,  4.935642e-01, -3.160687e-01},
  { 9.977089e-01,  7.770822e-03, -6.720608e-02, -1.390819e-01, -1.282537e-03, -5.926273e-01},
  { 7.757774e-01, -3.330848e-01,  5.359329e-01,  4.274186e-02,  5.313026e-01,  1.939770e-01},
  {-1.674072e-01, -1.432996e-01,  9.754179e-01,  5.804782e-02,  5.698607e-01,  1.957852e-01},
  { 6.861571e-01, -7.248640e-01, -6.132267e-02,  3.421642e-01, -2.231953e-01, -8.197000e-02},
  {-2.523107e-01, -9.597208e-01, -1.235925e-01, -1.519274e-01, -9.963132e-01, -7.769601e-01},
  { 5.638631e-01,  7.653802e-01, -3.102445e-01, -2.463076e-01,  1.020297e-01, -7.027340e-01},
  {-8.837865e-01,  2.688234e-01, -3.829562e-01,  2.823306e-01, -2.735866e-01, -3.345926e-01},
  {-1.118276e-01,  3.328590e-01, -9.363223e-01,  2.728704e-01, -2.372244e-01, -3.205361e-01},
  {-4.552893e-01,  5.347697e-01,  7.118518e-01,  2.876340e-01, -2.130582e-01, -3.137084e-01},
  { 9.043016e-01,  3.308354e-02,  4.256103e-01,  1.097788e-01,  4.448173e-01,  4.681234e-01},
  {-2.602374e-01, -3.143785e-01,  9.129308e-01,  1.097788e-01,  4.448173e-01,  4.681234e-01},
  { 3.787286e-01,  3.857950e-01,  8.412651e-01,  1.697008e-01,  4.579589e-01,  4.230684e-01},
  {-6.789309e-01, -7.240272e-01,  1.218091e-01, -1.897505e-01, -5.005671e-01, -1.739738e-01},
  { 2.267324e-01,  9.683693e-02, -9.691311e-01, -1.897505e-01, -5.005671e-01, -1.739738e-01},
  { 2.267324e-01,  9.683693e-02, -9.691311e-01, -1.664835e-01, -5.155518e-01, -1.700277e-01},
  { 2.267324e-01,  9.683693e-02, -9.691311e-01, -1.530751e-01, -5.592660e-01, -1.712587e-01},
  {-9.589942e-02, -7.194898e-01, -6.878501e-01, -1.530751e-01, -5.592660e-01, -1.712587e-01},
  {-2.609638e-01, -9.586074e-01, -1.138853e-01, -2.901627e-01, -5.247698e-01, -1.474922e-01},
  {-8.975472e-01,  4.091352e-01, -1.643693e-01, -2.782625e-01, -2.898273e-01,  5.495690e-01},
  {-5.690349e-01, -1.011253e-01,  8.160717e-01, -2.722224e-01,  1.684838e-01, -3.845864e-01},
  {-2.887905e-01,  2.526407e-01,  9.234569e-01,  2.827051e-02, -3.903828e-01,  4.223933e-01},
  {-2.613737e-01,  3.338176e-01,  9.056763e-01,  7.610513e-03, -4.039725e-01,  4.214399e-01},
  {-3.594579e-01, -3.376599e-01, -8.699286e-01, -3.181350e-01, -2.480635e-01, -7.425394e-01},
  {-2.516035e-01,  6.146896e-01, -7.475643e-01, -2.996049e-01, -1.848156e-01, -6.851438e-01},
  {-6.833387e-01, -8.680473e-02, -7.249229e-01, -3.480738e-01, -2.058925e-01, -7.311618e-01},
  { 3.377694e-01,  8.918745e-01, -3.007852e-01, -3.480738e-01, -2.058925e-01, -7.311618e-01},
  { 4.427581e-02,  9.686846e-01,  2.443152e-01, -4.223444e-01, -2.205995e-01, -6.593904e-01},
  {-2.492473e-01,  6.287233e-01, -7.366023e-01,  4.925846e-01,  1.079445e+00, -3.339629e-01},
  {-3.780973e-01,  7.571813e-01,  5.326528e-01, -3.352034e-01, -7.144618e-01,  1.088627e-01},
  { 5.279624e-01,  3.022358e-01,  7.936682e-01,  5.091511e-01,  8.029005e-02, -4.267704e-02},
  { 8.597150e-01, -2.654829e-02,  5.100836e-01,  4.588825e-01,  2.056565e-01, -9.811781e-02},
  { 5.091302e-01, -6.918107e-01,  5.120394e-01,  3.790946e-01,  8.461328e-01,  2.041251e-01},
  { 7.248998e-01, -3.123302e-01, -6.139789e-01,  3.790946e-01,  8.461328e-01,  2.041251e-01},
  {-4.034564e-01,  3.972453e-01,  8.242688e-01,  3.868976e-01,  7.866396e-01,  2.518914e-01},
  { 7.590220e-01, -4.667243e-01,  4.539318e-01,  3.985103e-01,  8.293452e-01,  1.543993e-01},
  { 9.739601e-01, -2.168393e-01,  6.620054e-02,  5.148966e-01, -5.694524e-03,  2.177691e-01},
  { 4.824004e-01,  5.102680e-01,  7.119806e-01,  4.953672e-01,  1.673920e-01,  1.069521e-01},
  {-7.241179e-03,  2.410841e-01,  9.704772e-01,  1.013226e-01, -9.564896e-01, -3.829792e-01},
  {-1.788904e-01,  3.514100e-01, -9.189719e-01,  4.173623e-01, -6.492850e-02,  2.751926e-02},
  {-2.186068e-01,  9.663844e-01,  1.353237e-01, -2.777954e-01,  5.345436e-01, -4.491540e-01},
  { 1.218090e-01,  9.107745e-01,  3.945280e-01, -2.777954e-01,  5.345436e-01, -4.491540e-01},
  { 8.283498e-01, -5.158432e-01,  2.185003e-01,  5.695981e-01, -1.241786e-01,  2.290873e-04},
  { 1.593975e-01,  2.974855e-01,  9.413261e-01,  2.557184e-01, -6.158220e-01,  1.637136e-01},
  {-2.035338e-01,  9.789857e-01,  1.269392e-02,  3.681696e-01, -5.930216e-01,  2.083314e-01},
  {-3.209090e-01,  4.664165e-01,  8.243015e-01,  4.319548e-01, -5.797606e-01,  2.083338e-01},
  {-1.024704e-01,  8.213568e-01, -5.611354e-01,  2.663673e-01, -1.003867e+00, -4.545453e-01},
  { 4.198612e-01,  8.836555e-01, -2.070493e-01,  3.068137e-01, -9.958789e-01, -4.675988e-01},
  {-4.241243e-01,  8.793619e-01, -2.164280e-01, -4.627765e-01, -6.350921e-01, -4.621804e-01},
  {-7.465356e-01,  4.324874e-01,  5.056078e-01, -4.605616e-01, -6.424230e-01, -4.292938e-01},
  { 9.678732e-01, -1.633189e-01, -1.911766e-01,  2.194133e-01, -1.215621e+00, -4.727843e-01},
  { 3.821913e-01, -5.910642e-01, -7.103330e-01,  3.705576e-02, -7.679860e-01,  1.143105e-01},
  {-5.371848e-01, -8.275504e-01, -1.630732e-01,  3.697106e-01, -9.384996e-01,  3.727007e-01},
  {-6.594754e-01, -7.506230e-01, -4.070957e-02,  3.502379e-01, -9.262955e-01,  3.749141e-01},
  { 6.629990e-01,  2.484792e-01, -7.061800e-01,  2.111289e-01, -1.191005e+00, -5.357541e-01},
  { 3.642371e-01,  5.878139e-01, -7.223616e-01,  5.611790e-02,  4.380986e-01, -4.063678e-01},
  { 5.606920e-01,  3.788468e-01, -7.362742e-01,  1.919783e-01,  3.066904e-01, -4.447948e-01},
  { 5.606920e-01,  3.788468e-01, -7.362742e-01,  5.874825e-01,  1.035025e+00, -3.509552e-01},
  { 3.501390e-01, -9.241644e-01,  1.527182e-01,  5.874825e-01,  1.035025e+00, -3.509552e-01},
  {-7.382998e-01,  5.131704e-01, -4.376866e-01,  5.874825e-01,  1.035025e+00, -3.509552e-01},
  {-7.382998e-01,  5.131704e-01, -4.376866e-01,  5.660353e-01,  1.022861e+00, -3.753940e-01},
  { 7.591861e-02,  6.720805e-01,  7.365760e-01, -3.987529e-02,  2.996945e-01,  5.365614e-01},
  {-3.753869e-01,  3.389668e-01, -8.626623e-01, -3.403740e-02,  3.402044e-01,  4.947604e-01},
  { 1.070576e-01,  7.064703e-01,  6.995987e-01, -3.403740e-02,  3.402044e-01,  4.947604e-01},
  {-3.753869e-01,  3.389668e-01, -8.626623e-01, -1.356421e-01,  3.197696e-01,  5.309441e-01},
  { 5.089737e-01,  4.889644e-01, -7.084205e-01,  3.816118e-01, -8.112080e-01, -1.758549e-01},
  {-3.027100e-01,  2.607808e-01, -9.167116e-01,  1.317431e-01, -1.212570e+00, -7.134638e-01},
  { 1.076978e-01, -3.165314e-01, -9.424484e-01,  9.728993e-02, -1.093837e+00, -7.264647e-01},
  {-2.498161e-02,  9.572812e-01,  2.880773e-01, -2.769146e-01, -1.999341e-01,  2.665164e-01},
  { 1.836810e-01,  9.649656e-01,  1.873569e-01,  9.412016e-02,  4.845763e-02,  4.657562e-01},
  {-6.301470e-01, -7.539479e-01,  1.856808e-01,  1.158954e-01,  1.276843e-01,  4.760582e-01},
  { 4.261455e-01,  7.038581e-01,  5.683167e-01,  1.158954e-01,  1.276843e-01,  4.760582e-01},
  { 4.801542e-01, -1.626941e-01,  8.619644e-01,  1.019706e-01, -1.080960e+00, -6.500586e-01},
  {-9.430616e-01,  2.722739e-01, -1.910540e-01,  1.130963e-01, -1.180793e+00, -6.696374e-01},
  {-3.552465e-01,  2.677514e-01, -8.956055e-01,  1.087400e-01, -1.173848e+00, -6.668094e-01},
  { 7.242996e-02, -6.966777e-01, -7.137185e-01,  3.109400e-01,  3.851376e-01, -4.070774e-01},
  { 5.542560e-01,  7.879751e-01, -2.681338e-01,  3.109400e-01,  3.851376e-01, -4.070774e-01},
  { 4.960599e-01, -5.890673e-01, -6.379061e-01, -4.459883e-01, -6.219641e-01, -4.084028e-01},
  {-4.401177e-01, -3.289520e-02,  8.973374e-01, -3.939670e-01, -6.183928e-01, -3.712470e-01},
  {-3.133775e-01, -1.661139e-01,  9.349870e-01, -4.662622e-01, -3.600614e-01, -4.856527e-01},
  {-7.734044e-01,  6.051486e-01,  1.887876e-01,  4.906810e-01,  1.216892e-01,  6.244941e-02},
  {-1.723051e-01,  1.241858e-01,  9.771842e-01, -8.420166e-02,  7.304739e-01,  4.275593e-01},
  { 4.444324e-01, -7.501087e-01,  4.897110e-01,  4.829264e-01,  6.043547e-01,  3.482914e-01},
  {-6.597715e-01, -7.506028e-01,  3.601417e-02,  1.258855e-01,  5.384441e-01, -4.769842e-01},
  {-6.597715e-01, -7.506028e-01,  3.601417e-02,  1.414889e-01,  5.245345e-01, -4.810363e-01},
  { 7.714147e-01,  3.623320e-01,  5.231013e-01,  8.876622e-02,  3.112752e-01, -6.538680e-01},
  {-9.348932e-01, -2.089851e-01, -2.868796e-01, -1.527977e-01,  1.597093e-01, -4.137635e-01},
  {-9.348932e-01, -2.089851e-01, -2.868796e-01,  2.850311e-01,  1.455598e-01, -5.511396e-01},
  {-9.348932e-01, -2.089851e-01, -2.868796e-01,  2.968172e-01,  7.320387e-02, -5.753666e-01},
  { 9.319636e-01, -1.243839e-01,  3.405475e-01,  4.304507e-01, -8.274351e-01,  4.623368e-01},
  { 6.230731e-01,  6.934960e-01,  3.617227e-01,  3.319387e-01, -8.037328e-01,  5.865830e-01},
  { 8.221176e-01,  1.794833e-01,  5.402855e-01,  3.407625e-01, -8.160682e-01,  5.950335e-01},
  { 3.366815e-01, -8.468573e-01,  4.116774e-01,  4.304507e-01, -8.274351e-01,  4.623368e-01},
  { 5.102989e-02,  9.128633e-01,  4.050637e-01,  1.874374e-01,  4.906317e-01,  8.028443e-01},
  {-7.007069e-01, -5.302666e-01,  4.773126e-01,  1.874374e-01,  4.906317e-01,  8.028443e-01},
  {-4.758181e-01,  6.959862e-01, -5.377735e-01,  1.874374e-01,  4.906317e-01,  8.028443e-01},
  {-5.253149e-01,  6.537544e-01, -5.446552e-01,  1.775390e-01,  3.635475e-01,  6.471300e-01},
  { 8.504111e-02, -7.820534e-01,  6.173820e-01,  1.310561e-01,  5.452840e-01,  5.031972e-01},
  {-2.321298e-01,  6.896163e-01,  6.859629e-01, -2.132747e-01, -3.520499e-01,  1.786976e-01},
  { 2.979381e-01,  2.318960e-01,  9.259898e-01, -2.621923e-01, -4.465873e-01,  1.767617e-01},
  { 8.996302e-01,  4.117875e-01,  1.452464e-01,  4.227894e-01, -5.267236e-01,  3.917022e-01},
  {-1.616536e-01,  2.652874e-02, -9.864909e-01,  3.787411e-01, -4.695661e-01,  4.004574e-01},
  {-7.661073e-01, -6.016277e-01,  2.261054e-01,  2.330771e-01, -1.245637e+00, -2.767272e-01},
  {-1.221103e-01, -7.381217e-01, -6.635250e-01,  1.451309e-01, -9.023165e-01,  5.231268e-02},
  { 4.664972e-01, -7.186005e-01, -5.157458e-01,  1.400428e-01, -9.644500e-01,  1.223680e-01},
  {-3.449535e-01,  1.148429e-01, -9.315675e-01,  9.717962e-02, -1.198666e-01, -5.418252e-01},
  {-5.758728e-01, -8.161798e-01,  4.712794e-02,  3.538682e-02,  9.270378e-01,  2.454627e-01},
  { 8.226352e-02,  9.319876e-01,  3.530326e-01,  1.862322e-01, -3.392276e-01, -4.692055e-01},
  { 6.931847e-01, -7.063291e-01,  1.435065e-01,  1.666774e-01, -3.994991e-01, -3.808780e-01},
  { 1.283944e-01,  8.057168e-01,  5.782174e-01,  1.666774e-01, -3.994991e-01, -3.808780e-01},
  { 4.154406e-01,  8.227187e-01, -3.879989e-01,  5.698677e-01,  1.331108e-01, -4.538261e-01},
  { 4.633956e-01, -6.005890e-01,  6.515807e-01,  5.698677e-01,  1.331108e-01, -4.538261e-01},
  { 9.374789e-01, -3.480000e-01,  5.417059e-03,  2.655173e-01,  1.254695e+00,  2.430568e-01},
  { 9.374789e-01, -3.480000e-01,  5.417059e-03,  2.463473e-01,  1.202247e+00,  1.913395e-01},
  {-4.407445e-02,  9.667105e-01,  2.520480e-01, -5.285445e-01, -3.485650e-01, -4.760509e-01},
  {-9.701463e-01, -9.028636e-03, -2.423523e-01, -2.382593e-01,  5.368292e-01, -6.339659e-01},
  { 6.313591e-02,  2.096913e-02,  9.977846e-01,  2.429635e-01, -8.279733e-01,  1.006247e-01},
  { 4.799728e-02,  9.988448e-01, -2.306827e-03, -3.939688e-01, -1.191318e-01, -6.666522e-01},
  {-9.735416e-01,  6.735834e-02, -2.183570e-01, -3.896027e-01, -1.306512e-01, -7.010247e-01},
  { 2.648613e-01, -2.170101e-01,  9.395505e-01,  4.399232e-01,  2.132819e-01,  2.534415e-01},
  { 7.127194e-01, -3.682723e-01, -5.969980e-01,  3.488050e-01,  9.111938e-01,  5.507277e-01},
  { 3.779197e-01,  7.120472e-01,  5.917479e-01,  3.488050e-01,  9.111938e-01,  5.507277e-01},
  {-2.177286e-01, -5.456783e-01,  8.092152e-01, -2.075506e-02,  8.333713e-01,  4.928606e-01},
  { 8.801338e-02,  8.490410e-01, -5.209444e-01, -5.321099e-01, -3.582268e-01, -3.972794e-01},
  { 9.094707e-01, -3.232076e-01,  2.615337e-01,  3.899961e-01,  4.305497e-01,  8.620459e-02},
  {-4.239326e-01,  8.967650e-01,  1.268609e-01, -2.450608e-01,  5.797839e-01,  9.679758e-02},
  { 6.817877e-01,  7.214079e-01, -1.213922e-01, -2.450608e-01,  5.797839e-01,  9.679758e-02},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  1.627111e-01,  5.652916e-01, -2.692213e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  1.335905e-01,  6.460031e-01, -2.548074e-01},
  { 4.713984e-01, -8.680515e-01, -1.557886e-01,  1.335905e-01,  6.460031e-01, -2.548074e-01},
  { 4.908866e-01, -7.697462e-01, -4.080701e-01,  1.246860e-01,  6.426595e-01, -2.208584e-01},
  { 5.357456e-01,  5.482665e-02, -8.425976e-01, -3.179352e-01, -4.143933e-01, -4.820887e-01},
  {-1.194978e-01,  8.841354e-01, -4.516911e-01, -2.652709e-01, -4.365575e-01, -4.775159e-01},
  {-4.177050e-01,  9.051679e-01,  7.869967e-02, -2.116301e-01, -4.466413e-01, -5.079408e-01},
  {-5.465317e-01,  7.831150e-02,  8.337688e-01, -2.102652e-01,  8.349881e-01,  1.434042e-01},
  {-5.274738e-01,  8.407502e-01,  1.221084e-01, -1.426306e-01,  9.288521e-01,  1.558623e-01},
  {-7.468683e-01,  9.991848e-02,  6.574224e-01,  2.415619e-01,  1.207637e+00,  1.863390e-01},
  {-6.989354e-01, -3.047413e-01, -6.470101e-01, -2.498683e-01, -3.624904e-01, -2.126469e-01},
  {-7.587385e-01,  3.437943e-01, -5.532824e-01,  4.646698e-01,  9.845839e-02, -5.468353e-01},
  {-1.985669e-01,  2.469614e-01, -9.484625e-01,  2.646194e-01, -2.737926e-01, -1.161068e-01},
  {-3.128540e-01,  1.465505e-01,  9.384270e-01, -5.264499e-01, -3.370389e-01, -3.617909e-01},
  {-2.200465e-01, -3.576082e-01,  9.075770e-01, -3.937043e-01, -3.203610e-01, -3.596204e-01},
  {-5.537091e-01, -7.823818e-01, -2.851051e-01,  1.649803e-01, -7.813631e-01,  5.312180e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -2.598208e-01,  8.278617e-02, -6.804583e-01},
  {-2.334564e-01, -6.612790e-01, -7.128872e-01, -2.463076e-01,  1.020297e-01, -7.027340e-01},
  {-1.967157e-01, -5.777224e-01,  7.921742e-01, -4.571436e-01, -6.006963e-01,  7.574620e-03},
  {-6.216989e-01,  1.091644e-02, -7.831803e-01, -1.939904e-01,  9.694682e-02, -3.277131e-01},
  {-8.722787e-02,  8.559477e-01, -5.096515e-01,  3.212050e-01, -2.237063e-01, -5.053912e-02},
  { 9.295720e-01,  3.667288e-01,  3.749701e-02,  2.277820e-01, -7.974953e-01,  1.356428e-01},
  {-6.212427e-02, -9.980684e-01, -1.310344e-04,  3.728820e-01, -7.460018e-01,  5.032578e-01},
  {-3.135127e-01, -2.640942e-01,  9.121206e-01,  3.728820e-01, -7.460018e-01,  5.032578e-01},
  { 7.666812e-01, -6.418153e-01,  1.652940e-02,  4.259003e-01, -7.327082e-01,  5.253302e-01},
  { 3.135127e-01,  2.640942e-01, -9.121206e-01,  4.259003e-01, -7.327082e-01,  5.253302e-01},
  {-8.975288e-01, -2.381501e-01,  3.711154e-01, -2.917806e-01, -1.246197e-01, -5.465608e-01},
  { 4.499547e-01, -8.737327e-01, -1.847488e-01, -3.216735e-01, -6.041588e-02, -5.541698e-01},
  {-8.962781e-01, -4.362060e-01, -8.006219e-02, -2.139968e-01, -9.630783e-01, -7.765985e-01},
  {-8.087985e-01, -5.878401e-01,  1.699964e-02,  1.204734e-01,  5.223567e-01,  7.397841e-01},
  {-8.000900e-01, -3.361450e-01,  4.968527e-01,  9.486607e-02,  5.582072e-01,  6.743009e-01},
  {-2.202224e-01, -6.331933e-01,  7.420030e-01,  2.455083e-01,  5.316874e-01,  6.696164e-01},
  {-1.303681e-01,  3.775001e-01,  9.167867e-01, -3.669090e-01,  1.112021e-02, -6.274214e-02},
  {-6.296789e-01,  7.349654e-01, -2.516552e-01, -3.280965e-01, -5.570707e-01,  1.429705e-01},
  {-4.819894e-01,  7.869000e-01,  3.853240e-01,  2.102158e-01,  9.252289e-01, -2.814797e-01},
  { 5.380302e-01, -3.211571e-01, -7.793469e-01,  1.322428e-01,  8.548788e-01, -3.063190e-01},
  {-3.928623e-01, -6.179976e-01, -6.809833e-01,  5.288737e-03, -6.859037e-02, -5.353465e-01},
  {-8.808727e-01, -3.449325e-01, -3.241680e-01,  3.099120e-01, -1.257569e-01,  3.246508e-01},
  { 6.514089e-01,  6.090405e-01,  4.524778e-01,  5.513216e-01,  7.239743e-02, -4.750882e-02},
  {-8.326975e-01, -1.871658e-01,  5.211372e-01,  2.698544e-01, -1.633098e-01,  7.445115e-01},
  {-7.289407e-01, -5.569000e-03,  6.845542e-01,  2.100452e-01, -1.332020e+00, -3.019553e-01},
  {-6.318300e-02,  9.469772e-01,  3.150273e-01,  4.988503e-01,  1.238139e+00,  3.159219e-01},
  {-5.697566e-01, -5.918549e-02,  8.196796e-01,  4.988503e-01,  1.238139e+00,  3.159219e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  4.327585e-01,  1.240193e+00,  2.271712e-01},
  { 8.498805e-01, -4.833018e-01, -2.100538e-01,  3.320725e-01, -6.292059e-01, -1.612554e-01},
  {-5.663004e-01, -4.776441e-01, -6.716844e-01,  3.118268e-01, -1.012036e+00, -4.504686e-01},
  { 9.579107e-01,  2.819275e-01, -5.407495e-02,  3.549432e-01, -8.260735e-01, -2.052758e-01},
  {-2.449432e-02,  7.635021e-01, -6.453408e-01,  3.316269e-01,  1.122085e+00, -1.071659e-02},
  { 2.106687e-01,  5.362399e-01, -8.173527e-01,  2.860717e-01,  1.175886e+00,  5.466390e-02},
  {-6.870295e-01,  2.238400e-01, -6.912931e-01,  2.946315e-01,  1.220371e+00,  4.593680e-02},
  {-7.430166e-01,  1.472749e-01,  6.528679e-01,  2.915374e-01,  1.114155e+00, -8.317319e-02},
  { 9.860191e-01,  1.665787e-01, -4.239928e-03,  2.888091e-01,  1.142588e+00, -3.562321e-02},
  {-6.168271e-01,  7.322226e-01, -2.887464e-01,  2.860717e-01,  1.175886e+00,  5.466390e-02},
  {-1.713662e-01,  4.715713e-01, -8.650168e-01, -5.470513e-01, -4.258946e-01, -1.950627e-01},
  { 7.597609e-01, -2.062655e-01,  6.166181e-01,  6.241601e-02,  1.646230e-01, -6.704575e-01},
  {-1.964357e-01,  9.800379e-01,  3.063996e-02,  2.082622e-01, -3.281026e-01, -2.611101e-01},
  { 8.635698e-01,  5.042294e-01, -1.200324e-04,  2.871340e-01, -3.086254e-01, -3.784442e-01},
  { 8.498805e-01, -4.833018e-01, -2.100538e-01,  3.341088e-01, -6.209718e-01, -1.719620e-01},
  {-1.264699e-01, -8.256366e-01,  5.498449e-01, -3.715273e-02, -4.227764e-01,  1.619429e-01},
  { 8.449709e-01, -1.445432e-01,  5.149092e-01,  8.876622e-02,  3.112752e-01, -6.538680e-01},
  {-1.630302e-02,  4.010095e-01, -9.159288e-01,  6.241601e-02,  1.646230e-01, -6.704575e-01},
  {-3.294096e-01,  2.497286e-01, -9.105629e-01,  2.194133e-01, -1.215621e+00, -4.727843e-01},
  { 1.579144e-01,  3.965638e-02,  9.866561e-01, -1.699460e-01,  2.147104e-01, -4.868520e-01},
  { 8.305618e-02, -2.383940e-02,  9.962596e-01, -1.525348e-01,  2.231262e-01, -4.825877e-01},
  {-9.394975e-01,  3.278406e-01, -9.932270e-02, -1.359150e-01,  2.655302e-01, -4.998299e-01},
  {-6.671100e-01, -6.349304e-01, -3.896506e-01,  5.144002e-02, -1.283033e+00, -2.769534e-01},
  {-8.240922e-01,  5.445384e-01, -1.560448e-01,  3.382641e-02, -1.282696e+00, -1.827594e-01},
};

static GLushort pialsurf_indices[][3] =
{
  {   1,    3,    0},
  {   3,    1,    2},
  {   4,   17,    6},
  {   3,   17,    4},
  {   3,    4,    0},
  {   4,    8,    0},
  {5770,   10,    5},
  {  16,   15,    4},
  {  16,    4,    6},
  {   4,   15,    7},
  {   7,   64,    4},
  {  64,    0,    8},
  {  11,   17,    3},
  {  10,    9,    5},
  {  21,    5,    9},
  {  11,    3,   12},
  {  13, 5770,   22},
  {  74,   14,   26},
  {  14,   74,   15},
  {  14,   16,   26},
  {  15,   16,   14},
  {  45,   64,    7},
  {  64,    8,    4},
  {  18,    9,   10},
  {  18,   31,    9},
  {6771,   10, 5770},
  {  18,   10,  127},
  {  11,   12,   19},
  {  20, 5770,    5},
  {   5,   21,   20},
  {  20,   21,   52},
  {  69,   52,   21},
  {5770,   20,   22},
  {  22,   37,   13},
  {  52,   22,   20},
  {  42,   43,   23},
  {  23,   74,   42},
  {  25,   24,   59},
  {  74,   23,   15},
  {  24,   25,   27},
  {  15,   23, 7749},
  {  16,   62,   26},
  {7750,   28, 5874},
  {  82,   29,   17},
  {  30,   48,    9},
  {   9,   48,   46},
  {   9,   46,   47},
  {  82,   17,   11},
  {   9,   31,   30},
  {  82,   11,   65},
  {  18,   51,   31},
  {  11,   32,   65},
  {   9,   68,   21},
  {  11,   19,   34},
  {  11,   34,   32},
  {  21,   35,   69},
  {  68,   35,   21},
  {  36,   37,   22},
  {  36,   22,   52},
  {  53,   69,   35},
  {  40,   41,   57},
  {  40,   42,   41},
  {  41,   42,   74},
  {  43,   75,   23},
  {  59,   24,   58},
  {  23,   75,   61},
  {  27,  101,   24},
  {  60,  101,   27},
  {  26,   62,   74},
  {  15,   45,    7},
  {  15, 7749,   45},
  {  23,   61, 7749},
  {   6,   17,   27},
  {  16,    6,   62},
  {  45, 7749,   44},
  {7749,   61,   44},
  {  47,   46,   63},
  {  30,   31,   51},
  {  30,   51,   48},
  {  47, 6563,    9},
  {7438, 7512,   49},
  {  50,  127,   10},
  {5766, 6779, 6780},
  {  50, 6771, 7516},
  {6771,   50,   10},
  {   9, 6563,   68},
  {6485,   86, 7745},
  {  70,   35,   68},
  {  86,   37,   36},
  {  36,   52,   86},
  {  86,   38,   37},
  {  35,   70,   53},
  {  89,   53,   70},
  {  73,   55,   54},
  {  97,   56,   54},
  {  54,   56,   73},
  {  97,   39,   56},
  {  97,   40,   39},
  {  56,   39,   73},
  {  39,   40,   57},
  {  39,   57,   73},
  {  57,   41,   73},
  {  40,   97,   42},
  {  43,   42,   97},
  {  75,   43,  100},
  {5880,   75,  100},
  {  58,   24,  101},
  {  59, 7254, 7659},
  {  25,   59,   27},
  {7659,   27,   59},
  {  74,   62, 6635},
  {  27, 7659, 7724},
  {  29,   60,   27},
  {  61,   45,   44},
  {  77,   60,   82},
  {  60,   29,   82},
  {  77,   82,   80},
  {  45, 7514,   64},
  {  63,  105,   47},
  {7513,   81, 7511},
  {7030,   18,  127},
  { 105,   85,   47},
  {7512, 7515,   49},
  {7511,   81,   50},
  {  50,   81,  127},
  {  32, 6485, 7745},
  {  84,   65,   32},
  {  52,   69,   86},
  {  71,   85,   91},
  {5771,   92,   72},
  {  95,   94,   55},
  {  55,   94,  168},
  {  55,  168,   54},
  {  96,   95,   55},
  {  73,   96,   55},
  {  58,   98, 5774},
  {  41,   74,   73},
  {  43,   97,  100},
  {  60,  103,  101},
  {  60,   77,  103},
  { 284, 6823, 6515},
  { 123, 6515,   79},
  {  45,   61,  151},
  { 151, 7514,   45},
  {  77,   80, 7304},
  {  46,  208,   63},
  {  83,   85,  105},
  {  85, 6563,   47},
  {  84,   32, 7745},
  {  48,   51,  107},
  {  83,  108,   85},
  {  82,   65,  128},
  {  84,  128,   65},
  { 108,   91,   85},
  {  68, 6566,   70},
  {  69, 5883,   86},
  {  85,   71,   87},
  {  69,   53,   88},
  {  69,   88, 5883},
  {  70,  111,   89},
  { 112,   72,  136},
  { 119,   90,   71},
  {  91,  119,   71},
  {  73,   74,  120},
  {  98,   58,   99},
  { 101,   99,   58},
  {  59,   58, 5893},
  {  74, 6635,  120},
  {  97,   76,  100},
  {  97,  102,   76},
  { 104, 6578,   76},
  { 125,   76,  102},
  {7474,   61,   75},
  { 103,   77, 7304},
  {  61, 7474,  151},
  {6822,   80,   79},
  {  63,  208,  105},
  { 128,   79,   80},
  { 128,   80,   82},
  {7030,  127, 6719},
  {  48, 6722,   46},
  {  83,  106,  108},
  {  48,  107, 6722},
  { 130,  128,   84},
  {  84, 7745,  130},
  { 108,  106,  131},
  {7745,   86, 6690},
  {7745, 6690, 7153},
  {  68, 5881,  133},
  {6480,   85,   87},
  {6566,   68,  133},
  {6791, 6792, 6789},
  {7173,  134, 6793},
  {  70, 6566,  111},
  {  87,   71, 5888},
  {  86, 5883, 6796},
  {  90, 5888,   71},
  { 110,  109, 5877},
  {5876, 5878, 6795},
  { 113, 6795, 5878},
  {5878,  111,  113},
  {6794, 6795,  112},
  { 113,  112, 6795},
  {6794,  112,  136},
  { 112,  113,  114},
  {  92,  136,   72},
  { 112,  114,   72},
  { 114,  137,   72},
  { 142,   72,  137},
  {  90,  119,  115},
  { 119,   91,  259},
  {7623, 6226,  116},
  {5889, 5890, 5885},
  {  92,   93,  220},
  {7623,  220,   93},
  { 117, 6287,  118},
  { 117,  118, 6287},
  {  93, 6226, 7623},
  { 168,   97,   54},
  { 120,  145,   73},
  {  58, 6408, 5893},
  { 101,  103,  173},
  {  59, 5893, 7254},
  {6579,  100, 6578},
  { 100,   76, 6578},
  {6578,  149,  122},
  { 103,   78, 6609},
  { 123,  284, 6515},
  {  76,  125,  104},
  {6870,  124, 6868},
  { 127,   81, 7221},
  { 127,  204, 7219},
  {  79,  128,  206},
  { 105,  208,   83},
  {  46, 6722,  153},
  {  83,  129,  106},
  {  83,  208,  129},
  {  46,  153,  208},
  { 154,  128,  130},
  { 106,  177,  131},
  { 108,  131,  295},
  {5888, 6481,   87},
  {6690, 6788, 7153},
  {6793,  134, 6790},
  { 188,  111, 6566},
  { 157,   91,  108},
  {  90,  135, 5888},
  {5888,  135,  156},
  { 160,  135,   90},
  { 113,  111,  114},
  { 114,  111,  188},
  { 114,  188,  137},
  { 142,  137,  188},
  {  90,  115,  160},
  { 219,  187,   92},
  { 138,  259,   91},
  { 119,  144,  115},
  { 115,  144,  160},
  {  94,   95,  195},
  {  94,  195,  190},
  {  97,  168,  192},
  {  96,  145,   95},
  {  96,   73,  145},
  { 171,  196,   97},
  { 234,   58, 5774},
  {  99,  101,  173},
  {  58,  234, 6408},
  { 146,  102,   97},
  { 146,  416,  125},
  { 146,  125,  102},
  { 173,  103, 6609},
  { 147, 6630,  121},
  {6609, 6820,  174},
  { 148,   80,  150},
  {6578,  104,  149},
  {  80, 6822,  150},
  {7220, 6869, 7218},
  { 126,  104,  245},
  { 104,  125,  245},
  {7221,  204,  127},
  { 126,  245,  152},
  {6719,  127, 7219},
  { 106,  129,  208},
  { 208,  177,  106},
  {6722,  210,  153},
  { 130, 7745,  154},
  { 209, 6719,  178},
  { 108,  295,  180},
  {6721, 5882,  209},
  {6566,  133, 6565},
  { 157,  108,  180},
  {6790,  134,  155},
  { 156,  135,  158},
  { 134,  136,  155},
  { 135,  160,  158},
  { 155,  136,  183},
  {5776,  185,  159},
  {5776,  159,  143},
  {  92,  187,  136},
  { 139, 5887, 7629},
  { 219,   92,  220},
  {5886, 7630, 6286},
  { 140, 5884, 7631},
  {5776,  143,  256},
  {6672,  163, 6231},
  {6912, 7350,  161},
  { 160,  144,  163},
  { 144,  119,  260},
  {7519,  256,  143},
  { 162,  161, 7350},
  {6231,  163,  162},
  { 162,  163,  165},
  { 162,  165,  164},
  { 192,  168, 5780},
  {5780,  191,  192},
  { 190,  195,  166},
  { 191,  167,  192},
  {  97,  194,  171},
  { 196,  197,   97},
  { 199,   97,  197},
  { 197,  325,  199},
  { 145,  120,  172},
  { 146,   97,  416},
  {6550, 6364, 5892},
  {6822, 7449,  150},
  { 122,  149,  175},
  {6559, 6561, 6562},
  { 149,  200,  175},
  {6560,  200,  201},
  { 149,  104,  126},
  { 149,  126,  200},
  { 152,  205,  126},
  { 205,  152,  176},
  { 152,  245,  176},
  {  79,  289,  123},
  {7219,  178, 6719},
  { 208,  153,  293},
  { 154, 7607, 7611},
  {  67,  132,  211},
  { 180, 6910,  157},
  { 181, 7386, 7388},
  { 188, 6566,  184},
  { 160, 5894,  158},
  { 185,  211,  182},
  { 138,   91,  212},
  { 138,  212,  217},
  { 183,  136,  187},
  { 160, 6672,  188},
  { 160,  188,  184},
  { 159,  185,  143},
  {6286, 7630,  222},
  { 259,  260,  119},
  {6672,  160,  163},
  {7624,  220, 7623},
  { 161,  162,  344},
  {7521, 7518,  221},
  { 260,  163,  144},
  { 162,  164,  306},
  { 224,  165,  163},
  { 224,  163,  189},
  { 190,  166,  229},
  { 190,  229, 5870},
  { 169, 6530,  193},
  { 193, 6530,  170},
  {6530,  232,  170},
  { 166,  195,  230},
  { 192,  194,   97},
  { 192,  167,  194},
  { 167,  169,  194},
  { 169,  193,  325},
  { 193,  170,  325},
  { 196,  171,  194},
  {6406,   95,  145},
  { 145,  198, 6406},
  {5774,  173,  234},
  { 416,   97,  199},
  {6609,  174,  240},
  {6609,  240,  173},
  { 237,  173,  240},
  { 126,  201,  200},
  {6869, 7220,  204},
  { 125,  243,  202},
  { 204, 6334,  203},
  { 244,  125,  202},
  { 206,  289,   79},
  { 205,  176, 5904},
  { 176,  290, 5904},
  { 206,  128,  207},
  { 128,  154,  246},
  { 128,  246,  207},
  { 153,  210,  293},
  { 295,  131,  177},
  { 154,  248,  246},
  { 154, 7611,  248},
  { 209, 6720, 6721},
  {5775,  211,  132},
  { 183,  187,  132},
  { 132, 7387,  183},
  { 181, 7388, 7386},
  { 157,  212,   91},
  { 157,  301,  212},
  { 252,  186,  253},
  { 255,  214,  215},
  {5898,  255,  215},
  { 182,  187,  185},
  { 254,  217,  212},
  { 185,  187, 5899},
  { 187, 5896, 5899},
  { 259,  138,  302},
  {7418, 7520,  218},
  {5899, 5900,  185},
  {5900,  143,  185},
  { 344,  186,  161},
  {5900,  220,  143},
  { 143,  220, 7519},
  { 220, 7624, 7519},
  { 261,  163,  260},
  { 162,  306,  344},
  { 163,  261,  223},
  { 163,  223,  189},
  { 189,  223,  224},
  { 306,  164,  165},
  { 228,  227,  269},
  { 274,  228,  269},
  { 229,  322,  191},
  { 167,  191,  169},
  {6530,  169,  367},
  { 230,  229,  166},
  { 194,  169,  196},
  { 196,  169,  197},
  { 325,  197,  169},
  {  95, 6406,  195},
  { 281,  233,  235},
  { 173,  237,  279},
  { 237,  236, 5897},
  {5897,  236,  237},
  { 234,  327, 6408},
  { 238,  278,  239},
  { 239,  278,  241},
  { 199, 6950,  416},
  { 374,  237,  240},
  { 240,  174,  285},
  { 240,  285,  283},
  { 174, 6821,  286},
  { 174,  286,  285},
  { 123,  288,  284},
  {7475,  201,  205},
  { 126,  205,  201},
  { 123,  335,  288},
  { 203, 6334,  204},
  { 202,  243,  244},
  { 335,  123,  289},
  { 289,  206,  337},
  { 176,  245,  290},
  {6614, 6720,  209},
  {6614,  209,  178},
  { 246,  248,  247},
  {6722, 7487,  210},
  { 295, 6478,  180},
  { 249,  298,  338},
  { 298,  249, 5777},
  { 211,  250,  248},
  {5777,  296,  185},
  { 296,  250,  185},
  { 250,  211,  185},
  { 255, 5898, 5902},
  { 255, 5902,  257},
  { 258,  257, 5902},
  {5902, 5903,  258},
  { 344,  253,  186},
  { 387,  258, 5903},
  {7418,  218, 6346},
  { 138,  217,  302},
  { 218, 6345, 6346},
  {7520,  303,  218},
  { 262,  307, 7520},
  { 221, 7518, 7522},
  { 263,  223,  261},
  { 263,  224,  223},
  { 263,  308,  306},
  { 263,  306,  224},
  { 224,  306,  165},
  { 309,  264,  226},
  { 264,  309,  310},
  { 225,  309,  226},
  { 225,  266,  311},
  { 226,  264,  265},
  { 225,  267,  266},
  { 226,  265,  225},
  { 267,  225,  271},
  { 269,  227,  268},
  { 273,  269,  270},
  { 449,  267,  271},
  { 269,  273,  274},
  { 272,  449,  271},
  { 228,  315,  227},
  { 367,  169,  191},
  { 229,  230,  275},
  {6530, 6763,  232},
  { 232,  319,  276},
  { 323,  170,  276},
  { 230,  195,  324},
  { 195, 6406,  324},
  { 233,  281,  326},
  { 235,  233,  277},
  { 371,  234,  279},
  { 173,  279,  234},
  { 325,  280,  199},
  { 235,  238,  282},
  { 235,  282,  281},
  { 235,  277,  238},
  { 277,  278,  238},
  { 279,  237, 5909},
  {6599, 6600, 6597},
  { 278,  329,  241},
  { 238,  239,  282},
  { 240,  283,  374},
  {6598,  325,  330},
  { 378,  416, 6950},
  {6282,  283,  285},
  { 333,  284,  288},
  { 241,  329,  331},
  { 287,  331,  329},
  { 242, 7475,  205},
  { 334,  243,  125},
  { 242,  205, 5904},
  { 243,  334,  244},
  { 423,  125,  244},
  { 291,  336,  292},
  { 291,  292,  249},
  {5901,  297,  207},
  { 208,  295,  177},
  {5901,  247,  248},
  {7488,  294,  179},
  { 210,  421,  293},
  { 248,  297, 5901},
  { 250,  296,  297},
  { 297,  248,  250},
  { 249,  296, 5777},
  { 257,  300,  340},
  { 300,  257,  258},
  { 212,  301,  254},
  { 186,  252,  342},
  { 343,  254,  301},
  { 389,  254,  343},
  { 186,  342,  305},
  { 217,  254,  302},
  { 302,  304,  259},
  { 387,  218,  303},
  { 186,  305, 7630},
  { 305,  222, 7630},
  { 260,  304,  261},
  { 260,  259,  304},
  { 303, 7520,  388},
  { 307,  388, 7520},
  { 307,  305,  388},
  { 222,  305,  346},
  { 347,  261,  304},
  { 304,  345,  348},
  { 304,  348,  347},
  { 262,  346,  307},
  { 263,  261,  308},
  { 261,  349,  308},
  { 398,  264,  310},
  { 309,  225,  311},
  { 312,  265,  264},
  { 264,  398,  312},
  { 225,  265,  272},
  { 266,  267, 6607},
  { 272,  271,  225},
  { 399,  268,  313},
  { 314,  444,  313},
  { 268,  399,  269},
  { 358,  269,  399},
  { 359,  269,  358},
  { 269,  359,  270},
  { 359,  273,  270},
  { 267,  449, 6607},
  { 273,  359, 5911},
  { 228,  274, 6521},
  { 228, 6521,  315},
  { 273, 5911,  274},
  { 272,  316,  361},
  { 319, 5908,  276},
  { 454, 6530,  367},
  { 321,  229,  275},
  { 229,  321,  322},
  { 367,  191,  322},
  { 275,  230,  462},
  { 321,  461,  322},
  { 325,  170,  412},
  { 170,  323,  412},
  { 277,  233,  326},
  { 327,  234,  371},
  { 371,  279,  328},
  {5909,  328,  279},
  { 281,  282,  503},
  { 375,  503,  282},
  { 283, 6282,  415},
  { 283,  415,  374},
  { 282,  239,  375},
  { 239,  241,  375},
  {6281,  332, 6283},
  {6280,  376, 5907},
  { 285,  286, 6282},
  { 417,  333,  288},
  { 335,  417,  288},
  { 423,  244,  334},
  { 379,  245,  125},
  { 423,  379,  125},
  { 336,  380,  292},
  { 337,  206,  207},
  { 292,  296,  249},
  { 337,  296,  292},
  { 337,  207,  296},
  {6297,  291,  249},
  { 249,  338, 6297},
  { 296,  207,  297},
  {7487, 7489,  210},
  { 293, 6873,  208},
  { 424,  208, 6873},
  { 208,  424,  295},
  { 338,  298,  339},
  { 338,  339,  384},
  { 340,  299,  385},
  { 299,  340,  300},
  { 299, 5905,  258},
  { 299,  258,  341},
  { 252,  253,  429},
  { 475,  157, 6910},
  {5914,  305,  342},
  { 157,  475,  301},
  { 343,  435,  389},
  { 254,  389,  302},
  { 387,  303,  434},
  { 302,  389,  304},
  { 308,  344,  306},
  { 346,  305,  307},
  { 350,  439,  352},
  { 350,  351,  439},
  { 352,  353,  350},
  { 352,  439,  393},
  { 393,  309,  352},
  { 266, 6607,  311},
  { 536,  311, 6607},
  { 311,  536,  309},
  { 354,  356,  355},
  { 313,  357,  356},
  { 354,  355,  356},
  { 356,  399,  313},
  { 265,  316,  272},
  { 317,  318,  406},
  { 272,  361,  449},
  { 318,  360,  406},
  { 363,  364,  366},
  { 320,  231, 7315},
  { 231,  365, 7315},
  {6529,  365,  231},
  { 363,  366,  408},
  { 409,  408,  366},
  { 461,  321,  275},
  { 548,  367,  322},
  { 276,  590,  323},
  { 230,  324,  371},
  { 461,  368,  322},
  { 322,  368,  548},
  { 324, 5906,  369},
  { 324,  369,  371},
  { 277,  326, 5919},
  { 370, 5919,  326},
  { 326,  281,  370},
  { 371,  328,  373},
  { 278,  372,  329},
  {6723,  373,  328},
  { 328, 5909, 6723},
  { 241,  331,  375},
  { 284,  333,  505},
  { 284,  505, 6821},
  { 331,  287,  375},
  { 377,  375,  287},
  { 287,  329,  377},
  { 417,  505,  333},
  { 420,  417,  335},
  { 416, 7050,  125},
  { 245,  379,  422},
  { 289,  381,  335},
  { 335,  472,  420},
  { 245,  421,  290},
  { 245,  422,  421},
  { 381,  292,  380},
  { 336,  382,  380},
  { 289,  292,  381},
  { 651,  336,  291},
  { 337,  292,  289},
  {5910, 6297,  338},
  {7489,  421,  210},
  { 338,  384, 5910},
  {5910,  384,  385},
  { 295,  424,  426},
  { 295,  426, 6478},
  { 428, 6479,  474},
  { 339,  298,  340},
  { 339,  340,  384},
  { 384,  340,  385},
  { 299, 7603,  385},
  {7603,  299,  341},
  {6479,  428,  251},
  { 429,  253,  344},
  { 475, 6910, 7009},
  { 258,  430,  341},
  { 433,  343,  301},
  { 343,  433,  435},
  { 258,  387,  432},
  { 475,  478,  301},
  { 301,  478,  433},
  { 521,  388,  305},
  {6655,  344,  386},
  { 436,  391,  437},
  { 308,  386,  344},
  { 386,  308,  436},
  { 391,  436,  308},
  { 345,  304,  389},
  { 390,  434,  303},
  { 303,  388,  390},
  { 308,  349,  391},
  { 347,  391,  349},
  { 348,  391,  347},
  { 392,  391,  348},
  { 391,  392,  438},
  { 349,  261,  347},
  { 348,  345,  392},
  { 345,  481,  392},
  { 309,  394,  310},
  { 309,  393,  394},
  { 394,  395,  310},
  { 394, 6241,  395},
  { 351,  397,  439},
  { 310,  395,  396},
  { 396,  399,  310},
  { 310,  399,  398},
  { 397,  483, 5781},
  { 356,  312,  398},
  { 399,  356,  398},
  { 312,  356,  444},
  { 357, 5915,  356},
  { 399,  442,  358},
  { 446,  358,  442},
  { 358,  446,  359},
  { 359,  446, 5911},
  { 406,  400,  317},
  { 317,  400, 5781},
  { 316,  265,  492},
  {6521,  274,  401},
  { 274, 5911, 6914},
  { 274, 6914,  401},
  { 316,  492,  361},
  { 406,  360,  453},
  { 362,  365,  407},
  {5917,  407,  365},
  { 361,  492,  635},
  { 276, 5908, 6317},
  {7315,  365,  362},
  { 455,  590,  276},
  { 408,  409,  410},
  { 368,  411,  548},
  { 462,  230,  371},
  { 278,  277,  547},
  { 413,  278,  547},
  {5919,  370,  464},
  { 370,  281,  464},
  { 278,  413,  372},
  { 371,  373,  414},
  { 281,  503,  464},
  { 373,  553,  414},
  { 373,  415,  553},
  { 372,  468,  329},
  {6282,  559,  415},
  { 325,  378,  330},
  {6282,  286,  559},
  { 125, 7050,  470},
  { 125,  470,  334},
  { 334,  470,  560},
  { 419,  335,  381},
  { 334,  560,  423},
  { 379,  423,  422},
  { 381,  681,  419},
  { 472,  335,  603},
  { 380,  382,  681},
  { 380,  681,  381},
  { 382,  336,  651},
  {5910,  385,  473},
  { 291, 6297,  651},
  { 426,  427, 6478},
  { 427, 7406, 6478},
  { 429, 6707,  252},
  { 429,  431, 6707},
  { 430,  432,  520},
  { 432,  430,  258},
  { 305, 5914,  521},
  { 432,  387,  434},
  { 434,  390,  524},
  { 434,  524,  432},
  { 524,  390,  388},
  { 524,  388,  521},
  { 389,  435,  571},
  {7106, 7107,  391},
  {7106,  391, 6503},
  { 391,  438, 6503},
  { 345,  389,  481},
  {6241,  394,  393},
  { 397,  482,  439},
  { 584,  396,  395},
  { 482,  397,  489},
  { 397,  351,  483},
  { 351,  350,  483},
  { 350,  353,  483},
  { 483,  353,  441},
  { 353,  352,  441},
  { 396,  484,  399},
  { 397,  440,  489},
  { 440,  397, 5781},
  { 483,  441, 5781},
  { 441,  486,  449},
  { 265,  312,  444},
  { 490,  440, 5781},
  { 441,  449, 5782},
  { 357,  313,  445},
  { 444,  314,  537},
  { 314,  315,  537},
  { 446,  539, 5911},
  { 360,  449,  447},
  { 360,  447,  453},
  { 449,  361,  447},
  { 405,  540,  448},
  { 447,  361,  453},
  { 403,  407, 5916},
  { 403, 5916, 6522},
  { 403,  402,  362},
  { 403,  362,  407},
  {5911,  455, 6596},
  {6911,  405,  494},
  {6397, 6399,  456},
  {6396, 5918,  452},
  { 405, 6398,  494},
  { 405,  448, 6398},
  { 406,  589,  400},
  { 450, 5912,  451},
  {6318, 6595, 6887},
  {6400,  458,  457},
  { 365,  454, 5917},
  {6317,  455,  276},
  {6398,  544,  363},
  { 363,  544,  364},
  { 459,  364,  544},
  { 544, 6676,  459},
  { 929,  495,  363},
  { 929,  363,  408},
  { 547,  364,  459},
  { 454,  367,  543},
  { 409,  366,  460},
  { 409,  460,  410},
  { 410,  460,  464},
  {5919,  547,  277},
  { 462,  371,  463},
  { 461,  496,  368},
  { 465,  548,  411},
  { 323,  590,  412},
  {7232,  463,  414},
  { 368,  639,  411},
  { 465,  497,  548},
  { 548,  497,  498},
  {7231, 7233,  466},
  { 414,  463,  371},
  { 413,  467,  372},
  { 372,  467,  468},
  { 503,  375,  557},
  { 375,  504,  557},
  { 375,  377,  504},
  { 329,  558,  507},
  { 378,  506,  416},
  { 469,  377,  329},
  { 509,  469,  329},
  { 329,  507,  509},
  { 505,  417,  420},
  { 377,  469,  508},
  { 416,  506, 7050},
  { 509,  510,  469},
  { 421,  422,  511},
  { 561,  471,  423},
  { 419,  681,  603},
  { 383, 6864,  651},
  {6873,  293,  421},
  { 424,  652,  426},
  { 427,  426,  652},
  { 428,  474,  608},
  { 344, 6655,  429},
  {7009,  608,  475},
  { 430, 6754,  341},
  { 520,  432,  612},
  { 477,  476,  429},
  { 570,  386,  436},
  { 436,  437, 7105},
  {6503, 6504, 7106},
  { 389,  571,  574},
  { 389,  574,  481},
  { 438,  392,  481},
  { 438,  481, 6503},
  {6241,  533,  395},
  { 395,  533,  584},
  {6241, 6613,  533},
  { 484,  396,  584},
  { 441,  352,  486},
  { 487,  486,  352},
  { 309,  487,  352},
  {6785,  487,  309},
  { 442,  399,  484},
  { 488,  534,  485},
  { 443,  488,  485},
  { 440,  490,  489},
  { 444,  491,  265},
  { 442,  539,  446},
  { 265,  491,  587},
  { 491,  444,  537},
  { 486, 6786,  449},
  { 265,  587,  492},
  {5781,  400,  490},
  { 493,  537,  315},
  {6409,  448,  540},
  { 490,  400,  588},
  { 315, 6521,  543},
  { 315,  543,  493},
  {5911,  539,  455},
  { 448, 6957, 6398},
  { 400,  589,  588},
  {5917,  454,  543},
  {6400,  457,  458},
  {6957,  544, 6398},
  { 492,  545,  635},
  {6398,  363,  495},
  {6398,  495,  494},
  { 361,  635,  453},
  { 637,  929,  408},
  { 637,  408,  410},
  { 364,  547,  366},
  { 547,  460,  366},
  { 275,  639,  461},
  { 464,  637,  410},
  { 275,  462,  639},
  { 547,  549,  413},
  { 462,  463,  551},
  { 368,  496,  639},
  { 590,  499,  412},
  {5920, 7234,  500},
  { 462,  502,  639},
  { 411,  639,  465},
  { 412,  499,  552},
  { 465,  639,  497},
  { 552, 7506,  325},
  { 325,  412,  552},
  { 414,  553, 7232},
  { 502,  462,  551},
  { 325, 7506,  506},
  { 559,  553,  415},
  { 554,  468,  467},
  { 599,  468,  554},
  { 468,  599,  329},
  { 325,  506,  378},
  { 329,  599,  600},
  { 329,  600,  558},
  { 286, 6821,  559},
  { 505,  420,  646},
  { 562,  508,  469},
  { 469,  510,  562},
  { 562,  509,  507},
  { 418, 7468,  470},
  { 562,  510,  509},
  { 420, 5794,  646},
  { 423,  560,  561},
  { 419,  603,  335},
  { 420,  472, 7595},
  { 423,  471,  512},
  { 513,  651, 6864},
  {7729,  513, 6864},
  { 473,  385, 7604},
  {7603, 7604,  385},
  {6873,  605, 6698},
  { 604,  516,  515},
  { 518, 6348, 6698},
  {6698, 6352,  518},
  { 515,  516,  517},
  { 516,  607,  517},
  {6755,  567,  566},
  { 429, 6702,  610},
  { 522,  524,  521},
  { 522,  523,  524},
  { 431,  429,  476},
  { 432,  524,  612},
  {6655,  386,  570},
  { 571,  435,  433},
  { 613,  476,  477},
  { 572,  476,  480},
  { 525,  480,  476},
  { 480,  525,  575},
  {7284,  481,  526},
  { 481,  574, 7712},
  { 476,  530,  527},
  { 526,  481, 7712},
  { 579,  532,  616},
  { 439,  482, 6240},
  { 482,  665, 6240},
  { 533,  586, 5933},
  { 533, 5933,  585},
  { 533,  585,  584},
  { 443,  485,  623},
  { 539,  484,  584},
  { 484,  539,  442},
  { 489,  490,  626},
  { 487, 6786,  486},
  { 540,  541, 6409},
  { 490,  588,  538},
  { 493, 7661,  537},
  { 406,  453,  589},
  { 590,  455,  539},
  {6676,  547,  459},
  { 547, 6676,  549},
  { 550,  548,  498},
  { 496,  461,  639},
  { 413,  549,  593},
  { 463, 7232,  551},
  { 467,  413,  593},
  { 499,  590,  552},
  { 497,  639,  498},
  { 498,  639,  550},
  { 464,  503,  594},
  { 555,  639,  502},
  { 596,  639,  555},
  { 706,  596,  555},
  { 467,  595,  554},
  { 502,  551,  555},
  { 503,  557,  556},
  {7505,  709,  506},
  { 504,  377,  642},
  { 377,  508,  642},
  {6821,  505,  646},
  { 561,  508,  562},
  { 561,  562,  471},
  { 422,  647, 6873},
  { 423,  512,  422},
  { 471,  562,  512},
  {7595,  472,  603},
  { 514, 6755,  566},
  { 513, 7729,  565},
  { 566,  565, 7729},
  {7729,  514,  566},
  { 516,  604,  564},
  { 564,  607,  516},
  { 651,  513,  565},
  {6698,  605, 6352},
  { 515,  569,  605},
  { 567,  563,  566},
  { 515,  517,  568},
  { 517,  607,  568},
  { 609,  425,  430},
  { 612,  430,  520},
  { 524,  522,  523},
  { 522,  524,  521},
  { 476,  572,  431},
  { 521, 5913, 5922},
  { 429,  610,  477},
  { 475,  658,  478},
  { 610,  613,  477},
  { 571,  725,  574},
  { 530,  476,  613},
  { 436,  479,  529},
  { 479, 7562,  529},
  { 570,  436,  529},
  { 572,  480,  573},
  { 480,  575,  573},
  { 476,  575,  525},
  { 530,  570,  531},
  { 578,  531,  570},
  { 528,  578,  570},
  { 570,  529,  528},
  { 528,  529, 7562},
  { 574, 7456, 7712},
  {6972, 7712, 7456},
  { 614,  578,  528},
  { 528, 7285,  614},
  { 576,  577, 7285},
  { 581,  582,  617},
  { 581,  583,  582},
  {5924,  583,  581},
  { 482,  626,  665},
  { 482,  489,  626},
  {6613,  666,  533},
  { 586,  533,  666},
  { 623,  485,  624},
  { 584,  625,  539},
  { 443,  623,  627},
  { 490,  538,  626},
  {7661,  491,  537},
  { 538,  588,  631},
  { 633,  589,  453},
  { 590,  539,  632},
  {6957,  630,  544},
  { 634,  545,  492},
  { 543, 7661,  493},
  { 495,  703,  494},
  {6676,  636,  546},
  { 543,  367, 7661},
  { 637,  464,  594},
  { 549, 6676,  591},
  { 591,  671,  592},
  { 549,  591,  672},
  { 549,  672,  593},
  { 591,  592,  672},
  {7232,  553,  551},
  { 639,  596,  597},
  { 552, 7502, 7506},
  { 501, 7505,  506},
  { 595,  598,  554},
  { 553,  559,  640},
  { 554,  598,  599},
  { 504,  556,  557},
  { 558,  600,  601},
  { 600,  599,  601},
  { 507,  558,  601},
  {6821,  646,  559},
  { 506,  709, 7050},
  { 508,  560,  642},
  {7050,  709,  711},
  {7050,  711,  602},
  { 508,  561,  560},
  { 507,  601,  562},
  { 646, 5794,  746},
  { 602,  747, 7050},
  {7050,  747, 7049},
  { 470, 7468,  560},
  {5794,  680,  746},
  { 422, 6873,  511},
  { 647,  422,  512},
  { 511, 6873,  421},
  { 651,  648,  382},
  { 607,  564,  649},
  { 649,  564,  604},
  { 649,  604,  650},
  { 566,  563,  684},
  { 605,  716,  515},
  { 515,  716,  604},
  { 649, 7283,  607},
  { 566,  606,  565},
  { 569, 6352,  605},
  { 567,  609, 7432},
  { 515,  568,  569},
  { 569,  608,  474},
  { 425,  609,  567},
  { 430,  612,  689},
  { 430,  689,  609},
  { 720,  475,  608},
  {6702, 6704,  610},
  { 519, 6656, 6703},
  { 524,  521, 7169},
  { 521, 5922, 7169},
  { 610, 6704,  570},
  { 611, 6655,  570},
  { 478,  658,  433},
  { 433, 7481,  571},
  { 610,  530,  613},
  { 610,  570,  530},
  { 524,  573,  690},
  { 574,  725, 7457},
  { 575,  690,  573},
  { 476,  527,  575},
  { 759,  527,  530},
  {7285, 6413,  614},
  { 530,  531,  759},
  { 531,  578,  759},
  {7285,  577, 6413},
  { 577, 5795, 6413},
  { 617,  615,  581},
  { 615,  616,  581},
  { 615,  659,  616},
  {5791,  661,  580},
  {5791,  660,  661},
  { 580,  661,  618},
  { 532, 5790,  619},
  { 580,  618,  619},
  { 532,  619,  663},
  { 581,  664,  620},
  { 623,  624,  622},
  { 622,  700,  623},
  { 701,  584,  585},
  {5933,  701,  585},
  { 586,  699, 5933},
  { 485,  534,  624},
  { 534,  535,  624},
  { 702,  627,  623},
  { 625,  628,  539},
  { 539,  628,  629},
  { 815,  631,  588},
  { 631,  738,  538},
  { 538,  738,  669},
  { 492,  587,  634},
  { 633,  453,  704},
  { 453,  635,  704},
  { 544,  783, 6676},
  { 588,  589,  741},
  { 495,  929,  703},
  {6676,  783,  636},
  { 705, 7661,  367},
  { 546,  636,  591},
  { 546,  591, 6676},
  { 705,  367,  548},
  { 705,  548,  550},
  { 591,  670,  671},
  { 637,  594,  638},
  { 593,  672,  467},
  { 671,  672,  592},
  { 639,  675,  550},
  { 597,  675,  639},
  {6427,  674,  595},
  { 594,  503,  556},
  { 596,  706,  597},
  { 640,  559,  677},
  { 551,  553,  555},
  { 597,  706,  790},
  { 556,  504,  676},
  { 559,  644,  677},
  { 512,  601,  679},
  {7048,  643,  645},
  { 601,  512,  562},
  { 647,  512,  682},
  { 648,  651,  683},
  { 684,  685,  566},
  { 684,  563,  653},
  { 651,  565,  654},
  { 568,  607, 7480},
  { 654,  565,  606},
  {7480,  656,  568},
  { 609,  657, 7432},
  { 655, 7432,  657},
  { 656,  608,  569},
  { 568,  656,  569},
  { 689,  687,  609},
  { 609,  687,  657},
  { 688,  655,  657},
  { 658,  475,  720},
  { 612,  524,  689},
  { 524,  690,  689},
  { 693,  614, 6418},
  { 693, 6418,  722},
  { 527,  758,  692},
  { 759,  578,  614},
  { 759,  614,  693},
  { 614, 6413, 6418},
  { 690,  575,  527},
  { 527,  759,  758},
  { 662,  615,  617},
  { 615,  662,  659},
  { 659,  772,  616},
  { 728,  616,  772},
  { 616,  728,  579},
  { 661,  697,  618},
  { 696,  618,  697},
  { 664,  581,  616},
  { 766,  579,  728},
  { 618,  696,  619},
  { 532,  663,  616},
  { 582,  665,  617},
  { 617,  665,  662},
  { 620,  664,  621},
  { 665,  626,  662},
  { 621,  664, 6800},
  { 700,  622,  624},
  { 666,  699,  586},
  { 584,  701,  625},
  { 702,  668,  627},
  { 776,  628,  625},
  { 538,  781,  626},
  { 629,  628,  776},
  { 627, 5925, 7340},
  { 627,  668,  736},
  { 627,  736, 5925},
  { 629,  776,  539},
  { 539,  776,  632},
  { 630,  783,  544},
  { 632,  784,  590},
  { 929,  782,  703},
  { 741,  815,  588},
  { 545,  786,  635},
  { 929,  637,  638},
  { 783,  591,  636},
  { 467,  672,  744},
  {6427, 6428,  674},
  { 675,  597,  790},
  { 594,  556,  827},
  { 676,  827,  556},
  { 595,  674,  598},
  { 640,  677,  553},
  { 553,  677,  555},
  { 598,  707,  599},
  { 504,  678,  676},
  { 504,  642,  678},
  { 679,  599,  708},
  { 679,  601,  599},
  { 644,  710,  677},
  { 559,  646,  791},
  { 646,  792,  791},
  { 681,  648, 7135},
  { 648,  681,  382},
  { 714,  603,  713},
  {7496,  603,  714},
  { 647,  682, 6873},
  {7496, 7595,  603},
  { 604,  716,  650},
  { 840,  606,  566},
  { 566,  685,  840},
  { 654,  839,  651},
  {7432,  655,  686},
  { 607,  717,  719},
  {7480,  607,  718},
  { 607,  719,  718},
  { 687,  721,  657},
  { 658, 7481,  433},
  { 692,  691,  690},
  { 690,  527,  692},
  { 722, 6418,  723},
  {7237, 7238,  694},
  { 660,  695,  661},
  { 579,  766,  660},
  { 619,  696,  727},
  { 698,  616,  663},
  { 664,  616,  698},
  { 663,  853,  698},
  { 623,  700,  732},
  { 623,  732,  733},
  { 623,  733,  702},
  { 781,  538,  669},
  { 631,  815,  738},
  { 587,  814,  634},
  {7660, 7661,  820},
  { 788,  633,  704},
  { 589,  633,  741},
  { 740,  590,  784},
  { 705,  550,  820},
  { 552,  590,  740},
  { 670,  901,  671},
  { 467,  744,  673},
  { 674,  707,  598},
  { 599,  707,  708},
  { 676,  678, 7051},
  { 678,  642, 7046},
  { 710,  745,  677},
  { 745,  710,  644},
  { 831,  644,  559},
  { 791,  831,  559},
  { 646,  746,  792},
  {7049,  747, 7047},
  { 833,  712,  650},
  { 712,  793,  650},
  { 649,  650,  793},
  { 683,  651,  834},
  { 750,  650,  716},
  {7282, 7283,  649},
  { 795,  834,  651},
  { 751,  716,  605},
  { 605, 6873,  751},
  {7429, 7430,  946},
  { 654,  606,  839},
  { 608,  656,  752},
  { 656, 7480,  752},
  {7480,  718,  754},
  { 720,  752,  658},
  { 721,  687,  689},
  { 657,  721,  688},
  { 874,  688,  721},
  {7481,  801,  571},
  { 690,  721,  689},
  { 693,  722,  756},
  { 724,  759,  693},
  {6982,  724,  693},
  { 758,  691,  692},
  { 724, 7450,  759},
  {6418, 7236,  723},
  {7235,  725,  726},
  { 759,  845,  758},
  { 695,  660,  766},
  { 695,  806,  661},
  { 661,  806,  697},
  { 804,  697,  806},
  { 697,  804,  696},
  { 696,  851,  727},
  { 659,  662,  772},
  { 772,  953,  728},
  { 619,  918,  663},
  { 918,  853,  663},
  { 730,  731, 6551},
  { 729, 6553,  730},
  { 774,  731,  730},
  { 699, 5927,  698},
  { 731,  774,  807},
  {5927,  699,  666},
  { 700, 6365,  732},
  {6365,  700,  624},
  { 734,  701, 5933},
  { 702,  733,  668},
  { 733, 6917,  668},
  { 776,  625,  701},
  { 626,  781, 7705},
  { 736,  668,  739},
  { 736,  739,  778},
  { 669,  738,  781},
  { 818,  778,  739},
  { 632,  776,  784},
  { 634,  814,  545},
  {7661,  705,  820},
  { 704,  635,  817},
  { 545,  814,  822},
  { 788,  704,  817},
  { 635,  786,  819},
  { 740,  784,  963},
  { 788,  742,  633},
  { 783,  787,  591},
  { 741,  633,  742},
  { 591,  787,  901},
  { 591,  901,  670},
  { 671,  901,  743},
  { 827,  638,  594},
  { 789,  744,  672},
  { 743,  789,  672},
  { 672,  671,  743},
  {6428, 7329,  674},
  { 675,  790,  550},
  {7504,  709,  641},
  { 830,  708,  707},
  { 828,  676, 6636},
  { 676, 7051, 6636},
  { 644,  831,  745},
  { 906,  831,  791},
  { 679,  833,  512},
  { 679,  748,  749},
  { 711, 6636,  602},
  { 602, 6636,  747},
  { 793,  712,  749},
  { 749,  748,  793},
  { 833,  650,  750},
  { 682,  751, 6873},
  { 717,  715,  796},
  {7428,  685,  684},
  {7428, 7429,  946},
  { 717,  799,  719},
  { 608,  752,  720},
  { 754,  719,  799},
  { 718,  719,  754},
  { 686,  874,  753},
  { 688,  874,  655},
  { 655,  874,  686},
  { 870,  658,  752},
  { 693,  756, 6982},
  { 722,  723, 1015},
  { 571,  801,  725},
  { 691,  758,  755},
  { 875,  800,  723},
  { 723, 7236,  875},
  { 726,  875, 7236},
  { 760,  762,  763},
  { 760,  763,  761},
  { 763,  762,  765},
  { 765,  762,  766},
  { 762,  764,  766},
  { 768,  767,  803},
  { 766,  764,  695},
  { 764,  805,  695},
  { 767,  768,  771},
  { 695,  805,  806},
  { 696,  804,  769},
  { 769,  804,  770},
  { 851,  619, 5930},
  { 696,  769,  851},
  {6553, 7610,  730},
  {6553, 7609, 7610},
  { 698,  853,  699},
  { 662,  626,  882},
  {7198,  732,  854},
  { 734,  776,  701},
  { 624, 6536,  858},
  { 624,  858,  811},
  { 668, 6917,  889},
  { 778, 5925,  736},
  { 668,  735,  779},
  { 668,  779,  739},
  { 737,  777, 7230},
  { 784,  776,  928},
  { 780,  737, 7230},
  { 783, 5925,  813},
  { 860,  739,  779},
  { 738,  815,  894},
  { 738,  894, 7229},
  { 778,  818,  896},
  { 739,  860,  818},
  { 860,  931,  818},
  { 815,  741,  785},
  { 824,  929,  638},
  { 786,  545,  822},
  { 741,  742,  861},
  { 787,  898,  901},
  { 638,  827,  824},
  { 743,  901,  789},
  { 742,  788,  826},
  {7062,  707,  674},
  { 905,  706,  555},
  { 555,  677,  905},
  { 831,  906,  745},
  { 709,  829,  711},
  { 711,  829,  832},
  { 832, 6636,  711},
  { 679,  749,  712},
  { 793,  794,  649},
  { 649,  794,  835},
  {7134, 7353, 7497},
  {7135, 1149,  681},
  { 681, 1149,  603},
  { 512,  751,  682},
  { 649,  835,  836},
  { 716,  751,  833},
  { 833,  750,  716},
  { 649,  836, 7282},
  { 512,  833,  751},
  {5934, 7266,  837},
  { 795,  651,  798},
  { 798,  651,  839},
  {7430, 7431,  946},
  { 717,  796,  799},
  { 839,  606,  840},
  { 869,  753,  874},
  { 691,  841,  690},
  {7301, 6983, 6984},
  { 841,  909,  690},
  { 723,  800, 1015},
  { 755,  758,  844},
  { 758,  802,  844},
  { 759, 7450,  846},
  { 759,  846,  845},
  {6985,  758,  845},
  { 760,  914,  762},
  { 765,  848,  763},
  { 767,  771,  850},
  { 768, 5936,  771},
  { 769,  770,  851},
  {1119,  772,  662},
  { 953,  772, 1119},
  { 662,  988, 1119},
  {5935,  773,  852},
  { 773, 6552,  731},
  { 730, 7610,  774},
  {6908,  699,  853},
  { 774,  887,  807},
  { 775, 5931, 5937},
  {7198,  889,  808},
  {6917, 6918,  889},
  { 808,  889,  809},
  {6365,  624,  810},
  { 811,  810,  624},
  {6365,  810,  856},
  {7705,  781,  812},
  { 859, 7096, 7097},
  { 668,  889,  735},
  { 858, 6536, 6891},
  { 778,  813, 5925},
  { 777,  780, 7230},
  { 781,  738, 7229},
  { 963,  784, 7354},
  { 783,  813,  896},
  {5932,  820,  895},
  { 931,  821,  818},
  { 817,  635,  819},
  { 821,  896,  818},
  { 899,  785,  741},
  { 785,  899,  816},
  { 823,  740,  963},
  { 741,  861,  899},
  { 820,  550,  825},
  { 740,  823,  552},
  { 934,  552,  900},
  { 901,  864,  789},
  { 552,  934, 7502},
  { 744,  789,  864},
  { 788,  862,  826},
  { 550,  790,  825},
  { 790,  939,  825},
  {7504,  829,  709},
  { 828, 6636,  832},
  { 830,  707, 6350},
  { 679,  708,  830},
  { 745,  906,  677},
  { 905,  677,  906},
  { 791,  792,  941},
  { 833,  679,  712},
  { 867,  793,  748},
  { 794,  793,  867},
  { 867,  835,  794},
  {1189, 7496,  714},
  {7266, 7305,  837},
  { 795,  798, 7115},
  { 685, 7428,  946},
  { 799,  796,  945},
  { 799,  945,  754},
  { 869,  874,  871},
  { 841,  691,  755},
  { 757,  722,  873},
  { 722, 1015,  873},
  { 721,  690, 7465},
  {6395, 6394,  843},
  { 801,  842,  725},
  { 690,  909, 7465},
  { 845, 6778, 6985},
  { 875,  725,  913},
  { 726,  725,  875},
  { 845,  846,  910},
  {7450,  876,  846},
  { 914, 5796,  762},
  { 762,  915,  764},
  { 878,  847,  877},
  { 847,  878,  879},
  { 766,  848,  765},
  { 879,  767,  847},
  { 767,  879,  803},
  { 804,  849,  770},
  {7646,  767,  850},
  { 805,  881,  806},
  { 804,  806,  881},
  {7610,  768,  803},
  { 918,  619,  851},
  { 771, 5936,  850},
  {5936,  768, 7610},
  { 773,  731,  852},
  {7610, 1119,  774},
  { 990,  774, 1119},
  { 774,  990,  887},
  {7705,  922,  882},
  { 889, 7198,  854},
  { 888,  731,  807},
  { 807,  887,  855},
  { 626, 7705,  882},
  {1044,  888,  807},
  {5933,  853,  924},
  { 807,  855, 1044},
  { 776,  734, 1046},
  {7705,  812, 7023},
  { 856,  810,  890},
  { 811,  858, 7608},
  { 811, 7608,  810},
  { 892,  735,  889},
  { 858, 6891, 7608},
  { 777,  737,  780},
  { 735,  892,  779},
  { 860,  779,  892},
  { 928, 7354,  784},
  {7229,  894,  893},
  { 813,  778,  896},
  { 814, 5932,  895},
  { 785,  816,  894},
  { 899,  894,  816},
  { 814,  895,  822},
  { 787,  783,  898},
  { 817,  819,  788},
  { 819,  786,  897},
  { 786,  822,  897},
  { 788,  819,  862},
  { 823,  900,  552},
  { 861,  742,  863},
  { 862,  933,  902},
  { 827,  935,  824},
  { 863,  742,  903},
  { 826,  903,  742},
  { 826,  862,  902},
  { 864,  938,  744},
  { 707, 7063,  866},
  { 827,  676,  828},
  { 827,  828,  904},
  { 706,  905,  790},
  { 828,  832, 7502},
  { 832,  829, 7503},
  {6350,  707,  866},
  { 679,  867,  748},
  { 679,  830,  867},
  { 746,  941,  792},
  {1149,  975,  603},
  { 834,  795,  977},
  { 798,  943, 7115},
  {7446, 7464,  942},
  { 754,  949, 7480},
  { 840,  685,  946},
  {7481,  949,  801},
  { 755,  908,  841},
  { 872,  755, 7075},
  { 801,  949,  842},
  { 841,  908,  909},
  { 755,  844, 7075},
  {7450, 7451, 1019},
  { 843, 6394, 6395},
  {7450, 1019,  911},
  {7450,  911,  876},
  { 761,  763,  914},
  { 848,  914,  763},
  { 915,  917,  764},
  { 877,  847, 7646},
  { 915, 1024,  917},
  { 804,  881,  916},
  { 766,  728,  953},
  { 764,  917,  881},
  { 764,  881,  805},
  { 849,  851,  770},
  {7646,  850, 6781},
  { 803,  879,  985},
  { 803,  985, 7610},
  { 850, 5936,  987},
  {5936, 5938,  987},
  {1119, 7610,  985},
  { 988,  662,  882},
  { 988,  882,  989},
  { 731, 1041,  852},
  { 922,  989,  882},
  { 885,  884,  883},
  { 731,  888, 1041},
  { 884,  885,  886},
  { 855,  887,  926},
  { 926, 1044,  855},
  {5933,  924,  734},
  { 854,  732, 7586},
  { 734,  924, 1046},
  { 856,  890, 6572},
  { 890,  810, 7608},
  {1087,  857,  732},
  { 928,  776, 1046},
  {7096,  859, 7097},
  {7022, 1044,  891},
  {6891, 6892, 7608},
  {1086, 7673,  781},
  { 997, 7673, 1086},
  {1086,  781, 7229},
  { 815,  785,  894},
  { 860, 6372,  931},
  { 899,  930,  894},
  { 896,  898,  783},
  { 896,  821,  961},
  { 931,  961,  821},
  { 819,  897,  862},
  { 862,  897,  822},
  { 825, 1093,  820},
  { 824,  934,  963},
  { 862,  822,  933},
  { 863,  966,  861},
  { 898,  965,  901},
  { 937,  864,  901},
  { 903,  966,  863},
  { 826,  902,  967},
  { 936,  902,  933},
  { 903,  826,  967},
  {7502,  934,  935},
  {7502,  935,  904},
  { 707, 7062, 7063},
  { 938,  865,  744},
  { 825,  939,  969},
  {7063, 1006,  866},
  { 828, 7502,  904},
  { 866, 1006,  970},
  { 866,  970, 6350},
  { 830, 6350,  867},
  { 791,  941,  906},
  { 835,  867, 6350},
  { 603,  975,  713},
  { 713,  975,  714},
  { 907,  977,  795},
  { 838,  797, 1072},
  { 976, 1072,  797},
  { 797,  837,  976},
  { 837, 7305,  976},
  { 839,  943,  798},
  { 942, 7464,  944},
  { 949,  754,  945},
  { 839,  840,  943},
  { 840,  978,  943},
  { 944, 7464, 7465},
  { 755,  872,  908},
  { 949,  980,  842},
  { 875, 1015,  800},
  {6778,  910,  951},
  {6778,  845,  910},
  { 910,  912,  951},
  { 951,  912,  876},
  { 951,  876,  981},
  { 910,  846,  912},
  { 912,  846,  876},
  {7648,  877, 7646},
  { 914,  848, 1025},
  { 848,  766,  953},
  { 848,  953, 1025},
  {1026,  917, 1024},
  { 767, 7646,  847},
  { 917,  916,  881},
  { 804, 7385,  849},
  { 804,  916, 7385},
  { 918,  851,  984},
  { 919,  920, 1034},
  { 919, 1034, 5941},
  { 920,  885,  883},
  { 920,  921,  885},
  { 920,  919,  921},
  { 920,  883, 1082},
  {1082,  883,  884},
  {7491,  886,  885},
  { 885,  921, 7491},
  { 884,  886,  923},
  { 993,  922, 7705},
  { 926,  887,  925},
  { 854, 7586,  889},
  { 732,  857,  958},
  { 857, 1087,  958},
  {7021,  997, 1044},
  {7229,  893, 1130},
  {6372,  860,  892},
  { 894,  930, 1130},
  {7354, 1047,  963},
  { 898,  896, 1048},
  { 931,  962,  961},
  { 929,  824,  932},
  {1047,  932,  824},
  { 822,  895, 1050},
  { 822, 1050,  933},
  { 824,  963, 1047},
  { 823,  963,  900},
  { 898, 1048,  965},
  { 933, 1050,  964},
  { 861,  966, 1097},
  { 861, 1097, 1095},
  { 934,  824,  935},
  { 938,  864,  937},
  { 935,  827,  904},
  { 790,  905,  939},
  { 971,  905,  906},
  {6350,  970, 1009},
  { 971,  906,  940},
  { 906,  941, 6960},
  { 835,  974,  836},
  { 834, 1071, 1149},
  { 714,  975, 1189},
  { 868,  838, 1013},
  {6940, 5945, 5939},
  { 943,  978, 7115},
  {7076, 7175,  872},
  { 872, 7175,  908},
  {7076,  872, 7075},
  {1016,  842,  980},
  { 842, 1016,  950},
  { 725,  842,  950},
  {7075,  844, 6776},
  { 951, 6777, 6778},
  { 725, 1114,  913},
  { 981,  876,  911},
  { 911, 1019,  981},
  { 952,  982,  914},
  { 914,  982, 1021},
  {1021,  915, 5796},
  { 878,  877, 1025},
  { 878, 1025,  879},
  { 879, 1025,  985},
  { 953, 1075, 1025},
  { 916,  917, 1027},
  { 849, 5941,  984},
  { 849,  984,  851},
  {7385,  916, 1032},
  {5946,  918,  984},
  {6781,  850, 1036},
  { 987, 1036,  850},
  { 918, 5946, 5942},
  { 956,  954, 7385},
  {7385, 1032,  956},
  {1119, 1075,  953},
  { 957,  919,  956},
  { 919, 5941,  956},
  { 853,  918, 6907},
  {5938, 7044,  987},
  { 852, 1040, 1038},
  { 990,  925,  887},
  { 888, 1044, 1043},
  {1044,  926,  925},
  { 958, 7586,  732},
  {1044,  927,  891},
  {1087, 7426,  958},
  { 889,  995,  892},
  {7608, 6892, 7355},
  { 894, 1130,  893},
  {1130,  930,  960},
  { 929,  932, 1047},
  {1001,  962,  931},
  {1093,  895,  820},
  { 934,  900,  963},
  { 967,  902, 1096},
  { 902,  936, 1096},
  { 936,  933,  964},
  { 967, 5943,  903},
  { 966,  903, 5943},
  {1006,  865,  938},
  {1100,  905, 1008},
  { 905, 1100,  939},
  {1008,  905, 1105},
  { 905,  971, 1105},
  { 941,  746, 1146},
  {6960, 7338,  906},
  { 746,  680, 1064},
  {6960,  941, 1146},
  {1068, 1064,  680},
  {1010,  940,  972},
  {6350,  973,  835},
  { 835,  973,  974},
  { 974, 1011,  836},
  {1149, 1189,  975},
  { 834,  977, 1071},
  { 838, 1072, 1013},
  {7431, 7447, 1369},
  { 942,  944, 6454},
  {7324, 1152, 7259},
  {7115,  978, 6872},
  { 979, 6872,  978},
  {1153,  945,  796},
  { 978,  840,  979},
  { 946,  979,  840},
  { 945, 1153,  948},
  {1014,  948, 1153},
  {1114, 1016,  945},
  {7451, 1015, 1288},
  {7465,  909, 7463},
  {7463,  909,  908},
  {7463,  908, 7175},
  {7451, 1288, 1019},
  {1015,  875, 1112},
  { 951,  981, 6777},
  { 875,  913, 1157},
  { 913, 1018, 1157},
  { 913, 1114, 1158},
  { 913, 1158, 1018},
  { 877, 5798, 1025},
  { 916, 1027, 1028},
  { 916, 1028, 1029},
  { 916, 1029, 1032},
  {5954,  983,  880},
  { 957,  956, 1032},
  { 918,  955,  986},
  { 918,  986, 6907},
  {1033, 1034,  920},
  {1082, 1033,  920},
  { 924,  853, 6907},
  {1041, 1040,  852},
  { 990,  991,  925},
  {7491,  921,  992},
  { 888, 1043, 1041},
  { 925,  991,  993},
  {6279, 6573, 1124},
  {1127, 5940,  992},
  { 925,  993, 7705},
  { 925,  927, 1044},
  {6573, 1045, 1124},
  {6365, 6366,  732},
  { 958, 7426, 7586},
  {6805, 5949,  994},
  { 732, 6366, 1087},
  { 995,  996,  892},
  { 892,  996,  998},
  { 892,  998,  999},
  { 928, 1046, 7354},
  { 892,  999, 6372},
  {1000, 6372,  999},
  { 896, 1088, 1048},
  { 896, 1090, 1088},
  {6372, 1001,  931},
  {6372, 1000, 1001},
  { 960, 1089, 1130},
  { 896,  961, 1090},
  {1091,  962, 1001},
  { 961,  962, 1090},
  { 962, 1049, 1090},
  { 895, 1093, 1050},
  { 962, 1091, 1049},
  { 861, 1095,  899},
  {6538,  964, 1050},
  {1048, 1131,  965},
  {1096,  936,  964},
  { 967, 1096, 1053},
  { 965,  937,  901},
  {1098, 1097,  966},
  {1002, 1093,  825},
  { 937,  965, 1054},
  {7730,  966, 7622},
  {1054,  938,  937},
  { 825,  969, 1002},
  {1006,  938, 1057},
  {1004, 1007, 7730},
  {5944, 1006, 1005},
  {5944, 1005, 1006},
  {1006, 1057,  970},
  {1057, 1009,  970},
  {1004, 1003, 1102},
  {1004, 1102, 1007},
  {1008, 1056, 1100},
  {1100,  969,  939},
  {1140, 1010,  972},
  { 971, 1065, 1105},
  {1146,  746, 1064},
  { 971,  940, 1010},
  { 971, 1010, 1065},
  { 942, 6454, 1150},
  { 977,  907, 1108},
  {1109, 7431, 1369},
  {7431, 1109,  946},
  {7324, 1013, 1152},
  {7259, 1152,  796},
  { 796, 1152, 1153},
  { 944, 7465, 7463},
  { 947, 1196, 1017},
  { 980,  949,  945},
  { 945, 1016,  980},
  { 950, 1016, 1114},
  { 950, 1114,  725},
  {1019, 1288, 1073},
  { 981, 1019, 1073},
  {1020, 1074, 1022},
  {1074,  952, 1022},
  {1020, 1022, 1023},
  { 915, 1021, 7699},
  {1022,  952, 1025},
  {1022, 1025, 1023},
  { 952,  914, 1025},
  { 880,  983, 1020},
  {1025, 1075,  985},
  {1031, 1026, 5948},
  {1116,  917, 1026},
  { 917, 1116, 1027},
  {1077,  985, 1075},
  {1031, 1116, 1026},
  {1030,  983, 5954},
  { 984, 5941, 1033},
  {1034, 1033, 5941},
  {1032, 1079,  957},
  {1035, 1116, 1032},
  { 957, 1079, 1037},
  {6907,  986, 6324},
  { 984, 1033, 1082},
  { 987, 7044, 7045},
  {1167,  919,  957},
  {1083,  957, 1037},
  {1123, 1039, 6907},
  {6907, 1039,  924},
  { 919, 1125,  921},
  { 921, 1125, 1042},
  { 990,  922,  991},
  { 993,  991,  922},
  { 921, 1042,  992},
  {6954, 6279, 1124},
  { 924, 6956, 1046},
  { 992, 1042, 1127},
  {1043, 1044, 1084},
  {1043, 1084, 1041},
  { 997, 1086, 1044},
  { 959,  929, 1047},
  {1090, 1049, 1133},
  {1049, 1091, 1051},
  {7310, 1096,  964},
  { 968, 1053, 1003},
  {1093, 1002, 1178},
  {1131, 1054,  965},
  { 938, 1054, 1057},
  {1003, 1137, 1055},
  {1003, 1055, 1102},
  {1058, 1059, 1063},
  {1058, 1101, 1059},
  {1059, 1060, 1062},
  {1059, 1062, 1063},
  {1060, 1059, 1061},
  {1104, 1008, 1105},
  {1066, 1060, 1061},
  {1010, 1140, 1104},
  {1062, 1060, 1066},
  {6960, 1146, 5950},
  {6350, 1069,  973},
  { 974,  973, 1106},
  {1106, 1066,  974},
  {1011,  974, 1066},
  {1070, 1011, 1066},
  {1066, 1067, 1070},
  {7496, 1189, 7476},
  {1011, 1070,  836},
  { 976, 7305, 1070},
  {1070, 1107,  976},
  {1071,  977, 1108},
  {7447,  942, 1369},
  {5947, 6872, 1239},
  {6872,  979, 1239},
  { 948, 1114,  945},
  {1242, 1017, 1196},
  { 952, 1074, 1021},
  { 952, 1021,  982},
  {1020, 1115, 1161},
  {1020,  983, 1115},
  {7433, 1162, 1031},
  {1115,  983, 1076},
  {1076,  983, 1030},
  {1027, 1116, 1028},
  {1035, 1029, 1028},
  {1075, 1119, 1077},
  {1028, 1116, 1035},
  {1029, 1035, 1032},
  {1076, 1030, 5954},
  {1162, 1117, 1031},
  {1116, 1031, 1118},
  {1078, 1116, 1081},
  {1119,  985, 1077},
  {1032, 1116, 1078},
  {1032, 1163, 1080},
  {1032, 1080, 1079},
  { 987, 7045, 1036},
  { 988,  989,  990},
  {1038, 1040, 1121},
  { 990, 1119,  988},
  { 990,  989,  922},
  {6907, 7398, 1123},
  {1082,  884, 1122},
  {6953, 6955,  923},
  { 884, 6955, 1122},
  { 884,  923, 6955},
  {1167, 1125,  919},
  { 957, 1083, 1167},
  {1041, 1126, 1040},
  {1042, 1125, 1127},
  {1044, 1086, 1085},
  { 889, 7586,  995},
  { 995, 7586,  996},
  {1085, 1086, 7229},
  {1128,  999, 1301},
  {1130, 1169, 7229},
  {1085, 7229, 1169},
  {1046, 1045, 7354},
  { 999, 1128, 1000},
  {1268, 1000, 1128},
  {1001, 1000, 1268},
  {1001, 1132, 1091},
  {1092, 1050, 1093},
  { 899, 1094,  930},
  { 930, 1094,  960},
  {1050, 1092, 6538},
  {1095, 1094,  899},
  { 964, 6782, 7310},
  {1053, 1096, 1099},
  {1131, 1136, 1054},
  {1053, 1099, 1003},
  { 966, 7730, 1098},
  {1003, 1099, 1137},
  {1184, 1098, 7730},
  {1100, 1002,  969},
  {1100, 1181, 1002},
  {1178, 1002, 1181},
  {1138, 1101, 1103},
  {1138, 1179, 1101},
  {1184, 7730, 1007},
  {1058, 1103, 1101},
  {1182, 1059, 1101},
  {1139, 1184, 1007},
  {1055, 1137, 1102},
  {1056, 1008, 1140},
  {1228, 1009, 1057},
  {1061, 1059, 1182},
  {1007, 1102, 1139},
  {1140, 1008, 1104},
  {1105, 1010, 1104},
  {1064, 7018, 6376},
  {1063, 1062, 1066},
  {1064, 6376, 1146},
  {1058, 1069, 6350},
  {1058, 6350, 1144},
  {1058, 1063, 1066},
  {1066, 1061, 1067},
  {1105, 1065, 1010},
  {1064, 1068, 7018},
  {1058, 1066, 1106},
  {6350, 1009, 1144},
  {1058, 1106,  973},
  {1058,  973, 1069},
  {1151, 1013, 1148},
  {1188, 1148, 1013},
  { 976, 1107, 1072},
  {1012, 7490,  907},
  {6454,  944, 1191},
  {1014, 1153, 7333},
  {7333, 1194, 1014},
  { 948, 1014, 1114},
  {1014, 1194, 1114},
  {1156, 1112,  875},
  { 875, 1157, 1156},
  {1158, 1157, 1018},
  {1247,  981, 1073},
  {1020, 1160, 1074},
  {1020, 1161, 1160},
  {1021, 1074, 1160},
  {1021, 1207, 7699},
  {6781, 1036, 1120},
  {1081, 1116, 1118},
  {1080, 1163, 1079},
  {1079, 1163, 1037},
  {1078, 1164, 1032},
  {1163, 1032, 1164},
  {1040, 1126, 1166},
  {1041, 1168, 1126},
  {1084, 1044, 1169},
  {1084, 1169, 1041},
  {1124, 1045, 1046},
  {1044, 1085, 1169},
  {1170, 1087, 6366},
  {1130, 1172, 1169},
  {1170, 6468, 1087},
  {1129,  996, 1219},
  { 996, 1129,  998},
  { 999,  998, 1129},
  {1089, 1315, 1130},
  {1001, 1173, 1132},
  {1088, 1090, 1222},
  {1223, 1091, 1132},
  {1089,  960, 1316},
  {1223, 1134, 1091},
  { 960, 1318, 1316},
  {1093, 1178, 1092},
  {1134, 1051, 1091},
  {1094, 1318,  960},
  {1092, 1178, 6538},
  {1049, 1051, 1134},
  {1049, 1134, 1135},
  {1049, 1135, 1133},
  {7310, 6782, 7309},
  {1095, 1097, 1175},
  {1131, 1176, 1136},
  {6835, 1175, 1097},
  {1137, 1096, 1052},
  {1097, 1098, 6835},
  {1184, 6835, 1098},
  {1362, 6835, 1184},
  {1137, 1099, 1096},
  {1181, 1359, 1178},
  {1054, 1228, 1057},
  {1056, 1140, 1100},
  {1101, 1179, 1182},
  {1103, 1144, 1138},
  {1061, 1182, 6586},
  {1182, 1183, 6586},
  {1141, 6586, 1183},
  {1142, 6586, 1141},
  {1142, 6584, 6586},
  {1144, 1185, 1138},
  {1144, 1103, 1058},
  {1061, 5952, 1186},
  {1061, 1143, 5952},
  {1009, 1185, 1144},
  {1147, 1067, 1186},
  {1061, 1186, 1067},
  {1070, 1067, 1147},
  {1013, 1072, 1147},
  {1013, 1147, 1188},
  {1072, 1107, 1147},
  {1147, 1107, 1070},
  { 907, 7490, 1237},
  { 907, 1237, 1108},
  {1279, 1369,  942},
  {1013, 1151, 1152},
  {1369, 6667, 1109},
  {1191,  944, 7463},
  {1110, 1241, 1015},
  {1015, 1193, 1110},
  {1109, 6667, 1154},
  {1112, 1193, 1015},
  { 947, 1113, 1196},
  {1015, 1241, 1243},
  { 946, 1109, 1154},
  {1015, 1243, 1288},
  {1112, 1156, 1155},
  {1114, 1194, 1158},
  {1287, 6777,  981},
  {1288, 1247, 1073},
  {1289, 1200, 1198},
  {1200, 1289, 1201},
  {1201, 1289, 1199},
  {1199, 1159, 1201},
  {1201, 1159, 1202},
  {1021, 1204, 1207},
  {1160, 1161, 1021},
  {1161, 1115, 1295},
  {7699, 1207, 1162},
  {1115, 1076, 1208},
  {6781, 1120, 1252},
  {1117, 1257, 1031},
  {1118, 1031, 1257},
  {1118, 1262, 1081},
  {1036, 7045, 1120},
  {1163, 1165, 1037},
  {1211, 1428, 1165},
  {1165, 1428, 1037},
  {1040, 1166, 1121},
  {1037, 1428, 1083},
  {1125, 1167, 1127},
  {1126, 1214, 1166},
  {1213, 1168, 1041},
  {1301, 1268, 1128},
  {1041, 1169, 1172},
  {1219,  996, 1171},
  {6469, 1087, 6468},
  {1001, 1270, 1173},
  {1315, 1089, 1316},
  {1048, 1088, 1131},
  {1220, 1223, 1173},
  {1220, 1221, 1223},
  {1173, 1223, 1132},
  {1223, 1135, 1134},
  {1223, 1272, 1135},
  {1133, 5959, 1090},
  {1095, 1175, 1094},
  {1133, 1135, 5959},
  {1052, 1224, 6538},
  {1052, 6538, 1226},
  {1052, 1226, 1137},
  {1226, 1320, 1137},
  {1137, 1139, 1102},
  {1274, 1138, 1180},
  {1139, 1137, 1227},
  {6634, 1183, 6587},
  {5956, 6587, 1183},
  {1139, 1227, 1184},
  {1138, 1185, 1229},
  {5951, 1146, 1324},
  {1186, 1145, 1230},
  {1145, 6585, 1187},
  {1145, 1187, 1230},
  {6585, 5961, 1187},
  {1228, 1185, 1009},
  {6761, 1188, 1186},
  {1188, 1232, 1234},
  {1188, 1277, 1232},
  {1186, 1188, 1147},
  {1234, 1148, 1188},
  {1148, 1234, 1151},
  {1108, 1149, 1071},
  {7490, 1012, 7161},
  {1150, 6454, 1190},
  {6454, 1191, 1190},
  {1152, 1326, 1153},
  {1326, 7333, 1153},
  {1191, 1242, 1281},
  {1110, 1193, 1192},
  {1110, 1192, 1241},
  {1194, 7333, 7334},
  { 979,  946, 7159},
  {1411, 1154, 6667},
  {1194, 1112, 1155},
  {1154, 1411,  946},
  {1155, 1156, 1158},
  {1155, 1158, 1194},
  {1156, 1157, 1158},
  {1195, 1196, 1197},
  {1596, 1287,  981},
  {1596,  981, 1247},
  {1199, 1292, 1159},
  {1159, 1248, 1203},
  {1203, 1202, 1159},
  {1249, 7706, 7708},
  {1204, 1250, 1207},
  {1205, 7707, 5953},
  {6256, 1206, 7709},
  {7708, 7706, 1252},
  {7706, 1253, 1252},
  {1115, 1208, 6431},
  {1252, 1120, 1256},
  {1253, 1076, 5954},
  {1253, 1208, 1076},
  {1162, 1207, 1257},
  {1162, 1257, 1117},
  {1165, 1163, 1164},
  {1303, 1120, 7045},
  {1164, 1299, 1165},
  {1258, 1120, 1259},
  {1302, 1259, 1120},
  {1120, 1303, 1302},
  {1345, 1081, 1262},
  {1081, 1345, 1078},
  {1210, 1212, 1209},
  {7528, 1212, 1210},
  {1209, 1212, 1264},
  {1211, 6531, 1428},
  {1166, 1305, 1263},
  {1166, 1214, 1305},
  {1126, 1267, 1214},
  {1213, 1041, 1265},
  {1213, 1267, 1168},
  {1168, 1267, 1126},
  {1214, 1216, 7499},
  {1213, 1265, 1267},
  {1267, 1216, 1214},
  {1215, 7492, 7495},
  {1301, 1312, 1268},
  {1301,  999, 1218},
  {1129, 1219, 1218},
  {1129, 1218,  999},
  {1041, 1172, 1266},
  {7426, 1087, 6469},
  {1171, 1269, 1310},
  {1171, 1310, 1219},
  {1001, 1268, 1270},
  {1267, 1172, 1130},
  {1271, 1220, 1173},
  {1173, 1270, 1271},
  {1222, 1176, 1088},
  {5959, 1135, 1272},
  {6538, 1178, 1359},
  {1224, 1174, 6538},
  {1177, 6834, 7458},
  {1176, 1357, 1136},
  {1184, 1364, 1362},
  {1179, 1138, 1321},
  {1179, 1321, 1182},
  {1227, 1484, 1184},
  {1138, 1229, 1180},
  {1183, 1230, 5956},
  {1228, 1229, 1185},
  {5960, 6761, 1186},
  {1230, 5960, 1186},
  {7017, 7019, 1367},
  {1278, 1234, 1232},
  {1233, 1149, 1108},
  {1108, 1237, 1330},
  {1151, 1234, 1152},
  {1234, 1326, 1152},
  {1326, 1235, 7333},
  {7333, 1235, 6767},
  {1111, 1236, 1240},
  {7332, 7605, 5967},
  {1192, 7227, 1241},
  {1335, 1192, 1193},
  {1112, 1335, 1193},
  {1112, 1194, 7334},
  {1284, 1196, 1244},
  {1196, 1113, 1197},
  {1113, 1245, 1197},
  {1244, 1196, 1195},
  {1244, 1195, 1246},
  {1246, 1195, 1197},
  {1197, 1245, 1286},
  {1198, 1291, 1289},
  {1198, 1290, 1291},
  {1290, 1198, 1293},
  {1159, 1292, 1248},
  {1198, 1200, 1293},
  {7706, 1249, 1293},
  {1204, 1341, 1250},
  {1417, 1204, 1021},
  {1161, 1295, 1021},
  {1021, 1381, 1417},
  {1250, 1341, 1207},
  {7706, 1251, 1253},
  {1251, 1208, 1253},
  {1115, 1379, 1295},
  {1208, 1255, 6431},
  {1252, 1256, 1342},
  {1120, 1258, 1256},
  {1256, 1258, 1296},
  {1164, 1078, 1299},
  {1166, 1303, 7045},
  {1209, 1261, 1260},
  {1260, 1301, 1209},
  {1210, 1209, 1301},
  {1345, 5955, 1165},
  {1299, 1345, 1165},
  {1264, 1261, 1209},
  {1262, 1346, 1345},
  {7494, 7528, 1210},
  {1349, 1083, 1428},
  {1083, 1349, 1167},
  {7493, 1215, 1264},
  {1305, 1214, 5964},
  {1127, 1167, 6633},
  {1214, 7499, 1309},
  {1214, 1309, 5964},
  {1167, 1349, 6633},
  {1215, 1218, 1219},
  {1215, 1219, 1264},
  {1041, 1266, 1265},
  {1265, 1266, 1267},
  {1267, 1352, 1216},
  {1216, 1352, 7499},
  {1172, 1267, 1266},
  {7454, 1267, 1130},
  {1313, 1351, 1314},
  {1271, 1353, 1220},
  {1221, 1220, 1353},
  {1131, 1088, 1176},
  {1221, 1353, 1317},
  {1221, 1317, 1223},
  {1223, 1317, 1272},
  {1175, 6835, 1319},
  {6836, 1225, 6833},
  {1364, 1184, 1484},
  {1407, 1137, 1320},
  {1054, 5799, 1180},
  {1275, 1484, 1227},
  {1137, 1407, 1227},
  {1054, 1180, 1228},
  {1229, 1228, 1180},
  {1182, 1321, 1183},
  {1183, 5960, 1230},
  {6376, 1324, 1146},
  {1233, 1108, 1330},
  {1331, 1149, 1327},
  {1149, 1331, 1189},
  {1190, 5972, 1150},
  {7635, 1235, 1326},
  {6314, 1235, 7635},
  {6314, 6456, 1235},
  {6502, 1280, 5962},
  {1190, 1191, 5972},
  {7199, 5962, 7606},
  {1236, 5963, 1240},
  {1369, 1411, 6667},
  {1112, 7334, 1335},
  {1192, 1335, 7227},
  {7159,  946, 1411},
  {1281, 1242, 1282},
  {1283, 1281, 1282},
  {1196, 1282, 1242},
  {1241, 7226, 1243},
  {1196, 1284, 1282},
  {1284, 1283, 1282},
  {1243, 1412, 1288},
  {1197, 1285, 1246},
  {1286, 1285, 1197},
  {1292, 1339, 1248},
  {1201, 1293, 1200},
  {1248, 1339, 5969},
  {1249, 1457, 1293},
  {1201, 1202, 1293},
  {1202, 1203, 1293},
  {1203, 1248, 1461},
  {1248, 5969, 1461},
  {7706, 1293, 1340},
  {7706, 1340, 1251},
  {1204, 1294, 1341},
  {7708, 1342, 1249},
  {1021, 1295, 1381},
  {1252, 1342, 7708},
  {1251, 1254, 1208},
  {1207, 1341, 1257},
  {1420, 1257, 1341},
  {1606, 1295, 1379},
  {1208, 1254, 1255},
  {6432, 1255, 1254},
  {1256, 1297, 1342},
  {1297, 1256, 1296},
  {1296, 1383, 1297},
  {1298, 1260, 1385},
  {1298, 1301, 1260},
  {1298, 1386, 1301},
  {1258, 1259, 1296},
  {1346, 1262, 1118},
  {1300, 1260, 1261},
  {1301, 1386, 1347},
  {1166, 1263, 1387},
  {1345, 1348, 5955},
  {1304, 1301, 1347},
  {5955, 1348, 1306},
  {1310, 1307, 1264},
  {1301, 1304, 1312},
  {7600, 1305, 5964},
  {1307, 1310, 1350},
  {1309, 7499, 1311},
  {1310, 1264, 1219},
  {1311, 7499, 1622},
  {1352, 7453, 7499},
  {1622, 1217, 7452},
  {1393, 1271, 1312},
  {1312, 1271, 1268},
  {1268, 1271, 1270},
  {1130, 1315, 1430},
  {6469, 7160, 7426},
  {1269, 1314, 1392},
  {1271, 1393, 1353},
  {1222, 1090, 6337},
  {1090, 5959, 1355},
  {6835, 1362, 1319},
  {1357, 5973, 1136},
  {5800, 1136, 5973},
  {1365, 7389, 7445},
  {1138, 1531, 1321},
  {1484, 1275, 1407},
  {1321, 1322, 1183},
  {1183, 1322, 5960},
  {5960, 1322, 1323},
  {1276, 5966, 1277},
  {1407, 1275, 1227},
  {7020, 7017, 1367},
  {5966, 1493, 1277},
  {1278, 1232, 1445},
  {1445, 1232, 1277},
  {1233, 1327, 1149},
  {1331, 1325, 1189},
  {1278, 1326, 1234},
  {1329, 7634, 1328},
  { 942, 5972, 1279},
  { 942, 1150, 5972},
  {5968, 6456, 6314},
  {1332, 1334, 1335},
  {5972, 1191, 1370},
  {5962, 1280, 7606},
  {1369, 1639, 1411},
  {1191, 1281, 1371},
  {1191, 1371, 1370},
  {1334, 7227, 1335},
  {1280, 5967, 7605},
  {1280, 7605, 7606},
  {1283, 1371, 1281},
  {1498, 1284, 1244},
  {1246, 1498, 1244},
  {1285, 1286, 1336},
  {1286, 1245, 1336},
  {1287, 1336, 1245},
  {1288, 1412, 1247},
  {6448, 1199, 1289},
  {1413, 1290, 1414},
  {1290, 1413, 1291},
  {1199, 6448, 1292},
  {6448, 1337, 1292},
  {1290, 1293, 1457},
  {1293, 1203, 1461},
  {1416, 1340, 1293},
  {1381, 1468, 1417},
  {1342, 1297, 1378},
  {1254, 1379, 1115},
  {1378, 1297, 1343},
  {1257, 1469, 1118},
  {1297, 1383, 1343},
  {1385, 1384, 1298},
  {1298, 1384, 1386},
  {1296, 1259, 1302},
  {1296, 1302, 1387},
  {1296, 1387, 1383},
  {1078, 1345, 1299},
  {1300, 1388, 1423},
  {1388, 1300, 1264},
  {1300, 1261, 1264},
  {1303, 1166, 1387},
  {1348, 1345, 1425},
  {1387, 1263, 1305},
  {1264, 1307, 1427},
  {1350, 1427, 1307},
  {5964, 6462, 7600},
  {1350, 1310, 1392},
  {1269, 1392, 1310},
  {1390, 1312, 1304},
  {6633, 1349, 1351},
  {1351, 5970, 6633},
  {1390, 1393, 1312},
  {7454, 1130, 1430},
  {1433, 1222, 6337},
  {1433, 1394, 1222},
  {1356, 6732, 7702},
  {1176, 1431, 1432},
  {1176, 1222, 1394},
  {1176, 1394, 1431},
  {6337, 1090, 1434},
  {1395, 6338, 1354},
  {1358, 1175, 1319},
  {1358, 1398, 1175},
  {6538, 1359, 1402},
  {1403, 5958, 1361},
  {1360, 1363, 6732},
  {6732, 1436, 1360},
  {6538, 1402, 1226},
  {1357, 1399, 5973},
  {5958, 1403, 1273},
  {1404, 1363, 1360},
  {1365, 7141, 7389},
  {1405, 1531, 1138},
  {1441, 1407, 1320},
  {1366, 7006, 6989},
  {5966, 5971, 1493},
  {1277, 1446, 1445},
  {1233, 1330, 1327},
  {7635, 1408, 1333},
  {1409, 1331, 1327},
  {1332, 1335, 1495},
  {5972, 1369, 1279},
  {1330, 1237, 1410},
  {1238, 6651, 1237},
  {1371, 1283, 1498},
  {1372, 1758, 1285},
  {1283, 1284, 1498},
  {1285, 1758, 1246},
  {1285, 1373, 1372},
  {1285, 1336, 1373},
  {1336, 1287, 1374},
  {1291, 1375, 1289},
  {1339, 1292, 1376},
  {1338, 7534, 6523},
  {1290, 1457, 1414},
  {6523, 7534, 1377},
  {1377, 1461, 6523},
  {1293, 1555, 1416},
  {1464, 1340, 1416},
  {1249, 1378, 1457},
  {1457, 1378, 1505},
  {1294, 1204, 1417},
  {1249, 1342, 1378},
  {1251, 1340, 1254},
  {1379, 1254, 1340},
  {1295, 1380, 1381},
  {1295, 1606, 1380},
  {1343, 1466, 1378},
  {7408, 1257, 1420},
  {1260, 1344, 1385},
  {1260, 1300, 1344},
  {5801, 1344, 1300},
  {5802, 5801, 1300},
  {1383, 1387, 7177},
  {5802, 1300, 1423},
  {1424, 1345, 1346},
  {1425, 1345, 1424},
  {1264, 1389, 1388},
  {1303, 1387, 1302},
  {1424, 1346, 1472},
  {1264, 1427, 1426},
  {5977, 1304, 1386},
  {1386, 1304, 1347},
  {5977, 1390, 1304},
  {5977, 7336, 1390},
  {1350, 1392, 1427},
  {7600, 1523, 1305},
  {1393, 1390, 7717},
  {1349, 1392, 1314},
  {1316, 1318, 1315},
  {1353, 1393, 1481},
  {1353, 1481, 1356},
  {1432, 1357, 1176},
  {1354, 6338, 1395},
  {1396, 1434, 1090},
  {1090, 1355, 1396},
  {1397, 1356, 1481},
  {1356, 1397, 6732},
  {1398, 1358, 7536},
  {1398, 1094, 1175},
  {1318, 1094, 1398},
  {1355, 5959, 1437},
  {1355, 1437, 1576},
  {6732, 1397, 1400},
  {1400, 1436, 6732},
  {1358, 1319, 7536},
  {6732, 1363, 5958},
  {5958, 1363, 1361},
  {1437, 1273, 1403},
  {1401, 7728, 7741},
  {1402, 1359, 1181},
  {1226, 1402, 1320},
  {1399, 1440, 5973},
  {1361, 1363, 1403},
  {1439, 1485, 1320},
  {1320, 1485, 1530},
  {1320, 1580, 1441},
  {1441, 1484, 1407},
  {5971, 1406, 1493},
  {6535, 6257, 6534},
  {7020, 1367, 1489},
  {1534, 1489, 1367},
  {1493, 1406, 7281},
  {1406, 1442, 7281},
  {1444, 5951, 1324},
  {1534, 1367, 7019},
  {1277, 1493, 1446},
  {6376, 1492, 1324},
  {1278, 1445, 1326},
  {1408, 7635, 1326},
  {1330, 1410, 1327},
  {5972, 1447, 1369},
  {5972, 1448, 1447},
  {7334, 1408, 1335},
  {7334, 1368, 1408},
  {1368, 1333, 1408},
  {1327, 1410, 1409},
  {5972, 1370, 6964},
  {1448, 6733, 1497},
  {1450, 5957, 1411},
  {5974, 6964, 1370},
  {7226, 1452, 1243},
  {1371, 1498, 1370},
  {1243, 1452, 1412},
  {1372, 1373, 1546},
  {1498, 1246, 1758},
  {1336, 1374, 1373},
  {1412, 1596, 1247},
  {1291, 1499, 1375},
  {6448, 1289, 1375},
  {6476, 1337, 6448},
  {6476, 6446, 1337},
  {1292, 1337, 6446},
  {1555, 1293, 1461},
  {1379, 1340, 1464},
  {1466, 1418, 1378},
  {1421, 1420, 1341},
  {1382, 1421, 1341},
  {1466, 1343, 1383},
  {1382, 1659, 1419},
  {1419, 1465, 1382},
  {1380, 1467, 1381},
  {1468, 1381, 1467},
  {1382, 1465, 1422},
  {1118, 1470, 1346},
  {1384, 1385, 1386},
  {1423, 1564, 5802},
  {1426, 1516, 1389},
  {1389, 1264, 1426},
  {1523, 1387, 1305},
  {6531, 6905, 1428},
  {1349, 1428, 1429},
  {1427, 1392, 1476},
  {1391, 1522, 1477},
  {1308, 1309, 1522},
  {1392, 1429, 1476},
  {1622, 1309, 1311},
  {1429, 1392, 1349},
  {1349, 1314, 1351},
  {7717, 1478, 1393},
  {1318, 1398, 1479},
  {1394, 1433, 1576},
  {1394, 1576, 1431},
  {1576, 1434, 1396},
  {1396, 1355, 1576},
  {1481, 1630, 1397},
  {1480, 1399, 1357},
  {1400, 1397, 1436},
  {1399, 1480, 1482},
  {1319, 1362, 7536},
  {1360, 1436, 1404},
  {1320, 1402, 1438},
  {1435, 1364, 1484},
  {1483, 1435, 1484},
  {1320, 1438, 1439},
  {1438, 1402, 1181},
  {1440, 1399, 1482},
  {1530, 1580, 1320},
  {1181, 5951, 1486},
  {5951, 1488, 1486},
  {6258, 7548, 5965},
  {1488, 5951, 1444},
  {1442, 1406, 6258},
  {1444, 1324, 1443},
  {1324, 1583, 1443},
  {1410, 1538, 1409},
  {1334, 1332, 1541},
  {1410, 1237, 1496},
  {6651, 1496, 1237},
  {6603, 6604, 1449},
  {6651, 6783, 1451},
  {7102, 1411, 1639},
  {7102, 1639, 1451},
  {1411, 5975, 6888},
  {6888, 5975, 1411},
  {1370, 1498, 5974},
  {7226, 7228, 1452},
  {1373, 1549, 1546},
  {1453, 1412, 1452},
  {1374, 1287, 1761},
  {1375, 1499, 1500},
  {6448, 1375, 1500},
  {1499, 1291, 1599},
  {1291, 1413, 1599},
  {5871, 1415, 1376},
  {1455, 1413, 1414},
  {7553, 1649, 7534},
  {1455, 1414, 1502},
  {1458, 1459, 1504},
  {1416, 1555, 5976},
  {1506, 1461, 1377},
  {1462, 1504, 1459},
  {1508, 1462, 1459},
  {1508, 1459, 1554},
  {1416, 1460, 1464},
  {1505, 1418, 1463},
  {1505, 1378, 1418},
  {1418, 1509, 1463},
  {1417, 1341, 1294},
  {1341, 1513, 1382},
  {1468, 1557, 1417},
  {1659, 1382, 1513},
  {1606, 1607, 1380},
  {1382, 1422, 1421},
  {1469, 1470, 1118},
  {1421, 1422, 1514},
  {5986, 7177, 1387},
  {1388, 1389, 1516},
  {1388, 1516, 1423},
  {1564, 1423, 1516},
  {1472, 1425, 1424},
  {1473, 1474, 1516},
  {1518, 1516, 1474},
  {1516, 1426, 1473},
  {1476, 1473, 1426},
  {1523, 1517, 1387},
  {1475, 1474, 1428},
  {1475, 1428, 6905},
  {1475, 1518, 1474},
  {1474, 1473, 1428},
  {1473, 1476, 1428},
  {1426, 1427, 1476},
  {1428, 1476, 1429},
  {1309, 1622, 1522},
  {1318, 1524, 1315},
  {7455, 1315, 1524},
  {1393, 1478, 1481},
  {1576, 1432, 1431},
  {1357, 1432, 1480},
  {1433, 6337, 1576},
  {6337, 1434, 1576},
  {1436, 1397, 1630},
  {1480, 1529, 1482},
  {7411, 1579, 1526},
  {1527, 1403, 1363},
  {1363, 1404, 1527},
  {7410, 1435, 1528},
  {1528, 1435, 1483},
  {1482, 1529, 1440},
  {1440, 1531, 1405},
  {1181, 1486, 1439},
  {1581, 1321, 1531},
  {1484, 1441, 1809},
  {5965, 1487, 6258},
  {6591, 6258, 1487},
  {1488, 1444, 1850},
  {1488, 1850, 1486},
  {1489, 1582, 6375},
  {6258, 1490, 1442},
  {1491, 1442, 1490},
  {7281, 6608, 1491},
  {1444, 1443, 1850},
  {1583, 1324, 1492},
  {1582, 1492, 6375},
  {1535, 1534, 1325},
  {1445, 1494, 1536},
  {1445, 1446, 1494},
  {1326, 1445, 1536},
  {1409, 1535, 1325},
  {1326, 1537, 1408},
  {1495, 1335, 1537},
  {1408, 1537, 1335},
  {1410, 1496, 1538},
  {1496, 6651, 1538},
  {6603, 1449, 6604},
  {6651, 1451, 1542},
  {1451, 1639, 1542},
  {1452, 7228, 7293},
  {1372, 1546, 1758},
  {1373, 1595, 1549},
  {1453, 7294, 1412},
  {1373, 1374, 1761},
  {1287, 1596, 1761},
  {1455, 1599, 1413},
  {1553, 1414, 1457},
  {1292, 1604, 1376},
  {1503, 1554, 1458},
  {1458, 1554, 1459},
  {1504, 1503, 1458},
  {1462, 1508, 1507},
  {1460, 1606, 1464},
  {1464, 1606, 1379},
  {1418, 1511, 1509},
  {1417, 1609, 1341},
  {1511, 1418, 1512},
  {1341, 1609, 1661},
  {1341, 1661, 1513},
  {1418, 1466, 1512},
  {1419, 1659, 1465},
  {1465, 1510, 1514},
  {1465, 1514, 1422},
  {7408, 1420, 6906},
  {7533, 1558, 6354},
  {1515, 1560, 5803},
  {6878, 5981, 6331},
  {6588, 5979, 1471},
  {1519, 1567, 1520},
  {1425, 1521, 1348},
  {1475, 1620, 1518},
  {1348, 1620, 1475},
  {1520, 1477, 1522},
  {1623, 1620, 1348},
  {1348, 1521, 1623},
  {7452, 1681, 1622},
  {1479, 1524, 1318},
  {1524, 7452, 7455},
  {1479, 1398, 7536},
  {1479, 7536, 1729},
  {1686, 1576, 1437},
  {1437, 1403, 1632},
  {1437, 1632, 1686},
  {1403, 1527, 1632},
  {1436, 1578, 1404},
  {1404, 1578, 1527},
  {1439, 1438, 1181},
  {1440, 1529, 1531},
  {1484, 1809, 1483},
  {1580, 1439, 1486},
  {5965, 1321, 1487},
  {1490, 6258, 6591},
  {6591, 1533, 1490},
  {1441, 1850, 1809},
  {1580, 1486, 1850},
  {1534, 1582, 1489},
  {6877, 7112, 6590},
  {1490, 1532, 1491},
  {1491, 1532, 1636},
  {1491, 1636, 7281},
  {7281, 1636, 1584},
  {1492, 1582, 1690},
  {1583, 1850, 1443},
  {1691, 1536, 1494},
  {1691, 1494, 1446},
  {1331, 1409, 1325},
  {1447, 1448, 1639},
  {1448, 1497, 1639},
  {6651, 1585, 1539},
  {6651, 1641, 1585},
  {1542, 1639, 1754},
  {6651, 1542, 1641},
  {1544, 1543, 1588},
  {1544, 1588, 1589},
  {1543, 1544, 1547},
  {1544, 1589, 1591},
  {1589, 7073, 1591},
  {1589, 1545, 7073},
  {1589, 5980, 1545},
  {1547, 1759, 1543},
  {1452, 7293, 1453},
  {1453, 7293, 7294},
  {1595, 1373, 1761},
  {1499, 1597, 1500},
  {6447, 6448, 1500},
  {1456, 1501, 1454},
  {7417, 5804, 7416},
  {1414, 1552, 1502},
  {1551, 1503, 1550},
  {1414, 1553, 1601},
  {1414, 1601, 1552},
  {1292, 6874, 1604},
  {1551, 1554, 1503},
  {1502, 1651, 1602},
  {1502, 1602, 1455},
  {7534, 1649, 1377},
  {1554, 1551, 7434},
  {1460, 1555, 1606},
  {1461, 1506, 1555},
  {1658, 1505, 1463},
  {1658, 1463, 1509},
  {1511, 1658, 1509},
  {1508, 1654, 1510},
  {1508, 1510, 1465},
  {1609, 1417, 1557},
  {1510, 1657, 1514},
  {1420, 1421, 1611},
  {1421, 1514, 1713},
  {6354, 1466, 1383},
  {1611, 1610, 1420},
  {1420, 1784, 6906},
  {1560, 1515, 1612},
  {1560, 1559, 1614},
  {6354, 1383, 7070},
  {6354, 7070, 1561},
  {6354, 1561, 7533},
  {1563, 1383, 1667},
  {7070, 1383, 1563},
  {1560, 1614, 5803},
  {1346, 6903, 1472},
  {1722, 1387, 1517},
  {1615, 1569, 5803},
  {1518, 1620, 1516},
  {1517, 1523, 1722},
  {6671, 1516, 1620},
  {1516, 6671, 1617},
  {1425, 7225, 1521},
  {1572, 1570, 1566},
  {1519, 1520, 1573},
  {7252, 1521, 7225},
  {1521, 7252, 1623},
  {1571, 1626, 1619},
  {1571, 1570, 1572},
  {1680, 1573, 1574},
  {1574, 1573, 1678},
  {1680, 1574, 1479},
  {1680, 1479, 1729},
  {1574, 1678, 1479},
  {1479, 7452, 1524},
  {1479, 1678, 1624},
  {1479, 1624, 7452},
  {7452, 1624, 1625},
  {7405, 7537, 1525},
  {1432, 1529, 1480},
  {7322, 7405, 1525},
  {7405, 7322, 1575},
  {6298, 1575, 7322},
  {1576, 1529, 1432},
  {1578, 1436, 1631},
  {7322, 7323, 6298},
  {1686, 1805, 1576},
  {1633, 6756, 6757},
  {1577, 1632, 1527},
  {1527, 1578, 1577},
  {7409, 1483, 6757},
  {1529, 1687, 1531},
  {1483, 1634, 6757},
  {1485, 1439, 1530},
  {1483, 1809, 1634},
  {1530, 1439, 1580},
  {1688, 1636, 1487},
  {1636, 1532, 1487},
  {1581, 1635, 1321},
  {1321, 1635, 1487},
  {1487, 1635, 1688},
  {1690, 1583, 1492},
  {1582, 1534, 1535},
  {1584, 1446, 1493},
  {1493, 7281, 1584},
  {1535, 1409, 1582},
  {1745, 1746, 1446},
  {1536, 1637, 1326},
  {1447, 1639, 1369},
  {1495, 1537, 1640},
  {1332, 1495, 1541},
  {1541, 1586, 1540},
  {1541, 1495, 1586},
  {1754, 1643, 1542},
  {1540, 1586, 1543},
  {1540, 1543, 1590},
  {1586, 1587, 1543},
  {1590, 1543, 1594},
  {1587, 1588, 1543},
  {1542, 1643, 1641},
  {1498, 1858, 1497},
  {1591, 1592, 1644},
  {6662, 7073, 1545},
  {1593, 1858, 1498},
  {1593, 1498, 1645},
  {1590, 1594, 1759},
  {1594, 1543, 1759},
  {1547, 1544, 1591},
  {1547, 1591, 1644},
  {1646, 1759, 1547},
  {1548, 7367, 1698},
  {7369, 7367, 1548},
  {1596, 1412, 7294},
  {1598, 1597, 1499},
  {1499, 1599, 1598},
  {1599, 1455, 7256},
  {1647, 7256, 1455},
  {1455, 1602, 1647},
  {1700, 1647, 1602},
  {1602, 7258, 1700},
  {1550, 7264, 1551},
  {1648, 1551, 7264},
  {1502, 1552, 1651},
  {1550, 1503, 1701},
  {1550, 1701, 1765},
  {1649, 1770, 1377},
  {1554, 1605, 1650},
  {1553, 1655, 1601},
  {6874, 6928, 1604},
  {1770, 1701, 1503},
  {1503, 1504, 1770},
  {1655, 1553, 1457},
  {1770, 1504, 1462},
  {1457, 1505, 1655},
  {1377, 1607, 1506},
  {1508, 1554, 1654},
  {1505, 1656, 1655},
  {1658, 1656, 1505},
  {1606, 1555, 1607},
  {1555, 1506, 1607},
  {1659, 1706, 1507},
  {1507, 1508, 1659},
  {1654, 1657, 1510},
  {1508, 1465, 1659},
  {1467, 1380, 1607},
  {7657, 1658, 7001},
  {1558, 7001, 1511},
  {6354, 1558, 1511},
  {1511, 1512, 6354},
  {1466, 6354, 1512},
  {1468, 1467, 1607},
  {1607, 1557, 1468},
  {1609, 1660, 1661},
  {1513, 1708, 1659},
  {1609, 1829, 1660},
  {1661, 1708, 1513},
  {1514, 1657, 1713},
  {1558, 7533, 1707},
  {1558, 1707, 7002},
  {1560, 1612, 1663},
  {1560, 1663, 7104},
  {1784, 1420, 1782},
  {1666, 7533, 1616},
  {1616, 7533, 1561},
  {1614, 1615, 5803},
  {1562, 7071, 1616},
  {1346, 1470, 6903},
  {1515, 1565, 1665},
  {5986, 1387, 1722},
  {1425, 1472, 1671},
  {1619, 1569, 1615},
  {1672, 1673, 1566},
  {7600, 7601, 7602},
  {6671, 1618, 1617},
  {1570, 1619, 1672},
  {1672, 1566, 1570},
  {1566, 1673, 1572},
  {1567, 1519, 1573},
  {7602, 1789, 7600},
  {7600, 1789, 1523},
  {1619, 1570, 1571},
  {1573, 1520, 1678},
  {1520, 1522, 1678},
  {1522, 1622, 1678},
  {1619, 1478, 1569},
  {1478, 1619, 1626},
  {1572, 1679, 1683},
  {1572, 1626, 1571},
  {1624, 1622, 1625},
  {1625, 1681, 7452},
  {1683, 1626, 1572},
  {1478, 1626, 1481},
  {7405, 1629, 6379},
  {1631, 1436, 1626},
  {1578, 1631, 1734},
  {5982, 6296, 1685},
  {5982, 1685, 1628},
  {1576, 1736, 1529},
  {1576, 1805, 1736},
  {7571, 7572, 7573},
  {1529, 1740, 1687},
  {6757, 1634, 1633},
  {1687, 1689, 1531},
  {1441, 1580, 1850},
  {1689, 1743, 1531},
  {1531, 1743, 1581},
  {1690, 1744, 1583},
  {1446, 1584, 1745},
  {1446, 1746, 1691},
  {1637, 1536, 1691},
  {1495, 1640, 1586},
  {1641, 1643, 1585},
  {1586, 1640, 1753},
  {1586, 1753, 1587},
  {1588, 1587, 1893},
  {7242, 1642, 6407},
  {7242, 1588, 1642},
  {1695, 1644, 1592},
  {1859, 1695, 1592},
  {1545, 6407, 6662},
  {1547, 1644, 7368},
  {1498, 1758, 1645},
  {1761, 1756, 1595},
  {7368, 1646, 1547},
  {1823, 1500, 1864},
  {1500, 1823, 6447},
  {1911, 6447, 1823},
  {6447, 1911, 1603},
  {1552, 1601, 1651},
  {1604, 1868, 5871},
  {1551, 1648, 7434},
  {1601, 1655, 1651},
  {1651, 1652, 1602},
  {1602, 1652, 7258},
  {1603, 1766, 1653},
  {1650, 1702, 1554},
  {6928, 6929, 1868},
  {6928, 1868, 1604},
  {1654, 1554, 1702},
  {1607, 1377, 1775},
  {1462, 1507, 1706},
  {1656, 1771, 1655},
  {1707, 1771, 1656},
  {1656, 1658, 1707},
  {1658, 1511, 7001},
  {1658, 7657, 1707},
  {1660, 1776, 1661},
  {1608, 1556, 7658},
  {1611, 1421, 1713},
  {1612, 1710, 1663},
  {1515, 1665, 1612},
  {1614, 1559, 1662},
  {1615, 1614, 1662},
  {1563, 1667, 1669},
  {1668, 1615, 1664},
  {1664, 1670, 1668},
  {1716, 1666, 1616},
  {1671, 1472, 6903},
  {1665, 1565, 6963},
  {1668, 1670, 1672},
  {1615, 1668, 1619},
  {1672, 1619, 1668},
  {1723, 1672, 1670},
  {1672, 1723, 1673},
  {1425, 6904, 7225},
  {1722, 1523, 1834},
  {1523, 1789, 1834},
  {6671, 1675, 1618},
  {1620, 6669, 6671},
  {1674, 1677, 1673},
  {1673, 1677, 1572},
  {1677, 1679, 1572},
  {1677, 1730, 1679},
  {1622, 1624, 1678},
  {1622, 1681, 1625},
  {1683, 1679, 1730},
  {1734, 1683, 1730},
  {7537, 7405, 6379},
  {1626, 1630, 1481},
  {6850, 1732, 1627},
  {1631, 1626, 1683},
  {1683, 1734, 1631},
  {1630, 1626, 1436},
  {5983, 5989, 1684},
  {1844, 1578, 1734},
  {1632, 1577, 1880},
  {1807, 1577, 1578},
  {5985, 7372, 5984},
  {1636, 1688, 1741},
  {1689, 1742, 1743},
  {1581, 1743, 1635},
  {1810, 1637, 1691},
  {1326, 1637, 1537},
  {1810, 1537, 1637},
  {1693, 1638, 1692},
  {1749, 1538, 5811},
  {1810, 1640, 1537},
  {1751, 1692, 1638},
  {1749, 5811, 1752},
  {1694, 1753, 1640},
  {1585, 1643, 1754},
  {1585, 1754, 1812},
  {1754, 1639, 1815},
  {1893, 1587, 1753},
  {1497, 1858, 1639},
  {6662, 6407, 1696},
  {1820, 1593, 1645},
  {1820, 1903, 1593},
  {1644, 1757, 7368},
  {1758, 1546, 1755},
  {1758, 1755, 1819},
  {1759, 1646, 1697},
  {1756, 1761, 1860},
  {1697, 1646, 6574},
  {7368, 6574, 1646},
  {7294, 6419, 1596},
  {1761, 1596, 6419},
  {1864, 1500, 1597},
  {1597, 1598, 1945},
  {1700, 1762, 1647},
  {5994, 6556, 7265},
  {7257, 1700, 1600},
  {7264, 1550, 5809},
  {1598, 7312, 7313},
  {1550, 1765, 5809},
  {1649, 6245, 1765},
  {1650, 1605, 1768},
  {1650, 1767, 1702},
  {1649, 1701, 1770},
  {1652, 1769, 7258},
  {1702, 1825, 1654},
  {1651, 1655, 1771},
  {1652, 1651, 1769},
  {5990, 5991, 1704},
  {5990, 1704, 5991},
  {1377, 1770, 1772},
  {1377, 1772, 1775},
  {1770, 1462, 1773},
  {1708, 1773, 1462},
  {1657, 1654, 1774},
  {1705, 1708, 1462},
  {1462, 1706, 1705},
  {1659, 1708, 1706},
  {1777, 1713, 1657},
  {1830, 1713, 1777},
  {1711, 1615, 1710},
  {1707, 1712, 1709},
  {1709, 1712, 1778},
  {1611, 1713, 1610},
  {1612, 1665, 1710},
  {1710, 1615, 1662},
  {1711, 1664, 1615},
  {1714, 1664, 1711},
  {1420, 1610, 1782},
  {1610, 1713, 1568},
  {7533, 1712, 1707},
  {1664, 1715, 1670},
  {7533, 1666, 1872},
  {1779, 1717, 1780},
  {1780, 1717, 1714},
  {1779, 1718, 1717},
  {1616, 7071, 1716},
  {6963, 1720, 1665},
  {1779, 1721, 1718},
  {1717, 7120, 1714},
  {1670, 1715, 1723},
  {1671, 6902, 1425},
  {6904, 1425, 6901},
  {1665, 1720, 1833},
  {1719, 1568, 1713},
  {6962, 6947, 6961},
  {1724, 7343, 7344},
  {1573, 1786, 1567},
  {7602, 1786, 1789},
  {1725, 1726, 1674},
  {1837, 1726, 1725},
  {7252, 1875, 1676},
  {7252, 1676, 1623},
  {1874, 1727, 1726},
  {1674, 1726, 1730},
  {1674, 1730, 1677},
  {1791, 1728, 1682},
  {1791, 1682, 1874},
  {1874, 1682, 1727},
  {1726, 1731, 1730},
  {1682, 1731, 1727},
  {1727, 1731, 1726},
  {6557, 2006, 1729},
  {1731, 1682, 1728},
  {1730, 1731, 1734},
  {1728, 1733, 1731},
  {1797, 1731, 1733},
  {6694, 1731, 1797},
  {5988, 1735, 1795},
  {5992, 1735, 1804},
  {1735, 5988, 1737},
  {1844, 1798, 7448},
  {1798, 1844, 1734},
  {1802, 1735, 1737},
  {1685, 1737, 5988},
  {1686, 1632, 1805},
  {1807, 7737, 1577},
  {1578, 1844, 1807},
  {1738, 1739, 6290},
  {1737, 1685, 1739},
  {1846, 1739, 1685},
  {6290, 1739, 1738},
  {1685, 6296, 1846},
  {1633, 1634, 1848},
  {1634, 1885, 1848},
  {1635, 1888, 1688},
  {1688, 1888, 1741},
  {1583, 1744, 1850},
  {1690, 1582, 1409},
  {1745, 1584, 1889},
  {1584, 1636, 1889},
  {1690, 1409, 1852},
  {1746, 1810, 1691},
  {1750, 1693, 1692},
  {1750, 1851, 1693},
  {1745, 1750, 1747},
  {1693, 1748, 1638},
  {1538, 1749, 1409},
  {1694, 1640, 1810},
  {1810, 1892, 1694},
  {1751, 1750, 1692},
  {1813, 1751, 1638},
  {1748, 1813, 1638},
  {1812, 1754, 1815},
  {1588, 1893, 1856},
  {1644, 1695, 7688},
  {1588, 1856, 1642},
  {1642, 1696, 6407},
  {6938, 1820, 1861},
  {1593, 1903, 1858},
  {1644, 1817, 1757},
  {1645, 1758, 1820},
  {1546, 1549, 1755},
  {1906, 1755, 1549},
  {1759, 1697, 1699},
  {1760, 1699, 1697},
  {1595, 1906, 1549},
  {7294, 1760, 6419},
  {7257, 1762, 1700},
  {1603, 1911, 1766},
  {1649, 1765, 1701},
  {1767, 1825, 1702},
  {1768, 1605, 1826},
  {1654, 1825, 1774},
  {1770, 1773, 1772},
  {1703, 7435, 7436},
  {1605, 7260, 1826},
  {1707, 1952, 1771},
  {1774, 1827, 1657},
  {1828, 1657, 1827},
  {1660, 1829, 1772},
  {1772, 1773, 1660},
  {1773, 1708, 1661},
  {1705, 1706, 1708},
  {1607, 1775, 1557},
  {1660, 1773, 1776},
  {1773, 1661, 1776},
  {1609, 1557, 1775},
  {1870, 1830, 1777},
  {1871, 1713, 1830},
  {1710, 1779, 1711},
  {1711, 1779, 1780},
  {1711, 1780, 1714},
  {1921, 1713, 1871},
  {1710, 1665, 1779},
  {1714, 1783, 1664},
  {6774, 1781, 6773},
  {1782, 1610, 1568},
  {1664, 1783, 1715},
  {1872, 1666, 2112},
  {1666, 1716, 2112},
  {1779, 1665, 1833},
  {1721, 1779, 1833},
  {7071, 5986, 6392},
  {7120, 1717, 1718},
  {7346, 1715, 7344},
  {5986, 1722, 1873},
  {1568, 1719, 1785},
  {7120, 1718, 1721},
  {1788, 1836, 1721},
  {1721, 1836, 7120},
  {1722, 1834, 1873},
  {1786, 1573, 1787},
  {7121, 2048, 7118},
  {5987, 7089, 1725},
  {5987, 7345, 7089},
  {1573, 1835, 1787},
  {1786, 1787, 1789},
  {1726, 1837, 1874},
  {1834, 1789, 1925},
  {7252, 7253, 1875},
  {1680, 1729, 2006},
  {1792, 1794, 1878},
  {1792, 1878, 1733},
  {1792, 1841, 1794},
  {2006, 6557, 1793},
  {1794, 1842, 1878},
  {1731, 1796, 1734},
  {1733, 1878, 1797},
  {1796, 1798, 1734},
  {7243, 1804, 6742},
  {6694, 7014, 1731},
  {1731, 7014, 1796},
  {1799, 1801, 1839},
  {1843, 1839, 1801},
  {1804, 1801, 1799},
  {1798, 7014, 7448},
  {1801, 1804, 1806},
  {1804, 1735, 1802},
  {1801, 1806, 1843},
  {1804, 1802, 1846},
  {1802, 1737, 1846},
  {1737, 1739, 1846},
  {7575, 1805, 7574},
  {1804, 1846, 1806},
  {1577, 7737, 1880},
  {7737, 1807, 1844},
  {1740, 7570, 1687},
  {7570, 1742, 1687},
  {1888, 1635, 1743},
  {1849, 6998, 1634},
  {1689, 1808, 1742},
  {1634, 1809, 1849},
  {1810, 1746, 1811},
  {1746, 1745, 1811},
  {1409, 1938, 1852},
  {1811, 1745, 1747},
  {1851, 1750, 1745},
  {1693, 1851, 1748},
  {1938, 1409, 1749},
  {1751, 1813, 1750},
  {1752, 1814, 1749},
  {1694, 1892, 1753},
  {1752, 1585, 1814},
  {1585, 6687, 1853},
  {1753, 1892, 1893},
  {1585, 1853, 1897},
  {1639, 1858, 1979},
  {7690, 1817, 7689},
  {7689, 1817, 1644},
  {7688, 1695, 1900},
  {1642, 1856, 1696},
  {1696, 1856, 1816},
  {6990, 6470, 6843},
  {1903, 1979, 1858},
  {1818, 6470, 6990},
  {1986, 1819, 1755},
  {1756, 1860, 1595},
  {1820, 1758, 1903},
  {7368, 1757, 6575},
  {1757, 1817, 6575},
  {1821, 6575, 1817},
  {6938, 1861, 1820},
  {1860, 1761, 1905},
  {1822, 1862, 1697},
  {1697, 1821, 1822},
  {1697, 1862, 1760},
  {6419, 1760, 1761},
  {1761, 1760, 1905},
  {1863, 1905, 1760},
  {1647, 1762, 7256},
  {1763, 1764, 5808},
  {1764, 5871, 1824},
  {1764, 1824, 5808},
  {5808, 7434, 6971},
  {6971, 7434, 1648},
  {5871, 1868, 1824},
  {1912, 1650, 1768},
  {1650, 1912, 1767},
  {1866, 1769, 1651},
  {1653, 1766, 1868},
  {1825, 1827, 1774},
  {1829, 1775, 1772},
  {1828, 1949, 1657},
  {1916, 1657, 1949},
  {1709, 1952, 1707},
  {1869, 1952, 1709},
  {1917, 1918, 1657},
  {1916, 1917, 1657},
  {1775, 1829, 1609},
  {1709, 1778, 1869},
  {1778, 1919, 1869},
  {7530, 7533, 1872},
  {1920, 1712, 1613},
  {1920, 1778, 1712},
  {1781, 6774, 6773},
  {1784, 1782, 1568},
  {1716, 7071, 2112},
  {7071, 6392, 2112},
  {1783, 1831, 1832},
  {1783, 1832, 1715},
  {1715, 1832, 7344},
  {1873, 6392, 5986},
  {1833, 7655, 1721},
  {7344, 1922, 1724},
  {7344, 1832, 1922},
  {1785, 1621, 1568},
  {7120, 2002, 1714},
  {1621, 1785, 1838},
  {7655, 1788, 1721},
  {1787, 1835, 1789},
  {6963, 7280, 1720},
  {1835, 1573, 1680},
  {1835, 1680, 1924},
  {1875, 1720, 1676},
  {1875, 1833, 1720},
  {6670, 1790, 6668},
  {2006, 7525, 1876},
  {6277, 6686, 6299},
  {1877, 6742, 1804},
  {1798, 1796, 7014},
  {1632, 1880, 1805},
  {1806, 1846, 7058},
  {1846, 5993, 1847},
  {5993, 5995, 1847},
  {1742, 1808, 1687},
  {1687, 1808, 1689},
  {1741, 1884, 5812},
  {1742, 2017, 1743},
  {1743, 1887, 1888},
  {1809, 2016, 1849},
  {1745, 1889, 1851},
  {1852, 1890, 1690},
  {1892, 1810, 1811},
  {1747, 1750, 1937},
  {1748, 7245, 1813},
  {1895, 1938, 1814},
  {1814, 1938, 1749},
  {1814, 1585, 1895},
  {1585, 1897, 1895},
  {1893, 1898, 1856},
  {1695, 1859, 1900},
  {6990, 1857, 1818},
  {1857, 1813, 1899},
  {1901, 1857, 1899},
  {7690, 1904, 1817},
  {7690, 1944, 1904},
  {1857, 1901, 1818},
  {1860, 1904, 1944},
  {1907, 1817, 1904},
  {1758, 1819, 1903},
  {1860, 1905, 1904},
  {1907, 1822, 1817},
  {1821, 1817, 1822},
  {1760, 1862, 1863},
  {1822, 1907, 1862},
  {1907, 1863, 1862},
  {7256, 1598, 1599},
  {1865, 1598, 1910},
  {1865, 1910, 1947},
  {1598, 7313, 1991},
  {1766, 1911, 2103},
  {1825, 1767, 2034},
  {2034, 1867, 1825},
  {1913, 1867, 2034},
  {1868, 2108, 1824},
  {1826, 1948, 1768},
  {1825, 1867, 1827},
  {1771, 1952, 1651},
  {1824, 1955, 7434},
  {7434, 1955, 1948},
  {1827, 1867, 1828},
  {1867, 1949, 1828},
  {1651, 1952, 1951},
  {1918, 1777, 1657},
  {1777, 1921, 1870},
  {1870, 1921, 1830},
  {7530, 1872, 2111},
  {1713, 1921, 1956},
  {1783, 1922, 6520},
  {6520, 1922, 5997},
  {6992, 6994, 6995},
  {2112, 6392, 6993},
  {1713, 1963, 1719},
  {1719, 1963, 1785},
  {1783, 1714, 1922},
  {1832, 1831, 1922},
  {1835, 1924, 1962},
  {1964, 1833, 1875},
  {1733, 1728, 1791},
  {1791, 1874, 1733},
  {1840, 1926, 1968},
  {1843, 1840, 1839},
  {1839, 1840, 1968},
  {1839, 1968, 1877},
  {1839, 1877, 1799},
  {1877, 1804, 1799},
  {1927, 1878, 6388},
  {1842, 6388, 1878},
  {7448, 7737, 1844},
  {7574, 1805, 1880},
  {7574, 1880, 1928},
  {1846, 1881, 7058},
  {1846, 1847, 1881},
  {1742, 7570, 1929},
  {7574, 1928, 1929},
  {1881, 1847, 6313},
  {1848, 1885, 6278},
  {1741, 1888, 6937},
  {1741, 6937, 1884},
  {1850, 1744, 2144},
  {1890, 1852, 1938},
  {1851, 1889, 1935},
  {1851, 1935, 1891},
  {1893, 1892, 1811},
  {1811, 1747, 1893},
  {1937, 1893, 1747},
  {1748, 1851, 7245},
  {1891, 7246, 1851},
  {1812, 1815, 2090},
  {1639, 1979, 1936},
  {1853, 6687, 6000},
  {1639, 1936, 1815},
  {1644, 7688, 7689},
  {1893, 1937, 1898},
  {1813, 7245, 1899},
  {1856, 1898, 1813},
  {7690, 1942, 1944},
  {1856, 1857, 6990},
  {1856, 1813, 1857},
  {5996, 6470, 1900},
  {1902, 1900, 6470},
  {6470, 1818, 1902},
  {1818, 1901, 1902},
  {1860, 1984, 1595},
  {1986, 2026, 1819},
  {1904, 1905, 1907},
  {1755, 1906, 1987},
  {1864, 1597, 1908},
  {1945, 1909, 2028},
  {1864, 1908, 1823},
  {1909, 1945, 1865},
  {1945, 1598, 1865},
  {1823, 1946, 1911},
  {1947, 1910, 1992},
  {1910, 1598, 1991},
  {1767, 1912, 2034},
  {1766, 2103, 1868},
  {1867, 1913, 1914},
  {1867, 1914, 1949},
  {1915, 1948, 1955},
  {1915, 1955, 1953},
  {1915, 1995, 1948},
  {1824, 6320, 1955},
  {1996, 1995, 1915},
  {1955, 6320, 6689},
  {1918, 1921, 1777},
  {7531, 1778, 1920},
  {1921, 1871, 1830},
  {2111, 1872, 2112},
  {1919, 1778, 1998},
  {1958, 1963, 1713},
  {1958, 1713, 1956},
  {1833, 1923, 7655},
  {1714, 2002, 1922},
  {1923, 1833, 1964},
  {1960, 1835, 1962},
  {1789, 1835, 1960},
  {1785, 1963, 1838},
  {2003, 7119, 7123},
  {1725, 7089, 1837},
  {1965, 7656, 7004},
  {7092, 1874, 1837},
  {1837, 7089, 7093},
  {1789, 2001, 1925},
  {1924, 1680, 2006},
  {1966, 1733, 1874},
  {1966, 1792, 1733},
  {1792, 1967, 1841},
  {1792, 1966, 1967},
  {1843, 6748, 1840},
  {1797, 2009, 1800},
  {1800, 1969, 1879},
  {1879, 1969, 1970},
  {1879, 1970, 1803},
  {1803, 1970, 2011},
  {1803, 2011, 2068},
  {1803, 2068, 1971},
  {1845, 1803, 1971},
  {1880, 1930, 1928},
  {1880, 7737, 1971},
  {1931, 1806, 7058},
  {7058, 1881, 1882},
  {1932, 1742, 1929},
  {1881, 6313, 6294},
  {5998, 6416, 7057},
  {6637, 6762, 7419},
  {1933, 1883, 1934},
  {2017, 1742, 1932},
  {6998, 1849, 1934},
  {2016, 1934, 1849},
  {2144, 1809, 1850},
  {1887, 1743, 2017},
  {1935, 1889, 6246},
  {1890, 1744, 1690},
  {1744, 1890, 1973},
  {1890, 1938, 7665},
  {2199, 2090, 1815},
  {1815, 1936, 2199},
  {1938, 6000, 7664},
  {6687, 2090, 2022},
  {6687, 2022, 6000},
  {1895, 1897, 1938},
  {1853, 1939, 1897},
  {1853, 6000, 1939},
  {1937, 1750, 1813},
  {1937, 1813, 1898},
  {7245, 1941, 1899},
  {7688, 1900, 1940},
  {1943, 1901, 1941},
  {1901, 1899, 1941},
  {1900, 1902, 1940},
  {1901, 1943, 1902},
  {1944, 1984, 1860},
  {1903, 1819, 1985},
  {2026, 1985, 1819},
  {1595, 1984, 1906},
  {1755, 1987, 1986},
  {1905, 1863, 1907},
  {1988, 1987, 1906},
  {1945, 1989, 1597},
  {1597, 1989, 1908},
  {2030, 2028, 1909},
  {1947, 1909, 1865},
  {1991, 7313, 7314},
  {2034, 2167, 1913},
  {7314, 2035, 1991},
  {1914, 1913, 2036},
  {1914, 2036, 1949},
  {1866, 1651, 1993},
  {7314, 1993, 2035},
  {1868, 2037, 2108},
  {1949, 1994, 1916},
  {1955, 1997, 1953},
  {1915, 1953, 1996},
  {1917, 1916, 1950},
  {6747, 7579, 7578},
  {1998, 1869, 1919},
  {1921, 1918, 2044},
  {1958, 1959, 1963},
  {1922, 2002, 2000},
  {1960, 1962, 7407},
  {7742, 1959, 1964},
  {1724, 1922, 2052},
  {1964, 2227, 1923},
  {1789, 2050, 2001},
  {7742, 1964, 1875},
  {7742, 1875, 7253},
  {7121, 7124, 2048},
  {1966, 1874, 2008},
  {1841, 2055, 1927},
  {2055, 1841, 1967},
  {6548, 6758, 6016},
  {2009, 1797, 2127},
  {1797, 1878, 2127},
  {2058, 1800, 2009},
  {1970, 2066, 2011},
  {1806, 1931, 1843},
  {1928, 2135, 1929},
  {1928, 1930, 2012},
  {1880, 1971, 2136},
  {1929, 2135, 1932},
  {7058, 2139, 1931},
  {1932, 2135, 2017},
  {1934, 7331, 1933},
  {1887, 2017, 2018},
  {1887, 2018, 1888},
  {6246, 2015, 1935},
  {1935, 2015, 2019},
  {1809, 2144, 2016},
  {1973, 2144, 1744},
  {1891, 1935, 2019},
  {1894, 1891, 2091},
  {2089, 2091, 1891},
  {1936, 6436, 2199},
  {7348, 7347, 1974},
  {1936, 1979, 2147},
  {7347, 7348, 1974},
  {2093, 1894, 2091},
  {1939, 1978, 1938},
  {1938, 1978, 6000},
  {1894, 2093, 7671},
  {1939, 6000, 1978},
  {7245, 1980, 1941},
  {1897, 1939, 1938},
  {2024, 1943, 2094},
  {2094, 1943, 1981},
  {1941, 1981, 1943},
  {1981, 1941, 1980},
  {1982, 1943, 2024},
  {2206, 1944, 1942},
  {1940, 1902, 2024},
  {1982, 1902, 1943},
  {1982, 2024, 1902},
  {1983, 1979, 1903},
  {2152, 1944, 2206},
  {1983, 1903, 2025},
  {1903, 1985, 2025},
  {1989, 2029, 1908},
  {1908, 2029, 2031},
  {1908, 2031, 1823},
  {1823, 2031, 1946},
  {1768, 2165, 1912},
  {1910, 1991, 2035},
  {1910, 2035, 2040},
  {1910, 2040, 1992},
  {2036, 1913, 2167},
  {2037, 1868, 2103},
  {2039, 1992, 2040},
  {1949, 2038, 1994},
  {1768, 1948, 1995},
  {1950, 1994, 2042},
  {2042, 1994, 2105},
  {1916, 1994, 1950},
  {1651, 1951, 2104},
  {1950, 1918, 1917},
  {1921, 2044, 1956},
  {2112, 1957, 2049},
  {1958, 1956, 1999},
  {7407, 2115, 1960},
  {1789, 1960, 2115},
  {1959, 1958, 1964},
  {2226, 1961, 1924},
  {6464, 2051, 1923},
  {7655, 1923, 2051},
  {2006, 2226, 1924},
  {2004, 2005, 7094},
  {2005, 2004, 7094},
  {1724, 2052, 7095},
  {1724, 7095, 7090},
  {2006, 1876, 6023},
  {2055, 2118, 2181},
  {1967, 1966, 2054},
  {1967, 2054, 2055},
  {1874, 7092, 2008},
  {1927, 2055, 2121},
  {2328, 1968, 1926},
  {2328, 1877, 1968},
  {1878, 1927, 2127},
  {2009, 2127, 2187},
  {1800, 2010, 1969},
  {2066, 2067, 2011},
  {1931, 2073, 1843},
  {1928, 2134, 7694},
  {1930, 1880, 2136},
  {1971, 2133, 2136},
  {2139, 2137, 1931},
  {5998, 1972, 7059},
  {6457, 2193, 7250},
  {2015, 6937, 2014},
  {1934, 2016, 7331},
  {2014, 6937, 1888},
  {2142, 1888, 2018},
  {2014, 1888, 2142},
  {2144, 7331, 2016},
  {1891, 2019, 2089},
  {7666, 1938, 7664},
  {1973, 6699, 6019},
  {1936, 2147, 6332},
  {1975, 2020, 2021},
  {6002, 1977, 5999},
  {1976, 6004, 6265},
  {2093, 2095, 7671},
  {7423, 2024, 2094},
  {2094, 1981, 2095},
  {1980, 7245, 6005},
  {1855, 1854, 1896},
  {1981, 1980, 6005},
  {1940, 2149, 7041},
  {1940, 2024, 2097},
  {1983, 2098, 1979},
  {1985, 2026, 2210},
  {1986, 2210, 2026},
  {1986, 1987, 6700},
  {1906, 1984, 1988},
  {1988, 1984, 2027},
  {2027, 1987, 1988},
  {1945, 2028, 1989},
  {2031, 2101, 2032},
  {2032, 1946, 2031},
  {2032, 2101, 1990},
  {1946, 2032, 1911},
  {1990, 2033, 2032},
  {2032, 2166, 1911},
  {1947, 1992, 2262},
  {1912, 2165, 2034},
  {2035, 2109, 2040},
  {2036, 2038, 1949},
  {1992, 2039, 2217},
  {2104, 1993, 1651},
  {6006, 6001, 2041},
  {2043, 2039, 2040},
  {1996, 2106, 1995},
  {1953, 2106, 1996},
  {2109, 1951, 1952},
  {2042, 2171, 1950},
  {1952, 1869, 2109},
  {2171, 1918, 1950},
  {6020, 1953, 1997},
  {2110, 2172, 6747},
  {7530, 2111, 2363},
  {2491, 2173, 1778},
  {1778, 2173, 1998},
  {1956, 2044, 1999},
  {2112, 2049, 2223},
  {2046, 2047, 7123},
  {2047, 2045, 7123},
  {1999, 2114, 1958},
  {2046, 7123, 7402},
  {1957, 2001, 2049},
  {7407, 2113, 2115},
  {1958, 2114, 1964},
  {1961, 2226, 2113},
  {2115, 2223, 1789},
  {1789, 2223, 2050},
  {2001, 2050, 2049},
  {2052, 1922, 2000},
  {1964, 2114, 2227},
  {2052, 2000, 2002},
  {2051, 6463, 7655},
  {7655, 6463, 2228},
  {2002, 7120, 2179},
  {2179, 2117, 2002},
  {2002, 2117, 2120},
  {2002, 2120, 2052},
  {2006, 6023, 2053},
  {2118, 2055, 2054},
  {2008, 2007, 7091},
  {2122, 2234, 2121},
  {2234, 1927, 2121},
  {6513, 1843, 2337},
  {2124, 2061, 2056},
  {2058, 2009, 2235},
  {2124, 2125, 2061},
  {2127, 1927, 2234},
  {2056, 2061, 2059},
  {2060, 2125, 7174},
  {2125, 2060, 2061},
  {2058, 2010, 1800},
  {2060, 7174, 2062},
  {2061, 2065, 2059},
  {2060, 2062, 6897},
  {2060, 6896, 2061},
  {7248, 2064, 7247},
  {2061, 2071, 2065},
  {1969, 2066, 1970},
  {2068, 2011, 2067},
  {2064, 7248, 2069},
  {7250, 7247, 2064},
  {2072, 2065, 6009},
  {1928, 2012, 2134},
  {1971, 2068, 2133},
  {2064, 2070, 7250},
  {7247, 7250, 2072},
  {2075, 2072, 7250},
  {2076, 2072, 2075},
  {2075, 2077, 2076},
  {1931, 2137, 2073},
  {2076, 2078, 2072},
  {5998, 7057, 1972},
  {2013, 6415, 7058},
  {6712, 6457, 2241},
  {6457, 7250, 2138},
  {2074, 7321, 2075},
  {2075, 7321, 2077},
  {2072, 2078, 2088},
  {7249, 7251, 6011},
  {2076, 2077, 2087},
  {2076, 2087, 2078},
  {7216, 7214, 2079},
  {7216, 2079, 7214},
  {2078, 2081, 2088},
  {6011, 7251, 2083},
  {2077, 7321, 2087},
  {2078, 2087, 2084},
  {2078, 2084, 2081},
  {6919, 2014, 2140},
  {2014, 6919, 2015},
  {6920, 2015, 6919},
  {2143, 7250, 2193},
  {7250, 2143, 2080},
  {2088, 2081, 2084},
  {2142, 2140, 2014},
  {2015, 6920, 2085},
  {2015, 2085, 2019},
  {7251, 2086, 2083},
  {2084, 2087, 7215},
  {2080, 2143, 2086},
  {7215, 2087, 7213},
  {2144, 1973, 7740},
  {2091, 2089, 2145},
  {1979, 2096, 2147},
  {6012, 7422, 2023},
  {2095, 1981, 7671},
  {7688, 1940, 7041},
  {2155, 1855, 1896},
  {7423, 2149, 2024},
  {2151, 2204, 2096},
  {2096, 1979, 2151},
  {2149, 1940, 2097},
  {2024, 2149, 2097},
  {2098, 2151, 1979},
  {2098, 1983, 2153},
  {2153, 1983, 2025},
  {1986, 6700, 2210},
  {1987, 2027, 2351},
  {1989, 2100, 2029},
  {2100, 1989, 2028},
  {2030, 2163, 2028},
  {1909, 2163, 2030},
  {1909, 2262, 2163},
  {1909, 1947, 2262},
  {1990, 2161, 2164},
  {1990, 2164, 2102},
  {2166, 2032, 2033},
  {2103, 1911, 2166},
  {2168, 1990, 2102},
  {2033, 1990, 2168},
  {2036, 2167, 2038},
  {2035, 2104, 2109},
  {2035, 1993, 2104},
  {2033, 2168, 2107},
  {2037, 2103, 2108},
  {1995, 2106, 1768},
  {6006, 2041, 6001},
  {2040, 2109, 2043},
  {2104, 1951, 2109},
  {2042, 2105, 2171},
  {2109, 2039, 2043},
  {1953, 6020, 2216},
  {2109, 1869, 1998},
  {7578, 2110, 6747},
  {7531, 7532, 1778},
  {2171, 2222, 1918},
  {1918, 2222, 2044},
  {2044, 2277, 1999},
  {2175, 2176, 2046},
  {2046, 2176, 2047},
  {2047, 2225, 2045},
  {2175, 2046, 2174},
  {2047, 2176, 2225},
  {2224, 7123, 2045},
  {2174, 2046, 7402},
  {1965, 7122, 7656},
  {2049, 2050, 2223},
  {2116, 7005, 2178},
  {2006, 2053, 2226},
  {7095, 2052, 2120},
  {2118, 2054, 2119},
  {2327, 2119, 2054},
  {2054, 1966, 2327},
  {1966, 2008, 2327},
  {2231, 2327, 2008},
  {2008, 7091, 2231},
  {2057, 2234, 2123},
  {2125, 2124, 2184},
  {2187, 2235, 2009},
  {2058, 2235, 2126},
  {2123, 2186, 2057},
  {2126, 2128, 2058},
  {2129, 2125, 2184},
  {2057, 2238, 2234},
  {2058, 2128, 2010},
  {2010, 2128, 2066},
  {2010, 2066, 1969},
  {6007, 2130, 6008},
  {2130, 6007, 6008},
  {2066, 2131, 2067},
  {2067, 2133, 2068},
  {2132, 7250, 2070},
  {2132, 2070, 2063},
  {2136, 2133, 2191},
  {2073, 2292, 1843},
  {2192, 6010, 7694},
  {2137, 2139, 2240},
  {2073, 2137, 2240},
  {7058, 6415, 2241},
  {2241, 6457, 2138},
  {2135, 7164, 2296},
  {2072, 2088, 5814},
  {2135, 2296, 2017},
  {2017, 2296, 2018},
  {2085, 2141, 2142},
  {2141, 2085, 2082},
  {2086, 2143, 7320},
  {2142, 2196, 2085},
  {2085, 2196, 2089},
  {2085, 2089, 2019},
  {2089, 2196, 7680},
  {7740, 1973, 6019},
  {2146, 6003, 6813},
  {6019, 2092, 2251},
  {2090, 2199, 2298},
  {2091, 2202, 2093},
  {2253, 2093, 2202},
  {2147, 2096, 2204},
  {2148, 2406, 7423},
  {6012, 6736, 2343},
  {6013, 2093, 2253},
  {6013, 2253, 6734},
  {2406, 2205, 7423},
  {1896, 2207, 2155},
  {2303, 2155, 2207},
  {7423, 2205, 2149},
  {2150, 6322, 6323},
  {2206, 2301, 2152},
  {2150, 6323, 6322},
  {2098, 2153, 2151},
  {2258, 2153, 2025},
  {2025, 1985, 2258},
  {6701, 2256, 2154},
  {2211, 2154, 2256},
  {1944, 2152, 1984},
  {2156, 2157, 2155},
  {2155, 2212, 2156},
  {2155, 2157, 2213},
  {2351, 6700, 1987},
  {2027, 1984, 2099},
  {2027, 2099, 2351},
  {2259, 2351, 2099},
  {2158, 2029, 2100},
  {2029, 2158, 2031},
  {2163, 2160, 2028},
  {2028, 2160, 2100},
  {2159, 2100, 2160},
  {2100, 2159, 2158},
  {2162, 2158, 2159},
  {2101, 2214, 1990},
  {1990, 2214, 2161},
  {2103, 2166, 2218},
  {2216, 2165, 1768},
  {2103, 2218, 2108},
  {2166, 2033, 2107},
  {2168, 2219, 2107},
  {2166, 2107, 2218},
  {1768, 2106, 2216},
  {1994, 2038, 7576},
  {2107, 2219, 2169},
  {2358, 2217, 2039},
  {2216, 2106, 1953},
  {2039, 2109, 2358},
  {2107, 1954, 2218},
  {2107, 2169, 2170},
  {2108, 2218, 1954},
  {2107, 2170, 1954},
  {2170, 2169, 2270},
  {1954, 2170, 2110},
  {2170, 2270, 2110},
  {2171, 2268, 2222},
  {2109, 1998, 2221},
  {2111, 2112, 2273},
  {2658, 2173, 2491},
  {2222, 2272, 2044},
  {2175, 2174, 2321},
  {2321, 2174, 2275},
  {6450, 6449, 2177},
  {2224, 2045, 2225},
  {2275, 2174, 7402},
  {2176, 2274, 2225},
  {2003, 7123, 2224},
  {2178, 7005, 2116},
  {2117, 2179, 6014},
  {2118, 2119, 2230},
  {6015, 6022, 2120},
  {2120, 6022, 7095},
  {2231, 7091, 7066},
  {2182, 7066, 7091},
  {2183, 2056, 2059},
  {2056, 2183, 2124},
  {2184, 2124, 2332},
  {2334, 2186, 2123},
  {2126, 2188, 2128},
  {2185, 2129, 2184},
  {2128, 2188, 2237},
  {2186, 2290, 2057},
  {2234, 2238, 2127},
  {2128, 2237, 6017},
  {2189, 2057, 2290},
  {2057, 2189, 2238},
  {6017, 2066, 2128},
  {2337, 1843, 2292},
  {6897, 2062, 6347},
  {2131, 2190, 2067},
  {2191, 2067, 2190},
  {2067, 2191, 2133},
  {2138, 7250, 2132},
  {2134, 2012, 2242},
  {1930, 2242, 2012},
  {2292, 2073, 2240},
  {2240, 2139, 2292},
  {2241, 2139, 7058},
  {2241, 6927, 2139},
  {2072, 5814, 2065},
  {2296, 7164, 2242},
  {6018, 2142, 2141},
  {7331, 2144, 2243},
  {2143, 6803, 7321},
  {2018, 2195, 2142},
  {2193, 2194, 2143},
  {7321, 6803, 2087},
  {2018, 2296, 2195},
  {2195, 2245, 2142},
  {2196, 2142, 2245},
  {6025, 6592, 2145},
  {6025, 6026, 6592},
  {6319, 6437, 2201},
  {2091, 2145, 2202},
  {2145, 6592, 2200},
  {2199, 6332, 2298},
  {2145, 2200, 2202},
  {2092, 6879, 2251},
  {2343, 7422, 6012},
  {6735, 6737, 7636},
  {1942, 1855, 2206},
  {2301, 2206, 1855},
  {2151, 2208, 2204},
  {1855, 2155, 2301},
  {2255, 2301, 2155},
  {7041, 2149, 2205},
  {2153, 2208, 2151},
  {2155, 2303, 2209},
  {2155, 2209, 2212},
  {1985, 2210, 2258},
  {2155, 2257, 2255},
  {2155, 2213, 2257},
  {2422, 2099, 1984},
  {2099, 2305, 2259},
  {2031, 2158, 2101},
  {2158, 2162, 2215},
  {2163, 6638, 2160},
  {2160, 6638, 2264},
  {2160, 2264, 2159},
  {2158, 2215, 2101},
  {2159, 2264, 2162},
  {2162, 2264, 2215},
  {2264, 2265, 2215},
  {2219, 2102, 2164},
  {2168, 2102, 2219},
  {2309, 2165, 2266},
  {2309, 2167, 2165},
  {2165, 2312, 2266},
  {2165, 2167, 2034},
  {2312, 2165, 2216},
  {2217, 2310, 1992},
  {2317, 2358, 2109},
  {2169, 2219, 2270},
  {2216, 6020, 2319},
  {2491, 1778, 2271},
  {2111, 2273, 2363},
  {2112, 2223, 2273},
  {1998, 2173, 2221},
  {2044, 2272, 2277},
  {6450, 2177, 6449},
  {2175, 2274, 2176},
  {2276, 2224, 2225},
  {2227, 2114, 1999},
  {1999, 2277, 2227},
  {2324, 2225, 2274},
  {2366, 2003, 2224},
  {2367, 2113, 2226},
  {2113, 2367, 2115},
  {2223, 2115, 2367},
  {2227, 2228, 6463},
  {2227, 2277, 2228},
  {2226, 2053, 2278},
  {2179, 2229, 6014},
  {6014, 2229, 2233},
  {6014, 2233, 6021},
  {2119, 2327, 2279},
  {7095, 6022, 7088},
  {2124, 2183, 2329},
  {2059, 2282, 2183},
  {2332, 2185, 2184},
  {2126, 2235, 2188},
  {6513, 2337, 2387},
  {2185, 6030, 2132},
  {2185, 2132, 2129},
  {2286, 2127, 2238},
  {2338, 2127, 2286},
  {2237, 2190, 6017},
  {2189, 2290, 2238},
  {6030, 2239, 2132},
  {2289, 2239, 6029},
  {2065, 2291, 2059},
  {2288, 6386, 2190},
  {2132, 2239, 2293},
  {6386, 2136, 2190},
  {2191, 2190, 2136},
  {2132, 2293, 2138},
  {2136, 2242, 1930},
  {7694, 2134, 2242},
  {7694, 2242, 2192},
  {2294, 2241, 2138},
  {2065, 5814, 7274},
  {2244, 2249, 6678},
  {6803, 2143, 2194},
  {2197, 6024, 2198},
  {6678, 2249, 2203},
  {2342, 7697, 7698},
  {7697, 2342, 6027},
  {2247, 6592, 2342},
  {6592, 2247, 2200},
  {6019, 2297, 7740},
  {2022, 2090, 2298},
  {2298, 6332, 2587},
  {2246, 7337, 2248},
  {2344, 2297, 6019},
  {2251, 2344, 6019},
  {2147, 2204, 2299},
  {2202, 2345, 2253},
  {7337, 2254, 2248},
  {2251, 2022, 2298},
  {2406, 2148, 2250},
  {2250, 7404, 2406},
  {2404, 2254, 7337},
  {2207, 6543, 2303},
  {6544, 6545, 2205},
  {2153, 2258, 2208},
  {2152, 2301, 2302},
  {2209, 2304, 2212},
  {2258, 2210, 2350},
  {2154, 2211, 6701},
  {2212, 2304, 2213},
  {2152, 2302, 2422},
  {2152, 2422, 1984},
  {6700, 2351, 7109},
  {2214, 2260, 2161},
  {2306, 2163, 2262},
  {2261, 2163, 2306},
  {2215, 6847, 2101},
  {6848, 2101, 6847},
  {2355, 2101, 6848},
  {2264, 2357, 2265},
  {6847, 2215, 2265},
  {2307, 2264, 2548},
  {2264, 2307, 2357},
  {2311, 2265, 2357},
  {6467, 2265, 2311},
  {2265, 6467, 6847},
  {2262, 1992, 2310},
  {2428, 2167, 2309},
  {2358, 2310, 2217},
  {2167, 7576, 2038},
  {7576, 2315, 1994},
  {2105, 1994, 2171},
  {1994, 2318, 2267},
  {2267, 2318, 2269},
  {2267, 2269, 2361},
  {2318, 2220, 2269},
  {2319, 2553, 2216},
  {2270, 2172, 2110},
  {2271, 1778, 7532},
  {2220, 2320, 2274},
  {2361, 2175, 2359},
  {2275, 2322, 2321},
  {2276, 2366, 2224},
  {7403, 2277, 2275},
  {2275, 7402, 7403},
  {2274, 2323, 2324},
  {2225, 2324, 2366},
  {2277, 7403, 2228},
  {2278, 2369, 2226},
  {6023, 2278, 2053},
  {2279, 2230, 2119},
  {2181, 2118, 2280},
  {2230, 2280, 2118},
  {6417, 2180, 1877},
  {2121, 2055, 2280},
  {2055, 2181, 2280},
  {2328, 6417, 1877},
  {2121, 2280, 2122},
  {2328, 6513, 2386},
  {2183, 2330, 2329},
  {2124, 2329, 2332},
  {2123, 2234, 2334},
  {2283, 2236, 2333},
  {2333, 2236, 2186},
  {2185, 2335, 6030},
  {2281, 2188, 2235},
  {2282, 2388, 2183},
  {2188, 2281, 2237},
  {2187, 2127, 2284},
  {2237, 2389, 2190},
  {2127, 2338, 2284},
  {2389, 2391, 2190},
  {2059, 2291, 2282},
  {6865, 6032, 6866},
  {2190, 2391, 2288},
  {6660, 2287, 6374},
  {2285, 2289, 6029},
  {2290, 2453, 2238},
  {2289, 2293, 2239},
  {2339, 2292, 2139},
  {6927, 2339, 2139},
  {2294, 2293, 6927},
  {2293, 2294, 2138},
  {7274, 2291, 2065},
  {2242, 2136, 2395},
  {6927, 2241, 2294},
  {2249, 2244, 2397},
  {7739, 7740, 2193},
  {2399, 2195, 2296},
  {2245, 2195, 2399},
  {2342, 7698, 6632},
  {2202, 2200, 2462},
  {2300, 6031, 7422},
  {6544, 2205, 2347},
  {2408, 2405, 7337},
  {2301, 2255, 2302},
  {2471, 2208, 2258},
  {2208, 2471, 2204},
  {2258, 2595, 2471},
  {2211, 2256, 6701},
  {2257, 2304, 2209},
  {2257, 2209, 2255},
  {2304, 2257, 2213},
  {2258, 2421, 2595},
  {2350, 2210, 2473},
  {2422, 2305, 2099},
  {2101, 2353, 2214},
  {2547, 2164, 2161},
  {2261, 2263, 2163},
  {2263, 2548, 2264},
  {2266, 2356, 2309},
  {2164, 2354, 2219},
  {2312, 2216, 6916},
  {2314, 6916, 2216},
  {2315, 2316, 1994},
  {1994, 2316, 2318},
  {2219, 2432, 2270},
  {2109, 2221, 2317},
  {1994, 2267, 2171},
  {2267, 2361, 2171},
  {2361, 2269, 2220},
  {2320, 2220, 2433},
  {2319, 6020, 2553},
  {2172, 2270, 6620},
  {2268, 2360, 2321},
  {2361, 2220, 2274},
  {2274, 2320, 2362},
  {2268, 2321, 2222},
  {2274, 2362, 2364},
  {2222, 2321, 2322},
  {2222, 2322, 2272},
  {2361, 2274, 2175},
  {2365, 2274, 2364},
  {2367, 2273, 2223},
  {2272, 2322, 2277},
  {2322, 2275, 2277},
  {2366, 2276, 2225},
  {2367, 2226, 2369},
  {2179, 2003, 2366},
  {2366, 2368, 2179},
  {2229, 2325, 6028},
  {2326, 6028, 2325},
  {2326, 2325, 2444},
  {2327, 2280, 2230},
  {2230, 2279, 2327},
  {2326, 2232, 6028},
  {2330, 2375, 2329},
  {2280, 2327, 2331},
  {2234, 2382, 2334},
  {2234, 2122, 2382},
  {2122, 2280, 2382},
  {2183, 2383, 2330},
  {2186, 2334, 2333},
  {2335, 2185, 2332},
  {2387, 2386, 6513},
  {2335, 2384, 6030},
  {2183, 2388, 2383},
  {2235, 2385, 2281},
  {2339, 7696, 7704},
  {2237, 2281, 2385},
  {2336, 2388, 2282},
  {2187, 2623, 2235},
  {2385, 2389, 2237},
  {2284, 2623, 2187},
  {2285, 7696, 2339},
  {2291, 2336, 2282},
  {2285, 2339, 2289},
  {2186, 2236, 2290},
  {2238, 2669, 2286},
  {2238, 2453, 2570},
  {2337, 2292, 2339},
  {2293, 2289, 2339},
  {6386, 2395, 2136},
  {2339, 6927, 2293},
  {2397, 2522, 2249},
  {2194, 2683, 6803},
  {2247, 2400, 2200},
  {2246, 2248, 2584},
  {2463, 2584, 2248},
  {2248, 2254, 2463},
  {2147, 2587, 6332},
  {2204, 2401, 2299},
  {2343, 2300, 7422},
  {2345, 2202, 2462},
  {2402, 2463, 2254},
  {2343, 2252, 2526},
  {2404, 2402, 2254},
  {2590, 2401, 2204},
  {2252, 2253, 2526},
  {2346, 2526, 2253},
  {2253, 2345, 2346},
  {2249, 2408, 2203},
  {2405, 2404, 7337},
  {2205, 2406, 2347},
  {2468, 2590, 2204},
  {2407, 2405, 2408},
  {2204, 2409, 2468},
  {6610, 2348, 2303},
  {2471, 2409, 2204},
  {2349, 2255, 2209},
  {2349, 2209, 2303},
  {2303, 2348, 2349},
  {2421, 2258, 2350},
  {7109, 2351, 2598},
  {2259, 2352, 2351},
  {2259, 2305, 2352},
  {2482, 2214, 2353},
  {2260, 2214, 2482},
  {2101, 2485, 2353},
  {2306, 2262, 2549},
  {2354, 2164, 2547},
  {2548, 2426, 2307},
  {2307, 2426, 2357},
  {2308, 2427, 6035},
  {2266, 2312, 2356},
  {6916, 2356, 2312},
  {2356, 6916, 2428},
  {2314, 2486, 6916},
  {2216, 2553, 2314},
  {2316, 2430, 2318},
  {2430, 2431, 2318},
  {2433, 2220, 2318},
  {2317, 2221, 2806},
  {2268, 2171, 2359},
  {2268, 2359, 2360},
  {2433, 2362, 2320},
  {6620, 2270, 6619},
  {2359, 2171, 2361},
  {2432, 2552, 2270},
  {2175, 2321, 2360},
  {2359, 2175, 2360},
  {2273, 2367, 6997},
  {2173, 2658, 2221},
  {2274, 2365, 6036},
  {6036, 2323, 2274},
  {6036, 2365, 6038},
  {2323, 6036, 2324},
  {2324, 6036, 2366},
  {2368, 2435, 2179},
  {2369, 2278, 2499},
  {2179, 2435, 2229},
  {2370, 2437, 2373},
  {2373, 2372, 2370},
  {2370, 2372, 2371},
  {2440, 2371, 2372},
  {2371, 2440, 2436},
  {2325, 2229, 2435},
  {2374, 2325, 2439},
  {2325, 2374, 2444},
  {2373, 2558, 2372},
  {2327, 2231, 2377},
  {2231, 2440, 2377},
  {2231, 7066, 2440},
  {2375, 2376, 2329},
  {2375, 2330, 2388},
  {2375, 2388, 2376},
  {2558, 2503, 2372},
  {2440, 2372, 2503},
  {2440, 7066, 2441},
  {7066, 7268, 2444},
  {7066, 2444, 2441},
  {2328, 2386, 2445},
  {2280, 2331, 2448},
  {2331, 2378, 2448},
  {2331, 2327, 2378},
  {2448, 2378, 2380},
  {2335, 2332, 2381},
  {2446, 2379, 2333},
  {2334, 2382, 2449},
  {2382, 2280, 2506},
  {2333, 2334, 2504},
  {2385, 2235, 2622},
  {2387, 2337, 2339},
  {2283, 2333, 2667},
  {2389, 2385, 2624},
  {2336, 2390, 2388},
  {2284, 2669, 2623},
  {2284, 2338, 2669},
  {2286, 2669, 2338},
  {6661, 2389, 2451},
  {2390, 2336, 2392},
  {2392, 2336, 2394},
  {2291, 2394, 2336},
  {6034, 2393, 2340},
  {2394, 2291, 2396},
  {2515, 2242, 2395},
  {2515, 2395, 2511},
  {6893, 7275, 2396},
  {2458, 2455, 6893},
  {6893, 2396, 2458},
  {2398, 2573, 2244},
  {2397, 2456, 2522},
  {2247, 2342, 2521},
  {2247, 2521, 2400},
  {2683, 2194, 2193},
  {6803, 2683, 2461},
  {7740, 2297, 2523},
  {2400, 2462, 2200},
  {2147, 2299, 2587},
  {2343, 2526, 2300},
  {2344, 2640, 2464},
  {2298, 2587, 2251},
  {2587, 2299, 2465},
  {2299, 2401, 2465},
  {2345, 2403, 2346},
  {6711, 2412, 6611},
  {2537, 2412, 6711},
  {2469, 2410, 2255},
  {2255, 2349, 2411},
  {2255, 2411, 2469},
  {2349, 2348, 6037},
  {2413, 2412, 2537},
  {2255, 2410, 2302},
  {7108, 2472, 6926},
  {2302, 2410, 2414},
  {2470, 2412, 2413},
  {2415, 2470, 2413},
  {2415, 2419, 2418},
  {2419, 2417, 6909},
  {2417, 2419, 6909},
  {2422, 2302, 2423},
  {2418, 2416, 2420},
  {2418, 2416, 2420},
  {2422, 2423, 2475},
  {2422, 2475, 2305},
  {2352, 2477, 2351},
  {2479, 2425, 2478},
  {2260, 2482, 2546},
  {2260, 2546, 2161},
  {2261, 2601, 2263},
  {2485, 2101, 6035},
  {2262, 2310, 2549},
  {2356, 2428, 2309},
  {2550, 2429, 2428},
  {2167, 2428, 2429},
  {2167, 2429, 2313},
  {2313, 2429, 2430},
  {2429, 2431, 2430},
  {6033, 2430, 2315},
  {2315, 2430, 2316},
  {2219, 2551, 2432},
  {2486, 2314, 2487},
  {2431, 6915, 2318},
  {2806, 2606, 2317},
  {2314, 2553, 2487},
  {2318, 6915, 2433},
  {6677, 2364, 2488},
  {2364, 2362, 2488},
  {2491, 2271, 7532},
  {2273, 2491, 2363},
  {6677, 2365, 2364},
  {6677, 6038, 2365},
  {6677, 2495, 6038},
  {2434, 2366, 2614},
  {2366, 2434, 2368},
  {2436, 2616, 2371},
  {2497, 2436, 2438},
  {2436, 2440, 2438},
  {2435, 2439, 2325},
  {2373, 2437, 2558},
  {2440, 2441, 2438},
  {2441, 2444, 2438},
  {2374, 2439, 2444},
  {2442, 2329, 2443},
  {2376, 2443, 2329},
  {2376, 2388, 2443},
  {2377, 2440, 2327},
  {2445, 6417, 2328},
  {2327, 2440, 2503},
  {2445, 2386, 2502},
  {2503, 2378, 2327},
  {2447, 2381, 2329},
  {2332, 2329, 2381},
  {2446, 2333, 2504},
  {2503, 2448, 2380},
  {2380, 2378, 2503},
  {2335, 2447, 2384},
  {2447, 2335, 2381},
  {2383, 2388, 2330},
  {2450, 2449, 2382},
  {2382, 2506, 2450},
  {7704, 2564, 2339},
  {7292, 6582, 6751},
  {2334, 2449, 5816},
  {2622, 2235, 2623},
  {2386, 2387, 2339},
  {2624, 2385, 2566},
  {2236, 2283, 2667},
  {2451, 2510, 6373},
  {2290, 2236, 2453},
  {6373, 2510, 6434},
  {2568, 2392, 2452},
  {2511, 2395, 2571},
  {7201, 2514, 7200},
  {2455, 2454, 6893},
  {2295, 2396, 2291},
  {2458, 2396, 2459},
  {2244, 2573, 2516},
  {2244, 2516, 2397},
  {2456, 2517, 6333},
  {2341, 2676, 2295},
  {2296, 2242, 2519},
  {2296, 2519, 2399},
  {7698, 2399, 2519},
  {2456, 6333, 2522},
  {2521, 2342, 2460},
  {2246, 2584, 2398},
  {2341, 6925, 2676},
  {2400, 2521, 2524},
  {2462, 2400, 2524},
  {2300, 2586, 6031},
  {2344, 2464, 2297},
  {2344, 2251, 2640},
  {2527, 2526, 2346},
  {2345, 2462, 2403},
  {6043, 6474, 2405},
  {2346, 2403, 2527},
  {2534, 2533, 2405},
  {2405, 2407, 2534},
  {2407, 2408, 2467},
  {2535, 2467, 2408},
  {2469, 2591, 2410},
  {6913, 2411, 6473},
  {2594, 2409, 2471},
  {2409, 2594, 2468},
  {2591, 2414, 2410},
  {2538, 2415, 2413},
  {2415, 2538, 2419},
  {2418, 2419, 2538},
  {2302, 2414, 2423},
  {2415, 2418, 2470},
  {2418, 2416, 2470},
  {2418, 2596, 2416},
  {7580, 2416, 2596},
  {2351, 2477, 2598},
  {2352, 2475, 2477},
  {2475, 2352, 2305},
  {2478, 2544, 2479},
  {2424, 2482, 2353},
  {2481, 2424, 2353},
  {2601, 2261, 2480},
  {2545, 2481, 2484},
  {2484, 2485, 2483},
  {2484, 2481, 2485},
  {2481, 2353, 2485},
  {2425, 2602, 2483},
  {2483, 2602, 2484},
  {2161, 2546, 2547},
  {2485, 2425, 2483},
  {2427, 6890, 2425},
  {2425, 2485, 2427},
  {6035, 2427, 2485},
  {2427, 6849, 6890},
  {2549, 2310, 2863},
  {2426, 2425, 2357},
  {2425, 6890, 2357},
  {2219, 2354, 2604},
  {2604, 2605, 2219},
  {2605, 2551, 2219},
  {2317, 2606, 2358},
  {2362, 5820, 2488},
  {2362, 2433, 2554},
  {2489, 7442, 7443},
  {2714, 2806, 2221},
  {2555, 2487, 2553},
  {2492, 2487, 2555},
  {2494, 2492, 2555},
  {2495, 6677, 2656},
  {2493, 2491, 2273},
  {2658, 2491, 2716},
  {6997, 2493, 2273},
  {2555, 2557, 2494},
  {6259, 2495, 2496},
  {2366, 6036, 6259},
  {6259, 2496, 2366},
  {2366, 2496, 2614},
  {6997, 2367, 2369},
  {2368, 2434, 2435},
  {2370, 2615, 2437},
  {2371, 2615, 2370},
  {2615, 2371, 2616},
  {2616, 2436, 2617},
  {2436, 2497, 2617},
  {2438, 2498, 2497},
  {2498, 2438, 2435},
  {2498, 2435, 2434},
  {2278, 6023, 2499},
  {6039, 6040, 2500},
  {2438, 2439, 2435},
  {2443, 2501, 2442},
  {2501, 2443, 2388},
  {2438, 2444, 2439},
  {2445, 2502, 6417},
  {2442, 2561, 2329},
  {2558, 2560, 2503},
  {2561, 2384, 2447},
  {2561, 2447, 2329},
  {7291, 2384, 2561},
  {2280, 5815, 2506},
  {5816, 2504, 2334},
  {2386, 2339, 2564},
  {2390, 2509, 2508},
  {2508, 2388, 2390},
  {2449, 2450, 5816},
  {2385, 2622, 2566},
  {2333, 2379, 2667},
  {2509, 2390, 7077},
  {2451, 2389, 2624},
  {7077, 2390, 2392},
  {2667, 2668, 2236},
  {7077, 2392, 2568},
  {2238, 2570, 2669},
  {7113, 7114, 2569},
  {2512, 2569, 7114},
  {6675, 6893, 6356},
  {6893, 2513, 6356},
  {6893, 2454, 2513},
  {6862, 2455, 6381},
  {6862, 2454, 2455},
  {6381, 2455, 6042},
  {2455, 2458, 6042},
  {2515, 2518, 2242},
  {2516, 2456, 2397},
  {2518, 2519, 2242},
  {2730, 2519, 2518},
  {7360, 2572, 7359},
  {2839, 2573, 2398},
  {2458, 2459, 2734},
  {6632, 7698, 2519},
  {2460, 6632, 2519},
  {2519, 2520, 2460},
  {2520, 2577, 2460},
  {2521, 2460, 2577},
  {2342, 6632, 2460},
  {2193, 7740, 2683},
  {2525, 2523, 2297},
  {7740, 2523, 2736},
  {2522, 6939, 2249},
  {2639, 2525, 2297},
  {2586, 2585, 6031},
  {2526, 2586, 2300},
  {2462, 2524, 2403},
  {2401, 2529, 2465},
  {6043, 2405, 2528},
  {2465, 2529, 2587},
  {7000, 2401, 2590},
  {2528, 2405, 2466},
  {2585, 2686, 7404},
  {2641, 2408, 2249},
  {2406, 2531, 6711},
  {2406, 2686, 2531},
  {2532, 6711, 2531},
  {2405, 2533, 2588},
  {2405, 2588, 2466},
  {2407, 2467, 2534},
  {2408, 2641, 2535},
  {6711, 2532, 2537},
  {2411, 6913, 2469},
  {2590, 2468, 2594},
  {2536, 2414, 2591},
  {2538, 2413, 2537},
  {2536, 2539, 2414},
  {2423, 2414, 2539},
  {2596, 2418, 2538},
  {2477, 2539, 2642},
  {2642, 2643, 2477},
  {2475, 2539, 2477},
  {2539, 2475, 2423},
  {2595, 2421, 2350},
  {2350, 2473, 2595},
  {2745, 2595, 2473},
  {2473, 7109, 2745},
  {7580, 2596, 2476},
  {2476, 6644, 7580},
  {2540, 6041, 7477},
  {2541, 7477, 6041},
  {2542, 2693, 2544},
  {2544, 2693, 2479},
  {2543, 2542, 2478},
  {2542, 2544, 2478},
  {2543, 2478, 2480},
  {2424, 2600, 2482},
  {2601, 2480, 2478},
  {2481, 2600, 2424},
  {2261, 2306, 2480},
  {2549, 2480, 2306},
  {2601, 2478, 2548},
  {2425, 2548, 2478},
  {2425, 2748, 2602},
  {2602, 2545, 2484},
  {2601, 2548, 2263},
  {2425, 2426, 2548},
  {2604, 2354, 2547},
  {2310, 2358, 2863},
  {2428, 6916, 7157},
  {2429, 6915, 2431},
  {2429, 2550, 6915},
  {2358, 2707, 2705},
  {2486, 2709, 2708},
  {2358, 2606, 2707},
  {2552, 2432, 6045},
  {2607, 2433, 6915},
  {2554, 2433, 2607},
  {2554, 5820, 2362},
  {7443, 7442, 2489},
  {2553, 6546, 2490},
  {2553, 2715, 2555},
  {2492, 2610, 2487},
  {2492, 2494, 2610},
  {2493, 6997, 2556},
  {2555, 2612, 2557},
  {2494, 2717, 2610},
  {2557, 2717, 2494},
  {2557, 2613, 2717},
  {2437, 2615, 6435},
  {2815, 6657, 2618},
  {2618, 6417, 2761},
  {2502, 2559, 6417},
  {2502, 2386, 2559},
  {2563, 2561, 2562},
  {2563, 2562, 2561},
  {2560, 2448, 2503},
  {2763, 2505, 6558},
  {2565, 6359, 6358},
  {6359, 2565, 6358},
  {2723, 6751, 6582},
  {2621, 6583, 2507},
  {5816, 2450, 5815},
  {2667, 2379, 6650},
  {2669, 2832, 2623},
  {2451, 2624, 2510},
  {7113, 2569, 7140},
  {2395, 6434, 2510},
  {2513, 2454, 6862},
  {7200, 2514, 7201},
  {2396, 2295, 2575},
  {2516, 2671, 2456},
  {2456, 2574, 2517},
  {2396, 2575, 2459},
  {2295, 2676, 2575},
  {2634, 2519, 2628},
  {7100, 2574, 2456},
  {2574, 7099, 7241},
  {2632, 7241, 7099},
  {7241, 2632, 2457},
  {2459, 2575, 2637},
  {2520, 2519, 2634},
  {2634, 2576, 2520},
  {2577, 2520, 2576},
  {2581, 2583, 2633},
  {2734, 2459, 2637},
  {2580, 2522, 6333},
  {6925, 2679, 2676},
  {2577, 2582, 2521},
  {2581, 2638, 2583},
  {2839, 2398, 2584},
  {6618, 6939, 2522},
  {2524, 2521, 2682},
  {2523, 2525, 2736},
  {2683, 2684, 2461},
  {2524, 2682, 2403},
  {2525, 2639, 2736},
  {2527, 2403, 2685},
  {2584, 2528, 2466},
  {2584, 2466, 2530},
  {2584, 2530, 2839},
  {2584, 6044, 2528},
  {2251, 2587, 2640},
  {2686, 2406, 7404},
  {2739, 2641, 2249},
  {2532, 2531, 2686},
  {2466, 2588, 2530},
  {2687, 2588, 2533},
  {2533, 2534, 2687},
  {2589, 2534, 2467},
  {2535, 2589, 2467},
  {2591, 2469, 2593},
  {2532, 2592, 2537},
  {2539, 2536, 2642},
  {6913, 2593, 2469},
  {2537, 2592, 2538},
  {2538, 2592, 2596},
  {2470, 2416, 2474},
  {2598, 2745, 7109},
  {2643, 2598, 2477},
  {2474, 7478, 2597},
  {2599, 2542, 2543},
  {2599, 2693, 2542},
  {2646, 2543, 2480},
  {2646, 2692, 2543},
  {2543, 2692, 2599},
  {2480, 2647, 2646},
  {2481, 2545, 2600},
  {2600, 2603, 2482},
  {2480, 2549, 2647},
  {2545, 2602, 2600},
  {2600, 2602, 2648},
  {2600, 2648, 2603},
  {2648, 2602, 2750},
  {2605, 6339, 2551},
  {2758, 6045, 6340},
  {6045, 2758, 2552},
  {2486, 2654, 2709},
  {2608, 6047, 6048},
  {5822, 2488, 5820},
  {6546, 2655, 2490},
  {2487, 2610, 2486},
  {2553, 2490, 2609},
  {2493, 2713, 2491},
  {2811, 2713, 2556},
  {6309, 2611, 2612},
  {6309, 2612, 2611},
  {2557, 2612, 2613},
  {2656, 7625, 2495},
  {2495, 7625, 2615},
  {2496, 2495, 2614},
  {2495, 2498, 2614},
  {2614, 2498, 2434},
  {2615, 2616, 2495},
  {2616, 2617, 2495},
  {2617, 2497, 2495},
  {2497, 2498, 2495},
  {2619, 6295, 2620},
  {2442, 2620, 2561},
  {2619, 2620, 6295},
  {2559, 2386, 2719},
  {2620, 2663, 2561},
  {6558, 2446, 2763},
  {2446, 2504, 2763},
  {2664, 2448, 2560},
  {2386, 6752, 2719},
  {7373, 2719, 6752},
  {2664, 2280, 2448},
  {2561, 2663, 6549},
  {7291, 2561, 6549},
  {2505, 2763, 7165},
  {2504, 5816, 2722},
  {2566, 2622, 2725},
  {6292, 6367, 6369},
  {2622, 2623, 2726},
  {7113, 7140, 6051},
  {2624, 2728, 2510},
  {7140, 2569, 6052},
  {2669, 2777, 2832},
  {2236, 2835, 2453},
  {2571, 2395, 2729},
  {2512, 2625, 2569},
  {2569, 2625, 6453},
  {2453, 2836, 2570},
  {2669, 2570, 2836},
  {2515, 2730, 2518},
  {2515, 2511, 2730},
  {2626, 6695, 2516},
  {2626, 2573, 7556},
  {2626, 2516, 2573},
  {6871, 7359, 2572},
  {2730, 2627, 2519},
  {2519, 2627, 2628},
  {2630, 6697, 6934},
  {2628, 2633, 2634},
  {2634, 2635, 2576},
  {2577, 2576, 2635},
  {7210, 7211, 7209},
  {7099, 7566, 2632},
  {2636, 2630, 6745},
  {2458, 2636, 6745},
  {2730, 2633, 2627},
  {2628, 2627, 2633},
  {2633, 2579, 2634},
  {7565, 2674, 7564},
  {2636, 2458, 2734},
  {2633, 2583, 2579},
  {2634, 2579, 2635},
  {2582, 2635, 2579},
  {2635, 2582, 2577},
  {6617, 6618, 2580},
  {6382, 2680, 2578},
  {2581, 2578, 2680},
  {2522, 2580, 6618},
  {2734, 2637, 2842},
  {2579, 2583, 2582},
  {2582, 2681, 2521},
  {2685, 2403, 2682},
  {2297, 2464, 2792},
  {2464, 2640, 2792},
  {2687, 2530, 2588},
  {2589, 2687, 2534},
  {2589, 2535, 2641},
  {2592, 2532, 2686},
  {2740, 2591, 2593},
  {6913, 2740, 2593},
  {2595, 2743, 2471},
  {2592, 7675, 2596},
  {2597, 2470, 2474},
  {2598, 2643, 2644},
  {2470, 2597, 6263},
  {3028, 2595, 2745},
  {2745, 2598, 2644},
  {2596, 7675, 7582},
  {7584, 2541, 6041},
  {2599, 2692, 2645},
  {2599, 2645, 2693},
  {2479, 2693, 2425},
  {2482, 2899, 2546},
  {2602, 2748, 2750},
  {2546, 2899, 2649},
  {2750, 2650, 2648},
  {6659, 2649, 6658},
  {2546, 2862, 2547},
  {2549, 2749, 2647},
  {2750, 2651, 2650},
  {2549, 2863, 2749},
  {2604, 2701, 2605},
  {6339, 2605, 2701},
  {2705, 2863, 2358},
  {2607, 6915, 2652},
  {2607, 2652, 2653},
  {2607, 2653, 2756},
  {2607, 2756, 5824},
  {2607, 5824, 5821},
  {2490, 2655, 2609},
  {2486, 2610, 2711},
  {2488, 7444, 6677},
  {2491, 2713, 2657},
  {2714, 2221, 2658},
  {2711, 2610, 2717},
  {2493, 2556, 2713},
  {2612, 6308, 2659},
  {2659, 6308, 2612},
  {2613, 2660, 2717},
  {7625, 7024, 2615},
  {2369, 2814, 6997},
  {2369, 2499, 2661},
  {2369, 2661, 2814},
  {2437, 6601, 2662},
  {2815, 2618, 2761},
  {2442, 2501, 2388},
  {2558, 2437, 2720},
  {2721, 2560, 2558},
  {2763, 2504, 2722},
  {2560, 2721, 2664},
  {2665, 6050, 6054},
  {2665, 6054, 6050},
  {2508, 2509, 7561},
  {6370, 6293, 2567},
  {2727, 2566, 2725},
  {2668, 2667, 2831},
  {2566, 2727, 2624},
  {6650, 2666, 2667},
  {2236, 2668, 2835},
  {2833, 2395, 2510},
  {2729, 2395, 2833},
  {2511, 2571, 2730},
  {2571, 2779, 2730},
  {6356, 2513, 6862},
  {6055, 2516, 6695},
  {6055, 2671, 2516},
  {2774, 2671, 6055},
  {6935, 6936, 6863},
  {2780, 7555, 2629},
  {2456, 2671, 2631},
  {7566, 7099, 7101},
  {2630, 2636, 6581},
  {2630, 6581, 6697},
  {6383, 2578, 2633},
  {2581, 2633, 2578},
  {6383, 2633, 2783},
  {2734, 2675, 6053},
  {2676, 2637, 2575},
  {2674, 2677, 7564},
  {7564, 2677, 2678},
  {6925, 7163, 6371},
  {2581, 2680, 2845},
  {2581, 2845, 2638},
  {2582, 2583, 2681},
  {2521, 2681, 2682},
  {2685, 2786, 2526},
  {2736, 2639, 2737},
  {7740, 2736, 2683},
  {2586, 2526, 2786},
  {2526, 2527, 2685},
  {2585, 2787, 2686},
  {6939, 2791, 2249},
  {2639, 2297, 3091},
  {2297, 2792, 3091},
  {2529, 6999, 7003},
  {2529, 7003, 2587},
  {2249, 2791, 2739},
  {2739, 2589, 2641},
  {2592, 2686, 2977},
  {2740, 2688, 2591},
  {2689, 2740, 6913},
  {2594, 2471, 2743},
  {2689, 6913, 7307},
  {6251, 7307, 6913},
  {2592, 2742, 7675},
  {2690, 2595, 2691},
  {2643, 2642, 2644},
  {2644, 2642, 2745},
  {3028, 2691, 2595},
  {2746, 2645, 2692},
  {2645, 2746, 2747},
  {2645, 2747, 2859},
  {2645, 2859, 2693},
  {2646, 2647, 2694},
  {2425, 2693, 7723},
  {2482, 2603, 2899},
  {2603, 2648, 3036},
  {2648, 2650, 3036},
  {2750, 2751, 2696},
  {2547, 2862, 2604},
  {2750, 2696, 2651},
  {2651, 2696, 2698},
  {2651, 2698, 2700},
  {2701, 2697, 2702},
  {2698, 2699, 2700},
  {2698, 2699, 2700},
  {2700, 2704, 2651},
  {2704, 2752, 2651},
  {6057, 2703, 2704},
  {2863, 2705, 2706},
  {2701, 2702, 6339},
  {2705, 2905, 2706},
  {2705, 2707, 2905},
  {2805, 2758, 2702},
  {2707, 2606, 2754},
  {2702, 2758, 6340},
  {2806, 2754, 2606},
  {2708, 2755, 2652},
  {2652, 2755, 2653},
  {2653, 2755, 2756},
  {2654, 5821, 2709},
  {2710, 2654, 2486},
  {2552, 2758, 2655},
  {2486, 2711, 2710},
  {2609, 2758, 2553},
  {2553, 2758, 2715},
  {2716, 2714, 2658},
  {2759, 6867, 2612},
  {6645, 6867, 2759},
  {2661, 2760, 2814},
  {2661, 2499, 6023},
  {2661, 6023, 2760},
  {2718, 6921, 6922},
  {6921, 2718, 6922},
  {2761, 6417, 2559},
  {2437, 2662, 2720},
  {2827, 2720, 2662},
  {2817, 2827, 2662},
  {2762, 2620, 2442},
  {2720, 2721, 2558},
  {2663, 2620, 2762},
  {2764, 6751, 2918},
  {6751, 2723, 2918},
  {6549, 2663, 2723},
  {7561, 2509, 6058},
  {2622, 2726, 2725},
  {2725, 2920, 2727},
  {2623, 2776, 2726},
  {2832, 2776, 2623},
  {2835, 2668, 2831},
  {2920, 2624, 2727},
  {2728, 2624, 2920},
  {2729, 2833, 2778},
  {6452, 2670, 6451},
  {2453, 2835, 2836},
  {2774, 6356, 2671},
  {6862, 2671, 6356},
  {6527, 6528, 6861},
  {6860, 6935, 6863},
  {7555, 2780, 6310},
  {2674, 2672, 2673},
  {6936, 6526, 6863},
  {2629, 7208, 2780},
  {2677, 2674, 2673},
  {6697, 6581, 2731},
  {2781, 2783, 2633},
  {2732, 2677, 2673},
  {6056, 6274, 2733},
  {2840, 2637, 2676},
  {6618, 2734, 6939},
  {6371, 2679, 6925},
  {2680, 6382, 2845},
  {2583, 2735, 2681},
  {2681, 2785, 2682},
  {2685, 2682, 2785},
  {2683, 2736, 2976},
  {2684, 2683, 2976},
  {2585, 2586, 2931},
  {2586, 2786, 2931},
  {2736, 2737, 2788},
  {2639, 3091, 2737},
  {6939, 2893, 2791},
  {2640, 2587, 2792},
  {2738, 2789, 2530},
  {2530, 2687, 2738},
  {2852, 2642, 2536},
  {2977, 2686, 2790},
  {2591, 2688, 2536},
  {2590, 2594, 2850},
  {2740, 2536, 2688},
  {2742, 2592, 2741},
  {2690, 2793, 2595},
  {2595, 2793, 2743},
  {2850, 2594, 2743},
  {2860, 2692, 2646},
  {2799, 2860, 2646},
  {2646, 2694, 2799},
  {2694, 2647, 2799},
  {2647, 2749, 2799},
  {2695, 6401, 6402},
  {2751, 7501, 2696},
  {2802, 2697, 2701},
  {2802, 2701, 2801},
  {2650, 2651, 2753},
  {2604, 2862, 2701},
  {2696, 2864, 2698},
  {2698, 2864, 2700},
  {2651, 2752, 2753},
  {2704, 2700, 2864},
  {6057, 2704, 2703},
  {2702, 2804, 2805},
  {2754, 2905, 2707},
  {2755, 2708, 2709},
  {2807, 2758, 2805},
  {2709, 5821, 2755},
  {2755, 5821, 5824},
  {2755, 5824, 2756},
  {5820, 5821, 2654},
  {2609, 2655, 2758},
  {2757, 2654, 2710},
  {2654, 2757, 5820},
  {2710, 2909, 6060},
  {2711, 2909, 2710},
  {2810, 2806, 2714},
  {2488, 2712, 7444},
  {6727, 7444, 2712},
  {2713, 2808, 2657},
  {6726, 6061, 6049},
  {2657, 2716, 2491},
  {2715, 2759, 2555},
  {2713, 2811, 2808},
  {6725, 6594, 6724},
  {2662, 2818, 2817},
  {2559, 2914, 2761},
  {2559, 2719, 2914},
  {7596, 2442, 2956},
  {7596, 2762, 2442},
  {2762, 2918, 2663},
  {2763, 2823, 2822},
  {2765, 2720, 2827},
  {2918, 2723, 2663},
  {2722, 2823, 2763},
  {2765, 2721, 2720},
  {2722, 2826, 2823},
  {2721, 2765, 2664},
  {7526, 7527, 2767},
  {7165, 2829, 2775},
  {2664, 2765, 2768},
  {2769, 2768, 2765},
  {2765, 2827, 2770},
  {2765, 2770, 2769},
  {2766, 2724, 2830},
  {2724, 2508, 7561},
  {2768, 2769, 2828},
  {2768, 2828, 5815},
  {2830, 2724, 2772},
  {2724, 7561, 2772},
  {2830, 2772, 2773},
  {2725, 2726, 2920},
  {2830, 2773, 7012},
  {2667, 3074, 2831},
  {7139, 6430, 7138},
  {3074, 2667, 2775},
  {2773, 6273, 7012},
  {2510, 2728, 2833},
  {7012, 6273, 6460},
  {3075, 2777, 2669},
  {2836, 6842, 2669},
  {2571, 2729, 2779},
  {2778, 2779, 2729},
  {2774, 6055, 2838},
  {2965, 2838, 6055},
  {2633, 2730, 2885},
  {2676, 2679, 2841},
  {6618, 2675, 2734},
  {2840, 2843, 2637},
  {6383, 2782, 2784},
  {6382, 2784, 2845},
  {2583, 2888, 2735},
  {2785, 2681, 2735},
  {2734, 2844, 6939},
  {2786, 2685, 2930},
  {2685, 2785, 2847},
  {2736, 3199, 2976},
  {2893, 6939, 2849},
  {2787, 2848, 2686},
  {7710, 2686, 2848},
  {2737, 3091, 2788},
  {2792, 2587, 7662},
  {2587, 7003, 7662},
  {2739, 2791, 2589},
  {2642, 2852, 2851},
  {2977, 2853, 2592},
  {2592, 2853, 2741},
  {3024, 2536, 2740},
  {2795, 2741, 2853},
  {2741, 2795, 2742},
  {2691, 2793, 2690},
  {7674, 2742, 2795},
  {2740, 2689, 7307},
  {2691, 3028, 2983},
  {6271, 7308, 2794},
  {2796, 7307, 5819},
  {6980, 2797, 2796},
  {2798, 2796, 2797},
  {2860, 2746, 2692},
  {2746, 2860, 2747},
  {2861, 2799, 2749},
  {2799, 2861, 2800},
  {2801, 2701, 2902},
  {2696, 6945, 2864},
  {2753, 2904, 2650},
  {2865, 2863, 2706},
  {2753, 2996, 2904},
  {2702, 2866, 2804},
  {2702, 2697, 2866},
  {2805, 2869, 2807},
  {2715, 2758, 2807},
  {2807, 2869, 2759},
  {2808, 2809, 2657},
  {2810, 2714, 2716},
  {2612, 2555, 2759},
  {2717, 2872, 2711},
  {2660, 2813, 2872},
  {2660, 2872, 2717},
  {2760, 6023, 6064},
  {2914, 2816, 2761},
  {2662, 2913, 2818},
  {2761, 3058, 2815},
  {2823, 2917, 2822},
  {2917, 2823, 2819},
  {2917, 2819, 2916},
  {2817, 2875, 2821},
  {2817, 2821, 2824},
  {2719, 7373, 7599},
  {2819, 2823, 2877},
  {2817, 2824, 2827},
  {2918, 2820, 2764},
  {2825, 2823, 2826},
  {2877, 2823, 2825},
  {2767, 7527, 7526},
  {5827, 2879, 2766},
  {2766, 3067, 2724},
  {2388, 2724, 3067},
  {2763, 2829, 7165},
  {2826, 2771, 2828},
  {2770, 2827, 2828},
  {2770, 2828, 2769},
  {2828, 2771, 5815},
  {2833, 2728, 2834},
  {2775, 2881, 2922},
  {2834, 2728, 2920},
  {2834, 2920, 2833},
  {3075, 2669, 6842},
  {2779, 2778, 2882},
  {2730, 2779, 2884},
  {2730, 2884, 2837},
  {2779, 2882, 2884},
  {2963, 2774, 2838},
  {2885, 2730, 2837},
  {2923, 2965, 6055},
  {2633, 2925, 2781},
  {2972, 2782, 6383},
  {2783, 2972, 6383},
  {2972, 2783, 2781},
  {2925, 2972, 2781},
  {2676, 2841, 2840},
  {2973, 2841, 2679},
  {2843, 2842, 2637},
  {2842, 2844, 2734},
  {2974, 2638, 2845},
  {2638, 2974, 2583},
  {2888, 2583, 2974},
  {2846, 2735, 2888},
  {2735, 2846, 2785},
  {2847, 2785, 2846},
  {6371, 7163, 2976},
  {2930, 2685, 2975},
  {6939, 2844, 2849},
  {2736, 2890, 3199},
  {2789, 2738, 2892},
  {2738, 2687, 2933},
  {2589, 2791, 2981},
  {7710, 2932, 7441},
  {3091, 2792, 7662},
  {2536, 3024, 2852},
  {3022, 2850, 2743},
  {3024, 2740, 7307},
  {3024, 7307, 2934},
  {6749, 2855, 2795},
  {7307, 2895, 2934},
  {6321, 5818, 2854},
  {2796, 2895, 7307},
  {2855, 6749, 2856},
  {6063, 6654, 6062},
  {2798, 2897, 2858},
  {2859, 2898, 2693},
  {2937, 2693, 2898},
  {2693, 2937, 7723},
  {2800, 2861, 3098},
  {2900, 3098, 2861},
  {2900, 2861, 2749},
  {2649, 2899, 2902},
  {2649, 2902, 6658},
  {2749, 2863, 2900},
  {2902, 2901, 6658},
  {2801, 2944, 2802},
  {2803, 6944, 6946},
  {2802, 2944, 2697},
  {2650, 2904, 3036},
  {2864, 2752, 2704},
  {2706, 2905, 3042},
  {2706, 3042, 2865},
  {2697, 2867, 2868},
  {2804, 2866, 2997},
  {2697, 2868, 2866},
  {2805, 2804, 3047},
  {2805, 3047, 2869},
  {2870, 2906, 2809},
  {2759, 2715, 2807},
  {2870, 2809, 2808},
  {2809, 2716, 2657},
  {2810, 2871, 2806},
  {7721, 2871, 7136},
  {2909, 2711, 3004},
  {2716, 2871, 2810},
  {6645, 2759, 6500},
  {2911, 6500, 2759},
  {2912, 2812, 6049},
  {7366, 2952, 2711},
  {7286, 6594, 6725},
  {3055, 2814, 2760},
  {2760, 6064, 3055},
  {3055, 2815, 3058},
  {7287, 2913, 2662},
  {6602, 2662, 6601},
  {2818, 3009, 2817},
  {2819, 2874, 2916},
  {2817, 3009, 2875},
  {2914, 2719, 7599},
  {2874, 2819, 2877},
  {2877, 2957, 2874},
  {2877, 2876, 2957},
  {2876, 2958, 2957},
  {2875, 3009, 2915},
  {2875, 2915, 2958},
  {2876, 2877, 2824},
  {2876, 2824, 2958},
  {2824, 2821, 2958},
  {2821, 2875, 2958},
  {2820, 2918, 2878},
  {2879, 3067, 2766},
  {2828, 2877, 2825},
  {2877, 2827, 2824},
  {2829, 2763, 2822},
  {2828, 2825, 2826},
  {2877, 2828, 2827},
  {2881, 2775, 2829},
  {2963, 2880, 2830},
  {2920, 2726, 2921},
  {2776, 2921, 2726},
  {2830, 2774, 2963},
  {2832, 2777, 3075},
  {2778, 2833, 2882},
  {2775, 2924, 3077},
  {2775, 2922, 2924},
  {2885, 2925, 2633},
  {6055, 2886, 2923},
  {6055, 7270, 2886},
  {6310, 2780, 7269},
  {2841, 2973, 2840},
  {2782, 2887, 2784},
  {2889, 2846, 2888},
  {2889, 2926, 2846},
  {2844, 2842, 2929},
  {2842, 2843, 2927},
  {2784, 2887, 2845},
  {2975, 2685, 2847},
  {2847, 2846, 2928},
  {2926, 2928, 2846},
  {2844, 2929, 2849},
  {2931, 2787, 2585},
  {2932, 7710, 2848},
  {2738, 2933, 2982},
  {2979, 2933, 2687},
  {2687, 2589, 2979},
  {2642, 2851, 3090},
  {2853, 2894, 6750},
  {2853, 2935, 2894},
  {2853, 6749, 2795},
  {2691, 2983, 2793},
  {7262, 7080, 3364},
  {7262, 3364, 7261},
  {2747, 2898, 2859},
  {2747, 2860, 2898},
  {2860, 2799, 2936},
  {2800, 3098, 2799},
  {2937, 2939, 7723},
  {2751, 7500, 7501},
  {2902, 2944, 2801},
  {2995, 2900, 2863},
  {6945, 2696, 6943},
  {6438, 6439, 6066},
  {2867, 2697, 2944},
  {2995, 2863, 2865},
  {2866, 2868, 2945},
  {2866, 2945, 2997},
  {2754, 2806, 2905},
  {2947, 2905, 2806},
  {2999, 2868, 2867},
  {6068, 2950, 2906},
  {2906, 7011, 7137},
  {6068, 2906, 2907},
  {2907, 2906, 2870},
  {2906, 2716, 2809},
  {5825, 5826, 6061},
  {2716, 2906, 2871},
  {2906, 7136, 2871},
  {5826, 2951, 6061},
  {2870, 2808, 6996},
  {2759, 2869, 2910},
  {2759, 2910, 2911},
  {2808, 2811, 6996},
  {6500, 2911, 2954},
  {2952, 3004, 2711},
  {6049, 6061, 2912},
  {2872, 7366, 2711},
  {7039, 7380, 2873},
  {7288, 2912, 7287},
  {2816, 3058, 2761},
  {7599, 2878, 2914},
  {2918, 2914, 2878},
  {2879, 3011, 3067},
  {2879, 5827, 3011},
  {2919, 5827, 2960},
  {5827, 2830, 2960},
  {2881, 2829, 3129},
  {2830, 2880, 2960},
  {2831, 3014, 2835},
  {2776, 2832, 2962},
  {2835, 3014, 2836},
  {2836, 3014, 2883},
  {2882, 2833, 2964},
  {2833, 2920, 2964},
  {2838, 2965, 6069},
  {2882, 2964, 2967},
  {2837, 2968, 2885},
  {2837, 2884, 2968},
  {2884, 2882, 2968},
  {2924, 2922, 2969},
  {2923, 2886, 7270},
  {2972, 2887, 2782},
  {2973, 2927, 2840},
  {2888, 3020, 2889},
  {2926, 2889, 3020},
  {2927, 2929, 2842},
  {2843, 2840, 2927},
  {2974, 3020, 2888},
  {2974, 2845, 2887},
  {2786, 2930, 2978},
  {2786, 2978, 2931},
  {2839, 2789, 3350},
  {2787, 2932, 2848},
  {2736, 2788, 2890},
  {2787, 2978, 2932},
  {2892, 2738, 2982},
  {2589, 2981, 2979},
  {2791, 2893, 2981},
  {3090, 2851, 3024},
  {2851, 2852, 3024},
  {2977, 7180, 2853},
  {3022, 2743, 3026},
  {2793, 2983, 2743},
  {3026, 2743, 2983},
  {2642, 3027, 2745},
  {2745, 3027, 3028},
  {2934, 2895, 2984},
  {2986, 7261, 3364},
  {7261, 2987, 6067},
  {2858, 6067, 2987},
  {3096, 2895, 2796},
  {2796, 2798, 3096},
  {2858, 3096, 2798},
  {2898, 2989, 2937},
  {2941, 2939, 2937},
  {2938, 2939, 2940},
  {2938, 2991, 2942},
  {2603, 2992, 2899},
  {2941, 6593, 2939},
  {2938, 7723, 2939},
  {7127, 3098, 2900},
  {6942, 2938, 2942},
  {2864, 6942, 2942},
  {2899, 2944, 2902},
  {2943, 2864, 2942},
  {6942, 2864, 2903},
  {2864, 2943, 2752},
  {2996, 2752, 2943},
  {2752, 2996, 2753},
  {2867, 3039, 3041},
  {2946, 3041, 2904},
  {2867, 3041, 2948},
  {2804, 2997, 3047},
  {7011, 2906, 7010},
  {2949, 2907, 3115},
  {3003, 5825, 2908},
  {3004, 3003, 2908},
  {2870, 6996, 2907},
  {2909, 3004, 2908},
  {2953, 6061, 2951},
  {6061, 2953, 2955},
  {3056, 2955, 2953},
  {7366, 3005, 2952},
  {2813, 7366, 2872},
  {6061, 2955, 2912},
  {2816, 3057, 3058},
  {2442, 2388, 2956},
  {7287, 2912, 3007},
  {3007, 2913, 7287},
  {2913, 3007, 3008},
  {2957, 2958, 3176},
  {2958, 2915, 2959},
  {3010, 2914, 2918},
  {2917, 2916, 3066},
  {3011, 5827, 3068},
  {2822, 2917, 2829},
  {3129, 2829, 2917},
  {6898, 2960, 2880},
  {2961, 3012, 2962},
  {2962, 2832, 2961},
  {2961, 2832, 3071},
  {2831, 3074, 3014},
  {2921, 2776, 3013},
  {2832, 3075, 3071},
  {3016, 2883, 3014},
  {2964, 2920, 2966},
  {2967, 2964, 3018},
  {2968, 2882, 2967},
  {2964, 2966, 3018},
  {2885, 2968, 2925},
  {3151, 2972, 2971},
  {2925, 2968, 3079},
  {2925, 3079, 2971},
  {2925, 2971, 2972},
  {2839, 2970, 2923},
  {2839, 3350, 7361},
  {3020, 2928, 2926},
  {2927, 3192, 2929},
  {2975, 2847, 3021},
  {3020, 3021, 2847},
  {2847, 2928, 3020},
  {3153, 2849, 2929},
  {2849, 3153, 2893},
  {3155, 2893, 3153},
  {2978, 7711, 2932},
  {2978, 2787, 2931},
  {2789, 2892, 3350},
  {2933, 2979, 3084},
  {2981, 2980, 6070},
  {2981, 6070, 2980},
  {2981, 2893, 3023},
  {2935, 2853, 7180},
  {3024, 2934, 2984},
  {2984, 2895, 2985},
  {2986, 2987, 7261},
  {2895, 3096, 2985},
  {3096, 2858, 2986},
  {2858, 2987, 2986},
  {2860, 2989, 2898},
  {2936, 2799, 2988},
  {2936, 2988, 2989},
  {2936, 2989, 2860},
  {2937, 2989, 3375},
  {2990, 2991, 2938},
  {2990, 3161, 2991},
  {2990, 2938, 2940},
  {2899, 2992, 2994},
  {2941, 2937, 2993},
  {2603, 3036, 2992},
  {2899, 2994, 2944},
  {3035, 2944, 2994},
  {3108, 2942, 3106},
  {3038, 3036, 2904},
  {3037, 2944, 3035},
  {2942, 3108, 2943},
  {2867, 2944, 3037},
  {3041, 3038, 2904},
  {3039, 2867, 3037},
  {2865, 3040, 2995},
  {2865, 3042, 3040},
  {2904, 2996, 3108},
  {3042, 2905, 3109},
  {2945, 2868, 3043},
  {2997, 2945, 3043},
  {7542, 7187, 7541},
  {2998, 3041, 7186},
  {3041, 3049, 2948},
  {2948, 3049, 3000},
  {2948, 3000, 2867},
  {2949, 3115, 2950},
  {2950, 3116, 2906},
  {2906, 3116, 7010},
  {5826, 5825, 3001},
  {5825, 3003, 3002},
  {5825, 3002, 3001},
  {2910, 2869, 3047},
  {2907, 6996, 3115},
  {2911, 2910, 3047},
  {2951, 3050, 3052},
  {2951, 3052, 2953},
  {2953, 3052, 3056},
  {6499, 7366, 2813},
  {3119, 2955, 3056},
  {2912, 2955, 3007},
  {3008, 3007, 2955},
  {2816, 2914, 3057},
  {3008, 3059, 2913},
  {3120, 2913, 3059},
  {2913, 3120, 2818},
  {2818, 3060, 3009},
  {2916, 2874, 3062},
  {2957, 3176, 3063},
  {2959, 3176, 2958},
  {3064, 2915, 3009},
  {3175, 3010, 2918},
  {5827, 2919, 3068},
  {2960, 6898, 2919},
  {2961, 3070, 3012},
  {3012, 3013, 2962},
  {2962, 3013, 2776},
  {6941, 3015, 3014},
  {3015, 6941, 3014},
  {2921, 3076, 2920},
  {6842, 7421, 3075},
  {2920, 3076, 2966},
  {3018, 2966, 3076},
  {2923, 3147, 2965},
  {2967, 3018, 3017},
  {2967, 3017, 3079},
  {2923, 2970, 3080},
  {2970, 3081, 3080},
  {3150, 2924, 2969},
  {2971, 3082, 3151},
  {3080, 2970, 2839},
  {3080, 2970, 3081},
  {7361, 3080, 2839},
  {3151, 2887, 2972},
  {2927, 2973, 3246},
  {3019, 3083, 2887},
  {6371, 2976, 3152},
  {2890, 2788, 3199},
  {3084, 7206, 2933},
  {2979, 2981, 3084},
  {2892, 2982, 3350},
  {2981, 3023, 3088},
  {2893, 3086, 3023},
  {2893, 6442, 3086},
  {2788, 3091, 3089},
  {3092, 3091, 2891},
  {2891, 3202, 3092},
  {3022, 3026, 3025},
  {3364, 7080, 3093},
  {3026, 2983, 3028},
  {2984, 2985, 3095},
  {3161, 3162, 2991},
  {3030, 2988, 2799},
  {3029, 3097, 3031},
  {3030, 2799, 3098},
  {3099, 3029, 3031},
  {3097, 3032, 3031},
  {7125, 3031, 3032},
  {3102, 2990, 2940},
  {3033, 3099, 3031},
  {3031, 7125, 3033},
  {7126, 3034, 3033},
  {2992, 3036, 2994},
  {3034, 2995, 3105},
  {2995, 3034, 7028},
  {2943, 3108, 2996},
  {3040, 3107, 2995},
  {2904, 7187, 7542},
  {3043, 2868, 3110},
  {3043, 3110, 2997},
  {2905, 2947, 3044},
  {3041, 2998, 3114},
  {2868, 2999, 3211},
  {3046, 3114, 2998},
  {3114, 3049, 3041},
  {3270, 3047, 2997},
  {2950, 3115, 3116},
  {3050, 3001, 3002},
  {3165, 7010, 3116},
  {3048, 7010, 3165},
  {3050, 3002, 3003},
  {2911, 3216, 2954},
  {3050, 3003, 3004},
  {3050, 3051, 3052},
  {3050, 3004, 3051},
  {3004, 3054, 3051},
  {3004, 2952, 3053},
  {2952, 3005, 3006},
  {2952, 3006, 3053},
  {3004, 3053, 3054},
  {6997, 2814, 3055},
  {6499, 6641, 7366},
  {3053, 3219, 3054},
  {3006, 3168, 3053},
  {3008, 2955, 3059},
  {2955, 3120, 3059},
  {2955, 3119, 3120},
  {2956, 2388, 3170},
  {2914, 3010, 3282},
  {3061, 3282, 3010},
  {2874, 2957, 3123},
  {2959, 2915, 3124},
  {2915, 3064, 3124},
  {3065, 3061, 3010},
  {2918, 3173, 3175},
  {3126, 3069, 3066},
  {3066, 2916, 3126},
  {3067, 3011, 3068},
  {3178, 3068, 2919},
  {3070, 2961, 3072},
  {3132, 3012, 3070},
  {2880, 3073, 6898},
  {3071, 3072, 2961},
  {3012, 3132, 3013},
  {3072, 3138, 3070},
  {3070, 3138, 3130},
  {3013, 3132, 2921},
  {3132, 3182, 2921},
  {6440, 3073, 2965},
  {3073, 2880, 2965},
  {3074, 2775, 3184},
  {2921, 3135, 3076},
  {2965, 2880, 2963},
  {3014, 3074, 3075},
  {2775, 3077, 3184},
  {3017, 3018, 3076},
  {3147, 2923, 3078},
  {2922, 3339, 2969},
  {3078, 2923, 3080},
  {3149, 3079, 3017},
  {3149, 3082, 2971},
  {2971, 3079, 3149},
  {2924, 3150, 3188},
  {2974, 2887, 3083},
  {3021, 3020, 3294},
  {3194, 2974, 3083},
  {3154, 2930, 2975},
  {2930, 3154, 2978},
  {2978, 7440, 7711},
  {3084, 2981, 3085},
  {7440, 2978, 3087},
  {7205, 7206, 3158},
  {2981, 3088, 3085},
  {3088, 3023, 3252},
  {3022, 3025, 3160},
  {3090, 3024, 3254},
  {3202, 2891, 3305},
  {3025, 3026, 3160},
  {3024, 2984, 7558},
  {2984, 3095, 3201},
  {3026, 3028, 3094},
  {3364, 3093, 3307},
  {3028, 3205, 3094},
  {2986, 3364, 3096},
  {2985, 3096, 3204},
  {2988, 3030, 2989},
  {3375, 2989, 3030},
  {3375, 3263, 2937},
  {6344, 3032, 3260},
  {3099, 3033, 3101},
  {2940, 2993, 3102},
  {3034, 3101, 3033},
  {3263, 3103, 2937},
  {2937, 3103, 2993},
  {3102, 2993, 3103},
  {2991, 3163, 2942},
  {3106, 2942, 3163},
  {3034, 3164, 3101},
  {2994, 3036, 3035},
  {3036, 3104, 3035},
  {3037, 3035, 3104},
  {3038, 3104, 3036},
  {3037, 3104, 3038},
  {3105, 2995, 3107},
  {3039, 3037, 3038},
  {3038, 3041, 3039},
  {3109, 2905, 3111},
  {2905, 3212, 3111},
  {2998, 3322, 3046},
  {3112, 3114, 3046},
  {3045, 6349, 6924},
  {3112, 3113, 3114},
  {6829, 6924, 6349},
  {3114, 3166, 3049},
  {3165, 3116, 3273},
  {3049, 3166, 3117},
  {3115, 6996, 3272},
  {3216, 2911, 3215},
  {3051, 3054, 3052},
  {6997, 3055, 6368},
  {3054, 3218, 3052},
  {7676, 6368, 3055},
  {7366, 3171, 3005},
  {3005, 3171, 7364},
  {3168, 3006, 3005},
  {3118, 3119, 3056},
  {3056, 3052, 3118},
  {3121, 3118, 3052},
  {3052, 3218, 3121},
  {3057, 2914, 3167},
  {3328, 2956, 3170},
  {2818, 3120, 3119},
  {3119, 3118, 2818},
  {3121, 2818, 3118},
  {3328, 7390, 2956},
  {3067, 3170, 2388},
  {2818, 3121, 3060},
  {3009, 3060, 3121},
  {3124, 3009, 3121},
  {2957, 3063, 3123},
  {3061, 3065, 3122},
  {3065, 3010, 3174},
  {3062, 2874, 3125},
  {3010, 3175, 3174},
  {3126, 2916, 3062},
  {3126, 3062, 3127},
  {3062, 3128, 3127},
  {3067, 3068, 3177},
  {3069, 3286, 3129},
  {3069, 3129, 3066},
  {3068, 3178, 3177},
  {3066, 3129, 2917},
  {3129, 3339, 2881},
  {3070, 3130, 3132},
  {2881, 3339, 2922},
  {3130, 3131, 3132},
  {6440, 3179, 3073},
  {3234, 3133, 3138},
  {7716, 3138, 3072},
  {3130, 3138, 3131},
  {2921, 3182, 3183},
  {3134, 6441, 6071},
  {6071, 6441, 3139},
  {3140, 6876, 3137},
  {3141, 3140, 3137},
  {3133, 7400, 3142},
  {3133, 3142, 3138},
  {3143, 6072, 6076},
  {3145, 3144, 3140},
  {6074, 6744, 6073},
  {3140, 3141, 3145},
  {6440, 2965, 3147},
  {3146, 3184, 3077},
  {3014, 3075, 3016},
  {3148, 3017, 3076},
  {3186, 3239, 3076},
  {6075, 6440, 3078},
  {6440, 3147, 3078},
  {3077, 2924, 3146},
  {3017, 3148, 3443},
  {6075, 3078, 3080},
  {3339, 3241, 2969},
  {3149, 3189, 3082},
  {2887, 3191, 3019},
  {2927, 3193, 3192},
  {2927, 6975, 3193},
  {3019, 3191, 3083},
  {2929, 3192, 3153},
  {3448, 3020, 2974},
  {2975, 3021, 3154},
  {3152, 2976, 3156},
  {2978, 3154, 3195},
  {7206, 3084, 3158},
  {3086, 6442, 3298},
  {3086, 3298, 3023},
  {3199, 3304, 2976},
  {3087, 2978, 3157},
  {2978, 3159, 3157},
  {3159, 2978, 3200},
  {2978, 3196, 3248},
  {2978, 3248, 3200},
  {3084, 3085, 3158},
  {3085, 3088, 3158},
  {3089, 3303, 2788},
  {3157, 3159, 3087},
  {3089, 3091, 3301},
  {7558, 2984, 3306},
  {3201, 3306, 2984},
  {3027, 3203, 3028},
  {3204, 3256, 3095},
  {3095, 2985, 3204},
  {3161, 3206, 3162},
  {3161, 2990, 3102},
  {3162, 3163, 2991},
  {3375, 3030, 3098},
  {3100, 3375, 3098},
  {3101, 3164, 3099},
  {3034, 3105, 3164},
  {3105, 3107, 3164},
  {2868, 3211, 3110},
  {2997, 3110, 3268},
  {2997, 3268, 3270},
  {2905, 6923, 3212},
  {2905, 3044, 6923},
  {3322, 3113, 3112},
  {3322, 3112, 3046},
  {3000, 2999, 2867},
  {3000, 3590, 2999},
  {3114, 6729, 3166},
  {3271, 2911, 3047},
  {6895, 7029, 3386},
  {2911, 3214, 3215},
  {3054, 3169, 3218},
  {3058, 7676, 3055},
  {3222, 3053, 3168},
  {3053, 3222, 3219},
  {3169, 3054, 3219},
  {3172, 3168, 3005},
  {3121, 3332, 3124},
  {3282, 3061, 3122},
  {3124, 3064, 3009},
  {2918, 3226, 3173},
  {3176, 2959, 3124},
  {3122, 3065, 3229},
  {3065, 3174, 3229},
  {2874, 3123, 3125},
  {3123, 3285, 3232},
  {3128, 3062, 3232},
  {3062, 3125, 3232},
  {3069, 6884, 3286},
  {6898, 3073, 3179},
  {3134, 3179, 6441},
  {3131, 3181, 3132},
  {3132, 3181, 3182},
  {3235, 3134, 3136},
  {3074, 3184, 3075},
  {3071, 3075, 7716},
  {3131, 3138, 3181},
  {2921, 3183, 3135},
  {6486, 3235, 3136},
  {3136, 6875, 6486},
  {3184, 3146, 3237},
  {3142, 3236, 3138},
  {3186, 3076, 3135},
  {3144, 3145, 3185},
  {3148, 3076, 3187},
  {3239, 3187, 3076},
  {6075, 3080, 6486},
  {3146, 2924, 3237},
  {3188, 3237, 2924},
  {3148, 3187, 3443},
  {3242, 6486, 3080},
  {3151, 3082, 3189},
  {6371, 3152, 6078},
  {3021, 3294, 3247},
  {3191, 3295, 3083},
  {3083, 3295, 3194},
  {3152, 3156, 3296},
  {2976, 3501, 3156},
  {2978, 3195, 3196},
  {7205, 3158, 3197},
  {7205, 3197, 3250},
  {3158, 3251, 3197},
  {3158, 3088, 3251},
  {3088, 3252, 3251},
  {3252, 3023, 3198},
  {3089, 3301, 3303},
  {7081, 3249, 3415},
  {2788, 3303, 3199},
  {3022, 3160, 3253},
  {7081, 7440, 3249},
  {3087, 3249, 7440},
  {3087, 3159, 3249},
  {3026, 3094, 3160},
  {3094, 3310, 3160},
  {3027, 2642, 3203},
  {3203, 3205, 3028},
  {3258, 3096, 3364},
  {3094, 3205, 3257},
  {3206, 3316, 3162},
  {3207, 3162, 3316},
  {3162, 3207, 3163},
  {3097, 3260, 3032},
  {6344, 3261, 6342},
  {3102, 3103, 3264},
  {3207, 3317, 3163},
  {3207, 3208, 3317},
  {3209, 3163, 3317},
  {3209, 3210, 3163},
  {3106, 3163, 3265},
  {3163, 3210, 3265},
  {3108, 3106, 2904},
  {3106, 7187, 2904},
  {3106, 3265, 3266},
  {3040, 3424, 3107},
  {3040, 3042, 3424},
  {3109, 3111, 3424},
  {3111, 3212, 3424},
  {7186, 3322, 2998},
  {7186, 7626, 3322},
  {3211, 2999, 3590},
  {3113, 3322, 3213},
  {3270, 3271, 3047},
  {3115, 3272, 3116},
  {2911, 3271, 3214},
  {7676, 3058, 3057},
  {3224, 3169, 3219},
  {7363, 3220, 3005},
  {3220, 3331, 3005},
  {3172, 3005, 3221},
  {3172, 3222, 3168},
  {3221, 3005, 3331},
  {3172, 3221, 3222},
  {3221, 3227, 3222},
  {3222, 3227, 3228},
  {3221, 3279, 3227},
  {3222, 3228, 3223},
  {3223, 3283, 3224},
  {3224, 3283, 3225},
  {7544, 7596, 7390},
  {3122, 3229, 3282},
  {7637, 3230, 3175},
  {3175, 3173, 7637},
  {3228, 3283, 3223},
  {3229, 3174, 3280},
  {3174, 3175, 3230},
  {3174, 3230, 3280},
  {3123, 3063, 3285},
  {3069, 3126, 6883},
  {6883, 3126, 3127},
  {3125, 3123, 3232},
  {3285, 3063, 3176},
  {3124, 3231, 3284},
  {3177, 3178, 3287},
  {3129, 3286, 3336},
  {3291, 3339, 3129},
  {6898, 3179, 3180},
  {6898, 3180, 3233},
  {3339, 3291, 3400},
  {7716, 3072, 3071},
  {3233, 3180, 3134},
  {3180, 3179, 3134},
  {3437, 7401, 7716},
  {3181, 3338, 3182},
  {3182, 3338, 3183},
  {6433, 3134, 3235},
  {3236, 3181, 3138},
  {3181, 3236, 3338},
  {3135, 3183, 3338},
  {3340, 3184, 3237},
  {3338, 3239, 3186},
  {3186, 3135, 3338},
  {7399, 3236, 3142},
  {3241, 3339, 3403},
  {3237, 3188, 3240},
  {3344, 3240, 3188},
  {3442, 7399, 3238},
  {3189, 3149, 3243},
  {3189, 3243, 3345},
  {3242, 3080, 7361},
  {3241, 3292, 2969},
  {3189, 3345, 3244},
  {3151, 3189, 3244},
  {3292, 3346, 2969},
  {2969, 3346, 3150},
  {2887, 3151, 3191},
  {3151, 3244, 3191},
  {2927, 3246, 6975},
  {6814, 3245, 6077},
  {3152, 3296, 3351},
  {3152, 3351, 6078},
  {2974, 3194, 3448},
  {3021, 3247, 3154},
  {3195, 3154, 3247},
  {3247, 3297, 3195},
  {3195, 3297, 3196},
  {3352, 3200, 3248},
  {3296, 3156, 3501},
  {3352, 3354, 3249},
  {3249, 3200, 3352},
  {3251, 7204, 3197},
  {3300, 3252, 3198},
  {3298, 3198, 3023},
  {2976, 3304, 3501},
  {3415, 3249, 3355},
  {3249, 3159, 3200},
  {6429, 3301, 3091},
  {3199, 3303, 3304},
  {3253, 2891, 7720},
  {2891, 3253, 3414},
  {3414, 3305, 2891},
  {3305, 3308, 3202},
  {3416, 3091, 3092},
  {3092, 3202, 3416},
  {3202, 3308, 3255},
  {3201, 3095, 3309},
  {3095, 3617, 3309},
  {3094, 3313, 3310},
  {3094, 3257, 3313},
  {3204, 3096, 3369},
  {3096, 3618, 3369},
  {3096, 3258, 3618},
  {3259, 3371, 3315},
  {3161, 3464, 3206},
  {3102, 3464, 3161},
  {3260, 3261, 6344},
  {3102, 3264, 3464},
  {3099, 3164, 3378},
  {3208, 3262, 3317},
  {3209, 3317, 3210},
  {3210, 3317, 3266},
  {3164, 3318, 3378},
  {3265, 3210, 3266},
  {3318, 3164, 3424},
  {3164, 3107, 3424},
  {3109, 3424, 3042},
  {3424, 3212, 3379},
  {3321, 3379, 3212},
  {3211, 3381, 3110},
  {3267, 3381, 3211},
  {3212, 3273, 3321},
  {3212, 6923, 7267},
  {3590, 6845, 3514},
  {3386, 7029, 3166},
  {3169, 3274, 3218},
  {6510, 3170, 3433},
  {6511, 3433, 3329},
  {3222, 3223, 3219},
  {3219, 3223, 3224},
  {3169, 3224, 3225},
  {3169, 3225, 3274},
  {3274, 3121, 3218},
  {3220, 3330, 3331},
  {3274, 3225, 3275},
  {3274, 3275, 3121},
  {3170, 3067, 3433},
  {3331, 3279, 3221},
  {7596, 2956, 7390},
  {3331, 3278, 3279},
  {3275, 3332, 3121},
  {7637, 3173, 3276},
  {7637, 3276, 3394},
  {3276, 3173, 3226},
  {3278, 3277, 3279},
  {3227, 3432, 3228},
  {3229, 3280, 3281},
  {3229, 3281, 3282},
  {3280, 3230, 7637},
  {3280, 7637, 3281},
  {3279, 3278, 3277},
  {3279, 3432, 3227},
  {3225, 3332, 3275},
  {3124, 3332, 3231},
  {3228, 3432, 3283},
  {3284, 3176, 3124},
  {3069, 6883, 6884},
  {3127, 3128, 6079},
  {3285, 3288, 3232},
  {6079, 3128, 3232},
  {3288, 6079, 3232},
  {3334, 3398, 3285},
  {3289, 3129, 3336},
  {3291, 3129, 3289},
  {6898, 3233, 7587},
  {3290, 7587, 3233},
  {3290, 3233, 3134},
  {7401, 3437, 3402},
  {3235, 6486, 7362},
  {3239, 3338, 3404},
  {7399, 3442, 3236},
  {3187, 3239, 3443},
  {6486, 3242, 7362},
  {3149, 3017, 3243},
  {3704, 3347, 3244},
  {3348, 3192, 3193},
  {3193, 3351, 3348},
  {3294, 3020, 3409},
  {3409, 3020, 3448},
  {3449, 3247, 3294},
  {3533, 3153, 3192},
  {3295, 3191, 3349},
  {3297, 3247, 3449},
  {3295, 3451, 3194},
  {3352, 3248, 3410},
  {3248, 3297, 3410},
  {3196, 3297, 3248},
  {7202, 7204, 3452},
  {3355, 3249, 3354},
  {7204, 3251, 3356},
  {3299, 3412, 3251},
  {3251, 3252, 3299},
  {3252, 3300, 3360},
  {3298, 3300, 3198},
  {6674, 3302, 6487},
  {3091, 3612, 6429},
  {3254, 3362, 3090},
  {6706, 3306, 6080},
  {3093, 6540, 3307},
  {3305, 3540, 3308},
  {3090, 3362, 2642},
  {3201, 3309, 3306},
  {3612, 3091, 3416},
  {3202, 3255, 3416},
  {3255, 3308, 3363},
  {3309, 3617, 3458},
  {3310, 3670, 3160},
  {3617, 3095, 3256},
  {3364, 3311, 3314},
  {3310, 3313, 3312},
  {3364, 3314, 3258},
  {3311, 3367, 3314},
  {3205, 3203, 3368},
  {3205, 3368, 3257},
  {3258, 3314, 3370},
  {3259, 3099, 3371},
  {3464, 3316, 3206},
  {3259, 3315, 3260},
  {3264, 3263, 3464},
  {3208, 3207, 3262},
  {3262, 3207, 3511},
  {6899, 6343, 6715},
  {6899, 6900, 6343},
  {3465, 3099, 3378},
  {3375, 3376, 3263},
  {3262, 3377, 3317},
  {3319, 3266, 3317},
  {3319, 3317, 3377},
  {3319, 3377, 3320},
  {3266, 3319, 3269},
  {3380, 3319, 3320},
  {3382, 3379, 3321},
  {3110, 3381, 3268},
  {3267, 3211, 3590},
  {3321, 3273, 3382},
  {6730, 6731, 6728},
  {6729, 3386, 3166},
  {6844, 3386, 3514},
  {3388, 3324, 3325},
  {3388, 3325, 3391},
  {3272, 3323, 3116},
  {3272, 6996, 3687},
  {3272, 3687, 3323},
  {3391, 3325, 3326},
  {3214, 3271, 3326},
  {3325, 3431, 3326},
  {3214, 3326, 3215},
  {3216, 3215, 7365},
  {3327, 6285, 6284},
  {3328, 6643, 7390},
  {7363, 3330, 3220},
  {3282, 3167, 2914},
  {3432, 3279, 3278},
  {3225, 3283, 3432},
  {3225, 3432, 3396},
  {3176, 3284, 3334},
  {6884, 3397, 3286},
  {3285, 3176, 3334},
  {3334, 3284, 3434},
  {3334, 3526, 3398},
  {6539, 6898, 3335},
  {6539, 3335, 6289},
  {3287, 7162, 3177},
  {3286, 3397, 3336},
  {3289, 3336, 3291},
  {7587, 3290, 3337},
  {3291, 3399, 3400},
  {3134, 6433, 3337},
  {3134, 3337, 3290},
  {3184, 3340, 3075},
  {3075, 3340, 7716},
  {3235, 7362, 6433},
  {3236, 3404, 3338},
  {3237, 3240, 3340},
  {3236, 3486, 3404},
  {3342, 3343, 3341},
  {3443, 3239, 3441},
  {7361, 7362, 3242},
  {3188, 3440, 3344},
  {3238, 3406, 3442},
  {3345, 3243, 3017},
  {3345, 3017, 3443},
  {3345, 3704, 3244},
  {3347, 3191, 3244},
  {3347, 3349, 3191},
  {3491, 3293, 3192},
  {3293, 3533, 3192},
  {3451, 3448, 3194},
  {3155, 3450, 3411},
  {3296, 3353, 3351},
  {3295, 3576, 3451},
  {3155, 3411, 3298},
  {3501, 3353, 3296},
  {3356, 3251, 3455},
  {3251, 3412, 3357},
  {3251, 3357, 3455},
  {3299, 3252, 3358},
  {3299, 3358, 3412},
  {3252, 3360, 3359},
  {3252, 3359, 3358},
  {3300, 3298, 3360},
  {3301, 3413, 3303},
  {3301, 6429, 3413},
  {6541, 6542, 3361},
  {6541, 3361, 6542},
  {6540, 7470, 3307},
  {6080, 3306, 3504},
  {3306, 3309, 3504},
  {3458, 3504, 3309},
  {3307, 7470, 3364},
  {3670, 3253, 3160},
  {3364, 3365, 3311},
  {3366, 3311, 3365},
  {3310, 3312, 6683},
  {3311, 3366, 3367},
  {6680, 3313, 3368},
  {3257, 3368, 3313},
  {6681, 6682, 3583},
  {3545, 3618, 3258},
  {3367, 3370, 3314},
  {3545, 3258, 3509},
  {3370, 3509, 3258},
  {3371, 3372, 3315},
  {3316, 3373, 3207},
  {3621, 3207, 3373},
  {3315, 3372, 3260},
  {3261, 3260, 3372},
  {3374, 3261, 3372},
  {3263, 3376, 3464},
  {3318, 3423, 3378},
  {3318, 3468, 3423},
  {3377, 3467, 3320},
  {3318, 3424, 3468},
  {3320, 7529, 3380},
  {3380, 7628, 3319},
  {3319, 3588, 3269},
  {3269, 3588, 3589},
  {3268, 3381, 3383},
  {3383, 3381, 3427},
  {3270, 3268, 3383},
  {3429, 3384, 3383},
  {3382, 3273, 3385},
  {3384, 3429, 3324},
  {3384, 3324, 3387},
  {6729, 7482, 3474},
  {6729, 3474, 3386},
  {3390, 3271, 3270},
  {3387, 3388, 3270},
  {3387, 3324, 3388},
  {3475, 3389, 3323},
  {3389, 3471, 3323},
  {3687, 3475, 3323},
  {3391, 3271, 3390},
  {3326, 3271, 3391},
  {3325, 3324, 3392},
  {3215, 3326, 3330},
  {3326, 3431, 3330},
  {3327, 6284, 6285},
  {3736, 3557, 3217},
  {7365, 3215, 3393},
  {3331, 3522, 3278},
  {3225, 3395, 3332},
  {3396, 3479, 3225},
  {3332, 3434, 3231},
  {3598, 3333, 3478},
  {3177, 3524, 3067},
  {3177, 6288, 3524},
  {3285, 3398, 3288},
  {3334, 3434, 3526},
  {3291, 3336, 3481},
  {3291, 3481, 3399},
  {3400, 3399, 3528},
  {3401, 3339, 3400},
  {3238, 7401, 3402},
  {3440, 3340, 3240},
  {3342, 3341, 3343},
  {3441, 3239, 3404},
  {3240, 3344, 3440},
  {3406, 3238, 3341},
  {3486, 3236, 3442},
  {3486, 3439, 3404},
  {3345, 3443, 3407},
  {3488, 3345, 3407},
  {3704, 3345, 3488},
  {3192, 3446, 3491},
  {3192, 3348, 3408},
  {3192, 3408, 3446},
  {3294, 3409, 3447},
  {3294, 3447, 3449},
  {3410, 3297, 3449},
  {3450, 3155, 3153},
  {3410, 3495, 3352},
  {3411, 3450, 3453},
  {3356, 3452, 7204},
  {3298, 3359, 3360},
  {3456, 3414, 3253},
  {3456, 3540, 3305},
  {3305, 3414, 3456},
  {7471, 3364, 7470},
  {3203, 2642, 3362},
  {3539, 3364, 7471},
  {3539, 3457, 3364},
  {3365, 3364, 3457},
  {3363, 3416, 3255},
  {6085, 3363, 3308},
  {6683, 3670, 3310},
  {3365, 3460, 3366},
  {3417, 3418, 3419},
  {3417, 3419, 3418},
  {3507, 6291, 3420},
  {3420, 3367, 3507},
  {3366, 3507, 3367},
  {6291, 3462, 3420},
  {3420, 3462, 3370},
  {3420, 3370, 3367},
  {3204, 3369, 3618},
  {3370, 3462, 3509},
  {3371, 3510, 3372},
  {3099, 5828, 3371},
  {3464, 3372, 3463},
  {3373, 3316, 3464},
  {3207, 3621, 3511},
  {3372, 3376, 3374},
  {3372, 3464, 3376},
  {3511, 3377, 3262},
  {3465, 3421, 3422},
  {3465, 3423, 3421},
  {3421, 7133, 3422},
  {7529, 3320, 3425},
  {3425, 7240, 7529},
  {3429, 3383, 3427},
  {3428, 6612, 3382},
  {3384, 3270, 3383},
  {3382, 3385, 3428},
  {3116, 6775, 3385},
  {3387, 3270, 3384},
  {3273, 3116, 3385},
  {3388, 3390, 3270},
  {3389, 3475, 3472},
  {3116, 3323, 3471},
  {3324, 3429, 3392},
  {3391, 3390, 3388},
  {3392, 3430, 3325},
  {3325, 3477, 3431},
  {3393, 3215, 3330},
  {3167, 3282, 7424},
  {3331, 3330, 3522},
  {3432, 6081, 3396},
  {3225, 3479, 3395},
  {3332, 3525, 3434},
  {3524, 3433, 3067},
  {3284, 3231, 3434},
  {6547, 3335, 3480},
  {6079, 3288, 3435},
  {3335, 6898, 3480},
  {7587, 3480, 6898},
  {3397, 3481, 3336},
  {3528, 3401, 3400},
  {3437, 7716, 3340},
  {3437, 3484, 3402},
  {3441, 3404, 3439},
  {3486, 3441, 3439},
  {3407, 3443, 3444},
  {3407, 3444, 3488},
  {7361, 3350, 3532},
  {3349, 3347, 3489},
  {3490, 3533, 3293},
  {3408, 3348, 3492},
  {3408, 3492, 3446},
  {3349, 3576, 3295},
  {3448, 3447, 3409},
  {3153, 3533, 3450},
  {3492, 3348, 3351},
  {7202, 3452, 3661},
  {3451, 3498, 3448},
  {3495, 3410, 3448},
  {3450, 3494, 3453},
  {3411, 3453, 3499},
  {3576, 3498, 3451},
  {3452, 3356, 3496},
  {3454, 3496, 3356},
  {3356, 3455, 3454},
  {3499, 3298, 3411},
  {3355, 3354, 3500},
  {6465, 3357, 3412},
  {3412, 3358, 6465},
  {3358, 3359, 6465},
  {3499, 6465, 3359},
  {3359, 3298, 3499},
  {3609, 3303, 3413},
  {3670, 3456, 3253},
  {3503, 3501, 3304},
  {3540, 3456, 3502},
  {3612, 3413, 6429},
  {3503, 3304, 3303},
  {6085, 3308, 3669},
  {7701, 3459, 3582},
  {3365, 3457, 3460},
  {7700, 3419, 6291},
  {3507, 3506, 6291},
  {7700, 6291, 3419},
  {3366, 3460, 3507},
  {3459, 3461, 6291},
  {6291, 3461, 3462},
  {3256, 3204, 3618},
  {3464, 3621, 3373},
  {3463, 3772, 3464},
  {3466, 3547, 3422},
  {3422, 7133, 7158},
  {3378, 3423, 3465},
  {7133, 3421, 3423},
  {3467, 3425, 3320},
  {3424, 3469, 3423},
  {3424, 3379, 3469},
  {3427, 3381, 3516},
  {3517, 3267, 3590},
  {3427, 3516, 3429},
  {3471, 6775, 3116},
  {3471, 6329, 6775},
  {3473, 3389, 3472},
  {3471, 3389, 3473},
  {3429, 3516, 3392},
  {3472, 3475, 3552},
  {3516, 3476, 3392},
  {3392, 3476, 3430},
  {3325, 3430, 3477},
  {7357, 3557, 3556},
  {3330, 3431, 3519},
  {3431, 3558, 3520},
  {3519, 3431, 3520},
  {7593, 3737, 3736},
  {3394, 7425, 7637},
  {3394, 3276, 3694},
  {3522, 3432, 3278},
  {6266, 3562, 6082},
  {3479, 3563, 3395},
  {3332, 3395, 3563},
  {3396, 3743, 3479},
  {3479, 3743, 3563},
  {6288, 3480, 3524},
  {6079, 3435, 3478},
  {3526, 3288, 3398},
  {3525, 3526, 3434},
  {3397, 6884, 3527},
  {3397, 3527, 3481},
  {3482, 3484, 3437},
  {3340, 3483, 3437},
  {3567, 3401, 3528},
  {3340, 3485, 3483},
  {3402, 3484, 3238},
  {3339, 3401, 3403},
  {3567, 3403, 3401},
  {3238, 3484, 3341},
  {3850, 3406, 3341},
  {3405, 3406, 3850},
  {3150, 3346, 3188},
  {3850, 7703, 3445},
  {3406, 3405, 3701},
  {3406, 3701, 3442},
  {3488, 3444, 3443},
  {3445, 3701, 3405},
  {3350, 7668, 3532},
  {3446, 3492, 3491},
  {3448, 3410, 3449},
  {3448, 3449, 3447},
  {3450, 3533, 7170},
  {3448, 3577, 3495},
  {7479, 7695, 3493},
  {3496, 3493, 3452},
  {3499, 3494, 3535},
  {3499, 3535, 6465},
  {3494, 3499, 3453},
  {3454, 3455, 3497},
  {3357, 3497, 3455},
  {3454, 3497, 3496},
  {6465, 3497, 3357},
  {3497, 6465, 3535},
  {3500, 3354, 7473},
  {3456, 3670, 3502},
  {3610, 3502, 3670},
  {3610, 3540, 3502},
  {3504, 6839, 6080},
  {3504, 3458, 3541},
  {3612, 3416, 3613},
  {6311, 7563, 3582},
  {3459, 6291, 3582},
  {3457, 3507, 3460},
  {3416, 3363, 3542},
  {6291, 3506, 3582},
  {3461, 3459, 3505},
  {6682, 6839, 3583},
  {3508, 3461, 3543},
  {3461, 3508, 6411},
  {3462, 6083, 3509},
  {3256, 3618, 3617},
  {3463, 3372, 3510},
  {3099, 3465, 3620},
  {3099, 3620, 5828},
  {3463, 3585, 3772},
  {3772, 3546, 3464},
  {3468, 3424, 3423},
  {3467, 3727, 3425},
  {7133, 3423, 3469},
  {3512, 7133, 3469},
  {3469, 3379, 3512},
  {3379, 3382, 3512},
  {7130, 3512, 3382},
  {3515, 7130, 3382},
  {3514, 3386, 3513},
  {3513, 3386, 3470},
  {3381, 3267, 3632},
  {3386, 3627, 3470},
  {3788, 3267, 3517},
  {3381, 3632, 3516},
  {7185, 3269, 3589},
  {3472, 3552, 3473},
  {3518, 3555, 3476},
  {3476, 3555, 3430},
  {3431, 3477, 3594},
  {3558, 3431, 6086},
  {3431, 3594, 3647},
  {3330, 3519, 3522},
  {7378, 3521, 3276},
  {3329, 3433, 3523},
  {3560, 3394, 3648},
  {3394, 3694, 3648},
  {3432, 3562, 6266},
  {3524, 3523, 3433},
  {3396, 3599, 3743},
  {6884, 3650, 3527},
  {3480, 3652, 3524},
  {3288, 3526, 3565},
  {3480, 7587, 3652},
  {3481, 3527, 3650},
  {3438, 3653, 7722},
  {3528, 3399, 3481},
  {3482, 3437, 3483},
  {3529, 3341, 3484},
  {3340, 3440, 3485},
  {3699, 3241, 3403},
  {3438, 3190, 3568},
  {3569, 6769, 3568},
  {3486, 3530, 3441},
  {3441, 3530, 3443},
  {3445, 3405, 3850},
  {3570, 3443, 3530},
  {3531, 3488, 3443},
  {3241, 3573, 3292},
  {3445, 3487, 3701},
  {3488, 3570, 3704},
  {3488, 3531, 3570},
  {3292, 3573, 3346},
  {3532, 3572, 7361},
  {3293, 3491, 3707},
  {3293, 3707, 3490},
  {6307, 3533, 3490},
  {3489, 3663, 3349},
  {7479, 3493, 3534},
  {3664, 3351, 3353},
  {3493, 3496, 3534},
  {3497, 3534, 3496},
  {3534, 3497, 3535},
  {3533, 3534, 3535},
  {3535, 7171, 3533},
  {3577, 3665, 3495},
  {6577, 3536, 6576},
  {3664, 3353, 3501},
  {3711, 3664, 3501},
  {3354, 7060, 7473},
  {7471, 7472, 3539},
  {3711, 3501, 3538},
  {3503, 3303, 3501},
  {3538, 3501, 3303},
  {7644, 7645, 3537},
  {3609, 3713, 3303},
  {3611, 6311, 3582},
  {3541, 6839, 3504},
  {3457, 3608, 3507},
  {6839, 3541, 3581},
  {3670, 3583, 3672},
  {6839, 3581, 3614},
  {6839, 3614, 3764},
  {3583, 6839, 3764},
  {6083, 3543, 3509},
  {3544, 3509, 3543},
  {3509, 3544, 3545},
  {3510, 3676, 3463},
  {3463, 3584, 3585},
  {3620, 3465, 3422},
  {3772, 3622, 3546},
  {3466, 7132, 3547},
  {3549, 3550, 3548},
  {3377, 3727, 3467},
  {3513, 3550, 3587},
  {3727, 6084, 3425},
  {3386, 3474, 3627},
  {3627, 3474, 7483},
  {3730, 6329, 3471},
  {3632, 3633, 3516},
  {3474, 7482, 7483},
  {3517, 3634, 3788},
  {3516, 3633, 3476},
  {3554, 3473, 3553},
  {3473, 3554, 3471},
  {3637, 3471, 3554},
  {7190, 3471, 3637},
  {3637, 3554, 3553},
  {3555, 3518, 3591},
  {3592, 3430, 3555},
  {3430, 3593, 3477},
  {3477, 3593, 3646},
  {3431, 3647, 3596},
  {6086, 3431, 3595},
  {3431, 3596, 3595},
  {3520, 3558, 3559},
  {3519, 3520, 3522},
  {3520, 3559, 3522},
  {3522, 3559, 3432},
  {3432, 3559, 3562},
  {3559, 3561, 3562},
  {3563, 3525, 3332},
  {3563, 3564, 3525},
  {3598, 3478, 3651},
  {3526, 3525, 3564},
  {3749, 3478, 3435},
  {3288, 3565, 3566},
  {3435, 3288, 3749},
  {3602, 3749, 3288},
  {3566, 3602, 3288},
  {4013, 3482, 3483},
  {3482, 3654, 3484},
  {3484, 3654, 3529},
  {3603, 3341, 3529},
  {3438, 3568, 3656},
  {3658, 3486, 3604},
  {3486, 3658, 3530},
  {3570, 3530, 3658},
  {3442, 3703, 3486},
  {3659, 3486, 3703},
  {3443, 3570, 3531},
  {6768, 3571, 3702},
  {7361, 3572, 3571},
  {3662, 3701, 3487},
  {3574, 7203, 3575},
  {3606, 3533, 6307},
  {7479, 3575, 7203},
  {3606, 3534, 3533},
  {3492, 3351, 3711},
  {3664, 3711, 3351},
  {3498, 3577, 3448},
  {3577, 3578, 3665},
  {7318, 3495, 3579},
  {3457, 3539, 7319},
  {3537, 7645, 7644},
  {3612, 3609, 3413},
  {6085, 6412, 3363},
  {3608, 3506, 3507},
  {3582, 3506, 3608},
  {3541, 3458, 3615},
  {3541, 3615, 3581},
  {3461, 3616, 3543},
  {3675, 3544, 3543},
  {3463, 3676, 3584},
  {3620, 3422, 3678},
  {3772, 3680, 3622},
  {3546, 3622, 3464},
  {3586, 3549, 3548},
  {3549, 3623, 3550},
  {3550, 3623, 3587},
  {3627, 3548, 3550},
  {3513, 3627, 3550},
  {3630, 3513, 3587},
  {3513, 3470, 3627},
  {3590, 3514, 3513},
  {3513, 3630, 3590},
  {3628, 3380, 7529},
  {7627, 3380, 3628},
  {3553, 3552, 3475},
  {3552, 3553, 3473},
  {3730, 3471, 7190},
  {3591, 3638, 3555},
  {3641, 3555, 3638},
  {3555, 3641, 3592},
  {3430, 3592, 3593},
  {6996, 3556, 3687},
  {3477, 3646, 3594},
  {3558, 6086, 3559},
  {6086, 3595, 3559},
  {3595, 3596, 3559},
  {3559, 3596, 3561},
  {3167, 7424, 7594},
  {3562, 3597, 6082},
  {3562, 3561, 3696},
  {6082, 3597, 3599},
  {3598, 3651, 3744},
  {3524, 3652, 3523},
  {3563, 3601, 3564},
  {3600, 3565, 3563},
  {3526, 3563, 3565},
  {3526, 3601, 3563},
  {3601, 3526, 3564},
  {3651, 3478, 3748},
  {3565, 3600, 3566},
  {7722, 3653, 3436},
  {3653, 3750, 3436},
  {5829, 3481, 3650},
  {3481, 3567, 3528},
  {3654, 3482, 4013},
  {3603, 3529, 3654},
  {3438, 3656, 3655},
  {3440, 4013, 3485},
  {3485, 4013, 3483},
  {3341, 3603, 3698},
  {3753, 3568, 6769},
  {3486, 3659, 3604},
  {3241, 3918, 3573},
  {3442, 3701, 3703},
  {6307, 3490, 3660},
  {3572, 3605, 3571},
  {3571, 3605, 3702},
  {3490, 3707, 3660},
  {3573, 3918, 3705},
  {3572, 3532, 3605},
  {3605, 3532, 7668},
  {7667, 3575, 3605},
  {3605, 3575, 3702},
  {3534, 3606, 7479},
  {3711, 3491, 3492},
  {3349, 3663, 3576},
  {3498, 3761, 3577},
  {3495, 3665, 3579},
  {3607, 3579, 3665},
  {3608, 3457, 7318},
  {7318, 3579, 3608},
  {3579, 3607, 3608},
  {3863, 3538, 3303},
  {3538, 3863, 3711},
  {3308, 3540, 3669},
  {3611, 3582, 3666},
  {3582, 3608, 3666},
  {3613, 3416, 3542},
  {3581, 3615, 3614},
  {3613, 3542, 3671},
  {6716, 3817, 3505},
  {3458, 3673, 3615},
  {3505, 3616, 3461},
  {3583, 3764, 3820},
  {3616, 3505, 3718},
  {3616, 3675, 3543},
  {3616, 3718, 3675},
  {3583, 3619, 3672},
  {3617, 3618, 3720},
  {3675, 3545, 3544},
  {3619, 3583, 3820},
  {3618, 3545, 3675},
  {3676, 3677, 3584},
  {3584, 3677, 3585},
  {3621, 3679, 3511},
  {3678, 3422, 3725},
  {3511, 3679, 3377},
  {3622, 3770, 3464},
  {3547, 3725, 3422},
  {3586, 3726, 3549},
  {3623, 3549, 3726},
  {3681, 3725, 3547},
  {3547, 7132, 3681},
  {3776, 3586, 3624},
  {3776, 3624, 3625},
  {3624, 3586, 3548},
  {3548, 3625, 3624},
  {3587, 3623, 3726},
  {7130, 7133, 3512},
  {3626, 3625, 3426},
  {3729, 6084, 3727},
  {3426, 3551, 3626},
  {3625, 3548, 3426},
  {3627, 3426, 3548},
  {3627, 3628, 3426},
  {3515, 3783, 7130},
  {3629, 3628, 3627},
  {3628, 3629, 7627},
  {3629, 3627, 7483},
  {3629, 7483, 7627},
  {3630, 3631, 3590},
  {3631, 3517, 3590},
  {3517, 3631, 3634},
  {3476, 3633, 3685},
  {6087, 3636, 3635},
  {3476, 3733, 3791},
  {3476, 3791, 3518},
  {3591, 3940, 3638},
  {3591, 3518, 3791},
  {3553, 3688, 3637},
  {3688, 3689, 3637},
  {3639, 3640, 3896},
  {3687, 3556, 3734},
  {3691, 3642, 3639},
  {3639, 3642, 3640},
  {3640, 3644, 3896},
  {3556, 3557, 3736},
  {3642, 3644, 3640},
  {3592, 3641, 3646},
  {3592, 3646, 3593},
  {7358, 3735, 3645},
  {7356, 7358, 3645},
  {7377, 7379, 3329},
  {3594, 3646, 3647},
  {3739, 3647, 3646},
  {3523, 7377, 3329},
  {3596, 3647, 3561},
  {7593, 3648, 3649},
  {3696, 3561, 3647},
  {3648, 3694, 3649},
  {4175, 3745, 3651},
  {3743, 3600, 3563},
  {3841, 3600, 3743},
  {3478, 3749, 3748},
  {3602, 3566, 3749},
  {3438, 3655, 3653},
  {3567, 3481, 3846},
  {3567, 3846, 3697},
  {3567, 3697, 3403},
  {3440, 3962, 4013},
  {3656, 3568, 3753},
  {3241, 3699, 3657},
  {3850, 3341, 3912},
  {3658, 3604, 3659},
  {3570, 3658, 3659},
  {6769, 3702, 3700},
  {3703, 3704, 3659},
  {3570, 3659, 3704},
  {7479, 3754, 3702},
  {3188, 3346, 3573},
  {3756, 3606, 6307},
  {3705, 3188, 3573},
  {3702, 3575, 7479},
  {7479, 3606, 3757},
  {3756, 3757, 3606},
  {3489, 7577, 3663},
  {3662, 3709, 3758},
  {3662, 3708, 3709},
  {3663, 3498, 3576},
  {3498, 3710, 3761},
  {3577, 3761, 3578},
  {3607, 3665, 3608},
  {6311, 3611, 3762},
  {3863, 3303, 3713},
  {3610, 3670, 3714},
  {3611, 3666, 6631},
  {3609, 3612, 3712},
  {3540, 3610, 3815},
  {3610, 3714, 3815},
  {3666, 3608, 3667},
  {3666, 3667, 6631},
  {3580, 7744, 3668},
  {3715, 3816, 6716},
  {3542, 3363, 3671},
  {6716, 3816, 3817},
  {3764, 3614, 3615},
  {3718, 3505, 3717},
  {3672, 3619, 3674},
  {3620, 3721, 3676},
  {3585, 3677, 3722},
  {3772, 3585, 3722},
  {3723, 3679, 3621},
  {3464, 3770, 3621},
  {3723, 3377, 3679},
  {3377, 3723, 3724},
  {3680, 3933, 3622},
  {3377, 3724, 3727},
  {3726, 6328, 3587},
  {3682, 3587, 3778},
  {3587, 3682, 3683},
  {3779, 3683, 3682},
  {3587, 3683, 3684},
  {3587, 3684, 3630},
  {3728, 3626, 6380},
  {3626, 3551, 6380},
  {3632, 3685, 3633},
  {3788, 3632, 3267},
  {3733, 3476, 3685},
  {3591, 3791, 3940},
  {3475, 3687, 3553},
  {3553, 3687, 3688},
  {3690, 3691, 3639},
  {3736, 3734, 3556},
  {3896, 3644, 3735},
  {3796, 3735, 3644},
  {3641, 3638, 3643},
  {3643, 3738, 3641},
  {3641, 3693, 3646},
  {3693, 3641, 3738},
  {3692, 3735, 3796},
  {3735, 3692, 3645},
  {3276, 3521, 3694},
  {6797, 3645, 3692},
  {7593, 3649, 3737},
  {7377, 3523, 3741},
  {3696, 3647, 3695},
  {3523, 6097, 3741},
  {3743, 3597, 3562},
  {3742, 3800, 3598},
  {3597, 3743, 3599},
  {3744, 3651, 3745},
  {3652, 3952, 3523},
  {6884, 3747, 3650},
  {3651, 3748, 4175},
  {3600, 3746, 3566},
  {3653, 3751, 6841},
  {4013, 4012, 3654},
  {3403, 3697, 3699},
  {3603, 3654, 3847},
  {3603, 3847, 3698},
  {3241, 3657, 3918},
  {3700, 3702, 3851},
  {3754, 3851, 3702},
  {3854, 6307, 3660},
  {3704, 3701, 3662},
  {7479, 3757, 3855},
  {3662, 3758, 3704},
  {3862, 7577, 3704},
  {7577, 3862, 3663},
  {3759, 3663, 3862},
  {3706, 3663, 3759},
  {3491, 3711, 3707},
  {3710, 3498, 3663},
  {6492, 4016, 6490},
  {3608, 3665, 3667},
  {3712, 3713, 3609},
  {3810, 3712, 3612},
  {3540, 3815, 3669},
  {3810, 3612, 3813},
  {3612, 3716, 3813},
  {3668, 3814, 3363},
  {3673, 3764, 3615},
  {3673, 3458, 3617},
  {3505, 3817, 3717},
  {3717, 3765, 3718},
  {3765, 3819, 3618},
  {3618, 3675, 3765},
  {3769, 3719, 3674},
  {3674, 3619, 3769},
  {3617, 3720, 3768},
  {3878, 3676, 3721},
  {3677, 3676, 3878},
  {3722, 3677, 3878},
  {3771, 3621, 3770},
  {3621, 3771, 3723},
  {3877, 3620, 3678},
  {3725, 3774, 3678},
  {3678, 3774, 3877},
  {3775, 3680, 3772},
  {3586, 3776, 3726},
  {3681, 3885, 3725},
  {3726, 3882, 7166},
  {3625, 3626, 3728},
  {3625, 3728, 3776},
  {3587, 6328, 3778},
  {3682, 3778, 3779},
  {3630, 3684, 3631},
  {3684, 3788, 3631},
  {6856, 3730, 3515},
  {7190, 3784, 3730},
  {3631, 3788, 3634},
  {3788, 3938, 3632},
  {3632, 3938, 3685},
  {3731, 3790, 3732},
  {3689, 3789, 3637},
  {3639, 3732, 3690},
  {3732, 3639, 3896},
  {3642, 3691, 3795},
  {3642, 3795, 3644},
  {3644, 6103, 3796},
  {3692, 3796, 6797},
  {3799, 3647, 3739},
  {3695, 3647, 3799},
  {3562, 3696, 3740},
  {3696, 3695, 3740},
  {6884, 7083, 3747},
  {3747, 5829, 3650},
  {4175, 3748, 3908},
  {3600, 3841, 3746},
  {3652, 7587, 7588},
  {6840, 6841, 3801},
  {6841, 3751, 3804},
  {3481, 5830, 5831},
  {3751, 3803, 3804},
  {3751, 3653, 3803},
  {3653, 3805, 3803},
  {3654, 4012, 3847},
  {3653, 3655, 3805},
  {3697, 3846, 3752},
  {3697, 3752, 3699},
  {3698, 3912, 3341},
  {3700, 3753, 6769},
  {7110, 7111, 6275},
  {3701, 3704, 3703},
  {3700, 6652, 3753},
  {3854, 6095, 6307},
  {7703, 3850, 7643},
  {3807, 3754, 7479},
  {7479, 3855, 3807},
  {7643, 3850, 4016},
  {6307, 6095, 3808},
  {3862, 3704, 3758},
  {7643, 4016, 6492},
  {3663, 3706, 6801},
  {3706, 3759, 6801},
  {6493, 3760, 6491},
  {3761, 6107, 3578},
  {3863, 3924, 3711},
  {3863, 3713, 3811},
  {6974, 3611, 6973},
  {3611, 6631, 6973},
  {3667, 3865, 6631},
  {3712, 3810, 3713},
  {3713, 3810, 3811},
  {3668, 7744, 3812},
  {3714, 3670, 3815},
  {3668, 3812, 3814},
  {4061, 3716, 3612},
  {3612, 3613, 4061},
  {3867, 4061, 3613},
  {3613, 3671, 3867},
  {3717, 3817, 3765},
  {3617, 3764, 3673},
  {3675, 3718, 3765},
  {3674, 6362, 3672},
  {3820, 3764, 3818},
  {3764, 3617, 3818},
  {3768, 3818, 3617},
  {6363, 3766, 3767},
  {3719, 6362, 3674},
  {3819, 3720, 3618},
  {6363, 3767, 3766},
  {3719, 3769, 6362},
  {3876, 6362, 3769},
  {3822, 3768, 3720},
  {3721, 3877, 3878},
  {3721, 3620, 3877},
  {3771, 3879, 3723},
  {3622, 3933, 3770},
  {3883, 3727, 3724},
  {3773, 3726, 3776},
  {3885, 3884, 3725},
  {3725, 3884, 4070},
  {3823, 3772, 3825},
  {3772, 3824, 3775},
  {7133, 7130, 7131},
  {3728, 3781, 3887},
  {3779, 3782, 3683},
  {3728, 6380, 3781},
  {6966, 3780, 3778},
  {3683, 3782, 3684},
  {3684, 3782, 3788},
  {3515, 3730, 3783},
  {3730, 3784, 3783},
  {3785, 3786, 4045},
  {3784, 3686, 7128},
  {3637, 3789, 7190},
  {3785, 3731, 3732},
  {3785, 3732, 3786},
  {3787, 3786, 3896},
  {3732, 3896, 3786},
  {3733, 3685, 3791},
  {3789, 3689, 3941},
  {3732, 3790, 3898},
  {3732, 3898, 3690},
  {3638, 3940, 7358},
  {3792, 3687, 3734},
  {3736, 3792, 3734},
  {3735, 7358, 3834},
  {3737, 3794, 3736},
  {3644, 3795, 6103},
  {3797, 3738, 6797},
  {3738, 3797, 3693},
  {4000, 3649, 3694},
  {3799, 4050, 3695},
  {3562, 3740, 3903},
  {6090, 6739, 3798},
  {3837, 6089, 6093},
  {6421, 3839, 6477},
  {3598, 3744, 3742},
  {3748, 3749, 3908},
  {3749, 3566, 3843},
  {6841, 3802, 3801},
  {6841, 3804, 3802},
  {3803, 3805, 3804},
  {3752, 3846, 3806},
  {3752, 3806, 3699},
  {3656, 3911, 3961},
  {3656, 3959, 3655},
  {3656, 3961, 3959},
  {3656, 3753, 3911},
  {3440, 3188, 3848},
  {3188, 4143, 3848},
  {3851, 3754, 3913},
  {3755, 3851, 3753},
  {6094, 6852, 3756},
  {3853, 3756, 6100},
  {3756, 6307, 6100},
  {7289, 3857, 7117},
  {3808, 3858, 6088},
  {3860, 3854, 3660},
  {3660, 3707, 3860},
  {3861, 3860, 3707},
  {3968, 3861, 3707},
  {3809, 6493, 6494},
  {3973, 3968, 3707},
  {3921, 3862, 3758},
  {6802, 3710, 3663},
  {3663, 6801, 6802},
  {3711, 3973, 3707},
  {6493, 3809, 3760},
  {3758, 3709, 3921},
  {3921, 7746, 7747},
  {7746, 3921, 3709},
  {6107, 3923, 3578},
  {6311, 3762, 4151},
  {3665, 3865, 3667},
  {3813, 3716, 4061},
  {3363, 3814, 4061},
  {3671, 3363, 3867},
  {3670, 3868, 3815},
  {3670, 3672, 3868},
  {3672, 3869, 3868},
  {6362, 3931, 3869},
  {6362, 3869, 3672},
  {3768, 3820, 3818},
  {3819, 3765, 3871},
  {3619, 3820, 3769},
  {3874, 3769, 3820},
  {3821, 3874, 3820},
  {3820, 3768, 3821},
  {3822, 3821, 3768},
  {3822, 3720, 3875},
  {3819, 3875, 3720},
  {6362, 3876, 3872},
  {3769, 3874, 3873},
  {3723, 3879, 3724},
  {4035, 3877, 3774},
  {3775, 3933, 3680},
  {4037, 3773, 3776},
  {3880, 4035, 3774},
  {3772, 3722, 3881},
  {3726, 3773, 3882},
  {3774, 3725, 3880},
  {3725, 4070, 3880},
  {3772, 3881, 3825},
  {3772, 3823, 3824},
  {3777, 3885, 3681},
  {3728, 3887, 3776},
  {6966, 7618, 3780},
  {3829, 3729, 3727},
  {3778, 3890, 3779},
  {3779, 3890, 3782},
  {3780, 7618, 3778},
  {3890, 3778, 7618},
  {3828, 3830, 3827},
  {3831, 3830, 3828},
  {6380, 3894, 3781},
  {3787, 4045, 3786},
  {3787, 3832, 3936},
  {3788, 3782, 3833},
  {3789, 7129, 7190},
  {3731, 3785, 4045},
  {3685, 3938, 3791},
  {3791, 3897, 3940},
  {3896, 3735, 3993},
  {3687, 4076, 3688},
  {7358, 3940, 3993},
  {7358, 3993, 3834},
  {3690, 3793, 3691},
  {3794, 3649, 3835},
  {3794, 3835, 3736},
  {3795, 3691, 3943},
  {3794, 3737, 3649},
  {3646, 3945, 3901},
  {3646, 3901, 3739},
  {3693, 3797, 3945},
  {3693, 3945, 3646},
  {4050, 3799, 3739},
  {6091, 6931, 6930},
  {6111, 4000, 3694},
  {3903, 3740, 4051},
  {3740, 3695, 4051},
  {4050, 4051, 3695},
  {3836, 3747, 7083},
  {3840, 3836, 6098},
  {3523, 3952, 6097},
  {3840, 3842, 3836},
  {3836, 3842, 3747},
  {3842, 5872, 3747},
  {3907, 3746, 3841},
  {3746, 3843, 3566},
  {3746, 3907, 3843},
  {3749, 3843, 4009},
  {3652, 7588, 3844},
  {3801, 3802, 3844},
  {3804, 3845, 3802},
  {3804, 3805, 3957},
  {3804, 3957, 3845},
  {3805, 3655, 3959},
  {3960, 3806, 3846},
  {3806, 3960, 3699},
  {3962, 3440, 3848},
  {3753, 3913, 3911},
  {3753, 3851, 3913},
  {3807, 3913, 3754},
  {3657, 3849, 3918},
  {4056, 4143, 3188},
  {6099, 6851, 3856},
  {3859, 3858, 3808},
  {3808, 6095, 3859},
  {3705, 3918, 3967},
  {3862, 3966, 3759},
  {3759, 3966, 7087},
  {3759, 3919, 6801},
  {3809, 6494, 7748},
  {3665, 3578, 3923},
  {3925, 3715, 6311},
  {3762, 3866, 4151},
  {3762, 3763, 3866},
  {3810, 3813, 3926},
  {3812, 7744, 4154},
  {3813, 4061, 3926},
  {3814, 3976, 4061},
  {3814, 3812, 3976},
  {3715, 3925, 3816},
  {3363, 4061, 3867},
  {3815, 3868, 3929},
  {3816, 3930, 3817},
  {3817, 3870, 3871},
  {3817, 3871, 3765},
  {3930, 3978, 3870},
  {3930, 3870, 3817},
  {6362, 3872, 3931},
  {3876, 3873, 3932},
  {3876, 3769, 3873},
  {3770, 3879, 3771},
  {3879, 3984, 3724},
  {3933, 3775, 3824},
  {3724, 3984, 3883},
  {4070, 4035, 3880},
  {3722, 4069, 3881},
  {3882, 4038, 7166},
  {3727, 3883, 6102},
  {3885, 3777, 3826},
  {3828, 3827, 4070},
  {4070, 3827, 3935},
  {3727, 6102, 3829},
  {3781, 3893, 3887},
  {3890, 3892, 3782},
  {3827, 3830, 3935},
  {7618, 3936, 3890},
  {3991, 3782, 3892},
  {3828, 3891, 7129},
  {3828, 7129, 3831},
  {3781, 3894, 3893},
  {3782, 3991, 3833},
  {4045, 3787, 3936},
  {3831, 7129, 3789},
  {3789, 3895, 3831},
  {3938, 3788, 3833},
  {3895, 3789, 3941},
  {3832, 3787, 3896},
  {3938, 3897, 3791},
  {3690, 3898, 3939},
  {3735, 3834, 3993},
  {3792, 4047, 3687},
  {3793, 3942, 3899},
  {7061, 3899, 3943},
  {7061, 3943, 3691},
  {3649, 3900, 3835},
  {3835, 3900, 3736},
  {6103, 3999, 3796},
  {3903, 3902, 3562},
  {3562, 3902, 3743},
  {3742, 3836, 3800},
  {6096, 6837, 6738},
  {3742, 3744, 3948},
  {3949, 3948, 3744},
  {3947, 6098, 3836},
  {3744, 3745, 3949},
  {3947, 3953, 3840},
  {3952, 3904, 6097},
  {6104, 6105, 6509},
  {3743, 3906, 3841},
  {3953, 3842, 3840},
  {3907, 3841, 3906},
  {3955, 3842, 3953},
  {3907, 4009, 3843},
  {3749, 4009, 3908},
  {3844, 3909, 6390},
  {3802, 3845, 3957},
  {3802, 3957, 3844},
  {5831, 3910, 3846},
  {3805, 3959, 3958},
  {3805, 3958, 3957},
  {3849, 3699, 3960},
  {4016, 3850, 3912},
  {3913, 3807, 3855},
  {3855, 3914, 3913},
  {3918, 3849, 4097},
  {3852, 7326, 7325},
  {3855, 3757, 3915},
  {3855, 3915, 3914},
  {3854, 3916, 6414},
  {7290, 3756, 6852},
  {6852, 3857, 7290},
  {3857, 7289, 7290},
  {3917, 4099, 3858},
  {3858, 3859, 3917},
  {3916, 3917, 6882},
  {3188, 3705, 4056},
  {3919, 6106, 6801},
  {7543, 3922, 6101},
  {3862, 3921, 3966},
  {3921, 7747, 3970},
  {3811, 3973, 3863},
  {4151, 3925, 6311},
  {3763, 3864, 3866},
  {3975, 3866, 3864},
  {4059, 3975, 3864},
  {3865, 4059, 6631},
  {3974, 3973, 3811},
  {4151, 3866, 4060},
  {3810, 3927, 3811},
  {3810, 3926, 3927},
  {3928, 3927, 3926},
  {4154, 3976, 3812},
  {3669, 3815, 3977},
  {3815, 3929, 3977},
  {4022, 3816, 3925},
  {3869, 3929, 3868},
  {7300, 4062, 7143},
  {4063, 7143, 4062},
  {3932, 3875, 3978},
  {3978, 3875, 3870},
  {3870, 3875, 3819},
  {3870, 3819, 3871},
  {3873, 3874, 3932},
  {3874, 3821, 3822},
  {3874, 3822, 3932},
  {3822, 3875, 3932},
  {6312, 4025, 3876},
  {3876, 3932, 6312},
  {3872, 3876, 4025},
  {3878, 3983, 3722},
  {3824, 3981, 3933},
  {3773, 4037, 3882},
  {3934, 3825, 3881},
  {3882, 4037, 4038},
  {3934, 3986, 3825},
  {3883, 3985, 3987},
  {3883, 3987, 6102},
  {4116, 4037, 3776},
  {3887, 4116, 3776},
  {3828, 4070, 3884},
  {3884, 3885, 3828},
  {3891, 3828, 3885},
  {3885, 3826, 3891},
  {6102, 3987, 3989},
  {3889, 6894, 3886},
  {3892, 3890, 4042},
  {3892, 4042, 3991},
  {4043, 3893, 3894},
  {3830, 3990, 3935},
  {3832, 3937, 3936},
  {3894, 7188, 4043},
  {3938, 3833, 3991},
  {3896, 3937, 3832},
  {3937, 3896, 3992},
  {3896, 3993, 3992},
  {3994, 3897, 3938},
  {3790, 3731, 3898},
  {3939, 3898, 3731},
  {3897, 3994, 3940},
  {3690, 3939, 3793},
  {4047, 4076, 3687},
  {3792, 3995, 4047},
  {3792, 3736, 3995},
  {3736, 3997, 3995},
  {3943, 3899, 4205},
  {3900, 3997, 3736},
  {3944, 3901, 3945},
  {3739, 3901, 3944},
  {3649, 4326, 3900},
  {3943, 6103, 3795},
  {4079, 6797, 3999},
  {4079, 3797, 6797},
  {4079, 3945, 3797},
  {6772, 7377, 3741},
  {6797, 3796, 3999},
  {6506, 6092, 6301},
  {7327, 7328, 4001},
  {4000, 3946, 3649},
  {3836, 3742, 3948},
  {3951, 3743, 3902},
  {3902, 3903, 3951},
  {3948, 3947, 3836},
  {3950, 6112, 3904},
  {6097, 3904, 6112},
  {3952, 3950, 3904},
  {3838, 6097, 6112},
  {3905, 7027, 7026},
  {3743, 3951, 3906},
  {3906, 3951, 3907},
  {4009, 3907, 3954},
  {3952, 3652, 4139},
  {4009, 3956, 3908},
  {3652, 4010, 4139},
  {3652, 3844, 4010},
  {3844, 3957, 3909},
  {4014, 3847, 4012},
  {3912, 3698, 4095},
  {3913, 3914, 4096},
  {3916, 3854, 3860},
  {3916, 3860, 7613},
  {3916, 7613, 3963},
  {4099, 3917, 3916},
  {3860, 3861, 7613},
  {7613, 3861, 4015},
  {3705, 3967, 4056},
  {3861, 3968, 7146},
  {3861, 7146, 4015},
  {4015, 7146, 7437},
  {7543, 3966, 3921},
  {3969, 7543, 3921},
  {7543, 3969, 3922},
  {3921, 4106, 6109},
  {6107, 6109, 4106},
  {3923, 6107, 3972},
  {6107, 4106, 3971},
  {6107, 3971, 3972},
  {3972, 3971, 4058},
  {3924, 3973, 3711},
  {4059, 3865, 3923},
  {3665, 3923, 3865},
  {3863, 3973, 3924},
  {3977, 7743, 7738},
  {4227, 7142, 4063},
  {4023, 3931, 3872},
  {4227, 6110, 6824},
  {3979, 6312, 3932},
  {6824, 6826, 4227},
  {4227, 6825, 7142},
  {4023, 3872, 4024},
  {3872, 4025, 4024},
  {3980, 3933, 3981},
  {3980, 3981, 3982},
  {3980, 4066, 3933},
  {3983, 3878, 3877},
  {3981, 3824, 4032},
  {3981, 4032, 3982},
  {3933, 4066, 3770},
  {3770, 4066, 3879},
  {4036, 3879, 4033},
  {3879, 4036, 3984},
  {3722, 4280, 4069},
  {4068, 3984, 4036},
  {3823, 4031, 3824},
  {3881, 4069, 3934},
  {3986, 3934, 4069},
  {3883, 3984, 3985},
  {3887, 3893, 4116},
  {3987, 4041, 3989},
  {3935, 4039, 4070},
  {3935, 3988, 4039},
  {3890, 3936, 3937},
  {3935, 3990, 3988},
  {4042, 3890, 3937},
  {3990, 3830, 4044},
  {3831, 4044, 3830},
  {3938, 3991, 3994},
  {3689, 3688, 6351},
  {3944, 3945, 3998},
  {4326, 4049, 3900},
  {3899, 3942, 4205},
  {3943, 3999, 6103},
  {3945, 4079, 3998},
  {3944, 3998, 3739},
  {3739, 4048, 4050},
  {3649, 3946, 4326},
  {6300, 6260, 4171},
  {7328, 7327, 4001},
  {3745, 4052, 3949},
  {3951, 3903, 4004},
  {3903, 4051, 4004},
  {4054, 6112, 3950},
  {4052, 3745, 4085},
  {3952, 4054, 3950},
  {4051, 4005, 4004},
  {4005, 4007, 4004},
  {3745, 4175, 4085},
  {3951, 4004, 3954},
  {3951, 3954, 3907},
  {4004, 4007, 3954},
  {4175, 3908, 3956},
  {3954, 4008, 4009},
  {3954, 4007, 4008},
  {3956, 4009, 4175},
  {3844, 4011, 4010},
  {4139, 4010, 4011},
  {3844, 6390, 4011},
  {6108, 3909, 6389},
  {4140, 6389, 3909},
  {3909, 3957, 4140},
  {4093, 4140, 3957},
  {3910, 4141, 3846},
  {7224, 4093, 3957},
  {3846, 4141, 3960},
  {4095, 3698, 3847},
  {3911, 4055, 3961},
  {3849, 3960, 4097},
  {3911, 3913, 4096},
  {3915, 4096, 3914},
  {3916, 3963, 4099},
  {3918, 4097, 3967},
  {3967, 4097, 4056},
  {3920, 4018, 3970},
  {4057, 4019, 4106},
  {4019, 4058, 3971},
  {4019, 3971, 4106},
  {4019, 4057, 4058},
  {3968, 3973, 4020},
  {4150, 3970, 4018},
  {3970, 4150, 3921},
  {3974, 4153, 3973},
  {4021, 3973, 4153},
  {3811, 3927, 4153},
  {3811, 4153, 3974},
  {3866, 3975, 4060},
  {3976, 4154, 4107},
  {3926, 4061, 3928},
  {4061, 3976, 4107},
  {4023, 4109, 3977},
  {3977, 3929, 3869},
  {4023, 3977, 3931},
  {3977, 3869, 3931},
  {4066, 3980, 3982},
  {3982, 4028, 4066},
  {6117, 4026, 6114},
  {6114, 6116, 6117},
  {4032, 6117, 6116},
  {6116, 3982, 4032},
  {6116, 6991, 7072},
  {6116, 7072, 3982},
  {4066, 4033, 3879},
  {3877, 4035, 4156},
  {3877, 4156, 4034},
  {3877, 4034, 3983},
  {3983, 4034, 3722},
  {4029, 4030, 4031},
  {3824, 4030, 4032},
  {4030, 3824, 4031},
  {3823, 3825, 4031},
  {3984, 4068, 3985},
  {3987, 3985, 4068},
  {4038, 4195, 7166},
  {4040, 4041, 3987},
  {7166, 4117, 3888},
  {6537, 4039, 3988},
  {4163, 4116, 3893},
  {4043, 4163, 3893},
  {4041, 4040, 4072},
  {4041, 4074, 3989},
  {3937, 3992, 4042},
  {4042, 3992, 3991},
  {7183, 3989, 4074},
  {3992, 3993, 4046},
  {3992, 4046, 3991},
  {3991, 4046, 3994},
  {3993, 3940, 4046},
  {4046, 3940, 3994},
  {3996, 3942, 4077},
  {4047, 3995, 4247},
  {3995, 3997, 4247},
  {7317, 3900, 4049},
  {3900, 7317, 3997},
  {3996, 4205, 3942},
  {4079, 4048, 3998},
  {3998, 4048, 3739},
  {6605, 6772, 3741},
  {6111, 6784, 4000},
  {3741, 6606, 6605},
  {4002, 4003, 7038},
  {4002, 7038, 4003},
  {3947, 3948, 4088},
  {4051, 4132, 4084},
  {4051, 4084, 4053},
  {3953, 3947, 4006},
  {3947, 4088, 4006},
  {4051, 4053, 4005},
  {4007, 4005, 4053},
  {4053, 4084, 4086},
  {4053, 4086, 4007},
  {4007, 4086, 4008},
  {4054, 3952, 4087},
  {4214, 4175, 4009},
  {4176, 4215, 4009},
  {4009, 4008, 4176},
  {3955, 4090, 3910},
  {4139, 4011, 7222},
  {3910, 4092, 4141},
  {3957, 3958, 7224},
  {4013, 4014, 4012},
  {3959, 3961, 4055},
  {3959, 4055, 3958},
  {3958, 4055, 7224},
  {4013, 3962, 4179},
  {4014, 4095, 3847},
  {3911, 4096, 4055},
  {3848, 4100, 3962},
  {3962, 4100, 4264},
  {4096, 3915, 4098},
  {3915, 3757, 4098},
  {3757, 7290, 4098},
  {3848, 4143, 4100},
  {3757, 3756, 7290},
  {4099, 4101, 4181},
  {3963, 4101, 4099},
  {3963, 7613, 4101},
  {4104, 4016, 3912},
  {4016, 4104, 3920},
  {4097, 5833, 4056},
  {3920, 4147, 4018},
  {6970, 4106, 6969},
  {4020, 5834, 4017},
  {3968, 4020, 6113},
  {3921, 4185, 4106},
  {4021, 4020, 3973},
  {3972, 4059, 3923},
  {4151, 4060, 4152},
  {3928, 4153, 3927},
  {4022, 3925, 4151},
  {3977, 4109, 7743},
  {7300, 3816, 4228},
  {4022, 4228, 3816},
  {6115, 4064, 4027},
  {4065, 4029, 4031},
  {7072, 6991, 6119},
  {4066, 4114, 4033},
  {4280, 3722, 4034},
  {4033, 4067, 4036},
  {4067, 4068, 4036},
  {4031, 3825, 4157},
  {3825, 3986, 4157},
  {7653, 3987, 4068},
  {4069, 4157, 3986},
  {7653, 4040, 3987},
  {4116, 4319, 4037},
  {4282, 4071, 4040},
  {4282, 4040, 7653},
  {4039, 6537, 4196},
  {4071, 4072, 4040},
  {7618, 7620, 3936},
  {4072, 7182, 4041},
  {7182, 4163, 4043},
  {7621, 7619, 7192},
  {4242, 6889, 3988},
  {7184, 7191, 7181},
  {7196, 7197, 4073},
  {3988, 3990, 4199},
  {4044, 4199, 3990},
  {7195, 4075, 3936},
  {3936, 4075, 4045},
  {3731, 4045, 4119},
  {3731, 4119, 3939},
  {3941, 6351, 3895},
  {4077, 3942, 4168},
  {3793, 4168, 3942},
  {4076, 4120, 3688},
  {3688, 4120, 6351},
  {4247, 4076, 4047},
  {3996, 4077, 4205},
  {4205, 4122, 3943},
  {3997, 7317, 4247},
  {4078, 4247, 4080},
  {4049, 4124, 7317},
  {4049, 4326, 4124},
  {4123, 4128, 4048},
  {4048, 4128, 4050},
  {4051, 4050, 4132},
  {3946, 4000, 4254},
  {4054, 4087, 6112},
  {4088, 3948, 4089},
  {6355, 4175, 4136},
  {4086, 4135, 4176},
  {4086, 4176, 4008},
  {3955, 4006, 4259},
  {4006, 3955, 3953},
  {4214, 4009, 4215},
  {6390, 7222, 4011},
  {4090, 4091, 3910},
  {4092, 3910, 4091},
  {4178, 4141, 4092},
  {4013, 4179, 4014},
  {4096, 7224, 4055},
  {3960, 4141, 4097},
  {3962, 4264, 4217},
  {3962, 4217, 4179},
  {3912, 4095, 4104},
  {7613, 4015, 4103},
  {4102, 7613, 4103},
  {4097, 4146, 5833},
  {4143, 4056, 4145},
  {4106, 6968, 6969},
  {4018, 4147, 4150},
  {4149, 4150, 4147},
  {4058, 4148, 3972},
  {3972, 4148, 4188},
  {3972, 4188, 4059},
  {4060, 3975, 4191},
  {3928, 4061, 4153},
  {4151, 4155, 4022},
  {6118, 4108, 4109},
  {6118, 4109, 4108},
  {4109, 4023, 7469},
  {7469, 4023, 4111},
  {4111, 4023, 4110},
  {4110, 4023, 4024},
  {4227, 4112, 6110},
  {4024, 4025, 4110},
  {4110, 4025, 4111},
  {6512, 4111, 4025},
  {4025, 6312, 6512},
  {4279, 4065, 4031},
  {4113, 4028, 4065},
  {4066, 4028, 4113},
  {4113, 4233, 4066},
  {4066, 4232, 4114},
  {4068, 4033, 4114},
  {4067, 4033, 4068},
  {4114, 7653, 4068},
  {4070, 4234, 4035},
  {4038, 4037, 4195},
  {4070, 4039, 4158},
  {4159, 4158, 4039},
  {4071, 4282, 4161},
  {4196, 4159, 4039},
  {6810, 7370, 4242},
  {4164, 3888, 4117},
  {4242, 6809, 6810},
  {4075, 7194, 4045},
  {3831, 3895, 4290},
  {3895, 6351, 4290},
  {4119, 4166, 3939},
  {4168, 3793, 4167},
  {4244, 4121, 4077},
  {4122, 3999, 3943},
  {4204, 4123, 4079},
  {4124, 7316, 7317},
  {4079, 4123, 4048},
  {4125, 4127, 4128},
  {4125, 4129, 4127},
  {4081, 4127, 4129},
  {4127, 4081, 4128},
  {4170, 4128, 4081},
  {4128, 4130, 4050},
  {4050, 4130, 4131},
  {4050, 4131, 4132},
  {4133, 4171, 6260},
  {4082, 4081, 4129},
  {4081, 4083, 4170},
  {4081, 4082, 4083},
  {4326, 3946, 4254},
  {4083, 4082, 4134},
  {4135, 4173, 4138},
  {4134, 4137, 4083},
  {4138, 4170, 4083},
  {4213, 4174, 3948},
  {3948, 3949, 4213},
  {4213, 3949, 4052},
  {4135, 4086, 4084},
  {4089, 3948, 4174},
  {4083, 4137, 4138},
  {4006, 4256, 4259},
  {4138, 4295, 4135},
  {4090, 3955, 4177},
  {4090, 4177, 4091},
  {7223, 4094, 4216},
  {4264, 4301, 4217},
  {7224, 4096, 7222},
  {4096, 4098, 7222},
  {4095, 4263, 4104},
  {4095, 4014, 4263},
  {4098, 7290, 7222},
  {4101, 7613, 4182},
  {4101, 4142, 4181},
  {4101, 4182, 4142},
  {7613, 4102, 4144},
  {4102, 4184, 4144},
  {4102, 5834, 4184},
  {4348, 3920, 4104},
  {4147, 3920, 4348},
  {4185, 6968, 4106},
  {3921, 4150, 4185},
  {4020, 4021, 5834},
  {4153, 4189, 4186},
  {4153, 4186, 4021},
  {4153, 4190, 4189},
  {4153, 4061, 4222},
  {4154, 4276, 4107},
  {7642, 4109, 7469},
  {4062, 7300, 4228},
  {4062, 4228, 4063},
  {4226, 6384, 4111},
  {6512, 4226, 4111},
  {4112, 4227, 4193},
  {4065, 4279, 4113},
  {4233, 4232, 4066},
  {4031, 4157, 4318},
  {4031, 4318, 4231},
  {4194, 4069, 4235},
  {4194, 4157, 4069},
  {4037, 4236, 4365},
  {4070, 4158, 4234},
  {4037, 4365, 4195},
  {7166, 4195, 4117},
  {6889, 4242, 6812},
  {4118, 6808, 6811},
  {4242, 4200, 6809},
  {4045, 4166, 4119},
  {4045, 4201, 4166},
  {3793, 3939, 4166},
  {4168, 4167, 6952},
  {4076, 4247, 4246},
  {4169, 4204, 4079},
  {4121, 4250, 4077},
  {4205, 4245, 4122},
  {4122, 4202, 3999},
  {4202, 4169, 3999},
  {4079, 3999, 4169},
  {4128, 4123, 4249},
  {4077, 4250, 4205},
  {4251, 4208, 4205},
  {4126, 4205, 4208},
  {4205, 4126, 4249},
  {4128, 4206, 4125},
  {4208, 4172, 4126},
  {4126, 4172, 4249},
  {4125, 4206, 4129},
  {4130, 4128, 4131},
  {4171, 4133, 6327},
  {4172, 4209, 4249},
  {4138, 4173, 4170},
  {4173, 4132, 4131},
  {4129, 4294, 4082},
  {4173, 4135, 4132},
  {4082, 4294, 4134},
  {4132, 4135, 4084},
  {6112, 4087, 4373},
  {4256, 4006, 4088},
  {4052, 4085, 4213},
  {4134, 4211, 4137},
  {4256, 4210, 4259},
  {4136, 4175, 6355},
  {4137, 4295, 4138},
  {4295, 4176, 4135},
  {4177, 3955, 4259},
  {4139, 7222, 4261},
  {4091, 4177, 4092},
  {7223, 4216, 6391},
  {4141, 4178, 4300},
  {4014, 4218, 4263},
  {7222, 7290, 4219},
  {4180, 4219, 6488},
  {4263, 4268, 4104},
  {7013, 4219, 7290},
  {4146, 4097, 4220},
  {7633, 7013, 7290},
  {4181, 4142, 4182},
  {4144, 7032, 7613},
  {4099, 4181, 4269},
  {4144, 4184, 4183},
  {4220, 4183, 4146},
  {4143, 4145, 4347},
  {4145, 6498, 4347},
  {4056, 6498, 4145},
  {4185, 4188, 4148},
  {4185, 4148, 6122},
  {5834, 4021, 4186},
  {4150, 4149, 4308},
  {3975, 4059, 4188},
  {4190, 4273, 4189},
  {4274, 3975, 4188},
  {4153, 4222, 4190},
  {4152, 4060, 4191},
  {4191, 3975, 4274},
  {4061, 4192, 4275},
  {4061, 4275, 4222},
  {4107, 4224, 4061},
  {4022, 4155, 4223},
  {4022, 4277, 4228},
  {4063, 4228, 4227},
  {6512, 4317, 4226},
  {4231, 4279, 4031},
  {4114, 4232, 7653},
  {4194, 4235, 4318},
  {4318, 4157, 4194},
  {4159, 4196, 4158},
  {4196, 6537, 4160},
  {4117, 4285, 4198},
  {4240, 4163, 7182},
  {4198, 4164, 4117},
  {4071, 4197, 4072},
  {4071, 4161, 4197},
  {7182, 4072, 4197},
  {4164, 4198, 7193},
  {7193, 4198, 4165},
  {3988, 4199, 4242},
  {4200, 4241, 6809},
  {7194, 4198, 4045},
  {4045, 4198, 4201},
  {4287, 4243, 4166},
  {3831, 4290, 4044},
  {4246, 4120, 4076},
  {4553, 4120, 4246},
  {4120, 4553, 6351},
  {4122, 4245, 4202},
  {4202, 4203, 4169},
  {4204, 4169, 4203},
  {4247, 4078, 4248},
  {4245, 4205, 4249},
  {4204, 4249, 4123},
  {7043, 7316, 7042},
  {4205, 4250, 4251},
  {4131, 4128, 4170},
  {4249, 4209, 4253},
  {4206, 4294, 4129},
  {4405, 4000, 6784},
  {4170, 4173, 4131},
  {4000, 4600, 4254},
  {4134, 4294, 4211},
  {4257, 4256, 4088},
  {4089, 4257, 4088},
  {4211, 4295, 4137},
  {4085, 4258, 4213},
  {4085, 4175, 4212},
  {4214, 4212, 4175},
  {4295, 4215, 4176},
  {4214, 4215, 4260},
  {3952, 4261, 4087},
  {3952, 4139, 4261},
  {4177, 4262, 4092},
  {4092, 4262, 4300},
  {4092, 4300, 4178},
  {4300, 4097, 4141},
  {4179, 4217, 4014},
  {4218, 4014, 4217},
  {4180, 6488, 4219},
  {7032, 4144, 4221},
  {7032, 4221, 4266},
  {4221, 6276, 4266},
  {4100, 4143, 4264},
  {4348, 4104, 4268},
  {4184, 4146, 4183},
  {4147, 4348, 4308},
  {4272, 5834, 4307},
  {5834, 4272, 4146},
  {4308, 4149, 4147},
  {4150, 4188, 4185},
  {4307, 5834, 4186},
  {4272, 4307, 4349},
  {4150, 4187, 4188},
  {4189, 4307, 4186},
  {4150, 4309, 4187},
  {4188, 4187, 4274},
  {4223, 4155, 4151},
  {4151, 4152, 4223},
  {4353, 4192, 4061},
  {4061, 4224, 4353},
  {4276, 4224, 4107},
  {7469, 4111, 6384},
  {4227, 4228, 4229},
  {4228, 4277, 4229},
  {4227, 4229, 4230},
  {4317, 6512, 4193},
  {4227, 4230, 4193},
  {4193, 4230, 4278},
  {4279, 4361, 4113},
  {4280, 6133, 4069},
  {4037, 4319, 4281},
  {4037, 4281, 4236},
  {4158, 4237, 4234},
  {4238, 4195, 4365},
  {4163, 4319, 4116},
  {4196, 4160, 4321},
  {4195, 4238, 4284},
  {4160, 4162, 4241},
  {4160, 4241, 4321},
  {4239, 4163, 4240},
  {4117, 4195, 4285},
  {4195, 4284, 4285},
  {4240, 4197, 4286},
  {4240, 4286, 4239},
  {4197, 4240, 7182},
  {4286, 4161, 4322},
  {4288, 4241, 4200},
  {4200, 4242, 4289},
  {4287, 4166, 4201},
  {4323, 4243, 4287},
  {6952, 4167, 4370},
  {4166, 4370, 4167},
  {4167, 3793, 4166},
  {4245, 4203, 4202},
  {4245, 4291, 4203},
  {4203, 4291, 4204},
  {4121, 4244, 4250},
  {4247, 4248, 4246},
  {4249, 4204, 4292},
  {4206, 4128, 4249},
  {4206, 4249, 4253},
  {7316, 4124, 7042},
  {4250, 4371, 4251},
  {6327, 4207, 4171},
  {6327, 4293, 4207},
  {4172, 4208, 4511},
  {4172, 4511, 4209},
  {4254, 4600, 4255},
  {4256, 4331, 4210},
  {4089, 4333, 4257},
  {4089, 4174, 4333},
  {4174, 4334, 4333},
  {4085, 4212, 4258},
  {4213, 4336, 4174},
  {4212, 4214, 4258},
  {4087, 6405, 6981},
  {4213, 4296, 4336},
  {4213, 4258, 4296},
  {4214, 4260, 4297},
  {4259, 4407, 4177},
  {4177, 4407, 4262},
  {4097, 4300, 4340},
  {4380, 4097, 4340},
  {4382, 4097, 4380},
  {4301, 4341, 4217},
  {4265, 4219, 6426},
  {6276, 4097, 4266},
  {4182, 4385, 4181},
  {4267, 4302, 3964},
  {3964, 7612, 4267},
  {4345, 4267, 4304},
  {4143, 4347, 4264},
  {4270, 4305, 6497},
  {4271, 4270, 6496},
  {5833, 6498, 4056},
  {4189, 4273, 4307},
  {4308, 4309, 4150},
  {4187, 4309, 4311},
  {4190, 4222, 4273},
  {4152, 4191, 4223},
  {4223, 4277, 4022},
  {4193, 4278, 4317},
  {4231, 4318, 4279},
  {4234, 4237, 4321},
  {4282, 7653, 4463},
  {4236, 4281, 4365},
  {4237, 4158, 4321},
  {4158, 4196, 4321},
  {4283, 4163, 4239},
  {4397, 4283, 4239},
  {4286, 4197, 4161},
  {4285, 4201, 4198},
  {4287, 4201, 4285},
  {4288, 4200, 4289},
  {4044, 4471, 4199},
  {4468, 4471, 4044},
  {4243, 4431, 4166},
  {4290, 4468, 4044},
  {4404, 4168, 6952},
  {4244, 4077, 4168},
  {4168, 4404, 4244},
  {4245, 4292, 4291},
  {4291, 4292, 4204},
  {4245, 4249, 4292},
  {4248, 4324, 4246},
  {4251, 4325, 4208},
  {4206, 4253, 4294},
  {6325, 7524, 4252},
  {4254, 4255, 4328},
  {6326, 6121, 6267},
  {4210, 4331, 4330},
  {4294, 4332, 4211},
  {4210, 4330, 4259},
  {4211, 4332, 4295},
  {4373, 4087, 4335},
  {4174, 4336, 4334},
  {4259, 4337, 4407},
  {4258, 4214, 4297},
  {4296, 4258, 4298},
  {4338, 4298, 4258},
  {4299, 4338, 4258},
  {4261, 7222, 6405},
  {4339, 4340, 4300},
  {4217, 4341, 4218},
  {4381, 4301, 4342},
  {4264, 4342, 4301},
  {4218, 4341, 4343},
  {4218, 4343, 4263},
  {4263, 4343, 4268},
  {4097, 4303, 4266},
  {4342, 4264, 4347},
  {4302, 4385, 3964},
  {4384, 4268, 4343},
  {4385, 4182, 7613},
  {7032, 4266, 4344},
  {4303, 4344, 4266},
  {4181, 4385, 4269},
  {4270, 6497, 4305},
  {5833, 4389, 6498},
  {4272, 4389, 5833},
  {4273, 4310, 4307},
  {4308, 4350, 4309},
  {4273, 4352, 4310},
  {4350, 4390, 4309},
  {4309, 4390, 4351},
  {4187, 4311, 4274},
  {4273, 4391, 4352},
  {4222, 4391, 4273},
  {4223, 4191, 4314},
  {4222, 4275, 4391},
  {4314, 4191, 4274},
  {4224, 4276, 4313},
  {4275, 4192, 4393},
  {4276, 4225, 4313},
  {4313, 4225, 4226},
  {4223, 4315, 4277},
  {4316, 4277, 4315},
  {4316, 4358, 4317},
  {4317, 4278, 4316},
  {4229, 4316, 4278},
  {4316, 4229, 4277},
  {4230, 4229, 4278},
  {4360, 4361, 4279},
  {4396, 4360, 4279},
  {4279, 4318, 4396},
  {4156, 4035, 4362},
  {4234, 4362, 4035},
  {4233, 4395, 4232},
  {4396, 4069, 6133},
  {4069, 4396, 4235},
  {4318, 4235, 4396},
  {4365, 4281, 4319},
  {4319, 4540, 4365},
  {4320, 4319, 4163},
  {4320, 4163, 4283},
  {4397, 4320, 4283},
  {4161, 4364, 4322},
  {4397, 4239, 4286},
  {4287, 4285, 4284},
  {4286, 7567, 4400},
  {4284, 4366, 4287},
  {4366, 4368, 4287},
  {4287, 4368, 4323},
  {4199, 4369, 4242},
  {4288, 4289, 7078},
  {4199, 4471, 4369},
  {4243, 4323, 4431},
  {4244, 4404, 4250},
  {7042, 4124, 4326},
  {4433, 4208, 4325},
  {4208, 4433, 4511},
  {4436, 4209, 4511},
  {4253, 4209, 4436},
  {4332, 4294, 4253},
  {4255, 4600, 4329},
  {4327, 6124, 6125},
  {4329, 4328, 4255},
  {4331, 4256, 4439},
  {4330, 4375, 4259},
  {4337, 4259, 4375},
  {4295, 4441, 4215},
  {4087, 4261, 6405},
  {4296, 4298, 4336},
  {4299, 4258, 4297},
  {4260, 4299, 4297},
  {4338, 4336, 4298},
  {4377, 4338, 4299},
  {4262, 4407, 4300},
  {4300, 4378, 4339},
  {4340, 4339, 4380},
  {4409, 7222, 4219},
  {4381, 4408, 4301},
  {4301, 4408, 4341},
  {4381, 4342, 4383},
  {4344, 4303, 4382},
  {4303, 4097, 4382},
  {4302, 4267, 4386},
  {4267, 4345, 4386},
  {6126, 6458, 6123},
  {4385, 7082, 4269},
  {7632, 4447, 4413},
  {4268, 4388, 4348},
  {4306, 4270, 4271},
  {4351, 4274, 4309},
  {4309, 4274, 4311},
  {4274, 6135, 4314},
  {6131, 4314, 6135},
  {4224, 4313, 4353},
  {4223, 4314, 4392},
  {6128, 4312, 6714},
  {4353, 4393, 4192},
  {4226, 4353, 4313},
  {4357, 4356, 4317},
  {4358, 4357, 4317},
  {4353, 4226, 4421},
  {4354, 4355, 6717},
  {4317, 4356, 6718},
  {4316, 4315, 4358},
  {4358, 4315, 4223},
  {6718, 4394, 4317},
  {4421, 4226, 4359},
  {4317, 4359, 4226},
  {4361, 4424, 4113},
  {4156, 4458, 4280},
  {4280, 4458, 4426},
  {4362, 4425, 4156},
  {6133, 4280, 4426},
  {4232, 7652, 7653},
  {4427, 4363, 4321},
  {4363, 4234, 4321},
  {4282, 4364, 4161},
  {4286, 4400, 4397},
  {4238, 4429, 4284},
  {4284, 4429, 4398},
  {4284, 4398, 4366},
  {4322, 4464, 4286},
  {4366, 6132, 4368},
  {4286, 4464, 7568},
  {4242, 4369, 4289},
  {4166, 4431, 4370},
  {4431, 4323, 7156},
  {4290, 6351, 4468},
  {6952, 4431, 4404},
  {4251, 4433, 4325},
  {4432, 4433, 4251},
  {4293, 6327, 7681},
  {4000, 4405, 4372},
  {4405, 4252, 6525},
  {4000, 4372, 4600},
  {4252, 7524, 6525},
  {4327, 6125, 6124},
  {4475, 4253, 4436},
  {4254, 4328, 4326},
  {4329, 4600, 6567},
  {4328, 4329, 4326},
  {4375, 4330, 4558},
  {4331, 4439, 4330},
  {4376, 4253, 4475},
  {4295, 4332, 4253},
  {4439, 4256, 4257},
  {4257, 4333, 4439},
  {4295, 4253, 4376},
  {4373, 4335, 4374},
  {6404, 4374, 4335},
  {4338, 4406, 4336},
  {4299, 4260, 4377},
  {4215, 4440, 4260},
  {4440, 4442, 4260},
  {4339, 5837, 4480},
  {4339, 4378, 4379},
  {4339, 4480, 4380},
  {4343, 4341, 4408},
  {4382, 7032, 4344},
  {4302, 4386, 4385},
  {7632, 4413, 4411},
  {7632, 4411, 7013},
  {4386, 7031, 7033},
  {6127, 6130, 4388},
  {4352, 4391, 5838},
  {4419, 4391, 4275},
  {4392, 4314, 6131},
  {4275, 4393, 4419},
  {4356, 4418, 6718},
  {4355, 4354, 6717},
  {4421, 4393, 4353},
  {4357, 4358, 4223},
  {4357, 4223, 4420},
  {4394, 6718, 4418},
  {4418, 4422, 4394},
  {4423, 4359, 4317},
  {4423, 4317, 4422},
  {4394, 4422, 4317},
  {4361, 4360, 4424},
  {4156, 4425, 4458},
  {4113, 4424, 4233},
  {4362, 4234, 4459},
  {4363, 4459, 4234},
  {7651, 7713, 4115},
  {4363, 4427, 4462},
  {4320, 4397, 4428},
  {4320, 4428, 4319},
  {4321, 4241, 4427},
  {4364, 4464, 4322},
  {4398, 4399, 4366},
  {4368, 7176, 4398},
  {4368, 4398, 4429},
  {4429, 4430, 4401},
  {4429, 4401, 4368},
  {4403, 4367, 4464},
  {4401, 4402, 4368},
  {7078, 4369, 4466},
  {4369, 7078, 4289},
  {4402, 6880, 4368},
  {4368, 6880, 4323},
  {6880, 7156, 4323},
  {6952, 4370, 4431},
  {4553, 4468, 6351},
  {4553, 4471, 4468},
  {4505, 4250, 4404},
  {4246, 4324, 4472},
  {6951, 7042, 4326},
  {4251, 4371, 4432},
  {4371, 4551, 4432},
  {6525, 4434, 4405},
  {6443, 4437, 6129},
  {4326, 4329, 4512},
  {4374, 6804, 4373},
  {4375, 4558, 4601},
  {4334, 4439, 4333},
  {4374, 4560, 6804},
  {4295, 4376, 4514},
  {4338, 4377, 4406},
  {4215, 4441, 4440},
  {4260, 4442, 4377},
  {6405, 7222, 4520},
  {7222, 4409, 4520},
  {4380, 4480, 4382},
  {4381, 4383, 4408},
  {4383, 4384, 4343},
  {4383, 4343, 4408},
  {4383, 4387, 4346},
  {4383, 7189, 4384},
  {4411, 4410, 7013},
  {4385, 4386, 4483},
  {4383, 4342, 4387},
  {6854, 4412, 6130},
  {6130, 4412, 4388},
  {4527, 4348, 4388},
  {4348, 4448, 4390},
  {4389, 4347, 6498},
  {4272, 4415, 4389},
  {4348, 4350, 4308},
  {4390, 4350, 4348},
  {4349, 4415, 4272},
  {4310, 4532, 4307},
  {4351, 4390, 4449},
  {4351, 4450, 4274},
  {4419, 5839, 4391},
  {4420, 4534, 4357},
  {4417, 4422, 4418},
  {4423, 4421, 4359},
  {4457, 4421, 4423},
  {4495, 4424, 4360},
  {4233, 4424, 4395},
  {4396, 6133, 4360},
  {7650, 4424, 4460},
  {4363, 4462, 4694},
  {4282, 4463, 4364},
  {4428, 4540, 4319},
  {4364, 4463, 4464},
  {4365, 4540, 4238},
  {4238, 4542, 4429},
  {4241, 4543, 4500},
  {4241, 4288, 4543},
  {7567, 7569, 4467},
  {4402, 4401, 4430},
  {4369, 4471, 4590},
  {4553, 4246, 4472},
  {4250, 4505, 4371},
  {4551, 4371, 4505},
  {4405, 4434, 4372},
  {4372, 4434, 4600},
  {4473, 6525, 7524},
  {4474, 4558, 4330},
  {4439, 4474, 4330},
  {4439, 4334, 4476},
  {4336, 4476, 4334},
  {4295, 4514, 4440},
  {4295, 4440, 4441},
  {4406, 4377, 4442},
  {4407, 4478, 5837},
  {4480, 4481, 4382},
  {4445, 7013, 4410},
  {7033, 4382, 4481},
  {4409, 4219, 7013},
  {4410, 4411, 4485},
  {7150, 4446, 7149},
  {7150, 7149, 4446},
  {4413, 4447, 4523},
  {4347, 4414, 4342},
  {4448, 4348, 4527},
  {4347, 4528, 4414},
  {4529, 4528, 4347},
  {4307, 4570, 4349},
  {4449, 4450, 4351},
  {4453, 6137, 4451},
  {4417, 4453, 4451},
  {4533, 4453, 4417},
  {4418, 4533, 4417},
  {6131, 6135, 4392},
  {4494, 4451, 4419},
  {4416, 4575, 4534},
  {4451, 4494, 4417},
  {4416, 4534, 4493},
  {4416, 4493, 4223},
  {4223, 4493, 4420},
  {4356, 4357, 4418},
  {4534, 4418, 4357},
  {4494, 4422, 4417},
  {4393, 4421, 4419},
  {4494, 4455, 4422},
  {4421, 4456, 4419},
  {4455, 4457, 4423},
  {4455, 4423, 4422},
  {4421, 4457, 4456},
  {4425, 4362, 4459},
  {4458, 4495, 4426},
  {4426, 4360, 6133},
  {4426, 4495, 4360},
  {4424, 4461, 4539},
  {4579, 4115, 7713},
  {4115, 4579, 4463},
  {4428, 4497, 4540},
  {4428, 4397, 4498},
  {4427, 4241, 4634},
  {4241, 4500, 4634},
  {4540, 4499, 4238},
  {4238, 4499, 4542},
  {4429, 4544, 4430},
  {4465, 4543, 4288},
  {4403, 4464, 4503},
  {4501, 4466, 4369},
  {4503, 4467, 7569},
  {6424, 7154, 4502},
  {7155, 4504, 4431},
  {4431, 4504, 4469},
  {4470, 4471, 6357},
  {4470, 6357, 4471},
  {4505, 4404, 4551},
  {4551, 4509, 4432},
  {4436, 4511, 4475},
  {4435, 6134, 4473},
  {7524, 4438, 4473},
  {4601, 4561, 4375},
  {4476, 4336, 4477},
  {4336, 4406, 4477},
  {4375, 4561, 4337},
  {4477, 4406, 4515},
  {4951, 4512, 6760},
  {4440, 4608, 4442},
  {4561, 4407, 4337},
  {4406, 4442, 4609},
  {4442, 4608, 4609},
  {4561, 4652, 4407},
  {4407, 4652, 4478},
  {4478, 4444, 5837},
  {4516, 4444, 4478},
  {4518, 4444, 4516},
  {7484, 7485, 4479},
  {7484, 4479, 4610},
  {4480, 4518, 4517},
  {4480, 4444, 4518},
  {6405, 4520, 6148},
  {4521, 4482, 4519},
  {4482, 4521, 4445},
  {4521, 7013, 4445},
  {4613, 4409, 4521},
  {4482, 4445, 4410},
  {7013, 4521, 4409},
  {4410, 4485, 4524},
  {4485, 4411, 4522},
  {4522, 4413, 4523},
  {4385, 4483, 7082},
  {7067, 7082, 4483},
  {4386, 4484, 4483},
  {4522, 4411, 4413},
  {7082, 7067, 7068},
  {4342, 4527, 4412},
  {4412, 4527, 4388},
  {7151, 7152, 4485},
  {6139, 6305, 4487},
  {7598, 4487, 6305},
  {4347, 4389, 4529},
  {4530, 4529, 4389},
  {4489, 4490, 6304},
  {4489, 6304, 4490},
  {6305, 4490, 7598},
  {4490, 4491, 4492},
  {4415, 4530, 4389},
  {4349, 4530, 4415},
  {4390, 4448, 4449},
  {4352, 4531, 4310},
  {4310, 4531, 4532},
  {4416, 4223, 4392},
  {6136, 6140, 4454},
  {4534, 4420, 4493},
  {4494, 4419, 4455},
  {4419, 4456, 4457},
  {4419, 4457, 4455},
  {4458, 4425, 4535},
  {4535, 4495, 4458},
  {4495, 4536, 4424},
  {4459, 4363, 4899},
  {4424, 4496, 4461},
  {4424, 4539, 4537},
  {4496, 4538, 4461},
  {7713, 7714, 4579},
  {4541, 4463, 4579},
  {4497, 4428, 4633},
  {4633, 4428, 4498},
  {4463, 4541, 4464},
  {4636, 4498, 4397},
  {4636, 4397, 4400},
  {4400, 7567, 4636},
  {4465, 4676, 4543},
  {4586, 4501, 4369},
  {4369, 4590, 4586},
  {4551, 4404, 4548},
  {4549, 4548, 4404},
  {4404, 4431, 4549},
  {4431, 4469, 4549},
  {4504, 4550, 4469},
  {4507, 4506, 4552},
  {4508, 4507, 4552},
  {4681, 4555, 4551},
  {4551, 4555, 4509},
  {4510, 4508, 4554},
  {4506, 4511, 4433},
  {4506, 4507, 4511},
  {4507, 4508, 4511},
  {4508, 4510, 4511},
  {4434, 6524, 6807},
  {4435, 4473, 4649},
  {4438, 6403, 4473},
  {4512, 4951, 4326},
  {4439, 4476, 4513},
  {4476, 4477, 4513},
  {4477, 4603, 4513},
  {4477, 4515, 4603},
  {4608, 4440, 4514},
  {6567, 4600, 4443},
  {4515, 4406, 4562},
  {4406, 4563, 4562},
  {4406, 4609, 4563},
  {4652, 4516, 4478},
  {6746, 7025, 7486},
  {6405, 6148, 4612},
  {4521, 4654, 4613},
  {4706, 4481, 4614},
  {4482, 4410, 4564},
  {4706, 7033, 4481},
  {4410, 4524, 4564},
  {4523, 4565, 4522},
  {4522, 6514, 4485},
  {4483, 4484, 7067},
  {4484, 4386, 4616},
  {7033, 4616, 4386},
  {4524, 4485, 4618},
  {4525, 4618, 4485},
  {7538, 4523, 4447},
  {4447, 4486, 7538},
  {7172, 6138, 6144},
  {4488, 7466, 4490},
  {4490, 7466, 6979},
  {4492, 4624, 4490},
  {4531, 4352, 4668},
  {4352, 5838, 4668},
  {4450, 4449, 4569},
  {5838, 5840, 4669},
  {4416, 4572, 4575},
  {4453, 4533, 4452},
  {4533, 4418, 4629},
  {4392, 6135, 4576},
  {4418, 4534, 4629},
  {4535, 4425, 4577},
  {4535, 4577, 4495},
  {4695, 4496, 4536},
  {4536, 4496, 4424},
  {4424, 4537, 4460},
  {4363, 4694, 4899},
  {4497, 4633, 4540},
  {4543, 4634, 4500},
  {4464, 4541, 4675},
  {4580, 4544, 4540},
  {4542, 4540, 4544},
  {4544, 4580, 4639},
  {4429, 4542, 4544},
  {4503, 4464, 4675},
  {4501, 4545, 4466},
  {7078, 4466, 4545},
  {4675, 4677, 4503},
  {4675, 4635, 4638},
  {4675, 4638, 4677},
  {4501, 4586, 4545},
  {4545, 4586, 4546},
  {4545, 4546, 7078},
  {7078, 4546, 6741},
  {4402, 4430, 6881},
  {4586, 4590, 4589},
  {6147, 6142, 4547},
  {6146, 4547, 4592},
  {4469, 4550, 4549},
  {4554, 4508, 4552},
  {6141, 6156, 4432},
  {4432, 6156, 4433},
  {6156, 4506, 4433},
  {4435, 4649, 4556},
  {4511, 4510, 4557},
  {4511, 4557, 4598},
  {4510, 4595, 4557},
  {4434, 6807, 4596},
  {4511, 4599, 4475},
  {4511, 4598, 4599},
  {4649, 4473, 6403},
  {4475, 4599, 4376},
  {4474, 4439, 4513},
  {4559, 4376, 4599},
  {4599, 4602, 4559},
  {4376, 4559, 4514},
  {4559, 4602, 4514},
  {4514, 4602, 4605},
  {4514, 4605, 4608},
  {4562, 4603, 4515},
  {4609, 4607, 4563},
  {4610, 4951, 6760},
  {4600, 7303, 4443},
  {4518, 4652, 4517},
  {4516, 4652, 4518},
  {4610, 4479, 4519},
  {4517, 4611, 4891},
  {4517, 4891, 4480},
  {4519, 4653, 4521},
  {4891, 4481, 4480},
  {4614, 4481, 4891},
  {4524, 4618, 4564},
  {4618, 4525, 4526},
  {6514, 7151, 4485},
  {4529, 4530, 4528},
  {7466, 4661, 6979},
  {4490, 4624, 7598},
  {4665, 4624, 4492},
  {4569, 4449, 4448},
  {4448, 4626, 4569},
  {4570, 4307, 4532},
  {4573, 6135, 7672},
  {5838, 4669, 4668},
  {4628, 4571, 4452},
  {4572, 4416, 4392},
  {5840, 4571, 4669},
  {4627, 4669, 4571},
  {4452, 4533, 4628},
  {4574, 4575, 6393},
  {4574, 6393, 4575},
  {4576, 4748, 4392},
  {4672, 4495, 4577},
  {4536, 4495, 4672},
  {4578, 4672, 4577},
  {4577, 4425, 4578},
  {4672, 4695, 4536},
  {4459, 4899, 4425},
  {4674, 4694, 4462},
  {4696, 4674, 4462},
  {4462, 4427, 4696},
  {4496, 4695, 4538},
  {4540, 4633, 4580},
  {4498, 4582, 4633},
  {4579, 4675, 4541},
  {4636, 4583, 4498},
  {4582, 4581, 4639},
  {4582, 4639, 4580},
  {4540, 4542, 4499},
  {4581, 4583, 4639},
  {4584, 4639, 4583},
  {4584, 7535, 4639},
  {4586, 4642, 4546},
  {4546, 6708, 6741},
  {4586, 4589, 4642},
  {6708, 4546, 4642},
  {7244, 4587, 4504},
  {4591, 4587, 6881},
  {4643, 4591, 4588},
  {4587, 4591, 4550},
  {4587, 4550, 4504},
  {4591, 4593, 4550},
  {4591, 4643, 4593},
  {4592, 4547, 6146},
  {4547, 6142, 6147},
  {4644, 4590, 4471},
  {4548, 4549, 4645},
  {4549, 4550, 4646},
  {4679, 4644, 4471},
  {4471, 4553, 4679},
  {4554, 4552, 4701},
  {6156, 4552, 4506},
  {6161, 4553, 4472},
  {4554, 4701, 4510},
  {7682, 4510, 4701},
  {6141, 7559, 7560},
  {6951, 4326, 4812},
  {6807, 4594, 4596},
  {4557, 4595, 4650},
  {4557, 4650, 4598},
  {4434, 4596, 7547},
  {4772, 4558, 4474},
  {4648, 4879, 4773},
  {4603, 7682, 4773},
  {4773, 4513, 4603},
  {4603, 4606, 4604},
  {4603, 4562, 4607},
  {4603, 4607, 4606},
  {4562, 4563, 4607},
  {4652, 4611, 4517},
  {4610, 4519, 4739},
  {4443, 7303, 7486},
  {4519, 4482, 4739},
  {4653, 4654, 4521},
  {4891, 4892, 4614},
  {4655, 4482, 4564},
  {4657, 4565, 4615},
  {4707, 4615, 4565},
  {4565, 4523, 4707},
  {7033, 4706, 4616},
  {4617, 6143, 6149},
  {4742, 7067, 4484},
  {4659, 6472, 7539},
  {7466, 7557, 4528},
  {4528, 4619, 7466},
  {4661, 7466, 4619},
  {4528, 4660, 4619},
  {4528, 4530, 4660},
  {4620, 6145, 6150},
  {4620, 6150, 6145},
  {4688, 6979, 4661},
  {6979, 4688, 6978},
  {7598, 4624, 4621},
  {4566, 4622, 6977},
  {4623, 4530, 4349},
  {6482, 4623, 4349},
  {6159, 6967, 6978},
  {6153, 6159, 6978},
  {4448, 4621, 4667},
  {4448, 4667, 4626},
  {4568, 4567, 4793},
  {4568, 4793, 4492},
  {4570, 4625, 4349},
  {4531, 4668, 4532},
  {4569, 4626, 4576},
  {4569, 4576, 4573},
  {4628, 4627, 4571},
  {4573, 4576, 6135},
  {4671, 4628, 4533},
  {4533, 4629, 4671},
  {4575, 4629, 4534},
  {4629, 4630, 4671},
  {7295, 4631, 4630},
  {4696, 4427, 4632},
  {4538, 4695, 4461},
  {4579, 7714, 4673},
  {4427, 4634, 4632},
  {4633, 4582, 4580},
  {4498, 4583, 4581},
  {4498, 4581, 4582},
  {6629, 4584, 4583},
  {4584, 6628, 4726},
  {6628, 7654, 4726},
  {4584, 4729, 7535},
  {4543, 4676, 4728},
  {7567, 4467, 4677},
  {4637, 6445, 6444},
  {6445, 4637, 6444},
  {4467, 4503, 4677},
  {4639, 4698, 4544},
  {4544, 4678, 4430},
  {4430, 4678, 6881},
  {4678, 4640, 6881},
  {4641, 4588, 4640},
  {4678, 4544, 4698},
  {6881, 4640, 4588},
  {4642, 4589, 4590},
  {6881, 4588, 4591},
  {4644, 4642, 4590},
  {4548, 4645, 4680},
  {4646, 4645, 4549},
  {4731, 4646, 4550},
  {4680, 4551, 4548},
  {4551, 4680, 4681},
  {4647, 4879, 4648},
  {4769, 4647, 7683},
  {7682, 4701, 4769},
  {6141, 7560, 6156},
  {6951, 4812, 6420},
  {7682, 4650, 4510},
  {4650, 4595, 4510},
  {6303, 4596, 4597},
  {4596, 6303, 7547},
  {4650, 7682, 4598},
  {4649, 6403, 7546},
  {7682, 4599, 4598},
  {4603, 4602, 7682},
  {7682, 4602, 4599},
  {4600, 4434, 4651},
  {4603, 4604, 4605},
  {4603, 4605, 4602},
  {4604, 4606, 4608},
  {4604, 4608, 4605},
  {4607, 4609, 4606},
  {4606, 4609, 4608},
  {4561, 4683, 4652},
  {6853, 4611, 4652},
  {6853, 4652, 4683},
  {4611, 4704, 4684},
  {7303, 6746, 7486},
  {4684, 4685, 4611},
  {6405, 4612, 7302},
  {4654, 4653, 6589},
  {4891, 4611, 4685},
  {6589, 4613, 4654},
  {7684, 7685, 4741},
  {4656, 4655, 4564},
  {4484, 4616, 4706},
  {4617, 6149, 6143},
  {4658, 4523, 6472},
  {4659, 4658, 6472},
  {4530, 4689, 4660},
  {4530, 4623, 4689},
  {6153, 4689, 4623},
  {4662, 6152, 6151},
  {6978, 4688, 6153},
  {4664, 6154, 4663},
  {4690, 4625, 4570},
  {6155, 4625, 4690},
  {4492, 4717, 4665},
  {4627, 4628, 4721},
  {4627, 4721, 4669},
  {4572, 4392, 4575},
  {4626, 4748, 4576},
  {4628, 4671, 4692},
  {4630, 4575, 4670},
  {4575, 4630, 4629},
  {4631, 7295, 4630},
  {4672, 4752, 4695},
  {7715, 4723, 7714},
  {4461, 4724, 4723},
  {4461, 4723, 7715},
  {4461, 4695, 4724},
  {4940, 4675, 4579},
  {4635, 4675, 4940},
  {4635, 4940, 4697},
  {4636, 7567, 4677},
  {4635, 4697, 4638},
  {4641, 4643, 4588},
  {4641, 4699, 4643},
  {4550, 4593, 4731},
  {6688, 4642, 4644},
  {4642, 6710, 6708},
  {4645, 4646, 4733},
  {4552, 4702, 4701},
  {4647, 4769, 4770},
  {4326, 4951, 4812},
  {4601, 4558, 4772},
  {4474, 4513, 4736},
  {4651, 4434, 4682},
  {4651, 4778, 4600},
  {4951, 4610, 4739},
  {4611, 6853, 6855},
  {6589, 4653, 4738},
  {4482, 4779, 4739},
  {4482, 4655, 4779},
  {4657, 4615, 4705},
  {7684, 4741, 7685},
  {4614, 4892, 4706},
  {4565, 4657, 4705},
  {4523, 4687, 4707},
  {4484, 4706, 4742},
  {4659, 7539, 7540},
  {4659, 4686, 4709},
  {4658, 4659, 4711},
  {4659, 4709, 4711},
  {4688, 4619, 4660},
  {4619, 4688, 4661},
  {4660, 4689, 4712},
  {4712, 6153, 4688},
  {4662, 6151, 6152},
  {4712, 4689, 6153},
  {4623, 6159, 6153},
  {4664, 4663, 6154},
  {4667, 4621, 4624},
  {6482, 4666, 4623},
  {6159, 4623, 4666},
  {4626, 4624, 4665},
  {4624, 4626, 4667},
  {4691, 6155, 4690},
  {6932, 4793, 4567},
  {4793, 4832, 4492},
  {4748, 4626, 4665},
  {4668, 4718, 4532},
  {4532, 4719, 4570},
  {4714, 4570, 4719},
  {4570, 4714, 6158},
  {4713, 6158, 4714},
  {4721, 4668, 4669},
  {4628, 4692, 4721},
  {4670, 4575, 4748},
  {4575, 4392, 4748},
  {4630, 4670, 4794},
  {4693, 4692, 4671},
  {4671, 4630, 4693},
  {4722, 4693, 4630},
  {4723, 4753, 7714},
  {4673, 4753, 4579},
  {4695, 6360, 4724},
  {4753, 4940, 4579},
  {4634, 4543, 4756},
  {4634, 4756, 4725},
  {4756, 4543, 4727},
  {4757, 4636, 4677},
  {4584, 4759, 4729},
  {4543, 4728, 4727},
  {4638, 4697, 4677},
  {4678, 4730, 4640},
  {4641, 4640, 4699},
  {4733, 4646, 4731},
  {4733, 4808, 4645},
  {6709, 6164, 4700},
  {7639, 4679, 4768},
  {4680, 4734, 7560},
  {6156, 4702, 4552},
  {4701, 4850, 4769},
  {4812, 4735, 4703},
  {4682, 4434, 7547},
  {4474, 4815, 4772},
  {6405, 4813, 4771},
  {4778, 4651, 4682},
  {4601, 4772, 4561},
  {7303, 4600, 4778},
  {7302, 4818, 6405},
  {4779, 4655, 4740},
  {4779, 4740, 4821},
  {4740, 4655, 4656},
  {4564, 4618, 7396},
  {6302, 4522, 4565},
  {6514, 4522, 4708},
  {4618, 6162, 7396},
  {4522, 6302, 4708},
  {4523, 4658, 4687},
  {4686, 7069, 4709},
  {4709, 4829, 4711},
  {7641, 6740, 7640},
  {4709, 4710, 4829},
  {4687, 4658, 4825},
  {4658, 4711, 4825},
  {4660, 4712, 4688},
  {6330, 4714, 4715},
  {6330, 4715, 4690},
  {4690, 4715, 4691},
  {4691, 4715, 6163},
  {6157, 6933, 4793},
  {4665, 4717, 4748},
  {4532, 4718, 4719},
  {4716, 6838, 4720},
  {4722, 4630, 4794},
  {4672, 4578, 4899},
  {4578, 4425, 4899},
  {4695, 4752, 6360},
  {4673, 7714, 4753},
  {4696, 4632, 4725},
  {4632, 4634, 4725},
  {6828, 4726, 7654},
  {4759, 4761, 7116},
  {4677, 4697, 4757},
  {4700, 4728, 4676},
  {4843, 4678, 4698},
  {4762, 4678, 4804},
  {4730, 4678, 4762},
  {4699, 4640, 4730},
  {4731, 4593, 4766},
  {4593, 4643, 4766},
  {4699, 4766, 4643},
  {4732, 6160, 4733},
  {4732, 4733, 6160},
  {6164, 4849, 4700},
  {4734, 4680, 4808},
  {4680, 4645, 4808},
  {4811, 4702, 6156},
  {7560, 4734, 4809},
  {7560, 4809, 4811},
  {4811, 6156, 7560},
  {4647, 4770, 4879},
  {4773, 4736, 4513},
  {4474, 4736, 4774},
  {4736, 4775, 4774},
  {4561, 4772, 4683},
  {6405, 4818, 4737},
  {4705, 4615, 4785},
  {4615, 4707, 4822},
  {4564, 7396, 4656},
  {4861, 4656, 7396},
  {4705, 6302, 4565},
  {4788, 4707, 4687},
  {4742, 4743, 4710},
  {4710, 4743, 4787},
  {4825, 4788, 4687},
  {4711, 4744, 4746},
  {4746, 4744, 4825},
  {4745, 6959, 7459},
  {4710, 4747, 4829},
  {4825, 4711, 4746},
  {4789, 4714, 4719},
  {4714, 4789, 4715},
  {4790, 4715, 4789},
  {4792, 4715, 4790},
  {4717, 4492, 4832},
  {4715, 4792, 6163},
  {6163, 4749, 4750},
  {4833, 6933, 4750},
  {4833, 4750, 4749},
  {6933, 4833, 4793},
  {4718, 4668, 4834},
  {6163, 4751, 4749},
  {6163, 4792, 4751},
  {4668, 4721, 4834},
  {4721, 4794, 4834},
  {4721, 4692, 4794},
  {4670, 4748, 4794},
  {4692, 4693, 4794},
  {4693, 4722, 4794},
  {4672, 4899, 4795},
  {4795, 4796, 4672},
  {4672, 4796, 4752},
  {4723, 4724, 4797},
  {4899, 4694, 4798},
  {6360, 4752, 4837},
  {4724, 6360, 6361},
  {4674, 4696, 4799},
  {4674, 4799, 4694},
  {4696, 4800, 4799},
  {6360, 4837, 6361},
  {4800, 4696, 4725},
  {4725, 4756, 4800},
  {4940, 4754, 4697},
  {6828, 4755, 4726},
  {6828, 4801, 4755},
  {4697, 4754, 4757},
  {4755, 4584, 4726},
  {4755, 4758, 4584},
  {4584, 4758, 4759},
  {4759, 4803, 4761},
  {7116, 4760, 6615},
  {7116, 4761, 4760},
  {4639, 4585, 4761},
  {4639, 4843, 4698},
  {4843, 4804, 4678},
  {4847, 4765, 7393},
  {4766, 4699, 4730},
  {4767, 4806, 4700},
  {4767, 4700, 4849},
  {4702, 4810, 4701},
  {4553, 6161, 4735},
  {4553, 4735, 4874},
  {4878, 4735, 4812},
  {4682, 7547, 4882},
  {4774, 4815, 4474},
  {4775, 4736, 4816},
  {4736, 4776, 4816},
  {4776, 4736, 4814},
  {4776, 4814, 4777},
  {4776, 4777, 4816},
  {4682, 4882, 4778},
  {6405, 4737, 4813},
  {4780, 4820, 4783},
  {4780, 4783, 4782},
  {4781, 4784, 4782},
  {4781, 4782, 4783},
  {4785, 4615, 4822},
  {4706, 4892, 4823},
  {4706, 4823, 4742},
  {4823, 4743, 4742},
  {4823, 4787, 4743},
  {4786, 4745, 4744},
  {4744, 4829, 4786},
  {4786, 6959, 4745},
  {4744, 4711, 4829},
  {4787, 4747, 4710},
  {4790, 4789, 4719},
  {4791, 4717, 4832},
  {4748, 4717, 4791},
  {4749, 4751, 4833},
  {4748, 4833, 4794},
  {4724, 6361, 4797},
  {4799, 4798, 4694},
  {4801, 4802, 4755},
  {4755, 4802, 4842},
  {4755, 4842, 4758},
  {4757, 4754, 4841},
  {6828, 4764, 5846},
  {4759, 4758, 4803},
  {4727, 4728, 4700},
  {4727, 4700, 4756},
  {4764, 7393, 4844},
  {4761, 4585, 6616},
  {7393, 4765, 4844},
  {4765, 4805, 4844},
  {7393, 5011, 4847},
  {4765, 4847, 4805},
  {4730, 4762, 4766},
  {4731, 4766, 4871},
  {4847, 4914, 4807},
  {4946, 4806, 4767},
  {4874, 4849, 4768},
  {4734, 4808, 4809},
  {4768, 4679, 4874},
  {4553, 4874, 4679},
  {4810, 4702, 4811},
  {4850, 4701, 4810},
  {4877, 4770, 4769},
  {4851, 4852, 4809},
  {4811, 4809, 4852},
  {4814, 4736, 4773},
  {4817, 4777, 4814},
  {4817, 4816, 4777},
  {4813, 4737, 4853},
  {4737, 4885, 4853},
  {4882, 4922, 4778},
  {4737, 4818, 4885},
  {4739, 4819, 4951},
  {4739, 4889, 4819},
  {4739, 4779, 4889},
  {4854, 4780, 4782},
  {4780, 4855, 4820},
  {4783, 4820, 4856},
  {4783, 4890, 6626},
  {4821, 4740, 4857},
  {4705, 4785, 4894},
  {4784, 4781, 6626},
  {4781, 4783, 6626},
  {4740, 4656, 4857},
  {4822, 4707, 6176},
  {4707, 4788, 6176},
  {4858, 4860, 4786},
  {4862, 4823, 6169},
  {7396, 7397, 4861},
  {4828, 4786, 4860},
  {4786, 4829, 4824},
  {4786, 4824, 4858},
  {4823, 4862, 4787},
  {6168, 6959, 6167},
  {4786, 4828, 6959},
  {4827, 4788, 4825},
  {4787, 4829, 4747},
  {4829, 4787, 4935},
  {4830, 4718, 4834},
  {4751, 4792, 4831},
  {4790, 4831, 4792},
  {4793, 4833, 4832},
  {4832, 4835, 4791},
  {4748, 4791, 4835},
  {4833, 4751, 4834},
  {4833, 4834, 4794},
  {4835, 4833, 4748},
  {4837, 4752, 4796},
  {4797, 6361, 4836},
  {6361, 4837, 4836},
  {4798, 4799, 5006},
  {4801, 4863, 4838},
  {4801, 4838, 4839},
  {4800, 4756, 4864},
  {4840, 5846, 4764},
  {4758, 4842, 4803},
  {4843, 4639, 4866},
  {4803, 4842, 4761},
  {4842, 4639, 4761},
  {4842, 4866, 4639},
  {6885, 4764, 6827},
  {4804, 4869, 4762},
  {4762, 4869, 4766},
  {4700, 4806, 4946},
  {4804, 4846, 4869},
  {4847, 5011, 4914},
  {4914, 4848, 4807},
  {4915, 4848, 4914},
  {4874, 4872, 4849},
  {4849, 4873, 4767},
  {4809, 4808, 4916},
  {4811, 4950, 4810},
  {4850, 4875, 4769},
  {4878, 4874, 4735},
  {4770, 4877, 4879},
  {4815, 4880, 4772},
  {4883, 4814, 4773},
  {7547, 4813, 4882},
  {4884, 4774, 4775},
  {4775, 4816, 4884},
  {4884, 4814, 4883},
  {4884, 4817, 4814},
  {4772, 4920, 4683},
  {4683, 4920, 6853},
  {4923, 4886, 4704},
  {4778, 6166, 7303},
  {4704, 4886, 4684},
  {4854, 4855, 4780},
  {4887, 4782, 4685},
  {4887, 4854, 4782},
  {4855, 4856, 4820},
  {4779, 4821, 4889},
  {4783, 4856, 4890},
  {4782, 4784, 4895},
  {6165, 4859, 6625},
  {4894, 4785, 4927},
  {4785, 4822, 4927},
  {4895, 4784, 6626},
  {6167, 4860, 4960},
  {4960, 4860, 4858},
  {6169, 4823, 4892},
  {6176, 4788, 6167},
  {4824, 4934, 4858},
  {4824, 4829, 4934},
  {6484, 4826, 6483},
  {6167, 6959, 4860},
  {4828, 4860, 6959},
  {4787, 4862, 4935},
  {4719, 4718, 4790},
  {4831, 4790, 4718},
  {4718, 4830, 4831},
  {4751, 4831, 4830},
  {4830, 4834, 4751},
  {4832, 4833, 4835},
  {4797, 4900, 4723},
  {4797, 4836, 4900},
  {4796, 4938, 4837},
  {5006, 4899, 4798},
  {4900, 4940, 4753},
  {4863, 4901, 4838},
  {4902, 4838, 4901},
  {4904, 4754, 4940},
  {4838, 4902, 4839},
  {4840, 4863, 4801},
  {4901, 4863, 4840},
  {4754, 4904, 4841},
  {4840, 4764, 4901},
  {4903, 4901, 4764},
  {4801, 4866, 4802},
  {4801, 4839, 4865},
  {4801, 4865, 4866},
  {4802, 4866, 4842},
  {4843, 4866, 4867},
  {4843, 4867, 4804},
  {4804, 4867, 4905},
  {4864, 4756, 4908},
  {4764, 4844, 4903},
  {4905, 4846, 4804},
  {4905, 4910, 4846},
  {4756, 4909, 4908},
  {4757, 4904, 4964},
  {4909, 4756, 4700},
  {4844, 4965, 4903},
  {4846, 7052, 7054},
  {7054, 4912, 4846},
  {4846, 4912, 4869},
  {4869, 4912, 4766},
  {7054, 4913, 4912},
  {4766, 4912, 4870},
  {4766, 4870, 4871},
  {4731, 4871, 4968},
  {4807, 4966, 4847},
  {4807, 4848, 4966},
  {4849, 4872, 4873},
  {4808, 4733, 4916},
  {4767, 4873, 4946},
  {4916, 4851, 4809},
  {4989, 5019, 4874},
  {4810, 4876, 4850},
  {4875, 4850, 4876},
  {4918, 4810, 4950},
  {4810, 4918, 4876},
  {4877, 4769, 4875},
  {4918, 4948, 4876},
  {4950, 4811, 4952},
  {4852, 4851, 4949},
  {4852, 4952, 4811},
  {4881, 4879, 4877},
  {4877, 4919, 4881},
  {4812, 4951, 4878},
  {4879, 4881, 4773},
  {4880, 4920, 4772},
  {4773, 4881, 4883},
  {4853, 4882, 4813},
  {4884, 4815, 4774},
  {4921, 4882, 4853},
  {4816, 4817, 4884},
  {4853, 4885, 4921},
  {4882, 4921, 4922},
  {4921, 6174, 4922},
  {4778, 4922, 4885},
  {4885, 6166, 4778},
  {4885, 4818, 6166},
  {4854, 4975, 4855},
  {4685, 4684, 4887},
  {4975, 4854, 4887},
  {4855, 4888, 4856},
  {4685, 4782, 7687},
  {4890, 4856, 4977},
  {4959, 4960, 4858},
  {4959, 4858, 4893},
  {4893, 4858, 6857},
  {6626, 4890, 4928},
  {6626, 4928, 4931},
  {4894, 4937, 4705},
  {4895, 6626, 4862},
  {4937, 6302, 4705},
  {4931, 4862, 6626},
  {6176, 6167, 4932},
  {4932, 6167, 4930},
  {4862, 4931, 4935},
  {4897, 4896, 4937},
  {4898, 4934, 4829},
  {4898, 4829, 4935},
  {4795, 4899, 4983},
  {4938, 4795, 4983},
  {4795, 4938, 4796},
  {4753, 4723, 4900},
  {4836, 4939, 4900},
  {4836, 4837, 4939},
  {4899, 5006, 5215},
  {4941, 4837, 4938},
  {4800, 5006, 4799},
  {4944, 4800, 4864},
  {4865, 4839, 4902},
  {4866, 4865, 4902},
  {4864, 4908, 4944},
  {4841, 4904, 4757},
  {4945, 4906, 4903},
  {4906, 4945, 4907},
  {4909, 4944, 4908},
  {7052, 4910, 4945},
  {4910, 7052, 4846},
  {7053, 4911, 7065},
  {4845, 6171, 4868},
  {4868, 6171, 7311},
  {4844, 4805, 4966},
  {4847, 4966, 4805},
  {4966, 4848, 4915},
  {4731, 4968, 4733},
  {4872, 4874, 4873},
  {4873, 4874, 4917},
  {4873, 4917, 4946},
  {4948, 4919, 4877},
  {4878, 4951, 4874},
  {5024, 4880, 4815},
  {4819, 4972, 4951},
  {4886, 4925, 4684},
  {4975, 4887, 4924},
  {4976, 4855, 4975},
  {4684, 4925, 4887},
  {4888, 4855, 4976},
  {4888, 4958, 4856},
  {4977, 4856, 4958},
  {7687, 4782, 7686},
  {6175, 4997, 4890},
  {7686, 4782, 4895},
  {4997, 4928, 4890},
  {4857, 4656, 4999},
  {4979, 4999, 4656},
  {4822, 6176, 6713},
  {4929, 4932, 4962},
  {4858, 4934, 6857},
  {4861, 4979, 4656},
  {4932, 6764, 4962},
  {4932, 4930, 6764},
  {7397, 4936, 4861},
  {4896, 4897, 4937},
  {7397, 4937, 4936},
  {4837, 4984, 4939},
  {4837, 4942, 4984},
  {4837, 4941, 4942},
  {4901, 4943, 4902},
  {4901, 4903, 4943},
  {4902, 4943, 4867},
  {4902, 4867, 4866},
  {4906, 4943, 4903},
  {4943, 4906, 4867},
  {4906, 4907, 4867},
  {4905, 4867, 4907},
  {4907, 4945, 4905},
  {4910, 4905, 4945},
  {4904, 4963, 4964},
  {6685, 7052, 4945},
  {4909, 4700, 5074},
  {4700, 4946, 5074},
  {4903, 4965, 4945},
  {6555, 7638, 6422},
  {7053, 7065, 6170},
  {4913, 4967, 4912},
  {4967, 4913, 7064},
  {4967, 4968, 4912},
  {4968, 4871, 4870},
  {4914, 4966, 4915},
  {4968, 4916, 4733},
  {4947, 4946, 4917},
  {4916, 4949, 4851},
  {4876, 4948, 4875},
  {4875, 4948, 4877},
  {4950, 4953, 4918},
  {4918, 4953, 4948},
  {4948, 4953, 6475},
  {6475, 4954, 4948},
  {4948, 4954, 4919},
  {4954, 5148, 4919},
  {4920, 4880, 4992},
  {4884, 4971, 4990},
  {4884, 4883, 4971},
  {4920, 4973, 6853},
  {4922, 6173, 4885},
  {4992, 4924, 4887},
  {4992, 4975, 4924},
  {4923, 7371, 4886},
  {4886, 7371, 4925},
  {4889, 5093, 4819},
  {4821, 5093, 4889},
  {4976, 4958, 4888},
  {5099, 7278, 4926},
  {4926, 7279, 5099},
  {4978, 4890, 4977},
  {6175, 4957, 4997},
  {4821, 4857, 4956},
  {4999, 4956, 4857},
  {4894, 4927, 4937},
  {6167, 4960, 4930},
  {4933, 6177, 6765},
  {4934, 4982, 6857},
  {4931, 4928, 4997},
  {6713, 6176, 6179},
  {4981, 4962, 6764},
  {4934, 4898, 4935},
  {4982, 4934, 4935},
  {4899, 5215, 5104},
  {4984, 4942, 5004},
  {4942, 4941, 5003},
  {5006, 4800, 4944},
  {5008, 5006, 4944},
  {4940, 4963, 4904},
  {6885, 7393, 4764},
  {6172, 5012, 6705},
  {6696, 6705, 5012},
  {7064, 5051, 4967},
  {4912, 4968, 4870},
  {4968, 4969, 4970},
  {4968, 4970, 4916},
  {4969, 4968, 5018},
  {4949, 4916, 4970},
  {4949, 4988, 4952},
  {4949, 4952, 4852},
  {6315, 4953, 4955},
  {4972, 4989, 4951},
  {4815, 4884, 5058},
  {4884, 4990, 5058},
  {4991, 4971, 4883},
  {4883, 4881, 4991},
  {4919, 4991, 4881},
  {4920, 4992, 4973},
  {4973, 4992, 4974},
  {4974, 6853, 4973},
  {4974, 4992, 4925},
  {4887, 4925, 4992},
  {4925, 7371, 4974},
  {4976, 5094, 4958},
  {4890, 4978, 4996},
  {4957, 5029, 4997},
  {6857, 4982, 4998},
  {4937, 4927, 4980},
  {4927, 4822, 6713},
  {4980, 4961, 5069},
  {4961, 4981, 5069},
  {4931, 5067, 4935},
  {4931, 4997, 5067},
  {7239, 5002, 4936},
  {4899, 5104, 4983},
  {4941, 4938, 5003},
  {5003, 5042, 4942},
  {4942, 4985, 5004},
  {4942, 5042, 4985},
  {4963, 5040, 4964},
  {4944, 4909, 5010},
  {5040, 5011, 7393},
  {5040, 4763, 4964},
  {6555, 6422, 5014},
  {6555, 5014, 5015},
  {5048, 4986, 4914},
  {5012, 5045, 6696},
  {6696, 5014, 6422},
  {6172, 4966, 5012},
  {5048, 5052, 4986},
  {4914, 5049, 4966},
  {5051, 5016, 4967},
  {4967, 5016, 4968},
  {4968, 5054, 5017},
  {4970, 4969, 4987},
  {5018, 4987, 4969},
  {4874, 5019, 4917},
  {4917, 7591, 4947},
  {4949, 4970, 5023},
  {5022, 5023, 4970},
  {5023, 4988, 4949},
  {4874, 4951, 4989},
  {4950, 4952, 5088},
  {4953, 5089, 4955},
  {6178, 7691, 4954},
  {5148, 4954, 7691},
  {4992, 4880, 5025},
  {5024, 5025, 4880},
  {5058, 5024, 4815},
  {4975, 5027, 5028},
  {4975, 5028, 4976},
  {4821, 4956, 5093},
  {7278, 5099, 5121},
  {4958, 5096, 4977},
  {7035, 4993, 6859},
  {5029, 4957, 6180},
  {4890, 4996, 6455},
  {4959, 4993, 4960},
  {4993, 4959, 6859},
  {7037, 6858, 7098},
  {4956, 5124, 5064},
  {4998, 5122, 5163},
  {4996, 4978, 4977},
  {4956, 4999, 5124},
  {6857, 4998, 4995},
  {4979, 5032, 4999},
  {4937, 4980, 5031},
  {6764, 6766, 5034},
  {4960, 5000, 5034},
  {4979, 4861, 5032},
  {5069, 4981, 5033},
  {4981, 6764, 5033},
  {4982, 4935, 5067},
  {4982, 5067, 4998},
  {4936, 5001, 4861},
  {4936, 5002, 5001},
  {4983, 5071, 4938},
  {4939, 4984, 4900},
  {4900, 4984, 5037},
  {4900, 5037, 5005},
  {5040, 4900, 5005},
  {5005, 5039, 5040},
  {5007, 5004, 4985},
  {4900, 5040, 4940},
  {4963, 4940, 5040},
  {4985, 5009, 5007},
  {5043, 5007, 5009},
  {4985, 5042, 5009},
  {4914, 5011, 5048},
  {5045, 5012, 5013},
  {5050, 6554, 5015},
  {5013, 5012, 5049},
  {6696, 5046, 5014},
  {7517, 7330, 6554},
  {6554, 5050, 7517},
  {4966, 5049, 5012},
  {4914, 4986, 5049},
  {5016, 5054, 4968},
  {4968, 5017, 5018},
  {4987, 5018, 5056},
  {5018, 5017, 5054},
  {5018, 5054, 5056},
  {4970, 4987, 5020},
  {4987, 5056, 5020},
  {4970, 5020, 5022},
  {5021, 5019, 4989},
  {4917, 5057, 7591},
  {4988, 5087, 4952},
  {4952, 5087, 5088},
  {4950, 5088, 4953},
  {4971, 4991, 5026},
  {4972, 4819, 5093},
  {4992, 5027, 4975},
  {5028, 5094, 4976},
  {5061, 5062, 5028},
  {5094, 5096, 4958},
  {5064, 5060, 4956},
  {5063, 5029, 6180},
  {4977, 5096, 5101},
  {4996, 4977, 5101},
  {5122, 4998, 5030},
  {4997, 5029, 5030},
  {5067, 5030, 4998},
  {5030, 5067, 4997},
  {5066, 4937, 5031},
  {5000, 4960, 5102},
  {5034, 5033, 6764},
  {5033, 5034, 5069},
  {5035, 6181, 6182},
  {5035, 6182, 6181},
  {6183, 5001, 5036},
  {5002, 5036, 5001},
  {5103, 5036, 5002},
  {4938, 5071, 5003},
  {4984, 5004, 5037},
  {5004, 5007, 5043},
  {5004, 5043, 5037},
  {5037, 5043, 5038},
  {5039, 5041, 5040},
  {5169, 5042, 5003},
  {5006, 5008, 5105},
  {5107, 5040, 5041},
  {5131, 5040, 5107},
  {5010, 5108, 4944},
  {5008, 4944, 5108},
  {5131, 5011, 5040},
  {5048, 5011, 5131},
  {5010, 4909, 5072},
  {4909, 5074, 5072},
  {5045, 5013, 5075},
  {5045, 5075, 6653},
  {6696, 5045, 7679},
  {6696, 7679, 5046},
  {5014, 5046, 5076},
  {5050, 6691, 7517},
  {5050, 5109, 6691},
  {4986, 5174, 5049},
  {7460, 5053, 5051},
  {5051, 5054, 5016},
  {7084, 7085, 5055},
  {5051, 5080, 5054},
  {7084, 5055, 7085},
  {5051, 5053, 5079},
  {5019, 5081, 4917},
  {5022, 5020, 5084},
  {4917, 5081, 5083},
  {4917, 5083, 5057},
  {7591, 5057, 5113},
  {5138, 4988, 5023},
  {5084, 5023, 5022},
  {5088, 6649, 4953},
  {5089, 4953, 6649},
  {5026, 4990, 4971},
  {5024, 5058, 5090},
  {5026, 4991, 5059},
  {4972, 5093, 5092},
  {5025, 5120, 4992},
  {5027, 4992, 5120},
  {5061, 5028, 5027},
  {5093, 4956, 5060},
  {5028, 5062, 5094},
  {5061, 5095, 5062},
  {4993, 4994, 5065},
  {5122, 5029, 5063},
  {5030, 5029, 5122},
  {6455, 4996, 5100},
  {4993, 5065, 7394},
  {4993, 7394, 4960},
  {4960, 7394, 5102},
  {4999, 5125, 5124},
  {4999, 5032, 5068},
  {4999, 5068, 5125},
  {5031, 4980, 5066},
  {4980, 5847, 5066},
  {4980, 5069, 5847},
  {4937, 5066, 5274},
  {5000, 5069, 5034},
  {4861, 5001, 5032},
  {5001, 6184, 5070},
  {5274, 5002, 4937},
  {5002, 5274, 5129},
  {5002, 5129, 5103},
  {4983, 5104, 5071},
  {5037, 5038, 5005},
  {5005, 5106, 5039},
  {5038, 5106, 5005},
  {5039, 5106, 5041},
  {5038, 5043, 5106},
  {5006, 5105, 5215},
  {5106, 5107, 5041},
  {5008, 5108, 5105},
  {5044, 5108, 5010},
  {5010, 5072, 5044},
  {5045, 6653, 7679},
  {5073, 5109, 5046},
  {5049, 5075, 5013},
  {5046, 5109, 5076},
  {5109, 5050, 5076},
  {5076, 5050, 5047},
  {6189, 6691, 5109},
  {4946, 4947, 5078},
  {5080, 5056, 5054},
  {5080, 5051, 5079},
  {5021, 5081, 5019},
  {5021, 5082, 5081},
  {5138, 5140, 4988},
  {6693, 5056, 5080},
  {5021, 4989, 5082},
  {5081, 5112, 5083},
  {5114, 4988, 5140},
  {5113, 5057, 5083},
  {5082, 4989, 5085},
  {4989, 5086, 5085},
  {4989, 5118, 5117},
  {4990, 5026, 5151},
  {4990, 5151, 5058},
  {4919, 5183, 4991},
  {4972, 5092, 5091},
  {4972, 5091, 5149},
  {5024, 5120, 5025},
  {5093, 5060, 5119},
  {5122, 7277, 7306},
  {5063, 6965, 5122},
  {5157, 5121, 5099},
  {5062, 5095, 5123},
  {5095, 5097, 5123},
  {5060, 5064, 5153},
  {5065, 4994, 7037},
  {6858, 7037, 4994},
  {5096, 6186, 5101},
  {5102, 5069, 5000},
  {5001, 5070, 5032},
  {5068, 5032, 5128},
  {5032, 5070, 5128},
  {5102, 5847, 5069},
  {6184, 5189, 5070},
  {5103, 5189, 6184},
  {5071, 5104, 5166},
  {5190, 5003, 5168},
  {5042, 5169, 5009},
  {5048, 5131, 5171},
  {5044, 5132, 5108},
  {5044, 5072, 5132},
  {5072, 5074, 5110},
  {5072, 5110, 5197},
  {5072, 5197, 5132},
  {5075, 5135, 6385},
  {5110, 5074, 5198},
  {5135, 5075, 5049},
  {5074, 4946, 5198},
  {6189, 5111, 6691},
  {4946, 5078, 5176},
  {5174, 4986, 5052},
  {5079, 6642, 5080},
  {5081, 5082, 5112},
  {5082, 5141, 5112},
  {5112, 5142, 5083},
  {5023, 5084, 5137},
  {5084, 5139, 5137},
  {5084, 5020, 5139},
  {5020, 5056, 5139},
  {5082, 5143, 5141},
  {5142, 5116, 5083},
  {5142, 5115, 5116},
  {5113, 5083, 5116},
  {5082, 5085, 5143},
  {5085, 5086, 7335},
  {7692, 5148, 7691},
  {5118, 4989, 4972},
  {5024, 5090, 5120},
  {5090, 5058, 5151},
  {5059, 5151, 5026},
  {5091, 5092, 5119},
  {5059, 4991, 6190},
  {5092, 5093, 5119},
  {5061, 5027, 5151},
  {5153, 5152, 5060},
  {5154, 5122, 7306},
  {5061, 5155, 5095},
  {5123, 5094, 5062},
  {5160, 6185, 6459},
  {5158, 5123, 5097},
  {6185, 5160, 5098},
  {6455, 5100, 5101},
  {6455, 5101, 6186},
  {5124, 5161, 5064},
  {7394, 5065, 7037},
  {5066, 5847, 5127},
  {5189, 5128, 5070},
  {5103, 5130, 5189},
  {5103, 5129, 5130},
  {5071, 5166, 5003},
  {5104, 5215, 5167},
  {5104, 5167, 5166},
  {5003, 5166, 5168},
  {5003, 5190, 5169},
  {5215, 5105, 5108},
  {5108, 5134, 5215},
  {5108, 5132, 5134},
  {5134, 5133, 5132},
  {5133, 5132, 5134},
  {5132, 5197, 5134},
  {5135, 5049, 5172},
  {5172, 5049, 5174},
  {5111, 6189, 5199},
  {5052, 5048, 5223},
  {5053, 5136, 5079},
  {5079, 5200, 5137},
  {5138, 5023, 5137},
  {5202, 5138, 5137},
  {5080, 6642, 6693},
  {5087, 5114, 5140},
  {5141, 5142, 5112},
  {5142, 5141, 5143},
  {5142, 5143, 5115},
  {5116, 7086, 5113},
  {5114, 5087, 4988},
  {6335, 5143, 6188},
  {5143, 6335, 5115},
  {5144, 6187, 5146},
  {5145, 5118, 5146},
  {7086, 5116, 5115},
  {6193, 5088, 5087},
  {5088, 6193, 6649},
  {5178, 5118, 4972},
  {5178, 4972, 5149},
  {5177, 4919, 5148},
  {4919, 5177, 5183},
  {5149, 5091, 5150},
  {5150, 5119, 5179},
  {5179, 5119, 5182},
  {5091, 5119, 5150},
  {5182, 5119, 5181},
  {5090, 5151, 5120},
  {5119, 5152, 5181},
  {5059, 6190, 6377},
  {5059, 6377, 5151},
  {4991, 5183, 6190},
  {5119, 5060, 5152},
  {5120, 5151, 5027},
  {7306, 5185, 5154},
  {5155, 5159, 5095},
  {5156, 5122, 5154},
  {5095, 5159, 5097},
  {5153, 5064, 5293},
  {5094, 5123, 5158},
  {5122, 5156, 5163},
  {5099, 5213, 5157},
  {5099, 7276, 5213},
  {6459, 7016, 5160},
  {5158, 5097, 5159},
  {5158, 5159, 5242},
  {5161, 5212, 5064},
  {5161, 5124, 5245},
  {5126, 7036, 5186},
  {5124, 5125, 5245},
  {7394, 7395, 5188},
  {5066, 5127, 5164},
  {5274, 5066, 5164},
  {7394, 5188, 5102},
  {5189, 5165, 5128},
  {5276, 5130, 5129},
  {5274, 5276, 5129},
  {5169, 5190, 5170},
  {5169, 5170, 5009},
  {5009, 5170, 5191},
  {5009, 5191, 5043},
  {5043, 5192, 5106},
  {5106, 5131, 5107},
  {5106, 5192, 5131},
  {5171, 5131, 5192},
  {5193, 5215, 5134},
  {5198, 5197, 5110},
  {5338, 5198, 4946},
  {5250, 5048, 5171},
  {5176, 5338, 4946},
  {5223, 5048, 5250},
  {5199, 5173, 5175},
  {5173, 5199, 6189},
  {5174, 5052, 5223},
  {5111, 5199, 5077},
  {5221, 5053, 5077},
  {5053, 5221, 5136},
  {7590, 5176, 5078},
  {5136, 5221, 5079},
  {5222, 5079, 5221},
  {5200, 5079, 5222},
  {5138, 5201, 5256},
  {5138, 5225, 5140},
  {5140, 5225, 5087},
  {7167, 5087, 5225},
  {5146, 5203, 5144},
  {5146, 5118, 5203},
  {5115, 6335, 6353},
  {5177, 5148, 7692},
  {5178, 5229, 5118},
  {7507, 7509, 5180},
  {7507, 5180, 7692},
  {5180, 5177, 7692},
  {5150, 5179, 5229},
  {5150, 5229, 5149},
  {5179, 5182, 5344},
  {5177, 5180, 5208},
  {5152, 5235, 5181},
  {5184, 6190, 5265},
  {6190, 5183, 5265},
  {5151, 5155, 5061},
  {5151, 6377, 5155},
  {5159, 6466, 5265},
  {5159, 5155, 6466},
  {5236, 5156, 5154},
  {5154, 5185, 5236},
  {6571, 5158, 5242},
  {5212, 5387, 5064},
  {5161, 5245, 5212},
  {5187, 5213, 5162},
  {6191, 5160, 7016},
  {5186, 7036, 7462},
  {6316, 5187, 5162},
  {7016, 5187, 6191},
  {5299, 5125, 5068},
  {5164, 5127, 5327},
  {5127, 5847, 5327},
  {5247, 5327, 5847},
  {5327, 5274, 5164},
  {5128, 5165, 5068},
  {5299, 5068, 5165},
  {5130, 5276, 5189},
  {5215, 5166, 5167},
  {5191, 5192, 5043},
  {5191, 5248, 5192},
  {5190, 5216, 5170},
  {5166, 5194, 5302},
  {5190, 5302, 5216},
  {5166, 5215, 5194},
  {5215, 5193, 5217},
  {5215, 5218, 5194},
  {5193, 5134, 5195},
  {5135, 5172, 5220},
  {6192, 5135, 5219},
  {6664, 5196, 6663},
  {6192, 5173, 6189},
  {5278, 5173, 6192},
  {5173, 5278, 5175},
  {5176, 7590, 5255},
  {5138, 5202, 5201},
  {5137, 5200, 5224},
  {5137, 5224, 5202},
  {5113, 7086, 5342},
  {5087, 5258, 6193},
  {5203, 5204, 5144},
  {6193, 5226, 6649},
  {5089, 6649, 5205},
  {5144, 5204, 5228},
  {5144, 5228, 5147},
  {5203, 5118, 5229},
  {5203, 5229, 5261},
  {5344, 5229, 5179},
  {5206, 7510, 5230},
  {7508, 7510, 5206},
  {5149, 5229, 5178},
  {5206, 5230, 7508},
  {5233, 5177, 5208},
  {5208, 5180, 5207},
  {5181, 5344, 5182},
  {5208, 5234, 5233},
  {5239, 5159, 5265},
  {5209, 6194, 5210},
  {5209, 5210, 6194},
  {5293, 5064, 5387},
  {5121, 5157, 5241},
  {5242, 5159, 5239},
  {5246, 5187, 7016},
  {5213, 5187, 5246},
  {5102, 5350, 5431},
  {5102, 5431, 7392},
  {5102, 5188, 5350},
  {5168, 5166, 5190},
  {5214, 5192, 5248},
  {5214, 5249, 5192},
  {5166, 5302, 5190},
  {5170, 5216, 5191},
  {5192, 5331, 5371},
  {5192, 5371, 5171},
  {5216, 5302, 7678},
  {5215, 5217, 5218},
  {5193, 5195, 5217},
  {5217, 5333, 5218},
  {5135, 5220, 5219},
  {5197, 5303, 5134},
  {5252, 5303, 5197},
  {5199, 5221, 5077},
  {5253, 5338, 5176},
  {5174, 5223, 5282},
  {5176, 5255, 5253},
  {5283, 5253, 5255},
  {5200, 5222, 5224},
  {5284, 5257, 5201},
  {5201, 5202, 5284},
  {5225, 5138, 6532},
  {5258, 6564, 6193},
  {6648, 6646, 5227},
  {5260, 5203, 5261},
  {5203, 5260, 5204},
  {5228, 5204, 5260},
  {5228, 5287, 5147},
  {7510, 6647, 5259},
  {6646, 6648, 5227},
  {5230, 7510, 5259},
  {5229, 5344, 5287},
  {6198, 5208, 5207},
  {6198, 7255, 5208},
  {5234, 5208, 7255},
  {5233, 5183, 5177},
  {5264, 5234, 5263},
  {5234, 5264, 5233},
  {5183, 5233, 5264},
  {5237, 5210, 5267},
  {5237, 5267, 7374},
  {5152, 5153, 5235},
  {5210, 5211, 5267},
  {5236, 5266, 5156},
  {5320, 5156, 5266},
  {5185, 5268, 5236},
  {5185, 5121, 5268},
  {5237, 5238, 5210},
  {5238, 5211, 5210},
  {5267, 5242, 5239},
  {5212, 5294, 5365},
  {5156, 5320, 5240},
  {5186, 7462, 5270},
  {5212, 5245, 5294},
  {7420, 5271, 7395},
  {5163, 5156, 7718},
  {5157, 5213, 5273},
  {5157, 5273, 5241},
  {5211, 5242, 5267},
  {7719, 5244, 5243},
  {7016, 5272, 5246},
  {5271, 5188, 7395},
  {5271, 5297, 5188},
  {5125, 5299, 5245},
  {5297, 5350, 5188},
  {5276, 5275, 5165},
  {5165, 5189, 5276},
  {5214, 5248, 5249},
  {7677, 5301, 5216},
  {5333, 6461, 5218},
  {5303, 6195, 5195},
  {5217, 6195, 5333},
  {5371, 5250, 5171},
  {5219, 5251, 6192},
  {5134, 5303, 5195},
  {5220, 5172, 5334},
  {6192, 5251, 5278},
  {5279, 5252, 5197},
  {5197, 5198, 5279},
  {5172, 5174, 5335},
  {5174, 5282, 5335},
  {5199, 5175, 5278},
  {5221, 5199, 5278},
  {5278, 5280, 5221},
  {5257, 5254, 5256},
  {5201, 5257, 5256},
  {5256, 6532, 5138},
  {6564, 5259, 6647},
  {6564, 6647, 6193},
  {6564, 5286, 5259},
  {5289, 5230, 5259},
  {5287, 5344, 5147},
  {5229, 5287, 5261},
  {5230, 5289, 5262},
  {6196, 7508, 5230},
  {7255, 5263, 5234},
  {5181, 5235, 5344},
  {7374, 5318, 7144},
  {5264, 5292, 5183},
  {5291, 5319, 5237},
  {7374, 5267, 5318},
  {5183, 5292, 5265},
  {5266, 5236, 5268},
  {5265, 5269, 5239},
  {5235, 5153, 5293},
  {5237, 5319, 5238},
  {5267, 5239, 5269},
  {5121, 5324, 5295},
  {5121, 5295, 5268},
  {5212, 5365, 5387},
  {5121, 5241, 5324},
  {5294, 5245, 5321},
  {5321, 5245, 5365},
  {5325, 5365, 5245},
  {5270, 7462, 5240},
  {5240, 7462, 5156},
  {7718, 5156, 7461},
  {5273, 5324, 5241},
  {7016, 5211, 5296},
  {5272, 5296, 5298},
  {5296, 5272, 7016},
  {5272, 5298, 5246},
  {5327, 5247, 5328},
  {5299, 5165, 5329},
  {5275, 5329, 5165},
  {5431, 7391, 7392},
  {5331, 5192, 5249},
  {5216, 5301, 5191},
  {5251, 5219, 5848},
  {5219, 5220, 5848},
  {5305, 7040, 5252},
  {5252, 5279, 5305},
  {5278, 5304, 5280},
  {5198, 5338, 5279},
  {5221, 5309, 5254},
  {5281, 5223, 5250},
  {5254, 5257, 5221},
  {5221, 5257, 5284},
  {5438, 5223, 5281},
  {5284, 5285, 5221},
  {5221, 5285, 5224},
  {5221, 5224, 5222},
  {5284, 5202, 5285},
  {5285, 5202, 5224},
  {5255, 7589, 5283},
  {7589, 7592, 5310},
  {5225, 6532, 7167},
  {5343, 5259, 5286},
  {5228, 5260, 5287},
  {5343, 5289, 5259},
  {5260, 5261, 5287},
  {5289, 5343, 5288},
  {6199, 5288, 5314},
  {7374, 5290, 5446},
  {6199, 5232, 5231},
  {6199, 5314, 6203},
  {6199, 6203, 5232},
  {6197, 7145, 6198},
  {6198, 7145, 7255},
  {5264, 5263, 5318},
  {5269, 5318, 5267},
  {5265, 5292, 5269},
  {5387, 5346, 5293},
  {5319, 5211, 5238},
  {5270, 5240, 5320},
  {6639, 5300, 6489},
  {5273, 5213, 5351},
  {5213, 5246, 5351},
  {5300, 7391, 6489},
  {5431, 6489, 7391},
  {5275, 5276, 5274},
  {5248, 5331, 5249},
  {5191, 5301, 5330},
  {5302, 5352, 5301},
  {5194, 5218, 5302},
  {5848, 5220, 5334},
  {5251, 5332, 5278},
  {5308, 5250, 5371},
  {5353, 5306, 5278},
  {5308, 5281, 5250},
  {5278, 5306, 5304},
  {5280, 5309, 5221},
  {5306, 5307, 5304},
  {5304, 5307, 5337},
  {5338, 5253, 5283},
  {5356, 5254, 5309},
  {5338, 5283, 5310},
  {5283, 7589, 5310},
  {5311, 6533, 5340},
  {5312, 5446, 5313},
  {7375, 5446, 5312},
  {5316, 5315, 6200},
  {5290, 7374, 7144},
  {7144, 5318, 5317},
  {5263, 5317, 5318},
  {5345, 5235, 5293},
  {5318, 5269, 5264},
  {5292, 5264, 5269},
  {5367, 5268, 5295},
  {5392, 5366, 5270},
  {5270, 5320, 5392},
  {5323, 5322, 5295},
  {5295, 5324, 5323},
  {5211, 5454, 5296},
  {5298, 5296, 5454},
  {5325, 5245, 5299},
  {5271, 5366, 5297},
  {5326, 5297, 5366},
  {5326, 5368, 5297},
  {5351, 5396, 5273},
  {5246, 5298, 5351},
  {5275, 5274, 5369},
  {5330, 5248, 5191},
  {5248, 5330, 5331},
  {5218, 6461, 5302},
  {5848, 5332, 5251},
  {5277, 6201, 5303},
  {5303, 5405, 6195},
  {5308, 5371, 5438},
  {5353, 5278, 5332},
  {5280, 5304, 5309},
  {5172, 5335, 5375},
  {5172, 5375, 5334},
  {6815, 5306, 5353},
  {6201, 5279, 5373},
  {5306, 6815, 5307},
  {5304, 5337, 5309},
  {5279, 5338, 5373},
  {5337, 5377, 5309},
  {5308, 5438, 5281},
  {6815, 7467, 5307},
  {5339, 5307, 7467},
  {5307, 5339, 5337},
  {7352, 5337, 5336},
  {7352, 5336, 5337},
  {5309, 5377, 5356},
  {5338, 5310, 5414},
  {5223, 5438, 5282},
  {5358, 5472, 5310},
  {5310, 5113, 5358},
  {5359, 5358, 5113},
  {5113, 5342, 5359},
  {6564, 5341, 5286},
  {5286, 5341, 5343},
  {5342, 7086, 5360},
  {5288, 5361, 5314},
  {5314, 5361, 5362},
  {5314, 5362, 5363},
  {5313, 5514, 7376},
  {6203, 5314, 5446},
  {7376, 5514, 5291},
  {5345, 5344, 5235},
  {5345, 5293, 5346},
  {5389, 5428, 5268},
  {5367, 5389, 5268},
  {5365, 5325, 5453},
  {5347, 5453, 5325},
  {5348, 5367, 5295},
  {5323, 5349, 5322},
  {5348, 5322, 5349},
  {5324, 5349, 5323},
  {5295, 5322, 5348},
  {5271, 7420, 5366},
  {5351, 5298, 5454},
  {5324, 5273, 5396},
  {5297, 5368, 5350},
  {5299, 5329, 5500},
  {5274, 5327, 5397},
  {5500, 5329, 5369},
  {5275, 5369, 5329},
  {5352, 5330, 5301},
  {5848, 5334, 5332},
  {6195, 5405, 5333},
  {5334, 5372, 5332},
  {5353, 5332, 5372},
  {6201, 5373, 5374},
  {5375, 5408, 5334},
  {5353, 6817, 6815},
  {6815, 6336, 7467},
  {5354, 7467, 6336},
  {5335, 5282, 5438},
  {6679, 5355, 5356},
  {5337, 5339, 5377},
  {5357, 5377, 5339},
  {5340, 6533, 5311},
  {6564, 7663, 5341},
  {5360, 5359, 5342},
  {5341, 5417, 5343},
  {5343, 5417, 5288},
  {5288, 5417, 5361},
  {5344, 5360, 7086},
  {5361, 5383, 5362},
  {5384, 5385, 5313},
  {5290, 6202, 5446},
  {5313, 5385, 5514},
  {6202, 6203, 5446},
  {5314, 5363, 5386},
  {5268, 5364, 5266},
  {5428, 5364, 5268},
  {5319, 5291, 5514},
  {5387, 5365, 5388},
  {5320, 5266, 5364},
  {5211, 5319, 5514},
  {5349, 5390, 5389},
  {5367, 5348, 5349},
  {5367, 5349, 5389},
  {5349, 5324, 5396},
  {5325, 5299, 5347},
  {5368, 5326, 5395},
  {5326, 5366, 5395},
  {5327, 5328, 5399},
  {5330, 5371, 5331},
  {5370, 5401, 5330},
  {5370, 5352, 5402},
  {5370, 5330, 5352},
  {5352, 5302, 5403},
  {5352, 5403, 5402},
  {5403, 5302, 6461},
  {5403, 6461, 5333},
  {5371, 5406, 5438},
  {6627, 5353, 5372},
  {6201, 5405, 5303},
  {6201, 5374, 5405},
  {5334, 5408, 5372},
  {5335, 5437, 5375},
  {5438, 5437, 5335},
  {7008, 7007, 6495},
  {5355, 6679, 5356},
  {5356, 5377, 5378},
  {6770, 5377, 5357},
  {5356, 5378, 5254},
  {5416, 5254, 5378},
  {5414, 5310, 5441},
  {5357, 6621, 6770},
  {5254, 5416, 7663},
  {5472, 5441, 5310},
  {7663, 5416, 5417},
  {7663, 5417, 5341},
  {5382, 5384, 5419},
  {5313, 5419, 5384},
  {5361, 5417, 5420},
  {5420, 5383, 5361},
  {5383, 5424, 5362},
  {5446, 5314, 5386},
  {5386, 5363, 5362},
  {5424, 5386, 5362},
  {5426, 5345, 5387},
  {5346, 5387, 5345},
  {5425, 5345, 5426},
  {5425, 5476, 5345},
  {5345, 5476, 5344},
  {5365, 5427, 5388},
  {5364, 5392, 5320},
  {5390, 5391, 5430},
  {5390, 5430, 5389},
  {5365, 5453, 5427},
  {5390, 5349, 5391},
  {5453, 5347, 5394},
  {5366, 5392, 5518},
  {5391, 5349, 5393},
  {5391, 5393, 5480},
  {5396, 5351, 5454},
  {5349, 5396, 5393},
  {5347, 5299, 5394},
  {5500, 5369, 7615},
  {7617, 5400, 7614},
  {5274, 5397, 5458},
  {5274, 5458, 7616},
  {5274, 7616, 5369},
  {5400, 7617, 7614},
  {5460, 5330, 5401},
  {5401, 5370, 5402},
  {5371, 5404, 5406},
  {5405, 5403, 5333},
  {6817, 5353, 5434},
  {5405, 5374, 5433},
  {5372, 5408, 5407},
  {5372, 5407, 6627},
  {5373, 5433, 5374},
  {6817, 7103, 5412},
  {6815, 6817, 5412},
  {5411, 6818, 6816},
  {5410, 6206, 5376},
  {5439, 5373, 5338},
  {5412, 5413, 6815},
  {6336, 6815, 5413},
  {5466, 5439, 5338},
  {6336, 5413, 5531},
  {5380, 7554, 5531},
  {6207, 6213, 6673},
  {5377, 6770, 5378},
  {5421, 5380, 5381},
  {5380, 5421, 5535},
  {5474, 5358, 5359},
  {5418, 5382, 5419},
  {5359, 5360, 5474},
  {6832, 5448, 6743},
  {5420, 5447, 5383},
  {5424, 5383, 5447},
  {5446, 5386, 5424},
  {5344, 5423, 5360},
  {5387, 5388, 5450},
  {5364, 5428, 5392},
  {5391, 5429, 5497},
  {5391, 5497, 5430},
  {5211, 5514, 5491},
  {5389, 5430, 5428},
  {5391, 5480, 5429},
  {5480, 5393, 5455},
  {5393, 5396, 5455},
  {5453, 5394, 5299},
  {5500, 5453, 5299},
  {5368, 5395, 5456},
  {5327, 5399, 5397},
  {5500, 5398, 5458},
  {5458, 5397, 5596},
  {5399, 6640, 5457},
  {5402, 5459, 5460},
  {5402, 5460, 5401},
  {5330, 5460, 5371},
  {5432, 5459, 5402},
  {5402, 5403, 5405},
  {6261, 5371, 5850},
  {5371, 5460, 5850},
  {5402, 5405, 5461},
  {6205, 5371, 6261},
  {5433, 5462, 5849},
  {6627, 5407, 5434},
  {5408, 5435, 5409},
  {5409, 5435, 5463},
  {6268, 5436, 5407},
  {5434, 5407, 5436},
  {5439, 5433, 5373},
  {5433, 5439, 5462},
  {7498, 5462, 5439},
  {5375, 5437, 5435},
  {5435, 5408, 5375},
  {5436, 7103, 5434},
  {6817, 5434, 7103},
  {6387, 5464, 6211},
  {5413, 5412, 5440},
  {5531, 5413, 5440},
  {5414, 5466, 5338},
  {6207, 6204, 6213},
  {6673, 6213, 5467},
  {5445, 5378, 6770},
  {5378, 5445, 5470},
  {5441, 5466, 5414},
  {5380, 5531, 5381},
  {5416, 5378, 5470},
  {5441, 5472, 5469},
  {5509, 5469, 5472},
  {6569, 5442, 6570},
  {5416, 5420, 5417},
  {5421, 5422, 6819},
  {6743, 5448, 6692},
  {5419, 5313, 5446},
  {5447, 5420, 5487},
  {5419, 5446, 5473},
  {5423, 5474, 5360},
  {5446, 5424, 5447},
  {5384, 5854, 5385},
  {5514, 5385, 5854},
  {5476, 5423, 5344},
  {5449, 5426, 5387},
  {5449, 5387, 5450},
  {5425, 5426, 5476},
  {5450, 5388, 5492},
  {5388, 5427, 5492},
  {5392, 5428, 5478},
  {5428, 5517, 5478},
  {5451, 5430, 5497},
  {5452, 5429, 5480},
  {5428, 5430, 5451},
  {5211, 5498, 5454},
  {5395, 5366, 5456},
  {5457, 5397, 5399},
  {5368, 5431, 5350},
  {5431, 5457, 6640},
  {5402, 5461, 5432},
  {5433, 5461, 5405},
  {5849, 5461, 5433},
  {5482, 5409, 5463},
  {5483, 5462, 7498},
  {5504, 5463, 5435},
  {5409, 5482, 6209},
  {5438, 5406, 5404},
  {5435, 5437, 5504},
  {5529, 5504, 5437},
  {5465, 5464, 6387},
  {5438, 5529, 5437},
  {5506, 5412, 6210},
  {5412, 5506, 5440},
  {5441, 5469, 5557},
  {5467, 5533, 6673},
  {5533, 5415, 6673},
  {6568, 5444, 5443},
  {5415, 5533, 5445},
  {5420, 5416, 5470},
  {5380, 5535, 5379},
  {5471, 5445, 5533},
  {5445, 5471, 5470},
  {5420, 5486, 5487},
  {5489, 5418, 5419},
  {5488, 5419, 5473},
  {5421, 6819, 5640},
  {5421, 5640, 5535},
  {5418, 5489, 5382},
  {5487, 5473, 5447},
  {5472, 5358, 5474},
  {7079, 7545, 6831},
  {5473, 5446, 5447},
  {5423, 5426, 5474},
  {5382, 5854, 5384},
  {5423, 5476, 5426},
  {7545, 5513, 6831},
  {5450, 5492, 5449},
  {5491, 5477, 5211},
  {5453, 5492, 5427},
  {5493, 5497, 5429},
  {5429, 5452, 5493},
  {5493, 5452, 5494},
  {5495, 5494, 5452},
  {5211, 5477, 5479},
  {5498, 5211, 5479},
  {5428, 5451, 5497},
  {5452, 5480, 5495},
  {5455, 5396, 5454},
  {5366, 5499, 5456},
  {5397, 5457, 6217},
  {5502, 6217, 5457},
  {5481, 5459, 5432},
  {5459, 5481, 5460},
  {5432, 5461, 5481},
  {5503, 6341, 5462},
  {5526, 5503, 5462},
  {5482, 5463, 5504},
  {5462, 5483, 5526},
  {5404, 5505, 5438},
  {6209, 5525, 6210},
  {6210, 5525, 5506},
  {5528, 5465, 5439},
  {5531, 5440, 5506},
  {5507, 5439, 5466},
  {5508, 5467, 5468},
  {5467, 5508, 5533},
  {5441, 5557, 5466},
  {5470, 5486, 5420},
  {5533, 5484, 5485},
  {5533, 5485, 5471},
  {5471, 5485, 5470},
  {5470, 5485, 5486},
  {5484, 5419, 5485},
  {5488, 5485, 5419},
  {5473, 5487, 5488},
  {5509, 5472, 5474},
  {5510, 5509, 5474},
  {5854, 5382, 5489},
  {5510, 5474, 5426},
  {6214, 6831, 5490},
  {5513, 7545, 5512},
  {5513, 5540, 6831},
  {5491, 5514, 6216},
  {5494, 5495, 5591},
  {5477, 5591, 5495},
  {5491, 5515, 5477},
  {5497, 5493, 5494},
  {5497, 5494, 5516},
  {5495, 5479, 5477},
  {5392, 5478, 5517},
  {5498, 5479, 5495},
  {5495, 5480, 5498},
  {5392, 5517, 5518},
  {5366, 5518, 5576},
  {5480, 5455, 5498},
  {5454, 5498, 5455},
  {5519, 5499, 5366},
  {5545, 5519, 5366},
  {5499, 5519, 5627},
  {5499, 5627, 5456},
  {5596, 5397, 5501},
  {5458, 5596, 5520},
  {5397, 6217, 6471},
  {5502, 5457, 5431},
  {5502, 5431, 7585},
  {5504, 5523, 5482},
  {5404, 7552, 5505},
  {5482, 5523, 5525},
  {5482, 5525, 6209},
  {5483, 5464, 5526},
  {5525, 5527, 5506},
  {5529, 5530, 5504},
  {5507, 5528, 5439},
  {5438, 5505, 5529},
  {5466, 5557, 5507},
  {5468, 5532, 5508},
  {5468, 5379, 5607},
  {5468, 5607, 5532},
  {5379, 5535, 5607},
  {5485, 5487, 5486},
  {6215, 6949, 6948},
  {5485, 5488, 5487},
  {5854, 5489, 5419},
  {5511, 5510, 5537},
  {5640, 6819, 5565},
  {5537, 5510, 5426},
  {5426, 5449, 6759},
  {6216, 5542, 5491},
  {5449, 5492, 5544},
  {5477, 5515, 5591},
  {5515, 5491, 5571},
  {5492, 5453, 5544},
  {5590, 5544, 5453},
  {5497, 5517, 5428},
  {5517, 5497, 5516},
  {5496, 5453, 5575},
  {5575, 5453, 5500},
  {5458, 5520, 5500},
  {5521, 5596, 5501},
  {5501, 5397, 5521},
  {6471, 5521, 5397},
  {5522, 5546, 7585},
  {5368, 5522, 7585},
  {7585, 5431, 5368},
  {7550, 7551, 7549},
  {5528, 5526, 5464},
  {5465, 5528, 5464},
  {5504, 5553, 5523},
  {5525, 5554, 5527},
  {5504, 5530, 5553},
  {5506, 5527, 5554},
  {5506, 5554, 5531},
  {5556, 5531, 5555},
  {5554, 5555, 5531},
  {5507, 5557, 5601},
  {5508, 5532, 5533},
  {5534, 5557, 5469},
  {5381, 5531, 5421},
  {5533, 5559, 5484},
  {5484, 5559, 5419},
  {5509, 5534, 5469},
  {5419, 5560, 5558},
  {5419, 5558, 5583},
  {5419, 5559, 5560},
  {5536, 5509, 5510},
  {5536, 5534, 5509},
  {5475, 5421, 5562},
  {5510, 5511, 5561},
  {5475, 5562, 5512},
  {6819, 5490, 5565},
  {5854, 5538, 5514},
  {5512, 5617, 5513},
  {5513, 5539, 5540},
  {5565, 5490, 5540},
  {5490, 6831, 5540},
  {5541, 7147, 5616},
  {5541, 5616, 7296},
  {6759, 5449, 5569},
  {5542, 6216, 5541},
  {5542, 5571, 5491},
  {5453, 5496, 5622},
  {5518, 5517, 5594},
  {5366, 5576, 5545},
  {5519, 5545, 5627},
  {5521, 6471, 5596},
  {5627, 5368, 5456},
  {5546, 5522, 5547},
  {5522, 5368, 6471},
  {5550, 5503, 5526},
  {5528, 5551, 5549},
  {5549, 5526, 5528},
  {5549, 5550, 5526},
  {5523, 5553, 5525},
  {5554, 5525, 5553},
  {5552, 5551, 5528},
  {5505, 5628, 5529},
  {5552, 5528, 5581},
  {5530, 5629, 5553},
  {5530, 5529, 5629},
  {5531, 5556, 5421},
  {5419, 5583, 5853},
  {5561, 5534, 5536},
  {5561, 5536, 5510},
  {5561, 5511, 5563},
  {5643, 5512, 5562},
  {5511, 5537, 5563},
  {6759, 5563, 5537},
  {5854, 5615, 5538},
  {5537, 5426, 6759},
  {5512, 5643, 5617},
  {5538, 5585, 5514},
  {5566, 5514, 5585},
  {5538, 5615, 5585},
  {5567, 6759, 5569},
  {5539, 5513, 5617},
  {5568, 7297, 5616},
  {5541, 7296, 5542},
  {7731, 5573, 7732},
  {7736, 5572, 6519},
  {5570, 5654, 7299},
  {5589, 5542, 7296},
  {5571, 5621, 5515},
  {7732, 5573, 7735},
  {7296, 7299, 5857},
  {5591, 5515, 5621},
  {7735, 5573, 5593},
  {5517, 5516, 5574},
  {5516, 5494, 5591},
  {5574, 5516, 5591},
  {5575, 5622, 5496},
  {5576, 5595, 5545},
  {5518, 5594, 5576},
  {6471, 5577, 5596},
  {5597, 5549, 5551},
  {5548, 5550, 5579},
  {5550, 5549, 5579},
  {7552, 5580, 5505},
  {5628, 5505, 5580},
  {5581, 5551, 5552},
  {5581, 5630, 5551},
  {5529, 5628, 5629},
  {5554, 5553, 5629},
  {5601, 5581, 5528},
  {5528, 5507, 5601},
  {5556, 5555, 5606},
  {5556, 6220, 7693},
  {5561, 5557, 5534},
  {5556, 7693, 5421},
  {5558, 5560, 5533},
  {5559, 5533, 5560},
  {5558, 5533, 5582},
  {5558, 5532, 5583},
  {5535, 5853, 5607},
  {5643, 5562, 5421},
  {6759, 5561, 5563},
  {5854, 5584, 5642},
  {5854, 5642, 5614},
  {5615, 5854, 5614},
  {5615, 5614, 5644},
  {5565, 5618, 5640},
  {5564, 6218, 6219},
  {7148, 5585, 7147},
  {5585, 5616, 7147},
  {6219, 7212, 5619},
  {5539, 5620, 5540},
  {5540, 5620, 5618},
  {5540, 5618, 5565},
  {7298, 5568, 5618},
  {7298, 5618, 5674},
  {5543, 5674, 5570},
  {5619, 7212, 5449},
  {7731, 7732, 7414},
  {5674, 5587, 5570},
  {7055, 5588, 7056},
  {5587, 5654, 5570},
  {5542, 5621, 5571},
  {5588, 7055, 7056},
  {5621, 5542, 5589},
  {5590, 5679, 5449},
  {5449, 5544, 5590},
  {5590, 5453, 5652},
  {5453, 5653, 5652},
  {7299, 5654, 5857},
  {5589, 7296, 5857},
  {7735, 5593, 5680},
  {5657, 5517, 5857},
  {5517, 5574, 5684},
  {5517, 5684, 5857},
  {5574, 5592, 5684},
  {5624, 5517, 5657},
  {5574, 5591, 5592},
  {5594, 5517, 5624},
  {5575, 5500, 5660},
  {5576, 5594, 5595},
  {5500, 5520, 5690},
  {5500, 5690, 5731},
  {5577, 5368, 5627},
  {5577, 6471, 5368},
  {5663, 5548, 5598},
  {5549, 5597, 5579},
  {5579, 5598, 5548},
  {5597, 5602, 5579},
  {5579, 5602, 5599},
  {5579, 5599, 5598},
  {5633, 5597, 5630},
  {5597, 5633, 5602},
  {5602, 5603, 5600},
  {5602, 5600, 5599},
  {5599, 5600, 5598},
  {5602, 5604, 5603},
  {5600, 5603, 5604},
  {5554, 5632, 5555},
  {5555, 5635, 5606},
  {5634, 5605, 5665},
  {7670, 7351, 7669},
  {5608, 5605, 5611},
  {5605, 5608, 5665},
  {5609, 5665, 5608},
  {5605, 5634, 5611},
  {5607, 5610, 5532},
  {5583, 5532, 5610},
  {5611, 5634, 5612},
  {5421, 7693, 5636},
  {5853, 5610, 5607},
  {5610, 5853, 5583},
  {5611, 5700, 5608},
  {5612, 5613, 5611},
  {5643, 5421, 5636},
  {5584, 5641, 5642},
  {5561, 6759, 5667},
  {5647, 5667, 6759},
  {5640, 5618, 5646},
  {5615, 5616, 5585},
  {5564, 6219, 5619},
  {5568, 5616, 5618},
  {5674, 5654, 5587},
  {5619, 5449, 5679},
  {5680, 6306, 7735},
  {5679, 5590, 5651},
  {5590, 5652, 5651},
  {5589, 5857, 5684},
  {5589, 5684, 5710},
  {5621, 5589, 5710},
  {5653, 5453, 5622},
  {5653, 5622, 5685},
  {5654, 5683, 5857},
  {5592, 5591, 5621},
  {5680, 5593, 5623},
  {5680, 5623, 5681},
  {5545, 5625, 5626},
  {5545, 5595, 5662},
  {5545, 5662, 5625},
  {5595, 5594, 5662},
  {5500, 5731, 5660},
  {5627, 5545, 5626},
  {5520, 5596, 5690},
  {5630, 5581, 5601},
  {5630, 5601, 5633},
  {5598, 5600, 5604},
  {5598, 5604, 5631},
  {5629, 5632, 5554},
  {5604, 5664, 5631},
  {5602, 7726, 5604},
  {6378, 5557, 5666},
  {7726, 5668, 5604},
  {5604, 5668, 5634},
  {5604, 5634, 5664},
  {5664, 5634, 5665},
  {5555, 5665, 5635},
  {5666, 5557, 5667},
  {5667, 5557, 5561},
  {5668, 5613, 5634},
  {5612, 5634, 5613},
  {5608, 5669, 7693},
  {7693, 5669, 5636},
  {5668, 5637, 5613},
  {5668, 5638, 5637},
  {5700, 5669, 5608},
  {5702, 5700, 5611},
  {5643, 5636, 5639},
  {5637, 5648, 5613},
  {5637, 5638, 5648},
  {7523, 6221, 6846},
  {5667, 5645, 5699},
  {5702, 5611, 5613},
  {5647, 5645, 5667},
  {5613, 5649, 5702},
  {5640, 5646, 5642},
  {5649, 5613, 5648},
  {5643, 5672, 5617},
  {5619, 6830, 5564},
  {5675, 6830, 5619},
  {7733, 7414, 7732},
  {5620, 5868, 5618},
  {5679, 5675, 5619},
  {5650, 5620, 6306},
  {5678, 5620, 5650},
  {6306, 5680, 5650},
  {5654, 5650, 5680},
  {5650, 5654, 5678},
  {5674, 5678, 5654},
  {5586, 6987, 7734},
  {5680, 5681, 5654},
  {7734, 6987, 7339},
  {5621, 5710, 5592},
  {5681, 5623, 5714},
  {5681, 5714, 5682},
  {5655, 5656, 5658},
  {5623, 5659, 5714},
  {5624, 5657, 5714},
  {5658, 5656, 5655},
  {5715, 5593, 6580},
  {5659, 5593, 5715},
  {5593, 5659, 5623},
  {5625, 5662, 5626},
  {5690, 5596, 5577},
  {5629, 5665, 5632},
  {6425, 5696, 7727},
  {5698, 5638, 5668},
  {5636, 5669, 7523},
  {5648, 5638, 5698},
  {6221, 7523, 5700},
  {5698, 5701, 5648},
  {5721, 5699, 5645},
  {5648, 5701, 5670},
  {5644, 5642, 5646},
  {5646, 5618, 5644},
  {5616, 5644, 5618},
  {5615, 5644, 5616},
  {5670, 5645, 5647},
  {5648, 5670, 6624},
  {5648, 5704, 5649},
  {6830, 5675, 6622},
  {5648, 6623, 5671},
  {7414, 7733, 5673},
  {6987, 5586, 5676},
  {5620, 5678, 5677},
  {5678, 5674, 5677},
  {5651, 5652, 5679},
  {5653, 5679, 5652},
  {5685, 5725, 5653},
  {5681, 5682, 5654},
  {5593, 6986, 5655},
  {5654, 5682, 5727},
  {5654, 5727, 5683},
  {6986, 5686, 5655},
  {5682, 5714, 5711},
  {5686, 6580, 5655},
  {5738, 5714, 5657},
  {5655, 6580, 5593},
  {5624, 5714, 5687},
  {5660, 5685, 5575},
  {5622, 5575, 5685},
  {5594, 5624, 5662},
  {5624, 5687, 5662},
  {5688, 5689, 6580},
  {6580, 5689, 5860},
  {5689, 5745, 5860},
  {5690, 5577, 6505},
  {5577, 5627, 5744},
  {5629, 5628, 5855},
  {5598, 5631, 5663},
  {5629, 5663, 5665},
  {5631, 5664, 5663},
  {5663, 5664, 5665},
  {5632, 5665, 5555},
  {5693, 5692, 6378},
  {5694, 5695, 6378},
  {5693, 6378, 5695},
  {5697, 5694, 5666},
  {5697, 5666, 5667},
  {5694, 6378, 5666},
  {5668, 5720, 5698},
  {5667, 5698, 5720},
  {5667, 5699, 5698},
  {5700, 7523, 5669},
  {5698, 5721, 5701},
  {5703, 6501, 5700},
  {5644, 5614, 5642},
  {5721, 5645, 5701},
  {5670, 5701, 5645},
  {7207, 5746, 5643},
  {5705, 5643, 5746},
  {5649, 5704, 5736},
  {5643, 5705, 5672},
  {5648, 5671, 5704},
  {5673, 7733, 7415},
  {5705, 7415, 7733},
  {5706, 5673, 7415},
  {5671, 5736, 5704},
  {7414, 5673, 5706},
  {5675, 5707, 6622},
  {5708, 6623, 6806},
  {6623, 5708, 5709},
  {5677, 5674, 5868},
  {5675, 5679, 5707},
  {5653, 5707, 5679},
  {5707, 7168, 5708},
  {5707, 5653, 7168},
  {7034, 5725, 5685},
  {5712, 5686, 6986},
  {5683, 5727, 5738},
  {5869, 5711, 5714},
  {5714, 5738, 5869},
  {5712, 5688, 5686},
  {5712, 5713, 5688},
  {5739, 5685, 5660},
  {5728, 5739, 5660},
  {6580, 5742, 5715},
  {5659, 5662, 5714},
  {5714, 5662, 5687},
  {5756, 5732, 5626},
  {5728, 5660, 5731},
  {5626, 5662, 5756},
  {6753, 5731, 5717},
  {5716, 5689, 5688},
  {5717, 5731, 5718},
  {5689, 5716, 5745},
  {5718, 5690, 6505},
  {5718, 6505, 5717},
  {5717, 6505, 6753},
  {5716, 5733, 5745},
  {5627, 5864, 5734},
  {5744, 5719, 5577},
  {5744, 5627, 5734},
  {5691, 5577, 5719},
  {5855, 5663, 5629},
  {5694, 5697, 5720},
  {5694, 5720, 5695},
  {7725, 5720, 5668},
  {6425, 7727, 5696},
  {5667, 5720, 5697},
  {5699, 5721, 5698},
  {5702, 5703, 5700},
  {5702, 5649, 5747},
  {5702, 5746, 7207},
  {5649, 5736, 5735},
  {5649, 5735, 5747},
  {7415, 5705, 5746},
  {5736, 5671, 6224},
  {5723, 6684, 5724},
  {7168, 5653, 5724},
  {5653, 5761, 5724},
  {5653, 5725, 5760},
  {5653, 5760, 5761},
  {6988, 5749, 5726},
  {6986, 5726, 5712},
  {5682, 5711, 5727},
  {5711, 5869, 5727},
  {7381, 5685, 5739},
  {5728, 5731, 5729},
  {5728, 5729, 5739},
  {5730, 5715, 5743},
  {5715, 5730, 5659},
  {5662, 5659, 5730},
  {5743, 5756, 5662},
  {5662, 5730, 5743},
  {5718, 5731, 5690},
  {5720, 5693, 5695},
  {5693, 5720, 7725},
  {7413, 7414, 5722},
  {5706, 5722, 7414},
  {5671, 6623, 6224},
  {7412, 5748, 6988},
  {5737, 7168, 5724},
  {5723, 5724, 6684},
  {5709, 6224, 6623},
  {6988, 5748, 5749},
  {5761, 5737, 5724},
  {5760, 5725, 7382},
  {5725, 7034, 7382},
  {5726, 5713, 5712},
  {5727, 5869, 5738},
  {5688, 5713, 5716},
  {5729, 5752, 5739},
  {5729, 5731, 5752},
  {5858, 7178, 5740},
  {6580, 7179, 5742},
  {5715, 5742, 5743},
  {5716, 5752, 5731},
  {5741, 5732, 7179},
  {5754, 7179, 5732},
  {5732, 5756, 5754},
  {5733, 5716, 5744},
  {5744, 5734, 5733},
  {5734, 5864, 5745},
  {5734, 5745, 5733},
  {5746, 5702, 5758},
  {5758, 5702, 5747},
  {5735, 5736, 5748},
  {5735, 5748, 5747},
  {5736, 5759, 5748},
  {5736, 6224, 5759},
  {5726, 5749, 5751},
  {5713, 5726, 5751},
  {5713, 5751, 5750},
  {5752, 7381, 5739},
  {5750, 6225, 5753},
  {5750, 5753, 5716},
  {5716, 5713, 5750},
  {5752, 5716, 5753},
  {5758, 7412, 5746},
  {5747, 5748, 5758},
  {5758, 5748, 7412},
  {5749, 5748, 5763},
  {5763, 5751, 5749},
  {5750, 5751, 5760},
  {5759, 5761, 5748},
  {6224, 5761, 5759},
  {5761, 5763, 5748},
  {5761, 5760, 5763},
  {5760, 5751, 5763},
  {   2,   12,    3},
  {   2, 7438,   12},
  {7438,    2,    1},
  {7438,   34,   12},
  {  34, 7439, 6485},
  {  12,   34,   19},
  {5764, 5765, 5767},
  {  34, 6485,   32},
  {7273, 5875, 5768},
  {7273, 5769,   66},
  {7273, 5768, 5769},
  {5768, 5770,   13},
  {5768,   38, 5769},
  {5768,   13,   38},
  {7217,   86, 6485},
  {7217,   38,   86},
  {   1, 7512, 7438},
  {  38,   13,   37},
  {  29,   27,   17},
  {5771, 5879,   92},
  {6226, 6227,  116},
  {6912, 7349, 7350},
  {5773,  141, 6229},
  {5771,   72,  142},
  {  98,   99,  173},
  {5775,  187,  182},
  {5775,  132,  187},
  {5775,  182,  211},
  {5776,  216, 5778},
  {5777,  185, 5776},
  {5776, 5778, 5777},
  {5779,  215,  214},
  {5779,  214, 5777},
  {5776,  256,  216},
  { 214,  213,  340},
  { 214,  340,  298},
  { 340,  213,  257},
  {5870,  168,   94},
  {5870, 5780,  168},
  {5780,  229,  191},
  {  94,  190, 5870},
  { 232,  276,  170},
  { 313,  268,  314},
  { 268,  227,  314},
  { 314,  227,  315},
  {5781,  441, 5782},
  { 318,  317, 5781},
  {5781, 5782,  318},
  { 318,  449,  360},
  { 318, 5782,  449},
  {5784,  405,  404},
  {5784,  540,  405},
  {5783,  667,  535},
  { 443,  535,  488},
  {5783,  443, 5785},
  {6236, 6232, 5873},
  {5784, 5786,  540},
  {6270, 5787, 6233},
  {6269, 5788, 6234},
  {5786,  542,  540},
  {5786, 6958,  542},
  {7263,  494,  703},
  {5785,  443, 5789},
  {5789,  443,  627},
  {7341, 7342, 6234},
  { 535,  667,  624},
  { 540,  542, 5921},
  {5791,  619, 5790},
  {5790,  660, 5791},
  {5790,  579,  660},
  {5791,  580,  619},
  {5792,  582,  583},
  {5792,  583, 5793},
  {5792,  665,  582},
  {6239, 6242, 6243},
  { 439, 6238,  393},
  {6238, 6241,  393},
  { 583, 5923, 5793},
  {6244, 5926, 5928},
  { 914,  760,  761},
  { 914, 1021, 5796},
  {5796,  915,  762},
  {5797, 5798,  877},
  {7648, 7646, 7647},
  {5798, 1023, 1025},
  {1231, 6587, 5956},
  {5799, 1136, 5800},
  {5799, 5800, 7141},
  {1274, 1180, 5799},
  {5799, 7141, 1365},
  {5799, 1054, 1136},
  {5801, 1386, 1344},
  {5802, 1564, 5978},
  {1344, 1386, 1385},
  {1386, 5801, 5977},
  {5871, 1376, 1604},
  {5871, 1764, 5805},
  {1763, 6245, 5805},
  {6245, 1649, 5805},
  {5805, 1764, 1763},
  {1763, 5806, 6245},
  {1763, 5807, 5806},
  {6245, 5806, 1765},
  {5808, 1824, 7434},
  {1539, 1585, 5810},
  {5810, 5811, 1538},
  {5810, 1538, 1539},
  {6651, 1539, 1538},
  {5812, 1889, 1741},
  {5812, 1884, 1889},
  {1741, 1889, 1636},
  {6246, 6937, 2015},
  {2087, 6803, 7213},
  {2156, 2212, 2157},
  {2212, 2213, 2157},
  {2398, 2244, 6678},
  {5815, 2280, 2664},
  {5815, 2664, 2768},
  {5816, 2826, 2722},
  {5816, 5815, 2771},
  {5816, 2771, 2826},
  {5815, 2450, 2506},
  {7583, 2744, 7581},
  {7383, 7384, 6065},
  {6249, 6799, 6976},
  {5818, 6798, 6799},
  {7384, 7674, 2795},
  {2896, 2857, 7015},
  {6798, 5818, 6321},
  {7384, 2795, 6065},
  {5821, 2554, 2607},
  {5821, 5820, 2554},
  {5820, 2757, 5822},
  {5822, 5823, 2712},
  {7427, 2908, 5825},
  {7427, 5825, 6061},
  {7427, 2909, 2908},
  {5826, 3001, 3050},
  {5826, 3050, 2951},
  {5822, 2712, 2488},
  {2530, 2789, 2839},
  {2388, 2508, 2724},
  {6068, 2949, 2950},
  {6068, 2907, 2949},
  {5827, 2766, 2830},
  {2968, 2967, 3079},
  {3029, 3259, 3097},
  {3097, 3259, 3260},
  {3029, 3099, 3259},
  {6577, 6576, 3536},
  {5828, 3620, 3510},
  {3510, 3371, 5828},
  {3510, 3620, 3676},
  {5829, 5872, 3481},
  {5829, 3747, 5872},
  {3481, 5872, 5830},
  {5830, 5872, 3955},
  {5830, 3955, 3910},
  {3955, 5872, 3842},
  {5830, 3910, 5831},
  {3965, 4103, 4015},
  {4103, 3965, 4017},
  {4146, 4184, 5834},
  {5833, 4146, 4272},
  {4103, 4017, 5834},
  {5832, 4105, 5836},
  {5835, 6120, 6410},
  {4103, 5834, 4102},
  {4156, 4280, 4034},
  {4300, 4379, 4378},
  {4300, 5837, 4379},
  {5837, 4300, 4407},
  {5837, 4339, 4379},
  {4444, 4480, 5837},
  {5838, 4391, 5839},
  {5839, 5842, 5841},
  {5839, 4419, 6272},
  {5839, 5841, 5838},
  {6272, 4419, 4451},
  {6517, 6518, 6516},
  {5840, 4452, 4571},
  {5843, 4527, 4342},
  {4342, 4414, 5844},
  {5844, 4487, 7597},
  {5845, 5844, 4414},
  {5845, 6139, 5844},
  {5844, 6139, 4487},
  {6666, 6144, 6138},
  {5845, 4414, 6665},
  {4342, 5844, 5843},
  {5843, 7597, 4527},
  {5846, 4840, 4801},
  {5102, 7392, 5847},
  {5047, 5015, 5014},
  {5047, 5014, 5076},
  {5047, 5050, 5015},
  {5100, 4996, 5101},
  {5321, 5365, 5294},
  {6627, 5434, 5353},
  {6341, 5503, 5852},
  {5849, 5481, 5461},
  {5849, 5850, 5481},
  {6341, 5852, 6252},
  {6252, 5852, 6262},
  {5851, 6212, 6208},
  {5503, 5578, 5852},
  {5852, 5578, 6253},
  {5850, 5460, 5481},
  {5853, 5535, 5854},
  {5854, 5419, 5853},
  {5535, 5641, 5854},
  {5535, 5640, 5641},
  {5641, 5584, 5854},
  {5641, 5640, 5642},
  {5503, 5548, 5578},
  {5548, 5524, 7549},
  {5548, 7549, 7551},
  {5855, 5548, 5663},
  {5548, 5856, 5628},
  {5548, 5580, 5524},
  {5548, 5628, 5580},
  {5856, 5855, 5628},
  {5582, 5533, 5532},
  {5582, 5532, 5558},
  {5630, 5597, 5551},
  {5857, 5683, 5657},
  {5592, 5710, 5684},
  {5858, 5859, 7178},
  {6254, 6580, 5860},
  {6254, 5860, 5861},
  {5859, 6886, 7178},
  {5859, 5661, 6886},
  {6580, 5686, 5688},
  {6255, 5863, 5864},
  {6255, 5864, 5862},
  {6255, 6508, 5863},
  {5626, 5864, 5627},
  {5863, 5860, 5745},
  {5865, 5863, 5745},
  {5867, 6222, 6223},
  {5867, 6223, 6222},
  {5868, 5620, 5677},
  {5716, 5691, 5719},
  {5755, 5756, 5743},
  {5755, 5754, 5756},
  {5755, 5743, 5742},
  {5754, 5755, 5742},
  {5752, 5762, 7381},
  {5752, 5753, 5762},
  {5754, 5742, 7179},
  {5768, 5875, 5770},
  {7272,   33, 7271},
  {  89,   88,   53},
  {6228, 5891, 6230},
  {5780, 5870,  229},
  {5778, 5895, 5779},
  {5778, 5779, 5777},
  { 232, 6763,  319},
  {6269, 7074, 5788},
  { 534,  488,  535},
  {5783,  535,  443},
  { 579, 5790,  532},
  { 667, 6536,  624},
  {5788, 7074, 5929},
  {7649, 1020, 1023},
  {7649, 1023, 5798},
  {5799, 1365, 1274},
  {7417, 7416, 5804},
  {5805, 1649, 7553},
  {5805, 1415, 5871},
  {5811, 1585, 1752},
  {5813, 1884, 1886},
  {5813, 1889, 1884},
  {7583, 7581, 6046},
  {5817, 2744, 7583},
  {6249, 5818, 6799},
  {3481, 5831, 3846},
  {5550, 5548, 5503},
  {5855, 5856, 5548},
  {5868, 5674, 5618},
  {5657, 5683, 5738},
  {5733, 5757, 6507},
  {5757, 5733, 6507},
  {5865, 5866, 5864},
  {5864, 5866, 5745},
  {5865, 5745, 5866},
  {5719, 5744, 5716},
  {7439,   34, 7438},
  {5772, 6231,  162},
  {  98,  173, 5774},
  {5777,  214,  298},
  {6237, 5785, 5789},
  {6423, 6235, 6264},
  {6234, 5788, 7341},
  {5810, 1585, 5811},
  {2744, 6250, 7581},
  {5818, 6248, 6247},
  {5818, 6059, 6248},
  {5818, 6249, 6059},
  {5843, 5844, 7597},
  {6828, 5846, 4801},
  {6254, 5861, 6787},
  {5863, 5865, 5864},
};

SVV_NAMESPACE_BEGIN

svvModel pialsurf( "pialsurf",
                   pialsurf_vertices, pialsurf_nvertices,
                   pialsurf_indices, pialsurf_nindices );

SVV_NAMESPACE_END

#endif /* SVV_PIALSURF_H_ */
/*
 * End of: $Id: pialsurf.h,v 1.1.1.1 2006/12/19 22:59:09 christianh Exp $.
 * 
 */
