/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: teapot.h,v 1.1.1.1 2006/12/19 22:59:31 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_TEAPOT_H_
#  define SVV_TEAPOT_H_
#  include "svvModel.h"

static GLsizei teapot_nvertices = 1976;
static GLsizei teapot_nindices  = 3752;
static GLsizei teapot_nedges    = 15008;

static GLfloat teapot_vertices[][6] =
{
  {-9.624237e-01, -2.545894e-01, -9.447215e-02,  4.995172e-01,  3.381960e-01,  6.086935e-02},
  {-9.667357e-01, -2.557775e-01,  1.871015e-09,  5.096900e-01,  3.223329e-01,  0.000000e+00},
  {-9.480255e-01, -2.559921e-01, -1.889858e-01,  4.976563e-01,  3.223329e-01,  1.225940e-01},
  {-9.517869e-01,  2.410539e-01, -1.897227e-01,  4.894303e-01,  3.540633e-01,  1.208839e-01},
  {-9.705353e-01,  2.409592e-01, -1.065813e-09,  5.012965e-01,  3.540633e-01,  0.000000e+00},
  {-9.249715e-01, -2.550000e-01, -2.817849e-01,  4.763651e-01,  3.381960e-01,  1.781272e-01},
  {-8.924571e-01, -2.563827e-01, -3.711982e-01,  4.630592e-01,  3.223329e-01,  2.361626e-01},
  {-8.960552e-01,  2.412309e-01, -3.726831e-01,  4.553146e-01,  3.540633e-01,  2.328679e-01},
  {-8.518896e-01, -2.553560e-01, -4.572499e-01,  4.319261e-01,  3.381960e-01,  2.853020e-01},
  {-8.029419e-01, -2.566180e-01, -5.379884e-01,  4.081552e-01,  3.223329e-01,  3.384496e-01},
  {-8.062096e-01,  2.413366e-01, -5.401691e-01,  4.011799e-01,  3.540633e-01,  3.337280e-01},
  {-7.468400e-01, -2.555600e-01, -6.139374e-01,  3.684437e-01,  3.381960e-01,  3.801538e-01},
  {-6.834068e-01, -2.567301e-01, -6.834067e-01,  3.352005e-01,  3.223329e-01,  4.271986e-01},
  {-6.861998e-01,  2.413705e-01, -6.861997e-01,  3.292407e-01,  3.540633e-01,  4.212388e-01},
  {-7.337896e-01,  6.755466e-01, -7.203913e-02,  5.001833e-01,  3.593496e-01,  6.093768e-02},
  {-1.635650e-01,  9.859933e-01, -3.261490e-02,  4.989714e-01,  3.646401e-01,  1.228677e-01},
  {-1.667456e-01,  9.859999e-01,  2.949561e-09,  5.110353e-01,  3.646401e-01,  0.000000e+00},
  {-7.048172e-01,  6.761134e-01, -2.147170e-01,  4.770055e-01,  3.593496e-01,  1.783270e-01},
  {-1.539194e-01,  9.860076e-01, -6.401430e-02,  4.642969e-01,  3.646401e-01,  2.366899e-01},
  {-6.487175e-01,  6.767043e-01, -3.481910e-01,  4.325149e-01,  3.593496e-01,  2.856227e-01},
  {-1.384007e-01,  9.860252e-01, -9.273339e-02,  4.092726e-01,  3.646401e-01,  3.392051e-01},
  {-5.685122e-01,  6.770386e-01, -4.673465e-01,  3.689595e-01,  3.593496e-01,  3.805811e-01},
  {-1.177691e-01,  9.860328e-01, -1.177691e-01,  3.361541e-01,  3.646401e-01,  4.281522e-01},
  {-6.139376e-01, -2.555596e-01, -7.468401e-01,  2.881558e-01,  3.381960e-01,  4.604418e-01},
  {-5.379884e-01, -2.566174e-01, -8.029421e-01,  2.464515e-01,  3.223329e-01,  5.001532e-01},
  {-5.401689e-01,  2.413363e-01, -8.062098e-01,  2.417299e-01,  3.540633e-01,  4.931780e-01},
  {-4.572501e-01, -2.553554e-01, -8.518896e-01,  1.933039e-01,  3.381960e-01,  5.239242e-01},
  {-3.711982e-01, -2.563832e-01, -8.924570e-01,  1.441645e-01,  3.223329e-01,  5.550573e-01},
  {-3.726832e-01,  2.412308e-01, -8.960552e-01,  1.408698e-01,  3.540633e-01,  5.473127e-01},
  {-2.817849e-01, -2.549996e-01, -9.249716e-01,  8.612910e-02,  3.381960e-01,  5.683632e-01},
  {-1.889859e-01, -2.559918e-01, -9.480256e-01,  3.059587e-02,  3.223329e-01,  5.896543e-01},
  {-1.897227e-01,  2.410541e-01, -9.517869e-01,  2.888578e-02,  3.540633e-01,  5.814284e-01},
  {-9.447201e-02, -2.545898e-01, -9.624236e-01, -3.112875e-02,  3.381960e-01,  5.915153e-01},
  { 1.871015e-09, -2.557780e-01, -9.667355e-01, -9.199809e-02,  3.223329e-01,  6.016881e-01},
  {-2.131630e-09,  2.409598e-01, -9.705351e-01, -9.199809e-02,  3.540633e-01,  5.932946e-01},
  {-4.673469e-01,  6.770378e-01, -5.685127e-01,  2.885830e-01,  3.593496e-01,  4.609576e-01},
  {-9.273370e-02,  9.860252e-01, -1.384013e-01,  2.472070e-01,  3.646401e-01,  5.012707e-01},
  {-3.481913e-01,  6.767036e-01, -6.487180e-01,  1.936246e-01,  3.593496e-01,  5.245130e-01},
  {-6.401432e-02,  9.860077e-01, -1.539194e-01,  1.446918e-01,  3.646401e-01,  5.562950e-01},
  {-2.147171e-01,  6.761128e-01, -7.048178e-01,  8.632895e-02,  3.593496e-01,  5.690036e-01},
  {-3.261504e-02,  9.859931e-01, -1.635658e-01,  3.086963e-02,  3.646401e-01,  5.909694e-01},
  {-7.203899e-02,  6.755471e-01, -7.337891e-01, -3.106041e-02,  3.593496e-01,  5.921814e-01},
  {-2.359648e-09,  9.860000e-01, -1.667454e-01, -9.199809e-02,  3.646401e-01,  6.030334e-01},
  { 4.705059e-01,  8.811868e-01,  4.619519e-02,  5.148087e-01,  3.593496e-01,  6.244276e-02},
  { 6.530253e-01,  7.460674e-01,  1.301588e-01,  5.183845e-01,  3.540633e-01,  1.269038e-01},
  { 6.661862e-01,  7.457855e-01,  4.803232e-09,  5.308436e-01,  3.540633e-01,  0.000000e+00},
  { 4.516670e-01,  8.815128e-01,  1.375942e-01,  4.910592e-01,  3.593496e-01,  1.827314e-01},
  { 6.143314e-01,  7.465400e-01,  2.554898e-01,  4.825711e-01,  3.540633e-01,  2.444650e-01},
  { 4.155132e-01,  8.818207e-01,  2.230269e-01,  4.454684e-01,  3.593496e-01,  2.926770e-01},
  { 5.524124e-01,  7.468937e-01,  3.701221e-01,  4.257374e-01,  3.540633e-01,  3.503484e-01},
  { 3.640563e-01,  8.819852e-01,  2.992746e-01,  3.803443e-01,  3.593496e-01,  3.899807e-01},
  { 4.700978e-01,  7.470048e-01,  4.700978e-01,  3.502169e-01,  3.540633e-01,  4.422150e-01},
  { 8.212314e-01,  5.648713e-01,  8.061921e-02,  5.354165e-01,  3.381960e-01,  6.456371e-02},
  { 8.560477e-01,  4.879174e-01,  1.706430e-01,  5.397744e-01,  3.223329e-01,  1.313507e-01},
  { 8.730819e-01,  4.875737e-01,  1.032678e-08,  5.526677e-01,  3.223329e-01,  0.000000e+00},
  { 7.889397e-01,  5.655186e-01,  2.403394e-01,  5.108590e-01,  3.381960e-01,  1.889378e-01},
  { 8.056696e-01,  4.884834e-01,  3.350827e-01,  5.027061e-01,  3.223329e-01,  2.530313e-01},
  { 7.262958e-01,  5.661442e-01,  3.898400e-01,  4.637254e-01,  3.381960e-01,  3.026173e-01},
  { 7.247014e-01,  4.889185e-01,  4.855580e-01,  4.438826e-01,  3.223329e-01,  3.626245e-01},
  { 6.365765e-01,  5.664998e-01,  5.233052e-01,  3.963878e-01,  3.381960e-01,  4.032256e-01},
  { 6.167668e-01,  4.890780e-01,  6.167669e-01,  3.657147e-01,  3.223329e-01,  4.577128e-01},
  { 2.992744e-01,  8.819852e-01,  3.640562e-01,  2.979826e-01,  3.593496e-01,  4.723424e-01},
  { 3.701222e-01,  7.468938e-01,  5.524122e-01,  2.583503e-01,  3.540633e-01,  5.177355e-01},
  { 2.230269e-01,  8.818208e-01,  4.155130e-01,  2.006789e-01,  3.593496e-01,  5.374665e-01},
  { 2.554896e-01,  7.465402e-01,  6.143312e-01,  1.524669e-01,  3.540633e-01,  5.745692e-01},
  { 1.375941e-01,  8.815126e-01,  4.516672e-01,  9.073330e-02,  3.593496e-01,  5.830573e-01},
  { 1.301588e-01,  7.460676e-01,  6.530252e-01,  3.490568e-02,  3.540633e-01,  6.103825e-01},
  { 4.619538e-02,  8.811867e-01,  4.705061e-01, -2.955533e-02,  3.593496e-01,  6.068068e-01},
  {-2.881938e-09,  7.457855e-01,  6.661862e-01, -9.199809e-02,  3.540633e-01,  6.228417e-01},
  { 5.233052e-01,  5.664998e-01,  6.365765e-01,  3.112275e-01,  3.381960e-01,  4.883859e-01},
  { 4.855582e-01,  4.889185e-01,  7.247013e-01,  2.706265e-01,  3.223329e-01,  5.358806e-01},
  { 3.898401e-01,  5.661441e-01,  7.262958e-01,  2.106192e-01,  3.381960e-01,  5.557235e-01},
  { 3.350827e-01,  4.884832e-01,  8.056697e-01,  1.610333e-01,  3.223329e-01,  5.947042e-01},
  { 2.403391e-01,  5.655190e-01,  7.889394e-01,  9.693971e-02,  3.381960e-01,  6.028571e-01},
  { 1.706428e-01,  4.879175e-01,  8.560476e-01,  3.935257e-02,  3.223329e-01,  6.317725e-01},
  { 8.061936e-02,  5.648718e-01,  8.212310e-01, -2.743438e-02,  3.381960e-01,  6.274146e-01},
  {-1.408197e-08,  4.875736e-01,  8.730819e-01, -9.199809e-02,  3.223329e-01,  6.446658e-01},
  { 9.447201e-02, -2.545898e-01, -9.624236e-01, -1.528674e-01,  3.381960e-01,  5.915153e-01},
  { 1.889859e-01, -2.559918e-01, -9.480256e-01, -2.145921e-01,  3.223329e-01,  5.896543e-01},
  { 1.897227e-01,  2.410541e-01, -9.517868e-01, -2.128820e-01,  3.540633e-01,  5.814284e-01},
  { 2.817848e-01, -2.549996e-01, -9.249716e-01, -2.701253e-01,  3.381960e-01,  5.683632e-01},
  { 3.711982e-01, -2.563834e-01, -8.924569e-01, -3.281607e-01,  3.223329e-01,  5.550573e-01},
  { 3.726832e-01,  2.412309e-01, -8.960552e-01, -3.248660e-01,  3.540633e-01,  5.473127e-01},
  { 4.572501e-01, -2.553557e-01, -8.518896e-01, -3.773001e-01,  3.381960e-01,  5.239242e-01},
  { 5.379883e-01, -2.566178e-01, -8.029420e-01, -4.304477e-01,  3.223329e-01,  5.001532e-01},
  { 5.401689e-01,  2.413366e-01, -8.062097e-01, -4.257261e-01,  3.540633e-01,  4.931780e-01},
  { 6.139374e-01, -2.555602e-01, -7.468399e-01, -4.721519e-01,  3.381960e-01,  4.604418e-01},
  { 6.834067e-01, -2.567308e-01, -6.834066e-01, -5.191967e-01,  3.223329e-01,  4.271986e-01},
  { 6.861997e-01,  2.413714e-01, -6.861996e-01, -5.132369e-01,  3.540633e-01,  4.212388e-01},
  { 7.203898e-02,  6.755471e-01, -7.337891e-01, -1.529358e-01,  3.593496e-01,  5.921814e-01},
  { 3.261501e-02,  9.859931e-01, -1.635657e-01, -2.148658e-01,  3.646401e-01,  5.909694e-01},
  { 2.147171e-01,  6.761129e-01, -7.048176e-01, -2.703251e-01,  3.593496e-01,  5.690036e-01},
  { 6.401420e-02,  9.860077e-01, -1.539191e-01, -3.286880e-01,  3.646401e-01,  5.562950e-01},
  { 3.481912e-01,  6.767039e-01, -6.487178e-01, -3.776207e-01,  3.593496e-01,  5.245130e-01},
  { 9.273347e-02,  9.860252e-01, -1.384010e-01, -4.312032e-01,  3.646401e-01,  5.012707e-01},
  { 4.673461e-01,  6.770392e-01, -5.685118e-01, -4.725792e-01,  3.593496e-01,  4.609576e-01},
  { 1.177684e-01,  9.860331e-01, -1.177683e-01, -5.201504e-01,  3.646401e-01,  4.281522e-01},
  { 7.468399e-01, -2.555604e-01, -6.139374e-01, -5.524399e-01,  3.381960e-01,  3.801538e-01},
  { 8.029420e-01, -2.566177e-01, -5.379883e-01, -5.921513e-01,  3.223329e-01,  3.384496e-01},
  { 8.062097e-01,  2.413365e-01, -5.401691e-01, -5.851761e-01,  3.540633e-01,  3.337280e-01},
  { 8.518896e-01, -2.553556e-01, -4.572501e-01, -6.159223e-01,  3.381960e-01,  2.853020e-01},
  { 8.924571e-01, -2.563831e-01, -3.711982e-01, -6.470554e-01,  3.223329e-01,  2.361626e-01},
  { 8.960552e-01,  2.412309e-01, -3.726832e-01, -6.393108e-01,  3.540633e-01,  2.328679e-01},
  { 9.249716e-01, -2.549996e-01, -2.817849e-01, -6.603613e-01,  3.381960e-01,  1.781272e-01},
  { 9.480256e-01, -2.559918e-01, -1.889859e-01, -6.816524e-01,  3.223329e-01,  1.225940e-01},
  { 9.517869e-01,  2.410541e-01, -1.897227e-01, -6.734265e-01,  3.540633e-01,  1.208839e-01},
  { 9.624236e-01, -2.545898e-01, -9.447201e-02, -6.835134e-01,  3.381960e-01,  6.086935e-02},
  { 9.667355e-01, -2.557780e-01, -1.871015e-09, -6.936862e-01,  3.223329e-01,  0.000000e+00},
  { 9.705353e-01,  2.409591e-01, -3.197443e-09, -6.852927e-01,  3.540633e-01,  0.000000e+00},
  { 5.685116e-01,  6.770394e-01, -4.673460e-01, -5.529557e-01,  3.593496e-01,  3.805811e-01},
  { 1.384008e-01,  9.860252e-01, -9.273335e-02, -5.932688e-01,  3.646401e-01,  3.392051e-01},
  { 6.487178e-01,  6.767039e-01, -3.481913e-01, -6.165111e-01,  3.593496e-01,  2.856227e-01},
  { 1.539195e-01,  9.860076e-01, -6.401435e-02, -6.482931e-01,  3.646401e-01,  2.366899e-01},
  { 7.048177e-01,  6.761129e-01, -2.147171e-01, -6.610017e-01,  3.593496e-01,  1.783270e-01},
  { 1.635659e-01,  9.859931e-01, -3.261513e-02, -6.829675e-01,  3.646401e-01,  1.228677e-01},
  { 7.337902e-01,  6.755461e-01, -7.203891e-02, -6.841795e-01,  3.593496e-01,  6.093768e-02},
  { 1.667469e-01,  9.859998e-01,  5.899127e-10, -6.950314e-01,  3.646401e-01,  0.000000e+00},
  {-4.619539e-02,  8.811867e-01,  4.705061e-01, -1.544409e-01,  3.593496e-01,  6.068068e-01},
  {-1.301588e-01,  7.460675e-01,  6.530252e-01, -2.189019e-01,  3.540633e-01,  6.103825e-01},
  {-1.375941e-01,  8.815126e-01,  4.516673e-01, -2.747295e-01,  3.593496e-01,  5.830573e-01},
  {-2.554896e-01,  7.465401e-01,  6.143312e-01, -3.364631e-01,  3.540633e-01,  5.745692e-01},
  {-2.230269e-01,  8.818208e-01,  4.155130e-01, -3.846751e-01,  3.593496e-01,  5.374665e-01},
  {-3.701222e-01,  7.468938e-01,  5.524122e-01, -4.423465e-01,  3.540633e-01,  5.177355e-01},
  {-2.992745e-01,  8.819852e-01,  3.640563e-01, -4.819788e-01,  3.593496e-01,  4.723424e-01},
  {-4.700979e-01,  7.470047e-01,  4.700978e-01, -5.342131e-01,  3.540633e-01,  4.422150e-01},
  {-8.061937e-02,  5.648718e-01,  8.212311e-01, -1.565618e-01,  3.381960e-01,  6.274146e-01},
  {-1.706429e-01,  4.879175e-01,  8.560476e-01, -2.233487e-01,  3.223329e-01,  6.317725e-01},
  {-2.403391e-01,  5.655190e-01,  7.889394e-01, -2.809359e-01,  3.381960e-01,  6.028571e-01},
  {-3.350827e-01,  4.884832e-01,  8.056698e-01, -3.450294e-01,  3.223329e-01,  5.947042e-01},
  {-3.898401e-01,  5.661440e-01,  7.262959e-01, -3.946154e-01,  3.381960e-01,  5.557235e-01},
  {-4.855582e-01,  4.889183e-01,  7.247014e-01, -4.546226e-01,  3.223329e-01,  5.358806e-01},
  {-5.233052e-01,  5.664997e-01,  6.365767e-01, -4.952237e-01,  3.381960e-01,  4.883859e-01},
  {-6.167669e-01,  4.890780e-01,  6.167669e-01, -5.497109e-01,  3.223329e-01,  4.577128e-01},
  {-3.640567e-01,  8.819849e-01,  2.992747e-01, -5.643405e-01,  3.593496e-01,  3.899807e-01},
  {-5.524126e-01,  7.468935e-01,  3.701223e-01, -6.097335e-01,  3.540633e-01,  3.503484e-01},
  {-4.155134e-01,  8.818206e-01,  2.230272e-01, -6.294646e-01,  3.593496e-01,  2.926770e-01},
  {-6.143314e-01,  7.465400e-01,  2.554899e-01, -6.665673e-01,  3.540633e-01,  2.444650e-01},
  {-4.516672e-01,  8.815126e-01,  1.375941e-01, -6.750554e-01,  3.593496e-01,  1.827314e-01},
  {-6.530250e-01,  7.460678e-01,  1.301587e-01, -7.023806e-01,  3.540633e-01,  1.269038e-01},
  {-4.705056e-01,  8.811870e-01,  4.619522e-02, -6.988049e-01,  3.593496e-01,  6.244276e-02},
  {-6.661855e-01,  7.457861e-01,  9.606462e-10, -7.148398e-01,  3.540633e-01,  0.000000e+00},
  {-6.365766e-01,  5.665001e-01,  5.233049e-01, -5.803840e-01,  3.381960e-01,  4.032256e-01},
  {-7.247012e-01,  4.889188e-01,  4.855579e-01, -6.278787e-01,  3.223329e-01,  3.626245e-01},
  {-7.262955e-01,  5.661445e-01,  3.898402e-01, -6.477215e-01,  3.381960e-01,  3.026173e-01},
  {-8.056695e-01,  4.884835e-01,  3.350827e-01, -6.867023e-01,  3.223329e-01,  2.530313e-01},
  {-7.889394e-01,  5.655191e-01,  2.403391e-01, -6.948552e-01,  3.381960e-01,  1.889378e-01},
  {-8.560476e-01,  4.879176e-01,  1.706428e-01, -7.237706e-01,  3.223329e-01,  1.313507e-01},
  {-8.212311e-01,  5.648718e-01,  8.061937e-02, -7.194127e-01,  3.381960e-01,  6.456371e-02},
  {-8.730819e-01,  4.875735e-01, -9.387978e-09, -7.366639e-01,  3.223329e-01,  0.000000e+00},
  { 9.624236e-01, -2.545898e-01,  9.447201e-02, -6.835134e-01,  3.381960e-01, -6.086935e-02},
  { 9.480256e-01, -2.559918e-01,  1.889859e-01, -6.816524e-01,  3.223329e-01, -1.225940e-01},
  { 9.517869e-01,  2.410541e-01,  1.897227e-01, -6.734265e-01,  3.540633e-01, -1.208839e-01},
  { 9.249716e-01, -2.549996e-01,  2.817848e-01, -6.603613e-01,  3.381960e-01, -1.781272e-01},
  { 8.924571e-01, -2.563831e-01,  3.711982e-01, -6.470554e-01,  3.223329e-01, -2.361626e-01},
  { 8.960552e-01,  2.412309e-01,  3.726832e-01, -6.393108e-01,  3.540633e-01, -2.328679e-01},
  { 8.518896e-01, -2.553556e-01,  4.572501e-01, -6.159223e-01,  3.381960e-01, -2.853020e-01},
  { 8.029420e-01, -2.566177e-01,  5.379883e-01, -5.921513e-01,  3.223329e-01, -3.384496e-01},
  { 8.062097e-01,  2.413364e-01,  5.401691e-01, -5.851761e-01,  3.540633e-01, -3.337280e-01},
  { 7.468399e-01, -2.555604e-01,  6.139374e-01, -5.524399e-01,  3.381960e-01, -3.801538e-01},
  { 6.834066e-01, -2.567307e-01,  6.834067e-01, -5.191967e-01,  3.223329e-01, -4.271986e-01},
  { 6.861996e-01,  2.413714e-01,  6.861996e-01, -5.132369e-01,  3.540633e-01, -4.212388e-01},
  { 7.337902e-01,  6.755461e-01,  7.203891e-02, -6.841795e-01,  3.593496e-01, -6.093768e-02},
  { 1.635659e-01,  9.859931e-01,  3.261511e-02, -6.829675e-01,  3.646401e-01, -1.228677e-01},
  { 7.048177e-01,  6.761129e-01,  2.147171e-01, -6.610017e-01,  3.593496e-01, -1.783270e-01},
  { 1.539195e-01,  9.860076e-01,  6.401438e-02, -6.482931e-01,  3.646401e-01, -2.366899e-01},
  { 6.487178e-01,  6.767038e-01,  3.481913e-01, -6.165111e-01,  3.593496e-01, -2.856227e-01},
  { 1.384008e-01,  9.860252e-01,  9.273337e-02, -5.932688e-01,  3.646401e-01, -3.392051e-01},
  { 5.685116e-01,  6.770394e-01,  4.673460e-01, -5.529557e-01,  3.593496e-01, -3.805811e-01},
  { 1.177683e-01,  9.860331e-01,  1.177683e-01, -5.201504e-01,  3.646401e-01, -4.281522e-01},
  { 6.139374e-01, -2.555602e-01,  7.468399e-01, -4.721519e-01,  3.381960e-01, -4.604418e-01},
  { 5.379883e-01, -2.566178e-01,  8.029420e-01, -4.304477e-01,  3.223329e-01, -5.001532e-01},
  { 5.401689e-01,  2.413366e-01,  8.062097e-01, -4.257261e-01,  3.540633e-01, -4.931780e-01},
  { 4.572501e-01, -2.553557e-01,  8.518896e-01, -3.773001e-01,  3.381960e-01, -5.239242e-01},
  { 3.711982e-01, -2.563834e-01,  8.924569e-01, -3.281607e-01,  3.223329e-01, -5.550573e-01},
  { 3.726832e-01,  2.412309e-01,  8.960552e-01, -3.248660e-01,  3.540633e-01, -5.473127e-01},
  { 2.817848e-01, -2.549996e-01,  9.249716e-01, -2.701253e-01,  3.381960e-01, -5.683632e-01},
  { 1.889859e-01, -2.559918e-01,  9.480255e-01, -2.145921e-01,  3.223329e-01, -5.896543e-01},
  { 1.897227e-01,  2.410541e-01,  9.517868e-01, -2.128820e-01,  3.540633e-01, -5.814284e-01},
  { 9.447201e-02, -2.545898e-01,  9.624236e-01, -1.528674e-01,  3.381960e-01, -5.915153e-01},
  { 5.613046e-09, -2.557780e-01,  9.667355e-01, -9.199809e-02,  3.223329e-01, -6.016881e-01},
  {-1.065815e-09,  2.409598e-01,  9.705351e-01, -9.199809e-02,  3.540633e-01, -5.932946e-01},
  { 4.673461e-01,  6.770392e-01,  5.685118e-01, -4.725792e-01,  3.593496e-01, -4.609576e-01},
  { 9.273343e-02,  9.860252e-01,  1.384010e-01, -4.312032e-01,  3.646401e-01, -5.012707e-01},
  { 3.481912e-01,  6.767039e-01,  6.487178e-01, -3.776207e-01,  3.593496e-01, -5.245130e-01},
  { 6.401420e-02,  9.860077e-01,  1.539191e-01, -3.286880e-01,  3.646401e-01, -5.562950e-01},
  { 2.147171e-01,  6.761129e-01,  7.048177e-01, -2.703251e-01,  3.593496e-01, -5.690036e-01},
  { 3.261502e-02,  9.859931e-01,  1.635657e-01, -2.148658e-01,  3.646401e-01, -5.909694e-01},
  { 7.203899e-02,  6.755471e-01,  7.337891e-01, -1.529358e-01,  3.593496e-01, -5.921814e-01},
  {-1.769736e-09,  9.860000e-01,  1.667454e-01, -9.199809e-02,  3.646401e-01, -6.030334e-01},
  {-4.705056e-01,  8.811870e-01, -4.619522e-02, -6.988049e-01,  3.593496e-01, -6.244276e-02},
  {-6.530250e-01,  7.460678e-01, -1.301587e-01, -7.023806e-01,  3.540633e-01, -1.269038e-01},
  {-4.516672e-01,  8.815126e-01, -1.375941e-01, -6.750554e-01,  3.593496e-01, -1.827314e-01},
  {-6.143314e-01,  7.465400e-01, -2.554899e-01, -6.665673e-01,  3.540633e-01, -2.444650e-01},
  {-4.155133e-01,  8.818206e-01, -2.230272e-01, -6.294646e-01,  3.593496e-01, -2.926770e-01},
  {-5.524125e-01,  7.468935e-01, -3.701223e-01, -6.097335e-01,  3.540633e-01, -3.503484e-01},
  {-3.640567e-01,  8.819849e-01, -2.992747e-01, -5.643405e-01,  3.593496e-01, -3.899807e-01},
  {-4.700979e-01,  7.470047e-01, -4.700978e-01, -5.342131e-01,  3.540633e-01, -4.422150e-01},
  {-8.212311e-01,  5.648718e-01, -8.061937e-02, -7.194127e-01,  3.381960e-01, -6.456371e-02},
  {-8.560476e-01,  4.879176e-01, -1.706429e-01, -7.237706e-01,  3.223329e-01, -1.313507e-01},
  {-7.889394e-01,  5.655191e-01, -2.403391e-01, -6.948552e-01,  3.381960e-01, -1.889378e-01},
  {-8.056695e-01,  4.884835e-01, -3.350827e-01, -6.867023e-01,  3.223329e-01, -2.530313e-01},
  {-7.262955e-01,  5.661445e-01, -3.898401e-01, -6.477215e-01,  3.381960e-01, -3.026173e-01},
  {-7.247012e-01,  4.889188e-01, -4.855579e-01, -6.278787e-01,  3.223329e-01, -3.626245e-01},
  {-6.365765e-01,  5.665000e-01, -5.233049e-01, -5.803840e-01,  3.381960e-01, -4.032256e-01},
  {-6.167668e-01,  4.890780e-01, -6.167669e-01, -5.497109e-01,  3.223329e-01, -4.577128e-01},
  {-2.992744e-01,  8.819851e-01, -3.640563e-01, -4.819788e-01,  3.593496e-01, -4.723424e-01},
  {-3.701221e-01,  7.468938e-01, -5.524122e-01, -4.423465e-01,  3.540633e-01, -5.177355e-01},
  {-2.230269e-01,  8.818209e-01, -4.155130e-01, -3.846751e-01,  3.593496e-01, -5.374665e-01},
  {-2.554896e-01,  7.465402e-01, -6.143312e-01, -3.364631e-01,  3.540633e-01, -5.745692e-01},
  {-1.375941e-01,  8.815126e-01, -4.516673e-01, -2.747295e-01,  3.593496e-01, -5.830573e-01},
  {-1.301588e-01,  7.460675e-01, -6.530252e-01, -2.189019e-01,  3.540633e-01, -6.103825e-01},
  {-4.619538e-02,  8.811867e-01, -4.705061e-01, -1.544409e-01,  3.593496e-01, -6.068068e-01},
  { 9.606461e-10,  7.457855e-01, -6.661862e-01, -9.199809e-02,  3.540633e-01, -6.228417e-01},
  {-5.233052e-01,  5.664997e-01, -6.365767e-01, -4.952237e-01,  3.381960e-01, -4.883859e-01},
  {-4.855582e-01,  4.889183e-01, -7.247014e-01, -4.546226e-01,  3.223329e-01, -5.358806e-01},
  {-3.898401e-01,  5.661440e-01, -7.262958e-01, -3.946154e-01,  3.381960e-01, -5.557235e-01},
  {-3.350827e-01,  4.884832e-01, -8.056697e-01, -3.450294e-01,  3.223329e-01, -5.947042e-01},
  {-2.403391e-01,  5.655190e-01, -7.889394e-01, -2.809359e-01,  3.381960e-01, -6.028571e-01},
  {-1.706428e-01,  4.879176e-01, -8.560476e-01, -2.233487e-01,  3.223329e-01, -6.317725e-01},
  {-8.061937e-02,  5.648718e-01, -8.212310e-01, -1.565618e-01,  3.381960e-01, -6.274146e-01},
  { 3.755191e-09,  4.875735e-01, -8.730819e-01, -9.199809e-02,  3.223329e-01, -6.446658e-01},
  {-9.447201e-02, -2.545898e-01,  9.624236e-01, -3.112875e-02,  3.381960e-01, -5.915153e-01},
  {-1.889859e-01, -2.559918e-01,  9.480256e-01,  3.059587e-02,  3.223329e-01, -5.896543e-01},
  {-1.897227e-01,  2.410541e-01,  9.517869e-01,  2.888578e-02,  3.540633e-01, -5.814284e-01},
  {-2.817848e-01, -2.549996e-01,  9.249716e-01,  8.612910e-02,  3.381960e-01, -5.683632e-01},
  {-3.711982e-01, -2.563832e-01,  8.924571e-01,  1.441645e-01,  3.223329e-01, -5.550573e-01},
  {-3.726832e-01,  2.412308e-01,  8.960552e-01,  1.408698e-01,  3.540633e-01, -5.473127e-01},
  {-4.572501e-01, -2.553554e-01,  8.518896e-01,  1.933039e-01,  3.381960e-01, -5.239242e-01},
  {-5.379884e-01, -2.566174e-01,  8.029421e-01,  2.464515e-01,  3.223329e-01, -5.001532e-01},
  {-5.401690e-01,  2.413363e-01,  8.062098e-01,  2.417299e-01,  3.540633e-01, -4.931780e-01},
  {-6.139376e-01, -2.555595e-01,  7.468401e-01,  2.881558e-01,  3.381960e-01, -4.604418e-01},
  {-6.834068e-01, -2.567301e-01,  6.834068e-01,  3.352005e-01,  3.223329e-01, -4.271986e-01},
  {-6.861998e-01,  2.413705e-01,  6.861997e-01,  3.292407e-01,  3.540633e-01, -4.212388e-01},
  {-7.203898e-02,  6.755471e-01,  7.337891e-01, -3.106041e-02,  3.593496e-01, -5.921814e-01},
  {-3.261505e-02,  9.859931e-01,  1.635658e-01,  3.086963e-02,  3.646401e-01, -5.909694e-01},
  {-2.147171e-01,  6.761129e-01,  7.048177e-01,  8.632895e-02,  3.593496e-01, -5.690036e-01},
  {-6.401430e-02,  9.860076e-01,  1.539195e-01,  1.446918e-01,  3.646401e-01, -5.562950e-01},
  {-3.481913e-01,  6.767036e-01,  6.487180e-01,  1.936246e-01,  3.593496e-01, -5.245130e-01},
  {-9.273370e-02,  9.860252e-01,  1.384013e-01,  2.472070e-01,  3.646401e-01, -5.012707e-01},
  {-4.673468e-01,  6.770380e-01,  5.685126e-01,  2.885830e-01,  3.593496e-01, -4.609576e-01},
  {-1.177691e-01,  9.860328e-01,  1.177691e-01,  3.361541e-01,  3.646401e-01, -4.281522e-01},
  {-7.468400e-01, -2.555601e-01,  6.139374e-01,  3.684437e-01,  3.381960e-01, -3.801538e-01},
  {-8.029419e-01, -2.566180e-01,  5.379884e-01,  4.081552e-01,  3.223329e-01, -3.384496e-01},
  {-8.062096e-01,  2.413366e-01,  5.401691e-01,  4.011799e-01,  3.540633e-01, -3.337280e-01},
  {-8.518896e-01, -2.553560e-01,  4.572499e-01,  4.319261e-01,  3.381960e-01, -2.853020e-01},
  {-8.924571e-01, -2.563827e-01,  3.711982e-01,  4.630592e-01,  3.223329e-01, -2.361626e-01},
  {-8.960552e-01,  2.412309e-01,  3.726831e-01,  4.553146e-01,  3.540633e-01, -2.328679e-01},
  {-9.249715e-01, -2.550000e-01,  2.817849e-01,  4.763651e-01,  3.381960e-01, -1.781272e-01},
  {-9.480255e-01, -2.559922e-01,  1.889858e-01,  4.976563e-01,  3.223329e-01, -1.225940e-01},
  {-9.517869e-01,  2.410539e-01,  1.897228e-01,  4.894303e-01,  3.540633e-01, -1.208839e-01},
  {-9.624237e-01, -2.545893e-01,  9.447215e-02,  4.995172e-01,  3.381960e-01, -6.086935e-02},
  {-5.685123e-01,  6.770386e-01,  4.673465e-01,  3.689595e-01,  3.593496e-01, -3.805811e-01},
  {-1.384007e-01,  9.860252e-01,  9.273334e-02,  4.092726e-01,  3.646401e-01, -3.392051e-01},
  {-6.487175e-01,  6.767043e-01,  3.481910e-01,  4.325149e-01,  3.593496e-01, -2.856227e-01},
  {-1.539193e-01,  9.860076e-01,  6.401428e-02,  4.642969e-01,  3.646401e-01, -2.366899e-01},
  {-7.048171e-01,  6.761134e-01,  2.147171e-01,  4.770055e-01,  3.593496e-01, -1.783270e-01},
  {-1.635650e-01,  9.859933e-01,  3.261488e-02,  4.989714e-01,  3.646401e-01, -1.228677e-01},
  {-7.337896e-01,  6.755466e-01,  7.203913e-02,  5.001833e-01,  3.593496e-01, -6.093768e-02},
  { 4.619539e-02,  8.811867e-01, -4.705061e-01, -2.955533e-02,  3.593496e-01, -6.068068e-01},
  { 1.301588e-01,  7.460676e-01, -6.530252e-01,  3.490568e-02,  3.540633e-01, -6.103825e-01},
  { 1.375941e-01,  8.815126e-01, -4.516672e-01,  9.073330e-02,  3.593496e-01, -5.830573e-01},
  { 2.554896e-01,  7.465401e-01, -6.143313e-01,  1.524669e-01,  3.540633e-01, -5.745692e-01},
  { 2.230269e-01,  8.818209e-01, -4.155130e-01,  2.006789e-01,  3.593496e-01, -5.374665e-01},
  { 3.701222e-01,  7.468938e-01, -5.524122e-01,  2.583503e-01,  3.540633e-01, -5.177355e-01},
  { 2.992744e-01,  8.819852e-01, -3.640562e-01,  2.979826e-01,  3.593496e-01, -4.723424e-01},
  { 4.700977e-01,  7.470048e-01, -4.700978e-01,  3.502169e-01,  3.540633e-01, -4.422150e-01},
  { 8.061936e-02,  5.648718e-01, -8.212311e-01, -2.743438e-02,  3.381960e-01, -6.274146e-01},
  { 1.706428e-01,  4.879176e-01, -8.560476e-01,  3.935257e-02,  3.223329e-01, -6.317725e-01},
  { 2.403391e-01,  5.655190e-01, -7.889394e-01,  9.693971e-02,  3.381960e-01, -6.028571e-01},
  { 3.350827e-01,  4.884832e-01, -8.056697e-01,  1.610333e-01,  3.223329e-01, -5.947042e-01},
  { 3.898401e-01,  5.661440e-01, -7.262958e-01,  2.106192e-01,  3.381960e-01, -5.557235e-01},
  { 4.855581e-01,  4.889184e-01, -7.247013e-01,  2.706265e-01,  3.223329e-01, -5.358806e-01},
  { 5.233052e-01,  5.664998e-01, -6.365765e-01,  3.112275e-01,  3.381960e-01, -4.883859e-01},
  { 6.167669e-01,  4.890780e-01, -6.167669e-01,  3.657147e-01,  3.223329e-01, -4.577128e-01},
  { 3.640563e-01,  8.819851e-01, -2.992745e-01,  3.803443e-01,  3.593496e-01, -3.899807e-01},
  { 5.524125e-01,  7.468936e-01, -3.701222e-01,  4.257374e-01,  3.540633e-01, -3.503484e-01},
  { 4.155132e-01,  8.818207e-01, -2.230269e-01,  4.454684e-01,  3.593496e-01, -2.926770e-01},
  { 6.143314e-01,  7.465400e-01, -2.554898e-01,  4.825711e-01,  3.540633e-01, -2.444650e-01},
  { 4.516670e-01,  8.815128e-01, -1.375942e-01,  4.910592e-01,  3.593496e-01, -1.827314e-01},
  { 6.530253e-01,  7.460675e-01, -1.301588e-01,  5.183845e-01,  3.540633e-01, -1.269038e-01},
  { 4.705058e-01,  8.811868e-01, -4.619519e-02,  5.148087e-01,  3.593496e-01, -6.244276e-02},
  { 6.365765e-01,  5.664998e-01, -5.233052e-01,  3.963878e-01,  3.381960e-01, -4.032256e-01},
  { 7.247014e-01,  4.889186e-01, -4.855580e-01,  4.438826e-01,  3.223329e-01, -3.626245e-01},
  { 7.262958e-01,  5.661442e-01, -3.898400e-01,  4.637254e-01,  3.381960e-01, -3.026173e-01},
  { 8.056697e-01,  4.884834e-01, -3.350827e-01,  5.027061e-01,  3.223329e-01, -2.530313e-01},
  { 7.889397e-01,  5.655186e-01, -2.403394e-01,  5.108590e-01,  3.381960e-01, -1.889378e-01},
  { 8.560477e-01,  4.879173e-01, -1.706430e-01,  5.397744e-01,  3.223329e-01, -1.313507e-01},
  { 8.212314e-01,  5.648713e-01, -8.061921e-02,  5.354165e-01,  3.381960e-01, -6.456371e-02},
  { 9.110542e-01,  4.024694e-01,  8.943504e-02,  6.193520e-01,  1.551238e-01,  7.320052e-02},
  { 9.191088e-01,  3.488103e-01,  1.832220e-01,  6.845535e-01, -1.208966e-02,  1.614518e-01},
  { 9.372987e-01,  3.485270e-01,  9.369286e-09,  7.004037e-01, -1.208966e-02,  0.000000e+00},
  { 8.754715e-01,  4.030194e-01,  2.666926e-01,  5.915067e-01,  1.551238e-01,  2.142130e-01},
  { 8.651670e-01,  3.492827e-01,  3.598438e-01,  6.389928e-01, -1.208966e-02,  3.110177e-01},
  { 8.061643e-01,  4.035610e-01,  4.327096e-01,  5.380639e-01,  1.551238e-01,  3.430997e-01},
  { 7.783303e-01,  3.496350e-01,  5.214954e-01,  5.666870e-01, -1.208966e-02,  4.457262e-01},
  { 7.066861e-01,  4.038635e-01,  5.809381e-01,  4.617226e-01,  1.551238e-01,  4.571669e-01},
  { 6.624442e-01,  3.497648e-01,  6.624442e-01,  4.706061e-01, -1.208966e-02,  5.626042e-01},
  { 5.809380e-01,  4.038634e-01,  7.066861e-01,  3.651688e-01,  1.551238e-01,  5.537207e-01},
  { 5.214953e-01,  3.496350e-01,  7.783303e-01,  3.537281e-01, -1.208966e-02,  6.586851e-01},
  { 4.327097e-01,  4.035611e-01,  8.061643e-01,  2.511017e-01,  1.551238e-01,  6.300620e-01},
  { 3.598437e-01,  3.492827e-01,  8.651671e-01,  2.190196e-01, -1.208966e-02,  7.309909e-01},
  { 2.666924e-01,  4.030193e-01,  8.754717e-01,  1.222149e-01,  1.551238e-01,  6.835048e-01},
  { 1.832218e-01,  3.488104e-01,  9.191088e-01,  6.945374e-02, -1.208966e-02,  7.765515e-01},
  { 8.943501e-02,  4.024693e-01,  9.110543e-01, -1.879757e-02,  1.551238e-01,  7.113500e-01},
  {-1.218007e-08,  3.485271e-01,  9.372987e-01, -9.199809e-02, -1.208966e-02,  7.924017e-01},
  { 9.523243e-01,  2.904118e-01,  9.348544e-02,  7.165805e-01, -9.191648e-02,  8.320573e-02},
  { 9.593205e-01,  2.076789e-01,  1.912427e-01,  7.322673e-01, -1.717433e-01,  1.713715e-01},
  { 9.782357e-01,  2.074967e-01, -9.391250e-10,  7.490889e-01, -1.717433e-01,  0.000000e+00},
  { 9.152456e-01,  2.908446e-01,  2.788099e-01,  6.849317e-01, -9.191648e-02,  2.434920e-01},
  { 9.031258e-01,  2.079872e-01,  3.756395e-01,  6.839045e-01, -1.717433e-01,  3.301269e-01},
  { 8.428943e-01,  2.912606e-01,  4.524341e-01,  6.241826e-01, -9.191648e-02,  3.899958e-01},
  { 8.125500e-01,  2.082188e-01,  5.444331e-01,  6.071549e-01, -1.717433e-01,  4.731117e-01},
  { 7.389411e-01,  2.915034e-01,  6.074471e-01,  5.374064e-01, -9.191648e-02,  5.196522e-01},
  { 6.915964e-01,  2.083005e-01,  6.915963e-01,  5.051731e-01, -1.717433e-01,  5.971712e-01},
  { 9.878865e-01,  1.211485e-01,  9.696984e-02,  7.498195e-01, -2.470381e-01,  8.662633e-02},
  { 9.806813e-01, -6.407555e-03,  1.955076e-01,  7.503653e-01, -3.223329e-01,  1.751342e-01},
  { 9.999796e-01, -6.393653e-03, -9.434937e-10,  7.675564e-01, -3.223329e-01,  0.000000e+00},
  { 9.495283e-01,  1.213433e-01,  2.892610e-01,  7.168685e-01, -2.470381e-01,  2.535020e-01},
  { 9.232999e-01, -6.432565e-03,  3.840260e-01,  7.009409e-01, -3.223329e-01,  3.373751e-01},
  { 8.745623e-01,  1.215365e-01,  4.694356e-01,  6.536267e-01, -2.470381e-01,  4.060282e-01},
  { 8.307404e-01, -6.430120e-03,  5.566229e-01,  6.225066e-01, -3.223329e-01,  4.834994e-01},
  { 7.667589e-01,  1.216463e-01,  6.303040e-01,  5.632790e-01, -2.470381e-01,  5.410165e-01},
  { 7.070922e-01, -6.422000e-03,  7.070922e-01,  5.182856e-01, -3.223329e-01,  6.102836e-01},
  { 6.074470e-01,  2.915034e-01,  7.389411e-01,  4.276542e-01, -9.191648e-02,  6.294045e-01},
  { 5.444330e-01,  2.082187e-01,  8.125501e-01,  3.811136e-01, -1.717433e-01,  6.991530e-01},
  { 4.524340e-01,  2.912605e-01,  8.428943e-01,  2.979977e-01, -9.191648e-02,  7.161807e-01},
  { 3.756394e-01,  2.079872e-01,  9.031259e-01,  2.381288e-01, -1.717433e-01,  7.759026e-01},
  { 2.788099e-01,  2.908446e-01,  9.152456e-01,  1.514939e-01, -9.191648e-02,  7.769298e-01},
  { 1.912427e-01,  2.076789e-01,  9.593205e-01,  7.937343e-02, -1.717433e-01,  8.242654e-01},
  { 9.348527e-02,  2.904119e-01,  9.523243e-01, -8.792362e-03, -9.191648e-02,  8.085786e-01},
  {-1.878250e-09,  2.074968e-01,  9.782357e-01, -9.199809e-02, -1.717433e-01,  8.410869e-01},
  { 6.303040e-01,  1.216463e-01,  7.667588e-01,  4.490184e-01, -2.470381e-01,  6.552771e-01},
  { 5.566228e-01, -6.430420e-03,  8.307405e-01,  3.915013e-01, -3.223329e-01,  7.145047e-01},
  { 4.694355e-01,  1.215367e-01,  8.745623e-01,  3.140301e-01, -2.470381e-01,  7.456248e-01},
  { 3.840260e-01, -6.432615e-03,  9.232998e-01,  2.453770e-01, -3.223329e-01,  7.929390e-01},
  { 2.892610e-01,  1.213433e-01,  9.495283e-01,  1.615039e-01, -2.470381e-01,  8.088666e-01},
  { 1.955076e-01, -6.407526e-03,  9.806813e-01,  8.313613e-02, -3.223329e-01,  8.423634e-01},
  { 9.696984e-02,  1.211485e-01,  9.878866e-01, -5.371762e-03, -2.470381e-01,  8.418176e-01},
  {-9.434937e-10, -6.393438e-03,  9.999796e-01, -9.199809e-02, -3.223329e-01,  8.595545e-01},
  {-8.943506e-02,  4.024693e-01,  9.110543e-01, -1.651986e-01,  1.551238e-01,  7.113500e-01},
  {-1.832218e-01,  3.488104e-01,  9.191089e-01, -2.534499e-01, -1.208966e-02,  7.765515e-01},
  {-2.666925e-01,  4.030193e-01,  8.754717e-01, -3.062111e-01,  1.551238e-01,  6.835048e-01},
  {-3.598438e-01,  3.492826e-01,  8.651671e-01, -4.030158e-01, -1.208966e-02,  7.309909e-01},
  {-4.327097e-01,  4.035611e-01,  8.061643e-01, -4.350978e-01,  1.551238e-01,  6.300620e-01},
  {-5.214953e-01,  3.496350e-01,  7.783303e-01, -5.377243e-01, -1.208966e-02,  6.586851e-01},
  {-5.809381e-01,  4.038634e-01,  7.066861e-01, -5.491650e-01,  1.551238e-01,  5.537207e-01},
  {-6.624441e-01,  3.497648e-01,  6.624443e-01, -6.546022e-01, -1.208966e-02,  5.626042e-01},
  {-7.066861e-01,  4.038634e-01,  5.809381e-01, -6.457188e-01,  1.551238e-01,  4.571669e-01},
  {-7.783302e-01,  3.496350e-01,  5.214954e-01, -7.506832e-01, -1.208966e-02,  4.457262e-01},
  {-8.061643e-01,  4.035611e-01,  4.327097e-01, -7.220601e-01,  1.551238e-01,  3.430997e-01},
  {-8.651671e-01,  3.492827e-01,  3.598436e-01, -8.229890e-01, -1.208966e-02,  3.110177e-01},
  {-8.754717e-01,  4.030192e-01,  2.666923e-01, -7.755029e-01,  1.551238e-01,  2.142130e-01},
  {-9.191089e-01,  3.488106e-01,  1.832217e-01, -8.685496e-01, -1.208966e-02,  1.614518e-01},
  {-9.110544e-01,  4.024692e-01,  8.943501e-02, -8.033481e-01,  1.551238e-01,  7.320052e-02},
  {-9.372986e-01,  3.485273e-01, -5.621571e-09, -8.843998e-01, -1.208966e-02,  0.000000e+00},
  {-9.348527e-02,  2.904119e-01,  9.523243e-01, -1.752038e-01, -9.191648e-02,  8.085786e-01},
  {-1.912427e-01,  2.076789e-01,  9.593205e-01, -2.633696e-01, -1.717433e-01,  8.242654e-01},
  {-2.788099e-01,  2.908446e-01,  9.152456e-01, -3.354901e-01, -9.191648e-02,  7.769298e-01},
  {-3.756395e-01,  2.079872e-01,  9.031259e-01, -4.221250e-01, -1.717433e-01,  7.759026e-01},
  {-4.524340e-01,  2.912604e-01,  8.428943e-01, -4.819938e-01, -9.191648e-02,  7.161807e-01},
  {-5.444330e-01,  2.082188e-01,  8.125501e-01, -5.651097e-01, -1.717433e-01,  6.991530e-01},
  {-6.074471e-01,  2.915034e-01,  7.389410e-01, -6.116503e-01, -9.191648e-02,  6.294045e-01},
  {-6.915963e-01,  2.083005e-01,  6.915963e-01, -6.891692e-01, -1.717433e-01,  5.971712e-01},
  {-9.696984e-02,  1.211485e-01,  9.878866e-01, -1.786244e-01, -2.470381e-01,  8.418176e-01},
  {-1.955077e-01, -6.407521e-03,  9.806813e-01, -2.671323e-01, -3.223329e-01,  8.423634e-01},
  {-2.892610e-01,  1.213433e-01,  9.495283e-01, -3.455001e-01, -2.470381e-01,  8.088666e-01},
  {-3.840261e-01, -6.432694e-03,  9.232998e-01, -4.293732e-01, -3.223329e-01,  7.929390e-01},
  {-4.694355e-01,  1.215367e-01,  8.745623e-01, -4.980263e-01, -2.470381e-01,  7.456248e-01},
  {-5.566228e-01, -6.430494e-03,  8.307404e-01, -5.754974e-01, -3.223329e-01,  7.145047e-01},
  {-6.303041e-01,  1.216463e-01,  7.667587e-01, -6.330146e-01, -2.470381e-01,  6.552771e-01},
  {-7.070923e-01, -6.421737e-03,  7.070922e-01, -7.022817e-01, -3.223329e-01,  6.102836e-01},
  {-7.389409e-01,  2.915034e-01,  6.074473e-01, -7.214026e-01, -9.191648e-02,  5.196522e-01},
  {-8.125501e-01,  2.082186e-01,  5.444331e-01, -7.911511e-01, -1.717433e-01,  4.731117e-01},
  {-8.428943e-01,  2.912605e-01,  4.524339e-01, -8.081788e-01, -9.191648e-02,  3.899958e-01},
  {-9.031259e-01,  2.079871e-01,  3.756395e-01, -8.679007e-01, -1.717433e-01,  3.301269e-01},
  {-9.152456e-01,  2.908448e-01,  2.788098e-01, -8.689279e-01, -9.191648e-02,  2.434920e-01},
  {-9.593205e-01,  2.076788e-01,  1.912429e-01, -9.162635e-01, -1.717433e-01,  1.713715e-01},
  {-9.523240e-01,  2.904124e-01,  9.348540e-02, -9.005767e-01, -9.191648e-02,  8.320573e-02},
  {-9.782357e-01,  2.074968e-01,  0.000000e+00, -9.330851e-01, -1.717433e-01,  0.000000e+00},
  {-7.667587e-01,  1.216463e-01,  6.303042e-01, -7.472751e-01, -2.470381e-01,  5.410165e-01},
  {-8.307404e-01, -6.430286e-03,  5.566229e-01, -8.065028e-01, -3.223329e-01,  4.834994e-01},
  {-8.745623e-01,  1.215367e-01,  4.694355e-01, -8.376229e-01, -2.470381e-01,  4.060282e-01},
  {-9.232999e-01, -6.432571e-03,  3.840258e-01, -8.849371e-01, -3.223329e-01,  3.373751e-01},
  {-9.495283e-01,  1.213431e-01,  2.892608e-01, -9.008646e-01, -2.470381e-01,  2.535020e-01},
  {-9.806812e-01, -6.407150e-03,  1.955076e-01, -9.343614e-01, -3.223329e-01,  1.751342e-01},
  {-9.878867e-01,  1.211479e-01,  9.697001e-02, -9.338157e-01, -2.470381e-01,  8.662633e-02},
  {-8.671390e-01,  4.980662e-01,  1.073702e-09, -9.515525e-01, -3.223329e-01,  0.000000e+00},
  {-9.110543e-01,  4.024692e-01, -8.943506e-02, -8.033481e-01,  1.551238e-01, -7.320052e-02},
  {-9.191088e-01,  3.488106e-01, -1.832217e-01, -8.685496e-01, -1.208966e-02, -1.614518e-01},
  {-8.754717e-01,  4.030193e-01, -2.666923e-01, -7.755029e-01,  1.551238e-01, -2.142130e-01},
  {-8.651671e-01,  3.492827e-01, -3.598436e-01, -8.229890e-01, -1.208966e-02, -3.110177e-01},
  {-8.061643e-01,  4.035611e-01, -4.327097e-01, -7.220601e-01,  1.551238e-01, -3.430997e-01},
  {-7.783302e-01,  3.496351e-01, -5.214954e-01, -7.506832e-01, -1.208966e-02, -4.457262e-01},
  {-7.066861e-01,  4.038634e-01, -5.809382e-01, -6.457188e-01,  1.551238e-01, -4.571669e-01},
  {-6.624441e-01,  3.497648e-01, -6.624443e-01, -6.546022e-01, -1.208966e-02, -5.626042e-01},
  {-5.809380e-01,  4.038634e-01, -7.066861e-01, -5.491650e-01,  1.551238e-01, -5.537207e-01},
  {-5.214954e-01,  3.496350e-01, -7.783303e-01, -5.377243e-01, -1.208966e-02, -6.586851e-01},
  {-4.327097e-01,  4.035611e-01, -8.061642e-01, -4.350978e-01,  1.551238e-01, -6.300620e-01},
  {-3.598438e-01,  3.492826e-01, -8.651670e-01, -4.030158e-01, -1.208966e-02, -7.309909e-01},
  {-2.666924e-01,  4.030193e-01, -8.754717e-01, -3.062111e-01,  1.551238e-01, -6.835048e-01},
  {-1.832218e-01,  3.488105e-01, -9.191089e-01, -2.534499e-01, -1.208966e-02, -7.765515e-01},
  {-8.943503e-02,  4.024693e-01, -9.110543e-01, -1.651986e-01,  1.551238e-01, -7.113500e-01},
  { 1.873857e-09,  3.485271e-01, -9.372987e-01, -9.199809e-02, -1.208966e-02, -7.924017e-01},
  {-9.523240e-01,  2.904124e-01, -9.348540e-02, -9.005767e-01, -9.191648e-02, -8.320573e-02},
  {-9.593205e-01,  2.076788e-01, -1.912429e-01, -9.162635e-01, -1.717433e-01, -1.713715e-01},
  {-9.152456e-01,  2.908448e-01, -2.788097e-01, -8.689279e-01, -9.191648e-02, -2.434920e-01},
  {-9.031259e-01,  2.079871e-01, -3.756394e-01, -8.679007e-01, -1.717433e-01, -3.301269e-01},
  {-8.428944e-01,  2.912605e-01, -4.524340e-01, -8.081788e-01, -9.191648e-02, -3.899958e-01},
  {-8.125501e-01,  2.082186e-01, -5.444331e-01, -7.911511e-01, -1.717433e-01, -4.731117e-01},
  {-7.389409e-01,  2.915034e-01, -6.074472e-01, -7.214026e-01, -9.191648e-02, -5.196522e-01},
  {-6.915964e-01,  2.083005e-01, -6.915963e-01, -6.891692e-01, -1.717433e-01, -5.971712e-01},
  {-9.878867e-01,  1.211479e-01, -9.697001e-02, -9.338157e-01, -2.470381e-01, -8.662633e-02},
  {-9.806812e-01, -6.407148e-03, -1.955076e-01, -9.343614e-01, -3.223329e-01, -1.751342e-01},
  {-9.495283e-01,  1.213431e-01, -2.892608e-01, -9.008646e-01, -2.470381e-01, -2.535020e-01},
  {-9.232999e-01, -6.432570e-03, -3.840259e-01, -8.849371e-01, -3.223329e-01, -3.373751e-01},
  {-8.745623e-01,  1.215367e-01, -4.694355e-01, -8.376229e-01, -2.470381e-01, -4.060282e-01},
  {-8.307404e-01, -6.430284e-03, -5.566228e-01, -8.065028e-01, -3.223329e-01, -4.834994e-01},
  {-7.667587e-01,  1.216463e-01, -6.303042e-01, -7.472751e-01, -2.470381e-01, -5.410165e-01},
  {-7.070923e-01, -6.421739e-03, -7.070922e-01, -7.022817e-01, -3.223329e-01, -6.102836e-01},
  {-6.074471e-01,  2.915034e-01, -7.389410e-01, -6.116503e-01, -9.191648e-02, -6.294045e-01},
  {-5.444330e-01,  2.082188e-01, -8.125501e-01, -5.651097e-01, -1.717433e-01, -6.991530e-01},
  {-4.524340e-01,  2.912604e-01, -8.428943e-01, -4.819938e-01, -9.191648e-02, -7.161807e-01},
  {-3.756394e-01,  2.079872e-01, -9.031259e-01, -4.221250e-01, -1.717433e-01, -7.759026e-01},
  {-2.788099e-01,  2.908446e-01, -9.152456e-01, -3.354901e-01, -9.191648e-02, -7.769298e-01},
  {-1.912427e-01,  2.076789e-01, -9.593205e-01, -2.633696e-01, -1.717433e-01, -8.242654e-01},
  {-9.348527e-02,  2.904119e-01, -9.523243e-01, -1.752038e-01, -9.191648e-02, -8.085786e-01},
  {-1.878250e-09,  2.074968e-01, -9.782357e-01, -9.199809e-02, -1.717433e-01, -8.410869e-01},
  {-6.303041e-01,  1.216463e-01, -7.667587e-01, -6.330146e-01, -2.470381e-01, -6.552771e-01},
  {-5.566227e-01, -6.430499e-03, -8.307405e-01, -5.754974e-01, -3.223329e-01, -7.145047e-01},
  {-4.694355e-01,  1.215367e-01, -8.745623e-01, -4.980263e-01, -2.470381e-01, -7.456248e-01},
  {-3.840260e-01, -6.432694e-03, -9.232998e-01, -4.293732e-01, -3.223329e-01, -7.929390e-01},
  {-2.892610e-01,  1.213433e-01, -9.495283e-01, -3.455001e-01, -2.470381e-01, -8.088666e-01},
  {-1.955076e-01, -6.407530e-03, -9.806813e-01, -2.671323e-01, -3.223329e-01, -8.423634e-01},
  {-9.696984e-02,  1.211485e-01, -9.878866e-01, -1.786244e-01, -2.470381e-01, -8.418176e-01},
  { 9.434937e-10, -6.393438e-03, -9.999796e-01, -9.199809e-02, -3.223329e-01, -8.595545e-01},
  { 8.943504e-02,  4.024693e-01, -9.110543e-01, -1.879757e-02,  1.551238e-01, -7.113500e-01},
  { 1.832218e-01,  3.488105e-01, -9.191088e-01,  6.945374e-02, -1.208966e-02, -7.765515e-01},
  { 2.666925e-01,  4.030193e-01, -8.754717e-01,  1.222149e-01,  1.551238e-01, -6.835048e-01},
  { 3.598437e-01,  3.492826e-01, -8.651671e-01,  2.190196e-01, -1.208966e-02, -7.309909e-01},
  { 4.327097e-01,  4.035611e-01, -8.061643e-01,  2.511017e-01,  1.551238e-01, -6.300620e-01},
  { 5.214953e-01,  3.496350e-01, -7.783303e-01,  3.537281e-01, -1.208966e-02, -6.586851e-01},
  { 5.809381e-01,  4.038634e-01, -7.066861e-01,  3.651688e-01,  1.551238e-01, -5.537207e-01},
  { 6.624442e-01,  3.497648e-01, -6.624442e-01,  4.706061e-01, -1.208966e-02, -5.626042e-01},
  { 7.066861e-01,  4.038634e-01, -5.809380e-01,  4.617226e-01,  1.551238e-01, -4.571669e-01},
  { 7.783303e-01,  3.496350e-01, -5.214953e-01,  5.666870e-01, -1.208966e-02, -4.457262e-01},
  { 8.061643e-01,  4.035611e-01, -4.327096e-01,  5.380639e-01,  1.551238e-01, -3.430997e-01},
  { 8.651670e-01,  3.492827e-01, -3.598438e-01,  6.389928e-01, -1.208966e-02, -3.110177e-01},
  { 8.754715e-01,  4.030194e-01, -2.666926e-01,  5.915067e-01,  1.551238e-01, -2.142130e-01},
  { 9.191088e-01,  3.488103e-01, -1.832220e-01,  6.845535e-01, -1.208966e-02, -1.614518e-01},
  { 9.110542e-01,  4.024695e-01, -8.943500e-02,  6.193520e-01,  1.551238e-01, -7.320052e-02},
  { 9.348526e-02,  2.904119e-01, -9.523243e-01, -8.792362e-03, -9.191648e-02, -8.085786e-01},
  { 1.912427e-01,  2.076789e-01, -9.593205e-01,  7.937343e-02, -1.717433e-01, -8.242654e-01},
  { 2.788099e-01,  2.908446e-01, -9.152456e-01,  1.514939e-01, -9.191648e-02, -7.769298e-01},
  { 3.756394e-01,  2.079872e-01, -9.031259e-01,  2.381288e-01, -1.717433e-01, -7.759026e-01},
  { 4.524340e-01,  2.912604e-01, -8.428943e-01,  2.979977e-01, -9.191648e-02, -7.161807e-01},
  { 5.444331e-01,  2.082187e-01, -8.125501e-01,  3.811136e-01, -1.717433e-01, -6.991530e-01},
  { 6.074470e-01,  2.915034e-01, -7.389411e-01,  4.276542e-01, -9.191648e-02, -6.294045e-01},
  { 6.915963e-01,  2.083005e-01, -6.915963e-01,  5.051731e-01, -1.717433e-01, -5.971712e-01},
  { 9.696984e-02,  1.211485e-01, -9.878866e-01, -5.371762e-03, -2.470381e-01, -8.418176e-01},
  { 1.955077e-01, -6.407526e-03, -9.806812e-01,  8.313613e-02, -3.223329e-01, -8.423634e-01},
  { 2.892610e-01,  1.213433e-01, -9.495283e-01,  1.615039e-01, -2.470381e-01, -8.088666e-01},
  { 3.840260e-01, -6.432609e-03, -9.232999e-01,  2.453770e-01, -3.223329e-01, -7.929390e-01},
  { 4.694355e-01,  1.215367e-01, -8.745623e-01,  3.140301e-01, -2.470381e-01, -7.456248e-01},
  { 5.566228e-01, -6.430413e-03, -8.307404e-01,  3.915013e-01, -3.223329e-01, -7.145047e-01},
  { 6.303040e-01,  1.216463e-01, -7.667588e-01,  4.490184e-01, -2.470381e-01, -6.552771e-01},
  { 7.070922e-01, -6.422006e-03, -7.070921e-01,  5.182856e-01, -3.223329e-01, -6.102836e-01},
  { 7.389411e-01,  2.915034e-01, -6.074470e-01,  5.374064e-01, -9.191648e-02, -5.196522e-01},
  { 8.125500e-01,  2.082188e-01, -5.444331e-01,  6.071549e-01, -1.717433e-01, -4.731117e-01},
  { 8.428943e-01,  2.912606e-01, -4.524341e-01,  6.241826e-01, -9.191648e-02, -3.899958e-01},
  { 9.031258e-01,  2.079872e-01, -3.756394e-01,  6.839045e-01, -1.717433e-01, -3.301269e-01},
  { 9.152456e-01,  2.908446e-01, -2.788099e-01,  6.849317e-01, -9.191648e-02, -2.434920e-01},
  { 9.593205e-01,  2.076789e-01, -1.912427e-01,  7.322673e-01, -1.717433e-01, -1.713715e-01},
  { 9.523243e-01,  2.904118e-01, -9.348544e-02,  7.165805e-01, -9.191648e-02, -8.320573e-02},
  { 7.667589e-01,  1.216463e-01, -6.303040e-01,  5.632790e-01, -2.470381e-01, -5.410165e-01},
  { 8.307404e-01, -6.430127e-03, -5.566229e-01,  6.225066e-01, -3.223329e-01, -4.834994e-01},
  { 8.745623e-01,  1.215365e-01, -4.694356e-01,  6.536267e-01, -2.470381e-01, -4.060282e-01},
  { 9.232999e-01, -6.432561e-03, -3.840260e-01,  7.009409e-01, -3.223329e-01, -3.373751e-01},
  { 9.495283e-01,  1.213433e-01, -2.892610e-01,  7.168685e-01, -2.470381e-01, -2.535020e-01},
  { 9.806812e-01, -6.407551e-03, -1.955076e-01,  7.503653e-01, -3.223329e-01, -1.751342e-01},
  { 9.878865e-01,  1.211485e-01, -9.696983e-02,  7.498195e-01, -2.470381e-01, -8.662633e-02},
  { 9.862702e-01, -1.337858e-01,  9.681124e-02,  7.543923e-01, -3.563605e-01,  8.709694e-02},
  { 9.471666e-01, -2.592706e-01,  1.888235e-01,  7.413185e-01, -3.903881e-01,  1.732531e-01},
  { 9.658613e-01, -2.590595e-01,  0.000000e+00,  7.583247e-01, -3.903881e-01,  0.000000e+00},
  { 9.479659e-01, -1.340158e-01,  2.887914e-01,  7.212607e-01, -3.563605e-01,  2.548781e-01},
  { 8.916597e-01, -2.596253e-01,  3.708608e-01,  6.924227e-01, -3.903881e-01,  3.337508e-01},
  { 9.214442e-01, -3.778349e-01,  9.045097e-02,  7.377685e-01, -4.200716e-01,  8.538643e-02},
  { 8.473625e-01, -5.034347e-01,  1.689092e-01,  7.174615e-01, -4.497550e-01,  1.682930e-01},
  { 8.642297e-01, -5.030973e-01, -1.887198e-09,  7.339821e-01, -4.497550e-01,  0.000000e+00},
  { 8.854789e-01, -3.783621e-01,  2.697576e-01,  7.052902e-01, -4.200716e-01,  2.498733e-01},
  { 7.974768e-01, -5.040073e-01,  3.316737e-01,  6.699669e-01, -4.497550e-01,  3.241964e-01},
  { 8.731212e-01, -1.342366e-01,  4.686576e-01,  6.576753e-01, -3.563605e-01,  4.082329e-01},
  { 8.022134e-01, -2.598953e-01,  5.375019e-01,  6.148307e-01, -3.903881e-01,  4.783077e-01},
  { 7.654976e-01, -1.343330e-01,  6.292599e-01,  5.668375e-01, -3.563605e-01,  5.439561e-01},
  { 6.827868e-01, -2.600082e-01,  6.827869e-01,  5.117314e-01, -3.903881e-01,  6.037295e-01},
  { 8.154125e-01, -3.788686e-01,  4.376768e-01,  6.429554e-01, -4.200716e-01,  4.002163e-01},
  { 7.173222e-01, -5.044326e-01,  4.806212e-01,  5.945969e-01, -4.497550e-01,  4.646150e-01},
  { 7.148051e-01, -3.791843e-01,  5.875994e-01,  5.539012e-01, -4.200716e-01,  5.332719e-01},
  { 6.104876e-01, -5.045887e-01,  6.104876e-01,  4.944458e-01, -4.497550e-01,  5.864439e-01},
  { 7.845107e-01, -6.153150e-01,  7.700977e-02,  6.891564e-01, -4.968461e-01,  8.038381e-02},
  { 7.097536e-01, -6.900996e-01,  1.414651e-01,  6.450698e-01, -5.439368e-01,  1.532427e-01},
  { 7.240294e-01, -6.897691e-01, -6.096933e-08,  6.601121e-01, -5.439368e-01,  0.000000e+00},
  { 7.535992e-01, -6.159389e-01,  2.295812e-01,  6.585821e-01, -4.968461e-01,  2.352338e-01},
  { 6.677384e-01, -6.906546e-01,  2.777077e-01,  6.018214e-01, -5.439368e-01,  2.952032e-01},
  { 6.937052e-01, -6.165496e-01,  3.723436e-01,  5.998960e-01, -4.968461e-01,  3.767685e-01},
  { 6.004726e-01, -6.910709e-01,  4.023106e-01,  5.331945e-01, -5.439368e-01,  4.230620e-01},
  { 6.079893e-01, -6.168867e-01,  4.997999e-01,  5.160593e-01, -4.968461e-01,  5.020314e-01},
  { 5.109915e-01, -6.912130e-01,  5.109915e-01,  4.420001e-01, -5.439368e-01,  5.339982e-01},
  { 6.292598e-01, -1.343333e-01,  7.654977e-01,  4.519580e-01, -3.563605e-01,  6.588356e-01},
  { 5.375018e-01, -2.598953e-01,  8.022134e-01,  3.863096e-01, -3.903881e-01,  7.068288e-01},
  { 4.686577e-01, -1.342370e-01,  8.731211e-01,  3.162348e-01, -3.563605e-01,  7.496733e-01},
  { 3.708609e-01, -2.596251e-01,  8.916597e-01,  2.417527e-01, -3.903881e-01,  7.844208e-01},
  { 5.875992e-01, -3.791843e-01,  7.148052e-01,  4.412738e-01, -4.200716e-01,  6.458993e-01},
  { 4.806212e-01, -5.044326e-01,  7.173221e-01,  3.726169e-01, -4.497550e-01,  6.865949e-01},
  { 4.376771e-01, -3.788686e-01,  8.154124e-01,  3.082182e-01, -4.200716e-01,  7.349535e-01},
  { 3.316737e-01, -5.040074e-01,  7.974767e-01,  2.321983e-01, -4.497550e-01,  7.619650e-01},
  { 2.887911e-01, -1.340158e-01,  9.479660e-01,  1.628800e-01, -3.563605e-01,  8.132588e-01},
  { 1.888235e-01, -2.592703e-01,  9.471666e-01,  8.125499e-02, -3.903881e-01,  8.333165e-01},
  { 9.681159e-02, -1.337859e-01,  9.862702e-01, -4.901157e-03, -3.563605e-01,  8.463904e-01},
  { 0.000000e+00, -2.590595e-01,  9.658614e-01, -9.199809e-02, -3.903881e-01,  8.503228e-01},
  { 2.697575e-01, -3.783617e-01,  8.854791e-01,  1.578753e-01, -4.200716e-01,  7.972883e-01},
  { 1.689091e-01, -5.034348e-01,  8.473625e-01,  7.629494e-02, -4.497550e-01,  8.094596e-01},
  { 9.045114e-02, -3.778345e-01,  9.214444e-01, -6.611669e-03, -4.200716e-01,  8.297666e-01},
  {-1.887198e-09, -5.030975e-01,  8.642296e-01, -9.199809e-02, -4.497550e-01,  8.259802e-01},
  { 4.997998e-01, -6.168866e-01,  6.079894e-01,  4.100333e-01, -4.968461e-01,  6.080574e-01},
  { 4.023106e-01, -6.910707e-01,  6.004727e-01,  3.310639e-01, -5.439368e-01,  6.251926e-01},
  { 3.723438e-01, -6.165494e-01,  6.937052e-01,  2.847704e-01, -4.968461e-01,  6.918941e-01},
  { 2.777075e-01, -6.906546e-01,  6.677386e-01,  2.032051e-01, -5.439368e-01,  6.938195e-01},
  { 2.295808e-01, -6.159393e-01,  7.535991e-01,  1.432358e-01, -4.968461e-01,  7.505801e-01},
  { 1.414649e-01, -6.900995e-01,  7.097538e-01,  6.124413e-02, -5.439368e-01,  7.370679e-01},
  { 7.700970e-02, -6.153152e-01,  7.845105e-01, -1.161428e-02, -4.968461e-01,  7.811545e-01},
  { 4.408552e-08, -6.897689e-01,  7.240296e-01, -9.199809e-02, -5.439368e-01,  7.521101e-01},
  { 6.532586e-01, -7.544141e-01,  6.413095e-02,  6.160255e-01, -5.759183e-01,  7.285842e-02},
  { 6.839081e-01, -7.167206e-01,  1.363136e-01,  5.726782e-01, -6.078997e-01,  1.381919e-01},
  { 6.976843e-01, -7.164053e-01, -6.545737e-09,  5.862463e-01, -6.078997e-01,  0.000000e+00},
  { 6.273247e-01, -7.549446e-01,  1.911084e-01,  5.883135e-01, -5.759183e-01,  2.132120e-01},
  { 6.433897e-01, -7.172553e-01,  2.675715e-01,  5.336802e-01, -6.078997e-01,  2.662100e-01},
  { 5.772924e-01, -7.554609e-01,  3.098587e-01,  5.351200e-01, -5.759183e-01,  3.414967e-01},
  { 5.785439e-01, -7.176612e-01,  3.876201e-01,  4.717923e-01, -6.078997e-01,  3.815111e-01},
  { 5.058713e-01, -7.557548e-01,  4.158471e-01,  4.591353e-01, -5.759183e-01,  4.550309e-01},
  { 4.923117e-01, -7.178150e-01,  4.923117e-01,  3.895544e-01, -6.078997e-01,  4.815525e-01},
  { 7.364743e-01, -6.725908e-01,  7.230060e-02,  5.628406e-01, -6.262830e-01,  6.738563e-02},
  { 7.238773e-01, -6.746734e-01,  1.442827e-01,  5.397744e-01, -6.446658e-01,  1.313507e-01},
  { 7.384077e-01, -6.743546e-01,  0.000000e+00,  5.526677e-01, -6.446658e-01,  0.000000e+00},
  { 7.073848e-01, -6.731789e-01,  2.154923e-01,  5.372087e-01, -6.262830e-01,  1.971960e-01},
  { 6.810326e-01, -6.752633e-01,  2.832209e-01,  5.027061e-01, -6.446658e-01,  2.530313e-01},
  { 6.510808e-01, -6.737710e-01,  3.494661e-01,  4.880164e-01, -6.262830e-01,  3.158441e-01},
  { 6.124242e-01, -6.756960e-01,  4.103310e-01,  4.438826e-01, -6.446658e-01,  3.626245e-01},
  { 5.705893e-01, -6.741059e-01,  4.690513e-01,  4.177349e-01, -6.262830e-01,  4.208503e-01},
  { 5.211670e-01, -6.758476e-01,  5.211670e-01,  3.657147e-01, -6.446658e-01,  4.577128e-01},
  { 4.158471e-01, -7.557548e-01,  5.058714e-01,  3.630329e-01, -5.759183e-01,  5.511334e-01},
  { 3.876200e-01, -7.176613e-01,  5.785438e-01,  2.895130e-01, -6.078997e-01,  5.637904e-01},
  { 3.098585e-01, -7.554610e-01,  5.772923e-01,  2.494986e-01, -5.759183e-01,  6.271181e-01},
  { 2.675715e-01, -7.172551e-01,  6.433899e-01,  1.742119e-01, -6.078997e-01,  6.256782e-01},
  { 1.911083e-01, -7.549444e-01,  6.273249e-01,  1.212140e-01, -5.759183e-01,  6.803116e-01},
  { 1.363135e-01, -7.167206e-01,  6.839080e-01,  4.619377e-02, -6.078997e-01,  6.646763e-01},
  { 6.413092e-02, -7.544138e-01,  6.532587e-01, -1.913968e-02, -5.759183e-01,  7.080236e-01},
  {-6.545737e-09, -7.164055e-01,  6.976842e-01, -9.199809e-02, -6.078997e-01,  6.782444e-01},
  { 4.690512e-01, -6.741060e-01,  5.705892e-01,  3.288522e-01, -6.262830e-01,  5.097330e-01},
  { 4.103310e-01, -6.756961e-01,  6.124240e-01,  2.706265e-01, -6.446658e-01,  5.358806e-01},
  { 3.494660e-01, -6.737708e-01,  6.510809e-01,  2.238461e-01, -6.262830e-01,  5.800145e-01},
  { 2.832210e-01, -6.752630e-01,  6.810328e-01,  1.610333e-01, -6.446658e-01,  5.947042e-01},
  { 2.154925e-01, -6.731786e-01,  7.073851e-01,  1.051979e-01, -6.262830e-01,  6.292068e-01},
  { 1.442826e-01, -6.746730e-01,  7.238776e-01,  3.935257e-02, -6.446658e-01,  6.317725e-01},
  { 7.230058e-02, -6.725907e-01,  7.364742e-01, -2.461246e-02, -6.262830e-01,  6.548386e-01},
  {-9.337663e-09, -6.743538e-01,  7.384083e-01, -9.199809e-02, -6.446658e-01,  6.446658e-01},
  {-9.681158e-02, -1.337858e-01,  9.862702e-01, -1.790950e-01, -3.563605e-01,  8.463904e-01},
  {-1.888235e-01, -2.592703e-01,  9.471666e-01, -2.652512e-01, -3.903881e-01,  8.333165e-01},
  {-2.887911e-01, -1.340158e-01,  9.479660e-01, -3.468762e-01, -3.563605e-01,  8.132588e-01},
  {-3.708610e-01, -2.596251e-01,  8.916596e-01, -4.257489e-01, -3.903881e-01,  7.844208e-01},
  {-9.045113e-02, -3.778345e-01,  9.214444e-01, -1.773845e-01, -4.200716e-01,  8.297666e-01},
  {-1.689092e-01, -5.034347e-01,  8.473625e-01, -2.602911e-01, -4.497550e-01,  8.094596e-01},
  {-2.697576e-01, -3.783617e-01,  8.854791e-01, -3.418714e-01, -4.200716e-01,  7.972883e-01},
  {-3.316737e-01, -5.040073e-01,  7.974768e-01, -4.161945e-01, -4.497550e-01,  7.619650e-01},
  {-4.686577e-01, -1.342371e-01,  8.731210e-01, -5.002310e-01, -3.563605e-01,  7.496733e-01},
  {-5.375018e-01, -2.598951e-01,  8.022134e-01, -5.703058e-01, -3.903881e-01,  7.068288e-01},
  {-6.292598e-01, -1.343330e-01,  7.654977e-01, -6.359542e-01, -3.563605e-01,  6.588356e-01},
  {-6.827869e-01, -2.600079e-01,  6.827869e-01, -6.957276e-01, -3.903881e-01,  6.037295e-01},
  {-4.376771e-01, -3.788684e-01,  8.154125e-01, -4.922144e-01, -4.200716e-01,  7.349535e-01},
  {-4.806212e-01, -5.044325e-01,  7.173222e-01, -5.566131e-01, -4.497550e-01,  6.865949e-01},
  {-5.875992e-01, -3.791842e-01,  7.148053e-01, -6.252700e-01, -4.200716e-01,  6.458993e-01},
  {-6.104876e-01, -5.045887e-01,  6.104876e-01, -6.784420e-01, -4.497550e-01,  5.864439e-01},
  {-7.700961e-02, -6.153151e-01,  7.845106e-01, -1.723819e-01, -4.968461e-01,  7.811545e-01},
  {-1.414651e-01, -6.900995e-01,  7.097537e-01, -2.452407e-01, -5.439368e-01,  7.370679e-01},
  {-2.295812e-01, -6.159390e-01,  7.535992e-01, -3.272319e-01, -4.968461e-01,  7.505801e-01},
  {-2.777075e-01, -6.906546e-01,  6.677385e-01, -3.872013e-01, -5.439368e-01,  6.938195e-01},
  {-3.723437e-01, -6.165494e-01,  6.937052e-01, -4.687666e-01, -4.968461e-01,  6.918941e-01},
  {-4.023106e-01, -6.910709e-01,  6.004725e-01, -5.150601e-01, -5.439368e-01,  6.251926e-01},
  {-4.997998e-01, -6.168866e-01,  6.079894e-01, -5.940295e-01, -4.968461e-01,  6.080574e-01},
  {-5.109915e-01, -6.912130e-01,  5.109915e-01, -6.259963e-01, -5.439368e-01,  5.339982e-01},
  {-7.654976e-01, -1.343330e-01,  6.292599e-01, -7.508337e-01, -3.563605e-01,  5.439561e-01},
  {-8.022134e-01, -2.598953e-01,  5.375018e-01, -7.988269e-01, -3.903881e-01,  4.783077e-01},
  {-8.731211e-01, -1.342373e-01,  4.686576e-01, -8.416714e-01, -3.563605e-01,  4.082329e-01},
  {-8.916596e-01, -2.596251e-01,  3.708610e-01, -8.764189e-01, -3.903881e-01,  3.337508e-01},
  {-7.148052e-01, -3.791843e-01,  5.875992e-01, -7.378974e-01, -4.200716e-01,  5.332719e-01},
  {-7.173221e-01, -5.044326e-01,  4.806211e-01, -7.785930e-01, -4.497550e-01,  4.646150e-01},
  {-8.154126e-01, -3.788686e-01,  4.376768e-01, -8.269516e-01, -4.200716e-01,  4.002163e-01},
  {-7.974765e-01, -5.040077e-01,  3.316737e-01, -8.539630e-01, -4.497550e-01,  3.241964e-01},
  {-9.479660e-01, -1.340158e-01,  2.887910e-01, -9.052569e-01, -3.563605e-01,  2.548781e-01},
  {-9.471666e-01, -2.592701e-01,  1.888235e-01, -9.253146e-01, -3.903881e-01,  1.732531e-01},
  {-9.862703e-01, -1.337850e-01,  9.681159e-02, -9.383885e-01, -3.563605e-01,  8.709694e-02},
  {-9.658614e-01, -2.590591e-01,  1.886105e-09, -9.423209e-01, -3.903881e-01,  0.000000e+00},
  {-8.854789e-01, -3.783622e-01,  2.697577e-01, -8.892865e-01, -4.200716e-01,  2.498733e-01},
  {-8.473622e-01, -5.034351e-01,  1.689092e-01, -9.014577e-01, -4.497550e-01,  1.682930e-01},
  {-9.214444e-01, -3.778345e-01,  9.045146e-02, -9.217647e-01, -4.200716e-01,  8.538643e-02},
  {-8.642298e-01, -5.030973e-01,  3.774397e-09, -9.179784e-01, -4.497550e-01,  0.000000e+00},
  {-6.079894e-01, -6.168866e-01,  4.997998e-01, -7.000555e-01, -4.968461e-01,  5.020314e-01},
  {-6.004726e-01, -6.910709e-01,  4.023105e-01, -7.171907e-01, -5.439368e-01,  4.230620e-01},
  {-6.937054e-01, -6.165493e-01,  3.723437e-01, -7.838922e-01, -4.968461e-01,  3.767685e-01},
  {-6.677386e-01, -6.906546e-01,  2.777075e-01, -7.858176e-01, -5.439368e-01,  2.952032e-01},
  {-7.535993e-01, -6.159390e-01,  2.295809e-01, -8.425782e-01, -4.968461e-01,  2.352338e-01},
  {-7.097537e-01, -6.900996e-01,  1.414649e-01, -8.290660e-01, -5.439368e-01,  1.532422e-01},
  {-7.845105e-01, -6.153152e-01,  7.700998e-02, -8.731526e-01, -4.968461e-01,  8.038381e-02},
  {-7.240294e-01, -6.897691e-01,  5.346542e-08, -8.441082e-01, -5.439368e-01,  0.000000e+00},
  {-6.413084e-02, -7.544140e-01,  6.532587e-01, -1.648565e-01, -5.759183e-01,  7.080236e-01},
  {-1.363135e-01, -7.167208e-01,  6.839079e-01, -2.301899e-01, -6.078997e-01,  6.646763e-01},
  {-1.911085e-01, -7.549447e-01,  6.273246e-01, -3.052101e-01, -5.759183e-01,  6.803116e-01},
  {-2.675716e-01, -7.172551e-01,  6.433899e-01, -3.582081e-01, -6.078997e-01,  6.256782e-01},
  {-3.098585e-01, -7.554611e-01,  5.772922e-01, -4.334948e-01, -5.759183e-01,  6.271181e-01},
  {-3.876201e-01, -7.176611e-01,  5.785439e-01, -4.735092e-01, -6.078997e-01,  5.637904e-01},
  {-4.158470e-01, -7.557549e-01,  5.058713e-01, -5.470290e-01, -5.759183e-01,  5.511334e-01},
  {-4.923117e-01, -7.178150e-01,  4.923117e-01, -5.735506e-01, -6.078997e-01,  4.815525e-01},
  {-7.230061e-02, -6.725908e-01,  7.364743e-01, -1.593837e-01, -6.262830e-01,  6.548386e-01},
  {-1.442826e-01, -6.746731e-01,  7.238776e-01, -2.233487e-01, -6.446658e-01,  6.317725e-01},
  {-2.154924e-01, -6.731786e-01,  7.073851e-01, -2.891940e-01, -6.262830e-01,  6.292068e-01},
  {-2.832210e-01, -6.752631e-01,  6.810328e-01, -3.450294e-01, -6.446658e-01,  5.947042e-01},
  {-3.494661e-01, -6.737707e-01,  6.510810e-01, -4.078422e-01, -6.262830e-01,  5.800145e-01},
  {-4.103310e-01, -6.756960e-01,  6.124241e-01, -4.546226e-01, -6.446658e-01,  5.358806e-01},
  {-4.690513e-01, -6.741058e-01,  5.705894e-01, -5.128484e-01, -6.262830e-01,  5.097330e-01},
  {-5.211673e-01, -6.758473e-01,  5.211672e-01, -5.497109e-01, -6.446658e-01,  4.577128e-01},
  {-5.058712e-01, -7.557549e-01,  4.158471e-01, -6.431315e-01, -5.759183e-01,  4.550309e-01},
  {-5.785438e-01, -7.176613e-01,  3.876200e-01, -6.557885e-01, -6.078997e-01,  3.815111e-01},
  {-5.772923e-01, -7.554610e-01,  3.098585e-01, -7.191161e-01, -5.759183e-01,  3.414967e-01},
  {-6.433900e-01, -7.172550e-01,  2.675716e-01, -7.176763e-01, -6.078997e-01,  2.662100e-01},
  {-6.273248e-01, -7.549446e-01,  1.911081e-01, -7.723097e-01, -5.759183e-01,  2.132120e-01},
  {-6.839082e-01, -7.167204e-01,  1.363136e-01, -7.566743e-01, -6.078997e-01,  1.381919e-01},
  {-6.532586e-01, -7.544140e-01,  6.413106e-02, -8.000217e-01, -5.759183e-01,  7.285842e-02},
  {-6.976842e-01, -7.164055e-01,  1.870211e-09, -7.702425e-01, -6.078997e-01,  0.000000e+00},
  {-5.705894e-01, -6.741059e-01,  4.690513e-01, -6.017311e-01, -6.262830e-01,  4.208503e-01},
  {-6.124241e-01, -6.756960e-01,  4.103312e-01, -6.278787e-01, -6.446658e-01,  3.626245e-01},
  {-6.510810e-01, -6.737708e-01,  3.494661e-01, -6.720126e-01, -6.262830e-01,  3.158441e-01},
  {-6.810328e-01, -6.752631e-01,  2.832210e-01, -6.867023e-01, -6.446658e-01,  2.530313e-01},
  {-7.073854e-01, -6.731783e-01,  2.154924e-01, -7.212049e-01, -6.262830e-01,  1.971960e-01},
  {-7.238779e-01, -6.746727e-01,  1.442826e-01, -7.237706e-01, -6.446658e-01,  1.313507e-01},
  {-7.364746e-01, -6.725904e-01,  7.230078e-02, -7.468367e-01, -6.262830e-01,  6.738563e-02},
  {-7.384083e-01, -6.743538e-01, -1.867533e-09, -7.366639e-01, -6.446658e-01,  0.000000e+00},
  {-9.862703e-01, -1.337850e-01, -9.681159e-02, -9.383885e-01, -3.563605e-01, -8.709694e-02},
  {-9.471666e-01, -2.592701e-01, -1.888235e-01, -9.253146e-01, -3.903881e-01, -1.732531e-01},
  {-9.479660e-01, -1.340158e-01, -2.887910e-01, -9.052569e-01, -3.563605e-01, -2.548781e-01},
  {-8.916596e-01, -2.596251e-01, -3.708610e-01, -8.764189e-01, -3.903881e-01, -3.337508e-01},
  {-9.214443e-01, -3.778345e-01, -9.045146e-02, -9.217647e-01, -4.200716e-01, -8.538643e-02},
  {-8.473623e-01, -5.034350e-01, -1.689093e-01, -9.014577e-01, -4.497550e-01, -1.682930e-01},
  {-8.854789e-01, -3.783621e-01, -2.697576e-01, -8.892865e-01, -4.200716e-01, -2.498733e-01},
  {-7.974765e-01, -5.040076e-01, -3.316737e-01, -8.539630e-01, -4.497550e-01, -3.241964e-01},
  {-8.731211e-01, -1.342373e-01, -4.686576e-01, -8.416714e-01, -3.563605e-01, -4.082329e-01},
  {-8.022134e-01, -2.598953e-01, -5.375018e-01, -7.988269e-01, -3.903881e-01, -4.783077e-01},
  {-7.654976e-01, -1.343330e-01, -6.292599e-01, -7.508337e-01, -3.563605e-01, -5.439561e-01},
  {-6.827868e-01, -2.600079e-01, -6.827869e-01, -6.957276e-01, -3.903881e-01, -6.037295e-01},
  {-8.154125e-01, -3.788686e-01, -4.376768e-01, -8.269516e-01, -4.200716e-01, -4.002163e-01},
  {-7.173221e-01, -5.044326e-01, -4.806212e-01, -7.785930e-01, -4.497550e-01, -4.646150e-01},
  {-7.148052e-01, -3.791843e-01, -5.875992e-01, -7.378974e-01, -4.200716e-01, -5.332719e-01},
  {-6.104876e-01, -5.045888e-01, -6.104876e-01, -6.784420e-01, -4.497550e-01, -5.864439e-01},
  {-7.845106e-01, -6.153151e-01, -7.700989e-02, -8.731526e-01, -4.968461e-01, -8.038381e-02},
  {-7.097536e-01, -6.900996e-01, -1.414651e-01, -8.290660e-01, -5.439368e-01, -1.532427e-01},
  {-7.535995e-01, -6.159385e-01, -2.295813e-01, -8.425782e-01, -4.968461e-01, -2.352338e-01},
  {-6.677385e-01, -6.906546e-01, -2.777077e-01, -7.858176e-01, -5.439368e-01, -2.952032e-01},
  {-6.937054e-01, -6.165493e-01, -3.723437e-01, -7.838922e-01, -4.968461e-01, -3.767685e-01},
  {-6.004726e-01, -6.910709e-01, -4.023105e-01, -7.171907e-01, -5.439368e-01, -4.230620e-01},
  {-6.079894e-01, -6.168866e-01, -4.997998e-01, -7.000555e-01, -4.968461e-01, -5.020314e-01},
  {-5.109915e-01, -6.912130e-01, -5.109915e-01, -6.259963e-01, -5.439368e-01, -5.339982e-01},
  {-6.292598e-01, -1.343330e-01, -7.654977e-01, -6.359542e-01, -3.563605e-01, -6.588356e-01},
  {-5.375018e-01, -2.598952e-01, -8.022134e-01, -5.703058e-01, -3.903881e-01, -7.068288e-01},
  {-4.686577e-01, -1.342371e-01, -8.731210e-01, -5.002310e-01, -3.563605e-01, -7.496733e-01},
  {-3.708610e-01, -2.596251e-01, -8.916597e-01, -4.257489e-01, -3.903881e-01, -7.844208e-01},
  {-5.875992e-01, -3.791842e-01, -7.148053e-01, -6.252700e-01, -4.200716e-01, -6.458993e-01},
  {-4.806212e-01, -5.044325e-01, -7.173222e-01, -5.566131e-01, -4.497550e-01, -6.865949e-01},
  {-4.376771e-01, -3.788684e-01, -8.154125e-01, -4.922144e-01, -4.200716e-01, -7.349535e-01},
  {-3.316737e-01, -5.040073e-01, -7.974768e-01, -4.161945e-01, -4.497550e-01, -7.619650e-01},
  {-2.887911e-01, -1.340159e-01, -9.479660e-01, -3.468762e-01, -3.563605e-01, -8.132588e-01},
  {-1.888235e-01, -2.592703e-01, -9.471666e-01, -2.652512e-01, -3.903881e-01, -8.333165e-01},
  {-9.681158e-02, -1.337858e-01, -9.862702e-01, -1.790950e-01, -3.563605e-01, -8.463904e-01},
  {-9.430523e-10, -2.590595e-01, -9.658613e-01, -9.199809e-02, -3.903881e-01, -8.503228e-01},
  {-2.697576e-01, -3.783617e-01, -8.854792e-01, -3.418714e-01, -4.200716e-01, -7.972883e-01},
  {-1.689091e-01, -5.034348e-01, -8.473625e-01, -2.602911e-01, -4.497550e-01, -8.094596e-01},
  {-9.045114e-02, -3.778345e-01, -9.214444e-01, -1.773845e-01, -4.200716e-01, -8.297666e-01},
  {-4.717996e-09, -5.030976e-01, -8.642296e-01, -9.199809e-02, -4.497550e-01, -8.259802e-01},
  {-4.997998e-01, -6.168866e-01, -6.079894e-01, -5.940295e-01, -4.968461e-01, -6.080574e-01},
  {-4.023106e-01, -6.910708e-01, -6.004726e-01, -5.150601e-01, -5.439368e-01, -6.251926e-01},
  {-3.723437e-01, -6.165494e-01, -6.937053e-01, -4.687666e-01, -4.968461e-01, -6.918941e-01},
  {-2.777074e-01, -6.906546e-01, -6.677386e-01, -3.872013e-01, -5.439368e-01, -6.938195e-01},
  {-2.295808e-01, -6.159392e-01, -7.535990e-01, -3.272319e-01, -4.968461e-01, -7.505801e-01},
  {-1.414649e-01, -6.900995e-01, -7.097538e-01, -2.452403e-01, -5.439368e-01, -7.370679e-01},
  {-7.700969e-02, -6.153152e-01, -7.845105e-01, -1.723819e-01, -4.968461e-01, -7.811545e-01},
  {-5.346542e-08, -6.897689e-01, -7.240296e-01, -9.199809e-02, -5.439368e-01, -7.521101e-01},
  {-6.532585e-01, -7.544141e-01, -6.413095e-02, -8.000217e-01, -5.759183e-01, -7.285842e-02},
  {-6.839081e-01, -7.167206e-01, -1.363136e-01, -7.566743e-01, -6.078997e-01, -1.381919e-01},
  {-6.273245e-01, -7.549449e-01, -1.911083e-01, -7.723097e-01, -5.759183e-01, -2.132120e-01},
  {-6.433900e-01, -7.172550e-01, -2.675716e-01, -7.176763e-01, -6.078997e-01, -2.662100e-01},
  {-5.772923e-01, -7.554611e-01, -3.098585e-01, -7.191161e-01, -5.759183e-01, -3.414967e-01},
  {-5.785439e-01, -7.176613e-01, -3.876200e-01, -6.557885e-01, -6.078997e-01, -3.815111e-01},
  {-5.058713e-01, -7.557549e-01, -4.158471e-01, -6.431315e-01, -5.759183e-01, -4.550309e-01},
  {-4.923117e-01, -7.178150e-01, -4.923117e-01, -5.735506e-01, -6.078997e-01, -4.815525e-01},
  {-7.364746e-01, -6.725904e-01, -7.230078e-02, -7.468367e-01, -6.262830e-01, -6.738563e-02},
  {-7.238778e-01, -6.746727e-01, -1.442827e-01, -7.237706e-01, -6.446658e-01, -1.313507e-01},
  {-7.073854e-01, -6.731783e-01, -2.154924e-01, -7.212049e-01, -6.262830e-01, -1.971960e-01},
  {-6.810328e-01, -6.752631e-01, -2.832211e-01, -6.867023e-01, -6.446658e-01, -2.530313e-01},
  {-6.510810e-01, -6.737708e-01, -3.494661e-01, -6.720126e-01, -6.262830e-01, -3.158441e-01},
  {-6.124241e-01, -6.756960e-01, -4.103312e-01, -6.278787e-01, -6.446658e-01, -3.626245e-01},
  {-5.705893e-01, -6.741059e-01, -4.690513e-01, -6.017311e-01, -6.262830e-01, -4.208503e-01},
  {-5.211672e-01, -6.758473e-01, -5.211671e-01, -5.497109e-01, -6.446658e-01, -4.577128e-01},
  {-4.158470e-01, -7.557550e-01, -5.058713e-01, -5.470290e-01, -5.759183e-01, -5.511334e-01},
  {-3.876201e-01, -7.176611e-01, -5.785440e-01, -4.735092e-01, -6.078997e-01, -5.637904e-01},
  {-3.098585e-01, -7.554610e-01, -5.772923e-01, -4.334948e-01, -5.759183e-01, -6.271181e-01},
  {-2.675715e-01, -7.172551e-01, -6.433899e-01, -3.582081e-01, -6.078997e-01, -6.256782e-01},
  {-1.911083e-01, -7.549444e-01, -6.273249e-01, -3.052101e-01, -5.759183e-01, -6.803116e-01},
  {-1.363135e-01, -7.167206e-01, -6.839080e-01, -2.301899e-01, -6.078997e-01, -6.646763e-01},
  {-6.413094e-02, -7.544139e-01, -6.532587e-01, -1.648565e-01, -5.759183e-01, -7.080236e-01},
  {-7.480842e-09, -7.164055e-01, -6.976842e-01, -9.199809e-02, -6.078997e-01, -6.782444e-01},
  {-4.690513e-01, -6.741058e-01, -5.705894e-01, -5.128484e-01, -6.262830e-01, -5.097330e-01},
  {-4.103311e-01, -6.756960e-01, -6.124241e-01, -4.546226e-01, -6.446658e-01, -5.358806e-01},
  {-3.494662e-01, -6.737707e-01, -6.510810e-01, -4.078422e-01, -6.262830e-01, -5.800145e-01},
  {-2.832210e-01, -6.752631e-01, -6.810328e-01, -3.450294e-01, -6.446658e-01, -5.947042e-01},
  {-2.154924e-01, -6.731786e-01, -7.073851e-01, -2.891940e-01, -6.262830e-01, -6.292068e-01},
  {-1.442826e-01, -6.746730e-01, -7.238776e-01, -2.233487e-01, -6.446658e-01, -6.317725e-01},
  {-7.230060e-02, -6.725907e-01, -7.364743e-01, -1.593837e-01, -6.262830e-01, -6.548386e-01},
  {-7.470131e-09, -6.743538e-01, -7.384083e-01, -9.199809e-02, -6.446658e-01, -6.446658e-01},
  { 9.681159e-02, -1.337858e-01, -9.862702e-01, -4.901157e-03, -3.563605e-01, -8.463904e-01},
  { 1.888235e-01, -2.592703e-01, -9.471666e-01,  8.125499e-02, -3.903881e-01, -8.333165e-01},
  { 2.887910e-01, -1.340159e-01, -9.479660e-01,  1.628800e-01, -3.563605e-01, -8.132588e-01},
  { 3.708609e-01, -2.596251e-01, -8.916597e-01,  2.417527e-01, -3.903881e-01, -7.844208e-01},
  { 9.045114e-02, -3.778345e-01, -9.214444e-01, -6.611669e-03, -4.200716e-01, -8.297666e-01},
  { 1.689092e-01, -5.034347e-01, -8.473625e-01,  7.629494e-02, -4.497550e-01, -8.094596e-01},
  { 2.697576e-01, -3.783617e-01, -8.854791e-01,  1.578753e-01, -4.200716e-01, -7.972883e-01},
  { 3.316737e-01, -5.040074e-01, -7.974767e-01,  2.321983e-01, -4.497550e-01, -7.619650e-01},
  { 4.686577e-01, -1.342370e-01, -8.731211e-01,  3.162348e-01, -3.563605e-01, -7.496733e-01},
  { 5.375019e-01, -2.598953e-01, -8.022134e-01,  3.863096e-01, -3.903881e-01, -7.068288e-01},
  { 6.292598e-01, -1.343333e-01, -7.654977e-01,  4.519580e-01, -3.563605e-01, -6.588356e-01},
  { 6.827868e-01, -2.600081e-01, -6.827869e-01,  5.117314e-01, -3.903881e-01, -6.037295e-01},
  { 4.376771e-01, -3.788686e-01, -8.154124e-01,  3.082182e-01, -4.200716e-01, -7.349535e-01},
  { 4.806212e-01, -5.044326e-01, -7.173221e-01,  3.726169e-01, -4.497550e-01, -6.865949e-01},
  { 5.875992e-01, -3.791843e-01, -7.148052e-01,  4.412738e-01, -4.200716e-01, -6.458993e-01},
  { 6.104876e-01, -5.045887e-01, -6.104877e-01,  4.944458e-01, -4.497550e-01, -5.864439e-01},
  { 7.700960e-02, -6.153151e-01, -7.845106e-01, -1.161428e-02, -4.968461e-01, -7.811545e-01},
  { 1.414651e-01, -6.900995e-01, -7.097537e-01,  6.124457e-02, -5.439368e-01, -7.370679e-01},
  { 2.295812e-01, -6.159388e-01, -7.535993e-01,  1.432358e-01, -4.968461e-01, -7.505801e-01},
  { 2.777076e-01, -6.906546e-01, -6.677385e-01,  2.032051e-01, -5.439368e-01, -6.938195e-01},
  { 3.723438e-01, -6.165494e-01, -6.937052e-01,  2.847704e-01, -4.968461e-01, -6.918941e-01},
  { 4.023106e-01, -6.910708e-01, -6.004726e-01,  3.310639e-01, -5.439368e-01, -6.251926e-01},
  { 4.997998e-01, -6.168866e-01, -6.079894e-01,  4.100333e-01, -4.968461e-01, -6.080574e-01},
  { 5.109915e-01, -6.912129e-01, -5.109915e-01,  4.420001e-01, -5.439368e-01, -5.339982e-01},
  { 7.654976e-01, -1.343330e-01, -6.292599e-01,  5.668375e-01, -3.563605e-01, -5.439561e-01},
  { 8.022133e-01, -2.598953e-01, -5.375019e-01,  6.148307e-01, -3.903881e-01, -4.783077e-01},
  { 8.731212e-01, -1.342366e-01, -4.686576e-01,  6.576753e-01, -3.563605e-01, -4.082329e-01},
  { 8.916597e-01, -2.596253e-01, -3.708608e-01,  6.924227e-01, -3.903881e-01, -3.337508e-01},
  { 7.148050e-01, -3.791843e-01, -5.875994e-01,  5.539012e-01, -4.200716e-01, -5.332719e-01},
  { 7.173222e-01, -5.044326e-01, -4.806212e-01,  5.945969e-01, -4.497550e-01, -4.646150e-01},
  { 8.154126e-01, -3.788686e-01, -4.376768e-01,  6.429554e-01, -4.200716e-01, -4.002163e-01},
  { 7.974768e-01, -5.040073e-01, -3.316737e-01,  6.699669e-01, -4.497550e-01, -3.241964e-01},
  { 9.479659e-01, -1.340158e-01, -2.887913e-01,  7.212607e-01, -3.563605e-01, -2.548781e-01},
  { 9.471666e-01, -2.592706e-01, -1.888235e-01,  7.413185e-01, -3.903881e-01, -1.732531e-01},
  { 9.862702e-01, -1.337858e-01, -9.681125e-02,  7.543923e-01, -3.563605e-01, -8.709694e-02},
  { 8.854789e-01, -3.783621e-01, -2.697577e-01,  7.052902e-01, -4.200716e-01, -2.498733e-01},
  { 8.473625e-01, -5.034348e-01, -1.689091e-01,  7.174615e-01, -4.497550e-01, -1.682930e-01},
  { 9.214442e-01, -3.778349e-01, -9.045097e-02,  7.377685e-01, -4.200716e-01, -8.538643e-02},
  { 6.079893e-01, -6.168867e-01, -4.997999e-01,  5.160593e-01, -4.968461e-01, -5.020314e-01},
  { 6.004726e-01, -6.910709e-01, -4.023106e-01,  5.331945e-01, -5.439368e-01, -4.230620e-01},
  { 6.937052e-01, -6.165496e-01, -3.723436e-01,  5.998960e-01, -4.968461e-01, -3.767685e-01},
  { 6.677385e-01, -6.906546e-01, -2.777075e-01,  6.018214e-01, -5.439368e-01, -2.952032e-01},
  { 7.535991e-01, -6.159392e-01, -2.295808e-01,  6.585821e-01, -4.968461e-01, -2.352338e-01},
  { 7.097536e-01, -6.900997e-01, -1.414649e-01,  6.450698e-01, -5.439368e-01, -1.532422e-01},
  { 7.845106e-01, -6.153151e-01, -7.700986e-02,  6.891564e-01, -4.968461e-01, -8.038381e-02},
  { 6.413084e-02, -7.544140e-01, -6.532587e-01, -1.913968e-02, -5.759183e-01, -7.080236e-01},
  { 1.363135e-01, -7.167208e-01, -6.839079e-01,  4.619377e-02, -6.078997e-01, -6.646763e-01},
  { 1.911085e-01, -7.549447e-01, -6.273245e-01,  1.212140e-01, -5.759183e-01, -6.803116e-01},
  { 2.675716e-01, -7.172551e-01, -6.433899e-01,  1.742119e-01, -6.078997e-01, -6.256782e-01},
  { 3.098585e-01, -7.554610e-01, -5.772923e-01,  2.494986e-01, -5.759183e-01, -6.271181e-01},
  { 3.876200e-01, -7.176613e-01, -5.785439e-01,  2.895130e-01, -6.078997e-01, -5.637904e-01},
  { 4.158471e-01, -7.557548e-01, -5.058713e-01,  3.630329e-01, -5.759183e-01, -5.511334e-01},
  { 4.923117e-01, -7.178150e-01, -4.923117e-01,  3.895544e-01, -6.078997e-01, -4.815525e-01},
  { 7.230059e-02, -6.725907e-01, -7.364742e-01, -2.461246e-02, -6.262830e-01, -6.548386e-01},
  { 1.442826e-01, -6.746731e-01, -7.238776e-01,  3.935257e-02, -6.446658e-01, -6.317725e-01},
  { 2.154925e-01, -6.731786e-01, -7.073851e-01,  1.051979e-01, -6.262830e-01, -6.292068e-01},
  { 2.832211e-01, -6.752631e-01, -6.810328e-01,  1.610333e-01, -6.446658e-01, -5.947042e-01},
  { 3.494661e-01, -6.737708e-01, -6.510809e-01,  2.238461e-01, -6.262830e-01, -5.800145e-01},
  { 4.103310e-01, -6.756961e-01, -6.124240e-01,  2.706265e-01, -6.446658e-01, -5.358806e-01},
  { 4.690513e-01, -6.741060e-01, -5.705893e-01,  3.288522e-01, -6.262830e-01, -5.097330e-01},
  { 5.211670e-01, -6.758476e-01, -5.211670e-01,  3.657147e-01, -6.446658e-01, -4.577128e-01},
  { 5.058713e-01, -7.557548e-01, -4.158471e-01,  4.591353e-01, -5.759183e-01, -4.550309e-01},
  { 5.785439e-01, -7.176612e-01, -3.876200e-01,  4.717923e-01, -6.078997e-01, -3.815111e-01},
  { 5.772923e-01, -7.554609e-01, -3.098587e-01,  5.351200e-01, -5.759183e-01, -3.414967e-01},
  { 6.433897e-01, -7.172553e-01, -2.675715e-01,  5.336802e-01, -6.078997e-01, -2.662100e-01},
  { 6.273251e-01, -7.549443e-01, -1.911082e-01,  5.883135e-01, -5.759183e-01, -2.132120e-01},
  { 6.839081e-01, -7.167205e-01, -1.363135e-01,  5.726782e-01, -6.078997e-01, -1.381919e-01},
  { 6.532586e-01, -7.544140e-01, -6.413106e-02,  6.160255e-01, -5.759183e-01, -7.285842e-02},
  { 5.705894e-01, -6.741059e-01, -4.690513e-01,  4.177349e-01, -6.262830e-01, -4.208503e-01},
  { 6.124242e-01, -6.756960e-01, -4.103310e-01,  4.438826e-01, -6.446658e-01, -3.626245e-01},
  { 6.510808e-01, -6.737710e-01, -3.494661e-01,  4.880164e-01, -6.262830e-01, -3.158441e-01},
  { 6.810326e-01, -6.752633e-01, -2.832209e-01,  5.027061e-01, -6.446658e-01, -2.530313e-01},
  { 7.073848e-01, -6.731789e-01, -2.154922e-01,  5.372087e-01, -6.262830e-01, -1.971960e-01},
  { 7.238773e-01, -6.746734e-01, -1.442827e-01,  5.397744e-01, -6.446658e-01, -1.313507e-01},
  { 7.364742e-01, -6.725908e-01, -7.230060e-02,  5.628406e-01, -6.262830e-01, -6.738563e-02},
  { 7.705962e-03, -9.792724e-01,  2.024013e-01, -8.798528e-01,  1.679053e-01,  3.626245e-02},
  { 7.709252e-03, -9.999703e-01, -3.804368e-09, -7.796417e-01,  1.611665e-01,  0.000000e+00},
  { 6.912022e-03, -8.409641e-01,  5.410468e-01, -7.729285e-01,  1.762774e-01,  7.252491e-02},
  { 3.624916e-02, -8.402575e-01,  5.409744e-01, -9.864074e-01,  1.745282e-01,  7.252491e-02},
  { 4.027378e-02, -9.991887e-01, -1.522385e-08, -9.804293e-01,  1.596536e-01,  0.000000e+00},
  { 5.206649e-03, -5.912646e-01,  8.064608e-01, -8.792639e-01,  1.918913e-01,  8.461239e-02},
  {-1.930824e-04,  8.536322e-05,  1.000000e+00, -7.581528e-01,  2.095164e-01,  9.669987e-02},
  {-1.094472e-03, -2.882688e-04,  9.999993e-01, -9.995672e-01,  2.072514e-01,  9.669987e-02},
  { 7.299080e-02, -9.771793e-01,  1.994817e-01, -1.059693e+00,  1.613899e-01,  3.626245e-02},
  { 1.648182e-01, -8.082523e-01,  5.652990e-01, -1.143104e+00,  1.623011e-01,  7.252491e-02},
  { 1.941785e-01, -9.809662e-01,  9.571551e-09, -1.128836e+00,  1.490768e-01,  0.000000e+00},
  { 5.011506e-02, -5.928440e-01,  8.037565e-01, -1.075896e+00,  1.838673e-01,  8.461239e-02},
  {-1.385219e-03,  4.237015e-03,  9.999901e-01, -1.174500e+00,  1.913841e-01,  9.669987e-02},
  {-5.838416e-03,  5.912955e-01,  8.064338e-01, -8.784561e-01,  2.248724e-01,  8.461239e-02},
  {-8.677714e-03,  8.410172e-01,  5.409388e-01, -7.433813e-01,  2.427554e-01,  7.252491e-02},
  {-4.637923e-02,  8.388014e-01,  5.424585e-01, -1.012723e+00,  2.399705e-01,  7.252491e-02},
  {-1.030979e-02,  9.792522e-01,  2.023831e-01, -8.778672e-01,  2.488582e-01,  3.626245e-02},
  {-1.062463e-02,  9.999436e-01,  0.000000e+00, -7.366639e-01,  2.578663e-01,  0.000000e+00},
  {-5.707712e-02,  9.983698e-01, -3.809209e-09, -1.018705e+00,  2.548450e-01,  0.000000e+00},
  {-5.657349e-02,  5.896515e-01,  8.056740e-01, -1.098171e+00,  2.147683e-01,  8.461239e-02},
  {-1.593001e-01,  8.116404e-01,  5.620171e-01, -1.205895e+00,  2.204714e-01,  7.252491e-02},
  {-1.003248e-01,  9.740934e-01,  2.026747e-01, -1.114369e+00,  2.372456e-01,  3.626245e-02},
  {-1.993572e-01,  9.799269e-01, -7.638667e-09, -1.220163e+00,  2.336914e-01,  0.000000e+00},
  { 3.229107e-01, -9.324754e-01,  1.619207e-01, -1.178135e+00,  1.371849e-01,  2.077801e-02},
  { 3.367523e-01, -9.134900e-01,  2.283285e-01, -1.136864e+00,  1.565163e-01,  4.080520e-02},
  { 5.298759e-01, -8.094130e-01,  2.531443e-01, -1.226000e+00,  1.227745e-01,  4.230641e-02},
  { 5.292650e-01, -8.484566e-01,  0.000000e+00, -1.220834e+00,  1.203720e-01,  0.000000e+00},
  { 3.277441e-01, -9.017841e-01,  2.817257e-01, -1.186396e+00,  1.426731e-01,  5.704047e-02},
  { 4.230156e-01, -6.294655e-01,  6.517906e-01, -1.239615e+00,  1.291051e-01,  7.252491e-02},
  { 1.565209e-01, -5.047300e-01,  8.489693e-01, -1.187823e+00,  1.678667e-01,  8.461239e-02},
  {-1.423384e-02,  1.562000e-02,  9.997767e-01, -1.236405e+00,  1.741028e-01,  9.669987e-02},
  { 1.757473e-01, -4.850179e-01,  8.566625e-01, -1.197269e+00,  1.436702e-01,  7.252491e-02},
  { 2.187296e-01, -4.780649e-01,  8.506535e-01, -1.238558e+00,  1.488018e-01,  8.461239e-02},
  {-1.020431e-02, -9.926390e-03,  9.998986e-01, -1.280938e+00,  1.483247e-01,  9.669987e-02},
  { 7.130723e-01, -6.906927e-01,  1.202976e-01, -1.235283e+00,  1.093224e-01,  2.115321e-02},
  { 8.418382e-01, -4.590274e-01,  2.839051e-01, -1.249874e+00,  9.775714e-02,  4.230641e-02},
  { 8.735464e-01, -4.867408e-01, -5.835159e-09, -1.244420e+00,  9.638613e-02,  0.000000e+00},
  { 6.705844e-01, -6.169536e-01,  4.119281e-01, -1.244931e+00,  1.127520e-01,  5.741566e-02},
  { 6.431714e-01, -3.314286e-01,  6.902794e-01, -1.264241e+00,  1.013716e-01,  7.252491e-02},
  { 9.629416e-01, -2.368867e-01,  1.289505e-01, -1.251159e+00,  8.076803e-02,  2.115321e-02},
  { 9.575335e-01, -2.221843e-02,  2.874645e-01, -1.257936e+00,  6.446657e-02,  4.230641e-02},
  { 9.996417e-01, -2.676602e-02,  0.000000e+00, -1.252397e+00,  6.446657e-02,  0.000000e+00},
  { 8.777778e-01, -2.048411e-01,  4.330661e-01, -1.261147e+00,  8.201438e-02,  5.741566e-02},
  { 7.217255e-01, -1.019706e-02,  6.921043e-01, -1.272545e+00,  6.446657e-02,  7.252491e-02},
  { 3.841035e-01, -3.120553e-01,  8.689568e-01, -1.273159e+00,  1.227873e-01,  8.461239e-02},
  {-2.174894e-03, -6.787659e-03,  9.999746e-01, -1.307838e+00,  1.123438e-01,  9.669987e-02},
  { 4.703838e-01, -9.668516e-02,  8.771495e-01, -1.290372e+00,  8.566318e-02,  8.461239e-02},
  { 3.683390e-03,  2.370979e-03,  9.999903e-01, -1.316863e+00,  6.446657e-02,  9.669987e-02},
  {-1.592558e-01,  5.371441e-01,  8.283198e-01, -1.222630e+00,  1.962965e-01,  8.461239e-02},
  {-3.203270e-01,  6.996033e-01,  6.387064e-01, -1.273713e+00,  1.992275e-01,  7.252491e-02},
  {-2.739325e-01,  4.446260e-01,  8.528005e-01, -1.278329e+00,  1.722977e-01,  8.461239e-02},
  {-5.139598e-01,  5.237850e-01,  6.793339e-01, -1.322257e+00,  1.675401e-01,  7.252491e-02},
  {-2.578716e-01,  9.226407e-01,  2.867688e-01, -1.244437e+00,  2.133672e-01,  5.704047e-02},
  {-2.507230e-01,  9.423517e-01,  2.216106e-01, -1.212135e+00,  2.262519e-01,  4.080520e-02},
  {-3.991394e-01,  8.825446e-01,  2.486018e-01, -1.286010e+00,  2.075094e-01,  4.230641e-02},
  {-2.729559e-01,  9.481803e-01,  1.626324e-01, -1.252246e+00,  2.195260e-01,  2.077801e-02},
  {-4.332016e-01,  9.012970e-01, -1.899832e-08, -1.290673e+00,  2.106510e-01,  0.000000e+00},
  {-5.064258e-01,  7.630391e-01,  4.016271e-01, -1.304464e+00,  1.870390e-01,  5.741566e-02},
  {-6.863260e-01,  6.717725e-01,  2.787083e-01, -1.335872e+00,  1.738750e-01,  4.230641e-02},
  {-5.575084e-01,  8.216562e-01,  1.185983e-01, -1.313399e+00,  1.920761e-01,  2.115321e-02},
  {-7.189146e-01,  6.950984e-01,  1.917225e-09, -1.341038e+00,  1.762774e-01,  0.000000e+00},
  {-3.983509e-01,  2.793092e-01,  8.736721e-01, -1.315617e+00,  1.378811e-01,  8.461239e-02},
  {-6.696070e-01,  2.648785e-01,  6.938774e-01, -1.351439e+00,  1.233160e-01,  7.252491e-02},
  {-4.721997e-01,  8.333085e-02,  8.775440e-01, -1.334334e+00,  9.114715e-02,  8.461239e-02},
  {-7.205643e-01,  2.146300e-02,  6.930558e-01, -1.361186e+00,  6.446657e-02,  7.252491e-02},
  {-7.569621e-01,  4.909361e-01,  4.312658e-01, -1.343845e+00,  1.479164e-01,  5.741566e-02},
  {-8.944904e-01,  3.408820e-01,  2.892860e-01, -1.365806e+00,  1.269304e-01,  4.230641e-02},
  {-8.376388e-01,  5.308312e-01,  1.287620e-01, -1.353493e+00,  1.513460e-01,  2.115321e-02},
  {-9.357955e-01,  3.525434e-01,  7.670931e-09, -1.371256e+00,  1.283014e-01,  0.000000e+00},
  {-8.888712e-01,  1.446105e-01,  4.347365e-01, -1.363554e+00,  9.479595e-02,  5.741566e-02},
  {-9.575247e-01,  2.885930e-02,  2.869036e-01, -1.375790e+00,  6.446657e-02,  4.230641e-02},
  {-9.792791e-01,  1.555270e-01,  1.297066e-01, -1.373546e+00,  9.604231e-02,  2.115321e-02},
  {-9.995729e-01,  2.922269e-02,  3.787600e-09, -1.381330e+00,  6.446657e-02,  0.000000e+00},
  {-1.030979e-02,  9.792522e-01, -2.023831e-01, -8.778672e-01,  2.488582e-01, -3.626245e-02},
  {-8.677715e-03,  8.410172e-01, -5.409388e-01, -7.433813e-01,  2.427554e-01, -7.252491e-02},
  {-4.637923e-02,  8.388014e-01, -5.424585e-01, -1.012723e+00,  2.399705e-01, -7.252491e-02},
  {-5.838417e-03,  5.912955e-01, -8.064338e-01, -8.784561e-01,  2.248724e-01, -8.461239e-02},
  {-1.930841e-04,  8.534475e-05, -1.000000e+00, -7.581528e-01,  2.095164e-01, -9.669987e-02},
  {-1.094473e-03, -2.882872e-04, -9.999993e-01, -9.995672e-01,  2.072514e-01, -9.669987e-02},
  {-1.003248e-01,  9.740934e-01, -2.026747e-01, -1.114369e+00,  2.372456e-01, -3.626245e-02},
  {-1.593001e-01,  8.116404e-01, -5.620171e-01, -1.205895e+00,  2.204714e-01, -7.252491e-02},
  {-5.657349e-02,  5.896515e-01, -8.056741e-01, -1.098171e+00,  2.147683e-01, -8.461239e-02},
  {-1.385217e-03,  4.236987e-03, -9.999901e-01, -1.174500e+00,  1.913841e-01, -9.669987e-02},
  { 5.206649e-03, -5.912646e-01, -8.064608e-01, -8.792639e-01,  1.918913e-01, -8.461239e-02},
  { 6.912021e-03, -8.409641e-01, -5.410468e-01, -7.729285e-01,  1.762774e-01, -7.252491e-02},
  { 3.624916e-02, -8.402575e-01, -5.409744e-01, -9.864074e-01,  1.745282e-01, -7.252491e-02},
  { 7.705961e-03, -9.792724e-01, -2.024013e-01, -8.798528e-01,  1.679053e-01, -3.626245e-02},
  { 5.011505e-02, -5.928439e-01, -8.037565e-01, -1.075896e+00,  1.838673e-01, -8.461239e-02},
  { 1.648183e-01, -8.082523e-01, -5.652990e-01, -1.143104e+00,  1.623011e-01, -7.252491e-02},
  { 7.299081e-02, -9.771793e-01, -1.994817e-01, -1.059693e+00,  1.613899e-01, -3.626245e-02},
  {-2.729559e-01,  9.481803e-01, -1.626324e-01, -1.252246e+00,  2.195260e-01, -2.077801e-02},
  {-2.507230e-01,  9.423517e-01, -2.216106e-01, -1.212135e+00,  2.262519e-01, -4.080520e-02},
  {-3.991394e-01,  8.825446e-01, -2.486018e-01, -1.286010e+00,  2.075094e-01, -4.230641e-02},
  {-2.578716e-01,  9.226407e-01, -2.867688e-01, -1.244437e+00,  2.133672e-01, -5.704047e-02},
  {-3.203270e-01,  6.996033e-01, -6.387064e-01, -1.273713e+00,  1.992275e-01, -7.252491e-02},
  {-5.575083e-01,  8.216562e-01, -1.185983e-01, -1.313399e+00,  1.920761e-01, -2.115321e-02},
  {-6.863261e-01,  6.717725e-01, -2.787083e-01, -1.335872e+00,  1.738750e-01, -4.230641e-02},
  {-5.064259e-01,  7.630390e-01, -4.016271e-01, -1.304464e+00,  1.870390e-01, -5.741566e-02},
  {-5.139598e-01,  5.237851e-01, -6.793339e-01, -1.322257e+00,  1.675401e-01, -7.252491e-02},
  {-1.592558e-01,  5.371441e-01, -8.283198e-01, -1.222630e+00,  1.962965e-01, -8.461239e-02},
  {-1.423383e-02,  1.561997e-02, -9.997767e-01, -1.236405e+00,  1.741028e-01, -9.669987e-02},
  {-2.739325e-01,  4.446260e-01, -8.528004e-01, -1.278329e+00,  1.722977e-01, -8.461239e-02},
  {-1.020430e-02, -9.926395e-03, -9.998987e-01, -1.280938e+00,  1.483247e-01, -9.669987e-02},
  {-8.376388e-01,  5.308312e-01, -1.287619e-01, -1.353493e+00,  1.513460e-01, -2.115321e-02},
  {-8.944904e-01,  3.408820e-01, -2.892860e-01, -1.365806e+00,  1.269304e-01, -4.230641e-02},
  {-7.569621e-01,  4.909361e-01, -4.312658e-01, -1.343845e+00,  1.479164e-01, -5.741566e-02},
  {-6.696070e-01,  2.648784e-01, -6.938773e-01, -1.351439e+00,  1.233160e-01, -7.252491e-02},
  {-9.792791e-01,  1.555270e-01, -1.297066e-01, -1.373546e+00,  9.604231e-02, -2.115321e-02},
  {-9.575247e-01,  2.885930e-02, -2.869036e-01, -1.375790e+00,  6.446657e-02, -4.230641e-02},
  {-8.888713e-01,  1.446106e-01, -4.347364e-01, -1.363554e+00,  9.479595e-02, -5.741566e-02},
  {-7.205643e-01,  2.146300e-02, -6.930558e-01, -1.361186e+00,  6.446657e-02, -7.252491e-02},
  {-3.983509e-01,  2.793092e-01, -8.736721e-01, -1.315617e+00,  1.378811e-01, -8.461239e-02},
  {-2.174907e-03, -6.787676e-03, -9.999746e-01, -1.307838e+00,  1.123438e-01, -9.669987e-02},
  {-4.721997e-01,  8.333085e-02, -8.775439e-01, -1.334334e+00,  9.114715e-02, -8.461239e-02},
  { 3.683390e-03,  2.370989e-03, -9.999903e-01, -1.316863e+00,  6.446657e-02, -9.669987e-02},
  { 1.565209e-01, -5.047300e-01, -8.489692e-01, -1.187823e+00,  1.678667e-01, -8.461239e-02},
  { 1.757473e-01, -4.850179e-01, -8.566625e-01, -1.197269e+00,  1.436702e-01, -7.252491e-02},
  { 2.187296e-01, -4.780649e-01, -8.506535e-01, -1.238558e+00,  1.488018e-01, -8.461239e-02},
  { 4.230156e-01, -6.294655e-01, -6.517906e-01, -1.239615e+00,  1.291051e-01, -7.252491e-02},
  { 3.277442e-01, -9.017841e-01, -2.817257e-01, -1.186396e+00,  1.426731e-01, -5.704047e-02},
  { 3.367523e-01, -9.134900e-01, -2.283285e-01, -1.136864e+00,  1.565163e-01, -4.080520e-02},
  { 5.298759e-01, -8.094130e-01, -2.531443e-01, -1.226000e+00,  1.227745e-01, -4.230641e-02},
  { 3.229107e-01, -9.324754e-01, -1.619207e-01, -1.178135e+00,  1.371849e-01, -2.077801e-02},
  { 3.841035e-01, -3.120553e-01, -8.689568e-01, -1.273159e+00,  1.227873e-01, -8.461239e-02},
  { 6.431714e-01, -3.314285e-01, -6.902794e-01, -1.264241e+00,  1.013716e-01, -7.252491e-02},
  { 4.703837e-01, -9.668513e-02, -8.771495e-01, -1.290372e+00,  8.566318e-02, -8.461239e-02},
  { 7.217255e-01, -1.019706e-02, -6.921043e-01, -1.272545e+00,  6.446657e-02, -7.252491e-02},
  { 6.705845e-01, -6.169536e-01, -4.119281e-01, -1.244931e+00,  1.127520e-01, -5.741566e-02},
  { 8.418382e-01, -4.590275e-01, -2.839051e-01, -1.249874e+00,  9.775714e-02, -4.230641e-02},
  { 7.130723e-01, -6.906927e-01, -1.202976e-01, -1.235283e+00,  1.093224e-01, -2.115321e-02},
  { 8.777778e-01, -2.048410e-01, -4.330661e-01, -1.261147e+00,  8.201438e-02, -5.741566e-02},
  { 9.575335e-01, -2.221842e-02, -2.874645e-01, -1.257936e+00,  6.446657e-02, -4.230641e-02},
  { 9.629416e-01, -2.368867e-01, -1.289505e-01, -1.251159e+00,  8.076803e-02, -2.115321e-02},
  { 9.741461e-01,  1.869392e-01,  1.268586e-01, -1.246646e+00,  2.006629e-02,  2.115321e-02},
  { 9.133146e-01,  2.973460e-01,  2.782836e-01, -1.240642e+00, -2.549437e-02,  4.230641e-02},
  { 9.485409e-01,  3.166545e-01,  1.898846e-09, -1.235610e+00, -2.316930e-02,  0.000000e+00},
  { 8.878496e-01,  1.714007e-01,  4.270187e-01, -1.256260e+00,  1.795179e-02,  5.741566e-02},
  { 6.941422e-01,  2.433121e-01,  6.774703e-01, -1.253918e+00, -3.162732e-02,  7.252491e-02},
  { 4.783988e-01,  9.366331e-02,  8.731333e-01, -1.284381e+00,  1.176730e-02,  8.461239e-02},
  { 9.534942e-03,  4.176756e-04,  9.999545e-01, -1.294201e+00, -5.023664e-02,  9.669987e-02},
  { 8.872037e-01,  4.243551e-01,  1.810865e-01, -1.212178e+00, -7.845581e-02,  2.081755e-02},
  { 8.773020e-01,  4.121228e-01,  2.459594e-01, -1.189907e+00, -1.362222e-01,  4.096422e-02},
  { 8.295026e-01,  5.585030e-01,  9.639041e-09, -1.182558e+00, -1.289331e-01,  0.000000e+00},
  { 8.450963e-01,  4.150167e-01,  3.370065e-01, -1.220008e+00, -8.379798e-02,  5.708000e-02},
  { 6.517141e-01,  4.637395e-01,  6.001786e-01, -1.195567e+00, -1.418394e-01,  7.252491e-02},
  { 4.400099e-01,  2.450105e-01,  8.639219e-01, -1.241970e+00, -9.848347e-02,  8.461239e-02},
  { 8.735455e-03, -5.950635e-03,  9.999442e-01, -1.224195e+00, -1.702305e-01,  9.669987e-02},
  {-4.546248e-01, -6.630503e-02,  8.882117e-01, -1.334647e+00,  3.399538e-02,  8.461239e-02},
  {-6.969652e-01, -1.384261e-01,  7.036176e-01, -1.354555e+00, -2.376668e-03,  7.252491e-02},
  {-4.396287e-01, -8.683572e-02,  8.939721e-01, -1.305990e+00,  9.429310e-03,  9.669987e-02},
  {-4.458990e-01, -1.118261e-01,  8.880703e-01, -1.322304e+00, -2.800860e-02,  8.461239e-02},
  {-6.729468e-01, -2.775104e-01,  6.856607e-01, -1.334480e+00, -6.885031e-02,  7.252491e-02},
  {-8.967127e-01, -8.885379e-02,  4.336028e-01, -1.365088e+00,  3.015749e-02,  5.741566e-02},
  {-9.392973e-01, -1.877273e-01,  2.871919e-01, -1.368823e+00, -5.926633e-03,  4.230641e-02},
  {-9.867886e-01, -9.760351e-02,  1.293133e-01, -1.375046e+00,  2.893260e-02,  2.115321e-02},
  {-9.805122e-01, -1.964585e-01, -5.663380e-09, -1.374238e+00, -7.271818e-03,  0.000000e+00},
  {-8.617655e-01, -2.615897e-01,  4.346620e-01, -1.351404e+00, -3.803530e-02,  5.741566e-02},
  {-8.755990e-01, -3.908252e-01,  2.838698e-01, -1.347756e+00, -7.498321e-02,  4.230641e-02},
  {-9.482467e-01, -2.898558e-01,  1.296600e-01, -1.360903e+00, -4.137034e-02,  2.115321e-02},
  {-9.208275e-01, -3.899701e-01,  9.469067e-09, -1.352788e+00, -7.730833e-02,  0.000000e+00},
  {-4.075235e-01, -2.233600e-01,  8.854575e-01, -1.297528e+00, -9.026609e-02,  8.461239e-02},
  {-6.518233e-01, -4.137071e-01,  6.355886e-01, -1.300665e+00, -1.344386e-01,  7.252491e-02},
  {-3.975070e-01, -2.360001e-01,  8.867311e-01, -1.260769e+00, -1.075431e-01,  9.669987e-02},
  {-4.036157e-01, -2.676904e-01,  8.748921e-01, -1.259608e+00, -1.527084e-01,  8.461239e-02},
  {-5.919084e-01, -5.433705e-01,  5.953091e-01, -1.252818e+00, -1.986258e-01,  7.252491e-02},
  {-8.131166e-01, -4.662858e-01,  3.484521e-01, -1.322648e+00, -1.043800e-01,  5.703917e-02},
  {-8.257027e-01, -4.977120e-01,  2.655143e-01, -1.307696e+00, -1.392564e-01,  4.080004e-02},
  {-8.494280e-01, -4.906029e-01,  1.943731e-01, -1.331244e+00, -1.092537e-01,  2.077672e-02},
  {-8.371702e-01, -5.469425e-01,  0.000000e+00, -1.316738e+00, -1.454581e-01,  0.000000e+00},
  {-7.713855e-01, -5.847311e-01,  2.511055e-01, -1.284011e+00, -1.725126e-01,  3.626245e-02},
  {-7.263487e-01, -6.873264e-01,  1.157884e-08, -1.265827e+00, -2.115321e-01,  0.000000e+00},
  { 7.221557e-01,  6.564988e-01,  2.179459e-01, -1.140281e+00, -1.890246e-01,  3.626245e-02},
  { 5.360727e-01,  6.536847e-01,  5.341558e-01, -1.093779e+00, -2.506345e-01,  7.252491e-02},
  { 6.667106e-01,  7.453167e-01, -1.911478e-09, -1.089214e+00, -2.346988e-01,  0.000000e+00},
  { 3.972654e-01,  3.929022e-01,  8.293419e-01, -1.154338e+00, -2.120994e-01,  8.461239e-02},
  { 1.073169e-03, -8.420139e-04,  9.999990e-01, -1.103823e+00, -2.856927e-01,  9.669987e-02},
  { 5.545645e-01,  8.158086e-01,  1.640563e-01, -1.057884e+00, -2.654798e-01,  3.626245e-02},
  { 5.201073e-01,  8.395066e-01,  1.572165e-01, -1.022367e+00, -2.946707e-01,  7.252491e-02},
  { 5.274994e-01,  8.495554e-01, -1.882750e-09, -1.026175e+00, -2.819154e-01,  0.000000e+00},
  { 4.655073e-01,  8.778998e-01,  1.122273e-01, -9.878559e-01, -3.053456e-01,  2.101826e-02},
  { 4.655065e-01,  8.720127e-01,  1.513190e-01, -1.023983e+00, -2.892611e-01,  4.176747e-02},
  { 4.617390e-01,  8.658873e-01,  1.924483e-01, -9.497045e-01, -3.278732e-01,  4.230641e-02},
  { 4.806447e-01,  8.472201e-01,  2.262713e-01, -9.852213e-01, -3.135711e-01,  5.728070e-02},
  { 4.465931e-01,  7.507921e-01,  4.866886e-01, -9.448395e-01, -3.424787e-01,  7.252491e-02},
  { 3.403325e-01,  5.892598e-01,  7.327664e-01, -1.018976e+00, -3.065627e-01,  8.039757e-02},
  { 2.705146e-01,  4.958668e-01,  8.251897e-01, -1.099327e+00, -2.700088e-01,  8.588496e-02},
  { 2.754436e-01,  5.029356e-01,  8.192598e-01, -9.379543e-01, -3.631282e-01,  9.065635e-02},
  { 2.176272e-01,  3.979008e-01,  8.912426e-01, -1.017790e+00, -3.264072e-01,  9.248506e-02},
  {-8.808603e-03, -2.354299e-03,  9.999584e-01, -9.300637e-01, -3.867995e-01,  9.669987e-02},
  {-3.746234e-01, -4.084146e-01,  8.323789e-01, -1.173674e+00, -2.438251e-01,  8.461239e-02},
  {-4.831858e-01, -6.810579e-01,  5.501741e-01, -1.113862e+00, -3.207513e-01,  7.252491e-02},
  {-6.370706e-01, -7.376022e-01,  2.237945e-01, -1.187732e+00, -2.668985e-01,  3.626245e-02},
  {-5.700291e-01, -8.216245e-01,  5.734868e-09, -1.118426e+00, -3.366866e-01,  0.000000e+00},
  {-2.437273e-01, -3.976177e-01,  8.845888e-01, -1.016092e+00, -3.460850e-01,  9.248506e-02},
  {-3.010587e-01, -4.906413e-01,  8.177009e-01, -1.108314e+00, -3.013766e-01,  8.588496e-02},
  {-3.068000e-01, -5.016136e-01,  8.088619e-01, -9.221730e-01, -4.104708e-01,  9.065635e-02},
  {-3.447136e-01, -5.879483e-01,  7.317713e-01, -1.014910e+00, -3.659295e-01,  8.039757e-02},
  {-4.254485e-01, -7.532145e-01,  5.016588e-01, -9.152879e-01, -4.311202e-01,  7.252491e-02},
  {-4.744251e-01, -8.377773e-01,  2.702779e-01, -1.013853e+00, -3.813082e-01,  5.713802e-02},
  {-4.836290e-01, -8.486131e-01,  2.143797e-01, -1.115835e+00, -3.276351e-01,  4.119587e-02},
  {-4.840315e-01, -8.493693e-01,  2.104407e-01, -9.104229e-01, -4.457258e-01,  4.230641e-02},
  {-4.832306e-01, -8.616657e-01,  1.549851e-01, -1.013316e+00, -3.903284e-01,  2.087557e-02},
  {-4.841307e-01, -8.749956e-01, -3.756299e-09, -9.085748e-01, -4.512661e-01,  0.000000e+00},
  {-9.867886e-01, -9.760351e-02, -1.293133e-01, -1.375046e+00,  2.893260e-02, -2.115321e-02},
  {-9.392973e-01, -1.877273e-01, -2.871919e-01, -1.368823e+00, -5.926633e-03, -4.230641e-02},
  {-8.967127e-01, -8.885380e-02, -4.336028e-01, -1.365088e+00,  3.015749e-02, -5.741566e-02},
  {-6.969652e-01, -1.384261e-01, -7.036176e-01, -1.354555e+00, -2.376668e-03, -7.252491e-02},
  {-9.482467e-01, -2.898559e-01, -1.296601e-01, -1.360903e+00, -4.137034e-02, -2.115321e-02},
  {-8.755990e-01, -3.908252e-01, -2.838697e-01, -1.347756e+00, -7.498321e-02, -4.230641e-02},
  {-8.617655e-01, -2.615897e-01, -4.346620e-01, -1.351404e+00, -3.803530e-02, -5.741566e-02},
  {-6.729468e-01, -2.775105e-01, -6.856607e-01, -1.334480e+00, -6.885031e-02, -7.252491e-02},
  {-4.546248e-01, -6.630503e-02, -8.882117e-01, -1.334647e+00,  3.399538e-02, -8.461239e-02},
  {-4.396287e-01, -8.683572e-02, -8.939721e-01, -1.305990e+00,  9.429310e-03, -9.669987e-02},
  {-4.458990e-01, -1.118261e-01, -8.880703e-01, -1.322304e+00, -2.800860e-02, -8.461239e-02},
  { 9.534954e-03,  4.176798e-04, -9.999545e-01, -1.294201e+00, -5.023664e-02, -9.669987e-02},
  {-8.494280e-01, -4.906029e-01, -1.943731e-01, -1.331244e+00, -1.092537e-01, -2.077672e-02},
  {-8.257027e-01, -4.977120e-01, -2.655143e-01, -1.307696e+00, -1.392564e-01, -4.080004e-02},
  {-8.131166e-01, -4.662857e-01, -3.484521e-01, -1.322648e+00, -1.043800e-01, -5.703917e-02},
  {-6.518232e-01, -4.137071e-01, -6.355886e-01, -1.300665e+00, -1.344386e-01, -7.252491e-02},
  {-7.713855e-01, -5.847312e-01, -2.511055e-01, -1.284011e+00, -1.725126e-01, -3.626245e-02},
  {-5.919084e-01, -5.433705e-01, -5.953091e-01, -1.252818e+00, -1.986258e-01, -7.252491e-02},
  {-4.075235e-01, -2.233600e-01, -8.854574e-01, -1.297528e+00, -9.026609e-02, -8.461239e-02},
  {-3.975070e-01, -2.360001e-01, -8.867311e-01, -1.260769e+00, -1.075431e-01, -9.669987e-02},
  {-4.036157e-01, -2.676905e-01, -8.748921e-01, -1.259608e+00, -1.527084e-01, -8.461239e-02},
  { 8.735472e-03, -5.950648e-03, -9.999442e-01, -1.224195e+00, -1.702305e-01, -9.669987e-02},
  { 4.783988e-01,  9.366333e-02, -8.731333e-01, -1.284381e+00,  1.176730e-02, -8.461239e-02},
  { 6.941421e-01,  2.433121e-01, -6.774703e-01, -1.253918e+00, -3.162732e-02, -7.252491e-02},
  { 8.878495e-01,  1.714007e-01, -4.270188e-01, -1.256260e+00,  1.795179e-02, -5.741566e-02},
  { 9.133146e-01,  2.973460e-01, -2.782836e-01, -1.240642e+00, -2.549437e-02, -4.230641e-02},
  { 9.741461e-01,  1.869393e-01, -1.268586e-01, -1.246646e+00,  2.006629e-02, -2.115321e-02},
  { 4.400099e-01,  2.450105e-01, -8.639219e-01, -1.241970e+00, -9.848347e-02, -8.461239e-02},
  { 6.517141e-01,  4.637395e-01, -6.001786e-01, -1.195567e+00, -1.418394e-01, -7.252491e-02},
  { 8.450963e-01,  4.150167e-01, -3.370065e-01, -1.220008e+00, -8.379798e-02, -5.708000e-02},
  { 8.773019e-01,  4.121228e-01, -2.459594e-01, -1.189907e+00, -1.362222e-01, -4.096422e-02},
  { 8.872037e-01,  4.243551e-01, -1.810865e-01, -1.212178e+00, -7.845581e-02, -2.081755e-02},
  {-6.370706e-01, -7.376022e-01, -2.237944e-01, -1.187732e+00, -2.668985e-01, -3.626245e-02},
  {-4.831859e-01, -6.810579e-01, -5.501741e-01, -1.113862e+00, -3.207513e-01, -7.252491e-02},
  {-3.746234e-01, -4.084146e-01, -8.323790e-01, -1.173674e+00, -2.438251e-01, -8.461239e-02},
  { 1.073164e-03, -8.420139e-04, -9.999990e-01, -1.103823e+00, -2.856927e-01, -9.669987e-02},
  {-4.832306e-01, -8.616657e-01, -1.549851e-01, -1.013316e+00, -3.903284e-01, -2.087557e-02},
  {-4.836291e-01, -8.486131e-01, -2.143797e-01, -1.115835e+00, -3.276351e-01, -4.119587e-02},
  {-4.840315e-01, -8.493693e-01, -2.104407e-01, -9.104229e-01, -4.457258e-01, -4.230641e-02},
  {-4.744251e-01, -8.377773e-01, -2.702778e-01, -1.013853e+00, -3.813082e-01, -5.713802e-02},
  {-4.254485e-01, -7.532145e-01, -5.016588e-01, -9.152879e-01, -4.311202e-01, -7.252491e-02},
  {-3.447136e-01, -5.879483e-01, -7.317714e-01, -1.014910e+00, -3.659295e-01, -8.039757e-02},
  {-3.010587e-01, -4.906412e-01, -8.177009e-01, -1.108314e+00, -3.013766e-01, -8.588496e-02},
  {-3.068000e-01, -5.016134e-01, -8.088619e-01, -9.221730e-01, -4.104708e-01, -9.065635e-02},
  {-2.437273e-01, -3.976177e-01, -8.845887e-01, -1.016092e+00, -3.460850e-01, -9.248506e-02},
  {-8.808599e-03, -2.354299e-03, -9.999584e-01, -9.300637e-01, -3.867995e-01, -9.669987e-02},
  { 3.972654e-01,  3.929022e-01, -8.293419e-01, -1.154338e+00, -2.120994e-01, -8.461239e-02},
  { 5.360727e-01,  6.536847e-01, -5.341557e-01, -1.093779e+00, -2.506345e-01, -7.252491e-02},
  { 7.221557e-01,  6.564988e-01, -2.179459e-01, -1.140281e+00, -1.890246e-01, -3.626245e-02},
  { 2.176272e-01,  3.979008e-01, -8.912426e-01, -1.017790e+00, -3.264072e-01, -9.248506e-02},
  { 2.705146e-01,  4.958668e-01, -8.251897e-01, -1.099327e+00, -2.700088e-01, -8.588496e-02},
  { 2.754436e-01,  5.029356e-01, -8.192598e-01, -9.379543e-01, -3.631282e-01, -9.065635e-02},
  { 3.403325e-01,  5.892599e-01, -7.327664e-01, -1.018976e+00, -3.065627e-01, -8.039757e-02},
  { 4.465931e-01,  7.507921e-01, -4.866886e-01, -9.448395e-01, -3.424787e-01, -7.252491e-02},
  { 5.545645e-01,  8.158086e-01, -1.640563e-01, -1.057884e+00, -2.654798e-01, -3.626245e-02},
  { 5.201073e-01,  8.395066e-01, -1.572165e-01, -1.022367e+00, -2.946707e-01, -7.252491e-02},
  { 4.806447e-01,  8.472201e-01, -2.262713e-01, -9.852213e-01, -3.135711e-01, -5.728070e-02},
  { 4.655065e-01,  8.720127e-01, -1.513190e-01, -1.023983e+00, -2.892611e-01, -4.176747e-02},
  { 4.617390e-01,  8.658873e-01, -1.924484e-01, -9.497045e-01, -3.278732e-01, -4.230641e-02},
  { 4.655073e-01,  8.778998e-01, -1.122272e-01, -9.878559e-01, -3.053456e-01, -2.101826e-02},
  {-1.063836e-01,  9.821826e-01,  1.549193e-01,  7.005455e-01, -9.751214e-02,  4.591568e-02},
  {-1.054579e-01,  9.944237e-01, -3.772587e-09,  6.386232e-01, -9.669989e-02,  0.000000e+00},
  {-1.029984e-01,  9.352303e-01,  3.387264e-01,  6.386232e-01, -1.119355e-01,  9.307384e-02},
  {-2.316654e-01,  9.166454e-01,  3.257180e-01,  7.638431e-01, -9.742622e-02,  9.058931e-02},
  {-2.470505e-01,  9.690026e-01,  3.806695e-09,  7.610925e-01, -8.398277e-02,  0.000000e+00},
  {-9.933902e-02,  8.598174e-01,  5.008450e-01,  7.030425e-01, -1.235824e-01,  1.246285e-01},
  {-8.475072e-02,  7.337666e-01,  6.740949e-01,  6.386232e-01, -1.521024e-01,  1.595548e-01},
  {-1.731504e-01,  7.328386e-01,  6.580020e-01,  7.710848e-01, -1.328699e-01,  1.552957e-01},
  {-3.803722e-01,  9.134287e-01,  1.447933e-01,  8.047063e-01, -7.285585e-02,  4.365720e-02},
  {-5.051264e-01,  8.063496e-01,  3.076487e-01,  8.491109e-01, -6.065445e-02,  8.403949e-02},
  {-5.431682e-01,  8.396239e-01,  3.823490e-09,  8.447830e-01, -4.935563e-02,  0.000000e+00},
  {-3.224343e-01,  8.182415e-01,  4.759381e-01,  8.111400e-01, -9.534609e-02,  1.184982e-01},
  {-3.704505e-01,  6.750776e-01,  6.379943e-01,  8.605216e-01, -9.043803e-02,  1.440678e-01},
  {-6.812875e-02,  5.875646e-01,  8.063041e-01,  7.074176e-01, -1.692119e-01,  1.771035e-01},
  {-3.763995e-02,  4.011678e-01,  9.152309e-01,  6.386232e-01, -2.088846e-01,  1.994437e-01},
  {-6.332415e-02,  4.147212e-01,  9.077425e-01,  7.813306e-01, -1.829820e-01,  1.941196e-01},
  {-5.536104e-03,  2.090384e-01,  9.778918e-01,  7.129145e-01, -2.265700e-01,  2.033409e-01},
  { 3.745396e-02,  1.976387e-03,  9.992964e-01,  6.386232e-01, -2.739830e-01,  2.127397e-01},
  { 8.175071e-02,  1.920228e-02,  9.964678e-01,  7.930766e-01, -2.404277e-01,  2.070611e-01},
  {-1.868826e-01,  5.864601e-01,  7.881240e-01,  8.223959e-01, -1.347094e-01,  1.683919e-01},
  {-1.300149e-01,  4.161970e-01,  8.999313e-01,  8.766510e-01, -1.325433e-01,  1.800848e-01},
  { 1.287317e-02,  2.333999e-01,  9.722956e-01,  8.365529e-01, -1.841896e-01,  1.933392e-01},
  { 1.641820e-01,  6.787368e-02,  9.840922e-01,  8.951486e-01, -1.808073e-01,  1.920902e-01},
  {-6.787593e-01,  7.222970e-01,  1.325624e-01,  8.743861e-01, -2.879509e-02,  3.970454e-02},
  {-7.408414e-01,  6.081551e-01,  2.851338e-01,  9.043888e-01, -7.065552e-03,  7.477952e-02},
  {-7.882945e-01,  6.152982e-01, -8.549702e-09,  8.992573e-01,  1.891026e-03,  0.000000e+00},
  {-5.827835e-01,  6.784140e-01,  4.473455e-01,  8.829817e-01, -4.720674e-02,  1.077701e-01},
  {-5.620550e-01,  5.535797e-01,  6.145272e-01,  9.179096e-01, -3.066890e-02,  1.281935e-01},
  {-8.656745e-01,  4.857799e-01,  1.209364e-01,  9.193451e-01,  2.929364e-02,  3.473588e-02},
  {-8.605759e-01,  4.261319e-01,  2.789637e-01,  9.396348e-01,  5.788672e-02,  6.416445e-02},
  {-9.100907e-01,  4.144092e-01,  1.130074e-08,  9.340950e-01,  6.446657e-02,  0.000000e+00},
  {-7.641528e-01,  4.902846e-01,  4.191558e-01,  9.290453e-01,  1.517545e-02,  9.428324e-02},
  {-6.687193e-01,  4.286401e-01,  6.075214e-01,  9.542431e-01,  4.054517e-02,  1.099963e-01},
  {-3.471251e-01,  5.335480e-01,  7.712527e-01,  8.980281e-01, -7.942285e-02,  1.531468e-01},
  {-2.162839e-01,  3.928111e-01,  8.938237e-01,  9.370261e-01, -6.404538e-02,  1.602420e-01},
  { 1.222394e-02,  2.592705e-01,  9.657274e-01,  9.169427e-01, -1.199250e-01,  1.758352e-01},
  { 2.116980e-01,  1.304623e-01,  9.685884e-01,  9.589406e-01, -1.023042e-01,  1.709245e-01},
  {-4.854504e-01,  4.421779e-01,  7.541993e-01,  9.460170e-01, -9.536746e-03,  1.339818e-01},
  {-2.894644e-01,  3.519351e-01,  8.901415e-01,  9.748895e-01,  1.602208e-02,  1.374952e-01},
  {-1.951133e-02,  2.744588e-01,  9.614009e-01,  9.673555e-01, -4.060537e-02,  1.538306e-01},
  { 1.944946e-01,  1.703334e-01,  9.660012e-01,  9.985616e-01, -1.208966e-02,  1.466615e-01},
  { 8.043006e-02, -2.013521e-01,  9.762112e-01,  7.187852e-01, -2.878403e-01,  2.033409e-01},
  { 1.193111e-01, -3.859782e-01,  9.147599e-01,  6.386232e-01, -3.390792e-01,  1.994437e-01},
  { 2.271040e-01, -3.656180e-01,  9.026335e-01,  8.048180e-01, -2.978722e-01,  1.941196e-01},
  { 1.410379e-01, -5.464832e-01,  8.255085e-01,  6.853314e-01, -3.569558e-01,  1.785015e-01},
  { 1.604819e-01, -7.174953e-01,  6.778244e-01,  6.386232e-01, -3.958652e-01,  1.595548e-01},
  { 2.116407e-01, -7.011481e-01,  6.808815e-01,  7.356325e-01, -3.760688e-01,  1.584417e-01},
  { 1.614221e-01, -5.336261e-01,  8.301723e-01,  7.284380e-01, -3.168099e-01,  1.965663e-01},
  { 1.931423e-01, -5.445057e-01,  8.162166e-01,  7.709903e-01, -3.346834e-01,  1.761059e-01},
  { 3.427450e-01, -6.775564e-01,  6.507251e-01,  8.150596e-01, -3.479833e-01,  1.552957e-01},
  { 2.298779e-01, -1.605726e-01,  9.598815e-01,  8.516681e-01, -2.370462e-01,  1.933392e-01},
  { 4.288716e-01, -2.686392e-01,  8.624976e-01,  9.136420e-01, -2.290760e-01,  1.800848e-01},
  { 3.689700e-01, -4.885866e-01,  7.906606e-01,  8.402833e-01, -3.050305e-01,  1.716358e-01},
  { 4.722262e-01, -6.027915e-01,  6.431523e-01,  8.790578e-01, -3.126677e-01,  1.504079e-01},
  { 3.924363e-01, -4.597458e-01,  7.966351e-01,  8.621934e-01, -2.615994e-01,  1.867197e-01},
  { 4.284266e-01, -4.553474e-01,  7.804546e-01,  8.961671e-01, -2.686310e-01,  1.653198e-01},
  { 6.304013e-01, -5.035625e-01,  5.907784e-01,  9.297715e-01, -2.711813e-01,  1.440678e-01},
  { 1.826648e-01, -8.444852e-01,  5.034663e-01,  6.881464e-01, -4.054957e-01,  1.258736e-01},
  { 2.017759e-01, -9.195613e-01,  3.371845e-01,  6.386232e-01, -4.360309e-01,  9.307384e-02},
  { 2.690024e-01, -9.051437e-01,  3.291697e-01,  7.397068e-01, -4.140186e-01,  9.242445e-02},
  { 3.107902e-01, -8.170540e-01,  4.856257e-01,  7.781761e-01, -3.803748e-01,  1.241876e-01},
  { 4.102573e-01, -8.554124e-01,  3.161625e-01,  8.223056e-01, -3.834279e-01,  9.058931e-02},
  { 2.129251e-01, -9.645610e-01,  1.558365e-01,  6.895518e-01, -4.324319e-01,  4.637468e-02},
  { 2.164648e-01, -9.762904e-01,  0.000000e+00,  6.386232e-01, -4.512661e-01,  0.000000e+00},
  { 2.848417e-01, -9.585746e-01, -1.889301e-09,  7.412497e-01, -4.284131e-01,  0.000000e+00},
  { 3.473229e-01, -9.258366e-01,  1.489750e-01,  7.820786e-01, -4.056831e-01,  4.575323e-02},
  { 4.284635e-01, -9.035591e-01, -1.889177e-09,  8.250563e-01, -3.968722e-01,  0.000000e+00},
  { 4.546551e-01, -7.588500e-01,  4.662996e-01,  8.512812e-01, -3.473627e-01,  1.210076e-01},
  { 5.587748e-01, -7.726616e-01,  3.012719e-01,  8.887063e-01, -3.453720e-01,  8.773773e-02},
  { 5.987133e-01, -6.674914e-01,  4.427162e-01,  9.096794e-01, -3.075460e-01,  1.165633e-01},
  { 7.219656e-01, -6.329591e-01,  2.795146e-01,  9.411820e-01, -3.009635e-01,  8.403949e-02},
  { 4.969747e-01, -8.560743e-01,  1.419614e-01,  8.571090e-01, -3.708625e-01,  4.458165e-02},
  { 5.789050e-01, -8.153950e-01, -1.888436e-09,  8.923680e-01, -3.577771e-01,  0.000000e+00},
  { 6.451631e-01, -7.522371e-01,  1.338056e-01,  9.169427e-01, -3.290929e-01,  4.294420e-02},
  { 7.431846e-01, -6.690865e-01,  4.733935e-09,  9.455100e-01, -3.122598e-01,  0.000000e+00},
  { 3.749226e-01, -6.685217e-02,  9.246426e-01,  9.371465e-01, -1.631864e-01,  1.758352e-01},
  { 5.634818e-01, -1.375431e-01,  8.145981e-01,  9.808547e-01, -1.405586e-01,  1.602420e-01},
  { 6.329368e-01, -3.337480e-01,  6.985723e-01,  9.560610e-01, -2.036886e-01,  1.531468e-01},
  { 7.723742e-01, -3.306558e-01,  5.423144e-01,  9.999714e-01, -1.739352e-01,  1.281935e-01},
  { 4.398495e-01,  3.464943e-02,  8.974028e-01,  9.901466e-01, -7.378845e-02,  1.538306e-01},
  { 5.939925e-01, -3.440101e-02,  8.037347e-01,  1.022234e+00, -4.019709e-02,  1.374952e-01},
  { 7.359335e-01, -1.676775e-01,  6.559620e-01,  1.011485e+00, -1.048528e-01,  1.339818e-01},
  { 8.235254e-01, -1.929602e-01,  5.334532e-01,  1.042884e+00, -6.472013e-02,  1.099963e-01},
  { 7.693294e-01, -4.958718e-01,  4.027945e-01,  9.711075e-01, -2.359052e-01,  1.077701e-01},
  { 8.644541e-01, -4.333639e-01,  2.547838e-01,  1.013496e+00, -1.975428e-01,  7.477952e-02},
  { 8.175843e-01, -5.630500e-01,  1.205429e-01,  9.797030e-01, -2.543147e-01,  3.970454e-02},
  { 8.863767e-01, -4.629647e-01, -1.889302e-09,  1.018624e+00, -2.064950e-01,  0.000000e+00},
  { 8.810303e-01, -2.930633e-01,  3.713484e-01,  1.028461e+00, -1.295650e-01,  9.428324e-02},
  { 9.256360e-01, -2.838664e-01,  2.502356e-01,  1.057488e+00, -8.206167e-02,  6.416445e-02},
  { 9.310698e-01, -3.476896e-01,  1.105492e-01,  1.038157e+00, -1.436831e-01,  3.473588e-02},
  { 9.502375e-01, -3.115262e-01, -9.382416e-09,  1.063028e+00, -8.864153e-02,  0.000000e+00},
  {-9.308618e-01,  3.393035e-01,  1.355339e-01,  9.616781e-01,  1.312282e-01,  2.711336e-02},
  {-8.465220e-01,  4.121203e-01,  3.369829e-01,  9.898673e-01,  2.000828e-01,  4.428940e-02},
  {-9.157680e-01,  4.017076e-01,  1.890707e-08,  9.831154e-01,  2.024637e-01,  0.000000e+00},
  {-8.108956e-01,  3.673836e-01,  4.554970e-01,  9.728523e-01,  1.230796e-01,  7.359377e-02},
  {-6.194584e-01,  4.059786e-01,  6.719022e-01,  1.007669e+00,  1.938080e-01,  7.592445e-02},
  {-5.186524e-01,  3.632244e-01,  7.739947e-01,  9.924073e-01,  1.088282e-01,  1.045803e-01},
  {-2.881785e-01,  3.507444e-01,  8.910283e-01,  1.032836e+00,  1.849374e-01,  9.490556e-02},
  {-8.819988e-02,  2.675104e-01,  9.595098e-01,  1.016995e+00,  9.091076e-02,  1.200737e-01},
  { 7.447062e-02,  1.799489e-01,  9.808530e-01,  1.061687e+00,  1.747646e-01,  1.012327e-01},
  {-8.692088e-01,  4.608971e-01,  1.790246e-01,  1.003551e+00,  2.340739e-01,  2.050725e-02},
  {-7.301239e-01,  5.644285e-01,  3.851487e-01,  1.024774e+00,  2.664275e-01,  3.773960e-02},
  {-8.125539e-01,  5.828862e-01, -9.576987e-09,  1.016440e+00,  2.673085e-01,  0.000000e+00},
  {-7.051653e-01,  4.522966e-01,  5.460493e-01,  1.017261e+00,  2.311041e-01,  5.566260e-02},
  {-4.687726e-01,  4.588072e-01,  7.548167e-01,  1.046740e+00,  2.641024e-01,  6.469651e-02},
  {-7.047208e-01,  6.818720e-01,  1.960082e-01,  1.047273e+00,  2.945994e-01,  1.824877e-02},
  {-5.489789e-01,  7.518821e-01,  3.650966e-01,  1.079480e+00,  3.223329e-01,  3.525506e-02},
  {-5.857003e-01,  8.105277e-01, -1.440926e-08,  1.068400e+00,  3.223329e-01,  0.000000e+00},
  {-5.564801e-01,  6.019779e-01,  5.726714e-01,  1.064919e+00,  2.938000e-01,  4.953225e-02},
  {-3.508382e-01,  5.788999e-01,  7.360622e-01,  1.108692e+00,  3.223329e-01,  6.043742e-02},
  {-3.529555e-01,  3.858426e-01,  8.523778e-01,  1.041703e+00,  2.258694e-01,  7.771146e-02},
  {-2.569784e-01,  3.684761e-01,  8.934134e-01,  1.079570e+00,  2.606298e-01,  7.531846e-02},
  {-1.844071e-01,  3.188742e-01,  9.296845e-01,  1.071873e+00,  2.193454e-01,  8.942977e-02},
  { 2.671872e-02,  1.149684e-01,  9.930098e-01,  1.113394e+00,  2.570497e-01,  8.626188e-02},
  {-2.298272e-01,  3.435909e-01,  9.105629e-01,  1.116540e+00,  2.914534e-01,  7.299466e-02},
  { 1.072308e-02,  1.172924e-01,  9.930395e-01,  1.197334e+00,  3.223329e-01,  8.058323e-02},
  { 4.224756e-01,  7.343937e-02,  9.033942e-01,  1.026188e+00,  2.351743e-02,  1.306604e-01},
  { 5.460208e-01, -8.695545e-03,  8.377265e-01,  1.053539e+00,  6.414426e-02,  1.147484e-01},
  { 3.943517e-01,  8.135834e-02,  9.153510e-01,  1.030417e+00,  8.220779e-02,  1.237363e-01},
  { 7.237687e-01, -8.446298e-02,  6.848539e-01,  1.048592e+00,  1.805056e-03,  1.135098e-01},
  { 7.894408e-01, -1.686811e-01,  5.901948e-01,  1.075720e+00,  4.799323e-02,  9.179870e-02},
  { 3.276889e-01,  9.097939e-02,  9.403950e-01,  1.059044e+00,  1.214292e-01,  1.086558e-01},
  { 4.169855e-01, -2.314941e-02,  9.086183e-01,  1.090534e+00,  1.645918e-01,  9.490556e-02},
  { 6.284791e-01, -9.972116e-02,  7.714076e-01,  1.083872e+00,  1.081104e-01,  9.434427e-02},
  { 6.813531e-01, -2.538502e-01,  6.865260e-01,  1.115702e+00,  1.557212e-01,  7.592445e-02},
  { 8.945727e-01, -2.088295e-01,  3.951330e-01,  1.066875e+00, -1.555796e-02,  7.987711e-02},
  { 9.183111e-01, -2.753862e-01,  2.843716e-01,  1.091411e+00,  3.656546e-02,  5.354938e-02},
  { 9.563100e-01, -2.672605e-01,  1.185032e-01,  1.077323e+00, -2.547721e-02,  2.942857e-02},
  { 9.509217e-01, -3.094314e-01, -9.401309e-09,  1.097359e+00,  3.223331e-02,  0.000000e+00},
  { 8.427106e-01, -2.596136e-01,  4.716350e-01,  1.104085e+00,  9.743048e-02,  6.639027e-02},
  { 8.438668e-01, -4.141431e-01,  3.411367e-01,  1.133503e+00,  1.494465e-01,  4.428940e-02},
  { 9.289429e-01, -3.407983e-01,  1.446434e-01,  1.115633e+00,  9.132765e-02,  2.445948e-02},
  { 8.861397e-01, -4.634182e-01, -1.521311e-08,  1.140255e+00,  1.470655e-01,  0.000000e+00},
  { 2.698444e-01,  2.312411e-02,  9.626262e-01,  1.103208e+00,  2.124690e-01,  8.942977e-02},
  { 3.319872e-01, -2.217326e-02,  9.430233e-01,  1.147217e+00,  2.534697e-01,  7.531846e-02},
  { 4.273541e-01, -1.309127e-01,  8.945559e-01,  1.133374e+00,  2.059449e-01,  7.771146e-02},
  { 5.020796e-01, -3.756276e-01,  7.789865e-01,  1.180048e+00,  2.499928e-01,  6.469651e-02},
  { 2.767239e-01, -2.640179e-01,  9.239689e-01,  1.168448e+00,  2.712024e-01,  7.401237e-02},
  { 3.998777e-01, -5.355830e-01,  7.438070e-01,  1.226739e+00,  2.894335e-01,  6.155055e-02},
  { 2.694102e-01, -2.864849e-01,  9.194262e-01,  1.153612e+00,  2.883290e-01,  8.354095e-02},
  { 2.424605e-01, -3.169258e-01,  9.169357e-01,  1.215913e+00,  3.056060e-01,  7.152825e-02},
  { 3.394134e-01, -5.609859e-01,  7.550452e-01,  1.285975e+00,  3.223329e-01,  6.043742e-02},
  { 7.109576e-01, -4.397499e-01,  5.487799e-01,  1.157816e+00,  2.007060e-01,  5.566260e-02},
  { 6.928185e-01, -6.190738e-01,  3.697974e-01,  1.202014e+00,  2.476678e-01,  3.773960e-02},
  { 8.096447e-01, -5.611805e-01,  1.719070e-01,  1.171530e+00,  1.977405e-01,  2.050725e-02},
  { 7.326433e-01, -6.806128e-01, -5.726753e-09,  1.210343e+00,  2.467867e-01,  0.000000e+00},
  { 5.556392e-01, -6.347127e-01,  5.370334e-01,  1.215169e+00,  2.688987e-01,  4.997278e-02},
  { 5.286574e-01, -7.800938e-01,  3.346266e-01,  1.251877e+00,  2.885008e-01,  3.590445e-02},
  { 4.272037e-01, -7.718211e-01,  4.709449e-01,  1.269945e+00,  3.056490e-01,  4.828676e-02},
  { 4.455688e-01, -8.404477e-01,  3.084089e-01,  1.315187e+00,  3.223329e-01,  3.525506e-02},
  { 6.246802e-01, -7.633711e-01,  1.644358e-01,  1.231411e+00,  2.677770e-01,  1.841080e-02},
  { 5.520148e-01, -8.338343e-01,  1.893889e-09,  1.261413e+00,  2.881484e-01,  0.000000e+00},
  { 4.647919e-01, -8.744382e-01,  1.390192e-01,  1.288687e+00,  3.053266e-01,  1.778977e-02},
  { 4.834644e-01, -8.753641e-01,  1.880126e-09,  1.326267e+00,  3.223329e-01,  0.000000e+00},
  { 2.129251e-01, -9.645610e-01, -1.558365e-01,  6.895518e-01, -4.324319e-01, -4.637468e-02},
  { 2.017759e-01, -9.195613e-01, -3.371845e-01,  6.386232e-01, -4.360309e-01, -9.307384e-02},
  { 2.690024e-01, -9.051436e-01, -3.291697e-01,  7.397068e-01, -4.140186e-01, -9.242445e-02},
  { 3.473229e-01, -9.258366e-01, -1.489750e-01,  7.820786e-01, -4.056831e-01, -4.575323e-02},
  { 4.102573e-01, -8.554123e-01, -3.161625e-01,  8.223056e-01, -3.834279e-01, -9.058931e-02},
  { 1.826648e-01, -8.444852e-01, -5.034663e-01,  6.881464e-01, -4.054957e-01, -1.258736e-01},
  { 1.604819e-01, -7.174953e-01, -6.778245e-01,  6.386232e-01, -3.958652e-01, -1.595548e-01},
  { 2.116407e-01, -7.011481e-01, -6.808815e-01,  7.356325e-01, -3.760688e-01, -1.584417e-01},
  { 3.107903e-01, -8.170540e-01, -4.856256e-01,  7.781761e-01, -3.803748e-01, -1.241876e-01},
  { 3.427450e-01, -6.775564e-01, -6.507251e-01,  8.150596e-01, -3.479833e-01, -1.552957e-01},
  { 4.969747e-01, -8.560743e-01, -1.419614e-01,  8.571090e-01, -3.708625e-01, -4.458165e-02},
  { 5.587748e-01, -7.726616e-01, -3.012719e-01,  8.887063e-01, -3.453720e-01, -8.773773e-02},
  { 6.451631e-01, -7.522371e-01, -1.338056e-01,  9.169427e-01, -3.290929e-01, -4.294420e-02},
  { 7.219656e-01, -6.329591e-01, -2.795146e-01,  9.411820e-01, -3.009635e-01, -8.403949e-02},
  { 4.546552e-01, -7.588500e-01, -4.662996e-01,  8.512812e-01, -3.473627e-01, -1.210076e-01},
  { 4.722262e-01, -6.027914e-01, -6.431522e-01,  8.790578e-01, -3.126677e-01, -1.504079e-01},
  { 5.987133e-01, -6.674914e-01, -4.427162e-01,  9.096794e-01, -3.075460e-01, -1.165633e-01},
  { 6.304014e-01, -5.035624e-01, -5.907784e-01,  9.297715e-01, -2.711813e-01, -1.440678e-01},
  { 1.410379e-01, -5.464832e-01, -8.255086e-01,  6.853314e-01, -3.569558e-01, -1.785015e-01},
  { 1.193111e-01, -3.859783e-01, -9.147599e-01,  6.386232e-01, -3.390792e-01, -1.994437e-01},
  { 1.614221e-01, -5.336261e-01, -8.301723e-01,  7.284380e-01, -3.168099e-01, -1.965663e-01},
  { 1.931423e-01, -5.445057e-01, -8.162166e-01,  7.709903e-01, -3.346834e-01, -1.761059e-01},
  { 2.271040e-01, -3.656180e-01, -9.026335e-01,  8.048180e-01, -2.978722e-01, -1.941196e-01},
  { 8.043006e-02, -2.013521e-01, -9.762112e-01,  7.187852e-01, -2.878403e-01, -2.033409e-01},
  { 3.745396e-02,  1.976399e-03, -9.992964e-01,  6.386232e-01, -2.739830e-01, -2.127397e-01},
  { 8.175071e-02,  1.920228e-02, -9.964678e-01,  7.930766e-01, -2.404277e-01, -2.070611e-01},
  { 3.689700e-01, -4.885866e-01, -7.906606e-01,  8.402833e-01, -3.050305e-01, -1.716358e-01},
  { 3.924364e-01, -4.597458e-01, -7.966351e-01,  8.621934e-01, -2.615994e-01, -1.867197e-01},
  { 4.284267e-01, -4.553474e-01, -7.804546e-01,  8.961671e-01, -2.686310e-01, -1.653198e-01},
  { 4.288716e-01, -2.686393e-01, -8.624976e-01,  9.136420e-01, -2.290760e-01, -1.800848e-01},
  { 2.298779e-01, -1.605726e-01, -9.598815e-01,  8.516681e-01, -2.370462e-01, -1.933392e-01},
  { 1.641820e-01,  6.787367e-02, -9.840922e-01,  8.951486e-01, -1.808073e-01, -1.920902e-01},
  { 8.175843e-01, -5.630500e-01, -1.205429e-01,  9.797030e-01, -2.543147e-01, -3.970454e-02},
  { 8.644541e-01, -4.333639e-01, -2.547838e-01,  1.013496e+00, -1.975428e-01, -7.477952e-02},
  { 7.693294e-01, -4.958719e-01, -4.027945e-01,  9.711075e-01, -2.359052e-01, -1.077701e-01},
  { 7.723742e-01, -3.306558e-01, -5.423144e-01,  9.999714e-01, -1.739352e-01, -1.281935e-01},
  { 9.310698e-01, -3.476895e-01, -1.105492e-01,  1.038157e+00, -1.436831e-01, -3.473588e-02},
  { 9.256360e-01, -2.838664e-01, -2.502356e-01,  1.057488e+00, -8.206167e-02, -6.416445e-02},
  { 8.810303e-01, -2.930633e-01, -3.713484e-01,  1.028461e+00, -1.295650e-01, -9.428324e-02},
  { 8.235254e-01, -1.929602e-01, -5.334532e-01,  1.042884e+00, -6.472013e-02, -1.099963e-01},
  { 6.329368e-01, -3.337480e-01, -6.985723e-01,  9.560610e-01, -2.036886e-01, -1.531468e-01},
  { 5.634818e-01, -1.375431e-01, -8.145981e-01,  9.808547e-01, -1.405586e-01, -1.602420e-01},
  { 3.749226e-01, -6.685216e-02, -9.246426e-01,  9.371465e-01, -1.631864e-01, -1.758352e-01},
  { 2.116980e-01,  1.304623e-01, -9.685884e-01,  9.589406e-01, -1.023042e-01, -1.709245e-01},
  { 7.359335e-01, -1.676775e-01, -6.559620e-01,  1.011485e+00, -1.048528e-01, -1.339818e-01},
  { 5.939925e-01, -3.440102e-02, -8.037347e-01,  1.022234e+00, -4.019709e-02, -1.374952e-01},
  { 4.398495e-01,  3.464942e-02, -8.974029e-01,  9.901466e-01, -7.378845e-02, -1.538306e-01},
  { 1.944946e-01,  1.703335e-01, -9.660012e-01,  9.985616e-01, -1.208966e-02, -1.466615e-01},
  {-5.536106e-03,  2.090384e-01, -9.778918e-01,  7.129145e-01, -2.265700e-01, -2.033409e-01},
  {-3.763995e-02,  4.011678e-01, -9.152309e-01,  6.386232e-01, -2.088846e-01, -1.994437e-01},
  {-6.332415e-02,  4.147212e-01, -9.077425e-01,  7.813306e-01, -1.829820e-01, -1.941196e-01},
  {-6.812874e-02,  5.875646e-01, -8.063041e-01,  7.074176e-01, -1.692119e-01, -1.771035e-01},
  {-8.475072e-02,  7.337666e-01, -6.740949e-01,  6.386232e-01, -1.521024e-01, -1.595548e-01},
  {-1.731504e-01,  7.328385e-01, -6.580020e-01,  7.710848e-01, -1.328699e-01, -1.552957e-01},
  { 1.287317e-02,  2.333999e-01, -9.722956e-01,  8.365529e-01, -1.841896e-01, -1.933392e-01},
  {-1.300149e-01,  4.161970e-01, -8.999312e-01,  8.766510e-01, -1.325433e-01, -1.800848e-01},
  {-1.868826e-01,  5.864601e-01, -7.881240e-01,  8.223959e-01, -1.347094e-01, -1.683919e-01},
  {-3.704505e-01,  6.750776e-01, -6.379943e-01,  8.605216e-01, -9.043803e-02, -1.440678e-01},
  {-9.933903e-02,  8.598174e-01, -5.008450e-01,  7.030425e-01, -1.235824e-01, -1.246285e-01},
  {-1.029984e-01,  9.352303e-01, -3.387264e-01,  6.386232e-01, -1.119355e-01, -9.307384e-02},
  {-2.316654e-01,  9.166454e-01, -3.257180e-01,  7.638431e-01, -9.742622e-02, -9.058931e-02},
  {-1.063836e-01,  9.821826e-01, -1.549193e-01,  7.005455e-01, -9.751214e-02, -4.591568e-02},
  {-3.224343e-01,  8.182414e-01, -4.759382e-01,  8.111400e-01, -9.534609e-02, -1.184982e-01},
  {-5.051264e-01,  8.063496e-01, -3.076487e-01,  8.491109e-01, -6.065445e-02, -8.403949e-02},
  {-3.803722e-01,  9.134286e-01, -1.447933e-01,  8.047063e-01, -7.285585e-02, -4.365720e-02},
  { 1.222394e-02,  2.592705e-01, -9.657274e-01,  9.169427e-01, -1.199250e-01, -1.758352e-01},
  {-2.162839e-01,  3.928111e-01, -8.938236e-01,  9.370261e-01, -6.404538e-02, -1.602420e-01},
  {-3.471251e-01,  5.335481e-01, -7.712527e-01,  8.980281e-01, -7.942285e-02, -1.531468e-01},
  {-5.620550e-01,  5.535798e-01, -6.145272e-01,  9.179096e-01, -3.066890e-02, -1.281935e-01},
  {-1.951134e-02,  2.744588e-01, -9.614009e-01,  9.673555e-01, -4.060537e-02, -1.538306e-01},
  {-2.894645e-01,  3.519351e-01, -8.901415e-01,  9.748895e-01,  1.602208e-02, -1.374952e-01},
  {-4.854504e-01,  4.421779e-01, -7.541993e-01,  9.460170e-01, -9.536746e-03, -1.339818e-01},
  {-6.687193e-01,  4.286401e-01, -6.075214e-01,  9.542431e-01,  4.054517e-02, -1.099963e-01},
  {-5.827835e-01,  6.784139e-01, -4.473454e-01,  8.829817e-01, -4.720674e-02, -1.077701e-01},
  {-7.408414e-01,  6.081551e-01, -2.851338e-01,  9.043888e-01, -7.065552e-03, -7.477952e-02},
  {-6.787594e-01,  7.222970e-01, -1.325624e-01,  8.743861e-01, -2.879509e-02, -3.970454e-02},
  {-7.641528e-01,  4.902846e-01, -4.191558e-01,  9.290453e-01,  1.517545e-02, -9.428324e-02},
  {-8.605759e-01,  4.261319e-01, -2.789638e-01,  9.396348e-01,  5.788672e-02, -6.416445e-02},
  {-8.656744e-01,  4.857799e-01, -1.209364e-01,  9.193451e-01,  2.929364e-02, -3.473588e-02},
  { 9.563100e-01, -2.672605e-01, -1.185032e-01,  1.077323e+00, -2.547721e-02, -2.942857e-02},
  { 9.183111e-01, -2.753862e-01, -2.843716e-01,  1.091411e+00,  3.656546e-02, -5.354938e-02},
  { 8.945727e-01, -2.088295e-01, -3.951330e-01,  1.066875e+00, -1.555796e-02, -7.987711e-02},
  { 7.894408e-01, -1.686810e-01, -5.901949e-01,  1.075720e+00,  4.799323e-02, -9.179870e-02},
  { 9.289429e-01, -3.407983e-01, -1.446434e-01,  1.115633e+00,  9.132765e-02, -2.445948e-02},
  { 8.438668e-01, -4.141431e-01, -3.411366e-01,  1.133503e+00,  1.494465e-01, -4.428940e-02},
  { 8.427106e-01, -2.596136e-01, -4.716350e-01,  1.104085e+00,  9.743048e-02, -6.639027e-02},
  { 6.813531e-01, -2.538502e-01, -6.865261e-01,  1.115702e+00,  1.557212e-01, -7.592445e-02},
  { 7.237687e-01, -8.446298e-02, -6.848539e-01,  1.048592e+00,  1.805056e-03, -1.135098e-01},
  { 5.460208e-01, -8.695546e-03, -8.377265e-01,  1.053539e+00,  6.414426e-02, -1.147484e-01},
  { 4.224755e-01,  7.343937e-02, -9.033942e-01,  1.026188e+00,  2.351743e-02, -1.306604e-01},
  { 3.943517e-01,  8.135834e-02, -9.153510e-01,  1.030417e+00,  8.220779e-02, -1.237363e-01},
  { 6.284791e-01, -9.972116e-02, -7.714077e-01,  1.083872e+00,  1.081104e-01, -9.434427e-02},
  { 4.169856e-01, -2.314942e-02, -9.086183e-01,  1.090534e+00,  1.645918e-01, -9.490556e-02},
  { 3.276889e-01,  9.097938e-02, -9.403950e-01,  1.059044e+00,  1.214292e-01, -1.086558e-01},
  { 7.447061e-02,  1.799489e-01, -9.808530e-01,  1.061687e+00,  1.747646e-01, -1.012327e-01},
  { 8.096446e-01, -5.611805e-01, -1.719070e-01,  1.171530e+00,  1.977405e-01, -2.050725e-02},
  { 6.928185e-01, -6.190738e-01, -3.697975e-01,  1.202014e+00,  2.476678e-01, -3.773960e-02},
  { 7.109576e-01, -4.397499e-01, -5.487799e-01,  1.157816e+00,  2.007060e-01, -5.566260e-02},
  { 5.020795e-01, -3.756275e-01, -7.789865e-01,  1.180048e+00,  2.499928e-01, -6.469651e-02},
  { 6.246802e-01, -7.633712e-01, -1.644359e-01,  1.231411e+00,  2.677770e-01, -1.841080e-02},
  { 5.286573e-01, -7.800938e-01, -3.346266e-01,  1.251877e+00,  2.885008e-01, -3.590445e-02},
  { 4.647919e-01, -8.744382e-01, -1.390192e-01,  1.288687e+00,  3.053266e-01, -1.778977e-02},
  { 4.455688e-01, -8.404477e-01, -3.084089e-01,  1.315187e+00,  3.223329e-01, -3.525506e-02},
  { 5.556392e-01, -6.347127e-01, -5.370334e-01,  1.215169e+00,  2.688987e-01, -4.997278e-02},
  { 3.998777e-01, -5.355830e-01, -7.438069e-01,  1.226739e+00,  2.894335e-01, -6.155055e-02},
  { 4.272037e-01, -7.718211e-01, -4.709449e-01,  1.269945e+00,  3.056490e-01, -4.828676e-02},
  { 3.394134e-01, -5.609859e-01, -7.550452e-01,  1.285975e+00,  3.223329e-01, -6.043742e-02},
  { 4.273541e-01, -1.309127e-01, -8.945559e-01,  1.133374e+00,  2.059449e-01, -7.771146e-02},
  { 3.319872e-01, -2.217327e-02, -9.430233e-01,  1.147217e+00,  2.534697e-01, -7.531846e-02},
  { 2.698444e-01,  2.312411e-02, -9.626262e-01,  1.103208e+00,  2.124690e-01, -8.942977e-02},
  { 2.671870e-02,  1.149684e-01, -9.930098e-01,  1.113394e+00,  2.570497e-01, -8.626188e-02},
  { 2.767239e-01, -2.640179e-01, -9.239689e-01,  1.168448e+00,  2.712024e-01, -7.401237e-02},
  { 2.694102e-01, -2.864849e-01, -9.194262e-01,  1.153612e+00,  2.883290e-01, -8.354095e-02},
  { 2.424605e-01, -3.169258e-01, -9.169357e-01,  1.215913e+00,  3.056060e-01, -7.152825e-02},
  { 1.072309e-02,  1.172923e-01, -9.930395e-01,  1.197334e+00,  3.223329e-01, -8.058323e-02},
  {-8.819993e-02,  2.675104e-01, -9.595097e-01,  1.016995e+00,  9.091076e-02, -1.200737e-01},
  {-2.881785e-01,  3.507444e-01, -8.910283e-01,  1.032836e+00,  1.849374e-01, -9.490556e-02},
  {-5.186524e-01,  3.632244e-01, -7.739947e-01,  9.924073e-01,  1.088282e-01, -1.045803e-01},
  {-6.194584e-01,  4.059786e-01, -6.719022e-01,  1.007669e+00,  1.938080e-01, -7.592445e-02},
  {-8.108956e-01,  3.673836e-01, -4.554970e-01,  9.728523e-01,  1.230796e-01, -7.359377e-02},
  {-8.465219e-01,  4.121203e-01, -3.369829e-01,  9.898673e-01,  2.000828e-01, -4.428940e-02},
  {-9.308618e-01,  3.393035e-01, -1.355339e-01,  9.616781e-01,  1.312282e-01, -2.711336e-02},
  {-1.844071e-01,  3.188742e-01, -9.296845e-01,  1.071873e+00,  2.193454e-01, -8.942977e-02},
  {-2.569784e-01,  3.684761e-01, -8.934134e-01,  1.079570e+00,  2.606298e-01, -7.531846e-02},
  {-3.529555e-01,  3.858426e-01, -8.523778e-01,  1.041703e+00,  2.258694e-01, -7.771146e-02},
  {-4.687726e-01,  4.588072e-01, -7.548167e-01,  1.046740e+00,  2.641024e-01, -6.469651e-02},
  {-2.298272e-01,  3.435909e-01, -9.105629e-01,  1.116540e+00,  2.914534e-01, -7.299466e-02},
  {-3.508382e-01,  5.788999e-01, -7.360621e-01,  1.108692e+00,  3.223329e-01, -6.043742e-02},
  {-7.051653e-01,  4.522966e-01, -5.460492e-01,  1.017261e+00,  2.311041e-01, -5.566260e-02},
  {-7.301239e-01,  5.644285e-01, -3.851487e-01,  1.024774e+00,  2.664275e-01, -3.773960e-02},
  {-8.692089e-01,  4.608971e-01, -1.790246e-01,  1.003551e+00,  2.340739e-01, -2.050725e-02},
  {-5.564801e-01,  6.019779e-01, -5.726714e-01,  1.064919e+00,  2.938000e-01, -4.953225e-02},
  {-5.489789e-01,  7.518821e-01, -3.650966e-01,  1.079480e+00,  3.223329e-01, -3.525506e-02},
  {-7.047209e-01,  6.818720e-01, -1.960082e-01,  1.047273e+00,  2.945994e-01, -1.824877e-02},
  {-4.523218e-01,  8.871273e-01,  9.170675e-02,  1.089980e+00,  3.305804e-01,  1.707677e-02},
  {-3.563267e-01,  9.092541e-01,  2.151469e-01,  1.111159e+00,  3.407058e-01,  3.305159e-02},
  {-4.050196e-01,  9.143080e-01, -2.801780e-09,  1.100874e+00,  3.369453e-01,  0.000000e+00},
  {-4.000148e-01,  7.771112e-01,  4.858872e-01,  1.110441e+00,  3.316806e-01,  4.635105e-02},
  {-2.326334e-01,  8.149390e-01,  5.308071e-01,  1.142442e+00,  3.413506e-01,  5.666011e-02},
  {-1.828917e-01,  5.204516e-01,  8.340748e-01,  1.171461e+00,  3.323296e-01,  6.830707e-02},
  { 8.255377e-03,  5.491442e-01,  8.356869e-01,  1.237372e+00,  3.432974e-01,  7.554667e-02},
  {-3.365128e-01,  9.399987e-01,  5.622772e-02,  1.116853e+00,  3.427645e-01,  1.531382e-02},
  { 1.413853e-01,  9.793656e-01, -1.444068e-01,  1.133262e+00,  3.468989e-01,  2.820413e-02},
  { 1.642114e-01,  9.864252e-01,  0.000000e+00,  1.122123e+00,  3.465079e-01,  0.000000e+00},
  {-2.073373e-01,  9.454327e-01,  2.513331e-01,  1.137371e+00,  3.442215e-01,  4.156633e-02},
  { 3.197289e-02,  9.911627e-01, -1.287408e-01,  1.162625e+00,  3.479262e-01,  4.834994e-02},
  {-1.108209e-01,  8.837982e-01,  4.545540e-01,  1.198541e+00,  3.459019e-01,  6.125572e-02},
  {-1.181917e-02,  9.988761e-01,  4.590053e-02,  1.251726e+00,  3.510421e-01,  6.446659e-02},
  { 2.054608e-01, -2.111938e-01,  9.556061e-01,  1.263249e+00,  3.333009e-01,  6.830707e-02},
  { 4.014357e-01, -6.206265e-02,  9.137821e-01,  1.332305e+00,  3.452443e-01,  5.666011e-02},
  { 4.076729e-01, -7.669154e-01,  4.956244e-01,  1.324264e+00,  3.339498e-01,  4.635105e-02},
  { 6.402298e-01, -6.324002e-01,  4.360916e-01,  1.363589e+00,  3.458890e-01,  3.305159e-02},
  { 4.775257e-01, -8.747439e-01,  8.241586e-02,  1.344472e+00,  3.352520e-01,  1.707677e-02},
  { 5.581272e-01, -8.297554e-01, -1.881584e-09,  1.372846e+00,  3.504532e-01,  0.000000e+00},
  { 1.188640e-01,  6.792940e-01,  7.241762e-01,  1.290561e+00,  3.484333e-01,  6.125572e-02},
  { 1.370571e-01,  9.366804e-01,  3.222503e-01,  1.340832e+00,  3.541579e-01,  4.834994e-02},
  { 5.796103e-01,  1.031622e-01,  8.083375e-01,  1.351731e+00,  3.501180e-01,  4.156633e-02},
  { 5.004200e-01,  7.696914e-01,  3.964278e-01,  1.370194e+00,  3.551851e-01,  2.820413e-02},
  { 7.069101e-01, -6.833031e-01,  1.826881e-01,  1.371991e+00,  3.517727e-01,  1.531382e-02},
  { 8.552057e-01,  5.182888e-01,  0.000000e+00,  1.381330e+00,  3.555718e-01,  0.000000e+00},
  { 6.376850e-01,  7.232392e-01, -2.651092e-01,  1.130628e+00,  3.436670e-01,  1.289031e-02},
  { 7.650092e-01,  1.132999e-01, -6.339748e-01,  1.138295e+00,  3.408047e-01,  2.335667e-02},
  { 9.993886e-01,  3.496447e-02,  0.000000e+00,  1.128840e+00,  3.404652e-01,  0.000000e+00},
  { 3.501548e-01,  7.538724e-01, -5.559389e-01,  1.149353e+00,  3.443332e-01,  3.498773e-02},
  { 3.453006e-01,  3.146449e-01, -8.841754e-01,  1.163226e+00,  3.417029e-01,  4.003976e-02},
  { 7.550713e-02,  8.088839e-01, -5.830999e-01,  1.204116e+00,  3.462758e-01,  5.156080e-02},
  {-5.667911e-03,  6.027923e-01, -7.978780e-01,  1.238884e+00,  3.444321e-01,  5.338650e-02},
  { 6.878844e-01, -6.796462e-01, -2.547469e-01,  1.124319e+00,  3.314829e-01,  1.112736e-02},
  { 6.258098e-01, -6.081736e-01, -4.883514e-01,  1.118766e+00,  3.223329e-01,  2.115321e-02},
  { 7.155570e-01, -6.985543e-01,  0.000000e+00,  1.111378e+00,  3.223329e-01,  0.000000e+00},
  { 5.137765e-01, -4.927701e-01, -7.022901e-01,  1.139632e+00,  3.317924e-01,  3.020302e-02},
  { 3.724372e-01, -3.129180e-01, -8.737121e-01,  1.138239e+00,  3.223329e-01,  3.626245e-02},
  { 1.870016e-01, -9.091845e-02, -9.781432e-01,  1.184419e+00,  3.326992e-01,  4.450945e-02},
  { 1.213644e-02,  2.128313e-01, -9.770136e-01,  1.197334e+00,  3.223329e-01,  4.834994e-02},
  {-1.067040e-01,  9.021696e-01, -4.179764e-01,  1.286495e+00,  3.491983e-01,  5.156080e-02},
  {-2.056839e-01,  8.398473e-01, -5.023453e-01,  1.314542e+00,  3.471569e-01,  4.003976e-02},
  {-1.855615e-01,  9.568484e-01, -2.236248e-01,  1.341262e+00,  3.511366e-01,  3.498773e-02},
  {-2.733276e-01,  9.220510e-01, -2.740691e-01,  1.339474e+00,  3.480551e-01,  2.335667e-02},
  {-2.596683e-01,  9.519703e-01, -1.622491e-01,  1.360271e+00,  3.509475e-01,  1.289031e-02},
  {-3.109142e-01,  9.504380e-01,  7.647282e-09,  1.350089e+00,  3.449822e-01,  0.000000e+00},
  {-1.689940e-01,  5.164306e-01, -8.394882e-01,  1.251795e+00,  3.340616e-01,  4.450945e-02},
  {-2.592137e-01,  7.070363e-01, -6.579573e-01,  1.256428e+00,  3.223329e-01,  3.626245e-02},
  {-3.274881e-01,  8.396126e-01, -4.333615e-01,  1.296586e+00,  3.349684e-01,  3.020302e-02},
  {-3.432704e-01,  8.903719e-01, -2.990039e-01,  1.275901e+00,  3.223329e-01,  2.115321e-02},
  {-3.381253e-01,  9.200935e-01, -1.977355e-01,  1.312187e+00,  3.344269e-01,  1.112736e-02},
  {-3.337001e-01,  9.426793e-01,  1.887138e-08,  1.283289e+00,  3.223329e-01,  0.000000e+00},
  { 4.775257e-01, -8.747439e-01, -8.241588e-02,  1.344472e+00,  3.352520e-01, -1.707677e-02},
  { 6.402297e-01, -6.324001e-01, -4.360916e-01,  1.363589e+00,  3.458890e-01, -3.305159e-02},
  { 4.076729e-01, -7.669154e-01, -4.956244e-01,  1.324264e+00,  3.339498e-01, -4.635105e-02},
  { 4.014358e-01, -6.206265e-02, -9.137821e-01,  1.332305e+00,  3.452443e-01, -5.666011e-02},
  { 2.054608e-01, -2.111938e-01, -9.556061e-01,  1.263249e+00,  3.333009e-01, -6.830707e-02},
  { 8.255382e-03,  5.491443e-01, -8.356868e-01,  1.237372e+00,  3.432974e-01, -7.554667e-02},
  { 7.069101e-01, -6.833031e-01, -1.826881e-01,  1.371991e+00,  3.517727e-01, -1.531382e-02},
  { 5.004200e-01,  7.696914e-01, -3.964278e-01,  1.370194e+00,  3.551851e-01, -2.820413e-02},
  { 5.796103e-01,  1.031622e-01, -8.083375e-01,  1.351731e+00,  3.501180e-01, -4.156633e-02},
  { 1.370572e-01,  9.366804e-01, -3.222503e-01,  1.340832e+00,  3.541579e-01, -4.834994e-02},
  { 1.188640e-01,  6.792939e-01, -7.241763e-01,  1.290561e+00,  3.484333e-01, -6.125572e-02},
  {-1.181917e-02,  9.988761e-01, -4.590049e-02,  1.251726e+00,  3.510421e-01, -6.446659e-02},
  {-1.828917e-01,  5.204516e-01, -8.340748e-01,  1.171461e+00,  3.323296e-01, -6.830707e-02},
  {-2.326334e-01,  8.149390e-01, -5.308070e-01,  1.142442e+00,  3.413506e-01, -5.666011e-02},
  {-4.000148e-01,  7.771112e-01, -4.858871e-01,  1.110441e+00,  3.316806e-01, -4.635105e-02},
  {-3.563267e-01,  9.092541e-01, -2.151469e-01,  1.111159e+00,  3.407058e-01, -3.305159e-02},
  {-4.523218e-01,  8.871273e-01, -9.170675e-02,  1.089980e+00,  3.305804e-01, -1.707677e-02},
  {-1.108209e-01,  8.837982e-01, -4.545540e-01,  1.198541e+00,  3.459019e-01, -6.125572e-02},
  { 3.197289e-02,  9.911627e-01,  1.287408e-01,  1.162625e+00,  3.479262e-01, -4.834994e-02},
  {-2.073373e-01,  9.454327e-01, -2.513331e-01,  1.137371e+00,  3.442215e-01, -4.156633e-02},
  { 1.413853e-01,  9.793656e-01,  1.444068e-01,  1.133262e+00,  3.468989e-01, -2.820413e-02},
  {-3.365128e-01,  9.399987e-01, -5.622772e-02,  1.116853e+00,  3.427645e-01, -1.531382e-02},
  {-2.596682e-01,  9.519703e-01,  1.622491e-01,  1.360271e+00,  3.509475e-01, -1.289031e-02},
  {-2.733276e-01,  9.220510e-01,  2.740691e-01,  1.339474e+00,  3.480551e-01, -2.335667e-02},
  {-1.855614e-01,  9.568484e-01,  2.236248e-01,  1.341262e+00,  3.511366e-01, -3.498773e-02},
  {-2.056838e-01,  8.398473e-01,  5.023452e-01,  1.314542e+00,  3.471569e-01, -4.003976e-02},
  {-1.067040e-01,  9.021696e-01,  4.179764e-01,  1.286495e+00,  3.491983e-01, -5.156080e-02},
  {-5.667913e-03,  6.027924e-01,  7.978780e-01,  1.238884e+00,  3.444321e-01, -5.338650e-02},
  {-3.381253e-01,  9.200935e-01,  1.977355e-01,  1.312187e+00,  3.344269e-01, -1.112736e-02},
  {-3.432704e-01,  8.903719e-01,  2.990039e-01,  1.275901e+00,  3.223329e-01, -2.115321e-02},
  {-3.274881e-01,  8.396126e-01,  4.333615e-01,  1.296586e+00,  3.349684e-01, -3.020302e-02},
  {-2.592137e-01,  7.070363e-01,  6.579573e-01,  1.256428e+00,  3.223329e-01, -3.626245e-02},
  {-1.689940e-01,  5.164306e-01,  8.394882e-01,  1.251795e+00,  3.340616e-01, -4.450945e-02},
  { 1.213644e-02,  2.128313e-01,  9.770136e-01,  1.197334e+00,  3.223329e-01, -4.834994e-02},
  { 7.550713e-02,  8.088839e-01,  5.831000e-01,  1.204116e+00,  3.462758e-01, -5.156080e-02},
  { 3.453006e-01,  3.146450e-01,  8.841754e-01,  1.163226e+00,  3.417029e-01, -4.003976e-02},
  { 3.501548e-01,  7.538724e-01,  5.559389e-01,  1.149353e+00,  3.443332e-01, -3.498773e-02},
  { 7.650093e-01,  1.132999e-01,  6.339747e-01,  1.138295e+00,  3.408047e-01, -2.335667e-02},
  { 6.376850e-01,  7.232392e-01,  2.651092e-01,  1.130628e+00,  3.436670e-01, -1.289031e-02},
  { 1.870016e-01, -9.091844e-02,  9.781432e-01,  1.184419e+00,  3.326992e-01, -4.450945e-02},
  { 3.724372e-01, -3.129179e-01,  8.737121e-01,  1.138239e+00,  3.223329e-01, -3.626245e-02},
  { 5.137765e-01, -4.927701e-01,  7.022900e-01,  1.139632e+00,  3.317924e-01, -3.020302e-02},
  { 6.258097e-01, -6.081736e-01,  4.883513e-01,  1.118766e+00,  3.223329e-01, -2.115321e-02},
  { 6.878845e-01, -6.796462e-01,  2.547469e-01,  1.124319e+00,  3.314829e-01, -1.112736e-02},
  { 5.718725e-02,  9.983026e-01,  1.102282e-02, -4.444367e-02,  6.418337e-01,  9.789466e-03},
  {-1.749179e-09,  1.000000e+00, -3.731582e-09, -9.199809e-02,  6.446658e-01,  0.000000e+00},
  { 1.708445e-01,  9.828168e-01,  6.988190e-02, -6.635563e-04,  6.390014e-01,  3.915829e-02},
  { 1.850850e-01,  9.827225e-01,  4.700011e-10,  6.884192e-03,  6.390014e-01,  0.000000e+00},
  { 3.096659e-01,  9.489499e-01,  6.000876e-02,  2.594181e-02,  6.312568e-01,  2.423084e-02},
  { 6.297517e-01,  7.324332e-01,  2.587554e-01,  4.315137e-02,  6.235121e-01,  5.776507e-02},
  { 6.811435e-01,  7.321500e-01,  0.000000e+00,  5.439477e-02,  6.235121e-01,  0.000000e+00},
  { 4.819510e-02,  9.983252e-01,  3.199993e-02, -5.153586e-02,  6.418337e-01,  2.741850e-02},
  { 1.302901e-01,  9.828779e-01,  1.302901e-01, -2.148325e-02,  6.390014e-01,  7.051484e-02},
  { 2.618569e-01,  9.492602e-01,  1.741726e-01,  8.304178e-03,  6.312568e-01,  6.791253e-02},
  { 4.814268e-01,  7.324319e-01,  4.814268e-01,  1.221300e-02,  6.235121e-01,  1.042111e-01},
  { 9.136608e-01,  3.653614e-01,  1.781433e-01,  5.320602e-02,  6.119899e-01,  2.977411e-02},
  { 9.226396e-01, -6.764105e-02,  3.796852e-01,  5.164979e-02,  6.004719e-01,  6.133136e-02},
  { 9.977917e-01, -6.642034e-02, -2.097114e-09,  6.362811e-02,  6.004719e-01,  0.000000e+00},
  { 8.588892e-01, -4.838543e-01,  1.679121e-01,  4.996808e-02,  5.863063e-01,  2.908388e-02},
  { 7.546877e-01, -5.777863e-01,  3.108208e-01,  3.691488e-02,  5.721409e-01,  5.500461e-02},
  { 8.173534e-01, -5.761367e-01,  3.791703e-09,  4.767950e-02,  5.721409e-01,  0.000000e+00},
  { 7.746884e-01,  3.650457e-01,  5.163327e-01,  3.143264e-02,  6.119899e-01,  8.350571e-02},
  { 7.054374e-01, -6.867582e-02,  7.054373e-01,  1.871682e-02,  6.004719e-01,  1.107149e-01},
  { 7.267860e-01, -4.865360e-01,  4.848350e-01,  2.865413e-02,  5.863063e-01,  8.159578e-02},
  { 5.765199e-01, -5.790075e-01,  5.765198e-01,  7.334169e-03,  5.721409e-01,  9.933226e-02},
  { 3.199993e-02,  9.983252e-01,  4.819510e-02, -6.457959e-02,  6.418337e-01,  4.046224e-02},
  { 6.988189e-02,  9.828168e-01,  1.708445e-01, -5.283980e-02,  6.390014e-01,  9.133454e-02},
  { 1.741727e-01,  9.492602e-01,  2.618569e-01, -2.408556e-02,  6.312568e-01,  1.003023e-01},
  { 2.587554e-01,  7.324333e-01,  6.297516e-01, -3.423302e-02,  6.235121e-01,  1.351495e-01},
  { 1.102282e-02,  9.983026e-01,  5.718726e-02, -8.220863e-02,  6.418337e-01,  4.755442e-02},
  {-5.640015e-09,  9.827225e-01,  1.850850e-01, -9.199809e-02,  6.390014e-01,  9.888228e-02},
  { 6.000876e-02,  9.489499e-01,  3.096659e-01, -6.776725e-02,  6.312568e-01,  1.179399e-01},
  {-1.244790e-08,  7.321500e-01,  6.811435e-01, -9.199809e-02,  6.235121e-01,  1.463929e-01},
  { 5.163328e-01,  3.650458e-01,  7.746884e-01, -8.492378e-03,  6.119899e-01,  1.234307e-01},
  { 3.796853e-01, -6.764112e-02,  9.226395e-01, -3.066674e-02,  6.004719e-01,  1.436479e-01},
  { 4.848350e-01, -4.865360e-01,  7.267860e-01, -1.040231e-02,  5.863063e-01,  1.206522e-01},
  { 3.108208e-01, -5.777863e-01,  7.546877e-01, -3.699348e-02,  5.721409e-01,  1.289130e-01},
  { 1.781434e-01,  3.653614e-01,  9.136608e-01, -6.222398e-02,  6.119899e-01,  1.452041e-01},
  { 2.097114e-09, -6.642048e-02,  9.977917e-01, -9.199809e-02,  6.004719e-01,  1.556262e-01},
  { 1.679121e-01, -4.838543e-01,  8.588892e-01, -6.291421e-02,  5.863063e-01,  1.419662e-01},
  {-3.791704e-09, -5.761367e-01,  8.173534e-01, -9.199809e-02,  5.721409e-01,  1.396776e-01},
  { 7.470499e-01, -6.484295e-01,  1.464780e-01,  1.582097e-02,  5.404105e-01,  2.206777e-02},
  { 7.834349e-01, -5.307439e-01,  3.233273e-01, -1.392433e-02,  5.086800e-01,  3.326691e-02},
  { 8.484427e-01, -5.292873e-01, -1.911620e-09, -7.385697e-03,  5.086800e-01,  0.000000e+00},
  { 6.315745e-01, -6.505833e-01,  4.217288e-01, -3.872095e-04,  5.404105e-01,  6.193219e-02},
  { 5.988269e-01, -5.318015e-01,  5.988268e-01, -3.187311e-02,  5.086800e-01,  6.012497e-02},
  { 9.062811e-01, -3.831832e-01,  1.783963e-01, -1.687131e-02,  4.933842e-01,  1.535465e-02},
  { 9.232289e-01,  4.447377e-02,  3.816680e-01, -2.586311e-02,  4.780842e-01,  2.815213e-02},
  { 9.989954e-01,  4.481366e-02,  0.000000e+00, -2.031254e-02,  4.780842e-01,  0.000000e+00},
  { 8.697672e-01,  4.626581e-01,  1.716176e-01, -1.623052e-02,  4.646751e-01,  1.547241e-02},
  { 5.987003e-01,  7.617322e-01,  2.476326e-01, -1.270420e-02,  4.512661e-01,  3.373751e-02},
  { 6.485329e-01,  7.611866e-01,  2.017802e-09, -6.042644e-03,  4.512661e-01,  0.000000e+00},
  { 7.671248e-01, -3.852905e-01,  5.129044e-01, -2.818692e-02,  4.933842e-01,  4.311353e-02},
  { 7.064176e-01,  4.414005e-02,  7.064176e-01, -4.108754e-02,  4.780842e-01,  5.091055e-02},
  { 7.363133e-01,  4.637872e-01,  4.926908e-01, -2.765614e-02,  4.646751e-01,  4.345736e-02},
  { 4.578988e-01,  7.620087e-01,  4.578989e-01, -3.096972e-02,  4.512661e-01,  6.102837e-02},
  { 4.217288e-01, -6.505833e-01,  6.315745e-01, -3.006590e-02,  5.404105e-01,  9.161088e-02},
  { 3.233274e-01, -5.307439e-01,  7.834349e-01, -5.873118e-02,  5.086800e-01,  7.807375e-02},
  { 1.464780e-01, -6.484295e-01,  7.470498e-01, -6.993032e-02,  5.404105e-01,  1.078191e-01},
  {-1.146972e-08, -5.292872e-01,  8.484427e-01, -9.199809e-02,  5.086800e-01,  8.461239e-02},
  { 5.129043e-01, -3.852905e-01,  7.671248e-01, -4.888456e-02,  4.933842e-01,  6.381118e-02},
  { 3.816681e-01,  4.447374e-02,  9.232289e-01, -6.384596e-02,  4.780842e-01,  6.613497e-02},
  { 4.926907e-01,  4.637872e-01,  7.363133e-01, -4.854074e-02,  4.646751e-01,  6.434195e-02},
  { 2.476327e-01,  7.617322e-01,  5.987003e-01, -5.826058e-02,  4.512661e-01,  7.929389e-02},
  { 1.783964e-01, -3.831832e-01,  9.062811e-01, -7.664344e-02,  4.933842e-01,  7.512678e-02},
  {-1.676320e-08,  4.481369e-02,  9.989954e-01, -9.199809e-02,  4.780842e-01,  7.168555e-02},
  { 1.716178e-01,  4.626581e-01,  8.697672e-01, -7.652568e-02,  4.646751e-01,  7.576758e-02},
  {-7.062308e-09,  7.611865e-01,  6.485330e-01, -9.199809e-02,  4.512661e-01,  8.595545e-02},
  {-1.102282e-02,  9.983026e-01,  5.718726e-02, -1.017876e-01,  6.418337e-01,  4.755442e-02},
  {-6.988190e-02,  9.828168e-01,  1.708446e-01, -1.311564e-01,  6.390014e-01,  9.133454e-02},
  {-6.000878e-02,  9.489499e-01,  3.096659e-01, -1.162289e-01,  6.312568e-01,  1.179399e-01},
  {-2.587554e-01,  7.324333e-01,  6.297516e-01, -1.497632e-01,  6.235121e-01,  1.351495e-01},
  {-3.199993e-02,  9.983252e-01,  4.819511e-02, -1.194166e-01,  6.418337e-01,  4.046224e-02},
  {-1.302901e-01,  9.828779e-01,  1.302901e-01, -1.625129e-01,  6.390014e-01,  7.051484e-02},
  {-1.741726e-01,  9.492602e-01,  2.618569e-01, -1.599106e-01,  6.312568e-01,  1.003023e-01},
  {-4.814268e-01,  7.324319e-01,  4.814267e-01, -1.962092e-01,  6.235121e-01,  1.042111e-01},
  {-1.781434e-01,  3.653615e-01,  9.136608e-01, -1.217722e-01,  6.119899e-01,  1.452041e-01},
  {-3.796853e-01, -6.764106e-02,  9.226395e-01, -1.533294e-01,  6.004719e-01,  1.436479e-01},
  {-1.679122e-01, -4.838543e-01,  8.588892e-01, -1.210820e-01,  5.863063e-01,  1.419662e-01},
  {-3.108208e-01, -5.777863e-01,  7.546877e-01, -1.470027e-01,  5.721409e-01,  1.289130e-01},
  {-5.163327e-01,  3.650459e-01,  7.746884e-01, -1.755038e-01,  6.119899e-01,  1.234307e-01},
  {-7.054374e-01, -6.867575e-02,  7.054372e-01, -2.027130e-01,  6.004719e-01,  1.107149e-01},
  {-4.848350e-01, -4.865360e-01,  7.267859e-01, -1.735939e-01,  5.863063e-01,  1.206522e-01},
  {-5.765198e-01, -5.790076e-01,  5.765198e-01, -1.913303e-01,  5.721409e-01,  9.933226e-02},
  {-4.819509e-02,  9.983252e-01,  3.199993e-02, -1.324603e-01,  6.418337e-01,  2.741850e-02},
  {-1.708446e-01,  9.828167e-01,  6.988192e-02, -1.833326e-01,  6.390014e-01,  3.915829e-02},
  {-2.618569e-01,  9.492601e-01,  1.741727e-01, -1.923003e-01,  6.312568e-01,  6.791253e-02},
  {-6.297514e-01,  7.324334e-01,  2.587555e-01, -2.271475e-01,  6.235121e-01,  5.776507e-02},
  {-5.718726e-02,  9.983026e-01,  1.102280e-02, -1.395525e-01,  6.418337e-01,  9.789466e-03},
  {-1.850850e-01,  9.827225e-01, -1.410004e-09, -1.908804e-01,  6.390014e-01,  0.000000e+00},
  {-3.096660e-01,  9.489499e-01,  6.000876e-02, -2.099380e-01,  6.312568e-01,  2.423084e-02},
  {-6.811433e-01,  7.321501e-01, -2.074650e-09, -2.383910e-01,  6.235121e-01,  0.000000e+00},
  {-7.746884e-01,  3.650459e-01,  5.163327e-01, -2.154288e-01,  6.119899e-01,  8.350571e-02},
  {-9.226395e-01, -6.764121e-02,  3.796853e-01, -2.356460e-01,  6.004719e-01,  6.133136e-02},
  {-7.267859e-01, -4.865361e-01,  4.848349e-01, -2.126503e-01,  5.863063e-01,  8.159578e-02},
  {-7.546877e-01, -5.777863e-01,  3.108207e-01, -2.209111e-01,  5.721409e-01,  5.500461e-02},
  {-9.136608e-01,  3.653614e-01,  1.781434e-01, -2.372022e-01,  6.119899e-01,  2.977411e-02},
  {-9.977917e-01, -6.642073e-02,  2.097114e-09, -2.476243e-01,  6.004719e-01,  0.000000e+00},
  {-8.588892e-01, -4.838543e-01,  1.679121e-01, -2.339642e-01,  5.863063e-01,  2.908388e-02},
  {-8.173534e-01, -5.761367e-01,  7.583408e-09, -2.316757e-01,  5.721409e-01,  0.000000e+00},
  {-1.464780e-01, -6.484295e-01,  7.470498e-01, -1.140659e-01,  5.404105e-01,  1.078191e-01},
  {-3.233275e-01, -5.307439e-01,  7.834349e-01, -1.252650e-01,  5.086800e-01,  7.807375e-02},
  {-4.217288e-01, -6.505833e-01,  6.315745e-01, -1.539303e-01,  5.404105e-01,  9.161088e-02},
  {-5.988268e-01, -5.318016e-01,  5.988268e-01, -1.521231e-01,  5.086800e-01,  6.012497e-02},
  {-1.783964e-01, -3.831832e-01,  9.062811e-01, -1.073527e-01,  4.933842e-01,  7.512678e-02},
  {-3.816682e-01,  4.447382e-02,  9.232288e-01, -1.201502e-01,  4.780842e-01,  6.613497e-02},
  {-1.716177e-01,  4.626580e-01,  8.697671e-01, -1.074705e-01,  4.646751e-01,  7.576758e-02},
  {-2.476327e-01,  7.617322e-01,  5.987003e-01, -1.257356e-01,  4.512661e-01,  7.929389e-02},
  {-5.129044e-01, -3.852904e-01,  7.671247e-01, -1.351116e-01,  4.933842e-01,  6.381118e-02},
  {-7.064177e-01,  4.414019e-02,  7.064175e-01, -1.429086e-01,  4.780842e-01,  5.091055e-02},
  {-4.926908e-01,  4.637872e-01,  7.363133e-01, -1.354554e-01,  4.646751e-01,  6.434195e-02},
  {-4.578989e-01,  7.620087e-01,  4.578987e-01, -1.530265e-01,  4.512661e-01,  6.102837e-02},
  {-6.315744e-01, -6.505833e-01,  4.217288e-01, -1.836090e-01,  5.404105e-01,  6.193219e-02},
  {-7.834349e-01, -5.307441e-01,  3.233274e-01, -1.700719e-01,  5.086800e-01,  3.326691e-02},
  {-7.470499e-01, -6.484295e-01,  1.464780e-01, -1.998172e-01,  5.404105e-01,  2.206777e-02},
  {-8.484427e-01, -5.292873e-01,  1.146972e-08, -1.766105e-01,  5.086800e-01,  0.000000e+00},
  {-7.671247e-01, -3.852904e-01,  5.129045e-01, -1.558093e-01,  4.933842e-01,  4.311353e-02},
  {-9.232289e-01,  4.447373e-02,  3.816681e-01, -1.581331e-01,  4.780842e-01,  2.815213e-02},
  {-7.363135e-01,  4.637870e-01,  4.926908e-01, -1.563400e-01,  4.646751e-01,  4.345736e-02},
  {-5.987004e-01,  7.617322e-01,  2.476326e-01, -1.712920e-01,  4.512661e-01,  3.373751e-02},
  {-9.062811e-01, -3.831833e-01,  1.783961e-01, -1.671249e-01,  4.933842e-01,  1.535465e-02},
  {-9.989954e-01,  4.481357e-02, -4.190799e-09, -1.636836e-01,  4.780842e-01,  0.000000e+00},
  {-8.697673e-01,  4.626578e-01,  1.716175e-01, -1.677657e-01,  4.646751e-01,  1.547241e-02},
  {-6.485330e-01,  7.611864e-01,  6.053407e-09, -1.779535e-01,  4.512661e-01,  0.000000e+00},
  {-5.718726e-02,  9.983026e-01, -1.102282e-02, -1.395525e-01,  6.418337e-01, -9.789466e-03},
  {-1.708446e-01,  9.828168e-01, -6.988193e-02, -1.833326e-01,  6.390014e-01, -3.915829e-02},
  {-3.096660e-01,  9.489499e-01, -6.000875e-02, -2.099380e-01,  6.312568e-01, -2.423084e-02},
  {-6.297515e-01,  7.324334e-01, -2.587555e-01, -2.271475e-01,  6.235121e-01, -5.776507e-02},
  {-4.819509e-02,  9.983252e-01, -3.199994e-02, -1.324603e-01,  6.418337e-01, -2.741850e-02},
  {-1.302901e-01,  9.828779e-01, -1.302901e-01, -1.625129e-01,  6.390014e-01, -7.051484e-02},
  {-2.618569e-01,  9.492601e-01, -1.741727e-01, -1.923003e-01,  6.312568e-01, -6.791253e-02},
  {-4.814267e-01,  7.324319e-01, -4.814267e-01, -1.962092e-01,  6.235121e-01, -1.042111e-01},
  {-9.136608e-01,  3.653614e-01, -1.781434e-01, -2.372022e-01,  6.119899e-01, -2.977411e-02},
  {-9.226395e-01, -6.764118e-02, -3.796853e-01, -2.356460e-01,  6.004719e-01, -6.133136e-02},
  {-8.588892e-01, -4.838544e-01, -1.679121e-01, -2.339642e-01,  5.863063e-01, -2.908388e-02},
  {-7.546877e-01, -5.777861e-01, -3.108207e-01, -2.209111e-01,  5.721409e-01, -5.500461e-02},
  {-7.746884e-01,  3.650459e-01, -5.163327e-01, -2.154288e-01,  6.119899e-01, -8.350571e-02},
  {-7.054374e-01, -6.867576e-02, -7.054373e-01, -2.027130e-01,  6.004719e-01, -1.107149e-01},
  {-7.267860e-01, -4.865361e-01, -4.848350e-01, -2.126503e-01,  5.863063e-01, -8.159578e-02},
  {-5.765198e-01, -5.790076e-01, -5.765198e-01, -1.913303e-01,  5.721409e-01, -9.933226e-02},
  {-3.199994e-02,  9.983252e-01, -4.819511e-02, -1.194166e-01,  6.418337e-01, -4.046224e-02},
  {-6.988192e-02,  9.828167e-01, -1.708446e-01, -1.311564e-01,  6.390014e-01, -9.133454e-02},
  {-1.741727e-01,  9.492602e-01, -2.618569e-01, -1.599106e-01,  6.312568e-01, -1.003023e-01},
  {-2.587554e-01,  7.324333e-01, -6.297516e-01, -1.497632e-01,  6.235121e-01, -1.351495e-01},
  {-1.102282e-02,  9.983026e-01, -5.718725e-02, -1.017876e-01,  6.418337e-01, -4.755442e-02},
  {-9.400024e-10,  9.827225e-01, -1.850850e-01, -9.199809e-02,  6.390014e-01, -9.888228e-02},
  {-6.000878e-02,  9.489499e-01, -3.096659e-01, -1.162289e-01,  6.312568e-01, -1.179399e-01},
  {-1.244790e-08,  7.321500e-01, -6.811435e-01, -9.199809e-02,  6.235121e-01, -1.463929e-01},
  {-5.163328e-01,  3.650459e-01, -7.746883e-01, -1.755038e-01,  6.119899e-01, -1.234307e-01},
  {-3.796853e-01, -6.764107e-02, -9.226395e-01, -1.533294e-01,  6.004719e-01, -1.436479e-01},
  {-4.848350e-01, -4.865361e-01, -7.267859e-01, -1.735939e-01,  5.863063e-01, -1.206522e-01},
  {-3.108208e-01, -5.777863e-01, -7.546877e-01, -1.470027e-01,  5.721409e-01, -1.289130e-01},
  {-1.781434e-01,  3.653615e-01, -9.136608e-01, -1.217722e-01,  6.119899e-01, -1.452041e-01},
  {-2.097114e-09, -6.642046e-02, -9.977917e-01, -9.199809e-02,  6.004719e-01, -1.556262e-01},
  {-1.679122e-01, -4.838543e-01, -8.588891e-01, -1.210820e-01,  5.863063e-01, -1.419662e-01},
  {-1.516682e-08, -5.761367e-01, -8.173534e-01, -9.199809e-02,  5.721409e-01, -1.396776e-01},
  {-7.470499e-01, -6.484294e-01, -1.464780e-01, -1.998172e-01,  5.404105e-01, -2.206777e-02},
  {-7.834349e-01, -5.307440e-01, -3.233273e-01, -1.700719e-01,  5.086800e-01, -3.326691e-02},
  {-6.315745e-01, -6.505833e-01, -4.217288e-01, -1.836090e-01,  5.404105e-01, -6.193219e-02},
  {-5.988268e-01, -5.318016e-01, -5.988268e-01, -1.521231e-01,  5.086800e-01, -6.012497e-02},
  {-9.062811e-01, -3.831833e-01, -1.783961e-01, -1.671249e-01,  4.933842e-01, -1.535465e-02},
  {-9.232289e-01,  4.447373e-02, -3.816680e-01, -1.581331e-01,  4.780842e-01, -2.815213e-02},
  {-8.697674e-01,  4.626578e-01, -1.716175e-01, -1.677657e-01,  4.646751e-01, -1.547241e-02},
  {-5.987005e-01,  7.617322e-01, -2.476326e-01, -1.712920e-01,  4.512661e-01, -3.373751e-02},
  {-7.671247e-01, -3.852904e-01, -5.129045e-01, -1.558093e-01,  4.933842e-01, -4.311353e-02},
  {-7.064176e-01,  4.414020e-02, -7.064176e-01, -1.429086e-01,  4.780842e-01, -5.091055e-02},
  {-7.363135e-01,  4.637870e-01, -4.926908e-01, -1.563400e-01,  4.646751e-01, -4.345736e-02},
  {-4.578988e-01,  7.620087e-01, -4.578988e-01, -1.530265e-01,  4.512661e-01, -6.102837e-02},
  {-4.217288e-01, -6.505833e-01, -6.315745e-01, -1.539303e-01,  5.404105e-01, -9.161088e-02},
  {-3.233275e-01, -5.307439e-01, -7.834349e-01, -1.252650e-01,  5.086800e-01, -7.807375e-02},
  {-1.464780e-01, -6.484296e-01, -7.470497e-01, -1.140659e-01,  5.404105e-01, -1.078191e-01},
  {-1.911619e-08, -5.292872e-01, -8.484427e-01, -9.199809e-02,  5.086800e-01, -8.461239e-02},
  {-5.129044e-01, -3.852904e-01, -7.671247e-01, -1.351116e-01,  4.933842e-01, -6.381118e-02},
  {-3.816682e-01,  4.447381e-02, -9.232288e-01, -1.201502e-01,  4.780842e-01, -6.613497e-02},
  {-4.926908e-01,  4.637872e-01, -7.363133e-01, -1.354554e-01,  4.646751e-01, -6.434195e-02},
  {-2.476327e-01,  7.617322e-01, -5.987003e-01, -1.257356e-01,  4.512661e-01, -7.929389e-02},
  {-1.783964e-01, -3.831832e-01, -9.062811e-01, -1.073527e-01,  4.933842e-01, -7.512678e-02},
  {-1.257240e-08,  4.481369e-02, -9.989954e-01, -9.199809e-02,  4.780842e-01, -7.168555e-02},
  {-1.716178e-01,  4.626581e-01, -8.697671e-01, -1.074705e-01,  4.646751e-01, -7.576758e-02},
  { 2.017802e-09,  7.611865e-01, -6.485330e-01, -9.199809e-02,  4.512661e-01, -8.595545e-02},
  { 1.102282e-02,  9.983026e-01, -5.718726e-02, -8.220863e-02,  6.418337e-01, -4.755442e-02},
  { 6.988189e-02,  9.828168e-01, -1.708445e-01, -5.283980e-02,  6.390014e-01, -9.133454e-02},
  { 6.000876e-02,  9.489499e-01, -3.096659e-01, -6.776725e-02,  6.312568e-01, -1.179399e-01},
  { 2.587554e-01,  7.324332e-01, -6.297516e-01, -3.423302e-02,  6.235121e-01, -1.351495e-01},
  { 3.199993e-02,  9.983252e-01, -4.819510e-02, -6.457959e-02,  6.418337e-01, -4.046224e-02},
  { 1.302901e-01,  9.828779e-01, -1.302901e-01, -2.148325e-02,  6.390014e-01, -7.051484e-02},
  { 1.741727e-01,  9.492602e-01, -2.618569e-01, -2.408556e-02,  6.312568e-01, -1.003023e-01},
  { 4.814268e-01,  7.324319e-01, -4.814268e-01,  1.221300e-02,  6.235121e-01, -1.042111e-01},
  { 1.781434e-01,  3.653614e-01, -9.136608e-01, -6.222398e-02,  6.119899e-01, -1.452041e-01},
  { 3.796852e-01, -6.764109e-02, -9.226395e-01, -3.066674e-02,  6.004719e-01, -1.436479e-01},
  { 1.679121e-01, -4.838543e-01, -8.588892e-01, -6.291421e-02,  5.863063e-01, -1.419662e-01},
  { 3.108208e-01, -5.777863e-01, -7.546877e-01, -3.699348e-02,  5.721409e-01, -1.289130e-01},
  { 5.163327e-01,  3.650458e-01, -7.746884e-01, -8.492378e-03,  6.119899e-01, -1.234307e-01},
  { 7.054373e-01, -6.867578e-02, -7.054373e-01,  1.871682e-02,  6.004719e-01, -1.107149e-01},
  { 4.848350e-01, -4.865360e-01, -7.267860e-01, -1.040231e-02,  5.863063e-01, -1.206522e-01},
  { 5.765198e-01, -5.790075e-01, -5.765199e-01,  7.334169e-03,  5.721409e-01, -9.933226e-02},
  { 4.819511e-02,  9.983252e-01, -3.199993e-02, -5.153586e-02,  6.418337e-01, -2.741850e-02},
  { 1.708445e-01,  9.828167e-01, -6.988190e-02, -6.635563e-04,  6.390014e-01, -3.915829e-02},
  { 2.618569e-01,  9.492602e-01, -1.741726e-01,  8.304178e-03,  6.312568e-01, -6.791253e-02},
  { 6.297517e-01,  7.324332e-01, -2.587554e-01,  4.315137e-02,  6.235121e-01, -5.776507e-02},
  { 5.718724e-02,  9.983026e-01, -1.102282e-02, -4.444367e-02,  6.418337e-01, -9.789466e-03},
  { 3.096659e-01,  9.489499e-01, -6.000876e-02,  2.594181e-02,  6.312568e-01, -2.423084e-02},
  { 7.746884e-01,  3.650458e-01, -5.163328e-01,  3.143264e-02,  6.119899e-01, -8.350571e-02},
  { 9.226396e-01, -6.764104e-02, -3.796852e-01,  5.164979e-02,  6.004719e-01, -6.133136e-02},
  { 7.267860e-01, -4.865360e-01, -4.848350e-01,  2.865413e-02,  5.863063e-01, -8.159578e-02},
  { 7.546877e-01, -5.777863e-01, -3.108208e-01,  3.691488e-02,  5.721409e-01, -5.500461e-02},
  { 9.136608e-01,  3.653614e-01, -1.781434e-01,  5.320602e-02,  6.119899e-01, -2.977411e-02},
  { 8.588892e-01, -4.838543e-01, -1.679121e-01,  4.996808e-02,  5.863063e-01, -2.908388e-02},
  { 1.464780e-01, -6.484295e-01, -7.470497e-01, -6.993032e-02,  5.404105e-01, -1.078191e-01},
  { 3.233274e-01, -5.307438e-01, -7.834349e-01, -5.873118e-02,  5.086800e-01, -7.807375e-02},
  { 4.217288e-01, -6.505833e-01, -6.315745e-01, -3.006590e-02,  5.404105e-01, -9.161088e-02},
  { 5.988268e-01, -5.318015e-01, -5.988269e-01, -3.187311e-02,  5.086800e-01, -6.012497e-02},
  { 1.783964e-01, -3.831832e-01, -9.062811e-01, -7.664344e-02,  4.933842e-01, -7.512678e-02},
  { 3.816681e-01,  4.447376e-02, -9.232289e-01, -6.384596e-02,  4.780842e-01, -6.613497e-02},
  { 1.716177e-01,  4.626580e-01, -8.697671e-01, -7.652568e-02,  4.646751e-01, -7.576758e-02},
  { 2.476327e-01,  7.617322e-01, -5.987004e-01, -5.826058e-02,  4.512661e-01, -7.929389e-02},
  { 5.129043e-01, -3.852905e-01, -7.671248e-01, -4.888456e-02,  4.933842e-01, -6.381118e-02},
  { 7.064176e-01,  4.414006e-02, -7.064176e-01, -4.108754e-02,  4.780842e-01, -5.091055e-02},
  { 4.926907e-01,  4.637872e-01, -7.363133e-01, -4.854074e-02,  4.646751e-01, -6.434195e-02},
  { 4.578988e-01,  7.620087e-01, -4.578989e-01, -3.096972e-02,  4.512661e-01, -6.102837e-02},
  { 6.315745e-01, -6.505833e-01, -4.217288e-01, -3.872095e-04,  5.404105e-01, -6.193219e-02},
  { 7.834349e-01, -5.307439e-01, -3.233274e-01, -1.392433e-02,  5.086800e-01, -3.326691e-02},
  { 7.470499e-01, -6.484295e-01, -1.464780e-01,  1.582097e-02,  5.404105e-01, -2.206777e-02},
  { 7.671247e-01, -3.852905e-01, -5.129044e-01, -2.818692e-02,  4.933842e-01, -4.311353e-02},
  { 9.232289e-01,  4.447379e-02, -3.816680e-01, -2.586311e-02,  4.780842e-01, -2.815213e-02},
  { 7.363133e-01,  4.637872e-01, -4.926908e-01, -2.765614e-02,  4.646751e-01, -4.345736e-02},
  { 5.987003e-01,  7.617322e-01, -2.476327e-01, -1.270420e-02,  4.512661e-01, -3.373751e-02},
  { 9.062811e-01, -3.831832e-01, -1.783963e-01, -1.687131e-02,  4.933842e-01, -1.535465e-02},
  { 8.697672e-01,  4.626581e-01, -1.716176e-01, -1.623052e-02,  4.646751e-01, -1.547241e-02},
  { 3.276017e-01,  9.425991e-01,  6.468534e-02,  4.355794e-02,  4.321281e-01,  2.767551e-02},
  { 2.264765e-01,  9.694996e-01,  9.369580e-02,  8.889127e-02,  4.129901e-01,  7.696365e-02},
  { 2.456314e-01,  9.693633e-01,  0.000000e+00,  1.040878e-01,  4.129901e-01,  0.000000e+00},
  { 2.765328e-01,  9.430138e-01,  1.850803e-01,  2.311001e-02,  4.321281e-01,  7.773767e-02},
  { 1.730680e-01,  9.695849e-01,  1.730680e-01,  4.722309e-02,  4.129901e-01,  1.392212e-01},
  { 1.604222e-01,  9.867918e-01,  2.250902e-02,  1.796203e-01,  3.998948e-01,  2.786031e-02},
  { 1.577539e-01,  9.869841e-01,  3.124192e-02,  9.634791e-02,  4.129901e-01,  3.919869e-02},
  { 1.671353e-01,  9.853721e-01,  3.328117e-02,  2.554768e-01,  3.867995e-01,  7.224297e-02},
  { 1.715178e-01,  9.851810e-01,  1.863045e-09,  2.625681e-01,  3.867995e-01,  0.000000e+00},
  { 1.567003e-01,  9.868179e-01,  4.044027e-02,  1.689515e-01,  3.998948e-01,  8.189319e-02},
  { 1.580123e-01,  9.852504e-01,  6.567885e-02,  2.350895e-01,  3.867995e-01,  1.391674e-01},
  { 1.390735e-01,  9.868582e-01,  8.227629e-02,  1.486655e-01,  3.998948e-01,  1.309579e-01},
  { 1.333752e-01,  9.870346e-01,  8.929632e-02,  6.794737e-02,  4.129901e-01,  1.082562e-01},
  { 1.412738e-01,  9.854363e-01,  9.464195e-02,  2.027350e-01,  3.867995e-01,  1.994437e-01},
  { 1.289625e-01,  9.868720e-01,  9.722396e-02,  1.194123e-01,  3.998948e-01,  1.746658e-01},
  { 1.208221e-01,  9.852939e-01,  1.208221e-01,  1.597439e-01,  3.867995e-01,  2.517420e-01},
  { 1.850803e-01,  9.430137e-01,  2.765328e-01, -1.426042e-02,  4.321281e-01,  1.151081e-01},
  { 9.369582e-02,  9.694996e-01,  2.264765e-01, -1.503445e-02,  4.129901e-01,  1.808894e-01},
  { 6.468539e-02,  9.425991e-01,  3.276016e-01, -6.432258e-02,  4.321281e-01,  1.355560e-01},
  {-5.849682e-09,  9.693633e-01,  2.456314e-01, -9.199809e-02,  4.129901e-01,  1.960859e-01},
  { 9.722395e-02,  9.868720e-01,  1.289625e-01,  8.266768e-02,  3.998948e-01,  2.114104e-01},
  { 8.929630e-02,  9.870346e-01,  1.333752e-01,  1.625806e-02,  4.129901e-01,  1.599455e-01},
  { 9.464194e-02,  9.854363e-01,  1.412738e-01,  1.074456e-01,  3.867995e-01,  2.947330e-01},
  { 8.227627e-02,  9.868582e-01,  1.390735e-01,  3.895976e-02,  3.998948e-01,  2.406636e-01},
  { 6.567886e-02,  9.852504e-01,  1.580123e-01,  4.716936e-02,  3.867995e-01,  3.270875e-01},
  { 4.044027e-02,  9.868179e-01,  1.567003e-01, -1.010490e-02,  3.998948e-01,  2.609496e-01},
  { 3.124192e-02,  9.869841e-01,  1.577539e-01, -5.279940e-02,  4.129901e-01,  1.883460e-01},
  { 3.328115e-02,  9.853721e-01,  1.671353e-01, -1.975512e-02,  3.867995e-01,  3.474749e-01},
  { 2.250907e-02,  9.867918e-01,  1.604222e-01, -6.413779e-02,  3.998948e-01,  2.716183e-01},
  {-9.315227e-10,  9.851810e-01,  1.715178e-01, -9.199809e-02,  3.867995e-01,  3.545662e-01},
  { 1.809061e-01,  9.833400e-01,  1.775973e-02,  3.294926e-01,  3.737042e-01,  4.337312e-02},
  { 2.616790e-01,  9.637452e-01,  5.214594e-02,  3.949910e-01,  3.606089e-01,  1.012495e-01},
  { 2.670534e-01,  9.636818e-01,  1.870652e-09,  4.049318e-01,  3.606089e-01,  0.000000e+00},
  { 1.736132e-01,  9.833928e-01,  5.288660e-02,  3.129947e-01,  3.737042e-01,  1.269261e-01},
  { 2.460176e-01,  9.638512e-01,  1.023048e-01,  3.664195e-01,  3.606089e-01,  1.950449e-01},
  { 1.596610e-01,  9.834449e-01,  8.570030e-02,  2.813296e-01,  3.737042e-01,  2.032945e-01},
  { 2.211260e-01,  9.639268e-01,  1.481503e-01,  3.210750e-01,  3.606089e-01,  2.795232e-01},
  { 1.398604e-01,  9.834740e-01,  1.149699e-01,  2.360938e-01,  3.737042e-01,  2.708822e-01},
  { 1.881375e-01,  9.639546e-01,  1.881375e-01,  2.608224e-01,  3.606089e-01,  3.528205e-01},
  { 3.509197e-01,  9.357716e-01,  3.445062e-02,  4.222346e-01,  3.521724e-01,  5.291632e-02},
  { 5.789853e-01,  8.071318e-01,  1.153872e-01,  4.390862e-01,  3.437358e-01,  1.104166e-01},
  { 5.907010e-01,  8.068905e-01, -2.906983e-09,  4.499252e-01,  3.437358e-01,  0.000000e+00},
  { 3.368187e-01,  9.359627e-01,  1.026008e-01,  4.021082e-01,  3.521724e-01,  1.548539e-01},
  { 5.446326e-01,  8.075073e-01,  2.265111e-01,  4.079274e-01,  3.437358e-01,  2.127045e-01},
  { 7.845027e-01,  6.153254e-01,  7.700808e-02,  4.528133e-01,  3.330344e-01,  5.606358e-02},
  { 7.713806e-01,  6.175230e-01,  1.537445e-01,  4.555381e-01,  3.223329e-01,  1.138372e-01},
  { 7.868035e-01,  6.172036e-01, -1.868194e-09,  4.667123e-01,  3.223329e-01,  0.000000e+00},
  { 7.536042e-01,  6.159374e-01,  2.295687e-01,  4.314921e-01,  3.330344e-01,  1.640632e-01},
  { 7.258287e-01,  6.180993e-01,  3.018709e-01,  4.234122e-01,  3.223329e-01,  2.192938e-01},
  { 3.098089e-01,  9.361424e-01,  1.663008e-01,  3.634755e-01,  3.521724e-01,  2.480261e-01},
  { 4.896962e-01,  8.078048e-01,  3.280994e-01,  3.584729e-01,  3.437358e-01,  3.048311e-01},
  { 2.714206e-01,  9.362434e-01,  2.231127e-01,  3.082848e-01,  3.521724e-01,  3.304849e-01},
  { 4.167167e-01,  8.078950e-01,  4.167167e-01,  2.927668e-01,  3.437358e-01,  3.847649e-01},
  { 6.936635e-01,  6.165975e-01,  3.723419e-01,  3.905601e-01,  3.330344e-01,  2.627761e-01},
  { 6.527120e-01,  6.186414e-01,  4.373212e-01,  3.724321e-01,  3.223329e-01,  3.142746e-01},
  { 6.079534e-01,  6.169564e-01,  4.997576e-01,  3.320893e-01,  3.330344e-01,  3.501386e-01},
  { 5.554916e-01,  6.187553e-01,  5.554916e-01,  3.046863e-01,  3.223329e-01,  3.966844e-01},
  { 1.149699e-01,  9.834740e-01,  1.398604e-01,  1.788841e-01,  3.737042e-01,  3.280919e-01},
  { 1.481503e-01,  9.639268e-01,  2.211260e-01,  1.875251e-01,  3.606089e-01,  4.130731e-01},
  { 8.570030e-02,  9.834449e-01,  1.596610e-01,  1.112964e-01,  3.737042e-01,  3.733277e-01},
  { 1.023049e-01,  9.638512e-01,  2.460176e-01,  1.030468e-01,  3.606089e-01,  4.584176e-01},
  { 5.288658e-02,  9.833928e-01,  1.736132e-01,  3.492801e-02,  3.737042e-01,  4.049928e-01},
  { 5.214593e-02,  9.637453e-01,  2.616788e-01,  9.251407e-03,  3.606089e-01,  4.869891e-01},
  { 1.775976e-02,  9.833400e-01,  1.809061e-01, -4.862497e-02,  3.737042e-01,  4.214907e-01},
  { 0.000000e+00,  9.636818e-01,  2.670533e-01, -9.199809e-02,  3.606089e-01,  4.969299e-01},
  { 2.231126e-01,  9.362434e-01,  2.714206e-01,  2.384868e-01,  3.521724e-01,  4.002829e-01},
  { 3.280994e-01,  8.078047e-01,  4.896962e-01,  2.128330e-01,  3.437358e-01,  4.504710e-01},
  { 1.663009e-01,  9.361424e-01,  3.098088e-01,  1.560280e-01,  3.521724e-01,  4.554736e-01},
  { 2.265114e-01,  8.075070e-01,  5.446330e-01,  1.207064e-01,  3.437358e-01,  4.999255e-01},
  { 4.997576e-01,  6.169564e-01,  6.079533e-01,  2.581405e-01,  3.330344e-01,  4.240874e-01},
  { 4.373209e-01,  6.186417e-01,  6.527119e-01,  2.222765e-01,  3.223329e-01,  4.644302e-01},
  { 3.723419e-01,  6.165973e-01,  6.936637e-01,  1.707780e-01,  3.330344e-01,  4.825582e-01},
  { 3.018709e-01,  6.180992e-01,  7.258289e-01,  1.272957e-01,  3.223329e-01,  5.154103e-01},
  { 1.026008e-01,  9.359627e-01,  3.368186e-01,  6.285581e-02,  3.521724e-01,  4.941063e-01},
  { 1.153874e-01,  8.071315e-01,  5.789859e-01,  1.841855e-02,  3.437358e-01,  5.310844e-01},
  { 3.445056e-02,  9.357717e-01,  3.509196e-01, -3.908177e-02,  3.521724e-01,  5.142328e-01},
  {-2.906984e-09,  8.068903e-01,  5.907012e-01, -9.199809e-02,  3.437358e-01,  5.419233e-01},
  { 2.295690e-01,  6.159365e-01,  7.536049e-01,  7.206507e-02,  3.330344e-01,  5.234901e-01},
  { 1.537448e-01,  6.175222e-01,  7.713811e-01,  2.183915e-02,  3.223329e-01,  5.475362e-01},
  { 7.700813e-02,  6.153247e-01,  7.845032e-01, -3.593451e-02,  3.330344e-01,  5.448114e-01},
  {-3.736389e-09,  6.172032e-01,  7.868038e-01, -9.199809e-02,  3.223329e-01,  5.587104e-01},
  {-6.468539e-02,  9.425991e-01,  3.276017e-01, -1.196736e-01,  4.321281e-01,  1.355560e-01},
  {-9.369581e-02,  9.694996e-01,  2.264765e-01, -1.689617e-01,  4.129901e-01,  1.808894e-01},
  {-1.850803e-01,  9.430137e-01,  2.765328e-01, -1.697358e-01,  4.321281e-01,  1.151081e-01},
  {-1.730680e-01,  9.695849e-01,  1.730679e-01, -2.312193e-01,  4.129901e-01,  1.392212e-01},
  {-2.250906e-02,  9.867918e-01,  1.604222e-01, -1.198584e-01,  3.998948e-01,  2.716183e-01},
  {-3.124189e-02,  9.869841e-01,  1.577539e-01, -1.311968e-01,  4.129901e-01,  1.883460e-01},
  {-3.328114e-02,  9.853721e-01,  1.671353e-01, -1.642411e-01,  3.867995e-01,  3.474749e-01},
  {-4.044027e-02,  9.868179e-01,  1.567003e-01, -1.738913e-01,  3.998948e-01,  2.609496e-01},
  {-6.567886e-02,  9.852504e-01,  1.580123e-01, -2.311655e-01,  3.867995e-01,  3.270875e-01},
  {-8.227626e-02,  9.868582e-01,  1.390735e-01, -2.229559e-01,  3.998948e-01,  2.406636e-01},
  {-8.929629e-02,  9.870346e-01,  1.333752e-01, -2.002542e-01,  4.129901e-01,  1.599455e-01},
  {-9.464193e-02,  9.854363e-01,  1.412738e-01, -2.914418e-01,  3.867995e-01,  2.947330e-01},
  {-9.722394e-02,  9.868720e-01,  1.289625e-01, -2.666638e-01,  3.998948e-01,  2.114104e-01},
  {-1.208222e-01,  9.852939e-01,  1.208221e-01, -3.437401e-01,  3.867995e-01,  2.517420e-01},
  {-2.765328e-01,  9.430138e-01,  1.850802e-01, -2.071062e-01,  4.321281e-01,  7.773767e-02},
  {-2.264765e-01,  9.694996e-01,  9.369581e-02, -2.728874e-01,  4.129901e-01,  7.696365e-02},
  {-3.276017e-01,  9.425991e-01,  6.468534e-02, -2.275541e-01,  4.321281e-01,  2.767551e-02},
  {-2.456314e-01,  9.693633e-01, -4.679745e-09, -2.880839e-01,  4.129901e-01,  0.000000e+00},
  {-1.289625e-01,  9.868720e-01,  9.722395e-02, -3.034085e-01,  3.998948e-01,  1.746658e-01},
  {-1.333752e-01,  9.870346e-01,  8.929633e-02, -2.519436e-01,  4.129901e-01,  1.082562e-01},
  {-1.412738e-01,  9.854363e-01,  9.464196e-02, -3.867311e-01,  3.867995e-01,  1.994437e-01},
  {-1.390735e-01,  9.868582e-01,  8.227626e-02, -3.326617e-01,  3.998948e-01,  1.309579e-01},
  {-1.580123e-01,  9.852504e-01,  6.567885e-02, -4.190856e-01,  3.867995e-01,  1.391674e-01},
  {-1.567003e-01,  9.868179e-01,  4.044025e-02, -3.529477e-01,  3.998948e-01,  8.189319e-02},
  {-1.577539e-01,  9.869841e-01,  3.124189e-02, -2.803441e-01,  4.129901e-01,  3.919869e-02},
  {-1.671353e-01,  9.853721e-01,  3.328111e-02, -4.394729e-01,  3.867995e-01,  7.224297e-02},
  {-1.604222e-01,  9.867918e-01,  2.250898e-02, -3.636164e-01,  3.998948e-01,  2.786031e-02},
  {-1.715178e-01,  9.851810e-01, -8.616586e-09, -4.465643e-01,  3.867995e-01,  0.000000e+00},
  {-1.775977e-02,  9.833400e-01,  1.809061e-01, -1.353712e-01,  3.737042e-01,  4.214907e-01},
  {-5.214594e-02,  9.637453e-01,  2.616788e-01, -1.932476e-01,  3.606089e-01,  4.869891e-01},
  {-5.288659e-02,  9.833929e-01,  1.736131e-01, -2.189242e-01,  3.737042e-01,  4.049928e-01},
  {-1.023048e-01,  9.638512e-01,  2.460176e-01, -2.870430e-01,  3.606089e-01,  4.584176e-01},
  {-8.570029e-02,  9.834449e-01,  1.596610e-01, -2.952926e-01,  3.737042e-01,  3.733277e-01},
  {-1.481503e-01,  9.639268e-01,  2.211260e-01, -3.715213e-01,  3.606089e-01,  4.130731e-01},
  {-1.149699e-01,  9.834740e-01,  1.398604e-01, -3.628802e-01,  3.737042e-01,  3.280919e-01},
  {-1.881375e-01,  9.639546e-01,  1.881375e-01, -4.448186e-01,  3.606089e-01,  3.528205e-01},
  {-3.445056e-02,  9.357717e-01,  3.509195e-01, -1.449144e-01,  3.521724e-01,  5.142328e-01},
  {-1.153874e-01,  8.071314e-01,  5.789859e-01, -2.024147e-01,  3.437358e-01,  5.310844e-01},
  {-1.026008e-01,  9.359628e-01,  3.368185e-01, -2.468520e-01,  3.521724e-01,  4.941063e-01},
  {-2.265114e-01,  8.075068e-01,  5.446332e-01, -3.047026e-01,  3.437358e-01,  4.999255e-01},
  {-7.700813e-02,  6.153247e-01,  7.845032e-01, -1.480617e-01,  3.330344e-01,  5.448114e-01},
  {-1.537448e-01,  6.175221e-01,  7.713811e-01, -2.058353e-01,  3.223329e-01,  5.475362e-01},
  {-2.295691e-01,  6.159363e-01,  7.536050e-01, -2.560612e-01,  3.330344e-01,  5.234901e-01},
  {-3.018709e-01,  6.180992e-01,  7.258288e-01, -3.112919e-01,  3.223329e-01,  5.154103e-01},
  {-1.663008e-01,  9.361424e-01,  3.098087e-01, -3.400242e-01,  3.521724e-01,  4.554736e-01},
  {-3.280993e-01,  8.078046e-01,  4.896963e-01, -3.968292e-01,  3.437358e-01,  4.504710e-01},
  {-2.231127e-01,  9.362434e-01,  2.714207e-01, -4.224830e-01,  3.521724e-01,  4.002829e-01},
  {-4.167166e-01,  8.078951e-01,  4.167166e-01, -4.767630e-01,  3.437358e-01,  3.847649e-01},
  {-3.723419e-01,  6.165972e-01,  6.936638e-01, -3.547742e-01,  3.330344e-01,  4.825582e-01},
  {-4.373209e-01,  6.186416e-01,  6.527120e-01, -4.062727e-01,  3.223329e-01,  4.644302e-01},
  {-4.997576e-01,  6.169563e-01,  6.079533e-01, -4.421367e-01,  3.330344e-01,  4.240874e-01},
  {-5.554918e-01,  6.187550e-01,  5.554917e-01, -4.886824e-01,  3.223329e-01,  3.966844e-01},
  {-1.398604e-01,  9.834740e-01,  1.149699e-01, -4.200900e-01,  3.737042e-01,  2.708822e-01},
  {-2.211260e-01,  9.639268e-01,  1.481503e-01, -5.050712e-01,  3.606089e-01,  2.795232e-01},
  {-1.596610e-01,  9.834449e-01,  8.570031e-02, -4.653258e-01,  3.737042e-01,  2.032945e-01},
  {-2.460176e-01,  9.638512e-01,  1.023048e-01, -5.504157e-01,  3.606089e-01,  1.950449e-01},
  {-1.736131e-01,  9.833928e-01,  5.288655e-02, -4.969909e-01,  3.737042e-01,  1.269261e-01},
  {-2.616791e-01,  9.637452e-01,  5.214589e-02, -5.789872e-01,  3.606089e-01,  1.012495e-01},
  {-1.809061e-01,  9.833400e-01,  1.775970e-02, -5.134888e-01,  3.737042e-01,  4.337312e-02},
  {-2.670534e-01,  9.636818e-01, -4.676631e-10, -5.889280e-01,  3.606089e-01,  0.000000e+00},
  {-2.714207e-01,  9.362433e-01,  2.231127e-01, -4.922810e-01,  3.521724e-01,  3.304849e-01},
  {-4.896963e-01,  8.078046e-01,  3.280994e-01, -5.424691e-01,  3.437358e-01,  3.048311e-01},
  {-3.098087e-01,  9.361424e-01,  1.663008e-01, -5.474717e-01,  3.521724e-01,  2.480261e-01},
  {-5.446331e-01,  8.075069e-01,  2.265114e-01, -5.919236e-01,  3.437358e-01,  2.127045e-01},
  {-6.079533e-01,  6.169564e-01,  4.997576e-01, -5.160855e-01,  3.330344e-01,  3.501386e-01},
  {-6.527119e-01,  6.186417e-01,  4.373209e-01, -5.564283e-01,  3.223329e-01,  3.142746e-01},
  {-6.936638e-01,  6.165972e-01,  3.723420e-01, -5.745562e-01,  3.330344e-01,  2.627761e-01},
  {-7.258286e-01,  6.180994e-01,  3.018709e-01, -6.074084e-01,  3.223329e-01,  2.192938e-01},
  {-3.368188e-01,  9.359627e-01,  1.026008e-01, -5.861044e-01,  3.521724e-01,  1.548539e-01},
  {-5.789856e-01,  8.071316e-01,  1.153871e-01, -6.230824e-01,  3.437358e-01,  1.104166e-01},
  {-3.509197e-01,  9.357716e-01,  3.445062e-02, -6.062308e-01,  3.521724e-01,  5.291632e-02},
  {-5.907018e-01,  8.068900e-01,  2.906984e-09, -6.339214e-01,  3.437358e-01,  0.000000e+00},
  {-7.536045e-01,  6.159372e-01,  2.295687e-01, -6.154882e-01,  3.330344e-01,  1.640632e-01},
  {-7.713804e-01,  6.175231e-01,  1.537444e-01, -6.395343e-01,  3.223329e-01,  1.138372e-01},
  {-7.845032e-01,  6.153247e-01,  7.700813e-02, -6.368095e-01,  3.330344e-01,  5.606358e-02},
  {-7.868038e-01,  6.172032e-01,  0.000000e+00, -6.507084e-01,  3.223329e-01,  0.000000e+00},
  {-3.276017e-01,  9.425991e-01, -6.468531e-02, -2.275541e-01,  4.321281e-01, -2.767551e-02},
  {-2.264765e-01,  9.694996e-01, -9.369580e-02, -2.728874e-01,  4.129901e-01, -7.696365e-02},
  {-2.765328e-01,  9.430138e-01, -1.850803e-01, -2.071062e-01,  4.321281e-01, -7.773767e-02},
  {-1.730680e-01,  9.695849e-01, -1.730680e-01, -2.312193e-01,  4.129901e-01, -1.392212e-01},
  {-1.604222e-01,  9.867918e-01, -2.250899e-02, -3.636164e-01,  3.998948e-01, -2.786031e-02},
  {-1.577539e-01,  9.869841e-01, -3.124188e-02, -2.803441e-01,  4.129901e-01, -3.919869e-02},
  {-1.671353e-01,  9.853721e-01, -3.328111e-02, -4.394729e-01,  3.867995e-01, -7.224297e-02},
  {-1.567003e-01,  9.868179e-01, -4.044025e-02, -3.529477e-01,  3.998948e-01, -8.189319e-02},
  {-1.580123e-01,  9.852504e-01, -6.567885e-02, -4.190856e-01,  3.867995e-01, -1.391674e-01},
  {-1.390735e-01,  9.868582e-01, -8.227625e-02, -3.326617e-01,  3.998948e-01, -1.309579e-01},
  {-1.333752e-01,  9.870346e-01, -8.929633e-02, -2.519436e-01,  4.129901e-01, -1.082562e-01},
  {-1.412738e-01,  9.854363e-01, -9.464196e-02, -3.867311e-01,  3.867995e-01, -1.994437e-01},
  {-1.289625e-01,  9.868720e-01, -9.722395e-02, -3.034085e-01,  3.998948e-01, -1.746658e-01},
  {-1.208221e-01,  9.852939e-01, -1.208221e-01, -3.437401e-01,  3.867995e-01, -2.517420e-01},
  {-1.850803e-01,  9.430137e-01, -2.765328e-01, -1.697358e-01,  4.321281e-01, -1.151081e-01},
  {-9.369582e-02,  9.694996e-01, -2.264765e-01, -1.689617e-01,  4.129901e-01, -1.808894e-01},
  {-6.468539e-02,  9.425991e-01, -3.276017e-01, -1.196736e-01,  4.321281e-01, -1.355560e-01},
  { 2.105885e-09,  9.693633e-01, -2.456314e-01, -9.199809e-02,  4.129901e-01, -1.960859e-01},
  {-9.722394e-02,  9.868720e-01, -1.289625e-01, -2.666638e-01,  3.998948e-01, -2.114104e-01},
  {-8.929630e-02,  9.870346e-01, -1.333752e-01, -2.002542e-01,  4.129901e-01, -1.599455e-01},
  {-9.464194e-02,  9.854363e-01, -1.412738e-01, -2.914418e-01,  3.867995e-01, -2.947330e-01},
  {-8.227626e-02,  9.868582e-01, -1.390735e-01, -2.229559e-01,  3.998948e-01, -2.406636e-01},
  {-6.567885e-02,  9.852504e-01, -1.580123e-01, -2.311655e-01,  3.867995e-01, -3.270875e-01},
  {-4.044027e-02,  9.868179e-01, -1.567003e-01, -1.738913e-01,  3.998948e-01, -2.609496e-01},
  {-3.124192e-02,  9.869841e-01, -1.577539e-01, -1.311968e-01,  4.129901e-01, -1.883460e-01},
  {-3.328115e-02,  9.853721e-01, -1.671353e-01, -1.642411e-01,  3.867995e-01, -3.474749e-01},
  {-2.250907e-02,  9.867918e-01, -1.604222e-01, -1.198584e-01,  3.998948e-01, -2.716183e-01},
  {-4.657614e-10,  9.851810e-01, -1.715178e-01, -9.199809e-02,  3.867995e-01, -3.545662e-01},
  {-1.809060e-01,  9.833400e-01, -1.775970e-02, -5.134888e-01,  3.737042e-01, -4.337312e-02},
  {-2.616791e-01,  9.637452e-01, -5.214589e-02, -5.789872e-01,  3.606089e-01, -1.012495e-01},
  {-1.736131e-01,  9.833928e-01, -5.288655e-02, -4.969909e-01,  3.737042e-01, -1.269261e-01},
  {-2.460176e-01,  9.638512e-01, -1.023048e-01, -5.504157e-01,  3.606089e-01, -1.950449e-01},
  {-1.596610e-01,  9.834449e-01, -8.570030e-02, -4.653258e-01,  3.737042e-01, -2.032945e-01},
  {-2.211260e-01,  9.639268e-01, -1.481503e-01, -5.050712e-01,  3.606089e-01, -2.795232e-01},
  {-1.398604e-01,  9.834740e-01, -1.149698e-01, -4.200900e-01,  3.737042e-01, -2.708822e-01},
  {-1.881375e-01,  9.639546e-01, -1.881375e-01, -4.448186e-01,  3.606089e-01, -3.528205e-01},
  {-3.509197e-01,  9.357716e-01, -3.445061e-02, -6.062308e-01,  3.521724e-01, -5.291632e-02},
  {-5.789857e-01,  8.071316e-01, -1.153872e-01, -6.230824e-01,  3.437358e-01, -1.104166e-01},
  {-3.368188e-01,  9.359627e-01, -1.026008e-01, -5.861044e-01,  3.521724e-01, -1.548539e-01},
  {-5.446331e-01,  8.075069e-01, -2.265113e-01, -5.919236e-01,  3.437358e-01, -2.127045e-01},
  {-7.845032e-01,  6.153247e-01, -7.700814e-02, -6.368095e-01,  3.330344e-01, -5.606358e-02},
  {-7.713804e-01,  6.175231e-01, -1.537444e-01, -6.395343e-01,  3.223329e-01, -1.138372e-01},
  {-7.536044e-01,  6.159371e-01, -2.295687e-01, -6.154882e-01,  3.330344e-01, -1.640632e-01},
  {-7.258286e-01,  6.180994e-01, -3.018709e-01, -6.074084e-01,  3.223329e-01, -2.192938e-01},
  {-3.098088e-01,  9.361424e-01, -1.663008e-01, -5.474717e-01,  3.521724e-01, -2.480261e-01},
  {-4.896963e-01,  8.078046e-01, -3.280994e-01, -5.424691e-01,  3.437358e-01, -3.048311e-01},
  {-2.714207e-01,  9.362434e-01, -2.231127e-01, -4.922810e-01,  3.521724e-01, -3.304849e-01},
  {-4.167166e-01,  8.078951e-01, -4.167166e-01, -4.767630e-01,  3.437358e-01, -3.847649e-01},
  {-6.936638e-01,  6.165972e-01, -3.723419e-01, -5.745562e-01,  3.330344e-01, -2.627761e-01},
  {-6.527119e-01,  6.186417e-01, -4.373209e-01, -5.564283e-01,  3.223329e-01, -3.142746e-01},
  {-6.079533e-01,  6.169564e-01, -4.997576e-01, -5.160855e-01,  3.330344e-01, -3.501386e-01},
  {-5.554917e-01,  6.187550e-01, -5.554918e-01, -4.886824e-01,  3.223329e-01, -3.966844e-01},
  {-1.149698e-01,  9.834740e-01, -1.398604e-01, -3.628802e-01,  3.737042e-01, -3.280919e-01},
  {-1.481503e-01,  9.639268e-01, -2.211260e-01, -3.715213e-01,  3.606089e-01, -4.130731e-01},
  {-8.570029e-02,  9.834449e-01, -1.596610e-01, -2.952926e-01,  3.737042e-01, -3.733277e-01},
  {-1.023048e-01,  9.638512e-01, -2.460176e-01, -2.870430e-01,  3.606089e-01, -4.584176e-01},
  {-5.288659e-02,  9.833928e-01, -1.736131e-01, -2.189242e-01,  3.737042e-01, -4.049928e-01},
  {-5.214594e-02,  9.637453e-01, -2.616788e-01, -1.932476e-01,  3.606089e-01, -4.869891e-01},
  {-1.775976e-02,  9.833400e-01, -1.809061e-01, -1.353712e-01,  3.737042e-01, -4.214907e-01},
  {-9.353261e-10,  9.636818e-01, -2.670533e-01, -9.199809e-02,  3.606089e-01, -4.969299e-01},
  {-2.231127e-01,  9.362434e-01, -2.714207e-01, -4.224830e-01,  3.521724e-01, -4.002829e-01},
  {-3.280993e-01,  8.078047e-01, -4.896962e-01, -3.968292e-01,  3.437358e-01, -4.504710e-01},
  {-1.663008e-01,  9.361424e-01, -3.098087e-01, -3.400242e-01,  3.521724e-01, -4.554736e-01},
  {-2.265114e-01,  8.075069e-01, -5.446332e-01, -3.047026e-01,  3.437358e-01, -4.999255e-01},
  {-4.997576e-01,  6.169564e-01, -6.079533e-01, -4.421367e-01,  3.330344e-01, -4.240874e-01},
  {-4.373210e-01,  6.186416e-01, -6.527120e-01, -4.062727e-01,  3.223329e-01, -4.644302e-01},
  {-3.723419e-01,  6.165971e-01, -6.936638e-01, -3.547742e-01,  3.330344e-01, -4.825582e-01},
  {-3.018709e-01,  6.180992e-01, -7.258288e-01, -3.112919e-01,  3.223329e-01, -5.154103e-01},
  {-1.026008e-01,  9.359628e-01, -3.368185e-01, -2.468520e-01,  3.521724e-01, -4.941063e-01},
  {-1.153874e-01,  8.071314e-01, -5.789859e-01, -2.024147e-01,  3.437358e-01, -5.310844e-01},
  {-3.445056e-02,  9.357717e-01, -3.509195e-01, -1.449144e-01,  3.521724e-01, -5.142328e-01},
  {-3.875978e-09,  8.068903e-01, -5.907013e-01, -9.199809e-02,  3.437358e-01, -5.419233e-01},
  {-2.295691e-01,  6.159364e-01, -7.536049e-01, -2.560612e-01,  3.330344e-01, -5.234901e-01},
  {-1.537448e-01,  6.175222e-01, -7.713811e-01, -2.058353e-01,  3.223329e-01, -5.475362e-01},
  {-7.700814e-02,  6.153247e-01, -7.845032e-01, -1.480617e-01,  3.330344e-01, -5.448114e-01},
  {-5.604583e-09,  6.172032e-01, -7.868038e-01, -9.199809e-02,  3.223329e-01, -5.587104e-01},
  { 6.468539e-02,  9.425991e-01, -3.276017e-01, -6.432258e-02,  4.321281e-01, -1.355560e-01},
  { 9.369581e-02,  9.694996e-01, -2.264765e-01, -1.503445e-02,  4.129901e-01, -1.808894e-01},
  { 1.850803e-01,  9.430137e-01, -2.765328e-01, -1.426042e-02,  4.321281e-01, -1.151081e-01},
  { 1.730680e-01,  9.695849e-01, -1.730680e-01,  4.722309e-02,  4.129901e-01, -1.392212e-01},
  { 2.250906e-02,  9.867918e-01, -1.604222e-01, -6.413779e-02,  3.998948e-01, -2.716183e-01},
  { 3.124188e-02,  9.869841e-01, -1.577539e-01, -5.279940e-02,  4.129901e-01, -1.883460e-01},
  { 3.328114e-02,  9.853721e-01, -1.671354e-01, -1.975512e-02,  3.867995e-01, -3.474749e-01},
  { 4.044026e-02,  9.868179e-01, -1.567003e-01, -1.010490e-02,  3.998948e-01, -2.609496e-01},
  { 6.567886e-02,  9.852504e-01, -1.580123e-01,  4.716936e-02,  3.867995e-01, -3.270875e-01},
  { 8.227628e-02,  9.868582e-01, -1.390735e-01,  3.895976e-02,  3.998948e-01, -2.406636e-01},
  { 8.929629e-02,  9.870346e-01, -1.333752e-01,  1.625806e-02,  4.129901e-01, -1.599455e-01},
  { 9.464192e-02,  9.854363e-01, -1.412738e-01,  1.074456e-01,  3.867995e-01, -2.947330e-01},
  { 9.722394e-02,  9.868720e-01, -1.289625e-01,  8.266768e-02,  3.998948e-01, -2.114104e-01},
  { 1.208221e-01,  9.852939e-01, -1.208221e-01,  1.597439e-01,  3.867995e-01, -2.517420e-01},
  { 2.765328e-01,  9.430137e-01, -1.850803e-01,  2.311001e-02,  4.321281e-01, -7.773767e-02},
  { 2.264765e-01,  9.694996e-01, -9.369582e-02,  8.889127e-02,  4.129901e-01, -7.696365e-02},
  { 3.276016e-01,  9.425991e-01, -6.468534e-02,  4.355794e-02,  4.321281e-01, -2.767551e-02},
  { 1.289625e-01,  9.868720e-01, -9.722397e-02,  1.194123e-01,  3.998948e-01, -1.746658e-01},
  { 1.333752e-01,  9.870346e-01, -8.929633e-02,  6.794737e-02,  4.129901e-01, -1.082562e-01},
  { 1.412738e-01,  9.854363e-01, -9.464195e-02,  2.027350e-01,  3.867995e-01, -1.994437e-01},
  { 1.390735e-01,  9.868582e-01, -8.227631e-02,  1.486655e-01,  3.998948e-01, -1.309579e-01},
  { 1.580123e-01,  9.852504e-01, -6.567886e-02,  2.350895e-01,  3.867995e-01, -1.391674e-01},
  { 1.567003e-01,  9.868179e-01, -4.044025e-02,  1.689515e-01,  3.998948e-01, -8.189319e-02},
  { 1.577539e-01,  9.869841e-01, -3.124190e-02,  9.634791e-02,  4.129901e-01, -3.919869e-02},
  { 1.671353e-01,  9.853721e-01, -3.328115e-02,  2.554768e-01,  3.867995e-01, -7.224297e-02},
  { 1.604222e-01,  9.867918e-01, -2.250900e-02,  1.796203e-01,  3.998948e-01, -2.786031e-02},
  { 1.775976e-02,  9.833400e-01, -1.809061e-01, -4.862497e-02,  3.737042e-01, -4.214907e-01},
  { 5.214593e-02,  9.637453e-01, -2.616789e-01,  9.251407e-03,  3.606089e-01, -4.869891e-01},
  { 5.288658e-02,  9.833929e-01, -1.736132e-01,  3.492801e-02,  3.737042e-01, -4.049928e-01},
  { 1.023049e-01,  9.638512e-01, -2.460176e-01,  1.030468e-01,  3.606089e-01, -4.584176e-01},
  { 8.570030e-02,  9.834449e-01, -1.596610e-01,  1.112964e-01,  3.737042e-01, -3.733277e-01},
  { 1.481503e-01,  9.639268e-01, -2.211260e-01,  1.875251e-01,  3.606089e-01, -4.130731e-01},
  { 1.149699e-01,  9.834740e-01, -1.398604e-01,  1.788841e-01,  3.737042e-01, -3.280919e-01},
  { 1.881375e-01,  9.639546e-01, -1.881375e-01,  2.608224e-01,  3.606089e-01, -3.528205e-01},
  { 3.445056e-02,  9.357717e-01, -3.509195e-01, -3.908177e-02,  3.521724e-01, -5.142328e-01},
  { 1.153874e-01,  8.071314e-01, -5.789859e-01,  1.841855e-02,  3.437358e-01, -5.310844e-01},
  { 1.026008e-01,  9.359627e-01, -3.368186e-01,  6.285581e-02,  3.521724e-01, -4.941063e-01},
  { 2.265114e-01,  8.075070e-01, -5.446330e-01,  1.207064e-01,  3.437358e-01, -4.999255e-01},
  { 7.700814e-02,  6.153247e-01, -7.845032e-01, -3.593451e-02,  3.330344e-01, -5.448114e-01},
  { 1.537448e-01,  6.175221e-01, -7.713812e-01,  2.183915e-02,  3.223329e-01, -5.475362e-01},
  { 2.295691e-01,  6.159365e-01, -7.536049e-01,  7.206507e-02,  3.330344e-01, -5.234901e-01},
  { 3.018708e-01,  6.180992e-01, -7.258288e-01,  1.272957e-01,  3.223329e-01, -5.154103e-01},
  { 1.663009e-01,  9.361424e-01, -3.098088e-01,  1.560280e-01,  3.521724e-01, -4.554736e-01},
  { 3.280994e-01,  8.078047e-01, -4.896962e-01,  2.128330e-01,  3.437358e-01, -4.504710e-01},
  { 2.231126e-01,  9.362434e-01, -2.714206e-01,  2.384868e-01,  3.521724e-01, -4.002829e-01},
  { 4.167167e-01,  8.078949e-01, -4.167167e-01,  2.927668e-01,  3.437358e-01, -3.847649e-01},
  { 3.723419e-01,  6.165972e-01, -6.936637e-01,  1.707780e-01,  3.330344e-01, -4.825582e-01},
  { 4.373210e-01,  6.186417e-01, -6.527119e-01,  2.222765e-01,  3.223329e-01, -4.644302e-01},
  { 4.997576e-01,  6.169564e-01, -6.079533e-01,  2.581405e-01,  3.330344e-01, -4.240874e-01},
  { 5.554917e-01,  6.187552e-01, -5.554916e-01,  3.046863e-01,  3.223329e-01, -3.966844e-01},
  { 1.398604e-01,  9.834740e-01, -1.149699e-01,  2.360938e-01,  3.737042e-01, -2.708822e-01},
  { 2.211260e-01,  9.639268e-01, -1.481503e-01,  3.210750e-01,  3.606089e-01, -2.795232e-01},
  { 1.596610e-01,  9.834449e-01, -8.570030e-02,  2.813296e-01,  3.737042e-01, -2.032945e-01},
  { 2.460176e-01,  9.638512e-01, -1.023048e-01,  3.664195e-01,  3.606089e-01, -1.950449e-01},
  { 1.736132e-01,  9.833928e-01, -5.288660e-02,  3.129947e-01,  3.737042e-01, -1.269261e-01},
  { 2.616790e-01,  9.637452e-01, -5.214594e-02,  3.949910e-01,  3.606089e-01, -1.012495e-01},
  { 1.809061e-01,  9.833400e-01, -1.775973e-02,  3.294926e-01,  3.737042e-01, -4.337312e-02},
  { 2.714206e-01,  9.362434e-01, -2.231127e-01,  3.082848e-01,  3.521724e-01, -3.304849e-01},
  { 4.896961e-01,  8.078048e-01, -3.280994e-01,  3.584729e-01,  3.437358e-01, -3.048311e-01},
  { 3.098089e-01,  9.361424e-01, -1.663008e-01,  3.634755e-01,  3.521724e-01, -2.480261e-01},
  { 5.446326e-01,  8.075073e-01, -2.265111e-01,  4.079274e-01,  3.437358e-01, -2.127045e-01},
  { 6.079534e-01,  6.169564e-01, -4.997575e-01,  3.320893e-01,  3.330344e-01, -3.501386e-01},
  { 6.527120e-01,  6.186414e-01, -4.373212e-01,  3.724321e-01,  3.223329e-01, -3.142746e-01},
  { 6.936635e-01,  6.165975e-01, -3.723419e-01,  3.905601e-01,  3.330344e-01, -2.627761e-01},
  { 7.258288e-01,  6.180992e-01, -3.018709e-01,  4.234122e-01,  3.223329e-01, -2.192938e-01},
  { 3.368187e-01,  9.359627e-01, -1.026008e-01,  4.021082e-01,  3.521724e-01, -1.548539e-01},
  { 5.789852e-01,  8.071319e-01, -1.153872e-01,  4.390862e-01,  3.437358e-01, -1.104166e-01},
  { 3.509196e-01,  9.357716e-01, -3.445061e-02,  4.222346e-01,  3.521724e-01, -5.291632e-02},
  { 7.536042e-01,  6.159374e-01, -2.295687e-01,  4.314921e-01,  3.330344e-01, -1.640632e-01},
  { 7.713805e-01,  6.175230e-01, -1.537445e-01,  4.555381e-01,  3.223329e-01, -1.138372e-01},
  { 7.845027e-01,  6.153254e-01, -7.700808e-02,  4.528133e-01,  3.330344e-01, -5.606358e-02},
};

static GLushort teapot_indices[][3] =
{
  {   0,    1,    2},
  {   0,    2,    3},
  {   0,    3,    4},
  {   0,    4,    1},
  {   5,    2,    6},
  {   5,    6,    7},
  {   5,    7,    3},
  {   5,    3,    2},
  {   8,    6,    9},
  {   8,    9,   10},
  {   8,   10,    7},
  {   8,    7,    6},
  {  11,    9,   12},
  {  11,   12,   13},
  {  11,   13,   10},
  {  11,   10,    9},
  {  14,    4,    3},
  {  14,    3,   15},
  {  14,   15,   16},
  {  14,   16,    4},
  {  17,    3,    7},
  {  17,    7,   18},
  {  17,   18,   15},
  {  17,   15,    3},
  {  19,    7,   10},
  {  19,   10,   20},
  {  19,   20,   18},
  {  19,   18,    7},
  {  21,   10,   13},
  {  21,   13,   22},
  {  21,   22,   20},
  {  21,   20,   10},
  {  23,   12,   24},
  {  23,   24,   25},
  {  23,   25,   13},
  {  23,   13,   12},
  {  26,   24,   27},
  {  26,   27,   28},
  {  26,   28,   25},
  {  26,   25,   24},
  {  29,   27,   30},
  {  29,   30,   31},
  {  29,   31,   28},
  {  29,   28,   27},
  {  32,   30,   33},
  {  32,   33,   34},
  {  32,   34,   31},
  {  32,   31,   30},
  {  35,   13,   25},
  {  35,   25,   36},
  {  35,   36,   22},
  {  35,   22,   13},
  {  37,   25,   28},
  {  37,   28,   38},
  {  37,   38,   36},
  {  37,   36,   25},
  {  39,   28,   31},
  {  39,   31,   40},
  {  39,   40,   38},
  {  39,   38,   28},
  {  41,   31,   34},
  {  41,   34,   42},
  {  41,   42,   40},
  {  41,   40,   31},
  {  43,   16,   15},
  {  43,   15,   44},
  {  43,   44,   45},
  {  43,   45,   16},
  {  46,   15,   18},
  {  46,   18,   47},
  {  46,   47,   44},
  {  46,   44,   15},
  {  48,   18,   20},
  {  48,   20,   49},
  {  48,   49,   47},
  {  48,   47,   18},
  {  50,   20,   22},
  {  50,   22,   51},
  {  50,   51,   49},
  {  50,   49,   20},
  {  52,   45,   44},
  {  52,   44,   53},
  {  52,   53,   54},
  {  52,   54,   45},
  {  55,   44,   47},
  {  55,   47,   56},
  {  55,   56,   53},
  {  55,   53,   44},
  {  57,   47,   49},
  {  57,   49,   58},
  {  57,   58,   56},
  {  57,   56,   47},
  {  59,   49,   51},
  {  59,   51,   60},
  {  59,   60,   58},
  {  59,   58,   49},
  {  61,   22,   36},
  {  61,   36,   62},
  {  61,   62,   51},
  {  61,   51,   22},
  {  63,   36,   38},
  {  63,   38,   64},
  {  63,   64,   62},
  {  63,   62,   36},
  {  65,   38,   40},
  {  65,   40,   66},
  {  65,   66,   64},
  {  65,   64,   38},
  {  67,   40,   42},
  {  67,   42,   68},
  {  67,   68,   66},
  {  67,   66,   40},
  {  69,   51,   62},
  {  69,   62,   70},
  {  69,   70,   60},
  {  69,   60,   51},
  {  71,   62,   64},
  {  71,   64,   72},
  {  71,   72,   70},
  {  71,   70,   62},
  {  73,   64,   66},
  {  73,   66,   74},
  {  73,   74,   72},
  {  73,   72,   64},
  {  75,   66,   68},
  {  75,   68,   76},
  {  75,   76,   74},
  {  75,   74,   66},
  {  77,   33,   78},
  {  77,   78,   79},
  {  77,   79,   34},
  {  77,   34,   33},
  {  80,   78,   81},
  {  80,   81,   82},
  {  80,   82,   79},
  {  80,   79,   78},
  {  83,   81,   84},
  {  83,   84,   85},
  {  83,   85,   82},
  {  83,   82,   81},
  {  86,   84,   87},
  {  86,   87,   88},
  {  86,   88,   85},
  {  86,   85,   84},
  {  89,   34,   79},
  {  89,   79,   90},
  {  89,   90,   42},
  {  89,   42,   34},
  {  91,   79,   82},
  {  91,   82,   92},
  {  91,   92,   90},
  {  91,   90,   79},
  {  93,   82,   85},
  {  93,   85,   94},
  {  93,   94,   92},
  {  93,   92,   82},
  {  95,   85,   88},
  {  95,   88,   96},
  {  95,   96,   94},
  {  95,   94,   85},
  {  97,   87,   98},
  {  97,   98,   99},
  {  97,   99,   88},
  {  97,   88,   87},
  { 100,   98,  101},
  { 100,  101,  102},
  { 100,  102,   99},
  { 100,   99,   98},
  { 103,  101,  104},
  { 103,  104,  105},
  { 103,  105,  102},
  { 103,  102,  101},
  { 106,  104,  107},
  { 106,  107,  108},
  { 106,  108,  105},
  { 106,  105,  104},
  { 109,   88,   99},
  { 109,   99,  110},
  { 109,  110,   96},
  { 109,   96,   88},
  { 111,   99,  102},
  { 111,  102,  112},
  { 111,  112,  110},
  { 111,  110,   99},
  { 113,  102,  105},
  { 113,  105,  114},
  { 113,  114,  112},
  { 113,  112,  102},
  { 115,  105,  108},
  { 115,  108,  116},
  { 115,  116,  114},
  { 115,  114,  105},
  { 117,   42,   90},
  { 117,   90,  118},
  { 117,  118,   68},
  { 117,   68,   42},
  { 119,   90,   92},
  { 119,   92,  120},
  { 119,  120,  118},
  { 119,  118,   90},
  { 121,   92,   94},
  { 121,   94,  122},
  { 121,  122,  120},
  { 121,  120,   92},
  { 123,   94,   96},
  { 123,   96,  124},
  { 123,  124,  122},
  { 123,  122,   94},
  { 125,   68,  118},
  { 125,  118,  126},
  { 125,  126,   76},
  { 125,   76,   68},
  { 127,  118,  120},
  { 127,  120,  128},
  { 127,  128,  126},
  { 127,  126,  118},
  { 129,  120,  122},
  { 129,  122,  130},
  { 129,  130,  128},
  { 129,  128,  120},
  { 131,  122,  124},
  { 131,  124,  132},
  { 131,  132,  130},
  { 131,  130,  122},
  { 133,   96,  110},
  { 133,  110,  134},
  { 133,  134,  124},
  { 133,  124,   96},
  { 135,  110,  112},
  { 135,  112,  136},
  { 135,  136,  134},
  { 135,  134,  110},
  { 137,  112,  114},
  { 137,  114,  138},
  { 137,  138,  136},
  { 137,  136,  112},
  { 139,  114,  116},
  { 139,  116,  140},
  { 139,  140,  138},
  { 139,  138,  114},
  { 141,  124,  134},
  { 141,  134,  142},
  { 141,  142,  132},
  { 141,  132,  124},
  { 143,  134,  136},
  { 143,  136,  144},
  { 143,  144,  142},
  { 143,  142,  134},
  { 145,  136,  138},
  { 145,  138,  146},
  { 145,  146,  144},
  { 145,  144,  136},
  { 147,  138,  140},
  { 147,  140,  148},
  { 147,  148,  146},
  { 147,  146,  138},
  { 149,  107,  150},
  { 149,  150,  151},
  { 149,  151,  108},
  { 149,  108,  107},
  { 152,  150,  153},
  { 152,  153,  154},
  { 152,  154,  151},
  { 152,  151,  150},
  { 155,  153,  156},
  { 155,  156,  157},
  { 155,  157,  154},
  { 155,  154,  153},
  { 158,  156,  159},
  { 158,  159,  160},
  { 158,  160,  157},
  { 158,  157,  156},
  { 161,  108,  151},
  { 161,  151,  162},
  { 161,  162,  116},
  { 161,  116,  108},
  { 163,  151,  154},
  { 163,  154,  164},
  { 163,  164,  162},
  { 163,  162,  151},
  { 165,  154,  157},
  { 165,  157,  166},
  { 165,  166,  164},
  { 165,  164,  154},
  { 167,  157,  160},
  { 167,  160,  168},
  { 167,  168,  166},
  { 167,  166,  157},
  { 169,  159,  170},
  { 169,  170,  171},
  { 169,  171,  160},
  { 169,  160,  159},
  { 172,  170,  173},
  { 172,  173,  174},
  { 172,  174,  171},
  { 172,  171,  170},
  { 175,  173,  176},
  { 175,  176,  177},
  { 175,  177,  174},
  { 175,  174,  173},
  { 178,  176,  179},
  { 178,  179,  180},
  { 178,  180,  177},
  { 178,  177,  176},
  { 181,  160,  171},
  { 181,  171,  182},
  { 181,  182,  168},
  { 181,  168,  160},
  { 183,  171,  174},
  { 183,  174,  184},
  { 183,  184,  182},
  { 183,  182,  171},
  { 185,  174,  177},
  { 185,  177,  186},
  { 185,  186,  184},
  { 185,  184,  174},
  { 187,  177,  180},
  { 187,  180,  188},
  { 187,  188,  186},
  { 187,  186,  177},
  { 189,  116,  162},
  { 189,  162,  190},
  { 189,  190,  140},
  { 189,  140,  116},
  { 191,  162,  164},
  { 191,  164,  192},
  { 191,  192,  190},
  { 191,  190,  162},
  { 193,  164,  166},
  { 193,  166,  194},
  { 193,  194,  192},
  { 193,  192,  164},
  { 195,  166,  168},
  { 195,  168,  196},
  { 195,  196,  194},
  { 195,  194,  166},
  { 197,  140,  190},
  { 197,  190,  198},
  { 197,  198,  148},
  { 197,  148,  140},
  { 199,  190,  192},
  { 199,  192,  200},
  { 199,  200,  198},
  { 199,  198,  190},
  { 201,  192,  194},
  { 201,  194,  202},
  { 201,  202,  200},
  { 201,  200,  192},
  { 203,  194,  196},
  { 203,  196,  204},
  { 203,  204,  202},
  { 203,  202,  194},
  { 205,  168,  182},
  { 205,  182,  206},
  { 205,  206,  196},
  { 205,  196,  168},
  { 207,  182,  184},
  { 207,  184,  208},
  { 207,  208,  206},
  { 207,  206,  182},
  { 209,  184,  186},
  { 209,  186,  210},
  { 209,  210,  208},
  { 209,  208,  184},
  { 211,  186,  188},
  { 211,  188,  212},
  { 211,  212,  210},
  { 211,  210,  186},
  { 213,  196,  206},
  { 213,  206,  214},
  { 213,  214,  204},
  { 213,  204,  196},
  { 215,  206,  208},
  { 215,  208,  216},
  { 215,  216,  214},
  { 215,  214,  206},
  { 217,  208,  210},
  { 217,  210,  218},
  { 217,  218,  216},
  { 217,  216,  208},
  { 219,  210,  212},
  { 219,  212,  220},
  { 219,  220,  218},
  { 219,  218,  210},
  { 221,  179,  222},
  { 221,  222,  223},
  { 221,  223,  180},
  { 221,  180,  179},
  { 224,  222,  225},
  { 224,  225,  226},
  { 224,  226,  223},
  { 224,  223,  222},
  { 227,  225,  228},
  { 227,  228,  229},
  { 227,  229,  226},
  { 227,  226,  225},
  { 230,  228,  231},
  { 230,  231,  232},
  { 230,  232,  229},
  { 230,  229,  228},
  { 233,  180,  223},
  { 233,  223,  234},
  { 233,  234,  188},
  { 233,  188,  180},
  { 235,  223,  226},
  { 235,  226,  236},
  { 235,  236,  234},
  { 235,  234,  223},
  { 237,  226,  229},
  { 237,  229,  238},
  { 237,  238,  236},
  { 237,  236,  226},
  { 239,  229,  232},
  { 239,  232,  240},
  { 239,  240,  238},
  { 239,  238,  229},
  { 241,  231,  242},
  { 241,  242,  243},
  { 241,  243,  232},
  { 241,  232,  231},
  { 244,  242,  245},
  { 244,  245,  246},
  { 244,  246,  243},
  { 244,  243,  242},
  { 247,  245,  248},
  { 247,  248,  249},
  { 247,  249,  246},
  { 247,  246,  245},
  { 250,  248,    1},
  { 250,    1,    4},
  { 250,    4,  249},
  { 250,  249,  248},
  { 251,  232,  243},
  { 251,  243,  252},
  { 251,  252,  240},
  { 251,  240,  232},
  { 253,  243,  246},
  { 253,  246,  254},
  { 253,  254,  252},
  { 253,  252,  243},
  { 255,  246,  249},
  { 255,  249,  256},
  { 255,  256,  254},
  { 255,  254,  246},
  { 257,  249,    4},
  { 257,    4,   16},
  { 257,   16,  256},
  { 257,  256,  249},
  { 258,  188,  234},
  { 258,  234,  259},
  { 258,  259,  212},
  { 258,  212,  188},
  { 260,  234,  236},
  { 260,  236,  261},
  { 260,  261,  259},
  { 260,  259,  234},
  { 262,  236,  238},
  { 262,  238,  263},
  { 262,  263,  261},
  { 262,  261,  236},
  { 264,  238,  240},
  { 264,  240,  265},
  { 264,  265,  263},
  { 264,  263,  238},
  { 266,  212,  259},
  { 266,  259,  267},
  { 266,  267,  220},
  { 266,  220,  212},
  { 268,  259,  261},
  { 268,  261,  269},
  { 268,  269,  267},
  { 268,  267,  259},
  { 270,  261,  263},
  { 270,  263,  271},
  { 270,  271,  269},
  { 270,  269,  261},
  { 272,  263,  265},
  { 272,  265,  273},
  { 272,  273,  271},
  { 272,  271,  263},
  { 274,  240,  252},
  { 274,  252,  275},
  { 274,  275,  265},
  { 274,  265,  240},
  { 276,  252,  254},
  { 276,  254,  277},
  { 276,  277,  275},
  { 276,  275,  252},
  { 278,  254,  256},
  { 278,  256,  279},
  { 278,  279,  277},
  { 278,  277,  254},
  { 280,  256,   16},
  { 280,   16,   45},
  { 280,   45,  279},
  { 280,  279,  256},
  { 281,  265,  275},
  { 281,  275,  282},
  { 281,  282,  273},
  { 281,  273,  265},
  { 283,  275,  277},
  { 283,  277,  284},
  { 283,  284,  282},
  { 283,  282,  275},
  { 285,  277,  279},
  { 285,  279,  286},
  { 285,  286,  284},
  { 285,  284,  277},
  { 287,  279,   45},
  { 287,   45,   54},
  { 287,   54,  286},
  { 287,  286,  279},
  { 288,   54,   53},
  { 288,   53,  289},
  { 288,  289,  290},
  { 288,  290,   54},
  { 291,   53,   56},
  { 291,   56,  292},
  { 291,  292,  289},
  { 291,  289,   53},
  { 293,   56,   58},
  { 293,   58,  294},
  { 293,  294,  292},
  { 293,  292,   56},
  { 295,   58,   60},
  { 295,   60,  296},
  { 295,  296,  294},
  { 295,  294,   58},
  { 297,   60,   70},
  { 297,   70,  298},
  { 297,  298,  296},
  { 297,  296,   60},
  { 299,   70,   72},
  { 299,   72,  300},
  { 299,  300,  298},
  { 299,  298,   70},
  { 301,   72,   74},
  { 301,   74,  302},
  { 301,  302,  300},
  { 301,  300,   72},
  { 303,   74,   76},
  { 303,   76,  304},
  { 303,  304,  302},
  { 303,  302,   74},
  { 305,  290,  289},
  { 305,  289,  306},
  { 305,  306,  307},
  { 305,  307,  290},
  { 308,  289,  292},
  { 308,  292,  309},
  { 308,  309,  306},
  { 308,  306,  289},
  { 310,  292,  294},
  { 310,  294,  311},
  { 310,  311,  309},
  { 310,  309,  292},
  { 312,  294,  296},
  { 312,  296,  313},
  { 312,  313,  311},
  { 312,  311,  294},
  { 314,  307,  306},
  { 314,  306,  315},
  { 314,  315,  316},
  { 314,  316,  307},
  { 317,  306,  309},
  { 317,  309,  318},
  { 317,  318,  315},
  { 317,  315,  306},
  { 319,  309,  311},
  { 319,  311,  320},
  { 319,  320,  318},
  { 319,  318,  309},
  { 321,  311,  313},
  { 321,  313,  322},
  { 321,  322,  320},
  { 321,  320,  311},
  { 323,  296,  298},
  { 323,  298,  324},
  { 323,  324,  313},
  { 323,  313,  296},
  { 325,  298,  300},
  { 325,  300,  326},
  { 325,  326,  324},
  { 325,  324,  298},
  { 327,  300,  302},
  { 327,  302,  328},
  { 327,  328,  326},
  { 327,  326,  300},
  { 329,  302,  304},
  { 329,  304,  330},
  { 329,  330,  328},
  { 329,  328,  302},
  { 331,  313,  324},
  { 331,  324,  332},
  { 331,  332,  322},
  { 331,  322,  313},
  { 333,  324,  326},
  { 333,  326,  334},
  { 333,  334,  332},
  { 333,  332,  324},
  { 335,  326,  328},
  { 335,  328,  336},
  { 335,  336,  334},
  { 335,  334,  326},
  { 337,  328,  330},
  { 337,  330,  338},
  { 337,  338,  336},
  { 337,  336,  328},
  { 339,   76,  126},
  { 339,  126,  340},
  { 339,  340,  304},
  { 339,  304,   76},
  { 341,  126,  128},
  { 341,  128,  342},
  { 341,  342,  340},
  { 341,  340,  126},
  { 343,  128,  130},
  { 343,  130,  344},
  { 343,  344,  342},
  { 343,  342,  128},
  { 345,  130,  132},
  { 345,  132,  346},
  { 345,  346,  344},
  { 345,  344,  130},
  { 347,  132,  142},
  { 347,  142,  348},
  { 347,  348,  346},
  { 347,  346,  132},
  { 349,  142,  144},
  { 349,  144,  350},
  { 349,  350,  348},
  { 349,  348,  142},
  { 351,  144,  146},
  { 351,  146,  352},
  { 351,  352,  350},
  { 351,  350,  144},
  { 353,  146,  148},
  { 353,  148,  354},
  { 353,  354,  352},
  { 353,  352,  146},
  { 355,  304,  340},
  { 355,  340,  356},
  { 355,  356,  330},
  { 355,  330,  304},
  { 357,  340,  342},
  { 357,  342,  358},
  { 357,  358,  356},
  { 357,  356,  340},
  { 359,  342,  344},
  { 359,  344,  360},
  { 359,  360,  358},
  { 359,  358,  342},
  { 361,  344,  346},
  { 361,  346,  362},
  { 361,  362,  360},
  { 361,  360,  344},
  { 363,  330,  356},
  { 363,  356,  364},
  { 363,  364,  338},
  { 363,  338,  330},
  { 365,  356,  358},
  { 365,  358,  366},
  { 365,  366,  364},
  { 365,  364,  356},
  { 367,  358,  360},
  { 367,  360,  368},
  { 367,  368,  366},
  { 367,  366,  358},
  { 369,  360,  362},
  { 369,  362,  370},
  { 369,  370,  368},
  { 369,  368,  360},
  { 371,  346,  348},
  { 371,  348,  372},
  { 371,  372,  362},
  { 371,  362,  346},
  { 373,  348,  350},
  { 373,  350,  374},
  { 373,  374,  372},
  { 373,  372,  348},
  { 375,  350,  352},
  { 375,  352,  376},
  { 375,  376,  374},
  { 375,  374,  350},
  { 377,  352,  354},
  { 377,  354,  378},
  { 377,  378,  376},
  { 377,  376,  352},
  { 379,  362,  372},
  { 379,  372,  380},
  { 379,  380,  370},
  { 379,  370,  362},
  { 381,  372,  374},
  { 381,  374,  382},
  { 381,  382,  380},
  { 381,  380,  372},
  { 383,  374,  376},
  { 383,  376,  384},
  { 383,  384,  382},
  { 383,  382,  374},
  { 385,  376,  378},
  { 385,  378,  386},
  { 385,  386,  384},
  { 385,  384,  376},
  { 387,  148,  198},
  { 387,  198,  388},
  { 387,  388,  354},
  { 387,  354,  148},
  { 389,  198,  200},
  { 389,  200,  390},
  { 389,  390,  388},
  { 389,  388,  198},
  { 391,  200,  202},
  { 391,  202,  392},
  { 391,  392,  390},
  { 391,  390,  200},
  { 393,  202,  204},
  { 393,  204,  394},
  { 393,  394,  392},
  { 393,  392,  202},
  { 395,  204,  214},
  { 395,  214,  396},
  { 395,  396,  394},
  { 395,  394,  204},
  { 397,  214,  216},
  { 397,  216,  398},
  { 397,  398,  396},
  { 397,  396,  214},
  { 399,  216,  218},
  { 399,  218,  400},
  { 399,  400,  398},
  { 399,  398,  216},
  { 401,  218,  220},
  { 401,  220,  402},
  { 401,  402,  400},
  { 401,  400,  218},
  { 403,  354,  388},
  { 403,  388,  404},
  { 403,  404,  378},
  { 403,  378,  354},
  { 405,  388,  390},
  { 405,  390,  406},
  { 405,  406,  404},
  { 405,  404,  388},
  { 407,  390,  392},
  { 407,  392,  408},
  { 407,  408,  406},
  { 407,  406,  390},
  { 409,  392,  394},
  { 409,  394,  410},
  { 409,  410,  408},
  { 409,  408,  392},
  { 411,  378,  404},
  { 411,  404,  412},
  { 411,  412,  386},
  { 411,  386,  378},
  { 413,  404,  406},
  { 413,  406,  414},
  { 413,  414,  412},
  { 413,  412,  404},
  { 415,  406,  408},
  { 415,  408,  416},
  { 415,  416,  414},
  { 415,  414,  406},
  { 417,  408,  410},
  { 417,  410,  418},
  { 417,  418,  416},
  { 417,  416,  408},
  { 419,  394,  396},
  { 419,  396,  420},
  { 419,  420,  410},
  { 419,  410,  394},
  { 421,  396,  398},
  { 421,  398,  422},
  { 421,  422,  420},
  { 421,  420,  396},
  { 423,  398,  400},
  { 423,  400,  424},
  { 423,  424,  422},
  { 423,  422,  398},
  { 425,  400,  402},
  { 425,  402,  426},
  { 425,  426,  424},
  { 425,  424,  400},
  { 427,  410,  420},
  { 427,  420,  428},
  { 427,  428,  418},
  { 427,  418,  410},
  { 429,  420,  422},
  { 429,  422,  430},
  { 429,  430,  428},
  { 429,  428,  420},
  { 431,  422,  424},
  { 431,  424,  432},
  { 431,  432,  430},
  { 431,  430,  422},
  { 433,  424,  426},
  { 433,  426,  434},
  { 433,  434,  432},
  { 433,  432,  424},
  { 435,  220,  267},
  { 435,  267,  436},
  { 435,  436,  402},
  { 435,  402,  220},
  { 437,  267,  269},
  { 437,  269,  438},
  { 437,  438,  436},
  { 437,  436,  267},
  { 439,  269,  271},
  { 439,  271,  440},
  { 439,  440,  438},
  { 439,  438,  269},
  { 441,  271,  273},
  { 441,  273,  442},
  { 441,  442,  440},
  { 441,  440,  271},
  { 443,  273,  282},
  { 443,  282,  444},
  { 443,  444,  442},
  { 443,  442,  273},
  { 445,  282,  284},
  { 445,  284,  446},
  { 445,  446,  444},
  { 445,  444,  282},
  { 447,  284,  286},
  { 447,  286,  448},
  { 447,  448,  446},
  { 447,  446,  284},
  { 449,  286,   54},
  { 449,   54,  290},
  { 449,  290,  448},
  { 449,  448,  286},
  { 450,  402,  436},
  { 450,  436,  451},
  { 450,  451,  426},
  { 450,  426,  402},
  { 452,  436,  438},
  { 452,  438,  453},
  { 452,  453,  451},
  { 452,  451,  436},
  { 454,  438,  440},
  { 454,  440,  455},
  { 454,  455,  453},
  { 454,  453,  438},
  { 456,  440,  442},
  { 456,  442,  457},
  { 456,  457,  455},
  { 456,  455,  440},
  { 458,  426,  451},
  { 458,  451,  459},
  { 458,  459,  434},
  { 458,  434,  426},
  { 460,  451,  453},
  { 460,  453,  461},
  { 460,  461,  459},
  { 460,  459,  451},
  { 462,  453,  455},
  { 462,  455,  463},
  { 462,  463,  461},
  { 462,  461,  453},
  { 464,  455,  457},
  { 464,  457,  465},
  { 464,  465,  463},
  { 464,  463,  455},
  { 466,  442,  444},
  { 466,  444,  467},
  { 466,  467,  457},
  { 466,  457,  442},
  { 468,  444,  446},
  { 468,  446,  469},
  { 468,  469,  467},
  { 468,  467,  444},
  { 470,  446,  448},
  { 470,  448,  471},
  { 470,  471,  469},
  { 470,  469,  446},
  { 472,  448,  290},
  { 472,  290,  307},
  { 472,  307,  471},
  { 472,  471,  448},
  { 473,  457,  467},
  { 473,  467,  474},
  { 473,  474,  465},
  { 473,  465,  457},
  { 475,  467,  469},
  { 475,  469,  476},
  { 475,  476,  474},
  { 475,  474,  467},
  { 477,  469,  471},
  { 477,  471,  478},
  { 477,  478,  476},
  { 477,  476,  469},
  { 479,  471,  307},
  { 479,  307,  316},
  { 479,  316,  478},
  { 479,  478,  471},
  { 480,  316,  315},
  { 480,  315,  481},
  { 480,  481,  482},
  { 480,  482,  316},
  { 483,  315,  318},
  { 483,  318,  484},
  { 483,  484,  481},
  { 483,  481,  315},
  { 485,  482,  481},
  { 485,  481,  486},
  { 485,  486,  487},
  { 485,  487,  482},
  { 488,  481,  484},
  { 488,  484,  489},
  { 488,  489,  486},
  { 488,  486,  481},
  { 490,  318,  320},
  { 490,  320,  491},
  { 490,  491,  484},
  { 490,  484,  318},
  { 492,  320,  322},
  { 492,  322,  493},
  { 492,  493,  491},
  { 492,  491,  320},
  { 494,  484,  491},
  { 494,  491,  495},
  { 494,  495,  489},
  { 494,  489,  484},
  { 496,  491,  493},
  { 496,  493,  497},
  { 496,  497,  495},
  { 496,  495,  491},
  { 498,  487,  486},
  { 498,  486,  499},
  { 498,  499,  500},
  { 498,  500,  487},
  { 501,  486,  489},
  { 501,  489,  502},
  { 501,  502,  499},
  { 501,  499,  486},
  { 503,  489,  495},
  { 503,  495,  504},
  { 503,  504,  502},
  { 503,  502,  489},
  { 505,  495,  497},
  { 505,  497,  506},
  { 505,  506,  504},
  { 505,  504,  495},
  { 507,  322,  332},
  { 507,  332,  508},
  { 507,  508,  493},
  { 507,  493,  322},
  { 509,  332,  334},
  { 509,  334,  510},
  { 509,  510,  508},
  { 509,  508,  332},
  { 511,  493,  508},
  { 511,  508,  512},
  { 511,  512,  497},
  { 511,  497,  493},
  { 513,  508,  510},
  { 513,  510,  514},
  { 513,  514,  512},
  { 513,  512,  508},
  { 515,  334,  336},
  { 515,  336,  516},
  { 515,  516,  510},
  { 515,  510,  334},
  { 517,  336,  338},
  { 517,  338,  518},
  { 517,  518,  516},
  { 517,  516,  336},
  { 519,  510,  516},
  { 519,  516,  520},
  { 519,  520,  514},
  { 519,  514,  510},
  { 521,  516,  518},
  { 521,  518,  522},
  { 521,  522,  520},
  { 521,  520,  516},
  { 523,  497,  512},
  { 523,  512,  524},
  { 523,  524,  506},
  { 523,  506,  497},
  { 525,  512,  514},
  { 525,  514,  526},
  { 525,  526,  524},
  { 525,  524,  512},
  { 527,  514,  520},
  { 527,  520,  528},
  { 527,  528,  526},
  { 527,  526,  514},
  { 529,  520,  522},
  { 529,  522,  530},
  { 529,  530,  528},
  { 529,  528,  520},
  { 531,  500,  499},
  { 531,  499,  532},
  { 531,  532,  533},
  { 531,  533,  500},
  { 534,  499,  502},
  { 534,  502,  535},
  { 534,  535,  532},
  { 534,  532,  499},
  { 536,  502,  504},
  { 536,  504,  537},
  { 536,  537,  535},
  { 536,  535,  502},
  { 538,  504,  506},
  { 538,  506,  539},
  { 538,  539,  537},
  { 538,  537,  504},
  { 540,  533,  532},
  { 540,  532,  541},
  { 540,  541,  542},
  { 540,  542,  533},
  { 543,  532,  535},
  { 543,  535,  544},
  { 543,  544,  541},
  { 543,  541,  532},
  { 545,  535,  537},
  { 545,  537,  546},
  { 545,  546,  544},
  { 545,  544,  535},
  { 547,  537,  539},
  { 547,  539,  548},
  { 547,  548,  546},
  { 547,  546,  537},
  { 549,  506,  524},
  { 549,  524,  550},
  { 549,  550,  539},
  { 549,  539,  506},
  { 551,  524,  526},
  { 551,  526,  552},
  { 551,  552,  550},
  { 551,  550,  524},
  { 553,  526,  528},
  { 553,  528,  554},
  { 553,  554,  552},
  { 553,  552,  526},
  { 555,  528,  530},
  { 555,  530,  556},
  { 555,  556,  554},
  { 555,  554,  528},
  { 557,  539,  550},
  { 557,  550,  558},
  { 557,  558,  548},
  { 557,  548,  539},
  { 559,  550,  552},
  { 559,  552,  560},
  { 559,  560,  558},
  { 559,  558,  550},
  { 561,  552,  554},
  { 561,  554,  562},
  { 561,  562,  560},
  { 561,  560,  552},
  { 563,  554,  556},
  { 563,  556,  564},
  { 563,  564,  562},
  { 563,  562,  554},
  { 565,  338,  364},
  { 565,  364,  566},
  { 565,  566,  518},
  { 565,  518,  338},
  { 567,  364,  366},
  { 567,  366,  568},
  { 567,  568,  566},
  { 567,  566,  364},
  { 569,  518,  566},
  { 569,  566,  570},
  { 569,  570,  522},
  { 569,  522,  518},
  { 571,  566,  568},
  { 571,  568,  572},
  { 571,  572,  570},
  { 571,  570,  566},
  { 573,  366,  368},
  { 573,  368,  574},
  { 573,  574,  568},
  { 573,  568,  366},
  { 575,  368,  370},
  { 575,  370,  576},
  { 575,  576,  574},
  { 575,  574,  368},
  { 577,  568,  574},
  { 577,  574,  578},
  { 577,  578,  572},
  { 577,  572,  568},
  { 579,  574,  576},
  { 579,  576,  580},
  { 579,  580,  578},
  { 579,  578,  574},
  { 581,  522,  570},
  { 581,  570,  582},
  { 581,  582,  530},
  { 581,  530,  522},
  { 583,  570,  572},
  { 583,  572,  584},
  { 583,  584,  582},
  { 583,  582,  570},
  { 585,  572,  578},
  { 585,  578,  586},
  { 585,  586,  584},
  { 585,  584,  572},
  { 587,  578,  580},
  { 587,  580,  588},
  { 587,  588,  586},
  { 587,  586,  578},
  { 589,  370,  380},
  { 589,  380,  590},
  { 589,  590,  576},
  { 589,  576,  370},
  { 591,  380,  382},
  { 591,  382,  592},
  { 591,  592,  590},
  { 591,  590,  380},
  { 593,  576,  590},
  { 593,  590,  594},
  { 593,  594,  580},
  { 593,  580,  576},
  { 595,  590,  592},
  { 595,  592,  596},
  { 595,  596,  594},
  { 595,  594,  590},
  { 597,  382,  384},
  { 597,  384,  598},
  { 597,  598,  592},
  { 597,  592,  382},
  { 599,  384,  386},
  { 599,  386,  600},
  { 599,  600,  598},
  { 599,  598,  384},
  { 601,  592,  598},
  { 601,  598,  602},
  { 601,  602,  596},
  { 601,  596,  592},
  { 603,  598,  600},
  { 603,  600,  604},
  { 603,  604,  602},
  { 603,  602,  598},
  { 605,  580,  594},
  { 605,  594,  606},
  { 605,  606,  588},
  { 605,  588,  580},
  { 607,  594,  596},
  { 607,  596,  608},
  { 607,  608,  606},
  { 607,  606,  594},
  { 609,  596,  602},
  { 609,  602,  610},
  { 609,  610,  608},
  { 609,  608,  596},
  { 611,  602,  604},
  { 611,  604,  612},
  { 611,  612,  610},
  { 611,  610,  602},
  { 613,  530,  582},
  { 613,  582,  614},
  { 613,  614,  556},
  { 613,  556,  530},
  { 615,  582,  584},
  { 615,  584,  616},
  { 615,  616,  614},
  { 615,  614,  582},
  { 617,  584,  586},
  { 617,  586,  618},
  { 617,  618,  616},
  { 617,  616,  584},
  { 619,  586,  588},
  { 619,  588,  620},
  { 619,  620,  618},
  { 619,  618,  586},
  { 621,  556,  614},
  { 621,  614,  622},
  { 621,  622,  564},
  { 621,  564,  556},
  { 623,  614,  616},
  { 623,  616,  624},
  { 623,  624,  622},
  { 623,  622,  614},
  { 625,  616,  618},
  { 625,  618,  626},
  { 625,  626,  624},
  { 625,  624,  616},
  { 627,  618,  620},
  { 627,  620,  628},
  { 627,  628,  626},
  { 627,  626,  618},
  { 629,  588,  606},
  { 629,  606,  630},
  { 629,  630,  620},
  { 629,  620,  588},
  { 631,  606,  608},
  { 631,  608,  632},
  { 631,  632,  630},
  { 631,  630,  606},
  { 633,  608,  610},
  { 633,  610,  634},
  { 633,  634,  632},
  { 633,  632,  608},
  { 635,  610,  612},
  { 635,  612,  636},
  { 635,  636,  634},
  { 635,  634,  610},
  { 637,  620,  630},
  { 637,  630,  638},
  { 637,  638,  628},
  { 637,  628,  620},
  { 639,  630,  632},
  { 639,  632,  640},
  { 639,  640,  638},
  { 639,  638,  630},
  { 641,  632,  634},
  { 641,  634,  642},
  { 641,  642,  640},
  { 641,  640,  632},
  { 643,  634,  636},
  { 643,  636,  644},
  { 643,  644,  642},
  { 643,  642,  634},
  { 645,  386,  412},
  { 645,  412,  646},
  { 645,  646,  600},
  { 645,  600,  386},
  { 647,  412,  414},
  { 647,  414,  648},
  { 647,  648,  646},
  { 647,  646,  412},
  { 649,  600,  646},
  { 649,  646,  650},
  { 649,  650,  604},
  { 649,  604,  600},
  { 651,  646,  648},
  { 651,  648,  652},
  { 651,  652,  650},
  { 651,  650,  646},
  { 653,  414,  416},
  { 653,  416,  654},
  { 653,  654,  648},
  { 653,  648,  414},
  { 655,  416,  418},
  { 655,  418,  656},
  { 655,  656,  654},
  { 655,  654,  416},
  { 657,  648,  654},
  { 657,  654,  658},
  { 657,  658,  652},
  { 657,  652,  648},
  { 659,  654,  656},
  { 659,  656,  660},
  { 659,  660,  658},
  { 659,  658,  654},
  { 661,  604,  650},
  { 661,  650,  662},
  { 661,  662,  612},
  { 661,  612,  604},
  { 663,  650,  652},
  { 663,  652,  664},
  { 663,  664,  662},
  { 663,  662,  650},
  { 665,  652,  658},
  { 665,  658,  666},
  { 665,  666,  664},
  { 665,  664,  652},
  { 667,  658,  660},
  { 667,  660,  668},
  { 667,  668,  666},
  { 667,  666,  658},
  { 669,  418,  428},
  { 669,  428,  670},
  { 669,  670,  656},
  { 669,  656,  418},
  { 671,  428,  430},
  { 671,  430,  672},
  { 671,  672,  670},
  { 671,  670,  428},
  { 673,  656,  670},
  { 673,  670,  674},
  { 673,  674,  660},
  { 673,  660,  656},
  { 675,  670,  672},
  { 675,  672,  676},
  { 675,  676,  674},
  { 675,  674,  670},
  { 677,  430,  432},
  { 677,  432,  678},
  { 677,  678,  672},
  { 677,  672,  430},
  { 679,  432,  434},
  { 679,  434,  680},
  { 679,  680,  678},
  { 679,  678,  432},
  { 681,  672,  678},
  { 681,  678,  682},
  { 681,  682,  676},
  { 681,  676,  672},
  { 683,  678,  680},
  { 683,  680,  684},
  { 683,  684,  682},
  { 683,  682,  678},
  { 685,  660,  674},
  { 685,  674,  686},
  { 685,  686,  668},
  { 685,  668,  660},
  { 687,  674,  676},
  { 687,  676,  688},
  { 687,  688,  686},
  { 687,  686,  674},
  { 689,  676,  682},
  { 689,  682,  690},
  { 689,  690,  688},
  { 689,  688,  676},
  { 691,  682,  684},
  { 691,  684,  692},
  { 691,  692,  690},
  { 691,  690,  682},
  { 693,  612,  662},
  { 693,  662,  694},
  { 693,  694,  636},
  { 693,  636,  612},
  { 695,  662,  664},
  { 695,  664,  696},
  { 695,  696,  694},
  { 695,  694,  662},
  { 697,  664,  666},
  { 697,  666,  698},
  { 697,  698,  696},
  { 697,  696,  664},
  { 699,  666,  668},
  { 699,  668,  700},
  { 699,  700,  698},
  { 699,  698,  666},
  { 701,  636,  694},
  { 701,  694,  702},
  { 701,  702,  644},
  { 701,  644,  636},
  { 703,  694,  696},
  { 703,  696,  704},
  { 703,  704,  702},
  { 703,  702,  694},
  { 705,  696,  698},
  { 705,  698,  706},
  { 705,  706,  704},
  { 705,  704,  696},
  { 707,  698,  700},
  { 707,  700,  708},
  { 707,  708,  706},
  { 707,  706,  698},
  { 709,  668,  686},
  { 709,  686,  710},
  { 709,  710,  700},
  { 709,  700,  668},
  { 711,  686,  688},
  { 711,  688,  712},
  { 711,  712,  710},
  { 711,  710,  686},
  { 713,  688,  690},
  { 713,  690,  714},
  { 713,  714,  712},
  { 713,  712,  688},
  { 715,  690,  692},
  { 715,  692,  716},
  { 715,  716,  714},
  { 715,  714,  690},
  { 717,  700,  710},
  { 717,  710,  718},
  { 717,  718,  708},
  { 717,  708,  700},
  { 719,  710,  712},
  { 719,  712,  720},
  { 719,  720,  718},
  { 719,  718,  710},
  { 721,  712,  714},
  { 721,  714,  722},
  { 721,  722,  720},
  { 721,  720,  712},
  { 723,  714,  716},
  { 723,  716,  724},
  { 723,  724,  722},
  { 723,  722,  714},
  { 725,  434,  459},
  { 725,  459,  726},
  { 725,  726,  680},
  { 725,  680,  434},
  { 727,  459,  461},
  { 727,  461,  728},
  { 727,  728,  726},
  { 727,  726,  459},
  { 729,  680,  726},
  { 729,  726,  730},
  { 729,  730,  684},
  { 729,  684,  680},
  { 731,  726,  728},
  { 731,  728,  732},
  { 731,  732,  730},
  { 731,  730,  726},
  { 733,  461,  463},
  { 733,  463,  734},
  { 733,  734,  728},
  { 733,  728,  461},
  { 735,  463,  465},
  { 735,  465,  736},
  { 735,  736,  734},
  { 735,  734,  463},
  { 737,  728,  734},
  { 737,  734,  738},
  { 737,  738,  732},
  { 737,  732,  728},
  { 739,  734,  736},
  { 739,  736,  740},
  { 739,  740,  738},
  { 739,  738,  734},
  { 741,  684,  730},
  { 741,  730,  742},
  { 741,  742,  692},
  { 741,  692,  684},
  { 743,  730,  732},
  { 743,  732,  744},
  { 743,  744,  742},
  { 743,  742,  730},
  { 745,  732,  738},
  { 745,  738,  746},
  { 745,  746,  744},
  { 745,  744,  732},
  { 747,  738,  740},
  { 747,  740,  748},
  { 747,  748,  746},
  { 747,  746,  738},
  { 749,  465,  474},
  { 749,  474,  750},
  { 749,  750,  736},
  { 749,  736,  465},
  { 751,  474,  476},
  { 751,  476,  752},
  { 751,  752,  750},
  { 751,  750,  474},
  { 753,  736,  750},
  { 753,  750,  754},
  { 753,  754,  740},
  { 753,  740,  736},
  { 755,  750,  752},
  { 755,  752,  756},
  { 755,  756,  754},
  { 755,  754,  750},
  { 757,  476,  478},
  { 757,  478,  758},
  { 757,  758,  752},
  { 757,  752,  476},
  { 759,  478,  316},
  { 759,  316,  482},
  { 759,  482,  758},
  { 759,  758,  478},
  { 760,  752,  758},
  { 760,  758,  761},
  { 760,  761,  756},
  { 760,  756,  752},
  { 762,  758,  482},
  { 762,  482,  487},
  { 762,  487,  761},
  { 762,  761,  758},
  { 763,  740,  754},
  { 763,  754,  764},
  { 763,  764,  748},
  { 763,  748,  740},
  { 765,  754,  756},
  { 765,  756,  766},
  { 765,  766,  764},
  { 765,  764,  754},
  { 767,  756,  761},
  { 767,  761,  768},
  { 767,  768,  766},
  { 767,  766,  756},
  { 769,  761,  487},
  { 769,  487,  500},
  { 769,  500,  768},
  { 769,  768,  761},
  { 770,  692,  742},
  { 770,  742,  771},
  { 770,  771,  716},
  { 770,  716,  692},
  { 772,  742,  744},
  { 772,  744,  773},
  { 772,  773,  771},
  { 772,  771,  742},
  { 774,  744,  746},
  { 774,  746,  775},
  { 774,  775,  773},
  { 774,  773,  744},
  { 776,  746,  748},
  { 776,  748,  777},
  { 776,  777,  775},
  { 776,  775,  746},
  { 778,  716,  771},
  { 778,  771,  779},
  { 778,  779,  724},
  { 778,  724,  716},
  { 780,  771,  773},
  { 780,  773,  781},
  { 780,  781,  779},
  { 780,  779,  771},
  { 782,  773,  775},
  { 782,  775,  783},
  { 782,  783,  781},
  { 782,  781,  773},
  { 784,  775,  777},
  { 784,  777,  785},
  { 784,  785,  783},
  { 784,  783,  775},
  { 786,  748,  764},
  { 786,  764,  787},
  { 786,  787,  777},
  { 786,  777,  748},
  { 788,  764,  766},
  { 788,  766,  789},
  { 788,  789,  787},
  { 788,  787,  764},
  { 790,  766,  768},
  { 790,  768,  791},
  { 790,  791,  789},
  { 790,  789,  766},
  { 792,  768,  500},
  { 792,  500,  533},
  { 792,  533,  791},
  { 792,  791,  768},
  { 793,  777,  787},
  { 793,  787,  794},
  { 793,  794,  785},
  { 793,  785,  777},
  { 795,  787,  789},
  { 795,  789,  796},
  { 795,  796,  794},
  { 795,  794,  787},
  { 797,  789,  791},
  { 797,  791,  798},
  { 797,  798,  796},
  { 797,  796,  789},
  { 799,  791,  533},
  { 799,  533,  542},
  { 799,  542,  798},
  { 799,  798,  791},
  { 800,  801,  802},
  { 800,  802,  803},
  { 800,  803,  804},
  { 800,  804,  801},
  { 805,  802,  806},
  { 805,  806,  807},
  { 805,  807,  803},
  { 805,  803,  802},
  { 808,  804,  803},
  { 808,  803,  809},
  { 808,  809,  810},
  { 808,  810,  804},
  { 811,  803,  807},
  { 811,  807,  812},
  { 811,  812,  809},
  { 811,  809,  803},
  { 813,  806,  814},
  { 813,  814,  815},
  { 813,  815,  807},
  { 813,  807,  806},
  { 816,  814,  817},
  { 816,  817,  818},
  { 816,  818,  815},
  { 816,  815,  814},
  { 819,  807,  815},
  { 819,  815,  820},
  { 819,  820,  812},
  { 819,  812,  807},
  { 821,  815,  818},
  { 821,  818,  822},
  { 821,  822,  820},
  { 821,  820,  815},
  { 823,  810,  824},
  { 823,  824,  825},
  { 823,  825,  826},
  { 823,  826,  810},
  { 827,  824,  809},
  { 827,  809,  828},
  { 827,  828,  825},
  { 827,  825,  824},
  { 829,  809,  812},
  { 829,  812,  830},
  { 829,  830,  831},
  { 829,  831,  809},
  { 832,  831,  830},
  { 832,  830,  833},
  { 832,  833,  828},
  { 832,  828,  831},
  { 834,  826,  825},
  { 834,  825,  835},
  { 834,  835,  836},
  { 834,  836,  826},
  { 837,  825,  828},
  { 837,  828,  838},
  { 837,  838,  835},
  { 837,  835,  825},
  { 839,  836,  835},
  { 839,  835,  840},
  { 839,  840,  841},
  { 839,  841,  836},
  { 842,  835,  838},
  { 842,  838,  843},
  { 842,  843,  840},
  { 842,  840,  835},
  { 844,  828,  833},
  { 844,  833,  845},
  { 844,  845,  838},
  { 844,  838,  828},
  { 846,  838,  845},
  { 846,  845,  847},
  { 846,  847,  843},
  { 846,  843,  838},
  { 848,  812,  820},
  { 848,  820,  849},
  { 848,  849,  830},
  { 848,  830,  812},
  { 850,  830,  849},
  { 850,  849,  851},
  { 850,  851,  833},
  { 850,  833,  830},
  { 852,  820,  853},
  { 852,  853,  854},
  { 852,  854,  849},
  { 852,  849,  820},
  { 855,  853,  822},
  { 855,  822,  856},
  { 855,  856,  854},
  { 855,  854,  853},
  { 857,  849,  854},
  { 857,  854,  858},
  { 857,  858,  851},
  { 857,  851,  849},
  { 859,  854,  856},
  { 859,  856,  860},
  { 859,  860,  858},
  { 859,  858,  854},
  { 861,  833,  851},
  { 861,  851,  862},
  { 861,  862,  845},
  { 861,  845,  833},
  { 863,  845,  862},
  { 863,  862,  864},
  { 863,  864,  847},
  { 863,  847,  845},
  { 865,  851,  858},
  { 865,  858,  866},
  { 865,  866,  862},
  { 865,  862,  851},
  { 867,  858,  860},
  { 867,  860,  868},
  { 867,  868,  866},
  { 867,  866,  858},
  { 869,  862,  866},
  { 869,  866,  870},
  { 869,  870,  864},
  { 869,  864,  862},
  { 871,  866,  868},
  { 871,  868,  872},
  { 871,  872,  870},
  { 871,  870,  866},
  { 873,  817,  874},
  { 873,  874,  875},
  { 873,  875,  818},
  { 873,  818,  817},
  { 876,  874,  877},
  { 876,  877,  878},
  { 876,  878,  875},
  { 876,  875,  874},
  { 879,  818,  875},
  { 879,  875,  880},
  { 879,  880,  822},
  { 879,  822,  818},
  { 881,  875,  878},
  { 881,  878,  882},
  { 881,  882,  880},
  { 881,  880,  875},
  { 883,  877,  884},
  { 883,  884,  885},
  { 883,  885,  878},
  { 883,  878,  877},
  { 886,  884,  801},
  { 886,  801,  804},
  { 886,  804,  885},
  { 886,  885,  884},
  { 887,  878,  885},
  { 887,  885,  888},
  { 887,  888,  882},
  { 887,  882,  878},
  { 889,  885,  804},
  { 889,  804,  810},
  { 889,  810,  888},
  { 889,  888,  885},
  { 890,  822,  891},
  { 890,  891,  892},
  { 890,  892,  856},
  { 890,  856,  822},
  { 893,  891,  880},
  { 893,  880,  894},
  { 893,  894,  892},
  { 893,  892,  891},
  { 895,  856,  892},
  { 895,  892,  896},
  { 895,  896,  860},
  { 895,  860,  856},
  { 897,  892,  894},
  { 897,  894,  898},
  { 897,  898,  896},
  { 897,  896,  892},
  { 899,  880,  882},
  { 899,  882,  900},
  { 899,  900,  894},
  { 899,  894,  880},
  { 901,  894,  900},
  { 901,  900,  902},
  { 901,  902,  898},
  { 901,  898,  894},
  { 903,  860,  896},
  { 903,  896,  904},
  { 903,  904,  868},
  { 903,  868,  860},
  { 905,  896,  898},
  { 905,  898,  906},
  { 905,  906,  904},
  { 905,  904,  896},
  { 907,  868,  904},
  { 907,  904,  908},
  { 907,  908,  872},
  { 907,  872,  868},
  { 909,  904,  906},
  { 909,  906,  910},
  { 909,  910,  908},
  { 909,  908,  904},
  { 911,  898,  902},
  { 911,  902,  912},
  { 911,  912,  906},
  { 911,  906,  898},
  { 913,  906,  912},
  { 913,  912,  914},
  { 913,  914,  910},
  { 913,  910,  906},
  { 915,  882,  888},
  { 915,  888,  916},
  { 915,  916,  900},
  { 915,  900,  882},
  { 917,  900,  916},
  { 917,  916,  918},
  { 917,  918,  902},
  { 917,  902,  900},
  { 919,  888,  920},
  { 919,  920,  921},
  { 919,  921,  918},
  { 919,  918,  888},
  { 922,  920,  810},
  { 922,  810,  826},
  { 922,  826,  921},
  { 922,  921,  920},
  { 923,  902,  918},
  { 923,  918,  924},
  { 923,  924,  912},
  { 923,  912,  902},
  { 925,  912,  924},
  { 925,  924,  926},
  { 925,  926,  914},
  { 925,  914,  912},
  { 927,  918,  921},
  { 927,  921,  928},
  { 927,  928,  924},
  { 927,  924,  918},
  { 929,  921,  826},
  { 929,  826,  836},
  { 929,  836,  928},
  { 929,  928,  921},
  { 930,  924,  928},
  { 930,  928,  931},
  { 930,  931,  926},
  { 930,  926,  924},
  { 932,  928,  836},
  { 932,  836,  841},
  { 932,  841,  931},
  { 932,  931,  928},
  { 933,  841,  840},
  { 933,  840,  934},
  { 933,  934,  935},
  { 933,  935,  841},
  { 936,  840,  843},
  { 936,  843,  937},
  { 936,  937,  934},
  { 936,  934,  840},
  { 938,  843,  847},
  { 938,  847,  939},
  { 938,  939,  937},
  { 938,  937,  843},
  { 940,  935,  934},
  { 940,  934,  941},
  { 940,  941,  942},
  { 940,  942,  935},
  { 943,  934,  937},
  { 943,  937,  944},
  { 943,  944,  941},
  { 943,  941,  934},
  { 945,  937,  939},
  { 945,  939,  946},
  { 945,  946,  944},
  { 945,  944,  937},
  { 947,  847,  864},
  { 947,  864,  948},
  { 947,  948,  949},
  { 947,  949,  847},
  { 950,  949,  948},
  { 950,  948,  951},
  { 950,  951,  939},
  { 950,  939,  949},
  { 952,  864,  870},
  { 952,  870,  953},
  { 952,  953,  948},
  { 952,  948,  864},
  { 954,  870,  872},
  { 954,  872,  955},
  { 954,  955,  953},
  { 954,  953,  870},
  { 956,  948,  953},
  { 956,  953,  957},
  { 956,  957,  951},
  { 956,  951,  948},
  { 958,  953,  955},
  { 958,  955,  959},
  { 958,  959,  957},
  { 958,  957,  953},
  { 960,  939,  951},
  { 960,  951,  961},
  { 960,  961,  962},
  { 960,  962,  939},
  { 963,  962,  961},
  { 963,  961,  964},
  { 963,  964,  946},
  { 963,  946,  962},
  { 965,  951,  957},
  { 965,  957,  966},
  { 965,  966,  961},
  { 965,  961,  951},
  { 967,  957,  959},
  { 967,  959,  968},
  { 967,  968,  966},
  { 967,  966,  957},
  { 969,  961,  968},
  { 969,  968,  970},
  { 969,  970,  964},
  { 969,  964,  961},
  { 971,  942,  944},
  { 971,  944,  972},
  { 971,  972,  973},
  { 971,  973,  942},
  { 974,  944,  946},
  { 974,  946,  975},
  { 974,  975,  972},
  { 974,  972,  944},
  { 976,  973,  972},
  { 976,  972,  977},
  { 976,  977,  978},
  { 976,  978,  973},
  { 979,  978,  980},
  { 979,  980,  981},
  { 979,  981,  386},
  { 979,  386,  978},
  { 982,  980,  977},
  { 982,  977,  983},
  { 982,  983,  981},
  { 982,  981,  980},
  { 984,  972,  985},
  { 984,  985,  986},
  { 984,  986,  983},
  { 984,  983,  972},
  { 987,  985,  975},
  { 987,  975,  988},
  { 987,  988,  986},
  { 987,  986,  985},
  { 989,  946,  964},
  { 989,  964,  990},
  { 989,  990,  975},
  { 989,  975,  946},
  { 991,  964,  970},
  { 991,  970,  992},
  { 991,  992,  990},
  { 991,  990,  964},
  { 993,  975,  994},
  { 993,  994,  995},
  { 993,  995,  988},
  { 993,  988,  975},
  { 996,  994,  990},
  { 996,  990,  997},
  { 996,  997,  995},
  { 996,  995,  994},
  { 998,  990,  999},
  { 998,  999, 1000},
  { 998, 1000,  997},
  { 998,  997,  990},
  {1001,  999,  992},
  {1001,  992, 1002},
  {1001, 1002, 1000},
  {1001, 1000,  999},
  {1003,  872,  908},
  {1003,  908, 1004},
  {1003, 1004,  955},
  {1003,  955,  872},
  {1005,  908,  910},
  {1005,  910, 1006},
  {1005, 1006, 1004},
  {1005, 1004,  908},
  {1007,  955, 1004},
  {1007, 1004, 1008},
  {1007, 1008,  959},
  {1007,  959,  955},
  {1009, 1004, 1006},
  {1009, 1006, 1010},
  {1009, 1010, 1008},
  {1009, 1008, 1004},
  {1011,  910,  914},
  {1011,  914, 1012},
  {1011, 1012, 1006},
  {1011, 1006,  910},
  {1013, 1006, 1012},
  {1013, 1012, 1014},
  {1013, 1014, 1010},
  {1013, 1010, 1006},
  {1015,  959, 1008},
  {1015, 1008, 1016},
  {1015, 1016,  968},
  {1015,  968,  959},
  {1017, 1008, 1010},
  {1017, 1010, 1018},
  {1017, 1018, 1016},
  {1017, 1016, 1008},
  {1019,  968, 1018},
  {1019, 1018, 1020},
  {1019, 1020,  970},
  {1019,  970,  968},
  {1021, 1010, 1014},
  {1021, 1014, 1022},
  {1021, 1022, 1018},
  {1021, 1018, 1010},
  {1023, 1018, 1022},
  {1023, 1022, 1024},
  {1023, 1024, 1020},
  {1023, 1020, 1018},
  {1025,  914,  926},
  {1025,  926, 1026},
  {1025, 1026, 1014},
  {1025, 1014,  914},
  {1027,  926,  931},
  {1027,  931, 1028},
  {1027, 1028, 1026},
  {1027, 1026,  926},
  {1029,  931,  841},
  {1029,  841,  935},
  {1029,  935, 1028},
  {1029, 1028,  931},
  {1030, 1014, 1026},
  {1030, 1026, 1031},
  {1030, 1031, 1024},
  {1030, 1024, 1014},
  {1032, 1026, 1028},
  {1032, 1028, 1033},
  {1032, 1033, 1031},
  {1032, 1031, 1026},
  {1034, 1028,  935},
  {1034,  935,  942},
  {1034,  942, 1033},
  {1034, 1033, 1028},
  {1035,  970, 1020},
  {1035, 1020, 1036},
  {1035, 1036,  992},
  {1035,  992,  970},
  {1037, 1020, 1024},
  {1037, 1024, 1038},
  {1037, 1038, 1036},
  {1037, 1036, 1020},
  {1039,  992, 1040},
  {1039, 1040, 1041},
  {1039, 1041, 1002},
  {1039, 1002,  992},
  {1042, 1040, 1036},
  {1042, 1036, 1043},
  {1042, 1043, 1041},
  {1042, 1041, 1040},
  {1044, 1036, 1045},
  {1044, 1045, 1046},
  {1044, 1046, 1043},
  {1044, 1043, 1036},
  {1047, 1045, 1038},
  {1047, 1038, 1048},
  {1047, 1048, 1046},
  {1047, 1046, 1045},
  {1049, 1024, 1031},
  {1049, 1031, 1050},
  {1049, 1050, 1038},
  {1049, 1038, 1024},
  {1051, 1031,  942},
  {1051,  942,  973},
  {1051,  973, 1050},
  {1051, 1050, 1031},
  {1052, 1038, 1053},
  {1052, 1053, 1054},
  {1052, 1054, 1048},
  {1052, 1048, 1038},
  {1055, 1053, 1050},
  {1055, 1050, 1056},
  {1055, 1056, 1054},
  {1055, 1054, 1053},
  {1057, 1050,  973},
  {1057,  973,  978},
  {1057,  978, 1058},
  {1057, 1058, 1050},
  {1059, 1058, 1060},
  {1059, 1060, 1061},
  {1059, 1061, 1056},
  {1059, 1056, 1058},
  {1062, 1060,  978},
  {1062,  978,  386},
  {1062,  386, 1061},
  {1062, 1061, 1060},
  {1063, 1064, 1065},
  {1063, 1065, 1066},
  {1063, 1066, 1067},
  {1063, 1067, 1064},
  {1068, 1065, 1069},
  {1068, 1069, 1070},
  {1068, 1070, 1066},
  {1068, 1066, 1065},
  {1071, 1067, 1066},
  {1071, 1066, 1072},
  {1071, 1072, 1073},
  {1071, 1073, 1067},
  {1074, 1066, 1070},
  {1074, 1070, 1075},
  {1074, 1075, 1072},
  {1074, 1072, 1066},
  {1076, 1069, 1077},
  {1076, 1077, 1078},
  {1076, 1078, 1070},
  {1076, 1070, 1069},
  {1079, 1077, 1080},
  {1079, 1080, 1081},
  {1079, 1081, 1078},
  {1079, 1078, 1077},
  {1082, 1070, 1078},
  {1082, 1078, 1083},
  {1082, 1083, 1075},
  {1082, 1075, 1070},
  {1084, 1078, 1081},
  {1084, 1081, 1085},
  {1084, 1085, 1083},
  {1084, 1083, 1078},
  {1086, 1073, 1072},
  {1086, 1072, 1087},
  {1086, 1087, 1088},
  {1086, 1088, 1073},
  {1089, 1072, 1075},
  {1089, 1075, 1090},
  {1089, 1090, 1087},
  {1089, 1087, 1072},
  {1091, 1088, 1087},
  {1091, 1087, 1092},
  {1091, 1092, 1093},
  {1091, 1093, 1088},
  {1094, 1087, 1090},
  {1094, 1090, 1095},
  {1094, 1095, 1092},
  {1094, 1092, 1087},
  {1096, 1075, 1083},
  {1096, 1083, 1097},
  {1096, 1097, 1090},
  {1096, 1090, 1075},
  {1098, 1083, 1085},
  {1098, 1085, 1099},
  {1098, 1099, 1097},
  {1098, 1097, 1083},
  {1100, 1090, 1097},
  {1100, 1097, 1101},
  {1100, 1101, 1095},
  {1100, 1095, 1090},
  {1102, 1097, 1099},
  {1102, 1099, 1103},
  {1102, 1103, 1101},
  {1102, 1101, 1097},
  {1104, 1080, 1105},
  {1104, 1105, 1106},
  {1104, 1106, 1081},
  {1104, 1081, 1080},
  {1107, 1105, 1108},
  {1107, 1108, 1109},
  {1107, 1109, 1110},
  {1107, 1110, 1105},
  {1111, 1110, 1109},
  {1111, 1109, 1112},
  {1111, 1112, 1106},
  {1111, 1106, 1110},
  {1113, 1081, 1106},
  {1113, 1106, 1114},
  {1113, 1114, 1085},
  {1113, 1085, 1081},
  {1115, 1106, 1112},
  {1115, 1112, 1116},
  {1115, 1116, 1117},
  {1115, 1117, 1106},
  {1118, 1117, 1116},
  {1118, 1116, 1119},
  {1118, 1119, 1114},
  {1118, 1114, 1117},
  {1120, 1108, 1121},
  {1120, 1121, 1122},
  {1120, 1122, 1109},
  {1120, 1109, 1108},
  {1123, 1109, 1122},
  {1123, 1122, 1124},
  {1123, 1124, 1112},
  {1123, 1112, 1109},
  {1125, 1121, 1126},
  {1125, 1126, 1127},
  {1125, 1127, 1122},
  {1125, 1122, 1121},
  {1128, 1122, 1127},
  {1128, 1127, 1129},
  {1128, 1129, 1124},
  {1128, 1124, 1122},
  {1130, 1112, 1124},
  {1130, 1124, 1131},
  {1130, 1131, 1116},
  {1130, 1116, 1112},
  {1132, 1116, 1131},
  {1132, 1131, 1133},
  {1132, 1133, 1119},
  {1132, 1119, 1116},
  {1134, 1124, 1129},
  {1134, 1129, 1135},
  {1134, 1135, 1131},
  {1134, 1131, 1124},
  {1136, 1131, 1135},
  {1136, 1135, 1137},
  {1136, 1137, 1133},
  {1136, 1133, 1131},
  {1138, 1085, 1114},
  {1138, 1114, 1139},
  {1138, 1139, 1099},
  {1138, 1099, 1085},
  {1140, 1114, 1119},
  {1140, 1119, 1141},
  {1140, 1141, 1139},
  {1140, 1139, 1114},
  {1142, 1099, 1139},
  {1142, 1139, 1143},
  {1142, 1143, 1103},
  {1142, 1103, 1099},
  {1144, 1139, 1141},
  {1144, 1141, 1145},
  {1144, 1145, 1143},
  {1144, 1143, 1139},
  {1146, 1119, 1133},
  {1146, 1133, 1147},
  {1146, 1147, 1141},
  {1146, 1141, 1119},
  {1148, 1133, 1137},
  {1148, 1137, 1149},
  {1148, 1149, 1147},
  {1148, 1147, 1133},
  {1150, 1141, 1147},
  {1150, 1147, 1151},
  {1150, 1151, 1145},
  {1150, 1145, 1141},
  {1152, 1147, 1149},
  {1152, 1149, 1153},
  {1152, 1153, 1151},
  {1152, 1151, 1147},
  {1154, 1093, 1092},
  {1154, 1092, 1155},
  {1154, 1155, 1156},
  {1154, 1156, 1093},
  {1157, 1092, 1095},
  {1157, 1095, 1158},
  {1157, 1158, 1155},
  {1157, 1155, 1092},
  {1159, 1095, 1101},
  {1159, 1101, 1160},
  {1159, 1160, 1158},
  {1159, 1158, 1095},
  {1161, 1101, 1103},
  {1161, 1103, 1162},
  {1161, 1162, 1160},
  {1161, 1160, 1101},
  {1163, 1156, 1155},
  {1163, 1155, 1164},
  {1163, 1164, 1165},
  {1163, 1165, 1156},
  {1166, 1155, 1158},
  {1166, 1158, 1167},
  {1166, 1167, 1164},
  {1166, 1164, 1155},
  {1168, 1165, 1164},
  {1168, 1164, 1169},
  {1168, 1169, 1170},
  {1168, 1170, 1165},
  {1171, 1164, 1167},
  {1171, 1167, 1172},
  {1171, 1172, 1169},
  {1171, 1169, 1164},
  {1173, 1158, 1160},
  {1173, 1160, 1174},
  {1173, 1174, 1167},
  {1173, 1167, 1158},
  {1175, 1160, 1162},
  {1175, 1162, 1176},
  {1175, 1176, 1174},
  {1175, 1174, 1160},
  {1177, 1167, 1176},
  {1177, 1176, 1178},
  {1177, 1178, 1172},
  {1177, 1172, 1167},
  {1179, 1103, 1143},
  {1179, 1143, 1180},
  {1179, 1180, 1181},
  {1179, 1181, 1103},
  {1182, 1143, 1145},
  {1182, 1145, 1183},
  {1182, 1183, 1180},
  {1182, 1180, 1143},
  {1184, 1181, 1180},
  {1184, 1180, 1185},
  {1184, 1185, 1162},
  {1184, 1162, 1181},
  {1186, 1180, 1183},
  {1186, 1183, 1187},
  {1186, 1187, 1185},
  {1186, 1185, 1180},
  {1188, 1145, 1151},
  {1188, 1151, 1189},
  {1188, 1189, 1183},
  {1188, 1183, 1145},
  {1190, 1151, 1153},
  {1190, 1153, 1191},
  {1190, 1191, 1189},
  {1190, 1189, 1151},
  {1192, 1183, 1189},
  {1192, 1189, 1193},
  {1192, 1193, 1187},
  {1192, 1187, 1183},
  {1194, 1189, 1191},
  {1194, 1191, 1195},
  {1194, 1195, 1193},
  {1194, 1193, 1189},
  {1196, 1162, 1185},
  {1196, 1185, 1197},
  {1196, 1197, 1176},
  {1196, 1176, 1162},
  {1198, 1185, 1187},
  {1198, 1187, 1199},
  {1198, 1199, 1197},
  {1198, 1197, 1185},
  {1200, 1176, 1199},
  {1200, 1199, 1201},
  {1200, 1201, 1202},
  {1200, 1202, 1176},
  {1203, 1202, 1201},
  {1203, 1201, 1204},
  {1203, 1204, 1178},
  {1203, 1178, 1202},
  {1205, 1187, 1193},
  {1205, 1193, 1206},
  {1205, 1206, 1199},
  {1205, 1199, 1187},
  {1207, 1193, 1195},
  {1207, 1195, 1208},
  {1207, 1208, 1206},
  {1207, 1206, 1193},
  {1209, 1199, 1206},
  {1209, 1206, 1210},
  {1209, 1210, 1201},
  {1209, 1201, 1199},
  {1211, 1201, 1210},
  {1211, 1210, 1212},
  {1211, 1212, 1204},
  {1211, 1204, 1201},
  {1213, 1206, 1208},
  {1213, 1208, 1214},
  {1213, 1214, 1210},
  {1213, 1210, 1206},
  {1215, 1210, 1214},
  {1215, 1214, 1216},
  {1215, 1216, 1212},
  {1215, 1212, 1210},
  {1217, 1126, 1218},
  {1217, 1218, 1219},
  {1217, 1219, 1127},
  {1217, 1127, 1126},
  {1220, 1127, 1219},
  {1220, 1219, 1221},
  {1220, 1221, 1129},
  {1220, 1129, 1127},
  {1222, 1218, 1223},
  {1222, 1223, 1224},
  {1222, 1224, 1219},
  {1222, 1219, 1218},
  {1225, 1219, 1224},
  {1225, 1224, 1226},
  {1225, 1226, 1221},
  {1225, 1221, 1219},
  {1227, 1129, 1221},
  {1227, 1221, 1228},
  {1227, 1228, 1135},
  {1227, 1135, 1129},
  {1229, 1135, 1228},
  {1229, 1228, 1230},
  {1229, 1230, 1137},
  {1229, 1137, 1135},
  {1231, 1221, 1226},
  {1231, 1226, 1232},
  {1231, 1232, 1228},
  {1231, 1228, 1221},
  {1233, 1228, 1232},
  {1233, 1232, 1234},
  {1233, 1234, 1230},
  {1233, 1230, 1228},
  {1235, 1223, 1236},
  {1235, 1236, 1237},
  {1235, 1237, 1224},
  {1235, 1224, 1223},
  {1238, 1224, 1237},
  {1238, 1237, 1239},
  {1238, 1239, 1226},
  {1238, 1226, 1224},
  {1240, 1236, 1241},
  {1240, 1241, 1242},
  {1240, 1242, 1239},
  {1240, 1239, 1236},
  {1243, 1226, 1239},
  {1243, 1239, 1244},
  {1243, 1244, 1232},
  {1243, 1232, 1226},
  {1245, 1232, 1244},
  {1245, 1244, 1246},
  {1245, 1246, 1234},
  {1245, 1234, 1232},
  {1247, 1239, 1242},
  {1247, 1242, 1248},
  {1247, 1248, 1246},
  {1247, 1246, 1239},
  {1249, 1137, 1230},
  {1249, 1230, 1250},
  {1249, 1250, 1149},
  {1249, 1149, 1137},
  {1251, 1230, 1234},
  {1251, 1234, 1252},
  {1251, 1252, 1250},
  {1251, 1250, 1230},
  {1253, 1149, 1250},
  {1253, 1250, 1254},
  {1253, 1254, 1153},
  {1253, 1153, 1149},
  {1255, 1250, 1252},
  {1255, 1252, 1256},
  {1255, 1256, 1254},
  {1255, 1254, 1250},
  {1257, 1234, 1246},
  {1257, 1246, 1258},
  {1257, 1258, 1252},
  {1257, 1252, 1234},
  {1259, 1246, 1248},
  {1259, 1248, 1260},
  {1259, 1260, 1258},
  {1259, 1258, 1246},
  {1261, 1252, 1258},
  {1261, 1258, 1262},
  {1261, 1262, 1256},
  {1261, 1256, 1252},
  {1263, 1258, 1260},
  {1263, 1260, 1264},
  {1263, 1264, 1262},
  {1263, 1262, 1258},
  {1265, 1241, 1266},
  {1265, 1266, 1267},
  {1265, 1267, 1242},
  {1265, 1242, 1241},
  {1268, 1266, 1269},
  {1268, 1269, 1270},
  {1268, 1270, 1267},
  {1268, 1267, 1266},
  {1271, 1242, 1267},
  {1271, 1267, 1272},
  {1271, 1272, 1248},
  {1271, 1248, 1242},
  {1273, 1267, 1270},
  {1273, 1270, 1274},
  {1273, 1274, 1272},
  {1273, 1272, 1267},
  {1275, 1269, 1276},
  {1275, 1276, 1277},
  {1275, 1277, 1270},
  {1275, 1270, 1269},
  {1278, 1276, 1064},
  {1278, 1064, 1067},
  {1278, 1067, 1277},
  {1278, 1277, 1276},
  {1279, 1270, 1277},
  {1279, 1277, 1280},
  {1279, 1280, 1274},
  {1279, 1274, 1270},
  {1281, 1277, 1067},
  {1281, 1067, 1073},
  {1281, 1073, 1280},
  {1281, 1280, 1277},
  {1282, 1248, 1272},
  {1282, 1272, 1283},
  {1282, 1283, 1260},
  {1282, 1260, 1248},
  {1284, 1272, 1274},
  {1284, 1274, 1285},
  {1284, 1285, 1283},
  {1284, 1283, 1272},
  {1286, 1260, 1283},
  {1286, 1283, 1287},
  {1286, 1287, 1264},
  {1286, 1264, 1260},
  {1288, 1283, 1285},
  {1288, 1285, 1289},
  {1288, 1289, 1287},
  {1288, 1287, 1283},
  {1290, 1274, 1280},
  {1290, 1280, 1291},
  {1290, 1291, 1285},
  {1290, 1285, 1274},
  {1292, 1280, 1073},
  {1292, 1073, 1088},
  {1292, 1088, 1291},
  {1292, 1291, 1280},
  {1293, 1285, 1291},
  {1293, 1291, 1294},
  {1293, 1294, 1289},
  {1293, 1289, 1285},
  {1295, 1291, 1088},
  {1295, 1088, 1093},
  {1295, 1093, 1294},
  {1295, 1294, 1291},
  {1296, 1153, 1254},
  {1296, 1254, 1297},
  {1296, 1297, 1191},
  {1296, 1191, 1153},
  {1298, 1254, 1256},
  {1298, 1256, 1299},
  {1298, 1299, 1297},
  {1298, 1297, 1254},
  {1300, 1191, 1297},
  {1300, 1297, 1301},
  {1300, 1301, 1195},
  {1300, 1195, 1191},
  {1302, 1297, 1299},
  {1302, 1299, 1303},
  {1302, 1303, 1301},
  {1302, 1301, 1297},
  {1304, 1256, 1262},
  {1304, 1262, 1305},
  {1304, 1305, 1299},
  {1304, 1299, 1256},
  {1306, 1262, 1264},
  {1306, 1264, 1307},
  {1306, 1307, 1305},
  {1306, 1305, 1262},
  {1308, 1299, 1305},
  {1308, 1305, 1309},
  {1308, 1309, 1303},
  {1308, 1303, 1299},
  {1310, 1305, 1307},
  {1310, 1307, 1311},
  {1310, 1311, 1309},
  {1310, 1309, 1305},
  {1312, 1195, 1301},
  {1312, 1301, 1313},
  {1312, 1313, 1208},
  {1312, 1208, 1195},
  {1314, 1301, 1303},
  {1314, 1303, 1315},
  {1314, 1315, 1313},
  {1314, 1313, 1301},
  {1316, 1208, 1313},
  {1316, 1313, 1317},
  {1316, 1317, 1214},
  {1316, 1214, 1208},
  {1318, 1214, 1317},
  {1318, 1317, 1319},
  {1318, 1319, 1216},
  {1318, 1216, 1214},
  {1320, 1313, 1315},
  {1320, 1315, 1321},
  {1320, 1321, 1317},
  {1320, 1317, 1313},
  {1322, 1317, 1321},
  {1322, 1321, 1323},
  {1322, 1323, 1319},
  {1322, 1319, 1317},
  {1324, 1303, 1309},
  {1324, 1309, 1325},
  {1324, 1325, 1315},
  {1324, 1315, 1303},
  {1326, 1309, 1311},
  {1326, 1311, 1327},
  {1326, 1327, 1325},
  {1326, 1325, 1309},
  {1328, 1315, 1327},
  {1328, 1327, 1329},
  {1328, 1329, 1321},
  {1328, 1321, 1315},
  {1330, 1321, 1329},
  {1330, 1329, 1331},
  {1330, 1331, 1323},
  {1330, 1323, 1321},
  {1332, 1264, 1287},
  {1332, 1287, 1333},
  {1332, 1333, 1311},
  {1332, 1311, 1264},
  {1334, 1287, 1289},
  {1334, 1289, 1335},
  {1334, 1335, 1333},
  {1334, 1333, 1287},
  {1336, 1289, 1294},
  {1336, 1294, 1337},
  {1336, 1337, 1335},
  {1336, 1335, 1289},
  {1338, 1294, 1093},
  {1338, 1093, 1156},
  {1338, 1156, 1337},
  {1338, 1337, 1294},
  {1339, 1311, 1333},
  {1339, 1333, 1340},
  {1339, 1340, 1327},
  {1339, 1327, 1311},
  {1341, 1333, 1335},
  {1341, 1335, 1342},
  {1341, 1342, 1340},
  {1341, 1340, 1333},
  {1343, 1327, 1342},
  {1343, 1342, 1344},
  {1343, 1344, 1331},
  {1343, 1331, 1327},
  {1345, 1335, 1337},
  {1345, 1337, 1346},
  {1345, 1346, 1342},
  {1345, 1342, 1335},
  {1347, 1337, 1156},
  {1347, 1156, 1165},
  {1347, 1165, 1346},
  {1347, 1346, 1337},
  {1348, 1342, 1346},
  {1348, 1346, 1349},
  {1348, 1349, 1344},
  {1348, 1344, 1342},
  {1350, 1346, 1165},
  {1350, 1165, 1170},
  {1350, 1170, 1349},
  {1350, 1349, 1346},
  {1351, 1170, 1169},
  {1351, 1169, 1352},
  {1351, 1352, 1353},
  {1351, 1353, 1170},
  {1354, 1169, 1172},
  {1354, 1172, 1355},
  {1354, 1355, 1352},
  {1354, 1352, 1169},
  {1356, 1172, 1178},
  {1356, 1178, 1357},
  {1356, 1357, 1355},
  {1356, 1355, 1172},
  {1358, 1353, 1352},
  {1358, 1352, 1359},
  {1358, 1359, 1360},
  {1358, 1360, 1353},
  {1361, 1352, 1355},
  {1361, 1355, 1362},
  {1361, 1362, 1359},
  {1361, 1359, 1352},
  {1363, 1355, 1357},
  {1363, 1357, 1364},
  {1363, 1364, 1362},
  {1363, 1362, 1355},
  {1365, 1178, 1204},
  {1365, 1204, 1366},
  {1365, 1366, 1357},
  {1365, 1357, 1178},
  {1367, 1204, 1212},
  {1367, 1212, 1368},
  {1367, 1368, 1366},
  {1367, 1366, 1204},
  {1369, 1212, 1216},
  {1369, 1216, 1370},
  {1369, 1370, 1368},
  {1369, 1368, 1212},
  {1371, 1357, 1366},
  {1371, 1366, 1372},
  {1371, 1372, 1364},
  {1371, 1364, 1357},
  {1373, 1366, 1368},
  {1373, 1368, 1374},
  {1373, 1374, 1372},
  {1373, 1372, 1366},
  {1375, 1368, 1370},
  {1375, 1370, 1376},
  {1375, 1376, 1374},
  {1375, 1374, 1368},
  {1377, 1360, 1359},
  {1377, 1359, 1378},
  {1377, 1378, 1379},
  {1377, 1379, 1360},
  {1380, 1359, 1362},
  {1380, 1362, 1381},
  {1380, 1381, 1378},
  {1380, 1378, 1359},
  {1382, 1362, 1364},
  {1382, 1364, 1383},
  {1382, 1383, 1381},
  {1382, 1381, 1362},
  {1384, 1379, 1378},
  {1384, 1378, 1385},
  {1384, 1385, 1386},
  {1384, 1386, 1379},
  {1387, 1378, 1381},
  {1387, 1381, 1388},
  {1387, 1388, 1385},
  {1387, 1385, 1378},
  {1389, 1381, 1383},
  {1389, 1383, 1390},
  {1389, 1390, 1388},
  {1389, 1388, 1381},
  {1391, 1364, 1372},
  {1391, 1372, 1392},
  {1391, 1392, 1383},
  {1391, 1383, 1364},
  {1393, 1372, 1374},
  {1393, 1374, 1394},
  {1393, 1394, 1392},
  {1393, 1392, 1372},
  {1395, 1374, 1376},
  {1395, 1376, 1396},
  {1395, 1396, 1394},
  {1395, 1394, 1374},
  {1397, 1383, 1392},
  {1397, 1392, 1398},
  {1397, 1398, 1390},
  {1397, 1390, 1383},
  {1399, 1392, 1394},
  {1399, 1394, 1400},
  {1399, 1400, 1398},
  {1399, 1398, 1392},
  {1401, 1394, 1396},
  {1401, 1396, 1402},
  {1401, 1402, 1400},
  {1401, 1400, 1394},
  {1403, 1216, 1319},
  {1403, 1319, 1404},
  {1403, 1404, 1370},
  {1403, 1370, 1216},
  {1405, 1319, 1323},
  {1405, 1323, 1406},
  {1405, 1406, 1404},
  {1405, 1404, 1319},
  {1407, 1323, 1331},
  {1407, 1331, 1408},
  {1407, 1408, 1406},
  {1407, 1406, 1323},
  {1409, 1370, 1404},
  {1409, 1404, 1410},
  {1409, 1410, 1376},
  {1409, 1376, 1370},
  {1411, 1404, 1406},
  {1411, 1406, 1412},
  {1411, 1412, 1410},
  {1411, 1410, 1404},
  {1413, 1406, 1408},
  {1413, 1408, 1414},
  {1413, 1414, 1412},
  {1413, 1412, 1406},
  {1415, 1331, 1344},
  {1415, 1344, 1416},
  {1415, 1416, 1408},
  {1415, 1408, 1331},
  {1417, 1344, 1349},
  {1417, 1349, 1418},
  {1417, 1418, 1416},
  {1417, 1416, 1344},
  {1419, 1349, 1170},
  {1419, 1170, 1353},
  {1419, 1353, 1418},
  {1419, 1418, 1349},
  {1420, 1408, 1416},
  {1420, 1416, 1421},
  {1420, 1421, 1414},
  {1420, 1414, 1408},
  {1422, 1416, 1418},
  {1422, 1418, 1423},
  {1422, 1423, 1421},
  {1422, 1421, 1416},
  {1424, 1418, 1353},
  {1424, 1353, 1360},
  {1424, 1360, 1423},
  {1424, 1423, 1418},
  {1425, 1376, 1410},
  {1425, 1410, 1426},
  {1425, 1426, 1396},
  {1425, 1396, 1376},
  {1427, 1410, 1412},
  {1427, 1412, 1428},
  {1427, 1428, 1426},
  {1427, 1426, 1410},
  {1429, 1412, 1414},
  {1429, 1414, 1430},
  {1429, 1430, 1428},
  {1429, 1428, 1412},
  {1431, 1396, 1426},
  {1431, 1426, 1432},
  {1431, 1432, 1402},
  {1431, 1402, 1396},
  {1433, 1426, 1428},
  {1433, 1428, 1434},
  {1433, 1434, 1432},
  {1433, 1432, 1426},
  {1435, 1428, 1430},
  {1435, 1430, 1436},
  {1435, 1436, 1434},
  {1435, 1434, 1428},
  {1437, 1414, 1421},
  {1437, 1421, 1438},
  {1437, 1438, 1430},
  {1437, 1430, 1414},
  {1439, 1421, 1423},
  {1439, 1423, 1440},
  {1439, 1440, 1438},
  {1439, 1438, 1421},
  {1441, 1423, 1360},
  {1441, 1360, 1379},
  {1441, 1379, 1440},
  {1441, 1440, 1423},
  {1442, 1430, 1438},
  {1442, 1438, 1443},
  {1442, 1443, 1436},
  {1442, 1436, 1430},
  {1444, 1438, 1440},
  {1444, 1440, 1445},
  {1444, 1445, 1443},
  {1444, 1443, 1438},
  {1446, 1440, 1379},
  {1446, 1379, 1386},
  {1446, 1386, 1445},
  {1446, 1445, 1440},
  {1447, 1448, 1449},
  {1447, 1449, 1450},
  {1447, 1450, 1448},
  {1451, 1450, 1449},
  {1451, 1449, 1452},
  {1451, 1452, 1453},
  {1451, 1453, 1450},
  {1454, 1448, 1455},
  {1454, 1455, 1449},
  {1454, 1449, 1448},
  {1456, 1449, 1455},
  {1456, 1455, 1457},
  {1456, 1457, 1452},
  {1456, 1452, 1449},
  {1458, 1453, 1452},
  {1458, 1452, 1459},
  {1458, 1459, 1460},
  {1458, 1460, 1453},
  {1461, 1460, 1459},
  {1461, 1459, 1462},
  {1461, 1462, 1463},
  {1461, 1463, 1460},
  {1464, 1452, 1457},
  {1464, 1457, 1465},
  {1464, 1465, 1459},
  {1464, 1459, 1452},
  {1466, 1459, 1465},
  {1466, 1465, 1467},
  {1466, 1467, 1462},
  {1466, 1462, 1459},
  {1468, 1448, 1469},
  {1468, 1469, 1455},
  {1468, 1455, 1448},
  {1470, 1455, 1469},
  {1470, 1469, 1471},
  {1470, 1471, 1457},
  {1470, 1457, 1455},
  {1472, 1448, 1473},
  {1472, 1473, 1469},
  {1472, 1469, 1448},
  {1474, 1469, 1473},
  {1474, 1473, 1475},
  {1474, 1475, 1471},
  {1474, 1471, 1469},
  {1476, 1457, 1471},
  {1476, 1471, 1477},
  {1476, 1477, 1465},
  {1476, 1465, 1457},
  {1478, 1465, 1477},
  {1478, 1477, 1479},
  {1478, 1479, 1467},
  {1478, 1467, 1465},
  {1480, 1471, 1475},
  {1480, 1475, 1481},
  {1480, 1481, 1477},
  {1480, 1477, 1471},
  {1482, 1477, 1481},
  {1482, 1481, 1483},
  {1482, 1483, 1479},
  {1482, 1479, 1477},
  {1484, 1463, 1462},
  {1484, 1462, 1485},
  {1484, 1485, 1486},
  {1484, 1486, 1463},
  {1487, 1462, 1467},
  {1487, 1467, 1488},
  {1487, 1488, 1485},
  {1487, 1485, 1462},
  {1489, 1486, 1485},
  {1489, 1485, 1490},
  {1489, 1490, 1491},
  {1489, 1491, 1486},
  {1492, 1491, 1490},
  {1492, 1490, 1493},
  {1492, 1493, 1494},
  {1492, 1494, 1491},
  {1495, 1485, 1488},
  {1495, 1488, 1496},
  {1495, 1496, 1490},
  {1495, 1490, 1485},
  {1497, 1490, 1496},
  {1497, 1496, 1498},
  {1497, 1498, 1493},
  {1497, 1493, 1490},
  {1499, 1467, 1479},
  {1499, 1479, 1500},
  {1499, 1500, 1488},
  {1499, 1488, 1467},
  {1501, 1479, 1483},
  {1501, 1483, 1502},
  {1501, 1502, 1500},
  {1501, 1500, 1479},
  {1503, 1488, 1500},
  {1503, 1500, 1504},
  {1503, 1504, 1496},
  {1503, 1496, 1488},
  {1505, 1496, 1504},
  {1505, 1504, 1506},
  {1505, 1506, 1498},
  {1505, 1498, 1496},
  {1507, 1500, 1502},
  {1507, 1502, 1508},
  {1507, 1508, 1504},
  {1507, 1504, 1500},
  {1509, 1504, 1508},
  {1509, 1508, 1510},
  {1509, 1510, 1506},
  {1509, 1506, 1504},
  {1511, 1448, 1512},
  {1511, 1512, 1473},
  {1511, 1473, 1448},
  {1513, 1473, 1512},
  {1513, 1512, 1514},
  {1513, 1514, 1475},
  {1513, 1475, 1473},
  {1515, 1448, 1516},
  {1515, 1516, 1512},
  {1515, 1512, 1448},
  {1517, 1512, 1516},
  {1517, 1516, 1518},
  {1517, 1518, 1514},
  {1517, 1514, 1512},
  {1519, 1475, 1514},
  {1519, 1514, 1520},
  {1519, 1520, 1481},
  {1519, 1481, 1475},
  {1521, 1481, 1520},
  {1521, 1520, 1522},
  {1521, 1522, 1483},
  {1521, 1483, 1481},
  {1523, 1514, 1518},
  {1523, 1518, 1524},
  {1523, 1524, 1520},
  {1523, 1520, 1514},
  {1525, 1520, 1524},
  {1525, 1524, 1526},
  {1525, 1526, 1522},
  {1525, 1522, 1520},
  {1527, 1448, 1528},
  {1527, 1528, 1516},
  {1527, 1516, 1448},
  {1529, 1516, 1528},
  {1529, 1528, 1530},
  {1529, 1530, 1518},
  {1529, 1518, 1516},
  {1531, 1448, 1532},
  {1531, 1532, 1528},
  {1531, 1528, 1448},
  {1533, 1528, 1532},
  {1533, 1532, 1534},
  {1533, 1534, 1530},
  {1533, 1530, 1528},
  {1535, 1518, 1530},
  {1535, 1530, 1536},
  {1535, 1536, 1524},
  {1535, 1524, 1518},
  {1537, 1524, 1536},
  {1537, 1536, 1538},
  {1537, 1538, 1526},
  {1537, 1526, 1524},
  {1539, 1530, 1534},
  {1539, 1534, 1540},
  {1539, 1540, 1536},
  {1539, 1536, 1530},
  {1541, 1536, 1540},
  {1541, 1540, 1542},
  {1541, 1542, 1538},
  {1541, 1538, 1536},
  {1543, 1483, 1522},
  {1543, 1522, 1544},
  {1543, 1544, 1502},
  {1543, 1502, 1483},
  {1545, 1522, 1526},
  {1545, 1526, 1546},
  {1545, 1546, 1544},
  {1545, 1544, 1522},
  {1547, 1502, 1544},
  {1547, 1544, 1548},
  {1547, 1548, 1508},
  {1547, 1508, 1502},
  {1549, 1508, 1548},
  {1549, 1548, 1550},
  {1549, 1550, 1510},
  {1549, 1510, 1508},
  {1551, 1544, 1546},
  {1551, 1546, 1552},
  {1551, 1552, 1548},
  {1551, 1548, 1544},
  {1553, 1548, 1552},
  {1553, 1552, 1554},
  {1553, 1554, 1550},
  {1553, 1550, 1548},
  {1555, 1526, 1538},
  {1555, 1538, 1556},
  {1555, 1556, 1546},
  {1555, 1546, 1526},
  {1557, 1538, 1542},
  {1557, 1542, 1558},
  {1557, 1558, 1556},
  {1557, 1556, 1538},
  {1559, 1546, 1556},
  {1559, 1556, 1560},
  {1559, 1560, 1552},
  {1559, 1552, 1546},
  {1561, 1552, 1560},
  {1561, 1560, 1562},
  {1561, 1562, 1554},
  {1561, 1554, 1552},
  {1563, 1556, 1558},
  {1563, 1558, 1564},
  {1563, 1564, 1560},
  {1563, 1560, 1556},
  {1565, 1560, 1564},
  {1565, 1564, 1566},
  {1565, 1566, 1562},
  {1565, 1562, 1560},
  {1567, 1448, 1568},
  {1567, 1568, 1532},
  {1567, 1532, 1448},
  {1569, 1532, 1568},
  {1569, 1568, 1570},
  {1569, 1570, 1534},
  {1569, 1534, 1532},
  {1571, 1448, 1572},
  {1571, 1572, 1568},
  {1571, 1568, 1448},
  {1573, 1568, 1572},
  {1573, 1572, 1574},
  {1573, 1574, 1570},
  {1573, 1570, 1568},
  {1575, 1534, 1570},
  {1575, 1570, 1576},
  {1575, 1576, 1540},
  {1575, 1540, 1534},
  {1577, 1540, 1576},
  {1577, 1576, 1578},
  {1577, 1578, 1542},
  {1577, 1542, 1540},
  {1579, 1570, 1574},
  {1579, 1574, 1580},
  {1579, 1580, 1576},
  {1579, 1576, 1570},
  {1581, 1576, 1580},
  {1581, 1580, 1582},
  {1581, 1582, 1578},
  {1581, 1578, 1576},
  {1583, 1448, 1584},
  {1583, 1584, 1572},
  {1583, 1572, 1448},
  {1585, 1572, 1584},
  {1585, 1584, 1586},
  {1585, 1586, 1574},
  {1585, 1574, 1572},
  {1587, 1448, 1588},
  {1587, 1588, 1584},
  {1587, 1584, 1448},
  {1589, 1584, 1588},
  {1589, 1588, 1590},
  {1589, 1590, 1586},
  {1589, 1586, 1584},
  {1591, 1574, 1586},
  {1591, 1586, 1592},
  {1591, 1592, 1580},
  {1591, 1580, 1574},
  {1593, 1580, 1592},
  {1593, 1592, 1594},
  {1593, 1594, 1582},
  {1593, 1582, 1580},
  {1595, 1586, 1590},
  {1595, 1590, 1596},
  {1595, 1596, 1592},
  {1595, 1592, 1586},
  {1597, 1592, 1596},
  {1597, 1596, 1598},
  {1597, 1598, 1594},
  {1597, 1594, 1592},
  {1599, 1542, 1578},
  {1599, 1578, 1600},
  {1599, 1600, 1558},
  {1599, 1558, 1542},
  {1601, 1578, 1582},
  {1601, 1582, 1602},
  {1601, 1602, 1600},
  {1601, 1600, 1578},
  {1603, 1558, 1600},
  {1603, 1600, 1604},
  {1603, 1604, 1564},
  {1603, 1564, 1558},
  {1605, 1564, 1604},
  {1605, 1604, 1606},
  {1605, 1606, 1566},
  {1605, 1566, 1564},
  {1607, 1600, 1602},
  {1607, 1602, 1608},
  {1607, 1608, 1604},
  {1607, 1604, 1600},
  {1609, 1604, 1608},
  {1609, 1608, 1610},
  {1609, 1610, 1606},
  {1609, 1606, 1604},
  {1611, 1582, 1594},
  {1611, 1594, 1612},
  {1611, 1612, 1602},
  {1611, 1602, 1582},
  {1613, 1594, 1598},
  {1613, 1598, 1614},
  {1613, 1614, 1612},
  {1613, 1612, 1594},
  {1615, 1602, 1612},
  {1615, 1612, 1616},
  {1615, 1616, 1608},
  {1615, 1608, 1602},
  {1617, 1608, 1616},
  {1617, 1616, 1618},
  {1617, 1618, 1610},
  {1617, 1610, 1608},
  {1619, 1612, 1614},
  {1619, 1614, 1620},
  {1619, 1620, 1616},
  {1619, 1616, 1612},
  {1621, 1616, 1620},
  {1621, 1620, 1622},
  {1621, 1622, 1618},
  {1621, 1618, 1616},
  {1623, 1448, 1624},
  {1623, 1624, 1588},
  {1623, 1588, 1448},
  {1625, 1588, 1624},
  {1625, 1624, 1626},
  {1625, 1626, 1590},
  {1625, 1590, 1588},
  {1627, 1448, 1628},
  {1627, 1628, 1624},
  {1627, 1624, 1448},
  {1629, 1624, 1628},
  {1629, 1628, 1630},
  {1629, 1630, 1626},
  {1629, 1626, 1624},
  {1631, 1590, 1626},
  {1631, 1626, 1632},
  {1631, 1632, 1596},
  {1631, 1596, 1590},
  {1633, 1596, 1632},
  {1633, 1632, 1634},
  {1633, 1634, 1598},
  {1633, 1598, 1596},
  {1635, 1626, 1630},
  {1635, 1630, 1636},
  {1635, 1636, 1632},
  {1635, 1632, 1626},
  {1637, 1632, 1636},
  {1637, 1636, 1638},
  {1637, 1638, 1634},
  {1637, 1634, 1632},
  {1639, 1448, 1640},
  {1639, 1640, 1628},
  {1639, 1628, 1448},
  {1641, 1628, 1640},
  {1641, 1640, 1642},
  {1641, 1642, 1630},
  {1641, 1630, 1628},
  {1643, 1448, 1450},
  {1643, 1450, 1640},
  {1643, 1640, 1448},
  {1644, 1640, 1450},
  {1644, 1450, 1453},
  {1644, 1453, 1642},
  {1644, 1642, 1640},
  {1645, 1630, 1642},
  {1645, 1642, 1646},
  {1645, 1646, 1636},
  {1645, 1636, 1630},
  {1647, 1636, 1646},
  {1647, 1646, 1648},
  {1647, 1648, 1638},
  {1647, 1638, 1636},
  {1649, 1642, 1453},
  {1649, 1453, 1460},
  {1649, 1460, 1646},
  {1649, 1646, 1642},
  {1650, 1646, 1460},
  {1650, 1460, 1463},
  {1650, 1463, 1648},
  {1650, 1648, 1646},
  {1651, 1598, 1634},
  {1651, 1634, 1652},
  {1651, 1652, 1614},
  {1651, 1614, 1598},
  {1653, 1634, 1638},
  {1653, 1638, 1654},
  {1653, 1654, 1652},
  {1653, 1652, 1634},
  {1655, 1614, 1652},
  {1655, 1652, 1656},
  {1655, 1656, 1620},
  {1655, 1620, 1614},
  {1657, 1620, 1656},
  {1657, 1656, 1658},
  {1657, 1658, 1622},
  {1657, 1622, 1620},
  {1659, 1652, 1654},
  {1659, 1654, 1660},
  {1659, 1660, 1656},
  {1659, 1656, 1652},
  {1661, 1656, 1660},
  {1661, 1660, 1662},
  {1661, 1662, 1658},
  {1661, 1658, 1656},
  {1663, 1638, 1648},
  {1663, 1648, 1664},
  {1663, 1664, 1654},
  {1663, 1654, 1638},
  {1665, 1648, 1463},
  {1665, 1463, 1486},
  {1665, 1486, 1664},
  {1665, 1664, 1648},
  {1666, 1654, 1664},
  {1666, 1664, 1667},
  {1666, 1667, 1660},
  {1666, 1660, 1654},
  {1668, 1660, 1667},
  {1668, 1667, 1669},
  {1668, 1669, 1662},
  {1668, 1662, 1660},
  {1670, 1664, 1486},
  {1670, 1486, 1491},
  {1670, 1491, 1667},
  {1670, 1667, 1664},
  {1671, 1667, 1491},
  {1671, 1491, 1494},
  {1671, 1494, 1669},
  {1671, 1669, 1667},
  {1672, 1494, 1493},
  {1672, 1493, 1673},
  {1672, 1673, 1674},
  {1672, 1674, 1494},
  {1675, 1493, 1498},
  {1675, 1498, 1676},
  {1675, 1676, 1673},
  {1675, 1673, 1493},
  {1677, 1674, 1678},
  {1677, 1678, 1679},
  {1677, 1679, 1680},
  {1677, 1680, 1674},
  {1681, 1678, 1673},
  {1681, 1673, 1682},
  {1681, 1682, 1679},
  {1681, 1679, 1678},
  {1683, 1673, 1684},
  {1683, 1684, 1685},
  {1683, 1685, 1682},
  {1683, 1682, 1673},
  {1686, 1684, 1676},
  {1686, 1676, 1687},
  {1686, 1687, 1685},
  {1686, 1685, 1684},
  {1688, 1498, 1506},
  {1688, 1506, 1689},
  {1688, 1689, 1676},
  {1688, 1676, 1498},
  {1690, 1506, 1510},
  {1690, 1510, 1691},
  {1690, 1691, 1689},
  {1690, 1689, 1506},
  {1692, 1676, 1693},
  {1692, 1693, 1694},
  {1692, 1694, 1687},
  {1692, 1687, 1676},
  {1695, 1693, 1689},
  {1695, 1689, 1696},
  {1695, 1696, 1694},
  {1695, 1694, 1693},
  {1697, 1689, 1698},
  {1697, 1698, 1699},
  {1697, 1699, 1696},
  {1697, 1696, 1689},
  {1700, 1698, 1691},
  {1700, 1691, 1701},
  {1700, 1701, 1699},
  {1700, 1699, 1698},
  {1702, 1680, 1679},
  {1702, 1679, 1703},
  {1702, 1703, 1704},
  {1702, 1704, 1680},
  {1705, 1679, 1682},
  {1705, 1682, 1706},
  {1705, 1706, 1703},
  {1705, 1703, 1679},
  {1707, 1682, 1685},
  {1707, 1685, 1708},
  {1707, 1708, 1706},
  {1707, 1706, 1682},
  {1709, 1685, 1687},
  {1709, 1687, 1710},
  {1709, 1710, 1708},
  {1709, 1708, 1685},
  {1711, 1704, 1703},
  {1711, 1703, 1712},
  {1711, 1712, 1713},
  {1711, 1713, 1704},
  {1714, 1703, 1706},
  {1714, 1706, 1715},
  {1714, 1715, 1712},
  {1714, 1712, 1703},
  {1716, 1713, 1712},
  {1716, 1712, 1717},
  {1716, 1717, 1718},
  {1716, 1718, 1713},
  {1719, 1712, 1715},
  {1719, 1715, 1720},
  {1719, 1720, 1717},
  {1719, 1717, 1712},
  {1721, 1706, 1708},
  {1721, 1708, 1722},
  {1721, 1722, 1715},
  {1721, 1715, 1706},
  {1723, 1708, 1710},
  {1723, 1710, 1724},
  {1723, 1724, 1722},
  {1723, 1722, 1708},
  {1725, 1715, 1722},
  {1725, 1722, 1726},
  {1725, 1726, 1720},
  {1725, 1720, 1715},
  {1727, 1722, 1724},
  {1727, 1724, 1728},
  {1727, 1728, 1726},
  {1727, 1726, 1722},
  {1729, 1687, 1694},
  {1729, 1694, 1730},
  {1729, 1730, 1710},
  {1729, 1710, 1687},
  {1731, 1694, 1696},
  {1731, 1696, 1732},
  {1731, 1732, 1730},
  {1731, 1730, 1694},
  {1733, 1696, 1699},
  {1733, 1699, 1734},
  {1733, 1734, 1732},
  {1733, 1732, 1696},
  {1735, 1699, 1701},
  {1735, 1701, 1736},
  {1735, 1736, 1734},
  {1735, 1734, 1699},
  {1737, 1710, 1730},
  {1737, 1730, 1738},
  {1737, 1738, 1724},
  {1737, 1724, 1710},
  {1739, 1730, 1732},
  {1739, 1732, 1740},
  {1739, 1740, 1738},
  {1739, 1738, 1730},
  {1741, 1724, 1738},
  {1741, 1738, 1742},
  {1741, 1742, 1728},
  {1741, 1728, 1724},
  {1743, 1738, 1740},
  {1743, 1740, 1744},
  {1743, 1744, 1742},
  {1743, 1742, 1738},
  {1745, 1732, 1734},
  {1745, 1734, 1746},
  {1745, 1746, 1740},
  {1745, 1740, 1732},
  {1747, 1734, 1736},
  {1747, 1736, 1748},
  {1747, 1748, 1746},
  {1747, 1746, 1734},
  {1749, 1740, 1746},
  {1749, 1746, 1750},
  {1749, 1750, 1744},
  {1749, 1744, 1740},
  {1751, 1746, 1748},
  {1751, 1748, 1752},
  {1751, 1752, 1750},
  {1751, 1750, 1746},
  {1753, 1510, 1550},
  {1753, 1550, 1754},
  {1753, 1754, 1691},
  {1753, 1691, 1510},
  {1755, 1550, 1554},
  {1755, 1554, 1756},
  {1755, 1756, 1754},
  {1755, 1754, 1550},
  {1757, 1691, 1758},
  {1757, 1758, 1759},
  {1757, 1759, 1701},
  {1757, 1701, 1691},
  {1760, 1758, 1754},
  {1760, 1754, 1761},
  {1760, 1761, 1759},
  {1760, 1759, 1758},
  {1762, 1754, 1763},
  {1762, 1763, 1764},
  {1762, 1764, 1761},
  {1762, 1761, 1754},
  {1765, 1763, 1756},
  {1765, 1756, 1766},
  {1765, 1766, 1764},
  {1765, 1764, 1763},
  {1767, 1554, 1562},
  {1767, 1562, 1768},
  {1767, 1768, 1756},
  {1767, 1756, 1554},
  {1769, 1562, 1566},
  {1769, 1566, 1770},
  {1769, 1770, 1768},
  {1769, 1768, 1562},
  {1771, 1756, 1772},
  {1771, 1772, 1773},
  {1771, 1773, 1766},
  {1771, 1766, 1756},
  {1774, 1772, 1768},
  {1774, 1768, 1775},
  {1774, 1775, 1773},
  {1774, 1773, 1772},
  {1776, 1768, 1777},
  {1776, 1777, 1778},
  {1776, 1778, 1775},
  {1776, 1775, 1768},
  {1779, 1777, 1770},
  {1779, 1770, 1780},
  {1779, 1780, 1778},
  {1779, 1778, 1777},
  {1781, 1701, 1759},
  {1781, 1759, 1782},
  {1781, 1782, 1736},
  {1781, 1736, 1701},
  {1783, 1759, 1761},
  {1783, 1761, 1784},
  {1783, 1784, 1782},
  {1783, 1782, 1759},
  {1785, 1761, 1764},
  {1785, 1764, 1786},
  {1785, 1786, 1784},
  {1785, 1784, 1761},
  {1787, 1764, 1766},
  {1787, 1766, 1788},
  {1787, 1788, 1786},
  {1787, 1786, 1764},
  {1789, 1736, 1782},
  {1789, 1782, 1790},
  {1789, 1790, 1748},
  {1789, 1748, 1736},
  {1791, 1782, 1784},
  {1791, 1784, 1792},
  {1791, 1792, 1790},
  {1791, 1790, 1782},
  {1793, 1748, 1790},
  {1793, 1790, 1794},
  {1793, 1794, 1752},
  {1793, 1752, 1748},
  {1795, 1790, 1792},
  {1795, 1792, 1796},
  {1795, 1796, 1794},
  {1795, 1794, 1790},
  {1797, 1784, 1786},
  {1797, 1786, 1798},
  {1797, 1798, 1792},
  {1797, 1792, 1784},
  {1799, 1786, 1788},
  {1799, 1788, 1800},
  {1799, 1800, 1798},
  {1799, 1798, 1786},
  {1801, 1792, 1798},
  {1801, 1798, 1802},
  {1801, 1802, 1796},
  {1801, 1796, 1792},
  {1803, 1798, 1800},
  {1803, 1800, 1804},
  {1803, 1804, 1802},
  {1803, 1802, 1798},
  {1805, 1766, 1773},
  {1805, 1773, 1806},
  {1805, 1806, 1788},
  {1805, 1788, 1766},
  {1807, 1773, 1775},
  {1807, 1775, 1808},
  {1807, 1808, 1806},
  {1807, 1806, 1773},
  {1809, 1775, 1778},
  {1809, 1778, 1810},
  {1809, 1810, 1808},
  {1809, 1808, 1775},
  {1811, 1778, 1780},
  {1811, 1780, 1812},
  {1811, 1812, 1810},
  {1811, 1810, 1778},
  {1813, 1788, 1806},
  {1813, 1806, 1814},
  {1813, 1814, 1800},
  {1813, 1800, 1788},
  {1815, 1806, 1808},
  {1815, 1808, 1816},
  {1815, 1816, 1814},
  {1815, 1814, 1806},
  {1817, 1800, 1814},
  {1817, 1814, 1818},
  {1817, 1818, 1804},
  {1817, 1804, 1800},
  {1819, 1814, 1816},
  {1819, 1816, 1820},
  {1819, 1820, 1818},
  {1819, 1818, 1814},
  {1821, 1808, 1810},
  {1821, 1810, 1822},
  {1821, 1822, 1816},
  {1821, 1816, 1808},
  {1823, 1810, 1812},
  {1823, 1812, 1824},
  {1823, 1824, 1822},
  {1823, 1822, 1810},
  {1825, 1816, 1822},
  {1825, 1822, 1826},
  {1825, 1826, 1820},
  {1825, 1820, 1816},
  {1827, 1822, 1824},
  {1827, 1824, 1828},
  {1827, 1828, 1826},
  {1827, 1826, 1822},
  {1829, 1566, 1606},
  {1829, 1606, 1830},
  {1829, 1830, 1770},
  {1829, 1770, 1566},
  {1831, 1606, 1610},
  {1831, 1610, 1832},
  {1831, 1832, 1830},
  {1831, 1830, 1606},
  {1833, 1770, 1834},
  {1833, 1834, 1835},
  {1833, 1835, 1780},
  {1833, 1780, 1770},
  {1836, 1834, 1830},
  {1836, 1830, 1837},
  {1836, 1837, 1835},
  {1836, 1835, 1834},
  {1838, 1830, 1839},
  {1838, 1839, 1840},
  {1838, 1840, 1837},
  {1838, 1837, 1830},
  {1841, 1839, 1832},
  {1841, 1832, 1842},
  {1841, 1842, 1840},
  {1841, 1840, 1839},
  {1843, 1610, 1618},
  {1843, 1618, 1844},
  {1843, 1844, 1832},
  {1843, 1832, 1610},
  {1845, 1618, 1622},
  {1845, 1622, 1846},
  {1845, 1846, 1844},
  {1845, 1844, 1618},
  {1847, 1832, 1848},
  {1847, 1848, 1849},
  {1847, 1849, 1842},
  {1847, 1842, 1832},
  {1850, 1848, 1844},
  {1850, 1844, 1851},
  {1850, 1851, 1849},
  {1850, 1849, 1848},
  {1852, 1844, 1853},
  {1852, 1853, 1854},
  {1852, 1854, 1851},
  {1852, 1851, 1844},
  {1855, 1853, 1846},
  {1855, 1846, 1856},
  {1855, 1856, 1854},
  {1855, 1854, 1853},
  {1857, 1780, 1835},
  {1857, 1835, 1858},
  {1857, 1858, 1812},
  {1857, 1812, 1780},
  {1859, 1835, 1837},
  {1859, 1837, 1860},
  {1859, 1860, 1858},
  {1859, 1858, 1835},
  {1861, 1837, 1840},
  {1861, 1840, 1862},
  {1861, 1862, 1860},
  {1861, 1860, 1837},
  {1863, 1840, 1842},
  {1863, 1842, 1864},
  {1863, 1864, 1862},
  {1863, 1862, 1840},
  {1865, 1812, 1858},
  {1865, 1858, 1866},
  {1865, 1866, 1824},
  {1865, 1824, 1812},
  {1867, 1858, 1860},
  {1867, 1860, 1868},
  {1867, 1868, 1866},
  {1867, 1866, 1858},
  {1869, 1824, 1866},
  {1869, 1866, 1870},
  {1869, 1870, 1828},
  {1869, 1828, 1824},
  {1871, 1866, 1868},
  {1871, 1868, 1872},
  {1871, 1872, 1870},
  {1871, 1870, 1866},
  {1873, 1860, 1862},
  {1873, 1862, 1874},
  {1873, 1874, 1868},
  {1873, 1868, 1860},
  {1875, 1862, 1864},
  {1875, 1864, 1876},
  {1875, 1876, 1874},
  {1875, 1874, 1862},
  {1877, 1868, 1874},
  {1877, 1874, 1878},
  {1877, 1878, 1872},
  {1877, 1872, 1868},
  {1879, 1874, 1876},
  {1879, 1876, 1880},
  {1879, 1880, 1878},
  {1879, 1878, 1874},
  {1881, 1842, 1849},
  {1881, 1849, 1882},
  {1881, 1882, 1864},
  {1881, 1864, 1842},
  {1883, 1849, 1851},
  {1883, 1851, 1884},
  {1883, 1884, 1882},
  {1883, 1882, 1849},
  {1885, 1851, 1854},
  {1885, 1854, 1886},
  {1885, 1886, 1884},
  {1885, 1884, 1851},
  {1887, 1854, 1856},
  {1887, 1856, 1888},
  {1887, 1888, 1886},
  {1887, 1886, 1854},
  {1889, 1864, 1882},
  {1889, 1882, 1890},
  {1889, 1890, 1876},
  {1889, 1876, 1864},
  {1891, 1882, 1884},
  {1891, 1884, 1892},
  {1891, 1892, 1890},
  {1891, 1890, 1882},
  {1893, 1876, 1890},
  {1893, 1890, 1894},
  {1893, 1894, 1880},
  {1893, 1880, 1876},
  {1895, 1890, 1892},
  {1895, 1892, 1896},
  {1895, 1896, 1894},
  {1895, 1894, 1890},
  {1897, 1884, 1886},
  {1897, 1886, 1898},
  {1897, 1898, 1892},
  {1897, 1892, 1884},
  {1899, 1886, 1888},
  {1899, 1888, 1900},
  {1899, 1900, 1898},
  {1899, 1898, 1886},
  {1901, 1892, 1898},
  {1901, 1898, 1902},
  {1901, 1902, 1896},
  {1901, 1896, 1892},
  {1903, 1898, 1900},
  {1903, 1900, 1904},
  {1903, 1904, 1902},
  {1903, 1902, 1898},
  {1905, 1622, 1658},
  {1905, 1658, 1906},
  {1905, 1906, 1846},
  {1905, 1846, 1622},
  {1907, 1658, 1662},
  {1907, 1662, 1908},
  {1907, 1908, 1906},
  {1907, 1906, 1658},
  {1909, 1846, 1910},
  {1909, 1910, 1911},
  {1909, 1911, 1856},
  {1909, 1856, 1846},
  {1912, 1910, 1906},
  {1912, 1906, 1913},
  {1912, 1913, 1911},
  {1912, 1911, 1910},
  {1914, 1906, 1915},
  {1914, 1915, 1916},
  {1914, 1916, 1913},
  {1914, 1913, 1906},
  {1917, 1915, 1908},
  {1917, 1908, 1918},
  {1917, 1918, 1916},
  {1917, 1916, 1915},
  {1919, 1662, 1669},
  {1919, 1669, 1920},
  {1919, 1920, 1908},
  {1919, 1908, 1662},
  {1921, 1669, 1494},
  {1921, 1494, 1674},
  {1921, 1674, 1920},
  {1921, 1920, 1669},
  {1922, 1908, 1923},
  {1922, 1923, 1924},
  {1922, 1924, 1918},
  {1922, 1918, 1908},
  {1925, 1923, 1920},
  {1925, 1920, 1926},
  {1925, 1926, 1924},
  {1925, 1924, 1923},
  {1927, 1920, 1928},
  {1927, 1928, 1929},
  {1927, 1929, 1926},
  {1927, 1926, 1920},
  {1930, 1928, 1674},
  {1930, 1674, 1680},
  {1930, 1680, 1929},
  {1930, 1929, 1928},
  {1931, 1856, 1911},
  {1931, 1911, 1932},
  {1931, 1932, 1888},
  {1931, 1888, 1856},
  {1933, 1911, 1913},
  {1933, 1913, 1934},
  {1933, 1934, 1932},
  {1933, 1932, 1911},
  {1935, 1913, 1916},
  {1935, 1916, 1936},
  {1935, 1936, 1934},
  {1935, 1934, 1913},
  {1937, 1916, 1918},
  {1937, 1918, 1938},
  {1937, 1938, 1936},
  {1937, 1936, 1916},
  {1939, 1888, 1932},
  {1939, 1932, 1940},
  {1939, 1940, 1900},
  {1939, 1900, 1888},
  {1941, 1932, 1934},
  {1941, 1934, 1942},
  {1941, 1942, 1940},
  {1941, 1940, 1932},
  {1943, 1900, 1940},
  {1943, 1940, 1944},
  {1943, 1944, 1904},
  {1943, 1904, 1900},
  {1945, 1940, 1942},
  {1945, 1942, 1946},
  {1945, 1946, 1944},
  {1945, 1944, 1940},
  {1947, 1934, 1936},
  {1947, 1936, 1948},
  {1947, 1948, 1942},
  {1947, 1942, 1934},
  {1949, 1936, 1938},
  {1949, 1938, 1950},
  {1949, 1950, 1948},
  {1949, 1948, 1936},
  {1951, 1942, 1948},
  {1951, 1948, 1952},
  {1951, 1952, 1946},
  {1951, 1946, 1942},
  {1953, 1948, 1950},
  {1953, 1950, 1954},
  {1953, 1954, 1952},
  {1953, 1952, 1948},
  {1955, 1918, 1924},
  {1955, 1924, 1956},
  {1955, 1956, 1938},
  {1955, 1938, 1918},
  {1957, 1924, 1926},
  {1957, 1926, 1958},
  {1957, 1958, 1956},
  {1957, 1956, 1924},
  {1959, 1926, 1929},
  {1959, 1929, 1960},
  {1959, 1960, 1958},
  {1959, 1958, 1926},
  {1961, 1929, 1680},
  {1961, 1680, 1704},
  {1961, 1704, 1960},
  {1961, 1960, 1929},
  {1962, 1938, 1956},
  {1962, 1956, 1963},
  {1962, 1963, 1950},
  {1962, 1950, 1938},
  {1964, 1956, 1958},
  {1964, 1958, 1965},
  {1964, 1965, 1963},
  {1964, 1963, 1956},
  {1966, 1950, 1963},
  {1966, 1963, 1967},
  {1966, 1967, 1954},
  {1966, 1954, 1950},
  {1968, 1963, 1965},
  {1968, 1965, 1969},
  {1968, 1969, 1967},
  {1968, 1967, 1963},
  {1970, 1958, 1960},
  {1970, 1960, 1971},
  {1970, 1971, 1965},
  {1970, 1965, 1958},
  {1972, 1960, 1704},
  {1972, 1704, 1713},
  {1972, 1713, 1971},
  {1972, 1971, 1960},
  {1973, 1965, 1971},
  {1973, 1971, 1974},
  {1973, 1974, 1969},
  {1973, 1969, 1965},
  {1975, 1971, 1713},
  {1975, 1713, 1718},
  {1975, 1718, 1974},
  {1975, 1974, 1971},
};

SVV_NAMESPACE_BEGIN

svvModel teapot( "teapot",
                 teapot_vertices, teapot_nvertices,
                 teapot_indices, teapot_nindices );

SVV_NAMESPACE_END

#endif /* SVV_TEAPOT_H_ */
/*
 * End of: $Id: teapot.h,v 1.1.1.1 2006/12/19 22:59:31 christianh Exp $.
 * 
 */
