/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svHashMapExt.H,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SV_HASH_MAP_EXT_H_
#  define SV_HASH_MAP_EXT_H_

/* The extensions are no longer in the global or std  namespaces,
 * instead they are declared in the __gnu_cxx  namespace. For maximum
 * portability, a namespace alias is defined to use to talk about
 * extensions, e.g.:
 */
#  ifdef __GNUC__
#    if __GNUC__ < 3
#      include <hash_map.h>
namespace Sgi { using ::hash_map; }; // inherit globals
#    else
#      include <ext/hash_map>
#      if __GNUC_MINOR__ == 0
namespace Sgi = std;               // GCC 3.0
#      else
namespace Sgi = ::__gnu_cxx;       // GCC 3.1 and later
#      endif
#    endif
#  else      // ...  there are other compilers, right?
namespace Sgi = std;
#  endif

#endif /* SV_HASH_MAP_EXT_H_ */
/* 
 * End of: $Id: svHashMapExt.H,v 1.1.1.1 2006/12/19 22:58:33 christianh Exp $.
 * 
 */
