/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvConsts.h,v 1.1.1.1 2006/12/19 22:58:34 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_CONSTS_H_
#  define SVV_CONSTS_H_
#  include "svvTypes.h"

#  define SVV_ZERO              ((SvvFloat64) 0.0)
#  define SVV_HALF              ((SvvFloat64) 0.5)
#  define SVV_ONE               ((SvvFloat64) 1.0)
#  define SVV_MINUSONE          ((SvvFloat64) -1.0)
#  define SVV_TWO               ((SvvFloat64) 2.0)
#  define SVV_VAL255            ((SvvFloat64) 255.0)
#  define SVV_ONEOVER255        ((SvvFloat64) (SVV_ONE / SVV_VAL255))
#  define SVV_VAL65535          ((SvvFloat64) 65535.0)
#  define SVV_ONEOVER65535      ((SvvFloat64) (SVV_ONE / SVV_VAL65535))
#  define SVV_VAL4294965000     ((SvvFloat64) 4294965000.0)
#  define SVV_ONEOVER4294965000 ((SvvFloat64) (SVV_ONE / SVV_VAL4294965000))
#  define SVV_PI                ((SvvFloat64) 3.14159265358979323846)
#  define SVV_DEGTORAD          ((SvvFloat64) (SVV_PI / (SvvFloat64) 180.0))
#  define SVV_RADTODEG          ((SvvFloat64) (SVV_ONE / SVV_DEGTORAD))
#  define SVV_SQRT2             ((SvvFloat64) 1.41421356237309504880)
#  define SVV_E                 ((SvvFloat64) 2.7182818284590452354)

SVV_NAMESPACE_BEGIN

static const SvvFloat64 Zero                    = SVV_ZERO;
static const SvvFloat64 Half                    = SVV_HALF;
static const SvvFloat64 One                     = SVV_ONE;
static const SvvFloat64 MinusOne                = SVV_MINUSONE;
static const SvvFloat64 Two                     = SVV_TWO;
static const SvvFloat64 Val255                  = SVV_VAL255;
static const SvvFloat64 OneOver255              = SVV_ONEOVER255;
static const SvvFloat64 Val65535                = SVV_VAL65535;
static const SvvFloat64 OneOver65535            = SVV_ONEOVER65535;

/*
 * Not quite 2^31-1 because of possible floating point errors.
 * 4294965000 is a much safer number to use.
 */
static const SvvFloat64 Val4294965000           = SVV_VAL4294965000;
static const SvvFloat64 OneOver4294965000       = SVV_ONEOVER4294965000;

/* Transcendentals. */
static const SvvFloat64 Pi                      = SVV_PI;
static const SvvFloat64 DegToRad                = SVV_DEGTORAD;
static const SvvFloat64 RadToDeg                = SVV_RADTODEG;
static const SvvFloat64 Sqrt2                   = SVV_SQRT2;
static const SvvFloat64 E                       = SVV_E;

/** Color / Material defaults. */
static const float      DefaultAmbient[4]       = { 0.2f, 0.2f, 0.2f, 1.0f };
static const float      DefaultDiffuse[4]       = { 0.8f, 0.8f, 0.8f, 1.0f };
static const float      DefaultSpecular[4]      = { 0.0f, 0.0f, 0.0f, 1.0f };
static const float      DefaultEmissive[4]      = { 0.0f, 0.0f, 0.0f, 1.0f };
static const float      DefaultShininess        = 1.0F; /*OpenGL default is 0*/
static const float      Black[4]                = { 0.0f, 0.0f, 0.0f, 1.0f };
static const float      White[4]                = { 1.0f, 1.0f, 1.0f, 1.0f };

SVV_NAMESPACE_END

#endif /* SVV_CONSTS_H_ */
/* 
 * End of: $Id: svvConsts.h,v 1.1.1.1 2006/12/19 22:58:34 christianh Exp $.
 * 
 */
