/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvMacros.h,v 1.1.1.1 2006/12/19 22:58:35 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MACROS_H_
#  define SVV_MACROS_H_
#  include "svvTypes.h" /* includes svvConfiguration */


/** Attempt at "safe" strdup() function wrapper with C++ operator new. */
#  define SVV_STRDUP(_a)                                                \
                                strcpy(new char [strlen(_a) + 1], _a)

/** Attempt at "safe" strcpy() function wrapper for array destinations. */
#  define SVV_ASTRCPY(_dst, _src)                                       \
                                SVV_BEGIN_MACRO                         \
                                strncpy(_dst, _src, (sizeof _dst) - 1); \
                                _dst[(sizeof _dst) - 1] = '\0';         \
                                SVV_END_MACRO

/** Attempt at "safe" strcat() function wrapper for array destinations. */
#  define SVV_ASTRCAT(_dst, _src)                                       \
                                strncat(_dst, _src, (sizeof _dst) - 1);

/*
 * This macro is used for  debug statements in instance methods
 * svvDebugMacro(<< "this is debug info" << this->SomeVariable);
 */
#  ifdef SVV_LEAN_AND_MEAN
#    define svvDebugMacro(_x)
#  else
#    define svvDebugMacro(_x) \
	{ if (this->Debug) \
	    { char*      _msgbuff; \
	      ostrstream _msg; \
	      _msg << "Debug: In " __FILE__ ", line " << __LINE__ << "\n" \
	             << this->GetClassName() << " (" << this << "): " _x  \
	             << "\n\n" << ends; \
	      _msgbuff = _msg.str(); \
	      Svv::WriteDebugText(_msgbuff);\
	      _msg.rdbuf()->freeze(0);}}
#  endif /* SVV_LEAN_AND_MEAN */

/* 
 * Set/Get built-in type.  Creates members Set"name"() (e.g., SetVisibility())
 *   and Get"name"() (e.g., GetVisibility()).
 */
#  define svvSetGetMacro(_name,_type) \
	virtual void Set##_name (_type _arg) { \
	  if (this->_name != _arg) { \
	    this->_name = _arg; \
	  } \
	} \
	virtual _type Get##_name () const { \
	  return this->_name; \
	}

/*
 * Set/Get built-in type where value is constrained between min/max limits.
 * Create members Set"name"() (eg., SetRadius()) and Get"name"() 
 * (eg., GetRadius()). #defines are convenience for clamping open-ended values.
 * The Get"name"MinValue() and Get"name"MaxValue() members return the
 * min and max limits.
 */
#define svvSetGetClampMacro(_name,_type,_min,_max) \
	virtual void Set##_name (_type _arg) { \
	  if (this->_name != SVV_CLAMP(_arg,_min,_max)) { \
	    this->_name = SVV_CLAMP(_arg,_min,_max); \
	  } \
	} \
	virtual _type Get##_name##MinValue () { \
	  return _min; \
	} \
	virtual _type Get##_name##MaxValue () { \
	  return _max; \
	} \
	virtual _type Get##_name () const { \
	  return this->_name; \
	}

/* 
 * Set/Get built-in type representing a Boolean.  Creates members Set"name"() 
 * (e.g., SetVisibility()) and Get"name"() (e.g., GetVisibility()).
 * Additionally create members "name"On() and "name"Off() (e.g., DebugOn() 
 * DebugOff()).
 */
#  define svvSetGetBooleanMacro(_name,_type) \
	virtual void Set##_name (_type _arg) { \
	  if (this->_name != _arg) { \
	    this->_name = _arg; \
	  } \
	} \
	virtual _type Get##_name () const { \
	  return this->_name; \
	} \
	virtual void _name##On () { this->Set##_name((_type)1);}; \
	virtual void _name##Off () { this->Set##_name((_type)0);}


/* 
 * Following set macros for vectors define two members for each macro.  The first 
 * allows setting of individual components (e.g, SetColor(float,float,float)), 
 * the second allows setting from an array (e.g., SetColor(float* rgb[3])).
 * The macros vary in the size of the vector they deal with.
 */
#  define svvSetGetVec2Macro(_name,_type) \
	virtual void Set##_name (_type _a1, _type _a2) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)) { \
	    this->_name[0] = _a1; \
	    this->_name[1] = _a2; \
	  } \
	}; \
	void Set##_name (_type _arg[2]) { \
	  this->Set##_name (_arg[0], _arg[1]); \
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	}; \
	virtual void Get##_name (_type _arg[2]) { \
	  this->Get##_name (_arg[0], _arg[1]);\
	} 

#  define svvSetGetVec2ClampMacro(_name,_type,_min,_max) \
	virtual void Set##_name (_type _a1, _type _a2) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)) { \
	    if (this->_name[0] != SVV_CLAMP(_a1,_min,_max)) { \
	      this->_name[0] = SVV_CLAMP(_a1,_min,_max); \
	    } \
	    if (this->_name[1] != SVV_CLAMP(_a2,_min,_max)) { \
	      this->_name[1] = SVV_CLAMP(_a2,_min,_max); \
	    } \
	  } \
	}; \
	void Set##_name (_type _arg[2]) { \
	  this->Set##_name (_arg[0], _arg[1]); \
	} \
	virtual _type Get##_name##MinValue () { \
	  return _min; \
	} \
	virtual _type Get##_name##MaxValue () { \
	  return _max; \
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	}; \
	virtual void Get##_name (_type _arg[2]) { \
	  this->Get##_name (_arg[0], _arg[1]);\
	} 

#  define svvSetGetVec3Macro(_name,_type) \
	virtual void Set##_name (_type _a1, _type _a2, _type _a3) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)||(this->_name[2] != _a3)) { \
	    this->_name[0] = _a1; \
	    this->_name[1] = _a2; \
	    this->_name[2] = _a3; \
	  } \
	}; \
	virtual void Set##_name (_type _arg[3]) { \
	  this->Set##_name (_arg[0], _arg[1], _arg[2]);\
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2, _type &_a3) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	  _a3 = this->_name[2]; \
	}; \
	virtual void Get##_name (_type _arg[3]) { \
	  this->Get##_name (_arg[0], _arg[1], _arg[2]);\
	} 

#  define svvSetGetVec3ClampMacro(_name,_type,_min,_max) \
	virtual void Set##_name (_type _a1, _type _a2, _type _a3) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)||(this->_name[2] != _a3)) { \
	    if (this->_name[0] != SVV_CLAMP(_a1,_min,_max)) { \
	      this->_name[0] = SVV_CLAMP(_a1,_min,_max); \
	    } \
	    if (this->_name[1] != SVV_CLAMP(_a2,_min,_max)) { \
	      this->_name[1] = SVV_CLAMP(_a2,_min,_max); \
	    } \
	    if (this->_name[2] != SVV_CLAMP(_a3,_min,_max)) { \
	      this->_name[2] = SVV_CLAMP(_a3,_min,_max); \
	    } \
	  } \
	}; \
	virtual void Set##_name (_type _arg[3]) { \
	  this->Set##_name (_arg[0], _arg[1], _arg[2]);\
	} \
	virtual _type Get##_name##MinValue () { \
	  return _min; \
	} \
	virtual _type Get##_name##MaxValue () { \
	  return _max; \
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2, _type &_a3) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	  _a3 = this->_name[2]; \
	}; \
	virtual void Get##_name (_type _arg[3]) { \
	  this->Get##_name (_arg[0], _arg[1], _arg[2]);\
	} 

#  define svvSetGetVec4Macro(_name,_type) \
	virtual void Set##_name (_type _a1, _type _a2, _type _a3, _type _a4) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)||(this->_name[2] != _a3)||(this->_name[3] != _a4)) { \
	    this->_name[0] = _a1; \
	    this->_name[1] = _a2; \
	    this->_name[2] = _a3; \
	    this->_name[3] = _a4; \
	  } \
	}; \
	virtual void Set##_name (_type _arg[4]) { \
	  this->Set##_name (_arg[0], _arg[1], _arg[2], _arg[3]);\
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2, _type &_a3, _type &_a4) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	  _a3 = this->_name[2]; \
	  _a4 = this->_name[3]; \
	}; \
	virtual void Get##_name (_type _arg[4]) { \
	  this->Get##_name (_arg[0], _arg[1], _arg[2], _arg[3]);\
	} 

#  define svvSetGetVec4ClampMacro(_name,_type,_min,_max) \
	virtual void Set##_name (_type _a1, _type _a2, _type _a3, _type _a4) { \
	  if ((this->_name[0] != _a1)||(this->_name[1] != _a2)||(this->_name[2] != _a3)||(this->_name[3] != _a4)) { \
	    if (this->_name[0] != SVV_CLAMP(_a1,_min,_max)) { \
	      this->_name[0] = SVV_CLAMP(_a1,_min,_max); \
	    } \
	    if (this->_name[1] != SVV_CLAMP(_a2,_min,_max)) { \
	      this->_name[1] = SVV_CLAMP(_a2,_min,_max); \
	    } \
	    if (this->_name[2] != SVV_CLAMP(_a3,_min,_max)) { \
	      this->_name[2] = SVV_CLAMP(_a3,_min,_max); \
	    } \
	    if (this->_name[3] != SVV_CLAMP(_a4,_min,_max)) { \
	      this->_name[3] = SVV_CLAMP(_a4,_min,_max); \
	    } \
	  } \
	}; \
	virtual void Set##_name (_type _arg[4]) { \
	  this->Set##_name (_arg[0], _arg[1], _arg[2], _arg[3]);\
	} \
	virtual _type Get##_name##MinValue () { \
	  return _min; \
	} \
	virtual _type Get##_name##MaxValue () { \
	  return _max; \
	} \
	virtual _type *Get##_name () { \
	  return this->_name; \
	} \
	virtual void Get##_name (_type &_a1, _type &_a2, _type &_a3, _type &_a4) { \
	  _a1 = this->_name[0]; \
	  _a2 = this->_name[1]; \
	  _a3 = this->_name[2]; \
	  _a4 = this->_name[3]; \
	}; \
	virtual void Get##_name (_type _arg[4]) { \
	  this->Get##_name (_arg[0], _arg[1], _arg[2], _arg[3]);\
	} 

#endif /* SVV_MACROS_H_ */
/* 
 * End of: $Id: svvMacros.h,v 1.1.1.1 2006/12/19 22:58:35 christianh Exp $.
 * 
 */
