/* 
 * $Id: Annotation.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $
 * 
 */
#include <cstdio> /* snprintf() */
// VTK Common
#include "vtkProperty2D.h"
#include "vtkPolyData.h"
// VTK Rendering
#include "vtkCamera.h"
#include "vtkProperty.h"
#include "vtkActor.h"
#include "vtkTextActor.h"
#include "vtkPolyDataMapper.h"
// VTK Graphics
#include "vtkConeSource.h"
#include "vtkTriangleFilter.h"
#include "vtkCleanPolyData.h"
#include "vtkMassProperties.h"
// VTK Hybrid
#include "vtkCaptionActor2D.h"

#if VTK_MAJOR_VERSION>4 || (VTK_MAJOR_VERSION==4 && VTK_MINOR_VERSION>0)
// VTK Rendering
#  include "vtkTextProperty.h"
// VTK Hybrid
#  include "vtkSphereWidget.h"
#else
// VTK Rendering
#  include "vtkScaledTextActor.h"
#endif /* VTK Version >= 4.1 */


// ----------------------------------------------------------------------------
static vtkActor2D*
make_caption_2D (const char* str, vtkActor* actor)
{
  static float s_width = 0.18, s_height = 0.05;
  static float s_xpos = 0.0, s_ypos = 0.95;

  vtkCaptionActor2D* caption; // Hybrid
  vtkConeSource*     coneGlyph;

  caption   = vtkCaptionActor2D::New();
  coneGlyph = vtkConeSource::New();

  coneGlyph->SetResolution(12);

  float bounds[6], center[3];
  actor->GetBounds(bounds);

  caption->SetCaption(str);
  caption->GetProperty()->SetColor(actor->GetProperty()->GetColor());
  caption->SetAttachmentPoint(center[0], bounds[3], center[2] );
  caption->GetPositionCoordinate()->SetCoordinateSystemToNormalizedViewport();
  // If this coordinate is relative to another coordinate, then specify 
  // that coordinate as the ReferenceCoordinate. If this is NULL the 
  // coordinate is assumed to be absolute.
  caption->GetPositionCoordinate()->SetReferenceCoordinate(0);
  caption->GetPositionCoordinate()->SetValue(s_xpos, s_ypos); // top left
  caption->SetWidth(s_width);
  caption->SetHeight(s_height);
    {
    s_ypos -= s_height;
    if (s_ypos < 0)
      {
      s_ypos = 1.0 - s_height;
      s_xpos += s_width;
      }
    }
  caption->SetBorder(0);
  caption->SetThreeDimensionalLeader(1);
#if 0
  caption->SetPosition(25, 10);
#endif
  caption->SetLeaderGlyph(coneGlyph->GetOutput());
  //caption->SetMaximumLeaderGlyphSize(10);
  caption->SetLeaderGlyphSize(s_height/3.0);

#if VTK_MAJOR_VERSION>4 || (VTK_MAJOR_VERSION==4 && VTK_MINOR_VERSION>0)
  caption->GetCaptionTextProperty()->
    SetColor(caption->GetProperty()->GetColor());
  caption->GetCaptionTextProperty()->AntiAliasingOn();
  // VTK_ARIAL, VTK_COURIER, VTK_TIMES
  caption->GetCaptionTextProperty()->SetFontFamily(VTK_ARIAL);
  caption->GetCaptionTextProperty()->SetShadow(1);
  // VTK_TEXT_{LEFT|RIGHT|CENTERED}
  caption->GetCaptionTextProperty()->SetJustification(VTK_TEXT_LEFT);
#else
  // VTK_ARIAL, VTK_COURIER, VTK_TIMES
  caption->SetFontFamily(VTK_ARIAL);
  caption->SetShadow(1);
  // VTK_TEXT_{LEFT|RIGHT|CENTERED}
  caption->SetJustification(VTK_TEXT_LEFT);
#endif /* VTK Version >= 4.1 */

  return caption;
}

// ----------------------------------------------------------------------------
vtkProp*
MakeVolumetricText (vtkActor* actor, vtkCamera* camera)
{
  bool valid = true;
  float bounds[6];

  vtkPolyDataMapper* inputMapper;
  if ((inputMapper = vtkPolyDataMapper::SafeDownCast(actor->GetMapper()))==NULL)
    {
    cerr << "ERROR: actor does not possess a PolyData Mapper!\n";
    return 0;
    }

  inputMapper->Update();
  inputMapper->GetBounds(bounds);
  
  vtkMassProperties* massProperties = vtkMassProperties::New();
    {
    vtkTriangleFilter* triangles = vtkTriangleFilter::New();
      {
      vtkCleanPolyData* cleaner = vtkCleanPolyData::New();
        {
        cleaner->SetInput(inputMapper->GetInput());
        cleaner->ConvertLinesToPointsOn();
        cleaner->ConvertPolysToLinesOn();
        cleaner->ConvertStripsToPolysOn();
        cleaner->PointMergingOn();
        cleaner->Update();
        }
      triangles->SetInput(cleaner->GetOutput());
      triangles->PassVertsOff();
      triangles->PassLinesOff();
      triangles->Update();
      cleaner->Delete();
      }
    vtkPolyData* input = triangles->GetOutput();
    if (input->GetNumberOfCells()<1 || input->GetNumberOfPoints()<1)
      {
      valid = false;
      }
    else
      {
      massProperties->SetInput(triangles->GetOutput());
      massProperties->Update();
      }
    triangles->Delete();
    }

  char buf[32];

  if (valid)
    {
    (void) snprintf( buf, sizeof buf, "Volume = %f\n",
                     massProperties->GetVolume() );

    std::cerr << "Mass Properties:\n" << buf << std::endl;
    }

  massProperties->Delete();

  return (valid ? make_caption_2D(buf, actor) : NULL);
}

#if VTK_MAJOR_VERSION>4 || (VTK_MAJOR_VERSION==4 && VTK_MINOR_VERSION>0)
vtkActor2D*
MakeTextActor2D (const char* str, int x=12, int y=12, vtkTextProperty* tprop=0)
{
  vtkTextActor* text; // from Rendering

  text = vtkTextActor::New();

  text->ScaledTextOn();
  text->SetDisplayPosition(x,y);
  text->SetInput(str);

  // Set coordinates to match the old vtkScaledTextActor default value
  text->GetPosition2Coordinate()->SetCoordinateSystemToNormalizedViewport();
  text->GetPosition2Coordinate()->SetValue(0.6, 0.1);

  if (tprop)
    {
    text->SetTextProperty(tprop);
    }
  else
    {
    tprop = text->GetTextProperty();
    tprop->SetFontSize(18);
    //tprop->SetFontFamilyToArial();
    //tprop->SetFontFamilyToCourier();
    //tprop->SetFontFamilyToTimes();
    tprop->SetJustificationToCentered();
    tprop->BoldOn();
    tprop->ItalicOn();
    tprop->ShadowOn();
    tprop->AntiAliasingOn();
    tprop->SetColor(1.f, 1.f, 0.9f);
    }

  return text;
}
#endif /* VTK Version >= 4.1 */

/* 
 * End of: $Id: Annotation.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $.
 * 
 */
