/* 
 * $Id: Pipeline.H,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $
 * 
 */
#ifndef _PIPELINE_H_
#  define _PIPELINE_H_

// VTK Common
#include "vtkImplicitFunction.h"
#include "vtkSource.h"
// VTK Filtering
#include "vtkPolyDataSource.h"
// VTK Graphics
#include "vtkTransformTextureCoords.h"
// VTK Rendering
#include "vtkActor.h"


vtkPolyDataSource* MakeHullSource(vtkSource*, int = 4);
vtkPolyDataSource* MakeFeatureEdgesSource(vtkSource*);
vtkPolyDataSource* MakeMaceSource(void);

// The source returned is a vtkTransformTextureCoords which may be
// cast for use. Returning the ancestor avoids the additional dependency.
vtkTransformTextureCoords* InsertTextureMapToPlane(vtkActor*);
vtkTransformTextureCoords* InsertTextureMapToSphere(vtkActor*, bool = true);
vtkTransformTextureCoords* InsertTextureMapToCylinder(vtkActor*, bool = true);
vtkTransformTextureCoords* InsertTextureMapToImplicit(vtkActor*,
                                                      vtkImplicitFunction*,
                                                      vtkImplicitFunction*,
                                                      vtkImplicitFunction*);

void InsertNormals(vtkActor*);
void InsertDecimation(vtkActor*, float = 0.9);

void InsertLoopSubdivision(vtkActor*, int = 1);
void InsertButterflySubdivision(vtkActor*, int = 1);
void InsertLinearSubdivision(vtkActor*, int = 1);

#endif /* _PIPELINE_H_ */
/* 
 * End of: $Id: Pipeline.H,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $.
 * 
 */
