/* 
 * $Id: svSurfaceDataFiltersUICb.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $
 * 
 */ 

#include "svSurfaceDataFiltersUI.H"
#include "svSurfaceDataFilterUI.H"

#include "svController.H"

// 
// Hide() / Show()
// 

void
svSurfaceDataFiltersUI::Show(void)
{
  this->mainWindow->show(Sv::argc(),Sv::argv());
}

void
svSurfaceDataFiltersUI::Hide(void)
{
  this->mainWindow->hide();
}

int
svSurfaceDataFiltersUI::Shown(void)
{
  return this->mainWindow->shown();
}


static void
TriangleFilterButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svTriangleFilterUI* filterUI = new svTriangleFilterUI(X,Y,W,H,"Triangle Filter");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
CleanPolyDataButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svCleanPolyDataUI* filterUI = new svCleanPolyDataUI(X,Y,W,H,"Clean PolyData");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
WindowedSincButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svWindowedSincUI* filterUI = new svWindowedSincUI(X,Y,W,H,"Windowed Sinc");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
DecimateButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svDecimateUI* filterUI = new svDecimateUI(X,Y,W,H,"Decimation");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
FeatureEdgesButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svFeatureEdgesUI* filterUI = new svFeatureEdgesUI(X,Y,W,H,"Feature Edges");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
HullButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svHullUI* filterUI = new svHullUI(X,Y,W,H,"Convex Hull");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}

static void
DepthSortButtonCb(Fl_Widget* w, void* v)
{
#if 0
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svDepthSortUI* filterUI = new svDepthSortUI(X,Y,W,H,"Depth Sort");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
#endif /* 0 */
}

static void
NormalsButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  int X = p->FilterTabs->x() + 2;
  int Y = p->FilterTabs->y() + 26;
  int W = p->FilterTabs->w() - 4;
  int H = p->FilterTabs->h() - 28;

  svNormalsUI* filterUI = new svNormalsUI(X,Y,W,H,"Normals");
  // push the polydata filter pointer ivar onto the back of the list
  p->AddItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->add_resizable(*filterUI);
  p->FilterTabs->redraw();
}


// ----------------------------------------------------------------------------
static void
RemoveButtonCb(Fl_Widget* w, void* v)
{
  svSurfaceDataFiltersUI* p = reinterpret_cast<svSurfaceDataFiltersUI*>(v);
  if(!p) return;
  
  Fl_Widget*          widget   = p->FilterTabs->value();
  Fl_Group*           group    = reinterpret_cast<Fl_Group*>(widget);
  svSurfaceDataFilterUI* filterUI = reinterpret_cast<svSurfaceDataFilterUI*>(group);

  // remove the polydata filter pointer ivar from the list
  p->RemoveItem(filterUI->GetFilter());
  // now add the filter GUI
  p->FilterTabs->remove(*widget);
  (p->FilterTabs->parent())->redraw();
  delete filterUI;
}


// ----------------------------------------------------------------------------
void
svSurfaceDataFiltersUI::Init(void)
{
  this->TriangleFilterButton->callback(TriangleFilterButtonCb,this);
  this->CleanPolyDataButton->callback(CleanPolyDataButtonCb,this);
  this->WindowedSincButton->callback(WindowedSincButtonCb,this);
  this->DecimateButton->callback(DecimateButtonCb,this);
  this->FeatureEdgesButton->callback(FeatureEdgesButtonCb,this);
  this->HullButton->callback(HullButtonCb,this);
  this->DepthSortButton->callback(DepthSortButtonCb,this);
  this->NormalsButton->callback(NormalsButtonCb,this);
  this->RemoveButton->callback(RemoveButtonCb,this);
}

/* 
 * End of $Id: svSurfaceDataFiltersUICb.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $.
 */ 
